/****************************************
*********** Author: Burryaga ************
*****************************************/

/*
 * For Use in Mod Builder Version 2.1.2
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;

using nms			= libMBIN.NMS;
using globals		= libMBIN.NMS.Globals;
using components	= libMBIN.NMS.GameComponents;
using toolkit		= libMBIN.NMS.Toolkit;

namespace cmk.NMS.Scripts.Mod
{
	using CreatureRoleEnum      = components.GcCreatureRoles.CreatureRoleEnum;
	using CreatureSizeClassEnum = components.GcCreatureSizeClasses.CreatureSizeClassEnum;
	using DensityEnum           = components.GcCreatureGenerationDensity.DensityEnum;

	public class More_Animals : cmk.NMS.ModScript
	{
		// If the forests are too much for you, set this to false.
		protected bool IAmTheLorax = false;
		
		protected override void Execute()
		{
			IncreaseMaxFauna();
			IncreaseGroupSizes();
		}
		
		protected void IncreaseMaxFauna() 
		{
			var creature = Mbin<globals.GcCreatureGlobals>(
				"GCCREATUREGLOBALS.MBIN"
			);
			
			if (IAmTheLorax) 
			{
				creature.MaxEcosystemCreaturesLow += 10;
				creature.MaxEcosystemCreaturesNormal += 20;
			}
			else 
			{
				creature.MaxEcosystemCreaturesLow += 5;
				creature.MaxEcosystemCreaturesNormal += 10;
			}
		}
		
		protected void IncreaseGroupSizes() 
		{
            var pathsToGcCreatureRoleDescriptionTables = GetPathsFor("GcCreatureRoleDescriptionTable");

			foreach( var path in pathsToGcCreatureRoleDescriptionTables ) {

            	var mbin = Mbin<components.GcCreatureRoleDescriptionTable>(path);

				if( mbin.RoleDescription.IsNullOrEmpty() ) continue;

				var MinGroupSizeIncrease = 1;
				var MaxGroupSizeIncrease = 1;
				var Density = DensityEnum.Dense;
				
				if( mbin.RoleDescription[0].RequireTag == "HERD" ) {
					switch( mbin.RoleDescription[0].MinSize.CreatureSizeClass ) {
						case CreatureSizeClassEnum.Medium:
							MaxGroupSizeIncrease = 4;
							break;
						default:
							continue;
					}
				}
				else {
					switch( mbin.RoleDescription[0].Role.CreatureRole ) {
						case CreatureRoleEnum.Predator:
							MaxGroupSizeIncrease = 2;
							break;
						case CreatureRoleEnum.FishPredator:
							MaxGroupSizeIncrease = 2;
							break;
						case CreatureRoleEnum.PlayerPredator:
							MaxGroupSizeIncrease = 2;
							break;
						case CreatureRoleEnum.Robot:
							MaxGroupSizeIncrease = 3;
							break;
						default:  // prey
							MaxGroupSizeIncrease = 3;
							break;
					}
				}

				foreach(var role in mbin.RoleDescription) {
					role.MinGroupSize   += MinGroupSizeIncrease;
					role.MaxGroupSize   += MaxGroupSizeIncrease;
					if (role.Density.Density < DensityEnum.Dense) {
						role.Density.Density = Density;
					}
				}
			}
		}
		
		protected List<string> GetPathsFor(string GcObjectType) {
			
			return Game.Mbinc.Classes.Find(
                (targetClassInfo) => targetClassInfo.Type.Name.Equals(GcObjectType)
            ).PakItems;
			
		}
	}
}