#pragma once

#define NOMINMAX
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#include <psapi.h>

#include <cstdint>
#include <string>
#include <vector>
#include <algorithm>
#include <cwctype>
#include <filesystem>

#define EXPORT extern "C" __declspec(dllexport)

// util.cpp
void* ModuleDirectoryEntryData(void* Module, int DirectoryEntry, int* EntrySize = nullptr);
bool FileExists(std::filesystem::path File);

FARPROC* GetIATPointer(void* Module, const char* LibraryName, const char* ImportName);
FARPROC* GetExpPointer(void* Module, const char* ProcName);
void RedirectProcAddress(const char* ModuleName, const char* ProcName, FARPROC NewProc, FARPROC* OldProc);

void dlog(const char* Format, ...);

// proxy.cpp
bool Proxy_Attach(HMODULE dllModule);

template <class T>
static void SafeWrite(T* Addr, T Value)
{
	MEMORY_BASIC_INFORMATION addrMemInfo;
	VirtualQuery(Addr, &addrMemInfo, sizeof(MEMORY_BASIC_INFORMATION));
	if (!VirtualProtect(addrMemInfo.BaseAddress, addrMemInfo.RegionSize, PAGE_EXECUTE_READWRITE, &addrMemInfo.Protect))
		return;

	*Addr = Value;

	DWORD junk;
	VirtualProtect(addrMemInfo.BaseAddress, addrMemInfo.RegionSize, addrMemInfo.Protect, &junk);
}