------------------------------------------------------------------------------
-- Global overrides
------------------------------------------------------------------------------

DisableExpeditionRewards = false	-- | default: false | If true, does not put expedition rewards in the shop (you might want to change the StoreAvailability variables below)
DisableTwitchRewards = false		-- | default: false | If true, does not put Twitch drops in the shop (you might want to change the StoreAvailability variables below)

ConsumablesOnly = false				-- | default: false | If true, only items marked as consumable will be added

DefaultPrices = false				-- | default: false | If true, does not change any prices from the default (most things cost 3000). If used with AllPricesFree, DefaultPrices takes precedence

------------------------------------------------------------------------------
-- (￣￣▽￣￣) <- Cheaty McCheatface
------------------------------------------------------------------------------

NoTierRequirementForAll = false	    -- | default: false | If true, removes the tier requirements from mod items (does not affect vanilla items)
NoTimeRestriction = false			-- | default: false | If true, makes every modded item available every week (does not affect vanilla items)

NoRequirements = true				-- | default: false | If true, removes all requirements from all mod items (does not affect vanilla items)

AllPricesFree = true				-- | default: false | If true, makes all mod items prices 0 (does not affect vanilla items). If used with DefaultPrices, DefaultPrices takes precedence

------------------------------------------------------------------------------
-- Prices
------------------------------------------------------------------------------

PriceConsumable = 200				-- | default (expensive): 200  | default (cheap): 60   | 
PriceVeryLow = 700					-- | default (expensive): 700  | default (cheap): 175  | 
PriceLow = 1450						-- | default (expensive): 1450 | default (cheap): 400  |
PriceMedium = 3500					-- | default (expensive): 3500 | default (cheap): 1200 |
PriceHigh = 4450					-- | default (expensive): 4450 | default (cheap): 1450 |
PriceVeryHigh = 6200				-- | default (expensive): 6200 | default (cheap): 1800 |

------------------------------------------------------------------------------
-- Community reward tier requirements
------------------------------------------------------------------------------
-- If there's an E after the comment, it's currently empty. If there's a C, there are commented items inside. Feel free to uncomment or populate it with whatever you want to pay QS for.
-- Possible values:
--   -1 -> No requirement
--   0 -> Item Disabled (?)
--   1,2,3,4 -> Tier requirement 1,2,3,4
------------------------------------------------------------------------------

TierRequirementEx1Ph1 = 1      -- | mod default: 1 |   | C |
TierRequirementEx1Ph2 = 1      -- | mod default: 1 |   |   |
TierRequirementEx1Ph3 = 2      -- | mod default: 2 |   |   |
TierRequirementEx1Ph4 = 2      -- | mod default: 2 |   |   |
TierRequirementEx1Ph5 = 3      -- | mod default: 3 |   |   |
TierRequirementEx1Complete = 4 -- | mod default: 4 |   |   |

TierRequirementEx2Ph1 = 1      -- | mod default: 1 |   | C |
TierRequirementEx2Ph2 = 1      -- | mod default: 1 |   |   |
TierRequirementEx2Ph3 = 2      -- | mod default: 2 | E |   |
TierRequirementEx2Ph4 = 2      -- | mod default: 2 | E |   |
TierRequirementEx2Ph5 = 3      -- | mod default: 3 |   |   |
TierRequirementEx2Complete = 4 -- | mod default: 4 |   |   |

TierRequirementEx3Ph1 = 1      -- | mod default: 1 |   |   |
TierRequirementEx3Ph2 = 1      -- | mod default: 1 |   |   |
TierRequirementEx3Ph3 = 2      -- | mod default: 2 |   |   |
TierRequirementEx3Ph4 = 2      -- | mod default: 2 |   |   |
TierRequirementEx3Ph5 = 3      -- | mod default: 3 |   |   |
TierRequirementEx3Complete = 4 -- | mod default: 4 |   |   |

TierRequirementTw1_15min = 1   -- | mod default: 1 | E | C |
TierRequirementTw1_30min = 1   -- | mod default: 1 | E |   |
TierRequirementTw1_1hr = 2     -- | mod default: 2 |   |   |
TierRequirementTw1_2hr = 3     -- | mod default: 3 | E |   |
TierRequirementTw1_3hr = 4     -- | mod default: 4 |   |   |

TierRequirementTw2_15min = 1   -- | mod default: 1 |   |   |
TierRequirementTw2_30min = 1   -- | mod default: 1 | E |   |
TierRequirementTw2_1hr = 2     -- | mod default: 2 | E |   |
TierRequirementTw2_2hr = 3     -- | mod default: 3 |   |   |
TierRequirementTw2_3hr = 4     -- | mod default: 4 |   |   |

------------------------------------------------------------------------------
-- Availabile weeks
-- Which weeks the rewards will show up in the store
------------------------------------------------------------------------------

--                       week1, week2, week3, week4
StoreAvailabilityEx1 = { true,  false, false, false } -- | mod default: true, false, false, false
StoreAvailabilityEx2 = { false, true,  false, false } -- | mod default: false, true,  false, false
StoreAvailabilityEx3 = { false, false, true,  false } -- | mod default: false, false, true,  false
StoreAvailabilityTw1 = { false, true,  false, false } -- | mod default: false, true,  false, false
StoreAvailabilityTw2 = { false, false, false, true  } -- | mod default: false, false, false, true

------------------------------------------------------------------------------
-- ID Tables for Unique Rewards
------------------------------------------------------------------------------

REWARD_TABLE =
{
	-- ID - Item ID | IsConsumable - can buy multiple | Tier - community tier requirement | Weeks - What weeks of the month the item is available | Price - if nil, vanilla default price (most are 3000). if integer, new price

	-- { ["ID"] = "TWITCH_FIREW01A", ["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually -- Fireworks Pack Day 1
	-- { ["ID"] = "TWITCH_FIREW01B", ["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually -- Fireworks Pack Day 2
	-- { ["ID"] = "TWITCH_FIREW01C", ["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually -- Fireworks Pack Day 3
	-- { ["ID"] = "TWITCH_FIREW01D", ["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually -- Fireworks Pack Day 4
	-- { ["ID"] = "TWITCH_FIREW01E", ["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually -- Fireworks Pack Day 5
	{ ["ID"] = "EXPD_FIREWORK01",	["Campaign"] = "Ex1",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceConsumable}, -- Blue-Red Atlas Firework (Expedition 1)
	{ ["ID"] = "EXPD_FIREWORK01",	["Campaign"] = "Ex2",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceConsumable}, -- Blue-Red Atlas Firework (Expedition 2)
	{ ["ID"] = "EXPD_FIREWORK02",	["Campaign"] = "Ex1",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceConsumable}, -- Gold-Blue Atlas Firework (Expedition 1)
	{ ["ID"] = "EXPD_FIREWORK02",	["Campaign"] = "Ex2",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceConsumable}, -- Gold-Blue Atlas Firework (Expedition 2)
	{ ["ID"] = "EXPD_FIREWORK03",	["Campaign"] = "Ex1",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceConsumable}, -- Red-Gold Atlas Firework (Expedition 1)
	{ ["ID"] = "EXPD_FIREWORK03",	["Campaign"] = "Ex2",	["IsConsumable"] = "True",	["Tier"] = -1,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceConsumable}, -- Red-Gold Atlas Firework (Expedition 2)
	-- { ["ID"] = "EXPD_FIREPACK01",	["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = -1,	["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually - Atlas Fireworks Pack (Expedition 1)
	-- { ["ID"] = "EXPD_FIREPACK01",	["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = -1,	["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceVeryLow}, -- DISABLED Can buy individually - Atlas Fireworks Pack (Expedition 2)
	
	{ ["ID"] = "EXPD_TITLE01", 		["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph5,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceMedium}, -- Title: 'Pioneer'
	{ ["ID"] = "EXPD_TITLE02A",		["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Complete,	["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceMedium}, -- Title: 'Renegade'
	{ ["ID"] = "EXPD_TITLE02B",		["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Complete,	["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceMedium}, -- Title: 'Paragon'
	{ ["ID"] = "EXPD_TITLE03",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph5,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Title: 'Globemaster'
	
	{ ["ID"] = "DECAL_HAZARD", 		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_15min,	["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceLow}, -- Hazard Decal
	{ ["ID"] = "EXPD_DECAL01", 		["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph5,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceLow}, -- Pioneers Expedition Decal
	{ ["ID"] = "EXPD_DECAL02",		["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Ph5,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceLow}, -- Beachhead Expedition Decal
	{ ["ID"] = "EXPD_DECAL03",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph5,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceLow}, -- Cartographers Expedition Decal
	
	{ ["ID"] = "EXPD_BANNER01", 	["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph2,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceMedium}, -- Pioneers Expedition Banner
	{ ["ID"] = "EXPD_BANNER02",		["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Ph5,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceMedium}, -- Beachhead Expedition Banner
	{ ["ID"] = "EXPD_BANNER03",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph5,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Cartographers Expedition Banner
	
	{ ["ID"] = "BLD_EXPD_BASE01", 	["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph5,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceMedium}, -- Pioneers Expedition Flag
	{ ["ID"] = "BLD_FLYJAR",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph3,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Bio-Lantern
	{ ["ID"] = "BLD_PLANET_HOLO",	["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph2,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Holographic Chart Projector
	{ ["ID"] = "BASE_CAVE1",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph4,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Saucer Fungus
	{ ["ID"] = "BASE_CAVE2",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph4,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Cave Creeper
	{ ["ID"] = "BASE_CAVE3",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph4,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Troglotulip
	{ ["ID"] = "BASE_CAVE4",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph4,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Veined Flat Caps
	{ ["ID"] = "BASE_CAVE5",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph4,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Fingery Deposit
	
	{ ["ID"] = "EXPD_BACKPACK01", 	["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph4,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceHigh}, -- Streamlined Jetpack Unit
	{ ["ID"] = "JETS_BUBBLE",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Ph1,		["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceMedium}, -- Jetpack Bubble Trail
	{ ["ID"] = "EXPD_HELMET01", 	["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Ph3,		["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceHigh}, -- Golden First Spawn Battle Mask
	
	-- { ["ID"] = "MYSTERY_TRACKER",	["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Complete,	["Weeks"] = StoreAvailabilityEx2,	["Price"] = nil}, -- DISABLED No longer needed -- Historiographical Dosimeter
	{ ["ID"] = "EXPD_SPEC02",		["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Complete,	["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceVeryHigh}, -- SSV Normandy
	
	{ ["ID"] = "TWITCH_PET01",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_2hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceHigh}, -- Z. Falynascria Egg
	{ ["ID"] = "TWITCH_PET02",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_2hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceHigh}, -- V. Pentaamqum Egg
	{ ["ID"] = "TWITCH_PET03",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_2hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceHigh}, -- G. Oestridinzeus Egg
	{ ["ID"] = "TWITCH_PET04",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_2hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceHigh}, -- J. Croconaakeum Egg
	{ ["ID"] = "TWITCH_PET05",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_2hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceHigh}, -- P. Sheptefalae Egg
	{ ["ID"] = "EXPD_EGG_03",		["Campaign"] = "Ex3",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx3Complete,	["Weeks"] = StoreAvailabilityEx3,	["Price"] = PriceVeryHigh}, -- Whispering Companion Egg
	
	{ ["ID"] = "TWITCH_GUN01", 		["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Quantum Harmoniser Mark IV (A-Class Rifle)
	{ ["ID"] = "TWITCH_GUNUP01A", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceMedium}, -- Multi-tool Upgrade Pack 1
	{ ["ID"] = "TWITCH_GUN02", 		["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Loop Scoop Mark IV (A-Class Pistol)
	{ ["ID"] = "TWITCH_GUNUP01B", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceMedium}, -- Multi-tool Upgrade Pack 2
	{ ["ID"] = "TWITCH_GUN03", 		["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Arc Capacitor W/17I-15P (A-Class Pistol)
	{ ["ID"] = "TWITCH_GUNUP01C", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceMedium}, -- Multi-tool Upgrade Pack 3
	{ ["ID"] = "TWITCH_GUN04", 		["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Hunevar's Dream Charger (A-Class Pistol)
	{ ["ID"] = "TWITCH_GUNUP01D", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceMedium}, -- Multi-tool Upgrade Pack 4
	{ ["ID"] = "TWITCH_GUN05", 		["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Imperfect Loop Reflector (A-Class Rifle)
	{ ["ID"] = "TWITCH_GUNUP01E", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_1hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceMedium}, -- Multi-tool Upgrade Pack 5
	
	{ ["ID"] = "EXPD_SHIP01", 		["Campaign"] = "Ex1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx1Complete,	["Weeks"] = StoreAvailabilityEx1,	["Price"] = PriceVeryHigh}, -- Golden Vector (Expedition 1)
	{ ["ID"] = "TWITCH_SHIP01", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_3hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Eokai's Prime Inquirer (A-Class Explorer)
	{ ["ID"] = "TWITCH_SHIP02", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_3hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Hoshis HP7 (A-Class Fighter)
	{ ["ID"] = "TWITCH_SHIP03", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_3hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Nemesis of the Kudama (A-Class Fighter)
	{ ["ID"] = "TWITCH_SHIP04", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_3hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Ultimate Pride JB2 (A-Class Hauler)
	{ ["ID"] = "TWITCH_SHIP05", 	["Campaign"] = "Tw1",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw1_3hr,		["Weeks"] = StoreAvailabilityTw1,	["Price"] = PriceVeryHigh}, -- Prime Song JZ4 (A-Class Shuttle)
	{ ["ID"] = "TWITCH_SHIP06",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_3hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceVeryHigh}, -- VV5 Ariyaz (A-Class Shuttle)
	{ ["ID"] = "TWITCH_SHIP07",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_3hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceVeryHigh}, -- Jirishi's Prospect (A-Class Fighter)
	{ ["ID"] = "TWITCH_SHIP08B",	["Campaign"] = "Ex2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementEx2Ph2,		["Weeks"] = StoreAvailabilityEx2,	["Price"] = PriceVeryHigh}, -- Hadach's Discovery KH3 (A-Class Hunter) (Expedition 2)
	{ ["ID"] = "TWITCH_SHIP08B",	["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_3hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceVeryHigh}, -- Hadach's Discovery KH3 (A-Class Hunter) (Twitch Campaign 2)
	{ ["ID"] = "TWITCH_SHIP09",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_3hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceVeryHigh}, -- Ultimate Sleep LO1 (A-Class Explorer)
	{ ["ID"] = "TWITCH_SHIP10",		["Campaign"] = "Tw2",	["IsConsumable"] = "False",	["Tier"] = TierRequirementTw2_3hr,		["Weeks"] = StoreAvailabilityTw2,	["Price"] = PriceVeryHigh}, -- Hiwamiha of Destiny (Silver A-Class Fighter)
}

------------------------------------------------------------------------------
-- END settings
------------------------------------------------------------------------------

function AddNewSpecialEntry(id, shopNumber, tier, isConsumable) -- Returns a formatted XML section with the given data. id := Item ID, shopNumber := Used for determining which weeks item is available, tier := Community tier requirement, IsConsumable := If you can buy multiple
return[[    <Property value="GcPurchaseableSpecial.xml">
      <Property name="ID" value="]] .. id .. [[" />
      <Property name="ShopNumber" value="]] .. shopNumber .. [[" />
      <Property name="MissionTier" value="]] .. tier .. [[" />
      <Property name="IsConsumable" value="]] .. isConsumable .. [[" />
    </Property>
]]
end -- GetNewSpecial()

NEW_SPECIAL_XML = {}
for u,reward in ipairs(REWARD_TABLE) do
	for i=1,4 do
		local tmpShopNumber = i+51 -- The indecies that allow for community tier restrictions are 52,53,54,55
		local tmpTier = reward["Tier"]
		
		-- Apply Global Settings
		if NoRequirements == true then tmpShopNumber = 1 end
		if NoTierRequirementForAll == true or NoRequirements == true then tmpTier = -1 end
		
		local enableReward = true
		if DisableExpeditionRewards == true then
			if reward["Campaign"] == "Ex1" or reward["Campaign"] == "Ex2" or reward["Campaign"] == "Ex3" then
				enableReward = false
			end
		end
		if DisableTwitchRewards == true then
			if reward["Campaign"] == "Tw1" or reward["Campaign"] == "Tw2" then
				enableReward = false
			end
		end
		if NoTimeRestriction == false then
			if reward["Weeks"][i] == false then
				enableReward = false
			end
		end
		if ConsumablesOnly == true then
			if reward["IsConsumable"] == "False" then
				enableReward = false
			end
		end
		-- END Apply Global Settings
		
		if enableReward == true then
			table.insert(NEW_SPECIAL_XML, AddNewSpecialEntry(reward["ID"], tmpShopNumber, tmpTier, reward["IsConsumable"]))
		end
	end
end

SPECIAL_EXPORT = table.concat(NEW_SPECIAL_XML)

NMS_MOD_DEFINITION_CONTAINER =
{
	["MOD_FILENAME"] 			= "DriftersYATERISM.pak",
	["MOD_AUTHOR"]				= "DrifterOfTime",
	["MOD_DESCRIPTION"]			= "",
	["NMS_VERSION"]				= "3.67",
	["MODIFICATIONS"] 			= 
	{
		{
			["MBIN_CHANGE_TABLE"] =
			{
				{
					["MBIN_FILE_SOURCE"] 	= { "METADATA\REALITY\TABLES\PURCHASEABLESPECIALS.MBIN"},
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							["PRECEDING_KEY_WORDS"] = {"Table"},
							["LINE_OFFSET"] 		= "+0",
							["ADD"] 				= SPECIAL_EXPORT,
						},
					},
				},
			},
		},
	},
}

SHORTCUT_TO_MBIN_CHANGE_TABLE = NMS_MOD_DEFINITION_CONTAINER["MODIFICATIONS"][1]["MBIN_CHANGE_TABLE"]

-- Change prices
if DefaultPrices == false then
	SHORTCUT_TO_MBIN_CHANGE_TABLE[2] = 
	{
		["MBIN_FILE_SOURCE"] 	= { "METADATA\REALITY\TABLES\NMS_REALITY_GCPRODUCTTABLE.MBIN"},
		["EXML_CHANGE_TABLE"] 	= 
		{
		},
	}
	for i,item in ipairs(REWARD_TABLE) do
		local temp_price = item["Price"]
		if AllPricesFree == true then temp_price = 0 end
		local temp_table =
		{					
			["SPECIAL_KEY_WORDS"] = {"Id", item["ID"]},
			["VALUE_CHANGE_TABLE"] = 
			{
				{"BaseValue", temp_price},
			},
		}
		SHORTCUT_TO_MBIN_CHANGE_TABLE[2]["EXML_CHANGE_TABLE"][#SHORTCUT_TO_MBIN_CHANGE_TABLE[2]["EXML_CHANGE_TABLE"] + 1] = temp_table
	end
end