(****************************************************************************)
(*                                                                          *)
(*   This file is part of the SXC Extractor project code.                   *)
(*   Created 2019 by Madman.                                                *)
(*                                                                          *)
(*   See the file LICENSE.TXT included in this distribution, for details    *)
(*   about the copyright.                                                   *)
(*                                                                          *)
(*   This program is distributed in the hope that it will be useful, but    *)
(*   WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                   *)
(*                                                                          *)
(****************************************************************************)
{$APPTYPE CONSOLE}

program text2hash;
uses sxc_hashgen;


(****************************************************************************)
(*   helper functions                                                       *)
(****************************************************************************)

function Byte2Hex(const val: Byte): AnsiString;
const
	HEX_TABLE: packed array[0..15] of AnsiChar = '0123456789abcdef';
begin
	result := HEX_TABLE[val shr 4] + HEX_TABLE[val and $0F];
end;

function Word2Hex(const val: Word): AnsiString;
begin
	result := Byte2Hex(Byte(val shr 8)) + Byte2Hex(Byte(val and $FF));
end;

function Long2Hex(const val: LongWord): AnsiString;
begin
	result := Word2Hex(Word(val shr 16)) + Word2Hex(Word(val and $FFFF));
end;

function LongLong2Hex(const val: UInt64): AnsiString;
begin
	result := Long2Hex(LongWord(val shr 32)) + Long2Hex(LongWord(val and $FFFFFFFF));
end;


(****************************************************************************)
(*   main                                                                   *)
(****************************************************************************)

var
	st: HASH_STRING;
begin
	Write(StdOut, 'Enter a text: '); ReadLn(st);
	WriteLn(StdOut, 'Hash Code: ', LongLong2Hex(sxc_getHash(st)));
end.
