-- Original Mod Author Information (translators - do not edit)
Author = "alchemist"
ModName = "GPS"
BaseDescription = [[Better scanning]]
GameVersion = "3-87"
ModVersion = "1-3-0"

-- =========
-- CONSTANTS
-- =========

LANGUAGE_NAMES = {"English", "French", "Italian", "German", "Spanish", "Russian", "Polish",
  "Dutch", "Portuguese", "LatinAmericanSpanish", "BrazilianPortuguese", "SimplifiedChinese",
  "TraditionalChinese", "TencentChinese", "Korean", "Japanese", "USEnglish"}

-- for if the filename spelling of a language is different than just string.upper()
LANGUAGE_FILENAME_TABLE = {
  ["LatinAmericanSpanish"] = "LATINAMERAICANSPANISH"
}

-- ========================
-- BEGIN TRANSLATOR SECTION
-- ========================

-- Hello, my name is...
TranslationAuthor = "mer1tornexus"

-- The language provided by this build. Used in the output file name and (possibly)
-- to select which file to inject language entries in to.
--
-- Select from LANGUAGE_NAMES array above.
LanguageName = "Russian"

-- Whether to inject the language table into just the target language file (false),
-- or all language files (true). If true, players will see the provided strings no
-- matter what language they play in. Should probably be true, unless you have
-- a specific reason.
--
ForceAllLanguageFiles = true
--

-- Which group of files from the "Language" directory of the extracted game files to
-- inject the new language entries into. Translators should not change.
LanguageFilePrefix = "NMS_LOC7_"

--[[

# Adding Language Entries

The LANGUAGE_TABLE is a key-value table. When asked to display text, the game will
look up the the key in the player's preferred language file. 

Mod Authors: Add key-value pairs. Keys must be unique across the entire game.
Translators: Make changes to the values, do NOT make changes to keys.

  ["KEY"] = "Value",

All entries should be single line strings. If the output should be a multi-line
string, use \n to denote line breaks.

  ["MULTILINE_KEY"] = "This is the first line.\nThis is the second line.",

Line-breaks are especially important in dialogs as it also indicates where to
wait for the player to hit a button to continue reading.

The link below is for a guide on NMS text formatting. This will allow you to change
the color of text or add icons. Format wrappers and icon tags must be in English.

  https://www.nexusmods.com/nomanssky/mods/2134

--]]

-- Total keys: 179
LANGUAGE_TABLE = {
  --
  ["ALCH_BIOS_PORT_ERR_NEED_PASS"] = "  <IMG>SLASH<>  <IMG>SLASH<>  ", --
  ["ALCH_BIOS_PORT_MENU_HOME_DESC"] = "<STELLAR> <> <IMG>SLASH<>    ~ <TRADEABLE><> <IMG>SLASH<>   ...", --
  ["ALCH_BIOS_SHIP_MENU_HOME_DESC"] = "<STELLAR> <> <IMG>SLASH<>    ~ <TRADEABLE><> <IMG>SLASH<>   ...", --
  ["ALCH_BIOS_SHIP_MISSION_DESC"] = "  <STELLAR><>   <TRADEABLE><>,   (<IMG>SCAN<>)    <TECHNOLOGY> <>.\n\n<TRADEABLE> <>         <TECHNOLOGY> <>    <SPECIAL> <>.\n\n<TRADEABLE> <>   <TECHNOLOGY>  <>        ,    <SPECIAL> <>.", --
  ["ALCH_BIOS_SHIP_SCAN_OBJ"] = " ", --
  ["ALCH_BIOS_SHIP_SCAN_OBJ_MSG"] = " <TECHNOLOGY> <> \n  (<IMG>SCAN<>)   ", --
  ["ALCH_BIOS_SHIP_SCAN_OBJ_TIP"] = "  (<IMG>SCAN<>)    <TECHNOLOGY> <>.", --
  ["ALCH_BIOS_SHIP_SHIP_OBJ"] = "  ", --
  ["ALCH_BIOS_SHIP_SHIP_OBJ_TIP"] = "   <TRADEABLE>    <>   <TECHNOLOGY> <>.", --
  ["ALCH_BIOS_SHIP_SHIP_OBJ_WAIT"] = " <TECHNOLOGY> <> <FUEL><> <IMG>DANGER<> \n<TRADEABLE><>    ", --
  ["ALCH_BIOS_SHIP_SPACE_OBJ"] = "  ", --
  ["ALCH_BIOS_SHIP_SPACE_OBJ_TIP"] = "<IMG>DANGER<> <FUEL> <>\n<TECHNOLOGY> <>      , ,     .", --
  ["ALCH_BIOS_SHIP_SPACE_OBJ_WAIT"] = " <TECHNOLOGY> <> <FUEL><> <IMG><>", --
  ["ALCH_BIOS_SHIP_SUB_1"] = "  ", --
  ["ALCH_BIOS_SHIP_TITLE_1"] = "  ", --
  ["ALCH_FLYBY_PORT_FLYBY_CHAT_START"] = "%NAME%       %PLANET%", --
  ["ALCH_FLYBY_PORT_FLYBY_DONE"] = "   ", --
  ["ALCH_FLYBY_PORT_FLYBY_OBJ"] = " ", --
  ["ALCH_FLYBY_PORT_FLYBY_OBJ_TIP"] = "      .\n     ,    .", --
  ["ALCH_FLYBY_PORT_FLYBY_R_OBJ"] = "  ", --
  ["ALCH_FLYBY_PORT_FLYBY_R_OBJ_TIP"] = "       .\n    <STELLAR> <>  <STELLAR> <>.", --
  ["ALCH_FLYBY_PORT_FLYBY_START"] = "-   <IMG>SLASH<>   ...", --
  ["ALCH_FLYBY_PORT_FLYBY_WAIT"] = "    ...\n       <TECHNOLOGY> <>.", --
  ["ALCH_FLYBY_PORT_SHIP_COMM"] = "  ", --
  ["ALCH_FLYBY_PORT_SUB_1"] = "  ", --
  ["ALCH_FLYBY_PORT_TITLE_1"] = "- ", --
  ["ALCH_PLANET_EXP_SUB_1"] = "   ", --
  ["ALCH_RECON_SHIP_RECON_OBJ"] = " ", --
  ["ALCH_RECON_SHIP_RECON_OBJ_TIP"] = "   ", --
  ["ALCH_SCAN_ERR_PS_ACTIVE"] = " ", --
  ["ALCH_SCAN_ERR_PS_ACTIVE_OSD"] = " <IMG>SLASH<>   <IMG>SLASH<>     ", --
  ["ALCH_SCAN_FLYBY_COMM_DESC"] = " , .       ?", --
  ["ALCH_SCAN_GPS_INTRO_OSD"] = "  ", --
  ["ALCH_SCAN_GRP_ANC_DESC"] = "   ", --
  ["ALCH_SCAN_GRP_ANC_FLYBY"] = ".    .   .", --
  ["ALCH_SCAN_GRP_ANC_FLYBY_DONE"] = "  .   .", --
  ["ALCH_SCAN_GRP_ANC_MENU"] = " ...", --
  ["ALCH_SCAN_GRP_ANC_NAME"] = " ", --
  ["ALCH_SCAN_GRP_BLD_DESC"] = "  ", --
  ["ALCH_SCAN_GRP_BLD_FLYBY"] = ".      .   .", --
  ["ALCH_SCAN_GRP_BLD_FLYBY_DONE"] = "   .   .", --
  ["ALCH_SCAN_GRP_BLD_MENU"] = " ...", --
  ["ALCH_SCAN_GRP_BLD_NAME"] = " ", --
  ["ALCH_SCAN_GRP_SIG_DESC"] = "     ", --
  ["ALCH_SCAN_GRP_SIG_FLYBY"] = ".        .   .", --
  ["ALCH_SCAN_GRP_SIG_FLYBY_DONE"] = "  .   .", --
  ["ALCH_SCAN_GRP_SIG_MENU"] = " ...", --
  ["ALCH_SCAN_GRP_SIG_NAME"] = " ", --
  ["ALCH_SCAN_GRP_SVG_DESC"] = "   ", --
  ["ALCH_SCAN_GRP_SVG_FLYBY"] = ".       .   .", --
  ["ALCH_SCAN_GRP_SVG_FLYBY_DONE"] = "  .   .", --
  ["ALCH_SCAN_GRP_SVG_MENU"] = " ...", --
  ["ALCH_SCAN_GRP_SVG_NAME"] = " ", --
  ["ALCH_SCAN_GRP_UW_DESC"] = "   ", --
  ["ALCH_SCAN_GRP_UW_FLYBY"] = ".      .   .", --
  ["ALCH_SCAN_GRP_UW_FLYBY_DONE"] = "  .   .", --
  ["ALCH_SCAN_GRP_UW_MENU"] = " ...", --
  ["ALCH_SCAN_GRP_UW_NAME"] = " ", --
  ["ALCH_SCAN_MENU_DEBUG"] = "", --
  ["ALCH_SCAN_MENU_FLEET_RECON"] = "-...", --
  ["ALCH_SCAN_MENU_FLEET_RECON_ERR"] = "         .", --
  ["ALCH_SCAN_MENU_OPT_BACK"] = "...", --
  ["ALCH_SCAN_MENU_OPT_CONFIG"] = "...", --
  ["ALCH_SCAN_MENU_OPT_HOME"] = "...", --
  ["ALCH_SCAN_MENU_OPT_INIT"] = "...", --
  ["ALCH_SCAN_MENU_OPT_NEXT"] = " ...", --
  ["ALCH_SCAN_MENU_OPT_NO"] = "", --
  ["ALCH_SCAN_MENU_OPT_YES"] = "", --
  ["ALCH_SCAN_MENU_SCAN_EXACT"] = " ...", --
  ["ALCH_SCAN_MENU_SCAN_RAND"] = " ...", --
  ["ALCH_SCAN_MENU_SHIP_DESC"] = "<SPECIAL> <> <IMG>SLASH<>    ...", --
  ["ALCH_SCAN_MENU_SHIP_RANGE"] = "  ...", --
  ["ALCH_SCAN_MENU_SHIP_RANGE_DESC"] = "<SPECIAL> <> <IMG>SLASH<>    ...", --
  ["ALCH_SCAN_MENU_SHIP_RANGE_ERR"] = "   <IMG>SLASH<>  <IMG>SLASH<>  ", --
  ["ALCH_SCAN_MENU_SHIP_RECON"] = " ...", --
  ["ALCH_SCAN_MENU_SHIP_RECON_ERR"] = "  <IMG>SLASH<>  <IMG>SLASH<>   ", --
  ["ALCH_SCAN_PIO_GRAVE_TIP"] = "<TITLE>    <>\n   ,     ", --
  ["ALCH_SCAN_POI_TREA_MENU"] = " ", --
  ["ALCH_SCAN_POI_UWAB"] = " ", --
  ["ALCH_SCAN_POI_UWCF"] = "  ", --
  ["ALCH_SCAN_POI_UWDS"] = " ", --
  ["ALCH_SCAN_POI_UWTR"] = " ", --
  ["ALCH_SCAN_PQ_ACTIVE_OBJ"] = " ", --
  ["ALCH_SCAN_PQ_ACTIVE_OBJ_TIP"] = "       <TRADEABLE><>      <STELLAR> <>.\n\n     -.  <IMG> <>  <COMMODITY> <>.", --
  ["ALCH_SCAN_PQ_DESC"] = "<TECHNOLOGY><>   <IMG>SLASH<>    <IMG>SLASH<>   <STELLAR>  <>  ", --
  ["ALCH_SCAN_PQ_PLANET_OBJ"] = "  ", --
  ["ALCH_SCAN_PQ_PLANET_OBJ_TIP"] = ",   <SPECIAL> <>    <TRADEABLE>  <>.    ,   .\n\n     ", --
  ["ALCH_SCAN_PQ_PLANET_OBJ_WAIT"] = "<TITLE>    <> <TRADEABLE> <>\n   ,   ", --
  ["ALCH_SCAN_PQ_QA_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QA_MENU"] = "", --
  ["ALCH_SCAN_PQ_QA_TITLE"] = "  ~ ", --
  ["ALCH_SCAN_PQ_QB_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QB_MENU"] = "", --
  ["ALCH_SCAN_PQ_QB_TITLE"] = "  ~ ", --
  ["ALCH_SCAN_PQ_QC_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QC_MENU"] = "", --
  ["ALCH_SCAN_PQ_QC_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QD_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QD_MENU"] = "", --
  ["ALCH_SCAN_PQ_QD_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QE_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QE_MENU"] = "", --
  ["ALCH_SCAN_PQ_QE_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QF_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QF_MENU"] = "", --
  ["ALCH_SCAN_PQ_QF_TITLE"] = "  ~ ", --
  ["ALCH_SCAN_PQ_QG_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QG_MENU"] = "", --
  ["ALCH_SCAN_PQ_QG_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QH_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QH_MENU"] = "", --
  ["ALCH_SCAN_PQ_QH_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QI_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QI_MENU"] = "", --
  ["ALCH_SCAN_PQ_QI_TITLE"] = "  ~ ", --
  ["ALCH_SCAN_PQ_QJ_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QJ_MENU"] = "", --
  ["ALCH_SCAN_PQ_QJ_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QK_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QK_MENU"] = "", --
  ["ALCH_SCAN_PQ_QK_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_QL_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_QL_MENU"] = "", --
  ["ALCH_SCAN_PQ_QL_TITLE"] = "   ~ ", --
  ["ALCH_SCAN_PQ_RA_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_RA_MENU"] = " ", --
  ["ALCH_SCAN_PQ_RA_TITLE"] = "   ~  ", --
  ["ALCH_SCAN_PQ_RB_DESC"] = "<SPECIAL> <> <IMG>SLASH<>  ", --
  ["ALCH_SCAN_PQ_RB_MENU"] = " ", --
  ["ALCH_SCAN_PQ_RB_TITLE"] = "   ~  ", --
  ["ALCH_SCAN_PQ_RC_DESC"] = "<SPECIAL> <> <IMG>SLASH<>    ~   ~       ~   ", --
  ["ALCH_SCAN_PQ_RC_MENU"] = " ", --
  ["ALCH_SCAN_PQ_RC_TITLE"] = "   ~  ", --
  ["ALCH_SCAN_PQ_RD_DESC"] = "<SPECIAL>QUERY PARAMETERS<> <IMG>SLASH<>     ~    ~   ~       ~   ", --
  ["ALCH_SCAN_PQ_RD_MENU"] = " ", --
  ["ALCH_SCAN_PQ_RD_TITLE"] = "  ~  ", --
  ["ALCH_SCAN_PQ_SEARCH_OBJ"] = "     ", --
  ["ALCH_SCAN_PQ_SEARCH_OBJ_TIP"] = "              . <SPECIAL> <>.\n\n<STELLAR><> ~        <FUEL> <>.          .", --
  ["ALCH_SCAN_PQ_SYSTEM_OBJ"] = "  ", --
  ["ALCH_SCAN_PQ_SYSTEM_OBJ_TIP"] = ",   <SPECIAL> <>    <TECHNOLOGY> <>.\n\n <IMG> <>  <STELLAR> <>     .", --
  ["ALCH_SCAN_PQ_SYSTEM_OBJ_WAIT"] = "<TITLE>   <> <TECHNOLOGY> <>\n <IMG> <>  <STELLAR> <>", --
  ["ALCH_SCAN_PR_DESC"] = "<TECHNOLOGY><>   <IMG>SLASH<>    <IMG>SLASH<>   <STELLAR>  <>  ", --
  ["ALCH_SCAN_PZ_DESC"] = "<SPECIAL><>   <IMG>SLASH<> <FUEL>ADVISORY<> ~    <IMG>SLASH<>   <STELLAR>  <>  ", --
  ["ALCH_SCAN_SCAN_EXACT_DESC"] = "     .", --
  ["ALCH_SCAN_SCAN_RAND_DESC"] = "   POI.", --
  ["D_ALSCFP_SHIP_R_DESC"] = "-  <IMG>SLASH<> <TRADEABLE><> <IMG>SLASH<> <TECHNOLOGY> <>  ", --
  ["D_ALSCFP_SHIP_R_OPT_A"] = "", --
  ["D_ALSCPB_BOOT_LANG"] = "BIOS   <IMG>SLASH<>   <IMG>SLASH<>   ...\n<STELLAR> <> <IMG>SLASH<>     <IMG>SLASH<>        <IMG>SLASH<>   ?", --
  ["D_ALSCPB_BOOT_RES_A"] = "BIOS   <IMG>SLASH<>    <IMG>SLASH<> ...", --
  ["D_ALSCPB_BOOT_RES_B"] = "BIOS   <IMG>SLASH<>    <IMG>SLASH<> ...", --
  ["D_ALSCPB_CONFIG_LANG"] = "BIOS   <IMG>SLASH<>   ...", --
  ["D_ALSCPB_CONFIG_OPT_A"] = "   ", --
  ["D_ALSCPB_CONFIG_OPT_B"] = "   ", --
  ["D_ALSCPB_CONFIG_OPT_C"] = "  ", --
  ["D_ALSCPB_CONFIG_OPT_D"] = "  ", --
  ["D_ALSCPB_CONFIG_OPT_E"] = "  ", --
  ["D_ALSCPB_CONFIG_RES_A"] = "BIOS   <IMG>SLASH<>       <IMG>SLASH<> ...", --
  ["D_ALSCPB_CONFIG_RES_B"] = "BIOS   <IMG>SLASH<>        <IMG>SLASH<> ...", --
  ["D_ALSCPB_CONFIG_RES_C"] = "BIOS   <IMG>SLASH<> <COMMODITY> <> ,    <IMG>SLASH<> ...", --
  ["D_ALSCPB_CONFIG_RES_D"] = "BIOS   <IMG>SLASH<> <COMMODITY> <> ,    <IMG>SLASH<> ...", --
  ["D_ALSCPB_UTIL_RES_A"] = "  ...", --
  ["D_ALSCSB_BOOT_DESC"] = "BIOS   <IMG>SLASH<>   <IMG>SLASH<>   ...\n<STELLAR> <> <IMG>SLASH<>    <IMG>SLASH<>      Ship Tech <IMG>SLASH<>   ?", --
  ["D_ALSCSB_BOOT_RES_A"] = "BIOS   <IMG>SLASH<>    <IMG>SLASH<> ...", --
  ["D_ALSCSB_BOOT_RES_B"] = "BIOS   <IMG>SLASH<>    <IMG>SLASH<> ...", --
  ["D_ALSCSB_CONFIG_LANG"] = "BIOS   <IMG>SLASH<>   ...", --
  ["D_ALSCSB_CONFIG_OPT_A"] = "   ", --
  ["D_ALSCSB_CONFIG_OPT_B"] = "   ", --
  ["D_ALSCSB_CONFIG_OPT_C"] = "  ", --
  ["D_ALSCSB_CONFIG_OPT_D"] = "  ", --
  ["D_ALSCSB_CONFIG_RES_A"] = "BIOS   <IMG>SLASH<>       <IMG>SLASH<> ...", --
  ["D_ALSCSB_CONFIG_RES_B"] = "BIOS   <IMG>SLASH<>        <IMG>SLASH<> ...", --
  ["D_ALSCSB_CONFIG_RES_C"] = "BIOS   <IMG>SLASH<>       <IMG>SLASH<> ...", --
  ["D_ALSCSB_CONFIG_RES_D"] = "BIOS   <IMG>SLASH<>       <IMG>SLASH<> ...", --
  ["D_ALSCSB_PL_SCAN_DESC"] = "   <TRADEABLE><> <IMG>SLASH<>    ...", --
  ["D_ALSCSB_PL_SCAN_OPT_A"] = "  ...", --
  ["D_ALSCSB_PL_SCAN_OPT_B"] = "  ...", --
  ["SIGNALSCANNER_OPT_G"] = "  ...", --
  ["SIGNALSCANNER_OPT_H"] = "  ", --
  ["SIGNALSCANNER_RES_G"] = "    <IMG>SLASH<>      <IMG>SLASH<>      .", --
}

-- ======================================
-- END TRANSLATOR SECTION // BEGIN AMUMSS
-- ======================================

-- this could likely be much better
local function escapeLang(value)
  value = value:gsub("<", "&lt;")
  value = value:gsub(">", "&gt;")
  value = value:gsub("\n", "&#xA;")
  return value
end

local function langEntry(language, value)
  return [[
      <Property name="]]..language..[[" value="VariableSizeString.xml">
        <Property name="Value" value="]]..value..[[" />
      </Property>
]]
end

local function TkLocalisationEntry(lang, id, value)
  local entries = ""
  for i = 1, #LANGUAGE_NAMES do
    if LANGUAGE_NAMES[i] == lang then
      entries = entries..langEntry(LANGUAGE_NAMES[i], escapeLang(value))
    else
      entries = entries..langEntry(LANGUAGE_NAMES[i], "")
    end
  end

  return [[
    <Property value="TkLocalisationEntry.xml">
      <Property name="Id" value="]]..id..[[" />
]]..entries..[[
    </Property>
]]
end

-- build xml with LANGUAGE_TABLE associated with given language
local function buildForLanguage(lang)
  local langOutput = ""
  for key, value in pairs(LANGUAGE_TABLE) do
    langOutput = langOutput..TkLocalisationEntry(lang, key, value)
  end
  return langOutput;
end

-- build pak name
ModName = ModName.."_Lang_"..LanguageName
if Author ~= TranslationAuthor then
  ModName = ModName.."_"..TranslationAuthor
end

-- actual AMUMSS instructions
NMS_MOD_DEFINITION_CONTAINER = {

["MOD_FILENAME"]				= Author.."_"..ModName.."_"..GameVersion.."_"..ModVersion..".pak",
["MOD_DESCRIPTION"]			= BaseDescription,
["MOD_AUTHOR"]					= Author,
["NMS_VERSION"]					= GameVersion,

["MODIFICATIONS"]	= {
{["MBIN_CHANGE_TABLE"] = {

  -- empty on purpose

}}}}

local Ref = NMS_MOD_DEFINITION_CONTAINER["MODIFICATIONS"][1]["MBIN_CHANGE_TABLE"]

local function addChangeTable(lang)
  local langFilename
  if LANGUAGE_FILENAME_TABLE[lang] ~= nil then
    langFilename = LANGUAGE_FILENAME_TABLE[lang]
  else
    langFilename = string.upper(lang)
  end

  Ref[#Ref + 1] = {
    ["MBIN_FILE_SOURCE"] = "LANGUAGE\\"..LanguageFilePrefix..langFilename..".MBIN",
	  ["EXML_CHANGE_TABLE"] = {
      {
        ["PRECEDING_KEY_WORDS"] = {"Table"},
        ["LINE_OFFSET"] = 0,
        ["ADD"] = buildForLanguage(lang)
      },
	  }
  }
end

if ForceAllLanguageFiles == true then
  for i = 1, #LANGUAGE_NAMES do
    addChangeTable(LANGUAGE_NAMES[i])
  end
else
  addChangeTable(LanguageName)
end