-- SET TO TRUE TO IGNORE VANILLA PALETTE NUMBER LIMITS
-- EFFECTIVELY ELIMINATING SOME VANILLA PALETTES
YEET_VANILLA_PALETTES = false

NEW_COLOURS_HEX =
-- HEX COLOUR VALUES WITHOUT THE HASHTAG
-- FEEL FREE TO ADD A FEW OF YOUR OWN CUSTOM COLOURS
-- COLOURS WILL BE SHOWN TO OTHER PLAYERS IN MULTIPLAYER AS WHITE
-- KEEP THE "Name" VALUE UNDER 30 CHARACTERS
-- NOTE: TYPE "&" SYMBOL AS "&amp;"
--[[ CODE EXAMPLE FOR A SINGLE PALETTE
	{
		["PrimaryColour"] = 	"000000",
		["SecondaryColour"] = 	"000000",
		["TernaryColour"] = 	"000000",
		["QuaternaryColour"] = 	"000000",
		["Name"] =				"All Black",
		["Id"] =				"BF_ALLBLACK",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
-- COLOURS ARE IN HEXCODE
]]
{	
	-- {
		-- ["PrimaryColour"] = 	"ff0000",
		-- ["SecondaryColour"] = 	"ff0000",
		-- ["TernaryColour"] = 	"ff0000",
		-- ["QuaternaryColour"] = 	"ff0000",
		-- ["Name"] =				"All Red",
		-- ["Id"] =				"BF_ALLRED",
		-- ["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	-- },
	-- {
		-- ["PrimaryColour"] = 	"00ff00",
		-- ["SecondaryColour"] = 	"00ff00",
		-- ["TernaryColour"] = 	"00ff00",
		-- ["QuaternaryColour"] = 	"00ff00",
		-- ["Name"] =				"All Green",
		-- ["Id"] =				"BF_ALLGREEN",
		-- ["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	-- },
	-- {
		-- ["PrimaryColour"] = 	"0000ff",
		-- ["SecondaryColour"] = 	"0000ff",
		-- ["TernaryColour"] = 	"0000ff",
		-- ["QuaternaryColour"] = 	"0000ff",
		-- ["Name"] =				"All Blue",
		-- ["Id"] =				"BF_ALLBLUE",
		-- ["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	-- },
	{
		["PrimaryColour"] = 	"000000",
		["SecondaryColour"] = 	"000000",
		["TernaryColour"] = 	"000000",
		["QuaternaryColour"] = 	"000000",
		["Name"] =				"All Black",
		["Id"] =				"BF_ALLBLACK",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"ffffff",
		["SecondaryColour"] = 	"ffffff",
		["TernaryColour"] = 	"ffffff",
		["QuaternaryColour"] = 	"ffffff",
		["Name"] =				"All White",
		["Id"] =				"BF_ALLWHITE",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"000000",
		["SecondaryColour"] = 	"ffffff",
		["TernaryColour"] = 	"000000",
		["QuaternaryColour"] = 	"ffffff",
		["Name"] =				"Tai-chi 1",
		["Id"] =				"BF_TAICHI1",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"ffffff",
		["SecondaryColour"] = 	"000000",
		["TernaryColour"] = 	"ffffff",
		["QuaternaryColour"] = 	"000000",
		["Name"] =				"Tai-chi 2",
		["Id"] =				"BF_TAICHI2",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"bbd5bf",
		["SecondaryColour"] = 	"d46738",
		["TernaryColour"] = 	"487473",
		["QuaternaryColour"] = 	"487473",
		["Name"] =				"ArC 1",
		["Id"] =				"BF_ARCONE",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	-- {
		-- ["PrimaryColour"] = 	"d46738",
		-- ["SecondaryColour"] = 	"bbd5bf",
		-- ["TernaryColour"] = 	"487473",
		-- ["QuaternaryColour"] = 	"487473",
		-- ["Name"] =				"ArC 2",
		-- ["Id"] =				"BF_ARCTWO",
		-- ["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	-- },
	{
		["PrimaryColour"] = 	"f090be",	--331
		["SecondaryColour"] = 	"a4e6f0",
		["TernaryColour"] = 	"a34673",
		["QuaternaryColour"] = 	"659ba3",
		["Name"] =				"Pastel Magenta &amp; Blizzard Blue",
		["Id"] =				"BF_MAG_BLIZ",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"F78A83",	--3
		["SecondaryColour"] = 	"F54538",
		["TernaryColour"] = 	"C2372D",
		["QuaternaryColour"] = 	"75211B",
		["Name"] =				"Coral Pink &amp; Red Orange",
		["Id"] =				"BF_CORP_REDOR",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"F66420",	--19
		["SecondaryColour"] = 	"F6CB20",
		["TernaryColour"] = 	"D4711C",
		["QuaternaryColour"] = 	"D49D1C",
		["Name"] =				"Crayon Orange &amp; Jonquil",
		["Id"] =				"BF_ORA_JON",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"A5F54E",	--88
		["SecondaryColour"] = 	"EB6BFF",
		["TernaryColour"] = 	"61A814",
		["QuaternaryColour"] = 	"9725A8",
		["Name"] =				"French Lime &amp; Heliotrope",
		["Id"] =				"BF_LIM_HELIO",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"A9F3CC",	--148
		["SecondaryColour"] = 	"A8F29D",
		["TernaryColour"] = 	"B6F0F2",
		["QuaternaryColour"] = 	"B6F0F2",
		["Name"] =				"Magic Mint &amp; Light Green",
		["Id"] =				"BF_MINT_LG",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"2CF6D7",	--170
		["SecondaryColour"] = 	"2C3EF6",
		["TernaryColour"] = 	"26BFD4",
		["QuaternaryColour"] = 	"2663D4",
		["Name"] =				"Turquoise &amp; Palatinate Blue",
		["Id"] =				"BF_TUR_PAL",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"0057b7",	--211
		["SecondaryColour"] = 	"ffd700",
		["TernaryColour"] = 	"ffd700",
		["QuaternaryColour"] = 	"ffd700",
		["Name"] =				"Ukraine Colours",
		["Id"] =				"BF_UKRAINE",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"2c65a9",	--212
		["SecondaryColour"] = 	"52ce97",
		["TernaryColour"] = 	"52ce97",
		["QuaternaryColour"] = 	"52ce97",
		["Name"] =				"Lapis &amp; Shamrock",
		["Id"] =				"BF_LAP_SHAM",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
{
		["PrimaryColour"] = 	"C737FA",	--284
		["SecondaryColour"] = 	"F54198",
		["TernaryColour"] = 	"DE31DB",
		["QuaternaryColour"] = 	"DE31DB",
		["Name"] =				"Psychedelic Purple &amp; Rose",
		["Id"] =				"BF_PSYC_ROSE",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"F63B3B",	--0
		["SecondaryColour"] = 	"903BF6",
		["TernaryColour"] = 	"D43383",
		["QuaternaryColour"] = 	"A833D4",
		["Name"] =				"Coral Red &amp; Veronica",
		["Id"] =				"BF_COR_VER",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"F0A741",	--34
		["SecondaryColour"] = 	"F04647",
		["TernaryColour"] = 	"A36E24",
		["QuaternaryColour"] = 	"A32425",
		["Name"] =				"Yellow Orange &amp; Carmine Pink",
		["Id"] =				"BF_YO_CPINK",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"F2ECBF",	--52
		["SecondaryColour"] = 	"F2C6A7",
		["TernaryColour"] = 	"F3DEB5",
		["QuaternaryColour"] = 	"F3DEB5",
		["Name"] =				"Pale Spring Bud &amp; Apricot",
		["Id"] =				"BF_BUD_APRI",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"FFF870",	--57
		["SecondaryColour"] = 	"8A51F0",
		["TernaryColour"] = 	"A39D27",
		["QuaternaryColour"] = 	"4817A3",
		["Name"] =				"Icterine &amp; Lavender Indigo",
		["Id"] =				"BF_ICT_LAV",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"ede91e",	--58
		["SecondaryColour"] = 	"826494",
		["TernaryColour"] = 	"826494",
		["QuaternaryColour"] = 	"826494",
		["Name"] =				"Titanium Yellow &amp; French Lilac",
		["Id"] =				"BF_TIT_LILAC",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"2b651e",	--109
		["SecondaryColour"] = 	"5fc8dc",
		["TernaryColour"] = 	"5fc8dc",
		["QuaternaryColour"] = 	"5fc8dc",
		["Name"] =				"Dark Green &amp; Middle Blue",
		["Id"] =				"BF_DG_MIDB",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"3DF656",	--128
		["SecondaryColour"] = 	"F6EA3D",
		["TernaryColour"] = 	"52D435",
		["QuaternaryColour"] = 	"C1D435",
		["Name"] =				"Erin &amp; Dandelion",
		["Id"] =				"BF_ERIN_DAN",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"48C25A",	--128
		["SecondaryColour"] = 	"44784C",
		["TernaryColour"] = 	"A5F7B1",
		["QuaternaryColour"] = 	"2B7536",
		["Name"] =				"Bice &amp; Fern Green",
		["Id"] =				"BF_BICE_FERN",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"69CFFF",	--199
		["SecondaryColour"] = 	"F5A84C",
		["TernaryColour"] = 	"237EA8",
		["QuaternaryColour"] = 	"A86413",
		["Name"] =				"Light Sky Blue &amp; Yellow Orange",
		["Id"] =				"BF_SKY_YELORA",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"C1E7FA",	--199
		["SecondaryColour"] = 	"D8C1FA",
		["TernaryColour"] = 	"ABBFDE",
		["QuaternaryColour"] = 	"B2ABDE",
		["Name"] =				"Uranian Blue &amp; Pale Lavender",
		["Id"] =				"BF_URAN_LAV",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"BAD6F5",	--211
		["SecondaryColour"] = 	"AEF4F5",
		["TernaryColour"] = 	"C9C6F5",
		["QuaternaryColour"] = 	"C9C6F5",
		["Name"] =				"Cornflower &amp; Pale Blue",
		["Id"] =				"BF_CORN_BLUE",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"73A1F5",	--218
		["SecondaryColour"] = 	"CA5BF5",
		["TernaryColour"] = 	"5874A8",
		["QuaternaryColour"] = 	"8836A8",
		["Name"] =				"Vista Blue &amp; Medium Orchid",
		["Id"] =				"BF_VISB_ORC",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"8146b3",	--272
		["SecondaryColour"] = 	"ffffff",
		["TernaryColour"] = 	"8146b3",
		["QuaternaryColour"] = 	"8146b3",
		["Name"] =				"Medium Violet &amp; White",
		["Id"] =				"BF_MVIO_WHI",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
	{
		["PrimaryColour"] = 	"E1BDF5",	--278
		["SecondaryColour"] = 	"B7B0F5",
		["TernaryColour"] = 	"F5C9E5",
		["QuaternaryColour"] = 	"F5C9E5",
		["Name"] =				"Electric Lav &amp; Max Blurple",
		["Id"] =				"BF_LAV_BLUP",
		["PaletteGroup"] =		{ "LEGACY", "COLOURS_S", "COLOURS_F", "COLOURS_T" }
	},
}

VANILLA_PALETTE_IDS =
-- VANILLA PALETTE IDS TO BE ADDED TO OTHER PALETTE GROUPS
{
	["LEGACY"] = 
	{
		["Group"] = "LEGACY",
		["Palettes"] =
		{
			"LEGACY1",
			"LEGACY2",
			"LEGACY3",
			"LEGACY4",
			"LEGACY5",
			"LEGACY6",
			"LEGACY7",
			"LEGACY8",
			"LEGACY9",
			"LEGACY10",
			"LEGACY11",
			"LEGACY12",
			"LEGACY13",
			"LEGACY14",
			"LEGACY15",
			"LEGACY16",
		}
	},
	["FLAGS"] =
	{
		["Group"] = "FLAGS",
		["Palettes"] =
		{
			"FLAGS1",
			"FLAGS2",
			"FLAGS3",
			"FLAGS4",
			"FLAGS5",
			"FLAGS6",
		}
	},
	["COLOURS_S"] =
	{
		["Group"] = "COLOURS_S",
		["Palettes"] =
		{
			"STONENATURAL1",
			"STONENATURAL2",
			"STONENATURAL3",
			"STONENATURAL4",
			"STONEBLUE1",
			"STONEBLUE2",
			"STONEBLUE3",
			"STONEGREEN1",
			"STONEGREEN2",
			"STONEGREEN3",
			"STONEROYAL1",
		}
	},
	["COLOURS_F"] =
	{
		["Group"] = "COLOURS_F",
		["Palettes"] =
		{
			"FIBREGLASS1",
			"FIBREGLASS2",
			"FIBREGLASS3",
			"FIBREGLASS4",
			"FIBREGLASS5",
			"FIBREGLASS6",
			"FIBREGLASS7",
			"FIBREGLASS8",
		}
	},
	["COLOURS_T"] =
	{
		["Group"] = "COLOURS_T",
		["Palettes"] =
		{
			"TIMBERBASIC1",
			"TIMBERBASIC2",
			"TIMBERBASIC3",
			"TIMBERBASIC4",
			"TIMBERSTAINED1",
			"TIMBERSTAINED2",
			"TIMBERSTAINED3",
			"TIMBERSTAINED4",
			"TIMBERROYAL1",
		}
	},
}

PALETTE_QUAD = {"PrimaryColour", "SecondaryColour", "TernaryColour", "QuaternaryColour"}

RGB = {"R", "G", "B"}

-- VANILLA MAX PALETTE SLOTS IN ONE PALETTE GROUP WITHOUT UI FILE CHANGES
-- DO NOT ALTER 
NUM_VANILLA_COLOUR =
{ 
["LEGACY"] = 	16,
["FLAGS"] = 	6,
["COLOURS_S"] = 11,
["COLOURS_F"] = 8,
["COLOURS_T"] = 9,
}

-- MULTIPLIER TO THE HEIGHT OF THE COLOUR PALETTE SELECTRION WINDOW
-- MODIFY WITH CARE
UI_HEIGHT_MULTIPLIER = "2.2"

-- NUMBER OF CURRENT VANILLA PALETTES
-- ONLY EDIT UPON VANILLA BASE BUILDING PALETTE UPDATES
CURRENT_VANILLA_COLOUR = 51

-- NUMBER OF CURRENT VANILLA UI PALLETE SLOTS
-- ONLY EDIT UPON VANILLA UI UPDATES
VANILLA_UI_SLOTS = 25

-- HARDCODED NUMBER OF MAXIMUM SLOTS
-- DO NOT ALTER
PALETTE_SLOTS_LIMIT = 64

-- NUMBER OF MAXIMUM PALETTE SLOTS PER LINE DICTATED BY UI FILES
-- DO NOT ALTER
UI_SINGLE_LINE = 7

-- SUB CANVAS EXTRA UI HEIGHT
-- DO NOT ALTER
UI_OUTER_SPACING = "17"

-- PRINT DEBUG TEXT
DEBUG_TEXT = false

-- EXML DATA BLOCKS
SPACING = [[
		<Property value="GcNGuiSpacingData.xml">
          <Property name="Data" value="GcNGuiElementData.xml">
            <Property name="ID" value="" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="5" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="50" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="True" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
        </Property>
]]
LINE_BREAK = [[
        <Property value="GcNGuiSpacingData.xml">
          <Property name="Data" value="GcNGuiElementData.xml">
            <Property name="ID" value="" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="5" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="5" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="True" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
        </Property>
        <Property value="GcNGuiSpacingData.xml">
          <Property name="Data" value="GcNGuiElementData.xml">
            <Property name="ID" value="" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="5" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="5" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="True" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
        </Property>
        <Property value="GcNGuiSpacingData.xml">
          <Property name="Data" value="GcNGuiElementData.xml">
            <Property name="ID" value="THIS ONE" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="7" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="12" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="False" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
        </Property>
        <Property value="GcNGuiSpacingData.xml">
          <Property name="Data" value="GcNGuiElementData.xml">
            <Property name="ID" value="" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="0" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="50" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="False" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
        </Property>
]]

-- FORCES ALL BASE OBJECT TO USE THE NOW-UNIFIED LEGACY PALETTE GROUP
PALETTE_GROUP_REPLACEMENT =
	{
		-- ["PRECEDING_KEY_WORDS"] = {"GcBaseBuildingEntry.xml"},
		-- ["VALUE_MATCH_OPTIONS"] = "~=",
		-- ["VALUE_MATCH"] = ".+",
		["REPLACE_TYPE"] = "ALL",
		["VALUE_CHANGE_TABLE"] = 
		{
			{"ColourPaletteGroupId", "LEGACY"}
		}
	}

DEFAULT_PALETTE_REPLACEMENT =
	{
		-- ["PRECEDING_KEY_WORDS"] = {"GcBaseBuildingEntry.xml"},
		-- ["VALUE_MATCH_OPTIONS"] = "~=",
		-- ["VALUE_MATCH"] = ".+",
		["REPLACE_TYPE"] = "ALL",
		["VALUE_CHANGE_TABLE"] = 
		{
			{"DefaultColourPaletteId", "LEGACY1"}
		}
	}

-- TRUNCATION
function trunc(x)
	return math.modf(x*1000)/1000
end

function GetBaseBuildingPalette(PRIMARY, SECONDARY, TERNARY, QUATERNARY, NAME, ID)
return [[
    <Property value="GcBaseBuildingPalette.xml">
      <Property name="PrimaryColour" value="Colour.xml">
        <Property name="R" value="]] .. PRIMARY["R"] .. [[" />
        <Property name="G" value="]] .. PRIMARY["G"] .. [[" />
        <Property name="B" value="]] .. PRIMARY["B"] .. [[" />
        <Property name="A" value="1" />
      </Property>
      <Property name="SecondaryColour" value="Colour.xml">
        <Property name="R" value="]] .. SECONDARY["R"] .. [[" />
        <Property name="G" value="]] .. SECONDARY["G"] .. [[" />
        <Property name="B" value="]] .. SECONDARY["B"] .. [[" />
        <Property name="A" value="1" />
      </Property>
      <Property name="TernaryColour" value="Colour.xml">
        <Property name="R" value="]] .. TERNARY["R"] .. [[" />
        <Property name="G" value="]] .. TERNARY["G"] .. [[" />
        <Property name="B" value="]] .. TERNARY["B"] .. [[" />
        <Property name="A" value="1" />
      </Property>
      <Property name="QuaternaryColour" value="Colour.xml">
        <Property name="R" value="]] .. QUATERNARY["R"] .. [[" />
        <Property name="G" value="]] .. QUATERNARY["G"] .. [[" />
        <Property name="B" value="]] .. QUATERNARY["B"] .. [[" />
        <Property name="A" value="1" />
      </Property>
      <Property name="Name" value="]] .. NAME .. [[" />
      <Property name="Id" value="]] .. ID .. [[" />
      <Property name="SwatchPrimaryColour" value="Primary" />
      <Property name="SwatchSecondaryColour" value="Secondary" />
    </Property>
]]
end

--[[function GetObjectPaletteGroupReplacement(FROM)
return
	{
		["PRECEDING_KEY_WORDS"] = {"GcBaseBuildingEntry.xml"},
		["VALUE_MATCH"] = FROM,
		["REPLACE_TYPE"] = "ALL",
		["VALUE_CHANGE_TABLE"] = 
		{
			{"ColourPaletteGroupId", "LEGACY"}
		}
	}
end]]

function GetPaletteGroupEntry(PALETTEGROUP, ADD)
return
	{
		["PRECEDING_KEY_WORDS"] = {"PaletteGroups"},
		["PRECEDING_FIRST"] = "TRUE",
		["SPECIAL_KEY_WORDS"] = {"Id", PALETTEGROUP},
		["LINE_OFFSET"] = "+1",
		["ADD"] = ADD
	}
end

-- EFFICIENCY IMPROVEMENTS COURTESY OF Wberto
function GetPaletteGroupEntry_ALT(ID)
return [[
		<Property value="NMSString0x20.xml">
		  <!--BUILDFRAME -->
		  <Property name="Value" value= "]] .. ID .. [["/>
		</Property>
]]
end

-- ADDING NEW PALETTES SO THAT THE LAST CUSTOM PALETTE IS THE PALETTE_SLOTS_LIMITth ONE
function GetYeetPaletteTable(WHERE, ADD)
return
	{
		["PRECEDING_KEY_WORDS"] = {"GcBaseBuildingPalette.xml"},
		["SECTION_ACTIVE"] = WHERE,
		["REPLACE_TYPE"] = "ADDafterSECTION",
		["ADD"] = ADD
	}
end

function GetPaletteUIData(NUM)
return [[
		<Property value="GcNGuiLayerData.xml">
          <Property name="ElementData" value="GcNGuiElementData.xml">
            <Property name="ID" value="OPTION]] .. NUM .. [[" />
            <Property name="PresetID" value="" />
            <Property name="IsHidden" value="False" />
            <Property name="Layout" value="GcNGuiLayoutData.xml">
              <Property name="PositionX" value="0" />
              <Property name="PositionY" value="0" />
              <Property name="Width" value="70" />
              <Property name="WidthPercentage" value="False" />
              <Property name="Height" value="50" />
              <Property name="HeightPercentage" value="False" />
              <Property name="ConstrainProportions" value="False" />
              <Property name="ConstrainAspect" value="1" />
              <Property name="ForceAspect" value="False" />
              <Property name="Anchor" value="False" />
              <Property name="AnchorPercent" value="False" />
              <Property name="SameLine" value="True" />
              <Property name="Align" value="TkNGuiAlignment.xml">
                <Property name="Vertical" value="Top" />
                <Property name="Horizontal" value="Left" />
              </Property>
              <Property name="SlowCursorOnHover" value="False" />
              <Property name="MaxWidth" value="0" />
              <Property name="VROverrides" />
              <Property name="AccessibleOverrides" />
            </Property>
          </Property>
          <Property name="Style" value="TkNGuiGraphicStyle.xml">
            <Property name="Default" value="TkNGuiGraphicStyleData.xml">
              <Property name="PaddingX" value="0" />
              <Property name="PaddingY" value="0" />
              <Property name="MarginX" value="0" />
              <Property name="MarginY" value="0" />
              <Property name="Colour" value="Colour.xml">
                <Property name="R" value="0.118" />
                <Property name="G" value="0.212" />
                <Property name="B" value="0.235" />
                <Property name="A" value="0" />
              </Property>
              <Property name="IconColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="StrokeColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="Shape" value="Rectangle" />
              <Property name="SolidColour" value="False" />
              <Property name="HasDropShadow" value="False" />
              <Property name="HasOuterGradient" value="False" />
              <Property name="HasInnerGradient" value="False" />
              <Property name="Gradient" value="None" />
              <Property name="GradientStartOffset" value="0" />
              <Property name="GradientEndOffset" value="0" />
              <Property name="GradientOffsetPercent" value="False" />
              <Property name="GradientColour" value="Colour.xml">
                <Property name="R" value="0" />
                <Property name="G" value="0" />
                <Property name="B" value="0" />
                <Property name="A" value="1" />
              </Property>
              <Property name="CornerRadius" value="0" />
              <Property name="StrokeSize" value="1" />
              <Property name="Image" value="0" />
              <Property name="Icon" value="0" />
              <Property name="StrokeGradient" value="True" />
              <Property name="StrokeGradientOffset" value="0" />
              <Property name="StrokeGradientFeather" value="0" />
              <Property name="StrokeGradientColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
            </Property>
            <Property name="Highlight" value="TkNGuiGraphicStyleData.xml">
              <Property name="PaddingX" value="0" />
              <Property name="PaddingY" value="0" />
              <Property name="MarginX" value="0" />
              <Property name="MarginY" value="0" />
              <Property name="Colour" value="Colour.xml">
                <Property name="R" value="0.118" />
                <Property name="G" value="0.212" />
                <Property name="B" value="0.235" />
                <Property name="A" value="0.6" />
              </Property>
              <Property name="IconColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="StrokeColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="Shape" value="Rectangle" />
              <Property name="SolidColour" value="False" />
              <Property name="HasDropShadow" value="False" />
              <Property name="HasOuterGradient" value="False" />
              <Property name="HasInnerGradient" value="False" />
              <Property name="Gradient" value="None" />
              <Property name="GradientStartOffset" value="0" />
              <Property name="GradientEndOffset" value="0" />
              <Property name="GradientOffsetPercent" value="False" />
              <Property name="GradientColour" value="Colour.xml">
                <Property name="R" value="0" />
                <Property name="G" value="0" />
                <Property name="B" value="0" />
                <Property name="A" value="1" />
              </Property>
              <Property name="CornerRadius" value="0" />
              <Property name="StrokeSize" value="1" />
              <Property name="Image" value="0" />
              <Property name="Icon" value="0" />
              <Property name="StrokeGradient" value="True" />
              <Property name="StrokeGradientOffset" value="0" />
              <Property name="StrokeGradientFeather" value="0" />
              <Property name="StrokeGradientColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
            </Property>
            <Property name="Active" value="TkNGuiGraphicStyleData.xml">
              <Property name="PaddingX" value="0" />
              <Property name="PaddingY" value="0" />
              <Property name="MarginX" value="0" />
              <Property name="MarginY" value="0" />
              <Property name="Colour" value="Colour.xml">
                <Property name="R" value="0.118" />
                <Property name="G" value="0.212" />
                <Property name="B" value="0.235" />
                <Property name="A" value="0" />
              </Property>
              <Property name="IconColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="StrokeColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
              <Property name="Shape" value="Rectangle" />
              <Property name="SolidColour" value="False" />
              <Property name="HasDropShadow" value="False" />
              <Property name="HasOuterGradient" value="False" />
              <Property name="HasInnerGradient" value="False" />
              <Property name="Gradient" value="None" />
              <Property name="GradientStartOffset" value="0" />
              <Property name="GradientEndOffset" value="0" />
              <Property name="GradientOffsetPercent" value="False" />
              <Property name="GradientColour" value="Colour.xml">
                <Property name="R" value="0" />
                <Property name="G" value="0" />
                <Property name="B" value="0" />
                <Property name="A" value="1" />
              </Property>
              <Property name="CornerRadius" value="0" />
              <Property name="StrokeSize" value="1" />
              <Property name="Image" value="0" />
              <Property name="Icon" value="0" />
              <Property name="StrokeGradient" value="True" />
              <Property name="StrokeGradientOffset" value="0" />
              <Property name="StrokeGradientFeather" value="0" />
              <Property name="StrokeGradientColour" value="Colour.xml">
                <Property name="R" value="1" />
                <Property name="G" value="1" />
                <Property name="B" value="1" />
                <Property name="A" value="1" />
              </Property>
            </Property>
            <Property name="InheritStyleFromParentLayer" value="False" />
            <Property name="HighlightTime" value="0.1" />
            <Property name="HighlightScale" value="1" />
            <Property name="GlobalFade" value="1" />
            <Property name="Animate" value="None" />
            <Property name="AnimTime" value="0.5" />
            <Property name="AnimSplit" value="0.4" />
            <Property name="AnimCurve1" value="TkCurveType.xml">
              <Property name="Curve" value="Linear" />
            </Property>
            <Property name="AnimCurve2" value="TkCurveType.xml">
              <Property name="Curve" value="Linear" />
            </Property>
            <Property name="CustomMinStart" value="Vector2f.xml">
              <Property name="x" value="1" />
              <Property name="y" value="1" />
            </Property>
            <Property name="CustomMaxStart" value="Vector2f.xml">
              <Property name="x" value="1" />
              <Property name="y" value="1" />
            </Property>
          </Property>
          <Property name="Image" value="" />
          <Property name="Children" />
          <Property name="DataFilename" value="UI/COMPONENTS/CHARCUSTOMISE/BUILDCOLOUROPTION.MBIN" />
          <Property name="AltMode" value="None" />
        </Property>
]]
end

MARVELLER = {}
CHANGE_LEOPARDON = {}
table.insert(MARVELLER, [[<!--BuildFrame-->
]])
PALETTE_GROUP_CHANGE_TABLE = {}
PALETTE_GROUP_ADD_TEXT = {}

-- PALETTE EXPANSION

-- INITIALISE THE TEXT TABLE TO BE INJECTED INTO CORRESPONDING VANILLA PALETTE GROUPS
-- EFFICIENCY IMPROVEMENTS COURTESY OF Wberto
for i,j in pairs(VANILLA_PALETTE_IDS) do
	if DEBUG_TEXT then print(j["Group"]) end
	PALETTE_GROUP_ADD_TEXT[j["Group"]] = {}
end

-- ADDING NEW PALETTES
for m,n in pairs(NEW_COLOURS_HEX) do
NEW_COLOURS = {}
CURRENT_VANILLA_COLOUR = CURRENT_VANILLA_COLOUR + 1
	-- RGB IN Vector3f FORMAT, TRUNCATED TO 3 DECIMAL PLACES
	for i,j in pairs(PALETTE_QUAD) do
		NEW_COLOUR_TEMP = {}
		for k,l in pairs(RGB) do
			-- CONVERTING 2 DIGITS OF THE HEX COLOUR INTO DECIMAL, DIVIDING BY 255 AND TRUNCATING TO 3 D.P
			NEW_COLOUR_TEMP[l] = trunc(tonumber(string.sub(n[j],((k-1)*2)+1,((k-1)*2)+2),16)/255)
			if DEBUG_TEXT then print(l .. [[ - ]] .. NEW_COLOUR_TEMP[l]) end
		end
		-- SETTING PRI/SEC/TER/QUA COLOURS ACCORDING TO PALETTE_QUAD
		NEW_COLOURS[j] = NEW_COLOUR_TEMP
	end
	table.insert(MARVELLER,GetBaseBuildingPalette(NEW_COLOURS["PrimaryColour"], NEW_COLOURS["SecondaryColour"], NEW_COLOURS["TernaryColour"], NEW_COLOURS["QuaternaryColour"], n["Name"], n["Id"]))
	for o,p in pairs(n["PaletteGroup"]) do
		table.insert(PALETTE_GROUP_ADD_TEXT[p], GetPaletteGroupEntry_ALT(n["Id"]))
	end
	-- CHECK TOTAL NUMBER OF PALETTES TO PREVENT VANILLA PALETTES DISAPPEARING FROM OVERFLOW
	if CURRENT_VANILLA_COLOUR == PALETTE_SLOTS_LIMIT and not YEET_VANILLA_PALETTES then break end
end

-- INJECTING ALL VANILLA PALETTES IN GROUPS OTHER THAN LEGACY INTO THE LEGACY GROUP
for i,j in pairs(VANILLA_PALETTE_IDS) do
	-- table.insert(CHANGE_LEOPARDON, GetObjectPaletteGroupReplacement(j["Group"]))
	if j["Group"] ~= "LEGACY" then
		for k,l in pairs(j["Palettes"]) do
			table.insert(PALETTE_GROUP_ADD_TEXT["LEGACY"], GetPaletteGroupEntry_ALT(l))
		end
	end
end

-- EFFICIENCY IMPROVEMENTS COURTESY OF Wberto
table.insert(CHANGE_LEOPARDON, PALETTE_GROUP_REPLACEMENT)
table.insert(CHANGE_LEOPARDON, DEFAULT_PALETTE_REPLACEMENT)
for i,j in pairs(VANILLA_PALETTE_IDS) do
	-- DOESN'T TRY TO MAKE AMUMSS DO NOTHING IF A PALETTE GROUP HAS NOTHING ADDED TO IT, REDUCES WARNINGS
	if #PALETTE_GROUP_ADD_TEXT[j["Group"]] > 0 then
		PALETTE_GROUP_CHANGE_TABLE[j["Group"]] = GetPaletteGroupEntry(j["Group"], table.concat(PALETTE_GROUP_ADD_TEXT[j["Group"]]))
	end
end

table.insert(MARVELLER, [[<!--BuildFrame End-->]])


-- UI EXPANSION
COLOUR_UI_ADD_TABLE = {}
table.insert(COLOUR_UI_ADD_TABLE, [[<!--BuildFrame-->]])
-- PLUS ONE TO AVOID ADDING THE LAST VANILLA ENTRY AGAIN
for i = VANILLA_UI_SLOTS + 1, PALETTE_SLOTS_LIMIT do
	-- ADD LINE BREAK EVERY "UI_SINGLE_LINE"TH UI ENTRY, ELSE ADD HORIZONTAL SPACING
	if (i - 1) % UI_SINGLE_LINE > 0 then
		table.insert(COLOUR_UI_ADD_TABLE, SPACING)
		else table.insert(COLOUR_UI_ADD_TABLE, LINE_BREAK)
	end
	-- MINUS 1 SINCE VANILLA ID STARTS WITH 0
	table.insert(COLOUR_UI_ADD_TABLE, GetPaletteUIData(i-1))
end
table.insert(COLOUR_UI_ADD_TABLE, [[<!--BuildFrame End-->]])
if DEBUG_TEXT then
	print(table.concat(COLOUR_UI_ADD_TABLE))
	print(#VANILLA_PALETTE_IDS["LEGACY"]["Palettes"])
end

table.insert(CHANGE_LEOPARDON, GetYeetPaletteTable(tostring(#VANILLA_PALETTE_IDS["LEGACY"]["Palettes"]), table.concat(MARVELLER)))

for i,j in pairs(PALETTE_GROUP_CHANGE_TABLE) do
	table.insert(CHANGE_LEOPARDON, j)
end

NMS_MOD_DEFINITION_CONTAINER = 
{
["MOD_FILENAME"] 			= "~~~SACS.pak",
["MOD_BATCHNAME"]			= "~~~~BuildFrame_Comp.pak",
["MOD_AUTHOR"]				= "WinderTP, Babscoole, Wberto",
["MOD_DESCRIPTION"]			= "Selection Augmentation for Colour System", -- AKA Palette Augmentation and Tailoring System (PAnTS)
["NMS_VERSION"]				= "",
["GLOBAL_INTEGER_TO_FLOAT"]	= "PRESERVE",
["MODIFICATIONS"] 			= 
	{
		{
			["MBIN_CHANGE_TABLE"] 	= 
			{ 
				{
					["MBIN_FILE_SOURCE"] 	= "METADATA\REALITY\TABLES\BASEBUILDINGOBJECTSTABLE.MBIN",
					["EXML_CHANGE_TABLE"] 	= CHANGE_LEOPARDON
				}, 
				{
					["MBIN_FILE_SOURCE"] 	= "UI\COMPONENTS\BUILDCOLOUR.MBIN",
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							-- ["PRECEDING_KEY_WORDS"] = {"GcNGuiLayerData.xml"},
							-- ["PRECEDING_FIRST"] = "TRUE",
							["SPECIAL_KEY_WORDS"] = {"ID", "OPTION" .. VANILLA_UI_SLOTS - 1}, -- MINUS 1 SINCE VANILLA ID STARTS WITH 0
							["SECTION_UP_SPECIAL"] = 1,
							["ADD_OPTION"] = "ADDafterSECTION",
							["ADD"] = table.concat(COLOUR_UI_ADD_TABLE)
						},
						{
							-- UI CANVAS FOR COLOUR SLOTS
							["SPECIAL_KEY_WORDS"] = {"ID", "COLOUR1", "Layout", "GcNGuiLayoutData.xml"},
							["REPLACE_TYPE"] = "",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", UI_HEIGHT_MULTIPLIER},
							},
						},
						--	NEXT 3 EDITS CHANGES THE SAME ENTRY
						{
							-- THIS SECTION IS A SUB CANVAS WITH EXTRA UNITS MORE HEIGHT
							-- THE EXTRA UNITS ARE FIRST TAKEN AWAY
							["PRECEDING_KEY_WORDS"] = { "Children", "GcNGuiLayerData.xml" }, 
							-- ["SECTION_ACTIVE"] = 1,
							["REPLACE_TYPE"] = "",
							["MATH_OPERATION"] = "-",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", UI_OUTER_SPACING},
							},
						},
						{
							-- THE MATCHED HEIGHT IS MULTIPLIED EQUALLY TO THE PARENT UI CANVAS
							["PRECEDING_KEY_WORDS"] = { "Children", "GcNGuiLayerData.xml" }, 
							-- ["SECTION_ACTIVE"] = 1,
							["REPLACE_TYPE"] = "",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", UI_HEIGHT_MULTIPLIER},
							},
						},
						{
							-- THE EXTRA UNITS ARE ADDED BACK AFTER MULTIPLICATION
							["PRECEDING_KEY_WORDS"] = { "Children", "GcNGuiLayerData.xml" }, 
							-- ["SECTION_ACTIVE"] = 1,
							["REPLACE_TYPE"] = "",
							["MATH_OPERATION"] = "+",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", UI_OUTER_SPACING},
							},
						},
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= "UI\BUILDCUSTOMISE.MBIN",
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							-- UI CANVAS FOR COLOUR SLOTS
							["SPECIAL_KEY_WORDS"] = {"ID", "COLOUR1", "Layout", "GcNGuiLayoutData.xml"},
							["REPLACE_TYPE"] = "",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", UI_HEIGHT_MULTIPLIER},
							},
						},
						{
							-- EXPANDS MAIN COLOUR/MATERIAL CUSTOMISATION CANVAS TO VERTICAL 90% OF SCREEN
							["SPECIAL_KEY_WORDS"] = {"ID", "CUSTOMISE", "Layout", "GcNGuiLayoutData.xml"},
							["REPLACE_TYPE"] = "",
							["VALUE_CHANGE_TABLE"] = 
							{ 
								{"Height", "90" },
							},
						},
					}
				},
			}
		}, 
	}	
}