-- Custom Stats for No Man's Sky - OVERKILL
-- Mod_Version = "0.1.1"

-- You can change the stats you want below
-- Default stats are indicated as comments next to the variables
-- HD means HyperDrive
-- Dmg means Damage
-- MT has been added in front of multitools variables to avoid conflicts with ships


-------------------------------
------ SHIPBASESTATSDATA ------
-------------------------------

--- ALIEN (LIVING) ---

AlienS_Ship_Max = "100" -- "1"
AlienS_Ship_Min = "100" -- "1"
AlienS_Dmg_Max = "100" -- "50"
AlienS_Dmg_Min = "100" -- "35"
AlienS_HD_Max = "100" -- "65"
AlienS_HD_Min = "100" -- "50"
AlienS_Shield_Max = "100" -- "25"
AlienS_Shield_Min = "100" -- "10"

--- DROPSHIP (HAULER) ---

DropshipC_Dmg_Max = "100" -- "0"
DropshipC_Dmg_Min = "100" -- "0"
DropshipC_HD_Max = "100" -- "5"
DropshipC_HD_Min = "100" -- "0"
DropshipC_Shield_Max = "100" -- "20"
DropshipC_Shield_Min = "100" -- "12"

DropshipB_Dmg_Max = "100" -- "5"
DropshipB_Dmg_Min = "100" -- "0"
DropshipB_HD_Max = "100" -- "10"
DropshipB_HD_Min = "100" -- "5"
DropshipB_Shield_Max = "100" -- "35"
DropshipB_Shield_Min = "100" -- "25"

DropshipA_Dmg_Max = "100" -- "10"
DropshipA_Dmg_Min = "100" -- "5"
DropshipA_HD_Max = "100" -- "25"
DropshipA_HD_Min = "100" -- "15"
DropshipA_Shield_Max = "100" -- "50"
DropshipA_Shield_Min = "100" -- "40"

DropshipS_Dmg_Max = "100" -- "20"
DropshipS_Dmg_Min = "100" -- "10"
DropshipS_HD_Max = "100" -- "35"
DropshipS_HD_Min = "100" -- "30"
DropshipS_Shield_Max = "100" -- "85"
DropshipS_Shield_Min = "100" -- "65"

--- FIGHTER ---

FighterC_Dmg_Max = "100" -- "10"
FighterC_Dmg_Min = "100" -- "5"
FighterC_HD_Max = "100" -- "0"
FighterC_HD_Min = "100" -- "0"
FighterC_Shield_Max = "100" -- "0"
FighterC_Shield_Min = "100" -- "0"

FighterB_Dmg_Max = "100" -- "30"
FighterB_Dmg_Min = "100" -- "15"
FighterB_HD_Max = "100" -- "0"
FighterB_HD_Min = "100" -- "0"
FighterB_Shield_Max = "100" -- "10"
FighterB_Shield_Min = "100" -- "5"

FighterA_Dmg_Max = "100" -- "50"
FighterA_Dmg_Min = "100" -- "35"
FighterA_HD_Max = "100" -- "0"
FighterA_HD_Min = "100" -- "0"
FighterA_Shield_Max = "100" -- "20"
FighterA_Shield_Min = "100" -- "15"

FighterS_Dmg_Max = "100" -- "60"
FighterS_Dmg_Min = "100" -- "55"
FighterS_HD_Max = "100" -- "0"
FighterS_HD_Min = "100" -- "0"
FighterS_Shield_Max = "100" -- "25"
FighterS_Shield_Min = "100" -- "15"

--- FREIGHTER (CARGO) ---

FreighterC_Fleet_Max = "100" -- "10"
FreighterC_Fleet_Min = "100" -- "1"
FreighterC_HD_Max = "100" -- "15"
FreighterC_HD_Min = "100" -- "7"

FreighterB_Fleet_Max = "100" -- "20"
FreighterB_Fleet_Min = "100" -- "10"
FreighterB_HD_Max = "100" -- "19"
FreighterB_HD_Min = "100" -- "10"

FreighterA_Fleet_Max = "100" -- "40"
FreighterA_Fleet_Min = "100" -- "20"
FreighterA_HD_Max = "100" -- "60"
FreighterA_HD_Min = "100" -- "40"

FreighterS_Fleet_Max = "100" -- "60"
FreighterS_Fleet_Min = "100" -- "40"
FreighterS_HD_Max = "100" -- "80"
FreighterS_HD_Min = "100" -- "60"

--- ROYAL (EXOTIC) ---

RoyalC_Dmg_Max = "100" -- "50"
RoyalC_Dmg_Min = "100" -- "35"
RoyalC_HD_Max = "100" -- "65"
RoyalC_HD_Min = "100" -- "50"
RoyalC_Shield_Max = "100" -- "60"
RoyalC_Shield_Min = "100" -- "55"

RoyalB_Dmg_Max = "100" -- "50"
RoyalB_Dmg_Min = "100" -- "35"
RoyalB_HD_Max = "100" -- "65"
RoyalB_HD_Min = "100" -- "50"
RoyalB_Shield_Max = "100" -- "60"
RoyalB_Shield_Min = "100" -- "55"

RoyalA_Dmg_Max = "100" -- "50"
RoyalA_Dmg_Min = "100" -- "35"
RoyalA_HD_Max = "100" -- "65"
RoyalA_HD_Min = "100" -- "50"
RoyalA_Shield_Max = "100" -- "60"
RoyalA_Shield_Min = "100" -- "55"

RoyalS_Dmg_Max = "100" -- "50"
RoyalS_Dmg_Min = "100" -- "35"
RoyalS_HD_Max = "100" -- "65"
RoyalS_HD_Min = "100" -- "50"
RoyalS_Shield_Max = "100" -- "60"
RoyalS_Shield_Min = "100" -- "55"

--- SAIL (SOLAR) ---

SailC_Dmg_Max = "100" -- "10"
SailC_Dmg_Min = "100" -- "5"
SailC_HD_Max = "100" -- "10"
SailC_HD_Min = "100" -- "5"
SailC_Shield_Max = "100" -- "10"
SailC_Shield_Min = "100" -- "5"

SailB_Dmg_Max = "100" -- "30"
SailB_Dmg_Min = "100" -- "15"
SailB_HD_Max = "100" -- "20"
SailB_HD_Min = "100" -- "10"
SailB_Shield_Max = "100" -- "20"
SailB_Shield_Min = "100" -- "5"

SailA_Dmg_Max = "100" -- "40"
SailA_Dmg_Min = "100" -- "30"
SailA_HD_Max = "100" -- "30"
SailA_HD_Min = "100" -- "20"
SailA_Shield_Max = "100" -- "25"
SailA_Shield_Min = "100" -- "15"

SailS_Dmg_Max = "100" -- "50"
SailS_Dmg_Min = "100" -- "40"
SailS_HD_Max = "100" -- "35"
SailS_HD_Min = "100" -- "25"
SailS_Shield_Max = "100" -- "35"
SailS_Shield_Min = "100" -- "15"

--- SCIENTIFIC (EXPLORER) ---

ScientificC_Dmg_Max = "100" -- "0"
ScientificC_Dmg_Min = "100" -- "0"
ScientificC_HD_Max = "100" -- "15"
ScientificC_HD_Min = "100" -- "7"
ScientificC_Shield_Max = "100" -- "0"
ScientificC_Shield_Min = "100" -- "0"

ScientificB_Dmg_Max = "100" -- "0"
ScientificB_Dmg_Min = "100" -- "0"
ScientificB_HD_Max = "100" -- "30"
ScientificB_HD_Min = "100" -- "20"
ScientificB_Shield_Max = "100" -- "8"
ScientificB_Shield_Min = "100" -- "0"

ScientificA_Dmg_Max = "100" -- "0"
ScientificA_Dmg_Min = "100" -- "0"
ScientificA_HD_Max = "100" -- "45"
ScientificA_HD_Min = "100" -- "35"
ScientificA_Shield_Max = "100" -- "15"
ScientificA_Shield_Min = "100" -- "10"

ScientificS_Dmg_Max = "100" -- "0"
ScientificS_Dmg_Min = "100" -- "0"
ScientificS_HD_Max = "100" -- "80"
ScientificS_HD_Min = "100" -- "60"
ScientificS_Shield_Max = "100" -- "25"
ScientificS_Shield_Min = "100" -- "20"

--- SHUTTLE ---

ShuttleC_Dmg_Max = "100" -- "0"
ShuttleC_Dmg_Min = "100" -- "0"
ShuttleC_HD_Max = "100" -- "0"
ShuttleC_HD_Min = "100" -- "0"
ShuttleC_Shield_Max = "100" -- "0"
ShuttleC_Shield_Min = "100" -- "0"

ShuttleB_Dmg_Max = "100" -- "5"
ShuttleB_Dmg_Min = "100" -- "0"
ShuttleB_HD_Max = "100" -- "5"
ShuttleB_HD_Min = "100" -- "0"
ShuttleB_Shield_Max = "100" -- "5"
ShuttleB_Shield_Min = "100" -- "0"

ShuttleA_Dmg_Max = "100" -- "10"
ShuttleA_Dmg_Min = "100" -- "5"
ShuttleA_HD_Max = "100" -- "10"
ShuttleA_HD_Min = "100" -- "5"
ShuttleA_Shield_Max = "100" -- "10"
ShuttleA_Shield_Min = "100" -- "5"

ShuttleS_Dmg_Max = "100" -- "20"
ShuttleS_Dmg_Min = "100" -- "15"
ShuttleS_HD_Max = "100" -- "20"
ShuttleS_HD_Min = "100" -- "15"
ShuttleS_Shield_Max = "100" -- "20"
ShuttleS_Shield_Min = "100" -- "15"

---------------------------------
------ WEAPONBASESTATSDATA ------
---------------------------------

--- ALIEN ---

MT_AlienC_Dmg_Max = "100" -- "15"
MT_AlienC_Dmg_Min = "100" -- "10"
MT_AlienC_Mining_Max = "100" -- "5"
MT_AlienC_Mining_Min = "100" -- "0"
MT_AlienC_Scan_Max = "100" -- "25"
MT_AlienC_Scan_Min = "100" -- "20"

MT_AlienB_Dmg_Max = "100" -- "20"
MT_AlienB_Dmg_Min = "100" -- "15"
MT_AlienB_Mining_Max = "100" -- "10"
MT_AlienB_Mining_Min = "100" -- "5"
MT_AlienB_Scan_Max = "100" -- "35"
MT_AlienB_Scan_Min = "100" -- "30"

MT_AlienA_Dmg_Max = "100" -- "25"
MT_AlienA_Dmg_Min = "100" -- "20"
MT_AlienA_Mining_Max = "100" -- "15"
MT_AlienA_Mining_Min = "100" -- "10"
MT_AlienA_Scan_Max = "100" -- "45"
MT_AlienA_Scan_Min = "100" -- "40"

MT_AlienS_Dmg_Max = "100" -- "35"
MT_AlienS_Dmg_Min = "100" -- "25"
MT_AlienS_Mining_Max = "100" -- "20"
MT_AlienS_Mining_Min = "100" -- "15"
MT_AlienS_Scan_Max = "100" -- "60"
MT_AlienS_Scan_Min = "100" -- "50"

--- PISTOL ---

MT_PistolC_Dmg_Max = "100" -- "0"
MT_PistolC_Dmg_Min = "100" -- "0"
MT_PistolC_Mining_Max = "100" -- "10"
MT_PistolC_Mining_Min = "100" -- "5"
MT_PistolC_Scan_Max = "100" -- "20"
MT_PistolC_Scan_Min = "100" -- "10"

MT_PistolB_Dmg_Max = "100" -- "0"
MT_PistolB_Dmg_Min = "100" -- "0"
MT_PistolB_Mining_Max = "100" -- "15"
MT_PistolB_Mining_Min = "100" -- "10"
MT_PistolB_Scan_Max = "100" -- "30"
MT_PistolB_Scan_Min = "100" -- "25"

MT_PistolA_Dmg_Max = "100" -- "0"
MT_PistolA_Dmg_Min = "100" -- "0"
MT_PistolA_Mining_Max = "100" -- "20"
MT_PistolA_Mining_Min = "100" -- "15"
MT_PistolA_Scan_Max = "100" -- "40"
MT_PistolA_Scan_Min = "100" -- "35"

MT_PistolS_Dmg_Max = "100" -- "0"
MT_PistolS_Dmg_Min = "100" -- "0"
MT_PistolS_Mining_Max = "100" -- "35"
MT_PistolS_Mining_Min = "100" -- "20"
MT_PistolS_Scan_Max = "100" -- "50"
MT_PistolS_Scan_Min = "100" -- "45"

--- PRISTINE ---

MT_PristineC_Dmg_Max = "100" -- "5"
MT_PristineC_Dmg_Min = "100" -- "0"
MT_PristineC_Mining_Max = "100" -- "10"
MT_PristineC_Mining_Min = "100" -- "5"
MT_PristineC_Scan_Max = "100" -- "50"
MT_PristineC_Scan_Min = "100" -- "40"

MT_PristineB_Dmg_Max = "100" -- "10"
MT_PristineB_Dmg_Min = "100" -- "5"
MT_PristineB_Mining_Max = "100" -- "20"
MT_PristineB_Mining_Min = "100" -- "10"
MT_PristineB_Scan_Max = "100" -- "70"
MT_PristineB_Scan_Min = "100" -- "60"

MT_PristineA_Dmg_Max = "100" -- "15"
MT_PristineA_Dmg_Min = "100" -- "10"
MT_PristineA_Mining_Max = "100" -- "25"
MT_PristineA_Mining_Min = "100" -- "20"
MT_PristineA_Scan_Max = "100" -- "90"
MT_PristineA_Scan_Min = "100" -- "80"

MT_PristineS_Dmg_Max = "100" -- "25"
MT_PristineS_Dmg_Min = "100" -- "15"
MT_PristineS_Mining_Max = "100" -- "30"
MT_PristineS_Mining_Min = "100" -- "25"
MT_PristineS_Scan_Max = "100" -- "100"
MT_PristineS_Scan_Min = "100" -- "100"

--- RIFLE ---

MT_RifleC_Dmg_Max = "100" -- "5"
MT_RifleC_Dmg_Min = "100" -- "0"
MT_RifleC_Mining_Max = "100" -- "0"
MT_RifleC_Mining_Min = "100" -- "0"
MT_RifleC_Scan_Max = "100" -- "5"
MT_RifleC_Scan_Min = "100" -- "0"

MT_RifleB_Dmg_Max = "100" -- "10"
MT_RifleB_Dmg_Min = "100" -- "5"
MT_RifleB_Mining_Max = "100" -- "0"
MT_RifleB_Mining_Min = "100" -- "0"
MT_RifleB_Scan_Max = "100" -- "10"
MT_RifleB_Scan_Min = "100" -- "5"

MT_RifleA_Dmg_Max = "100" -- "15"
MT_RifleA_Dmg_Min = "100" -- "10"
MT_RifleA_Mining_Max = "100" -- "0"
MT_RifleA_Mining_Min = "100" -- "0"
MT_RifleA_Scan_Max = "100" -- "15"
MT_RifleA_Scan_Min = "100" -- "10"

MT_RifleS_Dmg_Max = "100" -- "20"
MT_RifleS_Dmg_Min = "100" -- "15"
MT_RifleS_Mining_Max = "100" -- "0"
MT_RifleS_Mining_Min = "100" -- "0"
MT_RifleS_Scan_Max = "100" -- "20"
MT_RifleS_Scan_Min = "100" -- "15"

--- ROYAL ---

MT_RoyalC_Dmg_Max = "100" -- "5"
MT_RoyalC_Dmg_Min = "100" -- "0"
MT_RoyalC_Mining_Max = "100" -- "10"
MT_RoyalC_Mining_Min = "100" -- "5"
MT_RoyalC_Scan_Max = "100" -- "50"
MT_RoyalC_Scan_Min = "100" -- "40"

MT_RoyalB_Dmg_Max = "100" -- "10"
MT_RoyalB_Dmg_Min = "100" -- "5"
MT_RoyalB_Mining_Max = "100" -- "20"
MT_RoyalB_Mining_Min = "100" -- "10"
MT_RoyalB_Scan_Max = "100" -- "70"
MT_RoyalB_Scan_Min = "100" -- "60"

MT_RoyalA_Dmg_Max = "100" -- "15"
MT_RoyalA_Dmg_Min = "100" -- "10"
MT_RoyalA_Mining_Max = "100" -- "25"
MT_RoyalA_Mining_Min = "100" -- "20"
MT_RoyalA_Scan_Max = "100" -- "90"
MT_RoyalA_Scan_Min = "100" -- "80"

MT_RoyalS_Dmg_Max = "100" -- "25"
MT_RoyalS_Dmg_Min = "100" -- "15"
MT_RoyalS_Mining_Max = "100" -- "30"
MT_RoyalS_Mining_Min = "100" -- "25"
MT_RoyalS_Scan_Max = "100" -- "100"
MT_RoyalS_Scan_Min = "100" -- "100"


-- Don't change code past this line unless you know what you are doing. --

BaseStatChanges =
{
  {
  "ShipBaseStatsData",
    {
      {
      "Alien",
        {
          {
          "S",
            {
              {"ALIEN_SHIP",
                { AlienS_Ship_Max, AlienS_Ship_Min, }
              },
              {"SHIP_DAMAGE",
                { AlienS_Dmg_Max, AlienS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { AlienS_HD_Max, AlienS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { AlienS_Shield_Max, AlienS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Dropship",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { DropshipC_Dmg_Max, DropshipC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { DropshipC_HD_Max, DropshipC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { DropshipC_Shield_Max, DropshipC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { DropshipB_Dmg_Max, DropshipB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { DropshipB_HD_Max, DropshipB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { DropshipB_Shield_Max, DropshipB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { DropshipA_Dmg_Max, DropshipA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { DropshipA_HD_Max, DropshipA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { DropshipA_Shield_Max, DropshipA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { DropshipS_Dmg_Max, DropshipS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { DropshipS_HD_Max, DropshipS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { DropshipS_Shield_Max, DropshipS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Fighter",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { FighterC_Dmg_Max, FighterC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { FighterC_HD_Max, FighterC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { FighterC_Shield_Max, FighterC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { FighterB_Dmg_Max, FighterB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { FighterB_HD_Max, FighterB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { FighterB_Shield_Max, FighterB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { FighterA_Dmg_Max, FighterA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { FighterA_HD_Max, FighterA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { FighterA_Shield_Max, FighterA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { FighterS_Dmg_Max, FighterS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { FighterS_HD_Max, FighterS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { FighterS_Shield_Max, FighterS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Freighter",
        {
          {
          "C",
            {
              {"FREI_FLEET",
                { FreighterC_Fleet_Max, FreighterC_Fleet_Min, }
              },
              {"FREI_HYPERDRIVE",
                { FreighterC_HD_Max, FreighterC_HD_Min, }
              },
            }
          },
          {
          "B",
            {
              {"FREI_FLEET",
                { FreighterB_Fleet_Max, FreighterB_Fleet_Min, }
              },
              {"FREI_HYPERDRIVE",
                { FreighterB_HD_Max, FreighterB_HD_Min, }
              },
            }
          },
          {
          "A",
            {
              {"FREI_FLEET",
                { FreighterA_Fleet_Max, FreighterA_Fleet_Min, }
              },
              {"FREI_HYPERDRIVE",
                { FreighterA_HD_Max, FreighterA_HD_Min, }
              },
            }
          },
          {
          "S",
            {
              {"FREI_FLEET",
                { FreighterS_Fleet_Max, FreighterS_Fleet_Min, }
              },
              {"FREI_HYPERDRIVE",
                { FreighterS_HD_Max, FreighterS_HD_Min, }
              },
            }
          },
        }
      },
      {
      "Royal",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { RoyalC_Dmg_Max, RoyalC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { RoyalC_HD_Max, RoyalC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { RoyalC_Shield_Max, RoyalC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { RoyalB_Dmg_Max, RoyalB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { RoyalB_HD_Max, RoyalB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { RoyalB_Shield_Max, RoyalB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { RoyalA_Dmg_Max, RoyalA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { RoyalA_HD_Max, RoyalA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { RoyalA_Shield_Max, RoyalA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { RoyalS_Dmg_Max, RoyalS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { RoyalS_HD_Max, RoyalS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { RoyalS_Shield_Max, RoyalS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Sail",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { SailC_Dmg_Max, SailC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { SailC_HD_Max, SailC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { SailC_Shield_Max, SailC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { SailB_Dmg_Max, SailB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { SailB_HD_Max, SailB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { SailB_Shield_Max, SailB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { SailA_Dmg_Max, SailA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { SailA_HD_Max, SailA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { SailA_Shield_Max, SailA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { SailS_Dmg_Max, SailS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { SailS_HD_Max, SailS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { SailS_Shield_Max, SailS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Scientific",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { ScientificC_Dmg_Max, ScientificC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ScientificC_HD_Max, ScientificC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ScientificC_Shield_Max, ScientificC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { ScientificB_Dmg_Max, ScientificB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ScientificB_HD_Max, ScientificB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ScientificB_Shield_Max, ScientificB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { ScientificA_Dmg_Max, ScientificA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ScientificA_HD_Max, ScientificA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ScientificA_Shield_Max, ScientificA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { ScientificS_Dmg_Max, ScientificS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ScientificS_HD_Max, ScientificS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ScientificS_Shield_Max, ScientificS_Shield_Min, }
              },
            }
          },
        }
      },
      {
      "Shuttle",
        {
          {
          "C",
            {
              {"SHIP_DAMAGE",
                { ShuttleC_Dmg_Max, ShuttleC_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ShuttleC_HD_Max, ShuttleC_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ShuttleC_Shield_Max, ShuttleC_Shield_Min, }
              },
            }
          },
          {
          "B",
            {
              {"SHIP_DAMAGE",
                { ShuttleB_Dmg_Max, ShuttleB_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ShuttleB_HD_Max, ShuttleB_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ShuttleB_Shield_Max, ShuttleB_Shield_Min, }
              },
            }
          },
          {
          "A",
            {
              {"SHIP_DAMAGE",
                { ShuttleA_Dmg_Max, ShuttleA_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ShuttleA_HD_Max, ShuttleA_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ShuttleA_Shield_Max, ShuttleA_Shield_Min, }
              },
            }
          },
          {
          "S",
            {
              {"SHIP_DAMAGE",
                { ShuttleS_Dmg_Max, ShuttleS_Dmg_Min, }
              },
              {"SHIP_HYPERDRIVE",
                { ShuttleS_HD_Max, ShuttleS_HD_Min, }
              },
              {"SHIP_SHIELD",
                { ShuttleS_Shield_Max, ShuttleS_Shield_Min, }
              },
            }
          },
        }
      },
    }
  },
  {
  "WeaponBaseStatsData",
    {
      {
      "Alien",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienC_Dmg_Max, MT_AlienC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienC_Mining_Max, MT_AlienC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienC_Scan_Max, MT_AlienC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienB_Dmg_Max, MT_AlienB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienB_Mining_Max, MT_AlienB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienB_Scan_Max, MT_AlienB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienA_Dmg_Max, MT_AlienA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienA_Mining_Max, MT_AlienA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienA_Scan_Max, MT_AlienA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienS_Dmg_Max, MT_AlienS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienS_Mining_Max, MT_AlienS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienS_Scan_Max, MT_AlienS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Pistol",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolC_Dmg_Max, MT_PistolC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolC_Mining_Max, MT_PistolC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolC_Scan_Max, MT_PistolC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolB_Dmg_Max, MT_PistolB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolB_Mining_Max, MT_PistolB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolB_Scan_Max, MT_PistolB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolA_Dmg_Max, MT_PistolA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolA_Mining_Max, MT_PistolA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolA_Scan_Max, MT_PistolA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolS_Dmg_Max, MT_PistolS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolS_Mining_Max, MT_PistolS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolS_Scan_Max, MT_PistolS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Pristine",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineC_Dmg_Max, MT_PristineC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineC_Mining_Max, MT_PristineC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineC_Scan_Max, MT_PristineC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineB_Dmg_Max, MT_PristineB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineB_Mining_Max, MT_PristineB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineB_Scan_Max, MT_PristineB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineA_Dmg_Max, MT_PristineA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineA_Mining_Max, MT_PristineA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineA_Scan_Max, MT_PristineA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineS_Dmg_Max, MT_PristineS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineS_Mining_Max, MT_PristineS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineS_Scan_Max, MT_PristineS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Rifle",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleC_Dmg_Max, MT_RifleC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleC_Mining_Max, MT_RifleC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleC_Scan_Max, MT_RifleC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleB_Dmg_Max, MT_RifleB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleB_Mining_Max, MT_RifleB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleB_Scan_Max, MT_RifleB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleA_Dmg_Max, MT_RifleA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleA_Mining_Max, MT_RifleA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleA_Scan_Max, MT_RifleA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleS_Dmg_Max, MT_RifleS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleS_Mining_Max, MT_RifleS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleS_Scan_Max, MT_RifleS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Royal",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalC_Dmg_Max, MT_RoyalC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalC_Mining_Max, MT_RoyalC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalC_Scan_Max, MT_RoyalC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalB_Dmg_Max, MT_RoyalB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalB_Mining_Max, MT_RoyalB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalB_Scan_Max, MT_RoyalB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalA_Dmg_Max, MT_RoyalA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalA_Mining_Max, MT_RoyalA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalA_Scan_Max, MT_RoyalA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalS_Dmg_Max, MT_RoyalS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalS_Mining_Max, MT_RoyalS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalS_Scan_Max, MT_RoyalS_Scan_Min, }
              },
            }
          },
        }
      },
    }
  },
}


-- File Settings --
FileName    = "CustomStats_0.1.1_OVERKILL.pak"
ModAuthor   = "Elsia"
LuaAuthor   = "Elsia"
ModMaintenance = "Probably Elsia"
Description = "Change base stats for freighters, ships and multitools, too much."
NMS_Version = "3.99"


-- File Source --
FileSource1 = "METADATA/REALITY/TABLES/INVENTORYTABLE.MBIN"

NMS_MOD_DEFINITION_CONTAINER = 
{
  ["MOD_FILENAME"]    = FileName,
  ["MOD_AUTHOR"]      = ModAuthor,
  ["LUA_AUTHOR"]      = LuaAuthor,
  ["MOD_MAINTENANCE"] = ModMaintenance,
  ["MOD_DESCRIPTION"] = Description,
  ["NMS_VERSION"]     = NMS_Version,
  ["MODIFICATIONS"]   =
  {
    {
      ["MBIN_CHANGE_TABLE"] = 
      { 
        {
          ["MBIN_FILE_SOURCE"]  = FileSource1,
          ["EXML_CHANGE_TABLE"] = 
          {
            -- InventoryTable
          }
        },
      }
    },
  }
}

local InventoryTable = NMS_MOD_DEFINITION_CONTAINER["MODIFICATIONS"][1]["MBIN_CHANGE_TABLE"][1]["EXML_CHANGE_TABLE"]

for i = 1, #BaseStatChanges do
  local Category = BaseStatChanges[i][2]
  for j = 1, #Category do
    local ObjectType = Category[j][1]
    local ObjectStat = Category[j][2]
    for k = 1, #ObjectStat do
      local ObjectClass = ObjectStat[k][1]
      local Change = ObjectStat[k][2]
      for l = 1, #Change do
        local StatID = Change[l][1]
        local Min = Change[l][2][1]
        local Max = Change[l][2][2]

        InventoryTable[#InventoryTable+1] =
        {
          ["SPECIAL_KEY_WORDS"]  = {ObjectType, "GcInventoryGenerationBaseStatData.xml", ObjectClass, "GcInventoryGenerationBaseStatClassData.xml", "BaseStatID", StatID},
          ["VALUE_CHANGE_TABLE"] = 
          {
            {"Min", Min},
            {"Max", Max}
          }
        }

      end
    end
  end
end