#pragma once

// Generated Thu, 30 Jun 2022 00:40:49 GMT
// https://alloc8or.re/rdr3/nativedb/

#include "types.h"
#include "Invoker.h"

using namespace Invoker;

#define NATIVE_DECL __forceinline

namespace BUILTIN
{
	NATIVE_DECL void WAIT(int ms) { invoke<Void>(0x4EDE34FBADD967A6, ms); } // 0x4EDE34FBADD967A6 0x7715C03B b1207
	// Counts up. Every 1000 is 1 real-time second. Use SETTIMERA(int value) to set the timer (e.g.: SETTIMERA(0)).
	NATIVE_DECL int TIMERA() { return invoke<int>(0x83666F9FB8FEBD4B); } // 0x83666F9FB8FEBD4B 0x45C8C188 b1207
	NATIVE_DECL int TIMERB() { return invoke<int>(0xC9D9444186B5A374); } // 0xC9D9444186B5A374 0x330A9C0C b1207
	NATIVE_DECL void SETTIMERA(int value) { invoke<Void>(0xC1B1E9A034A63A62, value); } // 0xC1B1E9A034A63A62 0x35785333 b1207
	NATIVE_DECL void SETTIMERB(int value) { invoke<Void>(0x5AE11BC36633DE4E, value); } // 0x5AE11BC36633DE4E 0x27C1B7C6 b1207
	// Gets the current frame time.
	NATIVE_DECL float TIMESTEP() { return invoke<float>(0x0000000050597EE2); } // 0x0000000050597EE2 0x50597EE2 b1207
	NATIVE_DECL float SIN(float value) { return invoke<float>(0x0BADBFA3B172435F, value); } // 0x0BADBFA3B172435F 0xBF987F58 b1207
	NATIVE_DECL float COS(float value) { return invoke<float>(0xD0FFB162F40A139C, value); } // 0xD0FFB162F40A139C 0x00238FE9 b1207
	NATIVE_DECL float SQRT(float value) { return invoke<float>(0x71D93B57D07F9804, value); } // 0x71D93B57D07F9804 0x145C7701 b1207
	NATIVE_DECL float POW(float base, float exponent) { return invoke<float>(0xE3621CC40F31FE2E, base, exponent); } // 0xE3621CC40F31FE2E 0x85D134F8 b1207
	NATIVE_DECL float _LOG10(float value) { return invoke<float>(0xE816E655DE37FE20, value); } // 0xE816E655DE37FE20 b1232
	// Calculates the magnitude of a vector.
	NATIVE_DECL float VMAG(float x, float y, float z) { return invoke<float>(0x652D2EEEF1D3E62C, x, y, z); } // 0x652D2EEEF1D3E62C 0x1FCF1ECD b1207
	NATIVE_DECL float VMAG(Vector3 vec) { return invoke<float>(0x652D2EEEF1D3E62C, vec.x, vec.y, vec.z); } // 0x652D2EEEF1D3E62C 0x1FCF1ECD b1207
	// Calculates the magnitude of a vector but does not perform Sqrt operations. (Its way faster)
	NATIVE_DECL float VMAG2(float x, float y, float z) { return invoke<float>(0xA8CEACB4F35AE058, x, y, z); } // 0xA8CEACB4F35AE058 0xE796E629 b1207
	NATIVE_DECL float VMAG2(Vector3 vec) { return invoke<float>(0xA8CEACB4F35AE058, vec.x, vec.y, vec.z); } // 0xA8CEACB4F35AE058 0xE796E629 b1207
	// Calculates distance between vectors.
	NATIVE_DECL float VDIST(float x1, float y1, float z1, float x2, float y2, float z2) { return invoke<float>(0x2A488C176D52CCA5, x1, y1, z1, x2, y2, z2); } // 0x2A488C176D52CCA5 0x3C08ECB7 b1207
	NATIVE_DECL float VDIST(Vector3 vec1, Vector3 vec2) { return invoke<float>(0x2A488C176D52CCA5, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0x2A488C176D52CCA5 0x3C08ECB7 b1207
	// Calculates distance between vectors but does not perform Sqrt operations. (Its way faster)
	NATIVE_DECL float VDIST2(float x1, float y1, float z1, float x2, float y2, float z2) { return invoke<float>(0xB7A628320EFF8E47, x1, y1, z1, x2, y2, z2); } // 0xB7A628320EFF8E47 0xC85DEF1F b1207
	NATIVE_DECL float VDIST2(Vector3 vec1, Vector3 vec2) { return invoke<float>(0xB7A628320EFF8E47, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0xB7A628320EFF8E47 0xC85DEF1F b1207
	NATIVE_DECL int SHIFT_LEFT(int value, int bitShift) { return invoke<int>(0xEDD95A39E5544DE8, value, bitShift); } // 0xEDD95A39E5544DE8 0x314CC6CD b1207
	NATIVE_DECL int SHIFT_RIGHT(int value, int bitShift) { return invoke<int>(0x97EF1E5BCE9DC075, value, bitShift); } // 0x97EF1E5BCE9DC075 0x352633CA b1207
	// Rounds a float value down to the next whole number
	NATIVE_DECL int FLOOR(float value) { return invoke<int>(0xF34EE736CF047844, value); } // 0xF34EE736CF047844 0x32E9BE04 b1207
	// Rounds a float value up to the next whole number
	NATIVE_DECL int CEIL(float value) { return invoke<int>(0x11E019C8F43ACC8A, value); } // 0x11E019C8F43ACC8A 0xD536A1DF b1207
	NATIVE_DECL int ROUND(float value) { return invoke<int>(0xF2DB717A73826179, value); } // 0xF2DB717A73826179 0x323B0E24 b1207
	NATIVE_DECL float TO_FLOAT(int value) { return invoke<float>(0xBBDA792448DB5A89, value); } // 0xBBDA792448DB5A89 0x67116627 b1207
	// 0 = high
	// 1 = normal
	// 2 = low
	NATIVE_DECL void SET_THREAD_PRIORITY(int priority) { invoke<Void>(0x42B65DEEF2EDF2A1, priority); } // 0x42B65DEEF2EDF2A1 b1207
}

namespace AICOVERPOINT
{
	NATIVE_DECL Entity _0x53E4D0C079CA6855(ScrHandle handle) { return invoke<Entity>(0x53E4D0C079CA6855, handle); } // 0x53E4D0C079CA6855 b1207
	NATIVE_DECL BOOL _DOES_COVER_POINT_EXIST(ScrHandle handle) { return invoke<BOOL>(0xC276FE69DDA22BAD, handle); } // 0xC276FE69DDA22BAD b1207
	NATIVE_DECL int _0x5F5B1B7E8E8F94C6(Ped ped) { return invoke<int>(0x5F5B1B7E8E8F94C6, ped); } // 0x5F5B1B7E8E8F94C6 b1207
	NATIVE_DECL void TASK_ENTER_COVER(Ped ped) { invoke<Void>(0x4972A022AE6DAFA1, ped); } // 0x4972A022AE6DAFA1 b1207
	NATIVE_DECL void TASK_EXIT_COVER(Ped ped) { invoke<Void>(0x2BC4A6D92D140112, ped); } // 0x2BC4A6D92D140112 b1207
	NATIVE_DECL int _0x957D7E750216D74B(Ped ped) { return invoke<int>(0x957D7E750216D74B, ped); } // 0x957D7E750216D74B b1207
	NATIVE_DECL void _0x89783FDDF079C88D(Any p0) { invoke<Void>(0x89783FDDF079C88D, p0); } // 0x89783FDDF079C88D b1207
	// coverLayer: see levels_0/levels/rdr3/coverlayers
	NATIVE_DECL void _0x64340DC208D671D5(const char* coverLayer) { invoke<Void>(0x64340DC208D671D5, coverLayer); } // 0x64340DC208D671D5 b1207
	// coverLayer: see levels_0/levels/rdr3/coverlayers
	NATIVE_DECL void _0x7A1FDCF35EAA140F(const char* coverLayer) { invoke<Void>(0x7A1FDCF35EAA140F, coverLayer); } // 0x7A1FDCF35EAA140F b1207
	// Makes ped flinch (if in cover) like they have been shot at
	NATIVE_DECL void _0x2A31D13C5F021D0D(Ped ped) { invoke<Void>(0x2A31D13C5F021D0D, ped); } // 0x2A31D13C5F021D0D b1207
	NATIVE_DECL void _0x3C7A9C2C953128FE(Ped ped) { invoke<Void>(0x3C7A9C2C953128FE, ped); } // 0x3C7A9C2C953128FE b1207
	NATIVE_DECL void _0xEBA51A294C73292E(Any* args) { invoke<Void>(0xEBA51A294C73292E, args); } // 0xEBA51A294C73292E b1207
	// weaponHash can also be -1
	NATIVE_DECL void _0x140B3CB1D424A945(Ped ped, Hash weaponHash) { invoke<Void>(0x140B3CB1D424A945, ped, weaponHash); } // 0x140B3CB1D424A945 b1207
	NATIVE_DECL BOOL _0x8CBE916CFC64AD5C(Ped ped) { return invoke<BOOL>(0x8CBE916CFC64AD5C, ped); } // 0x8CBE916CFC64AD5C b1207
	NATIVE_DECL void _0x1A7A802B2301EDC0(Ped ped) { invoke<Void>(0x1A7A802B2301EDC0, ped); } // 0x1A7A802B2301EDC0 b1207
	NATIVE_DECL void _0x733077295AB51304(Any p0) { invoke<Void>(0x733077295AB51304, p0); } // 0x733077295AB51304 b1207
	NATIVE_DECL ScrHandle _ADD_SCRIPTED_COVER_POINT(Any* data) { return invoke<ScrHandle>(0x975BD6351648935F, data); } // 0x975BD6351648935F b1207
}

namespace AITRANSPORT
{
	NATIVE_DECL void TASK_ENTER_TRANSPORT(Any* args) { invoke<Void>(0xAEE3ADD08829CB6F, args); } // 0xAEE3ADD08829CB6F b1207
	NATIVE_DECL void TASK_EXIT_TRANSPORT(Any* args) { invoke<Void>(0xC273A5B8488F7838, args); } // 0xC273A5B8488F7838 b1207
	// seat: see CREATE_PED_INSIDE_VEHICLE
	NATIVE_DECL void SET_PED_ON_TRANSPORT_SEAT(Ped ped, Entity transportEntity, int seat, int flags) { invoke<Void>(0xE588B5A8A005CB5E, ped, transportEntity, seat, flags); } // 0xE588B5A8A005CB5E b1207
	NATIVE_DECL void SET_PED_OFF_TRANSPORT_SEAT(Ped ped, int flags) { invoke<Void>(0x8886D83A430537FD, ped, flags); } // 0x8886D83A430537FD b1207
	// flagId:
	// enum eTransportConfigFlags
	// {
	// 	TCF_NotConsideredForEntryByLocalPlayer,
	// 	TCF_0xB78D6624,
	// 	TCF_0xA9700425,
	// 	TCF_0x8D7E4641,
	// 	TCF_0xF24BAA1F,
	// 	TCF_0x63B77935,
	// 	TCF_NotConsideredForEntryByAllPlayers,
	// 	TCF_0xD17A2AFD,
	// 	TCF_0xD4E4FDD5,
	// 	TCF_0x8227C929,
	// 	TCF_0x812C1070,
	// 	TCF_0x0E1AB26F,
	// 	TCF_0xBF4EC863,
	// 	TCF_0x75660C36,
	// 	TCF_0xA2539E20,
	// 	TCF_0x9162C633,
	// 	TCF_DisableHonorModifiers,
	// 	TCF_0xF9E71CB6,
	// 	TCF_0x933ECD3F,
	// 	TCF_0x18513A34
	// };
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/TRANSPORT_CONFIG_FLAGS
	NATIVE_DECL void SET_TRANSPORT_CONFIG_FLAG(Entity transportEntity, int flagId, BOOL value) { invoke<Void>(0xBA8818212633500A, transportEntity, flagId, value); } // 0xBA8818212633500A b1207
	// flagId: see SET_TRANSPORT_CONFIG_FLAG
	NATIVE_DECL BOOL GET_TRANSPORT_CONFIG_FLAG(Entity transportEntity, int flagId, BOOL p2) { return invoke<BOOL>(0xF382C92CCC1CCDBC, transportEntity, flagId, p2); } // 0xF382C92CCC1CCDBC b1207
	// See _SET_TRANSPORT_USAGE_FLAGS
	NATIVE_DECL Any _GET_TRANSPORT_USAGE_FLAGS(Entity transportEntity, int* flags) { return invoke<Any>(0xE195C5A82156321D, transportEntity, flags); } // 0xE195C5A82156321D b1207
	// enum eTransportUsageFlags
	// {
	// 	TUF_INVALID = 0,
	// 	TUF_ALLOW_DRIVER_ME = (1 << 0),
	// 	TUF_ALLOW_DRIVER_GANG = (1 << 1),
	// 	TUF_ALLOW_DRIVER_CREW = (1 << 2),
	// 	TUF_ALLOW_DRIVER_FRIENDS = (1 << 3),
	// 	TUF_ALLOW_DRIVER_ANYONE = (1 << 4),
	// 	TUF_ALLOW_PASSENGER_ME = (1 << 5),
	// 	TUF_ALLOW_PASSENGER_GANG = (1 << 6),
	// 	TUF_ALLOW_PASSENGER_CREW = (1 << 7),
	// 	TUF_ALLOW_PASSENGER_FRIENDS = (1 << 8),
	// 	TUF_ALLOW_PASSENGER_ANYONE = (1 << 9),
	// 	TUF_ALLOW_ACCESS_AI = (1 << 10)
	// };
	NATIVE_DECL void _SET_TRANSPORT_USAGE_FLAGS(Entity transportEntity, int flags) { invoke<Void>(0xE2487779957FE897, transportEntity, flags); } // 0xE2487779957FE897 b1207
	NATIVE_DECL void SET_TRANSPORT_ACCESSIBLE_SEAT_FLAGS(Entity transportEntity, int flags) { invoke<Void>(0xDD0660C997DE94FD, transportEntity, flags); } // 0xDD0660C997DE94FD b1207
	NATIVE_DECL void _0x4B6C9A43F7D9109B(Any p0, Any p1) { invoke<Void>(0x4B6C9A43F7D9109B, p0, p1); } // 0x4B6C9A43F7D9109B b1207
	// Checks if ped is placed on target transportEntity
	NATIVE_DECL BOOL _IS_PED_ON_TRANSPORT_ENTITY(Ped ped, Entity transportEntity) { return invoke<BOOL>(0x159EF5B6EDCE00E8, ped, transportEntity); } // 0x159EF5B6EDCE00E8 b1207
	NATIVE_DECL BOOL _IS_PED_ON_TRANSPORT_SEAT(Ped ped, BOOL p1) { return invoke<BOOL>(0xDC44F405A6B98D03, ped, p1); } // 0xDC44F405A6B98D03 b1207
	NATIVE_DECL BOOL _IS_TRANSPORT_SEAT_OCCUPIED(Entity transportEntity, int seatIndex) { return invoke<BOOL>(0x2E2E06023D07631E, transportEntity, seatIndex); } // 0x2E2E06023D07631E b1207
	// Called together with IS_VEHICLE_SEAT_FREE
	NATIVE_DECL BOOL _0x43FF27FC1829C202(Entity transportEntity, int seatIndex) { return invoke<BOOL>(0x43FF27FC1829C202, transportEntity, seatIndex); } // 0x43FF27FC1829C202 b1207
	// seatIndex: see CREATE_PED_INSIDE_VEHICLE
	NATIVE_DECL Ped _GET_PED_IN_TRANSPORT_SEAT(Entity transportEntity, int seatIndex) { return invoke<Ped>(0xFFEC4B0A1A3ED515, transportEntity, seatIndex); } // 0xFFEC4B0A1A3ED515 b1207
	NATIVE_DECL BOOL IS_PED_ENTERING_TRANSPORT(Ped ped, Entity transportEntity, BOOL p2) { return invoke<BOOL>(0x619E63980BFC0096, ped, transportEntity, p2); } // 0x619E63980BFC0096 b1207
	NATIVE_DECL BOOL IS_PED_EXITING_TRANSPORT(Ped ped, Entity transportEntity) { return invoke<BOOL>(0x660639BC60157048, ped, transportEntity); } // 0x660639BC60157048 b1207
	// _SET_TRANSPORT_*
	NATIVE_DECL void _0x4248AB2EEB3C75AD(Entity transportEntity, Ped ped, BOOL p2) { invoke<Void>(0x4248AB2EEB3C75AD, transportEntity, ped, p2); } // 0x4248AB2EEB3C75AD b1207
	NATIVE_DECL void _SET_PED_USE_TRANSPORT_SEAT_PREFERENCE(Ped ped, Entity transportEntity, int preferenceSlot, int p3, int seatIndex) { invoke<Void>(0xB7079F4C72896756, ped, transportEntity, preferenceSlot, p3, seatIndex); } // 0xB7079F4C72896756 b1207
	// _CLEAR_A*
	NATIVE_DECL void _0x5639FBEA922788DA(Entity transportEntity) { invoke<Void>(0x5639FBEA922788DA, transportEntity); } // 0x5639FBEA922788DA b1207
	NATIVE_DECL void _0x67F7CEAC2391E114(Entity transportEntity, BOOL p1) { invoke<Void>(0x67F7CEAC2391E114, transportEntity, p1); } // 0x67F7CEAC2391E114 b1207
	// _SET_TRANSPORT_*
	NATIVE_DECL void _0x8C8371EDFAF014A0(Ped ped, float p1) { invoke<Void>(0x8C8371EDFAF014A0, ped, p1); } // 0x8C8371EDFAF014A0 b1207
	// _SET_TRANSPORT_*
	NATIVE_DECL void _0xF8C20282B237E3F7(Ped ped) { invoke<Void>(0xF8C20282B237E3F7, ped); } // 0xF8C20282B237E3F7 b1207
	// _SET_TRANSPORT_*
	NATIVE_DECL void _0x13F138225C202F66(Entity transportEntity, int p1) { invoke<Void>(0x13F138225C202F66, transportEntity, p1); } // 0x13F138225C202F66 b1207
}

namespace ANIMSCENE
{
	// flags: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/_CREATE_ANIM_SCENE/README.md
	NATIVE_DECL AnimScene _CREATE_ANIM_SCENE(const char* animDict, int flags, const char* playbackListName, BOOL p3, BOOL p4) { return invoke<AnimScene>(0x1FCA98E33C1437B3, animDict, flags, playbackListName, p3, p4); } // 0x1FCA98E33C1437B3 b1207
	NATIVE_DECL void _DELETE_ANIM_SCENE(AnimScene animScene) { invoke<Void>(0x84EEDB2C6E650000, animScene); } // 0x84EEDB2C6E650000 b1207
	NATIVE_DECL void TRIGGER_ANIM_SCENE_SKIP(AnimScene animScene) { invoke<Void>(0x4B85B3CF9197AEDF, animScene); } // 0x4B85B3CF9197AEDF b1207
	// Used in Script Function CUTSCENE_MANAGE_SKIP
	// _CHECK_* (?)
	NATIVE_DECL BOOL _0x4B85B3CF91972222(AnimScene animScene) { return invoke<BOOL>(0x4B85B3CF91972222, animScene); } // 0x4B85B3CF91972222 b1207
	NATIVE_DECL void _CLEAR_ANIM_SCENE_WAS_SKIPPED(AnimScene animScene) { invoke<Void>(0x8A8208AE92BF87A5, animScene); } // 0x8A8208AE92BF87A5 b1207
	NATIVE_DECL BOOL DOES_ANIM_SCENE_EXIST(AnimScene animScene) { return invoke<BOOL>(0x25557E324489393C, animScene); } // 0x25557E324489393C b1207
	NATIVE_DECL BOOL _DOES_ENTITY_WITH_ID_EXIST_IN_ANIM_SCENE(AnimScene animScene, const char* entityId) { return invoke<BOOL>(0x6F1F0B17109309DA, animScene, entityId); } // 0x6F1F0B17109309DA b1207
	NATIVE_DECL BOOL _DOES_ANIM_SCENE_OWNERSHIP_OF_ENTITY_EXIST(AnimScene animScene, const char* entityName) { return invoke<BOOL>(0x9D1ECA9337BE9FC3, animScene, entityName); } // 0x9D1ECA9337BE9FC3 b1207
	NATIVE_DECL void LOAD_ANIM_SCENE(AnimScene animScene) { invoke<Void>(0xAF068580194D9DC7, animScene); } // 0xAF068580194D9DC7 b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_LOADED(AnimScene animScene, BOOL p1, BOOL p2) { return invoke<BOOL>(0x477122B8D05E7968, animScene, p1, p2); } // 0x477122B8D05E7968 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_LOADING(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0x59606519FF9D3EC2, animScene, p1); } // 0x59606519FF9D3EC2 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_METADATA_ASSET_IN_RANGE_LOADING(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0xF8D1D2DAB6007EEF, animScene, p1); } // 0xF8D1D2DAB6007EEF b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_METADATA_LOADED(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0x95531A4A20CCE7BC, animScene, p1); } // 0x95531A4A20CCE7BC b1207
	NATIVE_DECL int _GET_ANIM_SCENE_PLAYBACK_LIST_PHASE_AUDIO_LOAD_STRESS(AnimScene animScene, const char* phaseName) { return invoke<int>(0x9E036D5204FFBBC8, animScene, phaseName); } // 0x9E036D5204FFBBC8 b1207
	NATIVE_DECL void START_ANIM_SCENE(AnimScene animScene) { invoke<Void>(0xF4D94AF761768700, animScene); } // 0xF4D94AF761768700 b1207
	NATIVE_DECL void RESET_ANIM_SCENE(AnimScene animScene, const char* playbackListName) { invoke<Void>(0x8FDF221F13537936, animScene, playbackListName); } // 0x8FDF221F13537936 b1207
	NATIVE_DECL void ABORT_ANIM_SCENE(AnimScene animScene, BOOL p1) { invoke<Void>(0x718CF1328D20C2B3, animScene, p1); } // 0x718CF1328D20C2B3 b1207
	NATIVE_DECL void RESUME_ANIM_SCENE_FROM_LAST_CHECKPOINT(AnimScene animScene) { invoke<Void>(0x8E1BA705F63C1925, animScene); } // 0x8E1BA705F63C1925 b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_RUNNING(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0xCBFC7725DE6CE2E0, animScene, p1); } // 0xCBFC7725DE6CE2E0 b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_FINISHED(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0xD8254CB2C586412B, animScene, p1); } // 0xD8254CB2C586412B b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_EXITING_THIS_FRAME(AnimScene animScene) { return invoke<BOOL>(0xCDC5512A407CF08D, animScene); } // 0xCDC5512A407CF08D b1207
	NATIVE_DECL BOOL HAS_ANIM_SCENE_EXITED(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0xF94692EB9DC15D74, animScene, p1); } // 0xF94692EB9DC15D74 b1207
	// Used in SP R* Scripts only
	// _CO* - _CR*
	NATIVE_DECL BOOL _0x73616E64696C132E(AnimScene animScene, BOOL p1) { return invoke<BOOL>(0x73616E64696C132E, animScene, p1); } // 0x73616E64696C132E b1207
	NATIVE_DECL BOOL IS_ANIM_SCENE_IN_SECTION(AnimScene animScene, const char* sectionName, BOOL p2) { return invoke<BOOL>(0x8D81E7824B7753F7, animScene, sectionName, p2); } // 0x8D81E7824B7753F7 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_SKIPPABLE(AnimScene animScene) { return invoke<BOOL>(0x4CDFFE3189EBDBD0, animScene); } // 0x4CDFFE3189EBDBD0 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_ABORTED(AnimScene animScene) { return invoke<BOOL>(0x34A0671BE613D3D0, animScene); } // 0x34A0671BE613D3D0 b1207
	// Used in SP R* Scripts only
	// _IS_ANIM_SCENE_*
	NATIVE_DECL BOOL _0xD70C7A30412F8FA0(AnimScene animScene) { return invoke<BOOL>(0xD70C7A30412F8FA0, animScene); } // 0xD70C7A30412F8FA0 b1207
	// Used in SP R* Scripts only
	// _IS_ANIM_SCENE_*
	NATIVE_DECL BOOL _0x9AAE3C1148A09BCA(AnimScene animScene) { return invoke<BOOL>(0x9AAE3C1148A09BCA, animScene); } // 0x9AAE3C1148A09BCA b1207
	// Used in SP R* Scripts only
	// _WAS_ANIM_SCENE_*
	NATIVE_DECL BOOL _0xA96619FE85159ED2(AnimScene animScene) { return invoke<BOOL>(0xA96619FE85159ED2, animScene); } // 0xA96619FE85159ED2 b1207
	NATIVE_DECL void FADE_ANIM_SCENE_AUDIO_IN(AnimScene animScene, float p1) { invoke<Void>(0xA41351EA2A18A0AD, animScene, p1); } // 0xA41351EA2A18A0AD b1207
	NATIVE_DECL void FADE_ANIM_SCENE_AUDIO_OUT(AnimScene animScene, float p1) { invoke<Void>(0x323E3AD772BA5D57, animScene, p1); } // 0x323E3AD772BA5D57 b1207
	NATIVE_DECL void BLOCK_ANIM_SCENE_FADING_NEXT_FRAME(BOOL p0, BOOL p1) { invoke<Void>(0x1B70811D3BF75DB9, p0, p1); } // 0x1B70811D3BF75DB9 b1207
	NATIVE_DECL void SET_ANIM_SCENE_ORIGIN(AnimScene animScene, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, int order) { invoke<Void>(0x020894BF17A02EF2, animScene, posX, posY, posZ, rotX, rotY, rotZ, order); } // 0x020894BF17A02EF2 b1207
	NATIVE_DECL void SET_ANIM_SCENE_ORIGIN(AnimScene animScene, Vector3 pos, Vector3 rot, int order) { invoke<Void>(0x020894BF17A02EF2, animScene, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, order); } // 0x020894BF17A02EF2 b1207
	NATIVE_DECL void GET_ANIM_SCENE_ORIGIN(AnimScene animScene, Vector3* position, Vector3* rotation, int order) { invoke<Void>(0xADF1D53F3B1FE0A7, animScene, position, rotation, order); } // 0xADF1D53F3B1FE0A7 b1207
	NATIVE_DECL void SET_ANIM_SCENE_PAUSED(AnimScene animScene, BOOL toggle) { invoke<Void>(0xD6824B7D24DC0CE0, animScene, toggle); } // 0xD6824B7D24DC0CE0 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_PAUSED(AnimScene animScene) { return invoke<BOOL>(0x4B4038796F0D6566, animScene); } // 0x4B4038796F0D6566 b1207
	NATIVE_DECL void SET_ANIM_SCENE_RATE(AnimScene animScene, float rate) { invoke<Void>(0x75820B801CFF262A, animScene, rate); } // 0x75820B801CFF262A b1207
	NATIVE_DECL float _GET_ANIM_SCENE_RATE(AnimScene animScene) { return invoke<float>(0x43C21623E42B821B, animScene); } // 0x43C21623E42B821B b1207
	NATIVE_DECL float GET_ANIM_SCENE_PHASE(AnimScene animScene) { return invoke<float>(0x3FBC3F51BF12DFBF, animScene); } // 0x3FBC3F51BF12DFBF b1207
	NATIVE_DECL float _GET_ANIM_SCENE_TIME(AnimScene animScene) { return invoke<float>(0x61BE7D6186260002, animScene); } // 0x61BE7D6186260002 b1207
	NATIVE_DECL float _GET_ANIM_SCENE_DURATION(AnimScene animScene) { return invoke<float>(0x49F1D143ADE32656, animScene); } // 0x49F1D143ADE32656 b1207
	NATIVE_DECL void SET_ANIM_SCENE_ENTITY(AnimScene animScene, const char* entityName, Entity entity, int flags) { invoke<Void>(0x8B720AD451CA2AB3, animScene, entityName, entity, flags); } // 0x8B720AD451CA2AB3 b1207
	NATIVE_DECL void REMOVE_ANIM_SCENE_ENTITY(AnimScene animScene, const char* entityName, Entity entity) { invoke<Void>(0x2BF96692C67F3E53, animScene, entityName, entity); } // 0x2BF96692C67F3E53 b1207
	NATIVE_DECL BOOL IS_ENTITY_EXITING_ANIM_SCENE_THIS_FRAME(AnimScene animScene, const char* entityName) { return invoke<BOOL>(0x005E6F28DD7ED58D, animScene, entityName); } // 0x005E6F28DD7ED58D b1207
	NATIVE_DECL BOOL COULD_ANIM_SCENE_ENTITY_REACH_EXIT_NEXT_FRAME(AnimScene animScene, const char* entityName, Any p2, Any p3) { return invoke<BOOL>(0x73616E64696C616E, animScene, entityName, p2, p3); } // 0x73616E64696C616E b1207
	NATIVE_DECL BOOL HAS_ENTITY_EXITED_ANIM_SCENE(AnimScene animScene, const char* entityName) { return invoke<BOOL>(0xB89FCFF19DAFFF28, animScene, entityName); } // 0xB89FCFF19DAFFF28 b1207
	// _HAS_L* (?)
	NATIVE_DECL BOOL _HAS_ENTITY_ENTERED_ANIM_SCENE(AnimScene animScene, const char* entityName) { return invoke<BOOL>(0x337F1CC8EE895601, animScene, entityName); } // 0x337F1CC8EE895601 b1207
	NATIVE_DECL Ped _GET_ANIM_SCENE_PED(AnimScene animScene, const char* name, BOOL isNetwork) { return invoke<Ped>(0xE5822422197BBBA3, animScene, name, isNetwork); } // 0xE5822422197BBBA3 b1207
	NATIVE_DECL Object _GET_ANIM_SCENE_OBJECT(AnimScene animScene, const char* name, BOOL isNetwork) { return invoke<Object>(0xFB5674687A1B2814, animScene, name, isNetwork); } // 0xFB5674687A1B2814 b1207
	NATIVE_DECL Vehicle _GET_ANIM_SCENE_VEHICLE(AnimScene animScene, const char* name, BOOL isNetwork) { return invoke<Vehicle>(0x430EE0A19BC5A287, animScene, name, isNetwork); } // 0x430EE0A19BC5A287 b1207
	NATIVE_DECL void SET_ANIM_SCENE_BOOL(AnimScene animScene, const char* name, BOOL value, BOOL p3) { invoke<Void>(0x519E96C2C68B404B, animScene, name, value, p3); } // 0x519E96C2C68B404B b1207
	NATIVE_DECL BOOL GET_ANIM_SCENE_BOOL(AnimScene animScene, const char* name) { return invoke<BOOL>(0x07A6F6447ECA9B64, animScene, name); } // 0x07A6F6447ECA9B64 b1207
	NATIVE_DECL void SET_ANIM_SCENE_FLOAT(AnimScene animScene, const char* name, float value, BOOL p3, BOOL p4) { invoke<Void>(0x6BC5104E68CBEFE8, animScene, name, value, p3, p4); } // 0x6BC5104E68CBEFE8 b1207
	NATIVE_DECL float GET_ANIM_SCENE_FLOAT(AnimScene animScene, const char* name) { return invoke<float>(0xCC24CB07F60B496E, animScene, name); } // 0xCC24CB07F60B496E b1207
	NATIVE_DECL void SET_ANIM_SCENE_INT(AnimScene animScene, const char* name, int value, BOOL p3) { invoke<Void>(0x3A379D2166CF5B92, animScene, name, value, p3); } // 0x3A379D2166CF5B92 b1207
	NATIVE_DECL int GET_ANIM_SCENE_INT(AnimScene animScene, const char* name) { return invoke<int>(0x2B7277484CC095FD, animScene, name); } // 0x2B7277484CC095FD b1207
	NATIVE_DECL BOOL GET_ANIM_SCENE_ENTITY_LOCATION_DATA(AnimScene animScene, const char* entityName, Vector3* matrix, BOOL p3, const char* playbackListName, int p5) { return invoke<BOOL>(0x8398438D8F14F56D, animScene, entityName, matrix, p3, playbackListName, p5); } // 0x8398438D8F14F56D b1207
	NATIVE_DECL BOOL IS_ENTITY_PLAYING_ANIM_SCENE(Entity entity, AnimScene animScene) { return invoke<BOOL>(0x3AB6C7B0BB0DF4B1, entity, animScene); } // 0x3AB6C7B0BB0DF4B1 b1207
	NATIVE_DECL void ATTACH_ANIM_SCENE_TO_ENTITY(AnimScene animScene, Entity entity, int p2) { invoke<Void>(0xDC418495DBA327A1, animScene, entity, p2); } // 0xDC418495DBA327A1 b1207
	NATIVE_DECL void ATTACH_ANIM_SCENE_TO_ENTITY_PRESERVING_LOCATION(AnimScene animScene, Entity entity, int p2) { invoke<Void>(0x1C0B105C3F30B88D, animScene, entity, p2); } // 0x1C0B105C3F30B88D b1207
	NATIVE_DECL void DETACH_ANIM_SCENE(AnimScene animScene) { invoke<Void>(0x6843A1AA3A336DFF, animScene); } // 0x6843A1AA3A336DFF b1207
	NATIVE_DECL void DETACH_ANIM_SCENE_PRESERVING_LOCATION(AnimScene animScene) { invoke<Void>(0xA2507C4948C83D2E, animScene); } // 0xA2507C4948C83D2E b1207
	NATIVE_DECL void TAKE_OWNERSHIP_OF_ANIM_SCENE(AnimScene animScene) { invoke<Void>(0xF7A4C571E572D237, animScene); } // 0xF7A4C571E572D237 b1207
	NATIVE_DECL BOOL CHECK_OWNERSHIP_OF_ANIM_SCENE(AnimScene animScene) { return invoke<BOOL>(0x661B8683611B9B97, animScene); } // 0x661B8683611B9B97 b1207
	NATIVE_DECL void SET_ANIM_SCENE_PLAYBACK_LIST(AnimScene animScene, const char* playbackListName) { invoke<Void>(0xAB5E7CAB074D6B84, animScene, playbackListName); } // 0xAB5E7CAB074D6B84 b1207
	// Used in SP R* Scripts only
	// _IS_ANIM_SCENE_P*
	NATIVE_DECL BOOL _0x1C5D33A4293E6DDE(AnimScene animScene, const char* phaseName) { return invoke<BOOL>(0x1C5D33A4293E6DDE, animScene, phaseName); } // 0x1C5D33A4293E6DDE b1207
	NATIVE_DECL BOOL _DOES_ANIM_SCENE_PLAY_LIST_EXIST(AnimScene animScene, const char* playbackListName) { return invoke<BOOL>(0xA9016536015DE29D, animScene, playbackListName); } // 0xA9016536015DE29D b1207
	NATIVE_DECL void SET_ANIM_SCENE_PLAY_LIST(AnimScene animScene, const char* playlistName, BOOL p2) { invoke<Void>(0x15598CFB25F3DC7E, animScene, playlistName, p2); } // 0x15598CFB25F3DC7E b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_PLAYBACK_LIST_PHASE_ACTIVE(AnimScene animScene, const char* phaseName) { return invoke<BOOL>(0x1F0E401031E20146, animScene, phaseName); } // 0x1F0E401031E20146 b1207
	NATIVE_DECL BOOL REQUEST_ANIM_SCENE_PLAY_LIST(AnimScene animScene, const char* playlistName) { return invoke<BOOL>(0xDF7B5144E25CD3FE, animScene, playlistName); } // 0xDF7B5144E25CD3FE b1207
	NATIVE_DECL BOOL _RELEASE_ANIM_SCENE_PLAY_LIST(AnimScene animScene, const char* playlistName) { return invoke<BOOL>(0xAE6ADA8FE7E84ACC, animScene, playlistName); } // 0xAE6ADA8FE7E84ACC b1207
	NATIVE_DECL Hash _GET_ANIM_SCENE_DICT(AnimScene animScene) { return invoke<Hash>(0xAE5ADA4FE3E21ADC, animScene); } // 0xAE5ADA4FE3E21ADC b1207
	// Used in SP R* Scripts only
	// Params: p1 = 2B-LowHonor, 2A-HighHonor
	NATIVE_DECL BOOL _0x1407F5115FB9583E(AnimScene animScene, const char* p1) { return invoke<BOOL>(0x1407F5115FB9583E, animScene, p1); } // 0x1407F5115FB9583E b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_PLAYBACK_LIST_PHASE_LOADED(AnimScene animScene, const char* phaseName) { return invoke<BOOL>(0x23E33CB9F4A3F547, animScene, phaseName); } // 0x23E33CB9F4A3F547 b1207
	NATIVE_DECL BOOL _IS_ANIM_SCENE_PLAYBACK_LIST_PHASE_LOADING(AnimScene animScene, const char* phaseName) { return invoke<BOOL>(0x0DF57F86FE71DBE5, animScene, phaseName); } // 0x0DF57F86FE71DBE5 b1207
	// Used in braithwaites2 SP R* Scripts only
	// _A*
	NATIVE_DECL void _0x1AD896BF43619551() { invoke<Void>(0x1AD896BF43619551); } // 0x1AD896BF43619551 b1207
	NATIVE_DECL int GET_ANIM_SCENE_CURRENT_ACTIVE_CAMERA_COUNT(AnimScene animScene) { return invoke<int>(0x4822A65D5AF64E69, animScene); } // 0x4822A65D5AF64E69 b1207
	// Used in SP R* Scripts only
	// _IS_ANIM_SCENE_R* - _IS_ANIM_SCENE_S*
	NATIVE_DECL BOOL _0x5D7BFDA2290B4E39(const char* p0) { return invoke<BOOL>(0x5D7BFDA2290B4E39, p0); } // 0x5D7BFDA2290B4E39 b1207
	// MGM stands for MiniGameMoments.
	NATIVE_DECL BOOL _IS_MGM_SYSTEM_LOADED(const char* mgmFilename) { return invoke<BOOL>(0xFDFC14799373283F, mgmFilename); } // 0xFDFC14799373283F b1207
	// Used to request MiniGameMoments Assets.
	// 
	// mgmFilename's:
	// Poker
	// PokerArthur
	// PokerArthurCamp
	// PokerJohn
	// PokerJohnCamp
	NATIVE_DECL BOOL _LOAD_MGM_ASSETS(const char* mgmFilename) { return invoke<BOOL>(0xB727A847862CB00A, mgmFilename); } // 0xB727A847862CB00A b1207
	// Returns mgmHandle
	NATIVE_DECL int _CREATE_MGM_SYSTEM(const char* mgmFilename) { return invoke<int>(0xA1300DE03E5D1973, mgmFilename); } // 0xA1300DE03E5D1973 b1207
	NATIVE_DECL void _DELETE_MGM_SYSTEM(int mgmHandle) { invoke<Void>(0x53CB3970BA02E3CC, mgmHandle); } // 0x53CB3970BA02E3CC b1207
	// _PREPARE_* - _REGISTER_*
	NATIVE_DECL void _0xB1A196BAFE650402(int mgmHandle, Ped ped) { invoke<Void>(0xB1A196BAFE650402, mgmHandle, ped); } // 0xB1A196BAFE650402 b1207
	// _UNLOAD_* - _WAS_ANIM_SCENE_*
	NATIVE_DECL void _0xAE6DE22DE0ED4554(int mgmHandle, Ped ped) { invoke<Void>(0xAE6DE22DE0ED4554, mgmHandle, ped); } // 0xAE6DE22DE0ED4554 b1207
	// Only used in tg_p R* Script
	// Returns true when mgm event success
	// _PREPARE_* - _REGISTER_*
	NATIVE_DECL BOOL _0x61B2AAEF645DDAF0(int mgmEventHandle, const char* p1, int seatId, int p3, BOOL p4) { return invoke<BOOL>(0x61B2AAEF645DDAF0, mgmEventHandle, p1, seatId, p3, p4); } // 0x61B2AAEF645DDAF0 b1207
	NATIVE_DECL void _SET_MGM_EVENT(int mgmEventHandle, const char* p1, Any seatId, int p3, float p4) { invoke<Void>(0x07706C4CC9C6CC9E, mgmEventHandle, p1, seatId, p3, p4); } // 0x07706C4CC9C6CC9E b1207
	// p2: MINIGAME_GET_SECONDARY_VOICE_STRING
	// _SET_*
	NATIVE_DECL void _0x3641FCD53E59B335(int mgmHandle, Ped ped, const char* secondaryVoiceString) { invoke<Void>(0x3641FCD53E59B335, mgmHandle, ped, secondaryVoiceString); } // 0x3641FCD53E59B335 b1207
	NATIVE_DECL void _SET_BREAKOUT_ARCHETYPE(Ped ped, const char* archetype) { invoke<Void>(0x99B2A2E3655DEAF1, ped, archetype); } // 0x99B2A2E3655DEAF1 b1207
	NATIVE_DECL void _CLEAR_BREAKOUT_ARCHETYPE(Ped ped) { invoke<Void>(0xBC781D24AA11F179, ped); } // 0xBC781D24AA11F179 b1207
	// Used in SP R* Scripts only
	// _IS_*
	NATIVE_DECL BOOL _0x3B393716C3FD8237(Ped ped) { return invoke<BOOL>(0x3B393716C3FD8237, ped); } // 0x3B393716C3FD8237 b1207
	// Used in SP R* Scripts only
	// _SET_B* - _SET_C*
	NATIVE_DECL void _0xE12D7B4B959644CD() { invoke<Void>(0xE12D7B4B959644CD); } // 0xE12D7B4B959644CD b1207
	// Used in SP R* Scripts only
	// _RESUME_* - _SET_A*
	NATIVE_DECL void _0xC1193521E3B9FADD(Entity entity, BOOL p1) { invoke<Void>(0xC1193521E3B9FADD, entity, p1); } // 0xC1193521E3B9FADD b1207
	NATIVE_DECL void _REQUEST_PHOTO_MODE_FREEZE() { invoke<Void>(0x7C709C01D43D94CD); } // 0x7C709C01D43D94CD b1207
	NATIVE_DECL void _REQUEST_PHOTO_MODE_DEFREEZE() { invoke<Void>(0x41AFA5F228B0B6B0); } // 0x41AFA5F228B0B6B0 b1207
	// Used in SP R* Scripts only
	// _IS_PED_* - _IS_SC*
	NATIVE_DECL BOOL _0x2DB524750DC41ED4() { return invoke<BOOL>(0x2DB524750DC41ED4); } // 0x2DB524750DC41ED4 b1207
	// Used in SP R* Scripts only
	// _PAUSE_* - _PLAY_*
	NATIVE_DECL BOOL _0xEA41D44A8D42057B() { return invoke<BOOL>(0xEA41D44A8D42057B); } // 0xEA41D44A8D42057B b1207
	// Pauses all script threads except the one that called it.
	NATIVE_DECL void _PAUSE_SCRIPT_THREADS(BOOL toggle) { invoke<Void>(0x37C1257849DEF24A, toggle); } // 0x37C1257849DEF24A b1207
	// Used in SP R* Scripts only
	// _SET_P*
	NATIVE_DECL void _0xCDCD7B2D49AEE73A(BOOL p0) { invoke<Void>(0xCDCD7B2D49AEE73A, p0); } // 0xCDCD7B2D49AEE73A b1207
	NATIVE_DECL BOOL WAS_ANIM_SCENE_SKIPPED(AnimScene animScene) { return invoke<BOOL>(0xEF324E9550A394D5, animScene); } // 0xEF324E9550A394D5 b1207
}

namespace _NAMESPACE4
{
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xC31C44C43B48FDE3(Any* gamerHandle, int badSportBehaviorType) { invoke<Void>(0xC31C44C43B48FDE3, gamerHandle, badSportBehaviorType); } // 0xC31C44C43B48FDE3 b1207
}

namespace ATTRIBUTE
{
	// attributeIndex:
	// enum ePedAttribute
	// {
	// 	PA_HEALTH,
	// 	PA_STAMINA,
	// 	PA_SPECIALABILITY,
	// 	PA_COURAGE,
	// 	PA_AGILITY,
	// 	PA_SPEED,
	// 	PA_ACCELERATION,
	// 	PA_BONDING,
	// 	SA_HUNGER,
	// 	SA_FATIGUED,
	// 	SA_INEBRIATED,
	// 	SA_POISONED,
	// 	SA_BODYHEAT,
	// 	SA_BODYWEIGHT,
	// 	SA_OVERFED,
	// 	SA_SICKNESS,
	// 	SA_DIRTINESS,
	// 	SA_DIRTINESSHAT,
	// 	MTR_STRENGTH,
	// 	MTR_GRIT,
	// 	MTR_INSTINCT,
	// 	PA_UNRULINESS,
	// 	SA_DIRTINESSSKIN
	// };
	NATIVE_DECL void SET_ATTRIBUTE_BASE_RANK(Ped ped, int attributeIndex, int newValue) { invoke<Void>(0x5DA12E025D47D4E5, ped, attributeIndex, newValue); } // 0x5DA12E025D47D4E5 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_ATTRIBUTE_RANK(Ped ped, int attributeIndex) { return invoke<int>(0xA4C8E23E29040DE0, ped, attributeIndex); } // 0xA4C8E23E29040DE0 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_ATTRIBUTE_BASE_RANK(Ped ped, int attributeIndex) { return invoke<int>(0x147149F2E909323C, ped, attributeIndex); } // 0x147149F2E909323C b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_ATTRIBUTE_BONUS_RANK(Ped ped, int coreIndex) { return invoke<int>(0x0EFA71F4B4330E04, ped, coreIndex); } // 0x0EFA71F4B4330E04 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_MAX_ATTRIBUTE_RANK(Ped ped, int attributeIndex) { return invoke<int>(0x704674A0535A471D, ped, attributeIndex); } // 0x704674A0535A471D b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL void SET_ATTRIBUTE_BONUS_RANK(Ped ped, int attributeIndex, int newValue) { invoke<Void>(0x920F9488BD115EFB, ped, attributeIndex, newValue); } // 0x920F9488BD115EFB b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_DEFAULT_ATTRIBUTE_RANK(Ped ped, int attributeIndex) { return invoke<int>(0x958DD43D41F89A47, ped, attributeIndex); } // 0x958DD43D41F89A47 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_DEFAULT_MAX_ATTRIBUTE_RANK(Ped ped, int attributeIndex) { return invoke<int>(0x7C059C55AD940CB4, ped, attributeIndex); } // 0x7C059C55AD940CB4 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL void ADD_ATTRIBUTE_POINTS(Ped ped, int attributeIndex, int p2) { invoke<Void>(0x75415EE0CB583760, ped, attributeIndex, p2); } // 0x75415EE0CB583760 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL void SET_ATTRIBUTE_POINTS(Ped ped, int attributeIndex, int p2) { invoke<Void>(0x09A59688C26D88DF, ped, attributeIndex, p2); } // 0x09A59688C26D88DF b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_ATTRIBUTE_POINTS(Ped ped, int attributeIndex) { return invoke<int>(0x219DA04BAA9CB065, ped, attributeIndex); } // 0x219DA04BAA9CB065 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_MAX_ATTRIBUTE_POINTS(Ped ped, int attributeIndex) { return invoke<int>(0x223BF310F854871C, ped, attributeIndex); } // 0x223BF310F854871C b1207
	// coreIndex:
	// enum eAttributeCore
	// {
	// 	ATTRIBUTE_CORE_HEALTH,
	// 	ATTRIBUTE_CORE_STAMINA,
	// 	ATTRIBUTE_CORE_DEADEYE
	// };
	NATIVE_DECL void _SET_ATTRIBUTE_CORE_VALUE(Ped ped, int coreIndex, int value) { invoke<Void>(0xC6258F41D86676E0, ped, coreIndex, value); } // 0xC6258F41D86676E0 b1207
	// Gets the ped's core value on a scale of 0 to 100.
	// coreIndex: see _SET_ATTRIBUTE_CORE_VALUE
	NATIVE_DECL int _GET_ATTRIBUTE_CORE_VALUE(Ped ped, int coreIndex) { return invoke<int>(0x36731AC041289BB1, ped, coreIndex); } // 0x36731AC041289BB1 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL int GET_DEFAULT_ATTRIBUTE_POINTS_NEEDED_FOR_RANK(Hash modelHash, int attributeIndex, int rank) { return invoke<int>(0x94A7F191DB49A44D, modelHash, attributeIndex, rank); } // 0x94A7F191DB49A44D b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	// 
	// Old name: _SET_ATTRIBUTE_OVERPOWER_VALUE
	NATIVE_DECL void ENABLE_ATTRIBUTE_OVERPOWER(Ped ped, int attributeIndex, float value, BOOL makeSound) { invoke<Void>(0xF6A7C08DF2E28B28, ped, attributeIndex, value, makeSound); } // 0xF6A7C08DF2E28B28 b1207
	// coreIndex: see _SET_ATTRIBUTE_CORE_VALUE
	// 
	// Previously incorrectly named ENABLE_ATTRIBUTE_OVERPOWER
	NATIVE_DECL void _ENABLE_ATTRIBUTE_CORE_OVERPOWER(Ped ped, int coreIndex, float value, BOOL makeSound) { invoke<Void>(0x4AF5A4C7B9157D14, ped, coreIndex, value, makeSound); } // 0x4AF5A4C7B9157D14 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL void DISABLE_ATTRIBUTE_OVERPOWER(Ped ped, int attributeIndex) { invoke<Void>(0xF8DAC3D85636C241, ped, attributeIndex); } // 0xF8DAC3D85636C241 b1207
	// attributeIndex: see SET_ATTRIBUTE_BASE_RANK
	NATIVE_DECL BOOL _IS_ATTRIBUTE_OVERPOWERED(Ped ped, int attributeIndex) { return invoke<BOOL>(0x103C2F885ABEB00B, ped, attributeIndex); } // 0x103C2F885ABEB00B b1207
	NATIVE_DECL BOOL _IS_ATTRIBUTE_CORE_OVERPOWERED(Ped ped, int coreIndex) { return invoke<BOOL>(0x200373A8DF081F22, ped, coreIndex); } // 0x200373A8DF081F22 b1207
	NATIVE_DECL float _GET_ATTRIBUTE_OVERPOWER_SECONDS_LEFT(Ped ped, int attributeIndex) { return invoke<float>(0x4C9F782180712742, ped, attributeIndex); } // 0x4C9F782180712742 b1207
	NATIVE_DECL float _GET_ATTRIBUTE_CORE_OVERPOWER_SECONDS_LEFT(Ped ped, int coreIndex) { return invoke<float>(0xB429F58803D285B1, ped, coreIndex); } // 0xB429F58803D285B1 b1207
	NATIVE_DECL void _START_ITEM_PREVIEW(Any p0, Any p1) { invoke<Void>(0x7E2C766ADB2C5F1A, p0, p1); } // 0x7E2C766ADB2C5F1A b1207
	NATIVE_DECL void STOP_ITEM_PREVIEW() { invoke<Void>(0xD962F8579D702DB5); } // 0xD962F8579D702DB5 b1207
	// Displays status effects on core icons (includes warnings).
	// 
	// enum eUiRpgStatusEffect
	// {
	// 	STATUS_NONE,
	// 	STATUS_COLD,
	// 	STATUS_HOT,
	// 	STATUS_OVERFED,
	// 	STATUS_DIRTY,
	// 	STATUS_SNAKE_VENOM,
	// 	STATUS_ARROW_WOUNDED,
	// 	STATUS_ARROW_DRAINED,
	// 	STATUS_ARROW_DISORIENTED,
	// 	STATUS_ARROW_TRACKED,
	// 	STATUS_ARROW_CONFUSION,
	// 	STATUS_UNDERWEIGHT,
	// 	STATUS_OVERWEIGHT,
	// 	STATUS_SICK_1,
	// 	STATUS_SICK_2,
	// 	STATUS_PREDATOR_INVULNERABLE
	// };
	NATIVE_DECL void _SET_STATUS_EFFECT_CORE_ICON(int statusEffectType) { invoke<Void>(0xA4D3A1C008F250DF, statusEffectType); } // 0xA4D3A1C008F250DF b1207
	// Starts core periodic icon.
	// statusEffectType: see 0xA4D3A1C008F250DF
	NATIVE_DECL void _SET_STATUS_EFFECT_PERIODIC_ICON(int statusEffectType) { invoke<Void>(0xFB6E111908502871, statusEffectType); } // 0xFB6E111908502871 b1207
	// Stops periodic icon.
	// statusEffectType: see 0xA4D3A1C008F250DF
	NATIVE_DECL void _STOP_STATUS_EFFECT_PERIODIC_ICON(int statusEffectType) { invoke<Void>(0x3FC4C027FD0936F4, statusEffectType); } // 0x3FC4C027FD0936F4 b1207
}

namespace AUDIO
{
	NATIVE_DECL void _0x7455CD705F7E933E() { invoke<Void>(0x7455CD705F7E933E); } // 0x7455CD705F7E933E b1207
	NATIVE_DECL void CLEAR_CONVERSATION_HISTORY() { invoke<Void>(0x33D51F801CB16E4F); } // 0x33D51F801CB16E4F b1207
	NATIVE_DECL void _CLEAR_CONVERSATION_HISTORY_FOR_SCRIPTED_CONVERSATION(const char* convoRoot) { invoke<Void>(0xEF51242E35242B47, convoRoot); } // 0xEF51242E35242B47 b1207
	NATIVE_DECL BOOL CREATE_NEW_SCRIPTED_CONVERSATION(const char* convoRoot) { return invoke<BOOL>(0xD2C91A0B572AAE56, convoRoot); } // 0xD2C91A0B572AAE56 0xB2BC25F8 b1207
	NATIVE_DECL Any _0xDF947FE0D551684E(Any p0, Any p1) { return invoke<Any>(0xDF947FE0D551684E, p0, p1); } // 0xDF947FE0D551684E b1207
	NATIVE_DECL void ADD_PED_TO_CONVERSATION(const char* convoRoot, Ped ped, const char* characterName) { invoke<Void>(0x95D9F4BC443956E7, convoRoot, ped, characterName); } // 0x95D9F4BC443956E7 0xF8D5EB86 b1207
	NATIVE_DECL void _0xA2323A2EAE32A290(Any p0, Any p1, Any p2) { invoke<Void>(0xA2323A2EAE32A290, p0, p1, p2); } // 0xA2323A2EAE32A290 b1207
	NATIVE_DECL Any _0x79F9C57B8D0DFE90(Any p0, Any p1) { return invoke<Any>(0x79F9C57B8D0DFE90, p0, p1); } // 0x79F9C57B8D0DFE90 b1207
	NATIVE_DECL void START_SCRIPT_CONVERSATION(const char* convoRoot, BOOL p1, BOOL p2, BOOL clone) { invoke<Void>(0x6B17C62C9635D2DC, convoRoot, p1, p2, clone); } // 0x6B17C62C9635D2DC 0xE5DE7D9D b1207
	NATIVE_DECL void PRELOAD_SCRIPT_CONVERSATION(const char* convoRoot, BOOL p1, BOOL p2, BOOL clone) { invoke<Void>(0x3B3CAD6166916D87, convoRoot, p1, p2, clone); } // 0x3B3CAD6166916D87 0xDDF5C579 b1207
	NATIVE_DECL void START_PRELOADED_CONVERSATION(const char* convoRoot) { invoke<Void>(0x23641AFE870AF385, convoRoot); } // 0x23641AFE870AF385 0xA170261B b1207
	NATIVE_DECL Any _0x0CB3D1919E8D7CBA(Any p0) { return invoke<Any>(0x0CB3D1919E8D7CBA, p0); } // 0x0CB3D1919E8D7CBA b1207
	NATIVE_DECL Any _0xFE5C6177064BD390(Any p0) { return invoke<Any>(0xFE5C6177064BD390, p0); } // 0xFE5C6177064BD390 b1207
	NATIVE_DECL BOOL _IS_SCRIPTED_CONVERSATION_CREATED(const char* convoRoot) { return invoke<BOOL>(0xD89504D9D7D5057D, convoRoot); } // 0xD89504D9D7D5057D b1207
	NATIVE_DECL Any _0x5A13586A9447931F(Any p0) { return invoke<Any>(0x5A13586A9447931F, p0); } // 0x5A13586A9447931F b1207
	NATIVE_DECL BOOL IS_SCRIPTED_CONVERSATION_LOADED(const char* convoRoot) { return invoke<BOOL>(0xDF0D54BE7A776737, convoRoot); } // 0xDF0D54BE7A776737 0xE1870EA9 b1207
	NATIVE_DECL Any _0xA2CAC9DEF0195E6F(Any p0) { return invoke<Any>(0xA2CAC9DEF0195E6F, p0); } // 0xA2CAC9DEF0195E6F b1207
	NATIVE_DECL BOOL IS_SCRIPTED_CONVERSATION_PLAYING(const char* p0) { return invoke<BOOL>(0x1ECC76792F661CF5, p0); } // 0x1ECC76792F661CF5 b1207
	NATIVE_DECL Any _0xF01C570E0A0A1E67(Any p0) { return invoke<Any>(0xF01C570E0A0A1E67, p0); } // 0xF01C570E0A0A1E67 b1207
	NATIVE_DECL Any _0x847748AE5D7B1071(Any p0) { return invoke<Any>(0x847748AE5D7B1071, p0); } // 0x847748AE5D7B1071 b1207
	// _IS_SCRIPTED_CONVERSATION_*
	NATIVE_DECL Any _0xD0730C1FA40348D9(Any p0) { return invoke<Any>(0xD0730C1FA40348D9, p0); } // 0xD0730C1FA40348D9 b1207
	NATIVE_DECL int GET_CURRENT_SCRIPTED_CONVERSATION_LINE(const char* p0) { return invoke<int>(0x480357EE890C295A, p0); } // 0x480357EE890C295A 0x9620E41F b1207
	NATIVE_DECL void PAUSE_SCRIPTED_CONVERSATION(const char* p0, BOOL p1, BOOL p2, BOOL p3, BOOL p4) { invoke<Void>(0x8530AD776CD72B12, p0, p1, p2, p3, p4); } // 0x8530AD776CD72B12 0xE2C9C6F8 b1207
	NATIVE_DECL void RESTART_SCRIPTED_CONVERSATION(const char* p0) { invoke<Void>(0x9AEB285D1818C9AC, p0); } // 0x9AEB285D1818C9AC 0x6CB24B56 b1207
	NATIVE_DECL void _0x36559148B78853B3(Any p0, BOOL p1, Any p2) { invoke<Void>(0x36559148B78853B3, p0, p1, p2); } // 0x36559148B78853B3 b1207
	NATIVE_DECL int STOP_SCRIPTED_CONVERSATION(const char* p0, BOOL p1, BOOL p2) { return invoke<int>(0xD79DEEFB53455EBA, p0, p1, p2); } // 0xD79DEEFB53455EBA 0xAB77DA7D b1207
	NATIVE_DECL void SKIP_TO_NEXT_SCRIPTED_CONVERSATION_LINE(const char* p0) { invoke<Void>(0x9663FE6B7A61EB00, p0); } // 0x9663FE6B7A61EB00 0x85C98304 b1207
	NATIVE_DECL Any _0xF336E9F989B3518F(Any p0) { return invoke<Any>(0xF336E9F989B3518F, p0); } // 0xF336E9F989B3518F b1207
	NATIVE_DECL Any _0x254B0241E964B450(Any p0, Any p1) { return invoke<Any>(0x254B0241E964B450, p0, p1); } // 0x254B0241E964B450 b1207
	NATIVE_DECL Any _0x152ED1B56E8F1F50(Any p0, Any p1) { return invoke<Any>(0x152ED1B56E8F1F50, p0, p1); } // 0x152ED1B56E8F1F50 b1207
	NATIVE_DECL Any _0x935DBD96D4A3DA1F(Any p0, Any p1) { return invoke<Any>(0x935DBD96D4A3DA1F, p0, p1); } // 0x935DBD96D4A3DA1F b1207
	NATIVE_DECL Any _0x295859EB18F48D82(Any p0) { return invoke<Any>(0x295859EB18F48D82, p0); } // 0x295859EB18F48D82 b1207
	NATIVE_DECL void _0x40CA665AB9D8D505(const char* convoRoot, int singleLineIndex) { invoke<Void>(0x40CA665AB9D8D505, convoRoot, singleLineIndex); } // 0x40CA665AB9D8D505 b1207
	NATIVE_DECL void _0xF232C2C546AC16D0(Any p0) { invoke<Void>(0xF232C2C546AC16D0, p0); } // 0xF232C2C546AC16D0 b1207
	NATIVE_DECL void _0x1E6F9A9FE1A99F36(Any p0) { invoke<Void>(0x1E6F9A9FE1A99F36, p0); } // 0x1E6F9A9FE1A99F36 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void REGISTER_SCRIPT_WITH_AUDIO(int p0) { invoke<Void>(0xC6ED9D5092438D91, p0); } // 0xC6ED9D5092438D91 0xA6203643 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void UNREGISTER_SCRIPT_WITH_AUDIO() { invoke<Void>(0xA8638BE228D4751A); } // 0xA8638BE228D4751A 0x66728EFE b1207
	NATIVE_DECL BOOL REQUEST_SCRIPT_AUDIO_BANK(const char* audioBank) { return invoke<BOOL>(0x2F844A8B08D76685, audioBank); } // 0x2F844A8B08D76685 0x21322887 b1207
	NATIVE_DECL void RELEASE_NAMED_SCRIPT_AUDIO_BANK(const char* audioBank) { invoke<Void>(0x77ED170667F50170, audioBank); } // 0x77ED170667F50170 0x16707ABC b1207
	NATIVE_DECL void RELEASE_SCRIPT_AUDIO_BANK() { invoke<Void>(0x7A2D8AD0A9EB9C3F); } // 0x7A2D8AD0A9EB9C3F 0x22F865E5 b1207
	NATIVE_DECL int GET_SOUND_ID() { return invoke<int>(0x430386FE9BF80B45); } // 0x430386FE9BF80B45 0x6AE0AD56 b1207
	NATIVE_DECL void RELEASE_SOUND_ID(int soundId) { invoke<Void>(0x353FC880830B88FA, soundId); } // 0x353FC880830B88FA 0x9C080899 b1207
	NATIVE_DECL void PLAY_SOUND(const char* audioName, const char* audioRef, BOOL p2, Any p3, BOOL p4, Any p5) { invoke<Void>(0x7FF4944CC209192D, audioName, audioRef, p2, p3, p4, p5); } // 0x7FF4944CC209192D 0xB6E1917F b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/audio/frontend_soundsets
	NATIVE_DECL void PLAY_SOUND_FRONTEND(const char* audioName, const char* audioRef, BOOL p2, Any p3) { invoke<Void>(0x67C540AA08E4A6F5, audioName, audioRef, p2, p3); } // 0x67C540AA08E4A6F5 0x2E458F74 b1207
	// item: value returned from 0x2E1CDC1FF3B8473E
	// soundSet: HUD_SHOP_SOUNDSET, COMPANIONS_ROBBERIES_SOUNDSET
	NATIVE_DECL void _PLAY_SOUND_FROM_ITEM(Hash item, Hash soundSet, Any p2) { invoke<Void>(0xE8EAFF7B41EDD291, item, soundSet, p2); } // 0xE8EAFF7B41EDD291 b1207
	NATIVE_DECL void PLAY_SOUND_FROM_ENTITY(const char* audioName, Entity entity, const char* audioRef, BOOL isNetwork, Any p4, Any p5) { invoke<Void>(0x6FB1DA3CA9DA7D90, audioName, entity, audioRef, isNetwork, p4, p5); } // 0x6FB1DA3CA9DA7D90 b1207
	NATIVE_DECL void _PLAY_SOUND_FROM_POSITION(const char* audioName, float x, float y, float z, const char* audioRef, BOOL isNetwork, Any p6, BOOL p7, Any p8) { invoke<Void>(0xCCE219C922737BFA, audioName, x, y, z, audioRef, isNetwork, p6, p7, p8); } // 0xCCE219C922737BFA b1207
	NATIVE_DECL void _PLAY_SOUND_FROM_POSITION(const char* audioName, Vector3 vec, const char* audioRef, BOOL isNetwork, Any p6, BOOL p7, Any p8) { invoke<Void>(0xCCE219C922737BFA, audioName, vec.x, vec.y, vec.z, audioRef, isNetwork, p6, p7, p8); } // 0xCCE219C922737BFA b1207
	NATIVE_DECL void _STOP_SOUND_WITH_NAME(const char* audioName, const char* audioRef) { invoke<Void>(0x0F2A2175734926D8, audioName, audioRef); } // 0x0F2A2175734926D8 b1207
	NATIVE_DECL Any _0x580D71DFE0088E34(Any p0, Any p1) { return invoke<Any>(0x580D71DFE0088E34, p0, p1); } // 0x580D71DFE0088E34 b1207
	// item: FUSE, value returned from 0x2E1CDC1FF3B8473E
	// soundSet: HUD_SHOP_SOUNDSET, COMPANIONS_ROBBERIES_SOUNDSET
	NATIVE_DECL BOOL _IS_SCRIPTED_AUDIO_CUSTOM(Hash item, Hash soundSet) { return invoke<BOOL>(0x6DF942C4179BE5AB, item, soundSet); } // 0x6DF942C4179BE5AB b1207
	NATIVE_DECL void _0x9821B68CD3E05F2B(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x9821B68CD3E05F2B, p0, p1, p2, p3); } // 0x9821B68CD3E05F2B b1207
	// whistleConfig: Ped.WhistlePitch (0.0 - 1.0), Ped.WhistleClarity (0.0 - 1.0), Ped.WhistleShape (0.0 - 10.0)
	NATIVE_DECL void _SET_WHISTLE_CONFIG_FOR_PED(Ped ped, const char* whistleConfig, float value) { invoke<Void>(0x9963681A8BC69BF3, ped, whistleConfig, value); } // 0x9963681A8BC69BF3 b1207
	// p1: Entity.Relationship
	// p2: Player, Enemy, Teammate, Neutral
	NATIVE_DECL void _SET_SOUND_RELATIONSHIP_ON_PED(Ped ped, const char* p1, const char* p2) { invoke<Void>(0x2E31ACA7477CF00F, ped, p1, p2); } // 0x2E31ACA7477CF00F b1207
	NATIVE_DECL void _PLAY_SOUND_FRONTEND_WITH_SOUND_ID(int soundId, const char* name, const char* soundSet, BOOL p3) { invoke<Void>(0xCE5D0FFE83939AF1, soundId, name, soundSet, p3); } // 0xCE5D0FFE83939AF1 b1207
	// Params: p5 seems to be always 0
	NATIVE_DECL void _PLAY_SOUND_FROM_ENTITY_WITH_SET(int soundId, const char* soundName, Entity entity, const char* soundsetName, BOOL p4, Any p5) { invoke<Void>(0xF1C5310FEAA36B48, soundId, soundName, entity, soundsetName, p4, p5); } // 0xF1C5310FEAA36B48 b1207
	NATIVE_DECL void _0xDCF5BA95BBF0FABA(int soundId, const char* soundName, float x, float y, float z, const char* soundsetName, Any p6, Any p7, BOOL p8) { invoke<Void>(0xDCF5BA95BBF0FABA, soundId, soundName, x, y, z, soundsetName, p6, p7, p8); } // 0xDCF5BA95BBF0FABA b1207
	NATIVE_DECL void _0xDCF5BA95BBF0FABA(int soundId, const char* soundName, Vector3 vec, const char* soundsetName, Any p6, Any p7, BOOL p8) { invoke<Void>(0xDCF5BA95BBF0FABA, soundId, soundName, vec.x, vec.y, vec.z, soundsetName, p6, p7, p8); } // 0xDCF5BA95BBF0FABA b1207
	NATIVE_DECL void _0x0286617C8FC50A53(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x0286617C8FC50A53, p0, p1, p2, p3); } // 0x0286617C8FC50A53 b1207
	NATIVE_DECL void _STOP_SOUND_WITH_ID(int soundId) { invoke<Void>(0x3210BCB36AF7621B, soundId); } // 0x3210BCB36AF7621B b1207
	NATIVE_DECL void _0x503703EC1781B7D6(Any p0, Any p1, Any p2) { invoke<Void>(0x503703EC1781B7D6, p0, p1, p2); } // 0x503703EC1781B7D6 b1207
	NATIVE_DECL BOOL PREPARE_SOUND(const char* soundName, const char* soundsetName, int soundId) { return invoke<BOOL>(0xE368E8422C860BA7, soundName, soundsetName, soundId); } // 0xE368E8422C860BA7 b1207
	NATIVE_DECL void _RELEASE_SHARD_SOUNDS(const char* soundName, const char* soundsetName) { invoke<Void>(0x9D746964E0CF2C5F, soundName, soundsetName); } // 0x9D746964E0CF2C5F b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/audio/soundsets
	NATIVE_DECL BOOL PREPARE_SOUNDSET(const char* soundsetName, BOOL p1) { return invoke<BOOL>(0xD9130842D7226045, soundsetName, p1); } // 0xD9130842D7226045 b1207
	NATIVE_DECL void _RELEASE_SOUNDSET(const char* soundsetName) { invoke<Void>(0x531A78D6BF27014B, soundsetName); } // 0x531A78D6BF27014B b1207
	NATIVE_DECL BOOL PREPARE_SOUND_WITH_ENTITY(const char* soundName, Entity entity, const char* soundsetName, int soundId) { return invoke<BOOL>(0x4AD019591E94C064, soundName, entity, soundsetName, soundId); } // 0x4AD019591E94C064 b1207
	NATIVE_DECL void _0x3E93DDDCBB6111E4(Any p0, Any p1) { invoke<Void>(0x3E93DDDCBB6111E4, p0, p1); } // 0x3E93DDDCBB6111E4 b1207
	NATIVE_DECL Any _0x714A0EA7DE1167BE(const char* audioName, const char* soundsetName) { return invoke<Any>(0x714A0EA7DE1167BE, audioName, soundsetName); } // 0x714A0EA7DE1167BE b1207
	NATIVE_DECL Any _0x84848E1C0FC67DBB(Any p0) { return invoke<Any>(0x84848E1C0FC67DBB, p0); } // 0x84848E1C0FC67DBB b1207
	// struct ScriptedSpeechParams
	// {
	// 	const char* speechName;
	// 	const char* voiceName;
	// 	alignas(8) int v3;
	// 	alignas(8) Hash speechParamHash;
	// 	alignas(8) Entity entity;
	// 	alignas(8) BOOL v6;
	// 	alignas(8) int v7;
	// 	alignas(8) int v8;
	// };
	// 
	// static_assert(sizeof(ScriptedSpeechParams) == 0x40, "incorrect ScriptedSpeechParams size");
	// 
	// 
	// Example:
	// 
	// ScriptedSpeechParams params{"RE_PH_RHD_V3_AGGRO", "0405_U_M_M_RhdSheriff_01", 1, 0x67F3AB43, 0, true, 1, 1};
	// PLAY_PED_AMBIENT_SPEECH_NATIVE(PLAYER_PED_ID(), (Any*)&params);
	// 
	// Old name: _PLAY_AMBIENT_SPEECH1
	// https://github.com/femga/rdr3_discoveries/tree/master/audio/audio_banks
	NATIVE_DECL BOOL PLAY_PED_AMBIENT_SPEECH_NATIVE(Ped ped, Any* params) { return invoke<BOOL>(0x8E04FEDD28D42462, ped, params); } // 0x8E04FEDD28D42462 0x5C57B85D b1207
	// Old name: _PLAY_AMBIENT_SPEECH_AT_COORDS
	NATIVE_DECL BOOL PLAY_AMBIENT_SPEECH_FROM_POSITION_NATIVE(float x, float y, float z, Any* params) { return invoke<BOOL>(0xED640017ED337E45, x, y, z, params); } // 0xED640017ED337E45 0xA1A1402E b1207
	NATIVE_DECL BOOL PLAY_AMBIENT_SPEECH_FROM_POSITION_NATIVE(Vector3 vec, Any* params) { return invoke<BOOL>(0xED640017ED337E45, vec.x, vec.y, vec.z, params); } // 0xED640017ED337E45 0xA1A1402E b1207
	NATIVE_DECL Any _0x72E4D1C4639BC465(Any p0, Any p1) { return invoke<Any>(0x72E4D1C4639BC465, p0, p1); } // 0x72E4D1C4639BC465 b1207
	NATIVE_DECL Any _0xB18FEC133C7C6C69(Any p0) { return invoke<Any>(0xB18FEC133C7C6C69, p0); } // 0xB18FEC133C7C6C69 b1207
	NATIVE_DECL void _0xDC93F0948F2C28F4(Any p0) { invoke<Void>(0xDC93F0948F2C28F4, p0); } // 0xDC93F0948F2C28F4 b1207
	NATIVE_DECL void _0x0D7FD6A55FD63AEF(int p0, int p1, BOOL p2) { invoke<Void>(0x0D7FD6A55FD63AEF, p0, p1, p2); } // 0x0D7FD6A55FD63AEF b1207
	NATIVE_DECL void _0x660A8F876DF1D4F8(Any p0) { invoke<Void>(0x660A8F876DF1D4F8, p0); } // 0x660A8F876DF1D4F8 b1207
	NATIVE_DECL void _0x380A2E353AD30917(Any p0, Any p1, Any p2) { invoke<Void>(0x380A2E353AD30917, p0, p1, p2); } // 0x380A2E353AD30917 b1207
	NATIVE_DECL void _0x0FAF7171BF613B80(Any p0) { invoke<Void>(0x0FAF7171BF613B80, p0); } // 0x0FAF7171BF613B80 b1207
	// Valid pain IDs: 0..12
	NATIVE_DECL void PLAY_PAIN(Ped ped, int painId, float p2, BOOL p3, BOOL isNetwork) { invoke<Void>(0xBC9AE166038A5CEC, ped, painId, p2, p3, isNetwork); } // 0xBC9AE166038A5CEC 0x874BD6CB b1207
	NATIVE_DECL void _0x6652B0C8F3D414D0(Any p0) { invoke<Void>(0x6652B0C8F3D414D0, p0); } // 0x6652B0C8F3D414D0 b1207
	// Name: ROPE_SETTINGS_DEFAULT
	NATIVE_DECL void _0xF092B6030D6FD49C(int ropeId, const char* name) { invoke<Void>(0xF092B6030D6FD49C, ropeId, name); } // 0xF092B6030D6FD49C b1207
	NATIVE_DECL void _0x2651DDC0EA269073(int ropeId, float p1) { invoke<Void>(0x2651DDC0EA269073, ropeId, p1); } // 0x2651DDC0EA269073 b1207
	NATIVE_DECL void SET_AMBIENT_VOICE_NAME(Ped ped, const char* name) { invoke<Void>(0x6C8065A3B780185B, ped, name); } // 0x6C8065A3B780185B 0xBD2EA1A1 b1207
	// Hashes: VOFX_PLAYER_MALE01, VOFX_PLAYER_MALE02, VOFX_PLAYER_MALE03, VOFX_PLAYER_FEMALE01, VOFX_PLAYER_FEMALE02, VOFX_PLAYER_FEMALE03
	NATIVE_DECL void _SET_VOFX_PED_VOICE(Ped ped, Hash voice) { invoke<Void>(0x2703EFB583F0949A, ped, voice); } // 0x2703EFB583F0949A b1207
	NATIVE_DECL void STOP_CURRENT_PLAYING_SPEECH(Ped ped, Any p1) { invoke<Void>(0x79D2F0E66F81D90D, ped, p1); } // 0x79D2F0E66F81D90D 0x5B7463F4 b1207
	NATIVE_DECL void STOP_CURRENT_PLAYING_AMBIENT_SPEECH(Ped ped, Any p1) { invoke<Void>(0xB8BEC0CA6F0EDB0F, ped, p1); } // 0xB8BEC0CA6F0EDB0F 0xBB8E64BF b1207
	NATIVE_DECL BOOL IS_AMBIENT_SPEECH_PLAYING(Ped ped) { return invoke<BOOL>(0x9072C8B49907BFAD, ped); } // 0x9072C8B49907BFAD 0x1972E8AA b1207
	NATIVE_DECL BOOL IS_SCRIPTED_SPEECH_PLAYING(Any p0) { return invoke<BOOL>(0xCC9AA18DCC7084F4, p0); } // 0xCC9AA18DCC7084F4 0x2C653904 b1207
	NATIVE_DECL BOOL IS_ANY_SPEECH_PLAYING(Ped ped) { return invoke<BOOL>(0x729072355FA39EC9, ped); } // 0x729072355FA39EC9 0x2B74A6D6 b1207
	NATIVE_DECL Any _0x2B101AD9F651243A() { return invoke<Any>(0x2B101AD9F651243A); } // 0x2B101AD9F651243A b1207
	NATIVE_DECL Any _0x4A98E228A936DBCC(Any p0) { return invoke<Any>(0x4A98E228A936DBCC, p0); } // 0x4A98E228A936DBCC b1207
	NATIVE_DECL Any _0x6BFFB7C276866996(Any p0) { return invoke<Any>(0x6BFFB7C276866996, p0); } // 0x6BFFB7C276866996 b1207
	// Checks if the ped can play the speech or has the speech file, last parameter is usually false.
	NATIVE_DECL BOOL DOES_CONTEXT_EXIST_FOR_THIS_PED(Ped ped, const char* speechName, BOOL unk) { return invoke<BOOL>(0x49B99BF3FDA89A7A, ped, speechName, unk); } // 0x49B99BF3FDA89A7A 0x8BD5F11E b1207
	NATIVE_DECL Any _0xF0EE69F500952FA5(Any p0) { return invoke<Any>(0xF0EE69F500952FA5, p0); } // 0xF0EE69F500952FA5 b1207
	NATIVE_DECL Any _0x9D6DEC9791A4E501(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x9D6DEC9791A4E501, p0, p1, p2, p3); } // 0x9D6DEC9791A4E501 b1207
	// Not implemented.
	NATIVE_DECL void _0x864A842B86993851(Ped ped) { invoke<Void>(0x864A842B86993851, ped); } // 0x864A842B86993851 b1207
	NATIVE_DECL BOOL IS_PED_IN_CURRENT_CONVERSATION(const char* p0, Ped ped, Any p2) { return invoke<BOOL>(0x049E937F18F4020C, p0, ped, p2); } // 0x049E937F18F4020C 0x7B2F0743 b1207
	NATIVE_DECL BOOL _IS_PED_IN_ANY_CONVERSATION(Ped ped, BOOL p1) { return invoke<BOOL>(0x54B187F111D9C6F8, ped, p1); } // 0x54B187F111D9C6F8 b1207
	NATIVE_DECL void SET_PED_IS_DRUNK(Ped ped, BOOL toggle) { invoke<Void>(0x95D2D383D5396B8A, ped, toggle); } // 0x95D2D383D5396B8A 0xD2EA77A3 b1207
	NATIVE_DECL void _0x3A00D87B20A2A5E4(Any p0, Any p1) { invoke<Void>(0x3A00D87B20A2A5E4, p0, p1); } // 0x3A00D87B20A2A5E4 b1207
	NATIVE_DECL void _0xD47D47EFBF103FB8(Any p0, Any p1) { invoke<Void>(0xD47D47EFBF103FB8, p0, p1); } // 0xD47D47EFBF103FB8 b1207
	NATIVE_DECL void PLAY_ANIMAL_VOCALIZATION(Ped ped, const char* vocalizationName, BOOL p2) { invoke<Void>(0xEE066C7006C49C0A, ped, vocalizationName, p2); } // 0xEE066C7006C49C0A 0x498849F3 b1207
	NATIVE_DECL void _PLAY_ANIMAL_VOCALIZATION_PHEROMONE_VIAL_RESPONSE(Ped ped, Hash p1, BOOL p2) { invoke<Void>(0x0E53530D9B2DB01D, ped, p1, p2); } // 0x0E53530D9B2DB01D b1311
	NATIVE_DECL BOOL IS_ANIMAL_VOCALIZATION_PLAYING(Ped pedHandle) { return invoke<BOOL>(0xC265DF9FB44A9FBD, pedHandle); } // 0xC265DF9FB44A9FBD 0x0CBAF2EF b1207
	// Not implemented.
	NATIVE_DECL void SET_ANIMAL_MOOD(Ped animal, int mood) { invoke<Void>(0xCC97B29285B1DC3B, animal, mood); } // 0xCC97B29285B1DC3B 0x3EA7C6CB b1207
	NATIVE_DECL void _0xFCDEC42B1C78B7F8(Any p0, Any p1) { invoke<Void>(0xFCDEC42B1C78B7F8, p0, p1); } // 0xFCDEC42B1C78B7F8 b1207
	NATIVE_DECL void _0xEB4D592620B8C209(Any p0) { invoke<Void>(0xEB4D592620B8C209, p0); } // 0xEB4D592620B8C209 b1207
	NATIVE_DECL void _0xA6847BBA4FCDD13F(Any p0, Any p1) { invoke<Void>(0xA6847BBA4FCDD13F, p0, p1); } // 0xA6847BBA4FCDD13F b1207
	NATIVE_DECL void SET_STATIC_EMITTER_ENABLED(const char* emitterName, BOOL toggle) { invoke<Void>(0x399D2D3B33F1B8EB, emitterName, toggle); } // 0x399D2D3B33F1B8EB 0x91F72E92 b1207
	NATIVE_DECL void PLAY_END_CREDITS_MUSIC(BOOL play) { invoke<Void>(0xCD536C4D33DCC900, play); } // 0xCD536C4D33DCC900 0x8E88B3CC b1207
	NATIVE_DECL Any _0x7678FE0455ED1145(Any p0, Any p1, Any p2) { return invoke<Any>(0x7678FE0455ED1145, p0, p1, p2); } // 0x7678FE0455ED1145 b1207
	NATIVE_DECL Any _0xFFE9C53DEEA3DB0B(Any p0, Any p1, float x, float y, float z, BOOL isSrlLoaded, Any p6) { return invoke<Any>(0xFFE9C53DEEA3DB0B, p0, p1, x, y, z, isSrlLoaded, p6); } // 0xFFE9C53DEEA3DB0B b1207
	NATIVE_DECL Any _0xFFE9C53DEEA3DB0B(Any p0, Any p1, Vector3 vec, BOOL isSrlLoaded, Any p6) { return invoke<Any>(0xFFE9C53DEEA3DB0B, p0, p1, vec.x, vec.y, vec.z, isSrlLoaded, p6); } // 0xFFE9C53DEEA3DB0B b1207
	NATIVE_DECL void _0x5E3CCF03995388B5(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x5E3CCF03995388B5, p0, p1, p2, p3); } // 0x5E3CCF03995388B5 b1207
	NATIVE_DECL void _0x43037ABFE214A851() { invoke<Void>(0x43037ABFE214A851); } // 0x43037ABFE214A851 b1207
	NATIVE_DECL void SET_AMBIENT_ZONE_STATE(const char* zoneName, BOOL isEnabled, BOOL p2) { invoke<Void>(0xBDA07E5950085E46, zoneName, isEnabled, p2); } // 0xBDA07E5950085E46 0x2849CAC9 b1207
	NATIVE_DECL void CLEAR_AMBIENT_ZONE_STATE(const char* zoneName, BOOL p1) { invoke<Void>(0x218DD44AAAC964FF, zoneName, p1); } // 0x218DD44AAAC964FF 0xCDFF3C82 b1207
	NATIVE_DECL void SET_AMBIENT_ZONE_LIST_STATE(const char* ambientZone, BOOL p1, BOOL p2) { invoke<Void>(0x9748FA4DE50CCE3E, ambientZone, p1, p2); } // 0x9748FA4DE50CCE3E 0xBF80B412 b1207
	NATIVE_DECL void CLEAR_AMBIENT_ZONE_LIST_STATE(const char* ambientZone, BOOL p1) { invoke<Void>(0x120C48C614909FA4, ambientZone, p1); } // 0x120C48C614909FA4 0x38B9B8D4 b1207
	NATIVE_DECL void SET_AMBIENT_ZONE_STATE_PERSISTENT(const char* ambientZone, BOOL p1, BOOL p2) { invoke<Void>(0x1D6650420CEC9D3B, ambientZone, p1, p2); } // 0x1D6650420CEC9D3B 0xC1FFB672 b1207
	NATIVE_DECL void SET_AMBIENT_ZONE_LIST_STATE_PERSISTENT(const char* ambientZone, BOOL p1, BOOL p2) { invoke<Void>(0xF3638DAE8C4045E1, ambientZone, p1, p2); } // 0xF3638DAE8C4045E1 0x5F5A2605 b1207
	NATIVE_DECL void _SET_AMBIENT_ZONE_POSITION(const char* ambientZone, float x, float y, float z, float heading) { invoke<Void>(0x3743CE6948194349, ambientZone, x, y, z, heading); } // 0x3743CE6948194349 b1207
	NATIVE_DECL void _SET_AMBIENT_ZONE_POSITION(const char* ambientZone, Vector3 vec, float heading) { invoke<Void>(0x3743CE6948194349, ambientZone, vec.x, vec.y, vec.z, heading); } // 0x3743CE6948194349 b1207
	// Checks whether the horn of a vehicle is currently played.
	NATIVE_DECL BOOL IS_HORN_ACTIVE(Vehicle vehicle) { return invoke<BOOL>(0x9D6BFC12B05C6121, vehicle); } // 0x9D6BFC12B05C6121 0x20E2BDD0 b1207
	NATIVE_DECL void _0xFD461D0ABA5559B1(Any p0, Any p1) { invoke<Void>(0xFD461D0ABA5559B1, p0, p1); } // 0xFD461D0ABA5559B1 b1207
	NATIVE_DECL BOOL IS_STREAM_PLAYING(int streamId) { return invoke<BOOL>(0xD11FA52EB849D978, streamId); } // 0xD11FA52EB849D978 0xF1F51A14 b1207
	NATIVE_DECL BOOL LOAD_STREAM(const char* streamName, const char* soundSet) { return invoke<BOOL>(0x1F1F957154EC51DF, streamName, soundSet); } // 0x1F1F957154EC51DF 0x0D89599D b1207
	NATIVE_DECL void PLAY_STREAM_FROM_PED(Ped ped, int streamId) { invoke<Void>(0x89049DD63C08B5D1, ped, streamId); } // 0x89049DD63C08B5D1 0xA1D7FABE b1207
	NATIVE_DECL void PLAY_STREAM_FRONTEND(int streamId) { invoke<Void>(0x58FCE43488F9F5F4, streamId); } // 0x58FCE43488F9F5F4 0x2C2A16BC b1207
	NATIVE_DECL void PLAY_STREAM_FROM_POSITION(float x, float y, float z, int streamId) { invoke<Void>(0x21442F412E8DE56B, x, y, z, streamId); } // 0x21442F412E8DE56B 0x6FE5D865 b1207
	NATIVE_DECL void PLAY_STREAM_FROM_POSITION(Vector3 vec, int streamId) { invoke<Void>(0x21442F412E8DE56B, vec.x, vec.y, vec.z, streamId); } // 0x21442F412E8DE56B 0x6FE5D865 b1207
	NATIVE_DECL void _0x3A3BE6B920525237(Any p0, Any p1) { invoke<Void>(0x3A3BE6B920525237, p0, p1); } // 0x3A3BE6B920525237 b1207
	NATIVE_DECL void STOP_STREAM(int streamId) { invoke<Void>(0xA4718A1419D18151, streamId); } // 0xA4718A1419D18151 0xD1E364DE b1207
	NATIVE_DECL void STOP_PED_SPEAKING(Ped ped, BOOL shaking) { invoke<Void>(0x9D64D7405520E3D3, ped, shaking); } // 0x9D64D7405520E3D3 0xFF92B49D b1207
	NATIVE_DECL void DISABLE_PED_PAIN_AUDIO(Ped ped, BOOL toggle) { invoke<Void>(0xA9A41C1E940FB0E8, ped, toggle); } // 0xA9A41C1E940FB0E8 0x3B8E2D5F b1207
	NATIVE_DECL BOOL IS_AMBIENT_SPEECH_DISABLED(Ped ped) { return invoke<BOOL>(0x932C2D096A2C3FFF, ped); } // 0x932C2D096A2C3FFF 0x109D1F89 b1207
	NATIVE_DECL Any SET_IS_SCRIPTED_SPEECH_DISABLED(Ped ped, BOOL disabled) { return invoke<Any>(0xB2DE3AEBE31150E2, ped, disabled); } // 0xB2DE3AEBE31150E2 b1207
	NATIVE_DECL void _BLOCK_SPEECH_CONTEXT(const char* context, BOOL block) { invoke<Void>(0x6378A235374B852F, context, block); } // 0x6378A235374B852F b1207
	NATIVE_DECL void _0x87E6302FC61208CC(Any p0) { invoke<Void>(0x87E6302FC61208CC, p0); } // 0x87E6302FC61208CC b1207
	NATIVE_DECL void SET_HORN_ENABLED(Vehicle vehicle, BOOL toggle) { invoke<Void>(0x76D683C108594D0E, vehicle, toggle); } // 0x76D683C108594D0E 0x6EB92D05 b1207
	NATIVE_DECL void SET_AUDIO_VEHICLE_PRIORITY(Vehicle vehicle, Any p1) { invoke<Void>(0xE5564483E407F914, vehicle, p1); } // 0xE5564483E407F914 0x271A9766 b1207
	NATIVE_DECL void _0x259ACC5B52A2B2D9(Any p0, Any p1) { invoke<Void>(0x259ACC5B52A2B2D9, p0, p1); } // 0x259ACC5B52A2B2D9 b1207
	NATIVE_DECL void _FORCE_VEHICLE_ENGINE_AUDIO(Vehicle vehicle, const char* audioName) { invoke<Void>(0x4F0C413926060B38, vehicle, audioName); } // 0x4F0C413926060B38 0x33B0B007 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void SET_GPS_ACTIVE(BOOL active) { invoke<Void>(0x3BD3F52BA9B1E4E8, active); } // 0x3BD3F52BA9B1E4E8 0x0FC3379A b1207
	NATIVE_DECL BOOL _START_AUDIO_SCENESET(const char* audioName, const char* sceneset) { return invoke<BOOL>(0x6339C1EA3979B5F7, audioName, sceneset); } // 0x6339C1EA3979B5F7 b1207
	NATIVE_DECL void _STOP_AUDIO_SCENESET(const char* sceneset) { invoke<Void>(0x9428447DED71FC7E, sceneset); } // 0x9428447DED71FC7E b1207
	NATIVE_DECL BOOL _SET_AUDIO_SCENESET(const char* audioName, const char* sceneset) { return invoke<BOOL>(0xAC84686C06184B0D, audioName, sceneset); } // 0xAC84686C06184B0D b1207
	NATIVE_DECL BOOL START_AUDIO_SCENE(const char* scene) { return invoke<BOOL>(0x013A80FC08F6E4F2, scene); } // 0x013A80FC08F6E4F2 0xE48D757B b1207
	NATIVE_DECL Any _0xDC2F83A0612CA34D(Any p0) { return invoke<Any>(0xDC2F83A0612CA34D, p0); } // 0xDC2F83A0612CA34D b1207
	NATIVE_DECL void STOP_AUDIO_SCENE(const char* scene) { invoke<Void>(0xDFE8422B3B94E688, scene); } // 0xDFE8422B3B94E688 0xA08D8C58 b1207
	// _STOP_AUDIO_*
	NATIVE_DECL void _0x6AB944DF68B512D3(Any p0) { invoke<Void>(0x6AB944DF68B512D3, p0); } // 0x6AB944DF68B512D3 b1207
	NATIVE_DECL void STOP_AUDIO_SCENES() { invoke<Void>(0xBAC7FC81A75EC1A1); } // 0xBAC7FC81A75EC1A1 0xF6C7342A b1207
	NATIVE_DECL BOOL IS_AUDIO_SCENE_ACTIVE(const char* scene) { return invoke<BOOL>(0xB65B60556E2A9225, scene); } // 0xB65B60556E2A9225 0xACBED05C b1207
	NATIVE_DECL void SET_AUDIO_SCENE_VARIABLE(const char* scene, const char* variable, float value) { invoke<Void>(0xEF21A9EF089A2668, scene, variable, value); } // 0xEF21A9EF089A2668 0x19BB3CE8 b1207
	NATIVE_DECL Any _0x8B25A18E390F75BF(Any p0) { return invoke<Any>(0x8B25A18E390F75BF, p0); } // 0x8B25A18E390F75BF b1207
	NATIVE_DECL void ADD_ENTITY_TO_AUDIO_MIX_GROUP(Entity entity, const char* groupName, float p2) { invoke<Void>(0x153973AB99FE8980, entity, groupName, p2); } // 0x153973AB99FE8980 0x2BC93264 b1207
	NATIVE_DECL Any _0x131EC9247E7A2903(Any p0) { return invoke<Any>(0x131EC9247E7A2903, p0); } // 0x131EC9247E7A2903 b1207
	NATIVE_DECL void REMOVE_ENTITY_FROM_AUDIO_MIX_GROUP(Entity entity, float p1) { invoke<Void>(0x18EB48CFC41F2EA0, entity, p1); } // 0x18EB48CFC41F2EA0 0x308ED0EC b1207
	NATIVE_DECL Any _0xE600F61F54A444A6() { return invoke<Any>(0xE600F61F54A444A6); } // 0xE600F61F54A444A6 b1207
	NATIVE_DECL BOOL AUDIO_IS_SCRIPTED_MUSIC_PLAYING() { return invoke<BOOL>(0x845FFC3A4FEEFA3E); } // 0x845FFC3A4FEEFA3E 0x86E995D1 b1207
	// Checks for MOONSHINE_BAND
	NATIVE_DECL Hash _0xBE28DB99556FF8D9(Entity entity) { return invoke<Hash>(0xBE28DB99556FF8D9, entity); } // 0xBE28DB99556FF8D9 b1207
	NATIVE_DECL void _0x8E901B65206C2D3E(Ped ped) { invoke<Void>(0x8E901B65206C2D3E, ped); } // 0x8E901B65206C2D3E b1207
	NATIVE_DECL void _0xC4CFCE4C656EF480(Ped ped) { invoke<Void>(0xC4CFCE4C656EF480, ped); } // 0xC4CFCE4C656EF480 b1207
	NATIVE_DECL void _0xABDB4863D3D72021(Entity entity, Any p1, Any p2, float p3, Any p4) { invoke<Void>(0xABDB4863D3D72021, entity, p1, p2, p3, p4); } // 0xABDB4863D3D72021 b1207
	// Used in Script Function NET_CAMP_CLIENT_UPDATE_PED_ROLE_STATE_SHOP: hash exists! Playing hash
	NATIVE_DECL void _0xB93A769B8B726950(Ped ped, Hash p1) { invoke<Void>(0xB93A769B8B726950, ped, p1); } // 0xB93A769B8B726950 b1207
	NATIVE_DECL void _0xE891504B2F0E2DBA(Any p0, Any p1) { invoke<Void>(0xE891504B2F0E2DBA, p0, p1); } // 0xE891504B2F0E2DBA b1207
	NATIVE_DECL void _0x9EB779765E68C52E(Any p0, Any p1) { invoke<Void>(0x9EB779765E68C52E, p0, p1); } // 0x9EB779765E68C52E b1207
	NATIVE_DECL void _0xE9694B2D6CB87B06(Entity entity, Any p1) { invoke<Void>(0xE9694B2D6CB87B06, entity, p1); } // 0xE9694B2D6CB87B06 b1232
	NATIVE_DECL Any _0x886657C5B3D8EDE3(Entity entity) { return invoke<Any>(0x886657C5B3D8EDE3, entity); } // 0x886657C5B3D8EDE3 b1232
	NATIVE_DECL Any _0xC68C02DE259C927C(Any p0) { return invoke<Any>(0xC68C02DE259C927C, p0); } // 0xC68C02DE259C927C b1232
	NATIVE_DECL Any _0x2FFF4A78384AFFDF(Entity entity) { return invoke<Any>(0x2FFF4A78384AFFDF, entity); } // 0x2FFF4A78384AFFDF b1436
	NATIVE_DECL AnimScene _0x62377977E4F08668(Entity entity) { return invoke<AnimScene>(0x62377977E4F08668, entity); } // 0x62377977E4F08668 b1436
	NATIVE_DECL Any _GET_PED_SONG_INDEX_HOST(Ped ped) { return invoke<Any>(0x2DBBF0C5E19383EE, ped); } // 0x2DBBF0C5E19383EE b1232
	NATIVE_DECL Any _0xD05A460328560477(Any p0) { return invoke<Any>(0xD05A460328560477, p0); } // 0xD05A460328560477 b1232
	NATIVE_DECL void _0x8D29FDF565DED9AE(Any p0, Any p1, Any p2) { invoke<Void>(0x8D29FDF565DED9AE, p0, p1, p2); } // 0x8D29FDF565DED9AE b1232
	NATIVE_DECL void _0x448F2647DD6F2E27(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x448F2647DD6F2E27, p0, p1, p2, p3, p4); } // 0x448F2647DD6F2E27 b1232
	NATIVE_DECL void _0x139A4B9DF2D26CBF(Any p0, Any p1) { invoke<Void>(0x139A4B9DF2D26CBF, p0, p1); } // 0x139A4B9DF2D26CBF b1232
	NATIVE_DECL void _0x018ABE833CA64D2A(Any p0, Any p1) { invoke<Void>(0x018ABE833CA64D2A, p0, p1); } // 0x018ABE833CA64D2A b1232
	NATIVE_DECL void _0xBC07CA8FD710E7FD(Any p0, Any p1) { invoke<Void>(0xBC07CA8FD710E7FD, p0, p1); } // 0xBC07CA8FD710E7FD b1232
	NATIVE_DECL BOOL PREPARE_MUSIC_EVENT(const char* eventName) { return invoke<BOOL>(0x1E5185B72EF5158A, eventName); } // 0x1E5185B72EF5158A 0x534A5C1C b1207
	NATIVE_DECL BOOL CANCEL_MUSIC_EVENT(const char* eventName) { return invoke<BOOL>(0x5B17A90291133DA5, eventName); } // 0x5B17A90291133DA5 0x89FF942D b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/audio/music_events/music_events.lua
	NATIVE_DECL BOOL TRIGGER_MUSIC_EVENT(const char* eventName) { return invoke<BOOL>(0x706D57B0F50DA710, eventName); } // 0x706D57B0F50DA710 0xB6094948 b1207
	NATIVE_DECL Any _TRIGGER_MUSIC_EVENT_WITH_HASH(Hash eventName) { return invoke<Any>(0x05D6195FB4D428F4, eventName); } // 0x05D6195FB4D428F4 b1207
	NATIVE_DECL int GET_MUSIC_PLAYTIME() { return invoke<int>(0xE7A0D23DC414507B); } // 0xE7A0D23DC414507B 0xD633C809 b1207
	NATIVE_DECL void _0xF64034D533CE8AAC(Any p0, Any p1, Any p2) { invoke<Void>(0xF64034D533CE8AAC, p0, p1, p2); } // 0xF64034D533CE8AAC b1207
	// https://en.m.wikipedia.org/wiki/Walla
	NATIVE_DECL void SET_PED_WALLA_DENSITY(float p0, float p1) { invoke<Void>(0x149AEE66F0CB3A99, p0, p1); } // 0x149AEE66F0CB3A99 0xE64F97A0 b1207
	NATIVE_DECL void _0xDAD6CD07CAA4F382() { invoke<Void>(0xDAD6CD07CAA4F382); } // 0xDAD6CD07CAA4F382 b1207
	NATIVE_DECL void SET_PED_INTERIOR_WALLA_DENSITY(float p0, float p1) { invoke<Void>(0x8BF907833BE275DE, p0, p1); } // 0x8BF907833BE275DE 0x2CD26D69 b1207
	NATIVE_DECL void FORCE_PED_PANIC_WALLA() { invoke<Void>(0x062D5EAD4DA2FA6A); } // 0x062D5EAD4DA2FA6A 0xD87AF337 b1207
	NATIVE_DECL void _0x138ADB94F8B90616() { invoke<Void>(0x138ADB94F8B90616); } // 0x138ADB94F8B90616 b1207
	// Something like UPDATE_PED_*
	NATIVE_DECL void _0xBF4DC1784BE94DFA(Ped ped, BOOL p1, Hash hash) { invoke<Void>(0xBF4DC1784BE94DFA, ped, p1, hash); } // 0xBF4DC1784BE94DFA 0xD99E275B b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/audio/audio_flags
	NATIVE_DECL void SET_AUDIO_FLAG(const char* flagName, BOOL toggle) { invoke<Void>(0xB9EFD5C25018725A, flagName, toggle); } // 0xB9EFD5C25018725A 0x1C09C9E0 b1207
	NATIVE_DECL void _0x6DA15746D5CC1A92(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x6DA15746D5CC1A92, p0, p1, p2, p3, p4, p5); } // 0x6DA15746D5CC1A92 b1207
	NATIVE_DECL void _0x078F77FD1A43EAB3(Any p0, Any p1) { invoke<Void>(0x078F77FD1A43EAB3, p0, p1); } // 0x078F77FD1A43EAB3 b1207
	NATIVE_DECL void _0x3D0BBCCF401B5FDB() { invoke<Void>(0x3D0BBCCF401B5FDB); } // 0x3D0BBCCF401B5FDB b1207
	NATIVE_DECL void SET_PORTAL_SETTINGS_OVERRIDE(const char* p0, const char* p1) { invoke<Void>(0x044DBAD7A7FA2BE5, p0, p1); } // 0x044DBAD7A7FA2BE5 0x8AD670EC b1207
	NATIVE_DECL void REMOVE_PORTAL_SETTINGS_OVERRIDE(const char* p0) { invoke<Void>(0xB4BBFD9CD8B3922B, p0); } // 0xB4BBFD9CD8B3922B 0xD24B4D0C b1207
	NATIVE_DECL void _0xEA546C31FD45F8CD(Any p0) { invoke<Void>(0xEA546C31FD45F8CD, p0); } // 0xEA546C31FD45F8CD b1207
	NATIVE_DECL Any _0x44A5EEF54F62E823(Any p0) { return invoke<Any>(0x44A5EEF54F62E823, p0); } // 0x44A5EEF54F62E823 b1207
	NATIVE_DECL void _0x017492B2201E3428(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x017492B2201E3428, p0, p1, p2, p3); } // 0x017492B2201E3428 b1207
	NATIVE_DECL void _0xC886CD666ADD42E1(Any p0, Any p1) { invoke<Void>(0xC886CD666ADD42E1, p0, p1); } // 0xC886CD666ADD42E1 b1207
	NATIVE_DECL void _0x5AE0CB5F35F034FD(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0x5AE0CB5F35F034FD, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x5AE0CB5F35F034FD b1207
	NATIVE_DECL void _0x821C32C728B24477(Any p0, Any p1, Any p2) { invoke<Void>(0x821C32C728B24477, p0, p1, p2); } // 0x821C32C728B24477 b1207
	NATIVE_DECL void _0x06C5DF5EE444BC6B(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x06C5DF5EE444BC6B, p0, p1, p2, p3, p4); } // 0x06C5DF5EE444BC6B b1207
	NATIVE_DECL void _0x341CDD17EFC2472E(Any p0, Any p1) { invoke<Void>(0x341CDD17EFC2472E, p0, p1); } // 0x341CDD17EFC2472E b1207
	NATIVE_DECL void _0x7E176C676F8652A9(Any p0) { invoke<Void>(0x7E176C676F8652A9, p0); } // 0x7E176C676F8652A9 b1207
	NATIVE_DECL Any _0x2B9C37C01BF25EDB(Any p0) { return invoke<Any>(0x2B9C37C01BF25EDB, p0); } // 0x2B9C37C01BF25EDB b1207
	NATIVE_DECL Any _0xA6A3A3F96B8B030E() { return invoke<Any>(0xA6A3A3F96B8B030E); } // 0xA6A3A3F96B8B030E b1207
	// Creates stream and returns streamId handle to be used with PLAY_STREAM_* natives
	// https://github.com/femga/rdr3_discoveries/tree/master/audio/create_stream
	NATIVE_DECL int _GET_LOADED_STREAM_ID_FROM_CREATION(const char* streamName, const char* soundSet) { return invoke<int>(0x0556C784FA056628, streamName, soundSet); } // 0x0556C784FA056628 b1207
	NATIVE_DECL Any _0xC369E2234E34A0CA(Any p0, Any p1) { return invoke<Any>(0xC369E2234E34A0CA, p0, p1); } // 0xC369E2234E34A0CA b1207
	NATIVE_DECL void _0x35B8C070E0C16E2F(Any p0, Any p1) { invoke<Void>(0x35B8C070E0C16E2F, p0, p1); } // 0x35B8C070E0C16E2F b1207
	NATIVE_DECL void _0xE7E6CB8B713ED190() { invoke<Void>(0xE7E6CB8B713ED190); } // 0xE7E6CB8B713ED190 b1207
	NATIVE_DECL void _0x569ABC36E28DDEAA() { invoke<Void>(0x569ABC36E28DDEAA); } // 0x569ABC36E28DDEAA b1207
	NATIVE_DECL void _0x839C9F124BE74D94(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x839C9F124BE74D94, p0, p1, p2, p3, p4); } // 0x839C9F124BE74D94 b1207
	NATIVE_DECL void AUDIO_TRIGGER_EXPLOSION(const char* name, float x, float y, float z) { invoke<Void>(0x374F0E716BFCDE82, name, x, y, z); } // 0x374F0E716BFCDE82 b1207
	NATIVE_DECL void AUDIO_TRIGGER_EXPLOSION(const char* name, Vector3 vec) { invoke<Void>(0x374F0E716BFCDE82, name, vec.x, vec.y, vec.z); } // 0x374F0E716BFCDE82 b1207
	NATIVE_DECL void _0x3E98AC9D8C56C62C(Any p0) { invoke<Void>(0x3E98AC9D8C56C62C, p0); } // 0x3E98AC9D8C56C62C b1207
	NATIVE_DECL void _0xCBF2BEBB468A34F3(Any p0) { invoke<Void>(0xCBF2BEBB468A34F3, p0); } // 0xCBF2BEBB468A34F3 b1207
	NATIVE_DECL void _0xA2B851605748AD0E() { invoke<Void>(0xA2B851605748AD0E); } // 0xA2B851605748AD0E b1207
	NATIVE_DECL void _0xCFAD2C8CD1054523(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xCFAD2C8CD1054523, p0, p1, p2, p3); } // 0xCFAD2C8CD1054523 b1207
	NATIVE_DECL void _0xD733528B6C35647A(Any p0, Any p1) { invoke<Void>(0xD733528B6C35647A, p0, p1); } // 0xD733528B6C35647A b1207
	NATIVE_DECL void _0x5BC885EBD75FAA7D(Any p0, Any p1) { invoke<Void>(0x5BC885EBD75FAA7D, p0, p1); } // 0x5BC885EBD75FAA7D b1207
	NATIVE_DECL void _0x6B7A88A61B41E589(Any p0) { invoke<Void>(0x6B7A88A61B41E589, p0); } // 0x6B7A88A61B41E589 b1207
	NATIVE_DECL void _0x4BE3EC91C01F0FE8() { invoke<Void>(0x4BE3EC91C01F0FE8); } // 0x4BE3EC91C01F0FE8 b1207
	NATIVE_DECL void SET_AUDIO_ONLINE_TRANSITION_STAGE(const char* p0) { invoke<Void>(0x9B1FC259187C97C0, p0); } // 0x9B1FC259187C97C0 b1207
	NATIVE_DECL void _0x2E399EAFBEEA74D5() { invoke<Void>(0x2E399EAFBEEA74D5); } // 0x2E399EAFBEEA74D5 b1207
	NATIVE_DECL void _0x64B956F4E761DF5C(Any p0) { invoke<Void>(0x64B956F4E761DF5C, p0); } // 0x64B956F4E761DF5C b1207
}

namespace BOUNTY
{
	NATIVE_DECL BOOL _BOUNTY_REQUEST_PAY_OFF_BOUNTY(Any* outRpcGuid) { return invoke<BOOL>(0x537CE992BD2D7BCB, outRpcGuid); } // 0x537CE992BD2D7BCB b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_PAY_OFF_BOUNTY_EX(Any* outRpcGuid, Hash p1, Hash costType) { return invoke<BOOL>(0x587BCEC31D64F382, outRpcGuid, p1, costType); } // 0x587BCEC31D64F382 b1232
	// crimeType: see _REPORT_CRIME
	NATIVE_DECL BOOL _BOUNTY_REQUEST_SELF_REPORT_CRIME(Any* outRpcGuid, Hash crimeType, BOOL p2) { return invoke<BOOL>(0x188B748861B5BA17, outRpcGuid, crimeType, p2); } // 0x188B748861B5BA17 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_SELF_REPORT_KILLED_BY_BOUNTY_HUNTER(Any* outRpcGuid) { return invoke<BOOL>(0xB462D69D406A2602, outRpcGuid); } // 0xB462D69D406A2602 b1207
	NATIVE_DECL BOOL BOUNTY_GET_BOUNTY_ON_PLAYER(Any* gamerHandle, Any* bountyData) { return invoke<BOOL>(0x4EF23E04A0C8FF51, gamerHandle, bountyData); } // 0x4EF23E04A0C8FF51 b1207
	NATIVE_DECL BOOL _BOUNTY_IS_REQUEST_PENDING(Any* rpcGuid) { return invoke<BOOL>(0x03B61CD51097DE60, rpcGuid); } // 0x03B61CD51097DE60 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_BEGIN_WANTED_POSTER(Any* outRpcGuid, int p1) { return invoke<BOOL>(0xFFA13742E43507E3, outRpcGuid, p1); } // 0xFFA13742E43507E3 b1207
	NATIVE_DECL BOOL _0x81847C2134039BDC(Any* p0) { return invoke<BOOL>(0x81847C2134039BDC, p0); } // 0x81847C2134039BDC b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_COMPLETE_WANTED_POSTER(Any* outRpcGuid, Any* p1) { return invoke<BOOL>(0x727AB6F008BB9F29, outRpcGuid, p1); } // 0x727AB6F008BB9F29 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_COMPLETE_SPLIT_WANTED_POSTER(Any* outRpcGuid, Any* p1) { return invoke<BOOL>(0xFBD137BF0EC50FC9, outRpcGuid, p1); } // 0xFBD137BF0EC50FC9 b1207
	NATIVE_DECL void _BOUNTY_CANCEL_WANTED_POSTER() { invoke<Void>(0x6A9DF0FCD0C87FF9); } // 0x6A9DF0FCD0C87FF9 b1207
	NATIVE_DECL BOOL BOUNTY_REQUEST_BEGIN_LEGENDARY_MISSION(Any* outRpcGuid, int p1, int p2) { return invoke<BOOL>(0xFC81D7C7A151CFAA, outRpcGuid, p1, p2); } // 0xFC81D7C7A151CFAA b1207
	NATIVE_DECL BOOL BOUNTY_REQUEST_BEGIN_LEGENDARY_MISSION_FOR_POSSE(Any* outRpcGuid, int p1, int p2) { return invoke<BOOL>(0x48E4E23F1739E197, outRpcGuid, p1, p2); } // 0x48E4E23F1739E197 b1311
	NATIVE_DECL BOOL _BOUNTY_REQUEST_COMPLETE_LEGENDARY_MISSION(Any* outRpcGuid, Any* p1) { return invoke<BOOL>(0xA7309AC0DCF6D950, outRpcGuid, p1); } // 0xA7309AC0DCF6D950 b1207
	NATIVE_DECL void _BOUNTY_CANCEL_LEGENDARY_MISSION() { invoke<Void>(0x2BA1BCC99826CDA2); } // 0x2BA1BCC99826CDA2 b1207
	NATIVE_DECL BOOL BOUNTY_GET_WANTED_POSTER_SLOT(Hash p0, Hash p1, Any* p2) { return invoke<BOOL>(0xB395A44A0C7CA615, p0, p1, p2); } // 0xB395A44A0C7CA615 b1207
	NATIVE_DECL BOOL BOUNTY_GET_LEGENDARY_TARGET(Any p0, Any* p1) { return invoke<BOOL>(0x85E4D7B225A30ED1, p0, p1); } // 0x85E4D7B225A30ED1 b1207
	// _BOUNTY_C* or _BOUNTY_GET_*
	NATIVE_DECL BOOL _0x86EC5F83867C4B70(Any* p0) { return invoke<BOOL>(0x86EC5F83867C4B70, p0); } // 0x86EC5F83867C4B70 b1436
	NATIVE_DECL BOOL BOUNTY_GET_COOLDOWN_COLLECTION(Any* p0) { return invoke<BOOL>(0x8FAF4D262FABA99C, p0); } // 0x8FAF4D262FABA99C b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_BECOME_TARGET_OF_CHARACTER_BOUNTY_HUNT(Any* outRpcGuid) { return invoke<BOOL>(0xB096547D61868254, outRpcGuid); } // 0xB096547D61868254 b1207
	// _BOUNTY_IS_* or _BOUNTY_REQUEST_*
	NATIVE_DECL BOOL _0x27D3A0E1FE090A43(Any* p0) { return invoke<BOOL>(0x27D3A0E1FE090A43, p0); } // 0x27D3A0E1FE090A43 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_CLAIM_CHARACTER_BOUNTY(Any* outRpcGuid, int p1, Any* p2) { return invoke<BOOL>(0xA9C3B0F746375162, outRpcGuid, p1, p2); } // 0xA9C3B0F746375162 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_POSSE_LEADER_CLAIM_CHARACTER_BOUNTY(Any* outRpcGuid, int p1, Any* p2) { return invoke<BOOL>(0x5B53CA0E2AC3FF45, outRpcGuid, p1, p2); } // 0x5B53CA0E2AC3FF45 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_POSSE_MEMBER_CLAIM_CHARACTER_BOUNTY_SHARE(Any* outRpcGuid, Any* p1) { return invoke<BOOL>(0x22D3A61CE053270C, outRpcGuid, p1); } // 0x22D3A61CE053270C b1207
	NATIVE_DECL void _BOUNTY_CLEAR_BEING_BOUNTY_HUNTER() { invoke<Void>(0xA59D1997ECD99F0A); } // 0xA59D1997ECD99F0A b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_ESCAPED_CHARACTER_BOUNTY_HUNT(Any* outRpcGuid) { return invoke<BOOL>(0x12E981D53B07BF48, outRpcGuid); } // 0x12E981D53B07BF48 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_POSSE_LEADER_ESCAPED_CHARACTER_BOUNTY_HUNT(Any* outRpcGuid) { return invoke<BOOL>(0x2D874BA20E8E1F20, outRpcGuid); } // 0x2D874BA20E8E1F20 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_POSSE_MEMBER_ESCAPED_CHARACTER_BOUNTY_HUNT(Any* outRpcGuid) { return invoke<BOOL>(0x8521C2E235558278, outRpcGuid); } // 0x8521C2E235558278 b1207
	NATIVE_DECL void _BOUNTY_CLEAR_BEING_TARGET() { invoke<Void>(0x932DB3C05A7465D1); } // 0x932DB3C05A7465D1 b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_SERVED_FULL_JAIL_SENTENCE(Any* outRpcGuid) { return invoke<BOOL>(0x3F73AED12A5EF0FF, outRpcGuid); } // 0x3F73AED12A5EF0FF b1207
	NATIVE_DECL BOOL _BOUNTY_REQUEST_BRIBE_JAIL_GUARD(Any* outRpcGuid, int p1) { return invoke<BOOL>(0x28717806D3BDD0D0, outRpcGuid, p1); } // 0x28717806D3BDD0D0 b1207
	// _BOUNTY_GET_*
	NATIVE_DECL int _0xF8BCC5ECA33AC9C1() { return invoke<int>(0xF8BCC5ECA33AC9C1); } // 0xF8BCC5ECA33AC9C1 b1207
	// _BOUNTY_GET_*
	NATIVE_DECL int _0xD6A67E2FF373D0E3(int p0) { return invoke<int>(0xD6A67E2FF373D0E3, p0); } // 0xD6A67E2FF373D0E3 b1355
}

namespace BRAIN
{
	// Registers a script for any object with a specific model hash.
	NATIVE_DECL void REGISTER_OBJECT_SCRIPT_BRAIN(const char* scriptName, Hash modelHash, int p2, float activationRange, int p4, int p5) { invoke<Void>(0x16AF9B4EEAC3B305, scriptName, modelHash, p2, activationRange, p4, p5); } // 0x16AF9B4EEAC3B305 0xB6BCC608 b1207
	// Returns threadId
	NATIVE_DECL int _START_PRELOADED_SCRIPT_BRAIN(Entity entity, const char* scriptName, int scriptStackSize, BOOL p3) { return invoke<int>(0x4E4507CC5E4DB869, entity, scriptName, scriptStackSize, p3); } // 0x4E4507CC5E4DB869 b1207
	// Returns threadId
	NATIVE_DECL int _START_SCRIPT_BRAIN(Entity entity, const char* scriptName, int p2, Any* p3, int p4, BOOL p5) { return invoke<int>(0x6F62FAE266DCFC81, entity, scriptName, p2, p3, p4, p5); } // 0x6F62FAE266DCFC81 b1207
	NATIVE_DECL void _REMOVE_SCRIPT_BRAIN_ENTITY(Entity entity) { invoke<Void>(0x38F1E09224EECA09, entity); } // 0x38F1E09224EECA09 b1311
	NATIVE_DECL Entity _GET_SCRIPT_BRAIN_ENTITY() { return invoke<Entity>(0x6818D1A194E29983); } // 0x6818D1A194E29983 b1207
	// Common flags: 250, 99999
	// _SET_SCRIPT_BRAIN*
	NATIVE_DECL void _0xA6AC35DB4A7957A8(int flag) { invoke<Void>(0xA6AC35DB4A7957A8, flag); } // 0xA6AC35DB4A7957A8 b1207
	// Called with flag 0 before 0xA6AC35DB4A7957A8 in net_entity_brain
	// _SET_SCRIPT_BRAIN*
	NATIVE_DECL void _0x4AA5EA1EDFB25786(int flag) { invoke<Void>(0x4AA5EA1EDFB25786, flag); } // 0x4AA5EA1EDFB25786 b1207
	NATIVE_DECL void ENABLE_SCRIPT_BRAIN_SET(int brainSet) { invoke<Void>(0x1CF6E5C6750EADBD, brainSet); } // 0x1CF6E5C6750EADBD 0x2765919F b1207
	NATIVE_DECL void DISABLE_SCRIPT_BRAIN_SET(int brainSet) { invoke<Void>(0x3F44EA613A5B2676, brainSet); } // 0x3F44EA613A5B2676 0xFBD13FAD b1207
	// Called before starting a new thread_monitor script thread in startup_mp/startup_tlg
	// Alternative name _REGISTER_SCRIPT_BRAIN
	NATIVE_DECL void _PREPARE_SCRIPT_BRAIN() { invoke<Void>(0xA32B0B05EFF75730); } // 0xA32B0B05EFF75730 0xF3A3AB08 b1207
	// _PREPARE*, - _REGISTER*
	NATIVE_DECL void _0x74C333E34DF74E8A(const char* scriptName) { invoke<Void>(0x74C333E34DF74E8A, scriptName); } // 0x74C333E34DF74E8A 0x29CE8BAA b1207
}

namespace CAM
{
	// ease - smooth transition between the camera's positions
	// easeTime - Time in milliseconds for the transition to happen
	// 
	// If you have created a script (rendering) camera, and want to go back to the 
	// character (gameplay) camera, call this native with render set to FALSE.
	// Setting ease to TRUE will smooth the transition.
	NATIVE_DECL void RENDER_SCRIPT_CAMS(BOOL render, BOOL ease, int easeTime, BOOL p3, BOOL p4, int p5) { invoke<Void>(0x33281167E4942E4F, render, ease, easeTime, p3, p4, p5); } // 0x33281167E4942E4F 0x74337969 b1207
	// This native makes the gameplay camera zoom into first person/third person with a special effect.
	// blendBackSmoothingType: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/STOP_RENDERING_SCRIPT_CAMS_USING_CATCH_UP/README.md
	NATIVE_DECL void STOP_RENDERING_SCRIPT_CAMS_USING_CATCH_UP(BOOL render, float distance, int blendBackSmoothingType, BOOL p3, BOOL p4, BOOL p5) { invoke<Void>(0x8C7C7FF7CF0E5153, render, distance, blendBackSmoothingType, p3, p4, p5); } // 0x8C7C7FF7CF0E5153 0xD3C08183 b1207
	NATIVE_DECL Cam CREATE_CAM(const char* camName, BOOL p1) { return invoke<Cam>(0xE72CDBA7F0A02DD6, camName, p1); } // 0xE72CDBA7F0A02DD6 0xE9BF2A7D b1207
	NATIVE_DECL Cam CREATE_CAM_WITH_PARAMS(const char* camName, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float fov, BOOL p8, int p9) { return invoke<Cam>(0x40C23491CE83708E, camName, posX, posY, posZ, rotX, rotY, rotZ, fov, p8, p9); } // 0x40C23491CE83708E 0x23B02F15 b1207
	NATIVE_DECL Cam CREATE_CAM_WITH_PARAMS(const char* camName, Vector3 pos, Vector3 rot, float fov, BOOL p8, int p9) { return invoke<Cam>(0x40C23491CE83708E, camName, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, fov, p8, p9); } // 0x40C23491CE83708E 0x23B02F15 b1207
	NATIVE_DECL Cam CREATE_CAMERA(Hash camHash, BOOL p1) { return invoke<Cam>(0x57CDF879EA466C46, camHash, p1); } // 0x57CDF879EA466C46 0x5D6739AE b1207
	NATIVE_DECL Cam CREATE_CAMERA_WITH_PARAMS(Hash camHash, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float fov, BOOL p8, Any p9) { return invoke<Cam>(0x98B99B9F27E2D60B, camHash, posX, posY, posZ, rotX, rotY, rotZ, fov, p8, p9); } // 0x98B99B9F27E2D60B 0x0688BE9A b1207
	NATIVE_DECL Cam CREATE_CAMERA_WITH_PARAMS(Hash camHash, Vector3 pos, Vector3 rot, float fov, BOOL p8, Any p9) { return invoke<Cam>(0x98B99B9F27E2D60B, camHash, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, fov, p8, p9); } // 0x98B99B9F27E2D60B 0x0688BE9A b1207
	// BOOL param indicates whether the cam should be destroyed if it belongs to the calling script.
	NATIVE_DECL void DESTROY_CAM(Cam cam, BOOL p1) { invoke<Void>(0x4E67E0B6D7FD5145, cam, p1); } // 0x4E67E0B6D7FD5145 0xC39302BD b1207
	// BOOL param indicates whether the cam should be destroyed if it belongs to the calling script.
	NATIVE_DECL void DESTROY_ALL_CAMS(BOOL p0) { invoke<Void>(0x163600D6E136C9F8, p0); } // 0x163600D6E136C9F8 0x10C151CE b1207
	// Returns whether or not the passed camera handle exists.
	NATIVE_DECL BOOL DOES_CAM_EXIST(Cam cam) { return invoke<BOOL>(0x153AD457764FD704, cam); } // 0x153AD457764FD704 0x1EF89DC0 b1207
	// Set camera as active/inactive.
	NATIVE_DECL void SET_CAM_ACTIVE(Cam cam, BOOL active) { invoke<Void>(0x87295BCA613800C8, cam, active); } // 0x87295BCA613800C8 0x064659C2 b1207
	// Returns whether or not the passed camera handle is active.
	NATIVE_DECL BOOL IS_CAM_ACTIVE(Cam cam) { return invoke<BOOL>(0x63EFCC7E1810B8E6, cam); } // 0x63EFCC7E1810B8E6 0x4B58F177 b1207
	NATIVE_DECL BOOL IS_CAM_RENDERING(Cam cam) { return invoke<BOOL>(0x4415F8A6C536D39F, cam); } // 0x4415F8A6C536D39F 0x6EC6B5B2 b1207
	NATIVE_DECL Cam GET_RENDERING_CAM() { return invoke<Cam>(0x03A8931ECC8015D6); } // 0x03A8931ECC8015D6 0x0FCF4DF1 b1207
	NATIVE_DECL Vector3 GET_CAM_COORD(Cam cam) { return invoke<Vector3>(0x6B12F11C2A9F0344, cam); } // 0x6B12F11C2A9F0344 0x7C40F09C b1207
	NATIVE_DECL Vector3 GET_CAM_ROT(Cam cam, int rotationOrder) { return invoke<Vector3>(0x9BF96B57254E7889, cam, rotationOrder); } // 0x9BF96B57254E7889 0xDAC84C9F b1207
	NATIVE_DECL float GET_CAM_FOV(Cam cam) { return invoke<float>(0x8101D32A0A6B0F60, cam); } // 0x8101D32A0A6B0F60 0xD6E9FCF5 b1207
	NATIVE_DECL void SET_CAM_PARAMS(Cam cam, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float fieldOfView, Any p8, int p9, int p10, int p11, Any p12, Any p13) { invoke<Void>(0xA47BBFFFB83D4D0A, cam, posX, posY, posZ, rotX, rotY, rotZ, fieldOfView, p8, p9, p10, p11, p12, p13); } // 0xA47BBFFFB83D4D0A 0x2167CEBF b1207
	NATIVE_DECL void SET_CAM_PARAMS(Cam cam, Vector3 pos, Vector3 rot, float fieldOfView, Any p8, int p9, int p10, int p11, Any p12, Any p13) { invoke<Void>(0xA47BBFFFB83D4D0A, cam, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, fieldOfView, p8, p9, p10, p11, p12, p13); } // 0xA47BBFFFB83D4D0A 0x2167CEBF b1207
	// Sets the position of the cam.
	NATIVE_DECL void SET_CAM_COORD(Cam cam, float posX, float posY, float posZ) { invoke<Void>(0xF9EE7D419EE49DE6, cam, posX, posY, posZ); } // 0xF9EE7D419EE49DE6 0x7A8053AF b1207
	NATIVE_DECL void SET_CAM_COORD(Cam cam, Vector3 pos) { invoke<Void>(0xF9EE7D419EE49DE6, cam, pos.x, pos.y, pos.z); } // 0xF9EE7D419EE49DE6 0x7A8053AF b1207
	// Sets the rotation of the cam.
	NATIVE_DECL void SET_CAM_ROT(Cam cam, float rotX, float rotY, float rotZ, int rotationOrder) { invoke<Void>(0x63DFA6810AD78719, cam, rotX, rotY, rotZ, rotationOrder); } // 0x63DFA6810AD78719 0xEE38B3C1 b1207
	NATIVE_DECL void SET_CAM_ROT(Cam cam, Vector3 rot, int rotationOrder) { invoke<Void>(0x63DFA6810AD78719, cam, rot.x, rot.y, rot.z, rotationOrder); } // 0x63DFA6810AD78719 0xEE38B3C1 b1207
	// Sets the field of view of the cam.
	// 
	// Min: 1.0f
	// Max: 130.0f
	NATIVE_DECL void SET_CAM_FOV(Cam cam, float fieldOfView) { invoke<Void>(0x27666E5988D9D429, cam, fieldOfView); } // 0x27666E5988D9D429 0xD3D5D74F b1207
	NATIVE_DECL void SET_CAM_NEAR_CLIP(Cam cam, float nearClip) { invoke<Void>(0xA924028272A61364, cam, nearClip); } // 0xA924028272A61364 0x46DB13B1 b1207
	NATIVE_DECL void SET_CAM_FAR_CLIP(Cam cam, float farClip) { invoke<Void>(0x5E32817BF6302111, cam, farClip); } // 0x5E32817BF6302111 0x0D23E381 b1207
	NATIVE_DECL void SET_CAM_MOTION_BLUR_STRENGTH(Cam cam, float strength) { invoke<Void>(0x45FD891364181F9E, cam, strength); } // 0x45FD891364181F9E 0xFD6E0D67 b1207
	NATIVE_DECL void _0xFC3F638BE2B6BB02() { invoke<Void>(0xFC3F638BE2B6BB02); } // 0xFC3F638BE2B6BB02 b1207
	NATIVE_DECL void _0xE4B7945EF4F1BFB2(Cam cam, float* p1) { invoke<Void>(0xE4B7945EF4F1BFB2, cam, p1); } // 0xE4B7945EF4F1BFB2 b1207
	NATIVE_DECL void _0x1FC6C727D30FFDDE(Any p0) { invoke<Void>(0x1FC6C727D30FFDDE, p0); } // 0x1FC6C727D30FFDDE b1207
	// Last param determines if its relative to the Entity
	NATIVE_DECL void ATTACH_CAM_TO_ENTITY(Cam cam, Entity entity, float xOffset, float yOffset, float zOffset, BOOL isRelative) { invoke<Void>(0xFDC0DF7F6FB0A592, cam, entity, xOffset, yOffset, zOffset, isRelative); } // 0xFDC0DF7F6FB0A592 0xAD7C45F6 b1207
	NATIVE_DECL void ATTACH_CAM_TO_ENTITY(Cam cam, Entity entity, Vector3 offset, BOOL isRelative) { invoke<Void>(0xFDC0DF7F6FB0A592, cam, entity, offset.x, offset.y, offset.z, isRelative); } // 0xFDC0DF7F6FB0A592 0xAD7C45F6 b1207
	// boneIndex: https://github.com/femga/rdr3_discoveries/tree/master/boneNames
	NATIVE_DECL void ATTACH_CAM_TO_PED_BONE(Cam cam, Ped ped, int boneIndex, float x, float y, float z, BOOL heading) { invoke<Void>(0xDFC1E4A44C0324CA, cam, ped, boneIndex, x, y, z, heading); } // 0xDFC1E4A44C0324CA 0x506BB35C b1207
	NATIVE_DECL void ATTACH_CAM_TO_PED_BONE(Cam cam, Ped ped, int boneIndex, Vector3 vec, BOOL heading) { invoke<Void>(0xDFC1E4A44C0324CA, cam, ped, boneIndex, vec.x, vec.y, vec.z, heading); } // 0xDFC1E4A44C0324CA 0x506BB35C b1207
	NATIVE_DECL void DETACH_CAM(Cam cam) { invoke<Void>(0x05B41DDBEB559556, cam); } // 0x05B41DDBEB559556 0xF4FBF14A b1207
	NATIVE_DECL void POINT_CAM_AT_COORD(Cam cam, float x, float y, float z) { invoke<Void>(0x948B39341C3A40C2, cam, x, y, z); } // 0x948B39341C3A40C2 0x914BC21A b1207
	NATIVE_DECL void POINT_CAM_AT_COORD(Cam cam, Vector3 vec) { invoke<Void>(0x948B39341C3A40C2, cam, vec.x, vec.y, vec.z); } // 0x948B39341C3A40C2 0x914BC21A b1207
	NATIVE_DECL void POINT_CAM_AT_ENTITY(Cam cam, Entity entity, float p2, float p3, float p4, BOOL p5) { invoke<Void>(0xFC2867E6074D3A61, cam, entity, p2, p3, p4, p5); } // 0xFC2867E6074D3A61 0x7597A0F7 b1207
	NATIVE_DECL void STOP_CAM_POINTING(Cam cam) { invoke<Void>(0xCA1B30A3357C71F1, cam); } // 0xCA1B30A3357C71F1 0x5435F6A5 b1207
	NATIVE_DECL void _SET_CAM_FOCUS_DISTANCE(Cam cam, float distance) { invoke<Void>(0x11F32BB61B756732, cam, distance); } // 0x11F32BB61B756732 b1207
	NATIVE_DECL void _0x9F97E85EC142255E(Any p0, Any p1) { invoke<Void>(0x9F97E85EC142255E, p0, p1); } // 0x9F97E85EC142255E b1207
	// Allows you to aim and shoot at the direction the camera is facing.
	NATIVE_DECL void SET_CAM_AFFECTS_AIMING(Cam cam, BOOL toggle) { invoke<Void>(0x3CB9E8BDE5E76F33, cam, toggle); } // 0x3CB9E8BDE5E76F33 0x0C74F9AF b1207
	NATIVE_DECL void SET_CAM_CONTROLS_MINI_MAP_HEADING(Cam cam, BOOL p1) { invoke<Void>(0x1B8F3CE5A6001298, cam, p1); } // 0x1B8F3CE5A6001298 0xE1A0B2F1 b1207
	NATIVE_DECL void _0x42ED56B02E05D109(Any p0, BOOL p1) { invoke<Void>(0x42ED56B02E05D109, p0, p1); } // 0x42ED56B02E05D109 0x43220969 b1207
	// p7 (length) determines the length of the spline, affects camera path and duration of transition between previous node and this one
	// 
	// p8 big values ~100 will slow down the camera movement before reaching this node
	// 
	// p9 != 0 seems to override the rotation/pitch (bool?)
	NATIVE_DECL void ADD_CAM_SPLINE_NODE(Cam camera, float x, float y, float z, float xRot, float yRot, float zRot, int length, int p8, int p9) { invoke<Void>(0xF1F57F9D230F9CD1, camera, x, y, z, xRot, yRot, zRot, length, p8, p9); } // 0xF1F57F9D230F9CD1 0xAD3C7EAA b1207
	NATIVE_DECL void ADD_CAM_SPLINE_NODE(Cam camera, Vector3 vec, Vector3 rot, int length, int p8, int p9) { invoke<Void>(0xF1F57F9D230F9CD1, camera, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, length, p8, p9); } // 0xF1F57F9D230F9CD1 0xAD3C7EAA b1207
	NATIVE_DECL void SET_CAM_SPLINE_PHASE(Cam cam, float p1) { invoke<Void>(0xF1898A68E7C15636, cam, p1); } // 0xF1898A68E7C15636 0xF0AED233 b1207
	// Can use this with SET_CAM_SPLINE_PHASE to set the float it this native returns.
	// 
	// (returns 1.0f when no nodes has been added, reached end of non existing spline)
	NATIVE_DECL float GET_CAM_SPLINE_PHASE(Cam cam) { return invoke<float>(0x095EDCD24D90033A, cam); } // 0x095EDCD24D90033A 0x39784DD9 b1207
	NATIVE_DECL void SET_CAM_SPLINE_DURATION(Cam cam, int timeDuration) { invoke<Void>(0xFF6311652CA91015, cam, timeDuration); } // 0xFF6311652CA91015 0x3E91FC8A b1207
	NATIVE_DECL void SET_CAM_SPLINE_SMOOTHING_STYLE(Cam cam, int smoothingStyle) { invoke<Void>(0x84B3645618E726B0, cam, smoothingStyle); } // 0x84B3645618E726B0 0x15E141CE b1207
	NATIVE_DECL void SET_CAM_ACTIVE_WITH_INTERP(Cam camTo, Cam camFrom, int duration, int easeLocation, int easeRotation) { invoke<Void>(0x8B15AE2987C1AC8F, camTo, camFrom, duration, easeLocation, easeRotation); } // 0x8B15AE2987C1AC8F 0x7983E7F0 b1207
	NATIVE_DECL BOOL IS_CAM_INTERPOLATING(Cam cam) { return invoke<BOOL>(0x578F8F1CAA17BD2B, cam); } // 0x578F8F1CAA17BD2B 0x7159CB5D b1207
	NATIVE_DECL void SHAKE_CAM(Cam cam, const char* type, float amplitude) { invoke<Void>(0xF9A7BCF5D050D4E7, cam, type, amplitude); } // 0xF9A7BCF5D050D4E7 0x1D4211B0 b1207
	NATIVE_DECL BOOL IS_CAM_SHAKING(Cam cam) { return invoke<BOOL>(0x2EEB402BD7320159, cam); } // 0x2EEB402BD7320159 0x0961FD9B b1207
	NATIVE_DECL void STOP_CAM_SHAKING(Cam cam, BOOL p1) { invoke<Void>(0xB78CC4B4706614B0, cam, p1); } // 0xB78CC4B4706614B0 0x40D0EB87 b1207
	NATIVE_DECL BOOL PLAY_CAM_ANIM(Cam cam, const char* animName, const char* animDictionary, float x, float y, float z, float xRot, float yRot, float zRot, BOOL p9, int p10) { return invoke<BOOL>(0xA263DDF694D563F6, cam, animName, animDictionary, x, y, z, xRot, yRot, zRot, p9, p10); } // 0xA263DDF694D563F6 0xBCEFB87E b1207
	NATIVE_DECL BOOL PLAY_CAM_ANIM(Cam cam, const char* animName, const char* animDictionary, Vector3 vec, Vector3 rot, BOOL p9, int p10) { return invoke<BOOL>(0xA263DDF694D563F6, cam, animName, animDictionary, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, p9, p10); } // 0xA263DDF694D563F6 0xBCEFB87E b1207
	NATIVE_DECL void _0xCF69EA05CD9C33C9() { invoke<Void>(0xCF69EA05CD9C33C9); } // 0xCF69EA05CD9C33C9 b1207
	// Only used in R* Script camera_photomode
	NATIVE_DECL BOOL _IS_ANIM_SCENE_CAM_ACTIVE() { return invoke<BOOL>(0x20389408F0E93B9A); } // 0x20389408F0E93B9A b1207
	NATIVE_DECL BOOL IS_SCREEN_FADED_OUT() { return invoke<BOOL>(0xF5472C80DF2FF847); } // 0xF5472C80DF2FF847 0x9CAA05FA b1207
	NATIVE_DECL BOOL IS_SCREEN_FADED_IN() { return invoke<BOOL>(0x37F9A426FBCF4AF2); } // 0x37F9A426FBCF4AF2 0x4F37276D b1207
	NATIVE_DECL BOOL IS_SCREEN_FADING_OUT() { return invoke<BOOL>(0x02F39BEFE7B88D00); } // 0x02F39BEFE7B88D00 0x79275A57 b1207
	NATIVE_DECL BOOL IS_SCREEN_FADING_IN() { return invoke<BOOL>(0x0CECCC63FFA2EF24); } // 0x0CECCC63FFA2EF24 0xC7C82800 b1207
	// Fades the screen in.
	// 
	// duration: The time the fade should take, in milliseconds.
	NATIVE_DECL void DO_SCREEN_FADE_IN(int duration) { invoke<Void>(0x6A053CF596F67DF7, duration); } // 0x6A053CF596F67DF7 0x66C1BDEE b1207
	// Fades the screen out.
	// 
	// duration: The time the fade should take, in milliseconds.
	NATIVE_DECL void DO_SCREEN_FADE_OUT(int duration) { invoke<Void>(0x40C719A5E410B9E4, duration); } // 0x40C719A5E410B9E4 0x89D01805 b1207
	// More info: https://en.wikipedia.org/wiki/Letterboxing_(filming)
	NATIVE_DECL BOOL HAS_LETTER_BOX() { return invoke<BOOL>(0x81DCFD13CF39920E); } // 0x81DCFD13CF39920E b1207
	// Creates Cinematic Black Bars (at top and bottom)
	// Disable instantly: false/false, Enable instantly: true/true
	NATIVE_DECL void _REQUEST_LETTER_BOX_NOW(BOOL p0, BOOL p1) { invoke<Void>(0x69D65E89FFD72313, p0, p1); } // 0x69D65E89FFD72313 b1207
	NATIVE_DECL void _REQUEST_LETTER_BOX_OVERTIME(int p0, int p1, BOOL p2, int p3, BOOL p4, BOOL p5) { invoke<Void>(0xE296208C273BD7F0, p0, p1, p2, p3, p4, p5); } // 0xE296208C273BD7F0 b1207
	NATIVE_DECL void _FORCE_LETTER_BOX_THIS_UPDATE() { invoke<Void>(0xC64ABC0676AF262B); } // 0xC64ABC0676AF262B b1207
	// More info: see HAS_LETTER_BOX
	NATIVE_DECL float GET_LETTER_BOX_RATIO() { return invoke<float>(0xA2B1C7EF759A63CE); } // 0xA2B1C7EF759A63CE b1207
	NATIVE_DECL Any _0x73FF6BE63DC18819() { return invoke<Any>(0x73FF6BE63DC18819); } // 0x73FF6BE63DC18819 b1207
	NATIVE_DECL Any _0x450769C833D58844() { return invoke<Any>(0x450769C833D58844); } // 0x450769C833D58844 b1207
	NATIVE_DECL void SET_WIDESCREEN_BORDERS(BOOL p0, int p1) { invoke<Void>(0xD7F4D54CF80AFA34, p0, p1); } // 0xD7F4D54CF80AFA34 0x1A75DC9A b1207
	NATIVE_DECL Vector3 GET_GAMEPLAY_CAM_COORD() { return invoke<Vector3>(0x595320200B98596E); } // 0x595320200B98596E 0x9388CF79 b1207
	NATIVE_DECL Vector3 GET_GAMEPLAY_CAM_ROT(int rotationOrder) { return invoke<Vector3>(0x0252D2B5582957A6, rotationOrder); } // 0x0252D2B5582957A6 0x13A010B5 b1207
	NATIVE_DECL float GET_GAMEPLAY_CAM_FOV() { return invoke<float>(0xF6A96E5ACEEC6E50); } // 0xF6A96E5ACEEC6E50 0x4D6B3BFA b1207
	NATIVE_DECL void _0x8459B3E64257B21D(float p0) { invoke<Void>(0x8459B3E64257B21D, p0); } // 0x8459B3E64257B21D 0x1126E37C b1207
	NATIVE_DECL float GET_GAMEPLAY_CAM_RELATIVE_HEADING() { return invoke<float>(0xC4ABF536048998AA); } // 0xC4ABF536048998AA 0xCAF839C2 b1207
	// Sets the camera position relative to heading in float from -360 to +360.
	// 
	// Heading is always 0 in aiming camera.
	NATIVE_DECL void SET_GAMEPLAY_CAM_RELATIVE_HEADING(float heading, float p1) { invoke<Void>(0x5D1EB123EAC5D071, heading, p1); } // 0x5D1EB123EAC5D071 0x20C6217C b1207
	NATIVE_DECL float GET_GAMEPLAY_CAM_RELATIVE_PITCH() { return invoke<float>(0x99AADEBBA803F827); } // 0x99AADEBBA803F827 0xFC5A4946 b1207
	// Sets the camera pitch.
	// 
	// Parameters:
	// x = pitches the camera on the x axis.
	// Value2 = always seems to be hex 0x3F800000 (1.000000 float).
	NATIVE_DECL void SET_GAMEPLAY_CAM_RELATIVE_PITCH(float x, float Value2) { invoke<Void>(0xFB760AF4F537B8BF, x, Value2); } // 0xFB760AF4F537B8BF 0x6381B963 b1207
	NATIVE_DECL void _0x0961B089947BA6D0(Any p0) { invoke<Void>(0x0961B089947BA6D0, p0); } // 0x0961B089947BA6D0 b1207
	NATIVE_DECL void _0x04084490CC302CFB() { invoke<Void>(0x04084490CC302CFB); } // 0x04084490CC302CFB b1207
	NATIVE_DECL void _0x1DD95A8D6B24A0C9(BOOL p0) { invoke<Void>(0x1DD95A8D6B24A0C9, p0); } // 0x1DD95A8D6B24A0C9 b1207
	// Returns true if player is in first person
	NATIVE_DECL BOOL _IS_IN_FULL_FIRST_PERSON_MODE() { return invoke<BOOL>(0xD1BA66940E94C547); } // 0xD1BA66940E94C547 b1207
	NATIVE_DECL void SHAKE_GAMEPLAY_CAM(const char* shakeName, float intensity) { invoke<Void>(0xD9B31B4650520529, shakeName, intensity); } // 0xD9B31B4650520529 0xF2EFE660 b1207
	// _RES*
	NATIVE_DECL void _0xC3E9E5D4F413B773(const char* shakeName, float intensity) { invoke<Void>(0xC3E9E5D4F413B773, shakeName, intensity); } // 0xC3E9E5D4F413B773 b1207
	NATIVE_DECL BOOL IS_GAMEPLAY_CAM_SHAKING() { return invoke<BOOL>(0xEA4C5F4AA0A4DBEF); } // 0xEA4C5F4AA0A4DBEF 0x3457D681 b1207
	// shakeNames in script_rel: CORRECTOR_SHAKE, MINIGAME_BOUNTY_SHAKE, POV_DRUNK_SHAKE, DRUNK_SHAKE, MINIGAME_TRAIN_SHAKE
	// _IS_GAMEPLAY_*
	NATIVE_DECL BOOL _0x0060B31968E60E41(const char* shakeName) { return invoke<BOOL>(0x0060B31968E60E41, shakeName); } // 0x0060B31968E60E41 b1207
	// Sets the amplitude for the gameplay (i.e. 3rd or 1st) camera to shake.
	NATIVE_DECL void SET_GAMEPLAY_CAM_SHAKE_AMPLITUDE(float amplitude) { invoke<Void>(0x570E35F5C4A44838, amplitude); } // 0x570E35F5C4A44838 0x9219D44A b1207
	// _SET_GAMEPLAY_P* - _SET_GAMEPLAY_V*
	NATIVE_DECL void _0xFEFDDC6E8FDF8A75(const char* shakeName, float intensity) { invoke<Void>(0xFEFDDC6E8FDF8A75, shakeName, intensity); } // 0xFEFDDC6E8FDF8A75 b1207
	NATIVE_DECL void STOP_GAMEPLAY_CAM_SHAKING(BOOL p0) { invoke<Void>(0xE0DE43D290FB65F9, p0); } // 0xE0DE43D290FB65F9 0xFD569E4E b1207
	// script_rel: DRUNK_SHAKE, REINFORCED_LASSO_STRUGGLE_SHAKE, CORRECTOR_SHAKE, MINIGAME_BOUNTY_SHAKE, HAND_SHAKE, MINIGAME_TRAIN_SHAKE
	// script_mp_rel: DRUNK_SHAKE, REINFORCED_LASSO_STRUGGLE_SHAKE
	// _STOP_GAMEPLAY_CAM* - _STOP_I*
	NATIVE_DECL void _0x4285804FD65D8066(const char* shakeName, BOOL p1) { invoke<Void>(0x4285804FD65D8066, shakeName, p1); } // 0x4285804FD65D8066 b1207
	// Forces gameplay cam to specified ped as if you were the ped or spectating it
	NATIVE_DECL void SET_GAMEPLAY_CAM_FOLLOW_PED_THIS_UPDATE(Ped ped) { invoke<Void>(0x82E41D6ADE924FCA, ped); } // 0x82E41D6ADE924FCA 0x7D3007A2 b1207
	NATIVE_DECL BOOL IS_GAMEPLAY_CAM_RENDERING() { return invoke<BOOL>(0x8660EA714834E412); } // 0x8660EA714834E412 0x0EF276DA b1207
	NATIVE_DECL BOOL _0x251241CAEC707106() { return invoke<BOOL>(0x251241CAEC707106); } // 0x251241CAEC707106 0xC0B00C20 b1207
	NATIVE_DECL BOOL _0x43AB9D5A7D415478() { return invoke<BOOL>(0x43AB9D5A7D415478); } // 0x43AB9D5A7D415478 0x60C23785 b1207
	NATIVE_DECL BOOL IS_GAMEPLAY_CAM_LOOKING_BEHIND() { return invoke<BOOL>(0x8FE0D24FFD04D5A2); } // 0x8FE0D24FFD04D5A2 0x33C83F17 b1207
	NATIVE_DECL void _DISABLE_CAM_COLLISION_FOR_ENTITY(Entity entity) { invoke<Void>(0xD904F75DBD7AB865, entity); } // 0xD904F75DBD7AB865 0x2701A9AD b1207
	NATIVE_DECL void DISABLE_CAM_COLLISION_FOR_OBJECT(Entity entity) { invoke<Void>(0x7E3F546ACFE6C8D9, entity); } // 0x7E3F546ACFE6C8D9 0xC4736ED3 b1207
	NATIVE_DECL void _0x39073DA4EDDBC91D(Any p0) { invoke<Void>(0x39073DA4EDDBC91D, p0); } // 0x39073DA4EDDBC91D b1207
	NATIVE_DECL void _0x70A6658D476C6187() { invoke<Void>(0x70A6658D476C6187); } // 0x70A6658D476C6187 b1207
	NATIVE_DECL void _0x18C3DFAC458783BB() { invoke<Void>(0x18C3DFAC458783BB); } // 0x18C3DFAC458783BB b1207
	NATIVE_DECL void _0xF1A6FEEDF3776EF9() { invoke<Void>(0xF1A6FEEDF3776EF9); } // 0xF1A6FEEDF3776EF9 b1207
	NATIVE_DECL void _0xE6F364DE6C2FDEFE() { invoke<Void>(0xE6F364DE6C2FDEFE); } // 0xE6F364DE6C2FDEFE b1207
	// _DISABLE_*
	NATIVE_DECL void _0x0F1FFEF5D54AE832() { invoke<Void>(0x0F1FFEF5D54AE832); } // 0x0F1FFEF5D54AE832 b1207
	NATIVE_DECL void _0x3C8F74E8FE751614() { invoke<Void>(0x3C8F74E8FE751614); } // 0x3C8F74E8FE751614 b1207
	NATIVE_DECL void _0x06557F6D96C86881() { invoke<Void>(0x06557F6D96C86881); } // 0x06557F6D96C86881 b1207
	NATIVE_DECL BOOL IS_SPHERE_VISIBLE(float x, float y, float z, float radius) { return invoke<BOOL>(0x2E941B5FFA2989C6, x, y, z, radius); } // 0x2E941B5FFA2989C6 0xDD1329E2 b1207
	NATIVE_DECL BOOL IS_SPHERE_VISIBLE(Vector3 vec, float radius) { return invoke<BOOL>(0x2E941B5FFA2989C6, vec.x, vec.y, vec.z, radius); } // 0x2E941B5FFA2989C6 0xDD1329E2 b1207
	NATIVE_DECL Any _0x190F7DA1AC09A8EF() { return invoke<Any>(0x190F7DA1AC09A8EF); } // 0x190F7DA1AC09A8EF b1207
	// Used in Script Function SHOP_CAMERA_SUPPORT_START_NEW_ORBIT
	NATIVE_DECL void _SET_GAMEPLAY_CAM_INITIAL_ZOOM(float camInitialZoom) { invoke<Void>(0xBCDA0BA8762FACB9, camInitialZoom); } // 0xBCDA0BA8762FACB9 b1207
	NATIVE_DECL void _SET_GAMEPLAY_CAM_INITIAL_HEADING(float camInitialHeading) { invoke<Void>(0x6C1053C433A573CF, camInitialHeading); } // 0x6C1053C433A573CF b1207
	NATIVE_DECL void _SET_GAMEPLAY_CAM_INITIAL_PITCH(float camInitialPitch) { invoke<Void>(0x449995EA846D3FC2, camInitialPitch); } // 0x449995EA846D3FC2 b1207
	// minimum: Degrees between -180f and 180f.
	// maximum: Degrees between -180f and 180f.
	// 
	// Clamps the gameplay camera's current yaw.
	// 
	// Eg. _CLAMP_GAMEPLAY_CAM_YAW(0.0f, 0.0f) will set the horizontal angle directly behind the player.
	NATIVE_DECL void _CLAMP_GAMEPLAY_CAM_YAW(float minimum, float maximum) { invoke<Void>(0x14F3947318CA8AD2, minimum, maximum); } // 0x14F3947318CA8AD2 0x749909AC b1207
	// minimum: Degrees between -90f and 90f.
	// maximum: Degrees between -90f and 90f.
	// 
	// Clamps the gameplay camera's current pitch.
	// 
	// Eg. _CLAMP_GAMEPLAY_CAM_PITCH(0.0f, 0.0f) will set the vertical angle directly behind the player.
	NATIVE_DECL void _CLAMP_GAMEPLAY_CAM_PITCH(float minimum, float maximum) { invoke<Void>(0x326C7AA308F3DF6A, minimum, maximum); } // 0x326C7AA308F3DF6A 0xFA3A16E7 b1207
	NATIVE_DECL void _ANIMATE_GAMEPLAY_CAM_ZOOM(float p0, float distance) { invoke<Void>(0x2126C740A4AC370B, p0, distance); } // 0x2126C740A4AC370B 0x77340650 b1207
	// Forces gameplay cam to specified vehicle as if you were in it
	NATIVE_DECL void SET_IN_VEHICLE_CAM_STATE_THIS_UPDATE(Vehicle vehicle, int p1) { invoke<Void>(0xFA1D5E8D1C3CCD67, vehicle, p1); } // 0xFA1D5E8D1C3CCD67 0x4B22C5CB b1207
	NATIVE_DECL void _DISABLE_FIRST_PERSON_CAM_THIS_FRAME() { invoke<Void>(0x9C473089A934C930); } // 0x9C473089A934C930 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x77D65669A05D1A1A() { invoke<Void>(0x77D65669A05D1A1A); } // 0x77D65669A05D1A1A b1207
	NATIVE_DECL void _DISABLE_CINEMATIC_MODE_THIS_FRAME() { invoke<Void>(0x8910C24B7E0046EC); } // 0x8910C24B7E0046EC b1207
	NATIVE_DECL BOOL _IS_IN_CINEMATIC_MODE() { return invoke<BOOL>(0x74F1D22EFA71FAB8); } // 0x74F1D22EFA71FAB8 b1207
	NATIVE_DECL void _0x718C6ECF5E8CBDD4() { invoke<Void>(0x718C6ECF5E8CBDD4); } // 0x718C6ECF5E8CBDD4 b1207
	// Forces camera position to second furthest 3rd person
	NATIVE_DECL void _FORCE_THIRD_PERSON_CAM_THIS_FRAME() { invoke<Void>(0x8370D34BD2E60B73); } // 0x8370D34BD2E60B73 b1207
	// Forces camera position to furthest 3rd person
	NATIVE_DECL void _FORCE_THIRD_PERSON_CAM_FAR_THIS_FRAME() { invoke<Void>(0x1CFB749AD4317BDE); } // 0x1CFB749AD4317BDE b1207
	// Returns true if first person camera is active in saloon1.ysc
	NATIVE_DECL BOOL _FORCE_FIRST_PERSON_CAM_THIS_FRAME() { return invoke<BOOL>(0x90DA5BA5C2635416); } // 0x90DA5BA5C2635416 b1207
	// Does the same as 0x9C473089A934C930
	NATIVE_DECL void _DISABLE_FIRST_PERSON_CAM_THIS_FRAME_2() { invoke<Void>(0x05AB44D906738426); } // 0x05AB44D906738426 b1207
	NATIVE_DECL void _0x632BE8D84846FA56() { invoke<Void>(0x632BE8D84846FA56); } // 0x632BE8D84846FA56 b1207
	NATIVE_DECL void _0x71D71E08A7ED5BD7(Any p0) { invoke<Void>(0x71D71E08A7ED5BD7, p0); } // 0x71D71E08A7ED5BD7 b1207
	NATIVE_DECL BOOL IS_FOLLOW_VEHICLE_CAM_ACTIVE() { return invoke<BOOL>(0xA40C2F51FB589E9A); } // 0xA40C2F51FB589E9A 0x8DD49B77 b1207
	NATIVE_DECL void _0x7E40A01B11398FCB() { invoke<Void>(0x7E40A01B11398FCB); } // 0x7E40A01B11398FCB b1207
	NATIVE_DECL BOOL IS_AIM_CAM_ACTIVE() { return invoke<BOOL>(0x698F456FB909E077); } // 0x698F456FB909E077 0xC24B4F6F b1232
	NATIVE_DECL BOOL IS_FIRST_PERSON_AIM_CAM_ACTIVE() { return invoke<BOOL>(0xF63134C54B6EC212); } // 0xF63134C54B6EC212 0xD6280468 b1207
	NATIVE_DECL BOOL IS_FIRST_PERSON_CAMERA_ACTIVE(Any p0, Any p1, Any p2) { return invoke<BOOL>(0xA24C1D341C6E0D53, p0, p1, p2); } // 0xA24C1D341C6E0D53 b1207
	NATIVE_DECL Any _0xDC62CD70658E7A02() { return invoke<Any>(0xDC62CD70658E7A02); } // 0xDC62CD70658E7A02 b1207
	NATIVE_DECL Any _0x796085220ADCC847() { return invoke<Any>(0x796085220ADCC847); } // 0x796085220ADCC847 b1207
	NATIVE_DECL Any _0xB6A80E1E3A5444F1() { return invoke<Any>(0xB6A80E1E3A5444F1); } // 0xB6A80E1E3A5444F1 b1311
	NATIVE_DECL Any _0x8B1A5FE7E41E52B2() { return invoke<Any>(0x8B1A5FE7E41E52B2); } // 0x8B1A5FE7E41E52B2 b1311
	NATIVE_DECL float GET_FIRST_PERSON_AIM_CAM_ZOOM_FACTOR() { return invoke<float>(0xB4132CA1B0EE1365); } // 0xB4132CA1B0EE1365 0x33951005 b1207
	NATIVE_DECL void _0x05BD5E4088B30A66(float p0, float p1) { invoke<Void>(0x05BD5E4088B30A66, p0, p1); } // 0x05BD5E4088B30A66 0x2F29F0D5 b1207
	NATIVE_DECL void _SET_FIRST_PERSON_CAM_PITCH_RANGE(float p0, float p1) { invoke<Void>(0x715B7F5E8BED32A2, p0, p1); } // 0x715B7F5E8BED32A2 0x76DAC96C b1207
	NATIVE_DECL void _0xC205B3C54C6A4E37(Any p0) { invoke<Void>(0xC205B3C54C6A4E37, p0); } // 0xC205B3C54C6A4E37 b1207
	NATIVE_DECL Vector3 GET_FINAL_RENDERED_CAM_COORD() { return invoke<Vector3>(0x5352E025EC2B416F); } // 0x5352E025EC2B416F 0x9C84BDA0 b1207
	NATIVE_DECL Vector3 GET_FINAL_RENDERED_CAM_ROT(int rotationOrder) { return invoke<Vector3>(0x602685BD85DD26CA, rotationOrder); } // 0x602685BD85DD26CA 0x1FFBEFC5 b1207
	NATIVE_DECL float GET_FINAL_RENDERED_CAM_FOV() { return invoke<float>(0x04AF77971E508F6A); } // 0x04AF77971E508F6A 0x721B763B b1207
	NATIVE_DECL void SET_GAMEPLAY_COORD_HINT(float x, float y, float z, int duration, int blendOutDuration, int blendInDuration, int unk) { invoke<Void>(0xFA33B8C69A4A6A0F, x, y, z, duration, blendOutDuration, blendInDuration, unk); } // 0xFA33B8C69A4A6A0F 0xF27483C9 b1207
	NATIVE_DECL void SET_GAMEPLAY_COORD_HINT(Vector3 vec, int duration, int blendOutDuration, int blendInDuration, int unk) { invoke<Void>(0xFA33B8C69A4A6A0F, vec.x, vec.y, vec.z, duration, blendOutDuration, blendInDuration, unk); } // 0xFA33B8C69A4A6A0F 0xF27483C9 b1207
	NATIVE_DECL void SET_GAMEPLAY_PED_HINT(Ped p0, float x1, float y1, float z1, BOOL p4, Any p5, Any p6, Any p7) { invoke<Void>(0x90FB951648851733, p0, x1, y1, z1, p4, p5, p6, p7); } // 0x90FB951648851733 0x7C27343E b1207
	NATIVE_DECL void SET_GAMEPLAY_PED_HINT(Ped p0, Vector3 vec1, BOOL p4, Any p5, Any p6, Any p7) { invoke<Void>(0x90FB951648851733, p0, vec1.x, vec1.y, vec1.z, p4, p5, p6, p7); } // 0x90FB951648851733 0x7C27343E b1207
	NATIVE_DECL void SET_GAMEPLAY_VEHICLE_HINT(Any p0, float p1, float p2, float p3, BOOL p4, Any p5, Any p6, Any p7) { invoke<Void>(0xE2B2BB7DAC280515, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xE2B2BB7DAC280515 0x2C9A11D8 b1207
	NATIVE_DECL void SET_GAMEPLAY_OBJECT_HINT(Any p0, float p1, float p2, float p3, BOOL p4, Any p5, Any p6, Any p7) { invoke<Void>(0xC40551D65F2BF297, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xC40551D65F2BF297 0x2ED5E2F8 b1207
	// p6 & p7 - possibly length or time
	NATIVE_DECL void SET_GAMEPLAY_ENTITY_HINT(Entity entity, float xOffset, float yOffset, float zOffset, BOOL p4, int p5, int p6, int p7, Any p8) { invoke<Void>(0xD1F7F32640ADFD12, entity, xOffset, yOffset, zOffset, p4, p5, p6, p7, p8); } // 0xD1F7F32640ADFD12 0x66C32306 b1207
	NATIVE_DECL void SET_GAMEPLAY_ENTITY_HINT(Entity entity, Vector3 offset, BOOL p4, int p5, int p6, int p7, Any p8) { invoke<Void>(0xD1F7F32640ADFD12, entity, offset.x, offset.y, offset.z, p4, p5, p6, p7, p8); } // 0xD1F7F32640ADFD12 0x66C32306 b1207
	NATIVE_DECL BOOL IS_GAMEPLAY_HINT_ACTIVE() { return invoke<BOOL>(0x2E04AB5FEE042D4A); } // 0x2E04AB5FEE042D4A 0xAD8DA205 b1207
	NATIVE_DECL void STOP_GAMEPLAY_HINT(BOOL p0) { invoke<Void>(0x1BCEC33D54CFCA8A, p0); } // 0x1BCEC33D54CFCA8A 0x1BC28B7B b1207
	NATIVE_DECL void _0x93759A83D0D844E7(BOOL p0) { invoke<Void>(0x93759A83D0D844E7, p0); } // 0x93759A83D0D844E7 b1207
	NATIVE_DECL void _0x88544C0E3291DCAE(Any p0) { invoke<Void>(0x88544C0E3291DCAE, p0); } // 0x88544C0E3291DCAE b1207
	NATIVE_DECL void SET_GAMEPLAY_HINT_FOV(float FOV) { invoke<Void>(0x661E58BC6F00A49A, FOV); } // 0x661E58BC6F00A49A 0x96FD173B b1207
	NATIVE_DECL void SET_GAMEPLAY_HINT_FOLLOW_DISTANCE_SCALAR(float p0) { invoke<Void>(0xDDDC54181868F81F, p0); } // 0xDDDC54181868F81F 0x72E8CD3A b1207
	NATIVE_DECL void SET_GAMEPLAY_HINT_BASE_ORBIT_PITCH_OFFSET(float p0) { invoke<Void>(0x421192A2DA48FD01, p0); } // 0x421192A2DA48FD01 0x79472AE3 b1207
	NATIVE_DECL void _SET_GAMEPLAY_HINT_ANIM_OFFSETX(float p0) { invoke<Void>(0xF86B6F93727C59C9, p0); } // 0xF86B6F93727C59C9 0xFC7464A0 b1207
	NATIVE_DECL void _SET_GAMEPLAY_HINT_ANIM_OFFSETY(float p0) { invoke<Void>(0x29E74F819150CC32, p0); } // 0x29E74F819150CC32 0x3554AA0E b1207
	NATIVE_DECL void _0xF48664E9C83825E3(Any p0, Any p1) { invoke<Void>(0xF48664E9C83825E3, p0, p1); } // 0xF48664E9C83825E3 b1207
	NATIVE_DECL void _0x1F6EBD94680252CE(Any p0, Any p1) { invoke<Void>(0x1F6EBD94680252CE, p0, p1); } // 0x1F6EBD94680252CE b1207
	NATIVE_DECL void _0xE28F73212A813E82(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xE28F73212A813E82, p0, p1, p2, p3); } // 0xE28F73212A813E82 b1207
	NATIVE_DECL void _0x4D2F46D1B28D90FB(Any p0, Any p1) { invoke<Void>(0x4D2F46D1B28D90FB, p0, p1); } // 0x4D2F46D1B28D90FB b1207
	NATIVE_DECL void _START_CAMERA_ORBIT(Any* p0) { invoke<Void>(0x65B205BF30C13DDB, p0); } // 0x65B205BF30C13DDB b1207
	NATIVE_DECL void _0x641092322A8852AB() { invoke<Void>(0x641092322A8852AB); } // 0x641092322A8852AB b1207
	NATIVE_DECL void _0xDB382FE20C2DA222(Any p0) { invoke<Void>(0xDB382FE20C2DA222, p0); } // 0xDB382FE20C2DA222 b1207
	NATIVE_DECL void _0x2DD3149DC34A3F4C(Any p0) { invoke<Void>(0x2DD3149DC34A3F4C, p0); } // 0x2DD3149DC34A3F4C b1207
	NATIVE_DECL void _FREEZE_GAMEPLAY_CAM_THIS_FRAME() { invoke<Void>(0x027CAB2C3AF27010); } // 0x027CAB2C3AF27010 b1207
	NATIVE_DECL void _0x3C486E334520579D() { invoke<Void>(0x3C486E334520579D); } // 0x3C486E334520579D b1207
	NATIVE_DECL void _0x41E452A3C580D1A7() { invoke<Void>(0x41E452A3C580D1A7); } // 0x41E452A3C580D1A7 b1207
	NATIVE_DECL void SET_CINEMATIC_BUTTON_ACTIVE(BOOL p0) { invoke<Void>(0xB90411F480457A6C, p0); } // 0xB90411F480457A6C 0x3FBC5D00 b1207
	NATIVE_DECL BOOL IS_CINEMATIC_CAM_RENDERING() { return invoke<BOOL>(0xBF7C780731AADBF8); } // 0xBF7C780731AADBF8 0x80471AD9 b1207
	NATIVE_DECL void _DISABLE_VEHICLE_FIRST_PERSON_CAM_THIS_FRAME() { invoke<Void>(0xA5929C2E57AC90D1); } // 0xA5929C2E57AC90D1 0x5AC6DAC9 b1207
	NATIVE_DECL void _INVALIDATE_VEHICLE_IDLE_CAM() { invoke<Void>(0x634F4A0562CF19B8); } // 0x634F4A0562CF19B8 0x65DDE8AF b1207
	NATIVE_DECL void FORCE_CINEMATIC_RENDERING_THIS_UPDATE(BOOL p0) { invoke<Void>(0x702B75DC9D3EDE56, p0); } // 0x702B75DC9D3EDE56 0xFBB85E02 b1207
	NATIVE_DECL void _0x9AC65A36D3C0C189(Any p0) { invoke<Void>(0x9AC65A36D3C0C189, p0); } // 0x9AC65A36D3C0C189 b1207
	// _IS_SCRIPTED_S*
	NATIVE_DECL BOOL _0x975F6EBB62632FE3() { return invoke<BOOL>(0x975F6EBB62632FE3); } // 0x975F6EBB62632FE3 b1207
	NATIVE_DECL void SET_CINEMATIC_MODE_ACTIVE(BOOL p0) { invoke<Void>(0xCE7A90B160F75046, p0); } // 0xCE7A90B160F75046 0x2009E747 b1207
	NATIVE_DECL BOOL _0x1811A02277A9E49D() { return invoke<BOOL>(0x1811A02277A9E49D); } // 0x1811A02277A9E49D b1207
	// Used for DUELING_MANAGE_DEATH_CAMERA - Initializing death camera
	// Params: targetPed = death cam focuses on it
	NATIVE_DECL void _FORCE_CINEMATIC_DEATH_CAM_ON_PED(Ped targetPed) { invoke<Void>(0xE3639DB78B3B5400, targetPed); } // 0xE3639DB78B3B5400 b1207
	NATIVE_DECL void _0x986F7A51EE3E1F92(Any p0, Any p1) { invoke<Void>(0x986F7A51EE3E1F92, p0, p1); } // 0x986F7A51EE3E1F92 b1207
	NATIVE_DECL void _0x5B637D6F3B67716A(Any p0) { invoke<Void>(0x5B637D6F3B67716A, p0); } // 0x5B637D6F3B67716A b1207
	NATIVE_DECL void _0xC252C0CC969AF79A(Any p0) { invoke<Void>(0xC252C0CC969AF79A, p0); } // 0xC252C0CC969AF79A b1207
	NATIVE_DECL void _0xE2BB2D6A9FE2ECDE(Any p0) { invoke<Void>(0xE2BB2D6A9FE2ECDE, p0); } // 0xE2BB2D6A9FE2ECDE b1207
	// Used for DUELING_MANAGE_DEATH_CAMERA - Initializing death camera
	// _SET_P* - _SET_S*
	NATIVE_DECL void _SET_START_CINEMATIC_DEATH_CAM(BOOL p0) { invoke<Void>(0x6E969927CF632608, p0); } // 0x6E969927CF632608 b1207
	NATIVE_DECL Any _0x6072B7420A83A03F() { return invoke<Any>(0x6072B7420A83A03F); } // 0x6072B7420A83A03F b1207
	// Used for DUELING_LOCK_CAMERA_CONTROLS_THIS_FRAME: Disabling look/aim controls
	// _IS_SC(REEN_)* (?)
	NATIVE_DECL BOOL _0x1204EB53A5FBC63D() { return invoke<BOOL>(0x1204EB53A5FBC63D); } // 0x1204EB53A5FBC63D b1207
	NATIVE_DECL void _0x6519238858AF5479(Any p0) { invoke<Void>(0x6519238858AF5479, p0); } // 0x6519238858AF5479 b1207
	NATIVE_DECL void _0x2F994CC29CAA9D22(Any p0) { invoke<Void>(0x2F994CC29CAA9D22, p0); } // 0x2F994CC29CAA9D22 b1207
	NATIVE_DECL BOOL _IS_CAM_PHOTOFX_RUNNING() { return invoke<BOOL>(0xA14D5FE82BCB1D9E); } // 0xA14D5FE82BCB1D9E b1207
	NATIVE_DECL Any _0x6DFD37E586D4F44F() { return invoke<Any>(0x6DFD37E586D4F44F); } // 0x6DFD37E586D4F44F b1207
	NATIVE_DECL Any _0x80D7A3E39B120BC4() { return invoke<Any>(0x80D7A3E39B120BC4); } // 0x80D7A3E39B120BC4 b1207
	NATIVE_DECL void _0x63E5841A9264D016(Any p0) { invoke<Void>(0x63E5841A9264D016, p0); } // 0x63E5841A9264D016 b1207
	NATIVE_DECL void _TRIGGER_MISSION_FAILED_CAM() { invoke<Void>(0x9A92C06ACBAF9731); } // 0x9A92C06ACBAF9731 b1207
	NATIVE_DECL void _0x16E9ABDD34DDD931() { invoke<Void>(0x16E9ABDD34DDD931); } // 0x16E9ABDD34DDD931 b1207
	NATIVE_DECL BOOL IS_DEATH_FAIL_CAMERA_RUNNING() { return invoke<BOOL>(0x139EFB0A71DD9011); } // 0x139EFB0A71DD9011 b1207
	NATIVE_DECL Any _0x7CE9DC58E3E4755F() { return invoke<Any>(0x7CE9DC58E3E4755F); } // 0x7CE9DC58E3E4755F b1207
	NATIVE_DECL void _0x3B8E3AD9677CE12B(Any p0, Any p1, Any p2) { invoke<Void>(0x3B8E3AD9677CE12B, p0, p1, p2); } // 0x3B8E3AD9677CE12B b1207
	NATIVE_DECL void _0xDF7F5BE9150E47E4(Any p0) { invoke<Void>(0xDF7F5BE9150E47E4, p0); } // 0xDF7F5BE9150E47E4 b1207
	NATIVE_DECL void _0xB85C13E0BF1F2A1C(Any p0) { invoke<Void>(0xB85C13E0BF1F2A1C, p0); } // 0xB85C13E0BF1F2A1C b1207
	NATIVE_DECL void _0x066167C63111D8CF(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x066167C63111D8CF, p0, p1, p2, p3, p4); } // 0x066167C63111D8CF b1207
	// _DISABLE_*
	NATIVE_DECL void _0xA8BA2E0204D8486F() { invoke<Void>(0xA8BA2E0204D8486F); } // 0xA8BA2E0204D8486F b1355
	NATIVE_DECL void _0xC3742F1FDF0A6824() { invoke<Void>(0xC3742F1FDF0A6824); } // 0xC3742F1FDF0A6824 b1355
	NATIVE_DECL void _0x0FF7125F07DEB84F(Any p0, Any p1) { invoke<Void>(0x0FF7125F07DEB84F, p0, p1); } // 0x0FF7125F07DEB84F b1207
	NATIVE_DECL void _0x6CAB0BA160B168D2() { invoke<Void>(0x6CAB0BA160B168D2); } // 0x6CAB0BA160B168D2 b1207
	NATIVE_DECL void _LOAD_CINEMATIC_CAM_LOCATION(const char* locationDictName) { invoke<Void>(0x1B3C2D961F5FC0E1, locationDictName); } // 0x1B3C2D961F5FC0E1 b1207
	NATIVE_DECL void _UNLOAD_CINEMATIC_CAMERA_LOCATION(const char* dictionaryName) { invoke<Void>(0x2412216FCC7B4E3E, dictionaryName); } // 0x2412216FCC7B4E3E b1207
	NATIVE_DECL BOOL _0xAA235E2F2C09E952(const char* sLocationDictName) { return invoke<BOOL>(0xAA235E2F2C09E952, sLocationDictName); } // 0xAA235E2F2C09E952 b1207
	NATIVE_DECL Any _0x595550376B7EA230(Any p0) { return invoke<Any>(0x595550376B7EA230, p0); } // 0x595550376B7EA230 b1207
	NATIVE_DECL Any _0x465F04F68AD38197(Any p0, Any p1, Any p2) { return invoke<Any>(0x465F04F68AD38197, p0, p1, p2); } // 0x465F04F68AD38197 b1207
	NATIVE_DECL Any _0xEA113BF9B0C0C5D7(Any p0, Any p1, Any p2) { return invoke<Any>(0xEA113BF9B0C0C5D7, p0, p1, p2); } // 0xEA113BF9B0C0C5D7 b1207
	NATIVE_DECL void _CINEMATIC_LOCATION_TRIGGER_SCRIPTED_SHOT_EVENT_2(const char* dictionary, const char* shotName, int duration) { invoke<Void>(0xBC016635D6A73B31, dictionary, shotName, duration); } // 0xBC016635D6A73B31 b1207
	NATIVE_DECL void CINEMATIC_LOCATION_TRIGGER_SCRIPTED_SHOT_EVENT(const char* dictionary, const char* shotName, const char* cameraName, Any p3) { invoke<Void>(0x02389579A53C3276, dictionary, shotName, cameraName, p3); } // 0x02389579A53C3276 b1207
	NATIVE_DECL void _0xA54D643D0773EB65(Any p0, Any p1, Any p2) { invoke<Void>(0xA54D643D0773EB65, p0, p1, p2); } // 0xA54D643D0773EB65 b1207
	NATIVE_DECL void CINEMATIC_LOCATION_STOP_SCRIPTED_SHOT_EVENT(Any p0, Any p1, Any p2) { invoke<Void>(0x6D4D25C2137FF511, p0, p1, p2); } // 0x6D4D25C2137FF511 b1207
	NATIVE_DECL BOOL _0xC3AEBB276825A359(const char* dictionary, const char* shotName, int duration) { return invoke<BOOL>(0xC3AEBB276825A359, dictionary, shotName, duration); } // 0xC3AEBB276825A359 b1436
	NATIVE_DECL BOOL _0x1D931B7CC0EE3956(const char* dictionary, const char* shotName, const char* cameraName) { return invoke<BOOL>(0x1D931B7CC0EE3956, dictionary, shotName, cameraName); } // 0x1D931B7CC0EE3956 b1436
	NATIVE_DECL void _CINEMATIC_LOCATION_SET_LOCATION_AND_ROTATION(const char* name, float x, float y, float z, float rotX, float rotY, float rotZ) { invoke<Void>(0x0E94C95EC3185FA9, name, x, y, z, rotX, rotY, rotZ); } // 0x0E94C95EC3185FA9 b1207
	NATIVE_DECL void _CINEMATIC_LOCATION_SET_LOCATION_AND_ROTATION(const char* name, Vector3 vec, Vector3 rot) { invoke<Void>(0x0E94C95EC3185FA9, name, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z); } // 0x0E94C95EC3185FA9 b1207
	// Only used in R* Script fm_mission_controller
	NATIVE_DECL void CINEMATIC_LOCATION_OVERRIDE_TARGET_ENTITY_THIS_UPDATE(const char* name, Entity entity) { invoke<Void>(0x0B0F914459731F60, name, entity); } // 0x0B0F914459731F60 b1311
	NATIVE_DECL void _LOAD_CAMERA_DATA_DICT(const char* cameraDictionary) { invoke<Void>(0x6A4D224FC7643941, cameraDictionary); } // 0x6A4D224FC7643941 b1207
	NATIVE_DECL void _UNLOAD_CAMERA_DATA_DICT(const char* cameraDictionary) { invoke<Void>(0x798BE43C9393632B, cameraDictionary); } // 0x798BE43C9393632B b1207
	NATIVE_DECL BOOL _IS_CAM_DATA_DICT_LOADED(const char* cameraDictionary) { return invoke<BOOL>(0xDD0B7C5AE58F721D, cameraDictionary); } // 0xDD0B7C5AE58F721D b1207
	NATIVE_DECL Any _0xC285FD21294A1C49(Any p0) { return invoke<Any>(0xC285FD21294A1C49, p0); } // 0xC285FD21294A1C49 b1207
	NATIVE_DECL void _CAM_CREATE(const char* cameraDictionary) { invoke<Void>(0xB8B207C34285E978, cameraDictionary); } // 0xB8B207C34285E978 b1207
	NATIVE_DECL void _CAM_DESTROY(const char* cameraDictionary) { invoke<Void>(0x0A5A4F1979ABB40E, cameraDictionary); } // 0x0A5A4F1979ABB40E b1207
	NATIVE_DECL BOOL _IS_CAMERA_AVAILABLE(const char* cameraDictionary) { return invoke<BOOL>(0x927B810E43E99932, cameraDictionary); } // 0x927B810E43E99932 b1207
	NATIVE_DECL Any _0x4138EE36BC3DC0A7(Any p0, Any p1) { return invoke<Any>(0x4138EE36BC3DC0A7, p0, p1); } // 0x4138EE36BC3DC0A7 b1207
	NATIVE_DECL void _0xFEB8646818294C75(Any p0, Any p1) { invoke<Void>(0xFEB8646818294C75, p0, p1); } // 0xFEB8646818294C75 b1207
	NATIVE_DECL void _0x29E6655DF3590B0D(Any p0) { invoke<Void>(0x29E6655DF3590B0D, p0); } // 0x29E6655DF3590B0D b1207
	NATIVE_DECL void _0xAC77757C05DE9E5A(const char* cameraDictionary) { invoke<Void>(0xAC77757C05DE9E5A, cameraDictionary); } // 0xAC77757C05DE9E5A b1207
	NATIVE_DECL void _0x8E036B41C37D0E5F(Any p0) { invoke<Void>(0x8E036B41C37D0E5F, p0); } // 0x8E036B41C37D0E5F b1207
	NATIVE_DECL void _0x1D9F72DD4FD9A9D7(Any p0) { invoke<Void>(0x1D9F72DD4FD9A9D7, p0); } // 0x1D9F72DD4FD9A9D7 b1207
	NATIVE_DECL void _CAM_CREATE_2(const char* cameraDictionary) { invoke<Void>(0x7B0279170961A73F, cameraDictionary); } // 0x7B0279170961A73F b1207
	NATIVE_DECL void _0x728491FB3DFFEF99(Any p0) { invoke<Void>(0x728491FB3DFFEF99, p0); } // 0x728491FB3DFFEF99 b1207
	NATIVE_DECL Any _0x14C4A49E36C29E49() { return invoke<Any>(0x14C4A49E36C29E49); } // 0x14C4A49E36C29E49 b1207
	NATIVE_DECL Any _0xF824530B612FE0CE() { return invoke<Any>(0xF824530B612FE0CE); } // 0xF824530B612FE0CE b1207
	NATIVE_DECL Any _0xEF9A3132A0AA6B19() { return invoke<Any>(0xEF9A3132A0AA6B19); } // 0xEF9A3132A0AA6B19 b1207
	NATIVE_DECL Any _0x5060FA977CEA4455() { return invoke<Any>(0x5060FA977CEA4455); } // 0x5060FA977CEA4455 b1207
	NATIVE_DECL float _GET_PHOTO_MODE_FOCAL_LENGTH() { return invoke<float>(0x2533BAFFBE737E54); } // 0x2533BAFFBE737E54 b1207
	NATIVE_DECL float _GET_PHOTO_MODE_FOCUS_DISTANCE() { return invoke<float>(0x18FC740FFDCD7454); } // 0x18FC740FFDCD7454 b1207
	NATIVE_DECL float _GET_PHOTO_MODE_DOF() { return invoke<float>(0x4653A741D17F2CD0); } // 0x4653A741D17F2CD0 b1207
	NATIVE_DECL Any _0x2AB7C81B3F70570C() { return invoke<Any>(0x2AB7C81B3F70570C); } // 0x2AB7C81B3F70570C b1207
	NATIVE_DECL void _0x8505E05FC8822843(Any p0) { invoke<Void>(0x8505E05FC8822843, p0); } // 0x8505E05FC8822843 b1207
}

namespace CLOCK
{
	// SET_CLOCK_TIME(12, 34, 56);
	NATIVE_DECL void SET_CLOCK_TIME(int hour, int minute, int second) { invoke<Void>(0x3A52C59FFB2DEED8, hour, minute, second); } // 0x3A52C59FFB2DEED8 0x26F6AF14 b1207
	NATIVE_DECL void PAUSE_CLOCK(BOOL toggle, Any unused) { invoke<Void>(0x4D1A590C92BF377E, toggle, unused); } // 0x4D1A590C92BF377E 0xB02D6124 b1207
	NATIVE_DECL void _PAUSE_CLOCK_THIS_FRAME(BOOL toggle) { invoke<Void>(0x568D998A9FF96774, toggle); } // 0x568D998A9FF96774 b1207
	NATIVE_DECL void ADVANCE_CLOCK_TIME_TO(int hour, int minute, int second) { invoke<Void>(0x0184750AE88D0B1D, hour, minute, second); } // 0x0184750AE88D0B1D 0x57B8DA7C b1207
	NATIVE_DECL void ADD_TO_CLOCK_TIME(int hours, int minutes, int seconds) { invoke<Void>(0xAB7C251C7701D336, hours, minutes, seconds); } // 0xAB7C251C7701D336 0xCC40D20D b1207
	// Gets the current ingame hour, expressed without zeros. (09:34 will be represented as 9)
	NATIVE_DECL int GET_CLOCK_HOURS() { return invoke<int>(0xC82CF208C2B19199); } // 0xC82CF208C2B19199 0x7EF8316F b1207
	// Gets the current ingame clock minute.
	NATIVE_DECL int GET_CLOCK_MINUTES() { return invoke<int>(0x4E162231B823DBBF); } // 0x4E162231B823DBBF 0x94AAC486 b1207
	// Gets the current ingame clock second. Note that ingame clock seconds change really fast since a day in RDR is only 48 minutes in real life.
	NATIVE_DECL int GET_CLOCK_SECONDS() { return invoke<int>(0xB6101ABE62B5F080); } // 0xB6101ABE62B5F080 0x099C927E b1207
	NATIVE_DECL void _SET_MILLISECONDS_PER_GAME_MINUTE(int ms) { invoke<Void>(0x04EEDB3848DACF68, ms); } // 0x04EEDB3848DACF68 b1207
	// Base year is 1898.
	NATIVE_DECL int _GET_SECONDS_SINCE_BASE_YEAR() { return invoke<int>(0x78FD8BE812E436B2); } // 0x78FD8BE812E436B2 b1207
	NATIVE_DECL void SET_CLOCK_DATE(int day, int month, int year) { invoke<Void>(0x02AD3092562941E2, day, month, year); } // 0x02AD3092562941E2 0x96891C94 b1207
	// Gets the current day of the week.
	// 
	// 0: Sunday
	// 1: Monday
	// 2: Tuesday
	// 3: Wednesday
	// 4: Thursday
	// 5: Friday
	// 6: Saturday
	NATIVE_DECL int GET_CLOCK_DAY_OF_WEEK() { return invoke<int>(0x4DD02D4C7FB30076); } // 0x4DD02D4C7FB30076 0x84E4A289 b1207
	NATIVE_DECL int GET_CLOCK_DAY_OF_MONTH() { return invoke<int>(0xDF2FD796C54480A5); } // 0xDF2FD796C54480A5 0xC7A5ACB7 b1207
	NATIVE_DECL int GET_CLOCK_MONTH() { return invoke<int>(0x2D44E8FC79EAB1AC); } // 0x2D44E8FC79EAB1AC 0x3C48A3D5 b1207
	NATIVE_DECL int GET_CLOCK_YEAR() { return invoke<int>(0xE136DCA28C4A48BA); } // 0xE136DCA28C4A48BA 0xB8BECF15 b1207
	NATIVE_DECL int GET_MILLISECONDS_PER_GAME_MINUTE() { return invoke<int>(0xE4CB8D126501EC52); } // 0xE4CB8D126501EC52 0x3B74095C b1207
	NATIVE_DECL void GET_POSIX_TIME(int* year, int* month, int* day, int* hour, int* minute, int* second) { invoke<Void>(0x90338AD4A784E455, year, month, day, hour, minute, second); } // 0x90338AD4A784E455 0xE15A5281 b1207
	// Same as GET_POSIX_TIME except that it takes a single pointer to a struct.
	NATIVE_DECL void _GET_POSIX_TIME_STRUCT(Any* outTime) { invoke<Void>(0x86A68E84E5884951, outTime); } // 0x86A68E84E5884951 b1207
	NATIVE_DECL void _ADD_TIME_TO_DATE_TIME(Any* inDateTime, Any* timeToAdd, Any* outDateTime) { invoke<Void>(0x28EEACE9B43D9597, inDateTime, timeToAdd, outDateTime); } // 0x28EEACE9B43D9597 b1207
}

namespace COLLECTION
{
	// Used in Script Function NET_COLLECTABLES_HANDLE_ITEM_ADDED
	// Returns collectableCategory Hash
	NATIVE_DECL Hash _COLLECTABLE_GET_CATEGORY(Hash collectableItem) { return invoke<Hash>(0x725D52F21A5E9EF6, collectableItem); } // 0x725D52F21A5E9EF6 b1207
	NATIVE_DECL Hash _COLLECTABLE_GET_SUBCATEGORY(Hash collectableItem) { return invoke<Hash>(0x6052B4DE6657684F, collectableItem); } // 0x6052B4DE6657684F b1207
	NATIVE_DECL Hash _COLLECTABLE_GET_IPL(Hash collectableItem) { return invoke<Hash>(0x922A79CD4A033B8B, collectableItem); } // 0x922A79CD4A033B8B b1207
	NATIVE_DECL Vector3 _COLLECTABLE_GET_PLACEMENT_LOCATION(Hash collectableItem) { return invoke<Vector3>(0x1F1DD794908C2BFA, collectableItem); } // 0x1F1DD794908C2BFA b1207
	NATIVE_DECL int _COLLECTABLE_GET_NUM_FOUND(Hash collectableItem) { return invoke<int>(0xF83D3DDA4D3C8169, collectableItem); } // 0xF83D3DDA4D3C8169 b1207
	NATIVE_DECL int _COLLECTABLE_GET_NUM_TURNED_IN(Hash collectableItem) { return invoke<int>(0x9A03F22AD446EEAC, collectableItem); } // 0x9A03F22AD446EEAC b1207
	NATIVE_DECL void _COLLECTABLE_INCREMENT_NUM_FOUND(Hash collectableItem, int amount) { invoke<Void>(0x3EA62E56F386C997, collectableItem, amount); } // 0x3EA62E56F386C997 b1207
	NATIVE_DECL void _COLLECTABLE_INCREMENT_NUM_TURNED_IN(Hash collectableItem, int amount) { invoke<Void>(0x398FAB9C96A81924, collectableItem, amount); } // 0x398FAB9C96A81924 b1207
	NATIVE_DECL int _COLLECTABLE_CATEGORY_GET_NUM_COLLECTABLES(Hash collectableCategory, Hash collectableSubcategory) { return invoke<int>(0x62CAB7DB62EAD434, collectableCategory, collectableSubcategory); } // 0x62CAB7DB62EAD434 b1207
	NATIVE_DECL Hash _COLLECTABLE_GET_COLLECTABLE_ITEM_HASH(int index, Hash collectableCategory, Hash collectableSubcategory) { return invoke<Hash>(0x126CBEBBA46693CF, index, collectableCategory, collectableSubcategory); } // 0x126CBEBBA46693CF b1207
	NATIVE_DECL int _COLLECTABLE_CATEGORY_GET_NUM_FOUND(Hash collectableCategory, Hash collectableSubcategory) { return invoke<int>(0x5461C821D00FE15A, collectableCategory, collectableSubcategory); } // 0x5461C821D00FE15A b1207
	NATIVE_DECL int _COLLECTABLE_CATEGORY_GET_NUM_TURNED_IN(Hash collectableCategory, Hash collectableSubcategory) { return invoke<int>(0x3A65F4844913A047, collectableCategory, collectableSubcategory); } // 0x3A65F4844913A047 b1207
	NATIVE_DECL int _0x33825A7388A6B9F6(Hash collectableCategory, int p1) { return invoke<int>(0x33825A7388A6B9F6, collectableCategory, p1); } // 0x33825A7388A6B9F6 b1207
	// Returns p2 (index?) for 0xB9020EC89C07DF04
	NATIVE_DECL int _0x755901C7598B97BC(Hash collectableCategory, int p1) { return invoke<int>(0x755901C7598B97BC, collectableCategory, p1); } // 0x755901C7598B97BC b1207
	// Accepts more hashes than 0xCC644BC1DD655269
	NATIVE_DECL Any _0xB9020EC89C07DF04(Hash collectableCategory, int p1, int index) { return invoke<Any>(0xB9020EC89C07DF04, collectableCategory, p1, index); } // 0xB9020EC89C07DF04 b1207
	NATIVE_DECL BOOL _0xFC832B06127D8E99(Hash collectableCategory, int p1) { return invoke<BOOL>(0xFC832B06127D8E99, collectableCategory, p1); } // 0xFC832B06127D8E99 b1207
	NATIVE_DECL void COLLECTABLE_CATEGORY_SET_HAS_RECEIVED_LIST(Any p0, Any p1, Any p2) { invoke<Void>(0x0B6D275D2F242E17, p0, p1, p2); } // 0x0B6D275D2F242E17 b1207
	// Params: collectableCategory = WEEKLY_COLLECTABLES
	NATIVE_DECL BOOL _0x6BAB7ACED1017204(Hash collectableCategory, int p1) { return invoke<BOOL>(0x6BAB7ACED1017204, collectableCategory, p1); } // 0x6BAB7ACED1017204 b1207
	// Params: collectableCategory = WEEKLY_COLLECTABLES
	NATIVE_DECL BOOL _0x61BEFBA3CE7A3BC8(Hash collectableCategory, int p1) { return invoke<BOOL>(0x61BEFBA3CE7A3BC8, collectableCategory, p1); } // 0x61BEFBA3CE7A3BC8 b1232
	NATIVE_DECL Any _0xC4AC39719C1BB559(Hash collectableCategory, Any p1) { return invoke<Any>(0xC4AC39719C1BB559, collectableCategory, p1); } // 0xC4AC39719C1BB559 b1232
	NATIVE_DECL Any _0x93F2E7B5DB85657B(Any p0, Any p1) { return invoke<Any>(0x93F2E7B5DB85657B, p0, p1); } // 0x93F2E7B5DB85657B b1207
	NATIVE_DECL Hash COLLECTABLE_GET_CATEGORY_ITEM_SET_BUY_AWARD(Hash collectableCategory, Hash p1) { return invoke<Hash>(0xCC644BC1DD655269, collectableCategory, p1); } // 0xCC644BC1DD655269 b1207
	// Params: collectableCategory = WEEKLY_COLLECTABLES
	NATIVE_DECL Hash _0x9ADEE485726025D4(Hash collectableCategory) { return invoke<Hash>(0x9ADEE485726025D4, collectableCategory); } // 0x9ADEE485726025D4 b1207
	NATIVE_DECL Any _0xD1806FB3EDED6D11(Hash collectableCategory, int p1) { return invoke<Any>(0xD1806FB3EDED6D11, collectableCategory, p1); } // 0xD1806FB3EDED6D11 b1232
	NATIVE_DECL Any _0x3FD91F1A148A0468(Hash collectableCategory, int p1) { return invoke<Any>(0x3FD91F1A148A0468, collectableCategory, p1); } // 0x3FD91F1A148A0468 b1232
	NATIVE_DECL Any _0xC3CA424E1F12ED0C(Hash collectableCategory, int p1) { return invoke<Any>(0xC3CA424E1F12ED0C, collectableCategory, p1); } // 0xC3CA424E1F12ED0C b1232
	NATIVE_DECL Hash _COLLECTABLE_CATEGORY_GET_TOAST_TEXTURE_NAME(Hash collectableCategory, Hash collectableSubcategory) { return invoke<Hash>(0xD52D20B0C76BB26D, collectableCategory, collectableSubcategory); } // 0xD52D20B0C76BB26D b1207
	NATIVE_DECL Hash _COLLECTABLE_CATEGORY_GET_TOAST_TEXTURE_DICTIONARY(Hash collectableCategory, Hash collectableSubcategory) { return invoke<Hash>(0x13AAECDA43318BFE, collectableCategory, collectableSubcategory); } // 0x13AAECDA43318BFE b1207
	NATIVE_DECL Any _0xD297F68928A58130(Hash collectableCategory, int p1) { return invoke<Any>(0xD297F68928A58130, collectableCategory, p1); } // 0xD297F68928A58130 b1232
	NATIVE_DECL Any _0x775FA1FC87666847(Hash collectableCategory, int p1) { return invoke<Any>(0x775FA1FC87666847, collectableCategory, p1); } // 0x775FA1FC87666847 b1232
	NATIVE_DECL Any _0xEC3959E9950BF56B(int p0) { return invoke<Any>(0xEC3959E9950BF56B, p0); } // 0xEC3959E9950BF56B b1207
}

namespace COMPANION
{
	NATIVE_DECL void _0xD730281E496621FB(Ped ped, Hash p1) { invoke<Void>(0xD730281E496621FB, ped, p1); } // 0xD730281E496621FB b1207
	NATIVE_DECL void _0xBF6583E926D13890(Any p0, Any p1) { invoke<Void>(0xBF6583E926D13890, p0, p1); } // 0xBF6583E926D13890 b1207
	NATIVE_DECL void _0x0A8FD91EDE7B328A(Any p0, Any p1) { invoke<Void>(0x0A8FD91EDE7B328A, p0, p1); } // 0x0A8FD91EDE7B328A b1207
	NATIVE_DECL void _0x991E3346D788F20F(Any p0, Any p1) { invoke<Void>(0x991E3346D788F20F, p0, p1); } // 0x991E3346D788F20F b1207
	NATIVE_DECL void _0xCE27824B5968B79A(Any p0, Any p1) { invoke<Void>(0xCE27824B5968B79A, p0, p1); } // 0xCE27824B5968B79A b1207
	NATIVE_DECL void _0xF06CBB8CCCA823C0(Any p0, Any p1) { invoke<Void>(0xF06CBB8CCCA823C0, p0, p1); } // 0xF06CBB8CCCA823C0 b1207
	NATIVE_DECL void _0x2917E634206B9E17(Ped ped, int p1) { invoke<Void>(0x2917E634206B9E17, ped, p1); } // 0x2917E634206B9E17 b1207
	NATIVE_DECL void _0xD428C3F92FC3F6F8(Ped ped, const char* p1) { invoke<Void>(0xD428C3F92FC3F6F8, ped, p1); } // 0xD428C3F92FC3F6F8 b1207
	// Used for Script Function NET_FETCH_CLIENT_ACTIVATE_COMAPNION_ANALYSIS: Hiding! Ped
	NATIVE_DECL void _0xDEB369F6AD168C58(Ped ped, int p1) { invoke<Void>(0xDEB369F6AD168C58, ped, p1); } // 0xDEB369F6AD168C58 b1207
	NATIVE_DECL void _0x1740E3DEE0AE4D27(Ped ped, int p1) { invoke<Void>(0x1740E3DEE0AE4D27, ped, p1); } // 0x1740E3DEE0AE4D27 b1207
	NATIVE_DECL void _0x0DE02DA3C0F66955(Any p0, Any p1) { invoke<Void>(0x0DE02DA3C0F66955, p0, p1); } // 0x0DE02DA3C0F66955 b1207
	NATIVE_DECL void _0x0F1CD8CA9E65D5F6(int groupId, Hash p1) { invoke<Void>(0x0F1CD8CA9E65D5F6, groupId, p1); } // 0x0F1CD8CA9E65D5F6 b1207
	NATIVE_DECL Any _0xB7E0590C86E1711F(Any p0) { return invoke<Any>(0xB7E0590C86E1711F, p0); } // 0xB7E0590C86E1711F b1207
	NATIVE_DECL void _0xA079FF7CFB9AC8BD(Any p0, Any p1) { invoke<Void>(0xA079FF7CFB9AC8BD, p0, p1); } // 0xA079FF7CFB9AC8BD b1207
	NATIVE_DECL void _0x61BDA07407754A5C(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x61BDA07407754A5C, p0, p1, p2, p3); } // 0x61BDA07407754A5C b1207
	NATIVE_DECL void _0xD55A871E1CE3481B(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xD55A871E1CE3481B, p0, p1, p2, p3); } // 0xD55A871E1CE3481B b1207
	NATIVE_DECL void _0x0C6A00DAE896614C(Any p0, Any p1) { invoke<Void>(0x0C6A00DAE896614C, p0, p1); } // 0x0C6A00DAE896614C b1207
	NATIVE_DECL void _0x8FB98B719AA0075A(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x8FB98B719AA0075A, p0, p1, p2, p3, p4); } // 0x8FB98B719AA0075A b1207
	NATIVE_DECL void _0x9C902084F48D2E6C(Any p0) { invoke<Void>(0x9C902084F48D2E6C, p0); } // 0x9C902084F48D2E6C b1207
	NATIVE_DECL void _0xD747979C053EFA7A(Any p0) { invoke<Void>(0xD747979C053EFA7A, p0); } // 0xD747979C053EFA7A b1207
	NATIVE_DECL void _0x3CAAD93FA5B9579A(Volume volume, int p1, int p2) { invoke<Void>(0x3CAAD93FA5B9579A, volume, p1, p2); } // 0x3CAAD93FA5B9579A b1207
	NATIVE_DECL void _0x7274F84B1501B523(Any p0) { invoke<Void>(0x7274F84B1501B523, p0); } // 0x7274F84B1501B523 b1207
	NATIVE_DECL Any _0x722FBE08EF5B87BD(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0x722FBE08EF5B87BD, p0, p1, p2, p3, p4); } // 0x722FBE08EF5B87BD b1207
	NATIVE_DECL void _ACTIVATE_COMPANION_ANALYSIS(int groupId) { invoke<Void>(0xCBD9EC60495C728C, groupId); } // 0xCBD9EC60495C728C b1207
	NATIVE_DECL void _DEACTIVATE_COMPANION_ANALYSIS(int groupId) { invoke<Void>(0x72B7F65F11FC8896, groupId); } // 0x72B7F65F11FC8896 b1207
}

namespace COMPENDIUM
{
	NATIVE_DECL Any _0x725D52F21A5E9E22(Hash category) { return invoke<Any>(0x725D52F21A5E9E22, category); } // 0x725D52F21A5E9E22 b1207
	NATIVE_DECL int _COMPENDIUM_GET_NUM_OF_ENTRIES_IN_CATEGORY(Hash category) { return invoke<int>(0x729D52F61A5A9E22, category); } // 0x729D52F61A5A9E22 b1207
	NATIVE_DECL Any _0x729D52461AEA9E22(Hash category) { return invoke<Any>(0x729D52461AEA9E22, category); } // 0x729D52461AEA9E22 b1207
	NATIVE_DECL Any COMPENDIUM_GET_SHORT_DESCRIPTION_FROM_PED(Ped ped) { return invoke<Any>(0x6C5E5D48E48B4C65, ped); } // 0x6C5E5D48E48B4C65 b1207
	NATIVE_DECL Any COMPENDIUM_GET_SUBCATEGORY_PED_IS_IN(Hash p0, Ped ped) { return invoke<Any>(0x9B657550DF55EC96, p0, ped); } // 0x9B657550DF55EC96 b1311
	NATIVE_DECL Any _0xCD278B6BFBDBDC22(Any p0, Any p1) { return invoke<Any>(0xCD278B6BFBDBDC22, p0, p1); } // 0xCD278B6BFBDBDC22 b1355
	NATIVE_DECL Any COMPENDIUM_GET_NUM_ENTRIES_IN_SUBCATEGORY(Hash p0, Hash p1) { return invoke<Any>(0xF58A0C0E086E8E36, p0, p1); } // 0xF58A0C0E086E8E36 b1311
	NATIVE_DECL Any COMPENDIUM_GET_ENTRY_BY_INDEX_IN_SUBCATEGORY(Hash p0, Any p1, Any p2) { return invoke<Any>(0x5CEB63B2E3D9895F, p0, p1, p2); } // 0x5CEB63B2E3D9895F b1311
	NATIVE_DECL Any COMPENDIUM_GET_ENTRY_BY_PED_INDEX(Any p0, Any p1) { return invoke<Any>(0x1CFA0219D8E1CF25, p0, p1); } // 0x1CFA0219D8E1CF25 b1311
	NATIVE_DECL Any COMPENDIUM_GET_ENTRY_BY_STAT_ITEM(Any p0, Any p1) { return invoke<Any>(0x66EC938394D76C85, p0, p1); } // 0x66EC938394D76C85 b1355
	NATIVE_DECL Any COMPENDIUM_GET_SUBCATEGORY_TOAST_APP_ID(Any p0, Any p1) { return invoke<Any>(0x2BF30D9D4D680112, p0, p1); } // 0x2BF30D9D4D680112 b1311
	NATIVE_DECL Any COMPENDIUM_GET_MAP_DISCOVERABLE_FROM_STAT_ITEM(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x729D54121A5E9E20, p0, p1, p2, p3); } // 0x729D54121A5E9E20 b1207
	NATIVE_DECL void COMPENDIUM_ANIMAL_OBSERVED_BY_STAT_NAME(Hash animalType, BOOL p1) { invoke<Void>(0x725D52F26A5E9E10, animalType, p1); } // 0x725D52F26A5E9E10 b1207
	NATIVE_DECL Any COMPENDIUM_WAS_ANIMAL_OBSERVED(Any p0) { return invoke<Any>(0x23B5E9C5160BC04F, p0); } // 0x23B5E9C5160BC04F b1311
	NATIVE_DECL void COMPENDIUM_ANIMAL_SET_DISCOVERED(Any p0) { invoke<Void>(0x67F35C7C9F2BDCFE, p0); } // 0x67F35C7C9F2BDCFE b1311
	NATIVE_DECL Any COMPENDIUM_GET_STUDY_AWARD_ID(Any p0) { return invoke<Any>(0x9F678782720349E4, p0); } // 0x9F678782720349E4 b1311
	NATIVE_DECL Any COMPENDIUM_ANIMAL_GET_SAMPLE_INVENTORY_ITEM(Any p0) { return invoke<Any>(0x4E4ACAE1C671A9DA, p0); } // 0x4E4ACAE1C671A9DA b1311
	NATIVE_DECL Any COMPENDIUM_ANIMAL_HAS_SAMPLE(Any p0) { return invoke<Any>(0x6FC24625E4FCAC27, p0); } // 0x6FC24625E4FCAC27 b1311
	NATIVE_DECL Any COMPENDIUM_ANIMAL_HAS_STAMP(Any p0) { return invoke<Any>(0xBCF569FC32FFF456, p0); } // 0xBCF569FC32FFF456 b1311
	NATIVE_DECL Any COMPENDIUM_GET_SUBCATEGORY_SAMPLE_TOAST_TITLE(Any p0, Any p1) { return invoke<Any>(0x5E50C67EB60951E6, p0, p1); } // 0x5E50C67EB60951E6 b1311
	NATIVE_DECL Any COMPENDIUM_GET_SUBCATEGORY_SAMPLE_TOAST_DESC_PROGRESS(Any p0, Any p1) { return invoke<Any>(0x82BFB5B367957699, p0, p1); } // 0x82BFB5B367957699 b1311
	NATIVE_DECL Any COMPENDIUM_GET_SUBCATEGORY_SAMPLE_TOAST_DESC_COMPLETE(Any p0, Any p1) { return invoke<Any>(0x59D4D68CDB82427C, p0, p1); } // 0x59D4D68CDB82427C b1311
	NATIVE_DECL void COMPENDIUM_FISH_CAUGHT(Any p0, Any p1) { invoke<Void>(0x725D52F21A5E9E00, p0, p1); } // 0x725D52F21A5E9E00 b1207
	NATIVE_DECL Any COMPENDIUM_FISH_GET_LURE_SUITABILITY_BY_STAT_ITEM(Any p0, Any p1) { return invoke<Any>(0x725D52F21A5E9E81, p0, p1); } // 0x725D52F21A5E9E81 b1207
	NATIVE_DECL void COMPENDIUM_GANG_CAMP_FOUND(Any p0, Any p1) { invoke<Void>(0x725D52F21A5E9E03, p0, p1); } // 0x725D52F21A5E9E03 b1207
	NATIVE_DECL void COMPENDIUM_GANG_AMBUSH_SURVIVED(Any p0) { invoke<Void>(0x725D52F21A5E9E04, p0); } // 0x725D52F21A5E9E04 b1207
	NATIVE_DECL void COMPENDIUM_GANG_ENCOUNTERED(Any p0) { invoke<Void>(0x725D52F21A5E9E05, p0); } // 0x725D52F21A5E9E05 b1207
	NATIVE_DECL void COMPENDIUM_GANG_BOUNTY_CAPTURED(Any p0) { invoke<Void>(0x725D52F21A5E9E06, p0); } // 0x725D52F21A5E9E06 b1207
	NATIVE_DECL void COMPENDIUM_GANG_MEMBER_KILLED(Any p0) { invoke<Void>(0x725D52F21A5E9E07, p0); } // 0x725D52F21A5E9E07 b1207
	NATIVE_DECL void COMPENDIUM_GANG_HIDEOUT_FOUND(Any p0, Any p1) { invoke<Void>(0x725D52F21A5E9E08, p0, p1); } // 0x725D52F21A5E9E08 b1207
	// herbType: https://alloc8or.re/rdr3/doc/enums/eHerbType.txt
	NATIVE_DECL void COMPENDIUM_HERB_PICKED(Hash herbType, float x, float y, float z) { invoke<Void>(0x725D52F21A5E9E09, herbType, x, y, z); } // 0x725D52F21A5E9E09 b1207
	NATIVE_DECL void COMPENDIUM_HERB_PICKED(Hash herbType, Vector3 vec) { invoke<Void>(0x725D52F21A5E9E09, herbType, vec.x, vec.y, vec.z); } // 0x725D52F21A5E9E09 b1207
	NATIVE_DECL void COMPENDIUM_HORSE_BONDING(Ped ped, int bondingLevel) { invoke<Void>(0x725D52F21A5E9E50, ped, bondingLevel); } // 0x725D52F21A5E9E50 b1207
	NATIVE_DECL void COMPENDIUM_HORSE_WILD_BROKEN(Any p0) { invoke<Void>(0x725852D21A2E9E50, p0); } // 0x725852D21A2E9E50 b1207
	NATIVE_DECL void COMPENDIUM_HORSE_OBSERVED(Any p0, Any p1) { invoke<Void>(0x725D58F2125E5E50, p0, p1); } // 0x725D58F2125E5E50 b1207
}

namespace CRASHLOG
{
	NATIVE_DECL void _0x0FD3ECF9D0C8655F(const char* p0) { invoke<Void>(0x0FD3ECF9D0C8655F, p0); } // 0x0FD3ECF9D0C8655F b1207
	NATIVE_DECL void _0xCA0BAC376C541978(const char* p0) { invoke<Void>(0xCA0BAC376C541978, p0); } // 0xCA0BAC376C541978 b1207
	NATIVE_DECL BOOL _0x3A66F1963B223F61(const char* p0) { return invoke<BOOL>(0x3A66F1963B223F61, p0); } // 0x3A66F1963B223F61 b1207
	NATIVE_DECL BOOL _0x7C680FF55617F82F() { return invoke<BOOL>(0x7C680FF55617F82F); } // 0x7C680FF55617F82F b1207
	NATIVE_DECL BOOL _0xD8E3D22AA4F0E0A5(const char* p0) { return invoke<BOOL>(0xD8E3D22AA4F0E0A5, p0); } // 0xD8E3D22AA4F0E0A5 b1207
	NATIVE_DECL BOOL _0xA67F0B039D9CD513(BOOL p0) { return invoke<BOOL>(0xA67F0B039D9CD513, p0); } // 0xA67F0B039D9CD513 b1207
	NATIVE_DECL BOOL _0xE72E234B30DA7B7A(int p0) { return invoke<BOOL>(0xE72E234B30DA7B7A, p0); } // 0xE72E234B30DA7B7A b1207
	NATIVE_DECL BOOL _0x87F005C969EF1563(float p0) { return invoke<BOOL>(0x87F005C969EF1563, p0); } // 0x87F005C969EF1563 b1207
	NATIVE_DECL BOOL _0x23CCAB8F40B9CBEE(float x, float y, float z) { return invoke<BOOL>(0x23CCAB8F40B9CBEE, x, y, z); } // 0x23CCAB8F40B9CBEE b1207
	NATIVE_DECL BOOL _0x23CCAB8F40B9CBEE(Vector3 vec) { return invoke<BOOL>(0x23CCAB8F40B9CBEE, vec.x, vec.y, vec.z); } // 0x23CCAB8F40B9CBEE b1207
	NATIVE_DECL BOOL _0xF0D545C1EEAD614A() { return invoke<BOOL>(0xF0D545C1EEAD614A); } // 0xF0D545C1EEAD614A b1207
	NATIVE_DECL BOOL _0x33C1D63E55FA4284(const char* p0) { return invoke<BOOL>(0x33C1D63E55FA4284, p0); } // 0x33C1D63E55FA4284 b1207
	NATIVE_DECL void _0x4E42CA5BCD45444A() { invoke<Void>(0x4E42CA5BCD45444A); } // 0x4E42CA5BCD45444A b1207
	NATIVE_DECL void _0xDA05310EA94DC8C6(const char* p0, const char* p1) { invoke<Void>(0xDA05310EA94DC8C6, p0, p1); } // 0xDA05310EA94DC8C6 b1436
}

namespace CREW
{
	NATIVE_DECL BOOL NETWORK_FIND_GAMERS_IN_CREW(int p0) { return invoke<BOOL>(0xE532D6811B3A4D2A, p0); } // 0xE532D6811B3A4D2A 0x7771AB83 b1207
	NATIVE_DECL BOOL NETWORK_CLAN_SERVICE_IS_VALID() { return invoke<BOOL>(0x579CCED0265D4896); } // 0x579CCED0265D4896 0xF5F4BD95 b1207
	NATIVE_DECL BOOL NETWORK_CLAN_PLAYER_IS_ACTIVE(Any* gamerHandle) { return invoke<BOOL>(0xB124B57F571D8F18, gamerHandle); } // 0xB124B57F571D8F18 0xAB8319A3 b1207
	NATIVE_DECL BOOL NETWORK_CLAN_PLAYER_GET_DESC(Any* clanDesc, int bufferSize, Any* gamerHandle) { return invoke<BOOL>(0xEEE6EACBE8874FBA, clanDesc, bufferSize, gamerHandle); } // 0xEEE6EACBE8874FBA 0x6EE4A282 b1207
	NATIVE_DECL int NETWORK_CLAN_GET_LOCAL_MEMBERSHIPS_COUNT() { return invoke<int>(0x1F471B79ACC90BEF); } // 0x1F471B79ACC90BEF 0x807B3450 b1207
	NATIVE_DECL BOOL NETWORK_CLAN_GET_MEMBERSHIP_DESC(Any* memberDesc, int p1) { return invoke<BOOL>(0x48DE78AF2C8885B8, memberDesc, p1); } // 0x48DE78AF2C8885B8 0x3369DD1F b1207
	NATIVE_DECL BOOL _0x58D378AF2C8765B7(Any p0) { return invoke<BOOL>(0x58D378AF2C8765B7, p0); } // 0x58D378AF2C8765B7 b1207
	NATIVE_DECL BOOL _0xC685B014CE3D988B(Any p0) { return invoke<BOOL>(0xC685B014CE3D988B, p0); } // 0xC685B014CE3D988B b1207
	NATIVE_DECL BOOL _0x8E2143144B8E188D(int p0) { return invoke<BOOL>(0x8E2143144B8E188D, p0); } // 0x8E2143144B8E188D b1207
	NATIVE_DECL BOOL NETWORK_CLAN_REQUEST_EMBLEM(Any p0) { return invoke<BOOL>(0x13518FF1C6B28938, p0); } // 0x13518FF1C6B28938 0x7963FA4D b1207
	NATIVE_DECL BOOL NETWORK_CLAN_IS_EMBLEM_READY(Any p0, Any* p1) { return invoke<BOOL>(0xA134777FF7F33331, p0, p1); } // 0xA134777FF7F33331 0x88B13CDC b1207
	NATIVE_DECL void NETWORK_CLAN_RELEASE_EMBLEM(Any p0) { invoke<Void>(0x113E6E3E50E286B0, p0); } // 0x113E6E3E50E286B0 0xD6E3D5EA b1207
	NATIVE_DECL Any NETWORK_GET_PRIMARY_CLAN_DATA_CLEAR() { return invoke<Any>(0x9AA46BADAD0E27ED); } // 0x9AA46BADAD0E27ED 0xE22445DA b1207
	NATIVE_DECL BOOL NETWORK_GET_PRIMARY_CLAN_DATA_START(Any* p0, Any p1) { return invoke<BOOL>(0xCE86D8191B762107, p0, p1); } // 0xCE86D8191B762107 0x89DB0EC7 b1207
	NATIVE_DECL Any NETWORK_GET_PRIMARY_CLAN_DATA_PENDING() { return invoke<Any>(0xB5074DB804E28CE7); } // 0xB5074DB804E28CE7 0xA4EF02F3 b1207
	NATIVE_DECL Any NETWORK_GET_PRIMARY_CLAN_DATA_SUCCESS() { return invoke<Any>(0x5B4F04F19376A0BA); } // 0x5B4F04F19376A0BA 0x068A054E b1207
	NATIVE_DECL BOOL NETWORK_GET_PRIMARY_CLAN_DATA_NEW(Any* p0, Any* p1) { return invoke<BOOL>(0xC080FF658B2E41DA, p0, p1); } // 0xC080FF658B2E41DA 0x9B8631EB b1207
	NATIVE_DECL Any _0xC080FF658B2E51DA(Any p0) { return invoke<Any>(0xC080FF658B2E51DA, p0); } // 0xC080FF658B2E51DA b1207
}

namespace DATABINDING
{
	NATIVE_DECL Any _DATABINDING_GET_DATA_CONTAINER_FROM_PATH(const char* p0) { return invoke<Any>(0x0C827D175F1292F2, p0); } // 0x0C827D175F1292F2 b1207
	NATIVE_DECL Any _DATABINDING_GET_DATA_CONTAINER_FROM_CHILD_INDEX(Hash entryId, int p1) { return invoke<Any>(0x0C827D175F1292F3, entryId, p1); } // 0x0C827D175F1292F3 b1207
	NATIVE_DECL Any _0xD7DB94AB78E8EBE4(const char* p0, Hash p1) { return invoke<Any>(0xD7DB94AB78E8EBE4, p0, p1); } // 0xD7DB94AB78E8EBE4 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_CONTAINER_FROM_PATH(const char* p0, const char* p1) { return invoke<Any>(0x0C827D175F1292F4, p0, p1); } // 0x0C827D175F1292F4 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_CONTAINER_BY_HASH(Any p0, Hash p1) { return invoke<Any>(0x98BB14345BB68257, p0, p1); } // 0x98BB14345BB68257 b1207
	// Returns entryId Hash
	NATIVE_DECL Hash _DATABINDING_ADD_DATA_CONTAINER(Hash entryId, const char* p1) { return invoke<Hash>(0xEB4F9A3537EEABCD, entryId, p1); } // 0xEB4F9A3537EEABCD b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_BOOL_FROM_PATH(const char* p0, const char* p1, BOOL p2) { return invoke<Any>(0x37BB86A751148A6A, p0, p1, p2); } // 0x37BB86A751148A6A b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_BOOL_BY_HASH(Any p0, Hash p1, BOOL p2) { return invoke<Any>(0xBC95D3AE2ECA70D6, p0, p1, p2); } // 0xBC95D3AE2ECA70D6 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_BOOL(Any p0, const char* p1, BOOL p2) { return invoke<Any>(0x58BAA5F635DA2FF4, p0, p1, p2); } // 0x58BAA5F635DA2FF4 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_INT_BY_HASH(Any p0, Hash p1, int p2) { return invoke<Any>(0x267F9527F4350ADE, p0, p1, p2); } // 0x267F9527F4350ADE b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_INT(Any p0, const char* p1, Hash p2) { return invoke<Any>(0x307A3247C5457BDE, p0, p1, p2); } // 0x307A3247C5457BDE b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_FLOAT(Any p0, const char* p1, float p2) { return invoke<Any>(0x5154228273ADB9A6, p0, p1, p2); } // 0x5154228273ADB9A6 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_HASH_BY_HASH(Any p0, Hash p1, Hash p2) { return invoke<Any>(0x8E173DFB041993C6, p0, p1, p2); } // 0x8E173DFB041993C6 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_HASH(Any p0, const char* p1, Hash p2) { return invoke<Any>(0x8538F1205D60ECA6, p0, p1, p2); } // 0x8538F1205D60ECA6 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_STRING_FROM_PATH(const char* p0, const char* p1, const char* p2) { return invoke<Any>(0xA381DE86EE170C4A, p0, p1, p2); } // 0xA381DE86EE170C4A b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_STRING_BY_HASH(Any p0, Hash p1, const char* p2) { return invoke<Any>(0xEAD09E76E22630C3, p0, p1, p2); } // 0xEAD09E76E22630C3 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_STRING(Any p0, const char* p1, const char* p2) { return invoke<Any>(0x617FCA1C5652BBAD, p0, p1, p2); } // 0x617FCA1C5652BBAD b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_GANG_ID(Any p0, const char* p1, Any gangId) { return invoke<Any>(0x7D0F2014DB28DD00, p0, p1, gangId); } // 0x7D0F2014DB28DD00 b1207
	NATIVE_DECL Any _DATABINDING_ADD_DATA_POSSE_ID(Any p0, const char* p1, Any posseId) { return invoke<Any>(0x7D0F2014DB28DD01, p0, p1, posseId); } // 0x7D0F2014DB28DD01 b1207
	NATIVE_DECL Any _0x294AF5323F44B053(Any p0, const char* p1, Any p2) { return invoke<Any>(0x294AF5323F44B053, p0, p1, p2); } // 0x294AF5323F44B053 b1207
	NATIVE_DECL Any _DATABINDING_ADD_UI_ITEM_LIST_FROM_PATH(const char* p0, const char* p1) { return invoke<Any>(0xDB5B9A474148F699, p0, p1); } // 0xDB5B9A474148F699 b1207
	NATIVE_DECL Any _DATABINDING_ADD_UI_ITEM_LIST_BY_HASH(Any p0, Hash p1) { return invoke<Any>(0x3C7799283325181B, p0, p1); } // 0x3C7799283325181B b1207
	NATIVE_DECL Any _DATABINDING_ADD_UI_ITEM_LIST(Any p0, const char* p1) { return invoke<Any>(0xFE74FA57E0CE6824, p0, p1); } // 0xFE74FA57E0CE6824 b1207
	NATIVE_DECL void _DATABINDING_INSERT_UI_ITEM_TO_LIST_FROM_CONTEXT_STRING_ALIAS(Any p0, int index, const char* p2, Any p3) { invoke<Void>(0x5859E970794D92F3, p0, index, p2, p3); } // 0x5859E970794D92F3 b1207
	NATIVE_DECL void _DATABINDING_INSERT_UI_ITEM_TO_LIST_FROM_CONTEXT_HASH_ALIAS(Any p0, int index, Hash p2, Any p3) { invoke<Void>(0xEE97A05C05F16E41, p0, index, p2, p3); } // 0xEE97A05C05F16E41 b1207
	NATIVE_DECL void _DATABINDING_INSERT_UI_ITEM_TO_LIST_FROM_PATH_STRING_ALIAS(Any p0, Any p1, const char* p2, Any p3) { invoke<Void>(0x5740774F608E4FC8, p0, p1, p2, p3); } // 0x5740774F608E4FC8 b1207
	NATIVE_DECL void _0x6318FB3BE37E11B3(Hash entryId, int index) { invoke<Void>(0x6318FB3BE37E11B3, entryId, index); } // 0x6318FB3BE37E11B3 b1207
	NATIVE_DECL void _DATABINDING_REMOVE_BINDING_ARRAY_ITEM_BY_DATA_CONTEXT_ID(Any p0, Hash entryId) { invoke<Void>(0xF68B1726EAF7B285, p0, entryId); } // 0xF68B1726EAF7B285 b1207
	NATIVE_DECL void _DATABINDING_CLEAR_BINDING_ARRAY(Hash entryId) { invoke<Void>(0xA1F15C1D03DF802D, entryId); } // 0xA1F15C1D03DF802D b1207
	NATIVE_DECL Any _DATABINDING_GET_ITEM_CONTEXT_BY_INDEX(Any p0, int index) { return invoke<Any>(0xE96D7F9FEFCC105F, p0, index); } // 0xE96D7F9FEFCC105F b1207
	NATIVE_DECL void _DATABINDING_SET_TEMPLATED_UI_ITEM_LIST_SIZE(Any p0, int p1) { invoke<Void>(0xFE74FA57E0CE6825, p0, p1); } // 0xFE74FA57E0CE6825 b1207
	NATIVE_DECL void _DATABINDING_SET_TEMPLATED_UI_ITEM_HASH_ALIAS(Any p0, int p1, Hash p2) { invoke<Void>(0x0AE7138D0541F2DE, p0, p1, p2); } // 0x0AE7138D0541F2DE b1207
	NATIVE_DECL Any _0xD48993A61938C64D(Any p0, const char* p1) { return invoke<Any>(0xD48993A61938C64D, p0, p1); } // 0xD48993A61938C64D b1207
	NATIVE_DECL Any _DATABINDING_ADD_HASH_ARRAY(Any p0, const char* p1) { return invoke<Any>(0x52F5F08278EA5D75, p0, p1); } // 0x52F5F08278EA5D75 b1207
	NATIVE_DECL Any _DATABINDING_ADD_STRING_ARRAY(Any p0, const char* p1) { return invoke<Any>(0x1B23E0627BDBFE85, p0, p1); } // 0x1B23E0627BDBFE85 b1207
	NATIVE_DECL void _0x1919D59E60FD516E(Any p0, int p1, int p2) { invoke<Void>(0x1919D59E60FD516E, p0, p1, p2); } // 0x1919D59E60FD516E b1207
	NATIVE_DECL void _0x7FC60C94C83C5CD7(Any p0, Hash p1, int p2) { invoke<Void>(0x7FC60C94C83C5CD7, p0, p1, p2); } // 0x7FC60C94C83C5CD7 b1207
	NATIVE_DECL void _0xC900CEC8A172375B(Any p0, const char* p1, int p2) { invoke<Void>(0xC900CEC8A172375B, p0, p1, p2); } // 0xC900CEC8A172375B b1207
	NATIVE_DECL Any _0x02B21B6BEEDD83CC(Hash entryId, int p1) { return invoke<Any>(0x02B21B6BEEDD83CC, entryId, p1); } // 0x02B21B6BEEDD83CC b1207
	NATIVE_DECL Any _0xF47E33F8D2523825(Any p0, int p1) { return invoke<Any>(0xF47E33F8D2523825, p0, p1); } // 0xF47E33F8D2523825 b1207
	NATIVE_DECL void _0x3BF0767CF33FCC88(Hash entryId) { invoke<Void>(0x3BF0767CF33FCC88, entryId); } // 0x3BF0767CF33FCC88 b1207
	NATIVE_DECL Any _DATABINDING_GET_ARRAY_COUNT(Hash entryId) { return invoke<Any>(0xD23F5DE04FE717E2, entryId); } // 0xD23F5DE04FE717E2 b1207
	template<typename... Args> NATIVE_DECL void _DATABINDING_WRITE_DATA_SCRIPT_VARIABLES(int p0, int p1, Args... args) { invoke<Void>(0xAB888B4B91046771, p0, p1, args...); } // 0xAB888B4B91046771 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_BOOL(Any p0, BOOL p1) { invoke<Void>(0xAB888B4B91046770, p0, p1); } // 0xAB888B4B91046770 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_BOOL_FROM_PARENT(Any p0, const char* p1, BOOL p2) { invoke<Void>(0xBDFE546E4C2D0E21, p0, p1, p2); } // 0xBDFE546E4C2D0E21 b1207
	// _DATABINDING_WRITE_DATA_*
	NATIVE_DECL void _0xBFC83DA249BEFCC9(Any p0, Hash p1, Any p2) { invoke<Void>(0xBFC83DA249BEFCC9, p0, p1, p2); } // 0xBFC83DA249BEFCC9 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_INT(Any p0, int p1) { invoke<Void>(0x335C3F6B3766B8D9, p0, p1); } // 0x335C3F6B3766B8D9 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_INT_FROM_PARENT(Any p0, const char* p1, int p2) { invoke<Void>(0x9EFA98238BA08FC4, p0, p1, p2); } // 0x9EFA98238BA08FC4 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_INT_FROM_PARENT_BY_HASH(Any p0, Hash p1, Any p2) { invoke<Void>(0x9D6E10A41D6ED6EC, p0, p1, p2); } // 0x9D6E10A41D6ED6EC b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_FLOAT(Any p0, float p1) { invoke<Void>(0xDF504BECEB15DA93, p0, p1); } // 0xDF504BECEB15DA93 b1207
	// _DATABINDING_WRITE_DATA_*
	NATIVE_DECL void _0x05AC9E1E02975AFB(Any p0, const char* p1, float p2) { invoke<Void>(0x05AC9E1E02975AFB, p0, p1, p2); } // 0x05AC9E1E02975AFB b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_HASH_STRING(Any p0, Hash p1) { invoke<Void>(0xACDEF586BD71B1FD, p0, p1); } // 0xACDEF586BD71B1FD b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_HASH_STRING_FROM_PARENT(Any p0, const char* p1, Hash p2) { invoke<Void>(0x0971F04E1EAA7AE8, p0, p1, p2); } // 0x0971F04E1EAA7AE8 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_HASH_STRING_FROM_PARENT_BY_HASH(Any p0, Hash p1, Any p2) { invoke<Void>(0x20209529689E0953, p0, p1, p2); } // 0x20209529689E0953 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_STRING(Any p0, const char* p1) { invoke<Void>(0xE1BD342F2872AEE9, p0, p1); } // 0xE1BD342F2872AEE9 b1207
	NATIVE_DECL void DATABINDING_WRITE_STRING_FROM_PARENT(Any p0, const char* p1, const char* p2) { invoke<Void>(0x4FF713B2F17A391E, p0, p1, p2); } // 0x4FF713B2F17A391E b1207
	NATIVE_DECL void _DATABINDING_WRITE_STRING_FROM_HASH(Any p0, Hash p1, const char* p2) { invoke<Void>(0xA3BD6FF95E713EE5, p0, p1, p2); } // 0xA3BD6FF95E713EE5 b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_GANG_ID(Any p0, const char* p1, Any gangId) { invoke<Void>(0xC70041408E16BE2D, p0, p1, gangId); } // 0xC70041408E16BE2D b1207
	NATIVE_DECL void _DATABINDING_WRITE_DATA_POSSE_ID(Any p0, const char* p1, Any posseId) { invoke<Void>(0xC70041408E16BE2E, p0, p1, posseId); } // 0xC70041408E16BE2E b1207
	NATIVE_DECL void _0x422179C7F6AD9304(Any p0, Any* gamerHandle) { invoke<Void>(0x422179C7F6AD9304, p0, gamerHandle); } // 0x422179C7F6AD9304 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_BOOL(Any p0) { return invoke<Any>(0x5EEFBD4B6D7CD6EB, p0); } // 0x5EEFBD4B6D7CD6EB b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_BOOL_FROM_PARENT(Any p0, const char* p1) { return invoke<Any>(0xA8EDE09FE07BD77F, p0, p1); } // 0xA8EDE09FE07BD77F b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_BOOL_FROM_PARENT_BY_HASH(Any p0, Hash p1) { return invoke<Any>(0x4CDC3FDDFAE07EB3, p0, p1); } // 0x4CDC3FDDFAE07EB3 b1207
	NATIVE_DECL int DATABINDING_READ_INT(Any p0) { return invoke<int>(0x570784D782597512, p0); } // 0x570784D782597512 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_INT_FROM_PARENT(Any p0, const char* p1) { return invoke<Any>(0xFFC566A4801F6B40, p0, p1); } // 0xFFC566A4801F6B40 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_INT_FROM_PARENT_BY_HASH(Any p0, Hash p1) { return invoke<Any>(0xB5F668B648EC0970, p0, p1); } // 0xB5F668B648EC0970 b1207
	NATIVE_DECL float _0x5FE444EB67C70AD4(Hash entryId) { return invoke<float>(0x5FE444EB67C70AD4, entryId); } // 0x5FE444EB67C70AD4 b1207
	NATIVE_DECL Hash _0x81D7183E7A8ECA72(Hash entryId) { return invoke<Hash>(0x81D7183E7A8ECA72, entryId); } // 0x81D7183E7A8ECA72 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_HASH_STRING_FROM_PARENT(Any p0, const char* p1) { return invoke<Any>(0x9B535990B01B62DE, p0, p1); } // 0x9B535990B01B62DE b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_HASH_STRING_FROM_PARENT_BY_HASH(Any p0, Hash p1) { return invoke<Any>(0x1F43BC25A119B252, p0, p1); } // 0x1F43BC25A119B252 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_STRING(Any p0) { return invoke<Any>(0x3D290B5FFA7C5151, p0); } // 0x3D290B5FFA7C5151 b1207
	NATIVE_DECL Any _DATABINDING_READ_DATA_STRING_FROM_PARENT(Any p0, const char* p1) { return invoke<Any>(0x6323AD277C4A2AFB, p0, p1); } // 0x6323AD277C4A2AFB b1207
	NATIVE_DECL Any _0x6329C34BEE5BFF4B(Any p0, Hash p1) { return invoke<Any>(0x6329C34BEE5BFF4B, p0, p1); } // 0x6329C34BEE5BFF4B b1207
	NATIVE_DECL Any _0xE6AAB897120492D6(Any p0, const char* p1) { return invoke<Any>(0xE6AAB897120492D6, p0, p1); } // 0xE6AAB897120492D6 b1207
	NATIVE_DECL void _0xE6AAB897120492D7(Any p0, const char* p1, Any p2) { invoke<Void>(0xE6AAB897120492D7, p0, p1, p2); } // 0xE6AAB897120492D7 b1207
	NATIVE_DECL void _0xB138CA787F3DD858(Any p0, const char* p1, Any p2) { invoke<Void>(0xB138CA787F3DD858, p0, p1, p2); } // 0xB138CA787F3DD858 b1207
	NATIVE_DECL BOOL DATABINDING_IS_ENTRY_VALID(Hash entryId) { return invoke<BOOL>(0x1E7130793AAAAB8D, entryId); } // 0x1E7130793AAAAB8D b1207
	NATIVE_DECL void _DATABINDING_REMOVE_DATA_ENTRY(Hash entryId) { invoke<Void>(0x0AE9938D0541F2DA, entryId); } // 0x0AE9938D0541F2DA b1207
	NATIVE_DECL void _VIRTUAL_COLLECTION_SET_SIZE(Any p0, int size) { invoke<Void>(0x9DCE9B01A93B58BC, p0, size); } // 0x9DCE9B01A93B58BC b1207
	NATIVE_DECL void _VIRTUAL_COLLECTION_SET_INTEREST_INDEX(Any p0, int interestIndex) { invoke<Void>(0x49A8447533308BCF, p0, interestIndex); } // 0x49A8447533308BCF b1207
	NATIVE_DECL void _VIRTUAL_COLLECTION_ITEM_ADD(Any p0, int index, Hash p2, Any p3) { invoke<Void>(0x6DCBF187221CF73D, p0, index, p2, p3); } // 0x6DCBF187221CF73D b1207
	NATIVE_DECL void _VIRTUAL_COLLECTION_RESET(Any p0) { invoke<Void>(0x09D95666ED2B5F60, p0); } // 0x09D95666ED2B5F60 b1207
	NATIVE_DECL Any _VIRTUAL_COLLECTION_EXISTS(Any p0) { return invoke<Any>(0x37963B56755BFB35, p0); } // 0x37963B56755BFB35 b1207
}

namespace DATAFILE
{
	// Adds the given request ID to the watch list.
	NATIVE_DECL void DATAFILE_WATCH_REQUEST_ID(int id) { invoke<Void>(0xA5834834CA8FD7FC, id); } // 0xA5834834CA8FD7FC 0x621388FF b1207
	NATIVE_DECL BOOL DATAFILE_HAS_LOADED_FILE_DATA(Any p0) { return invoke<BOOL>(0x17279C820464CEE0, p0); } // 0x17279C820464CEE0 0x36FB8B3F b1207
	NATIVE_DECL BOOL DATAFILE_HAS_VALID_FILE_DATA(Any p0) { return invoke<BOOL>(0xE60100389E50EADE, p0); } // 0xE60100389E50EADE 0x2A9411DA b1207
	NATIVE_DECL BOOL DATAFILE_SELECT_ACTIVE_FILE(Any p0, Any p1) { return invoke<BOOL>(0x46102A0989AD80B5, p0, p1); } // 0x46102A0989AD80B5 0xB41064A4 b1207
	NATIVE_DECL BOOL DATAFILE_DELETE_REQUESTED_FILE(Any p0) { return invoke<BOOL>(0x604B8ED1A482F9DF, p0); } // 0x604B8ED1A482F9DF 0x9DB63CFF b1207
	NATIVE_DECL Any UGC2_SET_PLAYER_DATA(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xE79C70E77E0973C7, p0, p1, p2, p3); } // 0xE79C70E77E0973C7 b1207
	// Reloops value returned by UGC_QUERY_GET_CONTENT_NUM
	NATIVE_DECL Any DATAFILE_UGC_SELECT_DATA(Any ugcRequestId, int index, Any p2) { return invoke<Any>(0x790EC421078F5C4E, ugcRequestId, index, p2); } // 0x790EC421078F5C4E b1207
	NATIVE_DECL void DATAFILE_CREATE(int index) { invoke<Void>(0x56B7291FB953DD51, index); } // 0x56B7291FB953DD51 0x95F8A221 b1207
	NATIVE_DECL void DATAFILE_DELETE(int index) { invoke<Void>(0x9FB90EEDEA9F2D5C, index); } // 0x9FB90EEDEA9F2D5C 0xDEF31B0A b1207
	NATIVE_DECL const char* DATAFILE_GET_FILE_DICT(int index) { return invoke<const char*>(0xBBD8CF823CAE557C, index); } // 0xBBD8CF823CAE557C 0x86DDF9C2 b1207
	NATIVE_DECL BOOL DATADICT_IS_DICT_VALID(Any p0) { return invoke<BOOL>(0x4607D57C5F7D332A, p0); } // 0x4607D57C5F7D332A b1207
	NATIVE_DECL BOOL DATADICT_IS_ARRAY_VALID(Any p0) { return invoke<BOOL>(0xB04B69CF277D15C0, p0); } // 0xB04B69CF277D15C0 b1207
	NATIVE_DECL void DATADICT_SET_INT(Any* objectData, const char* key, int value) { invoke<Void>(0x26FDF5E99AA2F3E9, objectData, key, value); } // 0x26FDF5E99AA2F3E9 0xEFCF554A b1207
	NATIVE_DECL BOOL DATADICT_GET_BOOL(Any* objectData, const char* key) { return invoke<BOOL>(0x175E915A486EE548, objectData, key); } // 0x175E915A486EE548 0x8876C872 b1207
	NATIVE_DECL int DATADICT_GET_INT(Any* objectData, const char* key) { return invoke<int>(0x9D896A3B87D96E2B, objectData, key); } // 0x9D896A3B87D96E2B 0xA6C68693 b1207
	NATIVE_DECL float DATADICT_GET_FLOAT(Any* objectData, const char* key) { return invoke<float>(0x814643ECA258ADF5, objectData, key); } // 0x814643ECA258ADF5 0xA92C1AF4 b1207
	NATIVE_DECL const char* DATADICT_GET_STRING(Any* objectData, const char* key) { return invoke<const char*>(0xE37B38C0B4E95DFA, objectData, key); } // 0xE37B38C0B4E95DFA 0x942160EC b1207
	NATIVE_DECL Vector3 DATADICT_GET_VECTOR(Any* objectData, const char* key) { return invoke<Vector3>(0xE459C941431E0FFA, objectData, key); } // 0xE459C941431E0FFA 0xE84A127A b1207
	NATIVE_DECL Any* DATADICT_GET_DICT(Any* objectData, const char* key) { return invoke<Any*>(0x4D7A30130F46AC9C, objectData, key); } // 0x4D7A30130F46AC9C 0xC9C13D8D b1207
	NATIVE_DECL Any* DATADICT_GET_ARRAY(Any* objectData, const char* key) { return invoke<Any*>(0x1B5447CF18544B18, objectData, key); } // 0x1B5447CF18544B18 0x1F2F7D00 b1207
	// Types:
	// 1 = Boolean
	// 2 = Integer
	// 3 = Float
	// 4 = String
	// 5 = Vector3
	// 6 = Object
	// 7 = Array
	NATIVE_DECL int DATADICT_GET_TYPE(Any* objectData, const char* key) { return invoke<int>(0x92E11E3CA4C7CDF0, objectData, key); } // 0x92E11E3CA4C7CDF0 0x2678342A b1207
	NATIVE_DECL void _0xBC0DF006A4952C68(Any p0, Any p1, Any p2) { invoke<Void>(0xBC0DF006A4952C68, p0, p1, p2); } // 0xBC0DF006A4952C68 b1207
	NATIVE_DECL void _0x9F130129EBC31B34(Any p0, Any p1, Any p2) { invoke<Void>(0x9F130129EBC31B34, p0, p1, p2); } // 0x9F130129EBC31B34 b1207
	NATIVE_DECL void _0x277251C161B4C3F4(Any p0, Any p1, Any p2) { invoke<Void>(0x277251C161B4C3F4, p0, p1, p2); } // 0x277251C161B4C3F4 b1207
	NATIVE_DECL void _0x1C65CC931C0F946F(Any p0, Any p1, Any p2) { invoke<Void>(0x1C65CC931C0F946F, p0, p1, p2); } // 0x1C65CC931C0F946F b1207
	NATIVE_DECL void _0x7681B677400C7071(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x7681B677400C7071, p0, p1, p2, p3, p4); } // 0x7681B677400C7071 b1207
	NATIVE_DECL BOOL DATAARRAY_GET_BOOL(Any* arrayData, int arrayIndex) { return invoke<BOOL>(0xAB1231D2DE52F2D3, arrayData, arrayIndex); } // 0xAB1231D2DE52F2D3 0xA2E5F921 b1207
	NATIVE_DECL int DATAARRAY_GET_INT(Any* arrayData, int arrayIndex) { return invoke<int>(0x96DEA500B6EBBE53, arrayData, arrayIndex); } // 0x96DEA500B6EBBE53 0xBB120CFC b1207
	NATIVE_DECL float DATAARRAY_GET_FLOAT(Any* arrayData, int arrayIndex) { return invoke<float>(0xA9D003CF419CB81E, arrayData, arrayIndex); } // 0xA9D003CF419CB81E 0x08AD2CC2 b1207
	NATIVE_DECL const char* DATAARRAY_GET_STRING(Any* arrayData, int arrayIndex) { return invoke<const char*>(0xB6790A8FF80F889F, arrayData, arrayIndex); } // 0xB6790A8FF80F889F 0x93F985A6 b1207
	NATIVE_DECL Vector3 DATAARRAY_GET_VECTOR(Any* arrayData, int arrayIndex) { return invoke<Vector3>(0x850DA2750DA14E9A, arrayData, arrayIndex); } // 0x850DA2750DA14E9A 0x80E3DA55 b1207
	NATIVE_DECL Any* DATAARRAY_GET_DICT(Any* arrayData, int arrayIndex) { return invoke<Any*>(0xA010655985853485, arrayData, arrayIndex); } // 0xA010655985853485 0xECE81278 b1207
	NATIVE_DECL int DATAARRAY_GET_COUNT(Any* arrayData) { return invoke<int>(0x6A885BF69239E539, arrayData); } // 0x6A885BF69239E539 0xA8A21766 b1207
	// Types:
	// 1 = Boolean
	// 2 = Integer
	// 3 = Float
	// 4 = String
	// 5 = Vector3
	// 6 = Object
	// 7 = Array
	NATIVE_DECL int DATAARRAY_GET_TYPE(Any* arrayData, int arrayIndex) { return invoke<int>(0x151DAFE6B3B9888F, arrayData, arrayIndex); } // 0x151DAFE6B3B9888F 0xFA2402C8 b1207
	NATIVE_DECL Any _0x4F9E3ED7617123AC(Any p0) { return invoke<Any>(0x4F9E3ED7617123AC, p0); } // 0x4F9E3ED7617123AC b1207
	NATIVE_DECL Any _0xCA56DD6AB7A39F64(Any p0) { return invoke<Any>(0xCA56DD6AB7A39F64, p0); } // 0xCA56DD6AB7A39F64 b1207
	NATIVE_DECL Any _0xD97D8D905F1562F2(Any p0) { return invoke<Any>(0xD97D8D905F1562F2, p0); } // 0xD97D8D905F1562F2 b1207
	NATIVE_DECL void _DATAFILE_UNLOAD(Any p0) { invoke<Void>(0x129567F0C05F81B9, p0); } // 0x129567F0C05F81B9 b1207
	NATIVE_DECL BOOL PARSEDDATA_IS_FILE_VALID(Any p0) { return invoke<BOOL>(0x7907969497EA92F5, p0); } // 0x7907969497EA92F5 b1207
	NATIVE_DECL BOOL PARSEDDATA_IS_FILE_LOADED(Any p0) { return invoke<BOOL>(0x603AC35FD4602C76, p0); } // 0x603AC35FD4602C76 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x3168BA5D6DECE323() { invoke<Void>(0x3168BA5D6DECE323); } // 0x3168BA5D6DECE323 b1207
	NATIVE_DECL Any _DATAFILE_REGISTER_QUERY(Any p0, Any p1, Any p2) { return invoke<Any>(0xAE156A747C39A741, p0, p1, p2); } // 0xAE156A747C39A741 b1207
	// Old name: _DATAFILE_GET_DATA_NODE_INDEX
	NATIVE_DECL BOOL PARSEDDATA_RQ_FILLOUT_NODE(int* p0, Any* p1) { return invoke<BOOL>(0x83C3ED532B6E5D07, p0, p1); } // 0x83C3ED532B6E5D07 b1207
	NATIVE_DECL Any _DATAFILE_GET_NUM_NODES(Any p0) { return invoke<Any>(0xDF01B1F7A886B42D, p0); } // 0xDF01B1F7A886B42D b1207
	NATIVE_DECL Any _0xE13634BB6BAF0734(Any p0, Any p1) { return invoke<Any>(0xE13634BB6BAF0734, p0, p1); } // 0xE13634BB6BAF0734 b1207
	NATIVE_DECL Any _DATAFILE_GET_NUM_CHILDREN(Any p0, Any p1) { return invoke<Any>(0x6BEB168D5195E7AB, p0, p1); } // 0x6BEB168D5195E7AB b1207
	// Old name: _DATAFILE_GET_HASH
	NATIVE_DECL BOOL PARSEDDATA_RQ_FILLOUT_HASH(Hash* p0, Any* p1) { return invoke<BOOL>(0xFBFF3FF2F5E80C0B, p0, p1); } // 0xFBFF3FF2F5E80C0B b1207
	// Old name: _DATAFILE_GET_STRING
	NATIVE_DECL BOOL _PARSEDDATA_RQ_FILLOUT_STRING_63(char* p0, Any* p1) { return invoke<BOOL>(0x08EAF8E9F2EB7B2E, p0, p1); } // 0x08EAF8E9F2EB7B2E b1207
	NATIVE_DECL BOOL PARSEDDATA_RQ_FILLOUT_STRING_127(char* p0, Any* p1) { return invoke<BOOL>(0x951327435DC5164B, p0, p1); } // 0x951327435DC5164B b1232
	// Old name: _DATAFILE_GET_VECTOR
	NATIVE_DECL BOOL _PARSEDDATA_RQ_FILLOUT_VECTOR(Vector3* p0, Any* p1) { return invoke<BOOL>(0x06FBF89B12DA279C, p0, p1); } // 0x06FBF89B12DA279C b1207
	// Old name: _DATAFILE_GET_FLOAT
	NATIVE_DECL BOOL _PARSEDDATA_RQ_FILLOUT_FLOAT(float* p0, Any* p1) { return invoke<BOOL>(0x7F034FC3E891B57A, p0, p1); } // 0x7F034FC3E891B57A b1207
	// Old name: _DATAFILE_GET_INT
	NATIVE_DECL BOOL _PARSEDDATA_RQ_FILLOUT_INT(int* p0, Any* p1) { return invoke<BOOL>(0xEF44ACC657352A35, p0, p1); } // 0xEF44ACC657352A35 b1207
	// Old name: _DATAFILE_GET_BOOL
	NATIVE_DECL BOOL _PARSEDDATA_RQ_FILLOUT_BOOL(BOOL* p0, Any* p1) { return invoke<BOOL>(0x0D9138F3F8261DF7, p0, p1); } // 0x0D9138F3F8261DF7 b1207
	// Opens file.
	NATIVE_DECL void _PARSEDDATA_GET_FILE(Any* p0) { invoke<Void>(0x91DED5DD64BB2691, p0); } // 0x91DED5DD64BB2691 b1207
	// Returns false when there are no entries.
	NATIVE_DECL BOOL _PARSEDDATA_GET_ENTRIES(Any* p0) { return invoke<BOOL>(0xED4413CEE1BF142C, p0); } // 0xED4413CEE1BF142C b1207
	NATIVE_DECL BOOL _0xB2B42607F7867576(Any* p0, Any* p1, Hash p2) { return invoke<BOOL>(0xB2B42607F7867576, p0, p1, p2); } // 0xB2B42607F7867576 b1207
	NATIVE_DECL BOOL _0x52FC26D2D2FC2987(Any* p0, Any* p1, Hash p2) { return invoke<BOOL>(0x52FC26D2D2FC2987, p0, p1, p2); } // 0x52FC26D2D2FC2987 b1207
	NATIVE_DECL BOOL _PARSEDDATA_GET_SECTION(Any* p0, Any* p1, Hash section) { return invoke<BOOL>(0x44B3A36933AC009C, p0, p1, section); } // 0x44B3A36933AC009C b1207
	NATIVE_DECL BOOL _0xA63CD20F19B961AB(Any* p0, Any* p1, Hash p2) { return invoke<BOOL>(0xA63CD20F19B961AB, p0, p1, p2); } // 0xA63CD20F19B961AB b1207
}

namespace DEBUG
{
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0xACF9CB705BEFA8CB() { return invoke<Any>(0xACF9CB705BEFA8CB); } // 0xACF9CB705BEFA8CB b1207
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0xA8D970D8A72640A6() { return invoke<Any>(0xA8D970D8A72640A6); } // 0xA8D970D8A72640A6 b1207
	// Return example: 1207.69_dev_pc, 1436.28_dev_live_tu
	NATIVE_DECL const char* _GET_GAME_BUILD_STRING() { return invoke<const char*>(0x05A5F662AD35C573); } // 0x05A5F662AD35C573 b1207
}

namespace DECORATOR
{
	// This function sets metadata of type bool to specified entity.
	// 
	NATIVE_DECL BOOL DECOR_SET_BOOL(Entity entity, const char* propertyName, BOOL value) { return invoke<BOOL>(0xFE26E4609B1C3772, entity, propertyName, value); } // 0xFE26E4609B1C3772 0x8E101F5C b1207
	NATIVE_DECL BOOL DECOR_SET_FLOAT(Entity entity, const char* propertyName, float value) { return invoke<BOOL>(0x238F8B0C1C7FE834, entity, propertyName, value); } // 0x238F8B0C1C7FE834 0xBC7BD5CB b1207
	// Sets property to int.
	NATIVE_DECL BOOL DECOR_SET_INT(Entity entity, const char* propertyName, int value) { return invoke<BOOL>(0xE88F4D7F52A6090F, entity, propertyName, value); } // 0xE88F4D7F52A6090F 0xDB718B21 b1207
	NATIVE_DECL BOOL _DECOR_SET_UINT8(Entity entity, const char* propertyName, int value) { return invoke<BOOL>(0x4BDC83150D43772D, entity, propertyName, value); } // 0x4BDC83150D43772D b1207
	NATIVE_DECL BOOL _DECOR_SET_STRING(Entity entity, const char* propertyName, const char* value) { return invoke<BOOL>(0x0671C1A3FF7AFDFC, entity, propertyName, value); } // 0x0671C1A3FF7AFDFC b1207
	NATIVE_DECL BOOL DECOR_GET_BOOL(Entity entity, const char* propertyName) { return invoke<BOOL>(0xDEF3F1B071ABB197, entity, propertyName); } // 0xDEF3F1B071ABB197 0xDBCE51E0 b1207
	NATIVE_DECL float DECOR_GET_FLOAT(Entity entity, const char* propertyName) { return invoke<float>(0xE5FF70CD842CA9D4, entity, propertyName); } // 0xE5FF70CD842CA9D4 0x8DE5382F b1207
	NATIVE_DECL int DECOR_GET_INT(Entity entity, const char* propertyName) { return invoke<int>(0x44DB62727762FD9B, entity, propertyName); } // 0x44DB62727762FD9B 0xDDDE59B5 b1207
	NATIVE_DECL int _DECOR_GET_UINT8(Entity entity, const char* propertyName) { return invoke<int>(0xB1682B2443F0540B, entity, propertyName); } // 0xB1682B2443F0540B b1207
	// Returns whether or not the specified property is set for the entity.
	NATIVE_DECL BOOL DECOR_EXIST_ON(Entity entity, const char* propertyName) { return invoke<BOOL>(0xD9D1CDBF3464DCDF, entity, propertyName); } // 0xD9D1CDBF3464DCDF 0x74EF9C40 b1207
	NATIVE_DECL BOOL DECOR_REMOVE(Entity entity, const char* propertyName) { return invoke<BOOL>(0x2BA7F5877A088A1D, entity, propertyName); } // 0x2BA7F5877A088A1D 0xE0E2640B b1207
	NATIVE_DECL BOOL _DECOR_REMOVE_ALL(Entity entity) { return invoke<BOOL>(0x88942780E0ADEA42, entity); } // 0x88942780E0ADEA42 b1207
	NATIVE_DECL void DECOR_REGISTER(const char* propertyName, int type) { invoke<Void>(0x0B253D644E3C36B3, propertyName, type); } // 0x0B253D644E3C36B3 0x68BD42A9 b1207
	NATIVE_DECL void _DECOR_REGISTER_2(const char* propertyName, int type, BOOL p2) { invoke<Void>(0x4587374F88B7F6C2, propertyName, type, p2); } // 0x4587374F88B7F6C2 b1207
	// type: see DECOR_REGISTER
	NATIVE_DECL BOOL DECOR_IS_REGISTERED_AS_TYPE(const char* propertyName, int type) { return invoke<BOOL>(0x72355278C069F272, propertyName, type); } // 0x72355278C069F272 0x7CF0971D b1207
}

namespace DLC
{
	NATIVE_DECL BOOL IS_DLC_PRESENT(Hash dlcHash) { return invoke<BOOL>(0x2763DC12BBE2BB6F, dlcHash); } // 0x2763DC12BBE2BB6F 0x1F321943 b1207
	NATIVE_DECL BOOL GET_IS_LOADING_SCREEN_ACTIVE() { return invoke<BOOL>(0x71D4BF5890659B0C); } // 0x71D4BF5890659B0C 0x517B601B b1207
	NATIVE_DECL BOOL _GET_SPECIAL_EDITION_CORE_STATS_BONUS_ENABLED() { return invoke<BOOL>(0xA16B4FBA7887D7BA); } // 0xA16B4FBA7887D7BA b1207
	NATIVE_DECL BOOL _GET_SPECIAL_EDITION_CASH_CAMP_BONUS_ENABLED() { return invoke<BOOL>(0x1DB9D61E505AE3FC); } // 0x1DB9D61E505AE3FC b1207
}

namespace ENTITY
{
	// Checks if the Entity exists
	NATIVE_DECL BOOL DOES_ENTITY_EXIST(Entity entity) { return invoke<BOOL>(0xD42BD6EB2E0F1677, entity); } // 0xD42BD6EB2E0F1677 0x3AC90869 b1207
	NATIVE_DECL BOOL DOES_ENTITY_BELONG_TO_THIS_SCRIPT(Entity entity, BOOL p1) { return invoke<BOOL>(0x622B1980CBE13332, entity, p1); } // 0x622B1980CBE13332 0xACFEB3F9 b1207
	NATIVE_DECL BOOL DOES_ENTITY_HAVE_DRAWABLE(Entity entity) { return invoke<BOOL>(0x20487F0DA9AF164A, entity); } // 0x20487F0DA9AF164A 0xA5B33300 b1207
	NATIVE_DECL BOOL DOES_ENTITY_HAVE_PHYSICS(Entity entity) { return invoke<BOOL>(0xA512B3F1B2A0B51C, entity); } // 0xA512B3F1B2A0B51C 0x9BCD2979 b1207
	NATIVE_DECL BOOL HAS_ENTITY_BEEN_DAMAGED_BY_ANY_OBJECT(Entity entity) { return invoke<BOOL>(0x73BB763880CD23A6, entity); } // 0x73BB763880CD23A6 0x6B74582E b1207
	NATIVE_DECL BOOL HAS_ENTITY_BEEN_DAMAGED_BY_ANY_PED(Entity entity) { return invoke<BOOL>(0x9934E9C42D52D87E, entity); } // 0x9934E9C42D52D87E 0x53FD4A25 b1207
	NATIVE_DECL BOOL HAS_ENTITY_BEEN_DAMAGED_BY_ANY_VEHICLE(Entity entity) { return invoke<BOOL>(0x695D7C26DE65C423, entity); } // 0x695D7C26DE65C423 0x878C2CE0 b1207
	NATIVE_DECL BOOL HAS_ENTITY_BEEN_DAMAGED_BY_ENTITY(Entity entity1, Entity entity2, BOOL p2, BOOL p3) { return invoke<BOOL>(0x7B6E7BEC1143AC86, entity1, entity2, p2, p3); } // 0x7B6E7BEC1143AC86 0x07FC77E0 b1207
	// Used in Script Function DUELING_DID_PLAYER_DISARM_OPPONENT
	NATIVE_DECL BOOL _0x3EC28DA1FFAC9DDD(Entity entity1, Entity entity2, Any p2, Any p3) { return invoke<BOOL>(0x3EC28DA1FFAC9DDD, entity1, entity2, p2, p3); } // 0x3EC28DA1FFAC9DDD b1207
	NATIVE_DECL Entity _0xAF72EC7E1B54539B(Entity entity) { return invoke<Entity>(0xAF72EC7E1B54539B, entity); } // 0xAF72EC7E1B54539B b1311
	NATIVE_DECL BOOL HAS_ENTITY_CLEAR_LOS_TO_ENTITY(Entity entity1, Entity entity2, int traceType) { return invoke<BOOL>(0xFCDFF7B72D23A1AC, entity1, entity2, traceType); } // 0xFCDFF7B72D23A1AC 0x53576FA7 b1207
	NATIVE_DECL BOOL HAS_ENTITY_CLEAR_LOS_TO_COORD(Entity entity, float x, float y, float z, int flags) { return invoke<BOOL>(0x0C9DBF48C6BA6E4C, entity, x, y, z, flags); } // 0x0C9DBF48C6BA6E4C b1207
	NATIVE_DECL BOOL HAS_ENTITY_CLEAR_LOS_TO_COORD(Entity entity, Vector3 vec, int flags) { return invoke<BOOL>(0x0C9DBF48C6BA6E4C, entity, vec.x, vec.y, vec.z, flags); } // 0x0C9DBF48C6BA6E4C b1207
	// Has the entity1 got a clear line of sight to the other entity2 from the direction entity1 is facing.
	NATIVE_DECL BOOL HAS_ENTITY_CLEAR_LOS_TO_ENTITY_IN_FRONT(Entity entity1, Entity entity2, int traceType) { return invoke<BOOL>(0xE88F19660651D566, entity1, entity2, traceType); } // 0xE88F19660651D566 0x210D87C8 b1207
	NATIVE_DECL BOOL HAS_ENTITY_COLLIDED_WITH_ANYTHING(Entity entity) { return invoke<BOOL>(0xDF18751EC74F90FF, entity); } // 0xDF18751EC74F90FF 0x662A2F41 b1207
	NATIVE_DECL float _0x6D58167F62238284(Vehicle vehicle) { return invoke<float>(0x6D58167F62238284, vehicle); } // 0x6D58167F62238284 b1207
	NATIVE_DECL float _0xDFC2B226D56D85F6(Any p0, Any p1) { return invoke<float>(0xDFC2B226D56D85F6, p0, p1); } // 0xDFC2B226D56D85F6 b1207
	NATIVE_DECL float GET_ANIM_DURATION(const char* animDict, const char* animName) { return invoke<float>(0x9FFAF4940A54CC09, animDict, animName); } // 0x9FFAF4940A54CC09 0x8B5E3E3D b1207
	NATIVE_DECL Entity GET_ENTITY_ATTACHED_TO(Entity entity) { return invoke<Entity>(0x56D713888A566481, entity); } // 0x56D713888A566481 0xFE1589F9 b1207
	// Gets the current coordinates for a specified entity.
	// `entity` = The entity to get the coordinates from.
	// `alive` = Unused by the game, potentially used by debug builds in order to assert whether or not an entity was alive.
	// 
	// If entity is a ped and it's in a vehicle or on a mount the coords of that entity are returned. Set 'realCoords' to true when you need the true ped coords.
	NATIVE_DECL Vector3 GET_ENTITY_COORDS(Entity entity, BOOL alive, BOOL realCoords) { return invoke<Vector3>(0xA86D5F069399F44D, entity, alive, realCoords); } // 0xA86D5F069399F44D 0x1647F1CB b1207
	// Gets the entity's forward vector.
	NATIVE_DECL Vector3 GET_ENTITY_FORWARD_VECTOR(Hash entity) { return invoke<Vector3>(0x2412D9C05BB09B97, entity); } // 0x2412D9C05BB09B97 0x84DCECBF b1207
	// Gets the X-component of the entity's forward vector.
	NATIVE_DECL float GET_ENTITY_FORWARD_X(Entity entity) { return invoke<float>(0xDB0954E9960F6457, entity); } // 0xDB0954E9960F6457 0x49FAE914 b1207
	// Gets the Y-component of the entity's forward vector.
	NATIVE_DECL float GET_ENTITY_FORWARD_Y(Entity entity) { return invoke<float>(0x9A5C073ECBDA7EE7, entity); } // 0x9A5C073ECBDA7EE7 0x9E2F917C b1207
	NATIVE_DECL Vector3 _0x935A30AA88FB1014(Any p0) { return invoke<Vector3>(0x935A30AA88FB1014, p0); } // 0x935A30AA88FB1014 b1207
	// Returns the heading of the entity in degrees. Also know as the "Yaw" of an entity.
	NATIVE_DECL float GET_ENTITY_HEADING(Entity entity) { return invoke<float>(0xC230DD956E2F5507, entity); } // 0xC230DD956E2F5507 0x972CC383 b1207
	NATIVE_DECL int GET_ENTITY_HEALTH(Entity entity) { return invoke<int>(0x82368787EA73C0F7, entity); } // 0x82368787EA73C0F7 0x8E3222B7 b1207
	// Returns (CUR_HEALTH / MAX_HEALTH)
	NATIVE_DECL float _GET_ENTITY_HEALTH_FLOAT(Entity entity) { return invoke<float>(0x96C638784DB4C815, entity); } // 0x96C638784DB4C815 b1207
	// Alters entity's health by 'amount'. Can be negative (to drain health).
	// In the scripts entity2 and weaponHash are unused (zero).
	NATIVE_DECL BOOL _CHANGE_ENTITY_HEALTH(Entity entity, float amount, Entity entity2, Hash weaponHash) { return invoke<BOOL>(0x835F131E7DC8F97A, entity, amount, entity2, weaponHash); } // 0x835F131E7DC8F97A b1207
	NATIVE_DECL int GET_ENTITY_MAX_HEALTH(Entity entity, BOOL p1) { return invoke<int>(0x15D757606D170C3C, entity, p1); } // 0x15D757606D170C3C 0xC7AE6AA1 b1207
	NATIVE_DECL void SET_ENTITY_MAX_HEALTH(Entity entity, int value) { invoke<Void>(0x166E7CF68597D8B5, entity, value); } // 0x166E7CF68597D8B5 0x96F84DF8 b1207
	NATIVE_DECL float GET_ENTITY_HEIGHT(Entity entity, float X, float Y, float Z, BOOL atTop, BOOL inWorldCoords) { return invoke<float>(0x296DEBC84474B375, entity, X, Y, Z, atTop, inWorldCoords); } // 0x296DEBC84474B375 0xEE443481 b1207
	NATIVE_DECL float GET_ENTITY_HEIGHT(Entity entity, Vector3 vec, BOOL atTop, BOOL inWorldCoords) { return invoke<float>(0x296DEBC84474B375, entity, vec.x, vec.y, vec.z, atTop, inWorldCoords); } // 0x296DEBC84474B375 0xEE443481 b1207
	NATIVE_DECL float GET_ENTITY_HEIGHT_ABOVE_GROUND(Entity entity) { return invoke<float>(0x0D3B5BAEA08F63E9, entity); } // 0x0D3B5BAEA08F63E9 0x57F56A4D b1207
	NATIVE_DECL void _GET_ENTITY_WORLD_POSITION_OF_DIMENSIONS(Entity entity, Vector3* minimum, Vector3* maximum) { invoke<Void>(0xF3FDA9A617A15145, entity, minimum, maximum); } // 0xF3FDA9A617A15145 b1207
	NATIVE_DECL void GET_ENTITY_MATRIX(Entity entity, Vector3* rightVector, Vector3* forwardVector, Vector3* upVector, Vector3* position) { invoke<Void>(0x3A9B1120AF13FBF2, entity, rightVector, forwardVector, upVector, position); } // 0x3A9B1120AF13FBF2 0xEB9EB001 b1207
	// Returns the model hash from the entity
	NATIVE_DECL Hash GET_ENTITY_MODEL(Entity entity) { return invoke<Hash>(0xDA76A9F39210D365, entity); } // 0xDA76A9F39210D365 0xDAFCB3EC b1207
	// Returns the ped's animal type hash: https://alloc8or.re/rdr3/doc/enums/eAnimalType.txt
	// Combine this with GET_STRING_FROM_HASH_KEY to display localized entity names
	NATIVE_DECL Hash _GET_PED_ANIMAL_TYPE(Ped ped) { return invoke<Hash>(0x964000D355219FC0, ped); } // 0x964000D355219FC0 b1207
	NATIVE_DECL BOOL GET_IS_ANIMAL(Entity entity) { return invoke<BOOL>(0x9A100F1CF4546629, entity); } // 0x9A100F1CF4546629 b1207
	NATIVE_DECL BOOL _GET_IS_BIRD(Entity entity) { return invoke<BOOL>(0xC346A546612C49A9, entity); } // 0xC346A546612C49A9 b1207
	NATIVE_DECL BOOL _GET_IS_PREDATOR(Entity entity) { return invoke<BOOL>(0x5594AFE9DE0C01B7, entity); } // 0x5594AFE9DE0C01B7 b1207
	NATIVE_DECL Vector3 GET_OFFSET_FROM_ENTITY_GIVEN_WORLD_COORDS(Entity entity, float posX, float posY, float posZ) { return invoke<Vector3>(0x497C6B1A2C9AE69C, entity, posX, posY, posZ); } // 0x497C6B1A2C9AE69C 0x6477EC9E b1207
	NATIVE_DECL Vector3 GET_OFFSET_FROM_ENTITY_GIVEN_WORLD_COORDS(Entity entity, Vector3 pos) { return invoke<Vector3>(0x497C6B1A2C9AE69C, entity, pos.x, pos.y, pos.z); } // 0x497C6B1A2C9AE69C 0x6477EC9E b1207
	// Offset values are relative to the entity.
	// 
	// x = left/right
	// y = forward/backward
	// z = up/down
	NATIVE_DECL Vector3 GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(Entity entity, float offsetX, float offsetY, float offsetZ) { return invoke<Vector3>(0x1899F328B0E12848, entity, offsetX, offsetY, offsetZ); } // 0x1899F328B0E12848 0xABCF043A b1207
	NATIVE_DECL Vector3 GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(Entity entity, Vector3 offset) { return invoke<Vector3>(0x1899F328B0E12848, entity, offset.x, offset.y, offset.z); } // 0x1899F328B0E12848 0xABCF043A b1207
	NATIVE_DECL float GET_ENTITY_PITCH(Entity entity) { return invoke<float>(0xEF355ABEFF7F5005, entity); } // 0xEF355ABEFF7F5005 0xFCE6ECE5 b1207
	// Displays the current ROLL axis of the entity [-180.0000/180.0000+]
	// (Sideways Roll) such as a vehicle tipped on its side
	NATIVE_DECL float GET_ENTITY_ROLL(Entity entity) { return invoke<float>(0xBF966536FA8B6879, entity); } // 0xBF966536FA8B6879 0x36610842 b1207
	NATIVE_DECL Vector3 GET_ENTITY_ROTATION(Entity entity, int rotationOrder) { return invoke<Vector3>(0xE09CAF86C32CB48F, entity, rotationOrder); } // 0xE09CAF86C32CB48F 0x8FF45B04 b1207
	NATIVE_DECL Hash _GET_ENTITY_SCRIPT(Entity entity, Any* argStruct) { return invoke<Hash>(0x2A08A32B6D49906F, entity, argStruct); } // 0x2A08A32B6D49906F b1207
	// Result is in meters per second (m/s)
	NATIVE_DECL float GET_ENTITY_SPEED(Entity entity) { return invoke<float>(0xFB6BA510A533DF81, entity); } // 0xFB6BA510A533DF81 0x9E1E4798 b1207
	NATIVE_DECL Vector3 GET_ENTITY_SPEED_VECTOR(Entity entity, BOOL relative) { return invoke<Vector3>(0xF2DB09816A419DC5, entity, relative); } // 0xF2DB09816A419DC5 0x3ED2B997 b1207
	NATIVE_DECL float GET_ENTITY_UPRIGHT_VALUE(Entity entity) { return invoke<float>(0x56398BE65160C3BE, entity); } // 0x56398BE65160C3BE 0xF4268190 b1207
	NATIVE_DECL Vector3 GET_ENTITY_VELOCITY(Entity entity, int p1) { return invoke<Vector3>(0x4805D2B1D8CF94A9, entity, p1); } // 0x4805D2B1D8CF94A9 0xC14C9B6B b1207
	// Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
	NATIVE_DECL Object GET_OBJECT_INDEX_FROM_ENTITY_INDEX(Entity entity) { return invoke<Object>(0x280BBE5601EAA983, entity); } // 0x280BBE5601EAA983 0xBC5A9C58 b1207
	// Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
	NATIVE_DECL Ped GET_PED_INDEX_FROM_ENTITY_INDEX(Entity entity) { return invoke<Ped>(0x0F16D042BD640EA3, entity); } // 0x0F16D042BD640EA3 0xC46F74AC b1207
	// Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
	NATIVE_DECL Vehicle GET_VEHICLE_INDEX_FROM_ENTITY_INDEX(Entity entity) { return invoke<Vehicle>(0xDF1E5AAC561AFC59, entity); } // 0xDF1E5AAC561AFC59 0xC69CF43D b1207
	// Returns the coordinates of an entity-bone.
	// https://github.com/femga/rdr3_discoveries/tree/master/boneNames
	NATIVE_DECL Vector3 GET_WORLD_POSITION_OF_ENTITY_BONE(Entity entity, int boneIndex) { return invoke<Vector3>(0x82CFA50E34681CA5, entity, boneIndex); } // 0x82CFA50E34681CA5 0x7C6339DF b1207
	// Attaches scenario to bone with an offset
	// _GET_I* - _GET_M*
	NATIVE_DECL Vector3 _0x5E214112806591EA(Entity entity, int boneIndex) { return invoke<Vector3>(0x5E214112806591EA, entity, boneIndex); } // 0x5E214112806591EA b1207
	NATIVE_DECL Vector3 _0x3AB3A77672F6473F(Any p0, Any p1, Any p2, Any p3) { return invoke<Vector3>(0x3AB3A77672F6473F, p0, p1, p2, p3); } // 0x3AB3A77672F6473F b1207
	NATIVE_DECL Player GET_NEAREST_PLAYER_TO_ENTITY(Entity entity, Ped playerPedToIgnore, int flags) { return invoke<Player>(0x990E294FC387FB88, entity, playerPedToIgnore, flags); } // 0x990E294FC387FB88 0xCE17FDEC b1207
	NATIVE_DECL Player GET_NEAREST_PLAYER_TO_ENTITY_ON_TEAM(Entity entity, int team, Ped playerPedToIgnore, int flags) { return invoke<Player>(0xB2C30C3B4AFF718C, entity, team, playerPedToIgnore, flags); } // 0xB2C30C3B4AFF718C 0xB1808F56 b1207
	NATIVE_DECL Player _GET_NEAREST_PARTICIPANT_TO_ENTITY(Entity entity) { return invoke<Player>(0x6888A43C35A5F630, entity); } // 0x6888A43C35A5F630 b1207
	NATIVE_DECL BOOL PLACE_ENTITY_ON_GROUND_PROPERLY(Entity entity, BOOL p1) { return invoke<BOOL>(0x9587913B9E772D29, entity, p1); } // 0x9587913B9E772D29 b1207
	// Returns:
	// 0 = no entity
	// 1 = ped
	// 2 = vehicle
	// 3 = object
	NATIVE_DECL int GET_ENTITY_TYPE(Entity entity) { return invoke<int>(0x97F696ACA466B4E0, entity); } // 0x97F696ACA466B4E0 0x0B1BD08D b1207
	NATIVE_DECL int GET_ENTITY_POPULATION_TYPE(Entity entity) { return invoke<int>(0xADE28862B6D7B85B, entity); } // 0xADE28862B6D7B85B 0xFC30DDFF b1207
	NATIVE_DECL BOOL IS_AN_ENTITY(ScrHandle handle) { return invoke<BOOL>(0x27CFF3E5A286D3DF, handle); } // 0x27CFF3E5A286D3DF 0xD4B9715A b1207
	NATIVE_DECL BOOL IS_ENTITY_A_PED(Entity entity) { return invoke<BOOL>(0xCF8176912DDA4EA5, entity); } // 0xCF8176912DDA4EA5 0x55D33EAB b1207
	NATIVE_DECL BOOL IS_ENTITY_A_MISSION_ENTITY(Entity entity) { return invoke<BOOL>(0x138190F64DB4BBD1, entity); } // 0x138190F64DB4BBD1 0x2632E124 b1207
	NATIVE_DECL BOOL IS_ENTITY_A_VEHICLE(Entity entity) { return invoke<BOOL>(0xC3D96AF45FCCEC4C, entity); } // 0xC3D96AF45FCCEC4C 0xBE800B01 b1207
	NATIVE_DECL BOOL IS_ENTITY_AN_OBJECT(Entity entity) { return invoke<BOOL>(0x0A27A546A375FDEF, entity); } // 0x0A27A546A375FDEF 0x3F52E561 b1207
	// Checks if entity is within x/y/zSize distance of x/y/z. 
	// 
	// Last three are unknown ints, almost always p7 = 0, p8 = 1, p9 = 0
	NATIVE_DECL BOOL IS_ENTITY_AT_COORD(Entity entity, float xPos, float yPos, float zPos, float xSize, float ySize, float zSize, BOOL p7, BOOL p8, int p9) { return invoke<BOOL>(0x5E58342602E94718, entity, xPos, yPos, zPos, xSize, ySize, zSize, p7, p8, p9); } // 0x5E58342602E94718 0xD749B606 b1207
	NATIVE_DECL BOOL IS_ENTITY_AT_COORD(Entity entity, Vector3 pos, Vector3 size, BOOL p7, BOOL p8, int p9) { return invoke<BOOL>(0x5E58342602E94718, entity, pos.x, pos.y, pos.z, size.x, size.y, size.z, p7, p8, p9); } // 0x5E58342602E94718 0xD749B606 b1207
	// Checks if entity1 is within the box defined by x/y/zSize of entity2.
	// 
	// Last three parameters are almost always p5 = 0, p6 = 1, p7 = 0
	NATIVE_DECL BOOL IS_ENTITY_AT_ENTITY(Entity entity1, Entity entity2, float xSize, float ySize, float zSize, BOOL p5, BOOL p6, int p7) { return invoke<BOOL>(0xC057F02B837A27F6, entity1, entity2, xSize, ySize, zSize, p5, p6, p7); } // 0xC057F02B837A27F6 0xDABDCB52 b1207
	NATIVE_DECL BOOL IS_ENTITY_AT_ENTITY(Entity entity1, Entity entity2, Vector3 size, BOOL p5, BOOL p6, int p7) { return invoke<BOOL>(0xC057F02B837A27F6, entity1, entity2, size.x, size.y, size.z, p5, p6, p7); } // 0xC057F02B837A27F6 0xDABDCB52 b1207
	NATIVE_DECL BOOL IS_ENTITY_ATTACHED(Entity entity) { return invoke<BOOL>(0xEE6AD63ABF59C0B7, entity); } // 0xEE6AD63ABF59C0B7 0xEC1479D5 b1207
	NATIVE_DECL BOOL IS_ENTITY_ATTACHED_TO_ANY_OBJECT(Entity entity) { return invoke<BOOL>(0x306C1F6178F01AB3, entity); } // 0x306C1F6178F01AB3 0x0B5DE340 b1207
	NATIVE_DECL BOOL IS_ENTITY_ATTACHED_TO_ANY_PED(Entity entity) { return invoke<BOOL>(0xC841153DED2CA89A, entity); } // 0xC841153DED2CA89A 0x9D7A609C b1207
	NATIVE_DECL BOOL IS_ENTITY_ATTACHED_TO_ANY_VEHICLE(Entity entity) { return invoke<BOOL>(0x12DF6E0D2E736749, entity); } // 0x12DF6E0D2E736749 0xDE5C995E b1207
	NATIVE_DECL BOOL IS_ENTITY_ATTACHED_TO_ENTITY(Entity from, Entity to) { return invoke<BOOL>(0x154A3C529497053E, from, to); } // 0x154A3C529497053E 0xB0ABFEA8 b1207
	NATIVE_DECL BOOL _IS_ENTITY_OWNED_BY_PERSISTENCE_SYSTEM(Entity entity) { return invoke<BOOL>(0xA7E51B53309EAC97, entity); } // 0xA7E51B53309EAC97 b1207
	NATIVE_DECL BOOL IS_ENTITY_DEAD(Entity entity) { return invoke<BOOL>(0x7D5B1F88E7504BBA, entity); } // 0x7D5B1F88E7504BBA 0xB6F7CBAC b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_AIR(Entity entity, Any p1) { return invoke<BOOL>(0x886E37EC497200B6, entity, p1); } // 0x886E37EC497200B6 0xA4157987 b1207
	// Creates a spherical cone at origin that extends to surface with the angle specified. Then returns true if the entity is inside the spherical cone
	// 
	// Angle is measured in degrees.
	NATIVE_DECL BOOL IS_ENTITY_IN_ANGLED_AREA(Entity entity, float originX, float originY, float originZ, float edgeX, float edgeY, float edgeZ, float angle, BOOL p8, BOOL p9, Any p10) { return invoke<BOOL>(0xD3151E53134595E5, entity, originX, originY, originZ, edgeX, edgeY, edgeZ, angle, p8, p9, p10); } // 0xD3151E53134595E5 0x883622FA b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_ANGLED_AREA(Entity entity, Vector3 origin, Vector3 edge, float angle, BOOL p8, BOOL p9, Any p10) { return invoke<BOOL>(0xD3151E53134595E5, entity, origin.x, origin.y, origin.z, edge.x, edge.y, edge.z, angle, p8, p9, p10); } // 0xD3151E53134595E5 0x883622FA b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_AREA(Entity entity, float x1, float y1, float z1, float x2, float y2, float z2, BOOL p7, BOOL p8, Any p9) { return invoke<BOOL>(0x0C2634C40A16193E, entity, x1, y1, z1, x2, y2, z2, p7, p8, p9); } // 0x0C2634C40A16193E 0x8C2DFA9D b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_AREA(Entity entity, Vector3 vec1, Vector3 vec2, BOOL p7, BOOL p8, Any p9) { return invoke<BOOL>(0x0C2634C40A16193E, entity, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, p7, p8, p9); } // 0x0C2634C40A16193E 0x8C2DFA9D b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_VOLUME(Entity entity, ScrHandle volume, BOOL p2, int p3) { return invoke<BOOL>(0x5A5526BC09C06623, entity, volume, p2, p3); } // 0x5A5526BC09C06623 b1207
	NATIVE_DECL BOOL IS_ENTITY_IN_WATER(Entity entity) { return invoke<BOOL>(0xDDE5C125AC446723, entity); } // 0xDDE5C125AC446723 0x4C3C2508 b1207
	NATIVE_DECL BOOL _IS_ENTITY_UNDERWATER(Entity entity, BOOL p1) { return invoke<BOOL>(0xD4E5C1E93C466127, entity, p1); } // 0xD4E5C1E93C466127 b1207
	// Get how much of the entity is submerged.  1.0f is whole entity.
	NATIVE_DECL float GET_ENTITY_SUBMERGED_LEVEL(Entity entity) { return invoke<float>(0x4A77C3F73FD9E831, entity); } // 0x4A77C3F73FD9E831 0x0170F68C b1207
	// SET_ENTITY_R*
	NATIVE_DECL void _0x850C940EE3E7B8B5(Entity entity, BOOL toggle) { invoke<Void>(0x850C940EE3E7B8B5, entity, toggle); } // 0x850C940EE3E7B8B5 0x40C84A74 b1207
	NATIVE_DECL void _0x7A49D40DE437BC8D(Any p0, Any p1) { invoke<Void>(0x7A49D40DE437BC8D, p0, p1); } // 0x7A49D40DE437BC8D b1207
	NATIVE_DECL void _0x978AA2323ED32209(Any p0, Any p1) { invoke<Void>(0x978AA2323ED32209, p0, p1); } // 0x978AA2323ED32209 b1207
	NATIVE_DECL void _0x002AAC783ED323ED(Any p0, Any p1) { invoke<Void>(0x002AAC783ED323ED, p0, p1); } // 0x002AAC783ED323ED b1207
	NATIVE_DECL void _0x007AAC783ED323ED(Any p0, Any p1, Any p2) { invoke<Void>(0x007AAC783ED323ED, p0, p1, p2); } // 0x007AAC783ED323ED b1207
	NATIVE_DECL BOOL IS_ENTITY_ON_SCREEN(Entity entity) { return invoke<BOOL>(0x613C15D5D8DB781F, entity); } // 0x613C15D5D8DB781F 0xC1FEC5ED b1207
	NATIVE_DECL BOOL IS_ENTITY_PLAYING_ANIM(Entity entity, const char* animDict, const char* animName, int taskFlag) { return invoke<BOOL>(0xDEE49D5CA6C49148, entity, animDict, animName, taskFlag); } // 0xDEE49D5CA6C49148 0x0D130D34 b1207
	NATIVE_DECL Any _0x0B7CB1300CBFE19C(Any p0, Any p1) { return invoke<Any>(0x0B7CB1300CBFE19C, p0, p1); } // 0x0B7CB1300CBFE19C b1207
	NATIVE_DECL BOOL IS_ENTITY_STATIC(Entity entity) { return invoke<BOOL>(0x86468ADFA0F6B861, entity); } // 0x86468ADFA0F6B861 0x928E12E9 b1207
	NATIVE_DECL BOOL IS_ENTITY_TOUCHING_ENTITY(Entity entity, Entity targetEntity) { return invoke<BOOL>(0x9A2304A64C3C8423, entity, targetEntity); } // 0x9A2304A64C3C8423 0x6B931477 b1207
	NATIVE_DECL BOOL IS_ENTITY_TOUCHING_MODEL(Entity entity, Hash modelHash) { return invoke<BOOL>(0x2AE3EBC8DEB9768B, entity, modelHash); } // 0x2AE3EBC8DEB9768B 0x307E7611 b1207
	NATIVE_DECL BOOL IS_ENTITY_UPRIGHT(Entity entity, float angle) { return invoke<BOOL>(0xF6F6AFD8D4FB2658, entity, angle); } // 0xF6F6AFD8D4FB2658 0x3BCDF4E1 b1207
	NATIVE_DECL BOOL IS_ENTITY_UPSIDEDOWN(Entity entity) { return invoke<BOOL>(0x109DE3DA41AAD94A, entity); } // 0x109DE3DA41AAD94A 0x5ACAA48F b1207
	NATIVE_DECL BOOL IS_ENTITY_VISIBLE(Entity entity) { return invoke<BOOL>(0xFFC96ECB7FA404CA, entity); } // 0xFFC96ECB7FA404CA 0x120B4ED5 b1207
	// SET_ENTITY_LO*
	NATIVE_DECL void _0xFF9965C47FA404DA(Entity entity, BOOL toggle) { invoke<Void>(0xFF9965C47FA404DA, entity, toggle); } // 0xFF9965C47FA404DA b1207
	NATIVE_DECL BOOL IS_ENTITY_VISIBLE_TO_SCRIPT(Entity entity) { return invoke<BOOL>(0xF213C724E77F321A, entity); } // 0xF213C724E77F321A 0x5D240E9D b1207
	NATIVE_DECL void _0x3F08C6163A4AB1D6(Any p0) { invoke<Void>(0x3F08C6163A4AB1D6, p0); } // 0x3F08C6163A4AB1D6 b1207
	NATIVE_DECL void _0x0DB41D59E0F1502B(Any p0) { invoke<Void>(0x0DB41D59E0F1502B, p0); } // 0x0DB41D59E0F1502B b1207
	NATIVE_DECL BOOL _IS_TRACKED_ENTITY_VISIBLE(Entity entity) { return invoke<BOOL>(0xC8CCDB712FBCBA92, entity); } // 0xC8CCDB712FBCBA92 b1207
	NATIVE_DECL BOOL IS_ENTITY_OCCLUDED(Entity entity) { return invoke<BOOL>(0x140188E884645624, entity); } // 0x140188E884645624 0x46BC5B40 b1207
	NATIVE_DECL BOOL WOULD_ENTITY_BE_OCCLUDED(Hash entityModelHash, float x, float y, float z, BOOL p4) { return invoke<BOOL>(0x3546FAB293FF2981, entityModelHash, x, y, z, p4); } // 0x3546FAB293FF2981 0xEA127CBC b1207
	NATIVE_DECL BOOL WOULD_ENTITY_BE_OCCLUDED(Hash entityModelHash, Vector3 vec, BOOL p4) { return invoke<BOOL>(0x3546FAB293FF2981, entityModelHash, vec.x, vec.y, vec.z, p4); } // 0x3546FAB293FF2981 0xEA127CBC b1207
	NATIVE_DECL BOOL IS_ENTITY_WAITING_FOR_WORLD_COLLISION(Entity entity) { return invoke<BOOL>(0x5E1CC2E8DC3111DD, entity); } // 0x5E1CC2E8DC3111DD 0x00AB7A4A b1207
	NATIVE_DECL BOOL _IS_ENTITY_ON_TRAIN_TRACK(Entity entity) { return invoke<BOOL>(0x857ACB0AB4BD0D55, entity); } // 0x857ACB0AB4BD0D55 b1207
	NATIVE_DECL void _0xCDB682BB47C02F0A(Entity entity, Hash p1) { invoke<Void>(0xCDB682BB47C02F0A, entity, p1); } // 0xCDB682BB47C02F0A b1207
	NATIVE_DECL void _0xE19035EB65AB2932(Any p0, Any p1) { invoke<Void>(0xE19035EB65AB2932, p0, p1); } // 0xE19035EB65AB2932 b1207
	// Sets the loot table an entity will carry. Returns true if loot table has been successfully set.
	NATIVE_DECL BOOL _0x8C03CD6B5E0E85E8(Entity entity, Hash lootTable) { return invoke<BOOL>(0x8C03CD6B5E0E85E8, entity, lootTable); } // 0x8C03CD6B5E0E85E8 b1207
	NATIVE_DECL BOOL _0x1E804EA9B12030A4(Entity entity, Hash* p1) { return invoke<BOOL>(0x1E804EA9B12030A4, entity, p1); } // 0x1E804EA9B12030A4 b1207
	NATIVE_DECL BOOL _0xA88E215CEB0435C0(Ped mount, Any* argStruct, Hash p2, int p3, int p4, BOOL p5) { return invoke<BOOL>(0xA88E215CEB0435C0, mount, argStruct, p2, p3, p4, p5); } // 0xA88E215CEB0435C0 b1207
	NATIVE_DECL Any _0xE31FC20319874CB3(Any p0, Any p1, Any p2) { return invoke<Any>(0xE31FC20319874CB3, p0, p1, p2); } // 0xE31FC20319874CB3 b1207
	NATIVE_DECL Any _0x582F73ACFE969571(Any p0, Any p1, Any p2) { return invoke<Any>(0x582F73ACFE969571, p0, p1, p2); } // 0x582F73ACFE969571 b1207
	NATIVE_DECL Any _0xBA2A089E60ED1163(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0xBA2A089E60ED1163, p0, p1, p2, p3, p4); } // 0xBA2A089E60ED1163 b1207
	// enum eCarriableState
	// {
	// 	CARRIABLE_STATE_NONE,
	// 	CARRIABLE_STATE_TRANSITIONING_TO_HOGTIED,
	// 	CARRIABLE_STATE_CARRIABLE_INTRO,
	// 	CARRIABLE_STATE_CARRIABLE,
	// 	CARRIABLE_STATE_BEING_PICKED_UP_FROM_GROUND,
	// 	CARRIABLE_STATE_CARRIED_BY_HUMAN,
	// 	CARRIABLE_STATE_BEING_PLACED_ON_GROUND,
	// 	CARRIABLE_STATE_CARRIED_BY_MOUNT,
	// 	CARRIABLE_STATE_BEING_PLACED_ON_MOUNT,
	// 	CARRIABLE_STATE_BEING_PICKED_UP_FROM_MOUNT,
	// 	CARRIABLE_STATE_BEING_CUT_FREE,
	// 	CARRIABLE_STATE_BEING_PLACED_ON_GROUND_ESCAPE,
	// 	CARRIABLE_STATE_BEING_PLACED_IN_VEHICLE
	// };
	NATIVE_DECL int GET_CARRIABLE_ENTITY_STATE(Entity entity) { return invoke<int>(0x61914209C36EFDDB, entity); } // 0x61914209C36EFDDB b1207
	NATIVE_DECL Any _0xD46BF94C4C66FAB0(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xD46BF94C4C66FAB0, p0, p1, p2, p3); } // 0xD46BF94C4C66FAB0 b1207
	// Valid indices: 0 - 3
	// Index 1 always returns a `hogtied` config, doesn't matter the entity.
	// It's for humans only and the ped must be resurrected first if it's dead.
	NATIVE_DECL Hash _GET_OPTIMAL_CARRY_CONFIG(Entity entity, int index) { return invoke<Hash>(0x34F008A7E48C496B, entity, index); } // 0x34F008A7E48C496B b1207
	NATIVE_DECL Any _0xD21C7418C590BB40(Any p0) { return invoke<Any>(0xD21C7418C590BB40, p0); } // 0xD21C7418C590BB40 b1207
	// Returns zero if the entity is not a carriable
	NATIVE_DECL Hash _GET_ENTITY_CARRY_CONFIG(Entity entity) { return invoke<Hash>(0x0FD25587BB306C86, entity); } // 0x0FD25587BB306C86 b1207
	NATIVE_DECL BOOL _0x5AFFA9DDC87846F8(Hash model) { return invoke<BOOL>(0x5AFFA9DDC87846F8, model); } // 0x5AFFA9DDC87846F8 b1207
	// Returns a hash of an entity's name. (Alternative Name: _GET_ENTITY_PROMPT_NAME_HASH)
	NATIVE_DECL Hash _GET_CARRIABLE_FROM_ENTITY(Entity entity) { return invoke<Hash>(0x31FEF6A20F00B963, entity); } // 0x31FEF6A20F00B963 b1207
	NATIVE_DECL void _SET_ENTITY_CARCASS_TYPE(Entity entity, Hash type) { invoke<Void>(0x399657ED871B3A6C, entity, type); } // 0x399657ED871B3A6C b1207
	NATIVE_DECL Any _0x2A77EF9BEC8518F4(Any p0) { return invoke<Any>(0x2A77EF9BEC8518F4, p0); } // 0x2A77EF9BEC8518F4 b1207
	NATIVE_DECL void _DELETE_CARRIABLE(Entity* entity) { invoke<Void>(0x0D0DB2B6AF19A987, entity); } // 0x0D0DB2B6AF19A987 b1207
	NATIVE_DECL BOOL _IS_ENTITY_FULLY_LOOTED(Entity entity) { return invoke<BOOL>(0x8DE41E9902E85756, entity); } // 0x8DE41E9902E85756 b1207
	NATIVE_DECL void _0x6BCF5F3D8FFE988D(Entity entity, BOOL p1) { invoke<Void>(0x6BCF5F3D8FFE988D, entity, p1); } // 0x6BCF5F3D8FFE988D b1207
	NATIVE_DECL Any _0xEF2D9ED7CE684F08(Any p0) { return invoke<Any>(0xEF2D9ED7CE684F08, p0); } // 0xEF2D9ED7CE684F08 b1207
	NATIVE_DECL Any _0x0CCEFC6C2C95DA2A(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x0CCEFC6C2C95DA2A, p0, p1, p2, p3); } // 0x0CCEFC6C2C95DA2A b1207
	NATIVE_DECL Any _0x383F64263F946E45(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<Any>(0x383F64263F946E45, p0, p1, p2, p3, p4, p5); } // 0x383F64263F946E45 b1207
	NATIVE_DECL Any _0x8E10DF0FFA63FB65(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0x8E10DF0FFA63FB65, p0, p1, p2, p3, p4); } // 0x8E10DF0FFA63FB65 b1207
	// flagId: see _SET_ENTITY_CARRYING_FLAG
	NATIVE_DECL BOOL _GET_ENTITY_CARRYING_FLAG(Entity entity, int flagId) { return invoke<BOOL>(0x808077647856DE62, entity, flagId); } // 0x808077647856DE62 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/CARRYING_FLAGS
	// flagId:
	// enum eCarryingFlag
	// {
	// 	CARRYING_FLAG_CAN_BE_CUT_FREE = 1,
	// 	CARRYING_FLAG_CAN_BE_CARRIED_ON_FOOT = 2,
	// 	CARRYING_FLAG_CAN_BE_DROPPED = 4,
	// 	CARRYING_FLAG_CAN_BE_CARRIED_WHEN_DEAD = 7,
	// 	CARRYING_FLAG_CAN_CARRY_ANYTHING = 9,
	// 	CARRYING_FLAG_DISABLE_PROMPT_LOS_CHECKS = 19,
	// 	CARRYING_FLAG_FORCE_ALLOW_WARP_TO_SAFE_GROUND_LOCATION = 23,
	// 	CARRYING_FLAG_PICKUPS_IGNORE_HEIGHT_RESTRICTIONS = 26,
	// 	CARRYING_FLAG_CLEAN_UP_WHEN_NOT_CARRIED = 27,
	// 	CARRYING_FLAG_BLOCK_KNOCK_OFF_PED_VARIATIONS_FROM_CARRIABLE_INTERACTIONS = 29,
	// 	CARRYING_FLAG_HIT_WHEN_CARRIABLE = 31,
	// 	CARRYING_FLAG_DISABLE_CARRIABLE_INTERACTIONS_ON_THIS_MOUNT = 34,
	// 	CARRYING_FLAG_FORCE_HIDE_PROMPT_GROUP = 37,
	// };
	NATIVE_DECL void _SET_ENTITY_CARRYING_FLAG(Entity entity, int flagId, BOOL value) { invoke<Void>(0x18FF3110CF47115D, entity, flagId, value); } // 0x18FF3110CF47115D b1207
	NATIVE_DECL void _0xC3ABCFBC7D74AFA5(Any p0, Any p1, Any p2) { invoke<Void>(0xC3ABCFBC7D74AFA5, p0, p1, p2); } // 0xC3ABCFBC7D74AFA5 b1207
	// Called if entity is in water and submerged level is larger than 1f. If CARRYING_FLAG_FORCE_ALLOW_WARP_TO_SAFE_GROUND_LOCATION is true, it gets disabled as well.
	NATIVE_DECL void _0x371D179701D9C082(Entity entity) { invoke<Void>(0x371D179701D9C082, entity); } // 0x371D179701D9C082 b1436
	NATIVE_DECL void _0xA48E4801DEBDF7E4(Entity entity, BOOL p1) { invoke<Void>(0xA48E4801DEBDF7E4, entity, p1); } // 0xA48E4801DEBDF7E4 b1207
	NATIVE_DECL BOOL _GET_IS_CARRIABLE_PELT(Entity entity) { return invoke<BOOL>(0x255B6DB4E3AD3C3E, entity); } // 0x255B6DB4E3AD3C3E b1207
	NATIVE_DECL Any _0xF59FDE7B4D31A630(Any p0) { return invoke<Any>(0xF59FDE7B4D31A630, p0); } // 0xF59FDE7B4D31A630 b1207
	NATIVE_DECL Any _0x120376C23F019C6C(Any p0, Any p1) { return invoke<Any>(0x120376C23F019C6C, p0, p1); } // 0x120376C23F019C6C b1207
	NATIVE_DECL Any _0x5744562E973E33CD(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0x5744562E973E33CD, p0, p1, p2, p3, p4); } // 0x5744562E973E33CD b1207
	NATIVE_DECL void _0xDD03FC2089AD093C(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xDD03FC2089AD093C, p0, p1, p2, p3); } // 0xDD03FC2089AD093C b1207
	NATIVE_DECL Any _0xB16C780C51E51E2B(Any p0) { return invoke<Any>(0xB16C780C51E51E2B, p0); } // 0xB16C780C51E51E2B b1207
	NATIVE_DECL void _0xEF259AA1E097E0AD(Entity entity, Any p1) { invoke<Void>(0xEF259AA1E097E0AD, entity, p1); } // 0xEF259AA1E097E0AD b1207
	NATIVE_DECL void _0xBD94CECFB2D65119(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0xBD94CECFB2D65119, p0, p1, p2, p3, p4, p5); } // 0xBD94CECFB2D65119 b1207
	NATIVE_DECL void _SET_ENTITY_CUSTOM_PICKUP_RADIUS(Entity entity, float radius) { invoke<Void>(0x482D17E45665DA44, entity, radius); } // 0x482D17E45665DA44 b1207
	NATIVE_DECL void _0xE75EEA8DB59A9F39(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0xE75EEA8DB59A9F39, p0, p1, p2, p3, p4, p5); } // 0xE75EEA8DB59A9F39 b1207
	NATIVE_DECL Any _0x188736456D1DEDE6(Any p0, Any p1) { return invoke<Any>(0x188736456D1DEDE6, p0, p1); } // 0x188736456D1DEDE6 b1207
	NATIVE_DECL void _0xC6A1A3D63F122DE7(Any p0, Any p1) { invoke<Void>(0xC6A1A3D63F122DE7, p0, p1); } // 0xC6A1A3D63F122DE7 b1311
	// p6/relative - makes the xyz force not relative to world coords, but to something else
	// p7/highForce - setting false will make the force really low
	NATIVE_DECL void APPLY_FORCE_TO_ENTITY_CENTER_OF_MASS(Entity entity, int forceType, float x, float y, float z, BOOL p5, BOOL isDirectionRel, BOOL isForceRel, BOOL p8) { invoke<Void>(0x31DA7CEC5334DB37, entity, forceType, x, y, z, p5, isDirectionRel, isForceRel, p8); } // 0x31DA7CEC5334DB37 0x28924E98 b1207
	NATIVE_DECL void APPLY_FORCE_TO_ENTITY_CENTER_OF_MASS(Entity entity, int forceType, Vector3 vec, BOOL p5, BOOL isDirectionRel, BOOL isForceRel, BOOL p8) { invoke<Void>(0x31DA7CEC5334DB37, entity, forceType, vec.x, vec.y, vec.z, p5, isDirectionRel, isForceRel, p8); } // 0x31DA7CEC5334DB37 0x28924E98 b1207
	NATIVE_DECL void APPLY_FORCE_TO_ENTITY(Entity entity, int forceFlags, float x, float y, float z, float offX, float offY, float offZ, int boneIndex, BOOL isDirectionRel, BOOL ignoreUpVec, BOOL isForceRel, BOOL p12, BOOL p13) { invoke<Void>(0xF15E8F5D333F09C4, entity, forceFlags, x, y, z, offX, offY, offZ, boneIndex, isDirectionRel, ignoreUpVec, isForceRel, p12, p13); } // 0xF15E8F5D333F09C4 0xC1C0855A b1207
	NATIVE_DECL void APPLY_FORCE_TO_ENTITY(Entity entity, int forceFlags, Vector3 vec, Vector3 off, int boneIndex, BOOL isDirectionRel, BOOL ignoreUpVec, BOOL isForceRel, BOOL p12, BOOL p13) { invoke<Void>(0xF15E8F5D333F09C4, entity, forceFlags, vec.x, vec.y, vec.z, off.x, off.y, off.z, boneIndex, isDirectionRel, ignoreUpVec, isForceRel, p12, p13); } // 0xF15E8F5D333F09C4 0xC1C0855A b1207
	// Attaches entity1 to bone (boneIndex) of entity2.
	// 
	// boneIndex - this is different to boneID, use GET_PED_BONE_INDEX to get the index from the ID. use the index for attaching to specific bones. entity1 will be attached to entity2's centre if bone index given doesn't correspond to bone indexes for that entity type.
	// https://github.com/femga/rdr3_discoveries/tree/master/boneNames
	// 
	// useSoftPinning - if set to false attached entity will not detach when fixed
	// collision - controls collision between the two entities (FALSE disables collision).
	// isPed - pitch doesn't work when false and roll will only work on negative numbers (only peds)
	// vertexIndex - position of vertex
	// fixedRot - if false it ignores entity vector
	NATIVE_DECL void ATTACH_ENTITY_TO_ENTITY(Entity entity1, Entity entity2, int boneIndex, float xPos, float yPos, float zPos, float xRot, float yRot, float zRot, BOOL p9, BOOL useSoftPinning, BOOL collision, BOOL isPed, int vertexIndex, BOOL fixedRot, BOOL p15, BOOL p16) { invoke<Void>(0x6B9BBD38AB0796DF, entity1, entity2, boneIndex, xPos, yPos, zPos, xRot, yRot, zRot, p9, useSoftPinning, collision, isPed, vertexIndex, fixedRot, p15, p16); } // 0x6B9BBD38AB0796DF 0xEC024237 b1207
	NATIVE_DECL void ATTACH_ENTITY_TO_ENTITY(Entity entity1, Entity entity2, int boneIndex, Vector3 pos, Vector3 rot, BOOL p9, BOOL useSoftPinning, BOOL collision, BOOL isPed, int vertexIndex, BOOL fixedRot, BOOL p15, BOOL p16) { invoke<Void>(0x6B9BBD38AB0796DF, entity1, entity2, boneIndex, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, p9, useSoftPinning, collision, isPed, vertexIndex, fixedRot, p15, p16); } // 0x6B9BBD38AB0796DF 0xEC024237 b1207
	NATIVE_DECL void ATTACH_ENTITY_TO_ENTITY_PHYSICALLY(Entity entity1, Entity entity2, int p2, int boneIndex, float offsetX, float offsetY, float offsetZ, float p7, float p8, float p9, float p10, float p11, float p12, float p13, BOOL p14, BOOL p15, BOOL p16, BOOL p17, int p18, BOOL p19, float p20, float p21) { invoke<Void>(0xB629A43CA1643481, entity1, entity2, p2, boneIndex, offsetX, offsetY, offsetZ, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21); } // 0xB629A43CA1643481 0x0547417F b1207
	NATIVE_DECL void ATTACH_ENTITY_TO_ENTITY_PHYSICALLY(Entity entity1, Entity entity2, int p2, int boneIndex, Vector3 offset, float p7, float p8, float p9, float p10, float p11, float p12, float p13, BOOL p14, BOOL p15, BOOL p16, BOOL p17, int p18, BOOL p19, float p20, float p21) { invoke<Void>(0xB629A43CA1643481, entity1, entity2, p2, boneIndex, offset.x, offset.y, offset.z, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21); } // 0xB629A43CA1643481 0x0547417F b1207
	NATIVE_DECL void _0x445D7D8EA66E373E(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10, Any p11, Any p12, Any p13, Any p14, Any p15) { invoke<Void>(0x445D7D8EA66E373E, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); } // 0x445D7D8EA66E373E b1207
	NATIVE_DECL void _0x16908E859C3AB698(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x16908E859C3AB698, p0, p1, p2, p3, p4); } // 0x16908E859C3AB698 b1207
	NATIVE_DECL int GET_ENTITY_BONE_INDEX_BY_NAME(Entity entity, const char* boneName) { return invoke<int>(0xBACA8FE9C76C124E, entity, boneName); } // 0xBACA8FE9C76C124E 0xE4ECAC22 b1207
	NATIVE_DECL void CLEAR_ENTITY_LAST_DAMAGE_ENTITY(Entity entity) { invoke<Void>(0xBB19AC7D4DCEFD0F, entity); } // 0xBB19AC7D4DCEFD0F 0x2B83F43B b1207
	// Deletes the specified entity, then sets the handle pointed to by the pointer to NULL.
	NATIVE_DECL void DELETE_ENTITY(Entity* entity) { invoke<Void>(0x4CD38C78BD19A497, entity); } // 0x4CD38C78BD19A497 0xFAA3D236 b1207
	// Must be called from a background script, otherwise it will do nothing.
	NATIVE_DECL void _DELETE_ENTITY_2(Entity* entity) { invoke<Void>(0x5E94EA09E7207C16, entity); } // 0x5E94EA09E7207C16 b1207
	NATIVE_DECL void DETACH_ENTITY(Entity entity, BOOL p1, BOOL collision) { invoke<Void>(0x64CDE9D6BF8ECAD3, entity, p1, collision); } // 0x64CDE9D6BF8ECAD3 0xC8EFCB41 b1207
	// Getter for FREEZE_ENTITY_POSITION
	NATIVE_DECL BOOL _IS_ENTITY_FROZEN(Entity entity) { return invoke<BOOL>(0x083D497D57B7400F, entity); } // 0x083D497D57B7400F b1207
	NATIVE_DECL void FREEZE_ENTITY_POSITION(Entity entity, BOOL toggle) { invoke<Void>(0x7D9EFB7AD6B19754, entity, toggle); } // 0x7D9EFB7AD6B19754 0x65C16D57 b1207
	NATIVE_DECL void _SET_ENTITY_CLEANUP_BY_ENGINE(Entity entity, BOOL toggle) { invoke<Void>(0x740CB4F3F602C9F4, entity, toggle); } // 0x740CB4F3F602C9F4 0xD3850671 b1207
	// Makes the specified entity (ped, vehicle or object) persistent. Persistent entities will not automatically be removed by the engine.
	NATIVE_DECL void SET_ENTITY_AS_MISSION_ENTITY(Entity entity, BOOL p1, BOOL p2) { invoke<Void>(0xDC19C288082E586E, entity, p1, p2); } // 0xDC19C288082E586E 0x5D1F9E0F b1207
	// Marks the specified entity (ped, vehicle or object) as no longer needed.
	// Entities marked as no longer needed, will be deleted as the engine sees fit.
	NATIVE_DECL void SET_ENTITY_AS_NO_LONGER_NEEDED(Entity* entity) { invoke<Void>(0x4971D2F8162B9674, entity); } // 0x4971D2F8162B9674 0xADF2267C b1207
	// This is an alias of SET_ENTITY_AS_NO_LONGER_NEEDED.
	NATIVE_DECL void SET_PED_AS_NO_LONGER_NEEDED(Ped* ped) { invoke<Void>(0x2595DD4236549CE3, ped); } // 0x2595DD4236549CE3 0x9A388380 b1207
	// This is an alias of SET_ENTITY_AS_NO_LONGER_NEEDED.
	NATIVE_DECL void SET_VEHICLE_AS_NO_LONGER_NEEDED(Vehicle* vehicle) { invoke<Void>(0x629BFA74418D6239, vehicle); } // 0x629BFA74418D6239 0x9B0E10BE b1207
	// This is an alias of SET_ENTITY_AS_NO_LONGER_NEEDED.
	NATIVE_DECL void SET_OBJECT_AS_NO_LONGER_NEEDED(Object* object) { invoke<Void>(0x3AE22DEB5BA5A3E6, object); } // 0x3AE22DEB5BA5A3E6 0x3F6B949F b1207
	NATIVE_DECL void _0x20FAEE47427A4497() { invoke<Void>(0x20FAEE47427A4497); } // 0x20FAEE47427A4497 b1207
	// Returns true if calling script owns specified entity
	NATIVE_DECL BOOL _DOES_THREAD_OWN_THIS_ENTITY(Entity entity) { return invoke<BOOL>(0x88AD6CC10D8D35B2, entity); } // 0x88AD6CC10D8D35B2 b1207
	NATIVE_DECL void _0x56E0735D6273B227(Any p0, Any p1) { invoke<Void>(0x56E0735D6273B227, p0, p1); } // 0x56E0735D6273B227 b1207
	// SET_ENTITY_A*
	NATIVE_DECL void _0xC0EDEF16D90661EE(Entity entity, float p1) { invoke<Void>(0xC0EDEF16D90661EE, entity, p1); } // 0xC0EDEF16D90661EE b1207
	NATIVE_DECL void _0x0FD7D7C232876E72(Any p0) { invoke<Void>(0x0FD7D7C232876E72, p0); } // 0x0FD7D7C232876E72 b1207
	NATIVE_DECL void _0x0939E773925C4719() { invoke<Void>(0x0939E773925C4719); } // 0x0939E773925C4719 b1207
	NATIVE_DECL void SET_ENTITY_CAN_BE_DAMAGED(Entity entity, BOOL toggle) { invoke<Void>(0x0D06D522B90E861F, entity, toggle); } // 0x0D06D522B90E861F 0x60B6E744 b1207
	NATIVE_DECL BOOL _GET_ENTITY_CAN_BE_DAMAGED(Entity entity) { return invoke<BOOL>(0x75DF9E73F2F005FD, entity); } // 0x75DF9E73F2F005FD b1207
	NATIVE_DECL void SET_ENTITY_CAN_BE_DAMAGED_BY_RELATIONSHIP_GROUP(Entity entity, BOOL bCanBeDamaged, Hash relGroup) { invoke<Void>(0x0EF1AFB18649E015, entity, bCanBeDamaged, relGroup); } // 0x0EF1AFB18649E015 0x34165B5D b1207
	NATIVE_DECL void _0xFF83AF534156B399(Any p0, Any p1) { invoke<Void>(0xFF83AF534156B399, p0, p1); } // 0xFF83AF534156B399 b1207
	// Sets whether the entity can be targeted without being in line-of-sight.
	NATIVE_DECL void SET_ENTITY_CAN_BE_TARGETED_WITHOUT_LOS(Entity entity, BOOL toggle) { invoke<Void>(0x6D09F32E284D0FB7, entity, toggle); } // 0x6D09F32E284D0FB7 0x3B13797C b1207
	NATIVE_DECL BOOL GET_ENTITY_COLLISION_DISABLED(Entity entity) { return invoke<BOOL>(0xAA2FADD30F45A9DA, entity); } // 0xAA2FADD30F45A9DA 0xE8C0C629 b1207
	NATIVE_DECL void SET_ENTITY_COLLISION(Entity entity, BOOL toggle, BOOL keepPhysics) { invoke<Void>(0xF66F820909453B8C, entity, toggle, keepPhysics); } // 0xF66F820909453B8C 0x139FD37D b1207
	NATIVE_DECL void SET_ENTITY_COMPLETELY_DISABLE_COLLISION(Entity entity, BOOL toggle, BOOL keepPhysics) { invoke<Void>(0xE0580EC84813875A, entity, toggle, keepPhysics); } // 0xE0580EC84813875A 0xBD0D4831 b1207
	NATIVE_DECL void SET_ENTITY_COORDS(Entity entity, float xPos, float yPos, float zPos, BOOL xAxis, BOOL yAxis, BOOL zAxis, BOOL clearArea) { invoke<Void>(0x06843DA7060A026B, entity, xPos, yPos, zPos, xAxis, yAxis, zAxis, clearArea); } // 0x06843DA7060A026B 0xDF70B41B b1207
	NATIVE_DECL void SET_ENTITY_COORDS(Entity entity, Vector3 pos, BOOL xAxis, BOOL yAxis, BOOL zAxis, BOOL clearArea) { invoke<Void>(0x06843DA7060A026B, entity, pos.x, pos.y, pos.z, xAxis, yAxis, zAxis, clearArea); } // 0x06843DA7060A026B 0xDF70B41B b1207
	// Axis - Invert Axis Flags
	NATIVE_DECL void SET_ENTITY_COORDS_NO_OFFSET(Entity entity, float xPos, float yPos, float zPos, BOOL xAxis, BOOL yAxis, BOOL zAxis) { invoke<Void>(0x239A3351AC1DA385, entity, xPos, yPos, zPos, xAxis, yAxis, zAxis); } // 0x239A3351AC1DA385 0x4C83DE8D b1207
	NATIVE_DECL void SET_ENTITY_COORDS_NO_OFFSET(Entity entity, Vector3 pos, BOOL xAxis, BOOL yAxis, BOOL zAxis) { invoke<Void>(0x239A3351AC1DA385, entity, pos.x, pos.y, pos.z, xAxis, yAxis, zAxis); } // 0x239A3351AC1DA385 0x4C83DE8D b1207
	NATIVE_DECL void SET_ENTITY_DYNAMIC(Entity entity, BOOL toggle) { invoke<Void>(0xFBFC4473F66CE344, entity, toggle); } // 0xFBFC4473F66CE344 0x236F525B b1207
	NATIVE_DECL void SET_ENTITY_HEADING(Entity entity, float heading) { invoke<Void>(0xCF2B9C0645C4651B, entity, heading); } // 0xCF2B9C0645C4651B 0xE0FF064D b1207
	NATIVE_DECL void _SET_ENTITY_COORDS_AND_HEADING(Entity entity, float xPos, float yPos, float zPos, float heading, BOOL xAxis, BOOL yAxis, BOOL zAxis) { invoke<Void>(0x203BEFFDBE12E96A, entity, xPos, yPos, zPos, heading, xAxis, yAxis, zAxis); } // 0x203BEFFDBE12E96A b1207
	NATIVE_DECL void _SET_ENTITY_COORDS_AND_HEADING(Entity entity, Vector3 pos, float heading, BOOL xAxis, BOOL yAxis, BOOL zAxis) { invoke<Void>(0x203BEFFDBE12E96A, entity, pos.x, pos.y, pos.z, heading, xAxis, yAxis, zAxis); } // 0x203BEFFDBE12E96A b1207
	NATIVE_DECL void _SET_ENTITY_COORDS_AND_HEADING_NO_OFFSET(Entity entity, float xPos, float yPos, float zPos, float heading, BOOL p5, BOOL p6) { invoke<Void>(0x0918E3565C20F03C, entity, xPos, yPos, zPos, heading, p5, p6); } // 0x0918E3565C20F03C b1207
	NATIVE_DECL void _SET_ENTITY_COORDS_AND_HEADING_NO_OFFSET(Entity entity, Vector3 pos, float heading, BOOL p5, BOOL p6) { invoke<Void>(0x0918E3565C20F03C, entity, pos.x, pos.y, pos.z, heading, p5, p6); } // 0x0918E3565C20F03C b1207
	// Sets the entity's health. healthAmount sets the health value to that, and sets the maximum health core value. Setting healthAmount to 0 will kill the entity. entityKilledBy parameter can also be 0
	NATIVE_DECL void SET_ENTITY_HEALTH(Entity entity, int healthAmount, Entity entityKilledBy) { invoke<Void>(0xAC2767ED8BDFAB15, entity, healthAmount, entityKilledBy); } // 0xAC2767ED8BDFAB15 b1207
	// Sets a ped or an object totally invincible. It doesn't take any kind of damage. Peds will not ragdoll on explosions.
	NATIVE_DECL void SET_ENTITY_INVINCIBLE(Entity entity, BOOL toggle) { invoke<Void>(0xA5C38736C426FCB8, entity, toggle); } // 0xA5C38736C426FCB8 0xC1213A21 b1207
	// SET_ENTITY_LO*
	NATIVE_DECL void _0xAF7F3099B9FEB535(Entity entity, float p1, float p2, float p3) { invoke<Void>(0xAF7F3099B9FEB535, entity, p1, p2, p3); } // 0xAF7F3099B9FEB535 b1207
	NATIVE_DECL void SET_ENTITY_IS_TARGET_PRIORITY(Entity entity, BOOL p1, float p2) { invoke<Void>(0x0A5D170C44CB2189, entity, p1, p2); } // 0x0A5D170C44CB2189 0x9729EE32 b1207
	NATIVE_DECL void _0xB38A29CCD5447783(Any p0, Any p1, Any p2) { invoke<Void>(0xB38A29CCD5447783, p0, p1, p2); } // 0xB38A29CCD5447783 b1207
	// tier: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/_SET_ENTITY_THREAT_TIER/README.md
	NATIVE_DECL void _SET_ENTITY_THREAT_TIER(Entity entity, int tier, BOOL p2) { invoke<Void>(0x4B436BAC8CBE9B07, entity, tier, p2); } // 0x4B436BAC8CBE9B07 b1207
	NATIVE_DECL int _GET_ENTITY_THREAT_TIER(Entity entity) { return invoke<int>(0xE12F56CB25D9CE23, entity); } // 0xE12F56CB25D9CE23 b1207
	NATIVE_DECL void _0x2D40BCBFE9305DEA(Any p0, Any p1) { invoke<Void>(0x2D40BCBFE9305DEA, p0, p1); } // 0x2D40BCBFE9305DEA b1207
	NATIVE_DECL void _SET_ENTITY_LIGHTS_ENABLED(Entity entity, BOOL enabled) { invoke<Void>(0xEBDC12861D079ABA, entity, enabled); } // 0xEBDC12861D079ABA b1207
	NATIVE_DECL void SET_ENTITY_LOAD_COLLISION_FLAG(Entity entity, BOOL toggle) { invoke<Void>(0x9B9EE31AED48072E, entity, toggle); } // 0x9B9EE31AED48072E 0xC52F295B b1207
	NATIVE_DECL BOOL HAS_COLLISION_LOADED_AROUND_ENTITY(Entity entity) { return invoke<BOOL>(0xBEB1600952B9CF5C, entity); } // 0xBEB1600952B9CF5C 0x851687F9 b1207
	// Old name: _HAS_COLLISION_LOADED_AT_COORDS
	NATIVE_DECL BOOL HAS_COLLISION_LOADED_AROUND_POSITION(float xPos, float yPos, float zPos) { return invoke<BOOL>(0x6BFBDC46139C45AB, xPos, yPos, zPos); } // 0x6BFBDC46139C45AB b1207
	NATIVE_DECL BOOL HAS_COLLISION_LOADED_AROUND_POSITION(Vector3 pos) { return invoke<BOOL>(0x6BFBDC46139C45AB, pos.x, pos.y, pos.z); } // 0x6BFBDC46139C45AB b1207
	NATIVE_DECL void SET_ENTITY_ONLY_DAMAGED_BY_PLAYER(Entity entity, BOOL toggle) { invoke<Void>(0x473598683095D430, entity, toggle); } // 0x473598683095D430 0x4B707F50 b1207
	NATIVE_DECL void SET_ENTITY_ONLY_DAMAGED_BY_RELATIONSHIP_GROUP(Entity entity, BOOL p1, Hash relationshipGroup) { invoke<Void>(0x6C1F6AA2F0ADD104, entity, p1, relationshipGroup); } // 0x6C1F6AA2F0ADD104 0x202237E2 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/ENTITY_PROOFS
	// BOOL p2: handles an additional special proofs flag, so it simply indicates whether it should be enabled or disabled, not sure what exactly it proofs the entity from though
	NATIVE_DECL void SET_ENTITY_PROOFS(Entity entity, int proofsBitset, BOOL specialFlag) { invoke<Void>(0xFAEE099C6F890BB8, entity, proofsBitset, specialFlag); } // 0xFAEE099C6F890BB8 0x7E9EAB66 b1207
	// Note: this native was removed in 1232 but added back in 1311
	NATIVE_DECL int _GET_ENTITY_PROOFS(Entity entity) { return invoke<int>(0x6CF0DAD7FA1088EA, entity); } // 0x6CF0DAD7FA1088EA b1207
	NATIVE_DECL void SET_ENTITY_QUATERNION(Entity entity, float x, float y, float z, float w) { invoke<Void>(0x100E7007D13E3687, entity, x, y, z, w); } // 0x100E7007D13E3687 0x83B6046F b1207
	NATIVE_DECL void SET_ENTITY_QUATERNION(Entity entity, Vector4 vec) { invoke<Void>(0x100E7007D13E3687, entity, vec.x, vec.y, vec.z, vec.w); } // 0x100E7007D13E3687 0x83B6046F b1207
	NATIVE_DECL void SET_ENTITY_ROTATION(Entity entity, float pitch, float roll, float yaw, int rotationOrder, BOOL p5) { invoke<Void>(0x9CC8314DFEDE441E, entity, pitch, roll, yaw, rotationOrder, p5); } // 0x9CC8314DFEDE441E 0x0A345EFE b1207
	NATIVE_DECL void _0xD45BB89B53FC0CFD(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xD45BB89B53FC0CFD, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xD45BB89B53FC0CFD b1207
	NATIVE_DECL void SET_ENTITY_VISIBLE(Entity entity, BOOL toggle) { invoke<Void>(0x1794B4FCC84D812F, entity, toggle); } // 0x1794B4FCC84D812F 0xD043E8E1 b1207
	NATIVE_DECL void _0x80FDEB3A9E9AA578(Entity entity, BOOL p1) { invoke<Void>(0x80FDEB3A9E9AA578, entity, p1); } // 0x80FDEB3A9E9AA578 b1207
	NATIVE_DECL void _0x9C6906EF8CB20C5F(Entity entity) { invoke<Void>(0x9C6906EF8CB20C5F, entity); } // 0x9C6906EF8CB20C5F b1436
	// Note that the third parameter(denoted as z) is "up and down" with positive numbers encouraging upwards movement.
	NATIVE_DECL void SET_ENTITY_VELOCITY(Entity entity, float x, float y, float z) { invoke<Void>(0x1C99BB7B6E96D16F, entity, x, y, z); } // 0x1C99BB7B6E96D16F 0xFF5A1988 b1207
	NATIVE_DECL void SET_ENTITY_VELOCITY(Entity entity, Vector3 vec) { invoke<Void>(0x1C99BB7B6E96D16F, entity, vec.x, vec.y, vec.z); } // 0x1C99BB7B6E96D16F 0xFF5A1988 b1207
	NATIVE_DECL void SET_ENTITY_HAS_GRAVITY(Entity entity, BOOL toggle) { invoke<Void>(0x0CEDB728A1083FA7, entity, toggle); } // 0x0CEDB728A1083FA7 0xE2F262BF b1207
	// LOD distance can be 0 to 0xFFFF (higher values will result in 0xFFFF) as it is actually stored as a 16-bit value (aka uint16_t).
	NATIVE_DECL void SET_ENTITY_LOD_DIST(Entity entity, int value) { invoke<Void>(0x5FB407F0A7C877BF, entity, value); } // 0x5FB407F0A7C877BF 0xD7ACC7AD b1207
	// Returns the LOD distance of an entity.
	NATIVE_DECL int GET_ENTITY_LOD_DIST(Entity entity) { return invoke<int>(0xDF240D0C2A948683, entity); } // 0xDF240D0C2A948683 0x4DA3D51F b1207
	// skin - everything alpha except skin
	// Set entity alpha level. Ranging from 0 to 255 but changes occur after every 20 percent (after every 51).
	NATIVE_DECL void SET_ENTITY_ALPHA(Entity entity, int alphaLevel, BOOL skin) { invoke<Void>(0x0DF7692B1D9E7BA7, entity, alphaLevel, skin); } // 0x0DF7692B1D9E7BA7 0xAE667CB0 b1207
	NATIVE_DECL int GET_ENTITY_ALPHA(Entity entity) { return invoke<int>(0x1BB501624FAF2BEA, entity); } // 0x1BB501624FAF2BEA 0x1560B017 b1207
	NATIVE_DECL void RESET_ENTITY_ALPHA(Entity entity) { invoke<Void>(0x744B9EF44779D9AB, entity); } // 0x744B9EF44779D9AB 0x8A30761C b1207
	NATIVE_DECL void _SET_ENTITY_FADE_IN(Entity entity) { invoke<Void>(0xA91E6CF94404E8C9, entity); } // 0xA91E6CF94404E8C9 b1207
	NATIVE_DECL void SET_ENTITY_ALWAYS_PRERENDER(Entity entity, BOOL toggle) { invoke<Void>(0xACAD101E1FB66689, entity, toggle); } // 0xACAD101E1FB66689 0xD8FF798A b1207
	NATIVE_DECL void SET_ENTITY_RENDER_SCORCHED(Entity entity, BOOL toggle) { invoke<Void>(0x85B8A7534E44BC23, entity, toggle); } // 0x85B8A7534E44BC23 0xAAC9317B b1207
	// Seems to return true if entity is burned / scorched
	// _GET_ENTITY_*
	NATIVE_DECL Any _0x37B01666BAE8F7EF(Entity entity) { return invoke<Any>(0x37B01666BAE8F7EF, entity); } // 0x37B01666BAE8F7EF b1207
	NATIVE_DECL void _0xA9E6D8F2DDFC4DB9(Any p0, Any p1) { invoke<Void>(0xA9E6D8F2DDFC4DB9, p0, p1); } // 0xA9E6D8F2DDFC4DB9 b1207
	// Only works with objects!
	NATIVE_DECL void CREATE_MODEL_SWAP(float x, float y, float z, float radius, Hash originalModel, Hash newModel, BOOL p6) { invoke<Void>(0x10B2218320B6F5AC, x, y, z, radius, originalModel, newModel, p6); } // 0x10B2218320B6F5AC 0x0BC12F9E b1207
	NATIVE_DECL void CREATE_MODEL_SWAP(Vector3 vec, float radius, Hash originalModel, Hash newModel, BOOL p6) { invoke<Void>(0x10B2218320B6F5AC, vec.x, vec.y, vec.z, radius, originalModel, newModel, p6); } // 0x10B2218320B6F5AC 0x0BC12F9E b1207
	NATIVE_DECL void REMOVE_MODEL_SWAP(float x, float y, float z, float radius, Hash originalModel, Hash newModel, BOOL p6) { invoke<Void>(0x824E1C26A14CB817, x, y, z, radius, originalModel, newModel, p6); } // 0x824E1C26A14CB817 0xCE0AA8BC b1207
	NATIVE_DECL void REMOVE_MODEL_SWAP(Vector3 vec, float radius, Hash originalModel, Hash newModel, BOOL p6) { invoke<Void>(0x824E1C26A14CB817, vec.x, vec.y, vec.z, radius, originalModel, newModel, p6); } // 0x824E1C26A14CB817 0xCE0AA8BC b1207
	NATIVE_DECL void CREATE_MODEL_HIDE(float x, float y, float z, float radius, Hash model, BOOL p5) { invoke<Void>(0x069848B3FB3C4426, x, y, z, radius, model, p5); } // 0x069848B3FB3C4426 0x7BD5CF2F b1207
	NATIVE_DECL void CREATE_MODEL_HIDE(Vector3 vec, float radius, Hash model, BOOL p5) { invoke<Void>(0x069848B3FB3C4426, vec.x, vec.y, vec.z, radius, model, p5); } // 0x069848B3FB3C4426 0x7BD5CF2F b1207
	NATIVE_DECL void CREATE_MODEL_HIDE_EXCLUDING_SCRIPT_OBJECTS(float x, float y, float z, float radius, Hash model, BOOL p5) { invoke<Void>(0xD136090A9AAAB17D, x, y, z, radius, model, p5); } // 0xD136090A9AAAB17D 0x07AAF22C b1207
	NATIVE_DECL void CREATE_MODEL_HIDE_EXCLUDING_SCRIPT_OBJECTS(Vector3 vec, float radius, Hash model, BOOL p5) { invoke<Void>(0xD136090A9AAAB17D, vec.x, vec.y, vec.z, radius, model, p5); } // 0xD136090A9AAAB17D 0x07AAF22C b1207
	NATIVE_DECL void REMOVE_MODEL_HIDE(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x3F38A98576F6213A, p0, p1, p2, p3, p4, p5); } // 0x3F38A98576F6213A 0x993DBC10 b1207
	NATIVE_DECL Any _0xD4636C2EDB0DEA8A(Any p0) { return invoke<Any>(0xD4636C2EDB0DEA8A, p0); } // 0xD4636C2EDB0DEA8A b1207
	NATIVE_DECL void CREATE_FORCED_OBJECT(float x, float y, float z, Any p3, Hash modelHash, BOOL p5) { invoke<Void>(0x0961A905AFBC34C7, x, y, z, p3, modelHash, p5); } // 0x0961A905AFBC34C7 0x335190A2 b1207
	NATIVE_DECL void CREATE_FORCED_OBJECT(Vector3 vec, Any p3, Hash modelHash, BOOL p5) { invoke<Void>(0x0961A905AFBC34C7, vec.x, vec.y, vec.z, p3, modelHash, p5); } // 0x0961A905AFBC34C7 0x335190A2 b1207
	NATIVE_DECL void REMOVE_FORCED_OBJECT(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x553FA683F2BCD814, p0, p1, p2, p3, p4); } // 0x553FA683F2BCD814 0xAED73ADD b1207
	NATIVE_DECL void SET_ENTITY_NO_COLLISION_ENTITY(Entity entity1, Entity entity2, BOOL thisFrameOnly) { invoke<Void>(0xE037BF068223C38D, entity1, entity2, thisFrameOnly); } // 0xE037BF068223C38D 0x1E11BFE9 b1207
	NATIVE_DECL void SET_ENTITY_MOTION_BLUR(Entity entity, BOOL toggle) { invoke<Void>(0x516C6ABD18322B63, entity, toggle); } // 0x516C6ABD18322B63 0xE90005B8 b1207
	NATIVE_DECL void SET_CAN_AUTO_VAULT_ON_ENTITY(Entity entity, BOOL toggle) { invoke<Void>(0x80646744FA88F9D7, entity, toggle); } // 0x80646744FA88F9D7 0x44767B31 b1207
	NATIVE_DECL void SET_CAN_CLIMB_ON_ENTITY(Entity entity, BOOL toggle) { invoke<Void>(0x24AED2A608F93C4C, entity, toggle); } // 0x24AED2A608F93C4C 0xE224A6A5 b1207
	NATIVE_DECL void _SET_ENTITY_DECALS_DISABLED(Entity entity, BOOL toggle) { invoke<Void>(0xC64E597783BE9A1D, entity, toggle); } // 0xC64E597783BE9A1D b1207
	NATIVE_DECL int _GET_ENTITIES_NEAR_POINT(float x, float y, float z, float radius, ItemSet itemSet, int p5) { return invoke<int>(0x59B57C4B06531E1E, x, y, z, radius, itemSet, p5); } // 0x59B57C4B06531E1E b1207
	NATIVE_DECL int _GET_ENTITIES_NEAR_POINT(Vector3 vec, float radius, ItemSet itemSet, int p5) { return invoke<int>(0x59B57C4B06531E1E, vec.x, vec.y, vec.z, radius, itemSet, p5); } // 0x59B57C4B06531E1E b1207
	NATIVE_DECL int GET_MATCHING_ENTITIES(Volume volume, ItemSet itemSet, int entityType, Any p3, Hash p4, const char* p5) { return invoke<int>(0x84CCF9A12942C83D, volume, itemSet, entityType, p3, p4, p5); } // 0x84CCF9A12942C83D b1207
	NATIVE_DECL int _GET_ENTITIES_IN_VOLUME(Volume volume, ItemSet itemSet, int entityType) { return invoke<int>(0x886171A12F400B89, volume, itemSet, entityType); } // 0x886171A12F400B89 b1207
	// Alternative Name: _GET_ENTITY_FROM_MAP_OBJECT; You can get existing objects and manipulate them using this native.
	NATIVE_DECL Entity _SEARCH_BUILDING_POOL_FOR_ENTITY_WITH_THIS_MODEL(Hash modelHash) { return invoke<Entity>(0x66B2B83B94B22458, modelHash); } // 0x66B2B83B94B22458 b1207
	NATIVE_DECL Any _0xC2E71D7E0A7B4C89(Any p0) { return invoke<Any>(0xC2E71D7E0A7B4C89, p0); } // 0xC2E71D7E0A7B4C89 b1207
	NATIVE_DECL void _0x6C31B06E91518269(Any p0, Any p1) { invoke<Void>(0x6C31B06E91518269, p0, p1); } // 0x6C31B06E91518269 b1207
	NATIVE_DECL void _0x119A5714578F4E05(Any p0, Any p1) { invoke<Void>(0x119A5714578F4E05, p0, p1); } // 0x119A5714578F4E05 b1207
	// Params: p1 = 0 in R* Scripts (GET_DOOR_ENTITY_FROM_ID)
	// https://github.com/femga/rdr3_discoveries/blob/master/doorHashes/doorhashes.lua
	NATIVE_DECL Entity _GET_ENTITY_BY_DOORHASH(Hash doorHash, int p1) { return invoke<Entity>(0xF7424890E4A094C0, doorHash, p1); } // 0xF7424890E4A094C0 b1207
	NATIVE_DECL BOOL FIND_ANIM_EVENT_PHASE(const char* animDictionary, const char* animName, const char* p2, Any* p3, Any* p4) { return invoke<BOOL>(0x42718CC559BD7776, animDictionary, animName, p2, p3, p4); } // 0x42718CC559BD7776 0xC41DDA62 b1207
	NATIVE_DECL void FORCE_ENTITY_AI_AND_ANIMATION_UPDATE(Entity entity, BOOL p1) { invoke<Void>(0x4C9E96473D4F1A88, entity, p1); } // 0x4C9E96473D4F1A88 0x58D9775F b1207
	NATIVE_DECL float _GET_ENTITY_ANIM_CURRENT_TIME(Entity entity, const char* animDict, const char* animName) { return invoke<float>(0x627520389E288A73, entity, animDict, animName); } // 0x627520389E288A73 b1207
	// Used in Script Function GENERIC_ITEM_HAS_ANIM_COMPLETED
	// _GET_ENTITY_*
	NATIVE_DECL float _0x8E46E18AA828334F(Entity entity, const char* animDict, const char* animClip) { return invoke<float>(0x8E46E18AA828334F, entity, animDict, animClip); } // 0x8E46E18AA828334F b1207
	// Hardcoded to return zero/false.
	NATIVE_DECL Any _0xDF8E49EA89A01DB1(Any p0, Any p1, Any p2) { return invoke<Any>(0xDF8E49EA89A01DB1, p0, p1, p2); } // 0xDF8E49EA89A01DB1 b1207
	NATIVE_DECL BOOL HAS_ANIM_EVENT_FIRED(Entity entity, Hash actionHash) { return invoke<BOOL>(0x5851CC48405F4A07, entity, actionHash); } // 0x5851CC48405F4A07 0x66571CA0 b1207
	NATIVE_DECL BOOL HAS_ENTITY_ANIM_FINISHED(Entity entity, const char* animDict, const char* animName, int p3) { return invoke<BOOL>(0xAEB40615337EF1E3, entity, animDict, animName, p3); } // 0xAEB40615337EF1E3 0x1D9CAB92 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/animations
	NATIVE_DECL BOOL PLAY_ENTITY_ANIM(Entity entity, const char* animName, const char* animDict, float p3, BOOL loop, BOOL stayInAnim, BOOL p6, float delta, Any bitset) { return invoke<BOOL>(0xDC6D22FAB76D4874, entity, animName, animDict, p3, loop, stayInAnim, p6, delta, bitset); } // 0xDC6D22FAB76D4874 0x878753D5 b1207
	NATIVE_DECL void _SET_ENTITY_ANIM_CURRENT_TIME(Entity entity, const char* animDict, const char* animName, float time) { invoke<Void>(0x11CDABDC7783B2BC, entity, animDict, animName, time); } // 0x11CDABDC7783B2BC b1207
	NATIVE_DECL void _SET_ENTITY_ANIM_SPEED(Entity entity, const char* animDict, const char* animName, float speedMultiplier) { invoke<Void>(0xEAA885BA3CEA4E4A, entity, animDict, animName, speedMultiplier); } // 0xEAA885BA3CEA4E4A b1207
	NATIVE_DECL Any STOP_ENTITY_ANIM(Entity entity, const char* animation, const char* animGroup, float p3) { return invoke<Any>(0x786591D986DE9159, entity, animation, animGroup, p3); } // 0x786591D986DE9159 0xC4769830 b1207
	NATIVE_DECL void _0x669655FFB29EF1A9(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x669655FFB29EF1A9, p0, p1, p2, p3); } // 0x669655FFB29EF1A9 b1207
	NATIVE_DECL void _ADD_ENTITY_TRACKING_TRAILS(Entity entity) { invoke<Void>(0x1AD922AB5038DEF3, entity); } // 0x1AD922AB5038DEF3 b1207
	NATIVE_DECL void _0x5826EFD6D73C4DE5(Entity entity) { invoke<Void>(0x5826EFD6D73C4DE5, entity); } // 0x5826EFD6D73C4DE5 b1207
	NATIVE_DECL void _PAUSE_ENTITY_TRACKING(Entity entity, BOOL pause) { invoke<Void>(0x36EB4D34D4A092C5, entity, pause); } // 0x36EB4D34D4A092C5 b1207
	NATIVE_DECL Any _CREATE_FOOTPATH_TRAIL(Any p0, const char* waypointRecord, BOOL bUseSnowOffset, float p3, float p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10, BOOL bInit) { return invoke<Any>(0x29BA9F78321E5A6C, p0, waypointRecord, bUseSnowOffset, p3, p4, p5, p6, p7, p8, p9, p10, bInit); } // 0x29BA9F78321E5A6C b1207
	NATIVE_DECL void _0xC76E94A78127412B(Any p0, Any p1, Any p2) { invoke<Void>(0xC76E94A78127412B, p0, p1, p2); } // 0xC76E94A78127412B b1207
	NATIVE_DECL void _0x7F20092547B4DDEA(Any p0) { invoke<Void>(0x7F20092547B4DDEA, p0); } // 0x7F20092547B4DDEA b1207
	NATIVE_DECL void _0xF41E2979D5BC5370(Any p0) { invoke<Void>(0xF41E2979D5BC5370, p0); } // 0xF41E2979D5BC5370 b1207
	NATIVE_DECL Any _0xAAACB74442C1BED3(Any p0) { return invoke<Any>(0xAAACB74442C1BED3, p0); } // 0xAAACB74442C1BED3 b1207
	NATIVE_DECL Any PIN_CLOSEST_MAP_ENTITY(Hash modelHash, float x, float y, float z, int p4) { return invoke<Any>(0x6F3068258A499E52, modelHash, x, y, z, p4); } // 0x6F3068258A499E52 b1207
	NATIVE_DECL Any PIN_CLOSEST_MAP_ENTITY(Hash modelHash, Vector3 vec, int p4) { return invoke<Any>(0x6F3068258A499E52, modelHash, vec.x, vec.y, vec.z, p4); } // 0x6F3068258A499E52 b1207
	NATIVE_DECL void _UNPIN_MAP_ENTITY(Entity entity) { invoke<Void>(0xD2B9C78537ED5759, entity); } // 0xD2B9C78537ED5759 b1207
	NATIVE_DECL BOOL IS_MAP_ENTITY_PINNED(Any p0) { return invoke<BOOL>(0x1FF441D7954F8709, p0); } // 0x1FF441D7954F8709 b1207
	NATIVE_DECL Entity _GET_PINNED_MAP_ENTITY(Any p0) { return invoke<Entity>(0x4735E2A4BB83D9DA, p0); } // 0x4735E2A4BB83D9DA b1207
	NATIVE_DECL void _0xEAB3D91D30A344F1(Any p0) { invoke<Void>(0xEAB3D91D30A344F1, p0); } // 0xEAB3D91D30A344F1 b1207
	NATIVE_DECL void _0x37CEB637BA3B1A47(Any p0) { invoke<Void>(0x37CEB637BA3B1A47, p0); } // 0x37CEB637BA3B1A47 b1207
	NATIVE_DECL Any _0x350E9211074955AF(Any p0, Any p1) { return invoke<Any>(0x350E9211074955AF, p0, p1); } // 0x350E9211074955AF b1207
	NATIVE_DECL void _0x898586729DB5221D(Any p0) { invoke<Void>(0x898586729DB5221D, p0); } // 0x898586729DB5221D b1207
	NATIVE_DECL void _0xE9E7A0BAC7F57746(Any p0, Any p1) { invoke<Void>(0xE9E7A0BAC7F57746, p0, p1); } // 0xE9E7A0BAC7F57746 b1207
}

namespace EVENT
{
	NATIVE_DECL void SET_DECISION_MAKER(Ped ped, Hash name) { invoke<Void>(0x8AE2F981CDDB8FA4, ped, name); } // 0x8AE2F981CDDB8FA4 0x19CEAC9E b1207
	NATIVE_DECL void _SET_DECISION_MAKER_DEFAULT(Ped ped) { invoke<Void>(0x6B9C5C38838FB6E6, ped); } // 0x6B9C5C38838FB6E6 b1207
	NATIVE_DECL ScrHandle _CREATE_SHOCKING_EVENT(Any* args) { return invoke<ScrHandle>(0xCA1315C33B9A2847, args); } // 0xCA1315C33B9A2847 b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	// https://github.com/femga/rdr3_discoveries/blob/master/AI/EVENTS
	NATIVE_DECL ScrHandle ADD_SHOCKING_EVENT_AT_POSITION(Hash eventType, float x, float y, float z, float p4, float p5, float p6, float p7, float p8, int p9, int p10) { return invoke<ScrHandle>(0xD9F8455409B525E9, eventType, x, y, z, p4, p5, p6, p7, p8, p9, p10); } // 0xD9F8455409B525E9 0x0B30F779 b1207
	NATIVE_DECL ScrHandle ADD_SHOCKING_EVENT_AT_POSITION(Hash eventType, Vector3 vec, float p4, float p5, float p6, float p7, float p8, int p9, int p10) { return invoke<ScrHandle>(0xD9F8455409B525E9, eventType, vec.x, vec.y, vec.z, p4, p5, p6, p7, p8, p9, p10); } // 0xD9F8455409B525E9 0x0B30F779 b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL ScrHandle ADD_SHOCKING_EVENT_FOR_ENTITY(Hash eventType, Entity entity, float p2, float p3, float p4, float p5, float p6, float p7, BOOL p8, BOOL p9, int p10, int p11) { return invoke<ScrHandle>(0x7FD8F3BE76F89422, eventType, entity, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); } // 0x7FD8F3BE76F89422 0xA81B5B71 b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL BOOL IS_SHOCKING_EVENT_IN_SPHERE(Hash eventType, float x, float y, float z, float radius) { return invoke<BOOL>(0x9DB47E16060D6354, eventType, x, y, z, radius); } // 0x9DB47E16060D6354 0x2F98823E b1207
	NATIVE_DECL BOOL IS_SHOCKING_EVENT_IN_SPHERE(Hash eventType, Vector3 vec, float radius) { return invoke<BOOL>(0x9DB47E16060D6354, eventType, vec.x, vec.y, vec.z, radius); } // 0x9DB47E16060D6354 0x2F98823E b1207
	NATIVE_DECL BOOL REMOVE_SHOCKING_EVENT(ScrHandle event) { return invoke<BOOL>(0xE8BB3CC253A34559, event); } // 0xE8BB3CC253A34559 0xF82D5A87 b1207
	NATIVE_DECL void REMOVE_ALL_SHOCKING_EVENTS(BOOL p0) { invoke<Void>(0xD47A168C2AB90DC4, p0); } // 0xD47A168C2AB90DC4 0x64DF6282 b1207
	NATIVE_DECL void _REMOVE_ALL_SHOCKING_EVENTS_IN_AREA(float x, float y, float z, float radius, BOOL p4) { invoke<Void>(0xB4C71BA9CAB097BD, x, y, z, radius, p4); } // 0xB4C71BA9CAB097BD b1207
	NATIVE_DECL void _REMOVE_ALL_SHOCKING_EVENTS_IN_AREA(Vector3 vec, float radius, BOOL p4) { invoke<Void>(0xB4C71BA9CAB097BD, vec.x, vec.y, vec.z, radius, p4); } // 0xB4C71BA9CAB097BD b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL void _REMOVE_ALL_SHOCKING_EVENTS_OF_TYPE_IN_AREA(Hash eventType, float x, float y, float z, float radius, BOOL p5) { invoke<Void>(0x6A648D42BF271DC7, eventType, x, y, z, radius, p5); } // 0x6A648D42BF271DC7 b1207
	NATIVE_DECL void _REMOVE_ALL_SHOCKING_EVENTS_OF_TYPE_IN_AREA(Hash eventType, Vector3 vec, float radius, BOOL p5) { invoke<Void>(0x6A648D42BF271DC7, eventType, vec.x, vec.y, vec.z, radius, p5); } // 0x6A648D42BF271DC7 b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL void _REMOVE_ALL_SHOCKING_EVENTS_OF_TYPE(Hash eventType, BOOL p1) { invoke<Void>(0x118873DD538490B4, eventType, p1); } // 0x118873DD538490B4 b1207
	NATIVE_DECL void REMOVE_SHOCKING_EVENT_SPAWN_BLOCKING_AREAS() { invoke<Void>(0xDB249021652420C5); } // 0xDB249021652420C5 0xA0CE89C8 b1207
	NATIVE_DECL Any _0x36D0F2BA2C0D9BDE(Entity entity, int p1) { return invoke<Any>(0x36D0F2BA2C0D9BDE, entity, p1); } // 0x36D0F2BA2C0D9BDE b1207
	// Only used in R* SP Scripts
	// Hash only used in R* Script mob3.ysc: ROBBERY
	NATIVE_DECL void _0x7C511E91738A0828(Ped ped1, Ped ped2, int p2, Hash p3) { invoke<Void>(0x7C511E91738A0828, ped1, ped2, p2, p3); } // 0x7C511E91738A0828 b1207
	NATIVE_DECL void SUPPRESS_SHOCKING_EVENTS_NEXT_FRAME() { invoke<Void>(0x84994FAD4E4E4E69); } // 0x84994FAD4E4E4E69 0x4CC674B5 b1207
	NATIVE_DECL void _0xB6F4825153920582() { invoke<Void>(0xB6F4825153920582); } // 0xB6F4825153920582 b1207
	NATIVE_DECL void _0x4B2B1A891D437CA7(Any p0) { invoke<Void>(0x4B2B1A891D437CA7, p0); } // 0x4B2B1A891D437CA7 b1207
	NATIVE_DECL void _0x9520175B35E2268D(Ped ped, int p1) { invoke<Void>(0x9520175B35E2268D, ped, p1); } // 0x9520175B35E2268D b1207
	NATIVE_DECL Any _0x18E93EBFC1FCFA48(Any p0, Any p1, Any p2) { return invoke<Any>(0x18E93EBFC1FCFA48, p0, p1, p2); } // 0x18E93EBFC1FCFA48 b1207
	NATIVE_DECL void _0x56B3410626A473E7(Any p0) { invoke<Void>(0x56B3410626A473E7, p0); } // 0x56B3410626A473E7 b1207
	// Hash: P_REGISTER05X, P_REGISTER06X, P_REGISTER03X, PLAYER_ZERO, PLAYER_THREE, A_C_HORSE_MORGAN_FLAXENCHESTNUT
	NATIVE_DECL void _0x608AD36A644A97FE(Hash p0, BOOL p1, BOOL p2) { invoke<Void>(0x608AD36A644A97FE, p0, p1, p2); } // 0x608AD36A644A97FE b1207
	NATIVE_DECL void _0x4465C3D1475BD3FD(Any p0) { invoke<Void>(0x4465C3D1475BD3FD, p0); } // 0x4465C3D1475BD3FD b1207
	NATIVE_DECL Any _0x2DD42FAD06E6F19E(Any p0, Any p1, Any p2) { return invoke<Any>(0x2DD42FAD06E6F19E, p0, p1, p2); } // 0x2DD42FAD06E6F19E b1207
	NATIVE_DECL void _0xA86B0EE9B39D15D6(Any p0) { invoke<Void>(0xA86B0EE9B39D15D6, p0); } // 0xA86B0EE9B39D15D6 b1207
	NATIVE_DECL Any _0x26054EB81AC0893B(Any p0) { return invoke<Any>(0x26054EB81AC0893B, p0); } // 0x26054EB81AC0893B b1207
	NATIVE_DECL void _SET_EVENT_TRACKER_FOR_PED(Ped ped, const char* eventName, int p2) { invoke<Void>(0xBB1E41DD3D3C6250, ped, eventName, p2); } // 0xBB1E41DD3D3C6250 b1207
	NATIVE_DECL Any _0xAD17A18215DD23D6(Any p0, Any p1, Any p2) { return invoke<Any>(0xAD17A18215DD23D6, p0, p1, p2); } // 0xAD17A18215DD23D6 b1207
	NATIVE_DECL Any _0xC6A7DC546E94FED5(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xC6A7DC546E94FED5, p0, p1, p2, p3); } // 0xC6A7DC546E94FED5 b1207
	// Returns eventType
	NATIVE_DECL Hash _0x796EECFF0C6D39BE(Ped ped, Any p1, Any p2) { return invoke<Hash>(0x796EECFF0C6D39BE, ped, p1, p2); } // 0x796EECFF0C6D39BE b1207
	NATIVE_DECL Any _0x797B3D4D92E56094(Any p0, Any p1) { return invoke<Any>(0x797B3D4D92E56094, p0, p1); } // 0x797B3D4D92E56094 b1207
	NATIVE_DECL Entity _0x822A001BCEA5BD81(Ped ped, Hash eventType, Any p2, Any p3) { return invoke<Entity>(0x822A001BCEA5BD81, ped, eventType, p2, p3); } // 0x822A001BCEA5BD81 b1207
	NATIVE_DECL Any _0x38497F139981C5C9(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x38497F139981C5C9, p0, p1, p2, p3); } // 0x38497F139981C5C9 b1207
	NATIVE_DECL Any _0x1D1B448D719415AB(Ped ped) { return invoke<Any>(0x1D1B448D719415AB, ped); } // 0x1D1B448D719415AB b1207
	NATIVE_DECL Any _0x83D43F0FD5276E4D(Any p0, Any p1) { return invoke<Any>(0x83D43F0FD5276E4D, p0, p1); } // 0x83D43F0FD5276E4D b1207
	NATIVE_DECL void _0xE28D7FC9FD32ABEB(Any p0, Any p1, Any p2) { invoke<Void>(0xE28D7FC9FD32ABEB, p0, p1, p2); } // 0xE28D7FC9FD32ABEB b1311
	NATIVE_DECL void _0x1A5C5D350068A673(Ped ped, Any p1) { invoke<Void>(0x1A5C5D350068A673, ped, p1); } // 0x1A5C5D350068A673 b1207
	NATIVE_DECL void _0xAD8F2424C6E1E3A8(Ped ped) { invoke<Void>(0xAD8F2424C6E1E3A8, ped); } // 0xAD8F2424C6E1E3A8 b1207
	NATIVE_DECL void _0xE2C2FBB7825FFC66() { invoke<Void>(0xE2C2FBB7825FFC66); } // 0xE2C2FBB7825FFC66 b1207
}

namespace FIRE
{
	// Starts a fire:
	// 
	// xyz: Location of fire
	// maxChildren: The max amount of times a fire can spread to other objects. Must be 25 or less, or the function will do nothing.
	// isGasFire: Whether or not the fire is powered by gasoline.
	NATIVE_DECL FireId START_SCRIPT_FIRE(float x, float y, float z, int p3, float p4, BOOL p5, const char* soundsetName, float p7, int p8) { return invoke<FireId>(0x6B83617E04503888, x, y, z, p3, p4, p5, soundsetName, p7, p8); } // 0x6B83617E04503888 0xE7529357 b1207
	NATIVE_DECL FireId START_SCRIPT_FIRE(Vector3 vec, int p3, float p4, BOOL p5, const char* soundsetName, float p7, int p8) { return invoke<FireId>(0x6B83617E04503888, vec.x, vec.y, vec.z, p3, p4, p5, soundsetName, p7, p8); } // 0x6B83617E04503888 0xE7529357 b1207
	NATIVE_DECL void REMOVE_SCRIPT_FIRE(FireId fireHandle) { invoke<Void>(0x790125C36E194069, fireHandle); } // 0x790125C36E194069 0x6B21FE26 b1207
	NATIVE_DECL void START_ENTITY_FIRE(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xC4DC7418A44D6822, p0, p1, p2, p3); } // 0xC4DC7418A44D6822 0x8928428E b1207
	NATIVE_DECL void STOP_ENTITY_FIRE(Any p0, Any p1) { invoke<Void>(0x8390751DC40C1E98, p0, p1); } // 0x8390751DC40C1E98 0xCE8C9066 b1207
	NATIVE_DECL BOOL IS_ENTITY_ON_FIRE(Entity entity) { return invoke<BOOL>(0x1BD7C371CE257C3E, entity); } // 0x1BD7C371CE257C3E 0x8C73E64F b1207
	NATIVE_DECL void _0x754937C28271BC65(Any p0) { invoke<Void>(0x754937C28271BC65, p0); } // 0x754937C28271BC65 b1207
	NATIVE_DECL int GET_NUMBER_OF_FIRES_IN_RANGE(float x, float y, float z, float radius) { return invoke<int>(0xF9617BC6FAE61E08, x, y, z, radius); } // 0xF9617BC6FAE61E08 0x654D93B7 b1207
	NATIVE_DECL int GET_NUMBER_OF_FIRES_IN_RANGE(Vector3 vec, float radius) { return invoke<int>(0xF9617BC6FAE61E08, vec.x, vec.y, vec.z, radius); } // 0xF9617BC6FAE61E08 0x654D93B7 b1207
	NATIVE_DECL void STOP_FIRE_IN_RANGE(float x, float y, float z, float radius) { invoke<Void>(0xDB38F247BD421708, x, y, z, radius); } // 0xDB38F247BD421708 0x725C7205 b1207
	NATIVE_DECL void STOP_FIRE_IN_RANGE(Vector3 vec, float radius) { invoke<Void>(0xDB38F247BD421708, vec.x, vec.y, vec.z, radius); } // 0xDB38F247BD421708 0x725C7205 b1207
	NATIVE_DECL void _STOP_FIRE_IN_BOX(float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) { invoke<Void>(0xB7C7BDC375AEA9A4, posX, posY, posZ, rotX, rotY, rotZ, scaleX, scaleY, scaleZ); } // 0xB7C7BDC375AEA9A4 b1207
	NATIVE_DECL void _STOP_FIRE_IN_BOX(Vector3 pos, Vector3 rot, Vector3 scale) { invoke<Void>(0xB7C7BDC375AEA9A4, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, scale.x, scale.y, scale.z); } // 0xB7C7BDC375AEA9A4 b1207
	NATIVE_DECL BOOL GET_CLOSEST_FIRE_POS(Vector3* outPosition, float x, float y, float z) { return invoke<BOOL>(0xB646FB657F448261, outPosition, x, y, z); } // 0xB646FB657F448261 0xC4977B47 b1207
	NATIVE_DECL BOOL GET_CLOSEST_FIRE_POS(Vector3* outPosition, Vector3 vec) { return invoke<BOOL>(0xB646FB657F448261, outPosition, vec.x, vec.y, vec.z); } // 0xB646FB657F448261 0xC4977B47 b1207
	NATIVE_DECL Any _0x559FC1D310813031(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { return invoke<Any>(0x559FC1D310813031, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0x559FC1D310813031 b1232
	NATIVE_DECL Any _0x41B87A6495EE13DD(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { return invoke<Any>(0x41B87A6495EE13DD, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0x41B87A6495EE13DD b1232
	NATIVE_DECL Any _0xA4454592DCF7C992(Any p0) { return invoke<Any>(0xA4454592DCF7C992, p0); } // 0xA4454592DCF7C992 b1207
	NATIVE_DECL BOOL _IS_ENTITY_CONSUMED_BY_FIRE(Entity entity) { return invoke<BOOL>(0xCDC25355C0D65963, entity); } // 0xCDC25355C0D65963 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/graphics/explosions
	// 
	// explosionType:
	// enum eExplosionTag
	// {
	// 	EXP_TAG_DONTCARE = -1,
	// 	EXP_TAG_GRENADE,
	// 	EXP_TAG_STICKYBOMB,
	// 	EXP_TAG_MOLOTOV,
	// 	EXP_TAG_MOLOTOV_VOLATILE,
	// 	EXP_TAG_HI_OCTANE,
	// 	EXP_TAG_CAR,
	// 	EXP_TAG_PLANE,
	// 	EXP_TAG_PETROL_PUMP,
	// 	EXP_TAG_DIR_STEAM,
	// 	EXP_TAG_DIR_FLAME,
	// 	EXP_TAG_DIR_WATER_HYDRANT,
	// 	EXP_TAG_BOAT,
	// 	EXP_TAG_BULLET,
	// 	EXP_TAG_SMOKEGRENADE,
	// 	EXP_TAG_BZGAS,
	// 	EXP_TAG_GAS_CANISTER,
	// 	EXP_TAG_EXTINGUISHER,
	// 	EXP_TAG_TRAIN,
	// 	EXP_TAG_DIR_FLAME_EXPLODE,
	// 	EXP_TAG_VEHICLE_BULLET,
	// 	EXP_TAG_BIRD_CRAP,
	// 	EXP_TAG_FIREWORK,
	// 	EXP_TAG_TORPEDO,
	// 	EXP_TAG_TORPEDO_UNDERWATER,
	// 	EXP_TAG_LANTERN,
	// 	EXP_TAG_DYNAMITE,
	// 	EXP_TAG_DYNAMITESTACK,
	// 	EXP_TAG_DYNAMITE_VOLATILE,
	// 	EXP_TAG_RIVER_BLAST,
	// 	EXP_TAG_PLACED_DYNAMITE,
	// 	EXP_TAG_FIRE_ARROW,
	// 	EXP_TAG_DYNAMITE_ARROW,
	// 	EXP_TAG_PHOSPHOROUS_BULLET,
	// 	EXP_TAG_LIGHTNING_STRIKE,
	// 	EXP_TAG_TRACKING_ARROW,
	// 	EXP_TAG_POISON_BOTTLE
	// };
	NATIVE_DECL void ADD_EXPLOSION(float x, float y, float z, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0x7D6F58F69DA92530, x, y, z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0x7D6F58F69DA92530 0x10AF5258 b1207
	NATIVE_DECL void ADD_EXPLOSION(Vector3 vec, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0x7D6F58F69DA92530, vec.x, vec.y, vec.z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0x7D6F58F69DA92530 0x10AF5258 b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL void ADD_OWNED_EXPLOSION(Ped ped, float x, float y, float z, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0xD84A917A64D4D016, ped, x, y, z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0xD84A917A64D4D016 0x27EE0D67 b1207
	NATIVE_DECL void ADD_OWNED_EXPLOSION(Ped ped, Vector3 vec, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0xD84A917A64D4D016, ped, vec.x, vec.y, vec.z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0xD84A917A64D4D016 0x27EE0D67 b1207
	// _ADD_EXPLOSION_*(ON ENTITY?)
	NATIVE_DECL void _0xB7DF150605EEDC9B(Entity entity, int p1, float x, float y, float z, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0xB7DF150605EEDC9B, entity, p1, x, y, z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0xB7DF150605EEDC9B b1207
	NATIVE_DECL void _0xB7DF150605EEDC9B(Entity entity, int p1, Vector3 vec, int explosionType, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0xB7DF150605EEDC9B, entity, p1, vec.x, vec.y, vec.z, explosionType, damageScale, isAudible, isInvisible, cameraShake); } // 0xB7DF150605EEDC9B b1207
	// explosionType: see ADD_EXPLOSION
	// Change explosionFx (Visual Effect) for specified explosionType
	NATIVE_DECL void ADD_EXPLOSION_WITH_USER_VFX(float x, float y, float z, int explosionType, Hash explosionFx, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0x53BA259F3A67A99E, x, y, z, explosionType, explosionFx, damageScale, isAudible, isInvisible, cameraShake); } // 0x53BA259F3A67A99E 0xCF358946 b1207
	NATIVE_DECL void ADD_EXPLOSION_WITH_USER_VFX(Vector3 vec, int explosionType, Hash explosionFx, float damageScale, BOOL isAudible, BOOL isInvisible, float cameraShake) { invoke<Void>(0x53BA259F3A67A99E, vec.x, vec.y, vec.z, explosionType, explosionFx, damageScale, isAudible, isInvisible, cameraShake); } // 0x53BA259F3A67A99E 0xCF358946 b1207
	NATIVE_DECL void _0x34AE85C7CA4857AA(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10) { invoke<Void>(0x34AE85C7CA4857AA, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x34AE85C7CA4857AA b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL BOOL IS_EXPLOSION_IN_AREA(int explosionType, float x1, float y1, float z1, float x2, float y2, float z2) { return invoke<BOOL>(0x8391BA4313A25AD3, explosionType, x1, y1, z1, x2, y2, z2); } // 0x8391BA4313A25AD3 0xFB40075B b1207
	NATIVE_DECL BOOL IS_EXPLOSION_IN_AREA(int explosionType, Vector3 vec1, Vector3 vec2) { return invoke<BOOL>(0x8391BA4313A25AD3, explosionType, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0x8391BA4313A25AD3 0xFB40075B b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL BOOL IS_EXPLOSION_ACTIVE_IN_AREA(int explosionType, float x1, float y1, float z1, float x2, float y2, float z2) { return invoke<BOOL>(0xD96E82AEBFFAAFF0, explosionType, x1, y1, z1, x2, y2, z2); } // 0xD96E82AEBFFAAFF0 0x37C388DB b1207
	NATIVE_DECL BOOL IS_EXPLOSION_ACTIVE_IN_AREA(int explosionType, Vector3 vec1, Vector3 vec2) { return invoke<BOOL>(0xD96E82AEBFFAAFF0, explosionType, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0xD96E82AEBFFAAFF0 0x37C388DB b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL BOOL IS_EXPLOSION_IN_SPHERE(int explosionType, float x, float y, float z, float radius) { return invoke<BOOL>(0xD62DD846D82CBB90, explosionType, x, y, z, radius); } // 0xD62DD846D82CBB90 0xD455A7F3 b1207
	NATIVE_DECL BOOL IS_EXPLOSION_IN_SPHERE(int explosionType, Vector3 vec, float radius) { return invoke<BOOL>(0xD62DD846D82CBB90, explosionType, vec.x, vec.y, vec.z, radius); } // 0xD62DD846D82CBB90 0xD455A7F3 b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL BOOL IS_EXPLOSION_IN_ANGLED_AREA(int explosionType, float x1, float y1, float z1, float x2, float y2, float z2, float angle) { return invoke<BOOL>(0x5AE661ECD18524C9, explosionType, x1, y1, z1, x2, y2, z2, angle); } // 0x5AE661ECD18524C9 0x0128FED9 b1207
	NATIVE_DECL BOOL IS_EXPLOSION_IN_ANGLED_AREA(int explosionType, Vector3 vec1, Vector3 vec2, float angle) { return invoke<BOOL>(0x5AE661ECD18524C9, explosionType, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, angle); } // 0x5AE661ECD18524C9 0x0128FED9 b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL BOOL _IS_EXPLOSION_IN_VOLUME(int explosionType, Volume volume) { return invoke<BOOL>(0xE24822A4CFC9107A, explosionType, volume); } // 0xE24822A4CFC9107A b1207
	// explosionType: see ADD_EXPLOSION
	NATIVE_DECL Entity GET_OWNER_OF_EXPLOSION_IN_ANGLED_AREA(int explosionType, float x1, float y1, float z1, float x2, float y2, float z2, float radius) { return invoke<Entity>(0x8002DDAB58594D78, explosionType, x1, y1, z1, x2, y2, z2, radius); } // 0x8002DDAB58594D78 0xAEC0D176 b1207
	NATIVE_DECL Entity GET_OWNER_OF_EXPLOSION_IN_ANGLED_AREA(int explosionType, Vector3 vec1, Vector3 vec2, float radius) { return invoke<Entity>(0x8002DDAB58594D78, explosionType, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, radius); } // 0x8002DDAB58594D78 0xAEC0D176 b1207
	NATIVE_DECL void _0x68F6A75FDF5A70D6(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x68F6A75FDF5A70D6, p0, p1, p2, p3); } // 0x68F6A75FDF5A70D6 b1207
	NATIVE_DECL void _0x24DB6B9F2B719043(Any p0) { invoke<Void>(0x24DB6B9F2B719043, p0); } // 0x24DB6B9F2B719043 b1207
	// Tested with fire & dynamite. Only returns true using value p1 = 1 and when the ped is affected by fire.
	NATIVE_DECL BOOL _IS_PED_SHOCKING_EVENT_ACTIVE(Ped ped, int p1) { return invoke<BOOL>(0xAB7993BA61A4674F, ped, p1); } // 0xAB7993BA61A4674F b1232
}

namespace FLOCK
{
	NATIVE_DECL float GET_SPECIES_TUNING_FLOAT_PARAM(Hash p0, int p1, int p2) { return invoke<float>(0xE108489621422F91, p0, p1, p2); } // 0xE108489621422F91 b1207
	NATIVE_DECL void SET_SPECIES_TUNING_FLOAT_PARAM(Hash p0, int p1, int p2, float p3) { invoke<Void>(0x963240B6C252BA49, p0, p1, p2, p3); } // 0x963240B6C252BA49 b1207
	NATIVE_DECL void SET_SPECIES_TUNING_BOOL_PARAM(Hash p0, int p1, int p2, BOOL p3) { invoke<Void>(0x6D1D94C2459B42EE, p0, p1, p2, p3); } // 0x6D1D94C2459B42EE b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/ANIMAL_TUNING_FLOAT_PARAMS
	NATIVE_DECL float GET_ANIMAL_TUNING_FLOAT_PARAM(Ped animal, int index) { return invoke<float>(0x4BC3ECFDA0297E27, animal, index); } // 0x4BC3ECFDA0297E27 b1207
	NATIVE_DECL void SET_ANIMAL_TUNING_FLOAT_PARAM(Ped animal, int index, float value) { invoke<Void>(0xCBDA22C87977244F, animal, index, value); } // 0xCBDA22C87977244F b1207
	NATIVE_DECL void RESET_ANIMAL_TUNING_FLOAT_PARAM(Ped animal, int index) { invoke<Void>(0xE776A195488FC520, animal, index); } // 0xE776A195488FC520 b1355
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/ANIMAL_TUNING_BOOL_PARAMS
	NATIVE_DECL BOOL GET_ANIMAL_TUNING_BOOL_PARAM(Ped animal, int index) { return invoke<BOOL>(0x1C1993824A396603, animal, index); } // 0x1C1993824A396603 b1207
	NATIVE_DECL void SET_ANIMAL_TUNING_BOOL_PARAM(Ped animal, int index, BOOL value) { invoke<Void>(0x9FF1E042FA597187, animal, index, value); } // 0x9FF1E042FA597187 b1207
	NATIVE_DECL void RESET_ANIMAL_TUNING_BOOL_PARAM(Ped animal, int index) { invoke<Void>(0x96AA1304D30E6BC3, animal, index); } // 0x96AA1304D30E6BC3 b1355
	NATIVE_DECL Any _0x8049B17BEC937662(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0x8049B17BEC937662, p0, p1, p2, p3, p4, p5, p6); } // 0x8049B17BEC937662 b1207
	NATIVE_DECL Any _0xE93415B3307208E5(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8) { return invoke<Any>(0xE93415B3307208E5, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0xE93415B3307208E5 b1207
	NATIVE_DECL Any _0x19870C40C7EE15BE(Any p0, Any p1) { return invoke<Any>(0x19870C40C7EE15BE, p0, p1); } // 0x19870C40C7EE15BE b1207
	NATIVE_DECL void _0x0816C31480764AB0(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x0816C31480764AB0, p0, p1, p2, p3); } // 0x0816C31480764AB0 b1207
	NATIVE_DECL void _0xC3D581A34BC0A1F0(Any p0, Any p1) { invoke<Void>(0xC3D581A34BC0A1F0, p0, p1); } // 0xC3D581A34BC0A1F0 b1207
	NATIVE_DECL void _0xF2CCA7B68CFAB2B9(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10, Any p11, Any p12, Any p13) { invoke<Void>(0xF2CCA7B68CFAB2B9, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); } // 0xF2CCA7B68CFAB2B9 b1207
	NATIVE_DECL void _0xFB16F08F47B83B4C(Any p0) { invoke<Void>(0xFB16F08F47B83B4C, p0); } // 0xFB16F08F47B83B4C b1207
	// Ped (horse) will run away from players and mounting will trigger them to buck until disabled.
	// Used for: REL_DOMESTICATED_ANIMAL
	NATIVE_DECL BOOL _GET_ANIMAL_IS_WILD(Ped ped) { return invoke<BOOL>(0x3B005FF0538ED2A9, ped); } // 0x3B005FF0538ED2A9 b1207
	NATIVE_DECL void _SET_ANIMAL_IS_WILD(Ped ped, BOOL toggle) { invoke<Void>(0xAEB97D84CDF3C00B, ped, toggle); } // 0xAEB97D84CDF3C00B b1207
	// enum eAnimalRarityLevel
	// {
	// 	ARL_COMMON,
	// 	ARL_RARE,
	// 	ARL_LEGENDARY,
	// 	ARL_NUMRARITYLEVELS
	// };
	NATIVE_DECL int _GET_ANIMAL_RARITY(Ped ped) { return invoke<int>(0xF8B48A361DC388AE, ped); } // 0xF8B48A361DC388AE b1207
	// rarityLevel: see _GET_ANIMAL_RARITY
	NATIVE_DECL void _SET_ANIMAL_RARITY(Ped ped, int rarityLevel) { invoke<Void>(0x8B6F0F59B1B99801, ped, rarityLevel); } // 0x8B6F0F59B1B99801 b1207
	NATIVE_DECL void _0xFF1E339CE40EAAAF(Any p0, Any p1) { invoke<Void>(0xFF1E339CE40EAAAF, p0, p1); } // 0xFF1E339CE40EAAAF b1207
	NATIVE_DECL Any _0x8D913E493BAFE0A3(Any p0) { return invoke<Any>(0x8D913E493BAFE0A3, p0); } // 0x8D913E493BAFE0A3 b1207
	NATIVE_DECL ScrHandle _CREATE_HERD() { return invoke<ScrHandle>(0xCB4EF7EDAE2E16F1); } // 0xCB4EF7EDAE2E16F1 b1207
	NATIVE_DECL void _0xE0961AED72642B80(Any p0) { invoke<Void>(0xE0961AED72642B80, p0); } // 0xE0961AED72642B80 b1207
	NATIVE_DECL void _ADD_PED_TO_FLOCK(Any p0, Ped ped) { invoke<Void>(0x933E5D31A7D13069, p0, ped); } // 0x933E5D31A7D13069 b1207
	NATIVE_DECL void _0x408D1149C5E39C1E(Any p0, Any p1) { invoke<Void>(0x408D1149C5E39C1E, p0, p1); } // 0x408D1149C5E39C1E b1207
	NATIVE_DECL Any _0x9E13ACC38BA8F9C3(Any p0, Any p1) { return invoke<Any>(0x9E13ACC38BA8F9C3, p0, p1); } // 0x9E13ACC38BA8F9C3 b1207
	NATIVE_DECL Any _0x34B9C4D86DF2C2F3(Any p0) { return invoke<Any>(0x34B9C4D86DF2C2F3, p0); } // 0x34B9C4D86DF2C2F3 b1207
	NATIVE_DECL Vector3 _0x1DA6CB02071055D5(Any p0) { return invoke<Vector3>(0x1DA6CB02071055D5, p0); } // 0x1DA6CB02071055D5 b1207
	NATIVE_DECL void _0xC95611869E14F8AF(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xC95611869E14F8AF, p0, p1, p2, p3); } // 0xC95611869E14F8AF b1207
	NATIVE_DECL Any _0x09EE00B8F858E0BE(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0x09EE00B8F858E0BE, p0, p1, p2, p3, p4, p5, p6); } // 0x09EE00B8F858E0BE b1207
	NATIVE_DECL void _0xE36D2CB540597EF7(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xE36D2CB540597EF7, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xE36D2CB540597EF7 b1207
	NATIVE_DECL Any _0xD95F04A4E73BE85E(Any p0, Any p1) { return invoke<Any>(0xD95F04A4E73BE85E, p0, p1); } // 0xD95F04A4E73BE85E b1207
	NATIVE_DECL void _0x17E3E5C46ECCD308(Any p0, Any p1, Any p2) { invoke<Void>(0x17E3E5C46ECCD308, p0, p1, p2); } // 0x17E3E5C46ECCD308 b1207
	NATIVE_DECL void _0xC72CE37081DAE625(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xC72CE37081DAE625, p0, p1, p2, p3); } // 0xC72CE37081DAE625 b1207
	NATIVE_DECL void _0x67A43EA3F6FE0076(Any p0) { invoke<Void>(0x67A43EA3F6FE0076, p0); } // 0x67A43EA3F6FE0076 b1207
	NATIVE_DECL Any _0x36486AF7DA93A464(Any p0) { return invoke<Any>(0x36486AF7DA93A464, p0); } // 0x36486AF7DA93A464 b1207
	NATIVE_DECL void _0x6C57BEA886A20C6B(Any p0, Any p1) { invoke<Void>(0x6C57BEA886A20C6B, p0, p1); } // 0x6C57BEA886A20C6B b1207
	NATIVE_DECL void _0x1520626FFAFFFA8F(Any p0, Any p1) { invoke<Void>(0x1520626FFAFFFA8F, p0, p1); } // 0x1520626FFAFFFA8F b1207
	NATIVE_DECL void _0xFA821997794F48E7(Any p0, Any p1, Any p2) { invoke<Void>(0xFA821997794F48E7, p0, p1, p2); } // 0xFA821997794F48E7 b1207
	NATIVE_DECL void _0xCC6B5AAFC87BFC7B(Any p0, Any p1, Any p2) { invoke<Void>(0xCC6B5AAFC87BFC7B, p0, p1, p2); } // 0xCC6B5AAFC87BFC7B b1207
	NATIVE_DECL void _0xFDB008B3BCF5992F(Any p0, Any p1, Any p2) { invoke<Void>(0xFDB008B3BCF5992F, p0, p1, p2); } // 0xFDB008B3BCF5992F b1207
	NATIVE_DECL void _0x2DF3D457D86F8E57(Any p0, Any p1) { invoke<Void>(0x2DF3D457D86F8E57, p0, p1); } // 0x2DF3D457D86F8E57 b1207
	NATIVE_DECL void _0x706B434FEFAD6A24(Any p0) { invoke<Void>(0x706B434FEFAD6A24, p0); } // 0x706B434FEFAD6A24 b1207
	NATIVE_DECL void _0xA881F5C77A560906(Any p0) { invoke<Void>(0xA881F5C77A560906, p0); } // 0xA881F5C77A560906 b1207
	NATIVE_DECL Any _0x53187E563F938E76(Any p0) { return invoke<Any>(0x53187E563F938E76, p0); } // 0x53187E563F938E76 b1207
}

namespace GRAPHICS
{
	NATIVE_DECL void FREE_MEMORY_FOR_MISSION_CREATOR_PHOTO() { invoke<Void>(0x7DFF8F94937D2659); } // 0x7DFF8F94937D2659 0x9E553002 b1207
	NATIVE_DECL BOOL LOAD_MISSION_CREATOR_PHOTO(Any* p0, Any p1, Any p2, Any p3) { return invoke<BOOL>(0x84F0BA7462FF8D58, p0, p1, p2, p3); } // 0x84F0BA7462FF8D58 0x56C1E488 b1207
	NATIVE_DECL int GET_STATUS_OF_LOAD_MISSION_CREATOR_PHOTO(Any* p0) { return invoke<int>(0xC71B50AE58D07369, p0); } // 0xC71B50AE58D07369 0x226B08EA b1207
	NATIVE_DECL BOOL BEGIN_TAKE_HIGH_QUALITY_PHOTO() { return invoke<BOOL>(0xA15BFFC0A01B34E1); } // 0xA15BFFC0A01B34E1 0x47B0C137 b1207
	NATIVE_DECL int GET_STATUS_OF_TAKE_HIGH_QUALITY_PHOTO() { return invoke<int>(0x4A3DA74C3CCB1725); } // 0x4A3DA74C3CCB1725 0x65376C9B b1207
	NATIVE_DECL void FREE_MEMORY_FOR_HIGH_QUALITY_PHOTO() { invoke<Void>(0xD45547D8396F002A); } // 0xD45547D8396F002A 0x9CBA682A b1207
	NATIVE_DECL void _SET_PHOTO_SELF_STAT(BOOL p0) { invoke<Void>(0x2705D18C11B61046, p0); } // 0x2705D18C11B61046 b1207
	NATIVE_DECL void _SET_PHOTO_STUDIO_STAT(int p0) { invoke<Void>(0x8E6AFF353C09652E, p0); } // 0x8E6AFF353C09652E b1207
	NATIVE_DECL void _SET_POSSE_ID_FOR_PHOTO(Any posseId) { invoke<Void>(0x564837D4A9EDE296, posseId); } // 0x564837D4A9EDE296 b1207
	NATIVE_DECL void _0x9F6D859C80708B26(BOOL p0, BOOL p1) { invoke<Void>(0x9F6D859C80708B26, p0, p1); } // 0x9F6D859C80708B26 b1311
	NATIVE_DECL BOOL IS_PHOTO_FRAME() { return invoke<BOOL>(0x86076AE35CBBE55F); } // 0x86076AE35CBBE55F b1355
	NATIVE_DECL void _SET_PHOTO_IN_PHOTOMODE_STAT(BOOL p0) { invoke<Void>(0xFA91736933AB3D93, p0); } // 0xFA91736933AB3D93 b1207
	NATIVE_DECL void _SET_PHOTO_OVERLAY_EFFECT_STAT(int p0) { invoke<Void>(0x8B3296278328B5EB, p0); } // 0x8B3296278328B5EB b1207
	// Gets set to 1 when GET_STATUS_OF_TAKE_HIGH_QUALITY_PHOTO = PHOTO_OPERATION_SUCCEEDED
	NATIVE_DECL void _0x0D5B19C34068FEE7(Any p0) { invoke<Void>(0x0D5B19C34068FEE7, p0); } // 0x0D5B19C34068FEE7 b1311
	NATIVE_DECL void _SET_PLAYER_APPEAR_IN_PHOTO(Player player) { invoke<Void>(0x75D568607909333E, player); } // 0x75D568607909333E b1232
	NATIVE_DECL void _SET_REGION_PHOTO_TAKEN_STAT(const char* p0) { invoke<Void>(0xD1031B83AC093BC7, p0); } // 0xD1031B83AC093BC7 b1207
	NATIVE_DECL void _SET_DISTRICT_PHOTO_TAKEN_STAT(const char* p0) { invoke<Void>(0x9937FACBBF267244, p0); } // 0x9937FACBBF267244 b1207
	NATIVE_DECL void _SET_STATE_PHOTO_TAKEN_STAT(const char* p0) { invoke<Void>(0x8952E857696B8A79, p0); } // 0x8952E857696B8A79 b1207
	NATIVE_DECL BOOL SAVE_HIGH_QUALITY_PHOTO(int unused) { return invoke<BOOL>(0x57639FD876B68A91, unused); } // 0x57639FD876B68A91 0x3B15D33C b1207
	// 0 = succeeded
	// 1 = getting status
	// 2 = failed
	NATIVE_DECL int GET_STATUS_OF_SAVE_HIGH_QUALITY_PHOTO() { return invoke<int>(0xD6663EC374092383); } // 0xD6663EC374092383 0xEC5D0317 b1207
	// Called together with FREE_MEMORY_FOR_LOW_QUALITY_PHOTO
	NATIVE_DECL BOOL _0x494A9874F17A7D50(Any p0) { return invoke<BOOL>(0x494A9874F17A7D50, p0); } // 0x494A9874F17A7D50 0x25D569EB b1207
	NATIVE_DECL int _GET_STATUS_OF_DRAW_LOW_QUALITY_PHOTO(Any p0) { return invoke<int>(0x13430D3D5A45F14B, p0); } // 0x13430D3D5A45F14B 0xCFCDC518 b1207
	NATIVE_DECL void FREE_MEMORY_FOR_LOW_QUALITY_PHOTO() { invoke<Void>(0x614682E715ADBAAC); } // 0x614682E715ADBAAC 0x108F36CC b1207
	NATIVE_DECL void DRAW_LOW_QUALITY_PHOTO_TO_PHONE(BOOL p0, BOOL p1) { invoke<Void>(0xF1142E5D64B47802, p0, p1); } // 0xF1142E5D64B47802 0xE9F2B68F b1207
	// Always returns 200.
	NATIVE_DECL int _GET_MAX_NUMBER_OF_LOCAL_PHOTOS() { return invoke<int>(0x8E587FCD30E05592); } // 0x8E587FCD30E05592 b1207
	NATIVE_DECL int _GET_CURRENT_NUMBER_OF_LOCAL_PHOTOS() { return invoke<int>(0x78C56B8A7B1D000C); } // 0x78C56B8A7B1D000C b1207
	NATIVE_DECL Any _0xA42EDF1E88734A7E() { return invoke<Any>(0xA42EDF1E88734A7E); } // 0xA42EDF1E88734A7E 0x199FABF0 b1207
	// 0 = succeeded
	// 1 = getting status
	// 2 = failed
	NATIVE_DECL int GET_STATUS_OF_SORTED_LIST_OPERATION() { return invoke<int>(0xB28894CD7408BD0C); } // 0xB28894CD7408BD0C 0x596B900D b1207
	NATIVE_DECL void DRAW_LIGHT_WITH_RANGE(float posX, float posY, float posZ, int colorR, int colorG, int colorB, float range, float intensity) { invoke<Void>(0xD2D9E04C0DF927F4, posX, posY, posZ, colorR, colorG, colorB, range, intensity); } // 0xD2D9E04C0DF927F4 0x6A396E9A b1207
	NATIVE_DECL void DRAW_LIGHT_WITH_RANGE(Vector3 pos, int colorR, int colorG, int colorB, float range, float intensity) { invoke<Void>(0xD2D9E04C0DF927F4, pos.x, pos.y, pos.z, colorR, colorG, colorB, range, intensity); } // 0xD2D9E04C0DF927F4 0x6A396E9A b1207
	NATIVE_DECL void UPDATE_LIGHTS_ON_ENTITY(Entity entity) { invoke<Void>(0xBDBACB52A03CC760, entity); } // 0xBDBACB52A03CC760 0xC12AC47A b1207
	NATIVE_DECL void _SET_LIGHTS_COLOR_FOR_ENTITY(Entity entity, int red, int green, int blue) { invoke<Void>(0x6EC2A67962296F49, entity, red, green, blue); } // 0x6EC2A67962296F49 b1207
	NATIVE_DECL void _SET_LIGHTS_INTENSITY_FOR_ENTITY(Entity entity, float intensity) { invoke<Void>(0x07C0F87AAC57F2E4, entity, intensity); } // 0x07C0F87AAC57F2E4 b1207
	// type must be less than or equal to 20
	NATIVE_DECL void _SET_LIGHTS_TYPE_FOR_ENTITY(Entity entity, int type) { invoke<Void>(0xAB72C67163DC4DB4, entity, type); } // 0xAB72C67163DC4DB4 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/markers/marker_types.lua
	NATIVE_DECL void _DRAW_MARKER(Hash type, float posX, float posY, float posZ, float dirX, float dirY, float dirZ, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ, int red, int green, int blue, int alpha, BOOL bobUpAndDown, BOOL faceCamera, int p19, BOOL rotate, const char* textureDict, const char* textureName, BOOL drawOnEnts) { invoke<Void>(0x2A32FAA57B937173, type, posX, posY, posZ, dirX, dirY, dirZ, rotX, rotY, rotZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, textureDict, textureName, drawOnEnts); } // 0x2A32FAA57B937173 b1207
	NATIVE_DECL void _DRAW_MARKER(Hash type, Vector3 pos, Vector3 dir, Vector3 rot, Vector3 scale, int red, int green, int blue, int alpha, BOOL bobUpAndDown, BOOL faceCamera, int p19, BOOL rotate, const char* textureDict, const char* textureName, BOOL drawOnEnts) { invoke<Void>(0x2A32FAA57B937173, type, pos.x, pos.y, pos.z, dir.x, dir.y, dir.z, rot.x, rot.y, rot.z, scale.x, scale.y, scale.z, red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, textureDict, textureName, drawOnEnts); } // 0x2A32FAA57B937173 b1207
	NATIVE_DECL int CREATE_CHECKPOINT_WITH_NAMEHASH(Hash typeHash, float posX1, float posY1, float posZ1, float posX2, float posY2, float posZ2, float radius, int red, int green, int blue, int alpha, int reserved) { return invoke<int>(0x175668836B44CBB0, typeHash, posX1, posY1, posZ1, posX2, posY2, posZ2, radius, red, green, blue, alpha, reserved); } // 0x175668836B44CBB0 b1207
	NATIVE_DECL int CREATE_CHECKPOINT_WITH_NAMEHASH(Hash typeHash, Vector3 pos1, Vector3 pos2, float radius, int red, int green, int blue, int alpha, int reserved) { return invoke<int>(0x175668836B44CBB0, typeHash, pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, radius, red, green, blue, alpha, reserved); } // 0x175668836B44CBB0 b1207
	NATIVE_DECL BOOL _DOES_CHECKPOINT_HAVE_FX(int checkpoint) { return invoke<BOOL>(0x4C11CCACB7C02B6E, checkpoint); } // 0x4C11CCACB7C02B6E b1207
	// Sets the checkpoint color.
	NATIVE_DECL void SET_CHECKPOINT_RGBA(int checkpoint, int red, int green, int blue, int alpha) { invoke<Void>(0xCAAFC225E33B1D15, checkpoint, red, green, blue, alpha); } // 0xCAAFC225E33B1D15 0xEF9C8CB3 b1207
	// Sets the checkpoint icon color.
	NATIVE_DECL void SET_CHECKPOINT_RGBA2(int checkpoint, int red, int green, int blue, int alpha) { invoke<Void>(0x99AFF17222D4DEB4, checkpoint, red, green, blue, alpha); } // 0x99AFF17222D4DEB4 0xA5456DBB b1207
	NATIVE_DECL void _0xCC3B787E73E64160(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xCC3B787E73E64160, p0, p1, p2, p3, p4); } // 0xCC3B787E73E64160 b1207
	NATIVE_DECL void _0x171C18E994C1A395(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x171C18E994C1A395, p0, p1, p2, p3, p4); } // 0x171C18E994C1A395 b1207
	NATIVE_DECL void DELETE_CHECKPOINT(int checkpoint) { invoke<Void>(0x0DED5B0C8EBAAE12, checkpoint); } // 0x0DED5B0C8EBAAE12 0xB66CF3CA b1207
	// Draws a rectangle on the screen.
	// 
	// -x: The relative X point of the center of the rectangle. (0.0-1.0, 0.0 is the left edge of the screen, 1.0 is the right edge of the screen)
	// 
	// -y: The relative Y point of the center of the rectangle. (0.0-1.0, 0.0 is the top edge of the screen, 1.0 is the bottom edge of the screen)
	// 
	// -width: The relative width of the rectangle. (0.0-1.0, 1.0 means the whole screen width)
	// 
	// -height: The relative height of the rectangle. (0.0-1.0, 1.0 means the whole screen height)
	// 
	// -R: Red part of the color. (0-255)
	// 
	// -G: Green part of the color. (0-255)
	// 
	// -B: Blue part of the color. (0-255)
	// 
	// -A: Alpha part of the color. (0-255, 0 means totally transparent, 255 means totally opaque)
	NATIVE_DECL void DRAW_RECT(float x, float y, float width, float height, int red, int green, int blue, int alpha, BOOL p8, BOOL p9) { invoke<Void>(0x405224591DF02025, x, y, width, height, red, green, blue, alpha, p8, p9); } // 0x405224591DF02025 0xDD2BFC77 b1207
	NATIVE_DECL void DRAW_RECT(Vector2 vec, float width, float height, int red, int green, int blue, int alpha, BOOL p8, BOOL p9) { invoke<Void>(0x405224591DF02025, vec.x, vec.y, width, height, red, green, blue, alpha, p8, p9); } // 0x405224591DF02025 0xDD2BFC77 b1207
	// Sets a flag defining whether or not script draw commands should continue being drawn behind the pause menu. This is usually used for draw commands that are used with a world render target.
	NATIVE_DECL void SET_SCRIPT_GFX_DRAW_BEHIND_PAUSEMENU(BOOL toggle) { invoke<Void>(0x906B86E6D7896B9E, toggle); } // 0x906B86E6D7896B9E 0xF8FBCC25 b1207
	// Sets the draw order for script draw commands.
	NATIVE_DECL void SET_SCRIPT_GFX_DRAW_ORDER(int drawOrder) { invoke<Void>(0xCFCC78391C8B3814, drawOrder); } // 0xCFCC78391C8B3814 0xADF81D24 b1207
	// Draws a 2D sprite on the screen.
	// 
	// Parameters:
	// textureDict - Name of texture dictionary to load texture from
	// 
	// textureName - Name of texture to load from texture dictionary
	// 
	// screenX/Y - Screen offset (0.5 = center)
	// scaleX/Y - Texture scaling. Negative values can be used to flip the texture on that axis. (0.5 = half)
	// 
	// heading - Texture rotation in degrees (default = 0.0) positive is clockwise, measured in degrees
	// 
	// red,green,blue - Sprite color (default = 255/255/255)
	// 
	// alpha - opacity level
	// 
	// https://github.com/femga/rdr3_discoveries/tree/master/useful_info_from_rpfs/textures
	NATIVE_DECL void DRAW_SPRITE(const char* textureDict, const char* textureName, float screenX, float screenY, float width, float height, float heading, int red, int green, int blue, int alpha, BOOL p11) { invoke<Void>(0xC9884ECADE94CB34, textureDict, textureName, screenX, screenY, width, height, heading, red, green, blue, alpha, p11); } // 0xC9884ECADE94CB34 0x1FEC16B0 b1207
	NATIVE_DECL void DRAW_SPRITE(const char* textureDict, const char* textureName, Vector2 screen, float width, float height, float heading, int red, int green, int blue, int alpha, BOOL p11) { invoke<Void>(0xC9884ECADE94CB34, textureDict, textureName, screen.x, screen.y, width, height, heading, red, green, blue, alpha, p11); } // 0xC9884ECADE94CB34 0x1FEC16B0 b1207
	NATIVE_DECL void ATTACH_TV_AUDIO_TO_ENTITY(Entity entity) { invoke<Void>(0x40866A418EB8EFDE, entity); } // 0x40866A418EB8EFDE 0x784944DB b1207
	// Probably changes tvs from being a 3d audio to being "global" audio
	NATIVE_DECL void SET_TV_AUDIO_FRONTEND(BOOL toggle) { invoke<Void>(0x64437C98FCC5F291, toggle); } // 0x64437C98FCC5F291 0x2E0DFA35 b1207
	// Hardcoded to always set x to 1280 and y to 720.
	NATIVE_DECL void GET_SCREEN_RESOLUTION(int* x, int* y) { invoke<Void>(0x66773C92835D0909, x, y); } // 0x66773C92835D0909 0x29F3572F b1207
	NATIVE_DECL void _0xA04EF43030593ABC(Any p0, Any p1) { invoke<Void>(0xA04EF43030593ABC, p0, p1); } // 0xA04EF43030593ABC b1207
	NATIVE_DECL void _0xA21AF60C9F99CCC5() { invoke<Void>(0xA21AF60C9F99CCC5); } // 0xA21AF60C9F99CCC5 b1207
	NATIVE_DECL Any _0xC28F62AC9774FC1B() { return invoke<Any>(0xC28F62AC9774FC1B); } // 0xC28F62AC9774FC1B b1207
	NATIVE_DECL void _0xEB48CE48EEC41FD4(Any p0) { invoke<Void>(0xEB48CE48EEC41FD4, p0); } // 0xEB48CE48EEC41FD4 b1207
	NATIVE_DECL BOOL GET_SCREEN_COORD_FROM_WORLD_COORD(float worldX, float worldY, float worldZ, float* screenX, float* screenY) { return invoke<BOOL>(0xCB50D7AFCC8B0EC6, worldX, worldY, worldZ, screenX, screenY); } // 0xCB50D7AFCC8B0EC6 0x1F950E4B b1207
	NATIVE_DECL BOOL GET_SCREEN_COORD_FROM_WORLD_COORD(Vector3 world, float* screenX, float* screenY) { return invoke<BOOL>(0xCB50D7AFCC8B0EC6, world.x, world.y, world.z, screenX, screenY); } // 0xCB50D7AFCC8B0EC6 0x1F950E4B b1207
	NATIVE_DECL BOOL _IS_TEXTURE_IN_DICT(Hash txdHash, Hash dict) { return invoke<BOOL>(0xA2A51869BDED733B, txdHash, dict); } // 0xA2A51869BDED733B b1207
	// Does not affect weapons, particles, fire/explosions, flashlights or the sun.
	// When set to true, all emissive textures (including ped components that have light effects), street lights, building lights, vehicle lights, etc will all be turned off.
	// 
	// state: True turns off all artificial light sources in the map: buildings, street lights, car lights, etc. False turns them back on.
	NATIVE_DECL void SET_ARTIFICIAL_LIGHTS_STATE(BOOL state) { invoke<Void>(0xB2797619A7C7747B, state); } // 0xB2797619A7C7747B 0xAA2A0EAF b1207
	NATIVE_DECL void _0x98A7CD5EA379A854() { invoke<Void>(0x98A7CD5EA379A854); } // 0x98A7CD5EA379A854 b1207
	// Used in shop scripts for CATALOG_BOOK
	// false = Normal -> [CATALOG_BOOK_SHUTDOWN]
	// true = Trees flickering? -> [CATALOG_BOOK_OPEN]
	NATIVE_DECL void _0x1A9F09AB458D49C6(BOOL p0) { invoke<Void>(0x1A9F09AB458D49C6, p0); } // 0x1A9F09AB458D49C6 b1207
	// Creates a tracked point, useful for checking the visibility of a 3D point on screen.
	NATIVE_DECL int CREATE_TRACKED_POINT() { return invoke<int>(0xFB405CB357C69CB9); } // 0xFB405CB357C69CB9 0x3129C31A b1207
	NATIVE_DECL void SET_TRACKED_POINT_INFO(int point, float x, float y, float z, float radius) { invoke<Void>(0xF6FDA3D4404D4F2C, point, x, y, z, radius); } // 0xF6FDA3D4404D4F2C 0x28689AA4 b1207
	NATIVE_DECL void SET_TRACKED_POINT_INFO(int point, Vector3 vec, float radius) { invoke<Void>(0xF6FDA3D4404D4F2C, point, vec.x, vec.y, vec.z, radius); } // 0xF6FDA3D4404D4F2C 0x28689AA4 b1207
	NATIVE_DECL BOOL IS_TRACKED_POINT_VISIBLE(int point) { return invoke<BOOL>(0xCBB056BA159FB48D, point); } // 0xCBB056BA159FB48D 0x0BFC4F64 b1207
	// Returns iNumPixels, iPixelsVisible
	NATIVE_DECL int _0xDFE332A5DA6FE7C9(int iTrackedPoint) { return invoke<int>(0xDFE332A5DA6FE7C9, iTrackedPoint); } // 0xDFE332A5DA6FE7C9 b1207
	NATIVE_DECL void DESTROY_TRACKED_POINT(int point) { invoke<Void>(0x37A59922109F8F1C, point); } // 0x37A59922109F8F1C 0x14AC675F b1207
	NATIVE_DECL BOOL _IS_TRACKED_POINT_VALID(int point) { return invoke<BOOL>(0xF2FDDCC8C6BAE1B3, point); } // 0xF2FDDCC8C6BAE1B3 b1207
	NATIVE_DECL Any _0x27219300C36A8D40(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0x27219300C36A8D40, p0, p1, p2, p3, p4); } // 0x27219300C36A8D40 b1207
	NATIVE_DECL void _0xAE7BF7CA9E4BA48D(Any p0) { invoke<Void>(0xAE7BF7CA9E4BA48D, p0); } // 0xAE7BF7CA9E4BA48D b1207
	// Adds Vegetation Blocking Zone, Added Snow Flattening veg mod Zone
	// Returns veg modifier handle
	NATIVE_DECL int _ADD_VEG_MODIFIER_ZONE(Volume volume, int p1, int flags, int p3) { return invoke<int>(0xBD3324281E8B9933, volume, p1, flags, p3); } // 0xBD3324281E8B9933 b1207
	// Returns veg modifier handle
	NATIVE_DECL int ADD_VEG_MODIFIER_SPHERE(float x, float y, float z, float radius, int modType, int flags, int p6) { return invoke<int>(0xFA50F79257745E74, x, y, z, radius, modType, flags, p6); } // 0xFA50F79257745E74 b1207
	NATIVE_DECL int ADD_VEG_MODIFIER_SPHERE(Vector3 vec, float radius, int modType, int flags, int p6) { return invoke<int>(0xFA50F79257745E74, vec.x, vec.y, vec.z, radius, modType, flags, p6); } // 0xFA50F79257745E74 b1207
	NATIVE_DECL void REMOVE_VEG_MODIFIER_SPHERE(int vegModifierHandle, int p1) { invoke<Void>(0x9CF1836C03FB67A2, vegModifierHandle, p1); } // 0x9CF1836C03FB67A2 b1207
	NATIVE_DECL void _ENABLE_STATIC_VEG_MODIFIER(Hash p0) { invoke<Void>(0xDFEA23EC90113657, p0); } // 0xDFEA23EC90113657 b1207
	NATIVE_DECL void _DISABLE_STATIC_VEG_MODIFIER(Hash p0) { invoke<Void>(0xDD0BC0EDCB2162F6, p0); } // 0xDD0BC0EDCB2162F6 b1207
	NATIVE_DECL BOOL _IS_STATIC_VEG_MODIFIER_ENABLED(Hash p0) { return invoke<BOOL>(0xDE9BAD3292AA6D5E, p0); } // 0xDE9BAD3292AA6D5E b1207
	NATIVE_DECL void _0xEC3F7F24EEEB3BA3() { invoke<Void>(0xEC3F7F24EEEB3BA3); } // 0xEC3F7F24EEEB3BA3 b1207
	NATIVE_DECL void _0x9F158A49B0D84C3C(Any p0) { invoke<Void>(0x9F158A49B0D84C3C, p0); } // 0x9F158A49B0D84C3C b1207
	NATIVE_DECL void _0x910E260AEAD855DE() { invoke<Void>(0x910E260AEAD855DE); } // 0x910E260AEAD855DE b1207
	NATIVE_DECL BOOL _CREATE_SWATCH_TEXTURE_DICT(int slots) { return invoke<BOOL>(0x3D084D5568FB4028, slots); } // 0x3D084D5568FB4028 b1207
	NATIVE_DECL void _DESTROY_SWATCH_TEXTURE_DICT() { invoke<Void>(0xDAD7FB8402651654); } // 0xDAD7FB8402651654 b1207
	// Example: https://pastebin.com/tTgpER9A
	NATIVE_DECL void _GENERATE_SWATCH_TEXTURE_DIRECTLY(int slot, Any p1) { invoke<Void>(0x646ED1A1D28487DF, slot, p1); } // 0x646ED1A1D28487DF b1207
	// Example:
	// local hash = GetHashKey("CLOTHING_ITEM_M_EYES_001_TINT_001")
	// _GENERATE_SWATCH_TEXTURE(0, hash, 0, true)
	// metapedType: see 0xEC9A1261BF0CE510
	NATIVE_DECL void _GENERATE_SWATCH_TEXTURE(int slotId, Hash componentHash, int metapedType, BOOL p3) { invoke<Void>(0x160921255327C591, slotId, componentHash, metapedType, p3); } // 0x160921255327C591 b1207
	NATIVE_DECL void CASCADE_SHADOWS_SET_CASCADE_BOUNDS(Any p0, BOOL p1, float p2, float p3, float p4, float p5, BOOL p6, float p7) { invoke<Void>(0xD9EDB2E4512D563E, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xD9EDB2E4512D563E 0x84F05943 b1207
	// When this is set to ON, shadows only draw as you get nearer.
	// 
	// When OFF, they draw from a further distance.
	NATIVE_DECL void CASCADE_SHADOWS_ENABLE_ENTITY_TRACKER(BOOL toggle) { invoke<Void>(0x8FBFD2AEB196B369, toggle); } // 0x8FBFD2AEB196B369 0xFE903D0F b1207
	// Possible values:
	// "CSM_ST_POINT"
	// "CSM_ST_LINEAR"
	// "CSM_ST_BOX3x3"
	// "CSM_ST_BOX4x4"
	// "CSM_ST_DITHER2_LINEAR"
	// "CSM_ST_CUBIC"
	// "CSM_ST_POISSON16"
	// "CSM_ST_SOFT8"
	// "CSM_ST_SOFT16"
	// "CSM_ST_SOFT32"
	// "CSM_ST_DITHER16_RPDB"
	// "CSM_ST_POISSON16_RPDB_GNORM"
	// "CSM_ST_HIGHRES_BOX4x4"
	// "CSM_ST_ESM"
	NATIVE_DECL void CASCADE_SHADOWS_SET_SHADOW_SAMPLE_TYPE(const char* type) { invoke<Void>(0xCE4774E0F9AD48D1, type); } // 0xCE4774E0F9AD48D1 0xDE10BA1F b1207
	NATIVE_DECL void CASCADE_SHADOWS_CLEAR_SHADOW_SAMPLE_TYPE() { invoke<Void>(0xF7C29D7C12C36F03); } // 0xF7C29D7C12C36F03 b1207
	NATIVE_DECL void _0x503941F65DBA24EC(Any p0) { invoke<Void>(0x503941F65DBA24EC, p0); } // 0x503941F65DBA24EC b1207
	NATIVE_DECL void _0x815653A42C5ABE76() { invoke<Void>(0x815653A42C5ABE76); } // 0x815653A42C5ABE76 b1207
	NATIVE_DECL void _0xFF8018C778349234(Any p0) { invoke<Void>(0xFF8018C778349234, p0); } // 0xFF8018C778349234 b1207
	// Sets an unknown value related to timecycles.
	NATIVE_DECL void _0x297B72E2AF094742(int unk) { invoke<Void>(0x297B72E2AF094742, unk); } // 0x297B72E2AF094742 0xD8CC7221 b1207
	NATIVE_DECL void TOGGLE_PAUSED_RENDERPHASES(BOOL toggle) { invoke<Void>(0xEF9E1C45732F55FA, toggle); } // 0xEF9E1C45732F55FA 0x30ADE541 b1207
	NATIVE_DECL BOOL GET_TOGGLE_PAUSED_RENDERPHASES_STATUS() { return invoke<BOOL>(0x86ED21BDB2791CE8); } // 0x86ED21BDB2791CE8 0xD4F5D07D b1207
	NATIVE_DECL void RESET_PAUSED_RENDERPHASES() { invoke<Void>(0xCCD9AAD85E1B559E); } // 0xCCD9AAD85E1B559E 0x0113EAE4 b1207
	NATIVE_DECL void _SET_HIDOF_ENV_BLUR_PARAMS(BOOL p0, BOOL p1, float p2, float p3, float p4, float p5) { invoke<Void>(0xCC23AA1A7CBFE840, p0, p1, p2, p3, p4, p5); } // 0xCC23AA1A7CBFE840 0x513D444B b1207
	NATIVE_DECL void _0x21F00E08CBB5F37B(Any p0) { invoke<Void>(0x21F00E08CBB5F37B, p0); } // 0x21F00E08CBB5F37B b1207
	NATIVE_DECL void _0x5AC6E0FA028369DE() { invoke<Void>(0x5AC6E0FA028369DE); } // 0x5AC6E0FA028369DE b1207
	NATIVE_DECL BOOL _0xEC3D8C228FE553D7(BOOL p0) { return invoke<BOOL>(0xEC3D8C228FE553D7, p0); } // 0xEC3D8C228FE553D7 b1207
	NATIVE_DECL void _0xF5793BB386E1FF9C(Any p0) { invoke<Void>(0xF5793BB386E1FF9C, p0); } // 0xF5793BB386E1FF9C b1207
	NATIVE_DECL void _0x5CD6A2CCE5087161(Any p0) { invoke<Void>(0x5CD6A2CCE5087161, p0); } // 0x5CD6A2CCE5087161 b1311
	NATIVE_DECL void _0xC8D0611D9A0CF5D3(Any p0) { invoke<Void>(0xC8D0611D9A0CF5D3, p0); } // 0xC8D0611D9A0CF5D3 b1207
	NATIVE_DECL float _GET_PHOTO_MODE_EXPOSURE() { return invoke<float>(0x06C0D8BB6B04A709); } // 0x06C0D8BB6B04A709 b1207
	NATIVE_DECL void _0x62B9F9A1272AED80(Any p0) { invoke<Void>(0x62B9F9A1272AED80, p0); } // 0x62B9F9A1272AED80 b1207
	NATIVE_DECL float _GET_PHOTO_MODE_CONTRAST() { return invoke<float>(0x98F4154989B81EC6); } // 0x98F4154989B81EC6 b1207
	NATIVE_DECL void _0x9229ED770975BD9E() { invoke<Void>(0x9229ED770975BD9E); } // 0x9229ED770975BD9E b1311
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/ptfx/ptfx_assets_non_looped.lua
	NATIVE_DECL int START_PARTICLE_FX_NON_LOOPED_AT_COORD(const char* effectName, float xPos, float yPos, float zPos, float xRot, float yRot, float zRot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x2E80BF72EF7C87AC, effectName, xPos, yPos, zPos, xRot, yRot, zRot, scale, xAxis, yAxis, zAxis); } // 0x2E80BF72EF7C87AC 0xDD79D679 b1207
	NATIVE_DECL int START_PARTICLE_FX_NON_LOOPED_AT_COORD(const char* effectName, Vector3 pos, Vector3 rot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x2E80BF72EF7C87AC, effectName, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, scale, xAxis, yAxis, zAxis); } // 0x2E80BF72EF7C87AC 0xDD79D679 b1207
	NATIVE_DECL BOOL START_NETWORKED_PARTICLE_FX_NON_LOOPED_AT_COORD(const char* effectName, float xPos, float yPos, float zPos, float xRot, float yRot, float zRot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<BOOL>(0xFB97618457994A62, effectName, xPos, yPos, zPos, xRot, yRot, zRot, scale, xAxis, yAxis, zAxis); } // 0xFB97618457994A62 0x633F8C48 b1207
	NATIVE_DECL BOOL START_NETWORKED_PARTICLE_FX_NON_LOOPED_AT_COORD(const char* effectName, Vector3 pos, Vector3 rot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<BOOL>(0xFB97618457994A62, effectName, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, scale, xAxis, yAxis, zAxis); } // 0xFB97618457994A62 0x633F8C48 b1207
	NATIVE_DECL BOOL START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE(const char* effectName, Ped ped, float offsetX, float offsetY, float offsetZ, float rotX, float rotY, float rotZ, int boneIndex, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0x3FAA72BD940C3AC0, effectName, ped, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, boneIndex, scale, axisX, axisY, axisZ); } // 0x3FAA72BD940C3AC0 0x53DAEF4E b1207
	NATIVE_DECL BOOL START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE(const char* effectName, Ped ped, Vector3 offset, Vector3 rot, int boneIndex, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0x3FAA72BD940C3AC0, effectName, ped, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, boneIndex, scale, axisX, axisY, axisZ); } // 0x3FAA72BD940C3AC0 0x53DAEF4E b1207
	NATIVE_DECL BOOL START_PARTICLE_FX_NON_LOOPED_ON_ENTITY(const char* effectName, Entity entity, float offsetX, float offsetY, float offsetZ, float rotX, float rotY, float rotZ, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xFF4C64C513388C12, effectName, entity, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, scale, axisX, axisY, axisZ); } // 0xFF4C64C513388C12 0x9604DAD4 b1207
	NATIVE_DECL BOOL START_PARTICLE_FX_NON_LOOPED_ON_ENTITY(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xFF4C64C513388C12, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, scale, axisX, axisY, axisZ); } // 0xFF4C64C513388C12 0x9604DAD4 b1207
	NATIVE_DECL BOOL START_NETWORKED_PARTICLE_FX_NON_LOOPED_ON_ENTITY(const char* effectName, Entity entity, float offsetX, float offsetY, float offsetZ, float rotX, float rotY, float rotZ, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xE6CFE43937061143, effectName, entity, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, scale, axisX, axisY, axisZ); } // 0xE6CFE43937061143 0x469A2B4A b1207
	NATIVE_DECL BOOL START_NETWORKED_PARTICLE_FX_NON_LOOPED_ON_ENTITY(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xE6CFE43937061143, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, scale, axisX, axisY, axisZ); } // 0xE6CFE43937061143 0x469A2B4A b1207
	NATIVE_DECL BOOL _START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE_2(const char* effectName, Ped ped, float offsetX, float offsetY, float offsetZ, float rotX, float rotY, float rotZ, int boneIndex, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xC695870B8A149B96, effectName, ped, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, boneIndex, scale, axisX, axisY, axisZ); } // 0xC695870B8A149B96 b1207
	NATIVE_DECL BOOL _START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE_2(const char* effectName, Ped ped, Vector3 offset, Vector3 rot, int boneIndex, float scale, BOOL axisX, BOOL axisY, BOOL axisZ) { return invoke<BOOL>(0xC695870B8A149B96, effectName, ped, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, boneIndex, scale, axisX, axisY, axisZ); } // 0xC695870B8A149B96 b1207
	NATIVE_DECL void SET_PARTICLE_FX_NON_LOOPED_COLOUR(float r, float g, float b) { invoke<Void>(0x60B85BED6577A35B, r, g, b); } // 0x60B85BED6577A35B 0x7B689E20 b1207
	NATIVE_DECL void SET_PARTICLE_FX_NON_LOOPED_ALPHA(float alpha) { invoke<Void>(0xE8A35938A7026CEA, alpha); } // 0xE8A35938A7026CEA 0x497EAFF2 b1311
	NATIVE_DECL void _SET_PARTICLE_FX_NON_LOOPED_EMITTER_SCALE(float p0, float p1, float p2) { invoke<Void>(0x56C392C2BD78B024, p0, p1, p2); } // 0x56C392C2BD78B024 b1311
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/ptfx/ptfx_assets_looped.lua
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_AT_COORD(const char* effectName, float x, float y, float z, float xRot, float yRot, float zRot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis, BOOL p11) { return invoke<int>(0xBA32867E86125D3A, effectName, x, y, z, xRot, yRot, zRot, scale, xAxis, yAxis, zAxis, p11); } // 0xBA32867E86125D3A 0xD348E3E6 b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_AT_COORD(const char* effectName, Vector3 vec, Vector3 rot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis, BOOL p11) { return invoke<int>(0xBA32867E86125D3A, effectName, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, scale, xAxis, yAxis, zAxis, p11); } // 0xBA32867E86125D3A 0xD348E3E6 b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_PED_BONE(const char* effectName, Ped ped, float xOffset, float yOffset, float zOffset, float xRot, float yRot, float zRot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xE689C1B1432BB8AF, effectName, ped, xOffset, yOffset, zOffset, xRot, yRot, zRot, boneIndex, scale, xAxis, yAxis, zAxis); } // 0xE689C1B1432BB8AF 0xF8FC196F b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_PED_BONE(const char* effectName, Ped ped, Vector3 offset, Vector3 rot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xE689C1B1432BB8AF, effectName, ped, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, boneIndex, scale, xAxis, yAxis, zAxis); } // 0xE689C1B1432BB8AF 0xF8FC196F b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_ENTITY(const char* effectName, Entity entity, float xOffset, float yOffset, float zOffset, float xRot, float yRot, float zRot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xBD41E1440CE39800, effectName, entity, xOffset, yOffset, zOffset, xRot, yRot, zRot, scale, xAxis, yAxis, zAxis); } // 0xBD41E1440CE39800 0x0D06FF62 b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_ENTITY(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xBD41E1440CE39800, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, scale, xAxis, yAxis, zAxis); } // 0xBD41E1440CE39800 0x0D06FF62 b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_ENTITY_BONE(const char* effectName, Entity entity, float xOffset, float yOffset, float zOffset, float xRot, float yRot, float zRot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xD3BA6EC7F2FBD5E9, effectName, entity, xOffset, yOffset, zOffset, xRot, yRot, zRot, boneIndex, scale, xAxis, yAxis, zAxis); } // 0xD3BA6EC7F2FBD5E9 0x23BF0F9B b1207
	NATIVE_DECL int START_PARTICLE_FX_LOOPED_ON_ENTITY_BONE(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0xD3BA6EC7F2FBD5E9, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, boneIndex, scale, xAxis, yAxis, zAxis); } // 0xD3BA6EC7F2FBD5E9 0x23BF0F9B b1207
	NATIVE_DECL int START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY(const char* effectName, Entity entity, float xOffset, float yOffset, float zOffset, float xRot, float yRot, float zRot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x8F90AB32E1944BDE, effectName, entity, xOffset, yOffset, zOffset, xRot, yRot, zRot, scale, xAxis, yAxis, zAxis); } // 0x8F90AB32E1944BDE 0x110752B2 b1207
	NATIVE_DECL int START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x8F90AB32E1944BDE, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, scale, xAxis, yAxis, zAxis); } // 0x8F90AB32E1944BDE 0x110752B2 b1207
	NATIVE_DECL int START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY_BONE(const char* effectName, Entity entity, float xOffset, float yOffset, float zOffset, float xRot, float yRot, float zRot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x9C56621462FFE7A6, effectName, entity, xOffset, yOffset, zOffset, xRot, yRot, zRot, boneIndex, scale, xAxis, yAxis, zAxis); } // 0x9C56621462FFE7A6 0xF478EFCF b1207
	NATIVE_DECL int START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY_BONE(const char* effectName, Entity entity, Vector3 offset, Vector3 rot, int boneIndex, float scale, BOOL xAxis, BOOL yAxis, BOOL zAxis) { return invoke<int>(0x9C56621462FFE7A6, effectName, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, boneIndex, scale, xAxis, yAxis, zAxis); } // 0x9C56621462FFE7A6 0xF478EFCF b1207
	NATIVE_DECL void STOP_PARTICLE_FX_LOOPED(int ptfxHandle, BOOL p1) { invoke<Void>(0x22970F3A088B133B, ptfxHandle, p1); } // 0x22970F3A088B133B 0xD245455B b1207
	NATIVE_DECL BOOL DOES_PARTICLE_FX_LOOPED_EXIST(int ptfxHandle) { return invoke<BOOL>(0x9DD5AFF561E88F2A, ptfxHandle); } // 0x9DD5AFF561E88F2A 0xCBF91D2A b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_OFFSETS(int ptfxHandle, float x, float y, float z, float rotX, float rotY, float rotZ) { invoke<Void>(0xD3A4A95FC94FE83B, ptfxHandle, x, y, z, rotX, rotY, rotZ); } // 0xD3A4A95FC94FE83B 0x641F7790 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_OFFSETS(int ptfxHandle, Vector3 vec, Vector3 rot) { invoke<Void>(0xD3A4A95FC94FE83B, ptfxHandle, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z); } // 0xD3A4A95FC94FE83B 0x641F7790 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_EVOLUTION(int ptfxHandle, const char* propertyName, float amount, BOOL noNetwork) { invoke<Void>(0x3674F389B0FACD80, ptfxHandle, propertyName, amount, noNetwork); } // 0x3674F389B0FACD80 0x1CBC1373 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_COLOUR(int ptfxHandle, float r, float g, float b, BOOL p4) { invoke<Void>(0x239879FC61C610CC, ptfxHandle, r, g, b, p4); } // 0x239879FC61C610CC 0x5219D530 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_ALPHA(int ptfxHandle, float alpha) { invoke<Void>(0x88786E76234F7054, ptfxHandle, alpha); } // 0x88786E76234F7054 0x5ED49BE1 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_SCALE(int ptfxHandle, float scale) { invoke<Void>(0x1A9E1C0D98D093B7, ptfxHandle, scale); } // 0x1A9E1C0D98D093B7 0x099B8B49 b1207
	NATIVE_DECL void SET_PARTICLE_FX_LOOPED_FAR_CLIP_DIST(int ptfxHandle, float range) { invoke<Void>(0x9B04D471DA0AD7AA, ptfxHandle, range); } // 0x9B04D471DA0AD7AA 0x233DE879 b1207
	// _SET_PARTICLE_FX_LOOPED_FA* - _SET_PARTICLE_FX_LOOPED_OF*
	NATIVE_DECL void _SET_PARTICLE_FX_LOOPED_UPDATE_DISTANT_SMOKE(int ptfxHandle, float scalar) { invoke<Void>(0x9DDC222D85D5AF2A, ptfxHandle, scalar); } // 0x9DDC222D85D5AF2A b1207
	NATIVE_DECL void REMOVE_PARTICLE_FX(int ptfxHandle, BOOL p1) { invoke<Void>(0x459598F579C98929, ptfxHandle, p1); } // 0x459598F579C98929 0x6BA48C7E b1207
	NATIVE_DECL void REMOVE_PARTICLE_FX_FROM_ENTITY(Entity entity) { invoke<Void>(0x92884B4A49D81325, entity); } // 0x92884B4A49D81325 0xCEDE52E9 b1207
	NATIVE_DECL void REMOVE_PARTICLE_FX_IN_RANGE(float X, float Y, float Z, float radius) { invoke<Void>(0x87B5905ECA623B68, X, Y, Z, radius); } // 0x87B5905ECA623B68 0x7EB8F275 b1207
	NATIVE_DECL void REMOVE_PARTICLE_FX_IN_RANGE(Vector3 vec, float radius) { invoke<Void>(0x87B5905ECA623B68, vec.x, vec.y, vec.z, radius); } // 0x87B5905ECA623B68 0x7EB8F275 b1207
	// fxName: see data_0/data/effects/ptfx/fxlists/
	NATIVE_DECL void USE_PARTICLE_FX_ASSET(const char* fxName) { invoke<Void>(0xA10DB07FC234DD12, fxName); } // 0xA10DB07FC234DD12 0x9C720B61 b1207
	NATIVE_DECL void SET_PARTICLE_FX_OVERRIDE(const char* oldAsset, const char* newAsset) { invoke<Void>(0xBE711A169E9C7E95, oldAsset, newAsset); } // 0xBE711A169E9C7E95 0xC92719A7 b1207
	// Resets the effect of SET_PARTICLE_FX_OVERRIDE
	NATIVE_DECL void RESET_PARTICLE_FX_OVERRIDE(const char* name) { invoke<Void>(0x274B3DABF7E72DEF, name); } // 0x274B3DABF7E72DEF 0x9E8D8B72 b1207
	// p1: AMB_ANN_COAL_CHUTE_DIVE, AMB_ANN_COAL_CHUTE
	// p2: EMIT
	// p3: either 0.0f or 1.0f
	NATIVE_DECL void _0x4FB67D172C4476F3(Entity entity, const char* p1, const char* p2, float p3) { invoke<Void>(0x4FB67D172C4476F3, entity, p1, p2, p3); } // 0x4FB67D172C4476F3 b1207
	// Related to Campfires.
	// p1: AMB_BONFIRE_MP, AMB_CAMPFIRE_LRG_MP
	NATIVE_DECL void SET_PARTICLE_FX_AMBIENT_COLOUR(Entity entity, const char* p1, float r, float g, float b) { invoke<Void>(0x3C61B52B00848C26, entity, p1, r, g, b); } // 0x3C61B52B00848C26 b1207
	// Only used in R* Script nb_stalking_hunter
	NATIVE_DECL void _0xD1472AFF30C103D6(float p0) { invoke<Void>(0xD1472AFF30C103D6, p0); } // 0xD1472AFF30C103D6 b1311
	NATIVE_DECL void SET_PARTICLE_FX_BULLET_IMPACT_SCALE(float scale) { invoke<Void>(0xA53C8D7D0F8C74D0, scale); } // 0xA53C8D7D0F8C74D0 0xC1AD5DDF b1207
	// _SET_PARTICLE_FX_*
	NATIVE_DECL void _0x8DCCC98DC0DBF9E4(float p0) { invoke<Void>(0x8DCCC98DC0DBF9E4, p0); } // 0x8DCCC98DC0DBF9E4 0x3968E915 b1207
	NATIVE_DECL void _SET_SNIPER_GLINTS_ENABLED(BOOL enabled) { invoke<Void>(0x6E8EB45A4F4460EB, enabled); } // 0x6E8EB45A4F4460EB b1207
	// _SET_PARTICLE_FX_*
	NATIVE_DECL void _0x2A1625858887D4E6(float p0) { invoke<Void>(0x2A1625858887D4E6, p0); } // 0x2A1625858887D4E6 0xE3880F5A b1207
	// _DISABLE_*
	NATIVE_DECL void _0x4046493D2EEACA0E() { invoke<Void>(0x4046493D2EEACA0E); } // 0x4046493D2EEACA0E b1207
	// https://imgur.com/a/I2swSDJ
	// 
	// Old name: _SET_PICKUP_OBJECT_GLOW_ENABLED
	NATIVE_DECL void SET_PICKUP_LIGHT(Object object, BOOL toggle) { invoke<Void>(0x7DFB49BCDB73089A, object, toggle); } // 0x7DFB49BCDB73089A b1207
	NATIVE_DECL void _BLOCK_PICKUP_OBJECT_LIGHT(Object pickupObject, BOOL toggle) { invoke<Void>(0x50C14328119E1DD1, pickupObject, toggle); } // 0x50C14328119E1DD1 b1207
	NATIVE_DECL void BLOCK_PICKUP_PLACEMENT_LIGHT(Pickup pickup, BOOL toggle) { invoke<Void>(0x0552AA3FFC5B87AA, pickup, toggle); } // 0x0552AA3FFC5B87AA b1207
	NATIVE_DECL void ALLOW_PICKUP_LIGHT_SYNC(Object pickupObject, BOOL allow) { invoke<Void>(0x7C348310A6E2FB91, pickupObject, allow); } // 0x7C348310A6E2FB91 b1207
	// Enables/disables a kind of 'shiny' effect on metals.
	NATIVE_DECL void _SET_PEARLESCENT_FX_ENABLED(Object object, BOOL toggle) { invoke<Void>(0x72E30372E7CC4415, object, toggle); } // 0x72E30372E7CC4415 b1207
	// Removes all decals in range from a position, it includes the bullet holes, blood pools, petrol...
	NATIVE_DECL void REMOVE_DECALS_IN_RANGE(float x, float y, float z, float range) { invoke<Void>(0x86DE59FA02902B40, x, y, z, range); } // 0x86DE59FA02902B40 0x06A619A0 b1207
	NATIVE_DECL void REMOVE_DECALS_IN_RANGE(Vector3 vec, float range) { invoke<Void>(0x86DE59FA02902B40, vec.x, vec.y, vec.z, range); } // 0x86DE59FA02902B40 0x06A619A0 b1207
	NATIVE_DECL void REMOVE_DECALS_FROM_OBJECT(Object obj) { invoke<Void>(0xFB8972BAE0013140, obj); } // 0xFB8972BAE0013140 0x8B67DCA7 b1207
	NATIVE_DECL int ADD_DECAL(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10, Any p11, Any p12, Any p13, Any p14, Any p15, Any p16, Any p17, Any p18, Any p19, Any p20, Any p21) { return invoke<int>(0x57CB267624EF85C0, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21); } // 0x57CB267624EF85C0 0xEAD0C412 b1207
	// https://i.imgur.com/ULQU9US.jpg
	// More rounded and small puddle
	NATIVE_DECL void _ADD_BLOOD_POOL(float x, float y, float z, BOOL unused) { invoke<Void>(0xFA2ECC78A6014D4F, x, y, z, unused); } // 0xFA2ECC78A6014D4F b1207
	NATIVE_DECL void _ADD_BLOOD_POOL(Vector3 vec, BOOL unused) { invoke<Void>(0xFA2ECC78A6014D4F, vec.x, vec.y, vec.z, unused); } // 0xFA2ECC78A6014D4F b1207
	// https://i.imgur.com/rPITUCV.jpg
	// More customizable and more like quadrants
	NATIVE_DECL void _ADD_BLOOD_POOL_2(float x, float y, float z, float p3, float size, float p5, BOOL permanent, float p7, BOOL p8) { invoke<Void>(0xF708298675ABDC6A, x, y, z, p3, size, p5, permanent, p7, p8); } // 0xF708298675ABDC6A b1207
	NATIVE_DECL void _ADD_BLOOD_POOL_2(Vector3 vec, float p3, float size, float p5, BOOL permanent, float p7, BOOL p8) { invoke<Void>(0xF708298675ABDC6A, vec.x, vec.y, vec.z, p3, size, p5, permanent, p7, p8); } // 0xF708298675ABDC6A b1207
	// Creates blood pools for the given ped in some interval for a few seconds.
	NATIVE_DECL void _ADD_BLOOD_POOLS_FOR_PED(Ped ped) { invoke<Void>(0xDFCE8CE9F3EBE93F, ped); } // 0xDFCE8CE9F3EBE93F b1207
	NATIVE_DECL void _ADD_BLOOD_POOLS_FOR_PED_WITH_PARAMS(Ped ped, float p1, float size, float p3) { invoke<Void>(0xC349EE1E6EFA494B, ped, p1, size, p3); } // 0xC349EE1E6EFA494B b1207
	NATIVE_DECL void START_PETROL_TRAIL_DECALS(Any p0, Any p1) { invoke<Void>(0x46F246D6504F0031, p0, p1); } // 0x46F246D6504F0031 0xE3938B0B b1207
	NATIVE_DECL void ADD_PETROL_TRAIL_DECAL_INFO(float x, float y, float z, float p3) { invoke<Void>(0x73354FB6D03D2E8A, x, y, z, p3); } // 0x73354FB6D03D2E8A 0xBAEC6ADD b1207
	NATIVE_DECL void ADD_PETROL_TRAIL_DECAL_INFO(Vector3 vec, float p3) { invoke<Void>(0x73354FB6D03D2E8A, vec.x, vec.y, vec.z, p3); } // 0x73354FB6D03D2E8A 0xBAEC6ADD b1207
	NATIVE_DECL void END_PETROL_TRAIL_DECALS() { invoke<Void>(0x0E126AAE933F3B56); } // 0x0E126AAE933F3B56 0xCCCA6855 b1207
	NATIVE_DECL Any _0xE63D68F455CA0B47(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0xE63D68F455CA0B47, p0, p1, p2, p3, p4, p5, p6); } // 0xE63D68F455CA0B47 b1207
	NATIVE_DECL void REMOVE_DECAL(int decal) { invoke<Void>(0x49A720552EB0BB88, decal); } // 0x49A720552EB0BB88 0xA4363188 b1207
	NATIVE_DECL BOOL IS_DECAL_ALIVE(int decal) { return invoke<BOOL>(0x3E4B4E5CF5D3EEB5, decal); } // 0x3E4B4E5CF5D3EEB5 0xCDD4A61A b1207
	// _SET_D* or _SET_E*
	NATIVE_DECL void _0x53ED07BF368EDA59() { invoke<Void>(0x53ED07BF368EDA59); } // 0x53ED07BF368EDA59 0xEAB6417C b1232
	// _SET_D* or _SET_E*
	NATIVE_DECL void _0xB032C085D9A03907() { invoke<Void>(0xB032C085D9A03907); } // 0xB032C085D9A03907 b1207
	// _DISABLE_*
	NATIVE_DECL void _0xFB680A9B33D0EDBE(BOOL p0) { invoke<Void>(0xFB680A9B33D0EDBE, p0); } // 0xFB680A9B33D0EDBE b1207
	// Used in CREATE_BEZIER_BLOOD_TRAIL_OF_TYPE
	NATIVE_DECL void _0x41F88A85A579A61D(float p0) { invoke<Void>(0x41F88A85A579A61D, p0); } // 0x41F88A85A579A61D b1207
	// p1: 0.3f in R* Scripts
	NATIVE_DECL void _BLOOD_TRAIL_FOR_WAYPOINT(const char* waypointRecording, float p1) { invoke<Void>(0xB9C92616929CC25D, waypointRecording, p1); } // 0xB9C92616929CC25D b1207
	NATIVE_DECL void _ADD_BLOOD_TRAIL_POINT(float x, float y, float z) { invoke<Void>(0xDD9DC1AB63D513CE, x, y, z); } // 0xDD9DC1AB63D513CE b1207
	NATIVE_DECL void _ADD_BLOOD_TRAIL_POINT(Vector3 vec) { invoke<Void>(0xDD9DC1AB63D513CE, vec.x, vec.y, vec.z); } // 0xDD9DC1AB63D513CE b1207
	// Used in CREATE_BEZIER_BLOOD_TRAIL_OF_TYPE
	// _ENABLE_*
	NATIVE_DECL void _0x812C1563185C6FB2() { invoke<Void>(0x812C1563185C6FB2); } // 0x812C1563185C6FB2 b1207
	// Used in CREATE_BEZIER_BLOOD_TRAIL_OF_TYPE
	NATIVE_DECL void _0x4BD66B4E3427689B(const char* p0) { invoke<Void>(0x4BD66B4E3427689B, p0); } // 0x4BD66B4E3427689B b1207
	NATIVE_DECL void _ADD_BLOOD_TRAIL_SPLAT(float x, float y, float z) { invoke<Void>(0xF5E45CB1CF965D2D, x, y, z); } // 0xF5E45CB1CF965D2D b1207
	NATIVE_DECL void _ADD_BLOOD_TRAIL_SPLAT(Vector3 vec) { invoke<Void>(0xF5E45CB1CF965D2D, vec.x, vec.y, vec.z); } // 0xF5E45CB1CF965D2D b1207
	NATIVE_DECL void _0xF2F543D48F319A3A() { invoke<Void>(0xF2F543D48F319A3A); } // 0xF2F543D48F319A3A b1207
	// _RESET_*
	NATIVE_DECL void _0x1460B644397453EB() { invoke<Void>(0x1460B644397453EB); } // 0x1460B644397453EB b1207
	// Only used in guama1 R* Script
	// Disables lod/distant lights when BOOL is set to true
	NATIVE_DECL void _DISABLE_FAR_ARTIFICIAL_LIGHTS(BOOL disable) { invoke<Void>(0xCD284E2F6AC27EE9, disable); } // 0xCD284E2F6AC27EE9 b1207
	NATIVE_DECL void _0x453D16D41FC51D3E(BOOL p0) { invoke<Void>(0x453D16D41FC51D3E, p0); } // 0x453D16D41FC51D3E b1207
	// Used in NET_CAMP_SPIRIT_ANIMAL_CLEAR_ANIMAL_VISIBILITY
	NATIVE_DECL void _0xC06F2F45A73EABCD(Entity entity) { invoke<Void>(0xC06F2F45A73EABCD, entity); } // 0xC06F2F45A73EABCD b1311
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/timecycles
	NATIVE_DECL void SET_TIMECYCLE_MODIFIER(const char* modifierName) { invoke<Void>(0xFA08722A5EA82DA7, modifierName); } // 0xFA08722A5EA82DA7 0xA81F3638 b1207
	NATIVE_DECL void SET_TIMECYCLE_MODIFIER_STRENGTH(float strength) { invoke<Void>(0xFDB74C9CC54C3F37, strength); } // 0xFDB74C9CC54C3F37 0x458F4F45 b1207
	NATIVE_DECL void SET_TRANSITION_TIMECYCLE_MODIFIER(const char* modifierName, float transition) { invoke<Void>(0xFF927A09F481D80C, modifierName, transition); } // 0xFF927A09F481D80C 0xBB2BA72A b1207
	NATIVE_DECL void SET_TRANSITION_OUT_OF_TIMECYCLE_MODIFIER(float strength) { invoke<Void>(0xBB6C707F20D955D4, strength); } // 0xBB6C707F20D955D4 0x56345F6B b1207
	NATIVE_DECL void CLEAR_TIMECYCLE_MODIFIER() { invoke<Void>(0x0E3F4AF2D63491FB); } // 0x0E3F4AF2D63491FB 0x8D8DF8EE b1207
	NATIVE_DECL int GET_TIMECYCLE_MODIFIER_INDEX() { return invoke<int>(0xA705394293E2B3D3); } // 0xA705394293E2B3D3 0x594FEEC4 b1207
	NATIVE_DECL int GET_TIMECYCLE_TRANSITION_MODIFIER_INDEX() { return invoke<int>(0x2DA67BA3C8A6755D); } // 0x2DA67BA3C8A6755D 0x03C44E4B b1207
	NATIVE_DECL void _0x67B0778C62E74423(Any p0) { invoke<Void>(0x67B0778C62E74423, p0); } // 0x67B0778C62E74423 b1207
	NATIVE_DECL void _0x6C03118E9E5C1A14(Any p0) { invoke<Void>(0x6C03118E9E5C1A14, p0); } // 0x6C03118E9E5C1A14 b1207
	// _GET_C* - _GET_E*
	NATIVE_DECL float _GET_MODIFIED_VISIBILITY_DISTANCE() { return invoke<float>(0x25CA89B2A39DCC69); } // 0x25CA89B2A39DCC69 b1207
	NATIVE_DECL void _ENABLE_EXTRA_TIMECYCLE_MODIFIER_STRENGTH(float strength) { invoke<Void>(0x6FE93BCC7BF12B63, strength); } // 0x6FE93BCC7BF12B63 b1207
	NATIVE_DECL void SET_TV_CHANNEL(int channel) { invoke<Void>(0x593FAF7FC9401A56, channel); } // 0x593FAF7FC9401A56 0x41A8A627 b1207
	NATIVE_DECL int GET_TV_CHANNEL() { return invoke<int>(0xF90FBFD68F3C59AE); } // 0xF90FBFD68F3C59AE 0x6B96145A b1207
	NATIVE_DECL void SET_TV_VOLUME(float volume) { invoke<Void>(0x73A97068787D7231, volume); } // 0x73A97068787D7231 0xF3504F4D b1207
	NATIVE_DECL void DRAW_TV_CHANNEL(float xPos, float yPos, float xScale, float yScale, float rotation, int red, int green, int blue, int alpha) { invoke<Void>(0xC0A145540254A840, xPos, yPos, xScale, yScale, rotation, red, green, blue, alpha); } // 0xC0A145540254A840 0x8129EF89 b1207
	NATIVE_DECL void DRAW_TV_CHANNEL(Vector2 pos, Vector2 scale, float rotation, int red, int green, int blue, int alpha) { invoke<Void>(0xC0A145540254A840, pos.x, pos.y, scale.x, scale.y, rotation, red, green, blue, alpha); } // 0xC0A145540254A840 0x8129EF89 b1207
	NATIVE_DECL void SET_TV_CHANNEL_PLAYLIST(int tvChannel, const char* playlistName, BOOL restart) { invoke<Void>(0xDEC6B25F5DC8925B, tvChannel, playlistName, restart); } // 0xDEC6B25F5DC8925B 0xB262DE67 b1207
	NATIVE_DECL BOOL _IS_TV_PLAYLIST_ITEM_PLAYING(Hash videoCliphash) { return invoke<BOOL>(0x4D562223E0EB65F3, videoCliphash); } // 0x4D562223E0EB65F3 0x4D1EB0FB b1207
	NATIVE_DECL Any _0x5C674EB487891F6B() { return invoke<Any>(0x5C674EB487891F6B); } // 0x5C674EB487891F6B b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void ENABLE_MOVIE_SUBTITLES(BOOL toggle) { invoke<Void>(0x6FC9B065229C0787, toggle); } // 0x6FC9B065229C0787 0xC2DEBA3D b1207
	NATIVE_DECL void _0x32DE2BFFDA43E62A() { invoke<Void>(0x32DE2BFFDA43E62A); } // 0x32DE2BFFDA43E62A b1207
	NATIVE_DECL void _0xD543487A1F12828F(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xD543487A1F12828F, p0, p1, p2, p3); } // 0xD543487A1F12828F b1207
	NATIVE_DECL void _0xD9BC98B55BCFAA9B(Any p0) { invoke<Void>(0xD9BC98B55BCFAA9B, p0); } // 0xD9BC98B55BCFAA9B b1207
	NATIVE_DECL void _0x48FE0DB54045B975(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { invoke<Void>(0x48FE0DB54045B975, p0, p1, p2, p3, p4, p5, p6); } // 0x48FE0DB54045B975 b1311
	NATIVE_DECL void _0x735762E8D7573E42(Any p0, Any p1, Any p2) { invoke<Void>(0x735762E8D7573E42, p0, p1, p2); } // 0x735762E8D7573E42 b1207
	NATIVE_DECL void _0x981C7D863980FA51() { invoke<Void>(0x981C7D863980FA51); } // 0x981C7D863980FA51 b1207
	NATIVE_DECL void _ANIMPOSTFX_PRELOAD_POSTFX(const char* effectName) { invoke<Void>(0x5199405EABFBD7F0, effectName); } // 0x5199405EABFBD7F0 b1207
	NATIVE_DECL BOOL _ANIMPOSTFX_HAS_LOADED(const char* effectName) { return invoke<BOOL>(0xBF2DD155B2ADCD0A, effectName); } // 0xBF2DD155B2ADCD0A b1207
	NATIVE_DECL void _ANIMPOSTFX_SET_TO_UNLOAD(const char* effectName) { invoke<Void>(0x37D7BDBA89F13959, effectName); } // 0x37D7BDBA89F13959 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/animpostfx
	NATIVE_DECL void ANIMPOSTFX_PLAY(const char* effectName) { invoke<Void>(0x4102732DF6B4005F, effectName); } // 0x4102732DF6B4005F 0x1D980479 b1207
	NATIVE_DECL void _ANIMPOSTFX_PLAY_TIMED(const char* effectName, int duration) { invoke<Void>(0x3A9A281FF71249E9, effectName, duration); } // 0x3A9A281FF71249E9 b1207
	NATIVE_DECL void ANIMPOSTFX_STOP(const char* effectName) { invoke<Void>(0xB4FD7446BAB2F394, effectName); } // 0xB4FD7446BAB2F394 0x06BB5CDA b1207
	// effectName2, p2 and p3 are unused
	// 
	// ANIMPOSTFX_*
	NATIVE_DECL void _0x26DD2FB0A88CC412(const char* effectName, const char* effectName2, Any p2, Any p3) { invoke<Void>(0x26DD2FB0A88CC412, effectName, effectName2, p2, p3); } // 0x26DD2FB0A88CC412 b1207
	NATIVE_DECL void _ANIMPOSTFX_CLEAR_EFFECT(const char* effectName) { invoke<Void>(0xC5CB91D65852ED7E, effectName); } // 0xC5CB91D65852ED7E b1207
	NATIVE_DECL BOOL ANIMPOSTFX_IS_RUNNING(const char* effectName) { return invoke<BOOL>(0x4A123E85D7C4CA0B, effectName); } // 0x4A123E85D7C4CA0B 0x089D5921 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0x2D4F9C852CE8A253(const char* effectName) { return invoke<BOOL>(0x2D4F9C852CE8A253, effectName); } // 0x2D4F9C852CE8A253 b1207
	NATIVE_DECL void ANIMPOSTFX_STOP_ALL() { invoke<Void>(0x66560A0D4C64FD21); } // 0x66560A0D4C64FD21 0x4E6D875B b1207
	// ANIMPOSTFX_*
	NATIVE_DECL void _0xAD74C22A541AB987(const char* effectName) { invoke<Void>(0xAD74C22A541AB987, effectName); } // 0xAD74C22A541AB987 b1207
	// must be called after ANIMPOSTFX_PLAY, strength 0.0f - 1.0f
	NATIVE_DECL void _ANIMPOSTFX_SET_STRENGTH(const char* effectName, float strength) { invoke<Void>(0xCAB4DD2D5B2B7246, effectName, strength); } // 0xCAB4DD2D5B2B7246 b1207
	// Health Core Effect Filter Potency: p1 = 1
	// Stamina Core Effect Filter Potency: p1 = 2
	// Multiple Core Effect Filter Potency: p1 = 3
	NATIVE_DECL void _ANIMPOSTFX_SET_POTENCY(const char* effectName, int p1, float potency) { invoke<Void>(0xF972F0AB16DC5260, effectName, p1, potency); } // 0xF972F0AB16DC5260 b1207
	NATIVE_DECL void _ANIMPOSTFX_SET_POSTFX_COLOR(const char* effectName, int p1, int red, int green, int blue, int alpha) { invoke<Void>(0x63011D0C7C6519E0, effectName, p1, red, green, blue, alpha); } // 0x63011D0C7C6519E0 b1311
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0xB958D97A0DFAA0C2(const char* effectName) { return invoke<BOOL>(0xB958D97A0DFAA0C2, effectName); } // 0xB958D97A0DFAA0C2 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL void _0xA201A3D0AC087C37(const char* effectName) { invoke<Void>(0xA201A3D0AC087C37, effectName); } // 0xA201A3D0AC087C37 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0xFBF161FCFEC8589E(const char* effectName, int p1, BOOL p2, BOOL* p3) { return invoke<BOOL>(0xFBF161FCFEC8589E, effectName, p1, p2, p3); } // 0xFBF161FCFEC8589E b1207
	// Known effects: MP_Trans_SceneToPhoto
	// MP_Trans_WinLose
	// SpectateFilter
	// MP_CharacterCreatorPhoto
	// MP_Trans_PhotoToScene
	// InterrogationHit
	NATIVE_DECL Hash _ANIMPOSTFX_GET_STACKHASH(const char* effectName) { return invoke<Hash>(0x842CCC9491FFCD9B, effectName); } // 0x842CCC9491FFCD9B b1207
	NATIVE_DECL void _ANIMPOSTFX_PRELOAD_POSTFX_BY_STACKHASH(Hash effectNameHash) { invoke<Void>(0xF3E039322BFBD4D8, effectNameHash); } // 0xF3E039322BFBD4D8 b1207
	NATIVE_DECL BOOL ANIMPOSTFX_IS_PRELOADING_BY_STACKHASH(Hash effectNameHash) { return invoke<BOOL>(0x59EA80079B86D8C7, effectNameHash); } // 0x59EA80079B86D8C7 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL void _0x38D9D50F2085E9B3(Hash effectNameHash) { invoke<Void>(0x38D9D50F2085E9B3, effectNameHash); } // 0x38D9D50F2085E9B3 b1207
	NATIVE_DECL void _ANIMPOSTFX_PLAY_TAG(Hash effectNameHash) { invoke<Void>(0x9B8D5D4CB8AF58B3, effectNameHash); } // 0x9B8D5D4CB8AF58B3 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL void _0xC76FC4C2FC5F4405(Hash effectNameHash) { invoke<Void>(0xC76FC4C2FC5F4405, effectNameHash); } // 0xC76FC4C2FC5F4405 b1207
	NATIVE_DECL void _ANIMPOSTFX_STOP_STACKHASH_POSTFX(Hash effectNameHash) { invoke<Void>(0xEDA5CBECF56E1386, effectNameHash); } // 0xEDA5CBECF56E1386 b1207
	NATIVE_DECL BOOL _ANIMPOSTFX_IS_TAG_PLAYING(Hash effectNameHash) { return invoke<BOOL>(0xEEF83A759AE06A27, effectNameHash); } // 0xEEF83A759AE06A27 b1207
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0xE75CDDEBF618C8FF(Hash effectNameHash) { return invoke<BOOL>(0xE75CDDEBF618C8FF, effectNameHash); } // 0xE75CDDEBF618C8FF b1207
	// ANIMPOSTFX_*
	NATIVE_DECL void _0x71845905BCCDE781(Hash effectNameHash) { invoke<Void>(0x71845905BCCDE781, effectNameHash); } // 0x71845905BCCDE781 b1207
	NATIVE_DECL BOOL ANIMPOSTFX_HAS_EVENT_TRIGGERED_BY_STACKHASH(Hash effectNameHash, int p1, BOOL p2, BOOL* p3) { return invoke<BOOL>(0x9AB192A9EF980EED, effectNameHash, p1, p2, p3); } // 0x9AB192A9EF980EED b1207
	// Returns whether the 'killFX' setting is enabled.
	// 
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0xFF584F097C17FA8F() { return invoke<BOOL>(0xFF584F097C17FA8F); } // 0xFF584F097C17FA8F b1207
	// ANIMPOSTFX_*
	NATIVE_DECL BOOL _0x3DA7A10583A4BEC0() { return invoke<BOOL>(0x3DA7A10583A4BEC0); } // 0x3DA7A10583A4BEC0 b1207
	// Doesn't actually return anything.
	// 
	// ANIMPOSTFX_*
	NATIVE_DECL Any _0xC37792A3F9C90771() { return invoke<Any>(0xC37792A3F9C90771); } // 0xC37792A3F9C90771 b1207
	NATIVE_DECL void _0xA0F4D12D6042F6D5(Any p0, Any p1) { invoke<Void>(0xA0F4D12D6042F6D5, p0, p1); } // 0xA0F4D12D6042F6D5 b1207
	NATIVE_DECL void _0x8996FA6AD9FE4E90(Any p0) { invoke<Void>(0x8996FA6AD9FE4E90, p0); } // 0x8996FA6AD9FE4E90 b1207
	NATIVE_DECL void _0xC38B4952B728397A(Vehicle vehicle, BOOL toggle) { invoke<Void>(0xC38B4952B728397A, vehicle, toggle); } // 0xC38B4952B728397A b1207
	NATIVE_DECL BOOL PEDSHOT_IS_AVAILABLE() { return invoke<BOOL>(0xAF6E67D073D2DCE2); } // 0xAF6E67D073D2DCE2 b1207
	NATIVE_DECL Any _0xFD05B1DDE83749FA(Any p0) { return invoke<Any>(0xFD05B1DDE83749FA, p0); } // 0xFD05B1DDE83749FA b1207
	NATIVE_DECL void _0xC2B8164C3BE871A4() { invoke<Void>(0xC2B8164C3BE871A4); } // 0xC2B8164C3BE871A4 b1207
	NATIVE_DECL void _0x3E2FDDBE435A8787() { invoke<Void>(0x3E2FDDBE435A8787); } // 0x3E2FDDBE435A8787 b1207
	NATIVE_DECL void _0x55285F885F662169() { invoke<Void>(0x55285F885F662169); } // 0x55285F885F662169 b1207
	NATIVE_DECL Any _0xD9C24F53631F2372(Any* p0, Ped ped, int p2) { return invoke<Any>(0xD9C24F53631F2372, p0, ped, p2); } // 0xD9C24F53631F2372 b1207
	NATIVE_DECL void _0x196D3ACBEBA4A44B(Any p0) { invoke<Void>(0x196D3ACBEBA4A44B, p0); } // 0x196D3ACBEBA4A44B b1207
	NATIVE_DECL void _0xA1A86055792FB249(Any p0) { invoke<Void>(0xA1A86055792FB249, p0); } // 0xA1A86055792FB249 b1207
	NATIVE_DECL Any _0x402E1A61D2587FCD(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0x402E1A61D2587FCD, p0, p1, p2, p3, p4, p5, p6); } // 0x402E1A61D2587FCD b1207
	NATIVE_DECL Any _0x5C9C3A466B3296A8(Any p0) { return invoke<Any>(0x5C9C3A466B3296A8, p0); } // 0x5C9C3A466B3296A8 b1207
	NATIVE_DECL Any _0xA15CCAB8AD038291(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xA15CCAB8AD038291, p0, p1, p2, p3); } // 0xA15CCAB8AD038291 b1207
	NATIVE_DECL Any _0x285438C26C732F9D() { return invoke<Any>(0x285438C26C732F9D); } // 0x285438C26C732F9D b1207
	// state: false disables artificial interior light sources for specific proxyInteriorIndex
	NATIVE_DECL void _SET_PROXY_INTERIOR_INDEX_ARTIFICIAL_LIGHTS_STATE(int proxyInteriorIndex, BOOL state) { invoke<Void>(0xBFCB17895BB99E4E, proxyInteriorIndex, state); } // 0xBFCB17895BB99E4E b1207
	NATIVE_DECL BOOL _IS_PROXY_INTERIOR_INDEX_ARTIFICIAL_LIGHTS_ENABLED(int proxyInteriorIndex) { return invoke<BOOL>(0x113857D66A9CABE6, proxyInteriorIndex); } // 0x113857D66A9CABE6 b1207
	// Returns proxyInteriorIndex
	NATIVE_DECL int _GET_PROXY_INTERIOR_INDEX(int interiorId) { return invoke<int>(0x5D1C5D8E62E8EE1C, interiorId); } // 0x5D1C5D8E62E8EE1C b1207
	NATIVE_DECL void _0x9D1B0B5066205692() { invoke<Void>(0x9D1B0B5066205692); } // 0x9D1B0B5066205692 b1207
	NATIVE_DECL void _0xC489FE31AC726512(Any p0, Any p1) { invoke<Void>(0xC489FE31AC726512, p0, p1); } // 0xC489FE31AC726512 b1207
	NATIVE_DECL void _SET_CLOUD_LAYER(float x, float y, int p2) { invoke<Void>(0xB8C984C0D47F4F07, x, y, p2); } // 0xB8C984C0D47F4F07 b1207
	NATIVE_DECL void _SET_CLOUD_LAYER(Vector2 vec, int p2) { invoke<Void>(0xB8C984C0D47F4F07, vec.x, vec.y, p2); } // 0xB8C984C0D47F4F07 b1207
	NATIVE_DECL void _SET_CLOUD_NOISE(float x, float y, float z) { invoke<Void>(0xFE7966DF01452F32, x, y, z); } // 0xFE7966DF01452F32 b1207
	NATIVE_DECL void _SET_CLOUD_NOISE(Vector3 vec) { invoke<Void>(0xFE7966DF01452F32, vec.x, vec.y, vec.z); } // 0xFE7966DF01452F32 b1207
	// Only used in finale2, smuggler2, winter4
	// _SET_CLOUD_A* - _SET_CLOUD_H*
	NATIVE_DECL void _SET_CLOUD_POSITION(float x, float y, float z) { invoke<Void>(0x10C1767B93257480, x, y, z); } // 0x10C1767B93257480 b1207
	NATIVE_DECL void _SET_CLOUD_POSITION(Vector3 vec) { invoke<Void>(0x10C1767B93257480, vec.x, vec.y, vec.z); } // 0x10C1767B93257480 b1207
	NATIVE_DECL void _SET_CLOUD_HEIGHT(float height) { invoke<Void>(0xC332C91388F5580B, height); } // 0xC332C91388F5580B b1207
	NATIVE_DECL void _0x085C5B61A0114F32(Any p0, Any p1) { invoke<Void>(0x085C5B61A0114F32, p0, p1); } // 0x085C5B61A0114F32 b1207
	NATIVE_DECL void _0x1FF8731BE1DFC0C0(Any p0, Any p1) { invoke<Void>(0x1FF8731BE1DFC0C0, p0, p1); } // 0x1FF8731BE1DFC0C0 b1207
	NATIVE_DECL Any _0xFC9B53C072F418E0() { return invoke<Any>(0xFC9B53C072F418E0); } // 0xFC9B53C072F418E0 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x94B261F1F35293E1(Any p0) { invoke<Void>(0x94B261F1F35293E1, p0); } // 0x94B261F1F35293E1 b1207
	NATIVE_DECL void ENABLE_ENTITYMASK() { invoke<Void>(0xFAAD23DE7A54FC14); } // 0xFAAD23DE7A54FC14 b1207
	NATIVE_DECL void DISABLE_ENTITYMASK() { invoke<Void>(0x5C9978A2A3DC3D0D); } // 0x5C9978A2A3DC3D0D b1207
	NATIVE_DECL void _ADD_ENTITY_TO_ENTITY_MASK(Entity entity, int mask) { invoke<Void>(0xC6F81FCD15350323, entity, mask); } // 0xC6F81FCD15350323 b1207
	NATIVE_DECL void _ADD_ENTITY_TO_ENTITY_MASK_WITH_INTENSITY(Entity entity, int mask, float intensity) { invoke<Void>(0x958DEBD9353C0935, entity, mask, intensity); } // 0x958DEBD9353C0935 b1207
	NATIVE_DECL void _REMOVE_ENTITY_FROM_ENTITY_MASK(Entity entity) { invoke<Void>(0x56A786E87FF53478, entity); } // 0x56A786E87FF53478 b1207
	NATIVE_DECL Any _0xE8A8378BF651079C(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0xE8A8378BF651079C, p0, p1, p2, p3, p4); } // 0xE8A8378BF651079C b1207
	NATIVE_DECL void _0xE92012611461A42A(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xE92012611461A42A, p0, p1, p2, p3, p4); } // 0xE92012611461A42A b1207
	NATIVE_DECL void _0x249CD6B7285536F2(Any p0, Any p1, Any p2) { invoke<Void>(0x249CD6B7285536F2, p0, p1, p2); } // 0x249CD6B7285536F2 b1207
	// Used for script function RPG_GLOBAL_STATS__PRIVATE__DEACTIVATE_STAT_FLAG - Inspiration Aura unequip
	NATIVE_DECL void _0xAF4D239B8903FCBE() { invoke<Void>(0xAF4D239B8903FCBE); } // 0xAF4D239B8903FCBE b1207
	// enum class eSnowCoverageType
	// {
	// 	Primary,
	// 	Secondary,
	// 	Xmas,
	// 	XmasSecondary // since b1232
	// };
	NATIVE_DECL void _SET_SNOW_COVERAGE_TYPE(int type) { invoke<Void>(0xF02A9C330BBFC5C7, type); } // 0xF02A9C330BBFC5C7 b1207
	NATIVE_DECL void _0x519928DF02EB5101(Any p0) { invoke<Void>(0x519928DF02EB5101, p0); } // 0x519928DF02EB5101 b1355
	NATIVE_DECL void _0x1C6306E5BC25C29C() { invoke<Void>(0x1C6306E5BC25C29C); } // 0x1C6306E5BC25C29C b1207
}

namespace GANG
{
	NATIVE_DECL BOOL NETWORK_IS_GANG_ID_VALID(Any gangId) { return invoke<BOOL>(0xD6F6ACF4392187FB, gangId); } // 0xD6F6ACF4392187FB b1207
	NATIVE_DECL BOOL NETWORK_IS_GANG_IN_SESSION(Any gangId) { return invoke<BOOL>(0x93A91A351A07360E, gangId); } // 0x93A91A351A07360E b1207
	NATIVE_DECL BOOL NETWORK_IS_GANG_ACTIVE(Any gangId) { return invoke<BOOL>(0x0F99F6436528A089, gangId); } // 0x0F99F6436528A089 b1207
	NATIVE_DECL BOOL _NETWORK_IS_GANG_OPEN(Any gangId) { return invoke<BOOL>(0xFCF96CCBD81B24C8, gangId); } // 0xFCF96CCBD81B24C8 b1207
	NATIVE_DECL Any _0x9970AE8C3D706139() { return invoke<Any>(0x9970AE8C3D706139); } // 0x9970AE8C3D706139 b1207
	NATIVE_DECL void _0xD1A226F2E05E58FC(Any p0, Any p1) { invoke<Void>(0xD1A226F2E05E58FC, p0, p1); } // 0xD1A226F2E05E58FC b1207
	NATIVE_DECL Any _0xC5BF29F4035277C2(Any p0) { return invoke<Any>(0xC5BF29F4035277C2, p0); } // 0xC5BF29F4035277C2 b1207
	NATIVE_DECL void _NETWORK_LEAVE_GANG(BOOL disband) { invoke<Void>(0x0A04A07BC3074EDB, disband); } // 0x0A04A07BC3074EDB b1207
	NATIVE_DECL void _NETWORK_KICK_GANG_MEMBER(Player player, int banTimeSeconds) { invoke<Void>(0xCD9E2D9BC52FD80F, player, banTimeSeconds); } // 0xCD9E2D9BC52FD80F b1207
	NATIVE_DECL Any _0xC0474C8BCF6787AD(Any p0) { return invoke<Any>(0xC0474C8BCF6787AD, p0); } // 0xC0474C8BCF6787AD b1207
	NATIVE_DECL BOOL NETWORK_IS_GANG_LEADER(Player player) { return invoke<BOOL>(0x424B17A7DC5C90BC, player); } // 0x424B17A7DC5C90BC b1207
	NATIVE_DECL BOOL _NETWORK_IS_GANG_MEMBER(Any gangId, Player player) { return invoke<BOOL>(0x9BE7DCB22D32CCBE, gangId, player); } // 0x9BE7DCB22D32CCBE b1207
	NATIVE_DECL BOOL NETWORK_IS_IN_SAME_GANG(Player player1, Player player2) { return invoke<BOOL>(0x3F59FE6F37869576, player1, player2); } // 0x3F59FE6F37869576 b1207
	NATIVE_DECL BOOL _NETWORK_IS_IN_MY_GANG(Player player) { return invoke<BOOL>(0x81FB74C83C2ED69F, player); } // 0x81FB74C83C2ED69F b1207
	NATIVE_DECL int NETWORK_GET_NUM_GANG_MEMBERS(Any gangId) { return invoke<int>(0x149A2751AB66AC02, gangId); } // 0x149A2751AB66AC02 b1207
	NATIVE_DECL int _NETWORK_GET_GANG_SIZE(Any gangId) { return invoke<int>(0x853B0FA4D8732C57, gangId); } // 0x853B0FA4D8732C57 b1207
	NATIVE_DECL Any _0x833D8268D51B4522(Any p0) { return invoke<Any>(0x833D8268D51B4522, p0); } // 0x833D8268D51B4522 b1207
	NATIVE_DECL Any NETWORK_GET_GANG_ID(Player player) { return invoke<Any>(0x901E0DC25080C8B9, player); } // 0x901E0DC25080C8B9 b1207
	NATIVE_DECL int _NETWORK_GET_GANG_MEMBERS(Any gangId, Any* memberHandles) { return invoke<int>(0xD1BF325C8252A982, gangId, memberHandles); } // 0xD1BF325C8252A982 b1207
	NATIVE_DECL Any _0xDA801F7F6A5278D3(Any p0) { return invoke<Any>(0xDA801F7F6A5278D3, p0); } // 0xDA801F7F6A5278D3 b1207
	NATIVE_DECL Any _0x2F7EB8B6F6AFE79C(Any p0) { return invoke<Any>(0x2F7EB8B6F6AFE79C, p0); } // 0x2F7EB8B6F6AFE79C b1207
	NATIVE_DECL Any _0x53A94294FDDCF98C(Any p0, Any p1) { return invoke<Any>(0x53A94294FDDCF98C, p0, p1); } // 0x53A94294FDDCF98C b1207
	NATIVE_DECL Player NETWORK_GET_GANG_LEADER(Any gangId) { return invoke<Player>(0x4BE6C13A45CCA8EC, gangId); } // 0x4BE6C13A45CCA8EC b1207
	NATIVE_DECL BOOL _NETWORK_GET_GANG_LEADER_HANDLE(Any gangId, Any* gamerHandle) { return invoke<BOOL>(0xCE88A261DCBBA0D9, gangId, gamerHandle); } // 0xCE88A261DCBBA0D9 b1207
	NATIVE_DECL BOOL _0x6102830F764B3DE1(Player player) { return invoke<BOOL>(0x6102830F764B3DE1, player); } // 0x6102830F764B3DE1 b1207
	NATIVE_DECL void _0xB38C256498748413() { invoke<Void>(0xB38C256498748413); } // 0xB38C256498748413 b1207
	NATIVE_DECL Any _0xE4C64CD37CB176AA(Any p0) { return invoke<Any>(0xE4C64CD37CB176AA, p0); } // 0xE4C64CD37CB176AA b1207
	NATIVE_DECL Any _0x7BAA30C9BBE8AEE7(Any p0, Any p1) { return invoke<Any>(0x7BAA30C9BBE8AEE7, p0, p1); } // 0x7BAA30C9BBE8AEE7 b1207
	NATIVE_DECL Any _0x0E5C9FB9ED5DFF1C(Any p0) { return invoke<Any>(0x0E5C9FB9ED5DFF1C, p0); } // 0x0E5C9FB9ED5DFF1C b1207
	NATIVE_DECL void _0xB22B1D9F74095382(Any p0) { invoke<Void>(0xB22B1D9F74095382, p0); } // 0xB22B1D9F74095382 b1207
	NATIVE_DECL void _0xEE4F20004D0288B7() { invoke<Void>(0xEE4F20004D0288B7); } // 0xEE4F20004D0288B7 b1207
	NATIVE_DECL void _0xAD22AB64FA428DF3(Any p0) { invoke<Void>(0xAD22AB64FA428DF3, p0); } // 0xAD22AB64FA428DF3 b1207
	NATIVE_DECL Any _0x48D82C83987E18E4(Any p0) { return invoke<Any>(0x48D82C83987E18E4, p0); } // 0x48D82C83987E18E4 b1207
	NATIVE_DECL void _0xA9CEAE8D6637FBAD(Any p0) { invoke<Void>(0xA9CEAE8D6637FBAD, p0); } // 0xA9CEAE8D6637FBAD b1207
	NATIVE_DECL Any _0x51C5EF47086AA0D7() { return invoke<Any>(0x51C5EF47086AA0D7); } // 0x51C5EF47086AA0D7 b1207
	NATIVE_DECL Any _0x644E02F24F9D4E98(Any p0, Any p1) { return invoke<Any>(0x644E02F24F9D4E98, p0, p1); } // 0x644E02F24F9D4E98 b1207
	NATIVE_DECL Any _0x3ADC71A66356D706() { return invoke<Any>(0x3ADC71A66356D706); } // 0x3ADC71A66356D706 b1207
	NATIVE_DECL Any _0xFA7C5B7E087A4CEB() { return invoke<Any>(0xFA7C5B7E087A4CEB); } // 0xFA7C5B7E087A4CEB b1207
	NATIVE_DECL Any _0x1F11702DDBD915C6(Any p0, Any p1) { return invoke<Any>(0x1F11702DDBD915C6, p0, p1); } // 0x1F11702DDBD915C6 b1207
	NATIVE_DECL Any _0x7933754F260B428A(Player player) { return invoke<Any>(0x7933754F260B428A, player); } // 0x7933754F260B428A b1207
	NATIVE_DECL Any _0xAFD3599A3CC5637D() { return invoke<Any>(0xAFD3599A3CC5637D); } // 0xAFD3599A3CC5637D b1207
	NATIVE_DECL void _0xC81A9E2C8EFD28D5(Any p0) { invoke<Void>(0xC81A9E2C8EFD28D5, p0); } // 0xC81A9E2C8EFD28D5 b1207
}

namespace GOOGLE_ANALYTICS
{
	NATIVE_DECL void _GOOGLE_ANALYTICS_PUSH_PAGE(const char* pageName) { invoke<Void>(0xD43A616AE3AC4EF6, pageName); } // 0xD43A616AE3AC4EF6 b1207
	NATIVE_DECL void _GOOGLE_ANALYTICS_POP_PAGE(const char* pageName) { invoke<Void>(0xC6DE040378364798, pageName); } // 0xC6DE040378364798 b1207
	NATIVE_DECL BOOL _GOOGLE_ANALYTICS_START_EVENT(const char* eventCategory, const char* eventAction, const char* eventLabel, int eventValue) { return invoke<BOOL>(0x1C54F031D7C0F7AC, eventCategory, eventAction, eventLabel, eventValue); } // 0x1C54F031D7C0F7AC b1355
	NATIVE_DECL BOOL _GOOGLE_ANALYTICS_END_EVENT() { return invoke<BOOL>(0x87BBCC4360A9BDE3); } // 0x87BBCC4360A9BDE3 b1355
}

namespace HUD
{
	// Enables time scale to be reduced while menus such as weapon wheel are open.
	NATIVE_DECL void _ENABLE_REDUCED_TIME_SCALE_WHILE_MENU_IS_OPEN() { invoke<Void>(0x26F6BBEA2CE3E3DC); } // 0x26F6BBEA2CE3E3DC b1207
	// Disables time scale being reduced while menus such as weapon wheel are open.
	NATIVE_DECL void _DISABLE_REDUCED_TIME_SCALE_WHILE_MENU_IS_OPEN() { invoke<Void>(0xC5C7A2F6567FCCBC); } // 0xC5C7A2F6567FCCBC b1207
	NATIVE_DECL void _ENABLE_HUD_COMPONENT_THIS_FRAME(Hash component) { invoke<Void>(0xC9CAEAEEC1256E54, component); } // 0xC9CAEAEEC1256E54 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/graphics/HUD/hud_presets
	NATIVE_DECL void _HIDE_HUD_COMPONENT(Hash component) { invoke<Void>(0x4CC5F2FC1332577F, component); } // 0x4CC5F2FC1332577F b1207
	NATIVE_DECL void _DISPLAY_HUD_COMPONENT(Hash component) { invoke<Void>(0x8BC7C1F929D07BF3, component); } // 0x8BC7C1F929D07BF3 b1207
	NATIVE_DECL Any _0x7EC0D68233E391AC(Any p0) { return invoke<Any>(0x7EC0D68233E391AC, p0); } // 0x7EC0D68233E391AC b1207
	NATIVE_DECL void _BUSYSPINNER_SET_TEXT(const char* text) { invoke<Void>(0x7F78CD75CC4539E4, text); } // 0x7F78CD75CC4539E4 b1207
	// Removes the loading prompt at the bottom right of the screen.
	NATIVE_DECL void BUSYSPINNER_OFF() { invoke<Void>(0x58F441B90EA84D06); } // 0x58F441B90EA84D06 0x94119534 b1207
	NATIVE_DECL BOOL BUSYSPINNER_IS_ON() { return invoke<BOOL>(0x823BF7B1DF613A21); } // 0x823BF7B1DF613A21 0xB8B3A5D0 b1207
	NATIVE_DECL const char* _GET_TEXT_SUBSTRING(const char* text, int position, int length) { return invoke<const char*>(0x9D7E12EC6A1EE4E5, text, position, length); } // 0x9D7E12EC6A1EE4E5 0x34A396EE b1207
	// Gets a string literal from a label name.
	NATIVE_DECL const char* _GET_LABEL_TEXT(const char* labelName) { return invoke<const char*>(0xCFEDCCAD3C5BA90D, labelName); } // 0xCFEDCCAD3C5BA90D 0x95C4B5AD b1207
	NATIVE_DECL void CLEAR_ALL_HELP_MESSAGES() { invoke<Void>(0x916ED8321F087059); } // 0x916ED8321F087059 0x9E5D9198 b1207
	NATIVE_DECL BOOL TEXT_BLOCK_IS_LOADED(const char* textBlock) { return invoke<BOOL>(0xD0976CC34002DB57, textBlock); } // 0xD0976CC34002DB57 b1207
	NATIVE_DECL BOOL _TEXT_BLOCK_IS_STREAMED(const char* textBlock) { return invoke<BOOL>(0x3CF96E16265B7DC8, textBlock); } // 0x3CF96E16265B7DC8 b1207
	NATIVE_DECL void TEXT_BLOCK_REQUEST(const char* textBlock) { invoke<Void>(0xF66090013DE648D5, textBlock); } // 0xF66090013DE648D5 b1207
	NATIVE_DECL void _TEXT_BLOCK_DELETE(const char* textBlock) { invoke<Void>(0xAA03F130A637D923, textBlock); } // 0xAA03F130A637D923 b1207
	NATIVE_DECL BOOL _DOES_TEXT_BLOCK_EXIST(const char* textDatabase) { return invoke<BOOL>(0x2C729F2B94CEA911, textDatabase); } // 0x2C729F2B94CEA911 b1207
	// Checks if the passed gxt name exists in the game files.
	NATIVE_DECL BOOL DOES_TEXT_LABEL_EXIST(const char* label) { return invoke<BOOL>(0x73C258C68D6F55B6, label); } // 0x73C258C68D6F55B6 0x6ECAE560 b1207
	NATIVE_DECL const char* _GET_LABEL_TEXT_2(const char* label) { return invoke<const char*>(0x3429670F9B9EF2D3, label); } // 0x3429670F9B9EF2D3 b1207
	NATIVE_DECL const char* _GET_TEXT_SUBSTRING_2(const char* text, int length) { return invoke<const char*>(0xD8402B858F4DDD88, text, length); } // 0xD8402B858F4DDD88 b1207
	NATIVE_DECL Any _0x806862E5D266CF38(Any p0, Any p1, Any p2) { return invoke<Any>(0x806862E5D266CF38, p0, p1, p2); } // 0x806862E5D266CF38 b1207
	// Returns the length of the string passed (much like strlen).
	NATIVE_DECL int GET_LENGTH_OF_LITERAL_STRING(const char* string) { return invoke<int>(0x481FBF588B0B76DB, string); } // 0x481FBF588B0B76DB 0x99379D55 b1207
	NATIVE_DECL int GET_LENGTH_OF_LITERAL_STRING_IN_BYTES(const char* string) { return invoke<int>(0xDC5AD6B7AB8184F5, string); } // 0xDC5AD6B7AB8184F5 0x7DBC0764 b1207
	// Returns the label text given the hash.
	// 
	// Old name: _GET_LABEL_TEXT_BY_HASH
	NATIVE_DECL const char* GET_STRING_FROM_HASH_KEY(Hash labelHash) { return invoke<const char*>(0xBD5DD5EAE2B6CE14, labelHash); } // 0xBD5DD5EAE2B6CE14 b1207
	NATIVE_DECL BOOL IS_RADAR_PREFERENCE_SWITCHED_ON() { return invoke<BOOL>(0x81E47F0EE1F2B21E); } // 0x81E47F0EE1F2B21E 0x14AEAA28 b1207
	NATIVE_DECL BOOL IS_SUBTITLE_PREFERENCE_SWITCHED_ON() { return invoke<BOOL>(0x7C4AC9573587F2DF); } // 0x7C4AC9573587F2DF 0x63BA19F5 b1355
	// If Hud should be displayed
	NATIVE_DECL void DISPLAY_HUD(BOOL toggle) { invoke<Void>(0xD63FE3AF9FB3D53F, toggle); } // 0xD63FE3AF9FB3D53F 0xD10E4E31 b1207
	NATIVE_DECL BOOL IS_HUD_HIDDEN() { return invoke<BOOL>(0x71B72B478F8189DC); } // 0x71B72B478F8189DC 0x40BADA1D b1207
	NATIVE_DECL BOOL IS_RADAR_HIDDEN() { return invoke<BOOL>(0x1B82FD5FFA4D666E); } // 0x1B82FD5FFA4D666E 0x1AB3B954 b1207
	NATIVE_DECL BOOL IS_RADAR_HIDDEN_BY_SCRIPT() { return invoke<BOOL>(0x66F35DD9D2B58579); } // 0x66F35DD9D2B58579 b1207
	// colorNameHash: https://alloc8or.re/rdr3/doc/enums/eColor.txt
	NATIVE_DECL void _GET_COLOR_FROM_NAME(Hash colorNameHash, int* red, int* green, int* blue, int* alpha) { invoke<Void>(0xB981DD2DFAF9B1C9, colorNameHash, red, green, blue, alpha); } // 0xB981DD2DFAF9B1C9 b1207
	// nullsub, this native does nothing since build 1436, use _BG_DISPLAY_TEXT (0x16794E044C9EFB58) instead.
	NATIVE_DECL void _DISPLAY_TEXT(const char* text, float xPos, float yPos) { invoke<Void>(0xD79334A4BB99BAD1, text, xPos, yPos); } // 0xD79334A4BB99BAD1 b1207
	NATIVE_DECL void _DISPLAY_TEXT(const char* text, Vector2 pos) { invoke<Void>(0xD79334A4BB99BAD1, text, pos.x, pos.y); } // 0xD79334A4BB99BAD1 b1207
	// This native does nothing since build 1436, use _BG_SET_TEXT_COLOR (0x16FA5CE47F184F1E) instead.
	NATIVE_DECL void _SET_TEXT_COLOR(int r, int g, int b, int a) { invoke<Void>(0x50A41AD966910F03, r, g, b, a); } // 0x50A41AD966910F03 b1207
	NATIVE_DECL void SET_TEXT_RENDER_ID(int renderId) { invoke<Void>(0xE550CDE128D56757, renderId); } // 0xE550CDE128D56757 0xC5C3B7F3 b1207
	NATIVE_DECL BOOL REGISTER_NAMED_RENDERTARGET(const char* name, BOOL p1) { return invoke<BOOL>(0x98AF2BB6F62BD588, name, p1); } // 0x98AF2BB6F62BD588 0xFAE5D6F0 b1207
	NATIVE_DECL BOOL IS_NAMED_RENDERTARGET_REGISTERED(const char* name) { return invoke<BOOL>(0x3EE32F7964C40FE6, name); } // 0x3EE32F7964C40FE6 0x284057F5 b1207
	NATIVE_DECL BOOL RELEASE_NAMED_RENDERTARGET(const char* name) { return invoke<BOOL>(0x0E692EE61761361F, name); } // 0x0E692EE61761361F 0xD3F6C892 b1207
	NATIVE_DECL void LINK_NAMED_RENDERTARGET(Hash modelHash) { invoke<Void>(0x2F506B8556242DDB, modelHash); } // 0x2F506B8556242DDB 0x6844C4B9 b1207
	NATIVE_DECL int GET_NAMED_RENDERTARGET_RENDER_ID(const char* name) { return invoke<int>(0xB6762A85EE29AA60, name); } // 0xB6762A85EE29AA60 0xF9D7A401 b1207
	NATIVE_DECL BOOL IS_NAMED_RENDERTARGET_LINKED(Hash modelHash) { return invoke<BOOL>(0x707032835FF09AE7, modelHash); } // 0x707032835FF09AE7 0x8B52601F b1207
	NATIVE_DECL void _0x9D37EB5003E0F2CF(Any p0, Any p1) { invoke<Void>(0x9D37EB5003E0F2CF, p0, p1); } // 0x9D37EB5003E0F2CF b1207
	NATIVE_DECL void HIDE_LOADING_ON_FADE_THIS_FRAME() { invoke<Void>(0xEA600AABAF4B9084); } // 0xEA600AABAF4B9084 0x35087963 b1207
	NATIVE_DECL void _0x052D4AC0922AF91A(Any p0, Any p1) { invoke<Void>(0x052D4AC0922AF91A, p0, p1); } // 0x052D4AC0922AF91A b1207
	NATIVE_DECL void HIDE_HUD_AND_RADAR_THIS_FRAME() { invoke<Void>(0x36CDD81627A6FCD2); } // 0x36CDD81627A6FCD2 0xB75D4AD2 b1207
	NATIVE_DECL void _0x8A59D44189AF2BC5(Any p0, Any p1) { invoke<Void>(0x8A59D44189AF2BC5, p0, p1); } // 0x8A59D44189AF2BC5 b1207
	NATIVE_DECL void _0x160825DADF1B04B3() { invoke<Void>(0x160825DADF1B04B3); } // 0x160825DADF1B04B3 b1207
	NATIVE_DECL Any _0x9C409BBC492CB5B1() { return invoke<Any>(0x9C409BBC492CB5B1); } // 0x9C409BBC492CB5B1 b1207
	NATIVE_DECL Any _0x0501D52D24EA8934(Any p0) { return invoke<Any>(0x0501D52D24EA8934, p0); } // 0x0501D52D24EA8934 b1207
	NATIVE_DECL Any _0x100157D6D7FE32CA(Any p0, Any p1) { return invoke<Any>(0x100157D6D7FE32CA, p0, p1); } // 0x100157D6D7FE32CA b1207
	NATIVE_DECL Any _0x28AE29D909C8FDCE(Any p0) { return invoke<Any>(0x28AE29D909C8FDCE, p0); } // 0x28AE29D909C8FDCE b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x2F7BB105144ACF30() { invoke<Void>(0x2F7BB105144ACF30); } // 0x2F7BB105144ACF30 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xBFFF81E12A745A5F() { invoke<Void>(0xBFFF81E12A745A5F); } // 0xBFFF81E12A745A5F b1207
	NATIVE_DECL void SET_MISSION_NAME(BOOL p0, const char* name) { invoke<Void>(0x402669A4BDAA72DA, p0, name); } // 0x402669A4BDAA72DA 0x68DCAE10 b1207
	NATIVE_DECL void SET_MISSION_NAME_FOR_UGC_MISSION(BOOL p0, const char* name) { invoke<Void>(0xD98630CE73C61E98, p0, name); } // 0xD98630CE73C61E98 0x8D9A1734 b1207
	NATIVE_DECL void _0xCE0D2F5586627CCE(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xCE0D2F5586627CCE, p0, p1, p2, p3, p4); } // 0xCE0D2F5586627CCE b1207
	NATIVE_DECL BOOL GET_HUD_SCREEN_POSITION_FROM_WORLD_POSITION(float worldX, float worldY, float worldZ, float* screenX, float* screenY) { return invoke<BOOL>(0xB39C81628EF10B42, worldX, worldY, worldZ, screenX, screenY); } // 0xB39C81628EF10B42 0xFE9A39F8 b1207
	NATIVE_DECL BOOL GET_HUD_SCREEN_POSITION_FROM_WORLD_POSITION(Vector3 world, float* screenX, float* screenY) { return invoke<BOOL>(0xB39C81628EF10B42, world.x, world.y, world.z, screenX, screenY); } // 0xB39C81628EF10B42 0xFE9A39F8 b1207
	NATIVE_DECL void _HIDE_HUD_THIS_FRAME() { invoke<Void>(0xBF4F34A85CA2970D); } // 0xBF4F34A85CA2970D b1207
	NATIVE_DECL void DISABLE_FRONTEND_THIS_FRAME() { invoke<Void>(0x56CE42A528156A67); } // 0x56CE42A528156A67 0xD86A029E b1207
	NATIVE_DECL void _0x5651516D947ABC53() { invoke<Void>(0x5651516D947ABC53); } // 0x5651516D947ABC53 b1207
	NATIVE_DECL void _ALLOW_PAUSE_MENU_WHEN_DEAD_THIS_FRAME() { invoke<Void>(0x30996422DF1EE561); } // 0x30996422DF1EE561 0x630CD8EE b1207
	NATIVE_DECL void SET_FRONTEND_ACTIVE(BOOL active) { invoke<Void>(0xCE47C21C0687EBC2, active); } // 0xCE47C21C0687EBC2 0x81E1AD32 b1207
	NATIVE_DECL BOOL IS_PAUSE_MENU_ACTIVE() { return invoke<BOOL>(0x535384D6067BA42E); } // 0x535384D6067BA42E 0xD3600591 b1207
	NATIVE_DECL void _SHOW_PLAYER_CORES(BOOL state) { invoke<Void>(0x50C803A4CD5932C5, state); } // 0x50C803A4CD5932C5 b1207
	NATIVE_DECL void _SHOW_HORSE_CORES(BOOL state) { invoke<Void>(0xD4EE21B7CC7FD350, state); } // 0xD4EE21B7CC7FD350 b1207
	NATIVE_DECL void _0x3FE4FB41EF7D2196(Any p0) { invoke<Void>(0x3FE4FB41EF7D2196, p0); } // 0x3FE4FB41EF7D2196 b1207
	NATIVE_DECL void _JOURNAL_WRITE_ENTRY(Any p0) { invoke<Void>(0x6DFDD665E416B093, p0); } // 0x6DFDD665E416B093 b1207
	NATIVE_DECL Any _JOURNAL_CAN_WRITE_ENTRY(Any p0) { return invoke<Any>(0xCF782691D91F270E, p0); } // 0xCF782691D91F270E b1207
	NATIVE_DECL Any _JOURNAL_GET_ENTRY_COUNT() { return invoke<Any>(0xE65B5DE53351BE22); } // 0xE65B5DE53351BE22 b1207
	NATIVE_DECL Any _JOURNAL_GET_ENTRY_AT_INDEX(Any p0) { return invoke<Any>(0x3D16ABD7A1FD8C96, p0); } // 0x3D16ABD7A1FD8C96 b1207
	NATIVE_DECL Any _JOURNAL_GET_GRIME_AT_INDEX(Any p0) { return invoke<Any>(0xCB5945E1B855852F, p0); } // 0xCB5945E1B855852F b1207
	NATIVE_DECL Any _JOURNAL_GET_ENTRY_INFO(Any p0, Any p1) { return invoke<Any>(0x5514C3E60673530F, p0, p1); } // 0x5514C3E60673530F b1207
	NATIVE_DECL Any _JOURNAL_GET_TEXTURE_WITH_LAYOUT(Any p0, Any p1, Any p2) { return invoke<Any>(0x62CC549B3B8EA2AA, p0, p1, p2); } // 0x62CC549B3B8EA2AA b1207
	NATIVE_DECL void _JOURNAL_MARK_READ(Any p0) { invoke<Void>(0xE4509BABE59BD24E, p0); } // 0xE4509BABE59BD24E b1207
	NATIVE_DECL void _JOURNAL_CLEAR_ALL_PROGRESS() { invoke<Void>(0xF402978DE6F88D6E); } // 0xF402978DE6F88D6E b1207
	NATIVE_DECL Any UI_REQUEST_SCENE(Any p0, Any p1) { return invoke<Any>(0xB6857100F8FD433C, p0, p1); } // 0xB6857100F8FD433C b1207
	NATIVE_DECL void _0xF1E6979C0B779985(int uiscene) { invoke<Void>(0xF1E6979C0B779985, uiscene); } // 0xF1E6979C0B779985 b1207
	NATIVE_DECL Any UI_GET_SCENE_UIOBJECT(Any p0) { return invoke<Any>(0xBE1067CD1C9570F6, p0); } // 0xBE1067CD1C9570F6 b1207
	NATIVE_DECL void UI_MOVIEVIEW_SET_RENDER_TARGET(Any p0, Any p1) { invoke<Void>(0x51DE09A2196BD951, p0, p1); } // 0x51DE09A2196BD951 b1207
	NATIVE_DECL Prompt _UI_PROMPT_CREATE(Hash inputHash, const char* labelName, Any p2, Any p3, Any p4, int p5) { return invoke<Prompt>(0x29FA7910726C3889, inputHash, labelName, p2, p3, p4, p5); } // 0x29FA7910726C3889 b1207
	NATIVE_DECL Prompt _UI_PROMPT_REGISTER_BEGIN() { return invoke<Prompt>(0x04F97DE45A519419); } // 0x04F97DE45A519419 b1207
	NATIVE_DECL void _UI_PROMPT_REGISTER_END(Prompt prompt) { invoke<Void>(0xF7AA2696A22AD8B9, prompt); } // 0xF7AA2696A22AD8B9 b1207
	// PP_Low = 0,
	// PP_Normal = 1,
	// PP_High = 2,
	// PP_MissionCritical = 3
	NATIVE_DECL void _UI_PROMPT_SET_PRIORITY(Prompt prompt, int priority) { invoke<Void>(0xCA24F528D0D16289, prompt, priority); } // 0xCA24F528D0D16289 b1207
	NATIVE_DECL Any _UI_PROMPT_SET_CONTROL_ACTION(Prompt prompt, Hash control) { return invoke<Any>(0xB5352B7494A08258, prompt, control); } // 0xB5352B7494A08258 b1207
	NATIVE_DECL void _UI_PROMPT_SET_ALLOWED_ACTION(Prompt prompt, Hash control) { invoke<Void>(0x565C1CE183CB0EAF, prompt, control); } // 0x565C1CE183CB0EAF b1207
	NATIVE_DECL void _UI_PROMPT_SET_STANDARD_MODE(Prompt prompt, BOOL releaseMode) { invoke<Void>(0xCC6656799977741B, prompt, releaseMode); } // 0xCC6656799977741B b1207
	// Params: p1 is 0
	NATIVE_DECL BOOL _UI_PROMPT_HAS_STANDARD_MODE_COMPLETED(Prompt prompt, int p1) { return invoke<BOOL>(0xC92AC953F0A982AE, prompt, p1); } // 0xC92AC953F0A982AE b1207
	NATIVE_DECL void _UI_PROMPT_SET_PRESSED_TIMED_MODE(Prompt prompt, int depletionTimeMs) { invoke<Void>(0x1473D3AF51D54276, prompt, depletionTimeMs); } // 0x1473D3AF51D54276 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_PRESSED_TIMED_MODE_COMPLETED(Prompt prompt) { return invoke<BOOL>(0x3CE854D250A88DAF, prompt); } // 0x3CE854D250A88DAF b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_PRESSED_TIMED_MODE_FAILED(Prompt prompt) { return invoke<BOOL>(0x1A17B9ECFF617562, prompt); } // 0x1A17B9ECFF617562 b1207
	NATIVE_DECL void _UI_PROMPT_SET_HOLD_MODE(Prompt prompt, int holdTimeMs) { invoke<Void>(0x94073D5CA3F16B7B, prompt, holdTimeMs); } // 0x94073D5CA3F16B7B b1207
	// Hashes: SHORT_TIMED_EVENT_MP, SHORT_TIMED_EVENT, MEDIUM_TIMED_EVENT, LONG_TIMED_EVENT, RUSTLING_CALM_TIMING, PLAYER_FOCUS_TIMING, PLAYER_REACTION_TIMING
	NATIVE_DECL void _UI_PROMPT_SET_STANDARDIZED_HOLD_MODE(Prompt prompt, Hash timedEventHash) { invoke<Void>(0x74C7D7B72ED0D3CF, prompt, timedEventHash); } // 0x74C7D7B72ED0D3CF b1207
	NATIVE_DECL void _UI_PROMPT_SET_HOLD_INDEFINITELY_MODE(Prompt prompt) { invoke<Void>(0xEA5CCF4EEB2F82D1, prompt); } // 0xEA5CCF4EEB2F82D1 b1207
	NATIVE_DECL void _UI_PROMPT_SET_HOLD_AUTO_FILL_MODE(Prompt prompt, int autoFillTimeMs, int holdTimeMs) { invoke<Void>(0x3CE932E737C145D6, prompt, autoFillTimeMs, holdTimeMs); } // 0x3CE932E737C145D6 b1207
	NATIVE_DECL void _UI_PROMPT_SET_HOLD_AUTO_FILL_WITH_DECAY_MODE(Prompt prompt, int autoFillTimeMs, int holdTimeMs) { invoke<Void>(0xA3F2149AA24F3D8E, prompt, autoFillTimeMs, holdTimeMs); } // 0xA3F2149AA24F3D8E b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_HOLD_AUTO_FILL_MODE(Prompt prompt) { return invoke<BOOL>(0x8010BEBD0D5ED5BC, prompt); } // 0x8010BEBD0D5ED5BC b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_HOLD_MODE(Prompt prompt) { return invoke<BOOL>(0xB60C9F9ED47ABB76, prompt); } // 0xB60C9F9ED47ABB76 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_HOLD_MODE_RUNNING(Prompt prompt) { return invoke<BOOL>(0xC7D70EAEF92EFF48, prompt); } // 0xC7D70EAEF92EFF48 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_HOLD_MODE_COMPLETED(Prompt prompt) { return invoke<BOOL>(0xE0F65F0640EF0617, prompt); } // 0xE0F65F0640EF0617 b1207
	NATIVE_DECL Any _0x81801291806DBC50(Any p0) { return invoke<Any>(0x81801291806DBC50, p0); } // 0x81801291806DBC50 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MODE(Prompt prompt, int mashes) { invoke<Void>(0xDF6423BF071C7F71, prompt, mashes); } // 0xDF6423BF071C7F71 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_INDEFINITELY_MODE(Prompt prompt) { invoke<Void>(0x7B66E89312727274, prompt); } // 0x7B66E89312727274 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_WITH_RESISTANCE_MODE(Prompt prompt, int mashes, float p2, float p3) { invoke<Void>(0xCD1BDFF15EFA79F5, prompt, mashes, p2, p3); } // 0xCD1BDFF15EFA79F5 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_WITH_RESISTANCE_CAN_FAIL_MODE(Prompt prompt, int mashes, float p2, float p3) { invoke<Void>(0xDC0CB602DEADBA53, prompt, mashes, p2, p3); } // 0xDC0CB602DEADBA53 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_AUTO_FILL_MODE(Prompt prompt, int autoFillTimeMs, int mashes) { invoke<Void>(0x6C39587D7CC66801, prompt, autoFillTimeMs, mashes); } // 0x6C39587D7CC66801 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MANUAL_MODE(Prompt prompt, float p1, float p2, float p3, Any p4) { invoke<Void>(0x32DF729D8BD3C1C6, prompt, p1, p2, p3, p4); } // 0x32DF729D8BD3C1C6 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MANUAL_CAN_FAIL_MODE(Prompt prompt, float p1, float p2, float p3, Any p4) { invoke<Void>(0x179DCF71F705DA20, prompt, p1, p2, p3, p4); } // 0x179DCF71F705DA20 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_MANUAL_MASH_MODE(Prompt prompt) { return invoke<BOOL>(0xA6C6A4ADB3BAC409, prompt); } // 0xA6C6A4ADB3BAC409 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_MASH_MODE(Prompt prompt) { return invoke<BOOL>(0xCD072523791DDC1B, prompt); } // 0xCD072523791DDC1B b1207
	NATIVE_DECL Any _0xB0E8599243B3F568(Any p0) { return invoke<Any>(0xB0E8599243B3F568, p0); } // 0xB0E8599243B3F568 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_MASH_MODE_COMPLETED(Prompt prompt) { return invoke<BOOL>(0x845CE958416DC473, prompt); } // 0x845CE958416DC473 b1207
	NATIVE_DECL BOOL _UI_PROMPT_HAS_MASH_MODE_FAILED(Prompt prompt) { return invoke<BOOL>(0x25B18E530CF39D6F, prompt); } // 0x25B18E530CF39D6F b1207
	NATIVE_DECL float _UI_PROMPT_GET_MASH_MODE_PROGRESS(Prompt prompt) { return invoke<float>(0x8A9585293863B8A5, prompt); } // 0x8A9585293863B8A5 b1207
	// standard (prompt not held) rate: (1f / 128f)
	// fast (prompt held) rate: (1f / 64f)
	// punitive (been hit) rate: (1f / 128f)
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MANUAL_MODE_INCREASE_PER_PRESS(Prompt prompt, float rate) { invoke<Void>(0xA0D1D79C6036A855, prompt, rate); } // 0xA0D1D79C6036A855 b1207
	// standard (prompt not held) rate: 0.035f
	// fast (prompt held) rate: 0.015f
	// punitive (been hit) rate: 0.14f
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MANUAL_MODE_DECAY_SPEED(Prompt prompt, float speed) { invoke<Void>(0x7D393C247FB9B431, prompt, speed); } // 0x7D393C247FB9B431 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MASH_MANUAL_MODE_PRESSED_GROWTH_SPEED(Prompt prompt, float speed) { invoke<Void>(0x56DBB26F98582C29, prompt, speed); } // 0x56DBB26F98582C29 b1207
	// Used for controllers
	NATIVE_DECL void _UI_PROMPT_SET_ROTATE_MODE(Prompt prompt, float p1, BOOL counterclockwise) { invoke<Void>(0x7ABE7095FB3D2581, prompt, p1, counterclockwise); } // 0x7ABE7095FB3D2581 b1207
	NATIVE_DECL void _UI_PROMPT_SET_TARGET_MODE(Prompt prompt, float p1, float p2, Any p3) { invoke<Void>(0x5F6503D9CD2754EB, prompt, p1, p2, p3); } // 0x5F6503D9CD2754EB b1207
	NATIVE_DECL void _UI_PROMPT_SET_TARGET_MODE_TARGET(Prompt prompt, float p1, float p2) { invoke<Void>(0x5E019C45DD3B6A14, prompt, p1, p2); } // 0x5E019C45DD3B6A14 b1207
	NATIVE_DECL void _UI_PROMPT_SET_TARGET_MODE_PROGRESS(Prompt prompt, float progress) { invoke<Void>(0x00123054BEC8A30F, prompt, progress); } // 0x00123054BEC8A30F b1207
	NATIVE_DECL void _UI_PROMPT_SET_BEAT_MODE(Prompt prompt, BOOL toggle) { invoke<Void>(0xF957A1654C6322FE, prompt, toggle); } // 0xF957A1654C6322FE b1207
	NATIVE_DECL BOOL _UI_PROMPT_WAS_BEAT_MODE_PRESSED_IN_TIME_WINDOW(Prompt prompt) { return invoke<BOOL>(0x1FE4788AB1430C55, prompt); } // 0x1FE4788AB1430C55 b1207
	NATIVE_DECL void _UI_PROMPT_SET_BEAT_MODE_GRAYED_OUT(Prompt prompt, Any p1) { invoke<Void>(0xB487A4936FBF40AC, prompt, p1); } // 0xB487A4936FBF40AC b1207
	NATIVE_DECL void _UI_PROMPT_RESTART_MODES(Prompt prompt) { invoke<Void>(0xDC6C55DFA2C24EE5, prompt); } // 0xDC6C55DFA2C24EE5 b1207
	NATIVE_DECL void _UI_PROMPT_SET_SPINNER_SPEED(Prompt prompt, Any p1) { invoke<Void>(0xAC6586A7FDCD4B68, prompt, p1); } // 0xAC6586A7FDCD4B68 b1207
	NATIVE_DECL void _UI_PROMPT_SET_SPINNER_POSITION(Prompt prompt, Any p1) { invoke<Void>(0x832CB510DE546282, prompt, p1); } // 0x832CB510DE546282 b1207
	NATIVE_DECL void _UI_PROMPT_SET_URGENT_PULSING_ENABLED(Prompt prompt, BOOL toggle) { invoke<Void>(0xC5F428EE08FA7F2C, prompt, toggle); } // 0xC5F428EE08FA7F2C b1207
	NATIVE_DECL BOOL _UI_PROMPT_GET_URGENT_PULSING_ENABLED(Prompt prompt) { return invoke<BOOL>(0x1FBA0DABECDDB52B, prompt); } // 0x1FBA0DABECDDB52B b1207
	NATIVE_DECL void _UI_PROMPT_SET_TAG(Prompt prompt, Any p1) { invoke<Void>(0xDEC85C174751292B, prompt, p1); } // 0xDEC85C174751292B b1207
	NATIVE_DECL int _UI_PROMPT_GET_GROUP_ID_FOR_TARGET_ENTITY(Entity entity) { return invoke<int>(0xB796970BD125FCE8, entity); } // 0xB796970BD125FCE8 b1207
	NATIVE_DECL int _UI_PROMPT_GET_GROUP_ID_FOR_SCENARIO_POINT(Any p0, int p1) { return invoke<int>(0xCB73D7521E7103F0, p0, p1); } // 0xCB73D7521E7103F0 b1207
	// tabIndex: specifies tab of prompt
	NATIVE_DECL void _UI_PROMPT_SET_GROUP(Prompt prompt, int groupId, int tabIndex) { invoke<Void>(0x2F11D3A254169EA4, prompt, groupId, tabIndex); } // 0x2F11D3A254169EA4 b1207
	NATIVE_DECL void _UI_PROMPT_REMOVE_GROUP(Prompt prompt, Any p1) { invoke<Void>(0x4E52C800A28F7BE8, prompt, p1); } // 0x4E52C800A28F7BE8 b1207
	// Note: you must use VAR_STRING for p1 if string is not part of text database
	// tabAmount: specifies number of tabs in prompt group
	// tabDefaultIndex: specifies starting index
	// p3 if is set > 3 you can no longer press Q to change tab if there are more than one tab set in tabAmount
	NATIVE_DECL Any _UI_PROMPT_SET_ACTIVE_GROUP_THIS_FRAME(Hash hash, int tabAmount, int tabDefaultIndex, Any p3, Any p4, Prompt prompt) { return invoke<Any>(0xC65A45D4453C2627, hash, tabAmount, tabDefaultIndex, p3, p4, prompt); } // 0xC65A45D4453C2627 b1207
	NATIVE_DECL int _UI_PROMPT_GET_GROUP_ACTIVE_PAGE(Hash hash) { return invoke<int>(0xC1FCC36C3F7286C8, hash); } // 0xC1FCC36C3F7286C8 b1207
	NATIVE_DECL Any _UI_PROMPT_SET_AMBIENT_GROUP_THIS_FRAME(Entity entity, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0x315C81D760609108, entity, p1, p2, p3, p4, p5, p6); } // 0x315C81D760609108 b1207
	NATIVE_DECL Any _0x8B55B324A9123F6B(int groupId, Volume volume, const char* p2, Any p3, Any p4, Any p5) { return invoke<Any>(0x8B55B324A9123F6B, groupId, volume, p2, p3, p4, p5); } // 0x8B55B324A9123F6B b1232
	NATIVE_DECL BOOL _UI_PROMPT_DOES_AMBIENT_GROUP_EXIST(Hash hash) { return invoke<BOOL>(0xEB550B927B34A1BB, hash); } // 0xEB550B927B34A1BB b1207
	NATIVE_DECL void _UI_PROMPT_ADD_GROUP_LINK(Any p0, Prompt prompt, Any p2) { invoke<Void>(0x684C96CC7C66E8EF, p0, prompt, p2); } // 0x684C96CC7C66E8EF b1207
	NATIVE_DECL void _UI_PROMPT_ADD_GROUP_RETURN_LINK(Any p0, Prompt prompt) { invoke<Void>(0x837972ED28159536, p0, prompt); } // 0x837972ED28159536 b1207
	// TM_ANY = 0,
	// TM_ON_FOOT,
	// TM_IN_VEHICLE
	NATIVE_DECL void _UI_PROMPT_SET_TRANSPORT_MODE(Prompt prompt, int mode) { invoke<Void>(0x876E4A35C73A6655, prompt, mode); } // 0x876E4A35C73A6655 b1207
	NATIVE_DECL void _UI_PROMPT_DISABLE_PROMPTS_THIS_FRAME() { invoke<Void>(0xF1622CE88A1946FB); } // 0xF1622CE88A1946FB b1207
	NATIVE_DECL void _UI_PROMPT_DELETE(Prompt prompt) { invoke<Void>(0x00EDE88D4D13CF59, prompt); } // 0x00EDE88D4D13CF59 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_VALID(Prompt prompt) { return invoke<BOOL>(0x347469FBDD1589A9, prompt); } // 0x347469FBDD1589A9 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_ACTIVE(Prompt prompt) { return invoke<BOOL>(0x546E342E01DE71CF, prompt); } // 0x546E342E01DE71CF b1207
	NATIVE_DECL void _UI_PROMPT_SET_VISIBLE(Prompt prompt, BOOL toggle) { invoke<Void>(0x71215ACCFDE075EE, prompt, toggle); } // 0x71215ACCFDE075EE b1207
	NATIVE_DECL void _UI_PROMPT_SET_ENABLED(Prompt prompt, BOOL toggle) { invoke<Void>(0x8A0FB4D03A630D21, prompt, toggle); } // 0x8A0FB4D03A630D21 b1207
	NATIVE_DECL void _UI_PROMPT_SET_TEXT(Prompt prompt, const char* text) { invoke<Void>(0x5DD02A8318420DD7, prompt, text); } // 0x5DD02A8318420DD7 b1207
	// attribute: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/_UI_PROMPT_SET_ATTRIBUTE/README.md
	NATIVE_DECL void _UI_PROMPT_SET_ATTRIBUTE(Prompt prompt, int attribute, BOOL enabled) { invoke<Void>(0x560E76D5E2E1803F, prompt, attribute, enabled); } // 0x560E76D5E2E1803F b1207
	NATIVE_DECL void _UI_PROMPT_SET_TYPE(Prompt prompt, int type) { invoke<Void>(0xF4A5C4509BF923B1, prompt, type); } // 0xF4A5C4509BF923B1 b1207
	NATIVE_DECL void _0x53CE46C01A089DA1(Prompt prompt, Any p1) { invoke<Void>(0x53CE46C01A089DA1, prompt, p1); } // 0x53CE46C01A089DA1 b1207
	NATIVE_DECL void _UI_PROMPT_SET_MANUAL_RESOLVED(Prompt prompt, Any p1) { invoke<Void>(0xA520C7B05FA4EB2A, prompt, p1); } // 0xA520C7B05FA4EB2A b1207
	// Attaches a Volume
	NATIVE_DECL void _UI_PROMPT_CONTEXT_SET_VOLUME(Prompt prompt, Volume volume) { invoke<Void>(0x4D107406667423BE, prompt, volume); } // 0x4D107406667423BE b1207
	NATIVE_DECL void _UI_PROMPT_CONTEXT_SET_POINT(Prompt prompt, float x, float y, float z) { invoke<Void>(0xAE84C5EE2C384FB3, prompt, x, y, z); } // 0xAE84C5EE2C384FB3 b1207
	NATIVE_DECL void _UI_PROMPT_CONTEXT_SET_POINT(Prompt prompt, Vector3 vec) { invoke<Void>(0xAE84C5EE2C384FB3, prompt, vec.x, vec.y, vec.z); } // 0xAE84C5EE2C384FB3 b1207
	NATIVE_DECL void _UI_PROMPT_CONTEXT_SET_SIZE(Prompt prompt, float size) { invoke<Void>(0x0C718001B77CA468, prompt, size); } // 0x0C718001B77CA468 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_PRESSED(Prompt prompt) { return invoke<BOOL>(0x21E60E230086697F, prompt); } // 0x21E60E230086697F b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_JUST_PRESSED(Prompt prompt) { return invoke<BOOL>(0x2787CC611D3FACC5, prompt); } // 0x2787CC611D3FACC5 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_JUST_RELEASED(Prompt prompt) { return invoke<BOOL>(0x635CC82FA297A827, prompt); } // 0x635CC82FA297A827 b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_RELEASED(Prompt prompt) { return invoke<BOOL>(0xAFC887BA7A7756D6, prompt); } // 0xAFC887BA7A7756D6 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/graphics/HUD/prompts/prompt_types
	NATIVE_DECL void _UI_PROMPT_ENABLE_PROMPT_TYPE_THIS_FRAME(int p0) { invoke<Void>(0x06565032897BA861, p0); } // 0x06565032897BA861 b1207
	NATIVE_DECL void _UI_PROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(int p0) { invoke<Void>(0xFC094EF26DD153FA, p0); } // 0xFC094EF26DD153FA b1207
	NATIVE_DECL void _UI_PROMPT_FILTER_CLEAR() { invoke<Void>(0x6A2F820452017EA2); } // 0x6A2F820452017EA2 b1207
	NATIVE_DECL void _UI_PROMPT_SET_FAVOURED_PED_FOR_CONFLICT_RESOLUTION(Ped ped) { invoke<Void>(0x530A428705BE5DEF, ped); } // 0x530A428705BE5DEF b1207
	NATIVE_DECL void _UI_PROMPT_CLEAR_FAVOURED_PED_FOR_CONFLICT_RESOLUTION() { invoke<Void>(0x51259AE5C72D4A1B); } // 0x51259AE5C72D4A1B b1207
	NATIVE_DECL BOOL _UI_PROMPT_IS_ENABLED(Prompt prompt) { return invoke<BOOL>(0x0D00EDDFB58B7F28, prompt); } // 0x0D00EDDFB58B7F28 b1207
	NATIVE_DECL BOOL UI_PROMPT_IS_CONTROL_ACTION_ACTIVE(Hash control) { return invoke<BOOL>(0x1BE19185B8AFE299, control); } // 0x1BE19185B8AFE299 b1207
	NATIVE_DECL Any _0xD6BD313CFA41E57A(Any p0) { return invoke<Any>(0xD6BD313CFA41E57A, p0); } // 0xD6BD313CFA41E57A b1207
	// This returns an id that can be used with 0x6095358C4142932A.
	NATIVE_DECL int _UI_PROMPT_SET_REGISTER_HORIZONTAL_ORIENTATION() { return invoke<int>(0xD9459157EB22C895); } // 0xD9459157EB22C895 b1207
	// id is the return value from 0xD9459157EB22C895.
	NATIVE_DECL void _UI_PROMPT_CLEAR_HORIZONTAL_ORIENTATION(int id) { invoke<Void>(0x6095358C4142932A, id); } // 0x6095358C4142932A b1207
	NATIVE_DECL void _UI_PROMPT_SET_ORDERING_AS_INPUT_TYPE(Prompt prompt, Any p1) { invoke<Void>(0x2F385ECC5200938D, prompt, p1); } // 0x2F385ECC5200938D b1207
	NATIVE_DECL Any _0x066725A9D52B3641() { return invoke<Any>(0x066725A9D52B3641); } // 0x066725A9D52B3641 b1232
	NATIVE_DECL void _0x958278B97C4AFFD8(Any p0, Any p1) { invoke<Void>(0x958278B97C4AFFD8, p0, p1); } // 0x958278B97C4AFFD8 b1232
	NATIVE_DECL int _CREATE_MP_GAMER_TAG(Player player, const char* username, BOOL pointedClanTag, BOOL isRockstarClan, const char* clanTag, int clanFlag) { return invoke<int>(0xD877AF112AD2B41B, player, username, pointedClanTag, isRockstarClan, clanTag, clanFlag); } // 0xD877AF112AD2B41B b1207
	NATIVE_DECL int CREATE_FAKE_MP_GAMER_TAG(Ped ped, const char* username, BOOL pointedClanTag, BOOL isRockstarClan, const char* clanTag, int clanFlag) { return invoke<int>(0x53CB4B502E1C57EA, ped, username, pointedClanTag, isRockstarClan, clanTag, clanFlag); } // 0x53CB4B502E1C57EA 0xF5CD2AA4 b1207
	NATIVE_DECL int _CREATE_MP_GAMER_TAG_ON_ENTITY(Entity entity, const char* text) { return invoke<int>(0xE961BF23EAB76B12, entity, text); } // 0xE961BF23EAB76B12 b1207
	NATIVE_DECL void REMOVE_MP_GAMER_TAG(int gamerTagId) { invoke<Void>(0x839BFD7D7E49FE09, gamerTagId); } // 0x839BFD7D7E49FE09 0x3D081FE4 b1207
	NATIVE_DECL BOOL IS_MP_GAMER_TAG_ACTIVE(int gamerTagId) { return invoke<BOOL>(0x6E1C31E14C7A5F97, gamerTagId); } // 0x6E1C31E14C7A5F97 0x60118951 b1207
	NATIVE_DECL BOOL _IS_MP_GAMER_TAG_ACTIVE_ON_ENTITY(int gamerTagId, Entity entity) { return invoke<BOOL>(0x502E1591A504F843, gamerTagId, entity); } // 0x502E1591A504F843 b1207
	// visibility:
	// enum eUIGamertagVisibility
	// {
	// 	UIGAMERTAGVISIBILITY_NONE,
	// 	UIGAMERTAGVISIBILITY_ICON,
	// 	UIGAMERTAGVISIBILITY_SIMPLE,
	// 	UIGAMERTAGVISIBILITY_COMPLEX
	// };
	NATIVE_DECL void _SET_MP_GAMER_TAG_VISIBILITY(int gamerTagId, int visibility) { invoke<Void>(0x93171DDDAB274EB8, gamerTagId, visibility); } // 0x93171DDDAB274EB8 b1207
	// Found types: GENERIC_PLAYER, DEADDROP, HOTPROPERTY, MINIGAMES
	NATIVE_DECL void _SET_MP_GAMER_TAG_TYPE(int gamerTagId, Hash type) { invoke<Void>(0x25B9C78A25105C35, gamerTagId, type); } // 0x25B9C78A25105C35 b1207
	NATIVE_DECL void _SET_MP_GAMER_TAG_COLOUR(int gamerTagId, Hash colour) { invoke<Void>(0x84BD27DDF9575816, gamerTagId, colour); } // 0x84BD27DDF9575816 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xEF7AB1A0E8C86170(int gamerTagId, BOOL allow) { invoke<Void>(0xEF7AB1A0E8C86170, gamerTagId, allow); } // 0xEF7AB1A0E8C86170 b1207
	NATIVE_DECL void SET_MP_GAMER_TAG_NAME(int gamerTagId, const char* string) { invoke<Void>(0xEA6F4B8D4B4B5B3E, gamerTagId, string); } // 0xEA6F4B8D4B4B5B3E 0x627A559B b1207
	NATIVE_DECL void _SET_MP_GAMER_TAG_NAME_POSSE(int gamerTagId, const char* text) { invoke<Void>(0x1EA716E0628A6F44, gamerTagId, text); } // 0x1EA716E0628A6F44 b1207
	NATIVE_DECL void SET_MP_GAMER_TAG_BIG_TEXT(int gamerTagId, const char* string) { invoke<Void>(0xA0D7CE5F83259663, gamerTagId, string); } // 0xA0D7CE5F83259663 0x939218AB b1207
	// Found icons: https://pastebin.com/xx6rEgiG
	NATIVE_DECL void _SET_MP_GAMER_TAG_TOP_ICON(int gamerTagId, Hash icon) { invoke<Void>(0x5F57522BC1EB9D9D, gamerTagId, icon); } // 0x5F57522BC1EB9D9D b1207
	// Found icons: SPEAKER, THROPY
	NATIVE_DECL void _SET_MP_GAMER_TAG_SECONDARY_ICON(int gamerTagId, Hash icon) { invoke<Void>(0x95384C6CE1526EFF, gamerTagId, icon); } // 0x95384C6CE1526EFF b1207
	NATIVE_DECL void _MP_GAMER_TAG_ENABLE_REVIVE_TOP_ICON(int gamerTagId) { invoke<Void>(0xFFF6579CF0139FCE, gamerTagId); } // 0xFFF6579CF0139FCE b1207
	NATIVE_DECL void _MP_GAMER_TAG_DISABLE_REVIVE_TOP_ICON(int gamerTagId) { invoke<Void>(0x1F9A64C2804B3471, gamerTagId); } // 0x1F9A64C2804B3471 b1207
}

namespace IK
{
	NATIVE_DECL void _INVERSE_KINEMATICS_REQUEST_LOOK_AT(Ped ped, Any* args) { invoke<Void>(0x66F9EB44342BB4C5, ped, args); } // 0x66F9EB44342BB4C5 b1207
	NATIVE_DECL void _0x0B9F7A01EC50448D(Ped ped, Any* args) { invoke<Void>(0x0B9F7A01EC50448D, ped, args); } // 0x0B9F7A01EC50448D b1207
	// Seems to disable IK on ped
	NATIVE_DECL void _INVERSE_KINEMATICS_SET_DISABLED_FOR_PED(Ped ped, int p1, BOOL p2) { invoke<Void>(0x0EABF182FBB63D72, ped, p1, p2); } // 0x0EABF182FBB63D72 b1207
	NATIVE_DECL BOOL _0x6098139150DCC745(Ped ped, int p1) { return invoke<BOOL>(0x6098139150DCC745, ped, p1); } // 0x6098139150DCC745 b1207
	NATIVE_DECL void _0x873C792E07A32C8B(Ped ped1, Ped ped2) { invoke<Void>(0x873C792E07A32C8B, ped1, ped2); } // 0x873C792E07A32C8B b1207
}

namespace _NAMESPACE30
{
	// Shows the cursor on screen for one frame.
	NATIVE_DECL void _SET_MOUSE_CURSOR_ACTIVE_THIS_FRAME() { invoke<Void>(0xF12E4CCAF249DC10); } // 0xF12E4CCAF249DC10 b1207
	// Changes the mouse cursor's sprite.
	// 
	// spriteId's: https://github.com/femga/rdr3_discoveries/tree/master/graphics/HUD/cursor_sprites#readme
	NATIVE_DECL void _SET_MOUSE_CURSOR_SPRITE(int spriteId) { invoke<Void>(0x7F5858AAB5A58CCE, spriteId); } // 0x7F5858AAB5A58CCE b1207
	// Allows camera to be moved if middle mouse button is held while in first person
	// Must be called every frame
	// _SET*
	NATIVE_DECL void _0x0546B117BB17548B() { invoke<Void>(0x0546B117BB17548B); } // 0x0546B117BB17548B b1232
	// Returns true if player is moving mouse while cursor is active
	// _PI* - _PO*
	NATIVE_DECL BOOL _0x2B8B605F2A9E64BF() { return invoke<BOOL>(0x2B8B605F2A9E64BF); } // 0x2B8B605F2A9E64BF b1311
	// Returns true if player is holding LMB while cursor is active
	// _PI* - _PO*
	NATIVE_DECL BOOL _0x61CAE9D1FD055E44() { return invoke<BOOL>(0x61CAE9D1FD055E44); } // 0x61CAE9D1FD055E44 b1207
	// Returns true if player releases LMB if cursor is active
	// _PI* - _PO*
	NATIVE_DECL BOOL _0xF7F51A57349739F2() { return invoke<BOOL>(0xF7F51A57349739F2); } // 0xF7F51A57349739F2 b1207
}

namespace INTERIOR
{
	NATIVE_DECL BOOL IS_VALID_INTERIOR(Interior interior) { return invoke<BOOL>(0x017C1B3159F79F6C, interior); } // 0x017C1B3159F79F6C 0x39C0B635 b1207
	NATIVE_DECL void GET_INTERIOR_LOCATION_AND_NAMEHASH(Interior interior, Vector3* position, Hash* nameHash) { invoke<Void>(0x8451E87D3C2B0286, interior, position, nameHash); } // 0x8451E87D3C2B0286 b1207
	NATIVE_DECL Hash _GET_INTERIOR_MINIMAP_HASH(Interior interior) { return invoke<Hash>(0x3039BE60B3749716, interior); } // 0x3039BE60B3749716 b1207
	NATIVE_DECL Vector3 _GET_INTERIOR_POSITION(Interior interior) { return invoke<Vector3>(0x2C9746D0CA15BE1C, interior); } // 0x2C9746D0CA15BE1C b1207
	NATIVE_DECL BOOL IS_INTERIOR_SCENE() { return invoke<BOOL>(0x4200F14D6F840A9A); } // 0x4200F14D6F840A9A 0x55226C13 b1207
	NATIVE_DECL void CLEAR_ROOM_FOR_ENTITY(Entity entity) { invoke<Void>(0xA1762D5BBFCA13A8, entity); } // 0xA1762D5BBFCA13A8 0x7DDADB92 b1207
	NATIVE_DECL void FORCE_ROOM_FOR_ENTITY(Entity entity, Interior interior, Hash roomHashKey) { invoke<Void>(0xBC29A9894C976945, entity, interior, roomHashKey); } // 0xBC29A9894C976945 0x10BD4435 b1207
	// Gets the room hash key from the room that the specified entity is in. Each room in every interior has a unique key. Returns 0 if the entity is outside.
	NATIVE_DECL Hash GET_ROOM_KEY_FROM_ENTITY(Entity entity) { return invoke<Hash>(0x076E46E0EB52AFC6, entity); } // 0x076E46E0EB52AFC6 0xE4ACF8C3 b1207
	// Seems to do the exact same as INTERIOR::GET_ROOM_KEY_FROM_ENTITY
	NATIVE_DECL Hash GET_KEY_FOR_ENTITY_IN_ROOM(Entity entity) { return invoke<Hash>(0x27D7B6F79E1F4603, entity); } // 0x27D7B6F79E1F4603 0x91EA80EF b1207
	// Returns the handle of the interior that the entity is in. Returns 0 if outside.
	NATIVE_DECL Interior GET_INTERIOR_FROM_ENTITY(Entity entity) { return invoke<Interior>(0xB417689857646F61, entity); } // 0xB417689857646F61 0x5C644614 b1207
	NATIVE_DECL void RETAIN_ENTITY_IN_INTERIOR(Entity entity, Interior interior) { invoke<Void>(0x5BD616735F16BF5C, entity, interior); } // 0x5BD616735F16BF5C 0xE645E162 b1207
	NATIVE_DECL void FORCE_ROOM_FOR_GAME_VIEWPORT(int interiorID, Hash roomHashKey) { invoke<Void>(0x115B4AA8FB28AB43, interiorID, roomHashKey); } // 0x115B4AA8FB28AB43 0xD79803B5 b1207
	NATIVE_DECL void CLEAR_ROOM_FOR_GAME_VIEWPORT() { invoke<Void>(0x951A049765E0D450); } // 0x951A049765E0D450 0x617DC75D b1207
	NATIVE_DECL Interior GET_INTERIOR_FROM_PRIMARY_VIEW() { return invoke<Interior>(0xBC8A281FF125C655); } // 0xBC8A281FF125C655 b1207
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS(float x, float y, float z) { return invoke<Interior>(0xCDD36C9E5C469070, x, y, z); } // 0xCDD36C9E5C469070 0xA17FBF37 b1207
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS(Vector3 vec) { return invoke<Interior>(0xCDD36C9E5C469070, vec.x, vec.y, vec.z); } // 0xCDD36C9E5C469070 0xA17FBF37 b1207
	NATIVE_DECL void PIN_INTERIOR_IN_MEMORY(Interior interior) { invoke<Void>(0xBD3D33EABF680168, interior); } // 0xBD3D33EABF680168 0x3ADA414E b1207
	// Does something similar to INTERIOR::DISABLE_INTERIOR.
	// 
	// You don't fall through the floor but everything is invisible inside and looks the same as when INTERIOR::DISABLE_INTERIOR is used. Peds behaves normally inside. 
	NATIVE_DECL void UNPIN_INTERIOR(Interior interior) { invoke<Void>(0x07FD1A0B814F6055, interior); } // 0x07FD1A0B814F6055 0xFCFF792A b1207
	NATIVE_DECL BOOL IS_INTERIOR_READY(Interior interior) { return invoke<BOOL>(0x941560D2D45DBFC8, interior); } // 0x941560D2D45DBFC8 0xE1EF6450 b1207
	NATIVE_DECL Any _0xB5EF6FEF2DC9EBED(Interior interior) { return invoke<Any>(0xB5EF6FEF2DC9EBED, interior); } // 0xB5EF6FEF2DC9EBED b1207
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS_WITH_TYPE(float x, float y, float z, const char* interiorType) { return invoke<Interior>(0xAAD6170AA33B13C0, x, y, z, interiorType); } // 0xAAD6170AA33B13C0 0x96525B06 b1207
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS_WITH_TYPE(Vector3 vec, const char* interiorType) { return invoke<Interior>(0xAAD6170AA33B13C0, vec.x, vec.y, vec.z, interiorType); } // 0xAAD6170AA33B13C0 0x96525B06 b1207
	// Hashed version of GET_INTERIOR_AT_COORDS_WITH_TYPE
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS_WITH_TYPEHASH(float x, float y, float z, Hash typeHash) { return invoke<Interior>(0x3543AEA1816D1D2B, x, y, z, typeHash); } // 0x3543AEA1816D1D2B 0x11718507 b1207
	NATIVE_DECL Interior GET_INTERIOR_AT_COORDS_WITH_TYPEHASH(Vector3 vec, Hash typeHash) { return invoke<Interior>(0x3543AEA1816D1D2B, vec.x, vec.y, vec.z, typeHash); } // 0x3543AEA1816D1D2B 0x11718507 b1207
	// Returns true if the collision at the specified coords is marked as being outside (false if there's an interior)
	NATIVE_DECL BOOL IS_COLLISION_MARKED_OUTSIDE(float x, float y, float z) { return invoke<BOOL>(0xF291396B517E25B2, x, y, z); } // 0xF291396B517E25B2 0x7762249C b1207
	NATIVE_DECL BOOL IS_COLLISION_MARKED_OUTSIDE(Vector3 vec) { return invoke<BOOL>(0xF291396B517E25B2, vec.x, vec.y, vec.z); } // 0xF291396B517E25B2 0x7762249C b1207
	NATIVE_DECL int GET_INTERIOR_FROM_COLLISION(float x, float y, float z) { return invoke<int>(0x5054D1A5218FA696, x, y, z); } // 0x5054D1A5218FA696 0x7ED33DC1 b1207
	NATIVE_DECL int GET_INTERIOR_FROM_COLLISION(Vector3 vec) { return invoke<int>(0x5054D1A5218FA696, vec.x, vec.y, vec.z); } // 0x5054D1A5218FA696 0x7ED33DC1 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/interiors/interior_sets
	NATIVE_DECL void ACTIVATE_INTERIOR_ENTITY_SET(Interior interior, const char* entitySetName, int p2) { invoke<Void>(0x174D0AAB11CED739, interior, entitySetName, p2); } // 0x174D0AAB11CED739 0xC80A5DDF b1207
	NATIVE_DECL void DEACTIVATE_INTERIOR_ENTITY_SET(Interior interior, const char* entitySetName, BOOL p2) { invoke<Void>(0x33B81A2C07A51FFF, interior, entitySetName, p2); } // 0x33B81A2C07A51FFF 0xDBA768A1 b1207
	NATIVE_DECL BOOL IS_INTERIOR_ENTITY_SET_ACTIVE(Interior interior, const char* entitySetName) { return invoke<BOOL>(0x32810CA2125F5842, interior, entitySetName); } // 0x32810CA2125F5842 0x39A3CC6F b1207
	NATIVE_DECL BOOL _IS_INTERIOR_ENTITY_SET_VALID(Interior interior, const char* entitySetName) { return invoke<BOOL>(0xD56FF170710FC826, interior, entitySetName); } // 0xD56FF170710FC826 b1207
	NATIVE_DECL void DISABLE_INTERIOR(Interior interior, BOOL toggle) { invoke<Void>(0x3C2B92A1A07D4FCE, interior, toggle); } // 0x3C2B92A1A07D4FCE 0x093ADEA5 b1207
	NATIVE_DECL void _0x2533F2AB0EB9C6F9(Any p0, Any p1) { invoke<Void>(0x2533F2AB0EB9C6F9, p0, p1); } // 0x2533F2AB0EB9C6F9 b1207
	NATIVE_DECL void _0xFE2B3D5500B1B2E4(Any p0, Any p1) { invoke<Void>(0xFE2B3D5500B1B2E4, p0, p1); } // 0xFE2B3D5500B1B2E4 b1207
}

namespace INVENTORY
{
	// Returns a unique inventory ID for this ped.
	// For the local player ped, it is an eInventories value.
	// For other peds, it is the inventory address casted to unsigned int.
	// 
	// enum eInventories
	// {
	// 	INVENTORY_INVALID,
	// 	INVENTORY_SP_PLAYER,
	// 	INVENTORY_MP_PLAYER,
	// 	INVENTORY_MP_MISSION,
	// 	INVENTORY_SECOND_SCREEN,
	// 	INVENTORY_SP_BACKUP,
	// 	INVENTORY_SP_SNAPSHOT,
	// 	INVENTORY_0xDE2AE452,
	// 	INVENTORY_0x399D9B3A,
	// 	INVENTORY_0x4BD43FA7,
	// 	INVENTORY_0x9529D251,
	// 	INVENTORY_0xA75776AC,
	// 	INVENTORY_MAX_ID = 11,
	// 	INVENTORY_IDS_COUNT
	// };
	NATIVE_DECL int _INVENTORY_GET_INVENTORY_ID_FROM_PED(Ped ped) { return invoke<int>(0x13D234A2A3F66E63, ped); } // 0x13D234A2A3F66E63 b1207
	NATIVE_DECL int _GET_ITEM_ROLE_MAX_LEVEL_COUNT(int inventoryId, Hash eRoleMaxLevel) { return invoke<int>(0xADDD1E7C0ECF7D95, inventoryId, eRoleMaxLevel); } // 0xADDD1E7C0ECF7D95 b1207
	NATIVE_DECL int _GET_ITEM_SLOT_MAX_COUNT(Hash provision, Hash slotId) { return invoke<int>(0xE80E50BEE276A54A, provision, slotId); } // 0xE80E50BEE276A54A b1207
	NATIVE_DECL BOOL _0x112BCA290D2EB53C(int inventoryId, Hash p1, int* year, int* month, int* day, int* hour, int* minute, int* second) { return invoke<BOOL>(0x112BCA290D2EB53C, inventoryId, p1, year, month, day, hour, minute, second); } // 0x112BCA290D2EB53C b1207
	// eInventoryItem: CLOTHING_FANCY_SUIT, CLOTHING_GUNSLINGER_OUTFIT, etc.
	// Only used in R* SP Scripts
	NATIVE_DECL void _0x46743BBFEDBC859E(int inventoryId, Hash eInventoryItem, BOOL p2) { invoke<Void>(0x46743BBFEDBC859E, inventoryId, eInventoryItem, p2); } // 0x46743BBFEDBC859E b1207
	// Only works on CClothingItem
	NATIVE_DECL void _INVENTORY_SET_INVENTORY_ITEM_IN_USE(int inventoryId, Any* guid, BOOL inUse) { invoke<Void>(0x65A5F70F4A292EBE, inventoryId, guid, inUse); } // 0x65A5F70F4A292EBE b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_IN_USE(int inventoryId, Any* guid) { return invoke<BOOL>(0x70E3A884ED000A01, inventoryId, guid); } // 0x70E3A884ED000A01 b1311
	// Used with CClothingItem
	NATIVE_DECL void _INVENTORY_SET_INVENTORY_ITEM_HIDDEN(int inventoryId, Any* guid, BOOL hidden) { invoke<Void>(0x9A113C660AEA3832, inventoryId, guid, hidden); } // 0x9A113C660AEA3832 b1207
	// Used with CSatchelItem, R* Script usage: fisihing_core
	NATIVE_DECL void _INVENTORY_SET_INVENTORY_ITEM_HIDDEN_2(int inventoryId, Any* guid, BOOL hidden) { invoke<Void>(0xD740F11FBC8AEF43, inventoryId, guid, hidden); } // 0xD740F11FBC8AEF43 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_HIDDEN(int inventoryId, Any* guid) { return invoke<BOOL>(0xF9933164965533B7, inventoryId, guid); } // 0xF9933164965533B7 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_IS_ANIMAL_PELT(Hash item) { return invoke<BOOL>(0x4AEF1FB5B9011D75, item); } // 0x4AEF1FB5B9011D75 b1207
	NATIVE_DECL Hash _INVENTORY_GET_INVENTORY_ITEM_DESCRIPTION_HASH(Hash item) { return invoke<Hash>(0xA4550FE9C512E3DD, item); } // 0xA4550FE9C512E3DD b1207
	// 2097152 (is item read?), 8388608 (is item sent/received/mailable?), 16777216 (is item consumable?)
	NATIVE_DECL BOOL _INVENTORY_IS_INVENTORY_ITEM_FLAG_ENABLED(Hash item, int flag) { return invoke<BOOL>(0x245D07651B1D183B, item, flag); } // 0x245D07651B1D183B b1207
	// eSoundType:
	// SI_SFX_INVALID = -1,
	// SI_SFX_PURCHASE,
	// SI_SFX_SELL,
	// SI_SFX_USE
	NATIVE_DECL BOOL _INVENTORY_GET_IS_INVENTORY_ITEM_SOUND_VALID(Hash item, int soundType) { return invoke<BOOL>(0x2BAE4880DCDD560B, item, soundType); } // 0x2BAE4880DCDD560B b1207
	// eSoundType
	// Returns item Hash to be used with _IS_SCRIPTED_AUDIO_CUSTOM and _PLAY_SOUND_FROM_ITEM (p0)
	NATIVE_DECL Hash _INVENTORY_GET_INVENTORY_ITEM_SOUND(Hash item, int soundType) { return invoke<Hash>(0x2E1CDC1FF3B8473E, item, soundType); } // 0x2E1CDC1FF3B8473E b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_INSPECTION_INFO(Hash item, Any* info) { return invoke<BOOL>(0x0C093C1787F18519, item, info); } // 0x0C093C1787F18519 b1207
	// Returns CopyID
	NATIVE_DECL int _INVENTORY_GET_INVENTORY_ITEM_WEAPON_COPY_ID(int inventoryId, Any* guid) { return invoke<int>(0xAB5F12746A099A0E, inventoryId, guid); } // 0xAB5F12746A099A0E b1207
	// inventoryId: see _INVENTORY_GET_PED_INVENTORY_ID
	NATIVE_DECL BOOL _INVENTORY_ARE_LOCAL_CHANGES_ALLOWED(int inventoryId) { return invoke<BOOL>(0x0FBBFFC891A97C81, inventoryId); } // 0x0FBBFFC891A97C81 b1207
	NATIVE_DECL BOOL _INVENTORY_IS_GUID_VALID(Any* guid) { return invoke<BOOL>(0xB881CA836CC4B6D4, guid); } // 0xB881CA836CC4B6D4 b1207
	NATIVE_DECL BOOL _INVENTORY_COMPARE_GUIDS(Any* guid1, Any* guid2) { return invoke<BOOL>(0x4C543D5DFCD2DAFD, guid1, guid2); } // 0x4C543D5DFCD2DAFD b1207
	NATIVE_DECL BOOL INVENTORY_GET_GUID_FROM_ITEMID(int inventoryId, Any* guid, Hash p2, Hash slotId, Any* outGuid) { return invoke<BOOL>(0x886DFD3E185C8A89, inventoryId, guid, p2, slotId, outGuid); } // 0x886DFD3E185C8A89 b1207
	// removeReason: REMOVE_REASON_DEFAULT (eRemoveItemReason)
	// Example: INVENTORY::_0x5D6182F3BCE1333B(1, joaat("REMOVE_REASON_DEFAULT")); -> clears weapon wheel
	// Only used in R* SP Scripts
	NATIVE_DECL BOOL _0x5D6182F3BCE1333B(int inventoryId, Hash removeReason) { return invoke<BOOL>(0x5D6182F3BCE1333B, inventoryId, removeReason); } // 0x5D6182F3BCE1333B b1207
	NATIVE_DECL BOOL INVENTORY_GET_INVENTORY_ITEM(int inventoryId, Any* inData, Any* outData, BOOL p3) { return invoke<BOOL>(0x9700E8EFC4AB9089, inventoryId, inData, outData, p3); } // 0x9700E8EFC4AB9089 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_FULL_INVENTORY_ITEM_DATA(int inventoryId, Any* guid, Any* p2, int p3, int p4) { return invoke<BOOL>(0x025A1B1FB03FBF61, inventoryId, guid, p2, p3, p4); } // 0x025A1B1FB03FBF61 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_CHILD(int inventoryId, Any* parentGuid, Any childIndex, Any* outInventoryItem) { return invoke<BOOL>(0xCD9A485F2B383B44, inventoryId, parentGuid, childIndex, outInventoryItem); } // 0xCD9A485F2B383B44 b1207
	// inventoryItemSlotHash: https://pastebin.com/P6fyr3vr
	NATIVE_DECL BOOL _INVENTORY_ADD_ITEM_WITH_GUID(int inventoryId, Any* guid1, Any* guid2, Hash item, Hash inventoryItemSlot, int p5, Hash addReason) { return invoke<BOOL>(0xCB5D11F9508A928D, inventoryId, guid1, guid2, item, inventoryItemSlot, p5, addReason); } // 0xCB5D11F9508A928D b1207
	// Getter: _INVENTORY_GET_FULL_INVENTORY_ITEM_DATA
	NATIVE_DECL BOOL _INVENTORY_UPDATE_INVENTORY_ITEM(int inventoryId, Any* guid1, Any* guid2, int p3) { return invoke<BOOL>(0xD80A8854DB5CFBA5, inventoryId, guid1, guid2, p3); } // 0xD80A8854DB5CFBA5 b1207
	NATIVE_DECL BOOL _INVENTORY_REMOVE_INVENTORY_ITEM_WITH_GUID(int inventoryId, Any* guid, int quantity, Hash removeReason) { return invoke<BOOL>(0x3E4E811480B3AE79, inventoryId, guid, quantity, removeReason); } // 0x3E4E811480B3AE79 b1207
	NATIVE_DECL BOOL _INVENTORY_REMOVE_INVENTORY_ITEM_WITH_ITEMID(int inventoryId, Hash item, int quantity, Hash removeReason) { return invoke<BOOL>(0xB4158C8C9A3B5DCE, inventoryId, item, quantity, removeReason); } // 0xB4158C8C9A3B5DCE b1207
	// guid1: old parent GUID
	// guid2: new parent GUID
	// guid3: new item GUID (out param)
	NATIVE_DECL BOOL _INVENTORY_MOVE_INVENTORY_ITEM(int inventoryId, Any* guid1, Any* guid2, Hash slotId, int quantity, Any* outGuid) { return invoke<BOOL>(0xDCCAA7C3BFD88862, inventoryId, guid1, guid2, slotId, quantity, outGuid); } // 0xDCCAA7C3BFD88862 b1207
	NATIVE_DECL BOOL _INVENTORY_SWAP_INVENTORY_ITEM(int inventoryId, Any* guid1, Any* guid2) { return invoke<BOOL>(0xF2753D691BCDA314, inventoryId, guid1, guid2); } // 0xF2753D691BCDA314 b1207
	// filterName (collections): "ALL", "ALL WEAPONS", "ALL HORSES", "ALL COACHES"
	// slotId: -1591664384
	// p3: outCollectionSize (?)
	// Returns collectionId
	NATIVE_DECL int _INVENTORY_CREATE_ITEM_COLLECTION(int inventoryId, const char* filterName, Hash slotId, int* size) { return invoke<int>(0x80D78BDC9D88EF07, inventoryId, filterName, slotId, size); } // 0x80D78BDC9D88EF07 b1207
	NATIVE_DECL int _INVENTORY_CREATE_ITEM_COLLECTION_WITH_FILTER(int inventoryId, Any* filter, int* numInCollection) { return invoke<int>(0x640F890C3E5A3FFD, inventoryId, filter, numInCollection); } // 0x640F890C3E5A3FFD b1207
	// collectionId is < outCollectionSize
	NATIVE_DECL BOOL _INVENTORY_GET_ITEM_FROM_COLLECTION_INDEX(int collectionId, int itemIndex, Any* itemData) { return invoke<BOOL>(0x82FA24C3D3FCD9B7, collectionId, itemIndex, itemData); } // 0x82FA24C3D3FCD9B7 b1207
	NATIVE_DECL BOOL _INVENTORY_RELEASE_ITEM_COLLECTION(int collectionId) { return invoke<BOOL>(0x42A2F33A1942E865, collectionId); } // 0x42A2F33A1942E865 b1207
	NATIVE_DECL BOOL _INVENTORY_EQUIP_ITEM_WITH_GUID(int inventoryId, Any* guid, BOOL bEquipped) { return invoke<BOOL>(0x734311E2852760D0, inventoryId, guid, bEquipped); } // 0x734311E2852760D0 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_EQUIPPED_IN_SLOT_BY_REF(int inventoryId, Any* guid, Hash slotId, Any* outGuid) { return invoke<BOOL>(0x22E590F108289A9D, inventoryId, guid, slotId, outGuid); } // 0x22E590F108289A9D b1207
	NATIVE_DECL BOOL _INVENTORY_DOES_ITEM_OWN_EQUIPMENT(int inventoryId, Any* guid, Hash item) { return invoke<BOOL>(0x88B58B83A43A8CAB, inventoryId, guid, item); } // 0x88B58B83A43A8CAB b1207
	// Params: p3 returns an int between 0 and 20 (?)
	// Only used in R* SP Scripts
	NATIVE_DECL BOOL _0xD08685BA892DBFAB(int inventoryId, Any* guid, int* p2, int* p3) { return invoke<BOOL>(0xD08685BA892DBFAB, inventoryId, guid, p2, p3); } // 0xD08685BA892DBFAB b1207
	// Params: p0 is only 0 or 1
	// Only used in R* SP Scripts
	NATIVE_DECL void _0x0349404A22736740(BOOL p0, int inventoryId, Any* guid) { invoke<Void>(0x0349404A22736740, p0, inventoryId, guid); } // 0x0349404A22736740 b1207
	// OWE_INVALID = -1,
	// OWE_GOOD_IN_HOT
	// OWE_GOOD_IN_NONE
	// OWE_GOOD_IN_COLD
	// OWE_GOOD_IN_ALL
	NATIVE_DECL void _INVENTORY_SET_INVENTORY_ITEM_WEATHER_EFFECTIVENESS(int inventoryId, Any* guid, int weatherEffectiveness) { invoke<Void>(0x6D2F987736A42D4C, inventoryId, guid, weatherEffectiveness); } // 0x6D2F987736A42D4C b1207
	// Example: (1, WEAPON_REVOLVER_CATTLEMAN, 0) - disables cattleman revolver on weapon wheel
	NATIVE_DECL void _INVENTORY_DISABLE_ITEM(int inventoryId, Hash item, Hash gtxReason) { invoke<Void>(0x766315A564594401, inventoryId, item, gtxReason); } // 0x766315A564594401 b1207
	NATIVE_DECL void _INVENTORY_ENABLE_ITEM(int inventoryId, Hash item) { invoke<Void>(0x6A564540FAC12211, inventoryId, item); } // 0x6A564540FAC12211 b1207
	// Alternative Name: _INVENTORY_IS_ITEM_DISABLED
	NATIVE_DECL BOOL _INVENTORY_IS_INVENTORY_ITEM_EQUIPPED(int inventoryId, Hash item, BOOL p2) { return invoke<BOOL>(0x3D10D7179D7034AF, inventoryId, item, p2); } // 0x3D10D7179D7034AF b1207
	NATIVE_DECL BOOL _INVENTORY_SET_INVENTORY_ITEM_INSPECTION_ENABLED(int inventoryId, Any* p1, BOOL enabled) { return invoke<BOOL>(0x227522FD59DDB7E8, inventoryId, p1, enabled); } // 0x227522FD59DDB7E8 b1207
	NATIVE_DECL BOOL _INVENTORY_IS_ITEM_EXPIRED(Any* itemGUID) { return invoke<BOOL>(0x0137C77A2EC64536, itemGUID); } // 0x0137C77A2EC64536 b1232
	NATIVE_DECL int _INVENTORY_GET_ITEM_EXPIRY_TIME(Any* itemGUID) { return invoke<int>(0x4A606C17276E1BCC, itemGUID); } // 0x4A606C17276E1BCC b1232
	NATIVE_DECL int _INVENTORY_GET_INVENTORY_ITEM_COUNT_WITH_GUID(int inventoryId, Any* guid, BOOL p2) { return invoke<int>(0xC97E0D2302382211, inventoryId, guid, p2); } // 0xC97E0D2302382211 b1207
	NATIVE_DECL int _INVENTORY_GET_INVENTORY_ITEM_COUNT_WITH_ITEMID(int inventoryId, Hash eInventoryItem, BOOL p2) { return invoke<int>(0xE787F05DFC977BDE, inventoryId, eInventoryItem, p2); } // 0xE787F05DFC977BDE b1207
	NATIVE_DECL BOOL _0xB1DD74A1F5536622(int inventoryId, Any* itemGUID) { return invoke<BOOL>(0xB1DD74A1F5536622, inventoryId, itemGUID); } // 0xB1DD74A1F5536622 b1311
	NATIVE_DECL int _INVENTORY_GET_CHILDREN_COUNT(int inventoryId, Any* parentGuid) { return invoke<int>(0xE843D21A8E2498AA, inventoryId, parentGuid); } // 0xE843D21A8E2498AA b1207
	NATIVE_DECL int INVENTORY_GET_CHILDREN_IN_SLOT_COUNT(int inventoryId, Any* guid, Hash slotId) { return invoke<int>(0x033EE4B89F3AC545, inventoryId, guid, slotId); } // 0x033EE4B89F3AC545 b1207
	NATIVE_DECL int _INVENTORY_GET_INVENTORY_ITEM_EQUIPPED_IN_SLOT(int inventoryId, Any* guid, Hash slotId, int p3, Any* p4) { return invoke<int>(0xBE012571B25F5ACA, inventoryId, guid, slotId, p3, p4); } // 0xBE012571B25F5ACA b1207
	NATIVE_DECL BOOL _INVENTORY_FITS_SLOT_ID(Hash item, Hash slotId) { return invoke<BOOL>(0x780C5B9AE2819807, item, slotId); } // 0x780C5B9AE2819807 b1207
	// p1: WARDROBE, KIT_CAMP, CHARACTER, KIT_MOONSHINER_PROPERTY
	// Returns slot hash
	NATIVE_DECL Hash _GET_DEFAULT_ITEM_SLOT_INFO(Hash item, Hash p1) { return invoke<Hash>(0x6452B1D357D81742, item, p1); } // 0x6452B1D357D81742 b1207
	NATIVE_DECL BOOL _INVENTORY_GET_INVENTORY_ITEM_FIT_SLOT(Hash p0, Any* p1, int p2) { return invoke<BOOL>(0xB991FE166FAF84FD, p0, p1, p2); } // 0xB991FE166FAF84FD b1207
	// p1 (out) and p2 (in) are both script arrays?
	// item: can be a component item, see SHOP_CATALOG_BUILD_LIST_OF_WEAPON_COMPONENTS
	NATIVE_DECL BOOL _0x9AC53CB6907B4428(Hash item, Any* p1, Any* p2) { return invoke<BOOL>(0x9AC53CB6907B4428, item, p1, p2); } // 0x9AC53CB6907B4428 b1207
	// p0 is the return value of DATABINDING::_DATABINDING_ADD_DATA_CONTAINER_FROM_PATH
	// p2, p3: 0
	// Returns databindingEntryId
	NATIVE_DECL Hash _0x9D21B185ABC2DBC4(Any data, const char* effects, BOOL p2, BOOL p3) { return invoke<Hash>(0x9D21B185ABC2DBC4, data, effects, p2, p3); } // 0x9D21B185ABC2DBC4 b1207
	// p1, p2: 0
	NATIVE_DECL void _0x75CFAC49301E134F(Hash databindingEntryId, BOOL p1, BOOL p2) { invoke<Void>(0x75CFAC49301E134F, databindingEntryId, p1, p2); } // 0x75CFAC49301E134F b1207
	// p2: 0
	// p3: -1
	// Returns databindingEntryId to be used with 0x75CFAC49301E134E (p0)
	NATIVE_DECL Hash _0x9D21B185ABC2DBC5(Any data, const char* stats, int p2, int p3) { return invoke<Hash>(0x9D21B185ABC2DBC5, data, stats, p2, p3); } // 0x9D21B185ABC2DBC5 b1207
	// p0: value returned by 0x9D21B185ABC2DBC5
	NATIVE_DECL void _0x75CFAC49301E134E(Any data, BOOL p1, Ped ped) { invoke<Void>(0x75CFAC49301E134E, data, p1, ped); } // 0x75CFAC49301E134E b1207
	// Returns databindingEntryId to be used with 0x951847CEF3D829FF (p0)
	NATIVE_DECL Hash _0x46DB71883EE9D5AF(Any data, const char* stats, Any* guid, Ped ped) { return invoke<Hash>(0x46DB71883EE9D5AF, data, stats, guid, ped); } // 0x46DB71883EE9D5AF b1207
	// p0: value returned by 0x46DB71883EE9D5AF
	NATIVE_DECL void _0x951847CEF3D829FF(Any p0, Any* outGuid, Ped ped) { invoke<Void>(0x951847CEF3D829FF, p0, outGuid, ped); } // 0x951847CEF3D829FF b1207
	// Only used in R* SP Scripts
	NATIVE_DECL BOOL _0x6862E4D93F64CF01(int inventoryId, Any* guid, Hash p2, Any* p3) { return invoke<BOOL>(0x6862E4D93F64CF01, inventoryId, guid, p2, p3); } // 0x6862E4D93F64CF01 b1207
	// This native has no functionality.
	NATIVE_DECL void _INVENTORY_ENABLE_MISSION_INVENTORY(BOOL toggle) { invoke<Void>(0x597F571DDEE3FFAC, toggle); } // 0x597F571DDEE3FFAC b1207
	NATIVE_DECL void INVENTORY_DISABLE_MISSION_INVENTORY_PICKUPS() { invoke<Void>(0xE1F389F03DC83673); } // 0xE1F389F03DC83673 b1311
	NATIVE_DECL void _INVENTORY_USE_MISSION_INVENTORY(BOOL enable, BOOL mirrorTransactions) { invoke<Void>(0xA6AA9F56BC6CFF58, enable, mirrorTransactions); } // 0xA6AA9F56BC6CFF58 b1207
	NATIVE_DECL void INVENTORY_COPY_MP_INVENTORY_TO_MISSION_INVENTORY(BOOL p0, BOOL p1, BOOL bCopySatchelItems, BOOL bCopyEmotes, BOOL bCopyHorse, BOOL p5) { invoke<Void>(0x644CCB76A76CFBD6, p0, p1, bCopySatchelItems, bCopyEmotes, bCopyHorse, p5); } // 0x644CCB76A76CFBD6 b1207
	NATIVE_DECL void _INVENTORY_COPY_ITEM_TO_MISSION_INVENTORY(Any* guid, BOOL p1) { invoke<Void>(0x3112ADB9D5F3426B, guid, p1); } // 0x3112ADB9D5F3426B b1207
	// Only used in R* SP Scripts
	NATIVE_DECL void _0xE36D4A38D28D9CFB(BOOL p0) { invoke<Void>(0xE36D4A38D28D9CFB, p0); } // 0xE36D4A38D28D9CFB b1207
	NATIVE_DECL BOOL _INVENTORY_USE_SP_BACKUP() { return invoke<BOOL>(0x7C7E4AB748EA3B07); } // 0x7C7E4AB748EA3B07 b1207
	NATIVE_DECL BOOL _INVENTORY_IS_PLAYER_INVENTORY_MIRRORING_TRANSACTIONS() { return invoke<BOOL>(0xFC7563F482781A3D); } // 0xFC7563F482781A3D b1207
	NATIVE_DECL void _INVENTORY_COPY_ITEM_TO_INVENTORY(int inventoryId, int inventoryIdCloned, Any* p2, Any p3) { invoke<Void>(0xC04F47D488EF9EBA, inventoryId, inventoryIdCloned, p2, p3); } // 0xC04F47D488EF9EBA b1207
	NATIVE_DECL void _0x9E58207B194488AC(Ped ped, int p1) { invoke<Void>(0x9E58207B194488AC, ped, p1); } // 0x9E58207B194488AC b1207
	NATIVE_DECL void _INVENTORY_HANDLE_ITEM_PROMPT_INFO_REQUEST(Any* p0) { invoke<Void>(0xFD41D1D4350F6413, p0); } // 0xFD41D1D4350F6413 b1207
	// Used in function SET_SHOP_BEING_ROBBED and many other shop related scripts and functions.
	// INVENTORY_A*
	NATIVE_DECL void _0x9B4E793B1CB6550A() { invoke<Void>(0x9B4E793B1CB6550A); } // 0x9B4E793B1CB6550A b1207
	NATIVE_DECL void _INVENTORY_SET_CARRIABLE_CARRY_ACTION_PROMPT_OVERRIDE(Any* data) { invoke<Void>(0xF666EF30F4F0AC4E, data); } // 0xF666EF30F4F0AC4E b1207
	NATIVE_DECL void _INVENTORY_ENABLE_WEAPONS(int inventoryId) { invoke<Void>(0xD5D72F1624F3BA7C, inventoryId); } // 0xD5D72F1624F3BA7C b1207
	// Params: p1 = 0
	NATIVE_DECL void _INVENTORY_DISABLE_WEAPONS(int inventoryId, Any p1) { invoke<Void>(0xE3A46370F70F3607, inventoryId, p1); } // 0xE3A46370F70F3607 b1207
	// Only used in R* SP Scripts
	NATIVE_DECL void _0xE1F45A67A9F0DCBC(int inventoryId) { invoke<Void>(0xE1F45A67A9F0DCBC, inventoryId); } // 0xE1F45A67A9F0DCBC b1207
	// Only used in R* SP Scripts
	NATIVE_DECL void _0x6968CE7AC32F6788(int inventoryId) { invoke<Void>(0x6968CE7AC32F6788, inventoryId); } // 0x6968CE7AC32F6788 b1207
	// Returns collectionId
	NATIVE_DECL int _INVENTORY_CREATE_ITEM_COLLECTION(Any* p0) { return invoke<int>(0x97A3646645727F42, p0); } // 0x97A3646645727F42 b1232
	// p1: 32
	// Returns collectionId
	NATIVE_DECL int _INVENTORY_CREATE_SORTED_COLLECTION(int inventoryId, int p1, int* size) { return invoke<int>(0xBB7F968675B34B0C, inventoryId, p1, size); } // 0xBB7F968675B34B0C b1311
}

namespace ITEMDATABASE
{
	NATIVE_DECL Any _ITEMDATABASE_CAN_EQUIP_ITEM_ON_CATEGORY(Any p0, Any p1, Any p2) { return invoke<Any>(0x856FF92C57742AE5, p0, p1, p2); } // 0x856FF92C57742AE5 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_FITS_SLOT_COUNT(Any p0) { return invoke<Any>(0x2970D1D6BFCF9B46, p0); } // 0x2970D1D6BFCF9B46 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_FITS_SLOT_INFO(Any p0, Any p1, Any p2) { return invoke<Any>(0x77210C146CED5261, p0, p1, p2); } // 0x77210C146CED5261 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_HAS_SLOT_COUNT(Any p0) { return invoke<Any>(0x44915068579D7710, p0); } // 0x44915068579D7710 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_HAS_SLOT_INFO(Any p0, Any p1, Any p2) { return invoke<Any>(0x8A9BD0DB7E8376CF, p0, p1, p2); } // 0x8A9BD0DB7E8376CF b1207
	NATIVE_DECL Any ITEMDATABASE_FILLOUT_ITEM_BY_NAME(Any p0, Any p1) { return invoke<Any>(0x2A610BEE7D341CC4, p0, p1); } // 0x2A610BEE7D341CC4 b1207
	// p0 can be a weapon hash, component item
	// p1 is a struct containing WEAPON_MOD and WEAPON_DECORATION
	NATIVE_DECL BOOL ITEMDATABASE_FILLOUT_ITEM_INFO(Hash p0, Any* p1) { return invoke<BOOL>(0xFE90ABBCBFDC13B2, p0, p1); } // 0xFE90ABBCBFDC13B2 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_ACQUIRE_COST(Any p0, Any p1, Any p2) { return invoke<Any>(0x74F7928816E4E181, p0, p1, p2); } // 0x74F7928816E4E181 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_SELL_PRICE(Any p0, Any p1, Any p2) { return invoke<Any>(0x7A62A2EEDE1C3766, p0, p1, p2); } // 0x7A62A2EEDE1C3766 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_SATCHEL_DATA(Any p0, Any p1) { return invoke<Any>(0x4776EFD78F75C23F, p0, p1); } // 0x4776EFD78F75C23F b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_UI_DATA(Any p0, Any p1) { return invoke<Any>(0xB86F7CC2DC67AC60, p0, p1); } // 0xB86F7CC2DC67AC60 b1207
	// _ITEMDATABASE_FILLOUT_(A)* - _ITEMDATABASE_FILLOUT_(B)*
	NATIVE_DECL Any _0x74C3B1093728D263(Any p0, Any p1) { return invoke<Any>(0x74C3B1093728D263, p0, p1); } // 0x74C3B1093728D263 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_ITEM_EFFECT_IDS(Any p0, Any p1) { return invoke<Any>(0x9379BE60DC55BBE6, p0, p1); } // 0x9379BE60DC55BBE6 b1207
	NATIVE_DECL Any ITEMDATABASE_FILLOUT_ITEM_EFFECT_ID_INFO(Any p0, Any p1) { return invoke<Any>(0xCF2D360D27FD1ABF, p0, p1); } // 0xCF2D360D27FD1ABF b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_TAG_DATA(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x5A11D6EEA17165B0, p0, p1, p2, p3); } // 0x5A11D6EEA17165B0 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_ACQUIRE_COSTS_COUNT(Any p0) { return invoke<Any>(0x01FDDAD392D04144, p0); } // 0x01FDDAD392D04144 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_ACQUIRE_COST(Any p0, Any p1, Any p2) { return invoke<Any>(0x6772A83C67A25775, p0, p1, p2); } // 0x6772A83C67A25775 b1207
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL Any _0xDEE7B3C76ED664BE(Any p0, Any p1) { return invoke<Any>(0xDEE7B3C76ED664BE, p0, p1); } // 0xDEE7B3C76ED664BE b1232
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_ITEM(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xAD73B614DF26CF8A, p0, p1, p2, p3); } // 0xAD73B614DF26CF8A b1232
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL Any _0x12DF9C58201DD19A(Any p0) { return invoke<Any>(0x12DF9C58201DD19A, p0); } // 0x12DF9C58201DD19A b1311
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL Any _0x1FC25AEB5F76B38D(Any p0, Any p1, Any p2) { return invoke<Any>(0x1FC25AEB5F76B38D, p0, p1, p2); } // 0x1FC25AEB5F76B38D b1311
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL Any _0xF540239F9937033B(Any p0, Any p1) { return invoke<Any>(0xF540239F9937033B, p0, p1); } // 0xF540239F9937033B b1232
	// _ITEMDATABASE_FILLOUT_(A)* - _ITEMDATABASE_FILLOUT_(B)*
	NATIVE_DECL Any _0xF27F01BBF5ACD3F3(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xF27F01BBF5ACD3F3, p0, p1, p2, p3); } // 0xF27F01BBF5ACD3F3 b1232
	// Returns collectionId to be used with 0x8750F69A720C2E41 (p0) and 0xCBB7B6EDFA933ADE (p0)
	NATIVE_DECL int _ITEMDATABASE_CREATE_ITEM_COLLECTION(Any* p0, int* size, int comparisonType) { return invoke<int>(0x71EFA7999AE79408, p0, size, comparisonType); } // 0x71EFA7999AE79408 b1207
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL Any _0xD389A2549C4EFB30(Any p0) { return invoke<Any>(0xD389A2549C4EFB30, p0); } // 0xD389A2549C4EFB30 b1207
	// Params: p2 can be a component item hash
	NATIVE_DECL BOOL _ITEMDATABASE_GET_COMPONENT_ITEM(int collectionId, int index, Hash* p2) { return invoke<BOOL>(0x8750F69A720C2E41, collectionId, index, p2); } // 0x8750F69A720C2E41 b1207
	NATIVE_DECL BOOL _ITEMDATABASE_RELEASE_ITEM_COLLECTION(int collectionId) { return invoke<BOOL>(0xCBB7B6EDFA933ADE, collectionId); } // 0xCBB7B6EDFA933ADE b1207
	NATIVE_DECL Any _ITEMDATABASE_IS_INTRINSIC_ITEM(Any p0) { return invoke<Any>(0x337F88E3A063995E, p0); } // 0x337F88E3A063995E b1207
	NATIVE_DECL Any _ITEMDATABASE_IS_OVERPOWERED_ITEM(Any p0) { return invoke<Any>(0x337F88E3A063995F, p0); } // 0x337F88E3A063995F b1207
	NATIVE_DECL Any _ITEMDATABASE_IS_KEY_VALID(Any p0, Any p1) { return invoke<Any>(0x6D5D51B188333FD1, p0, p1); } // 0x6D5D51B188333FD1 b1207
	NATIVE_DECL BOOL _0x537A0555F62CA01A(Hash p0, Any p1) { return invoke<BOOL>(0x537A0555F62CA01A, p0, p1); } // 0x537A0555F62CA01A b1436
	NATIVE_DECL Any _ITEMDATABASE_GET_BUNDLE_ID(Any p0) { return invoke<Any>(0x891A45960B6B768A, p0); } // 0x891A45960B6B768A b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_BUNDLE_ITEM_COUNT(Any p0, Any p1) { return invoke<Any>(0x3332695B01015DF9, p0, p1); } // 0x3332695B01015DF9 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_BUNDLE_ITEM_INFO(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x5D48A77E4B668B57, p0, p1, p2, p3); } // 0x5D48A77E4B668B57 b1207
	NATIVE_DECL BOOL _ITEMDATABASE_IS_BUNDLE_VALID(Any p0, Any p1) { return invoke<BOOL>(0x4308812A6E9CA62E, p0, p1); } // 0x4308812A6E9CA62E b1207
	NATIVE_DECL Any _0x799FCD53358ED5FA(Any p0, Any p1) { return invoke<Any>(0x799FCD53358ED5FA, p0, p1); } // 0x799FCD53358ED5FA b1355
	NATIVE_DECL Any _0xC4146375D8A0B374(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xC4146375D8A0B374, p0, p1, p2, p3); } // 0xC4146375D8A0B374 b1355
	NATIVE_DECL Any _0xA97EE5E4589FCF5A(Any p0, Any p1) { return invoke<Any>(0xA97EE5E4589FCF5A, p0, p1); } // 0xA97EE5E4589FCF5A b1207
	NATIVE_DECL Any _0x7A35A72A692BE9DB(Any p0) { return invoke<Any>(0x7A35A72A692BE9DB, p0); } // 0x7A35A72A692BE9DB b1207
	NATIVE_DECL Any _0x3A0B667ABFF87F6E(Any p0, Any p1, Any p2) { return invoke<Any>(0x3A0B667ABFF87F6E, p0, p1, p2); } // 0x3A0B667ABFF87F6E b1207
	NATIVE_DECL Any _0x388088BFF3681189(Any p0, Any p1) { return invoke<Any>(0x388088BFF3681189, p0, p1); } // 0x388088BFF3681189 b1232
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_BUNDLE(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xB542632693D53408, p0, p1, p2, p3); } // 0xB542632693D53408 b1232
	NATIVE_DECL Any _ITEMDATABASE_IS_SHOP_KEY_VALID(Any p0) { return invoke<Any>(0x00B9507D8E1D8716, p0); } // 0x00B9507D8E1D8716 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_INVENTORIES_ITEMS_COUNT(Any p0) { return invoke<Any>(0xC568B1A0F17C7025, p0); } // 0xC568B1A0F17C7025 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_INVENTORIES_ITEM_INFO(Any p0, Any p1, Any p2) { return invoke<Any>(0x4A79B41B4EB91F4E, p0, p1, p2); } // 0x4A79B41B4EB91F4E b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_INVENTORIES_ITEM_INFO_BY_KEY(Any p0, Any p1, Any p2) { return invoke<Any>(0xCFB06801F5099B25, p0, p1, p2); } // 0xCFB06801F5099B25 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_INVENTORIES_REQUIREMENT_GROUP_INFO(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x76C752D788A76813, p0, p1, p2, p3); } // 0x76C752D788A76813 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_INVENTORIES_REQUIREMENT_INFO(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0xE0EA5C031AE5539F, p0, p1, p2, p3, p4); } // 0xE0EA5C031AE5539F b1207
	NATIVE_DECL Any _0x17721003A66C72BF(Any p0, Any p1, Any p2) { return invoke<Any>(0x17721003A66C72BF, p0, p1, p2); } // 0x17721003A66C72BF b1207
	NATIVE_DECL Any _ITEMDATABASE_IS_SHOP_LAYOUT_KEY_VALID(Any p0) { return invoke<Any>(0x3AFE5182C45A84F6, p0); } // 0x3AFE5182C45A84F6 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_INFO(Any p0, Any p1) { return invoke<Any>(0x66A6D76B6BB999B4, p0, p1); } // 0x66A6D76B6BB999B4 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_ROOT_MENU_INFO(Any p0, Any p1, Any p2) { return invoke<Any>(0x86FCB565CCA0CFA7, p0, p1, p2); } // 0x86FCB565CCA0CFA7 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_MENU_INFO_BY_ID(Any p0, Any p1, Any p2) { return invoke<Any>(0xD66114469978B55B, p0, p1, p2); } // 0xD66114469978B55B b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_MENU_INFO_BY_INDEX(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xF04247092F193B75, p0, p1, p2, p3); } // 0xF04247092F193B75 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_MENU_PAGE_KEY(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x9A60570657A7B635, p0, p1, p2, p3); } // 0x9A60570657A7B635 b1207
	NATIVE_DECL Any _0xDBEADA0DF5F9AB9F(Any p0, Any p1, Any p2) { return invoke<Any>(0xDBEADA0DF5F9AB9F, p0, p1, p2); } // 0xDBEADA0DF5F9AB9F b1355
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_PAGE_INFO_BY_KEY(Any p0, Any p1, Any p2) { return invoke<Any>(0xB347C100DF0C9B7F, p0, p1, p2); } // 0xB347C100DF0C9B7F b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_SHOP_LAYOUT_PAGE_ITEM_KEY(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<Any>(0xF32BEF578B3DBAE8, p0, p1, p2, p3, p4, p5); } // 0xF32BEF578B3DBAE8 b1207
	NATIVE_DECL Any ITEMDATABASE_IS_BUYABLE_AWARD_VALID(Any p0) { return invoke<Any>(0x4CE753203FA42214, p0); } // 0x4CE753203FA42214 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_BUY_AWARD_ACQUIRE_COSTS(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xB52E20F6767A09A2, p0, p1, p2, p3); } // 0xB52E20F6767A09A2 b1207
	// _ITEMDATABASE_FILLOUT_(B)* - ITEMDATABASE_FILLOUT_ITEM*
	NATIVE_DECL Any _0xF8D09EF8CE61D7BF(Any p0, Any p1) { return invoke<Any>(0xF8D09EF8CE61D7BF, p0, p1); } // 0xF8D09EF8CE61D7BF b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_ITEM_PRICE_MODIFIERS(Any p0, Any p1) { return invoke<Any>(0x4EB37AAB79AB0C48, p0, p1); } // 0x4EB37AAB79AB0C48 b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_PRICE_MODIFIER_BY_KEY(Any p0, Any p1) { return invoke<Any>(0x40C5D95818823C94, p0, p1); } // 0x40C5D95818823C94 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_NUMBER_OF_MODIFIED_PRICES(Any p0) { return invoke<Any>(0x5AAAF40E9B224F5E, p0); } // 0x5AAAF40E9B224F5E b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_MODIFIED_PRICE(Any p0, Any p1) { return invoke<Any>(0xCB92EC9C004732B4, p0, p1); } // 0xCB92EC9C004732B4 b1207
	NATIVE_DECL Any _ITEMDATABASE_GET_NUMBER_OF_MODIFIERS(Any p0) { return invoke<Any>(0x1289D8315235856D, p0); } // 0x1289D8315235856D b1207
	NATIVE_DECL Any _ITEMDATABASE_FILLOUT_MODIFIER(Any p0, Any p1, Any p2) { return invoke<Any>(0x60614A0AB580A2B5, p0, p1, p2); } // 0x60614A0AB580A2B5 b1207
	// _ITEMDATABASE_GET_* - _ITEMDATABASE_IS_*
	NATIVE_DECL BOOL _0xEF254F1A4C08B7E6(Hash p0) { return invoke<BOOL>(0xEF254F1A4C08B7E6, p0); } // 0xEF254F1A4C08B7E6 b1207
	NATIVE_DECL int _0x3FAA928A79591761(Hash p0) { return invoke<int>(0x3FAA928A79591761, p0); } // 0x3FAA928A79591761 b1207
	// _ITEMDATABASE_GET_(A)* - _ITEMDATABASE_GET_(B)*
	NATIVE_DECL int _0x48229CE0C7938237(Hash p0) { return invoke<int>(0x48229CE0C7938237, p0); } // 0x48229CE0C7938237 b1207
	NATIVE_DECL BOOL _0x121D2005DD64496B(Hash p0, int index, Any p2) { return invoke<BOOL>(0x121D2005DD64496B, p0, index, p2); } // 0x121D2005DD64496B b1207
	// _ITEMDATABASE_FILLOUT_(A)* - _ITEMDATABASE_FILLOUT_(B)*
	NATIVE_DECL Any _0x8D029948CA29409B(Hash p0, Any p1, Any p2) { return invoke<Any>(0x8D029948CA29409B, p0, p1, p2); } // 0x8D029948CA29409B b1207
	NATIVE_DECL Any _0xE81D0378A384E755(Any p0, Any p1) { return invoke<Any>(0xE81D0378A384E755, p0, p1); } // 0xE81D0378A384E755 b1232
	NATIVE_DECL Any _0xD076DB9B96FAADF1(Any p0, Any p1) { return invoke<Any>(0xD076DB9B96FAADF1, p0, p1); } // 0xD076DB9B96FAADF1 b1311
	NATIVE_DECL BOOL _ITEMDATABASE_DOES_ITEM_HAVE_TAG(Hash item, Hash tag, Hash tagType) { return invoke<BOOL>(0xFF5FB5605AD56856, item, tag, tagType); } // 0xFF5FB5605AD56856 b1207
	NATIVE_DECL BOOL _ITEMDATABASE_DOES_BUNDLE_HAVE_TAG(Hash bundle, Hash tag, Hash tagType) { return invoke<BOOL>(0x99C6EA66DFE73757, bundle, tag, tagType); } // 0x99C6EA66DFE73757 b1207
	NATIVE_DECL Hash _ITEMDATABASE_GET_ITEM_TAG_TYPE(Hash item, Hash tag) { return invoke<Hash>(0x6111B8F9413F413A, item, tag); } // 0x6111B8F9413F413A b1207
	NATIVE_DECL Any _0x8870895BA5ED9385(Any p0, Hash tagType, Any p2) { return invoke<Any>(0x8870895BA5ED9385, p0, tagType, p2); } // 0x8870895BA5ED9385 b1232
	NATIVE_DECL Any _ITEMDATABASE_LOCALIZATION_GET_NUM_LABEL_TYPES(Any p0) { return invoke<Any>(0xCEC6A41E8910486A, p0); } // 0xCEC6A41E8910486A b1207
	NATIVE_DECL Any _ITEMDATABASE_LOCALIZATION_GET_NUM_VALUES(Any p0, Any p1) { return invoke<Any>(0x49885D82A13EEAEA, p0, p1); } // 0x49885D82A13EEAEA b1207
	NATIVE_DECL Any _ITEMDATABASE_LOCALIZATION_GET_TYPE(Any p0, Any p1) { return invoke<Any>(0xCABF5D41D0073D4A, p0, p1); } // 0xCABF5D41D0073D4A b1207
	NATIVE_DECL Any _ITEMDATABASE_LOCALIZATION_GET_VALUE(Any p0, Any p1, Any p2) { return invoke<Any>(0x9AE5610FDCED6EA7, p0, p1, p2); } // 0x9AE5610FDCED6EA7 b1207
	NATIVE_DECL int _ITEMDATABASE_GET_ITEM_PATHSET(int item, int p1) { return invoke<int>(0xF4452CE83118C738, item, p1); } // 0xF4452CE83118C738 b1207
	// Returns Pathset Hash
	NATIVE_DECL Hash _0xAA29A5F13B2C20B2(Any p0, Hash p1) { return invoke<Hash>(0xAA29A5F13B2C20B2, p0, p1); } // 0xAA29A5F13B2C20B2 b1232
}

namespace ITEMSET
{
	NATIVE_DECL ItemSet CREATE_ITEMSET(BOOL p0) { return invoke<ItemSet>(0xA1AF16083320065A, p0); } // 0xA1AF16083320065A 0x0A113B2C b1207
	NATIVE_DECL void DESTROY_ITEMSET(ItemSet itemset) { invoke<Void>(0x712BC69F10549B92, itemset); } // 0x712BC69F10549B92 0x83CE1A4C b1207
	NATIVE_DECL BOOL IS_ITEMSET_VALID(ItemSet itemset) { return invoke<BOOL>(0xD30765D153EF5C76, itemset); } // 0xD30765D153EF5C76 0xD201FC29 b1207
	NATIVE_DECL BOOL ADD_TO_ITEMSET(Entity entity, ItemSet itemset) { return invoke<BOOL>(0xABE74510883C7950, entity, itemset); } // 0xABE74510883C7950 0x6B0FE61B b1207
	NATIVE_DECL void REMOVE_FROM_ITEMSET(Entity entity, ItemSet itemset) { invoke<Void>(0xC5BAA432B429DC24, entity, itemset); } // 0xC5BAA432B429DC24 0xA9565228 b1207
	NATIVE_DECL int GET_ITEMSET_SIZE(ItemSet itemset) { return invoke<int>(0x55F2E375AC6018A9, itemset); } // 0x55F2E375AC6018A9 0x2B31F41A b1207
	NATIVE_DECL ScrHandle GET_INDEXED_ITEM_IN_ITEMSET(int index, ItemSet itemset) { return invoke<ScrHandle>(0x275A2E2C0FAB7612, index, itemset); } // 0x275A2E2C0FAB7612 0x3F712874 b1207
	NATIVE_DECL Any GET_INDEXED_SCENARIO_POINT_INDEX_IN_ITEMSET(int index, ItemSet itemset) { return invoke<Any>(0x9FC3CDB5CE815901, index, itemset); } // 0x9FC3CDB5CE815901 b1207
	NATIVE_DECL BOOL IS_IN_ITEMSET(Entity entity, ItemSet itemset) { return invoke<BOOL>(0xD1503C2EE2FE688C, entity, itemset); } // 0xD1503C2EE2FE688C 0x0D4B9730 b1207
	NATIVE_DECL void CLEAN_ITEMSET(ItemSet itemset) { invoke<Void>(0x85F3A86CA9021FB0, itemset); } // 0x85F3A86CA9021FB0 0x919A4858 b1207
	NATIVE_DECL void _CLEAR_ITEMSET(ItemSet itemset) { invoke<Void>(0x20A4BF0E09BEE146, itemset); } // 0x20A4BF0E09BEE146 b1207
}

namespace LAW
{
	// crimeType:
	// enum eCrimeType : Hash
	// {
	// 	CRIME_ACCOMPLICE = 0xAF074F6D,
	// 	CRIME_ARSON = 0x68134DC7,
	// 	CRIME_ASSAULT = 0x0BADC882,
	// 	CRIME_ASSAULT_ANIMAL = 0x18DA55EE,
	// 	CRIME_ASSAULT_CORPSE = 0x4E5F23F2,
	// 	CRIME_ASSAULT_HORSE = 0xC4736181,
	// 	CRIME_ASSAULT_LAW = 0xD7466D7C,
	// 	CRIME_ASSAULT_LIVESTOCK = 0xCCE1CCBD,
	// 	CRIME_BANK_ROBBERY = 0x6A1ADE3D,
	// 	CRIME_BURGLARY = 0xA54C77E0,
	// 	CRIME_CHEATING = 0xA2FF1145,
	// 	CRIME_DISTURBANCE = 0x5011F613,
	// 	CRIME_EXPLOSION = 0x3EBA7A37,
	// 	CRIME_EXPLOSION_POISON = 0x91D0A0E1,
	// 	CRIME_GRAVE_ROBBERY = 0x971EA5AF,
	// 	CRIME_HASSLE = 0x58488776,
	// 	CRIME_HIT_AND_RUN = 0xFF0A3CC4,
	// 	CRIME_HIT_AND_RUN_LAW = 0x064814AF,
	// 	CRIME_INTIMIDATION = 0x8319FBAB,
	// 	CRIME_JACK_HORSE = 0x82F7E4A2,
	// 	CRIME_JACK_VEHICLE = 0x6B981F4C,
	// 	CRIME_JAIL_BREAK = 0x12C1D589,
	// 	CRIME_KIDNAPPING = 0x98F908DB,
	// 	CRIME_KIDNAPPING_LAW = 0xFD72A7EA,
	// 	CRIME_LASSO_ASSAULT = 0x56EE5D5A,
	// 	CRIME_LAW_IS_THREATENED = 0x1CB91DF0,
	// 	CRIME_LOITERING = 0x6629D2F4,
	// 	CRIME_LOOTING = 0x55AD2BEB,
	// 	CRIME_MURDER = 0xE28ECE7E,
	// 	CRIME_MURDER_ANIMAL = 0x48F59A66,
	// 	CRIME_MURDER_HORSE = 0xC7261D79,
	// 	CRIME_MURDER_LAW = 0x7797FCE7,
	// 	CRIME_MURDER_LIVESTOCK = 0x9569C546,
	// 	CRIME_MURDER_PLAYER = 0xF5ABD6C9,
	// 	CRIME_MURDER_PLAYER_HORSE = 0xD55C6A79,
	// 	CRIME_PROPERTY_DESTRUCTION = 0x533B003D,
	// 	CRIME_RESIST_ARREST = 0xDF577BA5,
	// 	CRIME_ROBBERY = 0xA3BEDE4C,
	// 	CRIME_SELF_DEFENCE = 0xBD6A0AA3,
	// 	CRIME_STAGECOACH_ROBBERY = 0xFC738E61,
	// 	CRIME_STOLEN_GOODS = 0x9A949C79,
	// 	CRIME_THEFT = 0x72ADE410,
	// 	CRIME_THEFT_HORSE = 0xBE3A5838,
	// 	CRIME_THEFT_LIVESTOCK = 0x85BA08FD,
	// 	CRIME_THEFT_VEHICLE = 0x43A9ECA1,
	// 	CRIME_THREATEN = 0x941C985A,
	// 	CRIME_THREATEN_LAW = 0x7F908566,
	// 	CRIME_TRAIN_ROBBERY = 0x647D2A5A,
	// 	CRIME_TRAMPLE = 0x45DB39D8,
	// 	CRIME_TRAMPLE_LAW = 0xF00F266B,
	// 	CRIME_TRAMPLE_PLAYER = 0x75970C15,
	// 	CRIME_TRESPASSING = 0xAEDE8E35,
	// 	CRIME_UNARMED_ASSAULT = 0x5098CC5A,
	// 	CRIME_VANDALISM = 0x80FDC759,
	// 	CRIME_VANDALISM_VEHICLE = 0xF9E7ECE4,
	// 	CRIME_VEHICLE_DESTRUCTION = 0x54A85DDC,
	// 	CRIME_WANTED_LEVEL_UP_DEBUG_HIGH = 0x99C52FF5,
	// 	CRIME_WANTED_LEVEL_UP_DEBUG_LOW = 0xD891890F
	// };
	NATIVE_DECL void _REPORT_CRIME(Player player, Hash crimeType, int bounty, Entity entity, BOOL isKnownSuspect) { invoke<Void>(0xF60386770878A98F, player, crimeType, bounty, entity, isKnownSuspect); } // 0xF60386770878A98F b1207
	// crimeType: see _REPORT_CRIME
	NATIVE_DECL void SUPPRESS_CRIME_THIS_FRAME(Player player, Hash crimeType, int p2, int p3, int p4) { invoke<Void>(0x785177E4D57D7389, player, crimeType, p2, p3, p4); } // 0x785177E4D57D7389 b1207
	// Returns amount of suppressed crimes to be used later in the function MPINTRO_CRIME_MONITOR_MAINTAIN
	NATIVE_DECL int NUM_CRIMES_SUPPRESSED(Player player, Hash crimeType) { return invoke<int>(0xC08E804C91F47C80, player, crimeType); } // 0xC08E804C91F47C80 b1207
	NATIVE_DECL Any _0xFFEBE5AA96BC2E4E(Ped ped, Hash crimeType, BOOL p2) { return invoke<Any>(0xFFEBE5AA96BC2E4E, ped, crimeType, p2); } // 0xFFEBE5AA96BC2E4E b1207
	// Params: p0 either 0, 1 or -1 in R* Scripts
	// Set to 0 called together with _SUPPRESS_CRIME
	NATIVE_DECL void _0x15ABD5004CAD2D99(int p0) { invoke<Void>(0x15ABD5004CAD2D99, p0); } // 0x15ABD5004CAD2D99 b1207
	NATIVE_DECL void _0xF611DE44AEB36A1D(Hash crimeType, BOOL p1) { invoke<Void>(0xF611DE44AEB36A1D, crimeType, p1); } // 0xF611DE44AEB36A1D b1207
	NATIVE_DECL BOOL _0x3D2674828A4E6B3C() { return invoke<BOOL>(0x3D2674828A4E6B3C); } // 0x3D2674828A4E6B3C b1207
	NATIVE_DECL void _0xC5EB2755FA25F1E9(BOOL p0) { invoke<Void>(0xC5EB2755FA25F1E9, p0); } // 0xC5EB2755FA25F1E9 b1207
	NATIVE_DECL int GET_BOUNTY(Player player) { return invoke<int>(0x54310AAB97B92816, player); } // 0x54310AAB97B92816 b1207
	NATIVE_DECL void ADD_BOUNTY(Player player, int itemValueAmount) { invoke<Void>(0x0E3BDEED21BEB945, player, itemValueAmount); } // 0x0E3BDEED21BEB945 b1207
	NATIVE_DECL void SET_BOUNTY(Player player, int amount) { invoke<Void>(0x093A9D1F72DF0D19, player, amount); } // 0x093A9D1F72DF0D19 b1207
	NATIVE_DECL void CLEAR_BOUNTY(Player player) { invoke<Void>(0xC76F252371150D9A, player); } // 0xC76F252371150D9A b1207
	NATIVE_DECL int GET_WANTED_SCORE(Player player) { return invoke<int>(0xDD5FD601481F648B, player); } // 0xDD5FD601481F648B b1207
	NATIVE_DECL void SET_WANTED_SCORE(Player player, int intensity) { invoke<Void>(0xA80FF73F772ACF6A, player, intensity); } // 0xA80FF73F772ACF6A b1207
	NATIVE_DECL void CLEAR_WANTED_SCORE(Player player) { invoke<Void>(0x062B4A4A3396351D, player); } // 0x062B4A4A3396351D b1207
	NATIVE_DECL void _0x331D349E0380B097(Any p0) { invoke<Void>(0x331D349E0380B097, p0); } // 0x331D349E0380B097 b1207
	// Only used in R* Script fm_mission_controller
	// _CLEAR_WANTED_*
	NATIVE_DECL void _0x292AD61A33A7A485() { invoke<Void>(0x292AD61A33A7A485); } // 0x292AD61A33A7A485 b1207
	// Used in SP only, called together with 0x55F37F5F3F2475E1 & CLEAR_WANTED_SCORE
	// _REPORT_*
	NATIVE_DECL void _0x07E8B8B20570271C(Player player) { invoke<Void>(0x07E8B8B20570271C, player); } // 0x07E8B8B20570271C b1207
	// Used in SP only
	// _REPORT_*
	NATIVE_DECL void _0x22741652985C84D0(Player player, Hash lawRegionHash) { invoke<Void>(0x22741652985C84D0, player, lawRegionHash); } // 0x22741652985C84D0 b1207
	NATIVE_DECL void _REPORT_PLAYER_LAW_DISPATCH_RESPONSE_OVERRIDE(Player player, Hash dispatchResponseHash) { invoke<Void>(0x9C4352134B2835FB, player, dispatchResponseHash); } // 0x9C4352134B2835FB b1207
	// Only used in shoprobberies R* Scripts
	NATIVE_DECL BOOL _0x9EF07CFBB19A9733() { return invoke<BOOL>(0x9EF07CFBB19A9733); } // 0x9EF07CFBB19A9733 b1207
	NATIVE_DECL void _SET_LAW_DISABLED(BOOL toggle) { invoke<Void>(0x8DE82BC774F3B862, toggle); } // 0x8DE82BC774F3B862 b1207
	NATIVE_DECL void _FORCE_LAW_ON_LOCAL_PLAYER_IMMEDIATELY() { invoke<Void>(0x956510F8C36B5C64); } // 0x956510F8C36B5C64 b1207
	// enum eLawRegion : Hash
	// {
	// 	LAW_DISPATCH_REGION_NONE = 0,
	// 	LAW_REGION_AGUASDULCES = 0x2F573EBE,
	// 	LAW_REGION_ANNESBURG = 0x68CAFD50,
	// 	LAW_REGION_ARMADILLO = 0xF0B90756,
	// 	LAW_REGION_BAYOU_NWA = 0x80966B1C,
	// 	LAW_REGION_BEECHERS_HOPE = 0xE2544977,
	// 	LAW_REGION_BIG_VALLEY = 0x3DF1559A,
	// 	LAW_REGION_BLACKWATER = 0x60D4886D,
	// 	LAW_REGION_BLACKWATER_MAINGAME = 0x66553576,
	// 	LAW_REGION_BLUEGILL_MARSH = 0x1D6AED8E,
	// 	LAW_REGION_BRAITHWAITE_MANOR = 0x3D71E7FF,
	// 	LAW_REGION_BUTCHER_CREEK = 0x2B3E1822,
	// 	LAW_REGION_CALIGA_HALL = 0xF3FE5080,
	// 	LAW_REGION_CORNWALL = 0xCC4672FA,
	// 	LAW_REGION_CUMBERLAND_FOREST = 0x81A78306,
	// 	LAW_REGION_EMERALD_RANCH = 0x5C069DF3,
	// 	LAW_REGION_FORT_WALLACE = 0x0AF25192,
	// 	LAW_REGION_GREAT_PLAINS = 0xB20573FA,
	// 	LAW_REGION_GREAT_PLAINS_MAINGAME = 0x9862FF7C,
	// 	LAW_REGION_GRIZZLIES = 0xBB936031,
	// 	LAW_REGION_GUAMA = 0x200DFF42,
	// 	LAW_REGION_HEARTLANDS = 0xAD14DA65,
	// 	LAW_REGION_LAGRAS = 0xC64808D3,
	// 	LAW_REGION_MACFARLANES_RANCH = 0x396A7D5F,
	// 	LAW_REGION_MANICATO = 0x039DB6BF,
	// 	LAW_REGION_MANZANITA_POST = 0x895E580E,
	// 	LAW_REGION_MANZANITA_POST_MAINGAME = 0x9BDD6A38,
	// 	LAW_REGION_OCCUPIED_CARAVAN_CAMP = 0x7EBABB01,
	// 	LAW_REGION_OLD_MAP_WILDERNESS = 0xCBB45950,
	// 	LAW_REGION_OLD_MAP_WILDERNESS_MAINGAME = 0x9F839BE7,
	// 	LAW_REGION_OUTLAW3 = 0x97A02FC1,
	// 	LAW_REGION_PRONGHORN_RANCH = 0x398E4BFC,
	// 	LAW_REGION_RHODES = 0x89222928,
	// 	LAW_REGION_RHODES_LOCKDOWN = 0xB1181671,
	// 	LAW_REGION_RIDGEWOOD_FARM = 0x635C3028,
	// 	LAW_REGION_ROANOKE_RIDGE = 0x46386A9A,
	// 	LAW_REGION_SAINT_DENIS = 0x5CF7C268,
	// 	LAW_REGION_SAINT_DENIS_RURAL = 0x4FD5331A,
	// 	LAW_REGION_SCARLETT_MEADOWS = 0x5FDD9717,
	// 	LAW_REGION_SISIKA = 0x2B6BBA52,
	// 	LAW_REGION_STRAWBERRY = 0xDD932620,
	// 	LAW_REGION_TALL_TREES = 0xD939B758,
	// 	LAW_REGION_TALL_TREES_MAINGAME = 0x084B17DF,
	// 	LAW_REGION_THIEVES_LANDING = 0x3D0C2EB6,
	// 	LAW_REGION_THIEVES_LANDING_MAINGAME = 0x61C450F3,
	// 	LAW_REGION_TUMBLEWEED = 0x0EFAF8DC,
	// 	LAW_REGION_VALENTINE = 0xA7A3F0C3,
	// 	LAW_REGION_VALENTINE_LOCKDOWN = 0x123582FE,
	// 	LAW_REGION_VAN_HORN = 0x619B528E,
	// 	LAW_REGION_WAPITI = 0x7A976E02
	// };
	NATIVE_DECL void _SET_LAW_REGION(Player player, Hash lawRegionHash, Hash stateHash) { invoke<Void>(0x4752F68EB7F2D280, player, lawRegionHash, stateHash); } // 0x4752F68EB7F2D280 b1207
	NATIVE_DECL void _0x5E6F375CA101C108(Player player, BOOL p1) { invoke<Void>(0x5E6F375CA101C108, player, p1); } // 0x5E6F375CA101C108 b1207
	NATIVE_DECL void _SET_LAW_RBS_VOLUME(Player player, Hash p1) { invoke<Void>(0x9BBDCB8DF789EBC1, player, p1); } // 0x9BBDCB8DF789EBC1 b1207
	NATIVE_DECL BOOL IS_LAW_INCIDENT_ACTIVE(Player player) { return invoke<BOOL>(0xAD401C63158ACBAA, player); } // 0xAD401C63158ACBAA b1207
	NATIVE_DECL Hash _0x148E7AC8141C9E64(Player player) { return invoke<Hash>(0x148E7AC8141C9E64, player); } // 0x148E7AC8141C9E64 b1207
	NATIVE_DECL void _0xEDFC6C1FD1C964F5(Player player, Hash crimeType, int bounty, float p3, float p4, BOOL p5, float p6, float p7, Any p8) { invoke<Void>(0xEDFC6C1FD1C964F5, player, crimeType, bounty, p3, p4, p5, p6, p7, p8); } // 0xEDFC6C1FD1C964F5 b1207
	NATIVE_DECL BOOL _LAW_WITNESS_RESPONSE_TASK(Ped pedGroup1, Ped ped, Ped pedGroup2, float x, float y, float z, Hash crimeType) { return invoke<BOOL>(0xF0B67BAD53C35BD9, pedGroup1, ped, pedGroup2, x, y, z, crimeType); } // 0xF0B67BAD53C35BD9 b1207
	NATIVE_DECL BOOL _LAW_WITNESS_RESPONSE_TASK(Ped pedGroup1, Ped ped, Ped pedGroup2, Vector3 vec, Hash crimeType) { return invoke<BOOL>(0xF0B67BAD53C35BD9, pedGroup1, ped, pedGroup2, vec.x, vec.y, vec.z, crimeType); } // 0xF0B67BAD53C35BD9 b1207
	NATIVE_DECL Any _0x018F30D762E62DF8(Ped ped, Any* p1) { return invoke<Any>(0x018F30D762E62DF8, ped, p1); } // 0x018F30D762E62DF8 b1207
	NATIVE_DECL Any _0x318F0F9A4426CFA2(Ped ped, Any* p1) { return invoke<Any>(0x318F0F9A4426CFA2, ped, p1); } // 0x318F0F9A4426CFA2 b1207
	NATIVE_DECL Any _0x95878B13E272EF1F(Entity entity, Ped ped, BOOL p2, float x, float y, float z, Hash crimeType) { return invoke<Any>(0x95878B13E272EF1F, entity, ped, p2, x, y, z, crimeType); } // 0x95878B13E272EF1F b1207
	NATIVE_DECL Any _0x95878B13E272EF1F(Entity entity, Ped ped, BOOL p2, Vector3 vec, Hash crimeType) { return invoke<Any>(0x95878B13E272EF1F, entity, ped, p2, vec.x, vec.y, vec.z, crimeType); } // 0x95878B13E272EF1F b1207
	NATIVE_DECL void _ADD_WITNESS_RESPONSE(Player player, Hash crimeType, Ped pedGroup) { invoke<Void>(0x10827B5A0AAC56A7, player, crimeType, pedGroup); } // 0x10827B5A0AAC56A7 b1207
	NATIVE_DECL void _0xD7494DED50C6EF52(Player player, Hash crimeType, int p2) { invoke<Void>(0xD7494DED50C6EF52, player, crimeType, p2); } // 0xD7494DED50C6EF52 b1207
	NATIVE_DECL BOOL ARE_WITNESSES_ACTIVE(Player player) { return invoke<BOOL>(0x69E181772886F48B, player); } // 0x69E181772886F48B b1207
	NATIVE_DECL BOOL _ARE_WITNESSES_PENDING(Player player) { return invoke<BOOL>(0x0BB6DE7D23C60626, player); } // 0x0BB6DE7D23C60626 b1207
	NATIVE_DECL BOOL _ARE_INVESTIGATORS_ACTIVE(Player player, BOOL areInvestigatorsActive, Any p2) { return invoke<BOOL>(0xF0FBFB9AB15F7734, player, areInvestigatorsActive, p2); } // 0xF0FBFB9AB15F7734 b1207
	NATIVE_DECL void _0x522F74636DF10201(Player player, ItemSet itemSet) { invoke<Void>(0x522F74636DF10201, player, itemSet); } // 0x522F74636DF10201 b1207
	NATIVE_DECL void _0xDA1A9ADC4E3D4B16(ItemSet itemSet, Any p1, Any p2) { invoke<Void>(0xDA1A9ADC4E3D4B16, itemSet, p1, p2); } // 0xDA1A9ADC4E3D4B16 b1207
	NATIVE_DECL void _ENABLE_DISPATCH_LAW(BOOL toggle) { invoke<Void>(0xC805EB785824F712, toggle); } // 0xC805EB785824F712 b1207
	NATIVE_DECL void _ENABLE_DISPATCH_LAW_2(BOOL toggle) { invoke<Void>(0x710448D44A64C213, toggle); } // 0x710448D44A64C213 b1207
	// Only used in rcm_homerob00 R* Script
	NATIVE_DECL BOOL _0xECE3C34B270428D5() { return invoke<BOOL>(0xECE3C34B270428D5); } // 0xECE3C34B270428D5 b1207
	// Only used in trainrobbery_ambient R* Script
	NATIVE_DECL BOOL _ARE_LAW_PEDS_ENABLED_FOR_TRAIN() { return invoke<BOOL>(0xA22C46F16359471C); } // 0xA22C46F16359471C b1207
	// Only used in rcm_gunslinger1_1 R* Script: p0 = 0
	NATIVE_DECL void _0x82F11E1296996574(int p0) { invoke<Void>(0x82F11E1296996574, p0); } // 0x82F11E1296996574 b1207
	NATIVE_DECL void _0x3852237A3D9DF145(int p0) { invoke<Void>(0x3852237A3D9DF145, p0); } // 0x3852237A3D9DF145 b1207
	NATIVE_DECL BOOL _0x0EAF918F751F27BA(Ped ped) { return invoke<BOOL>(0x0EAF918F751F27BA, ped); } // 0x0EAF918F751F27BA b1207
	// Only used in rcm_serial_killer1 R* Script
	NATIVE_DECL BOOL _0xC0DF161950FB101E(Ped ped) { return invoke<BOOL>(0xC0DF161950FB101E, ped); } // 0xC0DF161950FB101E b1207
	NATIVE_DECL Any _0xE4D6E45F491A66CB(Player player, int p1) { return invoke<Any>(0xE4D6E45F491A66CB, player, p1); } // 0xE4D6E45F491A66CB b1207
	// Returns p1 value for 0xE4D6E45F491A66CB
	NATIVE_DECL int _0xE9EB79CBF9C0F58A(Player player) { return invoke<int>(0xE9EB79CBF9C0F58A, player); } // 0xE9EB79CBF9C0F58A b1207
	NATIVE_DECL void _0x21213B833EF4DAE7(Player player, Ped ped, Vector3* outCoords) { invoke<Void>(0x21213B833EF4DAE7, player, ped, outCoords); } // 0x21213B833EF4DAE7 b1207
	NATIVE_DECL void _0x61B98367D93F012F(Player player) { invoke<Void>(0x61B98367D93F012F, player); } // 0x61B98367D93F012F b1207
	NATIVE_DECL void _0x6ABC50979655BEE7(Player player, Hash* crimeType, Any p2) { invoke<Void>(0x6ABC50979655BEE7, player, crimeType, p2); } // 0x6ABC50979655BEE7 b1207
	NATIVE_DECL void _0x390710D2DAFA6BFF(Player player, BOOL p1) { invoke<Void>(0x390710D2DAFA6BFF, player, p1); } // 0x390710D2DAFA6BFF b1207
	// Returns bounty (increment) value
	NATIVE_DECL int _GET_CRIME_BOUNTY_AMOUNT_BY_TYPE(Hash crimeType) { return invoke<int>(0x35E5E21F9159849C, crimeType); } // 0x35E5E21F9159849C b1207
	// crimeType: see _REPORT_CRIME
	NATIVE_DECL int _0xDAEFDFDB2AEECE37(Hash crimeType, Any p1) { return invoke<int>(0xDAEFDFDB2AEECE37, crimeType, p1); } // 0xDAEFDFDB2AEECE37 b1207
	// See _REPORT_CRIME
	NATIVE_DECL Hash _GET_HUD_PLAYER_CRIME_TYPE(Player player) { return invoke<Hash>(0x259CE340A8738814, player); } // 0x259CE340A8738814 b1207
	NATIVE_DECL int _0xE083BEDA81709891(Player player) { return invoke<int>(0xE083BEDA81709891, player); } // 0xE083BEDA81709891 b1207
	NATIVE_DECL BOOL _0x89E005B1662F6E48(Player player, int p1, int p2) { return invoke<BOOL>(0x89E005B1662F6E48, player, p1, p2); } // 0x89E005B1662F6E48 b1207
	NATIVE_DECL BOOL _0x3738B784DDD35CC6(Player player, int p1, int p2) { return invoke<BOOL>(0x3738B784DDD35CC6, player, p1, p2); } // 0x3738B784DDD35CC6 b1207
	// Only used in net_fetch R* Script
	NATIVE_DECL int _0x0BDFEBCF40A5F7E3(Hash crimeType) { return invoke<int>(0x0BDFEBCF40A5F7E3, crimeType); } // 0x0BDFEBCF40A5F7E3 b1207
	// Note: This native is only used in multiplayer scripts
	// dispatchResponseHash: see update1/common/data/dispatchresponses/..
	NATIVE_DECL void _SET_CUSTOM_LAW_DISPATCH_RESPONSE(Hash dispatchResponseHash) { invoke<Void>(0x009CF9A29972C298, dispatchResponseHash); } // 0x009CF9A29972C298 b1207
	// dispatchResponseHash: see common/data/dispatchresponses/..
	NATIVE_DECL Any _CREATE_LAW_DISPATCH_RESPONSE_FOR_COORDS(float x, float y, float z, Hash dispatchResponseHash) { return invoke<Any>(0x75CBF20BA47E4F89, x, y, z, dispatchResponseHash); } // 0x75CBF20BA47E4F89 b1207
	NATIVE_DECL Any _CREATE_LAW_DISPATCH_RESPONSE_FOR_COORDS(Vector3 vec, Hash dispatchResponseHash) { return invoke<Any>(0x75CBF20BA47E4F89, vec.x, vec.y, vec.z, dispatchResponseHash); } // 0x75CBF20BA47E4F89 b1207
	// Force clears local player's wanted level
	NATIVE_DECL void _SET_BOUNTY_HUNTER_PURSUIT_CLEARED() { invoke<Void>(0x55F37F5F3F2475E1); } // 0x55F37F5F3F2475E1 b1207
	// Called together with REPORT_POLICE_SPOTTED_PLAYER
	NATIVE_DECL void _0xBD944A3D36E992DE() { invoke<Void>(0xBD944A3D36E992DE); } // 0xBD944A3D36E992DE b1207
	NATIVE_DECL void _0x987BE590FB9D41E5(BOOL p0) { invoke<Void>(0x987BE590FB9D41E5, p0); } // 0x987BE590FB9D41E5 b1207
	NATIVE_DECL void _0xDCF12B89624AAC96(BOOL p0) { invoke<Void>(0xDCF12B89624AAC96, p0); } // 0xDCF12B89624AAC96 b1207
	NATIVE_DECL void _0xDDCE8E960D1DE240(BOOL p0) { invoke<Void>(0xDDCE8E960D1DE240, p0); } // 0xDDCE8E960D1DE240 b1207
	NATIVE_DECL void _0xDEA083C16BB91345() { invoke<Void>(0xDEA083C16BB91345); } // 0xDEA083C16BB91345 b1207
	// Only used in act_bankrobbery01 R* Script
	NATIVE_DECL void _0x9C8A2BF37E966464(Player player, ItemSet itemSet) { invoke<Void>(0x9C8A2BF37E966464, player, itemSet); } // 0x9C8A2BF37E966464 b1207
	NATIVE_DECL BOOL _0x9D5C9A5A3321B128(Player player) { return invoke<BOOL>(0x9D5C9A5A3321B128, player); } // 0x9D5C9A5A3321B128 b1207
	NATIVE_DECL BOOL _0x0F230DE0DDBE3649(Player player) { return invoke<BOOL>(0x0F230DE0DDBE3649, player); } // 0x0F230DE0DDBE3649 b1207
	NATIVE_DECL BOOL _0x9945A3E2528A02E8(Player player) { return invoke<BOOL>(0x9945A3E2528A02E8, player); } // 0x9945A3E2528A02E8 b1207
	NATIVE_DECL float _0x717DA2281DF90855(Player player) { return invoke<float>(0x717DA2281DF90855, player); } // 0x717DA2281DF90855 b1207
	NATIVE_DECL void _0x9B4C564BFA7CFF37(float p0) { invoke<Void>(0x9B4C564BFA7CFF37, p0); } // 0x9B4C564BFA7CFF37 b1207
	NATIVE_DECL void _SET_ALLOW_DISABLED_LAW_RESPONSES(BOOL toggle) { invoke<Void>(0x4B52BF96E225D230, toggle); } // 0x4B52BF96E225D230 b1207
	NATIVE_DECL void RESET_WANTED_FOR_NEW_INCIDENT(Player player) { invoke<Void>(0x2728C77FBC4B9796, player); } // 0x2728C77FBC4B9796 b1207
	NATIVE_DECL BOOL _0x856CE8FDE2416602(Ped ped) { return invoke<BOOL>(0x856CE8FDE2416602, ped); } // 0x856CE8FDE2416602 b1207
	// Only used in shoprobberies
	NATIVE_DECL BOOL _0x7351DA734F989F4E(Entity entity) { return invoke<BOOL>(0x7351DA734F989F4E, entity); } // 0x7351DA734F989F4E b1207
	// p0 is always BOUNTYHUNTERSGLOBALCOOLDOWN in R* scripts
	NATIVE_DECL int _GET_BOUNTY_HUNTER_GLOBAL_COOLDOWN(Hash p0) { return invoke<int>(0x76CF93D4B416B288, p0); } // 0x76CF93D4B416B288 b1207
	// p0 is always BOUNTYHUNTERSGLOBALCOOLDOWN in R* scripts
	NATIVE_DECL void _SET_BOUNTY_HUNTER_GLOBAL_COOLDOWN(Hash p0, int p1) { invoke<Void>(0xF19706B1F8FFA88F, p0, p1); } // 0xF19706B1F8FFA88F b1207
	// Only used in resapwn_dump_body R* Script
	NATIVE_DECL void _0x2001687F9562FD9D(Any p0) { invoke<Void>(0x2001687F9562FD9D, p0); } // 0x2001687F9562FD9D b1207
	// p0 is always BOUNTYHUNTERSGLOBALCOOLDOWN in R* scripts
	NATIVE_DECL void _PAUSE_BOUNTY_HUNTER_COOLDOWN(Hash p0, BOOL p1, Any p2) { invoke<Void>(0xC61EDEBF16CD9668, p0, p1, p2); } // 0xC61EDEBF16CD9668 b1207
	NATIVE_DECL void _0xE9AC8466ABE484BB(BOOL p0, Any p1) { invoke<Void>(0xE9AC8466ABE484BB, p0, p1); } // 0xE9AC8466ABE484BB b1207
	NATIVE_DECL BOOL _0x40851BCC33ACD9AB(Ped ped) { return invoke<BOOL>(0x40851BCC33ACD9AB, ped); } // 0x40851BCC33ACD9AB b1207
	NATIVE_DECL BOOL _0xF46108C50A22B029() { return invoke<BOOL>(0xF46108C50A22B029); } // 0xF46108C50A22B029 b1207
	NATIVE_DECL void _0x7803436E68C32B26() { invoke<Void>(0x7803436E68C32B26); } // 0x7803436E68C32B26 b1207
	NATIVE_DECL void _0xC310239ACCCF5579() { invoke<Void>(0xC310239ACCCF5579); } // 0xC310239ACCCF5579 b1207
	NATIVE_DECL void _0x29CD4896ECB66C12() { invoke<Void>(0x29CD4896ECB66C12); } // 0x29CD4896ECB66C12 b1207
	// Seems to disable lawmen guarding behaviors (like during a region lockdown). Must be called every frame.
	NATIVE_DECL void _0xE94B5E938619712E() { invoke<Void>(0xE94B5E938619712E); } // 0xE94B5E938619712E b1207
	NATIVE_DECL int _0x7FC667F6DDFBCDCC(Player player) { return invoke<int>(0x7FC667F6DDFBCDCC, player); } // 0x7FC667F6DDFBCDCC b1207
	NATIVE_DECL void _0x9C5BD8C562565CE6(Hash* crimeType) { invoke<Void>(0x9C5BD8C562565CE6, crimeType); } // 0x9C5BD8C562565CE6 b1207
	NATIVE_DECL void _0xCBFB4951F2E3934C(Player player, Any p1) { invoke<Void>(0xCBFB4951F2E3934C, player, p1); } // 0xCBFB4951F2E3934C b1207
	NATIVE_DECL void _SET_PED_LAW_BEHAVIOUR(Ped ped, int behaviour) { invoke<Void>(0x819ADD5EF1742F47, ped, behaviour); } // 0x819ADD5EF1742F47 b1207
	NATIVE_DECL void _0x00DB0BC05E3FAA4E(Ped ped, int bitset) { invoke<Void>(0x00DB0BC05E3FAA4E, ped, bitset); } // 0x00DB0BC05E3FAA4E b1207
	NATIVE_DECL void _0x0C392DB374655176(float x, float y, float z, float p3, ItemSet itemSet) { invoke<Void>(0x0C392DB374655176, x, y, z, p3, itemSet); } // 0x0C392DB374655176 b1207
	NATIVE_DECL void _0x0C392DB374655176(Vector3 vec, float p3, ItemSet itemSet) { invoke<Void>(0x0C392DB374655176, vec.x, vec.y, vec.z, p3, itemSet); } // 0x0C392DB374655176 b1207
	NATIVE_DECL Any _0xC687A23E166DCF68(Any* p0) { return invoke<Any>(0xC687A23E166DCF68, p0); } // 0xC687A23E166DCF68 b1207
	NATIVE_DECL void _SET_DISPATCH_MULTIPLIER_OVERRIDE(float multiplier) { invoke<Void>(0x002BABE0B7D53136, multiplier); } // 0x002BABE0B7D53136 b1207
	NATIVE_DECL BOOL _0x26934083D3F2579C(Player player) { return invoke<BOOL>(0x26934083D3F2579C, player); } // 0x26934083D3F2579C b1207
	NATIVE_DECL BOOL GET_PLAYER_REGISTERED_CRIME(Player player, int p1, Hash* crimeType) { return invoke<BOOL>(0x532C5FDDB986EE5C, player, p1, crimeType); } // 0x532C5FDDB986EE5C b1207
	NATIVE_DECL BOOL _0xB527099D1E1EED49(Player player, int p1, Hash* crimeType) { return invoke<BOOL>(0xB527099D1E1EED49, player, p1, crimeType); } // 0xB527099D1E1EED49 b1207
	NATIVE_DECL void CLEAR_PLAYER_PAST_CRIMES(Player player) { invoke<Void>(0xBCC6DC59E32A2BDC, player); } // 0xBCC6DC59E32A2BDC b1207
	NATIVE_DECL void SET_PLAYER_ARRESTED_IN_REGION(Player player, Hash lawRegionHash) { invoke<Void>(0xE0FA74AA3CCE650B, player, lawRegionHash); } // 0xE0FA74AA3CCE650B b1207
	NATIVE_DECL void SET_PLAYER_TURNED_IN_BOUNTY_IN_REGION(Player player, Hash lawRegionHash) { invoke<Void>(0x73BAD7B2F2DB50DE, player, lawRegionHash); } // 0x73BAD7B2F2DB50DE b1207
	NATIVE_DECL void _0xD6C0A8C7C0B2F82C(Player player, BOOL p1) { invoke<Void>(0xD6C0A8C7C0B2F82C, player, p1); } // 0xD6C0A8C7C0B2F82C b1207
	// Default range is 1.0f
	NATIVE_DECL void SET_LAW_SENSE_RANGE_MODIFIER(Player player, float range) { invoke<Void>(0xFEC85339AACA2A35, player, range); } // 0xFEC85339AACA2A35 b1207
	// _SET_DISPATCH_*
	NATIVE_DECL void _0x7EF2A2FE38D74456(int flag, BOOL p1) { invoke<Void>(0x7EF2A2FE38D74456, flag, p1); } // 0x7EF2A2FE38D74456 b1207
	NATIVE_DECL BOOL _0xC7DC5A0A7DF608CB(int flag) { return invoke<BOOL>(0xC7DC5A0A7DF608CB, flag); } // 0xC7DC5A0A7DF608CB b1207
	NATIVE_DECL void SET_DISABLE_DISTURBANCE_CRIMES(Player player, BOOL p1) { invoke<Void>(0xDE5FAA741A781F73, player, p1); } // 0xDE5FAA741A781F73 b1207
	NATIVE_DECL void SET_POSTPONE_DISTURBANCE_CRIMES_DURING_COMBAT(Player player, BOOL p1) { invoke<Void>(0x362086B911657B1A, player, p1); } // 0x362086B911657B1A b1207
	NATIVE_DECL void _CREATE_GUARD_ZONE(const char* name) { invoke<Void>(0x8F9DE75680275C9F, name); } // 0x8F9DE75680275C9F b1207
	NATIVE_DECL void _REMOVE_GUARD_ZONE(const char* name) { invoke<Void>(0x67EBDD958835956C, name); } // 0x67EBDD958835956C b1207
	// Only used in loanshark_miner1 R* Script: name = ANNESBURG_MINES
	NATIVE_DECL void _0x9772395CC73E8D1F(Ped ped, const char* name) { invoke<Void>(0x9772395CC73E8D1F, ped, name); } // 0x9772395CC73E8D1F b1207
	NATIVE_DECL void _DISABLE_GUARD_ZONE(const char* name) { invoke<Void>(0x26D558692B25DD95, name); } // 0x26D558692B25DD95 b1207
	// Only used in sisikapenitentiary R* Script: name = SISIKA
	// _IS_G* or _IS_H*
	NATIVE_DECL BOOL _0x0DBACA9C38C9A686(const char* name) { return invoke<BOOL>(0x0DBACA9C38C9A686, name); } // 0x0DBACA9C38C9A686 b1207
	NATIVE_DECL BOOL _IS_GUARD_PED_INVESTIGATING(Ped ped) { return invoke<BOOL>(0xD743C4293F47AFAD, ped); } // 0xD743C4293F47AFAD b1207
	// Returns true when investigation creation was successful
	NATIVE_DECL BOOL _CREATE_GUARD_ZONE_FOR_ENTITY(const char* guardZoneName, Entity entity, float x, float y, float z) { return invoke<BOOL>(0x0D4B77E862475ED3, guardZoneName, entity, x, y, z); } // 0x0D4B77E862475ED3 b1311
	NATIVE_DECL BOOL _CREATE_GUARD_ZONE_FOR_ENTITY(const char* guardZoneName, Entity entity, Vector3 vec) { return invoke<BOOL>(0x0D4B77E862475ED3, guardZoneName, entity, vec.x, vec.y, vec.z); } // 0x0D4B77E862475ED3 b1311
	NATIVE_DECL void _SET_GUARD_ZONE_VOLUME_REGISTRATION_START(const char* name, Volume volume) { invoke<Void>(0x8C598A930F471938, name, volume); } // 0x8C598A930F471938 b1207
	NATIVE_DECL void _SET_GUARD_ZONE_VOLUME_RESTRICTED(const char* name, Volume volume) { invoke<Void>(0x35815F372D43E1E5, name, volume); } // 0x35815F372D43E1E5 b1207
	NATIVE_DECL void _SET_GUARD_ZONE_VOLUME_THREAT(const char* name, Volume volume) { invoke<Void>(0xA1B0E6301E2E02A6, name, volume); } // 0xA1B0E6301E2E02A6 b1207
	NATIVE_DECL void _SET_GUARD_ZONE_VOLUME_WARNING(const char* name, Volume volume) { invoke<Void>(0xAD3E07C37A7C1ADC, name, volume); } // 0xAD3E07C37A7C1ADC b1207
	NATIVE_DECL void _SET_GUARD_ZONE_VOLUME_REGISTRATION_END(const char* name, Volume volume) { invoke<Void>(0xA8A74AA79FB67159, name, volume); } // 0xA8A74AA79FB67159 b1207
	NATIVE_DECL void _SET_GUARD_ZONE_POSITION(const char* name, float x, float y, float z) { invoke<Void>(0x7E7BF59F89FC6C6D, name, x, y, z); } // 0x7E7BF59F89FC6C6D b1207
	NATIVE_DECL void _SET_GUARD_ZONE_POSITION(const char* name, Vector3 vec) { invoke<Void>(0x7E7BF59F89FC6C6D, name, vec.x, vec.y, vec.z); } // 0x7E7BF59F89FC6C6D b1207
	NATIVE_DECL void _SET_GUARD_ZONE_POSITION_2(const char* name, float x, float y, float z) { invoke<Void>(0x2F9005E2EA4E5EE4, name, x, y, z); } // 0x2F9005E2EA4E5EE4 b1207
	NATIVE_DECL void _SET_GUARD_ZONE_POSITION_2(const char* name, Vector3 vec) { invoke<Void>(0x2F9005E2EA4E5EE4, name, vec.x, vec.y, vec.z); } // 0x2F9005E2EA4E5EE4 b1207
}

namespace LOCALIZATION
{
	// Same return values as GET_CURRENT_LANGUAGE
	NATIVE_DECL int _LOCALIZATION_GET_SYSTEM_LANGUAGE() { return invoke<int>(0x3C1A05F86AE6ACB5); } // 0x3C1A05F86AE6ACB5 b1207
	// 0 = american (en-US)
	// 1 = french (fr-FR)
	// 2 = german (de-DE)
	// 3 = italian (it-IT)
	// 4 = spanish (es-ES)
	// 5 = brazilian (pt-BR)
	// 6 = polish (pl-PL)
	// 7 = russian (ru-RU)
	// 8 = korean (ko-KR)
	// 9 = chinesetrad (zh-TW)
	// 10 = japanese (ja-JP)
	// 11 = mexican (es-MX)
	// 12 = chinesesimp (zh-CN)
	NATIVE_DECL int GET_CURRENT_LANGUAGE() { return invoke<int>(0xDB917DA5C6835FCC); } // 0xDB917DA5C6835FCC 0x761BE00B b1207
	// Returns true if the current language is american, french, german, italian, spanish, brazilian or mexican.
	NATIVE_DECL BOOL _0x45D50415E4D885FF() { return invoke<BOOL>(0x45D50415E4D885FF); } // 0x45D50415E4D885FF b1207
	// 0 = DATE_FORMAT_DMY
	// 1 = DATE_FORMAT_MDY
	// 2 = DATE_FORMAT_YMD
	NATIVE_DECL int _LOCALIZATION_GET_SYSTEM_DATE_FORMAT() { return invoke<int>(0x76E30B799EBEEA0F); } // 0x76E30B799EBEEA0F b1207
}

namespace MAP
{
	// Returns the Blip handle of given Entity.
	NATIVE_DECL Blip GET_BLIP_FROM_ENTITY(Entity entity) { return invoke<Blip>(0x6D2C41A8BD6D6FD0, entity); } // 0x6D2C41A8BD6D6FD0 0x005A2A47 b1207
	NATIVE_DECL Blip GET_MAIN_PLAYER_BLIP_ID() { return invoke<Blip>(0x5CD2889B2B381D45); } // 0x5CD2889B2B381D45 0xAB93F020 b1207
	NATIVE_DECL Blip _BLIP_ADD_FOR_STYLE(Hash styleHash) { return invoke<Blip>(0x3E593DF9C2962EC6, styleHash); } // 0x3E593DF9C2962EC6 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/useful_info_from_rpfs/textures/blips
	// https://github.com/femga/rdr3_discoveries/tree/master/useful_info_from_rpfs/textures/blips_mp
	NATIVE_DECL Blip BLIP_ADD_FOR_COORDS(Hash blipHash, float x, float y, float z) { return invoke<Blip>(0x554D9D53F696D002, blipHash, x, y, z); } // 0x554D9D53F696D002 b1207
	NATIVE_DECL Blip BLIP_ADD_FOR_COORDS(Hash blipHash, Vector3 vec) { return invoke<Blip>(0x554D9D53F696D002, blipHash, vec.x, vec.y, vec.z); } // 0x554D9D53F696D002 b1207
	NATIVE_DECL Blip BLIP_ADD_FOR_ENTITY(Hash blipHash, Entity entity) { return invoke<Blip>(0x23F74C2FDA6E7C61, blipHash, entity); } // 0x23F74C2FDA6E7C61 b1207
	NATIVE_DECL Blip BLIP_ADD_FOR_PICKUP_PLACEMENT(Hash blipHash, Pickup pickup) { return invoke<Blip>(0xA486008892065FB9, blipHash, pickup); } // 0xA486008892065FB9 b1207
	NATIVE_DECL Blip BLIP_ADD_FOR_RADIUS(Hash blipHash, float x, float y, float z, float radius) { return invoke<Blip>(0x45F13B7E0A15C880, blipHash, x, y, z, radius); } // 0x45F13B7E0A15C880 b1207
	NATIVE_DECL Blip BLIP_ADD_FOR_RADIUS(Hash blipHash, Vector3 vec, float radius) { return invoke<Blip>(0x45F13B7E0A15C880, blipHash, vec.x, vec.y, vec.z, radius); } // 0x45F13B7E0A15C880 b1207
	NATIVE_DECL Blip _BLIP_ADD_FOR_AREA(Hash blipHash, float x, float y, float z, float scaleX, float scaleY, float scaleZ, int p7) { return invoke<Blip>(0xEC174ADBCB611ECC, blipHash, x, y, z, scaleX, scaleY, scaleZ, p7); } // 0xEC174ADBCB611ECC b1207
	NATIVE_DECL Blip _BLIP_ADD_FOR_AREA(Hash blipHash, Vector3 vec, Vector3 scale, int p7) { return invoke<Blip>(0xEC174ADBCB611ECC, blipHash, vec.x, vec.y, vec.z, scale.x, scale.y, scale.z, p7); } // 0xEC174ADBCB611ECC b1207
	NATIVE_DECL Blip _BLIP_ADD_FOR_VOLUME(Hash blipHash, Volume volume) { return invoke<Blip>(0xA6EF0C54A3443E70, blipHash, volume); } // 0xA6EF0C54A3443E70 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/useful_info_from_rpfs/blip_styles
	// Removes any existing modifiers and sets the style.
	NATIVE_DECL BOOL _BLIP_SET_STYLE(Blip blip, Hash styleHash) { return invoke<BOOL>(0xEDD964B7984AC291, blip, styleHash); } // 0xEDD964B7984AC291 b1207
	NATIVE_DECL BOOL _BLIP_ADD_STYLE(Blip blip, Hash styleHash) { return invoke<BOOL>(0xBD62D98799A3DAF0, blip, styleHash); } // 0xBD62D98799A3DAF0 b1207
	// https://alloc8or.re/rdr3/doc/enums/eBlipModifier.txt
	// https://github.com/femga/rdr3_discoveries/tree/master/useful_info_from_rpfs/blip_modifiers
	// 
	// Old name: _BLIP_SET_MODIFIER
	NATIVE_DECL BOOL BLIP_ADD_MODIFIER(Blip blip, Hash modifierHash) { return invoke<BOOL>(0x662D364ABF16DE2F, blip, modifierHash); } // 0x662D364ABF16DE2F b1207
	// If modifierHash is 0, ALL modifiers will be removed.
	NATIVE_DECL BOOL BLIP_REMOVE_MODIFIER(Blip blip, Hash modifierHash) { return invoke<BOOL>(0xB059D7BD3D78C16F, blip, modifierHash); } // 0xB059D7BD3D78C16F b1207
	NATIVE_DECL void _0x250C75EB1728CC0D(Blip blip) { invoke<Void>(0x250C75EB1728CC0D, blip); } // 0x250C75EB1728CC0D b1207
	NATIVE_DECL void SET_BLIP_FLASH_TIMER(Blip blip, int blipType, Hash blipHash) { invoke<Void>(0x02FF4CF43B7209D1, blip, blipType, blipHash); } // 0x02FF4CF43B7209D1 0x8D5DF611 b1207
	NATIVE_DECL BOOL SET_BLIP_FLASHES(Blip blip, int* p1, Hash* p2) { return invoke<BOOL>(0x0DF2B55F717DDB10, blip, p1, p2); } // 0x0DF2B55F717DDB10 0xC0047F15 b1207
	NATIVE_DECL void TRIGGER_SONAR_BLIP(Hash typeHash, float x, float y, float z) { invoke<Void>(0x72DD432F3CDFC0EE, typeHash, x, y, z); } // 0x72DD432F3CDFC0EE 0xBF25E7B2 b1207
	NATIVE_DECL void TRIGGER_SONAR_BLIP(Hash typeHash, Vector3 vec) { invoke<Void>(0x72DD432F3CDFC0EE, typeHash, vec.x, vec.y, vec.z); } // 0x72DD432F3CDFC0EE 0xBF25E7B2 b1207
	NATIVE_DECL void _TRIGGER_SONAR_BLIP_ON_ENTITY(Hash typeHash, Entity entity) { invoke<Void>(0x0C7A2289A5C4D7C9, typeHash, entity); } // 0x0C7A2289A5C4D7C9 b1207
	NATIVE_DECL void ALLOW_SONAR_BLIPS(BOOL toggle) { invoke<Void>(0x6E6E64788C07D2E0, toggle); } // 0x6E6E64788C07D2E0 0xE7E1E32B b1207
	NATIVE_DECL void SET_BLIP_COORDS(Blip blip, float posX, float posY, float posZ) { invoke<Void>(0x4FF674F5E23D49CE, blip, posX, posY, posZ); } // 0x4FF674F5E23D49CE 0x680A34D4 b1207
	NATIVE_DECL void SET_BLIP_COORDS(Blip blip, Vector3 pos) { invoke<Void>(0x4FF674F5E23D49CE, blip, pos.x, pos.y, pos.z); } // 0x4FF674F5E23D49CE 0x680A34D4 b1207
	NATIVE_DECL Vector3 GET_BLIP_COORDS(Blip blip) { return invoke<Vector3>(0x201C319797BDA603, blip); } // 0x201C319797BDA603 0xEF6FF47B b1207
	NATIVE_DECL void SET_BLIP_SPRITE(Blip blip, Hash hash, BOOL p2) { invoke<Void>(0x74F74D3207ED525C, blip, hash, p2); } // 0x74F74D3207ED525C 0x8DBBB0B9 b1207
	// _CLEAR*
	NATIVE_DECL Any _0x01B928CA2E198B01(Any p0) { return invoke<Any>(0x01B928CA2E198B01, p0); } // 0x01B928CA2E198B01 b1207
	NATIVE_DECL void SET_BLIP_NAME_FROM_TEXT_FILE(Blip blip, const char* textLabel) { invoke<Void>(0x0A062D6D7C0B2C2C, blip, textLabel); } // 0x0A062D6D7C0B2C2C 0xAC8A5461 b1207
	// Example:
	// const char* playerString = VAR_STRING(10, "PLAYER_STRING", GET_PLAYER_NAME(PLAYER_ID()));
	// _SET_BLIP_NAME_FROM_PLAYER_STRING(blip, playerString);
	NATIVE_DECL void _SET_BLIP_NAME_FROM_PLAYER_STRING(Blip blip, const char* playerString) { invoke<Void>(0x9CB1A1623062F402, blip, playerString); } // 0x9CB1A1623062F402 b1207
	NATIVE_DECL void SET_BLIP_NAME_TO_PLAYER_NAME(Blip blip, Player player) { invoke<Void>(0x093DD5A31BC2B459, blip, player); } // 0x093DD5A31BC2B459 0x03A0B8F9 b1207
	NATIVE_DECL void SET_BLIP_ROTATION(Blip blip, int rotation) { invoke<Void>(0x6049966A94FBE706, blip, rotation); } // 0x6049966A94FBE706 0x6B8F44FE b1207
	NATIVE_DECL void SET_BLIP_SCALE(Blip blip, float scale) { invoke<Void>(0xD38744167B2FA257, blip, scale); } // 0xD38744167B2FA257 0x1E6EC434 b1207
	NATIVE_DECL void REMOVE_BLIP(Blip* blip) { invoke<Void>(0xF2C3C9DA47AAA54A, blip); } // 0xF2C3C9DA47AAA54A 0xD8C3C1CD b1207
	NATIVE_DECL BOOL DOES_BLIP_EXIST(Blip blip) { return invoke<BOOL>(0xCD82FA174080B3B1, blip); } // 0xCD82FA174080B3B1 0xAE92DD96 b1207
	NATIVE_DECL BOOL _DOES_ENTITY_HAVE_BLIP(Entity entity) { return invoke<BOOL>(0x9FA00E2FC134A9D0, entity); } // 0x9FA00E2FC134A9D0 b1207
	NATIVE_DECL void SET_RADAR_ZOOM(int zoomLevel) { invoke<Void>(0xCAF6489DA2C8DD9E, zoomLevel); } // 0xCAF6489DA2C8DD9E 0x2A50D1A6 b1207
	NATIVE_DECL void _0xDEEDE7C41742E011(Any p0) { invoke<Void>(0xDEEDE7C41742E011, p0); } // 0xDEEDE7C41742E011 b1207
	NATIVE_DECL BOOL _IS_BLIP_ATTACHED_TO_ANY_ENTITY(Blip blip) { return invoke<BOOL>(0xE9F676788F8D5E1E, blip); } // 0xE9F676788F8D5E1E b1207
	NATIVE_DECL BOOL IS_BLIP_ON_MINIMAP(Blip blip) { return invoke<BOOL>(0x46534526B9CD2D17, blip); } // 0x46534526B9CD2D17 0x258CBA3A b1207
	// Doesn't actually return anything.
	NATIVE_DECL Any FORCE_SONAR_BLIPS_THIS_FRAME() { return invoke<Any>(0xEE1C7BA69BB74B08); } // 0xEE1C7BA69BB74B08 0x3F4AFB13 b1207
	// https://alloc8or.re/rdr3/doc/enums/rage__eGpsFlags.txt
	NATIVE_DECL void SET_GPS_FLAGS(int p0, float p1) { invoke<Void>(0x5DE61C90DDECFA2D, p0, p1); } // 0x5DE61C90DDECFA2D 0x60539BAB b1207
	// Clears the GPS flags.
	NATIVE_DECL void CLEAR_GPS_FLAGS() { invoke<Void>(0x4D3771237C79FF41); } // 0x4D3771237C79FF41 0x056AFCE6 b1207
	NATIVE_DECL void SET_GPS_CUSTOM_ROUTE_RENDER(BOOL p0, int p1, int p2) { invoke<Void>(0xF6CEF599FC470B33, p0, p1, p2); } // 0xF6CEF599FC470B33 0xDA0AF00E b1207
	NATIVE_DECL void CLEAR_GPS_CUSTOM_ROUTE() { invoke<Void>(0x1EAA5674B4D181C5); } // 0x1EAA5674B4D181C5 0xCF2E3E24 b1207
	NATIVE_DECL void START_GPS_MULTI_ROUTE(Hash colorNameHash, BOOL onFoot, BOOL inVehicle) { invoke<Void>(0x3D3D15AF7BCAAF83, colorNameHash, onFoot, inVehicle); } // 0x3D3D15AF7BCAAF83 0xC3DCBEDB b1207
	NATIVE_DECL void ADD_POINT_TO_GPS_MULTI_ROUTE(float x, float y, float z, BOOL p3) { invoke<Void>(0x64C59DD6834FA942, x, y, z, p3); } // 0x64C59DD6834FA942 0xFE485135 b1207
	NATIVE_DECL void ADD_POINT_TO_GPS_MULTI_ROUTE(Vector3 vec, BOOL p3) { invoke<Void>(0x64C59DD6834FA942, vec.x, vec.y, vec.z, p3); } // 0x64C59DD6834FA942 0xFE485135 b1207
	NATIVE_DECL void SET_GPS_MULTI_ROUTE_RENDER(BOOL toggle) { invoke<Void>(0x4426D65E029A4DC0, toggle); } // 0x4426D65E029A4DC0 0xE87CBE4C b1207
	// Does the same as SET_GPS_MULTI_ROUTE_RENDER(false);
	NATIVE_DECL void CLEAR_GPS_MULTI_ROUTE() { invoke<Void>(0x9E0AB9AAEE87CE28); } // 0x9E0AB9AAEE87CE28 0x0D9969E4 b1207
	NATIVE_DECL void _START_GPS_CUSTOM_ROUTE_FROM_WAYPOINT_RECORDING_ROUTE(const char* waypointRecording, int point, int numPoints, Hash colorNameHash, BOOL p4, BOOL p5) { invoke<Void>(0x6B44F13D888F770D, waypointRecording, point, numPoints, colorNameHash, p4, p5); } // 0x6B44F13D888F770D b1207
	NATIVE_DECL void CLEAR_GPS_PLAYER_WAYPOINT() { invoke<Void>(0x08FDC6F796E350D1); } // 0x08FDC6F796E350D1 0x0B9C7FC2 b1207
	NATIVE_DECL void _0xD3F58E9316B7FC2A(Any p0) { invoke<Void>(0xD3F58E9316B7FC2A, p0); } // 0xD3F58E9316B7FC2A b1207
	NATIVE_DECL void SET_WAYPOINT_OFF() { invoke<Void>(0xFA8C41E8020D3439); } // 0xFA8C41E8020D3439 0xB3496E1B b1207
	NATIVE_DECL BOOL IS_WAYPOINT_ACTIVE() { return invoke<BOOL>(0x202B1BBFC6AB5EE4); } // 0x202B1BBFC6AB5EE4 0x5E4DF47B b1207
	NATIVE_DECL Vector3 _GET_WAYPOINT_COORDS() { return invoke<Vector3>(0x29B30D07C3F7873B); } // 0x29B30D07C3F7873B b1207
	NATIVE_DECL Any _0xF08E42BFA46BDFF8(Any p0, Any p1) { return invoke<Any>(0xF08E42BFA46BDFF8, p0, p1); } // 0xF08E42BFA46BDFF8 b1207
	NATIVE_DECL void _HIDE_ACTIVE_POINTS_OF_INTEREST() { invoke<Void>(0xA1B4052C2A3DCC1E); } // 0xA1B4052C2A3DCC1E b1207
	NATIVE_DECL void _SHOW_ACTIVE_POINTS_OF_INTEREST() { invoke<Void>(0x3FBB838AEA30C1D8); } // 0x3FBB838AEA30C1D8 b1207
	NATIVE_DECL Any _0xF47A1EB2A538A3A3() { return invoke<Any>(0xF47A1EB2A538A3A3); } // 0xF47A1EB2A538A3A3 b1207
	NATIVE_DECL BOOL _FIND_CLOSEST_GPS_POSITION(float x, float y, float z, Vector3* outPosition) { return invoke<BOOL>(0x3FDA2B79AEEE351C, x, y, z, outPosition); } // 0x3FDA2B79AEEE351C b1207
	NATIVE_DECL BOOL _FIND_CLOSEST_GPS_POSITION(Vector3 vec, Vector3* outPosition) { return invoke<BOOL>(0x3FDA2B79AEEE351C, vec.x, vec.y, vec.z, outPosition); } // 0x3FDA2B79AEEE351C b1207
	// If Minimap / Radar should be displayed.
	NATIVE_DECL void DISPLAY_RADAR(BOOL toggle) { invoke<Void>(0x1B3DA717B9AFF828, toggle); } // 0x1B3DA717B9AFF828 0x52816BD4 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/graphics/minimap/radar/radar_configs.lua
	// configHash: -1943724816, 347777538, -117986897, -789269373, -547506804, -1986542417, 2080113112
	// p1: usually 898171178 or 0 in R* scripts (doesn't seems to have any effect)
	NATIVE_DECL void _SET_RADAR_CONFIG_TYPE(Hash configHash, Hash p1) { invoke<Void>(0x9C113883487FD53C, configHash, p1); } // 0x9C113883487FD53C b1207
	// list of minimap props: https://github.com/femga/rdr3_discoveries/tree/master/graphics/minimap/minimapObjects
	NATIVE_DECL void _ADD_PROP_TO_MINIMAP(Hash minimapProp, float x, float y, float rotation, int p4) { invoke<Void>(0x1392105DA88BBFFB, minimapProp, x, y, rotation, p4); } // 0x1392105DA88BBFFB b1207
	NATIVE_DECL void _ADD_PROP_TO_MINIMAP(Hash minimapProp, Vector2 vec, float rotation, int p4) { invoke<Void>(0x1392105DA88BBFFB, minimapProp, vec.x, vec.y, rotation, p4); } // 0x1392105DA88BBFFB b1207
	NATIVE_DECL void _REMOVE_PROP_FROM_MINIMAP(Hash minimapProp) { invoke<Void>(0xE057FEA9A22EB3EE, minimapProp); } // 0xE057FEA9A22EB3EE b1207
	NATIVE_DECL void SET_RADAR_AS_EXTERIOR_THIS_FRAME() { invoke<Void>(0xA8EBBAE986FB5457); } // 0xA8EBBAE986FB5457 0x39ABB10E b1207
	// Reveals the entire minimap (FOW = Fog of War)
	NATIVE_DECL void SET_MINIMAP_HIDE_FOW(BOOL toggle) { invoke<Void>(0x4B8F743A4A6D2FF8, toggle); } // 0x4B8F743A4A6D2FF8 0xD8D77733 b1207
	NATIVE_DECL void _SET_FOW_UPDATE_PLAYER_OVERRIDE(BOOL toggle, Hash p1) { invoke<Void>(0x63E7279D04160477, toggle, p1); } // 0x63E7279D04160477 b1207
	NATIVE_DECL void _SET_MINIMAP_FOW_OVERRIDE_REVEAL_SCALE(float scale, Hash p1) { invoke<Void>(0xE5A7F70B7C0F3271, scale, p1); } // 0xE5A7F70B7C0F3271 b1207
	NATIVE_DECL void _SET_MINIMAP_FOW_SHOULD_UPDATE(BOOL toggle, Hash p1) { invoke<Void>(0x632AA10BF7EA53D3, toggle, p1); } // 0x632AA10BF7EA53D3 b1207
	NATIVE_DECL void SET_MINIMAP_FOW_REVEAL_COORDINATE(float x, float y, float z, Hash p3) { invoke<Void>(0x73348402566ECB6E, x, y, z, p3); } // 0x73348402566ECB6E 0xE010F081 b1207
	NATIVE_DECL void SET_MINIMAP_FOW_REVEAL_COORDINATE(Vector3 vec, Hash p3) { invoke<Void>(0x73348402566ECB6E, vec.x, vec.y, vec.z, p3); } // 0x73348402566ECB6E 0xE010F081 b1207
	NATIVE_DECL void SET_MINIMAP_FOW_REVEAL_VOLUME(Volume volume, Hash p1) { invoke<Void>(0x63CBBD6CA6F321F9, volume, p1); } // 0x63CBBD6CA6F321F9 b1207
	NATIVE_DECL void RESET_MINIMAP_FOW(Hash hash) { invoke<Void>(0xEB3CB3386C775D72, hash); } // 0xEB3CB3386C775D72 b1207
	NATIVE_DECL void _REVEAL_MINIMAP_FOW(Hash hash) { invoke<Void>(0xF8096DF9B87246E3, hash); } // 0xF8096DF9B87246E3 b1207
	// hash can be the hash of "guarma" or "world".
	NATIVE_DECL void _SET_MINIMAP_ZONE(Hash zone) { invoke<Void>(0xA657EC9DBC6CC900, zone); } // 0xA657EC9DBC6CC900 b1207
	// Locks the minimap to the specified angle in integer degrees.
	// 
	// angle: The angle in whole degrees. If less than 0 or greater than 360, unlocks the angle.
	NATIVE_DECL void LOCK_MINIMAP_ANGLE(int angle) { invoke<Void>(0x0BFD145EF819FB3A, angle); } // 0x0BFD145EF819FB3A 0xDEC733E4 b1207
	NATIVE_DECL void UNLOCK_MINIMAP_ANGLE() { invoke<Void>(0x5373DE8E179BC2A0); } // 0x5373DE8E179BC2A0 0x742043F9 b1207
	// regionHash: https://github.com/femga/rdr3_discoveries/tree/master/graphics/minimap/wanted_regions
	NATIVE_DECL void _MAP_ENABLE_REGION_BLIP(Hash regionHash, Hash styleHash) { invoke<Void>(0x563FCB6620523917, regionHash, styleHash); } // 0x563FCB6620523917 b1207
	NATIVE_DECL void _MAP_DISABLE_REGION_BLIP(Hash regionHash) { invoke<Void>(0x6786D7AFAC3162B3, regionHash); } // 0x6786D7AFAC3162B3 b1207
	NATIVE_DECL BOOL _MAP_IS_REGION_HIGHLIGHTED_WITH_STYLE(Hash regionHash, Hash styleHash) { return invoke<BOOL>(0xE38450DBCBC70E3D, regionHash, styleHash); } // 0xE38450DBCBC70E3D b1207
	NATIVE_DECL void _MAP_DISCOVER_REGION(Hash discoveryHash) { invoke<Void>(0xD8C7162AB2E2AF45, discoveryHash); } // 0xD8C7162AB2E2AF45 b1207
	NATIVE_DECL void _MAP_DISCOVERY_SET_ENABLED(Hash discoveryHash) { invoke<Void>(0xDA98246C7A3C2189, discoveryHash); } // 0xDA98246C7A3C2189 b1207
	NATIVE_DECL BOOL _MAP_IS_DISCOVERY_ACTIVE(Hash discoveryHash) { return invoke<BOOL>(0x3F81EA4275D39D6F, discoveryHash); } // 0x3F81EA4275D39D6F b1207
	NATIVE_DECL void _SET_PAUSEMAP_COORDS_WITH_RADIUS(float x, float y, float z, float radius) { invoke<Void>(0xE0884C184728C75B, x, y, z, radius); } // 0xE0884C184728C75B b1207
	NATIVE_DECL void _SET_PAUSEMAP_COORDS_WITH_RADIUS(Vector3 vec, float radius) { invoke<Void>(0xE0884C184728C75B, vec.x, vec.y, vec.z, radius); } // 0xE0884C184728C75B b1207
	NATIVE_DECL void _0x7C9F4CDF402CA82A() { invoke<Void>(0x7C9F4CDF402CA82A); } // 0x7C9F4CDF402CA82A b1311
	// _CLEAR*
	NATIVE_DECL void _0x44813684F72B563C(Entity entity, Any p1) { invoke<Void>(0x44813684F72B563C, entity, p1); } // 0x44813684F72B563C b1207
	NATIVE_DECL void _0x97F6F158CC5B5CA2(Entity entity, Any p1) { invoke<Void>(0x97F6F158CC5B5CA2, entity, p1); } // 0x97F6F158CC5B5CA2 b1207
	NATIVE_DECL void _0xBB68D4D3CA3DE402(Any p0, Any p1) { invoke<Void>(0xBB68D4D3CA3DE402, p0, p1); } // 0xBB68D4D3CA3DE402 b1207
	NATIVE_DECL Any _0x3CB8859F04763C78(Any p0, Any p1) { return invoke<Any>(0x3CB8859F04763C78, p0, p1); } // 0x3CB8859F04763C78 b1207
	NATIVE_DECL void _0x7563CBCA99253D1A(Entity entity, Hash blip) { invoke<Void>(0x7563CBCA99253D1A, entity, blip); } // 0x7563CBCA99253D1A b1207
	NATIVE_DECL void _0x1726963E6049DB53(Any p0) { invoke<Void>(0x1726963E6049DB53, p0); } // 0x1726963E6049DB53 b1207
}

namespace MINIGAME
{
	NATIVE_DECL void _0x6480723D3BE535B6(Any p0) { invoke<Void>(0x6480723D3BE535B6, p0); } // 0x6480723D3BE535B6 b1207
	NATIVE_DECL void _0x3DF7EE3A76185108() { invoke<Void>(0x3DF7EE3A76185108); } // 0x3DF7EE3A76185108 b1207
	NATIVE_DECL Any _0xE1F365C4C8F259D8(Any p0, Any p1, Any p2) { return invoke<Any>(0xE1F365C4C8F259D8, p0, p1, p2); } // 0xE1F365C4C8F259D8 b1207
	NATIVE_DECL Any _0xE53A308AC35877A8() { return invoke<Any>(0xE53A308AC35877A8); } // 0xE53A308AC35877A8 b1207
	NATIVE_DECL Any _0x580F34C726387226(Any p0, Any p1) { return invoke<Any>(0x580F34C726387226, p0, p1); } // 0x580F34C726387226 b1207
	NATIVE_DECL void _0x0876326238914A3F() { invoke<Void>(0x0876326238914A3F); } // 0x0876326238914A3F b1207
	NATIVE_DECL Any _0x3FFE60DD8A936551(Any p0, Any p1) { return invoke<Any>(0x3FFE60DD8A936551, p0, p1); } // 0x3FFE60DD8A936551 b1207
	NATIVE_DECL void _0x18A0D48DF9211C07() { invoke<Void>(0x18A0D48DF9211C07); } // 0x18A0D48DF9211C07 b1207
	NATIVE_DECL Any _MINIGAME_IS_CONNECTED_TO_SERVER(Any p0) { return invoke<Any>(0x2A0C4736AC5AF0CE, p0); } // 0x2A0C4736AC5AF0CE b1207
	NATIVE_DECL Any _0x39654E1F68B78287() { return invoke<Any>(0x39654E1F68B78287); } // 0x39654E1F68B78287 b1207
	NATIVE_DECL Any _0x3EECAADAB0D9FE29() { return invoke<Any>(0x3EECAADAB0D9FE29); } // 0x3EECAADAB0D9FE29 b1207
	NATIVE_DECL Any _0xD39D32EB3B52DD83(Any p0) { return invoke<Any>(0xD39D32EB3B52DD83, p0); } // 0xD39D32EB3B52DD83 b1207
	NATIVE_DECL BOOL _MINIGAME_IS_SEAT_OCCUPIED(Any p0) { return invoke<BOOL>(0x8593A8CB0ED2C3B4, p0); } // 0x8593A8CB0ED2C3B4 b1207
	NATIVE_DECL BOOL _MINIGAME_REQUEST_SEAT_AT_TABLE(Any* data) { return invoke<BOOL>(0xF6AC6085D8D6C004, data); } // 0xF6AC6085D8D6C004 b1207
	NATIVE_DECL Any _MINIGAME_LEAVE_TABLE(Any p0) { return invoke<Any>(0xF5446E47941E654C, p0); } // 0xF5446E47941E654C b1207
	NATIVE_DECL Any _MINIGAME_GET_NEXT_EVENT_TYPE() { return invoke<Any>(0x578907F59BA01B6C); } // 0x578907F59BA01B6C b1207
	NATIVE_DECL Any _MINIGAME_GET_NEXT_EVENT(Any p0, Any p1) { return invoke<Any>(0xDF728C5AE137FC13, p0, p1); } // 0xDF728C5AE137FC13 b1207
	NATIVE_DECL void _MINIGAME_POP_NEXT_EVENT() { invoke<Void>(0x833E03BAEBADC4B0); } // 0x833E03BAEBADC4B0 b1207
	NATIVE_DECL Any _0x3B31732FADE5BAF3() { return invoke<Any>(0x3B31732FADE5BAF3); } // 0x3B31732FADE5BAF3 b1207
	NATIVE_DECL Any _0x578907F59BA01B6D(Any p0) { return invoke<Any>(0x578907F59BA01B6D, p0); } // 0x578907F59BA01B6D b1207
	NATIVE_DECL Any _0xDF728C5AE137FC14(Any p0, Any p1, Any p2) { return invoke<Any>(0xDF728C5AE137FC14, p0, p1, p2); } // 0xDF728C5AE137FC14 b1207
	NATIVE_DECL Any _MINIGAME_IS_REQUEST_PENDING(Any p0) { return invoke<Any>(0x9105A4A2556FA937, p0); } // 0x9105A4A2556FA937 b1207
	NATIVE_DECL Any _0x644439B5387EE57E(Any p0, Any p1) { return invoke<Any>(0x644439B5387EE57E, p0, p1); } // 0x644439B5387EE57E b1207
	NATIVE_DECL Any _0x15E90B6A993017AA() { return invoke<Any>(0x15E90B6A993017AA); } // 0x15E90B6A993017AA b1207
	NATIVE_DECL Any _0x10342CC82E8356E9(Any p0, Any p1) { return invoke<Any>(0x10342CC82E8356E9, p0, p1); } // 0x10342CC82E8356E9 b1207
	NATIVE_DECL Any _0x32A7C216344D623B(Any p0, Any p1, Any p2) { return invoke<Any>(0x32A7C216344D623B, p0, p1, p2); } // 0x32A7C216344D623B b1207
	NATIVE_DECL Any _0xEC819D612038EF4B(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { return invoke<Any>(0xEC819D612038EF4B, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xEC819D612038EF4B b1207
	NATIVE_DECL Any _POKER_GET_GAME_SETTINGS_FOR_ID(Any p0) { return invoke<Any>(0x2D20E12E1990D584, p0); } // 0x2D20E12E1990D584 b1207
	NATIVE_DECL Any _POKER_BUY_IN(Any p0, Any p1) { return invoke<Any>(0xB4D610EA5A1FDE74, p0, p1); } // 0xB4D610EA5A1FDE74 b1207
	NATIVE_DECL Any _POKER_CALL(Any p0, Any p1) { return invoke<Any>(0x8DED681B161EBD78, p0, p1); } // 0x8DED681B161EBD78 b1207
	NATIVE_DECL Any _POKER_CHECK(Any p0, Any p1) { return invoke<Any>(0x49A045628D9B1B86, p0, p1); } // 0x49A045628D9B1B86 b1207
	NATIVE_DECL Any _POKER_FOLD(Any p0) { return invoke<Any>(0x3DFAB7D9BB45B5BE, p0); } // 0x3DFAB7D9BB45B5BE b1207
	NATIVE_DECL Any _POKER_RAISE(Any p0, Any p1) { return invoke<Any>(0xECCF45A79A17BB96, p0, p1); } // 0xECCF45A79A17BB96 b1207
	NATIVE_DECL Any _POKER_REVEAL(Any p0) { return invoke<Any>(0x2F2131DB0A8B02DC, p0); } // 0x2F2131DB0A8B02DC b1207
	NATIVE_DECL void _0x58521E6DCDE97D74(Any p0, Any p1, Any p2) { invoke<Void>(0x58521E6DCDE97D74, p0, p1, p2); } // 0x58521E6DCDE97D74 b1207
	NATIVE_DECL void _0xF6DE98516FD3AC9B() { invoke<Void>(0xF6DE98516FD3AC9B); } // 0xF6DE98516FD3AC9B b1207
	NATIVE_DECL Any _0x3F4FD4BED07AB8C4(Any p0) { return invoke<Any>(0x3F4FD4BED07AB8C4, p0); } // 0x3F4FD4BED07AB8C4 b1207
	NATIVE_DECL Any _0x3AE451860F03CA8A(Any p0, Any p1) { return invoke<Any>(0x3AE451860F03CA8A, p0, p1); } // 0x3AE451860F03CA8A b1207
	NATIVE_DECL Any _0x012027C28F421F46(Any p0, Any p1) { return invoke<Any>(0x012027C28F421F46, p0, p1); } // 0x012027C28F421F46 b1207
	NATIVE_DECL void _0x455ECCA0715C507F() { invoke<Void>(0x455ECCA0715C507F); } // 0x455ECCA0715C507F b1207
	NATIVE_DECL Any _DOMINOES_BUY_IN(Any p0) { return invoke<Any>(0x399E6CD12FC8CA89, p0); } // 0x399E6CD12FC8CA89 b1207
	NATIVE_DECL Any _DOMINOES_PLACE_DOMINO(Any p0, Any p1) { return invoke<Any>(0xB79A29B33BF29BA5, p0, p1); } // 0xB79A29B33BF29BA5 b1207
	NATIVE_DECL Any _DOMINOES_REQUEST_VALID_PLACEMENTS(Any p0) { return invoke<Any>(0xE26AEE7E67D9E21D, p0); } // 0xE26AEE7E67D9E21D b1207
	NATIVE_DECL Any _0xA2DB3C6270C122E3(Any p0, Any p1) { return invoke<Any>(0xA2DB3C6270C122E3, p0, p1); } // 0xA2DB3C6270C122E3 b1207
	NATIVE_DECL Any _0x398066F893149856(Any p0, Any p1, Any p2) { return invoke<Any>(0x398066F893149856, p0, p1, p2); } // 0x398066F893149856 b1207
	NATIVE_DECL Any _0xBEA7D3CB47E1479C() { return invoke<Any>(0xBEA7D3CB47E1479C); } // 0xBEA7D3CB47E1479C b1207
	NATIVE_DECL Any _0x910B088E51A511AC() { return invoke<Any>(0x910B088E51A511AC); } // 0x910B088E51A511AC b1207
	NATIVE_DECL Any _0x9DD95B405AB4983E(Any p0, Any p1) { return invoke<Any>(0x9DD95B405AB4983E, p0, p1); } // 0x9DD95B405AB4983E b1207
}

namespace MISC
{
	NATIVE_DECL int GET_NUMBER_OF_FREE_STACKS_OF_THIS_SIZE(int stackSize) { return invoke<int>(0x40DC2907A9697EF7, stackSize); } // 0x40DC2907A9697EF7 0x11A178B8 b1207
	NATIVE_DECL int _GET_NUMBER_OF_INSTRUCTIONS() { return invoke<int>(0x72904D3D62AF5839); } // 0x72904D3D62AF5839 b1207
	NATIVE_DECL int _GET_MAX_NUM_INSTRUCTIONS() { return invoke<int>(0xC43CD2668B204419); } // 0xC43CD2668B204419 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL IS_MAG_DEMO_1_ACTIVE() { return invoke<BOOL>(0x5FC9357C26DAEFCE); } // 0x5FC9357C26DAEFCE b1207
	NATIVE_DECL void SET_RANDOM_SEED(int seed) { invoke<Void>(0x5CD7A49104AFCB6B, seed); } // 0x5CD7A49104AFCB6B 0xDB3FEB5C b1207
	// Maximum value is 1.0f
	// At a value of 0.0f the game will still run at a minimum time scale.
	NATIVE_DECL void SET_TIME_SCALE(float timeScale) { invoke<Void>(0x9682AF6050854856, timeScale); } // 0x9682AF6050854856 0xA7F84694 b1207
	// If true, the player can't save the game.
	NATIVE_DECL void SET_MISSION_FLAG(BOOL toggle) { invoke<Void>(0x36694B456BE80D0A, toggle); } // 0x36694B456BE80D0A 0x57592D52 b1207
	NATIVE_DECL BOOL GET_MISSION_FLAG() { return invoke<BOOL>(0xB15CD1CF58771DE1); } // 0xB15CD1CF58771DE1 0x95115F97 b1207
	NATIVE_DECL void _0x5801BE2DF2AF07EC(Any p0) { invoke<Void>(0x5801BE2DF2AF07EC, p0); } // 0x5801BE2DF2AF07EC b1207
	// If the parameter is true, sets the random event flag to true, if the parameter is false, the function does nothing at all.
	// Does nothing if the mission flag is set.
	NATIVE_DECL void SET_RANDOM_EVENT_FLAG(BOOL toggle) { invoke<Void>(0xB1ADCCC4150C6473, toggle); } // 0xB1ADCCC4150C6473 0xA77F31E8 b1207
	NATIVE_DECL BOOL GET_RANDOM_EVENT_FLAG() { return invoke<BOOL>(0x924D54E5698AE3E0); } // 0x924D54E5698AE3E0 0x794CC92C b1207
	NATIVE_DECL void _0x9BF2C0C568C61641(Any p0) { invoke<Void>(0x9BF2C0C568C61641, p0); } // 0x9BF2C0C568C61641 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xCC7FC854B956A128(const char* p0, const char* p1) { invoke<Void>(0xCC7FC854B956A128, p0, p1); } // 0xCC7FC854B956A128 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x9935F76407C32539(const char* p0) { invoke<Void>(0x9935F76407C32539, p0); } // 0x9935F76407C32539 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xFF252E2BAFB7330F(Any p0) { invoke<Void>(0xFF252E2BAFB7330F, p0); } // 0xFF252E2BAFB7330F b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x91D657230BC208D2(const char* p0, const char* p1) { invoke<Void>(0x91D657230BC208D2, p0, p1); } // 0x91D657230BC208D2 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x1694A053DFB61A34(const char* p0) { invoke<Void>(0x1694A053DFB61A34, p0); } // 0x1694A053DFB61A34 b1207
	// Hardcoded to return one/true.
	NATIVE_DECL Any _0xAF530E56505D1BD6(Any p0) { return invoke<Any>(0xAF530E56505D1BD6, p0); } // 0xAF530E56505D1BD6 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xB16FC7B364D86585() { invoke<Void>(0xB16FC7B364D86585); } // 0xB16FC7B364D86585 b1207
	NATIVE_DECL const char* _0xF81C53561D15F330() { return invoke<const char*>(0xF81C53561D15F330); } // 0xF81C53561D15F330 b1207
	NATIVE_DECL void _0x1096603B519C905F(const char* name) { invoke<Void>(0x1096603B519C905F, name); } // 0x1096603B519C905F b1207
	NATIVE_DECL void _0xCC3EDC5614B03F61(int p0) { invoke<Void>(0xCC3EDC5614B03F61, p0); } // 0xCC3EDC5614B03F61 b1207
	NATIVE_DECL void _0x708DF841B8F27AA2(const char* p0) { invoke<Void>(0x708DF841B8F27AA2, p0); } // 0x708DF841B8F27AA2 0xE77199F7 b1207
	NATIVE_DECL void _0xDA4D8EB04E8E2928(Any p0) { invoke<Void>(0xDA4D8EB04E8E2928, p0); } // 0xDA4D8EB04E8E2928 b1207
	NATIVE_DECL void _0xB08C4FA25BC29DB9(Any p0) { invoke<Void>(0xB08C4FA25BC29DB9, p0); } // 0xB08C4FA25BC29DB9 b1207
	NATIVE_DECL Hash _GET_PREV_WEATHER_TYPE_HASH_NAME() { return invoke<Hash>(0x4BEB42AEBCA732E9); } // 0x4BEB42AEBCA732E9 b1207
	NATIVE_DECL Hash _GET_NEXT_WEATHER_TYPE_HASH_NAME() { return invoke<Hash>(0x51021D36F62AAA83); } // 0x51021D36F62AAA83 b1207
	NATIVE_DECL void _0x0730E518486DEEC3(Any p0) { invoke<Void>(0x0730E518486DEEC3, p0); } // 0x0730E518486DEEC3 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/weather/weather_types.lua
	NATIVE_DECL void SET_WEATHER_TYPE(Hash weatherType, BOOL p1, BOOL p2, BOOL transition, float transitionTime, BOOL p5) { invoke<Void>(0x59174F1AFE095B5A, weatherType, p1, p2, transition, transitionTime, p5); } // 0x59174F1AFE095B5A b1207
	NATIVE_DECL void _SET_WEATHER_TYPE_2(Hash weatherType, int p1, int p2, int p3, BOOL p4) { invoke<Void>(0x2C6A07AF9AEDABD8, weatherType, p1, p2, p3, p4); } // 0x2C6A07AF9AEDABD8 b1207
	NATIVE_DECL int _GET_RANDOM_WEATHER_TYPE_INDEX() { return invoke<int>(0x7F4CE164D9A11DFE); } // 0x7F4CE164D9A11DFE b1207
	NATIVE_DECL Hash _GET_RANDOM_WEATHER_TYPE() { return invoke<Hash>(0x1359C181BC625503); } // 0x1359C181BC625503 b1207
	NATIVE_DECL void SET_RANDOM_WEATHER_TYPE(BOOL p0, BOOL p1) { invoke<Void>(0x6E5A7FBEECAB3C72, p0, p1); } // 0x6E5A7FBEECAB3C72 0xE7AA1BC9 b1207
	NATIVE_DECL void CLEAR_WEATHER_TYPE_PERSIST() { invoke<Void>(0xD85DFE5C131E4AE9); } // 0xD85DFE5C131E4AE9 0x6AB757D8 b1207
	NATIVE_DECL void _CLEAR_WEATHER_TYPE_PERSIST_OVERTIME(int milliseconds) { invoke<Void>(0xCE7690C0A0D1C36D, milliseconds); } // 0xCE7690C0A0D1C36D b1207
	// Params: percentWeather2: 0f - 0.75f in R* Scripts
	NATIVE_DECL void _GET_WEATHER_TYPE_TRANSITION(Hash* weatherType1, Hash* weatherType2, float* percentWeather2) { invoke<Void>(0x0AC679B2342F14F2, weatherType1, weatherType2, percentWeather2); } // 0x0AC679B2342F14F2 0x9A5C1D56 b1207
	// Params: BOOL p3 is always true
	NATIVE_DECL void _SET_WEATHER_TYPE_TRANSITION(Hash weatherType1, Hash weatherType2, float percentWeather2, BOOL enabled) { invoke<Void>(0xFA3E3CA8A1DE6D5D, weatherType1, weatherType2, percentWeather2, enabled); } // 0xFA3E3CA8A1DE6D5D 0x5CA74040 b1207
	NATIVE_DECL void _SET_WEATHER_TYPE_FROZEN(BOOL toggle) { invoke<Void>(0xD74ACDF7DB8114AF, toggle); } // 0xD74ACDF7DB8114AF b1207
	// Returns the weather type that has been set by a script
	NATIVE_DECL void _GET_FORCED_WEATHER(Hash* weather, Hash* p1) { invoke<Void>(0xDD560ABEF5D3784C, weather, p1); } // 0xDD560ABEF5D3784C b1207
	NATIVE_DECL void _0x2916B30DC6C41179(Hash weatherType) { invoke<Void>(0x2916B30DC6C41179, weatherType); } // 0x2916B30DC6C41179 b1207
	NATIVE_DECL void _0xD3F943B88F55376A(Hash weatherType) { invoke<Void>(0xD3F943B88F55376A, weatherType); } // 0xD3F943B88F55376A b1207
	NATIVE_DECL void _0x243CEDE8F916B994() { invoke<Void>(0x243CEDE8F916B994); } // 0x243CEDE8F916B994 b1207
	NATIVE_DECL void _SET_OVERRIDE_WEATHER(Hash weatherType) { invoke<Void>(0xBE83CAE8ED77A94F, weatherType); } // 0xBE83CAE8ED77A94F b1207
	NATIVE_DECL void CLEAR_OVERRIDE_WEATHER() { invoke<Void>(0x80A398F16FFE3CC3); } // 0x80A398F16FFE3CC3 0x7740EA4E b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/weather/weather_variations.lua
	NATIVE_DECL void _SET_WEATHER_VARIATION(const char* weatherType, const char* variation) { invoke<Void>(0x3373779BAF7CAF48, weatherType, variation); } // 0x3373779BAF7CAF48 b1207
	NATIVE_DECL void _CLEAR_WEATHER_VARIATION(const char* weatherType, BOOL p1) { invoke<Void>(0x0E71C80FA4EC8147, weatherType, p1); } // 0x0E71C80FA4EC8147 b1207
	// Only used in smuggler2 script
	NATIVE_DECL void WATER_OVERRIDE_SET_SHOREWAVEAMPLITUDE(float amplitude) { invoke<Void>(0x55123D5A7D9D3C42, amplitude); } // 0x55123D5A7D9D3C42 0x625181DC b1207
	// Only used in smuggler2 script
	NATIVE_DECL void WATER_OVERRIDE_SET_OCEANWAVEMAXAMPLITUDE(float maxAmplitude) { invoke<Void>(0xF06C5B66DE20B2B8, maxAmplitude); } // 0xF06C5B66DE20B2B8 0x0DE40C28 b1207
	NATIVE_DECL float _GET_TEMPERATURE_AT_COORDS(float x, float y, float z) { return invoke<float>(0xB98B78C3768AF6E0, x, y, z); } // 0xB98B78C3768AF6E0 b1207
	NATIVE_DECL float _GET_TEMPERATURE_AT_COORDS(Vector3 vec) { return invoke<float>(0xB98B78C3768AF6E0, vec.x, vec.y, vec.z); } // 0xB98B78C3768AF6E0 b1207
	NATIVE_DECL void SET_WIND_SPEED(float speed) { invoke<Void>(0xD00C2D82DC04A99F, speed); } // 0xD00C2D82DC04A99F 0x45705F94 b1207
	NATIVE_DECL float GET_WIND_SPEED() { return invoke<float>(0xFFB7E74E041150A4); } // 0xFFB7E74E041150A4 0x098F0F3C b1207
	NATIVE_DECL void SET_WIND_DIRECTION(float direction) { invoke<Void>(0xB56C4F5F57A45600, direction); } // 0xB56C4F5F57A45600 0x381AEEE9 b1207
	NATIVE_DECL Vector3 GET_WIND_DIRECTION() { return invoke<Vector3>(0xF703E82F3FE14A5F); } // 0xF703E82F3FE14A5F 0x89499A0D b1207
	NATIVE_DECL void _SET_RAIN_LEVEL(float intensity) { invoke<Void>(0x193DFC0526830FD6, intensity); } // 0x193DFC0526830FD6 b1207
	NATIVE_DECL float GET_RAIN_LEVEL() { return invoke<float>(0x931B5F4CC130224B); } // 0x931B5F4CC130224B 0xC9F67F28 b1207
	NATIVE_DECL void _0x745808BB01CEC6B9(float p0) { invoke<Void>(0x745808BB01CEC6B9, p0); } // 0x745808BB01CEC6B9 b1207
	NATIVE_DECL void _SET_SNOW_LEVEL(float level) { invoke<Void>(0xF6BEE7E80EC5CA40, level); } // 0xF6BEE7E80EC5CA40 b1207
	NATIVE_DECL float GET_SNOW_LEVEL() { return invoke<float>(0x1E5D727041BE1709); } // 0x1E5D727041BE1709 0x1B09184F b1207
	// creates single lightning+thunder at random position
	NATIVE_DECL void FORCE_LIGHTNING_FLASH() { invoke<Void>(0x369DB5B2510FA080); } // 0x369DB5B2510FA080 0xDF38165E b1207
	// p3 is always -1.0f in the scripts
	NATIVE_DECL void _FORCE_LIGHTNING_FLASH_AT_COORDS(float x, float y, float z, float p3) { invoke<Void>(0x67943537D179597C, x, y, z, p3); } // 0x67943537D179597C b1207
	NATIVE_DECL void _FORCE_LIGHTNING_FLASH_AT_COORDS(Vector3 vec, float p3) { invoke<Void>(0x67943537D179597C, vec.x, vec.y, vec.z, p3); } // 0x67943537D179597C b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xA9342743B634A462(Any p0) { invoke<Void>(0xA9342743B634A462, p0); } // 0xA9342743B634A462 b1207
	NATIVE_DECL int GET_GAME_TIMER() { return invoke<int>(0x4F67E8ECA7D3F667); } // 0x4F67E8ECA7D3F667 0xA4EA0691 b1207
	// Returns rage::fwTimer::sm_nonScaledClippedTime
	NATIVE_DECL int _GET_GAME_TIMER_NON_SCALED_CLIPPED() { return invoke<int>(0x483B8C542103AD72); } // 0x483B8C542103AD72 b1207
	NATIVE_DECL int GET_SYSTEM_TIME() { return invoke<int>(0xBE7F225417E35A7C); } // 0xBE7F225417E35A7C b1207
	NATIVE_DECL int _GET_NUMBER_OF_MICROSECONDS_SINCE_LAST_CALL() { return invoke<int>(0xB0CE5E5ED8BB3581); } // 0xB0CE5E5ED8BB3581 b1207
	NATIVE_DECL int _GET_SCRIPT_TIME_WITHIN_FRAME_IN_MICROSECONDS() { return invoke<int>(0x63219768C586667C); } // 0x63219768C586667C b1207
	NATIVE_DECL void _RESET_SCRIPT_TIME_WITHIN_FRAME() { invoke<Void>(0x1411A7CBC3A6EB7B); } // 0x1411A7CBC3A6EB7B b1207
	NATIVE_DECL float GET_FRAME_TIME() { return invoke<float>(0x5E72022914CE3C38); } // 0x5E72022914CE3C38 0x96374262 b1207
	NATIVE_DECL float _GET_BENCHMARK_TIME() { return invoke<float>(0x3F3172FEAE3AFE1C); } // 0x3F3172FEAE3AFE1C b1207
	NATIVE_DECL int GET_FRAME_COUNT() { return invoke<int>(0x77DFA958FCF100C1); } // 0x77DFA958FCF100C1 0xB477A015 b1207
	NATIVE_DECL void _0x6BED40493A1AFDB8(Any* p0, float p1) { invoke<Void>(0x6BED40493A1AFDB8, p0, p1); } // 0x6BED40493A1AFDB8 b1207
	// Reads the passed value as floating point value and returns it.
	// Example: _READ_INT_AS_FLOAT(0x3F800000) returns 1.0f because 0x3F800000 is the hexadecimal representation of 1.0f.
	NATIVE_DECL float _READ_INT_AS_FLOAT(int value) { return invoke<float>(0xD2C9126410DFA1B2, value); } // 0xD2C9126410DFA1B2 b1207
	NATIVE_DECL float GET_RANDOM_FLOAT_IN_RANGE(float startRange, float endRange) { return invoke<float>(0xE29F927A961F8AAA, startRange, endRange); } // 0xE29F927A961F8AAA 0x0562C4D0 b1207
	NATIVE_DECL int GET_RANDOM_INT_IN_RANGE(int startRange, int endRange) { return invoke<int>(0xD53343AA4FB7DD28, startRange, endRange); } // 0xD53343AA4FB7DD28 0x4051115B b1207
	NATIVE_DECL BOOL GET_GROUND_Z_FOR_3D_COORD(float x, float y, float z, float* groundZ, BOOL p4) { return invoke<BOOL>(0x24FA4267BB8D2431, x, y, z, groundZ, p4); } // 0x24FA4267BB8D2431 0xA1BFD5E0 b1207
	NATIVE_DECL BOOL GET_GROUND_Z_FOR_3D_COORD(Vector3 vec, float* groundZ, BOOL p4) { return invoke<BOOL>(0x24FA4267BB8D2431, vec.x, vec.y, vec.z, groundZ, p4); } // 0x24FA4267BB8D2431 0xA1BFD5E0 b1207
	NATIVE_DECL BOOL GET_GROUND_Z_AND_NORMAL_FOR_3D_COORD(float x, float y, float z, float* groundZ, Vector3* normal) { return invoke<BOOL>(0x2A29CA9A6319E6AB, x, y, z, groundZ, normal); } // 0x2A29CA9A6319E6AB 0x64D91CED b1207
	NATIVE_DECL BOOL GET_GROUND_Z_AND_NORMAL_FOR_3D_COORD(Vector3 vec, float* groundZ, Vector3* normal) { return invoke<BOOL>(0x2A29CA9A6319E6AB, vec.x, vec.y, vec.z, groundZ, normal); } // 0x2A29CA9A6319E6AB 0x64D91CED b1207
	NATIVE_DECL Any _0xBBE5B63EFFB08E68(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0xBBE5B63EFFB08E68, p0, p1, p2, p3, p4, p5, p6); } // 0xBBE5B63EFFB08E68 b1207
	NATIVE_DECL float ASIN(float p0) { return invoke<float>(0x6E3C15D296C15583, p0); } // 0x6E3C15D296C15583 0x998E5CAD b1207
	NATIVE_DECL float ACOS(float p0) { return invoke<float>(0x586690F0176DC575, p0); } // 0x586690F0176DC575 0xF4038776 b1207
	NATIVE_DECL float TAN(float p0) { return invoke<float>(0x8C13DB96497B7ABF, p0); } // 0x8C13DB96497B7ABF 0xD320CE5E b1207
	NATIVE_DECL float ATAN(float p0) { return invoke<float>(0x503054DED0B78027, p0); } // 0x503054DED0B78027 0x7A03CC8E b1207
	NATIVE_DECL float ATAN2(float p0, float p1) { return invoke<float>(0x965B220A066E3F07, p0, p1); } // 0x965B220A066E3F07 0x2508AC81 b1207
	// If useZ is false, only the 2D plane (X-Y) will be considered for calculating the distance.
	// 
	// Consider using this faster native instead: BUILTIN::VDIST - DVIST always takes in consideration the 3D coordinates.
	NATIVE_DECL float GET_DISTANCE_BETWEEN_COORDS(float x1, float y1, float z1, float x2, float y2, float z2, BOOL useZ) { return invoke<float>(0x0BE7F4E3CDBAFB28, x1, y1, z1, x2, y2, z2, useZ); } // 0x0BE7F4E3CDBAFB28 0xF698765E b1207
	NATIVE_DECL float GET_DISTANCE_BETWEEN_COORDS(Vector3 vec1, Vector3 vec2, BOOL useZ) { return invoke<float>(0x0BE7F4E3CDBAFB28, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, useZ); } // 0x0BE7F4E3CDBAFB28 0xF698765E b1207
	NATIVE_DECL float GET_ANGLE_BETWEEN_2D_VECTORS(float x1, float y1, float x2, float y2) { return invoke<float>(0xD0DFE1C486097BBB, x1, y1, x2, y2); } // 0xD0DFE1C486097BBB 0xDBF75E58 b1207
	NATIVE_DECL float GET_ANGLE_BETWEEN_2D_VECTORS(Vector2 vec1, Vector2 vec2) { return invoke<float>(0xD0DFE1C486097BBB, vec1.x, vec1.y, vec2.x, vec2.y); } // 0xD0DFE1C486097BBB 0xDBF75E58 b1207
	// dx = x1 - x2
	// dy = y1 - y2
	NATIVE_DECL float GET_HEADING_FROM_VECTOR_2D(float dx, float dy) { return invoke<float>(0x38D5202FF9271C62, dx, dy); } // 0x38D5202FF9271C62 0xD209D52B b1207
	NATIVE_DECL Vector3 GET_CLOSEST_POINT_ON_LINE(float p0, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, BOOL p9) { return invoke<Vector3>(0x83ACC65D9ACEC5EF, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0x83ACC65D9ACEC5EF 0xCAECF37E b1207
	NATIVE_DECL BOOL _0xAB6A04CEC428258B(float p0, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float p9, float p10, float p11, float* p12) { return invoke<BOOL>(0xAB6A04CEC428258B, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); } // 0xAB6A04CEC428258B 0xC6CC812C b1207
	NATIVE_DECL void SET_BIT(int* address, int offset) { invoke<Void>(0xF73FBE4845C43B5B, address, offset); } // 0xF73FBE4845C43B5B 0x4EFE7E6B b1207
	NATIVE_DECL void CLEAR_BIT(int* address, int offset) { invoke<Void>(0x7D1D4A3602B6AD4E, address, offset); } // 0x7D1D4A3602B6AD4E 0x8BC9E618 b1207
	NATIVE_DECL BOOL _IS_BIT_FLAG_SET(Any* bitFlags, int flag) { return invoke<BOOL>(0x8F4F050054005C27, bitFlags, flag); } // 0x8F4F050054005C27 b1207
	NATIVE_DECL BOOL _IS_ANY_BIT_FLAG_SET(Any* bitFlags) { return invoke<BOOL>(0x80E9C316EF84DD81, bitFlags); } // 0x80E9C316EF84DD81 b1207
	NATIVE_DECL int _COUNT_BIT_FLAGS(Any* bitFlags) { return invoke<int>(0xE704838F36F93B7B, bitFlags); } // 0xE704838F36F93B7B b1355
	// Similar to SET_BIT but specifically designed for large (>32 flags) bit flag sets.
	// The flags are stored in an int array where each int has the ability to hold 32 flags.
	// Flags 0-31 would be stored in the first int, flags 32-63 in the second int, etc.
	NATIVE_DECL void _SET_BIT_FLAG(Any* bitFlags, int flag) { invoke<Void>(0xE84AAC1B22A73E99, bitFlags, flag); } // 0xE84AAC1B22A73E99 b1207
	NATIVE_DECL void _CLEAR_BIT_FLAG(Any* bitFlags, int flag) { invoke<Void>(0xB909149F2BB5F6DA, bitFlags, flag); } // 0xB909149F2BB5F6DA b1207
	NATIVE_DECL void _CLEAR_ALL_BIT_FLAGS(Any* bitFlags) { invoke<Void>(0xD2D74F89DF844A50, bitFlags); } // 0xD2D74F89DF844A50 b1207
	// Computes a hash for the given string. It is hashed using Jenkins' One-at-a-Time hash algorithm (https://en.wikipedia.org/wiki/Jenkins_hash_function)
	// Note: this implementation is case-insensitive.
	NATIVE_DECL Hash GET_HASH_KEY(const char* string) { return invoke<Hash>(0xFD340785ADF8CFB7, string); } // 0xFD340785ADF8CFB7 0x98EFF6F1 b1207
	// enum class eEasingCurveType
	// {
	// 	TYPE_LINEAR,
	// 	TYPE_QUADRATIC_IN,
	// 	TYPE_QUADRATIC_OUT,
	// 	TYPE_QUADRATIC_INOUT,
	// 	TYPE_CUBIC_IN,
	// 	TYPE_CUBIC_OUT,
	// 	TYPE_CUBIC_INOUT,
	// 	TYPE_QUARTIC_IN,
	// 	TYPE_QUARTIC_OUT,
	// 	TYPE_QUARTIC_INOUT,
	// 	TYPE_QUINTIC_IN,
	// 	TYPE_QUINTIC_OUT,
	// 	TYPE_QUINTIC_INOUT,
	// 	TYPE_EXPONENTIAL_IN,
	// 	TYPE_EXPONENTIAL_OUT,
	// 	TYPE_EXPONENTIAL_INOUT,
	// 	TYPE_SINE_IN,
	// 	TYPE_SINE_OUT,
	// 	TYPE_SINE_INOUT,
	// 	TYPE_CIRCULAR_IN,
	// 	TYPE_CIRCULAR_OUT,
	// 	TYPE_CIRCULAR_INOUT,
	// 	TYPE_BOUNCE_IN,
	// 	TYPE_BOUNCE_OUT,
	// 	TYPE_BOUNCE_INOUT,
	// 	TYPE_CUSTOM
	// };
	NATIVE_DECL float _GET_EASING_CURVE_VALUE(float t, float b, float d, int easingCurveType) { return invoke<float>(0xEF50E344A8F93784, t, b, d, easingCurveType); } // 0xEF50E344A8F93784 b1207
	NATIVE_DECL BOOL IS_POSITION_OCCUPIED(float x, float y, float z, float range, BOOL p4, BOOL p5, BOOL p6, BOOL p7, BOOL p8, Any p9, BOOL p10) { return invoke<BOOL>(0x825CA3ED43831015, x, y, z, range, p4, p5, p6, p7, p8, p9, p10); } // 0x825CA3ED43831015 0x452E8D9E b1207
	NATIVE_DECL BOOL IS_POSITION_OCCUPIED(Vector3 vec, float range, BOOL p4, BOOL p5, BOOL p6, BOOL p7, BOOL p8, Any p9, BOOL p10) { return invoke<BOOL>(0x825CA3ED43831015, vec.x, vec.y, vec.z, range, p4, p5, p6, p7, p8, p9, p10); } // 0x825CA3ED43831015 0x452E8D9E b1207
	// flag |= 1 | 1048576 | 524288
	// ALL_BASE, PROJECTILES, AMBIENT_POPULATION, BROADCAST
	NATIVE_DECL void CLEAR_AREA(float x, float y, float z, float radius, int flag) { invoke<Void>(0x3B882A96EA77D5B1, x, y, z, radius, flag); } // 0x3B882A96EA77D5B1 0x854E9AB8 b1207
	NATIVE_DECL void CLEAR_AREA(Vector3 vec, float radius, int flag) { invoke<Void>(0x3B882A96EA77D5B1, vec.x, vec.y, vec.z, radius, flag); } // 0x3B882A96EA77D5B1 0x854E9AB8 b1207
	NATIVE_DECL void _CLEAR_VOLUME_AREA(Volume volume, int flag) { invoke<Void>(0x2FCD528A397E5C88, volume, flag); } // 0x2FCD528A397E5C88 b1207
	NATIVE_DECL void CLEAR_ANGLED_AREA_OF_VEHICLES(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xA4D83115C1E02F8A, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xA4D83115C1E02F8A 0xF11A3018 b1207
	NATIVE_DECL void SET_CREDITS_ACTIVE(BOOL toggle) { invoke<Void>(0xD37BECF862DA726F, toggle); } // 0xD37BECF862DA726F 0xEC2A0ECF b1207
	NATIVE_DECL void NETWORK_SET_SCRIPT_IS_SAFE_FOR_NETWORK_GAME() { invoke<Void>(0x3D0EAC6385DD6100); } // 0x3D0EAC6385DD6100 0x878486CE b1207
	NATIVE_DECL void PAUSE_DEATH_ARREST_RESTART(BOOL toggle) { invoke<Void>(0x66AB6B6C7E72F393, toggle); } // 0x66AB6B6C7E72F393 0x296574AE b1207
	NATIVE_DECL void IGNORE_NEXT_RESTART(BOOL toggle) { invoke<Void>(0x6C9FF40FF1B69F8F, toggle); } // 0x6C9FF40FF1B69F8F 0xDA13A4B6 b1207
	// Sets whether the game should fade in after the player dies or is arrested.
	NATIVE_DECL void SET_FADE_IN_AFTER_DEATH_ARREST(BOOL toggle) { invoke<Void>(0xDF3B5846DE5904AF, toggle); } // 0xDF3B5846DE5904AF 0xACDE6985 b1207
	NATIVE_DECL void SET_FADE_IN_AFTER_LOAD(BOOL toggle) { invoke<Void>(0xAC806C4CAB973517, toggle); } // 0xAC806C4CAB973517 0x6E00EB0B b1207
	NATIVE_DECL BOOL OVERRIDE_SAVE_HOUSE(BOOL p0, float p1, float p2, float p3, float p4, BOOL p5, float p6, float p7) { return invoke<BOOL>(0xB2C69E11A37B5AF0, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xB2C69E11A37B5AF0 0x47436C12 b1207
	NATIVE_DECL void SHOOT_SINGLE_BULLET_BETWEEN_COORDS(float x1, float y1, float z1, float x2, float y2, float z2, int damage, BOOL p7, Hash weaponHash, Ped ownerPed, BOOL isAudible, BOOL isInvisible, float speed, BOOL p13) { invoke<Void>(0x867654CBC7606F2C, x1, y1, z1, x2, y2, z2, damage, p7, weaponHash, ownerPed, isAudible, isInvisible, speed, p13); } // 0x867654CBC7606F2C 0xCB7415AC b1207
	NATIVE_DECL void SHOOT_SINGLE_BULLET_BETWEEN_COORDS(Vector3 vec1, Vector3 vec2, int damage, BOOL p7, Hash weaponHash, Ped ownerPed, BOOL isAudible, BOOL isInvisible, float speed, BOOL p13) { invoke<Void>(0x867654CBC7606F2C, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, damage, p7, weaponHash, ownerPed, isAudible, isInvisible, speed, p13); } // 0x867654CBC7606F2C 0xCB7415AC b1207
	NATIVE_DECL void FIRE_SINGLE_BULLET(Any* args) { invoke<Void>(0xCBC9A21F6A2A679C, args); } // 0xCBC9A21F6A2A679C b1207
	NATIVE_DECL void GET_MODEL_DIMENSIONS(Hash modelHash, Vector3* minimum, Vector3* maximum) { invoke<Void>(0xDCB8DDD5D054A7E7, modelHash, minimum, maximum); } // 0xDCB8DDD5D054A7E7 0x91ABB8E0 b1207
	NATIVE_DECL BOOL IS_BIT_SET(int address, int offset) { return invoke<BOOL>(0x4ED6CFDFE8D4131A, address, offset); } // 0x4ED6CFDFE8D4131A 0x902E26AC b1207
	NATIVE_DECL void _0x0A487CC74A517FB5(Any p0) { invoke<Void>(0x0A487CC74A517FB5, p0); } // 0x0A487CC74A517FB5 b1207
	NATIVE_DECL BOOL IS_MINIGAME_IN_PROGRESS() { return invoke<BOOL>(0xF4D8BCD052E7EA1B); } // 0xF4D8BCD052E7EA1B 0x53A95E13 b1207
	// Returns whether the game's measurement system is set to metric.
	NATIVE_DECL BOOL SHOULD_USE_METRIC_MEASUREMENTS() { return invoke<BOOL>(0x4FB556ACEFA93098); } // 0x4FB556ACEFA93098 0xBAF17315 b1207
	// Same as SHOULD_USE_METRIC_MEASUREMENTS
	NATIVE_DECL BOOL _SHOULD_USE_METRIC_MEASUREMENTS_2() { return invoke<BOOL>(0x58BCDC75BA52110A); } // 0x58BCDC75BA52110A b1207
	NATIVE_DECL BOOL _SHOULD_USE_METRIC_TEMPERATURE() { return invoke<BOOL>(0xFF4AAF3275BAAB4F); } // 0xFF4AAF3275BAAB4F b1207
	NATIVE_DECL BOOL _SHOULD_USE_METRIC_WEIGHT() { return invoke<BOOL>(0x8F24157FEDB85EA2); } // 0x8F24157FEDB85EA2 b1207
	NATIVE_DECL BOOL _SHOULD_USE_24_HOUR_CLOCK() { return invoke<BOOL>(0x0177CF20345F44DD); } // 0x0177CF20345F44DD b1207
	NATIVE_DECL int COMPARE_STRINGS(const char* str1, const char* str2, BOOL matchCase, int maxLength) { return invoke<int>(0xBFBB74A15EFC149B, str1, str2, matchCase, maxLength); } // 0xBFBB74A15EFC149B 0xFE25A58F b1207
	NATIVE_DECL int ABSI(int value) { return invoke<int>(0x0C214D5B8A38C828, value); } // 0x0C214D5B8A38C828 0xB44677C5 b1207
	NATIVE_DECL float ABSF(float value) { return invoke<float>(0x134549B388167CBF, value); } // 0x134549B388167CBF 0xAF6F6E0B b1207
	// Determines whether there is a projectile within the specified coordinates. The coordinates form a rectangle.
	// 
	// ownedByPlayer = only projectiles fired by the player will be detected.
	NATIVE_DECL BOOL IS_PROJECTILE_IN_AREA(float x1, float y1, float z1, float x2, float y2, float z2, BOOL ownedByPlayer) { return invoke<BOOL>(0x05B0061EFDFC8941, x1, y1, z1, x2, y2, z2, ownedByPlayer); } // 0x05B0061EFDFC8941 0x78E1A557 b1207
	NATIVE_DECL BOOL IS_PROJECTILE_IN_AREA(Vector3 vec1, Vector3 vec2, BOOL ownedByPlayer) { return invoke<BOOL>(0x05B0061EFDFC8941, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, ownedByPlayer); } // 0x05B0061EFDFC8941 0x78E1A557 b1207
	// Determines whether there is a projectile of a specific type within the specified coordinates. The coordinates form a rectangle.
	NATIVE_DECL BOOL IS_PROJECTILE_TYPE_IN_AREA(float x1, float y1, float z1, float x2, float y2, float z2, int type, BOOL p7) { return invoke<BOOL>(0x04965FB9E14235C7, x1, y1, z1, x2, y2, z2, type, p7); } // 0x04965FB9E14235C7 0x2B73BCF6 b1207
	NATIVE_DECL BOOL IS_PROJECTILE_TYPE_IN_AREA(Vector3 vec1, Vector3 vec2, int type, BOOL p7) { return invoke<BOOL>(0x04965FB9E14235C7, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, type, p7); } // 0x04965FB9E14235C7 0x2B73BCF6 b1207
	NATIVE_DECL BOOL IS_PROJECTILE_TYPE_IN_ANGLED_AREA(float p0, float p1, float p2, float p3, float p4, float p5, float p6, Any p7, BOOL p8) { return invoke<BOOL>(0x928431F4133CD3D4, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0x928431F4133CD3D4 0xD1AE2681 b1207
	NATIVE_DECL BOOL IS_PROJECTILE_TYPE_WITHIN_DISTANCE(float p0, float p1, float p2, Any p3, float p4, BOOL p5) { return invoke<BOOL>(0xF51C9BAAD9ED64C4, p0, p1, p2, p3, p4, p5); } // 0xF51C9BAAD9ED64C4 0xBE81F1E2 b1207
	NATIVE_DECL BOOL GET_COORDS_OF_PROJECTILE_TYPE_WITHIN_DISTANCE(Ped ped, Hash weaponHash, float distance, Vector3* outCoords, BOOL p4, BOOL mustBeOwnedByThisPed) { return invoke<BOOL>(0xD73C960A681052DF, ped, weaponHash, distance, outCoords, p4, mustBeOwnedByThisPed); } // 0xD73C960A681052DF 0x6BDE5CE4 b1207
	NATIVE_DECL BOOL GET_PROJECTILE_OF_PROJECTILE_TYPE_WITHIN_DISTANCE(Ped ped, Hash weaponHash, float distance, Vector3* outCoords, Object* outProjectile, BOOL p5, BOOL mustBeOwnedByThisPed) { return invoke<BOOL>(0x9578986A6105A6AD, ped, weaponHash, distance, outCoords, outProjectile, p5, mustBeOwnedByThisPed); } // 0x9578986A6105A6AD 0x507BC6F7 b1207
	NATIVE_DECL BOOL IS_BULLET_IN_ANGLED_AREA(float p0, float p1, float p2, float p3, float p4, float p5, float p6, BOOL p7) { return invoke<BOOL>(0x9D09D8493747CF02, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x9D09D8493747CF02 0xE2DB58F7 b1207
	NATIVE_DECL BOOL IS_BULLET_IN_AREA(float p0, float p1, float p2, float p3, BOOL p4) { return invoke<BOOL>(0xC652FD308772D79E, p0, p1, p2, p3, p4); } // 0xC652FD308772D79E 0xB54F46CA b1207
	NATIVE_DECL BOOL IS_BULLET_IN_BOX(float p0, float p1, float p2, float p3, float p4, float p5, BOOL p6) { return invoke<BOOL>(0xC128137C52152741, p0, p1, p2, p3, p4, p5, p6); } // 0xC128137C52152741 0xAB73ED26 b1207
	// p3 - possibly radius?
	NATIVE_DECL BOOL HAS_BULLET_IMPACTED_IN_AREA(float x, float y, float z, float p3, BOOL p4, BOOL p5) { return invoke<BOOL>(0xC153E5BCCF411814, x, y, z, p3, p4, p5); } // 0xC153E5BCCF411814 0x902BC7D9 b1207
	NATIVE_DECL BOOL HAS_BULLET_IMPACTED_IN_AREA(Vector3 vec, float p3, BOOL p4, BOOL p5) { return invoke<BOOL>(0xC153E5BCCF411814, vec.x, vec.y, vec.z, p3, p4, p5); } // 0xC153E5BCCF411814 0x902BC7D9 b1207
	NATIVE_DECL BOOL HAS_BULLET_IMPACTED_IN_BOX(float p0, float p1, float p2, float p3, float p4, float p5, BOOL p6, BOOL p7) { return invoke<BOOL>(0x3B6A4C05FB2B33AC, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x3B6A4C05FB2B33AC 0x2C2618CC b1207
	NATIVE_DECL Any _0x7A76104CC2CC69E8(Entity entity, int p1, int p2) { return invoke<Any>(0x7A76104CC2CC69E8, entity, p1, p2); } // 0x7A76104CC2CC69E8 b1207
	NATIVE_DECL Any _0xDC416CA762BC4F43(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<Any>(0xDC416CA762BC4F43, p0, p1, p2, p3, p4, p5); } // 0xDC416CA762BC4F43 b1207
	NATIVE_DECL Any _0x970339EFA4FDE518(Any p0, Any p1, Any p2) { return invoke<Any>(0x970339EFA4FDE518, p0, p1, p2); } // 0x970339EFA4FDE518 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL IS_ORBIS_VERSION() { return invoke<BOOL>(0x88CFAE250D3E0C71); } // 0x88CFAE250D3E0C71 0x40282018 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL IS_DURANGO_VERSION() { return invoke<BOOL>(0xD1CCC2A2639D325F); } // 0xD1CCC2A2639D325F 0x46FB06A5 b1207
	// Hardcoded to return true.
	NATIVE_DECL BOOL IS_PC_VERSION() { return invoke<BOOL>(0xB0FB6CFAA5A1C833); } // 0xB0FB6CFAA5A1C833 0x4D5D9EE3 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL IS_STADIA_VERSION() { return invoke<BOOL>(0x268AB8420A9E4ED7); } // 0x268AB8420A9E4ED7 b1207
	NATIVE_DECL BOOL IS_STRING_NULL(const char* string) { return invoke<BOOL>(0x602102324604D96B, string); } // 0x602102324604D96B 0x8E71E00F b1207
	NATIVE_DECL BOOL IS_STRING_NULL_OR_EMPTY(const char* string) { return invoke<BOOL>(0x2CF12F9ACF18F048, string); } // 0x2CF12F9ACF18F048 0x42E9F2CA b1207
	// Returns true if the entire string consists only of space characters.
	NATIVE_DECL BOOL IS_STRING_NULL_OR_EMPTY_OR_SPACES(const char* string) { return invoke<BOOL>(0x375F5870A7B8BEC1, string); } // 0x375F5870A7B8BEC1 b1207
	NATIVE_DECL BOOL ARE_STRINGS_EQUAL(const char* string1, const char* string2) { return invoke<BOOL>(0xD3852F22AB713A1F, string1, string2); } // 0xD3852F22AB713A1F 0x877C0BC5 b1207
	NATIVE_DECL BOOL _DOES_STRING_EXIST_IN_STRING(const char* string1, const char* string2) { return invoke<BOOL>(0x9382D5D43D2AA6FF, string1, string2); } // 0x9382D5D43D2AA6FF b1207
	NATIVE_DECL void _0x3C3C7B1B5EC08764() { invoke<Void>(0x3C3C7B1B5EC08764); } // 0x3C3C7B1B5EC08764 b1207
	NATIVE_DECL Any _0x94E8CA3DEE952789(Any p0, Any p1) { return invoke<Any>(0x94E8CA3DEE952789, p0, p1); } // 0x94E8CA3DEE952789 b1207
	NATIVE_DECL Any _0x5B4A8121A47D844D(Any p0) { return invoke<Any>(0x5B4A8121A47D844D, p0); } // 0x5B4A8121A47D844D b1207
	// Returns false if it's a null or empty string or if the string is too long. outInteger will be set to -999 in that case.
	NATIVE_DECL BOOL STRING_TO_INT(const char* string, int* outInteger) { return invoke<BOOL>(0xF2DD2298B3AF23E2, string, outInteger); } // 0xF2DD2298B3AF23E2 0x590A8160 b1207
	// Note: the buffer should be exactly 32 bytes long
	NATIVE_DECL void _INT_TO_STRING(int value, const char* format, char* buffer) { invoke<Void>(0xCF11C0CEB40C401B, value, format, buffer); } // 0xCF11C0CEB40C401B b1207
	NATIVE_DECL void _0x74ACA66484CEBAF0(Any p0) { invoke<Void>(0x74ACA66484CEBAF0, p0); } // 0x74ACA66484CEBAF0 b1207
	NATIVE_DECL void _0x49C44FE78A135A1D(Any p0) { invoke<Void>(0x49C44FE78A135A1D, p0); } // 0x49C44FE78A135A1D b1207
	NATIVE_DECL void _0xF650DCF5D6F312C1(Any p0) { invoke<Void>(0xF650DCF5D6F312C1, p0); } // 0xF650DCF5D6F312C1 b1232
	NATIVE_DECL const char* _GET_STRING_FROM_FLOAT(float value, int digits) { return invoke<const char*>(0x2B6846401D68E563, value, digits); } // 0x2B6846401D68E563 b1207
	NATIVE_DECL const char* _GET_STRING_FROM_VECTOR(float x, float y, float z) { return invoke<const char*>(0x6C4DBF553885F9EB, x, y, z); } // 0x6C4DBF553885F9EB b1207
	NATIVE_DECL const char* _GET_STRING_FROM_VECTOR(Vector3 vec) { return invoke<const char*>(0x6C4DBF553885F9EB, vec.x, vec.y, vec.z); } // 0x6C4DBF553885F9EB b1207
	NATIVE_DECL const char* _GET_STRING_FROM_BOOL(BOOL value) { return invoke<const char*>(0xF216F74101968DB0, value); } // 0xF216F74101968DB0 b1207
	// Note: The first bit in 'flags' must not be set.
	// It is also required to pass at least one extra argument (this must be a text label string or hash).
	// When passing a hash, flags should be 0.
	template<typename... Args> NATIVE_DECL const char* VAR_STRING(int flags, Args... args) { return invoke<const char*>(0xFA925AC00EB830B9, flags, args...); } // 0xFA925AC00EB830B9 b1207
	// Returns a formatted string (0x%x)
	NATIVE_DECL const char* _CREATE_COLOR_STRING(int rgb) { return invoke<const char*>(0xBCC2CFADEA1AEA6C, rgb); } // 0xBCC2CFADEA1AEA6C b1207
	NATIVE_DECL void SET_BITS_IN_RANGE(int* var, int rangeStart, int rangeEnd, int p3) { invoke<Void>(0x324DC1CEF57F31E6, var, rangeStart, rangeEnd, p3); } // 0x324DC1CEF57F31E6 0x32094719 b1207
	NATIVE_DECL int GET_BITS_IN_RANGE(int var, int rangeStart, int rangeEnd) { return invoke<int>(0x68E1352AF48F905D, var, rangeStart, rangeEnd); } // 0x68E1352AF48F905D 0xCA03A1E5 b1207
	// Make sure to call this from the correct thread if you're using multiple threads because all other threads except the one which is calling SET_GAME_PAUSED will be paused.
	NATIVE_DECL void SET_GAME_PAUSED(BOOL toggle) { invoke<Void>(0xFAEC088D28B1DE4A, toggle); } // 0xFAEC088D28B1DE4A 0x8230FF6C b1207
	NATIVE_DECL void SET_THIS_SCRIPT_CAN_BE_PAUSED(BOOL toggle) { invoke<Void>(0x3215376E79F6EA18, toggle); } // 0x3215376E79F6EA18 0xA0C3CE29 b1207
	NATIVE_DECL void SET_THIS_SCRIPT_CAN_REMOVE_BLIPS_CREATED_BY_ANY_SCRIPT(BOOL toggle) { invoke<Void>(0x8ABD939C2E5D00ED, toggle); } // 0x8ABD939C2E5D00ED 0xD06F1720 b1207
	// Cheats are GTA IV cheats:
	// 
	// 0 = unknown
	// 1 = unknown (same as 0)
	// 2 = Max Health and Armor
	// 3 = Raise Wanted Level
	// 4 = Lower Wanted Level
	// 5 = unknown (does nothing)
	// 6 = Change Weather
	// 7 = Spawn Annihilator
	// 8 = Spawn NRG 900
	// 9 = Spawn FBI
	// 10 = Spawn Jetmax
	// 11 = Spawn Comet
	// 12 = Spawn Turismo
	// 13 = Spawn Cognoscenti
	// 14 = Spawn Super GT
	// 15 = Spawn Sanchez
	// 
	// Initially used in Max Payne 3, that's why we know the name.
	NATIVE_DECL void SET_CHEAT_ACTIVE(int cheatId) { invoke<Void>(0xD4958E8CF0DE0DD0, cheatId); } // 0xD4958E8CF0DE0DD0 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xB711EB4BC8D06013() { invoke<Void>(0xB711EB4BC8D06013); } // 0xB711EB4BC8D06013 b1207
	// spawns a few distant/out-of-sight peds, vehicles, animals etc each time it is called
	NATIVE_DECL void POPULATE_NOW() { invoke<Void>(0xEA6DC3A8ADD2005F); } // 0xEA6DC3A8ADD2005F 0x72C20700 b1207
	NATIVE_DECL BOOL IS_GAME_SESSION_STATE_MACHINE_IDLE() { return invoke<BOOL>(0xF9E7DBB39080640B); } // 0xF9E7DBB39080640B b1207
	// p0 must be < 2
	NATIVE_DECL BOOL _QUEUE_SAVEGAME_OPERATION(int p0) { return invoke<BOOL>(0x279B0696DA4657EB, p0); } // 0x279B0696DA4657EB b1207
	// Only 0 and 1 are valid for p0, higher values causes the native to return 2.
	NATIVE_DECL int _GET_STATUS_OF_SAVEGAME_OPERATION(int p0) { return invoke<int>(0x1B065A2BF7953815, p0); } // 0x1B065A2BF7953815 b1207
	NATIVE_DECL Any _0x6C7B68D3CE60E8DE(Any p0) { return invoke<Any>(0x6C7B68D3CE60E8DE, p0); } // 0x6C7B68D3CE60E8DE b1207
	NATIVE_DECL Any _0x627B68D9CE6EE8DE(Any p0) { return invoke<Any>(0x627B68D9CE6EE8DE, p0); } // 0x627B68D9CE6EE8DE b1207
	NATIVE_DECL Any _0x7CF96F1250EF3221(Any p0) { return invoke<Any>(0x7CF96F1250EF3221, p0); } // 0x7CF96F1250EF3221 b1207
	NATIVE_DECL void _COPY_MEMORY(Any* dst, Any* src, int size) { invoke<Void>(0xF7AC7DC0DEE7C9BE, dst, src, size); } // 0xF7AC7DC0DEE7C9BE b1207
	// enum DispatchType
	// {
	// 	DT_Invalid,
	// 	DT_PoliceAutomobile,
	// 	DT_PoliceHelicopter,
	// 	DT_FireDepartment,
	// 	DT_SwatAutomobile,
	// 	DT_AmbulanceDepartment,
	// 	DT_PoliceRiders,
	// 	DT_PoliceVehicleRequest,
	// 	DT_PoliceRoadBlock,
	// 	DT_PoliceAutomobileWaitPulledOver,
	// 	DT_PoliceAutomobileWaitCruising,
	// 	DT_Gangs,
	// 	DT_SwatHelicopter,
	// 	DT_PoliceBoat,
	// 	DT_ArmyVehicle,
	// 	DT_OnFoot,
	// 	DT_PoliceDogs
	// };
	NATIVE_DECL void ENABLE_DISPATCH_SERVICE(int dispatchService, BOOL toggle) { invoke<Void>(0x50E52637EF70EF77, dispatchService, toggle); } // 0x50E52637EF70EF77 0x0B710A51 b1207
	// dispatchService: see ENABLE_DISPATCH_SERVICE
	NATIVE_DECL void BLOCK_DISPATCH_SERVICE_RESOURCE_CREATION(int dispatchService, BOOL toggle) { invoke<Void>(0x66947E61A44DE2C6, dispatchService, toggle); } // 0x66947E61A44DE2C6 0xE0F0684F b1207
	// dispatchService: see ENABLE_DISPATCH_SERVICE
	NATIVE_DECL BOOL CREATE_INCIDENT(int dispatchService, float x, float y, float z, int numUnits, float radius, int* outIncidentID, Any p7, Any p8) { return invoke<BOOL>(0x3F892CAF67444AE7, dispatchService, x, y, z, numUnits, radius, outIncidentID, p7, p8); } // 0x3F892CAF67444AE7 0xFC5FF7B3 b1207
	NATIVE_DECL BOOL CREATE_INCIDENT(int dispatchService, Vector3 vec, int numUnits, float radius, int* outIncidentID, Any p7, Any p8) { return invoke<BOOL>(0x3F892CAF67444AE7, dispatchService, vec.x, vec.y, vec.z, numUnits, radius, outIncidentID, p7, p8); } // 0x3F892CAF67444AE7 0xFC5FF7B3 b1207
	// dispatchService: see ENABLE_DISPATCH_SERVICE
	// 
	// The entities must be added to itemSet.
	NATIVE_DECL BOOL _CREATE_INCIDENT_WITH_ENTITIES(int dispatchService, float x, float y, float z, ItemSet itemSet, float radius, int* outIncidentID) { return invoke<BOOL>(0xAB3D3F45436DB1D8, dispatchService, x, y, z, itemSet, radius, outIncidentID); } // 0xAB3D3F45436DB1D8 b1207
	NATIVE_DECL BOOL _CREATE_INCIDENT_WITH_ENTITIES(int dispatchService, Vector3 vec, ItemSet itemSet, float radius, int* outIncidentID) { return invoke<BOOL>(0xAB3D3F45436DB1D8, dispatchService, vec.x, vec.y, vec.z, itemSet, radius, outIncidentID); } // 0xAB3D3F45436DB1D8 b1207
	// Delete an incident with a given id.
	NATIVE_DECL void DELETE_INCIDENT(int incidentId) { invoke<Void>(0x5CFD0F0D6AAE0AEE, incidentId); } // 0x5CFD0F0D6AAE0AEE 0x212BD0DC b1207
	NATIVE_DECL BOOL IS_INCIDENT_VALID(int incidentId) { return invoke<BOOL>(0x39F2B1BAD412246A, incidentId); } // 0x39F2B1BAD412246A 0x31FD0BA4 b1207
	NATIVE_DECL void _SET_INCIDENT_UNK(int incidentId) { invoke<Void>(0x9617B6E5F6537B63, incidentId); } // 0x9617B6E5F6537B63 b1207
	NATIVE_DECL int ADD_POP_MULTIPLIER_AREA(float x1, float y1, float z1, float x2, float y2, float z2, float pedDensity, float trafficDensity, BOOL p8, BOOL p9) { return invoke<int>(0x5EBDA1A3B8CB5EF7, x1, y1, z1, x2, y2, z2, pedDensity, trafficDensity, p8, p9); } // 0x5EBDA1A3B8CB5EF7 0x42BF09B3 b1207
	NATIVE_DECL int ADD_POP_MULTIPLIER_AREA(Vector3 vec1, Vector3 vec2, float pedDensity, float trafficDensity, BOOL p8, BOOL p9) { return invoke<int>(0x5EBDA1A3B8CB5EF7, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, pedDensity, trafficDensity, p8, p9); } // 0x5EBDA1A3B8CB5EF7 0x42BF09B3 b1207
	NATIVE_DECL BOOL DOES_POP_MULTIPLIER_AREA_EXIST(int id) { return invoke<BOOL>(0x03BA619C81A646B3, id); } // 0x03BA619C81A646B3 0xE933B34A b1207
	NATIVE_DECL void REMOVE_POP_MULTIPLIER_AREA(int id, BOOL p1) { invoke<Void>(0x88CB484364EFB37A, id, p1); } // 0x88CB484364EFB37A 0xFBDBE374 b1207
	// Only used in script function PROCESS_ZONE_CREATION
	// Returns Pop multiplier volume ID
	NATIVE_DECL Any _0x3233C4EC0514C7EC(Volume volume, float pedDensity, float vehicleDensity, int p3, int p4) { return invoke<Any>(0x3233C4EC0514C7EC, volume, pedDensity, vehicleDensity, p3, p4); } // 0x3233C4EC0514C7EC b1207
	NATIVE_DECL BOOL _DOES_POP_MULTIPLIER_AREA_EXIST_FOR_VOLUME(Volume volume) { return invoke<BOOL>(0x39D6DACE323A20B6, volume); } // 0x39D6DACE323A20B6 b1207
	NATIVE_DECL void _REMOVE_POP_MULTIPLIER_AREA_FOR_VOLUME(Volume volume, int p1) { invoke<Void>(0xBD090F5B1DB82189, volume, p1); } // 0xBD090F5B1DB82189 b1207
	NATIVE_DECL void _0xF569E33FB72ED28E() { invoke<Void>(0xF569E33FB72ED28E); } // 0xF569E33FB72ED28E b1207
	NATIVE_DECL void RESET_DISPATCH_IDEAL_SPAWN_DISTANCE() { invoke<Void>(0xC7817264BC4B6377); } // 0xC7817264BC4B6377 0xDA65ECAA b1207
	NATIVE_DECL void SET_DISPATCH_IDEAL_SPAWN_DISTANCE(float fIdealSpawnDistance) { invoke<Void>(0xEAB6823B82FBD283, fIdealSpawnDistance); } // 0xEAB6823B82FBD283 0x6283BE32 b1207
	NATIVE_DECL void _RESET_DISPATCH_MIN_SPAWN_DISTANCE() { invoke<Void>(0x96498D922D8D0D0A); } // 0x96498D922D8D0D0A b1207
	NATIVE_DECL void _SET_DISPATCH_MIN_SPAWN_DISTANCE(float minSpawnDistance) { invoke<Void>(0x27A1B170AA8AF84C, minSpawnDistance); } // 0x27A1B170AA8AF84C b1207
	NATIVE_DECL void _RESET_DISPATCH_MAX_SPAWN_DISTANCE() { invoke<Void>(0x54EC7B6BC72BAD69); } // 0x54EC7B6BC72BAD69 b1207
	NATIVE_DECL void _SET_DISPATCH_MAX_SPAWN_DISTANCE(float maxSpawnDistance) { invoke<Void>(0x89314FB3463E28DE, maxSpawnDistance); } // 0x89314FB3463E28DE b1207
	NATIVE_DECL void _0x4B0501A468B749F8() { invoke<Void>(0x4B0501A468B749F8); } // 0x4B0501A468B749F8 b1207
	// _SET_DISPATCH_*, unused
	NATIVE_DECL void _0x6BCF7B5CD338281A(Any p0, Any p1, Any p2) { invoke<Void>(0x6BCF7B5CD338281A, p0, p1, p2); } // 0x6BCF7B5CD338281A b1207
	NATIVE_DECL Any _ADD_DISPATCH_SPAWN_BLOCKING_AREA(Volume volume) { return invoke<Any>(0xA2D5A26208421426, volume); } // 0xA2D5A26208421426 b1207
	NATIVE_DECL void REMOVE_DISPATCH_SPAWN_BLOCKING_AREA(Any p0) { invoke<Void>(0x49F751F6868DDC5B, p0); } // 0x49F751F6868DDC5B 0xA8D2FB92 b1207
	// RESET_*
	NATIVE_DECL void _0xEF42F56F69877125() { invoke<Void>(0xEF42F56F69877125); } // 0xEF42F56F69877125 0xE0C9307E b1207
	// Params: p3 is 0 in R* Script utopia2
	NATIVE_DECL void ADD_TACTICAL_NAV_MESH_POINT(float x, float y, float z, int p3) { invoke<Void>(0xE4EE55E63FA9AF45, x, y, z, p3); } // 0xE4EE55E63FA9AF45 0x24A4E0B2 b1207
	NATIVE_DECL void ADD_TACTICAL_NAV_MESH_POINT(Vector3 vec, int p3) { invoke<Void>(0xE4EE55E63FA9AF45, vec.x, vec.y, vec.z, p3); } // 0xE4EE55E63FA9AF45 0x24A4E0B2 b1207
	NATIVE_DECL void CLEAR_TACTICAL_NAV_MESH_POINTS() { invoke<Void>(0xD93B6516C6878267); } // 0xD93B6516C6878267 0x66C3C59C b1207
	// enum eOnscreenKeyboardTextType
	// {
	// 	KTEXTTYPE_INVALID = -1,
	// 	KTEXTTYPE_DEFAULT,
	// 	KTEXTTYPE_EMAIL,
	// 	KTEXTTYPE_PASSWORD,
	// 	KTEXTTYPE_NUMERIC,
	// 	KTEXTTYPE_ALPHABET,
	// 	KTEXTTYPE_GAMERTAG,
	// 	KTEXTTYPE_FILENAME,
	// 	KTEXTTYPE_COUNT
	// };
	NATIVE_DECL void DISPLAY_ONSCREEN_KEYBOARD(int textType, const char* windowTitle, const char* p2, const char* defaultText, const char* defaultConcat1, const char* defaultConcat2, const char* defaultConcat3, int maxInputLength) { invoke<Void>(0x044131118D8DB3CD, textType, windowTitle, p2, defaultText, defaultConcat1, defaultConcat2, defaultConcat3, maxInputLength); } // 0x044131118D8DB3CD 0xAD99F2CE b1207
	// Returns the current status of the onscreen keyboard, and updates the output.
	// 
	// Status Codes:
	// 
	// 0 - User still editing
	// 1 - User has finished editing
	// 2 - User has canceled editing
	// 3 - Keyboard isn't active
	NATIVE_DECL int UPDATE_ONSCREEN_KEYBOARD() { return invoke<int>(0x37DF360F235A3893); } // 0x37DF360F235A3893 0x23D0A1CE b1207
	// Returns NULL unless UPDATE_ONSCREEN_KEYBOARD() returns 1 in the same tick.
	NATIVE_DECL const char* GET_ONSCREEN_KEYBOARD_RESULT() { return invoke<const char*>(0xAFB4CF58A4A292B1); } // 0xAFB4CF58A4A292B1 0x44828FB3 b1207
	NATIVE_DECL void _CANCEL_ONSCREEN_KEYBOARD() { invoke<Void>(0x58A39BE597CE99CD); } // 0x58A39BE597CE99CD 0x196444BB b1207
	NATIVE_DECL void NEXT_ONSCREEN_KEYBOARD_RESULT_WILL_DISPLAY_USING_THESE_FONTS(int p0) { invoke<Void>(0x5CB71EAA1429A358, p0); } // 0x5CB71EAA1429A358 0x3301EA47 b1207
	// Appears to remove stealth kill action from memory (?)
	NATIVE_DECL void ACTION_MANAGER_ENABLE_ACTION(Hash hash, BOOL enable) { invoke<Void>(0x7ACF124C12A2B045, hash, enable); } // 0x7ACF124C12A2B045 0x42B484ED b1207
	NATIVE_DECL Any _0xFD0759658268FD8E(Any p0) { return invoke<Any>(0xFD0759658268FD8E, p0); } // 0xFD0759658268FD8E b1207
	// Returns GET_GAME_TIMER() / 1000
	// Only used in rcm_pearson1.ysc
	NATIVE_DECL int _GET_REAL_GAME_TIMER_IN_SECONDS() { return invoke<int>(0x2E036F0480B8BF02); } // 0x2E036F0480B8BF02 b1207
	NATIVE_DECL void SET_SUPER_JUMP_THIS_FRAME(Player player) { invoke<Void>(0xB3E9BE963F10C445, player); } // 0xB3E9BE963F10C445 0x86745EF3 b1207
	NATIVE_DECL void SCRIPT_RACE_INIT(int numCheckpoints, int numLaps, int numPlayers, Any p3) { invoke<Void>(0x8AE059F47158417E, numCheckpoints, numLaps, numPlayers, p3); } // 0x8AE059F47158417E 0x2D33F15A b1207
	NATIVE_DECL void SCRIPT_RACE_SHUTDOWN() { invoke<Void>(0x334CE0DA4FAF330C); } // 0x334CE0DA4FAF330C 0xDF99925C b1207
	// SCRIPT_RACE_*
	NATIVE_DECL void _0xBA62B4D80FA66BD6(Any iPart, Any iCheckpoint, Any iLap, Any iTime) { invoke<Void>(0xBA62B4D80FA66BD6, iPart, iCheckpoint, iLap, iTime); } // 0xBA62B4D80FA66BD6 0xA27F4472 b1207
	NATIVE_DECL BOOL SCRIPT_RACE_GET_PLAYER_SPLIT_TIME(Any p0, Any* p1, Any* p2) { return invoke<BOOL>(0x769E848C66E3C2BB, p0, p1, p2); } // 0x769E848C66E3C2BB 0x07FF553F b1207
	// Begins with START_*. Next character in the name is either D or E.
	NATIVE_DECL void _START_BENCHMARK_RECORDING() { invoke<Void>(0x29D1F6DF864A094E); } // 0x29D1F6DF864A094E b1207
	// Begins with STOP_*. Next character in the name is either D or E.
	NATIVE_DECL void _STOP_BENCHMARK_RECORDING() { invoke<Void>(0xB89AEC71AFF2B599); } // 0xB89AEC71AFF2B599 b1207
	// Begins with RESET_*. Next character in the name is either D or E.
	NATIVE_DECL void _RESET_BENCHMARK_RECORDING() { invoke<Void>(0xECBABD0307FB216F); } // 0xECBABD0307FB216F b1207
	// Saves the benchmark recording to %USERPROFILE%\Documents\Rockstar Games\Red Dead Redemption 2\Benchmarks and submits some metrics.
	NATIVE_DECL void _SAVE_BENCHMARK_RECORDING() { invoke<Void>(0xF4743E2ECC02B3DA); } // 0xF4743E2ECC02B3DA b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL _UI_IS_SINGLEPLAYER_PAUSE_MENU_ACTIVE() { return invoke<BOOL>(0x4FFA0386A6216113); } // 0x4FFA0386A6216113 b1207
	// Returns value of the '-benchmarkIterations' command line option.
	NATIVE_DECL int _GET_BENCHMARK_ITERATIONS_FROM_COMMAND_LINE() { return invoke<int>(0x22FC52CF470CC98D); } // 0x22FC52CF470CC98D b1207
	// Returns value of the '-benchmarkPass' command line option.
	NATIVE_DECL int _GET_BENCHMARK_PASS_FROM_COMMAND_LINE() { return invoke<int>(0x9297DACF3A2CDFF7); } // 0x9297DACF3A2CDFF7 b1207
	// Hardcoded to return one/true.
	NATIVE_DECL Any _0xDC057B86FC157031() { return invoke<Any>(0xDC057B86FC157031); } // 0xDC057B86FC157031 b1207
	NATIVE_DECL void _0x9A252AA23D7098F2() { invoke<Void>(0x9A252AA23D7098F2); } // 0x9A252AA23D7098F2 b1207
	NATIVE_DECL BOOL _DOES_ITEM_HAVE_VALID_BASE(ScrHandle item) { return invoke<BOOL>(0xBDC6E364C9C78178, item); } // 0xBDC6E364C9C78178 b1207
	// 0 = invalid
	// 1 = CEntity
	// 2 = rage::volBase
	// 3 = rage::volSphere
	// 4 = rage::volBox
	// 5 = rage::volAggregate
	// 6 = rage::volCylinder
	// 7 = CScriptedCoverPoint
	// 8 = rage::ptfxScriptInfo
	// 9 = CPed
	// 10 = CVehicle
	// 11 = CObject
	// 12 = CItemSet
	// 13 = CPersistentCharacter
	NATIVE_DECL int _GET_ITEM_TYPE(ScrHandle handle) { return invoke<int>(0xDC8D2FF478DF9553, handle); } // 0xDC8D2FF478DF9553 b1207
	NATIVE_DECL BOOL _IS_BASE_A_PERSISTENT_CHARACTER(ScrHandle handle) { return invoke<BOOL>(0x716F17F8A0419F95, handle); } // 0x716F17F8A0419F95 b1207
	NATIVE_DECL BOOL _IS_BASE_A_COVER_POINT(ScrHandle handle) { return invoke<BOOL>(0xFEC1D4B5C82C176F, handle); } // 0xFEC1D4B5C82C176F b1207
	// _J*, _K*, _L*
	NATIVE_DECL void _0x553D67295DDD2309(Entity entity) { invoke<Void>(0x553D67295DDD2309, entity); } // 0x553D67295DDD2309 b1207
	NATIVE_DECL Any _0xF18AF483DF70BBDE(Any p0) { return invoke<Any>(0xF18AF483DF70BBDE, p0); } // 0xF18AF483DF70BBDE b1207
	NATIVE_DECL Entity _GET_ENTITY_FROM_ITEM(ScrHandle item) { return invoke<Entity>(0xEE04C0AFD4EFAF0E, item); } // 0xEE04C0AFD4EFAF0E b1207
	NATIVE_DECL Ped _GET_PED_FROM_INDEXED_ITEM(ScrHandle item) { return invoke<Ped>(0x3FFB15534067DCD4, item); } // 0x3FFB15534067DCD4 b1207
	NATIVE_DECL Vehicle _GET_VEHICLE_FROM_INDEXED_ITEM(ScrHandle item) { return invoke<Vehicle>(0xE578C8AE173719B3, item); } // 0xE578C8AE173719B3 b1207
	NATIVE_DECL Object _GET_OBJECT_FROM_INDEXED_ITEM(ScrHandle item) { return invoke<Object>(0x18013392501CE5DC, item); } // 0x18013392501CE5DC b1207
	NATIVE_DECL Any _0x33982467B1E349EF(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0x33982467B1E349EF, p0, p1, p2, p3, p4, p5, p6); } // 0x33982467B1E349EF b1207
	NATIVE_DECL Any _0x8314FC2013ECE2DA(Any p0, Any p1, Any p2) { return invoke<Any>(0x8314FC2013ECE2DA, p0, p1, p2); } // 0x8314FC2013ECE2DA b1207
	NATIVE_DECL void _0x4D5C9CC7E7E23E09() { invoke<Void>(0x4D5C9CC7E7E23E09); } // 0x4D5C9CC7E7E23E09 b1207
	// p3 is usually the same value of radius
	// p8 determines whether the ILO prompt is a lock on prompt with RMB
	NATIVE_DECL BOOL REGISTER_INTERACTION_LOCKON_PROMPT(Entity entity, const char* text, float radius, float p3, int flag, float p5, float p6, Prompt prompt, BOOL p8, int p9) { return invoke<BOOL>(0x870708A6E147A9AD, entity, text, radius, p3, flag, p5, p6, prompt, p8, p9); } // 0x870708A6E147A9AD b1207
	NATIVE_DECL BOOL UNREGISTER_INTERACTION_LOCKON_PROMPT(Entity entity) { return invoke<BOOL>(0xE98D55C5983F2509, entity); } // 0xE98D55C5983F2509 b1207
	NATIVE_DECL void _0xFC6ECB9170145ECE() { invoke<Void>(0xFC6ECB9170145ECE); } // 0xFC6ECB9170145ECE b1207
	NATIVE_DECL Any _0x35165C658077CD0B() { return invoke<Any>(0x35165C658077CD0B); } // 0x35165C658077CD0B b1207
	NATIVE_DECL BOOL _0x4B101DBCC9482F2D(Ped ped) { return invoke<BOOL>(0x4B101DBCC9482F2D, ped); } // 0x4B101DBCC9482F2D b1207
	NATIVE_DECL BOOL _IS_MISSION_CREATOR_ACTIVE() { return invoke<BOOL>(0xF236C84C6ADFCB2F); } // 0xF236C84C6ADFCB2F b1207
	NATIVE_DECL void _0xA3A8926951471C82() { invoke<Void>(0xA3A8926951471C82); } // 0xA3A8926951471C82 b1207
	// aiMemoryType: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/_CREATE_AI_MEMORY/README.md
	NATIVE_DECL void _CREATE_AI_MEMORY(Any* args, int aiMemoryType) { invoke<Void>(0x88BC5F4AEF77FC4E, args, aiMemoryType); } // 0x88BC5F4AEF77FC4E b1207
	NATIVE_DECL Any _0xFDF38E2B711BF78E(Any p0, Any p1) { return invoke<Any>(0xFDF38E2B711BF78E, p0, p1); } // 0xFDF38E2B711BF78E b1207
	// Not implemented.
	NATIVE_DECL void _0xEB946B9E579729AD(Ped ped, Any p1) { invoke<Void>(0xEB946B9E579729AD, ped, p1); } // 0xEB946B9E579729AD b1207
	NATIVE_DECL void _0x6AC4AF46A6B8DFB2(Any p0) { invoke<Void>(0x6AC4AF46A6B8DFB2, p0); } // 0x6AC4AF46A6B8DFB2 b1207
	NATIVE_DECL Any _0x8DB104CCEBCD58C5(Any p0, Any p1) { return invoke<Any>(0x8DB104CCEBCD58C5, p0, p1); } // 0x8DB104CCEBCD58C5 b1207
	NATIVE_DECL void _0x68319452C5064ABA(Any p0, Any p1) { invoke<Void>(0x68319452C5064ABA, p0, p1); } // 0x68319452C5064ABA b1207
	NATIVE_DECL void _0xDE2C3B74D2B3705C(Any p0, Any p1) { invoke<Void>(0xDE2C3B74D2B3705C, p0, p1); } // 0xDE2C3B74D2B3705C b1207
	NATIVE_DECL void _0x49F3241C28EBBFBC(Any p0) { invoke<Void>(0x49F3241C28EBBFBC, p0); } // 0x49F3241C28EBBFBC b1207
	NATIVE_DECL void _0x183672FE838A661B(Any p0) { invoke<Void>(0x183672FE838A661B, p0); } // 0x183672FE838A661B b1207
	NATIVE_DECL void _0x38C0C9CAE1544500(Any p0) { invoke<Void>(0x38C0C9CAE1544500, p0); } // 0x38C0C9CAE1544500 b1207
	NATIVE_DECL void _0x154340E87D8CC178(Any p0) { invoke<Void>(0x154340E87D8CC178, p0); } // 0x154340E87D8CC178 b1207
	NATIVE_DECL void _0x94FCADCF9F0C368E(Any p0) { invoke<Void>(0x94FCADCF9F0C368E, p0); } // 0x94FCADCF9F0C368E b1207
	NATIVE_DECL Any _0x0D0AE5081F88CFE1(Any p0) { return invoke<Any>(0x0D0AE5081F88CFE1, p0); } // 0x0D0AE5081F88CFE1 b1207
	NATIVE_DECL void _0xAF3A84C7DE6A1DC5(Any p0, Any p1) { invoke<Void>(0xAF3A84C7DE6A1DC5, p0, p1); } // 0xAF3A84C7DE6A1DC5 b1207
	NATIVE_DECL void _0x48E4D50F87A96AA5(Ped ped, BOOL p1, BOOL p2, Hash p3, Any* p4, Any p5) { invoke<Void>(0x48E4D50F87A96AA5, ped, p1, p2, p3, p4, p5); } // 0x48E4D50F87A96AA5 b1207
	NATIVE_DECL Any _0xB1F6665AA54DCD5C(Any p0) { return invoke<Any>(0xB1F6665AA54DCD5C, p0); } // 0xB1F6665AA54DCD5C b1207
	NATIVE_DECL Any _0x8BB99B85444544D9(Any p0, Any p1) { return invoke<Any>(0x8BB99B85444544D9, p0, p1); } // 0x8BB99B85444544D9 b1207
	NATIVE_DECL Any _0x6F02B5E50511721E(Any p0) { return invoke<Any>(0x6F02B5E50511721E, p0); } // 0x6F02B5E50511721E b1207
	NATIVE_DECL Any _0xCC1BAF72D571DB8D(Any p0, Any p1, Any p2) { return invoke<Any>(0xCC1BAF72D571DB8D, p0, p1, p2); } // 0xCC1BAF72D571DB8D b1207
	NATIVE_DECL BOOL _IS_PED_DECOMPOSED(Ped ped) { return invoke<BOOL>(0x5170DDA6D63ACAAA, ped); } // 0x5170DDA6D63ACAAA b1207
	NATIVE_DECL void SET_PED_DECOMPOSED(Ped ped, BOOL toggle) { invoke<Void>(0x674B90BE1115846D, ped, toggle); } // 0x674B90BE1115846D b1207
	NATIVE_DECL void _0xAB26DEEE120FD3FD(Any p0, Any p1) { invoke<Void>(0xAB26DEEE120FD3FD, p0, p1); } // 0xAB26DEEE120FD3FD b1207
	NATIVE_DECL void _0x082C043C7AFC3747(int compositeId, BOOL p1) { invoke<Void>(0x082C043C7AFC3747, compositeId, p1); } // 0x082C043C7AFC3747 b1207
	NATIVE_DECL void DISABLE_LOOTING_COMPOSITE_LOOTABLE_THIS_FRAME(int compositeId, BOOL p1) { invoke<Void>(0x40D72189F46D2E15, compositeId, p1); } // 0x40D72189F46D2E15 b1207
	NATIVE_DECL void _0xBB282CF5D2333FB8(Any p0, Any p1) { invoke<Void>(0xBB282CF5D2333FB8, p0, p1); } // 0xBB282CF5D2333FB8 b1207
	NATIVE_DECL void _0xAD44856A1CD29635(Any p0, Any p1, Any p2) { invoke<Void>(0xAD44856A1CD29635, p0, p1, p2); } // 0xAD44856A1CD29635 b1207
	NATIVE_DECL Any _0x38C2BF94D15F464D(Any p0) { return invoke<Any>(0x38C2BF94D15F464D, p0); } // 0x38C2BF94D15F464D b1207
	NATIVE_DECL void _0x3A87FDA8F1B6CDFB(Any p0, Any p1, Any p2) { invoke<Void>(0x3A87FDA8F1B6CDFB, p0, p1, p2); } // 0x3A87FDA8F1B6CDFB b1207
	NATIVE_DECL void _0x4647842FE8F31C1E(Any p0, Any p1) { invoke<Void>(0x4647842FE8F31C1E, p0, p1); } // 0x4647842FE8F31C1E b1207
	// Event names in the scripts: MGBegin, MGEnd, ReadyForCut
	NATIVE_DECL BOOL _GET_LOOTING_EVENT_HAS_FIRED(Ped ped, const char* eventName) { return invoke<BOOL>(0xF9B91C5129EABC08, ped, eventName); } // 0xF9B91C5129EABC08 b1207
	NATIVE_DECL void _0x9B47971234169990(Ped ped, Any item) { invoke<Void>(0x9B47971234169990, ped, item); } // 0x9B47971234169990 b1207
	NATIVE_DECL void _0x96282005C5C6801F(Any p0, Any p1) { invoke<Void>(0x96282005C5C6801F, p0, p1); } // 0x96282005C5C6801F b1311
	NATIVE_DECL void _0xF63FA29D4A9ACA86(Any p0, Any p1) { invoke<Void>(0xF63FA29D4A9ACA86, p0, p1); } // 0xF63FA29D4A9ACA86 b1207
	NATIVE_DECL void _0x8C0F6A3D7236DEEB(Any p0, Any p1) { invoke<Void>(0x8C0F6A3D7236DEEB, p0, p1); } // 0x8C0F6A3D7236DEEB b1207
	NATIVE_DECL void _0x7FA58CED69405F9A(Any p0, Any p1) { invoke<Void>(0x7FA58CED69405F9A, p0, p1); } // 0x7FA58CED69405F9A b1207
	// _CLEAR*
	NATIVE_DECL void _0xA08111B053D84B4D(Any p0) { invoke<Void>(0xA08111B053D84B4D, p0); } // 0xA08111B053D84B4D b1207
	NATIVE_DECL BOOL _IS_GLOBAL_BLOCK_VALID(int index) { return invoke<BOOL>(0xACB7E1418A8B6E32, index); } // 0xACB7E1418A8B6E32 b1207
	NATIVE_DECL void _SET_GLOBAL_BLOCK_IS_LOADED(int index, BOOL toggle) { invoke<Void>(0xE97240065406CB80, index, toggle); } // 0xE97240065406CB80 b1207
	NATIVE_DECL BOOL GAME_FRAMEWORK_MANAGER_INIT(Hash transitionMode) { return invoke<BOOL>(0x4CABE596D632E4B0, transitionMode); } // 0x4CABE596D632E4B0 b1207
	NATIVE_DECL void _GAME_FRAMEWORK_MANAGER_SHUTDOWN() { invoke<Void>(0xAFF2FD8ADD927585); } // 0xAFF2FD8ADD927585 b1207
	NATIVE_DECL Hash _GAME_FRAMEWORK_MANAGER_GET_MODE() { return invoke<Hash>(0xFAED234C7F53ABEB); } // 0xFAED234C7F53ABEB b1207
	NATIVE_DECL BOOL _0x36040772DF5E59A0() { return invoke<BOOL>(0x36040772DF5E59A0); } // 0x36040772DF5E59A0 b1355
	NATIVE_DECL Any _0x0358B8A41916C613(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x0358B8A41916C613, p0, p1, p2, p3); } // 0x0358B8A41916C613 b1207
	// Note: this native was added in build 1232.56
	NATIVE_DECL void _SET_GAME_LOGIC_PAUSED() { invoke<Void>(0x550F05CFFBD63C8C); } // 0x550F05CFFBD63C8C b1232
	// nullsub, doesn't do anything
	NATIVE_DECL void STOP_CURRENT_LOADING_PROGRESS_TIMER() { invoke<Void>(0xA565FAC215CBC77D); } // 0xA565FAC215CBC77D b1207
	NATIVE_DECL void _0xDBDA48EC456ED908() { invoke<Void>(0xDBDA48EC456ED908); } // 0xDBDA48EC456ED908 b1436
}

namespace MISSIONDATA
{
	NATIVE_DECL BOOL MISSIONDATA_IS_VALID(Any p0) { return invoke<BOOL>(0xE54DC27571D5EDC5, p0); } // 0xE54DC27571D5EDC5 b1207
	NATIVE_DECL Hash MISSIONDATA_GET_CATAGORY(Hash missionId) { return invoke<Hash>(0x57E798B65C45EE17, missionId); } // 0x57E798B65C45EE17 b1232
	NATIVE_DECL Hash MISSIONDATA_GET_TEXTURE_NAME(Hash missionId) { return invoke<Hash>(0x57E798B56C45EE15, missionId); } // 0x57E798B56C45EE15 b1207
	NATIVE_DECL Hash MISSIONDATA_GET_TEXTURE_TXD(Hash missionId) { return invoke<Hash>(0x57E798B57C45EE16, missionId); } // 0x57E798B57C45EE16 b1207
	NATIVE_DECL BOOL MISSIONDATA_WAS_COMPLETED(Hash missionId) { return invoke<BOOL>(0xE54DC27571D5EDC4, missionId); } // 0xE54DC27571D5EDC4 b1207
	NATIVE_DECL int MISSIONDATA_GET_RATING(Hash missionId) { return invoke<int>(0x57E798B54C45EE1A, missionId); } // 0x57E798B54C45EE1A b1207
	// MISSION_RATING_INCOMPLETE = 0,
	// MISSION_RATING_SKIPPED,
	// MISSION_RATING_COMPLETE,
	// MISSION_RATING_BRONZE,
	// MISSION_RATING_SILVER,
	// MISSION_RATING_GOLD,
	NATIVE_DECL void _MISSIONDATA_SET_MISSION_RATING(Hash missionId, int rating) { invoke<Void>(0xE824CE7D13FCB300, missionId, rating); } // 0xE824CE7D13FCB300 b1207
	NATIVE_DECL BOOL MISSIONDATA_IS_REQUIRED_STORY_MISSION(Hash missionId) { return invoke<BOOL>(0xE824CE7D13FCB35E, missionId); } // 0xE824CE7D13FCB35E b1207
	// replayState: MISSIONDATA_GET_REPLAY_STATE
	NATIVE_DECL void _MISSIONDATA_SET_REPLAY_STATE_LOCKED(Hash missionId, int replayState) { invoke<Void>(0xE4E2C581F127A11C, missionId, replayState); } // 0xE4E2C581F127A11C b1207
	NATIVE_DECL int MISSIONDATA_GET_REPLAY_STATE(Any p0) { return invoke<int>(0x8C32D86E9556ED86, p0); } // 0x8C32D86E9556ED86 b1207
	NATIVE_DECL void MISSIONDATA_SET_RATING_SCORES(Hash missionId, int bronzeScore, int silverScore, int goldScore) { invoke<Void>(0x12F65317708749A5, missionId, bronzeScore, silverScore, goldScore); } // 0x12F65317708749A5 b1207
	NATIVE_DECL void MISSIONDATA_SET_HIGH_SCORE(Hash missionId, int score) { invoke<Void>(0x3A04F0169DA87A9D, missionId, score); } // 0x3A04F0169DA87A9D b1207
	NATIVE_DECL int MISSIONDATA_GET_HIGH_SCORE(Hash missionId) { return invoke<int>(0x9AABABF8313C3516, missionId); } // 0x9AABABF8313C3516 b1207
	NATIVE_DECL BOOL _MISSIONDATA_IS_REPLAY_CATEGORY_LOCKED(Hash category) { return invoke<BOOL>(0xE145864DECC34219, category); } // 0xE145864DECC34219 b1232
	NATIVE_DECL void MISSIONDATA_SET_REPLAY_LOCKED_FOR_CATEGORY(Hash category, BOOL locked) { invoke<Void>(0x957A830C9B4B99EA, category, locked); } // 0x957A830C9B4B99EA b1232
	NATIVE_DECL void _MISSIONDATA_TIMECYCLE_BOX_SET_MODIFIER(const char* timecycleName) { invoke<Void>(0x25855B1574BF8CD5, timecycleName); } // 0x25855B1574BF8CD5 b1207
	NATIVE_DECL void _MISSIONDATA_TIMECYCLE_BOX_DELETE() { invoke<Void>(0x7F89E15A8FB8DE97); } // 0x7F89E15A8FB8DE97 b1207
	NATIVE_DECL BOOL _MISSIONDATA_TIMECYCLE_BOX_EXISTS() { return invoke<BOOL>(0x7E8F86A4FA33033C); } // 0x7E8F86A4FA33033C b1207
}

namespace MONEY
{
	NATIVE_DECL int _MONEY_GET_CASH_BALANCE() { return invoke<int>(0x0C02DABFA3B98176); } // 0x0C02DABFA3B98176 b1207
	NATIVE_DECL BOOL _MONEY_DECREMENT_CASH_BALANCE(int amount) { return invoke<BOOL>(0x466BC8769CF26A7A, amount); } // 0x466BC8769CF26A7A b1207
	NATIVE_DECL BOOL _MONEY_INCREMENT_CASH_BALANCE(int amount, Hash p1) { return invoke<BOOL>(0xBC3422DC91667621, amount, p1); } // 0xBC3422DC91667621 b1207
	NATIVE_DECL const char* _NETWORK_GET_STRING_CASH_BALANCE() { return invoke<const char*>(0x282D36FF103D78DF); } // 0x282D36FF103D78DF b1207
	NATIVE_DECL BOOL _NETWORK_IS_MONEY_BALANCE_NOT_LESS_THAN(int cashBalance, int goldBarBalance) { return invoke<BOOL>(0xAEC5F0119867E457, cashBalance, goldBarBalance); } // 0xAEC5F0119867E457 b1207
	NATIVE_DECL const char* _0xA46FD001D1BE896C() { return invoke<const char*>(0xA46FD001D1BE896C); } // 0xA46FD001D1BE896C b1207
	NATIVE_DECL BOOL _0x07AD9E43FD478527(Any p0, Any p1) { return invoke<BOOL>(0x07AD9E43FD478527, p0, p1); } // 0x07AD9E43FD478527 b1207
	NATIVE_DECL int _NETWORK_GET_CASH_BALANCE() { return invoke<int>(0x8A67120DBC299525); } // 0x8A67120DBC299525 b1207
}

namespace NETSHOPPING
{
	NATIVE_DECL BOOL CASHINVENTORY_INIT_SESSION_STATUS(int* p0, int* p1) { return invoke<BOOL>(0xC019112F8995DC1C, p0, p1); } // 0xC019112F8995DC1C b1207
	NATIVE_DECL BOOL _CASHINVENTORY_IS_SESSION_READY() { return invoke<BOOL>(0xFCC24220FDDAC929); } // 0xFCC24220FDDAC929 b1207
	NATIVE_DECL BOOL CASHINVENTORY_IS_CONNECTION_FAULTED() { return invoke<BOOL>(0x6CE9FB6332B5E46E); } // 0x6CE9FB6332B5E46E b1207
	NATIVE_DECL BOOL _CASHINVENTORY_INIT_SESSION_IS_FAULTED() { return invoke<BOOL>(0xD1CE92D1D9BE170A); } // 0xD1CE92D1D9BE170A b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_FIRE_AND_FORGET_ITEM(Hash actionHash, int* id, Any* item, int p3) { return invoke<BOOL>(0xFFEA09CCEC4AF32F, actionHash, id, item, p3); } // 0xFFEA09CCEC4AF32F b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_START(int* id, Hash type, Hash actionHash) { return invoke<BOOL>(0xF039EC27F4490E96, id, type, actionHash); } // 0xF039EC27F4490E96 b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_GET_BASKET_IS_VALID(int id) { return invoke<BOOL>(0x52A226ADF4A270D2, id); } // 0x52A226ADF4A270D2 b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_DELETE(int id) { return invoke<BOOL>(0x59EF5D516E2D96B9, id); } // 0x59EF5D516E2D96B9 b1207
	NATIVE_DECL int _CASHINVENTORY_TRANSACTION_VALIDATE_ITEM(Hash p0, Any* p1) { return invoke<int>(0x6C9F12700BCE69F4, p0, p1); } // 0x6C9F12700BCE69F4 b1207
	NATIVE_DECL int _0x38640A8C2DEF011B(int p0) { return invoke<int>(0x38640A8C2DEF011B, p0); } // 0x38640A8C2DEF011B b1311
	NATIVE_DECL BOOL _0xA3B8D31C13CB4239(int p0, Hash p1, Any* p2, int p3, Any* p4, int p5) { return invoke<BOOL>(0xA3B8D31C13CB4239, p0, p1, p2, p3, p4, p5); } // 0xA3B8D31C13CB4239 b1311
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_ADD_AWARD(int id, Hash hash, Any* p2, Any* p3) { return invoke<BOOL>(0x52BDE32F21BA3B6D, id, hash, p2, p3); } // 0x52BDE32F21BA3B6D b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_GET_ITEM_INFO(int id, int index, Any* itemInfo) { return invoke<BOOL>(0x7616B5F0895C2D99, id, index, itemInfo); } // 0x7616B5F0895C2D99 b1207
	NATIVE_DECL int _CASHINVENTORY_TRANSACTION_GET_NUM_OF_ITEMS(int id) { return invoke<int>(0xCF2D04D076847478, id); } // 0xCF2D04D076847478 b1207
	NATIVE_DECL Hash _CASHINVENTORY_TRANSACTION_GET_ACTION(int id) { return invoke<Hash>(0xBD2D520C51CCFF52, id); } // 0xBD2D520C51CCFF52 b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_CHECKOUT(int id) { return invoke<BOOL>(0x592BC00BF6629BE7, id); } // 0x592BC00BF6629BE7 b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_CHECKOUT_STATUS(int id, int* status) { return invoke<BOOL>(0x26C008791D066F37, id, status); } // 0x26C008791D066F37 b1207
	NATIVE_DECL int _0xB6F4557060EF0FB4(int p0, int p1) { return invoke<int>(0xB6F4557060EF0FB4, p0, p1); } // 0xB6F4557060EF0FB4 b1207
	NATIVE_DECL BOOL _CASHINVENTORY_TRANSACTION_RESPONSE_GET_ITEM_INFO(int id, int index, Any* itemInfo) { return invoke<BOOL>(0x98412398BBE73F61, id, index, itemInfo); } // 0x98412398BBE73F61 b1207
	NATIVE_DECL BOOL _0xCE54C9ABE6FBC6DB(Hash p0) { return invoke<BOOL>(0xCE54C9ABE6FBC6DB, p0); } // 0xCE54C9ABE6FBC6DB b1207
	NATIVE_DECL BOOL _0xA0B7094629724974(Hash p0, Any p1) { return invoke<BOOL>(0xA0B7094629724974, p0, p1); } // 0xA0B7094629724974 b1207
	NATIVE_DECL BOOL _0x92A32BA29622763F(int id, int index, Any* p2) { return invoke<BOOL>(0x92A32BA29622763F, id, index, p2); } // 0x92A32BA29622763F b1207
	NATIVE_DECL BOOL _0x3FA09DD57B93C0DE(Hash p0, int p1, int p2, Any p3, int p4) { return invoke<BOOL>(0x3FA09DD57B93C0DE, p0, p1, p2, p3, p4); } // 0x3FA09DD57B93C0DE b1207
	NATIVE_DECL BOOL _0xD1555FBC96C88444(Hash p0, int p1, int p2, Any p3, int p4) { return invoke<BOOL>(0xD1555FBC96C88444, p0, p1, p2, p3, p4); } // 0xD1555FBC96C88444 b1207
}

namespace NETWORK
{
	NATIVE_DECL BOOL NETWORK_IS_SIGNED_ONLINE() { return invoke<BOOL>(0x1077788E268557C2); } // 0x1077788E268557C2 0x6E5BDCE2 b1207
	// Hardcoded to return zero.
	// 
	// ==== PS4 specific info ====
	// 
	// Returns some sort of unavailable reason:
	// -1 = REASON_INVALID
	//  0 = REASON_OTHER
	//  1 = REASON_SYSTEM_UPDATE
	//  2 = REASON_GAME_UPDATE
	//  3 = REASON_SIGNED_OUT
	//  4 = REASON_AGE
	//  5 = REASON_CONNECTION
	// 
	// =================================
	NATIVE_DECL int _0x74FB3E29E6D10FA9() { return invoke<int>(0x74FB3E29E6D10FA9); } // 0x74FB3E29E6D10FA9 b1207
	// Returns whether the signed-in user has valid Rockstar Online Services (ROS) credentials.
	NATIVE_DECL BOOL NETWORK_HAS_VALID_ROS_CREDENTIALS() { return invoke<BOOL>(0x85443FF4C328F53B); } // 0x85443FF4C328F53B 0x3FB40673 b1207
	NATIVE_DECL BOOL NETWORK_IS_CLOUD_AVAILABLE() { return invoke<BOOL>(0x9A4CF4F48AD77302); } // 0x9A4CF4F48AD77302 0xC7FF5AFC b1207
	NATIVE_DECL BOOL NETWORK_HAS_SOCIAL_CLUB_ACCOUNT() { return invoke<BOOL>(0x67A5589628E0CFF6); } // 0x67A5589628E0CFF6 0x66EC713F b1207
	// If you are host, returns true else returns false.
	NATIVE_DECL BOOL NETWORK_IS_HOST() { return invoke<BOOL>(0x8DB296B814EDDA07); } // 0x8DB296B814EDDA07 0xE46AC10F b1207
	NATIVE_DECL BOOL NETWORK_HAVE_ONLINE_PRIVILEGES() { return invoke<BOOL>(0x25CB5A9F37BFD063); } // 0x25CB5A9F37BFD063 0xEF63BFDF b1207
	NATIVE_DECL BOOL NETWORK_CHECK_USER_CONTENT_PRIVILEGES(int p0) { return invoke<BOOL>(0x595F028698072DD9, p0); } // 0x595F028698072DD9 0xBB54AA3D b1207
	NATIVE_DECL BOOL NETWORK_CHECK_COMMUNICATION_PRIVILEGES(int p0) { return invoke<BOOL>(0x83F28CE49FBBFFBA, p0); } // 0x83F28CE49FBBFFBA 0xA79E5B05 b1207
	NATIVE_DECL BOOL NETWORK_CAN_VIEW_GAMER_USER_CONTENT(Any* gamerHandle) { return invoke<BOOL>(0x246545C37C27A717, gamerHandle); } // 0x246545C37C27A717 b1207
	NATIVE_DECL BOOL _0xF23A6D6C11D8EC15(Any* gamerHandle) { return invoke<BOOL>(0xF23A6D6C11D8EC15, gamerHandle); } // 0xF23A6D6C11D8EC15 b1207
	// Stadia only; always returns -1 on other platforms. p0 may be a BOOL.
	NATIVE_DECL int _0x3E8CCE6769DB5F34(int p0) { return invoke<int>(0x3E8CCE6769DB5F34, p0); } // 0x3E8CCE6769DB5F34 b1207
	NATIVE_DECL void _0x83FE8D7229593017() { invoke<Void>(0x83FE8D7229593017); } // 0x83FE8D7229593017 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_IS_PROMOTION_ENABLED() { return invoke<BOOL>(0x8FF6059DA26E688A); } // 0x8FF6059DA26E688A b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_IS_CUSTOM_UPSELL_ENABLED() { return invoke<BOOL>(0x78A9535AF83715C6); } // 0x78A9535AF83715C6 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_SHOULD_SHOW_PROMOTION_DLG() { return invoke<BOOL>(0xDA4B1A479C414FB2); } // 0xDA4B1A479C414FB2 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xFC6FCF4C03F1BBF6() { invoke<Void>(0xFC6FCF4C03F1BBF6); } // 0xFC6FCF4C03F1BBF6 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0x160F0CE6D76A39C9() { return invoke<Any>(0x160F0CE6D76A39C9); } // 0x160F0CE6D76A39C9 b1207
	// Hardcoded to return zero.
	NATIVE_DECL int NETWORK_GET_PROMOTION_DLG_SEEN_COUNT() { return invoke<int>(0x2FB53C631A49BE92); } // 0x2FB53C631A49BE92 b1207
	NATIVE_DECL void _0xE5FF65CFF5160752() { invoke<Void>(0xE5FF65CFF5160752); } // 0xE5FF65CFF5160752 b1207
	NATIVE_DECL BOOL NETWORK_CAN_ACCESS_MULTIPLAYER(int* loadingState) { return invoke<BOOL>(0xAF50DA1A3F8B1BA4, loadingState); } // 0xAF50DA1A3F8B1BA4 0xA520B982 b1207
	NATIVE_DECL BOOL NETWORK_CHECK_ACCESS_AND_ALERT_IF_FAIL() { return invoke<BOOL>(0x2A8112A974DE1EF6); } // 0x2A8112A974DE1EF6 b1207
	NATIVE_DECL int _NETWORK_GET_GLOBAL_ENTITY_FLAGS(Entity entity) { return invoke<int>(0xDD7806FD0543BC3D, entity); } // 0xDD7806FD0543BC3D b1207
	NATIVE_DECL void _0xA95470DA137587F5(BOOL p0) { invoke<Void>(0xA95470DA137587F5, p0); } // 0xA95470DA137587F5 b1207
	NATIVE_DECL Any _0xBB697756309D77EE(BOOL p0) { return invoke<Any>(0xBB697756309D77EE, p0); } // 0xBB697756309D77EE b1207
	NATIVE_DECL BOOL _NETWORK_HAS_COMPLETED_MP_INTRO_FLOW_ON_CURRENT_SLOT() { return invoke<BOOL>(0xDD73C9838CE7181D); } // 0xDD73C9838CE7181D b1207
	NATIVE_DECL BOOL NETWORK_SET_COMPLETED_MP_INTRO_FLOW_ON_CURRENT_SLOT(BOOL completed) { return invoke<BOOL>(0x2C5BD9A43987AA27, completed); } // 0x2C5BD9A43987AA27 b1207
	NATIVE_DECL BOOL _0xD7D0DF27CB1765B5(int p0) { return invoke<BOOL>(0xD7D0DF27CB1765B5, p0); } // 0xD7D0DF27CB1765B5 b1355
	NATIVE_DECL BOOL NETWORK_SET_MP_MISSION_FLAG_ON_CURRENT_SLOT(BOOL enabled, int flagIndex) { return invoke<BOOL>(0x86FD10251A7118A4, enabled, flagIndex); } // 0x86FD10251A7118A4 b1207
	NATIVE_DECL void _0x3E74A687A73979C6(BOOL p0) { invoke<Void>(0x3E74A687A73979C6, p0); } // 0x3E74A687A73979C6 b1207
	// Checks for session flag 'SF_PRIVATE'
	NATIVE_DECL BOOL NETWORK_SESSION_IS_PRIVATE() { return invoke<BOOL>(0xCEF70AA5B3F89BA1); } // 0xCEF70AA5B3F89BA1 0xDB67785D b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _NETWORK_SESSION_GET_SESSION_ID(Any* sessionId) { invoke<Void>(0xE9B356C330C0A806, sessionId); } // 0xE9B356C330C0A806 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL BOOL _NETWORK_SESSION_ARE_SESSION_IDS_EQUAL(Any* sessionId1, Any* sessionId2) { return invoke<BOOL>(0x4DEC5000F7B508F0, sessionId1, sessionId2); } // 0x4DEC5000F7B508F0 b1311
	// flags:
	// enum eSessionRequestOptionFlags
	// {
	// 	SESSION_REQUEST_OPTION_FLAG_INCLUDE_GANG_MEMBERS = (1 << 1),
	// 	SESSION_REQUEST_OPTION_FLAG_LEADER_KEEPS_GANG = (1 << 7),
	// };
	// 
	// seamlessType:
	// enum eSeamlessType
	// {
	// 	SEAMLESS_TYPE_NORMAL,
	// 	SEAMLESS_TYPE_PVE,
	// 	SEAMLESS_TYPE_DEV,
	// 	SEAMLESS_TYPE_NO_SEAMLESS
	// };
	NATIVE_DECL BOOL NETWORK_REQUEST_SESSION_SEAMLESS(int flags, int seamlessType, Any* sessionRequestId) { return invoke<BOOL>(0x04019AE4956D4393, flags, seamlessType, sessionRequestId); } // 0x04019AE4956D4393 b1207
	// Equivalent to NETWORK_REQUEST_SESSION_SEAMLESS if userHash == 0.
	// Otherwise it is equivalent to NETWORK_SESSION_REQUEST_SESSION_COMPETITIVE(flags, MATCHTYPE_SEAMLESS, userHash, 0, sessionRequestId);
	// 
	// p1 is unused
	NATIVE_DECL BOOL NETWORK_SESSION_REQUEST_SESSION_SEAMLESS(int flags, int seamlessType, int userHash, Any* sessionRequestId) { return invoke<BOOL>(0x2989E131FDE37E97, flags, seamlessType, userHash, sessionRequestId); } // 0x2989E131FDE37E97 b1207
	// matchType:
	// enum eMatchType
	// {
	// 	MATCHTYPE_DEPRECATED,
	// 	MATCHTYPE_UGCPLAYLIST,
	// 	MATCHTYPE_UGCMISSION,
	// 	MATCHTYPE_MINIGAME,
	// 	MATCHTYPE_SEAMLESS,
	// 	MATCHTYPE_PRIVATE_DO_NOT_USE
	// };
	NATIVE_DECL BOOL NETWORK_SESSION_REQUEST_SESSION_COMPETITIVE(int flags, int matchType, int userHash, int p3, Any* sessionRequestId) { return invoke<BOOL>(0x309BBEBEA8A3986C, flags, matchType, userHash, p3, sessionRequestId); } // 0x309BBEBEA8A3986C b1207
	// Session flag 'SF_PRIVATE' is set internally
	// p1 represents max amount of players in private session
	NATIVE_DECL BOOL NETWORK_SESSION_REQUEST_SESSION_PRIVATE(int flags, int numPlayers, int userHash, Any* sessionRequestId) { return invoke<BOOL>(0x39A8EF7AF29A192C, flags, numPlayers, userHash, sessionRequestId); } // 0x39A8EF7AF29A192C b1207
	// category:
	// enum eOnCallType
	// {
	// 	NETWORK_SESSION_REQUEST_ON_CALL_TYPE_STORY = 2,
	// 	NETWORK_SESSION_REQUEST_ON_CALL_TYPE_MATCH = 3
	// };
	NATIVE_DECL BOOL _NETWORK_SESSION_REQUEST_SESSION_ON_CALL(int flags, int category, Any* p2, int userHash, Any* sessionRequestId) { return invoke<BOOL>(0x23D9C1F2E4098EDC, flags, category, p2, userHash, sessionRequestId); } // 0x23D9C1F2E4098EDC b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_REQUEST_SESSION_NOMINATED(int flags, int userHash, int p2, Any* sessionRequestId) { return invoke<BOOL>(0x4F4672457FF597D1, flags, userHash, p2, sessionRequestId); } // 0x4F4672457FF597D1 b1436
	NATIVE_DECL BOOL NETWORK_SESSION_IS_SESSION_REQUEST_ID_VALID(Any* sessionRequestId) { return invoke<BOOL>(0x2F54B146D3EDCE4D, sessionRequestId); } // 0x2F54B146D3EDCE4D b1207
	NATIVE_DECL int NETWORK_SESSION_GET_SESSION_TYPE() { return invoke<int>(0xF0C0C94B404206FA); } // 0xF0C0C94B404206FA b1207
	NATIVE_DECL int _0x1413B6BF27AB7A95() { return invoke<int>(0x1413B6BF27AB7A95); } // 0x1413B6BF27AB7A95 b1207
	NATIVE_DECL BOOL NETWORK_SESSION_IS_ANY_REQUEST_IN_PROGRESS() { return invoke<BOOL>(0xBAFFDE5F953720D9); } // 0xBAFFDE5F953720D9 b1207
	NATIVE_DECL BOOL _0xAFA14F98327791CE(Any* sessionRequestId) { return invoke<BOOL>(0xAFA14F98327791CE, sessionRequestId); } // 0xAFA14F98327791CE b1207
	NATIVE_DECL BOOL NETWORK_SESSION_IS_REQUEST_IN_PROGRESS(Any* sessionRequestId) { return invoke<BOOL>(0x8FB7C254CFCBF78E, sessionRequestId); } // 0x8FB7C254CFCBF78E b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_IS_REQUEST_IN_PROGRESS_BY_QUEUE_GROUP(int queueGroup) { return invoke<BOOL>(0x9E762A595CF88E4A, queueGroup); } // 0x9E762A595CF88E4A b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_CANCEL_REQUEST(Any* sessionRequestId) { return invoke<BOOL>(0xE72E5C1289BD1F40, sessionRequestId); } // 0xE72E5C1289BD1F40 b1207
	NATIVE_DECL void _0xA6F1BAABFF6AD7B9(Any p0) { invoke<Void>(0xA6F1BAABFF6AD7B9, p0); } // 0xA6F1BAABFF6AD7B9 b1207
	// Returns result of session request:
	// 0 - NOT_FOUND
	// 1 - IN_PROGRESS
	// 2 - TIMEOUT
	// 3 - PLAYER_OFFLINE
	// 4 - GANG_MEMBERS_CHANGED
	// 5 - PLAYER_CANCELLED
	// 6 - PLAYER_SET_TOO_LARGE
	// 7 - MATCH_ACCEPTED
	// 8 - OTHER
	NATIVE_DECL int _NETWORK_SESSION_GET_SESSION_REQUEST_RESULT(Any* sessionRequestId, int* p1) { return invoke<int>(0x0DD051B1BF4B8BD6, sessionRequestId, p1); } // 0x0DD051B1BF4B8BD6 b1207
	NATIVE_DECL BOOL NETWORK_SESSION_IS_REQUEST_PENDING_TRANSITION(Any* sessionRequestId) { return invoke<BOOL>(0xCCF878D50F8AB10D, sessionRequestId); } // 0xCCF878D50F8AB10D b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_TRANSITION_TO_SESSION(Any* sessionRequestId) { return invoke<BOOL>(0xF20B18A330E6DB5C, sessionRequestId); } // 0xF20B18A330E6DB5C b1207
	NATIVE_DECL BOOL _0x0F44A5C78D114922(Any* sessionRequestId) { return invoke<BOOL>(0x0F44A5C78D114922, sessionRequestId); } // 0x0F44A5C78D114922 b1207
	NATIVE_DECL BOOL NETWORK_SESSION_LEFT_QUEUE_OR_REQUESTED_SESSION(Any* sessionRequestId) { return invoke<BOOL>(0xECE6A0C1B59CD8BE, sessionRequestId); } // 0xECE6A0C1B59CD8BE b1207
	NATIVE_DECL BOOL NETWORK_SESSION_LEAVE_SESSION() { return invoke<BOOL>(0x17C21B7319A05047); } // 0x17C21B7319A05047 b1207
	NATIVE_DECL BOOL NETWORK_SESSION_IS_TRANSITIONING() { return invoke<BOOL>(0xF2CBC969C4F090C7); } // 0xF2CBC969C4F090C7 b1207
	// Only used in R* Script startup_clip
	NATIVE_DECL void _0xFD4272A137703449() { invoke<Void>(0xFD4272A137703449); } // 0xFD4272A137703449 b1207
	// Only used in R* Script net_rolling_playlist
	NATIVE_DECL void _NETWORK_SESSION_PLAYLIST_GO_TO_NEXT_CONTENT() { invoke<Void>(0xBDE605F925B07127); } // 0xBDE605F925B07127 b1436
	// Only used in R* Script net_rolling_playlist
	NATIVE_DECL void _NETWORK_SESSION_PLAYLIST_GET_UPCOMING_CONTENT() { invoke<Void>(0x8F9DB6CD03B42B58); } // 0x8F9DB6CD03B42B58 b1436
	NATIVE_DECL void NETWORK_DISABLE_REALTIME_MULTIPLAYER() { invoke<Void>(0x236905C700FDB54D); } // 0x236905C700FDB54D b1207
	// Only used in R* Script fm_race_controller
	NATIVE_DECL void _0x71FA2D1880C48032(BOOL p0) { invoke<Void>(0x71FA2D1880C48032, p0); } // 0x71FA2D1880C48032 b1207
	NATIVE_DECL void NETWORK_GET_GLOBAL_MULTIPLAYER_CLOCK(int* hours, int* minutes, int* seconds) { invoke<Void>(0x6D03BFBD643B2A02, hours, minutes, seconds); } // 0x6D03BFBD643B2A02 0x74E8C53E b1207
	NATIVE_DECL void NETWORK_CLEAR_CLOCK_TIME_OVERRIDE() { invoke<Void>(0xD972DF67326F966E); } // 0xD972DF67326F966E 0xC4AEAF49 b1207
	NATIVE_DECL BOOL NETWORK_IS_CLOCK_TIME_OVERRIDDEN() { return invoke<BOOL>(0xD7C95D322FF57522); } // 0xD7C95D322FF57522 0x2465296D b1207
	NATIVE_DECL BOOL NETWORK_GET_GLOBAL_CLOCK(int* hour, int* minute, int* second) { return invoke<BOOL>(0x11A7ADCD629E170F, hour, minute, second); } // 0x11A7ADCD629E170F b1207
	NATIVE_DECL void _NETWORK_CLOCK_TIME_OVERRIDE(int hour, int minute, int second, int transitionTime, BOOL pauseClock) { invoke<Void>(0x669E223E64B1903C, hour, minute, second, transitionTime, pauseClock); } // 0x669E223E64B1903C b1207
	NATIVE_DECL void _NETWORK_CLOCK_TIME_OVERRIDE_2(int hour, int minute, int second, int transitionTime, BOOL pauseClock, BOOL clockwise) { invoke<Void>(0xE28C13ECC36FF14E, hour, minute, second, transitionTime, pauseClock, clockwise); } // 0xE28C13ECC36FF14E b1207
	NATIVE_DECL void _NETWORK_CLEAR_CLOCK_OVERRIDE_OVERTIME(int milliseconds) { invoke<Void>(0x65F040D91001ED4B, milliseconds); } // 0x65F040D91001ED4B b1207
	NATIVE_DECL BOOL _0x0E54D4DA6018FF8E() { return invoke<BOOL>(0x0E54D4DA6018FF8E); } // 0x0E54D4DA6018FF8E b1207
	NATIVE_DECL BOOL NETWORK_IS_FINDING_GAMERS() { return invoke<BOOL>(0xDDDF64C91BFCF0AA); } // 0xDDDF64C91BFCF0AA 0xA6DAA79F b1207
	NATIVE_DECL BOOL NETWORK_DID_FIND_GAMERS_SUCCEED() { return invoke<BOOL>(0xF9B83B77929D8863); } // 0xF9B83B77929D8863 0xBEDC4503 b1207
	NATIVE_DECL int _0x7BCA0A3972708436(Any p0, int p1) { return invoke<int>(0x7BCA0A3972708436, p0, p1); } // 0x7BCA0A3972708436 b1207
	NATIVE_DECL void NETWORK_CLEAR_FOUND_GAMERS() { invoke<Void>(0x6D14CCEE1B40381A); } // 0x6D14CCEE1B40381A 0x6AA9A154 b1207
	NATIVE_DECL BOOL _NETWORK_GET_GAMER_SESSION_FROM_HANDLE(Any* data, int count) { return invoke<BOOL>(0xFBDFE1C1356E12E8, data, count); } // 0xFBDFE1C1356E12E8 b1207
	NATIVE_DECL BOOL _0x25189F9908E9CD65() { return invoke<BOOL>(0x25189F9908E9CD65); } // 0x25189F9908E9CD65 b1207
	NATIVE_DECL BOOL NETWORK_DID_GET_GAMER_STATUS_SUCCEED() { return invoke<BOOL>(0x5AE17C6B0134B7F1); } // 0x5AE17C6B0134B7F1 0xC871E745 b1207
	NATIVE_DECL int _NETWORK_GET_GAMER_STATUS(Any* gamerHandle, int p1) { return invoke<int>(0xDDAEB478E58F8DEA, gamerHandle, p1); } // 0xDDAEB478E58F8DEA b1207
	NATIVE_DECL void NETWORK_CLEAR_GET_GAMER_STATUS() { invoke<Void>(0x86E0660E4F5C956D); } // 0x86E0660E4F5C956D 0x3F7EDBBD b1207
	NATIVE_DECL void NETWORK_SET_SCRIPT_READY_FOR_EVENTS(BOOL toggle) { invoke<Void>(0x7AC752103856FB20, toggle); } // 0x7AC752103856FB20 0xA639DCA2 b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL BOOL _0x316FD416C432C761() { return invoke<BOOL>(0x316FD416C432C761); } // 0x316FD416C432C761 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL BOOL _0x062842D61D0D53FD() { return invoke<BOOL>(0x062842D61D0D53FD); } // 0x062842D61D0D53FD b1311
	NATIVE_DECL BOOL NETWORK_IS_GAME_IN_PROGRESS() { return invoke<BOOL>(0x10FAB35428CCC9D7); } // 0x10FAB35428CCC9D7 0x09B88E3E b1207
	NATIVE_DECL BOOL NETWORK_IS_SESSION_ACTIVE() { return invoke<BOOL>(0xD83C2B94E7508980); } // 0xD83C2B94E7508980 0x715CB8C4 b1207
	NATIVE_DECL BOOL NETWORK_IS_IN_SESSION() { return invoke<BOOL>(0xCA97246103B63917); } // 0xCA97246103B63917 0x4BC4105E b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL _NETWORK_IS_IN_SESSION_LOBBY() { return invoke<BOOL>(0xC5196C42DE19F646); } // 0xC5196C42DE19F646 b1207
	NATIVE_DECL BOOL NETWORK_IS_SESSION_STARTED() { return invoke<BOOL>(0x9DE624D2FC4B603F); } // 0x9DE624D2FC4B603F 0x9D854A37 b1207
	NATIVE_DECL BOOL NETWORK_CAN_SESSION_END() { return invoke<BOOL>(0x4EEBC3694E49C572); } // 0x4EEBC3694E49C572 0xE1FCCDBA b1207
	// _NETWORK_GET_G*
	NATIVE_DECL int _0x225640E09EFFDC3F() { return invoke<int>(0x225640E09EFFDC3F); } // 0x225640E09EFFDC3F b1207
	// enum eSessionFlags
	// {
	// 	SESSION_FLAG_NONE = 0,
	// 	SF_INSTANCE = (1 << 0),
	// 	SF_MATCH = (1 << 1),
	// 	SF_PRIVATE = (1 << 2),
	// 	SF_BLOCK_INVITES = (1 << 3),
	// 	SF_BLOCK_JOIN_VIA_PRESENCE = (1 << 4),
	// 	SF_BLOCK_NON_HOST_INVITES = (1 << 5),
	// 	SF_BLOCK_IN_PROGRESS_MATCHMAKING_BACKFILL = (1 << 6),
	// 	SF_BLOCK_IN_GAMEPLAY_MATCHMAKING_BACKFILL = (1 << 7),
	// 	SF_BLOCK_INVITES_TEMPORARY = (1 << 8),
	// 	SF_IN_GAMEPLAY = (1 << 9),
	// 	SF_COMPETITIVE = (1 << 10),
	// 	SF_MATCHMAKING_BACKFILL_IS_BLOCKED = (1 << 11)
	// };
	NATIVE_DECL BOOL _NETWORK_SESSION_ADD_SESSION_FLAGS(int flags) { return invoke<BOOL>(0xE546BDA1B3E288EE, flags); } // 0xE546BDA1B3E288EE b1207
	// See _NETWORK_SESSION_ADD_SESSION_FLAGS
	NATIVE_DECL BOOL NETWORK_SESSION_REMOVE_SESSION_FLAGS(int flags) { return invoke<BOOL>(0x78335E12DB0BF961, flags); } // 0x78335E12DB0BF961 b1207
	NATIVE_DECL int NETWORK_SESSION_GET_SESSION_FLAGS() { return invoke<int>(0x51F33DBC1A41CBFD); } // 0x51F33DBC1A41CBFD b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_SET_PLAYER_FLAGS(int flags) { return invoke<BOOL>(0x0AE241A4A9ADEEEC, flags); } // 0x0AE241A4A9ADEEEC b1207
	NATIVE_DECL BOOL _NETWORK_SESSION_REMOVE_PLAYER_FLAGS(int flags) { return invoke<BOOL>(0x3215BBE34D3418C5, flags); } // 0x3215BBE34D3418C5 b1207
	NATIVE_DECL Player _NETWORK_GET_SESSION_HOST() { return invoke<Player>(0x8DC9AA3B508B1A85); } // 0x8DC9AA3B508B1A85 b1207
	NATIVE_DECL Any _0xD3A3C8B9F3BDEF81() { return invoke<Any>(0xD3A3C8B9F3BDEF81); } // 0xD3A3C8B9F3BDEF81 b1207
	NATIVE_DECL BOOL _0x18B94666CF610AEB() { return invoke<BOOL>(0x18B94666CF610AEB); } // 0x18B94666CF610AEB b1207
	NATIVE_DECL BOOL _0x981146E5C9CE9250(int p0) { return invoke<BOOL>(0x981146E5C9CE9250, p0); } // 0x981146E5C9CE9250 b1207
	NATIVE_DECL int _0xBF8276E51761F9DA() { return invoke<int>(0xBF8276E51761F9DA); } // 0xBF8276E51761F9DA b1207
	NATIVE_DECL BOOL _0xDCA4A74135E1DEA5(Any p0) { return invoke<BOOL>(0xDCA4A74135E1DEA5, p0); } // 0xDCA4A74135E1DEA5 b1207
	NATIVE_DECL BOOL NETWORK_HAS_PENDING_INVITE_FAILURE() { return invoke<BOOL>(0xD0498AD30E16B6BD); } // 0xD0498AD30E16B6BD b1207
	NATIVE_DECL BOOL _NETWORK_CAN_RECEIVE_INVITE_FROM_HANDLE(Any* gamerHandle) { return invoke<BOOL>(0xF23D6475640D29EB, gamerHandle); } // 0xF23D6475640D29EB b1207
	NATIVE_DECL void _0x704F92B3AF20D857(BOOL setting) { invoke<Void>(0x704F92B3AF20D857, setting); } // 0x704F92B3AF20D857 b1207
	NATIVE_DECL void _0xF342F6BD0A8287D5(Any p0) { invoke<Void>(0xF342F6BD0A8287D5, p0); } // 0xF342F6BD0A8287D5 b1207
	NATIVE_DECL void _0xD39A72AE5EBD57E5() { invoke<Void>(0xD39A72AE5EBD57E5); } // 0xD39A72AE5EBD57E5 b1207
	NATIVE_DECL BOOL _NETWORK_SEND_SESSION_INVITE(Any* gamerHandle, const char* contentId, Any* data, int dataSize, int p4, int flags) { return invoke<BOOL>(0xE47001B7CB8B98AE, gamerHandle, contentId, data, dataSize, p4, flags); } // 0xE47001B7CB8B98AE b1207
	NATIVE_DECL BOOL _0xD1FFB246F4E088AC(int p0) { return invoke<BOOL>(0xD1FFB246F4E088AC, p0); } // 0xD1FFB246F4E088AC b1207
	NATIVE_DECL int _0x27B1AE4D8C652F08(int p0) { return invoke<int>(0x27B1AE4D8C652F08, p0); } // 0x27B1AE4D8C652F08 b1207
	NATIVE_DECL int _0x6C27442A225A241A(int p0) { return invoke<int>(0x6C27442A225A241A, p0); } // 0x6C27442A225A241A b1207
	NATIVE_DECL const char* _0xE59F4924BD3A718D(int p0) { return invoke<const char*>(0xE59F4924BD3A718D, p0); } // 0xE59F4924BD3A718D b1207
	// Note: this native was added in build 1436.31
	NATIVE_DECL int _DELAY_ACTUAL_CONTENT_AND_CALL_IT_A_DAY_L_STAR(int p0) { return invoke<int>(0x78271BC02AE9AF83, p0); } // 0x78271BC02AE9AF83 b1436
	NATIVE_DECL BOOL _0x16EFB123C4451032(int p0, Any* gamerHandle) { return invoke<BOOL>(0x16EFB123C4451032, p0, gamerHandle); } // 0x16EFB123C4451032 b1207
	NATIVE_DECL const char* _0xE79BA3BC265895DA(int p0) { return invoke<const char*>(0xE79BA3BC265895DA, p0); } // 0xE79BA3BC265895DA b1207
	NATIVE_DECL Any _0xC0CFFDA87C2C163D(int p0, Any p1, int p2) { return invoke<Any>(0xC0CFFDA87C2C163D, p0, p1, p2); } // 0xC0CFFDA87C2C163D b1207
	NATIVE_DECL Any _0x5ED39DA62BEB1330(int p0) { return invoke<Any>(0x5ED39DA62BEB1330, p0); } // 0x5ED39DA62BEB1330 b1207
	NATIVE_DECL BOOL NETWORK_ACCEPT_RS_INVITE(int p0) { return invoke<BOOL>(0xB2CEA5105AAC8DDE, p0); } // 0xB2CEA5105AAC8DDE b1207
	NATIVE_DECL BOOL _0x3AA0CDC63696166D(int p0) { return invoke<BOOL>(0x3AA0CDC63696166D, p0); } // 0x3AA0CDC63696166D b1207
	NATIVE_DECL int NETWORK_REQUEST_JOIN(Any p0) { return invoke<int>(0xE483BB6BE686F632, p0); } // 0xE483BB6BE686F632 b1207
	NATIVE_DECL int _0xE8E633215471BB5D(Any p0) { return invoke<int>(0xE8E633215471BB5D, p0); } // 0xE8E633215471BB5D b1207
	NATIVE_DECL BOOL _0xA2837A5E21FB5A58(Any p0) { return invoke<BOOL>(0xA2837A5E21FB5A58, p0); } // 0xA2837A5E21FB5A58 b1207
	NATIVE_DECL BOOL _0xE39600E50D608693(Any p0, Any p1) { return invoke<BOOL>(0xE39600E50D608693, p0, p1); } // 0xE39600E50D608693 b1207
	NATIVE_DECL BOOL _0xD7BAD4062074B9C1(Any p0) { return invoke<BOOL>(0xD7BAD4062074B9C1, p0); } // 0xD7BAD4062074B9C1 b1207
	NATIVE_DECL int _0xCA58D4FD20D70F24(Any p0) { return invoke<int>(0xCA58D4FD20D70F24, p0); } // 0xCA58D4FD20D70F24 b1207
	NATIVE_DECL BOOL _0xC028B3F52C707C49(Any p0) { return invoke<BOOL>(0xC028B3F52C707C49, p0); } // 0xC028B3F52C707C49 b1207
	NATIVE_DECL BOOL NETWORK_IS_PLATFORM_INVITE_PENDING() { return invoke<BOOL>(0xFC4165C9165C166F); } // 0xFC4165C9165C166F b1207
	NATIVE_DECL void _0x5B9C6AC118FD4774() { invoke<Void>(0x5B9C6AC118FD4774); } // 0x5B9C6AC118FD4774 b1207
	NATIVE_DECL int _NETWORK_GET_PLATFORM_INVITE_ID() { return invoke<int>(0x9BCF28FB5D65A9BE); } // 0x9BCF28FB5D65A9BE b1207
	NATIVE_DECL BOOL NETWORK_ACTION_PLATFORM_INVITE() { return invoke<BOOL>(0x3B82ACC3F4B6240C); } // 0x3B82ACC3F4B6240C b1207
	NATIVE_DECL void NETWORK_CLEAR_PLATFORM_INVITE() { invoke<Void>(0xA4484173759749B1); } // 0xA4484173759749B1 b1207
	NATIVE_DECL void _0x603469298A4308AF(BOOL p0) { invoke<Void>(0x603469298A4308AF, p0); } // 0x603469298A4308AF b1207
	// Returns value of fwuiCachedSetting "general.onlineNotificationsInStoryMode"
	NATIVE_DECL BOOL _NETWORK_ARE_ONLINE_NOTIFICATIONS_SHOWN_IN_STORY_MODE() { return invoke<BOOL>(0xF5C5929E07512F80); } // 0xF5C5929E07512F80 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_IS_IN_PLATFORM_PARTY() { return invoke<BOOL>(0x2FC5650B0271CB57); } // 0x2FC5650B0271CB57 0xA812B6CB b1207
	NATIVE_DECL Any _0x11820D1AE80DEA39(Any p0, Any p1) { return invoke<Any>(0x11820D1AE80DEA39, p0, p1); } // 0x11820D1AE80DEA39 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_IS_IN_PLATFORM_PARTY_CHAT() { return invoke<BOOL>(0xFD8B834A8BA05048); } // 0xFD8B834A8BA05048 0xC6609191 b1207
	NATIVE_DECL void NETWORK_SEED_RANDOM_NUMBER_GENERATOR(int seed) { invoke<Void>(0xF1B84178F8674195, seed); } // 0xF1B84178F8674195 0x41702C8A b1207
	NATIVE_DECL int NETWORK_GET_RANDOM_INT_RANGED(int rangeStart, int rangeEnd) { return invoke<int>(0xE30CF56F1EFA5F43, rangeStart, rangeEnd); } // 0xE30CF56F1EFA5F43 0xF9B6426D b1207
	NATIVE_DECL void NETWORK_SET_THIS_SCRIPT_IS_NETWORK_SCRIPT(int maxNumMissionParticipants, BOOL p1, int instanceId) { invoke<Void>(0x1CA59E306ECB80A5, maxNumMissionParticipants, p1, instanceId); } // 0x1CA59E306ECB80A5 0x470810ED b1207
	NATIVE_DECL BOOL NETWORK_GET_THIS_SCRIPT_IS_NETWORK_SCRIPT() { return invoke<BOOL>(0x2910669969E9535E); } // 0x2910669969E9535E 0xD9BF6549 b1207
	// Seems to always return 0, but it's used in quite a few loops.
	// 
	// for (num3 = 0; num3 < NETWORK::0xCCD8C02D(); num3++)
	//     {
	//         if (NETWORK::NETWORK_IS_PARTICIPANT_ACTIVE(PLAYER::0x98F3B274(num3)) != 0)
	//         {
	//             var num5 = NETWORK::NETWORK_GET_PLAYER_INDEX(PLAYER::0x98F3B274(num3));
	NATIVE_DECL int NETWORK_GET_MAX_NUM_PARTICIPANTS() { return invoke<int>(0xA6C90FBC38E395EE); } // 0xA6C90FBC38E395EE 0xCCD8C02D b1207
	NATIVE_DECL int NETWORK_GET_NUM_PARTICIPANTS() { return invoke<int>(0x18D0456E86604654); } // 0x18D0456E86604654 0x3E25A3C5 b1207
	NATIVE_DECL int NETWORK_GET_SCRIPT_STATUS() { return invoke<int>(0x57D158647A6BFABF); } // 0x57D158647A6BFABF 0x2BE9235A b1207
	NATIVE_DECL void NETWORK_REGISTER_HOST_BROADCAST_VARIABLES(Any p0, Any p1, Any p2) { invoke<Void>(0x3E9B2F01C50DF595, p0, p1, p2); } // 0x3E9B2F01C50DF595 0xDAF3B0AE b1207
	NATIVE_DECL int _NETWORK_GET_SIZE_OF_HOST_BROADCAST_DATA_STORAGE(int* p0) { return invoke<int>(0xBA24095EA96DFE17, p0); } // 0xBA24095EA96DFE17 b1207
	NATIVE_DECL void NETWORK_REGISTER_PLAYER_BROADCAST_VARIABLES(Any p0, Any p1, Any p2) { invoke<Void>(0x3364AA97340CA215, p0, p1, p2); } // 0x3364AA97340CA215 0xBE3D32B4 b1207
	NATIVE_DECL int _NETWORK_GET_SIZE_OF_PLAYER_BROADCAST_DATA_STORAGE(int* p0) { return invoke<int>(0x690806BC83BC8CA2, p0); } // 0x690806BC83BC8CA2 b1207
	NATIVE_DECL BOOL NETWORK_HAS_RECEIVED_HOST_BROADCAST_DATA() { return invoke<BOOL>(0x5D10B3795F3FC886); } // 0x5D10B3795F3FC886 0x0B739F53 b1207
	NATIVE_DECL int NETWORK_GET_PLAYER_INDEX(Player player) { return invoke<int>(0x24FB80D107371267, player); } // 0x24FB80D107371267 0xBE1C1506 b1207
	NATIVE_DECL int NETWORK_GET_PARTICIPANT_INDEX(int index) { return invoke<int>(0x1B84DF6AF2A46938, index); } // 0x1B84DF6AF2A46938 0xC4D91094 b1207
	// Returns the Player associated to a given Ped when in an online session.
	NATIVE_DECL Player NETWORK_GET_PLAYER_INDEX_FROM_PED(Ped ped) { return invoke<Player>(0x6C0E2E0125610278, ped); } // 0x6C0E2E0125610278 0x40DBF464 b1207
	// Returns the amount of players connected in the current session. Only works when connected to a session/server.
	NATIVE_DECL int NETWORK_GET_NUM_CONNECTED_PLAYERS() { return invoke<int>(0xA4A79DD2D9600654); } // 0xA4A79DD2D9600654 0xF7952E62 b1207
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_CONNECTED(Player player) { return invoke<BOOL>(0x93DC1BE4E1ABE9D1, player); } // 0x93DC1BE4E1ABE9D1 0x168EE2C2 b1207
	NATIVE_DECL int NETWORK_GET_TOTAL_NUM_PLAYERS() { return invoke<int>(0xCF61D4B4702EE9EB); } // 0xCF61D4B4702EE9EB 0xF4F13B06 b1207
	NATIVE_DECL BOOL NETWORK_IS_PARTICIPANT_ACTIVE(int p0) { return invoke<BOOL>(0x6FF8FF40B6357D45, p0); } // 0x6FF8FF40B6357D45 0x4E2C348B b1207
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_ACTIVE(Player player) { return invoke<BOOL>(0xB8DFD30D6973E135, player); } // 0xB8DFD30D6973E135 0x43657B17 b1207
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_A_PARTICIPANT(Player player) { return invoke<BOOL>(0x3CA58F6CB7CBD784, player); } // 0x3CA58F6CB7CBD784 0xB08B6992 b1207
	NATIVE_DECL BOOL NETWORK_IS_HOST_OF_THIS_SCRIPT() { return invoke<BOOL>(0x83CD99A1E6061AB5); } // 0x83CD99A1E6061AB5 0x6970BA94 b1207
	NATIVE_DECL Player NETWORK_GET_HOST_OF_THIS_SCRIPT() { return invoke<Player>(0xC7B4D79B01FA7A5C); } // 0xC7B4D79B01FA7A5C 0x89EA7B54 b1232
	NATIVE_DECL Player NETWORK_GET_HOST_OF_SCRIPT(const char* scriptName, int p1, int p2) { return invoke<Player>(0x1D6A14F1F9A736FC, scriptName, p1, p2); } // 0x1D6A14F1F9A736FC 0x9C95D0BB b1436
	NATIVE_DECL Player _NETWORK_GET_HOST_OF_THREAD(int threadId) { return invoke<Player>(0xB4A25351D79B444C, threadId); } // 0xB4A25351D79B444C b1207
	NATIVE_DECL void NETWORK_SET_MISSION_FINISHED() { invoke<Void>(0x3B3D11CD9FFCDFC9); } // 0x3B3D11CD9FFCDFC9 0x3083FAD7 b1207
	NATIVE_DECL BOOL NETWORK_IS_SCRIPT_ACTIVE(const char* scriptName, int p1, BOOL p2, int p3) { return invoke<BOOL>(0x9D40DF90FAD26098, scriptName, p1, p2, p3); } // 0x9D40DF90FAD26098 0x4A65250C b1207
	NATIVE_DECL BOOL NETWORK_IS_SCRIPT_ACTIVE_BY_HASH(Hash scriptHash, int p1, BOOL p2, int p3) { return invoke<BOOL>(0x1B89BC43B6E69107, scriptHash, p1, p2, p3); } // 0x1B89BC43B6E69107 b1207
	NATIVE_DECL BOOL _NETWORK_IS_THREAD_ACTIVE(int threadId) { return invoke<BOOL>(0x31DAD2CD6D49546E, threadId); } // 0x31DAD2CD6D49546E b1207
	NATIVE_DECL int _NETWORK_GET_INSTANCE_ID_OF_THREAD(int threadId) { return invoke<int>(0xFB9ECED5B68F3B78, threadId); } // 0xFB9ECED5B68F3B78 b1207
	NATIVE_DECL int NETWORK_GET_NUM_SCRIPT_PARTICIPANTS(const char* scriptName, int instanceId, Hash position) { return invoke<int>(0x3658E8CD94FC121A, scriptName, instanceId, position); } // 0x3658E8CD94FC121A 0x8F7D9F46 b1207
	NATIVE_DECL int NETWORK_GET_INSTANCE_ID_OF_THIS_SCRIPT() { return invoke<int>(0x638A3A81733086DB); } // 0x638A3A81733086DB 0xDB8B5D71 b1207
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_A_PARTICIPANT_ON_SCRIPT(Player p0, Any* p1, Any p2) { return invoke<BOOL>(0x1AD5B71586B94820, p0, p1, p2); } // 0x1AD5B71586B94820 0xCEA55F4C b1207
	NATIVE_DECL void NETWORK_PREVENT_SCRIPT_HOST_MIGRATION() { invoke<Void>(0x2302C0264EA58D31); } // 0x2302C0264EA58D31 0x8DCFE77D b1207
	NATIVE_DECL BOOL NETWORK_IS_FEATURE_SUPPORTED(int featureId) { return invoke<BOOL>(0x9C725D149622BFDE, featureId); } // 0x9C725D149622BFDE b1207
	// Return the local Participant ID
	NATIVE_DECL Player PARTICIPANT_ID() { return invoke<Player>(0x90986E8876CE0A83); } // 0x90986E8876CE0A83 0x9C35A221 b1207
	// Return the local Participant ID.
	// 
	// This native is exactly the same as 'PARTICIPANT_ID' native.
	NATIVE_DECL int PARTICIPANT_ID_TO_INT() { return invoke<int>(0x57A3BDDAD8E5AA0A); } // 0x57A3BDDAD8E5AA0A 0x907498B0 b1207
	NATIVE_DECL int NETWORK_GET_DESTROYER_OF_NETWORK_ID(int netId, Hash* weaponHash) { return invoke<int>(0x7A1ADEEF01740A24, netId, weaponHash); } // 0x7A1ADEEF01740A24 0x4FCA6436 b1207
	// _NETWORK_GET_A* - _NETWORK_GET_D*
	NATIVE_DECL Player _0x6CF82A7F65A5AD5F(Ped ped, Any* p1) { return invoke<Player>(0x6CF82A7F65A5AD5F, ped, p1); } // 0x6CF82A7F65A5AD5F b1207
	// _NETWORK_GET_A* - _NETWORK_GET_D*
	NATIVE_DECL BOOL _0x236321F1178A5446(Player player, Ped ped, Any* p2) { return invoke<BOOL>(0x236321F1178A5446, player, ped, p2); } // 0x236321F1178A5446 b1207
	NATIVE_DECL BOOL NETWORK_GET_ASSISTED_DAMAGE_OF_ENTITY(Player player, Entity entity, int* p2) { return invoke<BOOL>(0x4CACA84440FA26F6, player, entity, p2); } // 0x4CACA84440FA26F6 0x28A45454 b1207
	NATIVE_DECL Entity NETWORK_GET_ENTITY_KILLER_OF_PLAYER(Player player, Hash* weaponHash) { return invoke<Entity>(0x42B2DAA6B596F5F8, player, weaponHash); } // 0x42B2DAA6B596F5F8 0xA7E7E04F b1207
	NATIVE_DECL void NETWORK_RESURRECT_LOCAL_PLAYER(float x, float y, float z, float heading, int p4, BOOL p5, Any p6, BOOL p7) { invoke<Void>(0xEA23C49EAA83ACFB, x, y, z, heading, p4, p5, p6, p7); } // 0xEA23C49EAA83ACFB 0xF1F9D4B4 b1207
	NATIVE_DECL void NETWORK_RESURRECT_LOCAL_PLAYER(Vector3 vec, float heading, int p4, BOOL p5, Any p6, BOOL p7) { invoke<Void>(0xEA23C49EAA83ACFB, vec.x, vec.y, vec.z, heading, p4, p5, p6, p7); } // 0xEA23C49EAA83ACFB 0xF1F9D4B4 b1207
	NATIVE_DECL void _NETWORK_RESURRECT_LOCAL_PLAYER_2(Any* args) { invoke<Void>(0x4154B7D8C75E5DCF, args); } // 0x4154B7D8C75E5DCF b1207
	NATIVE_DECL void NETWORK_SET_LOCAL_PLAYER_INVINCIBLE_TIME(int time) { invoke<Void>(0x2D95C7E2D7E07307, time); } // 0x2D95C7E2D7E07307 0xFEA9B85C b1207
	NATIVE_DECL void NETWORK_SET_LOCAL_PLAYER_SYNC_LOOK_AT(BOOL toggle) { invoke<Void>(0x524FF0AEFF9C3973, toggle); } // 0x524FF0AEFF9C3973 0xB72F086D b1207
	NATIVE_DECL BOOL NETWORK_HAS_ENTITY_BEEN_REGISTERED_WITH_THIS_THREAD(Entity entity) { return invoke<BOOL>(0xB07D3185E11657A5, entity); } // 0xB07D3185E11657A5 0xEDA68956 b1207
	NATIVE_DECL int NETWORK_GET_NETWORK_ID_FROM_ENTITY(Entity entity) { return invoke<int>(0xA11700682F3AD45C, entity); } // 0xA11700682F3AD45C 0x9E35DAB6 b1207
	NATIVE_DECL Entity NETWORK_GET_ENTITY_FROM_NETWORK_ID(int netId) { return invoke<Entity>(0xCE4E5D9B0A4FF560, netId); } // 0xCE4E5D9B0A4FF560 0x5B912C3F b1207
	NATIVE_DECL BOOL NETWORK_GET_ENTITY_IS_NETWORKED(Entity entity) { return invoke<BOOL>(0xC7827959479DCC78, entity); } // 0xC7827959479DCC78 0xD7F934F4 b1207
	NATIVE_DECL void NETWORK_REGISTER_ENTITY_AS_NETWORKED(Entity entity) { invoke<Void>(0x06FAACD625D80CAA, entity); } // 0x06FAACD625D80CAA 0x31A630A4 b1207
	NATIVE_DECL BOOL NETWORK_DOES_NETWORK_ID_EXIST(int netID) { return invoke<BOOL>(0x38CE16C96BD11344, netID); } // 0x38CE16C96BD11344 0xB8D2C99E b1207
	NATIVE_DECL Any _0x950ACD8F05B7B9DF(Any p0) { return invoke<Any>(0x950ACD8F05B7B9DF, p0); } // 0x950ACD8F05B7B9DF b1355
	NATIVE_DECL BOOL NETWORK_REQUEST_CONTROL_OF_NETWORK_ID(int netId) { return invoke<BOOL>(0xA670B3662FAFFBD0, netId); } // 0xA670B3662FAFFBD0 0x9262A60A b1207
	NATIVE_DECL BOOL NETWORK_HAS_CONTROL_OF_NETWORK_ID(int netId) { return invoke<BOOL>(0x4D36070FE0215186, netId); } // 0x4D36070FE0215186 0x92E77D21 b1207
	NATIVE_DECL BOOL NETWORK_REQUEST_CONTROL_OF_ENTITY(Entity entity) { return invoke<BOOL>(0xB69317BF5E782347, entity); } // 0xB69317BF5E782347 0xA05FEBD7 b1207
	NATIVE_DECL BOOL _NETWORK_REQUEST_CONTROL_OF_ANIM_SCENE(AnimScene animScene) { return invoke<BOOL>(0xAAA92B631B13F614, animScene); } // 0xAAA92B631B13F614 b1207
	NATIVE_DECL BOOL NETWORK_REQUEST_CONTROL_OF_PICKUP_PLACEMENT(Any p0) { return invoke<BOOL>(0x56ED2C48558DAB78, p0); } // 0x56ED2C48558DAB78 b1311
	NATIVE_DECL BOOL NETWORK_HAS_CONTROL_OF_ENTITY(Entity entity) { return invoke<BOOL>(0x01BF60A500E28887, entity); } // 0x01BF60A500E28887 0x005FD797 b1207
	NATIVE_DECL BOOL NETWORK_HAS_CONTROL_OF_PICKUP(Pickup pickup) { return invoke<BOOL>(0x5BC9495F0B3B6FA6, pickup); } // 0x5BC9495F0B3B6FA6 0xF7784FC8 b1207
	NATIVE_DECL BOOL _NETWORK_HAS_CONTROL_OF_ANIM_SCENE(AnimScene animScene) { return invoke<BOOL>(0x26A5C12FACFF8724, animScene); } // 0x26A5C12FACFF8724 b1207
	NATIVE_DECL BOOL NETWORK_HAS_CONTROL_OF_PICKUP_PLACEMENT(Any p0) { return invoke<BOOL>(0x51EABCF2786515AB, p0); } // 0x51EABCF2786515AB b1311
	// Same Native Handler as VEH_TO_NET, PED_TO_NET, OBJ_TO_NET and NETWORK_GET_NETWORK_ID_FROM_ENTITY
	NATIVE_DECL int _0xF260AF6F43953316(ScrHandle handle) { return invoke<int>(0xF260AF6F43953316, handle); } // 0xF260AF6F43953316 b1207
	// Returns the network ID of the given vehicle.
	NATIVE_DECL int VEH_TO_NET(Vehicle vehicle) { return invoke<int>(0xB4C94523F023419C, vehicle); } // 0xB4C94523F023419C 0xF17634EB b1207
	// Returns the network ID of the given ped.
	NATIVE_DECL int PED_TO_NET(Ped ped) { return invoke<int>(0x0EDEC3C276198689, ped); } // 0x0EDEC3C276198689 0x86A0B759 b1207
	// Returns the network ID of the given object.
	NATIVE_DECL int OBJ_TO_NET(Object object) { return invoke<int>(0x99BFDC94A603E541, object); } // 0x99BFDC94A603E541 0x1E05F29F b1207
	NATIVE_DECL int _ANIM_SCENE_TO_NET(AnimScene animScene) { return invoke<int>(0xE0D73CDDEA79DDCD, animScene); } // 0xE0D73CDDEA79DDCD b1207
	NATIVE_DECL Vehicle NET_TO_VEH(int netHandle) { return invoke<Vehicle>(0x367B936610BA360C, netHandle); } // 0x367B936610BA360C 0x7E02FAEA b1207
	// gets the ped id of a network id
	NATIVE_DECL Ped NET_TO_PED(int netHandle) { return invoke<Ped>(0xBDCD95FC216A8B3E, netHandle); } // 0xBDCD95FC216A8B3E 0x87717DD4 b1207
	// gets the object id of a network id
	NATIVE_DECL Object NET_TO_OBJ(int netHandle) { return invoke<Object>(0xD8515F5FEA14CB3F, netHandle); } // 0xD8515F5FEA14CB3F 0x27AA14D8 b1207
	// gets the entity id of a network id
	NATIVE_DECL Entity NET_TO_ENT(int netHandle) { return invoke<Entity>(0xBFFEAB45A9A9094A, netHandle); } // 0xBFFEAB45A9A9094A 0x5E149683 b1207
	NATIVE_DECL AnimScene _NET_TO_ANIM_SCENE(int netId) { return invoke<AnimScene>(0xD7F6781A0ABAF6FB, netId); } // 0xD7F6781A0ABAF6FB b1207
	NATIVE_DECL int _PROPSET_TO_NET(PropSet propSet) { return invoke<int>(0x74F99EF7EF503398, propSet); } // 0x74F99EF7EF503398 b1207
	NATIVE_DECL PropSet _NET_TO_PROPSET(int netId) { return invoke<PropSet>(0xD08066E00D26C448, netId); } // 0xD08066E00D26C448 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x0CC28C08613BA9E5(Any p0) { invoke<Void>(0x0CC28C08613BA9E5, p0); } // 0x0CC28C08613BA9E5 b1207
	NATIVE_DECL void NETWORK_GET_LOCAL_HANDLE(Any* gamerHandle) { invoke<Void>(0xE86051786B66CD8E, gamerHandle); } // 0xE86051786B66CD8E 0x08023B16 b1207
	NATIVE_DECL void NETWORK_HANDLE_FROM_PLAYER(Player player, Any* gamerHandle) { invoke<Void>(0x388EB2B86C73B6B3, player, gamerHandle); } // 0x388EB2B86C73B6B3 0xD3498917 b1207
	NATIVE_DECL Hash NETWORK_HASH_FROM_PLAYER_HANDLE(Player player) { return invoke<Hash>(0xBC1D768F2F5D6C05, player); } // 0xBC1D768F2F5D6C05 0xF8D7AF3B b1207
	NATIVE_DECL void NETWORK_HANDLE_FROM_FRIEND(int friendIndex, Any* gamerHandle) { invoke<Void>(0xD45CB817D7E177D2, friendIndex, gamerHandle); } // 0xD45CB817D7E177D2 0x3B0BB3A3 b1207
	// Always returns a null string.
	NATIVE_DECL const char* NETWORK_GET_GAMERTAG_FROM_HANDLE(Any* gamerHandle) { return invoke<const char*>(0x426141162EBE5CDB, gamerHandle); } // 0x426141162EBE5CDB 0xA18A1B26 b1207
	// Hardcoded to return -1.
	NATIVE_DECL int NETWORK_DISPLAYNAMES_FROM_HANDLES_START(Any* p0, Any p1) { return invoke<int>(0xD66C9E72B3CC4982, p0, p1); } // 0xD66C9E72B3CC4982 b1207
	// Hardcoded to return zero.
	NATIVE_DECL int NETWORK_GET_DISPLAYNAMES_FROM_HANDLES(Any p0, Any p1, Any p2) { return invoke<int>(0x58CC181719256197, p0, p1, p2); } // 0x58CC181719256197 b1207
	// Example:
	// 
	// char displayName[64];
	// if (_NETWORK_GET_DISPLAY_NAME_FROM_HANDLE(handle, displayName))
	// {
	// 	// use displayName
	// }
	NATIVE_DECL BOOL _NETWORK_GET_DISPLAY_NAME_FROM_HANDLE(Any* gamerHandle, char* displayName) { return invoke<BOOL>(0x7FEE4F07C54B6B3C, gamerHandle, displayName); } // 0x7FEE4F07C54B6B3C b1207
	NATIVE_DECL BOOL NETWORK_ARE_HANDLES_THE_SAME(Any* gamerHandle1, Any* gamerHandle2) { return invoke<BOOL>(0x57DBA049E110F217, gamerHandle1, gamerHandle2); } // 0x57DBA049E110F217 0x45975AE3 b1207
	NATIVE_DECL BOOL NETWORK_IS_HANDLE_VALID(Any* gamerHandle) { return invoke<BOOL>(0x6F79B93B0A8E4133, gamerHandle); } // 0x6F79B93B0A8E4133 0xF0996C6E b1207
	NATIVE_DECL Player NETWORK_GET_PLAYER_FROM_GAMER_HANDLE(Any* gamerHandle) { return invoke<Player>(0xCE5F689CF5A0A49D, gamerHandle); } // 0xCE5F689CF5A0A49D 0x2E96EF1E b1207
	NATIVE_DECL BOOL NETWORK_IS_GAMER_IN_MY_SESSION(Any* gamerHandle) { return invoke<BOOL>(0x0F10B05DDF8D16E9, gamerHandle); } // 0x0F10B05DDF8D16E9 0x59127716 b1207
	NATIVE_DECL void NETWORK_SHOW_PROFILE_UI(Any* gamerHandle) { invoke<Void>(0x859ED1CEA343FCA8, gamerHandle); } // 0x859ED1CEA343FCA8 0xF00A20B0 b1207
	NATIVE_DECL void _0x5759160AC17C13CE(Any* gamerHandle, const char* message) { invoke<Void>(0x5759160AC17C13CE, gamerHandle, message); } // 0x5759160AC17C13CE b1207
	// Returns the entity's network ID.
	NATIVE_DECL int _0xF302AB9D978352EE(Entity entity) { return invoke<int>(0xF302AB9D978352EE, entity); } // 0xF302AB9D978352EE b1207
	// Returns the entity associated with the given network ID.
	NATIVE_DECL Entity _0x4538EE7C321590BC(int networkId) { return invoke<Entity>(0x4538EE7C321590BC, networkId); } // 0x4538EE7C321590BC b1207
	NATIVE_DECL BOOL _0xA47D48D06AA5A188() { return invoke<BOOL>(0xA47D48D06AA5A188); } // 0xA47D48D06AA5A188 b1207
	NATIVE_DECL int NETWORK_GET_TOTAL_NUM_FRIENDS() { return invoke<int>(0xDB7ABDD203FA3704); } // 0xDB7ABDD203FA3704 b1207
	NATIVE_DECL int _0xA94ECE191D90637A() { return invoke<int>(0xA94ECE191D90637A); } // 0xA94ECE191D90637A b1207
	NATIVE_DECL void _0x5CB8B0C846D0F30B(Any p0) { invoke<Void>(0x5CB8B0C846D0F30B, p0); } // 0x5CB8B0C846D0F30B b1207
	NATIVE_DECL void _0xFF36F36B07E69059(Any p0) { invoke<Void>(0xFF36F36B07E69059, p0); } // 0xFF36F36B07E69059 b1207
	NATIVE_DECL BOOL _NETWORK_GET_CURRENT_FRIEND_PAGE_DATA(Any* p0) { return invoke<BOOL>(0xA3EEC0A5AFF3FC5B, p0); } // 0xA3EEC0A5AFF3FC5B b1207
	NATIVE_DECL int _0xB389289F031F059A() { return invoke<int>(0xB389289F031F059A); } // 0xB389289F031F059A b1207
	NATIVE_DECL BOOL NETWORK_CAN_REFRESH_FRIEND_PAGE() { return invoke<BOOL>(0x1AF5E28E64A76A9F); } // 0x1AF5E28E64A76A9F b1207
	NATIVE_DECL BOOL NETWORK_REFRESH_CURRENT_FRIEND_PAGE() { return invoke<BOOL>(0x1F51F367B710A832); } // 0x1F51F367B710A832 b1207
	NATIVE_DECL BOOL _0xDA1BFED8582F61F0() { return invoke<BOOL>(0xDA1BFED8582F61F0); } // 0xDA1BFED8582F61F0 b1207
	NATIVE_DECL BOOL _0x232E1EB23CDB313C() { return invoke<BOOL>(0x232E1EB23CDB313C); } // 0x232E1EB23CDB313C b1207
	NATIVE_DECL BOOL _0x3E4A16BC669E71B3() { return invoke<BOOL>(0x3E4A16BC669E71B3); } // 0x3E4A16BC669E71B3 b1207
	NATIVE_DECL BOOL _0xE348D1404BD80146(Any* gamerHandle) { return invoke<BOOL>(0xE348D1404BD80146, gamerHandle); } // 0xE348D1404BD80146 b1207
	NATIVE_DECL BOOL _0x665161D250850A9F(Any* gamerHandle) { return invoke<BOOL>(0x665161D250850A9F, gamerHandle); } // 0x665161D250850A9F b1207
	NATIVE_DECL const char* _NETWORK_GET_GAMERTAG_FROM_FRIEND(Any* gamerHandle) { return invoke<const char*>(0x5659D87BE674AB17, gamerHandle); } // 0x5659D87BE674AB17 b1207
	NATIVE_DECL BOOL NETWORK_IS_FRIEND(Any* gamerHandle) { return invoke<BOOL>(0x1A24A179F9B31654, gamerHandle); } // 0x1A24A179F9B31654 0x2DA4C282 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL NETWORK_IS_PENDING_FRIEND(Any* gamerHandle) { return invoke<BOOL>(0x0BE73DA6984A6E33, gamerHandle); } // 0x0BE73DA6984A6E33 0x5C85FF81 b1207
	NATIVE_DECL BOOL NETWORK_ADD_FRIEND(Any* gamerHandle, const char* message) { return invoke<BOOL>(0x8E02D73914064223, gamerHandle, message); } // 0x8E02D73914064223 0x20E5B3EE b1207
	NATIVE_DECL BOOL _NETWORK_REMOVE_FRIEND(Any* gamerHandle) { return invoke<BOOL>(0x55F618F68AB854D3, gamerHandle); } // 0x55F618F68AB854D3 b1207
	// On PC this returns true if gamerHandle is a valid handle.
	NATIVE_DECL BOOL _NETWORK_CAN_ADD_FRIEND(Any* gamerHandle) { return invoke<BOOL>(0x99ABE9BF9DADA162, gamerHandle); } // 0x99ABE9BF9DADA162 b1207
	// Old name: _NETWORK_SET_PASSIVE_MODE_OPTION
	NATIVE_DECL void NETWORK_SET_PLAYER_IS_PASSIVE(BOOL toggle) { invoke<Void>(0x9C25E8EC4C535FBD, toggle); } // 0x9C25E8EC4C535FBD b1207
	NATIVE_DECL void NETWORK_SET_FRIENDLY_FIRE_OPTION(BOOL toggle) { invoke<Void>(0xF808475FA571D823, toggle); } // 0xF808475FA571D823 0x6BAF95FA b1207
	NATIVE_DECL void NETWORK_SET_RICH_PRESENCE(int p0, Any* p1, int p2, int p3) { invoke<Void>(0x1DCCACDCFC569362, p0, p1, p2, p3); } // 0x1DCCACDCFC569362 0x932A6CED b1207
	NATIVE_DECL int NETWORK_GET_TIMEOUT_TIME() { return invoke<int>(0x5ED0356A0CE3A34F); } // 0x5ED0356A0CE3A34F 0xE1F86C6A b1207
	// Only used in fm_race_controller R* Script (PROCESS_LOCAL_PLAYER_INIT)
	NATIVE_DECL void _0xBC7D36946D19E60E(BOOL p0) { invoke<Void>(0xBC7D36946D19E60E, p0); } // 0xBC7D36946D19E60E b1207
	// Params: p5 = 50.f, p6 = 0 in R* Script net_fetch (NET_FETCH_CLIENT_UPDATE_PED_ROLE_CLUE_IDLE)
	NATIVE_DECL BOOL _0x880A7202301E282B(Any* p0, Any* p1, float x, float y, float z, float p5, Any p6) { return invoke<BOOL>(0x880A7202301E282B, p0, p1, x, y, z, p5, p6); } // 0x880A7202301E282B b1311
	NATIVE_DECL BOOL _0x880A7202301E282B(Any* p0, Any* p1, Vector3 vec, float p5, Any p6) { return invoke<BOOL>(0x880A7202301E282B, p0, p1, vec.x, vec.y, vec.z, p5, p6); } // 0x880A7202301E282B b1311
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0xC964FCD3D1720697() { return invoke<Any>(0xC964FCD3D1720697); } // 0xC964FCD3D1720697 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0xEC089F84A9C16C62() { return invoke<Any>(0xEC089F84A9C16C62); } // 0xEC089F84A9C16C62 b1207
	NATIVE_DECL void PREVENT_NETWORK_ID_MIGRATION(int netId) { invoke<Void>(0x7182EDDA1EE7DB5A, netId); } // 0x7182EDDA1EE7DB5A b1207
	NATIVE_DECL void KEEP_NETWORK_ID_IN_FAST_INSTANCE(int netId, BOOL p1, int p2) { invoke<Void>(0xE1BC73D6815BA361, netId, p1, p2); } // 0xE1BC73D6815BA361 b1207
	// Only used in SP R* Script dominoes_sp: p1 = 0
	NATIVE_DECL void _0x02C4C6C2900D84DF(Player player, Any p1) { invoke<Void>(0x02C4C6C2900D84DF, player, p1); } // 0x02C4C6C2900D84DF b1207
	NATIVE_DECL void _0xD78A26024BB13E08(Player player) { invoke<Void>(0xD78A26024BB13E08, player); } // 0xD78A26024BB13E08 b1207
	NATIVE_DECL void SET_NETWORK_ID_EXISTS_ON_ALL_MACHINES(int netId, BOOL toggle) { invoke<Void>(0xE05E81A888FA63C8, netId, toggle); } // 0xE05E81A888FA63C8 0x68D486B2 b1207
	NATIVE_DECL void SET_NETWORK_ID_ALWAYS_EXISTS_FOR_PLAYER(int netId, Player player, BOOL toggle) { invoke<Void>(0xA8A024587329F36A, netId, player, toggle); } // 0xA8A024587329F36A 0x4D15FDB1 b1207
	NATIVE_DECL void _0x9ED3108D6847760A(int netHandle, Any p1) { invoke<Void>(0x9ED3108D6847760A, netHandle, p1); } // 0x9ED3108D6847760A b1207
	NATIVE_DECL void _0xD785864798258032(Entity entity, BOOL toggle) { invoke<Void>(0xD785864798258032, entity, toggle); } // 0xD785864798258032 b1207
	// if set to true other network players can't see it
	// if set to false other network player can see it
	// =========================================
	// ^^ I attempted this by grabbing an object with GET_ENTITY_PLAYER_IS_FREE_AIMING_AT and setting this naive no matter the toggle he could still see it.
	// 
	// pc or last gen?
	// 
	// ^^ last-gen
	NATIVE_DECL void _NETWORK_SET_ENTITY_INVISIBLE_TO_NETWORK(Entity entity, BOOL toggle) { invoke<Void>(0xF1CA12B18AEF5298, entity, toggle); } // 0xF1CA12B18AEF5298 0x09CBC4B0 b1207
	NATIVE_DECL void _0xE31A04513237DC89(Entity entity) { invoke<Void>(0xE31A04513237DC89, entity); } // 0xE31A04513237DC89 b1207
	NATIVE_DECL void SET_NETWORK_ID_VISIBLE_IN_CUTSCENE(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xA6928482543022B4, p0, p1, p2, p3); } // 0xA6928482543022B4 0x199E75EF b1207
	NATIVE_DECL BOOL IS_NETWORK_ID_OWNED_BY_PARTICIPANT(int netId) { return invoke<BOOL>(0xA1607996431332DF, netId); } // 0xA1607996431332DF 0xEA5176C0 b1207
	NATIVE_DECL Player _NETWORK_GET_PLAYER_OWNER_OF_NETWORK_ID(int netId) { return invoke<Player>(0xA6C0787443C9583E, netId); } // 0xA6C0787443C9583E b1207
	NATIVE_DECL void SET_LOCAL_PLAYER_VISIBLE_IN_CUTSCENE(BOOL local, BOOL remote, int instanceId) { invoke<Void>(0xD1065D68947E7B6E, local, remote, instanceId); } // 0xD1065D68947E7B6E 0x59F3479B b1207
	NATIVE_DECL void PREVENT_MIGRATION_OF_ENTITIES_IN_FAST_INSTANCE_FOR_LOCAL_PLAYER(BOOL toggle) { invoke<Void>(0x89D803CD48622150, toggle); } // 0x89D803CD48622150 b1207
	NATIVE_DECL void SET_LOCAL_PLAYER_INVISIBLE_LOCALLY(BOOL p0) { invoke<Void>(0xE5F773C1A1D9D168, p0); } // 0xE5F773C1A1D9D168 0x764F6222 b1207
	NATIVE_DECL void SET_PLAYER_INVISIBLE_LOCALLY(Player player, BOOL toggle) { invoke<Void>(0x12B37D54667DB0B8, player, toggle); } // 0x12B37D54667DB0B8 0x18227209 b1207
	NATIVE_DECL void SET_PLAYER_VISIBLE_LOCALLY(Player player, BOOL toggle) { invoke<Void>(0xFAA10F1FAFB11AF2, player, toggle); } // 0xFAA10F1FAFB11AF2 0xBA2BB4B4 b1207
	NATIVE_DECL void SET_ENTITY_VISIBLE_IN_CUTSCENE(Entity entity, BOOL p1, BOOL p2, int p3) { invoke<Void>(0xE0031D3C8F36AB82, entity, p1, p2, p3); } // 0xE0031D3C8F36AB82 0xDBFB067B b1207
	NATIVE_DECL void _SET_DOOR_NETWORKED(Hash doorHash) { invoke<Void>(0x51D99497ABF3F451, doorHash); } // 0x51D99497ABF3F451 b1207
	NATIVE_DECL void _SET_DOOR_UNNETWORKED(Any p0, BOOL toggle) { invoke<Void>(0xC1E1A3D5ED7617B8, p0, toggle); } // 0xC1E1A3D5ED7617B8 b1207
	NATIVE_DECL BOOL IS_DAMAGE_TRACKER_ACTIVE_ON_NETWORK_ID(int netID) { return invoke<BOOL>(0x6E192E33AD436366, netID); } // 0x6E192E33AD436366 0x597063BA b1207
	NATIVE_DECL void ACTIVATE_DAMAGE_TRACKER_ON_NETWORK_ID(int netID, BOOL toggle) { invoke<Void>(0xD45B1FFCCD52FF19, netID, toggle); } // 0xD45B1FFCCD52FF19 0x95D07BA5 b1207
	NATIVE_DECL BOOL IS_SPHERE_VISIBLE_TO_ANOTHER_MACHINE(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<BOOL>(0xD82CF8E64C8729D8, p0, p1, p2, p3, p4); } // 0xD82CF8E64C8729D8 0x23C5274E b1207
	NATIVE_DECL BOOL IS_SPHERE_VISIBLE_TO_PLAYER(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<BOOL>(0xDC3A310219E5DA62, p0, p1, p2, p3, p4, p5); } // 0xDC3A310219E5DA62 0xE9FCFB32 b1207
	NATIVE_DECL void _0xD42C543F73233041(BOOL p0) { invoke<Void>(0xD42C543F73233041, p0); } // 0xD42C543F73233041 b1232
	NATIVE_DECL void RESERVE_NETWORK_MISSION_OBJECTS(int amount) { invoke<Void>(0x4E5C93BD0C32FBF8, amount); } // 0x4E5C93BD0C32FBF8 0x391DF4F3 b1207
	NATIVE_DECL void RESERVE_NETWORK_CLIENT_MISSION_OBJECTS(int amount) { invoke<Void>(0xE7DDA8BD3BCF751C, amount); } // 0xE7DDA8BD3BCF751C b1207
	NATIVE_DECL void RESERVE_NETWORK_MISSION_PEDS(int amount) { invoke<Void>(0xB60FEBA45333D36F, amount); } // 0xB60FEBA45333D36F 0x54998C37 b1207
	NATIVE_DECL void RESERVE_NETWORK_CLIENT_MISSION_PEDS(int amount) { invoke<Void>(0x807E119F80231732, amount); } // 0x807E119F80231732 b1207
	NATIVE_DECL void RESERVE_NETWORK_MISSION_VEHICLES(int amount) { invoke<Void>(0x76B02E21ED27A469, amount); } // 0x76B02E21ED27A469 0x5062875E b1207
	NATIVE_DECL void RESERVE_NETWORK_MISSION_PICKUPS(int amount) { invoke<Void>(0x4D40E7D749BC6E6D, amount); } // 0x4D40E7D749BC6E6D b1207
	NATIVE_DECL BOOL CAN_REGISTER_MISSION_OBJECTS(int amount) { return invoke<BOOL>(0x800DD4721A8B008B, amount); } // 0x800DD4721A8B008B 0x7F85DFDE b1207
	NATIVE_DECL BOOL CAN_REGISTER_MISSION_PEDS(int amount) { return invoke<BOOL>(0xBCBF4FEF9FA5D781, amount); } // 0xBCBF4FEF9FA5D781 0xCCAA5CE9 b1207
	NATIVE_DECL BOOL CAN_REGISTER_MISSION_VEHICLES(int amount) { return invoke<BOOL>(0x7277F1F2E085EE74, amount); } // 0x7277F1F2E085EE74 0x818B6830 b1207
	NATIVE_DECL BOOL CAN_REGISTER_MISSION_PICKUPS(int amount) { return invoke<BOOL>(0xF0460C7BF80011EA, amount); } // 0xF0460C7BF80011EA b1207
	NATIVE_DECL BOOL CAN_REGISTER_MISSION_ENTITIES(int ped_amt, int vehicle_amt, int object_amt, int pickup_amt) { return invoke<BOOL>(0x69778E7564BADE6D, ped_amt, vehicle_amt, object_amt, pickup_amt); } // 0x69778E7564BADE6D 0x83794008 b1207
	// p0 appears to be for MP
	NATIVE_DECL int GET_NUM_RESERVED_MISSION_OBJECTS(BOOL p0) { return invoke<int>(0xAA81B5F10BC43AC2, p0); } // 0xAA81B5F10BC43AC2 0x16A80CD6 b1207
	// p0 appears to be for MP
	NATIVE_DECL int GET_NUM_RESERVED_MISSION_PEDS(BOOL p0) { return invoke<int>(0x1F13D5AE5CB17E17, p0); } // 0x1F13D5AE5CB17E17 0x6C25975C b1207
	// p0 appears to be for MP
	NATIVE_DECL int GET_NUM_RESERVED_MISSION_VEHICLES(BOOL p0) { return invoke<int>(0xCF3A965906452031, p0); } // 0xCF3A965906452031 0xA9A308F3 b1207
	NATIVE_DECL int _GET_NUM_RESERVED_MISSION_PICKUPS(BOOL p0) { return invoke<int>(0x62BE3ECC79FBD004, p0); } // 0x62BE3ECC79FBD004 b1207
	NATIVE_DECL int GET_NUM_CREATED_MISSION_OBJECTS(BOOL p0) { return invoke<int>(0x12B6281B6C6706C0, p0); } // 0x12B6281B6C6706C0 0x603FA104 b1207
	NATIVE_DECL int GET_NUM_CREATED_MISSION_PEDS(BOOL p0) { return invoke<int>(0xCB215C4B56A7FAE7, p0); } // 0xCB215C4B56A7FAE7 0xD8FEC4F8 b1207
	NATIVE_DECL int GET_NUM_CREATED_MISSION_VEHICLES(BOOL p0) { return invoke<int>(0x0CD9AB83489430EA, p0); } // 0x0CD9AB83489430EA 0x20527695 b1207
	NATIVE_DECL int _GET_NUM_CREATED_MISSION_PICKUPS(BOOL p0) { return invoke<int>(0xD2BA051B94CA9BCC, p0); } // 0xD2BA051B94CA9BCC b1207
	// Used in Script Function NET_ACE_CLIENT_VERIFY_ENTITY_RESERVATIONS
	// Coords: Slot world position
	NATIVE_DECL void _GET_RESERVATIONS_FOR_SLOT_WORLD_POSITION(float x, float y, float z, BOOL p3, int* peds, int* vehicles, int* objects, int* pickups) { invoke<Void>(0x5E71E72A94985214, x, y, z, p3, peds, vehicles, objects, pickups); } // 0x5E71E72A94985214 b1207
	NATIVE_DECL void _GET_RESERVATIONS_FOR_SLOT_WORLD_POSITION(Vector3 vec, BOOL p3, int* peds, int* vehicles, int* objects, int* pickups) { invoke<Void>(0x5E71E72A94985214, vec.x, vec.y, vec.z, p3, peds, vehicles, objects, pickups); } // 0x5E71E72A94985214 b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL BOOL _0x5F328FC909F0E0FF(int p0, int p1, int p2, int p3) { return invoke<BOOL>(0x5F328FC909F0E0FF, p0, p1, p2, p3); } // 0x5F328FC909F0E0FF b1311
	// Always returns 60
	NATIVE_DECL int GET_MAX_NUM_NETWORK_OBJECTS() { return invoke<int>(0xC7BE335216B5EC7C); } // 0xC7BE335216B5EC7C 0x8687E285 b1207
	// Always returns 110
	NATIVE_DECL int GET_MAX_NUM_NETWORK_PEDS() { return invoke<int>(0x0C1F7D49C39D2289); } // 0x0C1F7D49C39D2289 0x744AC008 b1207
	// Always returns 40
	NATIVE_DECL int GET_MAX_NUM_NETWORK_VEHICLES() { return invoke<int>(0x0AFCE529F69B21FF); } // 0x0AFCE529F69B21FF 0xC3A12135 b1207
	// Always returns 80
	NATIVE_DECL int GET_MAX_NUM_NETWORK_PICKUPS() { return invoke<int>(0xA72835064DD63E4C); } // 0xA72835064DD63E4C 0x6A036061 b1207
	NATIVE_DECL BOOL _0x75FC34A2BA345BD1(Entity entity, Player player, Any* p2) { return invoke<BOOL>(0x75FC34A2BA345BD1, entity, player, p2); } // 0x75FC34A2BA345BD1 b1207
	// Must be called from a background script, otherwise it will do nothing.
	NATIVE_DECL void _0x979765465A6F25FC(Entity entity, BOOL p1) { invoke<Void>(0x979765465A6F25FC, entity, p1); } // 0x979765465A6F25FC b1207
	// Hardcoded to return zero.
	NATIVE_DECL int _0x5133CF81924F1129() { return invoke<int>(0x5133CF81924F1129); } // 0x5133CF81924F1129 b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x1E4E097D71D449FB(BOOL p0) { return invoke<int>(0x1E4E097D71D449FB, p0); } // 0x1E4E097D71D449FB b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x982D7AD755B8F62C(BOOL p0) { return invoke<int>(0x982D7AD755B8F62C, p0); } // 0x982D7AD755B8F62C b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x917AD74BDCF8B6E9(BOOL p0) { return invoke<int>(0x917AD74BDCF8B6E9, p0); } // 0x917AD74BDCF8B6E9 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0xF8DC69DC1AD19072(BOOL p0) { return invoke<int>(0xF8DC69DC1AD19072, p0); } // 0xF8DC69DC1AD19072 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x744BFBB0CA908161(BOOL p0) { return invoke<int>(0x744BFBB0CA908161, p0); } // 0x744BFBB0CA908161 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x106CBDD5077DEDE1(BOOL p0) { return invoke<int>(0x106CBDD5077DEDE1, p0); } // 0x106CBDD5077DEDE1 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0xBAF7E2979442B29F(BOOL p0) { return invoke<int>(0xBAF7E2979442B29F, p0); } // 0xBAF7E2979442B29F b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x039B692B3318FAB6(BOOL p0) { return invoke<int>(0x039B692B3318FAB6, p0); } // 0x039B692B3318FAB6 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x4835413EA6F9C9CD(BOOL p0) { return invoke<int>(0x4835413EA6F9C9CD, p0); } // 0x4835413EA6F9C9CD b1311
	NATIVE_DECL int GET_NETWORK_TIME() { return invoke<int>(0x7A5487FE9FAA6B48); } // 0x7A5487FE9FAA6B48 0x998103C2 b1207
	NATIVE_DECL int GET_NETWORK_TIME_ACCURATE() { return invoke<int>(0x89023FBBF9200E9F); } // 0x89023FBBF9200E9F 0x98AA48E5 b1207
	NATIVE_DECL BOOL HAS_NETWORK_TIME_STARTED() { return invoke<BOOL>(0x46718ACEEDEAFC84); } // 0x46718ACEEDEAFC84 0x4538C4A2 b1207
	// Adds the first argument to the second.
	NATIVE_DECL int GET_TIME_OFFSET(int timeA, int timeB) { return invoke<int>(0x017008CCDAD48503, timeA, timeB); } // 0x017008CCDAD48503 0x2E079AE6 b1207
	// Subtracts the second argument from the first, then returns whether the result is negative.
	NATIVE_DECL BOOL IS_TIME_LESS_THAN(int timeA, int timeB) { return invoke<BOOL>(0xCB2CF5148012C8D0, timeA, timeB); } // 0xCB2CF5148012C8D0 0x50EF8FC6 b1207
	// Subtracts the first argument from the second, then returns whether the result is negative.
	NATIVE_DECL BOOL IS_TIME_MORE_THAN(int timeA, int timeB) { return invoke<BOOL>(0xDE350F8651E4346C, timeA, timeB); } // 0xDE350F8651E4346C 0xBBB6DF61 b1207
	// Subtracts the second argument from the first.
	NATIVE_DECL int GET_TIME_DIFFERENCE(int timeA, int timeB) { return invoke<int>(0xA2C6FC031D46FFF0, timeA, timeB); } // 0xA2C6FC031D46FFF0 0x5666A837 b1207
	NATIVE_DECL int GET_CLOUD_TIME_AS_INT() { return invoke<int>(0x9A73240B49945C76); } // 0x9A73240B49945C76 0xF2FDF2E0 b1207
	// Takes the specified time and writes it to the structure specified in the second argument.
	// 
	// struct date_time
	// {
	//     int year;
	//     int PADDING1;
	//     int month;
	//     int PADDING2;
	//     int day;
	//     int PADDING3;
	//     int hour;
	//     int PADDING4;
	//     int minute;
	//     int PADDING5;
	//     int second;
	//     int PADDING6;
	// };
	NATIVE_DECL void CONVERT_POSIX_TIME(int posixTime, Any* timeStructure) { invoke<Void>(0xAC97AF97FA68E5D5, posixTime, timeStructure); } // 0xAC97AF97FA68E5D5 0xBB7CCE49 b1207
	NATIVE_DECL void NETWORK_SET_IN_SPECTATOR_MODE(BOOL toggle, Ped playerPed) { invoke<Void>(0x423DE3854BB50894, toggle, playerPed); } // 0x423DE3854BB50894 0x5C4C8458 b1207
	NATIVE_DECL void _NETWORK_SET_IN_STATIC_SPECTATOR_MODE(BOOL toggle, float x, float y, float z) { invoke<Void>(0xFBF1ECFB39A77B5F, toggle, x, y, z); } // 0xFBF1ECFB39A77B5F b1207
	NATIVE_DECL void _NETWORK_SET_IN_STATIC_SPECTATOR_MODE(BOOL toggle, Vector3 vec) { invoke<Void>(0xFBF1ECFB39A77B5F, toggle, vec.x, vec.y, vec.z); } // 0xFBF1ECFB39A77B5F b1207
	NATIVE_DECL BOOL NETWORK_IS_IN_SPECTATOR_MODE() { return invoke<BOOL>(0x048746E388762E11); } // 0x048746E388762E11 0x3EAD9DB8 b1207
	NATIVE_DECL BOOL _NETWORK_IS_PLAYER_IN_SPECTATOR_MODE(Player player) { return invoke<BOOL>(0x5B709519997ECF0F, player); } // 0x5B709519997ECF0F b1207
	NATIVE_DECL void NETWORK_SET_IN_MP_CUTSCENE(BOOL p0, BOOL p1, int p2, BOOL p3) { invoke<Void>(0x9CA5DE655269FEC4, p0, p1, p2, p3); } // 0x9CA5DE655269FEC4 0x8434CB43 b1207
	NATIVE_DECL BOOL NETWORK_IS_IN_MP_CUTSCENE() { return invoke<BOOL>(0x6CC27C9FA2040220); } // 0x6CC27C9FA2040220 0x4BB33316 b1207
	// Note: scripts seem to indicate that this was renamed to NETWORK_IS_PLAYER_IN_MP_FAST_INSTANCE
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_IN_MP_CUTSCENE(Player player) { return invoke<BOOL>(0x63F9EE203C3619F2, player); } // 0x63F9EE203C3619F2 0x56F961E4 b1207
	// _NETWORK_A* - _NETWORK_C*
	NATIVE_DECL void _0x34BC1E79546BA543(BOOL p0) { invoke<Void>(0x34BC1E79546BA543, p0); } // 0x34BC1E79546BA543 b1232
	NATIVE_DECL void _SET_NETWORK_RESPOT_TIMER(Entity entity, int timer, BOOL p2) { invoke<Void>(0x442B4347B6EC36E8, entity, timer, p2); } // 0x442B4347B6EC36E8 b1207
	// _GET_LAUNCH_PARAM_(RESPOT?)*
	// Name is probably invalid since this native only reads data from parsed entity.
	NATIVE_DECL BOOL _0x26A867C0B7A456D1(Entity entity) { return invoke<BOOL>(0x26A867C0B7A456D1, entity); } // 0x26A867C0B7A456D1 b1232
	NATIVE_DECL void _SET_LOCAL_PLAYER_AS_GHOST(BOOL toggle) { invoke<Void>(0x5FFE9B4144F9712F, toggle); } // 0x5FFE9B4144F9712F b1207
	NATIVE_DECL BOOL _IS_ENTITY_GHOSTED_TO_LOCAL_PLAYER(Entity entity) { return invoke<BOOL>(0x21D04D7BC538C146, entity); } // 0x21D04D7BC538C146 b1207
	NATIVE_DECL void _0xDCA6ABDB9288FBE4(Player player, BOOL disabled) { invoke<Void>(0xDCA6ABDB9288FBE4, player, disabled); } // 0xDCA6ABDB9288FBE4 b1207
	NATIVE_DECL void _SET_ENTITY_GHOSTED_TO_LOCAL_PLAYER(Entity entity, BOOL toggle) { invoke<Void>(0xEE5AE9956743BA20, entity, toggle); } // 0xEE5AE9956743BA20 b1207
	// Note: this native was added in build 1311.16
	NATIVE_DECL BOOL _IS_OBJECT_REASSIGNMENT_IN_PROGRESS() { return invoke<BOOL>(0x8FE9EB11EC9CC23A); } // 0x8FE9EB11EC9CC23A b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0x039AD6B57D5179FF() { return invoke<int>(0x039AD6B57D5179FF); } // 0x039AD6B57D5179FF b1311
	// Note: this native was added in build 1311.16
	// 
	// GET_NUM_*
	NATIVE_DECL int _0x02B3CDD652B3CDD6() { return invoke<int>(0x02B3CDD652B3CDD6); } // 0x02B3CDD652B3CDD6 b1311
	// Note: this native was added in build 1311.16
	NATIVE_DECL int _GET_NUM_PEER_NEGOTIATION_RESPONSES() { return invoke<int>(0x4FE932E84FE932E8); } // 0x4FE932E84FE932E8 b1311
	// Must be called from a background script, otherwise it will do nothing.
	NATIVE_DECL void _NETWORK_DEBUG_REQUEST_ENTITY_POSITION(Any* p0) { invoke<Void>(0xFA38B52F91B59075, p0); } // 0xFA38B52F91B59075 b1207
	NATIVE_DECL int _NETWORK_GET_NETWORK_ID_FROM_ROPE(int ropeId) { return invoke<int>(0x42871327315EDAE8, ropeId); } // 0x42871327315EDAE8 b1207
	NATIVE_DECL int _NETWORK_GET_ROPE_FROM_NETWORK_ID(int netId) { return invoke<int>(0xEB1A4DD8352EC828, netId); } // 0xEB1A4DD8352EC828 b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_ADD_SPAWN_POINT(float x, float y, float z, float heading) { invoke<Void>(0xFD1AC0B3858F224C, x, y, z, heading); } // 0xFD1AC0B3858F224C b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_ADD_SPAWN_POINT(Vector3 vec, float heading) { invoke<Void>(0xFD1AC0B3858F224C, vec.x, vec.y, vec.z, heading); } // 0xFD1AC0B3858F224C b1207
	NATIVE_DECL void _0xA63E4F050F20021F() { invoke<Void>(0xA63E4F050F20021F); } // 0xA63E4F050F20021F b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_ADD_EXCLUSION_VOLUME(Volume volume) { invoke<Void>(0xEEB7818B1D307212, volume); } // 0xEEB7818B1D307212 b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_REMOVE_EXCLUSION_VOLUME(Volume volume) { invoke<Void>(0xA35E7BF20FA269E0, volume); } // 0xA35E7BF20FA269E0 b1207
	NATIVE_DECL void _0x0BF90CBB6B72977B() { invoke<Void>(0x0BF90CBB6B72977B); } // 0x0BF90CBB6B72977B b1207
	NATIVE_DECL void _0x7B3FF2D193628126(Player player) { invoke<Void>(0x7B3FF2D193628126, player); } // 0x7B3FF2D193628126 b1207
	NATIVE_DECL void _0x19B52C20B5C4757C() { invoke<Void>(0x19B52C20B5C4757C); } // 0x19B52C20B5C4757C b1207
	NATIVE_DECL void NETWORK_SPAWN_CONFIG_SET_FLAGS(int flags) { invoke<Void>(0xF94A0D5B254375DF, flags); } // 0xF94A0D5B254375DF b1207
	NATIVE_DECL void _0x6CEE2E30021DAEC6() { invoke<Void>(0x6CEE2E30021DAEC6); } // 0x6CEE2E30021DAEC6 b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_ADD_PROPERTY_SCRIPTED(int configProperty, BOOL include) { invoke<Void>(0x44D59EC597BBF348, configProperty, include); } // 0x44D59EC597BBF348 b1207
	NATIVE_DECL void _0xB131E686BD97B3F8() { invoke<Void>(0xB131E686BD97B3F8); } // 0xB131E686BD97B3F8 b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_ADD_PROPERTY_PREFERENCE(int configProperty, BOOL include, float weight) { invoke<Void>(0xEB6027FD1B4600D5, configProperty, include, weight); } // 0xEB6027FD1B4600D5 b1207
	NATIVE_DECL void _0x405DDEFB1F531B18(Volume volume, BOOL p1, Any p2, Any p3) { invoke<Void>(0x405DDEFB1F531B18, volume, p1, p2, p3); } // 0x405DDEFB1F531B18 b1207
	NATIVE_DECL void _0x43CF999205084B4B() { invoke<Void>(0x43CF999205084B4B); } // 0x43CF999205084B4B b1207
	NATIVE_DECL void _0x13F592FC3BF0EA84(Volume volume, BOOL p1, float originalWeight, Any p3, Any p4) { invoke<Void>(0x13F592FC3BF0EA84, volume, p1, originalWeight, p3, p4); } // 0x13F592FC3BF0EA84 b1207
	NATIVE_DECL void _0xCF23AB5BD47B384D(Any p0) { invoke<Void>(0xCF23AB5BD47B384D, p0); } // 0xCF23AB5BD47B384D b1207
	NATIVE_DECL void _0xE5634491A58C2703(float p0) { invoke<Void>(0xE5634491A58C2703, p0); } // 0xE5634491A58C2703 b1207
	NATIVE_DECL void NETWORK_SPAWN_CONFIG_SET_GROUND_TO_ROOT_OFFSET(float offset) { invoke<Void>(0x59577799F6AE2F34, offset); } // 0x59577799F6AE2F34 b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_SET_LEVEL_WATER_DEPTH(int waterDepthLevel) { invoke<Void>(0xBDCC671B911040F9, waterDepthLevel); } // 0xBDCC671B911040F9 b1207
	NATIVE_DECL void NETWORK_SPAWN_CONFIG_SET_TUNING_FLOAT(Hash p0, float p1) { invoke<Void>(0x0608326F7B98C08D, p0, p1); } // 0x0608326F7B98C08D b1207
	NATIVE_DECL void _0x5D3C528B7A7DF836(Hash p0) { invoke<Void>(0x5D3C528B7A7DF836, p0); } // 0x5D3C528B7A7DF836 b1207
	NATIVE_DECL void _0x2686BD9566B65EDA(float x, float y, float z) { invoke<Void>(0x2686BD9566B65EDA, x, y, z); } // 0x2686BD9566B65EDA b1207
	NATIVE_DECL void _0x2686BD9566B65EDA(Vector3 vec) { invoke<Void>(0x2686BD9566B65EDA, vec.x, vec.y, vec.z); } // 0x2686BD9566B65EDA b1207
	NATIVE_DECL void _0xBB1EC8C2EEF33BAA(Entity entity) { invoke<Void>(0xBB1EC8C2EEF33BAA, entity); } // 0xBB1EC8C2EEF33BAA b1207
	NATIVE_DECL BOOL _0x67CCDF74C4DF7169() { return invoke<BOOL>(0x67CCDF74C4DF7169); } // 0x67CCDF74C4DF7169 b1207
	NATIVE_DECL void _0xC8B6D18E22484643() { invoke<Void>(0xC8B6D18E22484643); } // 0xC8B6D18E22484643 b1207
	NATIVE_DECL void _0x97BCE4C4B3191228() { invoke<Void>(0x97BCE4C4B3191228); } // 0x97BCE4C4B3191228 b1207
	NATIVE_DECL int _0x41452E8A3B9C0C4B() { return invoke<int>(0x41452E8A3B9C0C4B); } // 0x41452E8A3B9C0C4B b1207
	NATIVE_DECL BOOL _NETWORK_SPAWN_CONFIG_SEARCH_IN_PROGRESS() { return invoke<BOOL>(0x89EC2FC89ECB1005); } // 0x89EC2FC89ECB1005 b1207
	NATIVE_DECL void _0x61BFBAA795E712AD() { invoke<Void>(0x61BFBAA795E712AD); } // 0x61BFBAA795E712AD b1207
	NATIVE_DECL void _NETWORK_SPAWN_CONFIG_SET_CANCEL_SEARCH() { invoke<Void>(0x765E60A1DCB8B1CE); } // 0x765E60A1DCB8B1CE b1207
	NATIVE_DECL void _0x691E4DE5309EAEFC(Any p0, Any* p1) { invoke<Void>(0x691E4DE5309EAEFC, p0, p1); } // 0x691E4DE5309EAEFC b1207
	NATIVE_DECL void NETWORK_START_SOLO_TUTORIAL_SESSION() { invoke<Void>(0x17E0198B3882C2CB); } // 0x17E0198B3882C2CB 0x408A9436 b1207
	NATIVE_DECL void NETWORK_END_TUTORIAL_SESSION() { invoke<Void>(0xD0AFAFF5A51D72F7); } // 0xD0AFAFF5A51D72F7 0xBA57E53E b1207
	NATIVE_DECL BOOL NETWORK_IS_IN_TUTORIAL_SESSION() { return invoke<BOOL>(0xADA24309FE08DACF); } // 0xADA24309FE08DACF 0x34DD7B28 b1207
	NATIVE_DECL BOOL NETWORK_IS_TUTORIAL_SESSION_CHANGE_PENDING() { return invoke<BOOL>(0x35F0B98A8387274D); } // 0x35F0B98A8387274D 0xA003C40B b1207
	// NETWORK_ARE_*
	NATIVE_DECL BOOL _NETWORK_IS_PLAYER_EQUAL_TO_INDEX(Player player, int index) { return invoke<BOOL>(0x9DE986FC9A87C474, player, index); } // 0x9DE986FC9A87C474 0xE66A0B40 b1207
	NATIVE_DECL void NETWORK_ALLOW_ALL_ENTITY_FADING_FOR_INSTANCES(BOOL toggle) { invoke<Void>(0x4B05B97BA46F419D, toggle); } // 0x4B05B97BA46F419D b1207
	NATIVE_DECL void NETWORK_ALLOW_ENTITY_FADING_FOR_INSTANCES(Entity entity, BOOL toggle) { invoke<Void>(0xF3354D6CA46F419D, entity, toggle); } // 0xF3354D6CA46F419D b1207
	NATIVE_DECL void _0xDC6AD5C046F33AB4(BOOL p0, BOOL p1) { invoke<Void>(0xDC6AD5C046F33AB4, p0, p1); } // 0xDC6AD5C046F33AB4 b1207
	NATIVE_DECL void _0x6C7E04E9DE451789() { invoke<Void>(0x6C7E04E9DE451789); } // 0x6C7E04E9DE451789 b1207
	NATIVE_DECL void NETWORK_SET_LOCAL_PLAYER_PENDING_FAST_INSTANCE_ID(int instanceId) { invoke<Void>(0x007FF852DCF49DA4, instanceId); } // 0x007FF852DCF49DA4 b1207
	NATIVE_DECL int _NETWORK_GET_PLAYER_FAST_INSTANCE_ID(Player player) { return invoke<int>(0xD9267375834C5EAB, player); } // 0xD9267375834C5EAB b1207
	NATIVE_DECL void NETWORK_CONCEAL_PLAYER(Player player, BOOL toggle) { invoke<Void>(0xBBDF066252829606, player, toggle); } // 0xBBDF066252829606 0x72052DB3 b1207
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_CONCEALED(Player player) { return invoke<BOOL>(0x919B3C98ED8292F9, player); } // 0x919B3C98ED8292F9 0xB0313590 b1207
	// Note: this native was added in build 1355.30
	NATIVE_DECL void _0x40FEDB13870042F1() { invoke<Void>(0x40FEDB13870042F1); } // 0x40FEDB13870042F1 b1355
	// Note: this native was added in build 1355.30
	NATIVE_DECL void _0x422F9D6D6C7BC290(int p0) { invoke<Void>(0x422F9D6D6C7BC290, p0); } // 0x422F9D6D6C7BC290 b1355
	// Note: this native was added in build 1311.23, but was only used after build 1436.25
	NATIVE_DECL void NETWORK_REQUEST_CLOUD_TUNABLES() { invoke<Void>(0x42FB3B532D526E6C); } // 0x42FB3B532D526E6C 0xD760CAD5 b1311
	NATIVE_DECL BOOL NETWORK_IS_TUNABLE_CLOUD_REQUEST_PENDING() { return invoke<BOOL>(0x0467C11ED88B7D28); } // 0x0467C11ED88B7D28 0x47978D7F b1207
	NATIVE_DECL int NETWORK_GET_TUNABLE_CLOUD_CRC() { return invoke<int>(0x10BD227A753B0D84); } // 0x10BD227A753B0D84 0x231CFD12 b1436
	NATIVE_DECL BOOL NETWORK_DOES_TUNABLE_EXIST(Hash tunableContext, Hash tunableName) { return invoke<BOOL>(0x85E5F8B9B898B20A, tunableContext, tunableName); } // 0x85E5F8B9B898B20A 0x9FCE9C9A b1207
	NATIVE_DECL BOOL NETWORK_ACCESS_TUNABLE_INT(Hash tunableContext, Hash tunableName, int* value) { return invoke<BOOL>(0x8BE1146DFD5D4468, tunableContext, tunableName, value); } // 0x8BE1146DFD5D4468 0xE4B3726A b1207
	NATIVE_DECL BOOL NETWORK_ACCESS_TUNABLE_BOOL(Hash tunableContext, Hash tunableName) { return invoke<BOOL>(0xAA6A47A573ABB75A, tunableContext, tunableName); } // 0xAA6A47A573ABB75A 0x8A04E1FE b1207
	NATIVE_DECL int _NETWORK_TRY_ACCESS_TUNABLE_INT(Hash tunableContext, Hash tunableName, int defaultValue) { return invoke<int>(0xA25E006B36719774, tunableContext, tunableName, defaultValue); } // 0xA25E006B36719774 b1207
	NATIVE_DECL float _NETWORK_TRY_ACCESS_TUNABLE_FLOAT(Hash tunableContext, Hash tunableName, float defaultValue) { return invoke<float>(0xA18393089C05E49C, tunableContext, tunableName, defaultValue); } // 0xA18393089C05E49C b1207
	NATIVE_DECL BOOL _NETWORK_TRY_ACCESS_TUNABLE_BOOL(Hash tunableContext, Hash tunableName, BOOL defaultValue) { return invoke<BOOL>(0xB2AD5D29A99D4B26, tunableContext, tunableName, defaultValue); } // 0xB2AD5D29A99D4B26 b1207
	NATIVE_DECL void _0x894B5ECAB45D2342(int netHandle, Any p1) { invoke<Void>(0x894B5ECAB45D2342, netHandle, p1); } // 0x894B5ECAB45D2342 b1207
	NATIVE_DECL void NETWORK_DISABLE_PROXIMITY_MIGRATION(int netID) { invoke<Void>(0x407091CF6037118E, netID); } // 0x407091CF6037118E 0x9F82917F b1207
	NATIVE_DECL Any _0xCE5E79D9E303628E() { return invoke<Any>(0xCE5E79D9E303628E); } // 0xCE5E79D9E303628E b1355
	NATIVE_DECL BOOL _0xDBC754CB6CCB9378() { return invoke<BOOL>(0xDBC754CB6CCB9378); } // 0xDBC754CB6CCB9378 b1232
	NATIVE_DECL BOOL CLOUD_HAS_REQUEST_COMPLETED(int id) { return invoke<BOOL>(0x4C61B39930D045DA, id); } // 0x4C61B39930D045DA 0xBAF52DD8 b1207
	NATIVE_DECL BOOL CLOUD_DID_REQUEST_SUCCEED(int id) { return invoke<BOOL>(0x3A3D5568AF297CD5, id); } // 0x3A3D5568AF297CD5 0x9B9AFFF1 b1207
	NATIVE_DECL BOOL _GET_LAUNCH_PARAM_EXISTS(const char* paramName) { return invoke<BOOL>(0x02E97CE283648CD9, paramName); } // 0x02E97CE283648CD9 b1207
	NATIVE_DECL const char* _GET_LAUNCH_PARAM_VALUE(const char* paramName) { return invoke<const char*>(0x65E65CA6A0FE59D4, paramName); } // 0x65E65CA6A0FE59D4 b1207
	NATIVE_DECL void _SET_LAUNCH_PARAM_VALUE(const char* paramName, const char* value) { invoke<Void>(0x668AF6E4933AC13F, paramName, value); } // 0x668AF6E4933AC13F b1207
	NATIVE_DECL void _CLEAR_LAUNCH_PARAM(const char* paramName) { invoke<Void>(0x782C94DB6469634D, paramName); } // 0x782C94DB6469634D b1207
	NATIVE_DECL const char* _GET_LAUNCH_PARAM_STRING() { return invoke<const char*>(0xC59AB6A04333C502); } // 0xC59AB6A04333C502 b1207
	NATIVE_DECL void _SET_LAUNCH_PARAM_STRING(const char* params) { invoke<Void>(0xDFFC15AA63D04AAB, params); } // 0xDFFC15AA63D04AAB b1207
	NATIVE_DECL void _CLEAR_LAUNCH_PARAMS() { invoke<Void>(0x966DD84FB6A46017); } // 0x966DD84FB6A46017 b1207
	NATIVE_DECL BOOL UGC_IS_REQUEST_PENDING(int ugcRequestId) { return invoke<BOOL>(0xF4AC4FA844FD559A, ugcRequestId); } // 0xF4AC4FA844FD559A b1207
	NATIVE_DECL BOOL UGC_HAS_REQUEST_FINISHED(int ugcRequestId) { return invoke<BOOL>(0xA9EB4D606076615D, ugcRequestId); } // 0xA9EB4D606076615D b1207
	NATIVE_DECL BOOL UGC_DID_REQUEST_SUCCEED(int ugcRequestId) { return invoke<BOOL>(0x0B6009A90B8495F1, ugcRequestId); } // 0x0B6009A90B8495F1 b1207
	NATIVE_DECL Any _0xCD53E6CBF609C012(Any p0) { return invoke<Any>(0xCD53E6CBF609C012, p0); } // 0xCD53E6CBF609C012 b1207
	NATIVE_DECL Any _0xF40EF49B3099E98E(Any p0, int maxGet, const char* contentTypeName, Any p3, Any p4, Any p5) { return invoke<Any>(0xF40EF49B3099E98E, p0, maxGet, contentTypeName, p3, p4, p5); } // 0xF40EF49B3099E98E b1207
	NATIVE_DECL Any _0x8C109958C9BB559D(int categoryType, Any p1, int maxGet, const char* contentTypeName, int p4, Any p5) { return invoke<Any>(0x8C109958C9BB559D, categoryType, p1, maxGet, contentTypeName, p4, p5); } // 0x8C109958C9BB559D b1207
	NATIVE_DECL BOOL _UGC_QUERY_BY_CONTENT_ID(const char* contentId, BOOL latestVersion, const char* contentTypeName) { return invoke<BOOL>(0x69D22E183580113F, contentId, latestVersion, contentTypeName); } // 0x69D22E183580113F b1207
	NATIVE_DECL BOOL _UGC_IS_BOOK_MARKED(const char* contentId) { return invoke<BOOL>(0xE42D1042F09865FE, contentId); } // 0xE42D1042F09865FE b1355
	NATIVE_DECL void UGC_CLEAR_QUERY_RESULTS(int ugcRequestId) { invoke<Void>(0xE931354FEA710038, ugcRequestId); } // 0xE931354FEA710038 b1207
	NATIVE_DECL BOOL UGC_QUERY_WAS_FORCE_CANCELLED(int ugcRequestId) { return invoke<BOOL>(0xF8F0705E77A0E705, ugcRequestId); } // 0xF8F0705E77A0E705 b1207
	NATIVE_DECL int UGC_QUERY_GET_CONTENT_NUM(int ugcRequestId) { return invoke<int>(0x76160E0396142765, ugcRequestId); } // 0x76160E0396142765 b1207
	NATIVE_DECL Any _UGC_QUERY_GET_CREATOR_HANDLE(Any p0, int index, Any p2) { return invoke<Any>(0xADB56322EEDFBDC9, p0, index, p2); } // 0xADB56322EEDFBDC9 b1207
	NATIVE_DECL const char* _UGC_QUERY_GET_OWNER_ID(Any p0, int index) { return invoke<const char*>(0xF9F0B3028431967B, p0, index); } // 0xF9F0B3028431967B b1207
	NATIVE_DECL const char* _UGC_QUERY_GET_NAME(Any p0, int index) { return invoke<const char*>(0x2D053EA815702DD1, p0, index); } // 0x2D053EA815702DD1 b1207
	NATIVE_DECL const char* _UGC_QUERY_GET_ROOT_CONTENT_ID(Any p0, int index) { return invoke<const char*>(0x566CEB0542EF5ECF, p0, index); } // 0x566CEB0542EF5ECF b1207
	NATIVE_DECL const char* _UGC_QUERY_GET_PLAYLIST_NAME(Any p0, int index) { return invoke<const char*>(0xCAF50048C8D0FBA0, p0, index); } // 0xCAF50048C8D0FBA0 b1207
	NATIVE_DECL Hash _UGC_QUERY_GET_MISSION_DESC_HASH(Any p0, int index) { return invoke<Hash>(0xA6BF569956C60A60, p0, index); } // 0xA6BF569956C60A60 b1207
	NATIVE_DECL Any _UGC_QUERY_GET_CREATOR_PHOTO(Any p0, int p1, Any p2) { return invoke<Any>(0x409FE0CA6A4D1D49, p0, p1, p2); } // 0x409FE0CA6A4D1D49 b1207
	NATIVE_DECL void _UGC_QUERY_GET_DATE(Any p0, int index, Any* p2) { invoke<Void>(0xE0CB4AB15CB32710, p0, index, p2); } // 0xE0CB4AB15CB32710 b1207
	NATIVE_DECL int _UGC_QUERY_GET_POSIX_UPDATED_DATE(Any p0, Any p1) { return invoke<int>(0x21A99A72B00D8002, p0, p1); } // 0x21A99A72B00D8002 b1207
	NATIVE_DECL int _UGC_QUERY_GET_POSIX_PUBLISHED_DATE(Any p0, Any p1) { return invoke<int>(0x104080CA9E519B00, p0, p1); } // 0x104080CA9E519B00 b1207
	NATIVE_DECL int _UGC_QUERY_GET_VERSION(Any p0, int index, int p2) { return invoke<int>(0x63E9DCBC8B0931ED, p0, index, p2); } // 0x63E9DCBC8B0931ED b1207
	NATIVE_DECL int _UGC_QUERY_GET_LANGUAGE(Any p0, int index) { return invoke<int>(0x97764E8AC6487A9A, p0, index); } // 0x97764E8AC6487A9A b1207
	NATIVE_DECL BOOL _UGC_QUERY_GET_PUBLISHED(Any p0, Any p1) { return invoke<BOOL>(0x9993F1E11944A3DD, p0, p1); } // 0x9993F1E11944A3DD b1207
	NATIVE_DECL float _UGC_QUERY_GET_RATING(Any p0, int index, int p2) { return invoke<float>(0x24CD8FAEA1368379, p0, index, p2); } // 0x24CD8FAEA1368379 b1207
	NATIVE_DECL Any _0x5F0E99071582DECA(Any p0, int index, int p2) { return invoke<Any>(0x5F0E99071582DECA, p0, index, p2); } // 0x5F0E99071582DECA b1207
	NATIVE_DECL BOOL UGC_QUERY_GET_CONTENT_HAS_PLAYER_RECORD(Any p0, int index) { return invoke<BOOL>(0xF794765390A6DCA5, p0, index); } // 0xF794765390A6DCA5 b1207
	NATIVE_DECL BOOL _UGC_QUERY_GET_BOOK_MARKED(Any p0, int index) { return invoke<BOOL>(0x98539FC453AEA639, p0, index); } // 0x98539FC453AEA639 b1207
	// Checks if the user has ROS privilege 14.
	NATIVE_DECL BOOL _UGC_HAS_PRIVILEGE() { return invoke<BOOL>(0x6506BFA755FB209C); } // 0x6506BFA755FB209C b1207
	NATIVE_DECL int UGC_REQUEST_CONTENT_DATA_FROM_PARAMS(const char* contentTypeName, const char* contentId, int fileId, int fileVersion, int languageId) { return invoke<int>(0x7FD2990AF016795E, contentTypeName, contentId, fileId, fileVersion, languageId); } // 0x7FD2990AF016795E 0x38FC2EEB b1207
	NATIVE_DECL int UGC_REQUEST_CACHED_DESCRIPTION(Hash description) { return invoke<int>(0x5E0165278F6339EE, description); } // 0x5E0165278F6339EE 0x1C4F9FDB b1207
	NATIVE_DECL BOOL UGC_IS_DESCRIPTION_REQUEST_IN_PROGRESS(Hash description) { return invoke<BOOL>(0x2D5DC831176D0114, description); } // 0x2D5DC831176D0114 0xA69AE16C b1207
	NATIVE_DECL BOOL UGC_HAS_DESCRIPTION_REQUEST_FINISHED(Hash description) { return invoke<BOOL>(0xEBFA8D50ADDC54C4, description); } // 0xEBFA8D50ADDC54C4 0xF50BC67A b1207
	NATIVE_DECL BOOL UGC_DID_DESCRIPTION_REQUEST_SUCCEED(Hash description) { return invoke<BOOL>(0x162C23CA83ED0A62, description); } // 0x162C23CA83ED0A62 0xB3BBD241 b1207
	NATIVE_DECL const char* UGC_GET_CACHED_DESCRIPTION(Hash description, int length) { return invoke<const char*>(0x40F7E66472DF3E5C, description, length); } // 0x40F7E66472DF3E5C 0x70A2845C b1207
	NATIVE_DECL BOOL UGC_RELEASE_CACHED_DESCRIPTION(Hash description) { return invoke<BOOL>(0x5A34CD9C3C5BEC44, description); } // 0x5A34CD9C3C5BEC44 0x346B506C b1207
	NATIVE_DECL void UGC_RELEASE_ALL_CACHED_DESCRIPTIONS() { invoke<Void>(0x68103E2247887242); } // 0x68103E2247887242 0x0095DB71 b1207
	NATIVE_DECL void UGC_SET_QUERY_DATA_FROM_OFFLINE(BOOL p0) { invoke<Void>(0xF98DDE0A8ED09323, p0); } // 0xF98DDE0A8ED09323 0x213C6D36 b1207
	NATIVE_DECL BOOL UGC_IS_LANGUAGE_SUPPORTED(int languageId) { return invoke<BOOL>(0xF53E48461B71EECB, languageId); } // 0xF53E48461B71EECB 0xB4668B23 b1207
	NATIVE_DECL Any _0xD4022C7286B0DFA2(const char* p0, int p1, int p2) { return invoke<Any>(0xD4022C7286B0DFA2, p0, p1, p2); } // 0xD4022C7286B0DFA2 b1207
	// Returns false if pedshot push failed
	NATIVE_DECL BOOL _0xB72999D3120599DF(Any* p0, Any slot, Any p2) { return invoke<BOOL>(0xB72999D3120599DF, p0, slot, p2); } // 0xB72999D3120599DF b1207
	// Returns false if pedshot push failed
	NATIVE_DECL BOOL _0x2A48D9567940598F(Any* p0, Any cachingSlot, Any p2, Any type) { return invoke<BOOL>(0x2A48D9567940598F, p0, cachingSlot, p2, type); } // 0x2A48D9567940598F b1207
	// _NETWORK_IS_T* - _NETWORK_RE*
	NATIVE_DECL BOOL _0xA21E3BAD0A42D199() { return invoke<BOOL>(0xA21E3BAD0A42D199); } // 0xA21E3BAD0A42D199 b1207
	NATIVE_DECL Any _0xCC4E72C339461ED1() { return invoke<Any>(0xCC4E72C339461ED1); } // 0xCC4E72C339461ED1 b1207
	NATIVE_DECL Any _0x356F9FB0698C1FEB(Any p0, Any p1) { return invoke<Any>(0x356F9FB0698C1FEB, p0, p1); } // 0x356F9FB0698C1FEB b1207
	NATIVE_DECL Any _0xCAF4CA2F87779F8F(Any p0, Any p1) { return invoke<Any>(0xCAF4CA2F87779F8F, p0, p1); } // 0xCAF4CA2F87779F8F b1207
	NATIVE_DECL const char* _0xB5C4B18B12A2AF23(Any* gamerHandle, int p1) { return invoke<const char*>(0xB5C4B18B12A2AF23, gamerHandle, p1); } // 0xB5C4B18B12A2AF23 b1207
	NATIVE_DECL BOOL _0xE2C3CEC3C0903A00(const char* name) { return invoke<BOOL>(0xE2C3CEC3C0903A00, name); } // 0xE2C3CEC3C0903A00 b1207
	NATIVE_DECL int TEXTURE_DOWNLOAD_REQUEST(Any* gamerHandle, const char* filePath, const char* name, BOOL p3) { return invoke<int>(0x16160DA74A8E74A2, gamerHandle, filePath, name, p3); } // 0x16160DA74A8E74A2 0xAD546CC3 b1207
	NATIVE_DECL int _MUGSHOT_TEXTURE_DOWNLOAD_REQUEST(Any* gamerHandle, int p1, const char* name, BOOL p3) { return invoke<int>(0x9B5DB6CEAFAA10BB, gamerHandle, p1, name, p3); } // 0x9B5DB6CEAFAA10BB b1207
	NATIVE_DECL int UGC_TEXTURE_DOWNLOAD_REQUEST(Any* p0, Any p1, Any p2, Any p3, Any* p4, BOOL p5) { return invoke<int>(0x308F96458B7087CC, p0, p1, p2, p3, p4, p5); } // 0x308F96458B7087CC 0x68C9AF69 b1207
	NATIVE_DECL int _LOCAL_PLAYER_PEDSHOT_TEXTURE_DOWNLOAD_REQUEST(int player, int p1) { return invoke<int>(0x6E2FD8CF7EB10E53, player, p1); } // 0x6E2FD8CF7EB10E53 b1207
	NATIVE_DECL void TEXTURE_DOWNLOAD_RELEASE(int textureDownloadId) { invoke<Void>(0x487EB90B98E9FB19, textureDownloadId); } // 0x487EB90B98E9FB19 0xEE8D9E70 b1207
	NATIVE_DECL void _TEXTURE_DOWNLOAD_RELEASE_BY_NAME(const char* name) { invoke<Void>(0x7A17B7981560FFA5, name); } // 0x7A17B7981560FFA5 b1207
	NATIVE_DECL const char* TEXTURE_DOWNLOAD_GET_NAME(int textureDownloadId) { return invoke<const char*>(0x3448505B6E35262D, textureDownloadId); } // 0x3448505B6E35262D 0xA40EF65A b1207
	// 0 = succeeded
	// 1 = pending
	// 2 = failed
	NATIVE_DECL int GET_STATUS_OF_TEXTURE_DOWNLOAD(int textureDownloadId) { return invoke<int>(0x8BD6C6DEA20E82C6, textureDownloadId); } // 0x8BD6C6DEA20E82C6 0x03225BA3 b1207
	NATIVE_DECL int _0xCBAC13F065C47596() { return invoke<int>(0xCBAC13F065C47596); } // 0xCBAC13F065C47596 b1207
	NATIVE_DECL BOOL _0xCD954F330693F5F2() { return invoke<BOOL>(0xCD954F330693F5F2); } // 0xCD954F330693F5F2 b1207
	NATIVE_DECL Any _0xFBC30B70B3CDB87E() { return invoke<Any>(0xFBC30B70B3CDB87E); } // 0xFBC30B70B3CDB87E b1207
	NATIVE_DECL void _0x814729078AED6D30() { invoke<Void>(0x814729078AED6D30); } // 0x814729078AED6D30 b1207
	NATIVE_DECL BOOL NETWORK_HAVE_ROS_BANNED_PRIV() { return invoke<BOOL>(0x8020A73847E0CA7D); } // 0x8020A73847E0CA7D 0xD3BBE42F b1207
	NATIVE_DECL BOOL NETWORK_HAS_ROS_PRIVILEGE(int index) { return invoke<BOOL>(0xA699957E60D80214, index); } // 0xA699957E60D80214 0xFD261E30 b1207
	// Always returns -1. Seems to be XB1 specific.
	NATIVE_DECL int NETWORK_START_USER_CONTENT_PERMISSIONS_CHECK(Any* gamerHandle) { return invoke<int>(0xDEB2B99A1AF1A2A6, gamerHandle); } // 0xDEB2B99A1AF1A2A6 b1207
	NATIVE_DECL void _NETWORK_AUTO_SESSION_SET_ALLOWED_TO_SPLIT(BOOL toggle) { invoke<Void>(0x0A428058079EE65C, toggle); } // 0x0A428058079EE65C b1207
	NATIVE_DECL BOOL NETWORK_AUTO_SESSION_IS_ALLOWED_TO_MERGE() { return invoke<BOOL>(0xAADED99A6B268A27); } // 0xAADED99A6B268A27 b1207
	NATIVE_DECL void _NETWORK_AUTO_SESSION_SET_ALLOWED_TO_MERGE(BOOL toggle, Any* p1, int p2) { invoke<Void>(0x63246A24F5747510, toggle, p1, p2); } // 0x63246A24F5747510 b1207
	NATIVE_DECL BOOL _0xE258570E0C116A66() { return invoke<BOOL>(0xE258570E0C116A66); } // 0xE258570E0C116A66 b1207
	NATIVE_DECL void _0x4440FEE3EFE78F54(BOOL toggle) { invoke<Void>(0x4440FEE3EFE78F54, toggle); } // 0x4440FEE3EFE78F54 b1207
	NATIVE_DECL BOOL NETWORK_AUTO_SESSION_CAN_SPLIT_SESSION(int* p0) { return invoke<BOOL>(0xE404BFF0ABA23CDC, p0); } // 0xE404BFF0ABA23CDC b1207
	NATIVE_DECL BOOL NETWORK_AUTO_SESSION_SPLIT_SESSION(int playersToTake, int maxInstancePlayers, int sessionFlags, int bucketId) { return invoke<BOOL>(0xC223D299C670413D, playersToTake, maxInstancePlayers, sessionFlags, bucketId); } // 0xC223D299C670413D b1207
	NATIVE_DECL BOOL _0xA021095C983F20D8() { return invoke<BOOL>(0xA021095C983F20D8); } // 0xA021095C983F20D8 b1207
	NATIVE_DECL BOOL _0x6D87BA8EF15226CD() { return invoke<BOOL>(0x6D87BA8EF15226CD); } // 0x6D87BA8EF15226CD b1207
	NATIVE_DECL BOOL _0x277865A734918AE6() { return invoke<BOOL>(0x277865A734918AE6); } // 0x277865A734918AE6 b1207
	NATIVE_DECL void NETWORK_AUTO_SESSION_FINISH_INSTANCE() { invoke<Void>(0xBB51299166B844F3); } // 0xBB51299166B844F3 b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0xFD8112109A96877C() { invoke<Void>(0xFD8112109A96877C); } // 0xFD8112109A96877C b1311
	NATIVE_DECL void _0x5A91BCEF74944E93(Player player, float p1) { invoke<Void>(0x5A91BCEF74944E93, player, p1); } // 0x5A91BCEF74944E93 b1207
	// Note: this native was added in build 1311.23
	NATIVE_DECL int _0xFB3205788F8AFA3F() { return invoke<int>(0xFB3205788F8AFA3F); } // 0xFB3205788F8AFA3F b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0x335AF56613CA0F49(int p0) { invoke<Void>(0x335AF56613CA0F49, p0); } // 0x335AF56613CA0F49 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL BOOL _0x9E5A47744C0F0376(int p0) { return invoke<BOOL>(0x9E5A47744C0F0376, p0); } // 0x9E5A47744C0F0376 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0xD3B6EBC6C3D77D44(int p0) { invoke<Void>(0xD3B6EBC6C3D77D44, p0); } // 0xD3B6EBC6C3D77D44 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0xA7670F7991099680(int p0) { invoke<Void>(0xA7670F7991099680, p0); } // 0xA7670F7991099680 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0x7673C0D2C5CDAC55() { invoke<Void>(0x7673C0D2C5CDAC55); } // 0x7673C0D2C5CDAC55 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0x3CBD6565D9C3B133(int p0, int p1, float p2) { invoke<Void>(0x3CBD6565D9C3B133, p0, p1, p2); } // 0x3CBD6565D9C3B133 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0x0D183D8490EE4366(int p0, int p1) { invoke<Void>(0x0D183D8490EE4366, p0, p1); } // 0x0D183D8490EE4366 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0xC1968045EEB563B7(int p0) { invoke<Void>(0xC1968045EEB563B7, p0); } // 0xC1968045EEB563B7 b1311
	NATIVE_DECL BOOL NETWORK_AUTO_SESSION_IS_OBJECT_CREATION_PAUSED() { return invoke<BOOL>(0x0E2C3AEE6CE603B7); } // 0x0E2C3AEE6CE603B7 b1207
	NATIVE_DECL BOOL _0x0B6B4507AC5EA8B8() { return invoke<BOOL>(0x0B6B4507AC5EA8B8); } // 0x0B6B4507AC5EA8B8 b1207
	NATIVE_DECL BOOL NETWORK_IS_RESETTING_POPULATION() { return invoke<BOOL>(0x1BB50CD340A996E6); } // 0x1BB50CD340A996E6 b1207
	NATIVE_DECL BOOL NETWORK_RESET_POPULATION(BOOL p0, int p1) { return invoke<BOOL>(0x101F538C25ABB39A, p0, p1); } // 0x101F538C25ABB39A b1207
	NATIVE_DECL void NETWORK_DISABLE_LEAVE_REMOTE_PED_BEHIND(BOOL toggle) { invoke<Void>(0xC505036A35AFD01B, toggle); } // 0xC505036A35AFD01B 0xA100CC97 b1207
	NATIVE_DECL void _0x3034C77C79A58880(BOOL p0) { invoke<Void>(0x3034C77C79A58880, p0); } // 0x3034C77C79A58880 b1207
	NATIVE_DECL void _NETWORK_ALLOW_LOCAL_ENTITY_ATTACHMENT(Entity entity, BOOL toggle) { invoke<Void>(0x267C78C60E806B9A, entity, toggle); } // 0x267C78C60E806B9A 0xBB2D33D3 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x6BFF5F84102DF80A(Player player) { invoke<Void>(0x6BFF5F84102DF80A, player); } // 0x6BFF5F84102DF80A b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x5C497525F803486B() { invoke<Void>(0x5C497525F803486B); } // 0x5C497525F803486B b1207
	NATIVE_DECL BOOL _NETWORK_IS_CONNECTION_ENDPOINT_RELAY_SERVER(Player player) { return invoke<BOOL>(0x16D3D49902F697BB, player); } // 0x16D3D49902F697BB b1207
	NATIVE_DECL float _NETWORK_GET_AVERAGE_LATENCY_FOR_PLAYER(Player player) { return invoke<float>(0xD414BE129BB81B32, player); } // 0xD414BE129BB81B32 b1207
	// Same as _NETWORK_GET_AVERAGE_LATENCY_FOR_PLAYER (0xD414BE129BB81B32)
	NATIVE_DECL float _NETWORK_GET_AVERAGE_LATENCY_FOR_PLAYER_2(Player player) { return invoke<float>(0x0E3A041ED6AC2B45, player); } // 0x0E3A041ED6AC2B45 b1207
	NATIVE_DECL float _NETWORK_GET_AVERAGE_PACKET_LOSS_FOR_PLAYER(Player player) { return invoke<float>(0x350C23949E43686C, player); } // 0x350C23949E43686C b1207
	NATIVE_DECL int _NETWORK_GET_NUM_UNACKED_FOR_PLAYER(Player player) { return invoke<int>(0xFF8FCF9FFC458A1C, player); } // 0xFF8FCF9FFC458A1C b1207
	NATIVE_DECL int _NETWORK_GET_UNRELIABLE_RESEND_COUNT_FOR_PLAYER(Player player) { return invoke<int>(0x3765C3A3E8192E10, player); } // 0x3765C3A3E8192E10 b1207
	NATIVE_DECL int _NETWORK_GET_OLDEST_RESEND_COUNT_FOR_PLAYER(Player player) { return invoke<int>(0x52C1EADAF7B10302, player); } // 0x52C1EADAF7B10302 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0xAEDF1BC1C133D6E3() { return invoke<Any>(0xAEDF1BC1C133D6E3); } // 0xAEDF1BC1C133D6E3 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL Any _0x6FD992C4A1C1B986() { return invoke<Any>(0x6FD992C4A1C1B986); } // 0x6FD992C4A1C1B986 b1207
	// Returns true if the passed value is less than 32.
	NATIVE_DECL BOOL NETWORK_IS_PLAYER_INDEX_VALID(Player player) { return invoke<BOOL>(0x255A5EF65EDA9167, player); } // 0x255A5EF65EDA9167 b1207
	NATIVE_DECL BOOL _GET_PLAYER_WAYPOINT_IS_ACTIVE(Player player) { return invoke<BOOL>(0xDCC4B7F7112E8AB7, player); } // 0xDCC4B7F7112E8AB7 b1207
	NATIVE_DECL void _0x455156F47DC6B78C(BOOL p0) { invoke<Void>(0x455156F47DC6B78C, p0); } // 0x455156F47DC6B78C b1207
	NATIVE_DECL void _SET_LOCAL_PLAYER_DAMAGE_MULTIPLIER_FOR_PLAYER(Player player, float damageMultiplier) { invoke<Void>(0xD041A32992A55F84, player, damageMultiplier); } // 0xD041A32992A55F84 b1207
	NATIVE_DECL void _NETWORK_SET_VEHICLE_WHEELS_DESTRUCTIBLE(Entity entity, BOOL p1) { invoke<Void>(0x0C8BC052AE87D744, entity, p1); } // 0x0C8BC052AE87D744 b1207
	NATIVE_DECL void _0x5CD3AAD8FF9ED121(Any p0) { invoke<Void>(0x5CD3AAD8FF9ED121, p0); } // 0x5CD3AAD8FF9ED121 b1207
	NATIVE_DECL void _0x51951DE06C0D1C40(Player player, int type) { invoke<Void>(0x51951DE06C0D1C40, player, type); } // 0x51951DE06C0D1C40 b1207
	NATIVE_DECL void _0xE3AB5EEFCB6671A2(int setting) { invoke<Void>(0xE3AB5EEFCB6671A2, setting); } // 0xE3AB5EEFCB6671A2 b1207
	NATIVE_DECL void _0x9B39B0555CC692B5() { invoke<Void>(0x9B39B0555CC692B5); } // 0x9B39B0555CC692B5 b1207
	NATIVE_DECL int _0xFE53B1F8D43F19BF(Player player1, Player player2) { return invoke<int>(0xFE53B1F8D43F19BF, player1, player2); } // 0xFE53B1F8D43F19BF b1207
	NATIVE_DECL BOOL _0x862C5040F4888741(Player player1, Player player2) { return invoke<BOOL>(0x862C5040F4888741, player1, player2); } // 0x862C5040F4888741 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x2CD41AC000E6F611() { invoke<Void>(0x2CD41AC000E6F611); } // 0x2CD41AC000E6F611 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xACC44768AF229042() { invoke<Void>(0xACC44768AF229042); } // 0xACC44768AF229042 b1207
	NATIVE_DECL void _0x7E300B5B86AB1D1A(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10, Any p11, Any p12, Any p13, Any p14) { invoke<Void>(0x7E300B5B86AB1D1A, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); } // 0x7E300B5B86AB1D1A b1207
	NATIVE_DECL int GET_UNIQUE_INT_FOR_PLAYER(Player player) { return invoke<int>(0x07F723401B9D921C, player); } // 0x07F723401B9D921C b1207
	NATIVE_DECL void _0x780A13F780A13F1B(BOOL toggle) { invoke<Void>(0x780A13F780A13F1B, toggle); } // 0x780A13F780A13F1B b1311
	NATIVE_DECL BOOL _NETWORK_IS_TRACKED_PLAYER_VISIBLE(Player player, Player trackedPlayer) { return invoke<BOOL>(0xE525878A35B9EEBD, player, trackedPlayer); } // 0xE525878A35B9EEBD b1207
	NATIVE_DECL BOOL NETWORK_IS_AIM_CAM_ACTIVE(Player player) { return invoke<BOOL>(0x8E7CE19219669AEB, player); } // 0x8E7CE19219669AEB b1207
	NATIVE_DECL void _NETWORK_ALERT(Hash ctx, Hash lh, int ec, int h) { invoke<Void>(0x1BAA028F52EED310, ctx, lh, ec, h); } // 0x1BAA028F52EED310 b1311
	// Note: this native was added in build 1311.23
	NATIVE_DECL void _0x19447FCAE97704DC(Hash ctx, int ec, BOOL ex, BOOL ro) { invoke<Void>(0x19447FCAE97704DC, ctx, ec, ex, ro); } // 0x19447FCAE97704DC b1311
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x2C4E98DDA475364F(const char* p0) { invoke<Void>(0x2C4E98DDA475364F, p0); } // 0x2C4E98DDA475364F b1207
	NATIVE_DECL void _0x3F0ABAE38A0515AD(int p0, int p1) { invoke<Void>(0x3F0ABAE38A0515AD, p0, p1); } // 0x3F0ABAE38A0515AD b1207
	NATIVE_DECL int _0x3F2EE18A3E294801(int p0) { return invoke<int>(0x3F2EE18A3E294801, p0); } // 0x3F2EE18A3E294801 b1207
	NATIVE_DECL void _SET_SOCIAL_MATCHMAKING_ALLOWED(BOOL toggle) { invoke<Void>(0x777D0571A466B520, toggle); } // 0x777D0571A466B520 b1207
	NATIVE_DECL BOOL _GET_SOCIAL_MATCHMAKING_ALLOWED() { return invoke<BOOL>(0xD0541EF28E9C4783); } // 0xD0541EF28E9C4783 b1207
	NATIVE_DECL BOOL NETWORK_AWARD_HAS_REACHED_MAXCLAIM(Any p0) { return invoke<BOOL>(0xFBE782B3165AC8EC, p0); } // 0xFBE782B3165AC8EC b1207
	NATIVE_DECL Any _0x271F95E55C663B8B(Any p0, Any p1) { return invoke<Any>(0x271F95E55C663B8B, p0, p1); } // 0x271F95E55C663B8B b1207
	NATIVE_DECL Any _0x64A36BA85CE01A81(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x64A36BA85CE01A81, p0, p1, p2, p3); } // 0x64A36BA85CE01A81 b1207
	NATIVE_DECL Any _0xE10F2D7715ABABEC(Any p0) { return invoke<Any>(0xE10F2D7715ABABEC, p0); } // 0xE10F2D7715ABABEC b1207
	NATIVE_DECL Any _0x7A8E8DF782B47EB0(Any p0, Any p1, Any p2) { return invoke<Any>(0x7A8E8DF782B47EB0, p0, p1, p2); } // 0x7A8E8DF782B47EB0 b1207
	NATIVE_DECL Any _0x77B299E8799B1332(Any p0, Any p1, Any p2) { return invoke<Any>(0x77B299E8799B1332, p0, p1, p2); } // 0x77B299E8799B1332 b1207
	NATIVE_DECL Any _0x923346025512DFB7(Any p0) { return invoke<Any>(0x923346025512DFB7, p0); } // 0x923346025512DFB7 b1207
	NATIVE_DECL int _NETWORK_GET_XP() { return invoke<int>(0xDB438CC9BC6F4022); } // 0xDB438CC9BC6F4022 b1207
	NATIVE_DECL int _NETWORK_GET_RANK() { return invoke<int>(0x32C90CDFAF40514C); } // 0x32C90CDFAF40514C b1207
	NATIVE_DECL void NETWORK_SET_RECENT_GAMERS_ENABLED(BOOL toggle) { invoke<Void>(0x29FE035D35B8589C, toggle); } // 0x29FE035D35B8589C b1207
	NATIVE_DECL BOOL _0x273E04A3A7AD1F2D() { return invoke<BOOL>(0x273E04A3A7AD1F2D); } // 0x273E04A3A7AD1F2D b1207
	NATIVE_DECL void _NETWORK_ADD_PLAYER_TO_RECENT_GAMERS_LIST(Player player, int p1) { invoke<Void>(0x157D8F3DE12B307F, player, p1); } // 0x157D8F3DE12B307F b1207
	NATIVE_DECL BOOL NETWORK_REQUEST_RECENT_GAMER_NAMES(int p0, int playerCount) { return invoke<BOOL>(0x6D206D383BB5F6B1, p0, playerCount); } // 0x6D206D383BB5F6B1 b1207
	NATIVE_DECL BOOL _NETWORK_IS_RECENT_GAMER_NAMES_REQUEST_IN_PROGRESS() { return invoke<BOOL>(0x4664D213A0CCAF40); } // 0x4664D213A0CCAF40 b1207
	NATIVE_DECL BOOL _NETWORK_DID_RECENT_GAMER_NAMES_REQUEST_SUCCEED() { return invoke<BOOL>(0x12AEB56B489415C5); } // 0x12AEB56B489415C5 b1207
	NATIVE_DECL int _NETWORK_GET_NUM_RECENT_GAMERS() { return invoke<int>(0x37A834AEC6A4F74A); } // 0x37A834AEC6A4F74A b1207
	NATIVE_DECL BOOL NETWORK_GET_RECENT_GAMER_NAMES(int p0, int p1, Any* outData, int dataSize) { return invoke<BOOL>(0xFEFCC345CE357453, p0, p1, outData, dataSize); } // 0xFEFCC345CE357453 b1207
	NATIVE_DECL void _0x49CF17A564918E8D() { invoke<Void>(0x49CF17A564918E8D); } // 0x49CF17A564918E8D b1207
	NATIVE_DECL void _0xD637D327080CD86E(int p0) { invoke<Void>(0xD637D327080CD86E, p0); } // 0xD637D327080CD86E b1207
	NATIVE_DECL void _0x564552C6AF1EEAB1() { invoke<Void>(0x564552C6AF1EEAB1); } // 0x564552C6AF1EEAB1 b1207
	NATIVE_DECL void NETWORK_ACTIVITY_RESET_TO_IDLE() { invoke<Void>(0x3FE141FDB990E3D1); } // 0x3FE141FDB990E3D1 b1207
	NATIVE_DECL void NETWORK_ACTIVITY_SET_CURRENT(int p0) { invoke<Void>(0x9ADAC065D9F6706F, p0); } // 0x9ADAC065D9F6706F b1207
	// Returns CGameConfig->ConfigOnlineServices->RosTitleName (see gameconfig.xml)
	NATIVE_DECL const char* _NETWORK_GET_ROS_TITLE_NAME() { return invoke<const char*>(0xAC6153A0722F524C); } // 0xAC6153A0722F524C b1207
	NATIVE_DECL void _REPORT_PLAYER(Player player, int reportType, const char* description, const char* horseName) { invoke<Void>(0xA197C35F73AC0F12, player, reportType, description, horseName); } // 0xA197C35F73AC0F12 b1207
}

namespace OBJECT
{
	NATIVE_DECL Object CREATE_OBJECT(Hash modelHash, float x, float y, float z, BOOL isNetwork, BOOL bScriptHostObj, BOOL dynamic, BOOL p7, BOOL p8) { return invoke<Object>(0x509D5878EB39E842, modelHash, x, y, z, isNetwork, bScriptHostObj, dynamic, p7, p8); } // 0x509D5878EB39E842 0x2F7AA05C b1207
	NATIVE_DECL Object CREATE_OBJECT(Hash modelHash, Vector3 vec, BOOL isNetwork, BOOL bScriptHostObj, BOOL dynamic, BOOL p7, BOOL p8) { return invoke<Object>(0x509D5878EB39E842, modelHash, vec.x, vec.y, vec.z, isNetwork, bScriptHostObj, dynamic, p7, p8); } // 0x509D5878EB39E842 0x2F7AA05C b1207
	NATIVE_DECL Object CREATE_OBJECT_NO_OFFSET(Hash modelHash, float x, float y, float z, BOOL isNetwork, BOOL bScriptHostObj, BOOL dynamic, BOOL p7) { return invoke<Object>(0x9A294B2138ABB884, modelHash, x, y, z, isNetwork, bScriptHostObj, dynamic, p7); } // 0x9A294B2138ABB884 0x58040420 b1207
	NATIVE_DECL Object CREATE_OBJECT_NO_OFFSET(Hash modelHash, Vector3 vec, BOOL isNetwork, BOOL bScriptHostObj, BOOL dynamic, BOOL p7) { return invoke<Object>(0x9A294B2138ABB884, modelHash, vec.x, vec.y, vec.z, isNetwork, bScriptHostObj, dynamic, p7); } // 0x9A294B2138ABB884 0x58040420 b1207
	// Deletes the specified object, then sets the handle pointed to by the pointer to NULL.
	NATIVE_DECL void DELETE_OBJECT(Object* object) { invoke<Void>(0x931914268722C263, object); } // 0x931914268722C263 0xD6EF9DA7 b1207
	NATIVE_DECL BOOL PLACE_OBJECT_ON_GROUND_PROPERLY(Object object, BOOL p1) { return invoke<BOOL>(0x58A850EAEE20FAA3, object, p1); } // 0x58A850EAEE20FAA3 0x8F95A20B b1207
	NATIVE_DECL BOOL SLIDE_OBJECT(Object object, float toX, float toY, float toZ, float speedX, float speedY, float speedZ, BOOL collision) { return invoke<BOOL>(0x2FDFF4107B8C1147, object, toX, toY, toZ, speedX, speedY, speedZ, collision); } // 0x2FDFF4107B8C1147 0x63BFA7A0 b1207
	NATIVE_DECL BOOL SLIDE_OBJECT(Object object, Vector3 to, Vector3 speed, BOOL collision) { return invoke<BOOL>(0x2FDFF4107B8C1147, object, to.x, to.y, to.z, speed.x, speed.y, speed.z, collision); } // 0x2FDFF4107B8C1147 0x63BFA7A0 b1207
	NATIVE_DECL void SET_OBJECT_TARGETTABLE(Object object, BOOL targettable) { invoke<Void>(0x8A7391690F5AFD81, object, targettable); } // 0x8A7391690F5AFD81 0x3F88CD86 b1207
	NATIVE_DECL void _SET_OBJECT_TARGETTABLE_2(Object object, BOOL targettable) { invoke<Void>(0x581EDBE56E8D62C9, object, targettable); } // 0x581EDBE56E8D62C9 b1207
	// When p1 and p2 are true you can focus on the object (similar to when you focus a ped)
	NATIVE_DECL void _SET_OBJECT_TARGETTABLE_FOCUS(Object object, BOOL p1, BOOL p2) { invoke<Void>(0xA22712E8471AA08E, object, p1, p2); } // 0xA22712E8471AA08E b1207
	NATIVE_DECL void _0xF6E88489B4E6EBE5(Any p0, Any p1) { invoke<Void>(0xF6E88489B4E6EBE5, p0, p1); } // 0xF6E88489B4E6EBE5 b1207
	NATIVE_DECL void _0xE157A8A336C7F04A(Any p0, Any p1) { invoke<Void>(0xE157A8A336C7F04A, p0, p1); } // 0xE157A8A336C7F04A b1207
	NATIVE_DECL void _0x46CBCF0E98A4E156(Any p0, Any p1) { invoke<Void>(0x46CBCF0E98A4E156, p0, p1); } // 0x46CBCF0E98A4E156 b1207
	// isMission - if true doesn't return mission objects
	NATIVE_DECL Object GET_CLOSEST_OBJECT_OF_TYPE(float x, float y, float z, float radius, Hash modelHash, BOOL isMission, BOOL p6, BOOL p7) { return invoke<Object>(0xE143FA2249364369, x, y, z, radius, modelHash, isMission, p6, p7); } // 0xE143FA2249364369 0x45619B33 b1207
	NATIVE_DECL Object GET_CLOSEST_OBJECT_OF_TYPE(Vector3 vec, float radius, Hash modelHash, BOOL isMission, BOOL p6, BOOL p7) { return invoke<Object>(0xE143FA2249364369, vec.x, vec.y, vec.z, radius, modelHash, isMission, p6, p7); } // 0xE143FA2249364369 0x45619B33 b1207
	NATIVE_DECL BOOL HAS_OBJECT_BEEN_BROKEN(Any p0) { return invoke<BOOL>(0x8ABFB70C49CC43E2, p0); } // 0x8ABFB70C49CC43E2 0xFE21F891 b1207
	NATIVE_DECL BOOL HAS_CLOSEST_OBJECT_OF_TYPE_BEEN_BROKEN(float p0, float p1, float p2, float p3, Hash modelHash, Any p5) { return invoke<BOOL>(0x761B0E69AC4D007E, p0, p1, p2, p3, modelHash, p5); } // 0x761B0E69AC4D007E 0x6FC0353D b1207
	NATIVE_DECL Vector3 _GET_OBJECT_OFFSET_FROM_COORDS(float xPos, float yPos, float zPos, float heading, float xOffset, float yOffset, float zOffset) { return invoke<Vector3>(0x163E252DE035A133, xPos, yPos, zPos, heading, xOffset, yOffset, zOffset); } // 0x163E252DE035A133 0x87A42A12 b1207
	NATIVE_DECL Vector3 _GET_OBJECT_OFFSET_FROM_COORDS(Vector3 pos, float heading, Vector3 offset) { return invoke<Vector3>(0x163E252DE035A133, pos.x, pos.y, pos.z, heading, offset.x, offset.y, offset.z); } // 0x163E252DE035A133 0x87A42A12 b1207
	// Registers a door, hashes: https://github.com/femga/rdr3_discoveries/tree/master/doorHashes
	NATIVE_DECL void _ADD_DOOR_TO_SYSTEM_NEW(Hash doorHash, BOOL p1, BOOL p2, BOOL p3, int threadId, int p5, BOOL p6) { invoke<Void>(0xD99229FE93B46286, doorHash, p1, p2, p3, threadId, p5, p6); } // 0xD99229FE93B46286 b1207
	NATIVE_DECL BOOL _IS_DOOR_REGISTERED_WITH_NETWORK(Hash doorHash) { return invoke<BOOL>(0xB5DED7B65C604FDF, doorHash); } // 0xB5DED7B65C604FDF b1207
	NATIVE_DECL void REMOVE_DOOR_FROM_SYSTEM(Hash doorHash) { invoke<Void>(0x464D8E1427156FE4, doorHash); } // 0x464D8E1427156FE4 0x00253286 b1207
	// Door lock states:
	// enum eDoorState
	// {
	// 	DOORSTATE_INVALID = -1,
	// 	DOORSTATE_UNLOCKED,
	// 	DOORSTATE_LOCKED_UNBREAKABLE,
	// 	DOORSTATE_LOCKED_BREAKABLE,
	// 	DOORSTATE_HOLD_OPEN_POSITIVE,
	// 	DOORSTATE_HOLD_OPEN_NEGATIVE
	// };
	NATIVE_DECL void DOOR_SYSTEM_SET_DOOR_STATE(Hash doorHash, int state) { invoke<Void>(0x6BAB9442830C7F53, doorHash, state); } // 0x6BAB9442830C7F53 0xDF83DB47 b1207
	NATIVE_DECL int DOOR_SYSTEM_GET_DOOR_STATE(Hash doorHash) { return invoke<int>(0x160AA1B32F6139B8, doorHash); } // 0x160AA1B32F6139B8 0xD42A41C2 b1207
	NATIVE_DECL void DOOR_SYSTEM_SET_AUTOMATIC_RATE(Hash doorHash, float rate) { invoke<Void>(0x03C27E13B42A0E82, doorHash, rate); } // 0x03C27E13B42A0E82 0x4F44AF21 b1207
	NATIVE_DECL void DOOR_SYSTEM_SET_AUTOMATIC_DISTANCE(Hash doorHash, float distance) { invoke<Void>(0x9BA001CB45CBF627, doorHash, distance); } // 0x9BA001CB45CBF627 0x47531446 b1207
	NATIVE_DECL void _0xB3B1546D23DF8DE1(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xB3B1546D23DF8DE1, p0, p1, p2, p3, p4); } // 0xB3B1546D23DF8DE1 b1207
	// Sets the ajar angle of a door.
	// Ranges from -1.0 to 1.0, and 0.0 is closed / default.
	NATIVE_DECL void DOOR_SYSTEM_SET_OPEN_RATIO(Hash doorHash, float ajar, BOOL forceUpdate) { invoke<Void>(0xB6E6FBA95C7324AC, doorHash, ajar, forceUpdate); } // 0xB6E6FBA95C7324AC 0x34883DE3 b1207
	NATIVE_DECL void _0x3A77DAE8B4FD7586(Any p0, Any p1) { invoke<Void>(0x3A77DAE8B4FD7586, p0, p1); } // 0x3A77DAE8B4FD7586 b1207
	NATIVE_DECL void _DOOR_SYSTEM_SET_ABLE_TO_CHANGE_OPEN_RATIO_WHILE_LOCKED(Hash doorHash, BOOL p1) { invoke<Void>(0x1F1FABFE9B2A1254, doorHash, p1); } // 0x1F1FABFE9B2A1254 b1207
	// Returns true if door is alredy registered with owner
	NATIVE_DECL BOOL _IS_DOOR_REGISTERED_WITH_OWNER(Hash doorHash) { return invoke<BOOL>(0x4F89DAD4156BA145, doorHash); } // 0x4F89DAD4156BA145 b1207
	NATIVE_DECL void _DOOR_SYSTEM_CHANGE_SCRIPT_OWNER(Hash doorHash) { invoke<Void>(0x985767F5FA45BC44, doorHash); } // 0x985767F5FA45BC44 b1207
	NATIVE_DECL float _DOOR_SYSTEM_GET_AUTOMATIC_RATE(Hash doorHash) { return invoke<float>(0x8433E1954BE323FC, doorHash); } // 0x8433E1954BE323FC b1207
	NATIVE_DECL Any _0x6E2AA80BB0C03728(Any p0, Any p1) { return invoke<Any>(0x6E2AA80BB0C03728, p0, p1); } // 0x6E2AA80BB0C03728 b1207
	NATIVE_DECL void _0x1BC47A9DEDC8DF5D(Any p0, Any p1) { invoke<Void>(0x1BC47A9DEDC8DF5D, p0, p1); } // 0x1BC47A9DEDC8DF5D b1207
	NATIVE_DECL float DOOR_SYSTEM_GET_OPEN_RATIO(Hash doorHash) { return invoke<float>(0x65499865FCA6E5EC, doorHash); } // 0x65499865FCA6E5EC 0xB74C3BD7 b1207
	NATIVE_DECL void _0x7F458B543006C8FE(Any p0, Any p1) { invoke<Void>(0x7F458B543006C8FE, p0, p1); } // 0x7F458B543006C8FE b1207
	NATIVE_DECL Any _0xACD4F9831DFAD7F5(Any p0) { return invoke<Any>(0xACD4F9831DFAD7F5, p0); } // 0xACD4F9831DFAD7F5 b1207
	NATIVE_DECL void _0x0C0A373D181BF900(Any p0) { invoke<Void>(0x0C0A373D181BF900, p0); } // 0x0C0A373D181BF900 b1207
	NATIVE_DECL void _0xA93F925F1942E434(Any p0, Any p1) { invoke<Void>(0xA93F925F1942E434, p0, p1); } // 0xA93F925F1942E434 b1207
	NATIVE_DECL Any _0x4D8611DFE1126478(Any p0) { return invoke<Any>(0x4D8611DFE1126478, p0); } // 0x4D8611DFE1126478 b1207
	NATIVE_DECL void _0x57C242543B7B8FB9(Any p0, Any p1) { invoke<Void>(0x57C242543B7B8FB9, p0, p1); } // 0x57C242543B7B8FB9 b1207
	NATIVE_DECL void _0x4AE07EBA3462C5D5(Any p0, Any p1) { invoke<Void>(0x4AE07EBA3462C5D5, p0, p1); } // 0x4AE07EBA3462C5D5 b1207
	NATIVE_DECL void _0x22031584496CFB70(Any p0, Any p1) { invoke<Void>(0x22031584496CFB70, p0, p1); } // 0x22031584496CFB70 b1207
	NATIVE_DECL void _0xC07B91B996C1DE89(Any p0, Any p1) { invoke<Void>(0xC07B91B996C1DE89, p0, p1); } // 0xC07B91B996C1DE89 b1207
	NATIVE_DECL BOOL IS_DOOR_REGISTERED_WITH_SYSTEM(Hash doorHash) { return invoke<BOOL>(0xC153C43EA202C8C1, doorHash); } // 0xC153C43EA202C8C1 0x5AFCD8A1 b1207
	NATIVE_DECL BOOL IS_DOOR_CLOSED(Hash doorHash) { return invoke<BOOL>(0xC531EE8A1145A149, doorHash); } // 0xC531EE8A1145A149 0x48659CD7 b1207
	// Params: p1 = 23 in R* Scripts
	NATIVE_DECL Any _0x0943113E02322164(Object object, int p1) { return invoke<Any>(0x0943113E02322164, object, p1); } // 0x0943113E02322164 b1207
	NATIVE_DECL Any _0x614D0B4533F842D3(Any p0) { return invoke<Any>(0x614D0B4533F842D3, p0); } // 0x614D0B4533F842D3 b1207
	NATIVE_DECL void _DOOR_SYSTEM_FORCE_SHUT(Hash doorHash, BOOL p1) { invoke<Void>(0x276AAF0F1C7F2494, doorHash, p1); } // 0x276AAF0F1C7F2494 b1207
	NATIVE_DECL Any _0xEBA314768FB35D58(Any p0) { return invoke<Any>(0xEBA314768FB35D58, p0); } // 0xEBA314768FB35D58 b1207
	NATIVE_DECL void _0x5230BF34EB0EC645(Any p0) { invoke<Void>(0x5230BF34EB0EC645, p0); } // 0x5230BF34EB0EC645 b1207
	NATIVE_DECL BOOL DOES_OBJECT_OF_TYPE_EXIST_AT_COORDS(float x, float y, float z, float radius, Hash hash, BOOL p5) { return invoke<BOOL>(0xBFA48E2FF417213F, x, y, z, radius, hash, p5); } // 0xBFA48E2FF417213F 0x23FF2BA4 b1207
	NATIVE_DECL BOOL DOES_OBJECT_OF_TYPE_EXIST_AT_COORDS(Vector3 vec, float radius, Hash hash, BOOL p5) { return invoke<BOOL>(0xBFA48E2FF417213F, vec.x, vec.y, vec.z, radius, hash, p5); } // 0xBFA48E2FF417213F 0x23FF2BA4 b1207
	NATIVE_DECL BOOL IS_POINT_IN_ANGLED_AREA(float p0, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float p9, BOOL p10, BOOL p11) { return invoke<BOOL>(0x2A70BAE8883E4C81, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); } // 0x2A70BAE8883E4C81 0x73BCFFDC b1207
	NATIVE_DECL void SET_OBJECT_ALLOW_LOW_LOD_BUOYANCY(Object object, BOOL toggle) { invoke<Void>(0x4D89D607CB3DD1D2, object, toggle); } // 0x4D89D607CB3DD1D2 0x19B17769 b1207
	// Adjust the physics parameters of a prop, or otherwise known as "object". This is useful for simulated gravity.
	// 
	// Other parameters seem to be unknown.
	// 
	// p2: seems to be weight and gravity related. Higher value makes the obj fall faster. Very sensitive?
	// p3: seems similar to p2
	// p4: makes obj fall slower the higher the value
	// p5: similar to p4
	NATIVE_DECL void SET_OBJECT_PHYSICS_PARAMS(Object object, float weight, float p2, float p3, float p4, float p5, float gravity, float p7, float p8, float p9, float p10, float buoyancy) { invoke<Void>(0xF6DF6E90DE7DF90F, object, weight, p2, p3, p4, p5, gravity, p7, p8, p9, p10, buoyancy); } // 0xF6DF6E90DE7DF90F 0xE8D11C58 b1207
	NATIVE_DECL float GET_OBJECT_FRAGMENT_DAMAGE_HEALTH(Any p0, BOOL p1) { return invoke<float>(0xB6FBFD079B8D0596, p0, p1); } // 0xB6FBFD079B8D0596 0xF0B330AD b1207
	NATIVE_DECL Any _0x235C863DA77BD88D(Any p0, Any p1, Any p2) { return invoke<Any>(0x235C863DA77BD88D, p0, p1, p2); } // 0x235C863DA77BD88D b1207
	NATIVE_DECL void SET_ACTIVATE_OBJECT_PHYSICS_AS_SOON_AS_IT_IS_UNFROZEN(Object object, BOOL toggle) { invoke<Void>(0x406137F8EF90EAF5, object, toggle); } // 0x406137F8EF90EAF5 0x3E263AE1 b1207
	NATIVE_DECL void BREAK_OBJECT_FRAGMENT_CHILD(Object object, Any p1, BOOL p2) { invoke<Void>(0xE7E4C198B0185900, object, p1, p2); } // 0xE7E4C198B0185900 0x1E82C2AE b1207
	NATIVE_DECL void BREAK_ALL_OBJECT_FRAGMENT_BONES(Object object) { invoke<Void>(0x8462BE2341A55B6F, object); } // 0x8462BE2341A55B6F b1207
	NATIVE_DECL void _0xAAACF33CBF9B990A(Any p0, Any p1) { invoke<Void>(0xAAACF33CBF9B990A, p0, p1); } // 0xAAACF33CBF9B990A b1207
	NATIVE_DECL void _DAMAGE_BONE_ON_PROP(Object object, int bone) { invoke<Void>(0xE4EFB315BCD2A838, object, bone); } // 0xE4EFB315BCD2A838 b1207
	NATIVE_DECL void _0xF9C1681347C8BD15(Object object) { invoke<Void>(0xF9C1681347C8BD15, object); } // 0xF9C1681347C8BD15 b1207
	NATIVE_DECL Any _0x58DE624FA7FB0E7F(Any p0) { return invoke<Any>(0x58DE624FA7FB0E7F, p0); } // 0x58DE624FA7FB0E7F b1207
	NATIVE_DECL void _0x491439AEF410A2FC(Any p0) { invoke<Void>(0x491439AEF410A2FC, p0); } // 0x491439AEF410A2FC b1207
	NATIVE_DECL void _SET_OBJECT_BREAK_SCALE(Object object, float scale) { invoke<Void>(0xFFB99FFD17F65889, object, scale); } // 0xFFB99FFD17F65889 b1207
	NATIVE_DECL void _0xCEAB54F4632C6EF6(Any p0, Any p1) { invoke<Void>(0xCEAB54F4632C6EF6, p0, p1); } // 0xCEAB54F4632C6EF6 b1207
	NATIVE_DECL void TRACK_OBJECT_VISIBILITY(Object object) { invoke<Void>(0xB252BC036B525623, object); } // 0xB252BC036B525623 0x46D06B9A b1207
	NATIVE_DECL BOOL IS_OBJECT_VISIBLE(Object object) { return invoke<BOOL>(0x8B32ACE6326A7546, object); } // 0x8B32ACE6326A7546 0xF4FD8AE4 b1207
	NATIVE_DECL void _0xEB6F1A9B5510A5D2(Any p0, BOOL p1) { invoke<Void>(0xEB6F1A9B5510A5D2, p0, p1); } // 0xEB6F1A9B5510A5D2 0xAF016CC1 b1207
	NATIVE_DECL void ALLOW_DAMAGE_EVENTS_FOR_NON_NETWORKED_OBJECTS(BOOL enabled) { invoke<Void>(0xE2B3B852B537C398, enabled); } // 0xE2B3B852B537C398 b1207
	NATIVE_DECL void _0x6579860A5558524A(Any p0, Any p1) { invoke<Void>(0x6579860A5558524A, p0, p1); } // 0x6579860A5558524A b1207
	NATIVE_DECL void _0xDFA1237F5228263F(Any p0, Any p1) { invoke<Void>(0xDFA1237F5228263F, p0, p1); } // 0xDFA1237F5228263F b1207
	NATIVE_DECL float _GET_LIGHT_INTENSITY_FROM_OBJECT(Object object) { return invoke<float>(0xFA3B61EC249B4674, object); } // 0xFA3B61EC249B4674 b1207
	NATIVE_DECL void _SET_LIGHT_INTENSITY_FOR_OBJECT(Object object, float lightIntensity) { invoke<Void>(0xF49574E2332A8F06, object, lightIntensity); } // 0xF49574E2332A8F06 b1207
	// Params: value = 0.0 - 586.67 (?)
	NATIVE_DECL void _SET_LIGHT_TRANSLUCENCY_FOR_OBJECT(Object object, float value) { invoke<Void>(0x63E39F09310F481F, object, value); } // 0x63E39F09310F481F b1207
	NATIVE_DECL void _SET_LIGHT_SCATTERING_DISABLED_FOR_OBJECT(Object object, BOOL disable) { invoke<Void>(0x04D1D4E411CE52D0, object, disable); } // 0x04D1D4E411CE52D0 b1207
	NATIVE_DECL void _0x7FCD49388BC9B775(Any p0, Any p1) { invoke<Void>(0x7FCD49388BC9B775, p0, p1); } // 0x7FCD49388BC9B775 b1207
	NATIVE_DECL Any _0xFA99E8E575F2FEF8(Any p0) { return invoke<Any>(0xFA99E8E575F2FEF8, p0); } // 0xFA99E8E575F2FEF8 b1436
	NATIVE_DECL Object GET_RAYFIRE_MAP_OBJECT(float x, float y, float z, float radius, const char* name) { return invoke<Object>(0xB48FCED898292E52, x, y, z, radius, name); } // 0xB48FCED898292E52 0xA286DE96 b1207
	NATIVE_DECL Object GET_RAYFIRE_MAP_OBJECT(Vector3 vec, float radius, const char* name) { return invoke<Object>(0xB48FCED898292E52, vec.x, vec.y, vec.z, radius, name); } // 0xB48FCED898292E52 0xA286DE96 b1207
	NATIVE_DECL void SET_STATE_OF_RAYFIRE_MAP_OBJECT(Object object, int state) { invoke<Void>(0x5C29F698D404C5E1, object, state); } // 0x5C29F698D404C5E1 0x21F51560 b1207
	NATIVE_DECL int GET_STATE_OF_RAYFIRE_MAP_OBJECT(Object object) { return invoke<int>(0x899BA936634A322E, object); } // 0x899BA936634A322E 0xF1B8817A b1207
	NATIVE_DECL BOOL DOES_RAYFIRE_MAP_OBJECT_EXIST(Object object) { return invoke<BOOL>(0x52AF537A0C5B8AAD, object); } // 0x52AF537A0C5B8AAD 0xE08C834D b1207
	NATIVE_DECL float GET_RAYFIRE_MAP_OBJECT_ANIM_PHASE(Object object) { return invoke<float>(0x260EE4FDBDF4DB01, object); } // 0x260EE4FDBDF4DB01 0x020497DE b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/objects/pickup_list.lua
	NATIVE_DECL Pickup CREATE_PICKUP(Hash pickupHash, float x, float y, float z, int flags, int p5, BOOL p6, Hash modelHash, int p8, float p9, Any p10) { return invoke<Pickup>(0xFBA08C503DD5FA58, pickupHash, x, y, z, flags, p5, p6, modelHash, p8, p9, p10); } // 0xFBA08C503DD5FA58 0x5E14DF68 b1207
	NATIVE_DECL Pickup CREATE_PICKUP(Hash pickupHash, Vector3 vec, int flags, int p5, BOOL p6, Hash modelHash, int p8, float p9, Any p10) { return invoke<Pickup>(0xFBA08C503DD5FA58, pickupHash, vec.x, vec.y, vec.z, flags, p5, p6, modelHash, p8, p9, p10); } // 0xFBA08C503DD5FA58 0x5E14DF68 b1207
	NATIVE_DECL Pickup CREATE_PICKUP_ROTATE(Hash pickupHash, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, int flags, int p8, int p9, BOOL p10, Hash modelHash, int p12, float p13, Any p14) { return invoke<Pickup>(0x891804727E0A98B7, pickupHash, posX, posY, posZ, rotX, rotY, rotZ, flags, p8, p9, p10, modelHash, p12, p13, p14); } // 0x891804727E0A98B7 0xF015BFE2 b1207
	NATIVE_DECL Pickup CREATE_PICKUP_ROTATE(Hash pickupHash, Vector3 pos, Vector3 rot, int flags, int p8, int p9, BOOL p10, Hash modelHash, int p12, float p13, Any p14) { return invoke<Pickup>(0x891804727E0A98B7, pickupHash, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, flags, p8, p9, p10, modelHash, p12, p13, p14); } // 0x891804727E0A98B7 0xF015BFE2 b1207
	NATIVE_DECL Object CREATE_AMBIENT_PICKUP(Hash pickupHash, float x, float y, float z, int flags, int value, Hash modelHash, BOOL p7, BOOL p8, int p9, float p10) { return invoke<Object>(0x673966A0C0FD7171, pickupHash, x, y, z, flags, value, modelHash, p7, p8, p9, p10); } // 0x673966A0C0FD7171 0x17B99CE7 b1207
	NATIVE_DECL Object CREATE_AMBIENT_PICKUP(Hash pickupHash, Vector3 vec, int flags, int value, Hash modelHash, BOOL p7, BOOL p8, int p9, float p10) { return invoke<Object>(0x673966A0C0FD7171, pickupHash, vec.x, vec.y, vec.z, flags, value, modelHash, p7, p8, p9, p10); } // 0x673966A0C0FD7171 0x17B99CE7 b1207
	NATIVE_DECL Object CREATE_PORTABLE_PICKUP(Hash pickupHash, float x, float y, float z, BOOL placeOnGround, Hash modelHash) { return invoke<Object>(0x2EAF1FDB2FB55698, pickupHash, x, y, z, placeOnGround, modelHash); } // 0x2EAF1FDB2FB55698 0x8C886BE5 b1207
	NATIVE_DECL Object CREATE_PORTABLE_PICKUP(Hash pickupHash, Vector3 vec, BOOL placeOnGround, Hash modelHash) { return invoke<Object>(0x2EAF1FDB2FB55698, pickupHash, vec.x, vec.y, vec.z, placeOnGround, modelHash); } // 0x2EAF1FDB2FB55698 0x8C886BE5 b1207
	NATIVE_DECL void ATTACH_PORTABLE_PICKUP_TO_PED(Object pickupObject, Ped ped) { invoke<Void>(0x8DC39368BDD57755, pickupObject, ped); } // 0x8DC39368BDD57755 0x184F6AB3 b1207
	NATIVE_DECL void DETACH_PORTABLE_PICKUP_FROM_PED(Object pickupObject) { invoke<Void>(0xCF463D1E9A0AECB1, pickupObject); } // 0xCF463D1E9A0AECB1 0x1D094562 b1207
	NATIVE_DECL void _HIDE_PICKUP_OBJECT(Object pickupObject, BOOL toggle) { invoke<Void>(0x2777150CC7D9365E, pickupObject, toggle); } // 0x2777150CC7D9365E b1207
	NATIVE_DECL void SET_MAX_NUM_PORTABLE_PICKUPS_CARRIED_BY_PLAYER(Hash modelHash, int p1) { invoke<Void>(0x0BF3B3BD47D79C08, modelHash, p1); } // 0x0BF3B3BD47D79C08 0x7EFBA039 b1207
	NATIVE_DECL Any _0x3E2616E7EA539480(Any p0) { return invoke<Any>(0x3E2616E7EA539480, p0); } // 0x3E2616E7EA539480 b1207
	NATIVE_DECL void SET_LOCAL_PLAYER_CAN_COLLECT_PORTABLE_PICKUPS(BOOL toggle) { invoke<Void>(0x78857FC65CADB909, toggle); } // 0x78857FC65CADB909 0xA3CDF152 b1207
	NATIVE_DECL Vector3 GET_SAFE_PICKUP_COORDS(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<Vector3>(0x6E16BC2503FF1FF0, p0, p1, p2, p3, p4, p5); } // 0x6E16BC2503FF1FF0 0x618B5F67 b1207
	NATIVE_DECL Vector3 GET_PICKUP_COORDS(Pickup pickup) { return invoke<Vector3>(0x225B8B35C88029B3, pickup); } // 0x225B8B35C88029B3 0xC2E1E2C5 b1207
	NATIVE_DECL void REMOVE_ALL_PICKUPS_OF_TYPE(Hash pickupHash) { invoke<Void>(0x27F9D613092159CF, pickupHash); } // 0x27F9D613092159CF 0x40062C53 b1207
	NATIVE_DECL BOOL HAS_PICKUP_BEEN_COLLECTED(Pickup pickup) { return invoke<BOOL>(0x80EC48E6679313F9, pickup); } // 0x80EC48E6679313F9 0x0BE5CCED b1207
	NATIVE_DECL void REMOVE_PICKUP(Pickup pickup) { invoke<Void>(0x3288D8ACAECD2AB2, pickup); } // 0x3288D8ACAECD2AB2 0x64A7A0E0 b1207
	NATIVE_DECL void SET_PICKUP_DO_NOT_AUTO_PLACE_ON_GROUND(Object pickupObject) { invoke<Void>(0x634C19521485AB25, pickupObject); } // 0x634C19521485AB25 b1207
	NATIVE_DECL BOOL DOES_PICKUP_EXIST(Pickup pickup) { return invoke<BOOL>(0xAFC1CA75AD4074D1, pickup); } // 0xAFC1CA75AD4074D1 0x9C6DA0B3 b1207
	NATIVE_DECL BOOL DOES_PICKUP_OBJECT_EXIST(Object pickupObject) { return invoke<BOOL>(0xD9EFB6DBF7DAAEA3, pickupObject); } // 0xD9EFB6DBF7DAAEA3 0xE0B32108 b1207
	NATIVE_DECL Object GET_PICKUP_OBJECT(Pickup pickup) { return invoke<Object>(0x5099BC55630B25AE, pickup); } // 0x5099BC55630B25AE 0x6052E62E b1207
	NATIVE_DECL BOOL IS_OBJECT_A_PORTABLE_PICKUP(Object object) { return invoke<BOOL>(0x0378C08504160D0D, object); } // 0x0378C08504160D0D 0x0F0E94FF b1207
	NATIVE_DECL BOOL _IS_PICKUP_TYPE_VALID(Hash pickupHash) { return invoke<BOOL>(0x007BD043587F7C82, pickupHash); } // 0x007BD043587F7C82 b1207
	NATIVE_DECL BOOL DOES_PICKUP_OF_TYPE_EXIST_IN_AREA(Hash pickupHash, float x, float y, float z, float radius) { return invoke<BOOL>(0xF9C36251F6E48E33, pickupHash, x, y, z, radius); } // 0xF9C36251F6E48E33 0xF139681B b1207
	NATIVE_DECL BOOL DOES_PICKUP_OF_TYPE_EXIST_IN_AREA(Hash pickupHash, Vector3 vec, float radius) { return invoke<BOOL>(0xF9C36251F6E48E33, pickupHash, vec.x, vec.y, vec.z, radius); } // 0xF9C36251F6E48E33 0xF139681B b1207
	NATIVE_DECL void SET_PICKUP_REGENERATION_TIME(Pickup pickup, int duration) { invoke<Void>(0x78015C9B4B3ECC9D, pickup, duration); } // 0x78015C9B4B3ECC9D 0xAB11267D b1207
	NATIVE_DECL void FORCE_PICKUP_REGENERATE(Any p0) { invoke<Void>(0x758A5C1B3B1E1990, p0); } // 0x758A5C1B3B1E1990 b1207
	NATIVE_DECL void _0x94F3D956BFAEAE18(Any p0, Any p1, Any p2) { invoke<Void>(0x94F3D956BFAEAE18, p0, p1, p2); } // 0x94F3D956BFAEAE18 b1207
	// Maximum amount of pickup models that can be disallowed is 10.
	NATIVE_DECL void _SET_LOCAL_PLAYER_CAN_USE_PICKUPS_WITH_THIS_MODEL(Hash modelHash, BOOL toggle) { invoke<Void>(0x88EAEC617CD26926, modelHash, toggle); } // 0x88EAEC617CD26926 0x3A8F1BF7 b1207
	NATIVE_DECL void BLOCK_PICKUP_FROM_PLAYER_COLLECTION(Any p0, Any p1) { invoke<Void>(0xB8F5062070BB6DBD, p0, p1); } // 0xB8F5062070BB6DBD b1207
	NATIVE_DECL void SET_PICKUP_NOT_LOOTABLE(Any p0, Any p1) { invoke<Void>(0x92E87F60F21A0C3A, p0, p1); } // 0x92E87F60F21A0C3A b1207
	NATIVE_DECL void _0x1F5E07E14A86FAFC(Any p0) { invoke<Void>(0x1F5E07E14A86FAFC, p0); } // 0x1F5E07E14A86FAFC b1207
	NATIVE_DECL void SET_TEAM_PICKUP_OBJECT(Object object, Any p1, BOOL p2) { invoke<Void>(0x53E0DF1A2A3CF0CA, object, p1, p2); } // 0x53E0DF1A2A3CF0CA 0x77687DC5 b1207
	NATIVE_DECL Any _0x9F52AD67D1A91BAD(Any p0, Any p1) { return invoke<Any>(0x9F52AD67D1A91BAD, p0, p1); } // 0x9F52AD67D1A91BAD b1207
	NATIVE_DECL void PREVENT_COLLECTION_OF_PORTABLE_PICKUP(Object object, BOOL p1, BOOL p2) { invoke<Void>(0x92AEFB5F6E294023, object, p1, p2); } // 0x92AEFB5F6E294023 0xCBB5F9B6 b1207
	NATIVE_DECL void SET_PICKUP_GENERATION_RANGE_MULTIPLIER(float multiplier) { invoke<Void>(0x318516E02DE3ECE2, multiplier); } // 0x318516E02DE3ECE2 0x9879AC51 b1207
	NATIVE_DECL void SET_PICKUP_UNCOLLECTABLE(Any p0, Any p1) { invoke<Void>(0x4A8CB328CD6F1C9B, p0, p1); } // 0x4A8CB328CD6F1C9B b1207
	NATIVE_DECL void SET_PICKUP_HIDDEN_WHEN_UNCOLLECTABLE(Any p0, Any p1) { invoke<Void>(0x81218CE01B672219, p0, p1); } // 0x81218CE01B672219 b1207
	NATIVE_DECL void _SET_AMBIENT_PICKUP_LIFETIME(int lifetime) { invoke<Void>(0xAC9AE68F0A463752, lifetime); } // 0xAC9AE68F0A463752 b1207
	NATIVE_DECL void SET_PICKUP_PARTICLE_FX_SPAWN(Any p0, Any p1) { invoke<Void>(0xEB9740A38FD6D634, p0, p1); } // 0xEB9740A38FD6D634 b1207
	NATIVE_DECL void SET_PICKUP_PARTICLE_FX_HIGHLIGHT(Any p0, Any p1) { invoke<Void>(0x1607C7D9B3021DF5, p0, p1); } // 0x1607C7D9B3021DF5 b1207
	NATIVE_DECL void SUPPRESS_PICKUP_REWARD_TYPE(int rewardType, BOOL suppress) { invoke<Void>(0xF92099527DB8E2A7, rewardType, suppress); } // 0xF92099527DB8E2A7 0xA7E936FD b1207
	NATIVE_DECL Any _0x20135AF9C10D2A3D(Any p0) { return invoke<Any>(0x20135AF9C10D2A3D, p0); } // 0x20135AF9C10D2A3D b1207
	NATIVE_DECL void _SET_PICKUP_COLLECTABLE_ON_MOUNT(Object object) { invoke<Void>(0x00EE08603EADEE92, object); } // 0x00EE08603EADEE92 b1207
	NATIVE_DECL void _0xDE116ECFFDD4B997(Any p0, Any p1) { invoke<Void>(0xDE116ECFFDD4B997, p0, p1); } // 0xDE116ECFFDD4B997 b1207
	NATIVE_DECL Hash GET_WEAPON_TYPE_FROM_PICKUP_TYPE(Hash pickupHash) { return invoke<Hash>(0x08F96CA6C551AD51, pickupHash); } // 0x08F96CA6C551AD51 0xEDD01937 b1207
	NATIVE_DECL Any _0x44B09A23D728045A(Any p0) { return invoke<Any>(0x44B09A23D728045A, p0); } // 0x44B09A23D728045A b1207
	NATIVE_DECL void _SET_OBJECT_TEXTURE_VARIATION(Object object, int textureVariation) { invoke<Void>(0x971DA0055324D033, object, textureVariation); } // 0x971DA0055324D033 b1207
	NATIVE_DECL Any _0x3397CD4E0353DFBA(Any p0) { return invoke<Any>(0x3397CD4E0353DFBA, p0); } // 0x3397CD4E0353DFBA b1207
	NATIVE_DECL void _SET_OBJECT_BURN_OPACITY(Object object, float opacity) { invoke<Void>(0x7D7285EFEAB5AF15, object, opacity); } // 0x7D7285EFEAB5AF15 b1207
	NATIVE_DECL void _SET_OBJECT_BURN_INTENSITY(Object object, float intensity) { invoke<Void>(0xC8E21C1677DC5E6F, object, intensity); } // 0xC8E21C1677DC5E6F b1207
	// Seems to mostly have effect on wood-made objects https://imgur.com/a/32oQvOn
	NATIVE_DECL void _SET_OBJECT_BURN_LEVEL(Object object, float burnLevel, BOOL affectAsh) { invoke<Void>(0x2797C633DCDBBAC5, object, burnLevel, affectAsh); } // 0x2797C633DCDBBAC5 b1207
	NATIVE_DECL void _0x9A74A9CADFA8A598(Any p0) { invoke<Void>(0x9A74A9CADFA8A598, p0); } // 0x9A74A9CADFA8A598 b1207
	NATIVE_DECL void _RESET_OBJECT_VELOCITY(Object object) { invoke<Void>(0xF40AB58D83C35027, object); } // 0xF40AB58D83C35027 b1207
	// p2 is usually the same as speed parameter
	NATIVE_DECL void _SET_OBJECT_BURN_SPEED(Object object, float speed, float p2) { invoke<Void>(0x646564A3B7DF68F8, object, speed, p2); } // 0x646564A3B7DF68F8 b1207
	NATIVE_DECL void _0xCBFBD38F2E0A263B(Any p0, Any p1) { invoke<Void>(0xCBFBD38F2E0A263B, p0, p1); } // 0xCBFBD38F2E0A263B b1207
	// Most likely _CONVERT_PICKUP_*
	NATIVE_DECL Hash _GET_PICKUP_HASH(Hash pickupHash) { return invoke<Hash>(0x5EAAD83F8CFB4575, pickupHash); } // 0x5EAAD83F8CFB4575 0x6AE36192 b1207
	NATIVE_DECL void SET_FORCE_OBJECT_THIS_FRAME(float x, float y, float z, float p3) { invoke<Void>(0xF538081986E49E9D, x, y, z, p3); } // 0xF538081986E49E9D 0x3DA41C1A b1207
	NATIVE_DECL void SET_FORCE_OBJECT_THIS_FRAME(Vector3 vec, float p3) { invoke<Void>(0xF538081986E49E9D, vec.x, vec.y, vec.z, p3); } // 0xF538081986E49E9D 0x3DA41C1A b1207
	NATIVE_DECL Any _0xD91E55B6C005EB09(Any p0, Any p1) { return invoke<Any>(0xD91E55B6C005EB09, p0, p1); } // 0xD91E55B6C005EB09 b1207
	NATIVE_DECL void _MARK_OBJECT_FOR_DELETION(Object object) { invoke<Void>(0xADBE4809F19F927A, object); } // 0xADBE4809F19F927A 0x2048A7DD b1207
	// _SET_OBJECT_*
	NATIVE_DECL void _0xCAAF2BCCFEF37F77(Object object, Any p1) { invoke<Void>(0xCAAF2BCCFEF37F77, object, p1); } // 0xCAAF2BCCFEF37F77 b1207
	NATIVE_DECL Any _0x08C5825A2932EA7B(Any p0) { return invoke<Any>(0x08C5825A2932EA7B, p0); } // 0x08C5825A2932EA7B b1207
	NATIVE_DECL Any _0x7D4411D6736CD295(Any p0, Any p1) { return invoke<Any>(0x7D4411D6736CD295, p0, p1); } // 0x7D4411D6736CD295 b1207
	NATIVE_DECL Any _0x250EBB11E81A10BE(Any p0) { return invoke<Any>(0x250EBB11E81A10BE, p0); } // 0x250EBB11E81A10BE b1207
	NATIVE_DECL Any _0x2BF1953C0C21AC88(Any p0) { return invoke<Any>(0x2BF1953C0C21AC88, p0); } // 0x2BF1953C0C21AC88 b1207
	NATIVE_DECL BOOL CREATE_OBJECT_SKELETON(Object object) { return invoke<BOOL>(0xB6CBD40F8EA69E8A, object); } // 0xB6CBD40F8EA69E8A b1207
	// _PRE* or _Q* or _RE*
	NATIVE_DECL void _MAKE_ITEM_CARRIABLE(Object object) { invoke<Void>(0x1461DF6DB886BE3F, object); } // 0x1461DF6DB886BE3F b1207
	NATIVE_DECL void _0xF65EDE5D02A7A760(Any p0, Any p1) { invoke<Void>(0xF65EDE5D02A7A760, p0, p1); } // 0xF65EDE5D02A7A760 b1207
	// Sets object as auto-jumpable by horse.
	NATIVE_DECL void _SET_AUTO_JUMPABLE_BY_HORSE(Object object, BOOL p1) { invoke<Void>(0x98D2D9C053A1F449, object, p1); } // 0x98D2D9C053A1F449 b1207
	// Sets object as not jumpable by horse.
	NATIVE_DECL void _SET_NOT_JUMPABLE_BY_HORSE(Object object, BOOL p1) { invoke<Void>(0xE1C708BA4885796B, object, p1); } // 0xE1C708BA4885796B b1207
	NATIVE_DECL void _SET_OBJECT_KICKABLE(Object object, BOOL kickable) { invoke<Void>(0xB7017DA4D498269F, object, kickable); } // 0xB7017DA4D498269F b1207
	NATIVE_DECL void SET_CUSTOM_TEXTURES_ON_OBJECT(Object object, Hash txdHash, Any p2, Any p3) { invoke<Void>(0xE124889AE0521FCF, object, txdHash, p2, p3); } // 0xE124889AE0521FCF b1207
	NATIVE_DECL void _0xD503D6F0986D58BC(Any p0, Any p1) { invoke<Void>(0xD503D6F0986D58BC, p0, p1); } // 0xD503D6F0986D58BC b1207
	NATIVE_DECL void _0xAEE6C800E124CFE1(Any p0, Any p1) { invoke<Void>(0xAEE6C800E124CFE1, p0, p1); } // 0xAEE6C800E124CFE1 b1207
	NATIVE_DECL void _0x3DF1A0A58498E209(Object object, Any p1) { invoke<Void>(0x3DF1A0A58498E209, object, p1); } // 0x3DF1A0A58498E209 b1436
}

namespace PAD
{
	// Sets the current control context. Must be called every frame.
	// 
	// context: https://alloc8or.re/rdr3/doc/misc/input_contexts.txt
	// For more information, see common:/data/control/settings.meta
	// https://github.com/femga/rdr3_discoveries/tree/master/Controls
	NATIVE_DECL void _SET_CONTROL_CONTEXT(int p0, Hash context) { invoke<Void>(0x2804658EB7D8A50B, p0, context); } // 0x2804658EB7D8A50B b1207
	NATIVE_DECL Any _0xDDCEB0F26C89C00F(int p0) { return invoke<Any>(0xDDCEB0F26C89C00F, p0); } // 0xDDCEB0F26C89C00F b1207
	NATIVE_DECL BOOL _IS_CONTROL_ACTION_VALID(Hash control, int padIndex) { return invoke<BOOL>(0xBC0884BC590951C7, control, padIndex); } // 0xBC0884BC590951C7 b1207
	NATIVE_DECL BOOL IS_CONTROL_ENABLED(int padIndex, Hash control) { return invoke<BOOL>(0x1CEA6BFDF248E5D9, padIndex, control); } // 0x1CEA6BFDF248E5D9 0x9174AF84 b1207
	NATIVE_DECL BOOL IS_CONTROL_PRESSED(int padIndex, Hash control) { return invoke<BOOL>(0xF3A21BCD95725A4A, padIndex, control); } // 0xF3A21BCD95725A4A 0x517A4384 b1207
	NATIVE_DECL BOOL IS_CONTROL_RELEASED(int padIndex, Hash control) { return invoke<BOOL>(0x648EE3E7F38877DD, padIndex, control); } // 0x648EE3E7F38877DD 0x1F91A06E b1207
	NATIVE_DECL BOOL IS_CONTROL_JUST_PRESSED(int padIndex, Hash control) { return invoke<BOOL>(0x580417101DDB492F, padIndex, control); } // 0x580417101DDB492F 0x4487F579 b1207
	NATIVE_DECL BOOL IS_CONTROL_JUST_RELEASED(int padIndex, Hash control) { return invoke<BOOL>(0x50F940259D3841E6, padIndex, control); } // 0x50F940259D3841E6 0x2314444B b1207
	NATIVE_DECL int GET_CONTROL_VALUE(int padIndex, Hash control) { return invoke<int>(0xD95E79E8686D2C27, padIndex, control); } // 0xD95E79E8686D2C27 0xC526F3C6 b1207
	NATIVE_DECL float GET_CONTROL_NORMAL(int padIndex, Hash control) { return invoke<float>(0xEC3C9B8D5327B563, padIndex, control); } // 0xEC3C9B8D5327B563 0x5DE226A5 b1207
	NATIVE_DECL float GET_CONTROL_UNBOUND_NORMAL(int padIndex, Hash control) { return invoke<float>(0x5B84D09CEC5209C5, padIndex, control); } // 0x5B84D09CEC5209C5 0xC49343BB b1207
	NATIVE_DECL BOOL _SET_CONTROL_NORMAL(int padIndex, Hash control, float amount) { return invoke<BOOL>(0xE8A25867FBA3B05E, padIndex, control, amount); } // 0xE8A25867FBA3B05E b1207
	NATIVE_DECL BOOL IS_DISABLED_CONTROL_PRESSED(int padIndex, Hash control) { return invoke<BOOL>(0xE2587F8CBBD87B1D, padIndex, control); } // 0xE2587F8CBBD87B1D 0x32A93544 b1207
	NATIVE_DECL BOOL IS_DISABLED_CONTROL_JUST_PRESSED(int padIndex, Hash control) { return invoke<BOOL>(0x91AEF906BCA88877, padIndex, control); } // 0x91AEF906BCA88877 0xEE6ABD32 b1207
	NATIVE_DECL BOOL IS_DISABLED_CONTROL_JUST_RELEASED(int padIndex, Hash control) { return invoke<BOOL>(0x305C8DCD79DA8B0F, padIndex, control); } // 0x305C8DCD79DA8B0F 0xD6A679E1 b1207
	NATIVE_DECL float GET_DISABLED_CONTROL_NORMAL(int padIndex, Hash control) { return invoke<float>(0x11E65974A982637C, padIndex, control); } // 0x11E65974A982637C 0x66FF4FAA b1207
	NATIVE_DECL float GET_DISABLED_CONTROL_UNBOUND_NORMAL(int padIndex, Hash control) { return invoke<float>(0x4F8A26A890FD62FB, padIndex, control); } // 0x4F8A26A890FD62FB 0xF2A65A4C b1207
	NATIVE_DECL int GET_CONTROL_HOW_LONG_AGO(int p0) { return invoke<int>(0xD7D22F5592AED8BA, p0); } // 0xD7D22F5592AED8BA 0x0E8EF929 b1207
	NATIVE_DECL int _GET_DISABLED_CONTROL_HOW_LONG_AGO(int padIndex) { return invoke<int>(0x771DFCB24D19C2F6, padIndex); } // 0x771DFCB24D19C2F6 b1207
	// padIndex is not used
	NATIVE_DECL BOOL _IS_USING_KEYBOARD(int padIndex) { return invoke<BOOL>(0xA571D46727E2B718, padIndex); } // 0xA571D46727E2B718 b1207
	NATIVE_DECL Any _0x43F35DDB2905D945(Any p0, Any p1) { return invoke<Any>(0x43F35DDB2905D945, p0, p1); } // 0x43F35DDB2905D945 b1207
	NATIVE_DECL Any _0xBD629C1C4F501C80(Any p0) { return invoke<Any>(0xBD629C1C4F501C80, p0); } // 0xBD629C1C4F501C80 b1207
	NATIVE_DECL BOOL _0x6CD79468A1E595C6(int padIndex) { return invoke<BOOL>(0x6CD79468A1E595C6, padIndex); } // 0x6CD79468A1E595C6 b1207
	// nullsub, doesn't do anything
	// 
	// Old name: _SET_CONTROL_GROUP_COLOR
	NATIVE_DECL void SET_CONTROL_LIGHT_EFFECT_COLOR(int padIndex, int red, int green, int blue) { invoke<Void>(0x8290252FFF36ACB5, padIndex, red, green, blue); } // 0x8290252FFF36ACB5 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xCB0360EFEFB2580D(int padIndex) { invoke<Void>(0xCB0360EFEFB2580D, padIndex); } // 0xCB0360EFEFB2580D b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void SET_CONTROL_LIGHT_EFFECT_FLASHING_COLOR(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xA45884DB10EC7EE3, p0, p1, p2, p3); } // 0xA45884DB10EC7EE3 b1207
	NATIVE_DECL void SET_PAD_SHAKE(int padIndex, int duration, int frequency) { invoke<Void>(0x48B3886C1358D0D5, padIndex, duration, frequency); } // 0x48B3886C1358D0D5 0x5D38BD2F b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x14D29BB12D47F68C(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x14D29BB12D47F68C, p0, p1, p2, p3, p4); } // 0x14D29BB12D47F68C b1207
	NATIVE_DECL void STOP_PAD_SHAKE(int padIndex) { invoke<Void>(0x38C16A305E8CDC8D, padIndex); } // 0x38C16A305E8CDC8D 0x8F75657E b1207
	NATIVE_DECL void SET_PAD_SHAKE_SUPPRESSED_ID(int padIndex, int p1) { invoke<Void>(0xF239400E16C23E08, padIndex, p1); } // 0xF239400E16C23E08 0x7D65EB6E b1207
	NATIVE_DECL void _CLEAR_SUPPRESSED_PAD_RUMBLE(int p0) { invoke<Void>(0xA0CEFCEA390AAB9B, p0); } // 0xA0CEFCEA390AAB9B b1207
	NATIVE_DECL BOOL IS_LOOK_INVERTED() { return invoke<BOOL>(0x77B612531280010D); } // 0x77B612531280010D 0x313434B2 b1207
	NATIVE_DECL void SET_INPUT_EXCLUSIVE(int padIndex, Hash control) { invoke<Void>(0xEDE476E5EE29EDB1, padIndex, control); } // 0xEDE476E5EE29EDB1 0x4E8E29E6 b1207
	NATIVE_DECL void DISABLE_CONTROL_ACTION(int padIndex, Hash control, BOOL disable) { invoke<Void>(0xFE99B66D079CF6BC, padIndex, control, disable); } // 0xFE99B66D079CF6BC 0x3800C0DC b1207
	NATIVE_DECL void ENABLE_CONTROL_ACTION(int padIndex, Hash control, BOOL enable) { invoke<Void>(0x351220255D64C155, padIndex, control, enable); } // 0x351220255D64C155 0xD2753551 b1207
	NATIVE_DECL void DISABLE_ALL_CONTROL_ACTIONS(int padIndex) { invoke<Void>(0x5F4B6931816E599B, padIndex); } // 0x5F4B6931816E599B 0x16753CF4 b1207
	// rumbleCurve: common_0/data/rumblecurves.meta
	NATIVE_DECL void _0x5F217BC1190503D8(const char* rumbleCurve, float p1) { invoke<Void>(0x5F217BC1190503D8, rumbleCurve, p1); } // 0x5F217BC1190503D8 b1207
	NATIVE_DECL void _0x709BA8C08C5C008D() { invoke<Void>(0x709BA8C08C5C008D); } // 0x709BA8C08C5C008D b1207
	NATIVE_DECL Any _0x1252C029FC8EBB4D() { return invoke<Any>(0x1252C029FC8EBB4D); } // 0x1252C029FC8EBB4D b1207
	NATIVE_DECL void _0x52C68E92D6E23ADD(Any p0) { invoke<Void>(0x52C68E92D6E23ADD, p0); } // 0x52C68E92D6E23ADD b1311
}

namespace PATHFIND
{
	NATIVE_DECL void SET_ROADS_IN_AREA(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8) { invoke<Void>(0xBF1A602B5BA52FEE, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0xBF1A602B5BA52FEE 0xEBC7B918 b1207
	NATIVE_DECL void SET_ROADS_IN_ANGLED_AREA(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10) { invoke<Void>(0x1A5AA1208AF5DB59, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x1A5AA1208AF5DB59 0xBD088F4B b1207
	NATIVE_DECL void SET_ROADS_IN_VOLUME(Volume volume, BOOL p1, BOOL p2, BOOL p3) { invoke<Void>(0xC1799FAFD2FDF52B, volume, p1, p2, p3); } // 0xC1799FAFD2FDF52B b1207
	NATIVE_DECL void RESET_ROADS_IN_VOLUME(Volume volume, BOOL p1) { invoke<Void>(0xD17672447692478E, volume, p1); } // 0xD17672447692478E b1207
	NATIVE_DECL void SET_ROADS_BACK_TO_ORIGINAL(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0x1EE7063B80FFC77C, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x1EE7063B80FFC77C 0x86AC4A85 b1207
	NATIVE_DECL void SET_ROADS_BACK_TO_ORIGINAL_IN_ANGLED_AREA(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8) { invoke<Void>(0x0027501B9F3B407E, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0x0027501B9F3B407E 0x9DB5D209 b1207
	NATIVE_DECL void _0xAFE2AE66F6251C66(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xAFE2AE66F6251C66, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xAFE2AE66F6251C66 b1207
	NATIVE_DECL void _0x4358BCF14C91761C(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { invoke<Void>(0x4358BCF14C91761C, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0x4358BCF14C91761C b1207
	NATIVE_DECL void _0xB03944057FD735BA(Any p0, Any p1, Any p2) { invoke<Void>(0xB03944057FD735BA, p0, p1, p2); } // 0xB03944057FD735BA b1207
	NATIVE_DECL void _0x6C3F12ECEB6D2E2A(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0x6C3F12ECEB6D2E2A, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x6C3F12ECEB6D2E2A b1207
	NATIVE_DECL void _0x5A4E1A41E3A02AD0(Any p0, Any p1, Any p2) { invoke<Void>(0x5A4E1A41E3A02AD0, p0, p1, p2); } // 0x5A4E1A41E3A02AD0 b1207
	NATIVE_DECL BOOL GET_CLOSEST_VEHICLE_NODE(float x, float y, float z, Vector3* outPosition, int nodeType, float p5, float p6) { return invoke<BOOL>(0x240A18690AE96513, x, y, z, outPosition, nodeType, p5, p6); } // 0x240A18690AE96513 0x6F5F1E6C b1207
	NATIVE_DECL BOOL GET_CLOSEST_VEHICLE_NODE(Vector3 vec, Vector3* outPosition, int nodeType, float p5, float p6) { return invoke<BOOL>(0x240A18690AE96513, vec.x, vec.y, vec.z, outPosition, nodeType, p5, p6); } // 0x240A18690AE96513 0x6F5F1E6C b1207
	NATIVE_DECL Any _0xCA27A86CAA4E98ED(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0xCA27A86CAA4E98ED, p0, p1, p2, p3, p4, p5, p6); } // 0xCA27A86CAA4E98ED b1207
	NATIVE_DECL BOOL GET_CLOSEST_VEHICLE_NODE_WITH_HEADING(float x, float y, float z, Vector3* outPosition, float* outHeading, int nodeType, float p6, int p7) { return invoke<BOOL>(0x23CFFD4CCB243354, x, y, z, outPosition, outHeading, nodeType, p6, p7); } // 0x23CFFD4CCB243354 0x8BD5759B b1207
	NATIVE_DECL BOOL GET_CLOSEST_VEHICLE_NODE_WITH_HEADING(Vector3 vec, Vector3* outPosition, float* outHeading, int nodeType, float p6, int p7) { return invoke<BOOL>(0x23CFFD4CCB243354, vec.x, vec.y, vec.z, outPosition, outHeading, nodeType, p6, p7); } // 0x23CFFD4CCB243354 0x8BD5759B b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE(float x, float y, float z, int nthClosest, Vector3* outPosition, int unknown1, float unknown2, Any unknown3) { return invoke<BOOL>(0x5A6D8DF6FBC5D0C4, x, y, z, nthClosest, outPosition, unknown1, unknown2, unknown3); } // 0x5A6D8DF6FBC5D0C4 0xF125BFCC b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE(Vector3 vec, int nthClosest, Vector3* outPosition, int unknown1, float unknown2, Any unknown3) { return invoke<BOOL>(0x5A6D8DF6FBC5D0C4, vec.x, vec.y, vec.z, nthClosest, outPosition, unknown1, unknown2, unknown3); } // 0x5A6D8DF6FBC5D0C4 0xF125BFCC b1207
	NATIVE_DECL int GET_NTH_CLOSEST_VEHICLE_NODE_ID(float x, float y, float z, int nth, int nodetype, float p5, float p6) { return invoke<int>(0x116443008E5CEFC3, x, y, z, nth, nodetype, p5, p6); } // 0x116443008E5CEFC3 0x3F358BEA b1207
	NATIVE_DECL int GET_NTH_CLOSEST_VEHICLE_NODE_ID(Vector3 vec, int nth, int nodetype, float p5, float p6) { return invoke<int>(0x116443008E5CEFC3, vec.x, vec.y, vec.z, nth, nodetype, p5, p6); } // 0x116443008E5CEFC3 0x3F358BEA b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_WITH_HEADING(float x, float y, float z, int nthClosest, Vector3* outPosition, float* heading, Any* unknown1, int unknown2, float unknown3, float unknown4) { return invoke<BOOL>(0x591B40D4390DB54A, x, y, z, nthClosest, outPosition, heading, unknown1, unknown2, unknown3, unknown4); } // 0x591B40D4390DB54A 0x7349C856 b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_WITH_HEADING(Vector3 vec, int nthClosest, Vector3* outPosition, float* heading, Any* unknown1, int unknown2, float unknown3, float unknown4) { return invoke<BOOL>(0x591B40D4390DB54A, vec.x, vec.y, vec.z, nthClosest, outPosition, heading, unknown1, unknown2, unknown3, unknown4); } // 0x591B40D4390DB54A 0x7349C856 b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_ID_WITH_HEADING(float x, float y, float z, int nthClosest, Vector3* outPosition, float outHeading, Any p6, float p7, float p8) { return invoke<BOOL>(0x4114EAA8A7F7766D, x, y, z, nthClosest, outPosition, outHeading, p6, p7, p8); } // 0x4114EAA8A7F7766D 0xC1AEB88D b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_ID_WITH_HEADING(Vector3 vec, int nthClosest, Vector3* outPosition, float outHeading, Any p6, float p7, float p8) { return invoke<BOOL>(0x4114EAA8A7F7766D, vec.x, vec.y, vec.z, nthClosest, outPosition, outHeading, p6, p7, p8); } // 0x4114EAA8A7F7766D 0xC1AEB88D b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_FAVOUR_DIRECTION(float x, float y, float z, float desiredX, float desiredY, float desiredZ, int nthClosest, Vector3* outPosition, float* outHeading, int nodetype, Any p10, Any p11) { return invoke<BOOL>(0x2FAC235A6062F14A, x, y, z, desiredX, desiredY, desiredZ, nthClosest, outPosition, outHeading, nodetype, p10, p11); } // 0x2FAC235A6062F14A 0x928A4DEC b1207
	NATIVE_DECL BOOL GET_NTH_CLOSEST_VEHICLE_NODE_FAVOUR_DIRECTION(Vector3 vec, Vector3 desired, int nthClosest, Vector3* outPosition, float* outHeading, int nodetype, Any p10, Any p11) { return invoke<BOOL>(0x2FAC235A6062F14A, vec.x, vec.y, vec.z, desired.x, desired.y, desired.z, nthClosest, outPosition, outHeading, nodetype, p10, p11); } // 0x2FAC235A6062F14A 0x928A4DEC b1207
	// Returns true if the id is non zero.
	NATIVE_DECL BOOL IS_VEHICLE_NODE_ID_VALID(int vehicleNodeId) { return invoke<BOOL>(0x5829A02AF4F0B3CB, vehicleNodeId); } // 0x5829A02AF4F0B3CB 0x57DFB1EF b1207
	NATIVE_DECL void GET_VEHICLE_NODE_POSITION(int nodeId, Vector3* outPosition) { invoke<Void>(0x8E8D72FF24DEE1FB, nodeId, outPosition); } // 0x8E8D72FF24DEE1FB 0xE38E252D b1207
	NATIVE_DECL BOOL GET_VEHICLE_NODE_IS_SWITCHED_OFF(int nodeID) { return invoke<BOOL>(0x28533DBDDF7C2C97, nodeID); } // 0x28533DBDDF7C2C97 0x56737A3C b1207
	NATIVE_DECL Any GET_CLOSEST_ROAD(float x, float y, float z, float p3, int p4, Vector3* p5, Vector3* p6, Any* p7, Any* p8, float* p9, BOOL p10) { return invoke<Any>(0x132F52BBA570FE92, x, y, z, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x132F52BBA570FE92 0x567B0E11 b1207
	NATIVE_DECL Any GET_CLOSEST_ROAD(Vector3 vec, float p3, int p4, Vector3* p5, Vector3* p6, Any* p7, Any* p8, float* p9, BOOL p10) { return invoke<Any>(0x132F52BBA570FE92, vec.x, vec.y, vec.z, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x132F52BBA570FE92 0x567B0E11 b1207
	NATIVE_DECL BOOL ARE_NODES_LOADED_FOR_AREA(float x1, float y1, float x2, float y2) { return invoke<BOOL>(0xF7B79A50B905A30D, x1, y1, x2, y2); } // 0xF7B79A50B905A30D 0x86E80A17 b1207
	NATIVE_DECL BOOL ARE_NODES_LOADED_FOR_AREA(Vector2 vec1, Vector2 vec2) { return invoke<BOOL>(0xF7B79A50B905A30D, vec1.x, vec1.y, vec2.x, vec2.y); } // 0xF7B79A50B905A30D 0x86E80A17 b1207
	NATIVE_DECL BOOL REQUEST_PATHS_PREFER_ACCURATE_BOUNDINGSTRUCT(float x1, float y1, float x2, float y2) { return invoke<BOOL>(0x07FB139B592FA687, x1, y1, x2, y2); } // 0x07FB139B592FA687 0x2CDA5012 b1207
	NATIVE_DECL BOOL REQUEST_PATHS_PREFER_ACCURATE_BOUNDINGSTRUCT(Vector2 vec1, Vector2 vec2) { return invoke<BOOL>(0x07FB139B592FA687, vec1.x, vec1.y, vec2.x, vec2.y); } // 0x07FB139B592FA687 0x2CDA5012 b1207
	NATIVE_DECL BOOL GET_RANDOM_VEHICLE_NODE(float x, float y, float z, float radius, BOOL p4, BOOL p5, BOOL p6, Vector3* outPosition, int* nodeId) { return invoke<BOOL>(0x93E0DB8440B73A7D, x, y, z, radius, p4, p5, p6, outPosition, nodeId); } // 0x93E0DB8440B73A7D 0xAD1476EA b1207
	NATIVE_DECL BOOL GET_RANDOM_VEHICLE_NODE(Vector3 vec, float radius, BOOL p4, BOOL p5, BOOL p6, Vector3* outPosition, int* nodeId) { return invoke<BOOL>(0x93E0DB8440B73A7D, vec.x, vec.y, vec.z, radius, p4, p5, p6, outPosition, nodeId); } // 0x93E0DB8440B73A7D 0xAD1476EA b1207
	NATIVE_DECL void _GET_SPAWN_DATA_FOR_ROAD_NODE(int nodeId, float x, float y, float z, Vector3* outCoords, float* heading) { invoke<Void>(0xA3791B915B8B84C6, nodeId, x, y, z, outCoords, heading); } // 0xA3791B915B8B84C6 b1207
	NATIVE_DECL void _GET_SPAWN_DATA_FOR_ROAD_NODE(int nodeId, Vector3 vec, Vector3* outCoords, float* heading) { invoke<Void>(0xA3791B915B8B84C6, nodeId, vec.x, vec.y, vec.z, outCoords, heading); } // 0xA3791B915B8B84C6 b1207
	// Gets a value indicating whether the specified position is on a road.
	NATIVE_DECL BOOL IS_POINT_ON_ROAD(float x, float y, float z, Vehicle vehicle) { return invoke<BOOL>(0x125BF4ABFC536B09, x, y, z, vehicle); } // 0x125BF4ABFC536B09 0xCF198055 b1207
	NATIVE_DECL BOOL IS_POINT_ON_ROAD(Vector3 vec, Vehicle vehicle) { return invoke<BOOL>(0x125BF4ABFC536B09, vec.x, vec.y, vec.z, vehicle); } // 0x125BF4ABFC536B09 0xCF198055 b1207
	NATIVE_DECL void SET_PED_PATHS_IN_AREA(float x1, float y1, float z1, float x2, float y2, float z2, BOOL unknown, Any p7) { invoke<Void>(0x34F060F4BF92E018, x1, y1, z1, x2, y2, z2, unknown, p7); } // 0x34F060F4BF92E018 0x2148EA84 b1207
	NATIVE_DECL void SET_PED_PATHS_IN_AREA(Vector3 vec1, Vector3 vec2, BOOL unknown, Any p7) { invoke<Void>(0x34F060F4BF92E018, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, unknown, p7); } // 0x34F060F4BF92E018 0x2148EA84 b1207
	NATIVE_DECL void _0xE5EF9DE716FF737E(Any p0, Any p1, Any p2) { invoke<Void>(0xE5EF9DE716FF737E, p0, p1, p2); } // 0xE5EF9DE716FF737E b1207
	NATIVE_DECL BOOL GET_SAFE_COORD_FOR_PED(float x, float y, float z, BOOL onGround, Vector3* outPosition, int flags) { return invoke<BOOL>(0xB61C8E878A4199CA, x, y, z, onGround, outPosition, flags); } // 0xB61C8E878A4199CA 0xB370270A b1207
	NATIVE_DECL BOOL GET_SAFE_COORD_FOR_PED(Vector3 vec, BOOL onGround, Vector3* outPosition, int flags) { return invoke<BOOL>(0xB61C8E878A4199CA, vec.x, vec.y, vec.z, onGround, outPosition, flags); } // 0xB61C8E878A4199CA 0xB370270A b1207
	NATIVE_DECL void SET_PED_PATHS_BACK_TO_ORIGINAL(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { invoke<Void>(0xE04B48F2CC926253, p0, p1, p2, p3, p4, p5, p6); } // 0xE04B48F2CC926253 0x3F1ABDA4 b1207
	NATIVE_DECL void _0xCF213A5FC3ABFC08(Any p0, Any p1, Any p2) { invoke<Void>(0xCF213A5FC3ABFC08, p0, p1, p2); } // 0xCF213A5FC3ABFC08 b1207
	NATIVE_DECL void ADD_NAVMESH_REQUIRED_REGION(float x, float y, float radius) { invoke<Void>(0x387EAD7EE42F6685, x, y, radius); } // 0x387EAD7EE42F6685 0x12B086EA b1207
	NATIVE_DECL void ADD_NAVMESH_REQUIRED_REGION(Vector2 vec, float radius) { invoke<Void>(0x387EAD7EE42F6685, vec.x, vec.y, radius); } // 0x387EAD7EE42F6685 0x12B086EA b1207
	// Returns whether navmesh for the region is loaded.
	NATIVE_DECL BOOL IS_NAVMESH_LOADED_IN_AREA(float x1, float y1, float z1, float x2, float y2, float z2) { return invoke<BOOL>(0xF813C7E63F9062A5, x1, y1, z1, x2, y2, z2); } // 0xF813C7E63F9062A5 0x4C2BA99E b1207
	NATIVE_DECL BOOL IS_NAVMESH_LOADED_IN_AREA(Vector3 vec1, Vector3 vec2) { return invoke<BOOL>(0xF813C7E63F9062A5, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0xF813C7E63F9062A5 0x4C2BA99E b1207
	NATIVE_DECL int GET_NUM_NAVMESHES_EXISTING_IN_AREA(float p0, float p1, float p2, float p3, float p4, float p5) { return invoke<int>(0x01708E8DD3FF8C65, p0, p1, p2, p3, p4, p5); } // 0x01708E8DD3FF8C65 0x76AFFBB5 b1207
	NATIVE_DECL BOOL _NAVMESH_ACTIVATE_SWAP(const char* name) { return invoke<BOOL>(0x7C334FF4D9215912, name); } // 0x7C334FF4D9215912 b1207
	NATIVE_DECL BOOL _NAVMESH_DEACTIVATE_SWAP(const char* name) { return invoke<BOOL>(0x527B97C203BB8606, name); } // 0x527B97C203BB8606 b1207
	NATIVE_DECL BOOL _NAVMESH_IS_SWAP_ACTIVE(const char* name) { return invoke<BOOL>(0x5AC0944C156E5F44, name); } // 0x5AC0944C156E5F44 b1207
	NATIVE_DECL BOOL _NAVMESH_DOES_SWAP_EXIST(const char* name) { return invoke<BOOL>(0x495CFAB2924237C7, name); } // 0x495CFAB2924237C7 b1207
	NATIVE_DECL int _0x5A3B54ADDF5472A3(const char* p0) { return invoke<int>(0x5A3B54ADDF5472A3, p0); } // 0x5A3B54ADDF5472A3 b1207
	NATIVE_DECL Any* _0xA33914B00CA55756(const char* p0, int p1) { return invoke<Any*>(0xA33914B00CA55756, p0, p1); } // 0xA33914B00CA55756 b1207
	NATIVE_DECL BOOL _NAVMESH_ASSIGN_NAVMESH_TO_VEHICLE(Vehicle vehicle, const char* navMeshName) { return invoke<BOOL>(0x44026E3DB3CED602, vehicle, navMeshName); } // 0x44026E3DB3CED602 b1207
	NATIVE_DECL Any ADD_NAVMESH_BLOCKING_OBJECT(float p0, float p1, float p2, float p3, float p4, float p5, float p6, BOOL p7, Any p8) { return invoke<Any>(0xFCD5C8E06E502F5A, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0xFCD5C8E06E502F5A 0x2952BA56 b1207
	NATIVE_DECL void REMOVE_NAVMESH_BLOCKING_OBJECT(Any p0) { invoke<Void>(0x46399A7895957C0E, p0); } // 0x46399A7895957C0E 0x098602B0 b1207
	NATIVE_DECL BOOL DOES_NAVMESH_BLOCKING_OBJECT_EXIST(Any p0) { return invoke<BOOL>(0x0EAEB0DB4B132399, p0); } // 0x0EAEB0DB4B132399 0x4B67D7EE b1207
	NATIVE_DECL BOOL _ADD_NAVMESH_BLOCKING_VOLUME(Volume volume, int flags) { return invoke<BOOL>(0x19C7567D2F2287D6, volume, flags); } // 0x19C7567D2F2287D6 b1207
	NATIVE_DECL void _REMOVE_NAVMESH_BLOCKING_VOLUME(Volume volume) { invoke<Void>(0x2C87C3E1C7B96EE2, volume); } // 0x2C87C3E1C7B96EE2 b1207
	NATIVE_DECL BOOL _DOES_NAVMESH_BLOCKING_VOLUME_EXIST(Volume volume) { return invoke<BOOL>(0xDE0EA444735C1368, volume); } // 0xDE0EA444735C1368 b1207
	NATIVE_DECL void _0x6DAD6630AE4A74CB(Any p0, Any p1) { invoke<Void>(0x6DAD6630AE4A74CB, p0, p1); } // 0x6DAD6630AE4A74CB b1207
	NATIVE_DECL Any NAVMESH_REQUEST_PATH(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { return invoke<Any>(0x348F211CA2404039, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x348F211CA2404039 b1207
	NATIVE_DECL Any _0x661BB1E1FF77742D(Any p0) { return invoke<Any>(0x661BB1E1FF77742D, p0); } // 0x661BB1E1FF77742D b1207
	NATIVE_DECL Any _0x3A0F82F6EE2291C8(Any p0) { return invoke<Any>(0x3A0F82F6EE2291C8, p0); } // 0x3A0F82F6EE2291C8 b1207
	NATIVE_DECL Any _0x8800776E410EB669(Any p0) { return invoke<Any>(0x8800776E410EB669, p0); } // 0x8800776E410EB669 b1207
	NATIVE_DECL Any _0xF61CFEDEAB627BFA(Any p0) { return invoke<Any>(0xF61CFEDEAB627BFA, p0); } // 0xF61CFEDEAB627BFA b1207
	NATIVE_DECL Any _0xD470725E0703D22F(Any p0) { return invoke<Any>(0xD470725E0703D22F, p0); } // 0xD470725E0703D22F b1207
	NATIVE_DECL Vector3 _0x430F8319AE56C8A9(Any p0, Any p1) { return invoke<Vector3>(0x430F8319AE56C8A9, p0, p1); } // 0x430F8319AE56C8A9 b1207
	// Returns CGameWorldHeightMap's minimum Z value at specified point (grid node).
	NATIVE_DECL float GET_APPROX_FLOOR_FOR_POINT(float x, float y) { return invoke<float>(0x336511A34F2E5185, x, y); } // 0x336511A34F2E5185 0xA07C5B7D b1207
	NATIVE_DECL float GET_APPROX_FLOOR_FOR_POINT(Vector2 vec) { return invoke<float>(0x336511A34F2E5185, vec.x, vec.y); } // 0x336511A34F2E5185 0xA07C5B7D b1207
	NATIVE_DECL void SET_AMBIENT_PED_RANGE_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0x0B919E1FB47CC4E0, multiplier); } // 0x0B919E1FB47CC4E0 0x3C5085E4 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void SET_IGNORE_NO_GPS_FLAG(BOOL toggle) { invoke<Void>(0x72751156E7678833, toggle); } // 0x72751156E7678833 0xB72CF194 b1207
	NATIVE_DECL int GET_GPS_BLIP_ROUTE_LENGTH() { return invoke<int>(0xBBB45C3CF5C8AA85); } // 0xBBB45C3CF5C8AA85 0x4B770634 b1207
	NATIVE_DECL Any _0xEFC535C9FAF563B3(Any p0) { return invoke<Any>(0xEFC535C9FAF563B3, p0); } // 0xEFC535C9FAF563B3 b1207
	NATIVE_DECL Any _0x665B21666351CB37(Any p0, Any p1, Any p2) { return invoke<Any>(0x665B21666351CB37, p0, p1, p2); } // 0x665B21666351CB37 b1207
	NATIVE_DECL BOOL GET_GPS_BLIP_ROUTE_FOUND() { return invoke<BOOL>(0x869DAACBBE9FA006); } // 0x869DAACBBE9FA006 0x286F82CC b1207
	NATIVE_DECL Any _0x54F4D7B6670FBB5A(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0x54F4D7B6670FBB5A, p0, p1, p2, p3, p4); } // 0x54F4D7B6670FBB5A b1207
	NATIVE_DECL void _0x34C9AF25649172D0(Any p0) { invoke<Void>(0x34C9AF25649172D0, p0); } // 0x34C9AF25649172D0 b1207
	// GPS disabled zone: p1 = 0
	// Clearing GPS disabled zone: p1 = 1
	NATIVE_DECL void _0xF2A2177AC848B3A8(Volume volume, int p1, int p2) { invoke<Void>(0xF2A2177AC848B3A8, volume, p1, p2); } // 0xF2A2177AC848B3A8 b1207
	NATIVE_DECL void _0x4BDEBEA5702B97A9(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x4BDEBEA5702B97A9, p0, p1, p2, p3, p4, p5); } // 0x4BDEBEA5702B97A9 b1207
	NATIVE_DECL void _0x264E9A5CD78C338F(Any p0) { invoke<Void>(0x264E9A5CD78C338F, p0); } // 0x264E9A5CD78C338F b1207
	NATIVE_DECL void _0x869A7015BD4606E9(Any p0) { invoke<Void>(0x869A7015BD4606E9, p0); } // 0x869A7015BD4606E9 b1207
	NATIVE_DECL Any _0xFD5BB35AAB83FD48(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0xFD5BB35AAB83FD48, p0, p1, p2, p3, p4, p5, p6); } // 0xFD5BB35AAB83FD48 b1207
	NATIVE_DECL void _0x4907D0E4FB26EE65(Any p0) { invoke<Void>(0x4907D0E4FB26EE65, p0); } // 0x4907D0E4FB26EE65 b1207
	NATIVE_DECL Any _0x65A8196B8D7F5E0B(Any p0) { return invoke<Any>(0x65A8196B8D7F5E0B, p0); } // 0x65A8196B8D7F5E0B b1207
	NATIVE_DECL BOOL SIMULATED_ROUTE_IS_LOADED(Any p0) { return invoke<BOOL>(0x240915043CB799D7, p0); } // 0x240915043CB799D7 b1207
	NATIVE_DECL void SIMULATED_ROUTE_TRAVEL_TO_POINT(Any p0, float p1, float p2) { invoke<Void>(0xA1A3DE1C215C7394, p0, p1, p2); } // 0xA1A3DE1C215C7394 b1207
	NATIVE_DECL float SIMULATED_ROUTE_GET_ETA(Any p0) { return invoke<float>(0x2DD5F78D73B24172, p0); } // 0x2DD5F78D73B24172 b1207
}

namespace PED
{
	NATIVE_DECL Ped CREATE_PED(Hash modelHash, float x, float y, float z, float heading, BOOL isNetwork, BOOL bScriptHostPed, BOOL p7, BOOL p8) { return invoke<Ped>(0xD49F9B0955C367DE, modelHash, x, y, z, heading, isNetwork, bScriptHostPed, p7, p8); } // 0xD49F9B0955C367DE 0x0389EF71 b1207
	NATIVE_DECL Ped CREATE_PED(Hash modelHash, Vector3 vec, float heading, BOOL isNetwork, BOOL bScriptHostPed, BOOL p7, BOOL p8) { return invoke<Ped>(0xD49F9B0955C367DE, modelHash, vec.x, vec.y, vec.z, heading, isNetwork, bScriptHostPed, p7, p8); } // 0xD49F9B0955C367DE 0x0389EF71 b1207
	// Deletes the specified ped, then sets the handle pointed to by the pointer to NULL.
	NATIVE_DECL void DELETE_PED(Ped* ped) { invoke<Void>(0xCC0EF140F99365C5, ped); } // 0xCC0EF140F99365C5 0x13EFB9A0 b1207
	NATIVE_DECL void _SET_REMOVE_PED_NETWORKED(Ped ped, int p1) { invoke<Void>(0x39A2FC5AF55A52B1, ped, p1); } // 0x39A2FC5AF55A52B1 b1207
	// Only used in SP
	// _SET_REMOVE_PED*
	NATIVE_DECL void _0x7C08E7CB8D951B70(Ped ped, float p1) { invoke<Void>(0x7C08E7CB8D951B70, ped, p1); } // 0x7C08E7CB8D951B70 b1207
	NATIVE_DECL void _SET_PED_TO_BE_REMOVED(Ped ped, float p1, float p2, int p3, Any p4) { invoke<Void>(0x36E4B61DC56DE77C, ped, p1, p2, p3, p4); } // 0x36E4B61DC56DE77C b1207
	NATIVE_DECL Ped CLONE_PED(Ped ped, BOOL isNetwork, BOOL bScriptHostPed, BOOL copyHeadBlendFlag) { return invoke<Ped>(0xEF29A16337FACADB, ped, isNetwork, bScriptHostPed, copyHeadBlendFlag); } // 0xEF29A16337FACADB 0x8C8A8D6E b1207
	// Copies ped's components and props to targetPed.
	NATIVE_DECL void CLONE_PED_TO_TARGET(Ped ped, Ped targetPed) { invoke<Void>(0xE952D6431689AD9A, ped, targetPed); } // 0xE952D6431689AD9A 0xFC70EEC7 b1207
	// Gets a value indicating whether the specified ped is in the specified vehicle.
	NATIVE_DECL BOOL IS_PED_IN_VEHICLE(Ped ped, Vehicle vehicle, BOOL atGetIn) { return invoke<BOOL>(0xA3EE4A07279BB9DB, ped, vehicle, atGetIn); } // 0xA3EE4A07279BB9DB 0x7DA6BC83 b1207
	NATIVE_DECL BOOL IS_PED_IN_MODEL(Ped ped, Hash modelHash) { return invoke<BOOL>(0x796D90EFB19AA332, ped, modelHash); } // 0x796D90EFB19AA332 0xA6438D4B b1207
	// Gets a value indicating whether the specified ped is in any vehicle.
	NATIVE_DECL BOOL IS_PED_IN_ANY_VEHICLE(Ped ped, BOOL atGetIn) { return invoke<BOOL>(0x997ABD671D25CA0B, ped, atGetIn); } // 0x997ABD671D25CA0B 0x3B0171EE b1207
	NATIVE_DECL void _0x9851DE7AEC10B4E1(float x, float y, float z, float p3, int p4, Any p5) { invoke<Void>(0x9851DE7AEC10B4E1, x, y, z, p3, p4, p5); } // 0x9851DE7AEC10B4E1 b1207
	NATIVE_DECL void _0x9851DE7AEC10B4E1(Vector3 vec, float p3, int p4, Any p5) { invoke<Void>(0x9851DE7AEC10B4E1, vec.x, vec.y, vec.z, p3, p4, p5); } // 0x9851DE7AEC10B4E1 b1207
	// Gets a value indicating whether this ped's health is below its injured threshold.
	// 
	// The default threshold is 100.
	NATIVE_DECL BOOL IS_PED_INJURED(Ped ped) { return invoke<BOOL>(0x84A2DD9AC37C35C1, ped); } // 0x84A2DD9AC37C35C1 0x2530A087 b1207
	// Gets a value indicating whether this ped's health is below its fatally injured threshold. The default threshold is 100.
	// If the handle is invalid, the function returns true.
	NATIVE_DECL BOOL IS_PED_FATALLY_INJURED(Ped ped) { return invoke<BOOL>(0xD839450756ED5A80, ped); } // 0xD839450756ED5A80 0xBADA0093 b1207
	NATIVE_DECL BOOL IS_PED_DEAD_OR_DYING(Ped ped, BOOL p1) { return invoke<BOOL>(0x3317DEDB88C95038, ped, p1); } // 0x3317DEDB88C95038 0xCBDB7739 b1207
	// Bleedout profiles:
	// Animal_FastBleedout
	// Animal_Generic
	// Human_FastBleedout
	// Human_Generic
	// Human_Mission
	// 
	// For more information, see common/data/ai/peddamageinfo.meta
	NATIVE_DECL void _SET_PED_BLEEDOUT_PROFILE(Ped ped, Hash bleedoutProfile) { invoke<Void>(0x66C047719B0E80E1, ped, bleedoutProfile); } // 0x66C047719B0E80E1 b1207
	NATIVE_DECL BOOL IS_PED_AIMING_FROM_COVER(Ped ped) { return invoke<BOOL>(0x3998B1276A3300E5, ped); } // 0x3998B1276A3300E5 0xDEBAB2AF b1207
	// Returns whether the specified ped is reloading.
	NATIVE_DECL BOOL IS_PED_RELOADING(Ped ped) { return invoke<BOOL>(0x24B100C68C645951, ped); } // 0x24B100C68C645951 0x961E1745 b1207
	NATIVE_DECL BOOL IS_PED_A_PLAYER(Ped ped) { return invoke<BOOL>(0x12534C348C6CB68B, ped); } // 0x12534C348C6CB68B 0x404794CA b1207
	// Returns true only if it's a player ped and an animal as well.
	// _IS_ANY_* - _IS_CONTROL_*
	NATIVE_DECL BOOL _IS_ANIMAL_CONTROLLED_BY_A_PLAYER(Ped ped) { return invoke<BOOL>(0x0E2F43516F998269, ped); } // 0x0E2F43516F998269 b1311
	// seatIndex:
	// enum eVehicleSeat
	// {
	// 	VS_ANY_PASSENGER = -2,
	// 	VS_DRIVER,
	// 	VS_FRONT_RIGHT,
	// 	VS_BACK_LEFT,
	// 	VS_BACK_RIGHT,
	// 	VS_EXTRA_LEFT_1,
	// 	VS_EXTRA_RIGHT_1,
	// 	VS_EXTRA_LEFT_2,
	// 	VS_EXTRA_RIGHT_2,
	// 	VS_EXTRA_LEFT_3,
	// 	VS_EXTRA_RIGHT_3,
	// 	VS_NUM_SEATS
	// };
	NATIVE_DECL Ped CREATE_PED_INSIDE_VEHICLE(Vehicle vehicle, Hash modelHash, int seatIndex, BOOL p3, BOOL p4, BOOL p5) { return invoke<Ped>(0x7DD959874C1FD534, vehicle, modelHash, seatIndex, p3, p4, p5); } // 0x7DD959874C1FD534 0x3000F092 b1207
	NATIVE_DECL void SET_PED_DESIRED_HEADING(Ped ped, float heading) { invoke<Void>(0xAA5A7ECE2AA8FE70, ped, heading); } // 0xAA5A7ECE2AA8FE70 0x961458F9 b1207
	NATIVE_DECL void _FREEZE_PED_CAMERA_ROTATION(Ped ped) { invoke<Void>(0xFF287323B0E2C69A, ped); } // 0xFF287323B0E2C69A 0x290421BE b1207
	// angle is ped's view cone
	NATIVE_DECL BOOL IS_PED_FACING_PED(Ped ped, Ped otherPed, float angle) { return invoke<BOOL>(0xD71649DB0A545AA3, ped, otherPed, angle); } // 0xD71649DB0A545AA3 0x0B775838 b1207
	// Notes: The function only returns true while the ped is: 
	// A.) Swinging a random melee attack (including pistol-whipping)
	// 
	// B.) Reacting to being hit by a melee attack (including pistol-whipping)
	// 
	// C.) Is locked-on to an enemy (arms up, strafing/skipping in the default fighting-stance, ready to dodge+counter). 
	// 
	// You don't have to be holding the melee-targeting button to be in this stance; you stay in it by default for a few seconds after swinging at someone. If you do a sprinting punch, it returns true for the duration of the punch animation and then returns false again, even if you've punched and made-angry many peds
	NATIVE_DECL BOOL IS_PED_IN_MELEE_COMBAT(Ped ped) { return invoke<BOOL>(0x4E209B2C1EAD5159, ped); } // 0x4E209B2C1EAD5159 0xFD7814A5 b1207
	// Only used in R* SP Script winter1: p1 = 5000
	// _SET_PED_M*
	NATIVE_DECL Any _0x6DB875AFC584FA32(Ped ped, int p1) { return invoke<Any>(0x6DB875AFC584FA32, ped, p1); } // 0x6DB875AFC584FA32 b1207
	NATIVE_DECL BOOL IS_PED_STOPPED(Ped ped) { return invoke<BOOL>(0x530944F6F4B8A214, ped); } // 0x530944F6F4B8A214 0xA0DC0B87 b1207
	NATIVE_DECL BOOL IS_PED_SITTING(Ped ped) { return invoke<BOOL>(0x84D0BF2B21862059, ped); } // 0x84D0BF2B21862059 b1207
	NATIVE_DECL BOOL _0x09D7AFD3716DA8E1(Ped ped, int p1) { return invoke<BOOL>(0x09D7AFD3716DA8E1, ped, p1); } // 0x09D7AFD3716DA8E1 b1207
	// If returned true: CHECK_SHOT_NEAR: Succeeded shot near
	// If returned false: CHECK_SHOT_NEAR: Failed shot near
	NATIVE_DECL BOOL _0x9C81338B2E62CE0A(Player player, Ped ped, int shotNearRecentlyTime) { return invoke<BOOL>(0x9C81338B2E62CE0A, player, ped, shotNearRecentlyTime); } // 0x9C81338B2E62CE0A b1207
	NATIVE_DECL BOOL _0xB7DBB2986B87E230(Ped ped, float p1) { return invoke<BOOL>(0xB7DBB2986B87E230, ped, p1); } // 0xB7DBB2986B87E230 b1207
	NATIVE_DECL BOOL _0xD355E2F1BB41087E(Ped ped, float p1) { return invoke<BOOL>(0xD355E2F1BB41087E, ped, p1); } // 0xD355E2F1BB41087E b1207
	NATIVE_DECL BOOL IS_ANY_PED_SHOOTING_IN_AREA(float x1, float y1, float z1, float x2, float y2, float z2, BOOL p6, BOOL p7) { return invoke<BOOL>(0xA0D3D71EA1086C55, x1, y1, z1, x2, y2, z2, p6, p7); } // 0xA0D3D71EA1086C55 0x91833867 b1207
	NATIVE_DECL BOOL IS_ANY_PED_SHOOTING_IN_AREA(Vector3 vec1, Vector3 vec2, BOOL p6, BOOL p7) { return invoke<BOOL>(0xA0D3D71EA1086C55, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, p6, p7); } // 0xA0D3D71EA1086C55 0x91833867 b1207
	// Returns whether the specified ped is shooting.
	NATIVE_DECL BOOL IS_PED_SHOOTING(Ped ped) { return invoke<BOOL>(0x34616828CD07F1A1, ped); } // 0x34616828CD07F1A1 0xE7C3405E b1207
	// Returns time since the specified ped last shot, in seconds. (fPlayerJustShotTime)
	NATIVE_DECL float TIME_SINCE_PED_LAST_SHOT(Ped ped) { return invoke<float>(0x285D36C5C72B0569, ped); } // 0x285D36C5C72B0569 b1207
	// accuracy = 0-100, 100 being perfectly accurate
	NATIVE_DECL void SET_PED_ACCURACY(Ped ped, int accuracy) { invoke<Void>(0x7AEFB85C1D49DEB6, ped, accuracy); } // 0x7AEFB85C1D49DEB6 0x6C17122E b1207
	NATIVE_DECL int GET_PED_ACCURACY(Ped ped) { return invoke<int>(0x37F4AD56ECBC0CD6, ped); } // 0x37F4AD56ECBC0CD6 0x0A2A0AA0 b1207
	NATIVE_DECL BOOL IS_PED_MODEL(Ped ped, Hash modelHash) { return invoke<BOOL>(0xC9D55B1A358A5BF7, ped, modelHash); } // 0xC9D55B1A358A5BF7 0x5F1DDFCB b1207
	// Forces the ped to fall back and kills it.
	// 
	// It doesn't really explode the ped's head but it kills the ped
	NATIVE_DECL void EXPLODE_PED_HEAD(Ped ped, Hash weaponHash) { invoke<Void>(0x2D05CED3A38D0F3A, ped, weaponHash); } // 0x2D05CED3A38D0F3A 0x05CC1380 b1207
	// Same as SET_PED_ARMOUR, but ADDS 'amount' to the armor the Ped already has.
	NATIVE_DECL void ADD_ARMOUR_TO_PED(Ped ped, int amount) { invoke<Void>(0x5BA652A0CD14DF2F, ped, amount); } // 0x5BA652A0CD14DF2F 0xF686B26E b1207
	NATIVE_DECL void _0x5CA20FBE49891BBD(Ped ped, int p1) { invoke<Void>(0x5CA20FBE49891BBD, ped, p1); } // 0x5CA20FBE49891BBD b1207
	// Ped: The ped to warp.
	// vehicle: The vehicle to warp the ped into.
	// seatIndex: see CREATE_PED_INSIDE_VEHICLE
	NATIVE_DECL void SET_PED_INTO_VEHICLE(Ped ped, Vehicle vehicle, int seatIndex) { invoke<Void>(0xF75B0D629E1C063D, ped, vehicle, seatIndex); } // 0xF75B0D629E1C063D 0x07500C79 b1207
	NATIVE_DECL void SET_PED_MOVE_ANIMS_BLEND_OUT(Ped ped) { invoke<Void>(0x9E8C908F41584ECD, ped); } // 0x9E8C908F41584ECD 0x20E01957 b1207
	// Not implemented.
	NATIVE_DECL void _0x606D529DADA3C940(Ped ped, Any p1) { invoke<Void>(0x606D529DADA3C940, ped, p1); } // 0x606D529DADA3C940 b1207
	// Returns true/false if the ped is/isn't male.
	NATIVE_DECL BOOL IS_PED_MALE(Ped ped) { return invoke<BOOL>(0x6D9F5FAA7488BA46, ped); } // 0x6D9F5FAA7488BA46 0x90950455 b1207
	// Returns true/false if the ped is/isn't humanoid.
	NATIVE_DECL BOOL IS_PED_HUMAN(Ped ped) { return invoke<BOOL>(0xB980061DA992779D, ped); } // 0xB980061DA992779D 0x194BB7B0 b1207
	// Gets the vehicle the specified Ped is in.
	// 
	// If the Ped is not in a vehicle and includeLastVehicle is true, the vehicle they were last in is returned.
	NATIVE_DECL Vehicle GET_VEHICLE_PED_IS_IN(Ped ped, BOOL lastVehicle) { return invoke<Vehicle>(0x9A9112A0FE9A4713, ped, lastVehicle); } // 0x9A9112A0FE9A4713 0xAFE92319 b1207
	// Resets the value for the last vehicle driven by the Ped.
	NATIVE_DECL void RESET_PED_LAST_VEHICLE(Ped ped) { invoke<Void>(0xBB8DE8CF6A8DD8BB, ped); } // 0xBB8DE8CF6A8DD8BB 0x5E3B5942 b1207
	NATIVE_DECL void _0xC6136B40FFFB778B(BOOL p0) { invoke<Void>(0xC6136B40FFFB778B, p0); } // 0xC6136B40FFFB778B b1207
	// Only used in SP R* Script train_robbery3: p1 = CLIPSET@VEH_TRAIN@HANDCART@BASE_PANIC & CLIPSET@VEH_TRAIN@HANDCART@BASE_PANIC_JOHN
	NATIVE_DECL void _0x6E8B87139854022D(Ped ped, const char* clipset) { invoke<Void>(0x6E8B87139854022D, ped, clipset); } // 0x6E8B87139854022D b1207
	NATIVE_DECL int _GET_NUM_FREE_SLOTS_IN_PED_POOL() { return invoke<int>(0x313778EDCA9158E2); } // 0x313778EDCA9158E2 b1207
	NATIVE_DECL void _RESERVE_AMBIENT_PEDS(int numPeds) { invoke<Void>(0xED9582B3DA8F02B4, numPeds); } // 0xED9582B3DA8F02B4 b1207
	NATIVE_DECL void _RESERVE_AMBIENT_PEDS_TOTAL(int numPeds) { invoke<Void>(0xF008E0BA1FE1D644, numPeds); } // 0xF008E0BA1FE1D644 b1207
	NATIVE_DECL void _UNRESERVE_AMBIENT_PEDS(int numPeds) { invoke<Void>(0x7D4E70A67A651C71, numPeds); } // 0x7D4E70A67A651C71 b1207
	NATIVE_DECL int _GET_NUM_RESERVED_AMBIENT_PEDS_DESIRED() { return invoke<int>(0x62DE46F061CAA468); } // 0x62DE46F061CAA468 b1207
	NATIVE_DECL int _GET_NUM_RESERVED_AMBIENT_PEDS_READY() { return invoke<int>(0x5C16855277819BBF); } // 0x5C16855277819BBF b1207
	NATIVE_DECL BOOL _ARE_ALL_AMBIENT_PED_RESERVATIONS_READY() { return invoke<BOOL>(0x5E420FF293EE5472); } // 0x5E420FF293EE5472 b1207
	NATIVE_DECL void _SET_SCENARIO_PED_RANGE_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0xA77FA7BE9312F8C0, multiplier); } // 0xA77FA7BE9312F8C0 b1207
	// Only used in SP R* Script loanshark_hunter
	NATIVE_DECL void _0x9E3842E5DAD69F80(Volume volume) { invoke<Void>(0x9E3842E5DAD69F80, volume); } // 0x9E3842E5DAD69F80 b1207
	NATIVE_DECL void _SET_AMBIENT_PED_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0xAB0D553FE20A6E25, multiplier); } // 0xAB0D553FE20A6E25 b1207
	NATIVE_DECL void SET_SCENARIO_PED_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0x7A556143A1C03898, multiplier); } // 0x7A556143A1C03898 0x2909ABF0 b1207
	NATIVE_DECL void _SET_AMBIENT_ANIMAL_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0xC0258742B034DFAF, multiplier); } // 0xC0258742B034DFAF b1207
	NATIVE_DECL void _SET_AMBIENT_HUMAN_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0xBA0980B5C0A11924, multiplier); } // 0xBA0980B5C0A11924 b1207
	NATIVE_DECL void _SET_SCENARIO_ANIMAL_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0xDB48E99F8E064E56, multiplier); } // 0xDB48E99F8E064E56 b1207
	NATIVE_DECL void _SET_SCENARIO_HUMAN_DENSITY_MULTIPLIER_THIS_FRAME(float multiplier) { invoke<Void>(0x28CB6391ACEDD9DB, multiplier); } // 0x28CB6391ACEDD9DB b1207
	// Sets the scenario ped density to the given config.
	// 
	// Valid configs:
	// - BLACKWATER
	// - DEFAULT
	// - NEWBORDEAUX
	// - RHODES
	// - STRAWBERRY
	// - TUMBLEWEED
	// - VALENTINE
	// - VANHORN
	// 
	// See common/data/ai/densityscoringconfigs.meta for more information.
	NATIVE_DECL void _SET_SCENARIO_PED_DENSITY_THIS_FRAME(Hash configHash) { invoke<Void>(0x95423627A9CA598E, configHash); } // 0x95423627A9CA598E b1207
	NATIVE_DECL void INSTANTLY_FILL_PED_POPULATION() { invoke<Void>(0x4759CC730F947C81); } // 0x4759CC730F947C81 0x8C555ADD b1207
	// Only used in R* Script tg_p (CLIENT__AMBIENT_POPULATION - Player starts the populate in region)
	NATIVE_DECL void _0xBFA6B7731C3BAF02() { invoke<Void>(0xBFA6B7731C3BAF02); } // 0xBFA6B7731C3BAF02 b1207
	NATIVE_DECL BOOL IS_INSTANTLY_FILL_PED_POPULATION_FINISHED() { return invoke<BOOL>(0x0EE3F0D7FECCC54F); } // 0x0EE3F0D7FECCC54F b1207
	// The distance between these points, is the diagonal of a box (remember it's 3D).
	NATIVE_DECL void SET_PED_NON_CREATION_AREA(float x1, float y1, float z1, float x2, float y2, float z2) { invoke<Void>(0xEE01041D559983EA, x1, y1, z1, x2, y2, z2); } // 0xEE01041D559983EA 0x7A97283F b1207
	NATIVE_DECL void SET_PED_NON_CREATION_AREA(Vector3 vec1, Vector3 vec2) { invoke<Void>(0xEE01041D559983EA, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0xEE01041D559983EA 0x7A97283F b1207
	NATIVE_DECL void CLEAR_PED_NON_CREATION_AREA() { invoke<Void>(0x2E05208086BA0651); } // 0x2E05208086BA0651 0x6F7043A3 b1207
	NATIVE_DECL void _ATTACH_VOLUME_TO_ENTITY(Volume volume, Entity entity, float offsetX, float offsetY, float offsetZ, float rotX, float rotY, float rotZ, int p8, BOOL p9) { invoke<Void>(0x7C00CFC48A782DC0, volume, entity, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, p8, p9); } // 0x7C00CFC48A782DC0 b1207
	NATIVE_DECL void _ATTACH_VOLUME_TO_ENTITY(Volume volume, Entity entity, Vector3 offset, Vector3 rot, int p8, BOOL p9) { invoke<Void>(0x7C00CFC48A782DC0, volume, entity, offset.x, offset.y, offset.z, rot.x, rot.y, rot.z, p8, p9); } // 0x7C00CFC48A782DC0 b1207
	NATIVE_DECL void _DETACH_VOLUME_FROM_ENTITY(Volume volume, Entity entity) { invoke<Void>(0x19C975B81BE53C28, volume, entity); } // 0x19C975B81BE53C28 b1207
	NATIVE_DECL void SET_PED_ONTO_MOUNT(Ped ped, Ped mount, int seatIndex, BOOL p3) { invoke<Void>(0x028F76B6E78246EB, ped, mount, seatIndex, p3); } // 0x028F76B6E78246EB b1207
	NATIVE_DECL void _REMOVE_PED_FROM_MOUNT(Ped ped, BOOL p1, BOOL p2) { invoke<Void>(0x5337B721C51883A9, ped, p1, p2); } // 0x5337B721C51883A9 b1207
	NATIVE_DECL Ped CREATE_PED_ON_MOUNT(Ped mount, Hash modelHash, int index, BOOL p3, BOOL p4, BOOL p5, BOOL p6) { return invoke<Ped>(0xF89AA2BD01FC06B7, mount, modelHash, index, p3, p4, p5, p6); } // 0xF89AA2BD01FC06B7 b1207
	NATIVE_DECL BOOL _IS_MOUNT_SEAT_FREE(Ped mount, int seat) { return invoke<BOOL>(0xAAB0FE202E9FC9F0, mount, seat); } // 0xAAB0FE202E9FC9F0 b1207
	NATIVE_DECL BOOL IS_PED_ON_MOUNT(Ped ped) { return invoke<BOOL>(0x460BC76A0E10655E, ped); } // 0x460BC76A0E10655E 0x43103006 b1207
	NATIVE_DECL BOOL IS_PED_FULLY_ON_MOUNT(Ped ped, BOOL p1) { return invoke<BOOL>(0x95CBC65780DE7EB1, ped, p1); } // 0x95CBC65780DE7EB1 b1207
	NATIVE_DECL Ped GET_MOUNT(Ped ped) { return invoke<Ped>(0xE7E11B8DCBED1058, ped); } // 0xE7E11B8DCBED1058 0xDD31EC4E b1207
	// Returns last horse the ped was leading
	NATIVE_DECL Ped _GET_LAST_LED_MOUNT(Ped ped) { return invoke<Ped>(0x693126B5D0457D0D, ped); } // 0x693126B5D0457D0D b1232
	NATIVE_DECL Ped _GET_LAST_MOUNT(Ped ped) { return invoke<Ped>(0x4C8B59171957BCF7, ped); } // 0x4C8B59171957BCF7 b1207
	// Only used in R* Script nb_stalking_hunter
	NATIVE_DECL void _0xED1C764997A86D5A(Ped ped1, Ped ped2) { invoke<Void>(0xED1C764997A86D5A, ped1, ped2); } // 0xED1C764997A86D5A b1207
	// _SET_HO*
	NATIVE_DECL void _0xB8AB265426CFE6DD(Ped ped, BOOL p1) { invoke<Void>(0xB8AB265426CFE6DD, ped, p1); } // 0xB8AB265426CFE6DD b1207
	// Returns dismounted timestamp
	NATIVE_DECL int _0xE8D1CCB9375C101B(Ped mount, Player player) { return invoke<int>(0xE8D1CCB9375C101B, mount, player); } // 0xE8D1CCB9375C101B b1207
	NATIVE_DECL void _0xA691C10054275290(Ped mount, Player player, int dismountedTimestamp) { invoke<Void>(0xA691C10054275290, mount, player, dismountedTimestamp); } // 0xA691C10054275290 b1207
	NATIVE_DECL void _0x6734F0A6A52C371C(Player player, int horseSlot) { invoke<Void>(0x6734F0A6A52C371C, player, horseSlot); } // 0x6734F0A6A52C371C b1207
	NATIVE_DECL void _0x024EC9B649111915(Ped ped, BOOL p1) { invoke<Void>(0x024EC9B649111915, ped, p1); } // 0x024EC9B649111915 b1207
	NATIVE_DECL void SET_PED_OWNS_ANIMAL(Ped ped, Ped animal, BOOL p2) { invoke<Void>(0x931B241409216C1F, ped, animal, p2); } // 0x931B241409216C1F b1207
	NATIVE_DECL Ped _GET_ACTIVE_ANIMAL_OWNER(Ped animal) { return invoke<Ped>(0xF103823FFE72BB49, animal); } // 0xF103823FFE72BB49 b1207
	NATIVE_DECL void _0xBCC76708E5677E1D(Ped ped, BOOL p1) { invoke<Void>(0xBCC76708E5677E1D, ped, p1); } // 0xBCC76708E5677E1D b1207
	// Returns an int based on enum eTamingState
	// 
	// enum eTamingState
	// {
	// 	ATS_INVALID = 0,
	// 	ATS_INACTIVE,
	// 	ATS_TARGET_DETECTED,
	// 	ATS_CALLED_OUT,
	// 	ATS_MOUNTABLE,
	// 	ATS_BEING_PATTED,
	// 	ATS_BREAKING_ACTIVE,
	// 	ATS_SPOOKED,
	// 	ATS_RETREATING,
	// 	ATS_FLEEING
	// };
	NATIVE_DECL int _GET_HORSE_TAMING_STATE(Ped horse) { return invoke<int>(0x454AD4DA6C41B5BD, horse); } // 0x454AD4DA6C41B5BD b1207
	NATIVE_DECL void _0x54D3CD482742C482(Ped animal, float p2) { invoke<Void>(0x54D3CD482742C482, animal, p2); } // 0x54D3CD482742C482 b1355
	NATIVE_DECL void _0x5CB2EBB467BE3ED6(Ped animal, float p2) { invoke<Void>(0x5CB2EBB467BE3ED6, animal, p2); } // 0x5CB2EBB467BE3ED6 b1355
	NATIVE_DECL void _0x9F0F28B42C4EE80A(Ped animal, float p2) { invoke<Void>(0x9F0F28B42C4EE80A, animal, p2); } // 0x9F0F28B42C4EE80A b1355
	NATIVE_DECL void _SET_MOUNT_BONDING_LEVEL(Ped ped, int bondingLevel) { invoke<Void>(0xA69899995997A63B, ped, bondingLevel); } // 0xA69899995997A63B b1207
	// Note: this native was added in build 1232.40
	NATIVE_DECL void _SET_MOUNT_SECURITY_ENABLED(Ped ped, BOOL toggle) { invoke<Void>(0x11E6B9629C46D6EC, ped, toggle); } // 0x11E6B9629C46D6EC b1232
	// Only used in SP R* Script winter1: p1 = Winter1Mount
	NATIVE_DECL void _0x9B65444C07B782BF(Ped ped, const char* p1) { invoke<Void>(0x9B65444C07B782BF, ped, p1); } // 0x9B65444C07B782BF b1207
	NATIVE_DECL BOOL IS_ANIMAL_INTERACTION_POSSIBLE(Ped ped, Ped animal) { return invoke<BOOL>(0xD543D3A8FDE4F185, ped, animal); } // 0xD543D3A8FDE4F185 b1207
	NATIVE_DECL BOOL _IS_ANIMAL_INTERACTION_RUNNING(Ped ped) { return invoke<BOOL>(0x7FC84E85D98F063D, ped); } // 0x7FC84E85D98F063D b1207
	NATIVE_DECL Ped _0x8BE24D74D74C6E9B(Ped ped) { return invoke<Ped>(0x8BE24D74D74C6E9B, ped); } // 0x8BE24D74D74C6E9B b1207
	// _IS_I* - _IS_L*
	NATIVE_DECL BOOL _0x77243ED4F7CAAA55(Ped ped) { return invoke<BOOL>(0x77243ED4F7CAAA55, ped); } // 0x77243ED4F7CAAA55 b1207
	// Gets a value indicating whether the specified ped is on top of any vehicle.
	// 
	// Return 1 when ped is on vehicle.
	// Return 0 when ped is not on a vehicle.
	NATIVE_DECL BOOL IS_PED_ON_VEHICLE(Ped ped, BOOL p1) { return invoke<BOOL>(0x67722AEB798E5FAB, ped, p1); } // 0x67722AEB798E5FAB 0xA1AE7CC7 b1207
	NATIVE_DECL BOOL IS_PED_ON_SPECIFIC_VEHICLE(Ped ped, Vehicle vehicle) { return invoke<BOOL>(0xEC5F66E459AF3BB2, ped, vehicle); } // 0xEC5F66E459AF3BB2 0x63CB4603 b1207
	NATIVE_DECL void _WARP_PED_OUT_OF_VEHICLE(Ped ped) { invoke<Void>(0xE0B61ED8BB37712F, ped); } // 0xE0B61ED8BB37712F b1207
	NATIVE_DECL void SET_PED_MONEY(Ped ped, int amount) { invoke<Void>(0xA9C8960E8684C1B5, ped, amount); } // 0xA9C8960E8684C1B5 0x40D90BF2 b1207
	NATIVE_DECL int GET_PED_MONEY(Ped ped) { return invoke<int>(0x3F69145BBA87BAE7, ped); } // 0x3F69145BBA87BAE7 0xEB3C4C7E b1207
	// _SET_B*
	NATIVE_DECL void _0x9911F4A24485F653(BOOL p0) { invoke<Void>(0x9911F4A24485F653, p0); } // 0x9911F4A24485F653 0x02A080C8 b1207
	NATIVE_DECL void _0x34EDDD59364AD74A(Ped ped, Any* p1) { invoke<Void>(0x34EDDD59364AD74A, ped, p1); } // 0x34EDDD59364AD74A b1207
	NATIVE_DECL void _0x2D976DBDC731DF80(Ped ped) { invoke<Void>(0x2D976DBDC731DF80, ped); } // 0x2D976DBDC731DF80 b1207
	// Detect if ped is sitting in the specified vehicle
	// [True/False]
	NATIVE_DECL BOOL IS_PED_SITTING_IN_VEHICLE(Ped ped, Vehicle vehicle) { return invoke<BOOL>(0xA808AA1D79230FC2, ped, vehicle); } // 0xA808AA1D79230FC2 0xDDDE26FA b1207
	// Detect if ped is in any vehicle
	// [True/False]
	NATIVE_DECL BOOL IS_PED_SITTING_IN_ANY_VEHICLE(Ped ped) { return invoke<BOOL>(0x826AA586EDB9FEF8, ped); } // 0x826AA586EDB9FEF8 0x0EA9CA03 b1207
	NATIVE_DECL BOOL IS_PED_ON_FOOT(Ped ped) { return invoke<BOOL>(0x01FEE67DB37F59B2, ped); } // 0x01FEE67DB37F59B2 0xC60D0785 b1207
	NATIVE_DECL BOOL IS_PED_PLANTING_BOMB(Ped ped) { return invoke<BOOL>(0xC70B5FAE151982D8, ped); } // 0xC70B5FAE151982D8 0x0EDAC574 b1207
	NATIVE_DECL Vector3 GET_DEAD_PED_PICKUP_COORDS(Ped ped, float p1, float p2) { return invoke<Vector3>(0xCD5003B097200F36, ped, p1, p2); } // 0xCD5003B097200F36 0x129F9DC1 b1207
	NATIVE_DECL BOOL IS_PED_IN_ANY_BOAT(Ped ped) { return invoke<BOOL>(0x2E0E1C2B4F6CB339, ped); } // 0x2E0E1C2B4F6CB339 0x1118A947 b1207
	NATIVE_DECL BOOL IS_PED_IN_ANY_HELI(Ped ped) { return invoke<BOOL>(0x298B91AE825E5705, ped); } // 0x298B91AE825E5705 0x7AB5523B b1207
	NATIVE_DECL BOOL IS_PED_IN_ANY_PLANE(Ped ped) { return invoke<BOOL>(0x5FFF4CFC74D8FB80, ped); } // 0x5FFF4CFC74D8FB80 0x51BBCE7E b1207
	NATIVE_DECL BOOL IS_PED_IN_FLYING_VEHICLE(Ped ped) { return invoke<BOOL>(0x9134873537FA419C, ped); } // 0x9134873537FA419C 0xCA072485 b1207
	// _IS_PED_FL* - _IS_PED_FU*
	NATIVE_DECL BOOL _0x256EDD55C6BE1482(Ped ped) { return invoke<BOOL>(0x256EDD55C6BE1482, ped); } // 0x256EDD55C6BE1482 b1207
	NATIVE_DECL BOOL GET_PED_LAST_DAMAGE_BONE(Ped ped, int* outBone) { return invoke<BOOL>(0xD75960F6BD9EA49C, ped, outBone); } // 0xD75960F6BD9EA49C 0xAB933841 b1207
	NATIVE_DECL void CLEAR_PED_LAST_DAMAGE_BONE(Ped ped) { invoke<Void>(0x8EF6B7AC68E2F01B, ped); } // 0x8EF6B7AC68E2F01B 0x56CB715E b1207
	// enum ePedDamageCleanliness
	// {
	// 	PED_DAMAGE_CLEANLINESS_POOR,
	// 	PED_DAMAGE_CLEANLINESS_GOOD,
	// 	PED_DAMAGE_CLEANLINESS_PERFECT
	// };
	NATIVE_DECL int _GET_PED_DAMAGE_CLEANLINESS(Ped ped) { return invoke<int>(0x88EFFED5FE8B0B4A, ped); } // 0x88EFFED5FE8B0B4A b1207
	// damageCleanliness: see _GET_PED_DAMAGE_CLEANLINESS
	NATIVE_DECL void _SET_PED_DAMAGE_CLEANLINESS(Ped ped, int damageCleanliness) { invoke<Void>(0x7528720101A807A5, ped, damageCleanliness); } // 0x7528720101A807A5 b1207
	// Returns true if _GET_PED_DAMAGE_CLEANLINESS was ever lower than 2
	NATIVE_DECL BOOL _GET_PED_DAMAGED(Ped ped) { return invoke<BOOL>(0x6CFC373008A1EDAF, ped); } // 0x6CFC373008A1EDAF b1207
	NATIVE_DECL void _SET_PED_DAMAGED(Ped ped, BOOL damaged) { invoke<Void>(0xDACE03C65C6666DB, ped, damaged); } // 0xDACE03C65C6666DB b1207
	// Animal Skin Quality Modifier
	// Params: p2 = 2, p3 = 3 in R* Scripts
	NATIVE_DECL Any _SET_PLAYER_CURRENT_ANIMAL_DAMAGE_MODIFIER(Player player, float modifier, int p2, int p3) { return invoke<Any>(0x9EFF3C91DF38304F, player, modifier, p2, p3); } // 0x9EFF3C91DF38304F b1311
	NATIVE_DECL void _UPDATE_ANIMAL_DAMAGE_MODIFIER(Player player) { invoke<Void>(0x0F9E754EBE8FDBFA, player); } // 0x0F9E754EBE8FDBFA b1311
	// Returns animal skin quality modifier
	NATIVE_DECL float _GET_PLAYER_CURRENT_ANIMAL_DAMAGE_MODIFIER(Player player) { return invoke<float>(0xEE2D5C819A65BF26, player); } // 0xEE2D5C819A65BF26 b1311
	// Used in Script Function SATCHEL_COUNT_BREAKDOWN_COMPONENTS
	NATIVE_DECL Any _0xB29C553BA582D09E(Any* p0, Hash model, int damageCleanliness, int p3) { return invoke<Any>(0xB29C553BA582D09E, p0, model, damageCleanliness, p3); } // 0xB29C553BA582D09E b1207
	NATIVE_DECL BOOL _0x101B45C5F56D970F(Any* p0, Ped ped, int damageCleanliness, int p3) { return invoke<BOOL>(0x101B45C5F56D970F, p0, ped, damageCleanliness, p3); } // 0x101B45C5F56D970F b1207
	// Related to dead animals items/loots
	// Notice: skinningQuality is partially calculated using pedQuality
	NATIVE_DECL int _COMPUTE_SATCHEL_ITEM_FOR_PED_CARCASS(Any* outInventoryItemArray, Ped ped, int damageCleanliness, int skinningQuality) { return invoke<int>(0x6B89FAA36FC909A3, outInventoryItemArray, ped, damageCleanliness, skinningQuality); } // 0x6B89FAA36FC909A3 b1207
	NATIVE_DECL BOOL COMPUTE_SATCHEL_ITEM_FOR_PED_DAMAGE(Any p0, Ped pedAttached, int damageCleanliness) { return invoke<BOOL>(0x9E7738B291706746, p0, pedAttached, damageCleanliness); } // 0x9E7738B291706746 b1207
	NATIVE_DECL void SET_AI_WEAPON_DAMAGE_MODIFIER(float value) { invoke<Void>(0x1B1E2A40A65B8521, value); } // 0x1B1E2A40A65B8521 0x516E30EE b1207
	NATIVE_DECL void RESET_AI_WEAPON_DAMAGE_MODIFIER() { invoke<Void>(0xEA16670E7BA4743C); } // 0xEA16670E7BA4743C 0x6E965420 b1207
	// _SET_W(EAPON?)*
	NATIVE_DECL void _SET_TOTAL_PED_DAMAGE_FROM_AI(Ped ped, float totalDamage) { invoke<Void>(0x73B6F907B913C860, ped, totalDamage); } // 0x73B6F907B913C860 b1207
	// _DELETE_*
	NATIVE_DECL void _0xA6D6F03095C88F59(Ped ped) { invoke<Void>(0xA6D6F03095C88F59, ped); } // 0xA6D6F03095C88F59 b1207
	// _GET_WA*
	NATIVE_DECL float _GET_TOTAL_PED_DAMAGE_FROM_AI(Ped ped) { return invoke<float>(0x92C8EACA29F6BED6, ped); } // 0x92C8EACA29F6BED6 b1207
	// Old name: _SET_PED_DAMAGE_MODIFIER
	NATIVE_DECL void SET_PED_TO_PLAYER_WEAPON_DAMAGE_MODIFIER(Ped ped, float damageModifier) { invoke<Void>(0xD77AE48611B7B10A, ped, damageModifier); } // 0xD77AE48611B7B10A b1207
	NATIVE_DECL float GET_PED_TO_PLAYER_WEAPON_DAMAGE_MODIFIER(Ped ped) { return invoke<float>(0x936E7CAD0AE2EE14, ped); } // 0x936E7CAD0AE2EE14 b1207
	NATIVE_DECL void _SET_CURRENT_DEFENSE_AGAINST_PLAYERS_MODIFIER(Ped horse, float modifier) { invoke<Void>(0x069EDDF1FD4DEB0A, horse, modifier); } // 0x069EDDF1FD4DEB0A b1207
	NATIVE_DECL float _0x763FA8A9D76EE3A7(Ped ped) { return invoke<float>(0x763FA8A9D76EE3A7, ped); } // 0x763FA8A9D76EE3A7 b1311
	NATIVE_DECL void SET_AI_MELEE_WEAPON_DAMAGE_MODIFIER(float modifier) { invoke<Void>(0x66460DEDDD417254, modifier); } // 0x66460DEDDD417254 0x0F9A401F b1207
	NATIVE_DECL void _SET_ACCURACY_AGAINST_LOCAL_PLAYER_MODIFIER(Ped ped, float modifier) { invoke<Void>(0xC2266AA617668AD3, ped, modifier); } // 0xC2266AA617668AD3 b1207
	NATIVE_DECL float _0xDC9273D95976BA22(Ped ped) { return invoke<float>(0xDC9273D95976BA22, ped); } // 0xDC9273D95976BA22 b1207
	NATIVE_DECL void _SET_PED_HEADSHOT_DAMAGE_MULTIPLIER(Ped ped, float multiplier) { invoke<Void>(0x2BA918C823B8BA56, ped, multiplier); } // 0x2BA918C823B8BA56 b1207
	NATIVE_DECL void _0xDEE8D30AA5C2E28D(Ped ped, Hash p1, BOOL p2) { invoke<Void>(0xDEE8D30AA5C2E28D, ped, p1, p2); } // 0xDEE8D30AA5C2E28D b1207
	NATIVE_DECL void _0xE1B3BE07D3AADDED(Ped ped, int p1, BOOL p2) { invoke<Void>(0xE1B3BE07D3AADDED, ped, p1, p2); } // 0xE1B3BE07D3AADDED b1207
	NATIVE_DECL void _0x32CEDA9A0AB4CEF7(Ped ped, Hash p1, BOOL p2) { invoke<Void>(0x32CEDA9A0AB4CEF7, ped, p1, p2); } // 0x32CEDA9A0AB4CEF7 b1207
	NATIVE_DECL void _0x52A24D8A1DA89658(Ped ped, int p1, BOOL p2) { invoke<Void>(0x52A24D8A1DA89658, ped, p1, p2); } // 0x52A24D8A1DA89658 b1207
	NATIVE_DECL void _0x34B5CEAC180A5D6E(Ped ped, Hash p1, BOOL p2) { invoke<Void>(0x34B5CEAC180A5D6E, ped, p1, p2); } // 0x34B5CEAC180A5D6E b1207
	NATIVE_DECL void _0x4F27603E44A8E4C0(Ped ped, int p1, BOOL p2) { invoke<Void>(0x4F27603E44A8E4C0, ped, p1, p2); } // 0x4F27603E44A8E4C0 b1207
	// Changes health bar around heart core icon
	// INITIALISE_NEW_ROLE - Applying Super Jump buffs: p1 = 10, p2 = 0.0f
	// INITIALISE_NEW_ROLE - Clearing up Super Jump buffs: p1 = 10, p2 = 1.0f
	// _SET_D*
	NATIVE_DECL void _0x3FDCC1F8C17E303E(Ped ped, int p1, float p2) { invoke<Void>(0x3FDCC1F8C17E303E, ped, p1, p2); } // 0x3FDCC1F8C17E303E b1207
	// _SET_D*
	NATIVE_DECL void _0xE50C9816B3F22D8B(Ped ped, Hash p1, float p2) { invoke<Void>(0xE50C9816B3F22D8B, ped, p1, p2); } // 0xE50C9816B3F22D8B b1311
	NATIVE_DECL void _SET_DEFENSE_MODIFIER_FOR_PED(Ped ped, float modifier) { invoke<Void>(0x9B6808EC46BE849B, ped, modifier); } // 0x9B6808EC46BE849B b1207
	// _SET_M*
	NATIVE_DECL void _0x7883AA809DF43D98(Ped ped, float healthLimit) { invoke<Void>(0x7883AA809DF43D98, ped, healthLimit); } // 0x7883AA809DF43D98 b1355
	// _SET_H* - _SET_I*
	NATIVE_DECL void _0xC5B78E41DCF8227C(Ped ped, BOOL p1) { invoke<Void>(0xC5B78E41DCF8227C, ped, p1); } // 0xC5B78E41DCF8227C b1207
	NATIVE_DECL void SET_PED_CAN_BE_TARGETTED(Ped ped, BOOL toggle) { invoke<Void>(0x63F58F7C80513AAD, ped, toggle); } // 0x63F58F7C80513AAD 0x75C49F74 b1207
	NATIVE_DECL void SET_PED_CAN_BE_TARGETTED_BY_TEAM(Ped ped, int team, BOOL toggle) { invoke<Void>(0xBF1CA77833E58F2C, ped, team, toggle); } // 0xBF1CA77833E58F2C 0xB103A8E1 b1207
	NATIVE_DECL void SET_PED_CAN_BE_TARGETTED_BY_PLAYER(Ped ped, Player player, BOOL toggle) { invoke<Void>(0x66B57B72E0836A76, ped, player, toggle); } // 0x66B57B72E0836A76 0xD050F490 b1207
	NATIVE_DECL void _SET_INTERACTION_LOCKON_FLAG(Ped ped, Player player, int flag, BOOL enable) { invoke<Void>(0xFECA2081F61ED2CD, ped, player, flag, enable); } // 0xFECA2081F61ED2CD b1207
	NATIVE_DECL BOOL IS_PED_FALLING(Ped ped) { return invoke<BOOL>(0xFB92A102F1C4DFA3, ped); } // 0xFB92A102F1C4DFA3 0xABF77334 b1207
	NATIVE_DECL BOOL _IS_PED_SLIDING(Ped ped) { return invoke<BOOL>(0xD6740E14E4CEFC0B, ped); } // 0xD6740E14E4CEFC0B b1207
	NATIVE_DECL BOOL IS_PED_JUMPING(Ped ped) { return invoke<BOOL>(0xCEDABC5900A0BF97, ped); } // 0xCEDABC5900A0BF97 0x07E5BC0E b1207
	NATIVE_DECL BOOL IS_PED_CLIMBING(Ped ped) { return invoke<BOOL>(0x53E8CB4F48BFE623, ped); } // 0x53E8CB4F48BFE623 0xBCE03D35 b1207
	NATIVE_DECL BOOL _IS_PED_CLIMBING_LADDER(Ped ped) { return invoke<BOOL>(0x59643424B68D52B5, ped); } // 0x59643424B68D52B5 b1207
	// _IS_PED_C* - _IS_PED_D*
	NATIVE_DECL BOOL _0x577C60BA06D0EA64(Ped ped) { return invoke<BOOL>(0x577C60BA06D0EA64, ped); } // 0x577C60BA06D0EA64 b1207
	NATIVE_DECL BOOL IS_PED_VAULTING(Ped ped) { return invoke<BOOL>(0x117C70D1F5730B5E, ped); } // 0x117C70D1F5730B5E 0xC3169BDA b1207
	NATIVE_DECL BOOL IS_PED_DIVING(Ped ped) { return invoke<BOOL>(0x5527B8246FEF9B11, ped); } // 0x5527B8246FEF9B11 0x7BC5BF3C b1207
	// Returns true if the ped is currently opening a door (CTaskOpenDoor).
	NATIVE_DECL BOOL _IS_PED_OPENING_A_DOOR(Ped ped) { return invoke<BOOL>(0x26AF0E8E30BD2A2C, ped); } // 0x26AF0E8E30BD2A2C b1207
	// _IS_PED_IN*
	NATIVE_DECL BOOL _0x5C6C7C70CA302801(Ped ped) { return invoke<BOOL>(0x5C6C7C70CA302801, ped); } // 0x5C6C7C70CA302801 b1207
	// _IS_PED_J* - _IS_PED_L*
	NATIVE_DECL BOOL _0xB91AB3BE7F655D49(Ped ped) { return invoke<BOOL>(0xB91AB3BE7F655D49, ped); } // 0xB91AB3BE7F655D49 b1207
	NATIVE_DECL BOOL IS_PED_IN_ANY_TAXI(Ped ped) { return invoke<BOOL>(0x6E575D6A898AB852, ped); } // 0x6E575D6A898AB852 0x16FD386C b1207
	NATIVE_DECL void SET_PED_ID_RANGE(Ped ped, float value) { invoke<Void>(0xF107E836A70DCE05, ped, value); } // 0xF107E836A70DCE05 0xEF3B4ED9 b1207
	NATIVE_DECL float _GET_PED_ID_RANGE(Ped ped) { return invoke<float>(0x31167ED4324B758D, ped); } // 0x31167ED4324B758D b1207
	NATIVE_DECL void SET_PED_HIGHLY_PERCEPTIVE(Ped ped, BOOL toggle) { invoke<Void>(0x52D59AB61DDC05DD, ped, toggle); } // 0x52D59AB61DDC05DD 0x9A2180FF b1207
	NATIVE_DECL void SET_PED_INJURED_ON_GROUND_BEHAVIOUR(Ped ped, float unk) { invoke<Void>(0xEC4B4B3B9908052A, ped, unk); } // 0xEC4B4B3B9908052A 0xF30658D2 b1311
	NATIVE_DECL void DISABLE_PED_INJURED_ON_GROUND_BEHAVIOUR(Ped ped) { invoke<Void>(0x733C87D4CE22BEA2, ped); } // 0x733C87D4CE22BEA2 0x43709044 b1207
	// _SET_ST* - _SET_SW*
	NATIVE_DECL void _0x028E7B3BBA0BD2FC(Ped ped) { invoke<Void>(0x028E7B3BBA0BD2FC, ped); } // 0x028E7B3BBA0BD2FC b1207
	// _HAS_PED_*
	NATIVE_DECL BOOL _0xFA8C10DCE0706D43(Ped ped) { return invoke<BOOL>(0xFA8C10DCE0706D43, ped); } // 0xFA8C10DCE0706D43 b1207
	NATIVE_DECL void _SET_PED_ANIMAL_DETECTION_MODIFIER(Ped ped, float modifier) { invoke<Void>(0x43CA928E892CFDB8, ped, modifier); } // 0x43CA928E892CFDB8 b1311
	// _GET_PED_*
	NATIVE_DECL float _0x2BA9D7BF629F920C(Ped ped) { return invoke<float>(0x2BA9D7BF629F920C, ped); } // 0x2BA9D7BF629F920C b1207
	NATIVE_DECL void SET_PED_SEEING_RANGE(Ped ped, float value) { invoke<Void>(0xF29CF591C4BF6CEE, ped, value); } // 0xF29CF591C4BF6CEE 0x4BD72FE8 b1207
	// _GET_PED_*
	NATIVE_DECL float _0x900CA00CE703E1E2(Ped ped) { return invoke<float>(0x900CA00CE703E1E2, ped); } // 0x900CA00CE703E1E2 b1207
	NATIVE_DECL void SET_PED_HEARING_RANGE(Ped ped, float value) { invoke<Void>(0x33A8F7F7D5F7F33C, ped, value); } // 0x33A8F7F7D5F7F33C 0xB32087E0 b1207
	NATIVE_DECL void SET_PED_VISUAL_FIELD_MIN_ANGLE(Ped ped, float value) { invoke<Void>(0x2DB492222FB21E26, ped, value); } // 0x2DB492222FB21E26 0x72E2E18B b1207
	NATIVE_DECL void SET_PED_VISUAL_FIELD_MAX_ANGLE(Ped ped, float value) { invoke<Void>(0x70793BDCA1E854D4, ped, value); } // 0x70793BDCA1E854D4 0x0CEA0F9A b1207
	NATIVE_DECL void SET_PED_VISUAL_FIELD_PERIPHERAL_RANGE(Ped ped, float range) { invoke<Void>(0x9C74B0BC831B753A, ped, range); } // 0x9C74B0BC831B753A 0xFDF2F7C2 b1207
	NATIVE_DECL void SET_PED_VISUAL_FIELD_CENTER_ANGLE(Ped ped, float angle) { invoke<Void>(0x3B6405E8AB34A907, ped, angle); } // 0x3B6405E8AB34A907 0xE57202A1 b1207
	// _SET_PED_M*
	NATIVE_DECL void _0x9AB33CB5834885B3(Ped ped, float p1, float p2, float p3, float p4) { invoke<Void>(0x9AB33CB5834885B3, ped, p1, p2, p3, p4); } // 0x9AB33CB5834885B3 b1207
	// _SET_PED_O*
	NATIVE_DECL void _0x899DFA0009AC93DE(Ped ped, float p1) { invoke<Void>(0x899DFA0009AC93DE, ped, p1); } // 0x899DFA0009AC93DE b1207
	// _SET_PED_MO*
	NATIVE_DECL void _0x3A5697B80FED5EBE(Ped ped, float p1, float p2, float p3, float p4) { invoke<Void>(0x3A5697B80FED5EBE, ped, p1, p2, p3, p4); } // 0x3A5697B80FED5EBE b1207
	// Not implemented.
	NATIVE_DECL void SET_PED_STEALTH_MOVEMENT(Ped ped, Any p1, Any p2, Any p3) { invoke<Void>(0x88CBB5CEB96B7BD2, ped, p1, p2, p3); } // 0x88CBB5CEB96B7BD2 0x67E28E1D b1207
	// Returns whether the entity is in stealth mode
	NATIVE_DECL BOOL GET_PED_STEALTH_MOVEMENT(Ped ped) { return invoke<BOOL>(0x7C2AC9CA66575FBF, ped); } // 0x7C2AC9CA66575FBF 0x40321B83 b1207
	NATIVE_DECL void _SET_PED_CROUCH_MOVEMENT(Ped ped, BOOL state, int p2, BOOL immediately) { invoke<Void>(0x7DE9692C6F64CFE8, ped, state, p2, immediately); } // 0x7DE9692C6F64CFE8 b1207
	NATIVE_DECL BOOL GET_PED_CROUCH_MOVEMENT(Ped ped) { return invoke<BOOL>(0xD5FE956C70FF370B, ped); } // 0xD5FE956C70FF370B b1207
	NATIVE_DECL BOOL GET_PED_IS_DOING_COMBAT_ROLL(Ped ped) { return invoke<BOOL>(0xC48A9EB0D499B3E5, ped); } // 0xC48A9EB0D499B3E5 b1207
	// Creates a new ped group.
	// Groups can contain up to 8 peds.
	// 
	// The parameter is unused.
	// 
	// Returns a handle to the created group, or 0 if a group couldn't be created.
	NATIVE_DECL int CREATE_GROUP(int taskAllocator) { return invoke<int>(0x90370EBE0FEE1A3D, taskAllocator); } // 0x90370EBE0FEE1A3D 0x8DC0368D b1207
	NATIVE_DECL void SET_PED_AS_GROUP_LEADER(Ped ped, int groupId, BOOL p2) { invoke<Void>(0x2A7819605465FBCE, ped, groupId, p2); } // 0x2A7819605465FBCE 0x7265BEA2 b1207
	NATIVE_DECL void SET_PED_AS_GROUP_MEMBER(Ped ped, int groupId) { invoke<Void>(0x9F3480FE65DB31B5, ped, groupId); } // 0x9F3480FE65DB31B5 0x0EE13F92 b1207
	// This only will teleport the ped to the group leader if the group leader teleports (sets coords).
	// 
	// Only works in singleplayer
	NATIVE_DECL void SET_PED_CAN_TELEPORT_TO_GROUP_LEADER(Ped pedHandle, int groupId, BOOL toggle) { invoke<Void>(0x2E2F4240B3F24647, pedHandle, groupId, toggle); } // 0x2E2F4240B3F24647 0xD0D8BDBC b1207
	NATIVE_DECL void REMOVE_GROUP(int groupId) { invoke<Void>(0x8EB2F69076AF7053, groupId); } // 0x8EB2F69076AF7053 0x48D72B88 b1207
	NATIVE_DECL void REMOVE_PED_FROM_GROUP(Ped ped) { invoke<Void>(0xED74007FFB146BC2, ped); } // 0xED74007FFB146BC2 0x82697713 b1207
	NATIVE_DECL BOOL IS_PED_GROUP_MEMBER(Ped ped, int groupId, BOOL p2) { return invoke<BOOL>(0x9BB01E3834671191, ped, groupId, p2); } // 0x9BB01E3834671191 0x876D5363 b1207
	NATIVE_DECL BOOL _IS_PED_GROUP_LEADER(Ped ped, int groupId) { return invoke<BOOL>(0x878B68960C1C2A35, ped, groupId); } // 0x878B68960C1C2A35 b1207
	NATIVE_DECL BOOL IS_PED_HANGING_ON_TO_VEHICLE(Ped ped) { return invoke<BOOL>(0x1C86D8AEF8254B78, ped); } // 0x1C86D8AEF8254B78 0x9678D4FF b1207
	// Sets the range at which members will automatically leave the group.
	NATIVE_DECL void SET_GROUP_SEPARATION_RANGE(int groupId, float separationRange) { invoke<Void>(0x4102C7858CFEE4E4, groupId, separationRange); } // 0x4102C7858CFEE4E4 0x7B820CD5 b1207
	// _SET_C*
	NATIVE_DECL void _0x89E59DBD15E21177(int groupId, int p1) { invoke<Void>(0x89E59DBD15E21177, groupId, p1); } // 0x89E59DBD15E21177 b1207
	NATIVE_DECL BOOL IS_PED_PRONE(Ped ped) { return invoke<BOOL>(0xD6A86331A537A7B9, ped); } // 0xD6A86331A537A7B9 0x02C2A6C3 b1207
	// _IS_PED_IN*
	NATIVE_DECL BOOL _0x7583A9D35248B83F(Ped ped) { return invoke<BOOL>(0x7583A9D35248B83F, ped); } // 0x7583A9D35248B83F b1207
	NATIVE_DECL BOOL IS_PED_IN_COMBAT(Ped ped, Ped target) { return invoke<BOOL>(0x4859F1FC66A6278E, ped, target); } // 0x4859F1FC66A6278E 0xFE027CB5 b1207
	NATIVE_DECL BOOL CAN_PED_IN_COMBAT_SEE_TARGET(Ped ped, Ped target) { return invoke<BOOL>(0xEAD42DE3610D0721, ped, target); } // 0xEAD42DE3610D0721 0xCCD525E1 b1207
	NATIVE_DECL BOOL IS_PED_JACKING(Ped ped) { return invoke<BOOL>(0x4AE4FF911DFB61DA, ped); } // 0x4AE4FF911DFB61DA 0x3B321816 b1207
	NATIVE_DECL BOOL IS_PED_BEING_JACKED(Ped ped) { return invoke<BOOL>(0x9A497FE2DF198913, ped); } // 0x9A497FE2DF198913 0xD45D605C b1207
	NATIVE_DECL BOOL IS_PED_BEING_STUNNED(Ped ped, int p1) { return invoke<BOOL>(0x4FBACCE3B4138EE8, ped, p1); } // 0x4FBACCE3B4138EE8 0x0A66CE30 b1207
	NATIVE_DECL Ped GET_PEDS_JACKER(Ped ped) { return invoke<Ped>(0x9B128DC36C1E04CF, ped); } // 0x9B128DC36C1E04CF 0xDE1DBB59 b1207
	NATIVE_DECL Ped GET_JACK_TARGET(Ped ped) { return invoke<Ped>(0x5486A79D9FBD342D, ped); } // 0x5486A79D9FBD342D 0x1D196361 b1207
	NATIVE_DECL BOOL IS_PED_FLEEING(Ped ped) { return invoke<BOOL>(0xBBCCE00B381F8482, ped); } // 0xBBCCE00B381F8482 0x85D813C6 b1207
	NATIVE_DECL BOOL IS_PED_IN_COVER(Ped ped, BOOL p1, BOOL p2) { return invoke<BOOL>(0x60DFD0691A170B88, ped, p1, p2); } // 0x60DFD0691A170B88 0x972C5A8B b1207
	// _IS_PED_M* - _IS_PED_O*
	NATIVE_DECL BOOL _0x2DD4E0E26DFAD97D(Ped ped1, Ped ped2, float p2) { return invoke<BOOL>(0x2DD4E0E26DFAD97D, ped1, ped2, p2); } // 0x2DD4E0E26DFAD97D b1207
	NATIVE_DECL BOOL _0x06FA94C835787C64(Ped ped) { return invoke<BOOL>(0x06FA94C835787C64, ped); } // 0x06FA94C835787C64 b1207
	NATIVE_DECL BOOL _PED_DUELING_DID_PLAYER_HEADSHOT_OPPONENT(Ped ped) { return invoke<BOOL>(0xBD6B242B8BD5543A, ped); } // 0xBD6B242B8BD5543A b1207
	NATIVE_DECL BOOL IS_PED_IN_COVER_FACING_LEFT(Ped ped) { return invoke<BOOL>(0x845333B3150583AB, ped); } // 0x845333B3150583AB 0xB89DBB80 b1207
	NATIVE_DECL BOOL IS_PED_GOING_INTO_COVER(Ped ped) { return invoke<BOOL>(0x9F65DBC537E59AD5, ped); } // 0x9F65DBC537E59AD5 0xA3589628 b1207
	NATIVE_DECL BOOL IS_PED_RESPONDING_TO_THREAT(Ped ped) { return invoke<BOOL>(0x77525BBF433F2CD6, ped); } // 0x77525BBF433F2CD6 b1207
	// Returns kneeling, sitting, squating, and sleeping scenario hashes
	NATIVE_DECL Hash _GET_ACTIVE_DYNAMIC_SCENARIO_2(Ped ped) { return invoke<Hash>(0xC22AA08A8ADB87D4, ped); } // 0xC22AA08A8ADB87D4 b1207
	// Returns kneeling, sitting, squating, and sleeping scenario hashes
	NATIVE_DECL Hash _GET_ACTIVE_DYNAMIC_SCENARIO(Ped ped) { return invoke<Hash>(0x569F1E1237508DEB, ped); } // 0x569F1E1237508DEB b1207
	NATIVE_DECL BOOL _GIVE_PED_SCENARIO_PROP(Ped ped, Object object, const char* conditionalAnim, const char* p3, const char* p4, BOOL p5) { return invoke<BOOL>(0x3BBDD6143FF16F98, ped, object, conditionalAnim, p3, p4, p5); } // 0x3BBDD6143FF16F98 b1207
	NATIVE_DECL BOOL GIVE_PED_HASH_SCENARIO_PROP(Ped ped, Object object, const char* conditionalAnim, Hash scenarioType, Hash p4, BOOL p5) { return invoke<BOOL>(0x2B02DB082258625F, ped, object, conditionalAnim, scenarioType, p4, p5); } // 0x2B02DB082258625F b1207
	// Only used in SP R* Script rcm_jack2
	NATIVE_DECL BOOL _GIVE_PED_SCENARIO_PROP_DYNAMIC(Ped ped, Object object, const char* p2, const char* p3, BOOL p4) { return invoke<BOOL>(0xA0774E388CE4A679, ped, object, p2, p3, p4); } // 0xA0774E388CE4A679 b1207
	NATIVE_DECL Any _REQUEST_PROP_SCENARIO_PED(Ped ped, Object object, const char* p2, const char* p3, const char* p4, BOOL p5) { return invoke<Any>(0xBEC65C6049B3219D, ped, object, p2, p3, p4, p5); } // 0xBEC65C6049B3219D b1207
	NATIVE_DECL Any _REQUEST_PED_FOR_SCENARIO_TYPE(Ped ped, Object object, const char* p2, Hash scenarioType, const char* p4, BOOL p5) { return invoke<Any>(0xBDED916A9F9B0604, ped, object, p2, scenarioType, p4, p5); } // 0xBDED916A9F9B0604 b1207
	// Params: p1 = p_banjo01x_XH_R_HAND00, mp006_p_dblcello01x_XH_R_HAND00, p_fiddle01x_PH_L_HAND, p_guitar01x_XH_R_HAND00, mp006_p_mnshn_washboard01x_XH_R_HAND00, p_bottleBeer01x_PH_R_HAND
	NATIVE_DECL Entity _GET_PED_REGISTER_PROP(Ped ped, const char* p1, BOOL p2) { return invoke<Entity>(0x4D0D2E3D8BC000EB, ped, p1, p2); } // 0x4D0D2E3D8BC000EB b1207
	NATIVE_DECL int GET_SEAT_PED_IS_TRYING_TO_ENTER(Ped ped) { return invoke<int>(0x6F4C85ACD641BCD2, ped); } // 0x6F4C85ACD641BCD2 0xACF162E0 b1207
	// Returns the entity that killed the ped
	// 
	// It is best to check if the Ped is dead before asking for its killer.
	NATIVE_DECL Entity GET_PED_SOURCE_OF_DEATH(Ped ped) { return invoke<Entity>(0x93C8B64DEB84728C, ped); } // 0x93C8B64DEB84728C 0x84ADF9EB b1207
	// Returns the hash of the weapon/model/object that killed the ped.
	NATIVE_DECL Hash GET_PED_CAUSE_OF_DEATH(Ped ped) { return invoke<Hash>(0x16FFE42AB2D2DC59, ped); } // 0x16FFE42AB2D2DC59 0x63458C27 b1207
	NATIVE_DECL int GET_PED_TIME_OF_DEATH(Ped ped) { return invoke<int>(0x1E98817B311AE98A, ped); } // 0x1E98817B311AE98A 0xDF6D5D54 b1207
	NATIVE_DECL int COUNT_PEDS_IN_COMBAT_WITH_TARGET(Ped ped, int flag) { return invoke<int>(0x5407B7288D0478B7, ped, flag); } // 0x5407B7288D0478B7 0xEF0B78E6 b1207
	NATIVE_DECL int _GET_PEDS_IN_COMBAT_WITH_TARGET(Ped ped, ItemSet itemset, int flag) { return invoke<int>(0x7BE607DAFF382FD2, ped, itemset, flag); } // 0x7BE607DAFF382FD2 b1207
	NATIVE_DECL int COUNT_PEDS_IN_COMBAT_WITH_TARGET_WITHIN_RADIUS(Ped ped, float x, float y, float z, float radius, int flag) { return invoke<int>(0x336B3D200AB007CB, ped, x, y, z, radius, flag); } // 0x336B3D200AB007CB 0xFB18CB19 b1207
	NATIVE_DECL int COUNT_PEDS_IN_COMBAT_WITH_TARGET_WITHIN_RADIUS(Ped ped, Vector3 vec, float radius, int flag) { return invoke<int>(0x336B3D200AB007CB, ped, vec.x, vec.y, vec.z, radius, flag); } // 0x336B3D200AB007CB 0xFB18CB19 b1207
	NATIVE_DECL Entity GET_CURRENT_TARGET_FOR_PED(Ped ped) { return invoke<Entity>(0xCD66FEA29400A0B5, ped); } // 0xCD66FEA29400A0B5 b1207
	NATIVE_DECL void SET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH(Ped ped, Hash hash) { invoke<Void>(0xADB3F206518799E8, ped, hash); } // 0xADB3F206518799E8 0x423B7BA2 b1207
	NATIVE_DECL Hash _GET_DEFAULT_RELATIONSHIP_GROUP_HASH(Hash modelHash) { return invoke<Hash>(0x3CC4A718C258BDD0, modelHash); } // 0x3CC4A718C258BDD0 b1207
	NATIVE_DECL void SET_PED_RELATIONSHIP_GROUP_HASH(Ped ped, Hash relationshipGroup) { invoke<Void>(0xC80A74AC829DDD92, ped, relationshipGroup); } // 0xC80A74AC829DDD92 0x79F8C18C b1207
	NATIVE_DECL void SET_RELATIONSHIP_BETWEEN_GROUPS(int relationship, Hash group1, Hash group2) { invoke<Void>(0xBF25EB89375A37AD, relationship, group1, group2); } // 0xBF25EB89375A37AD 0xD4A215BA b1207
	NATIVE_DECL void CLEAR_RELATIONSHIP_BETWEEN_GROUPS(int relationship, Hash group1, Hash group2) { invoke<Void>(0x5E29243FB56FC6D4, relationship, group1, group2); } // 0x5E29243FB56FC6D4 0x994B8C2D b1207
	// The hash of the created relationship group is output in the second parameter.
	NATIVE_DECL BOOL ADD_RELATIONSHIP_GROUP(const char* name, Hash* groupHash) { return invoke<BOOL>(0xF372BC22FCB88606, name, groupHash); } // 0xF372BC22FCB88606 0x8B635546 b1207
	NATIVE_DECL void REMOVE_RELATIONSHIP_GROUP(Hash groupHash) { invoke<Void>(0xB6BA2444AB393DA2, groupHash); } // 0xB6BA2444AB393DA2 0x4A1DC59A b1207
	NATIVE_DECL int GET_RELATIONSHIP_BETWEEN_PEDS(Ped ped1, Ped ped2) { return invoke<int>(0xEBA5AD3A0EAF7121, ped1, ped2); } // 0xEBA5AD3A0EAF7121 0xE254C39C b1207
	NATIVE_DECL Hash GET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH(Ped ped) { return invoke<Hash>(0x42FDD0F017B1E38E, ped); } // 0x42FDD0F017B1E38E 0x714BD6E4 b1207
	NATIVE_DECL Hash GET_PED_RELATIONSHIP_GROUP_HASH(Ped ped) { return invoke<Hash>(0x7DBDD04862D95F04, ped); } // 0x7DBDD04862D95F04 0x354F283C b1207
	NATIVE_DECL int GET_RELATIONSHIP_BETWEEN_GROUPS(Hash group1, Hash group2) { return invoke<int>(0x9E6B70061662AE5C, group1, group2); } // 0x9E6B70061662AE5C 0x4E372FE2 b1207
	// _SET_RELATIONSHIP_*
	NATIVE_DECL void _0xDC91F22F09BC6C2F(Hash group, BOOL p1) { invoke<Void>(0xDC91F22F09BC6C2F, group, p1); } // 0xDC91F22F09BC6C2F b1207
	NATIVE_DECL void _0x9629FAF6460D35CB(Hash group, BOOL p1) { invoke<Void>(0x9629FAF6460D35CB, group, p1); } // 0x9629FAF6460D35CB b1207
	NATIVE_DECL void _0x4E68C7EF706DF35D(Ped ped, float x, float y, float z, float p4, Hash relationshipGroup) { invoke<Void>(0x4E68C7EF706DF35D, ped, x, y, z, p4, relationshipGroup); } // 0x4E68C7EF706DF35D b1207
	NATIVE_DECL void _0x4E68C7EF706DF35D(Ped ped, Vector3 vec, float p4, Hash relationshipGroup) { invoke<Void>(0x4E68C7EF706DF35D, ped, vec.x, vec.y, vec.z, p4, relationshipGroup); } // 0x4E68C7EF706DF35D b1207
	// Used in R* Script net_fetch (NET_FETCH_UPDATE_RECIPIENT_PROP_ILO_IN_COMBAT) and various SP Scripts
	// Params: p1 = 4/5/6, p5 = 40.f/100.f, coords = Player ped
	// Perhaps returns some distance (Clearing that the local player is able to use ILO while in combat because they are near the recipient but also near hated peds)
	// _GET_NUM_M* - _GET_PEDS_J*
	NATIVE_DECL int _0x3ACCE14DFA6BA8C2(Ped ped, int p1, float x, float y, float z, float p5, ItemSet itemset) { return invoke<int>(0x3ACCE14DFA6BA8C2, ped, p1, x, y, z, p5, itemset); } // 0x3ACCE14DFA6BA8C2 b1207
	NATIVE_DECL int _0x3ACCE14DFA6BA8C2(Ped ped, int p1, Vector3 vec, float p5, ItemSet itemset) { return invoke<int>(0x3ACCE14DFA6BA8C2, ped, p1, vec.x, vec.y, vec.z, p5, itemset); } // 0x3ACCE14DFA6BA8C2 b1207
	NATIVE_DECL void SET_PED_TO_INFORM_RESPECTED_FRIENDS(Ped ped, float radius, int maxFriends) { invoke<Void>(0x112942C6E708F70B, ped, radius, maxFriends); } // 0x112942C6E708F70B 0xD78AC46C b1207
	// _IS_PED_RE*
	NATIVE_DECL BOOL _0x40C9155AF8BC13F3(Ped ped) { return invoke<BOOL>(0x40C9155AF8BC13F3, ped); } // 0x40C9155AF8BC13F3 b1207
	// Only used in SP Scripts
	// Returns count / index
	// _C*
	NATIVE_DECL int _0xF4860514AD354226(ScrHandle shockingEvent, float x, float y, float z, float p4, int* p5) { return invoke<int>(0xF4860514AD354226, shockingEvent, x, y, z, p4, p5); } // 0xF4860514AD354226 b1207
	NATIVE_DECL int _0xF4860514AD354226(ScrHandle shockingEvent, Vector3 vec, float p4, int* p5) { return invoke<int>(0xF4860514AD354226, shockingEvent, vec.x, vec.y, vec.z, p4, p5); } // 0xF4860514AD354226 b1207
	// eventType: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL BOOL IS_PED_RESPONDING_TO_EVENT(Ped ped, Hash eventType) { return invoke<BOOL>(0x625B774D75C87068, ped, eventType); } // 0x625B774D75C87068 0x7A877554 b1207
	// Only used in R* SP Scripts
	// _GET_PED_IN*
	NATIVE_DECL Entity _0x5E9FAF6C513347B4(Ped ped, Hash eventType) { return invoke<Entity>(0x5E9FAF6C513347B4, ped, eventType); } // 0x5E9FAF6C513347B4 b1207
	// Only used in R* SP Script short_update
	// _GET_TARGET_* - _GET_TRACKED*
	NATIVE_DECL Any _0x326F7951EF0D7F75(Ped ped, Hash eventType) { return invoke<Any>(0x326F7951EF0D7F75, ped, eventType); } // 0x326F7951EF0D7F75 b1207
	// Used for AUDIO / ANIMSCENE (REFERENCE_REGIONAL_CHARACTER)
	// Params: p1 = 0
	// _GET_PED_IN*
	NATIVE_DECL Entity _0xE76687023D8C8505(Hash perscharModel, int p1) { return invoke<Entity>(0xE76687023D8C8505, perscharModel, p1); } // 0xE76687023D8C8505 b1207
	// Only used in R* SP Scripts
	// _GET_PLAYER_W* - _GET_RANDOM_*
	NATIVE_DECL BOOL _0xCB8F4C9343EBE240(Ped ped, Hash eventType, Vector3* coords) { return invoke<BOOL>(0xCB8F4C9343EBE240, ped, eventType, coords); } // 0xCB8F4C9343EBE240 b1207
	// Used in various R* MP & SP Scripts
	NATIVE_DECL void SET_PED_FIRING_PATTERN(Ped ped, Hash patternHash) { invoke<Void>(0x9AC577F5A12AD8A9, ped, patternHash); } // 0x9AC577F5A12AD8A9 0xB4629D66 b1207
	// Used in R* MP Script fm_mission_controller and various R* SP Scripts for ambush*
	NATIVE_DECL void _SET_PED_FIRING_PATTERN_2(Ped ped, Hash patternHash) { invoke<Void>(0x20E54854DEF6A54A, ped, patternHash); } // 0x20E54854DEF6A54A b1207
	// Only used in R* MP Script fm_mission_controller
	NATIVE_DECL void _SET_PED_FIRING_PATTERN_3(Ped ped, Hash patternHash) { invoke<Void>(0x244E8C282188E40F, ped, patternHash); } // 0x244E8C282188E40F b1207
	// Params: shootRate = 0 - 1000
	NATIVE_DECL void SET_PED_SHOOT_RATE(Ped ped, int shootRate) { invoke<Void>(0x614DA022990752DC, ped, shootRate); } // 0x614DA022990752DC 0xFB301746 b1207
	// _SET_PED_TA* - _SET_PED_TO_*
	NATIVE_DECL void _0x3C529A827998F9B3(Ped ped, int p1, int p2) { invoke<Void>(0x3C529A827998F9B3, ped, p1, p2); } // 0x3C529A827998F9B3 b1207
	// Only used in SP R* Scripts
	// Params: p2 = same as p2 of 0x3C529A827998F9B3
	// _SET_PED_TA* - _SET_PED_TO_*
	NATIVE_DECL void _0x1F44B7E283C09EDE(Ped ped, float p1, int p2) { invoke<Void>(0x1F44B7E283C09EDE, ped, p1, p2); } // 0x1F44B7E283C09EDE b1207
	// combatType can be between 0-14. See GET_COMBAT_FLOAT below for a list of possible parameters.
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/COMBAT_FLOATS
	NATIVE_DECL void SET_COMBAT_FLOAT(Ped ped, int combatType, float newValue) { invoke<Void>(0xFF41B4B141ED981C, ped, combatType, newValue); } // 0xFF41B4B141ED981C 0xD8B7637C b1207
	NATIVE_DECL float GET_COMBAT_FLOAT(Ped ped, int combatType) { return invoke<float>(0x52DFF8A10508090A, ped, combatType); } // 0x52DFF8A10508090A 0x511D7EF8 b1207
	NATIVE_DECL void GET_GROUP_SIZE(int groupId, BOOL* hasLeader, int* numberOfFollowers) { invoke<Void>(0x8DE69FE35CA09A45, groupId, hasLeader, numberOfFollowers); } // 0x8DE69FE35CA09A45 0xF7E1A691 b1207
	NATIVE_DECL BOOL DOES_GROUP_EXIST(int groupId) { return invoke<BOOL>(0x7C6B0C22F9F40BBE, groupId); } // 0x7C6B0C22F9F40BBE 0x935C978D b1207
	// _DOES_GROUP_* - _DOES_N*
	NATIVE_DECL BOOL _0x0455546F23FF08E4(int groupId) { return invoke<BOOL>(0x0455546F23FF08E4, groupId); } // 0x0455546F23FF08E4 b1207
	NATIVE_DECL BOOL IS_GROUP_LOCALLY_CONTROLLED(int groupId) { return invoke<BOOL>(0x909AD9E9A92A10DF, groupId); } // 0x909AD9E9A92A10DF b1207
	// Returns the groupId of which the specified ped is a member of.
	NATIVE_DECL int GET_PED_GROUP_INDEX(Ped ped) { return invoke<int>(0xF162E133B4E7A675, ped); } // 0xF162E133B4E7A675 0x134E0785 b1207
	NATIVE_DECL BOOL IS_PED_IN_GROUP(Ped ped) { return invoke<BOOL>(0x5891CAC5D4ACFF74, ped); } // 0x5891CAC5D4ACFF74 0x836D9795 b1207
	// _IS_PED_L* - _IS_PED_M*
	NATIVE_DECL BOOL _0x917760CFE7A0E0F1(Ped ped) { return invoke<BOOL>(0x917760CFE7A0E0F1, ped); } // 0x917760CFE7A0E0F1 b1207
	NATIVE_DECL Player GET_PLAYER_PED_IS_FOLLOWING(Ped ped) { return invoke<Player>(0x6A3975DEA89F9A17, ped); } // 0x6A3975DEA89F9A17 0xDE7442EE b1207
	// eFormationType
	// 
	// 0: Default
	// 1: Circle Around Leader
	// 2: Alternative Circle Around Leader
	// 3: Line, with Leader at center
	NATIVE_DECL void SET_GROUP_FORMATION(int groupId, int formationType) { invoke<Void>(0xCE2F5FC3AF7E8C1E, groupId, formationType); } // 0xCE2F5FC3AF7E8C1E 0x08FAC739 b1207
	NATIVE_DECL int _GET_GROUP_FORMATION(int groupId) { return invoke<int>(0x13A1B061007C906B, groupId); } // 0x13A1B061007C906B b1207
	NATIVE_DECL void SET_GROUP_FORMATION_SPACING(int groupId, float p1, float p2, float p3) { invoke<Void>(0x1D9D45004C28C916, groupId, p1, p2, p3); } // 0x1D9D45004C28C916 0xB1E086FF b1207
	NATIVE_DECL void RESET_GROUP_FORMATION_DEFAULT_SPACING(int groupId) { invoke<Void>(0x63DAB4CCB3273205, groupId); } // 0x63DAB4CCB3273205 0x267FCEAD b1207
	// _SET_FORMATION_*
	NATIVE_DECL BOOL _0xB05CC690CDE8A4A9(int groupId, float p1) { return invoke<BOOL>(0xB05CC690CDE8A4A9, groupId, p1); } // 0xB05CC690CDE8A4A9 b1207
	NATIVE_DECL void ADD_CUSTOM_FORMATION_LOCATION(int groupId, float x, float y, float z, int position) { invoke<Void>(0x4E23CD07BD161E06, groupId, x, y, z, position); } // 0x4E23CD07BD161E06 b1207
	NATIVE_DECL void ADD_CUSTOM_FORMATION_LOCATION(int groupId, Vector3 vec, int position) { invoke<Void>(0x4E23CD07BD161E06, groupId, vec.x, vec.y, vec.z, position); } // 0x4E23CD07BD161E06 b1207
	NATIVE_DECL BOOL ADD_FORMATION_LOCATION(int groupId, float p1, float p2, float p3) { return invoke<BOOL>(0xB05945C1E9E60D91, groupId, p1, p2, p3); } // 0xB05945C1E9E60D91 b1207
	NATIVE_DECL BOOL SET_FORMATION_POSITIONS_TARGET_RADIUS(int groupId, float radius) { return invoke<BOOL>(0x7CC7D3B7AF7FB71F, groupId, radius); } // 0x7CC7D3B7AF7FB71F b1207
	NATIVE_DECL void _SET_FORMATION_AUTO_ASSIGN_POSITION(int groupId, BOOL toggle) { invoke<Void>(0x478F6B9920446CE2, groupId, toggle); } // 0x478F6B9920446CE2 b1207
	NATIVE_DECL void _SET_PED_FORMATION_POSITION(Ped ped, int position, BOOL toggle) { invoke<Void>(0x0E9E95FDEDCC9D35, ped, position, toggle); } // 0x0E9E95FDEDCC9D35 b1207
	// Returns offset (0 < 32) to be used with MISC::SET_BIT
	// _GET_PED_CR*
	NATIVE_DECL int _0x8AF8E647D6B2A649(int groupId, Ped ped) { return invoke<int>(0x8AF8E647D6B2A649, groupId, ped); } // 0x8AF8E647D6B2A649 b1207
	// _CLEAR_PED_E* - _CLEAR_PED_L*
	NATIVE_DECL void _0x87C2724A56F66020(Ped ped) { invoke<Void>(0x87C2724A56F66020, ped); } // 0x87C2724A56F66020 b1207
	// _SET_FORMATION_*
	NATIVE_DECL void _0xD5BD1B5318A81994(int groupId, BOOL p1) { invoke<Void>(0xD5BD1B5318A81994, groupId, p1); } // 0xD5BD1B5318A81994 b1207
	// _SET_PLAYER_CAN_B* - _SET_PLAYER_CAN_U*
	NATIVE_DECL void _0x9BBEAF8B0C007F1E(Ped ped, BOOL p1) { invoke<Void>(0x9BBEAF8B0C007F1E, ped, p1); } // 0x9BBEAF8B0C007F1E b1207
	// _SET_PLAYER_N* - _SET_PLAYER_S*
	NATIVE_DECL void _0xC99F104BDF8C7F5A(Ped ped, BOOL p1) { invoke<Void>(0xC99F104BDF8C7F5A, ped, p1); } // 0xC99F104BDF8C7F5A b1207
	// _SET_PLAYER_SN* - _SET_PLAYER_STAMINA*
	NATIVE_DECL void _0x02E741E19E39628C(Ped ped, float p1) { invoke<Void>(0x02E741E19E39628C, ped, p1); } // 0x02E741E19E39628C b1207
	// _SET_SCENARIO_PED_* - _SET_SPAWNER_*
	NATIVE_DECL void _0x97C475212B327666(int groupId, BOOL p1) { invoke<Void>(0x97C475212B327666, groupId, p1); } // 0x97C475212B327666 b1207
	// _SET_SCENARIO_PED_* - _SET_SPAWNER_*
	NATIVE_DECL void _0x154B7E841AC7412F(int groupId, BOOL p1) { invoke<Void>(0x154B7E841AC7412F, groupId, p1); } // 0x154B7E841AC7412F b1207
	// _SET_FORMATION_*
	NATIVE_DECL void _0x8AFCCC0F18D70018(int groupId, BOOL p1) { invoke<Void>(0x8AFCCC0F18D70018, groupId, p1); } // 0x8AFCCC0F18D70018 b1207
	// _SET_FORMATION_P*
	NATIVE_DECL void _0xE1103300F3456DE7(int groupId, float p1, float p2) { invoke<Void>(0xE1103300F3456DE7, groupId, p1, p2); } // 0xE1103300F3456DE7 b1207
	// _SET_ENABLE_B* - _SET_ENABLE_H*
	NATIVE_DECL void _0xA8A95CECB1906EA2(int groupId, BOOL p1) { invoke<Void>(0xA8A95CECB1906EA2, groupId, p1); } // 0xA8A95CECB1906EA2 b1207
	// _SET_FORMATION_P*
	NATIVE_DECL void _0xDDFAD4DEAA7FA362(int groupId, float p1, float p2, float p3, float p4) { invoke<Void>(0xDDFAD4DEAA7FA362, groupId, p1, p2, p3, p4); } // 0xDDFAD4DEAA7FA362 b1207
	// _SET_FORMATION_P*
	NATIVE_DECL void _0x966DE09688A1DE39(int groupId, float p1, float p2, float p3, float p4) { invoke<Void>(0x966DE09688A1DE39, groupId, p1, p2, p3, p4); } // 0x966DE09688A1DE39 b1207
	// _SET_FORMATION_P*
	NATIVE_DECL void _0x7E5185B979706210(int groupId, int p1) { invoke<Void>(0x7E5185B979706210, groupId, p1); } // 0x7E5185B979706210 b1207
	// _SET_SCENARIO_PED_* - _SET_SPAWNER_*
	NATIVE_DECL void _0x40C3524D4ED83554(int groupId, BOOL p1) { invoke<Void>(0x40C3524D4ED83554, groupId, p1); } // 0x40C3524D4ED83554 b1207
	NATIVE_DECL void _0x86FAFC18E3D4380C(int groupId, BOOL p1) { invoke<Void>(0x86FAFC18E3D4380C, groupId, p1); } // 0x86FAFC18E3D4380C b1207
	NATIVE_DECL void _0x07EA5B053FA60AC7(int groupId, BOOL p1) { invoke<Void>(0x07EA5B053FA60AC7, groupId, p1); } // 0x07EA5B053FA60AC7 b1207
	NATIVE_DECL void _0xF9CBD46433E36713(Ped ped, Entity targetEntity, float p2, float p3, float p4, float p5, float p6, float p7, float p8, const char* p9) { invoke<Void>(0xF9CBD46433E36713, ped, targetEntity, p2, p3, p4, p5, p6, p7, p8, p9); } // 0xF9CBD46433E36713 b1207
	NATIVE_DECL Vehicle GET_VEHICLE_PED_IS_USING(Ped ped) { return invoke<Vehicle>(0x6094AD011A2EA87D, ped); } // 0x6094AD011A2EA87D 0x6DE3AADA b1207
	NATIVE_DECL Vehicle GET_VEHICLE_PED_IS_ENTERING(Ped ped) { return invoke<Vehicle>(0xF92691AED837A5FC, ped); } // 0xF92691AED837A5FC 0x56E0C163 b1207
	NATIVE_DECL Vehicle _GET_VEHICLE_DRAFT_HORSE_IS_ATTACHED_TO(Ped horse) { return invoke<Vehicle>(0xE4770DA1B8FF4FD1, horse); } // 0xE4770DA1B8FF4FD1 b1207
	NATIVE_DECL Vehicle _GET_LAST_VEHICLE_DRAFT_HORSE_WAS_ATTACHED_TO(Ped horse) { return invoke<Vehicle>(0x5064DB5083C29921, horse); } // 0x5064DB5083C29921 b1207
	NATIVE_DECL int GET_SEAT_PED_IS_USING(Ped ped) { return invoke<int>(0x4E76CB57222A00E5, ped); } // 0x4E76CB57222A00E5 b1207
	NATIVE_DECL Entity _GET_TRANSPORT_PED_IS_SEATED_ON(Ped ped) { return invoke<Entity>(0x849BD6C6314793D0, ped); } // 0x849BD6C6314793D0 b1207
	NATIVE_DECL BOOL IS_PED_ENTERING_ANY_TRANSPORT(Ped ped) { return invoke<BOOL>(0x1D46B417F926D34D, ped); } // 0x1D46B417F926D34D b1207
	NATIVE_DECL void SET_PED_GRAVITY(Ped ped, BOOL toggle) { invoke<Void>(0x9FF447B6B6AD960A, ped, toggle); } // 0x9FF447B6B6AD960A 0x3CA16652 b1207
	// Only used in R* Script mob4 combined with SET_ANIMAL_TUNING_BOOL_PARAM
	// _SET_PED_S* - _SET_PED_TARGET_*
	NATIVE_DECL void _0x96595B36D6A2279B(Ped animal, BOOL toggle) { invoke<Void>(0x96595B36D6A2279B, animal, toggle); } // 0x96595B36D6A2279B b1207
	// Only used in R* Script beat_sharp_shooter
	// Blocks ped from swimming underwater
	NATIVE_DECL void _SET_PED_IMMERSION_FLAG(Ped ped, BOOL toggle) { invoke<Void>(0x7FB0088E8769CDDB, ped, toggle); } // 0x7FB0088E8769CDDB b1207
	// Only used in R* Script mob4 and rcm_mason4
	// _SET_PED_DEFENSIVE_* - _SET_PED_DESIRED_*
	NATIVE_DECL void _0xA90684ED185CCB4B(Ped animal, BOOL p1, float p2, float p3) { invoke<Void>(0xA90684ED185CCB4B, animal, p1, p2, p3); } // 0xA90684ED185CCB4B b1207
	NATIVE_DECL void _FAKE_SET_PED_LOCO_INJURED(Ped ped, BOOL enabled) { invoke<Void>(0x8B3CB08158E98481, ped, enabled); } // 0x8B3CB08158E98481 b1207
	NATIVE_DECL void _FORCE_PED_DEATH(Ped ped, Ped pedKiller, Hash weapon) { invoke<Void>(0x1CE875505D45338A, ped, pedKiller, weapon); } // 0x1CE875505D45338A b1207
	// damages a ped with the given amount
	NATIVE_DECL void APPLY_DAMAGE_TO_PED(Ped ped, int damageAmount, int p2, int boneId, Ped pedKiller) { invoke<Void>(0x697157CED63F18D4, ped, damageAmount, p2, boneId, pedKiller); } // 0x697157CED63F18D4 0x4DC27FCF b1207
	// _SET_PED_D*
	NATIVE_DECL void _0xBAD2A311667A50D7(Ped ped, BOOL p1) { invoke<Void>(0xBAD2A311667A50D7, ped, p1); } // 0xBAD2A311667A50D7 b1207
	NATIVE_DECL int GET_PED_TYPE(Ped ped) { return invoke<int>(0xFF059E1E4C01E63C, ped); } // 0xFF059E1E4C01E63C 0xB1460D43 b1207
	// Turns the desired ped into a cop. If you use this on the player ped, you will become almost invisible to cops dispatched for you. You will also report your own crimes, get a generic cop voice, get a cop-vision-cone on the radar, and you will be unable to shoot at other cops. Toggling ped as "false" has no effect; you must change p0's ped model to disable the effect.
	// toggle = bSetRelGroup
	NATIVE_DECL void SET_PED_AS_COP(Ped ped, BOOL toggle) { invoke<Void>(0xBB03C38DD3FB7FFD, ped, toggle); } // 0xBB03C38DD3FB7FFD 0x84E7DE9F b1207
	// _SET_PED_A*
	NATIVE_DECL void _0x405180B14DA5A935(Ped ped, BOOL p1) { invoke<Void>(0x405180B14DA5A935, ped, p1); } // 0x405180B14DA5A935 b1207
	// personality (script_mp_rel): NONE, AGGRESSIVE, TIMID (non-aggressive), CRIPPS, SCRIPTEDINTIMIDATION, MAGGIE, MARCEL, SCRIPTEDSALOON
	// personality (script_rel): AVOID, SCRIPTEDOUTLAW, TIMIDGUARDDOG, SCRIPTEDTIMIDROB, AGGRESSIVECAMPER, LAZYDOG, KIERANTIEDUP, SCRIPTEDGALA
	NATIVE_DECL void _SET_PED_INTERACTION_PERSONALITY(Ped ped, Hash personality) { invoke<Void>(0x24C82EF607105FAA, ped, personality); } // 0x24C82EF607105FAA b1207
	NATIVE_DECL Hash _GET_PED_INTERACTION_PERSONALITY(Ped ped) { return invoke<Hash>(0xD7AD3C7EBAF88C92, ped); } // 0xD7AD3C7EBAF88C92 b1207
	// Hashes: STANDARD_PED_AGRO_GUARD, BOUNTY_HUNTER, PLAYER_HORSE
	// _SET_PED_P* - _SET_PED_R*
	NATIVE_DECL void _0xB8B6430EAD2D2437(Ped ped, Hash p1) { invoke<Void>(0xB8B6430EAD2D2437, ped, p1); } // 0xB8B6430EAD2D2437 b1207
	// _SET_PED_P* - _SET_PED_R*
	NATIVE_DECL void _0x329772C47DBB2FBC(Ped ped) { invoke<Void>(0x329772C47DBB2FBC, ped); } // 0x329772C47DBB2FBC b1207
	// Returns true if ped is in a dispute another ped (pedInDisputeWith can also be 0)
	NATIVE_DECL BOOL _GET_IS_PED_IN_DISPUTE_WITH_PED(Ped ped, Ped pedInDisputeWith) { return invoke<BOOL>(0x331550B212014B92, ped, pedInDisputeWith); } // 0x331550B212014B92 b1207
	// _GET_IS_PED_*
	NATIVE_DECL BOOL _0x94132D7C8D3575C4(Ped ped) { return invoke<BOOL>(0x94132D7C8D3575C4, ped); } // 0x94132D7C8D3575C4 b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0x8AF46E5159A5B620(Ped ped, Hash speechParams) { invoke<Void>(0x8AF46E5159A5B620, ped, speechParams); } // 0x8AF46E5159A5B620 b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0x45FEA6D5539BD474(Ped ped, const char* p1) { invoke<Void>(0x45FEA6D5539BD474, ped, p1); } // 0x45FEA6D5539BD474 b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0x20C5459379D75C1C(Ped ped, const char* p1) { invoke<Void>(0x20C5459379D75C1C, ped, p1); } // 0x20C5459379D75C1C b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0xE37ACEE15AC50C7E(Ped ped, const char* p1) { invoke<Void>(0xE37ACEE15AC50C7E, ped, p1); } // 0xE37ACEE15AC50C7E b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0xA3C53CDE922BC78B(Ped ped, const char* p1) { invoke<Void>(0xA3C53CDE922BC78B, ped, p1); } // 0xA3C53CDE922BC78B b1207
	// _SET_PED_IN*
	NATIVE_DECL void _0x41C23A8E6B344867(Ped ped, const char* p1) { invoke<Void>(0x41C23A8E6B344867, ped, p1); } // 0x41C23A8E6B344867 b1207
	NATIVE_DECL BOOL GET_IS_PED_RESPONDING_TO_POSITIVE_INTERACTION(Ped ped, Player player) { return invoke<BOOL>(0x9337183FDA2E9035, ped, player); } // 0x9337183FDA2E9035 b1207
	NATIVE_DECL BOOL GET_IS_PED_RESPONDING_TO_NEGATIVE_INTERACTION(Ped ped, Player player) { return invoke<BOOL>(0xA454D234E45BB6E5, ped, player); } // 0xA454D234E45BB6E5 b1207
	// _CLEAR_PED_B* - _CLEAR_PED_C*
	NATIVE_DECL void _0xA7DC9266ED6A4E51(Ped ped) { invoke<Void>(0xA7DC9266ED6A4E51, ped); } // 0xA7DC9266ED6A4E51 b1207
	// _GET_PED_B* - _GET_PED_C*
	NATIVE_DECL Any _0x89816B58C3466262(Ped ped) { return invoke<Any>(0x89816B58C3466262, ped); } // 0x89816B58C3466262 b1207
	// _CLEAR*
	NATIVE_DECL void _0x97B06669AC569003(Ped ped1, Ped ped2) { invoke<Void>(0x97B06669AC569003, ped1, ped2); } // 0x97B06669AC569003 b1207
	// _SET_PED_A*
	NATIVE_DECL void _0x85F500F4E24CA43E(Ped ped, float p1) { invoke<Void>(0x85F500F4E24CA43E, ped, p1); } // 0x85F500F4E24CA43E b1207
	// _SET_PED_SHOULD_PLAY_* - _SET_PED_SW*
	NATIVE_DECL void _0x9B9B9FA0EA283E3D(Ped ped, float p1) { invoke<Void>(0x9B9B9FA0EA283E3D, ped, p1); } // 0x9B9B9FA0EA283E3D b1207
	// _SET_C*
	NATIVE_DECL void _0xEC60D1D225BC50AA(Ped ped, float p1) { invoke<Void>(0xEC60D1D225BC50AA, ped, p1); } // 0xEC60D1D225BC50AA b1207
	// _SET_A* - _SET_B*
	NATIVE_DECL void _0x12F2D161BF4031FC(Ped ped, float p1) { invoke<Void>(0x12F2D161BF4031FC, ped, p1); } // 0x12F2D161BF4031FC b1207
	NATIVE_DECL void _0x0ADA3EC589E1736E() { invoke<Void>(0x0ADA3EC589E1736E); } // 0x0ADA3EC589E1736E b1207
	// If p2 is false, then this native will return true until the interaction is complete. If true, the native will return true until player pockets robbery item.
	// _GET_IS_PED_[M-R]*
	NATIVE_DECL BOOL _GET_IS_PED_BEING_ROBBED(Ped ped, Player player, BOOL trueUntilPlayerPocketsItem) { return invoke<BOOL>(0xE33F98BD76490ABC, ped, player, trueUntilPlayerPocketsItem); } // 0xE33F98BD76490ABC b1207
	// _GET_IS_PED_*
	NATIVE_DECL BOOL _0xD55DB4466D00A258(Ped legendaryAnimal) { return invoke<BOOL>(0xD55DB4466D00A258, legendaryAnimal); } // 0xD55DB4466D00A258 b1207
	// Sets the maximum health of a ped.
	NATIVE_DECL void SET_PED_MAX_HEALTH(Ped ped, int value) { invoke<Void>(0xF5F6378C4F3419D3, ped, value); } // 0xF5F6378C4F3419D3 0x5533F60B b1207
	NATIVE_DECL int GET_PED_MAX_HEALTH(Ped ped) { return invoke<int>(0x4700A416E8324EF3, ped); } // 0x4700A416E8324EF3 0xA45B6C8D b1207
	// configHash: see pedhealth.meta
	NATIVE_DECL void _SET_PED_HEALTH_CONFIG(Ped ped, Hash configHash) { invoke<Void>(0xF6B82FCE03B43A37, ped, configHash); } // 0xF6B82FCE03B43A37 b1207
	NATIVE_DECL void INIT_PED_DEFAULT_HEALTH(Ped ped) { invoke<Void>(0x7DD7FB3480D8083E, ped); } // 0x7DD7FB3480D8083E b1207
	NATIVE_DECL void SET_PED_MAX_TIME_IN_WATER(Ped ped, float value) { invoke<Void>(0x43C851690662113D, ped, value); } // 0x43C851690662113D 0xFE0A106B b1207
	NATIVE_DECL void SET_PED_MAX_TIME_UNDERWATER(Ped ped, float value) { invoke<Void>(0x6BA428C528D9E522, ped, value); } // 0x6BA428C528D9E522 0x082EF240 b1207
	// _CLEAR_PED_D*
	NATIVE_DECL void _0xAF041C10756C30FB(Ped ped, BOOL p1, BOOL p2, BOOL p3) { invoke<Void>(0xAF041C10756C30FB, ped, p1, p2, p3); } // 0xAF041C10756C30FB b1207
	// _SET_C*
	NATIVE_DECL void _0x5AF24CA9C974E51A(Ped ped1, Ped ped2) { invoke<Void>(0x5AF24CA9C974E51A, ped1, ped2); } // 0x5AF24CA9C974E51A b1207
	// state:
	// enum eKnockOffVehicle
	// {
	// 	KNOCKOFFVEHICLE_DEFAULT,
	// 	KNOCKOFFVEHICLE_NEVER,
	// 	KNOCKOFFVEHICLE_EASY,
	// 	KNOCKOFFVEHICLE_HARD
	// };
	NATIVE_DECL void SET_PED_CAN_BE_KNOCKED_OFF_VEHICLE(Ped ped, int state) { invoke<Void>(0x7A6535691B477C48, ped, state); } // 0x7A6535691B477C48 0x8A251612 b1207
	NATIVE_DECL BOOL CAN_KNOCK_PED_OFF_VEHICLE(Ped ped) { return invoke<BOOL>(0x51AC07A44D4F5B8A, ped); } // 0x51AC07A44D4F5B8A 0xC9D098B3 b1207
	NATIVE_DECL void KNOCK_PED_OFF_VEHICLE(Ped ped) { invoke<Void>(0x45BBCBA77C29A841, ped); } // 0x45BBCBA77C29A841 0xACDD0674 b1207
	NATIVE_DECL Ped GET_PED_AS_GROUP_MEMBER(int groupID, int memberNumber) { return invoke<Ped>(0x51455483CF23ED97, groupID, memberNumber); } // 0x51455483CF23ED97 0x9AA3CC8C b1207
	NATIVE_DECL Ped GET_PED_AS_GROUP_LEADER(int groupID) { return invoke<Ped>(0x5CCE68DBD5FE93EC, groupID); } // 0x5CCE68DBD5FE93EC 0x52873C6A b1207
	NATIVE_DECL void SET_PED_KEEP_TASK(Ped ped, BOOL toggle) { invoke<Void>(0x971D38760FBC02EF, ped, toggle); } // 0x971D38760FBC02EF 0xA7EC79CE b1207
	NATIVE_DECL BOOL IS_PED_SWIMMING(Ped ped) { return invoke<BOOL>(0x9DE327631295B4C2, ped); } // 0x9DE327631295B4C2 0x7AB43DB8 b1207
	NATIVE_DECL BOOL IS_PED_SWIMMING_UNDER_WATER(Ped ped) { return invoke<BOOL>(0xC024869A53992F34, ped); } // 0xC024869A53992F34 0x0E8D524F b1207
	// _IS_PED_IN_* (near water?)
	NATIVE_DECL BOOL _0xDC88D06719070C39(Ped ped) { return invoke<BOOL>(0xDC88D06719070C39, ped); } // 0xDC88D06719070C39 b1207
	NATIVE_DECL void SET_CREATE_RANDOM_COPS(BOOL toggle) { invoke<Void>(0x102E68B2024D536D, toggle); } // 0x102E68B2024D536D 0x23441648 b1207
	NATIVE_DECL BOOL IS_PED_IN_ANY_TRAIN(Ped ped) { return invoke<BOOL>(0x6F972C1AB75A1ED0, ped); } // 0x6F972C1AB75A1ED0 0x759EF63A b1207
	NATIVE_DECL BOOL IS_PED_GETTING_INTO_A_VEHICLE(Ped ped) { return invoke<BOOL>(0xBB062B2B5722478E, ped); } // 0xBB062B2B5722478E 0x90E805AC b1207
	// _HAS_PED_*
	NATIVE_DECL BOOL _0x550CB89DD7F4FA3D(Ped ped1, Ped ped2) { return invoke<BOOL>(0x550CB89DD7F4FA3D, ped1, ped2); } // 0x550CB89DD7F4FA3D b1207
	// Ped can not pull out a weapon when true
	NATIVE_DECL void SET_ENABLE_HANDCUFFS(Ped ped, BOOL p1, BOOL p2) { invoke<Void>(0xDF1AF8B5D56542FA, ped, p1, p2); } // 0xDF1AF8B5D56542FA 0xAC9BBA23 b1207
	NATIVE_DECL void SET_ENABLE_BOUND_ANKLES(Ped ped, BOOL toggle) { invoke<Void>(0xC52E0F855C58FC2E, ped, toggle); } // 0xC52E0F855C58FC2E 0x9208D689 b1207
	// If returned true, SET_ENABLE_BOUND_ANKLES is called in R* Script guama2
	// _GET_D* - _GET_E*
	NATIVE_DECL BOOL _0x8822F139408B8D0A(Ped ped) { return invoke<BOOL>(0x8822F139408B8D0A, ped); } // 0x8822F139408B8D0A b1207
	// Only used in R* Script train_robbery4
	// _SET_PED_D*
	NATIVE_DECL void _0x8822F124788B8D0A(Ped ped, BOOL p1) { invoke<Void>(0x8822F124788B8D0A, ped, p1); } // 0x8822F124788B8D0A b1207
	NATIVE_DECL void RESET_PED_WEAPON_MOVEMENT_CLIPSET(Ped ped) { invoke<Void>(0x97B0DB5B4AA74E77, ped); } // 0x97B0DB5B4AA74E77 0xC60C9ACD b1207
	NATIVE_DECL void _SET_PED_GETUP_ANIMATION(Ped ped, const char* animName, BOOL p2) { invoke<Void>(0x3AE3552E7C207CC5, ped, animName, p2); } // 0x3AE3552E7C207CC5 b1207
	// Used in R* Script generic_weight_control_item
	// _CLEAR_PED_E* - CLEAR_PED_(G?)L*
	NATIVE_DECL void _0x88A95BB640FC186F(Ped ped) { invoke<Void>(0x88A95BB640FC186F, ped); } // 0x88A95BB640FC186F b1207
	NATIVE_DECL void RESET_PED_IN_VEHICLE_CONTEXT(Ped ped) { invoke<Void>(0x22EF8FF8778030EB, ped); } // 0x22EF8FF8778030EB 0x3C94D88A b1207
	NATIVE_DECL void _0x878E8104FA27CDAE(Vehicle vehicle, Hash p1) { invoke<Void>(0x878E8104FA27CDAE, vehicle, p1); } // 0x878E8104FA27CDAE b1207
	NATIVE_DECL void SET_PED_GESTURE_GROUP(Ped ped, const char* gesture, int p2) { invoke<Void>(0xDDF803377F94AAA8, ped, gesture, p2); } // 0xDDF803377F94AAA8 0x170DA109 b1207
	// Seems to set the ped's loco type.
	// Values used in the scripts:
	// algie
	// angry_female
	// arthur_healthy
	// cowboy
	// cowboy_f
	// default
	// default_female
	// free_slave_01
	// free_slave_02
	// gold_panner
	// guard_lantern
	// injured_general
	// john_marston
	// lilly_millet
	// lone_prisoner
	// lost_man
	// mp_ova_hunter
	// mp_ova_hunter_female
	// murfree
	// old_female
	// primate
	// rally
	// waiter
	// war_veteran
	NATIVE_DECL void _SET_PED_DESIRED_LOCO_FOR_MODEL(Ped ped, const char* locomotionArchetype) { invoke<Void>(0x923583741DC87BCE, ped, locomotionArchetype); } // 0x923583741DC87BCE b1207
	// Clears locomotion archetype
	NATIVE_DECL void _CLEAR_PED_DESIRED_LOCO_FOR_MODEL(Ped ped) { invoke<Void>(0x4FD80C3DD84B817B, ped); } // 0x4FD80C3DD84B817B b1207
	// Sets peds motion type
	NATIVE_DECL void _SET_PED_DESIRED_LOCO_MOTION_TYPE(Ped ped, const char* locoMotionType) { invoke<Void>(0x89F5E7ADECCCB49C, ped, locoMotionType); } // 0x89F5E7ADECCCB49C b1207
	NATIVE_DECL void _CLEAR_PED_DESIRED_LOCO_MOTION_TYPE(Ped ped) { invoke<Void>(0x58F7DB5BD8FA2288, ped); } // 0x58F7DB5BD8FA2288 b1207
	NATIVE_DECL void _0x2371C39D4F91C288(Ped ped) { invoke<Void>(0x2371C39D4F91C288, ped); } // 0x2371C39D4F91C288 b1207
	// Known get up animation types: REAR, FRONT
	NATIVE_DECL void _REQUEST_PED_GETUP_ANIMATION(Ped ped, const char* getUpType) { invoke<Void>(0xEAA8242C8479C27D, ped, getUpType); } // 0xEAA8242C8479C27D b1207
	NATIVE_DECL void PED_COWER_IN_PLACE(Ped ped, Ped ped2) { invoke<Void>(0xF6E1E9F47A7686F8, ped, ped2); } // 0xF6E1E9F47A7686F8 b1207
	NATIVE_DECL void PED_COWER_MOVE_TO_POINT(Ped ped, float p1, float p2, float p3, Ped ped2, float p5) { invoke<Void>(0x1E4C940233FC0C6F, ped, p1, p2, p3, ped2, p5); } // 0x1E4C940233FC0C6F b1207
	// _PED_COWER_M*
	NATIVE_DECL void _0x16F798A05BB9E3B5(Ped ped) { invoke<Void>(0x16F798A05BB9E3B5, ped); } // 0x16F798A05BB9E3B5 b1207
	// target: 0 affects everyone
	// duration: -1 indefinite
	// flag: always 4 in R* Scripts
	NATIVE_DECL void _PED_EMOTIONAL_PRESET_LOCO_MOTION(Ped ped, const char* presetName, Ped targetPed, int duration, int flag) { invoke<Void>(0xAAB050DA48B57978, ped, presetName, targetPed, duration, flag); } // 0xAAB050DA48B57978 b1207
	NATIVE_DECL void _PED_CLEAR_LOCO_MOTION(Ped ped) { invoke<Void>(0x935CF6E42BAF7F4D, ped); } // 0x935CF6E42BAF7F4D b1207
	// _STOP_(?)*
	NATIVE_DECL void _0x32CCAD8A981B53D3(Ped ped) { invoke<Void>(0x32CCAD8A981B53D3, ped); } // 0x32CCAD8A981B53D3 b1207
	// SOBER = 0.0f, SLIGHTLY_DRUNK = 0.25f, MODERATELY_DRUNK = 0.5f, VERY_DRUNK = 1.0f
	NATIVE_DECL void _SET_PED_DRUNKNESS(Ped ped, BOOL enabled, float drunknessLevel) { invoke<Void>(0x406CCF555B04FAD3, ped, enabled, drunknessLevel); } // 0x406CCF555B04FAD3 b1207
	NATIVE_DECL BOOL _IS_PED_DRUNK(Ped ped) { return invoke<BOOL>(0x50F124E6EF188B22, ped); } // 0x50F124E6EF188B22 b1207
	// Returns ped drunk level
	// _H* or _I*
	NATIVE_DECL float _GET_PED_DRUNKNESS(Ped ped) { return invoke<float>(0x6FB76442469ABD68, ped); } // 0x6FB76442469ABD68 b1207
	NATIVE_DECL Vector3 GET_ANIM_INITIAL_OFFSET_POSITION(const char* animDict, const char* animName, float x, float y, float z, float xRot, float yRot, float zRot, float p8, int p9) { return invoke<Vector3>(0xBE22B26DD764C040, animDict, animName, x, y, z, xRot, yRot, zRot, p8, p9); } // 0xBE22B26DD764C040 0xC59D4268 b1207
	NATIVE_DECL Vector3 GET_ANIM_INITIAL_OFFSET_POSITION(const char* animDict, const char* animName, Vector3 vec, Vector3 rot, float p8, int p9) { return invoke<Vector3>(0xBE22B26DD764C040, animDict, animName, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, p8, p9); } // 0xBE22B26DD764C040 0xC59D4268 b1207
	NATIVE_DECL Vector3 GET_ANIM_INITIAL_OFFSET_ROTATION(const char* animDict, const char* animName, float x, float y, float z, float xRot, float yRot, float zRot, float p8, int p9) { return invoke<Vector3>(0x4B805E6046EE9E47, animDict, animName, x, y, z, xRot, yRot, zRot, p8, p9); } // 0x4B805E6046EE9E47 0x5F7789E6 b1207
	NATIVE_DECL Vector3 GET_ANIM_INITIAL_OFFSET_ROTATION(const char* animDict, const char* animName, Vector3 vec, Vector3 rot, float p8, int p9) { return invoke<Vector3>(0x4B805E6046EE9E47, animDict, animName, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, p8, p9); } // 0x4B805E6046EE9E47 0x5F7789E6 b1207
	NATIVE_DECL void SET_PED_RANDOM_COMPONENT_VARIATION(Ped ped, int p1) { invoke<Void>(0xC8A9481A01E63C28, ped, p1); } // 0xC8A9481A01E63C28 0x4111BA46 b1207
	NATIVE_DECL void KNOCK_OFF_PED_PROP(Ped ped, BOOL p1, BOOL p2, BOOL p3, BOOL p4) { invoke<Void>(0x6FD7816A36615F48, ped, p1, p2, p3, p4); } // 0x6FD7816A36615F48 0x08D8B180 b1207
	NATIVE_DECL void SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(Ped ped, BOOL toggle) { invoke<Void>(0x9F8AA94D6D97DBF4, ped, toggle); } // 0x9F8AA94D6D97DBF4 0xDFE34E4A b1207
	NATIVE_DECL BOOL _GET_BLOCKING_OF_NON_TEMPORARY_EVENTS(Ped ped) { return invoke<BOOL>(0x268B3AEBF032A88D, ped); } // 0x268B3AEBF032A88D b1207
	// _SET_PED_P* - _SET_PED_R*
	NATIVE_DECL void _0xC17A94CC8FC3C61A(Entity entity, int flag, float p2, float p3, float p4) { invoke<Void>(0xC17A94CC8FC3C61A, entity, flag, p2, p3, p4); } // 0xC17A94CC8FC3C61A b1207
	NATIVE_DECL void _SET_PED_SCALE(Ped ped, float scale) { invoke<Void>(0x25ACFC650B65C538, ped, scale); } // 0x25ACFC650B65C538 b1207
	// _GET_PED_M*
	NATIVE_DECL float _0x134775B093AD5C38(Ped ped) { return invoke<float>(0x134775B093AD5C38, ped); } // 0x134775B093AD5C38 b1207
	NATIVE_DECL float _GET_PED_HEIGHT(Ped ped) { return invoke<float>(0x1D491CCF7211FB74, ped); } // 0x1D491CCF7211FB74 b1207
	// PS_SMALL = 0,
	// PS_MEDIUM,
	// PS_MEDIUM_LARGE,
	// PS_LARGE,
	// PS_EXTRA_LARGE
	NATIVE_DECL int _GET_PED_MODEL_SIZE_FROM_HASH(Hash modelHash) { return invoke<int>(0xA65AA1ACE81E5A77, modelHash); } // 0xA65AA1ACE81E5A77 b1311
	NATIVE_DECL void REGISTER_TARGET(Ped ped, Ped targetPed, BOOL p2) { invoke<Void>(0x2F25D9AEFA34FBA2, ped, targetPed, p2); } // 0x2F25D9AEFA34FBA2 0x50A95442 b1207
	// _REGISTER_(TARGET?)*
	NATIVE_DECL void _0xD8736EFDA38EDC5C(Ped ped, float x, float y, float z, float p4) { invoke<Void>(0xD8736EFDA38EDC5C, ped, x, y, z, p4); } // 0xD8736EFDA38EDC5C b1207
	NATIVE_DECL void _0xD8736EFDA38EDC5C(Ped ped, Vector3 vec, float p4) { invoke<Void>(0xD8736EFDA38EDC5C, ped, vec.x, vec.y, vec.z, p4); } // 0xD8736EFDA38EDC5C b1207
	// Based on TASK_COMBAT_HATED_TARGETS_AROUND_PED, the parameters are likely similar (PedHandle, and area to attack in).
	NATIVE_DECL void REGISTER_HATED_TARGETS_AROUND_PED(Ped ped, float radius) { invoke<Void>(0x9222F300BF8354FE, ped, radius); } // 0x9222F300BF8354FE 0x7F87559E b1207
	NATIVE_DECL BOOL _IS_TARGET(Ped ped, Ped targetPed) { return invoke<BOOL>(0x6E5CBCB3941D7D08, ped, targetPed); } // 0x6E5CBCB3941D7D08 b1207
	NATIVE_DECL void _REMOVE_TARGET(Ped ped, Ped targetPed) { invoke<Void>(0x4707E9C23D8CA3FE, ped, targetPed); } // 0x4707E9C23D8CA3FE b1207
	// Gets the closest ped in a radius.
	NATIVE_DECL BOOL GET_CLOSEST_PED(float x, float y, float z, float radius, BOOL p4, BOOL p5, Ped* outPed, BOOL p7, BOOL p8, BOOL p9, int pedType) { return invoke<BOOL>(0xC33AB876A77F8164, x, y, z, radius, p4, p5, outPed, p7, p8, p9, pedType); } // 0xC33AB876A77F8164 0x8F6C1F55 b1207
	NATIVE_DECL BOOL GET_CLOSEST_PED(Vector3 vec, float radius, BOOL p4, BOOL p5, Ped* outPed, BOOL p7, BOOL p8, BOOL p9, int pedType) { return invoke<BOOL>(0xC33AB876A77F8164, vec.x, vec.y, vec.z, radius, p4, p5, outPed, p7, p8, p9, pedType); } // 0xC33AB876A77F8164 0x8F6C1F55 b1207
	NATIVE_DECL BOOL CAN_PED_RAGDOLL(Ped ped) { return invoke<BOOL>(0x128F79EDCECE4FD5, ped); } // 0x128F79EDCECE4FD5 0xC0EFB7A3 b1207
	NATIVE_DECL BOOL SET_PED_TO_RAGDOLL(Ped ped, int timeMin, int timeMax, int ragdollType, BOOL p4, BOOL p5, BOOL p6) { return invoke<BOOL>(0xAE99FB955581844A, ped, timeMin, timeMax, ragdollType, p4, p5, p6); } // 0xAE99FB955581844A 0x83CB5052 b1207
	NATIVE_DECL BOOL SET_PED_TO_RAGDOLL_WITH_FALL(Ped ped, int timeMin, int timeMax, int ragdollType, float falldirX, float falldirY, float falldirZ, float p7, float p8, float p9, float p10, float p11, float p12, float p13) { return invoke<BOOL>(0xD76632D99E4966C8, ped, timeMin, timeMax, ragdollType, falldirX, falldirY, falldirZ, p7, p8, p9, p10, p11, p12, p13); } // 0xD76632D99E4966C8 0xFA12E286 b1207
	NATIVE_DECL BOOL SET_PED_TO_RAGDOLL_WITH_FALL(Ped ped, int timeMin, int timeMax, int ragdollType, Vector3 falldir, float p7, float p8, float p9, float p10, float p11, float p12, float p13) { return invoke<BOOL>(0xD76632D99E4966C8, ped, timeMin, timeMax, ragdollType, falldir.x, falldir.y, falldir.z, p7, p8, p9, p10, p11, p12, p13); } // 0xD76632D99E4966C8 0xFA12E286 b1207
	// Causes Ped to ragdoll on collision with any object (e.g Running into trashcan). If applied to player you will sometimes trip on the sidewalk.
	NATIVE_DECL void SET_PED_RAGDOLL_ON_COLLISION(Ped ped, BOOL toggle, BOOL p2) { invoke<Void>(0xF0A4F1BBF4FA7497, ped, toggle, p2); } // 0xF0A4F1BBF4FA7497 0x2654A0F4 b1207
	NATIVE_DECL void _SET_PED_TO_DISABLE_RAGDOLL(Ped ped, BOOL toggle) { invoke<Void>(0x221F4D9912B7FE86, ped, toggle); } // 0x221F4D9912B7FE86 b1207
	// If the ped handle passed through the parenthesis is in a ragdoll state this will return true.
	NATIVE_DECL BOOL IS_PED_RAGDOLL(Ped ped) { return invoke<BOOL>(0x47E4E977581C5B55, ped); } // 0x47E4E977581C5B55 0xC833BBE1 b1207
	NATIVE_DECL BOOL IS_PED_RUNNING_RAGDOLL_TASK(Ped ped) { return invoke<BOOL>(0xE3B6097CC25AA69E, ped); } // 0xE3B6097CC25AA69E 0x44A153F2 b1207
	NATIVE_DECL void SET_PED_RAGDOLL_FORCE_FALL(Ped ped) { invoke<Void>(0x01F6594B923B9251, ped); } // 0x01F6594B923B9251 0x20A5BDE0 b1207
	// _SET_PED_T* - SET_PED_U*
	NATIVE_DECL void _0x8CB2553C559102C1(Ped ped, int p1, BOOL p2) { invoke<Void>(0x8CB2553C559102C1, ped, p1, p2); } // 0x8CB2553C559102C1 b1207
	// _DISABLE_A* - _DISABLE_C*
	NATIVE_DECL void _0xFD3C31A2E45671E7(Ped ped, int p1) { invoke<Void>(0xFD3C31A2E45671E7, ped, p1); } // 0xFD3C31A2E45671E7 b1207
	NATIVE_DECL void RESET_PED_RAGDOLL_TIMER(Ped ped) { invoke<Void>(0x9FA4664CF62E47E8, ped); } // 0x9FA4664CF62E47E8 0xF2865370 b1207
	NATIVE_DECL void SET_PED_CAN_RAGDOLL(Ped ped, BOOL toggle) { invoke<Void>(0xB128377056A54E2A, ped, toggle); } // 0xB128377056A54E2A 0xCF1384C4 b1207
	// _IS_PED_R*
	NATIVE_DECL BOOL _0x3AEC4A410ECAF30D(Ped ped) { return invoke<BOOL>(0x3AEC4A410ECAF30D, ped); } // 0x3AEC4A410ECAF30D b1207
	NATIVE_DECL BOOL IS_PED_RUNNING_MOBILE_PHONE_TASK(Ped ped) { return invoke<BOOL>(0x2AFE52F782F25775, ped); } // 0x2AFE52F782F25775 0xFB2AFED1 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/RAGDOLL_BLOCKING_FLAGS
	// 
	// flags:
	// enum eRagdollBlockingFlags
	// {
	// 	RBF_BULLET_IMPACT = (1 << 0),
	// 	RBF_VEHICLE_IMPACT = (1 << 1),
	// 	RBF_FIRE = (1 << 2),
	// 	RBF_ELECTROCUTION = (1 << 3),
	// 	RBF_PLAYER_IMPACT = (1 << 4),
	// 	RBF_EXPLOSION = (1 << 5),
	// 	RBF_IMPACT_OBJECT = (1 << 6),
	// 	RBF_MELEE = (1 << 7),
	// 	RBF_RUBBER_BULLET = (1 << 8),
	// 	RBF_FALLING = (1 << 9),
	// 	RBF_WATER_JET = (1 << 10),
	// 	RBF_DROWNING = (1 << 11),
	// 	RBF_0x9F52E2C4 = (1 << 12),
	// 	RBF_PLAYER_BUMP = (1 << 13),
	// 	RBF_PLAYER_RAGDOLL_BUMP = (1 << 14),
	// 	RBF_PED_RAGDOLL_BUMP = (1 << 15),
	// 	RBF_VEHICLE_GRAB = (1 << 16),
	// 	RBF_SMOKE_GRENADE = (1 << 17),
	// 	RBF_HORSE_BUMP = (1 << 18),
	// 	RBF_ACTIVATE_ON_COLLISION = (1 << 19)
	// };
	NATIVE_DECL void SET_RAGDOLL_BLOCKING_FLAGS(Ped ped, int flags) { invoke<Void>(0x26695EC767728D84, ped, flags); } // 0x26695EC767728D84 0x9C8F830D b1207
	// flags: see SET_RAGDOLL_BLOCKING_FLAGS
	NATIVE_DECL void CLEAR_RAGDOLL_BLOCKING_FLAGS(Ped ped, int flags) { invoke<Void>(0xD86D101FCFD00A4B, ped, flags); } // 0xD86D101FCFD00A4B 0x77CBA290 b1207
	NATIVE_DECL void _0x9F933E0985E12C51(Ped ped, float p1, float p2, float p3) { invoke<Void>(0x9F933E0985E12C51, ped, p1, p2, p3); } // 0x9F933E0985E12C51 b1207
	NATIVE_DECL void _0x88B2026A3B0BE33D(Ped ped, float p1) { invoke<Void>(0x88B2026A3B0BE33D, ped, p1); } // 0x88B2026A3B0BE33D b1207
	NATIVE_DECL void SET_PED_DEFENSIVE_AREA_VOLUME(Ped ped, Volume volume, BOOL p2, BOOL p3, BOOL p4) { invoke<Void>(0xFC3DB99C8144CD81, ped, volume, p2, p3, p4); } // 0xFC3DB99C8144CD81 b1207
	NATIVE_DECL void SET_PED_SPHERE_DEFENSIVE_AREA(Ped ped, float x, float y, float z, float radius, BOOL p5, BOOL p6, BOOL p7) { invoke<Void>(0x9D3151A373974804, ped, x, y, z, radius, p5, p6, p7); } // 0x9D3151A373974804 0xBD96D8E8 b1207
	NATIVE_DECL void SET_PED_SPHERE_DEFENSIVE_AREA(Ped ped, Vector3 vec, float radius, BOOL p5, BOOL p6, BOOL p7) { invoke<Void>(0x9D3151A373974804, ped, vec.x, vec.y, vec.z, radius, p5, p6, p7); } // 0x9D3151A373974804 0xBD96D8E8 b1207
	NATIVE_DECL void _SET_PED_DEFENSIVE_SPHERE_ATTACHED_TO_ENTITY(Ped ped, Entity entity, float x, float y, float z, float radius, int p6, BOOL p7) { invoke<Void>(0x1854217C640B39EC, ped, entity, x, y, z, radius, p6, p7); } // 0x1854217C640B39EC b1207
	NATIVE_DECL void _SET_PED_DEFENSIVE_SPHERE_ATTACHED_TO_ENTITY(Ped ped, Entity entity, Vector3 vec, float radius, int p6, BOOL p7) { invoke<Void>(0x1854217C640B39EC, ped, entity, vec.x, vec.y, vec.z, radius, p6, p7); } // 0x1854217C640B39EC b1207
	// _SET_PED_(A?)*
	NATIVE_DECL void _SET_PED_DEFENSIVE_AREA_TO_ANGLED_AREA(Ped ped, float x1, float y1, float z1, float x2, float y2, float z2, Any p7, BOOL p8, BOOL p9, Entity entity, BOOL p11) { invoke<Void>(0xEB2BFE5D009F0331, ped, x1, y1, z1, x2, y2, z2, p7, p8, p9, entity, p11); } // 0xEB2BFE5D009F0331 b1232
	NATIVE_DECL void _SET_PED_DEFENSIVE_AREA_TO_ANGLED_AREA(Ped ped, Vector3 vec1, Vector3 vec2, Any p7, BOOL p8, BOOL p9, Entity entity, BOOL p11) { invoke<Void>(0xEB2BFE5D009F0331, ped, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, p7, p8, p9, entity, p11); } // 0xEB2BFE5D009F0331 b1232
	NATIVE_DECL void SET_PED_DEFENSIVE_AREA_DIRECTION(Ped ped, float p1, float p2, float p3, BOOL p4) { invoke<Void>(0x413C6C763A4AFFAD, ped, p1, p2, p3, p4); } // 0x413C6C763A4AFFAD 0xB66B0C9A b1207
	// Ped will no longer get angry when you stay near him.
	NATIVE_DECL void REMOVE_PED_DEFENSIVE_AREA(Ped ped, BOOL toggle) { invoke<Void>(0x74D4E028107450A9, ped, toggle); } // 0x74D4E028107450A9 0x34AAAFA5 b1207
	NATIVE_DECL Vector3 GET_PED_DEFENSIVE_AREA_POSITION(Ped ped, BOOL p1) { return invoke<Vector3>(0x3C06B8786DD94CD1, ped, p1); } // 0x3C06B8786DD94CD1 0xCB65198D b1207
	NATIVE_DECL BOOL IS_PED_DEFENSIVE_AREA_ACTIVE(Ped ped, BOOL p1) { return invoke<BOOL>(0xBA63D9FE45412247, ped, p1); } // 0xBA63D9FE45412247 0x6D88BCD3 b1207
	NATIVE_DECL Volume _GET_PED_DEFENSIVE_VOLUME(Ped ped, Any p1) { return invoke<Volume>(0xEF2E6F870783369B, ped, p1); } // 0xEF2E6F870783369B b1207
	// _SET_PED_A*
	NATIVE_DECL void _0x4EC4EA2F72B36358(Ped ped, BOOL p1) { invoke<Void>(0x4EC4EA2F72B36358, ped, p1); } // 0x4EC4EA2F72B36358 b1207
	// _SET_PED_COMBAT_*
	NATIVE_DECL void _0xCF0B19806473D324(Ped ped, float x, float y, float z) { invoke<Void>(0xCF0B19806473D324, ped, x, y, z); } // 0xCF0B19806473D324 b1207
	NATIVE_DECL void _0xCF0B19806473D324(Ped ped, Vector3 vec) { invoke<Void>(0xCF0B19806473D324, ped, vec.x, vec.y, vec.z); } // 0xCF0B19806473D324 b1207
	// _RESET_PED_C*
	NATIVE_DECL void _0xB4B7C92FCE7347B7(Ped ped) { invoke<Void>(0xB4B7C92FCE7347B7, ped); } // 0xB4B7C92FCE7347B7 b1207
	NATIVE_DECL void REVIVE_INJURED_PED(Ped ped) { invoke<Void>(0x8D8ACD8388CD99CE, ped); } // 0x8D8ACD8388CD99CE 0x14D3E6E3 b1207
	// This function will simply bring the dead ped back to life.
	// 
	// Before calling this function, you may want to declare the position, where your Resurrected ped to be spawn at because theres a chance the ped will fall through the map
	// 
	// Also, disabling any assigned task immediately helped in the number of scenarios, where If you want peds to perform certain decided tasks.
	NATIVE_DECL void RESURRECT_PED(Ped ped) { invoke<Void>(0x71BC8E838B9C6035, ped); } // 0x71BC8E838B9C6035 0xA4B82097 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void SET_PED_NAME_DEBUG(Ped ped, const char* name) { invoke<Void>(0x98EFA132A4117BE1, ped, name); } // 0x98EFA132A4117BE1 0x20D6273E b1207
	// _SP* - _ST*
	NATIVE_DECL void _0xF9ACF4A08098EA25(Ped ped, BOOL p1) { invoke<Void>(0xF9ACF4A08098EA25, ped, p1); } // 0xF9ACF4A08098EA25 0x141CC936 b1207
	// _HAS_*
	NATIVE_DECL BOOL _0x7020839C7302D8AC(Ped ped) { return invoke<BOOL>(0x7020839C7302D8AC, ped); } // 0x7020839C7302D8AC b1207
	// _C*
	NATIVE_DECL void _0xE1AADD0055D76603(Ped ped, Entity entity, int boneIndex1, int boneIndex2, float x, float y, float z, float p7, BOOL p8, BOOL p9, int p10) { invoke<Void>(0xE1AADD0055D76603, ped, entity, boneIndex1, boneIndex2, x, y, z, p7, p8, p9, p10); } // 0xE1AADD0055D76603 b1207
	NATIVE_DECL void _0xE1AADD0055D76603(Ped ped, Entity entity, int boneIndex1, int boneIndex2, Vector3 vec, float p7, BOOL p8, BOOL p9, int p10) { invoke<Void>(0xE1AADD0055D76603, ped, entity, boneIndex1, boneIndex2, vec.x, vec.y, vec.z, p7, p8, p9, p10); } // 0xE1AADD0055D76603 b1207
	// _C*
	NATIVE_DECL void _0x5A1A929C8B729B4A(Ped ped) { invoke<Void>(0x5A1A929C8B729B4A, ped); } // 0x5A1A929C8B729B4A b1207
	// _SET_PED_D*
	NATIVE_DECL void _0x97A38B65EBDA3D50(Ped ped, BOOL p1) { invoke<Void>(0x97A38B65EBDA3D50, ped, p1); } // 0x97A38B65EBDA3D50 b1207
	// _GET_PED_D*
	NATIVE_DECL BOOL _0x06A10B4D7F50B0C3(Ped ped) { return invoke<BOOL>(0x06A10B4D7F50B0C3, ped); } // 0x06A10B4D7F50B0C3 b1207
	NATIVE_DECL BOOL _0x88A5564B19C15391(Ped ped) { return invoke<BOOL>(0x88A5564B19C15391, ped); } // 0x88A5564B19C15391 b1207
	NATIVE_DECL int _0x354CA4DDDEEC397A(Ped ped) { return invoke<int>(0x354CA4DDDEEC397A, ped); } // 0x354CA4DDDEEC397A b1207
	// METAPED_PLAYER_COMPONENTS_SET_META_TYPE_TO_BE_BYPASSED: Setting visibility
	// _SET_M* - _SET_P*
	NATIVE_DECL void _0xFEA6126C34DF2532(Ped ped, BOOL p1) { invoke<Void>(0xFEA6126C34DF2532, ped, p1); } // 0xFEA6126C34DF2532 b1207
	// _SET_PED_P* - _SET_PED_R*
	NATIVE_DECL void _0xA967D6A8ED2D713B(Ped ped, BOOL p1) { invoke<Void>(0xA967D6A8ED2D713B, ped, p1); } // 0xA967D6A8ED2D713B b1207
	NATIVE_DECL void APPLY_PED_BLOOD_SPECIFIC(Ped ped, Any p1, float p2, float p3, float p4, float p5, Any p6, float p7, Any* p8) { invoke<Void>(0xEF0D582CBF2D9B0F, ped, p1, p2, p3, p4, p5, p6, p7, p8); } // 0xEF0D582CBF2D9B0F 0xFC13CE80 b1207
	NATIVE_DECL void _0x58D32261AE0F0843(Ped ped, int boneId, float p2, float p3, float p4, float p5, float p6, float p7, const char* p8) { invoke<Void>(0x58D32261AE0F0843, ped, boneId, p2, p3, p4, p5, p6, p7, p8); } // 0x58D32261AE0F0843 b1207
	// _SET_PED_F*
	NATIVE_DECL void _0x735662994E60A710(Ped ped, BOOL p1) { invoke<Void>(0x735662994E60A710, ped, p1); } // 0x735662994E60A710 b1207
	NATIVE_DECL void _0x91BAB9E064F036CD(Any p0, Any p1) { invoke<Void>(0x91BAB9E064F036CD, p0, p1); } // 0x91BAB9E064F036CD b1207
	NATIVE_DECL void _0x897934E868EDDD6C(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x897934E868EDDD6C, p0, p1, p2, p3, p4); } // 0x897934E868EDDD6C b1207
	// bloodFountainPressure: visible effect from 0.0 till 20.0
	// yaw: visible effect from -3.0 till 3.0
	// bloodFountainDirection: 1.0 left side, -1.0 right side
	// bloodFountainPulse: from 0.1 (low) till 1.0 (fast)
	// make blood fountain from your stomach: _SET_PED_ACTIVATE_WOUND_EFFECT(ped, unk, 2, 14411, 0.0, 0.1, 0.0, 0.0, 3.0, -1.0, 1.0)
	NATIVE_DECL void _SET_PED_ACTIVATE_WOUND_EFFECT(Ped ped, int p1, int boneId, float moveWoundLeftRight, float bloodFountainPressure, float yaw, float bloodFountainDirection, float bloodFountainPulse, float p8, float p9) { invoke<Void>(0xFFD54D9FE71B966A, ped, p1, boneId, moveWoundLeftRight, bloodFountainPressure, yaw, bloodFountainDirection, bloodFountainPulse, p8, p9); } // 0xFFD54D9FE71B966A b1207
	// Params: 0.0f to remove wound effects
	NATIVE_DECL void _UPDATE_PED_WOUND_EFFECT(Ped ped, float value) { invoke<Void>(0x66B1CB778D911F49, ped, value); } // 0x66B1CB778D911F49 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/peds_customization/ped_decals.lua
	NATIVE_DECL void APPLY_PED_DAMAGE_PACK(Ped ped, const char* damagePack, float damage, float mult) { invoke<Void>(0x46DF918788CB093F, ped, damagePack, damage, mult); } // 0x46DF918788CB093F 0x208D0CB8 b1207
	NATIVE_DECL void CLEAR_PED_BLOOD_DAMAGE(Ped ped) { invoke<Void>(0x8FE22675A5A45817, ped); } // 0x8FE22675A5A45817 0xF7ADC960 b1207
	NATIVE_DECL void CLEAR_PED_BLOOD_DAMAGE_BY_ZONE(Ped ped, int p1) { invoke<Void>(0x56E3B78C5408D9F4, ped, p1); } // 0x56E3B78C5408D9F4 0xF210BE69 b1207
	NATIVE_DECL void CLEAR_PED_DAMAGE_DECAL_BY_ZONE(Ped ped, int p1, const char* p2) { invoke<Void>(0x523C79AEEFCC4A2A, ped, p1, p2); } // 0x523C79AEEFCC4A2A 0x70AA5B7D b1207
	NATIVE_DECL void _CLEAR_PED_BLOOD_DAMAGE_FACIAL(Ped ped, int p1) { invoke<Void>(0x7F5D88333EE8A86F, ped, p1); } // 0x7F5D88333EE8A86F b1207
	NATIVE_DECL void _0x34C11114887150FD(Any p0, Any p1) { invoke<Void>(0x34C11114887150FD, p0, p1); } // 0x34C11114887150FD b1207
	// METAPED_PLAYER_COMPONENTS_SET_META_TYPE_TO_BE_BYPASSED: Setting visibility
	// p1 is mostly 10
	// _CLEAR_PED_N* - _CLEAR_PED_W*
	NATIVE_DECL void _0xD8544F6260F5F01E(Ped ped, int p1) { invoke<Void>(0xD8544F6260F5F01E, ped, p1); } // 0xD8544F6260F5F01E b1232
	// Washing player's face/hands now
	// _FA* - _FI*
	NATIVE_DECL void _0xEB8886E1065654CD(Ped ped, int p1, const char* p2, float p3) { invoke<Void>(0xEB8886E1065654CD, ped, p1, p2, p3); } // 0xEB8886E1065654CD b1207
	NATIVE_DECL void FADE_AND_DESTROY_PED(Ped* ped) { invoke<Void>(0x7043D0681285BA2D, ped); } // 0x7043D0681285BA2D b1207
	NATIVE_DECL BOOL _IS_PED_QUEUED_FOR_DELETION(Ped ped) { return invoke<BOOL>(0x8D9BFCE3352DE47F, ped); } // 0x8D9BFCE3352DE47F b1207
	// It clears the wetness of the selected Ped/Player. Clothes have to be wet to notice the difference.
	NATIVE_DECL void CLEAR_PED_WETNESS(Ped ped) { invoke<Void>(0x9C720776DAA43E7E, ped); } // 0x9C720776DAA43E7E 0x629F15BD b1207
	// It adds the wetness level to the player clothing/outfit. As if player just got out from water surface.
	NATIVE_DECL void SET_PED_WETNESS_HEIGHT(Ped ped, float height) { invoke<Void>(0x44CB6447D2571AA0, ped, height); } // 0x44CB6447D2571AA0 0x7B33289A b1207
	// _SET_PED_WETNESS*
	NATIVE_DECL void _0xF9CFF5BB70E8A2CB(Ped ped, float p1) { invoke<Void>(0xF9CFF5BB70E8A2CB, ped, p1); } // 0xF9CFF5BB70E8A2CB b1207
	// combined with PED::SET_PED_WETNESS_HEIGHT(), this native makes the ped drenched in water up to the height specified in the other function
	NATIVE_DECL void SET_PED_WETNESS_ENABLED_THIS_FRAME(Ped ped) { invoke<Void>(0xB5485E4907B53019, ped); } // 0xB5485E4907B53019 0xBDE749F7 b1207
	// Washing player's face/hands now
	// _CLEAR_PED_E* - _CLEAR_PED_L*
	NATIVE_DECL void _0xA7A806677F8DE138(Ped ped) { invoke<Void>(0xA7A806677F8DE138, ped); } // 0xA7A806677F8DE138 b1207
	NATIVE_DECL void _0xA064BBABB064446F(Any p0) { invoke<Void>(0xA064BBABB064446F, p0); } // 0xA064BBABB064446F b1207
	NATIVE_DECL void CLEAR_PED_ENV_DIRT(Ped ped) { invoke<Void>(0x6585D955A68452A5, ped); } // 0x6585D955A68452A5 0xA993915F b1207
	NATIVE_DECL void SET_PED_SWEAT(Ped ped, float sweat) { invoke<Void>(0x27B0405F59637D1F, ped, sweat); } // 0x27B0405F59637D1F 0x76A1DB9F b1207
	NATIVE_DECL void CLEAR_PED_DECORATIONS(Ped ped) { invoke<Void>(0x0E5173C163976E38, ped); } // 0x0E5173C163976E38 0xD4496BF3 b1207
	// Despite this function's name, it simply returns whether the specified handle is a Ped.
	NATIVE_DECL BOOL WAS_PED_SKELETON_UPDATED(Ped ped) { return invoke<BOOL>(0x11B499C1E0FF8559, ped); } // 0x11B499C1E0FF8559 0xF7E2FBAD b1207
	// Gets the position of the specified bone of the specified ped.
	// 
	// ped: The ped to get the position of a bone from.
	// boneId: The ID of the bone to get the position from. This is NOT the index.
	// offsetX: The X-component of the offset to add to the position relative to the bone's rotation.
	// offsetY: The Y-component of the offset to add to the position relative to the bone's rotation.
	// offsetZ: The Z-component of the offset to add to the position relative to the bone's rotation.
	NATIVE_DECL Vector3 GET_PED_BONE_COORDS(Ped ped, int boneId, float offsetX, float offsetY, float offsetZ) { return invoke<Vector3>(0x17C07FC640E86B4E, ped, boneId, offsetX, offsetY, offsetZ); } // 0x17C07FC640E86B4E 0x4579CAB1 b1207
	NATIVE_DECL Vector3 GET_PED_BONE_COORDS(Ped ped, int boneId, Vector3 offset) { return invoke<Vector3>(0x17C07FC640E86B4E, ped, boneId, offset.x, offset.y, offset.z); } // 0x17C07FC640E86B4E 0x4579CAB1 b1207
	// blockingFlags: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/ADD_SCENARIO_BLOCKING_AREA/README.md
	NATIVE_DECL int ADD_SCENARIO_BLOCKING_AREA(float x1, float y1, float z1, float x2, float y2, float z2, BOOL p6, int blockingFlags) { return invoke<int>(0x1B5C85C612E5256E, x1, y1, z1, x2, y2, z2, p6, blockingFlags); } // 0x1B5C85C612E5256E 0xA38C0234 b1207
	NATIVE_DECL int ADD_SCENARIO_BLOCKING_AREA(Vector3 vec1, Vector3 vec2, BOOL p6, int blockingFlags) { return invoke<int>(0x1B5C85C612E5256E, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, p6, blockingFlags); } // 0x1B5C85C612E5256E 0xA38C0234 b1207
	NATIVE_DECL void REMOVE_SCENARIO_BLOCKING_AREAS() { invoke<Void>(0xD37401D78A929A49); } // 0xD37401D78A929A49 0x4DDF845F b1207
	NATIVE_DECL void REMOVE_SCENARIO_BLOCKING_AREA(Any p0, BOOL p1) { invoke<Void>(0x31D16B74C6E29D66, p0, p1); } // 0x31D16B74C6E29D66 0x4483EF06 b1207
	// flag: see ADD_SCENARIO_BLOCKING_AREA
	NATIVE_DECL Any _ADD_SCENARIO_BLOCKING_VOLUME(Volume volume, BOOL p1, int flag) { return invoke<Any>(0x4C39C95AE5DB1329, volume, p1, flag); } // 0x4C39C95AE5DB1329 b1207
	NATIVE_DECL Any _0x6F46F8ACB44C4FC1(Any p0) { return invoke<Any>(0x6F46F8ACB44C4FC1, p0); } // 0x6F46F8ACB44C4FC1 b1207
	NATIVE_DECL BOOL _IS_SCENARIO_BLOCKING_AREA_VALID(Any p0) { return invoke<BOOL>(0x91A5F9CBEBB9D936, p0); } // 0x91A5F9CBEBB9D936 b1207
	// Equivalent to IS_PED_USING_SCENARIO from V but takes a hash instead of a string.
	NATIVE_DECL BOOL IS_PED_USING_SCENARIO_HASH(Ped ped, Hash scenarioHash) { return invoke<BOOL>(0x34D6AC1157C8226C, ped, scenarioHash); } // 0x34D6AC1157C8226C b1207
	NATIVE_DECL BOOL IS_PED_USING_ANY_SCENARIO(Ped ped) { return invoke<BOOL>(0x57AB4A3080F85143, ped); } // 0x57AB4A3080F85143 0x195EF5B7 b1207
	NATIVE_DECL BOOL IS_PED_USING_THIS_SCENARIO(Ped ped, int scenario) { return invoke<BOOL>(0x9C54041BB66BCF9E, ped, scenario); } // 0x9C54041BB66BCF9E b1207
	// p2 is always 0, p3 is always 0, p4 is always 1
	NATIVE_DECL BOOL _CAN_PED_USE_SCENARIO_POINT(Ped ped, int scenario, Any p2, Any p3, Any p4) { return invoke<BOOL>(0xAB643407D0B26F07, ped, scenario, p2, p3, p4); } // 0xAB643407D0B26F07 b1207
	// _CAN_PED_SEE* - _CAN_PED_USE_(SCENARIO_HASH?)*
	NATIVE_DECL BOOL _0x1148F706CF4EBDDA(Ped ped, Hash p1, int p2) { return invoke<BOOL>(0x1148F706CF4EBDDA, ped, p1, p2); } // 0x1148F706CF4EBDDA b1207
	NATIVE_DECL BOOL SET_PED_PANIC_EXIT_SCENARIO(Ped ped, float x, float y, float z) { return invoke<BOOL>(0xFE07FF6495D52E2A, ped, x, y, z); } // 0xFE07FF6495D52E2A 0x59DE73AC b1207
	NATIVE_DECL BOOL SET_PED_PANIC_EXIT_SCENARIO(Ped ped, Vector3 vec) { return invoke<BOOL>(0xFE07FF6495D52E2A, ped, vec.x, vec.y, vec.z); } // 0xFE07FF6495D52E2A 0x59DE73AC b1207
	// If toggle is true, when the ped is using a scenario he will stop it and become scared
	// If toggle is false, the ped will not be scared anymore and continue his scenario
	NATIVE_DECL void _SET_PED_SCARED_WHEN_USING_SCENARIO(Ped ped, BOOL toggle) { invoke<Void>(0x9A77DFD295E29B09, ped, toggle); } // 0x9A77DFD295E29B09 0xC08FE5F6 b1207
	NATIVE_DECL void _0xD8CEEED54C672B5D(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { invoke<Void>(0xD8CEEED54C672B5D, p0, p1, p2, p3, p4, p5, p6); } // 0xD8CEEED54C672B5D b1207
	NATIVE_DECL BOOL _SET_PED_SHOULD_PLAY_DIRECTED_SCENARIO_EXIT(Ped ped, float x, float y, float z) { return invoke<BOOL>(0xEC6935EBE0847B90, ped, x, y, z); } // 0xEC6935EBE0847B90 0x761F8F48 b1207
	NATIVE_DECL BOOL _SET_PED_SHOULD_PLAY_DIRECTED_SCENARIO_EXIT(Ped ped, Vector3 vec) { return invoke<BOOL>(0xEC6935EBE0847B90, ped, vec.x, vec.y, vec.z); } // 0xEC6935EBE0847B90 0x761F8F48 b1207
	NATIVE_DECL void SET_PED_SHOULD_PLAY_NORMAL_SCENARIO_EXIT(Ped ped) { invoke<Void>(0xA3A9299C4F2ADB98, ped); } // 0xA3A9299C4F2ADB98 0x033F43FA b1207
	NATIVE_DECL void SET_PED_SHOULD_PLAY_IMMEDIATE_SCENARIO_EXIT(Ped ped) { invoke<Void>(0xF1C03A5352243A30, ped); } // 0xF1C03A5352243A30 0x4C684C81 b1207
	// lookIntensity:
	// 0 - REACT_LOOK_NONE
	// 1 - REACT_LOOK_LOW
	// 2 - REACT_LOOK_MEDIUM
	// 3 - REACT_LOOK_HIGH
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT(Ped ped, float x, float y, float z, int lookIntensity) { return invoke<BOOL>(0xEEED8FAFEC331A70, ped, x, y, z, lookIntensity); } // 0xEEED8FAFEC331A70 0x7B4C3E6F b1207
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT(Ped ped, Vector3 vec, int lookIntensity) { return invoke<BOOL>(0xEEED8FAFEC331A70, ped, vec.x, vec.y, vec.z, lookIntensity); } // 0xEEED8FAFEC331A70 0x7B4C3E6F b1207
	// lookIntensity: see SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_COMBAT_SCENARIO_EXIT(Ped ped, float x, float y, float z, int lookIntensity) { return invoke<BOOL>(0x802092B07E3B1EEA, ped, x, y, z, lookIntensity); } // 0x802092B07E3B1EEA b1207
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_COMBAT_SCENARIO_EXIT(Ped ped, Vector3 vec, int lookIntensity) { return invoke<BOOL>(0x802092B07E3B1EEA, ped, vec.x, vec.y, vec.z, lookIntensity); } // 0x802092B07E3B1EEA b1207
	// lookIntensity: see SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_EMOTIONAL_SCENARIO_EXIT(Ped ped, float x, float y, float z, int lookIntensity, BOOL p5) { return invoke<BOOL>(0x62FDAD5E01D2DD47, ped, x, y, z, lookIntensity, p5); } // 0x62FDAD5E01D2DD47 b1207
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_EMOTIONAL_SCENARIO_EXIT(Ped ped, Vector3 vec, int lookIntensity, BOOL p5) { return invoke<BOOL>(0x62FDAD5E01D2DD47, ped, vec.x, vec.y, vec.z, lookIntensity, p5); } // 0x62FDAD5E01D2DD47 b1207
	// lookIntensity: see SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_QUICK_SCENARIO_EXIT(Ped ped, float x, float y, float z, int lookIntensity, BOOL p5) { return invoke<BOOL>(0x463803429297117C, ped, x, y, z, lookIntensity, p5); } // 0x463803429297117C b1207
	NATIVE_DECL BOOL SET_PED_SHOULD_PLAY_QUICK_SCENARIO_EXIT(Ped ped, Vector3 vec, int lookIntensity, BOOL p5) { return invoke<BOOL>(0x463803429297117C, ped, vec.x, vec.y, vec.z, lookIntensity, p5); } // 0x463803429297117C b1207
	NATIVE_DECL BOOL _0xF9331B3A314EB49D(Ped ped) { return invoke<BOOL>(0xF9331B3A314EB49D, ped); } // 0xF9331B3A314EB49D b1207
	NATIVE_DECL void _0xE735A7DA22E88359(Any p0) { invoke<Void>(0xE735A7DA22E88359, p0); } // 0xE735A7DA22E88359 b1207
	NATIVE_DECL Any _0x82CB0F3F0C7785E5(Any p0) { return invoke<Any>(0x82CB0F3F0C7785E5, p0); } // 0x82CB0F3F0C7785E5 b1207
	NATIVE_DECL void _0xCA95C156C14B2054(Any p0, Any p1) { invoke<Void>(0xCA95C156C14B2054, p0, p1); } // 0xCA95C156C14B2054 b1207
	NATIVE_DECL void SET_FACIAL_IDLE_ANIM_OVERRIDE(Ped ped, const char* animName, const char* animDict) { invoke<Void>(0xFFC24B988B938B38, ped, animName, animDict); } // 0xFFC24B988B938B38 0x9BA19C13 b1207
	NATIVE_DECL void CLEAR_FACIAL_IDLE_ANIM_OVERRIDE(Ped ped) { invoke<Void>(0x726256CC1EEB182F, ped); } // 0x726256CC1EEB182F 0x5244F4E2 b1207
	// Hashes: MOODAGITATED, MOODAIMING, MOODANGRY, MOODBITCHY, MOODCONCENTRATION, MOODCONCENTRATIONEXTREME, MOODCURIOUS, MOODDEAD, MOODDEFUSE, MOODEXERTIONEXTREME, MOODEXERTIONMEDIUM, MOODEXERTIONMILD, MOODHAPPY, MOODINJUREDMILD, MOODINTIMIDATED, MOODKNOCKEDOUT, MOODNERVOUS, MOODNORMAL, MOODNORMALNEUTRAL, MOODPANIC, MOODSCARED, MOODSHOCKED, MOODSLEEPING, MOODSMUG, MOODTIRED
	// Params: p2 = 6 in R* Scripts
	NATIVE_DECL void _REQUEST_PED_FACIAL_MOOD_THIS_FRAME(Ped ped, Hash mood, int p2) { invoke<Void>(0x8B3B71C80A29A4BB, ped, mood, p2); } // 0x8B3B71C80A29A4BB b1207
	NATIVE_DECL void _0xD2F0FE8805D91647(Any p0, Any p1) { invoke<Void>(0xD2F0FE8805D91647, p0, p1); } // 0xD2F0FE8805D91647 b1207
	NATIVE_DECL void SET_PED_CAN_PLAY_GESTURE_ANIMS(Ped ped, Any p1, Any p2) { invoke<Void>(0xBAF20C5432058024, ped, p1, p2); } // 0xBAF20C5432058024 0xE131E3B3 b1207
	// Only used in R* Script net_moonshine_property
	// _A* - _B*
	NATIVE_DECL void _0x7EDB3C766B0D073F(Ped ped) { invoke<Void>(0x7EDB3C766B0D073F, ped); } // 0x7EDB3C766B0D073F b1232
	NATIVE_DECL void SET_PED_CAN_PLAY_AMBIENT_ANIMS(Ped ped, BOOL toggle) { invoke<Void>(0x6373D1349925A70E, ped, toggle); } // 0x6373D1349925A70E 0xF8053081 b1207
	NATIVE_DECL void SET_PED_CAN_PLAY_AMBIENT_BASE_ANIMS(Ped ped, BOOL toggle) { invoke<Void>(0x0EB0585D15254740, ped, toggle); } // 0x0EB0585D15254740 0x5720A5DD b1207
	// Only used in R* Script shop_harriet
	// _SET_PED_F*
	NATIVE_DECL void _0x4F63433CE3C08230(Ped ped, BOOL p1) { invoke<Void>(0x4F63433CE3C08230, ped, p1); } // 0x4F63433CE3C08230 b1311
	NATIVE_DECL void SET_PED_CAN_ARM_IK(Ped ped, BOOL toggle) { invoke<Void>(0x6C3B4D6D13B4C841, ped, toggle); } // 0x6C3B4D6D13B4C841 0x343B4DE0 b1207
	// _SET_PED_CAN_(?)_IK*
	NATIVE_DECL void _SET_PED_CAN_UNK_BODYPART_IK(Ped ped, BOOL toggle) { invoke<Void>(0xEE9DF765990E8D1D, ped, toggle); } // 0xEE9DF765990E8D1D b1207
	NATIVE_DECL void SET_PED_CAN_HEAD_IK(Ped ped, BOOL toggle) { invoke<Void>(0xC11C18092C5530DC, ped, toggle); } // 0xC11C18092C5530DC 0xD3B04476 b1207
	NATIVE_DECL void SET_PED_CAN_LEG_IK(Ped ped, BOOL toggle) { invoke<Void>(0x73518ECE2485412B, ped, toggle); } // 0x73518ECE2485412B 0x9955BC6F b1207
	NATIVE_DECL void SET_PED_CAN_TORSO_IK(Ped ped, BOOL toggle) { invoke<Void>(0xF2B7106D37947CE0, ped, toggle); } // 0xF2B7106D37947CE0 0x8E5D4EAB b1207
	NATIVE_DECL void SET_PED_CAN_TORSO_REACT_IK(Ped ped, BOOL toggle) { invoke<Void>(0xF5846EDB26A98A24, ped, toggle); } // 0xF5846EDB26A98A24 0x7B0040A8 b1207
	NATIVE_DECL void SET_PED_CAN_TORSO_VEHICLE_IK(Ped ped, BOOL toggle) { invoke<Void>(0x6647C5F6F5792496, ped, toggle); } // 0x6647C5F6F5792496 0x0FDA62DE b1207
	NATIVE_DECL void SET_PED_CAN_USE_AUTO_CONVERSATION_LOOKAT(Ped ped, BOOL toggle) { invoke<Void>(0xEC4686EC06434678, ped, toggle); } // 0xEC4686EC06434678 0x584C5178 b1207
	NATIVE_DECL BOOL IS_PED_HEADTRACKING_PED(Ped ped1, Ped ped2) { return invoke<BOOL>(0x5CD3CB88A7F8850D, ped1, ped2); } // 0x5CD3CB88A7F8850D 0x2A5DF721 b1207
	NATIVE_DECL BOOL IS_PED_HEADTRACKING_ENTITY(Ped ped, Entity entity) { return invoke<BOOL>(0x813A0A7C9D2E831F, ped, entity); } // 0x813A0A7C9D2E831F 0x233C9ACF b1207
	NATIVE_DECL void _DISABLE_AMBIENT_LOOK_AT_REQUESTS(Any p0, Any p1) { invoke<Void>(0x80038740C96AD17F, p0, p1); } // 0x80038740C96AD17F b1207
	NATIVE_DECL void _DISABLE_ALL_LOOK_AT_REQUESTS(Ped ped, int p1) { invoke<Void>(0xE1965A380342BE1F, ped, p1); } // 0xE1965A380342BE1F b1355
	// _SET_PED_R* - _SET_PED_S*
	NATIVE_DECL void _0xCD9E5F94A2F38683(Ped ped, BOOL p1) { invoke<Void>(0xCD9E5F94A2F38683, ped, p1); } // 0xCD9E5F94A2F38683 b1207
	NATIVE_DECL void SET_PED_CLOTH_PACKAGE_INDEX(Ped ped, BOOL p1) { invoke<Void>(0x78C4E9961DB3EB5B, ped, p1); } // 0x78C4E9961DB3EB5B 0xFC942D7C b1207
	// _SET_PED_CA* - _SET_PED_CO*
	NATIVE_DECL void _0x1D4636C90BBEFACB(Ped ped, int p1) { invoke<Void>(0x1D4636C90BBEFACB, ped, p1); } // 0x1D4636C90BBEFACB b1207
	// _ADD_*
	NATIVE_DECL void _0xEF371232BC6053E1(Ped ped) { invoke<Void>(0xEF371232BC6053E1, ped); } // 0xEF371232BC6053E1 b1207
	// _SET_PED_*
	NATIVE_DECL void _0x86F0B6730C32AC14(Ped ped, BOOL p1) { invoke<Void>(0x86F0B6730C32AC14, ped, p1); } // 0x86F0B6730C32AC14 b1207
	// _ATTACH_*
	NATIVE_DECL void _0x8101BA1C0B462412(Ped ped, int ropeId) { invoke<Void>(0x8101BA1C0B462412, ped, ropeId); } // 0x8101BA1C0B462412 b1207
	// flagId: https://alloc8or.re/rdr3/doc/enums/ePedScriptConfigFlags.txt
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/CPED_CONFIG_FLAGS
	NATIVE_DECL void SET_PED_CONFIG_FLAG(Ped ped, int flagId, BOOL value) { invoke<Void>(0x1913FE4CBF41C463, ped, flagId, value); } // 0x1913FE4CBF41C463 0x9CFBE10D b1207
	// Needs to be called every frame
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/CPED_RESET_FLAGS
	NATIVE_DECL void SET_PED_RESET_FLAG(Ped ped, int flagId, BOOL doReset) { invoke<Void>(0xC1E8A365BF3B29F2, ped, flagId, doReset); } // 0xC1E8A365BF3B29F2 0xCFF6FF66 b1207
	// flagId: see SET_PED_CONFIG_FLAG
	NATIVE_DECL BOOL GET_PED_CONFIG_FLAG(Ped ped, int flagId, BOOL p2) { return invoke<BOOL>(0x7EE53118C892B513, ped, flagId, p2); } // 0x7EE53118C892B513 0xABE98267 b1207
	NATIVE_DECL BOOL GET_PED_RESET_FLAG(Ped ped, int flagId) { return invoke<BOOL>(0xAF9E59B1B1FBF2A0, ped, flagId); } // 0xAF9E59B1B1FBF2A0 0x2FC10D11 b1207
	NATIVE_DECL void _0xC6981AFF6D2A71C2(Any p0) { invoke<Void>(0xC6981AFF6D2A71C2, p0); } // 0xC6981AFF6D2A71C2 b1207
	NATIVE_DECL void _0xE0FE107AB174D64A(Any p0, Any p1) { invoke<Void>(0xE0FE107AB174D64A, p0, p1); } // 0xE0FE107AB174D64A b1207
	NATIVE_DECL void SET_PED_GROUP_MEMBER_PASSENGER_INDEX(Ped ped, int index) { invoke<Void>(0x0BDDB8D9EC6BCF3C, ped, index); } // 0x0BDDB8D9EC6BCF3C 0x2AB3670B b1207
	// Presumably returns the Entity that the Ped is currently diving out of the way of.
	NATIVE_DECL BOOL IS_PED_EVASIVE_DIVING(Ped ped, Entity* evadingEntity) { return invoke<BOOL>(0x414641C26E105898, ped, evadingEntity); } // 0x414641C26E105898 0xD82829DC b1207
	// Params: p5 = -1 in R* Scripts
	NATIVE_DECL Any _SHOOT_TRIGGER_AT_COORDS(Ped ped, float x, float y, float z, int p4, float p5, int p6, float p7) { return invoke<Any>(0x4C57F27D1554E6B0, ped, x, y, z, p4, p5, p6, p7); } // 0x4C57F27D1554E6B0 b1207
	NATIVE_DECL Any _SHOOT_TRIGGER_AT_COORDS(Ped ped, Vector3 vec, int p4, float p5, int p6, float p7) { return invoke<Any>(0x4C57F27D1554E6B0, ped, vec.x, vec.y, vec.z, p4, p5, p6, p7); } // 0x4C57F27D1554E6B0 b1207
	NATIVE_DECL BOOL _IS_THIS_MODEL_A_HORSE(Hash model) { return invoke<BOOL>(0x772A1969F649E902, model); } // 0x772A1969F649E902 b1207
	NATIVE_DECL void SET_PED_MODEL_IS_SUPPRESSED(Ped ped, BOOL toggle) { invoke<Void>(0xE163A4BCE4DE6F11, ped, toggle); } // 0xE163A4BCE4DE6F11 0x7820CA43 b1207
	NATIVE_DECL BOOL _IS_PED_MODEL_SUPPRESSED(Hash model) { return invoke<BOOL>(0xAA9F048DCF69B6DC, model); } // 0xAA9F048DCF69B6DC b1207
	NATIVE_DECL void _0x7ABBD9E449E0DB00(Any p0, Any p1) { invoke<Void>(0x7ABBD9E449E0DB00, p0, p1); } // 0x7ABBD9E449E0DB00 b1207
	// Disables being able to kick move ped.
	NATIVE_DECL void _SET_PED_DISABLE_KICK_MOVE(Ped ped, BOOL disable) { invoke<Void>(0xADD31A5C7A5FAA73, ped, disable); } // 0xADD31A5C7A5FAA73 b1207
	NATIVE_DECL void SET_PED_CAN_RAGDOLL_FROM_PLAYER_IMPACT(Ped ped, BOOL toggle) { invoke<Void>(0xDF993EE5E90ABA25, ped, toggle); } // 0xDF993EE5E90ABA25 0xE9BD733A b1207
	NATIVE_DECL void _0xE6CB36F43A95D75F(Any p0) { invoke<Void>(0xE6CB36F43A95D75F, p0); } // 0xE6CB36F43A95D75F b1207
	NATIVE_DECL void SET_PED_LEG_IK_MODE(Ped ped, int mode) { invoke<Void>(0xC396F5B86FF9FEBD, ped, mode); } // 0xC396F5B86FF9FEBD 0xFDDB042E b1207
	// If returned true: There are enemy peds near friendly turn in ped. Going to aggro.
	// If returned false: Moving back to idle as there aren't any remaining enemy peds near ped
	// _IS_PED_IN_*
	NATIVE_DECL BOOL _0x078076AB50FB117F(Ped ped, float x, float y, float z, float p4, BOOL p5) { return invoke<BOOL>(0x078076AB50FB117F, ped, x, y, z, p4, p5); } // 0x078076AB50FB117F b1207
	NATIVE_DECL BOOL _0x078076AB50FB117F(Ped ped, Vector3 vec, float p4, BOOL p5) { return invoke<BOOL>(0x078076AB50FB117F, ped, vec.x, vec.y, vec.z, p4, p5); } // 0x078076AB50FB117F b1207
	// SET_PED_CAN_*
	NATIVE_DECL void _SET_PED_CAN_BE_LASSOED(Ped ped, BOOL toggle) { invoke<Void>(0xFD6943B6DF77E449, ped, toggle); } // 0xFD6943B6DF77E449 b1207
	// 0 - Stationary (Will just stand in place)
	// 1 - Defensive (Will try to find cover and very likely to blind fire)
	// 2 - Offensive (Will attempt to charge at enemy but take cover as well)
	// 3 - Suicidal Offensive (Will try to flank enemy in a suicidal attack)
	NATIVE_DECL void SET_PED_COMBAT_MOVEMENT(Ped ped, int combatMovement) { invoke<Void>(0x4D9CA1009AFBD057, ped, combatMovement); } // 0x4D9CA1009AFBD057 0x12E62F9E b1207
	NATIVE_DECL int GET_PED_COMBAT_MOVEMENT(Ped ped) { return invoke<int>(0xDEA92412FCAEB3F5, ped); } // 0xDEA92412FCAEB3F5 0xF3E7730E b1207
	// _SET_PED_COMBAT_R - _SET_PED_C*
	NATIVE_DECL void _0x815C0074A1BC0D93(Ped ped, int p1) { invoke<Void>(0x815C0074A1BC0D93, ped, p1); } // 0x815C0074A1BC0D93 b1207
	// _GET_PED_COMBAT_M* - _GET_PED_C*
	NATIVE_DECL int _0xFFDE295662405B25(Ped ped) { return invoke<int>(0xFFDE295662405B25, ped); } // 0xFFDE295662405B25 b1207
	// abilityLevel:
	// enum eCombatAbilityLevel
	// {
	// 	CAL_POOR,
	// 	CAL_AVERAGE,
	// 	CAL_PROFESSIONAL
	// };
	NATIVE_DECL void SET_PED_COMBAT_ABILITY(Ped ped, int abilityLevel) { invoke<Void>(0xC7622C0D36B2FDA8, ped, abilityLevel); } // 0xC7622C0D36B2FDA8 0x6C23D329 b1207
	// range:
	// enum eCombatRange
	// {
	// 	CR_NEAR,
	// 	CR_MEDIUM,
	// 	CR_FAR,
	// 	CR_VERY_FAR
	// };
	NATIVE_DECL void SET_PED_COMBAT_RANGE(Ped ped, int range) { invoke<Void>(0x3C606747B23E497B, ped, range); } // 0x3C606747B23E497B 0x8818A959 b1207
	// attributeIndex: https://alloc8or.re/rdr3/doc/enums/eCombatAttribute.txt
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/COMBAT_ATTRIBUTES
	NATIVE_DECL void SET_PED_COMBAT_ATTRIBUTES(Ped ped, int attributeIndex, BOOL enabled) { invoke<Void>(0x9F7794730795E019, ped, attributeIndex, enabled); } // 0x9F7794730795E019 0x81D64248 b1207
	// _GET_PED_COMBAT_*
	NATIVE_DECL BOOL _0xCC2B20596E29E4E3(Ped ped, int p1) { return invoke<BOOL>(0xCC2B20596E29E4E3, ped, p1); } // 0xCC2B20596E29E4E3 b1207
	// Hashes: GUARD, COMBAT_ANIMAL, LAW, LAW_SHERIFF
	// _SET_PED_COMBAT_A* - _SET_PED_COMBAT_M*
	NATIVE_DECL void _SET_PED_COMBAT_ATTRIBUTE_HASH(Ped ped, Hash p1) { invoke<Void>(0xBD75500141E4725C, ped, p1); } // 0xBD75500141E4725C b1207
	// TLR_ExitTask = 0,
	// TLR_NeverLoseTarget,
	// TLR_SearchForTarget
	NATIVE_DECL void SET_PED_TARGET_LOSS_RESPONSE(Ped ped, int responseType) { invoke<Void>(0x0703B9079823DA4A, ped, responseType); } // 0x0703B9079823DA4A 0xCFA613FF b1207
	NATIVE_DECL void _0x0A4618FFD517E24D(Any p0, Any p1) { invoke<Void>(0x0A4618FFD517E24D, p0, p1); } // 0x0A4618FFD517E24D b1207
	// _SET_PED_MO*
	NATIVE_DECL void _0x712B2C2B2471B493(Ped ped, Hash p1) { invoke<Void>(0x712B2C2B2471B493, ped, p1); } // 0x712B2C2B2471B493 b1207
	NATIVE_DECL void _0x00B380FF2DF6AB7A(Any p0, Any p1) { invoke<Void>(0x00B380FF2DF6AB7A, p0, p1); } // 0x00B380FF2DF6AB7A b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/COMBAT_STYLES
	// Params: p2 is usually 1, sometimes 0 or 2
	// duration in seconds, -1.0 = forever
	NATIVE_DECL void _SET_PED_COMBAT_STYLE(Ped ped, Hash combatStyleHash, int p2, float duration) { invoke<Void>(0x8ACC0506743A8A5C, ped, combatStyleHash, p2, duration); } // 0x8ACC0506743A8A5C b1207
	// Params: p1 = 1 in R* Scripts
	NATIVE_DECL void _CLEAR_PED_COMBAT_STYLE(Ped ped, int p1) { invoke<Void>(0x78815FC52832B690, ped, p1); } // 0x78815FC52832B690 b1207
	// duration in seconds, -1.0 = forever
	NATIVE_DECL void _SET_PED_COMBAT_STYLE_MOD(Ped ped, Hash combatStyleModHash, float duration) { invoke<Void>(0x8B1E8E35A6E814EA, ped, combatStyleModHash, duration); } // 0x8B1E8E35A6E814EA b1207
	// _CLEAR_PED_COMBAT_*
	NATIVE_DECL void _0x1FA132CBCD7CB239(Ped ped, Hash p1) { invoke<Void>(0x1FA132CBCD7CB239, ped, p1); } // 0x1FA132CBCD7CB239 b1207
	// _IS_PED_B* - _IS_PED_C*
	NATIVE_DECL BOOL _0x5BF0B9D9A8E227A0(Ped ped) { return invoke<BOOL>(0x5BF0B9D9A8E227A0, ped); } // 0x5BF0B9D9A8E227A0 b1207
	// _SET_PED_M*
	NATIVE_DECL void _0x642720D8D69328B6(Ped ped, Hash p1) { invoke<Void>(0x642720D8D69328B6, ped, p1); } // 0x642720D8D69328B6 b1207
	NATIVE_DECL BOOL IS_PED_PERFORMING_MELEE_ACTION(Ped ped, int p1, Hash p2) { return invoke<BOOL>(0xDCCA191DF9980FD7, ped, p1, p2); } // 0xDCCA191DF9980FD7 0x139C0875 b1207
	// _CAN_PED_*
	NATIVE_DECL BOOL _0x99DF2639DA76C1DC(Ped ped1, Ped ped2, int p2) { return invoke<BOOL>(0x99DF2639DA76C1DC, ped1, ped2, p2); } // 0x99DF2639DA76C1DC b1232
	NATIVE_DECL float _GET_PED_MELEE_ACTION_PHASE(Ped ped) { return invoke<float>(0x6127F25ED21C533C, ped); } // 0x6127F25ED21C533C b1207
	NATIVE_DECL BOOL IS_PED_BEING_STEALTH_KILLED(Ped ped) { return invoke<BOOL>(0x863B23EFDE9C5DF2, ped); } // 0x863B23EFDE9C5DF2 0xD044C8AF b1207
	NATIVE_DECL Ped GET_MELEE_TARGET_FOR_PED(Ped ped) { return invoke<Ped>(0x18A3E9EE1297FD39, ped); } // 0x18A3E9EE1297FD39 0xAFEC26A4 b1207
	NATIVE_DECL void _0xDEDBED3020DA49DC(Any p0) { invoke<Void>(0xDEDBED3020DA49DC, p0); } // 0xDEDBED3020DA49DC b1207
	NATIVE_DECL void _0xA405BF9F01960C16(Any p0) { invoke<Void>(0xA405BF9F01960C16, p0); } // 0xA405BF9F01960C16 b1207
	NATIVE_DECL Hash _GET_PED_BRAWLING_STYLE(Ped ped) { return invoke<Hash>(0xEC6B59BE445FEC51, ped); } // 0xEC6B59BE445FEC51 b1207
	// brawlingStyle:
	// enum eBrawlingStyle : Hash
	// {
	// 	BS_AI = 0x802C604D,
	// 	BS_AI_BARBRAWL = 0x4FF5F0C7,
	// 	BS_AI_DEFENSIVE = 0xD888F2FD,
	// 	BS_AI_MOONSHINE_BARBRAWL = 0xA01B433A,
	// 	BS_ALLIGATOR = 0x7A5548ED,
	// 	BS_ALLIGATOR_LARGE = 0x368EC7CB,
	// 	BS_ALLY = 0x69C76C14,
	// 	BS_ANIMAL = 0xD777C754,
	// 	BS_BADGER = 0x7E7C3F53,
	// 	BS_BEAR = 0x0BC66E35,
	// 	BS_BEAVER = 0x4E313783,
	// 	BS_BOAR = 0x176A5831,
	// 	BS_BOUNTY_HUNTER = 0x3900654C,
	// 	BS_BRUISER = 0x4514DB61,
	// 	BS_BULL = 0x4E50C5D2,
	// 	BS_COUGAR = 0x9DAA7CCB,
	// 	BS_COW = 0xB0E91295,
	// 	BS_COYOTE = 0xA448EB69,
	// 	BS_DEER = 0xA781E6B3,
	// 	BS_DOG = 0x5A4155C4,
	// 	BS_ELK = 0x408697F0,
	// 	BS_FEMALE = 0x6A3BB2C2,
	// 	BS_FEMALE_STRONG = 0x4DAFDD84,
	// 	BS_GANGUP = 0xD0CECFF2,
	// 	BS_GOAT = 0x078E649F,
	// 	BS_HORSE = 0xF6B775F3,
	// 	BS_MICAH_FINALE = 0x1F0BB27A,
	// 	BS_MOOSE = 0x968917AB,
	// 	BS_MUSKRAT = 0x1EDC33AC,
	// 	BS_NO_MELEE = 0x25B5F931,
	// 	BS_PIG = 0x22EAD110,
	// 	BS_PLAYER = 0x78BAEF07,
	// 	BS_PLAYER_FINALE = 0xF9E77D2D,
	// 	BS_PLAYER_MOONSHINER = 0x687BF19F,
	// 	BS_PLAYER_WINTER1 = 0x3C6A802F,
	// 	BS_QUICK = 0xC4CABB1B,
	// 	BS_RACCOON = 0x505F8917,
	// 	BS_SHEEP = 0x6827CCCF,
	// 	BS_SNAKE = 0x82BEBC4B,
	// 	BS_TIMID = 0x431AEF77,
	// 	BS_WOLF = 0xA8F023D4
	// };
	NATIVE_DECL void _SET_PED_BRAWLING_STYLE(Ped ped, Hash brawlingStyle) { invoke<Void>(0x8BA83CC4288CD56D, ped, brawlingStyle); } // 0x8BA83CC4288CD56D b1207
	// _RESET_PED_*
	NATIVE_DECL void _0x9D8DFE2DE9CB4DFC(Ped ped) { invoke<Void>(0x9D8DFE2DE9CB4DFC, ped); } // 0x9D8DFE2DE9CB4DFC b1207
	// _SET_PED_M*
	NATIVE_DECL Any _0xC48AF420371C7407(Any p0, Any p1) { return invoke<Any>(0xC48AF420371C7407, p0, p1); } // 0xC48AF420371C7407 b1207
	NATIVE_DECL Any _0x5EFA8A3D8A60D662(Any p0, Any p1) { return invoke<Any>(0x5EFA8A3D8A60D662, p0, p1); } // 0x5EFA8A3D8A60D662 b1207
	NATIVE_DECL Any _0x242EDF85D4E87B65(Any p0) { return invoke<Any>(0x242EDF85D4E87B65, p0); } // 0x242EDF85D4E87B65 b1207
	NATIVE_DECL void _SET_PED_COMBAT_BEHAVIOUR(Ped ped, Hash behaviour) { invoke<Void>(0x9238A3D970BBB0A9, ped, behaviour); } // 0x9238A3D970BBB0A9 b1207
	NATIVE_DECL void _0x9A4AC116CC1EEE14(Any p0) { invoke<Void>(0x9A4AC116CC1EEE14, p0); } // 0x9A4AC116CC1EEE14 b1207
	NATIVE_DECL void _0xE20027B414BFE6C7(Any p0, Any p1) { invoke<Void>(0xE20027B414BFE6C7, p0, p1); } // 0xE20027B414BFE6C7 b1207
	// NET_FETCH_CLIENT_UPDATE_PED_FIGHT_PROFICIENCY: Changing parry multiplier for ped
	NATIVE_DECL void _SET_PED_BEAT_MULTIPLIER(Ped ped, float p1) { invoke<Void>(0x6DBF2D78709AD70B, ped, p1); } // 0x6DBF2D78709AD70B b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/COMBAT_ACTION_DISABLE_FLAGS
	NATIVE_DECL void _SET_PED_ACTION_DISABLE_FLAG(Ped ped, int actionDisableFlag) { invoke<Void>(0xB8DE69D9473B7593, ped, actionDisableFlag); } // 0xB8DE69D9473B7593 b1207
	NATIVE_DECL void _CLEAR_PED_ACTION_DISABLE_FLAG(Ped ped, int actionDisableFlag) { invoke<Void>(0x949B2F9ED2917F5D, ped, actionDisableFlag); } // 0x949B2F9ED2917F5D b1207
	NATIVE_DECL BOOL _IS_PED_ACTION_DISABLE_FLAG_ENABLED(Ped ped, int actionDisableFlag) { return invoke<BOOL>(0xB346C85D49CC998E, ped, actionDisableFlag); } // 0xB346C85D49CC998E b1207
	NATIVE_DECL void _SET_PED_TARGET_ACTION_DISABLE_FLAG(Ped ped, int actionDisableFlag) { invoke<Void>(0xC163DAC52AC975D3, ped, actionDisableFlag); } // 0xC163DAC52AC975D3 b1207
	NATIVE_DECL void _CLEAR_PED_TARGET_ACTION_DISABLE_FLAG(Ped ped, int actionDisableFlag) { invoke<Void>(0xBBF6D1D07C02D00A, ped, actionDisableFlag); } // 0xBBF6D1D07C02D00A b1207
	NATIVE_DECL BOOL _IS_PED_TARGET_ACTION_DISABLE_FLAG_ENABLED(Ped ped, int actionDisableFlag) { return invoke<BOOL>(0x02AA2096FE00F3E1, ped, actionDisableFlag); } // 0x02AA2096FE00F3E1 b1207
	// _SET_PED_M*
	NATIVE_DECL void _0x57F35552E771BE9D(Ped ped, int p1) { invoke<Void>(0x57F35552E771BE9D, ped, p1); } // 0x57F35552E771BE9D b1207
	// _CLEAR_PED_M*
	NATIVE_DECL void _0x7C10221CE718AA72(Ped ped, int p1) { invoke<Void>(0x7C10221CE718AA72, ped, p1); } // 0x7C10221CE718AA72 b1207
	// _IS_PED_M*
	NATIVE_DECL BOOL _0x0D3B1568917EBDA0(Ped ped, int p1) { return invoke<BOOL>(0x0D3B1568917EBDA0, ped, p1); } // 0x0D3B1568917EBDA0 b1207
	NATIVE_DECL void _0x29F3539189D3E277(Any p0, Any p1) { invoke<Void>(0x29F3539189D3E277, p0, p1); } // 0x29F3539189D3E277 b1207
	NATIVE_DECL void _0xE9E06EA514A69061(Any p0, Any p1) { invoke<Void>(0xE9E06EA514A69061, p0, p1); } // 0xE9E06EA514A69061 b1207
	NATIVE_DECL void _SET_PED_WRITHING_DURATION(Ped ped, float writhingDuration1, float writhingDuration2, int p3) { invoke<Void>(0x4DB9D03AC4E1FA84, ped, writhingDuration1, writhingDuration2, p3); } // 0x4DB9D03AC4E1FA84 b1207
	// normalized / non normalized
	// 0.0        / 1000.0         STARTED IN WRITHE STAGE
	// 1.0        / 0.0            END OF WRITHE, DEAD
	// -1.0                        DEAD
	// 
	// Returns some value from AI task 562 (unknown).
	NATIVE_DECL float _GET_PED_REMAINING_REVIVAL_TIME(Ped ped, BOOL normalized) { return invoke<float>(0xEBE89623EB861271, ped, normalized); } // 0xEBE89623EB861271 b1207
	NATIVE_DECL void SET_PAUSE_PED_WRITHE_BLEEDOUT(Ped ped, BOOL toggle) { invoke<Void>(0x925A160133003AC6, ped, toggle); } // 0x925A160133003AC6 b1207
	// _GET_IS_PED_(BLEEDING_OUT?)*
	NATIVE_DECL BOOL _0x12EB4E31F092C9B3(Ped ped) { return invoke<BOOL>(0x12EB4E31F092C9B3, ped); } // 0x12EB4E31F092C9B3 b1207
	NATIVE_DECL BOOL GET_PED_IS_GRAPPLING(Ped ped) { return invoke<BOOL>(0x0E99E3BF11BB6367, ped); } // 0x0E99E3BF11BB6367 b1207
	NATIVE_DECL BOOL GET_PED_IS_BEING_GRAPPLED(Ped ped) { return invoke<BOOL>(0x3BDFCF25B58B0415, ped); } // 0x3BDFCF25B58B0415 b1207
	NATIVE_DECL Ped _GET_PED_GRAPPLER(Ped ped) { return invoke<Ped>(0xD0B7AEB56229D317, ped); } // 0xD0B7AEB56229D317 b1207
	NATIVE_DECL int GET_PED_GRAPPLE_STATE(Ped ped) { return invoke<int>(0x2311F15D971AA680, ped); } // 0x2311F15D971AA680 b1207
	NATIVE_DECL Hash _GET_PED_GRAPPLE_STYLE(Ped ped) { return invoke<Hash>(0x753B15AD0FD6F3E3, ped); } // 0x753B15AD0FD6F3E3 b1207
	// Hashes: GS_DRAGGING, GS_FACE_TO_BACK, GS_FACE_TO_FACE, GS_FACE_TO_FACE_WALL, GS_MOUNTED
	NATIVE_DECL Any _SET_PED_GRAPPLE_STYLE(Ped ped, Hash style) { return invoke<Any>(0x630E7B01F091A197, ped, style); } // 0x630E7B01F091A197 b1207
	NATIVE_DECL void _SET_PED_GRAPPLE_SEQUENCE(Ped ped, const char* grappleSequence) { invoke<Void>(0x604190F0CF0DF158, ped, grappleSequence); } // 0x604190F0CF0DF158 b1207
	NATIVE_DECL void _SET_PED_GRAPPLE_FLAG(Ped ped, int flag, BOOL enable) { invoke<Void>(0x789DABD18E9024DB, ped, flag, enable); } // 0x789DABD18E9024DB b1207
	NATIVE_DECL void _CLEAR_PED_GRAPPLE_FLAG(Ped ped, int flag) { invoke<Void>(0xEAE3B5B019C8D23F, ped, flag); } // 0xEAE3B5B019C8D23F b1207
	NATIVE_DECL int _GET_PED_GRAPPLE_FLAG(Ped ped) { return invoke<int>(0xF3C873ED0C595109, ped); } // 0xF3C873ED0C595109 b1207
	NATIVE_DECL void _SET_PED_GRAPPLE_ACTION(Ped ped, Hash grappleAction) { invoke<Void>(0x8301D87B1B89E219, ped, grappleAction); } // 0x8301D87B1B89E219 b1207
	NATIVE_DECL Any _SET_PED_GRAPPLE_EFFECT_MULTIPLIER(Ped ped, float multiplier) { return invoke<Any>(0x99A6E246C315BF60, ped, multiplier); } // 0x99A6E246C315BF60 b1207
	NATIVE_DECL void _SET_PED_GRAPPLE_ANIMATION(Ped ped, Hash grappleAnim) { invoke<Void>(0x56E9C26CD29D1ED6, ped, grappleAnim); } // 0x56E9C26CD29D1ED6 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/FLEE_ATTRIBUTES
	// 
	// attributeFlags:
	// enum eFleeAttribute
	// {
	// 	FA_FORCE_EXIT_VEHICLE = (1 << 16),
	// 	FA_DISABLE_MOUNT_USAGE = (1 << 20),
	// 	FA_DISABLE_ENTER_VEHICLES = (1 << 22),
	// };
	NATIVE_DECL void SET_PED_FLEE_ATTRIBUTES(Ped ped, int attributeFlags, BOOL enable) { invoke<Void>(0x70A2D1137C8ED7C9, ped, attributeFlags, enable); } // 0x70A2D1137C8ED7C9 0xA717A875 b1207
	NATIVE_DECL BOOL _IS_PED_COWERING(Ped ped) { return invoke<BOOL>(0xB086C8C0F5701D14, ped); } // 0xB086C8C0F5701D14 b1207
	NATIVE_DECL BOOL IS_ANY_PED_NEAR_POINT(float x, float y, float z, float radius) { return invoke<BOOL>(0x083961498679DC9F, x, y, z, radius); } // 0x083961498679DC9F 0xFBD9B050 b1207
	NATIVE_DECL BOOL IS_ANY_PED_NEAR_POINT(Vector3 vec, float radius) { return invoke<BOOL>(0x083961498679DC9F, vec.x, vec.y, vec.z, radius); } // 0x083961498679DC9F 0xFBD9B050 b1207
	NATIVE_DECL void FORCE_PED_AI_AND_ANIMATION_UPDATE(Ped ped, BOOL p1, BOOL p2) { invoke<Void>(0x2208438012482A1A, ped, p1, p2); } // 0x2208438012482A1A 0x187B9070 b1207
	// _FORCE_PED_*
	NATIVE_DECL void _0xC2722B252C79E641(Ped ped, Any p1, Any p2, BOOL p3) { invoke<Void>(0xC2722B252C79E641, ped, p1, p2, p3); } // 0xC2722B252C79E641 b1232
	// _IS_PED_D*
	NATIVE_DECL BOOL _0xC488B8C0E52560D8(Ped ped) { return invoke<BOOL>(0xC488B8C0E52560D8, ped); } // 0xC488B8C0E52560D8 b1207
	// _IS_PED_D*
	NATIVE_DECL BOOL _0x2DC0E8DCBD3546E9(Ped ped) { return invoke<BOOL>(0x2DC0E8DCBD3546E9, ped); } // 0x2DC0E8DCBD3546E9 b1207
	// Forces transition now, called together with 0xD65FDC686A031C83
	NATIVE_DECL void _ADD_SCENARIO_TRANSITION(Ped ped) { invoke<Void>(0x6D07B371E9439019, ped); } // 0x6D07B371E9439019 b1207
	// Ped Command Hash are special commands, that can be activated to change conditional anim variations or trigger transitions between conditional anims.
	// https://github.com/femga/rdr3_discoveries/blob/master/animations/scenarios
	NATIVE_DECL void _GIVE_PED_HASH_COMMAND(Ped ped, Hash commandHash, float activationDuration) { invoke<Void>(0xD65FDC686A031C83, ped, commandHash, activationDuration); } // 0xD65FDC686A031C83 b1207
	NATIVE_DECL BOOL _GET_IS_PED_COMMAND_HASH_PRESENT(Ped ped, Hash commandHash) { return invoke<BOOL>(0x68821369A2CEADD5, ped, commandHash); } // 0x68821369A2CEADD5 b1207
	NATIVE_DECL BOOL IS_PED_HEADING_TOWARDS_POSITION(Ped ped, float x, float y, float z, float p4) { return invoke<BOOL>(0xFCF37A457CB96DC0, ped, x, y, z, p4); } // 0xFCF37A457CB96DC0 0x45037B9B b1207
	NATIVE_DECL BOOL IS_PED_HEADING_TOWARDS_POSITION(Ped ped, Vector3 vec, float p4) { return invoke<BOOL>(0xFCF37A457CB96DC0, ped, vec.x, vec.y, vec.z, p4); } // 0xFCF37A457CB96DC0 0x45037B9B b1207
	// Not implemented.
	NATIVE_DECL void _0x600BBDD29820370C(Ped ped) { invoke<Void>(0x600BBDD29820370C, ped); } // 0x600BBDD29820370C b1207
	NATIVE_DECL void REQUEST_PED_VISIBILITY_TRACKING(Ped ped) { invoke<Void>(0x7D7A2E43E74E2EB8, ped); } // 0x7D7A2E43E74E2EB8 0x840D24D3 b1207
	NATIVE_DECL void RELEASE_PED_VISIBILITY_TRACKING(Ped ped) { invoke<Void>(0x3088634CF8C819CF, ped); } // 0x3088634CF8C819CF b1207
	NATIVE_DECL void REQUEST_PED_VEHICLE_VISIBILITY_TRACKING(Ped ped, BOOL p1) { invoke<Void>(0x2BC338A7B21F4608, ped, p1); } // 0x2BC338A7B21F4608 0x31C31DAA b1207
	// REQUEST_*
	NATIVE_DECL void _0x75BA1CB3B7D40CAF(Ped ped, BOOL p1) { invoke<Void>(0x75BA1CB3B7D40CAF, ped, p1); } // 0x75BA1CB3B7D40CAF 0x9194DB71 b1207
	NATIVE_DECL int GET_TRACKED_PED_PIXELCOUNT(Ped ped) { return invoke<int>(0x511F1A683387C7E2, ped); } // 0x511F1A683387C7E2 0x5B1B70AA b1207
	// Returns whether or not a ped is visible within your FOV, not this check auto's to false after a certain distance.
	// Target needs to be tracked first, won't work otherwise.
	NATIVE_DECL BOOL IS_TRACKED_PED_VISIBLE(Ped ped) { return invoke<BOOL>(0x91C8E617F64188AC, ped); } // 0x91C8E617F64188AC 0x33248CC1 b1207
	NATIVE_DECL BOOL _IS_TRACKED_PED_VISIBILITY_PERCENTAGE_NOT_LESS_THAN(Ped ped, float percent) { return invoke<BOOL>(0x164CECC59E70DF86, ped, percent); } // 0x164CECC59E70DF86 b1207
	NATIVE_DECL BOOL _IS_PED_VISIBILITY_TRACKED(Ped ped) { return invoke<BOOL>(0x5102307CE88798EB, ped); } // 0x5102307CE88798EB b1207
	NATIVE_DECL BOOL CAN_PED_BE_MOUNTED(Ped ped) { return invoke<BOOL>(0x2D64376CF437363E, ped); } // 0x2D64376CF437363E b1207
	// Returns true if given ped is a fish.
	// _IS_ME* - _IS_MO*
	NATIVE_DECL BOOL _IS_METAPED_FISH(Ped ped) { return invoke<BOOL>(0x118D476A6F1A13F1, ped); } // 0x118D476A6F1A13F1 b1207
	NATIVE_DECL BOOL IS_EVENT_IN_QUEUE(Ped ped, Hash eventType) { return invoke<BOOL>(0xC8D523BF5BBD3808, ped, eventType); } // 0xC8D523BF5BBD3808 b1207
	// Returns:
	// 0 - CTR_CANNOT_TARGET
	// 1 - CTR_CAN_TARGET
	// 2 - CTR_NOT_SURE_YET
	NATIVE_DECL int CAN_PED_SEE_ENTITY(Ped ped, Entity targetEntity, BOOL p2, BOOL p3) { return invoke<int>(0x7F9B9791D4CB71F6, ped, targetEntity, p2, p3); } // 0x7F9B9791D4CB71F6 b1207
	NATIVE_DECL int CAN_PED_SEE_PED_CACHED(Ped ped, Ped targetPed, BOOL p2) { return invoke<int>(0x9D9473CB82D83A30, ped, targetPed, p2); } // 0x9D9473CB82D83A30 b1207
	// _CAN_PED_B* - _CAN_PED_I*
	NATIVE_DECL float _0x0EA9EACBA3B01601(Ped ped1, Ped ped2, BOOL p2) { return invoke<float>(0x0EA9EACBA3B01601, ped1, ped2, p2); } // 0x0EA9EACBA3B01601 b1207
	// no bone = -1
	NATIVE_DECL int GET_PED_BONE_INDEX(Ped ped, int boneId) { return invoke<int>(0x3F428D08BE5AAE31, ped, boneId); } // 0x3F428D08BE5AAE31 0x259C6BA2 b1207
	// Returns boneIndex
	// _GET_PED_N* - _GET_PED_R*
	NATIVE_DECL int _0xC5303F460A40D21D(Ped ped, int p1) { return invoke<int>(0xC5303F460A40D21D, ped, p1); } // 0xC5303F460A40D21D b1207
	// _SET_PED_R* -_SET_PED_S*
	NATIVE_DECL void _0xE29D8CD66553DBAA(Ped horse) { invoke<Void>(0xE29D8CD66553DBAA, horse); } // 0xE29D8CD66553DBAA b1207
	NATIVE_DECL void _0xB06F5F1DEF417216(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xB06F5F1DEF417216, p0, p1, p2, p3); } // 0xB06F5F1DEF417216 b1207
	NATIVE_DECL void _0xFC23348F0F4E245F(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xFC23348F0F4E245F, p0, p1, p2, p3); } // 0xFC23348F0F4E245F b1207
	NATIVE_DECL void _0x9184788BFF1EDAD7(Any p0, Any p1) { invoke<Void>(0x9184788BFF1EDAD7, p0, p1); } // 0x9184788BFF1EDAD7 b1207
	// Params: ped, 0f, -1, true, true in R* MP Scripts
	// _SET_PED_DE* - _SET_PED_F*
	NATIVE_DECL void _0xE3144B932DFDFF65(Ped ped, float p1, int p2, BOOL p3, BOOL p4) { invoke<Void>(0xE3144B932DFDFF65, ped, p1, p2, p3, p4); } // 0xE3144B932DFDFF65 b1207
	NATIVE_DECL Any _0x0105FEE8F9091255(Any p0, Any p1) { return invoke<Any>(0x0105FEE8F9091255, p0, p1); } // 0x0105FEE8F9091255 b1207
	NATIVE_DECL void _0xD049920CD29F6CC8(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xD049920CD29F6CC8, p0, p1, p2, p3, p4); } // 0xD049920CD29F6CC8 b1207
	NATIVE_DECL Any _0xBB3E5370EBB6BE28(Any p0, Any p1) { return invoke<Any>(0xBB3E5370EBB6BE28, p0, p1); } // 0xBB3E5370EBB6BE28 b1207
	NATIVE_DECL void _0x2FA568BFA725F8D6(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x2FA568BFA725F8D6, p0, p1, p2, p3); } // 0x2FA568BFA725F8D6 b1207
	NATIVE_DECL Any _0x56E4BAD93D33453C(Any p0, Any p1) { return invoke<Any>(0x56E4BAD93D33453C, p0, p1); } // 0x56E4BAD93D33453C b1207
	NATIVE_DECL void _0x75A082563B4452E5(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x75A082563B4452E5, p0, p1, p2, p3); } // 0x75A082563B4452E5 b1207
	NATIVE_DECL void _0x16802C32B2FCA06B(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x16802C32B2FCA06B, p0, p1, p2, p3); } // 0x16802C32B2FCA06B b1207
	NATIVE_DECL void _0x8BA0C65AC15A7D33(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x8BA0C65AC15A7D33, p0, p1, p2, p3); } // 0x8BA0C65AC15A7D33 b1207
	NATIVE_DECL void _0x0FFDF937E5C11382(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x0FFDF937E5C11382, p0, p1, p2, p3, p4, p5); } // 0x0FFDF937E5C11382 b1207
	NATIVE_DECL void _0x5FCF25D584065BFD(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x5FCF25D584065BFD, p0, p1, p2, p3); } // 0x5FCF25D584065BFD b1207
	// _SET_PED_*
	NATIVE_DECL void _0xA2116C1E4ED85C24(Ped ped, BOOL inverted) { invoke<Void>(0xA2116C1E4ED85C24, ped, inverted); } // 0xA2116C1E4ED85C24 b1207
	// motionStateHash: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/tree/main/FORCE_PED_MOTION_STATE#readme
	NATIVE_DECL BOOL FORCE_PED_MOTION_STATE(Ped ped, Hash motionStateHash, BOOL p2, int p3, BOOL p4) { return invoke<BOOL>(0xF28965D04F570DCA, ped, motionStateHash, p2, p3, p4); } // 0xF28965D04F570DCA 0x164DDEFF b1207
	NATIVE_DECL void _0x75D3333409CD33CE(Any p0, Any p1, Any p2) { invoke<Void>(0x75D3333409CD33CE, p0, p1, p2); } // 0x75D3333409CD33CE b1207
	NATIVE_DECL BOOL _GET_PED_CURRENT_MOVEMENT_SPEED(Ped ped, float* speedX, float* speedY) { return invoke<BOOL>(0xF60165E1D2C5370B, ped, speedX, speedY); } // 0xF60165E1D2C5370B b1207
	NATIVE_DECL void SET_PED_MAX_MOVE_BLEND_RATIO(Ped ped, float value) { invoke<Void>(0x433083750C5E064A, ped, value); } // 0x433083750C5E064A 0xEAD0269A b1207
	NATIVE_DECL void SET_PED_MIN_MOVE_BLEND_RATIO(Ped ped, float value) { invoke<Void>(0x01A898D26E2333DD, ped, value); } // 0x01A898D26E2333DD 0x383EC364 b1207
	NATIVE_DECL void _0xBC1DC48270468444(Any p0) { invoke<Void>(0xBC1DC48270468444, p0); } // 0xBC1DC48270468444 b1207
	// Returns vehicle (desired) speed
	// _COMPUTE_(VEHICLE_SPEED_USING_BLEND_RATIO?)*
	NATIVE_DECL float _0x46BF2A810679D6E6(Ped ped, float maxMoveBlendRatio) { return invoke<float>(0x46BF2A810679D6E6, ped, maxMoveBlendRatio); } // 0x46BF2A810679D6E6 b1207
	// Returns vehicle speed
	// _COMPUTE_*
	NATIVE_DECL float _0xCA95924C893A0C91(Ped ped, float p1) { return invoke<float>(0xCA95924C893A0C91, ped, p1); } // 0xCA95924C893A0C91 b1207
	// _H* - _I*
	NATIVE_DECL void _HORSE_AGITATE(Ped mount, BOOL kickOffRider) { invoke<Void>(0xBAE08F00021BFFB2, mount, kickOffRider); } // 0xBAE08F00021BFFB2 b1207
	NATIVE_DECL void _0x413697EC260AABBF(Any p0, Any p1, Any p2) { invoke<Void>(0x413697EC260AABBF, p0, p1, p2); } // 0x413697EC260AABBF b1207
	NATIVE_DECL void _0xCAC43D060099EA72(Ped ped) { invoke<Void>(0xCAC43D060099EA72, ped); } // 0xCAC43D060099EA72 b1207
	NATIVE_DECL void _0xC9151483CC06A414(Ped ped) { invoke<Void>(0xC9151483CC06A414, ped); } // 0xC9151483CC06A414 b1207
	NATIVE_DECL void _0xAD3330E3C3E98007(Any p0, Any p1) { invoke<Void>(0xAD3330E3C3E98007, p0, p1); } // 0xAD3330E3C3E98007 b1207
	NATIVE_DECL Any _0xB8E2D655E1D5BD39(Any p0) { return invoke<Any>(0xB8E2D655E1D5BD39, p0); } // 0xB8E2D655E1D5BD39 b1207
	NATIVE_DECL Any _0x7BB810E8B343AC7B(Any p0) { return invoke<Any>(0x7BB810E8B343AC7B, p0); } // 0x7BB810E8B343AC7B b1207
	// Min: 0.0f
	// Max: 1.15f
	NATIVE_DECL void SET_PED_MOVE_RATE_OVERRIDE(Ped ped, float value) { invoke<Void>(0x085BF80FA50A39D1, ped, value); } // 0x085BF80FA50A39D1 0x900008C6 b1207
	NATIVE_DECL int GET_PED_NEARBY_VEHICLES(Ped ped, Any* sizeAndVehs) { return invoke<int>(0xCFF869CBFA210D82, ped, sizeAndVehs); } // 0xCFF869CBFA210D82 0xCB716F68 b1207
	NATIVE_DECL int GET_PED_NEARBY_PEDS(Ped ped, Any* sizeAndPeds, int ignoredPedType, int p3) { return invoke<int>(0x23F8F5FC7E8C4A6B, ped, sizeAndPeds, ignoredPedType, p3); } // 0x23F8F5FC7E8C4A6B 0x4D3325F4 b1207
	NATIVE_DECL BOOL IS_PED_READY_TO_RENDER(Ped ped) { return invoke<BOOL>(0xA0BC8FAED8CFEB3C, ped); } // 0xA0BC8FAED8CFEB3C b1207
	NATIVE_DECL void _0x6A489892E813951A(Any p0) { invoke<Void>(0x6A489892E813951A, p0); } // 0x6A489892E813951A b1207
	NATIVE_DECL BOOL IS_PED_USING_ACTION_MODE(Ped ped) { return invoke<BOOL>(0x00E73468D085F745, ped); } // 0x00E73468D085F745 0x5AE7EDA2 b1207
	NATIVE_DECL BOOL _IS_PED_USING_ACTION_MODE_2(Ped ped) { return invoke<BOOL>(0xEBB208D6AE712C03, ped); } // 0xEBB208D6AE712C03 b1207
	NATIVE_DECL void SET_PED_USING_ACTION_MODE(Ped ped, BOOL bActionModeEnabled, int p2, const char* action) { invoke<Void>(0xD75ACCF5E0FB5367, ped, bActionModeEnabled, p2, action); } // 0xD75ACCF5E0FB5367 0x8802F696 b1207
	// Overrides the ped's collision capsule radius for the current tick.
	// Must be called every tick to be effective.
	// 
	// Setting this to 0.001 will allow warping through some objects.
	NATIVE_DECL void SET_PED_CAPSULE(Ped ped, float value) { invoke<Void>(0x364DF566EC833DE2, ped, value); } // 0x364DF566EC833DE2 0xB153E1B9 b1207
	NATIVE_DECL Ped _GET_RIDER_OF_MOUNT(Ped mount, BOOL p1) { return invoke<Ped>(0xB676EFDA03DADA52, mount, p1); } // 0xB676EFDA03DADA52 b1207
	// Params: p4 = 35.f, duration = 5000 in R* Scripts
	NATIVE_DECL void SPAWNPOINTS_START_SEARCH(float x, float y, float z, float width, float p4, int spawnpointsFlag, float p6, int duration, float p8) { invoke<Void>(0x2DF9038C90AD5264, x, y, z, width, p4, spawnpointsFlag, p6, duration, p8); } // 0x2DF9038C90AD5264 0x909A1D76 b1207
	NATIVE_DECL void SPAWNPOINTS_START_SEARCH(Vector3 vec, float width, float p4, int spawnpointsFlag, float p6, int duration, float p8) { invoke<Void>(0x2DF9038C90AD5264, vec.x, vec.y, vec.z, width, p4, spawnpointsFlag, p6, duration, p8); } // 0x2DF9038C90AD5264 0x909A1D76 b1207
	// Searching area between coords 1 and 2
	NATIVE_DECL void SPAWNPOINTS_START_SEARCH_IN_ANGLED_AREA(float x1, float y1, float z1, float x2, float y2, float z2, float width, int spawnpointsFlag, float p8, int duration, float p10) { invoke<Void>(0xB2AFF10216DEFA2F, x1, y1, z1, x2, y2, z2, width, spawnpointsFlag, p8, duration, p10); } // 0xB2AFF10216DEFA2F 0x4AAD0ECB b1207
	NATIVE_DECL void SPAWNPOINTS_START_SEARCH_IN_ANGLED_AREA(Vector3 vec1, Vector3 vec2, float width, int spawnpointsFlag, float p8, int duration, float p10) { invoke<Void>(0xB2AFF10216DEFA2F, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, width, spawnpointsFlag, p8, duration, p10); } // 0xB2AFF10216DEFA2F 0x4AAD0ECB b1207
	NATIVE_DECL void _SPAWNPOINTS_START_SEARCH_WITH_VOLUME(Volume volume, int spawnpointsFlag, float p2, int duration, float p4) { invoke<Void>(0x83ED1FC9DF3411F5, volume, spawnpointsFlag, p2, duration, p4); } // 0x83ED1FC9DF3411F5 b1311
	NATIVE_DECL void SPAWNPOINTS_CANCEL_SEARCH() { invoke<Void>(0xFEE4A5459472A9F8); } // 0xFEE4A5459472A9F8 0x492C9E46 b1207
	NATIVE_DECL BOOL SPAWNPOINTS_IS_SEARCH_ACTIVE() { return invoke<BOOL>(0x3C67506996001F5E); } // 0x3C67506996001F5E 0x814A28F4 b1207
	NATIVE_DECL BOOL SPAWNPOINTS_IS_SEARCH_COMPLETE() { return invoke<BOOL>(0xA586FBEB32A53DBB); } // 0xA586FBEB32A53DBB 0x0B60D2BA b1207
	NATIVE_DECL BOOL SPAWNPOINTS_IS_SEARCH_FAILED() { return invoke<BOOL>(0xF445DE8DA80A1792); } // 0xF445DE8DA80A1792 0x6B83ABDF b1207
	NATIVE_DECL int SPAWNPOINTS_GET_NUM_SEARCH_RESULTS() { return invoke<int>(0xA635C11B8C44AFC2); } // 0xA635C11B8C44AFC2 0xF46B4DC8 b1207
	NATIVE_DECL void SPAWNPOINTS_GET_SEARCH_RESULT(int randomInt, float* x, Any* y, float* z) { invoke<Void>(0x280C7E3AC7F56E90, randomInt, x, y, z); } // 0x280C7E3AC7F56E90 0x36A4AC65 b1207
	NATIVE_DECL void SPAWNPOINTS_GET_SEARCH_RESULT_FLAGS(Any p0, Any* p1) { invoke<Void>(0xB782F8238512BAD5, p0, p1); } // 0xB782F8238512BAD5 0xBA699DDF b1207
	NATIVE_DECL void SET_IK_TARGET(Ped ped, int ikIndex, Entity entityLookAt, int boneLookAt, float offsetX, float offsetY, float offsetZ, Any p7, int blendInDuration, int blendOutDuration) { invoke<Void>(0xC32779C16FCEECD9, ped, ikIndex, entityLookAt, boneLookAt, offsetX, offsetY, offsetZ, p7, blendInDuration, blendOutDuration); } // 0xC32779C16FCEECD9 0x6FE5218C b1207
	NATIVE_DECL void SET_IK_TARGET(Ped ped, int ikIndex, Entity entityLookAt, int boneLookAt, Vector3 offset, Any p7, int blendInDuration, int blendOutDuration) { invoke<Void>(0xC32779C16FCEECD9, ped, ikIndex, entityLookAt, boneLookAt, offset.x, offset.y, offset.z, p7, blendInDuration, blendOutDuration); } // 0xC32779C16FCEECD9 0x6FE5218C b1207
	// For more information, see common:/data/emotional_presets.meta
	NATIVE_DECL void _REQUEST_PED_EMOTIONAL_PRESET(Ped ped, const char* name) { invoke<Void>(0x5C3C55EAAD19915F, ped, name); } // 0x5C3C55EAAD19915F b1207
	// See _REQUEST_PED_EMOTIONAL_PRESET
	NATIVE_DECL BOOL _HAS_PED_EMOTIONAL_PRESET_LOADED(Ped ped, const char* name) { return invoke<BOOL>(0xDE3904B22695D9F9, ped, name); } // 0xDE3904B22695D9F9 b1207
	// See _REQUEST_PED_EMOTIONAL_PRESET
	NATIVE_DECL void _REMOVE_PED_EMOTIONAL_PRESET(Ped ped, const char* name) { invoke<Void>(0xFC3BAB1801A8255A, ped, name); } // 0xFC3BAB1801A8255A b1207
	NATIVE_DECL void _REQUEST_MOTION_TYPE_ASSET(Hash nameHash, Ped ped) { invoke<Void>(0xF7EA250B9A919E03, nameHash, ped); } // 0xF7EA250B9A919E03 b1207
	NATIVE_DECL BOOL HAS_MOTION_TYPE_ASSET_LOADED(Hash nameHash, Ped ped) { return invoke<BOOL>(0x854BC9B1A1CCD034, nameHash, ped); } // 0x854BC9B1A1CCD034 b1207
	NATIVE_DECL void _REMOVE_MOTION_TYPE_ASSET(Hash nameHash, Ped ped) { invoke<Void>(0xDE7B2B4144906CDF, nameHash, ped); } // 0xDE7B2B4144906CDF b1207
	// _IS_PED_L* - _IS_PED_M*
	NATIVE_DECL BOOL _0x290B2E6CCDE532E1(Ped ped) { return invoke<BOOL>(0x290B2E6CCDE532E1, ped); } // 0x290B2E6CCDE532E1 b1207
	// _IS_PED_L* - _IS_PED_M*
	NATIVE_DECL BOOL _0x0EEF7A81C17679DB(Ped ped) { return invoke<BOOL>(0x0EEF7A81C17679DB, ped); } // 0x0EEF7A81C17679DB b1207
	NATIVE_DECL void SET_PED_LOD_MULTIPLIER(Ped ped, float multiplier) { invoke<Void>(0xDC2C5C242AAC342B, ped, multiplier); } // 0xDC2C5C242AAC342B 0x1D2B5C70 b1207
	NATIVE_DECL float _GET_PED_LOD_MULTIPLIER(Ped ped) { return invoke<float>(0x1B710E6F4AB69341, ped); } // 0x1B710E6F4AB69341 b1355
	NATIVE_DECL Any _0xA218D2BBCAA7388C(Any p0, Any p1) { return invoke<Any>(0xA218D2BBCAA7388C, p0, p1); } // 0xA218D2BBCAA7388C b1207
	NATIVE_DECL BOOL IS_ANY_HOSTILE_PED_NEAR_POINT(Ped ped, float x, float y, float z, float radius) { return invoke<BOOL>(0x68772DB2B2526F9F, ped, x, y, z, radius); } // 0x68772DB2B2526F9F 0x1A464167 b1311
	NATIVE_DECL BOOL IS_ANY_HOSTILE_PED_NEAR_POINT(Ped ped, Vector3 vec, float radius) { return invoke<BOOL>(0x68772DB2B2526F9F, ped, vec.x, vec.y, vec.z, radius); } // 0x68772DB2B2526F9F 0x1A464167 b1311
	NATIVE_DECL void _0xCBDE59C48F2B06F5(Any p0, Any p1, Any p2) { invoke<Void>(0xCBDE59C48F2B06F5, p0, p1, p2); } // 0xCBDE59C48F2B06F5 b1207
	NATIVE_DECL void _0x6A190B94C2541A99(Any p0) { invoke<Void>(0x6A190B94C2541A99, p0); } // 0x6A190B94C2541A99 b1207
	// Returns true if ped is in perception (focused and looking at target ped)
	// Most float params are -1.f in R* Scripts
	NATIVE_DECL BOOL IS_TARGET_PED_IN_PERCEPTION_AREA(Ped ped, Ped targetPed, float p2, float customDistance, float p4, float p5) { return invoke<BOOL>(0x06087579E7AA85A9, ped, targetPed, p2, customDistance, p4, p5); } // 0x06087579E7AA85A9 0xD0567D41 b1207
	NATIVE_DECL void SET_POP_CONTROL_SPHERE_THIS_FRAME(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xD8C3BE3EE94CAF2D, p0, p1, p2, p3, p4); } // 0xD8C3BE3EE94CAF2D 0x4BBE5E2C b1207
	NATIVE_DECL BOOL IS_PED_HOGTIED(Ped ped) { return invoke<BOOL>(0x3AA24CCC0D451379, ped); } // 0x3AA24CCC0D451379 b1207
	NATIVE_DECL BOOL IS_PED_BEING_HOGTIED(Ped ped) { return invoke<BOOL>(0xD453BB601D4A606E, ped); } // 0xD453BB601D4A606E b1207
	NATIVE_DECL Ped _0x3D9F958834AB9C30(Ped ped) { return invoke<Ped>(0x3D9F958834AB9C30, ped); } // 0x3D9F958834AB9C30 b1207
	// _IS_PED_S* - _IS_PED_U*
	NATIVE_DECL BOOL _0x913D04A5176F84C9(Ped ped) { return invoke<BOOL>(0x913D04A5176F84C9, ped); } // 0x913D04A5176F84C9 b1207
	NATIVE_DECL BOOL IS_PED_HOGTYING(Ped ped) { return invoke<BOOL>(0x42429C674B61238B, ped); } // 0x42429C674B61238B b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/LASSO_HOGTIE_FLAG
	NATIVE_DECL BOOL _GET_PED_LASSO_HOGTIE_FLAG(Ped ped, int flagId) { return invoke<BOOL>(0x2C76FA0E01681F8D, ped, flagId); } // 0x2C76FA0E01681F8D b1207
	NATIVE_DECL void SET_PED_LASSO_HOGTIE_FLAG(Ped ped, int flagId, BOOL value) { invoke<Void>(0xAE6004120C18DF97, ped, flagId, value); } // 0xAE6004120C18DF97 b1207
	NATIVE_DECL Any _0x4642182A298187D0(Ped ped, int p1, Any* p2, int p3, int p4) { return invoke<Any>(0x4642182A298187D0, ped, p1, p2, p3, p4); } // 0x4642182A298187D0 b1207
	NATIVE_DECL void _0x6B67320E0D57856A(Ped ped, Any* p1, int p2, BOOL p3) { invoke<Void>(0x6B67320E0D57856A, ped, p1, p2, p3); } // 0x6B67320E0D57856A b1207
	NATIVE_DECL Entity _GET_FIRST_ENTITY_PED_IS_CARRYING(Ped ped) { return invoke<Entity>(0xD806CD2A4F2C2996, ped); } // 0xD806CD2A4F2C2996 b1207
	NATIVE_DECL void _0xAA6C49AE90A32299(Ped ped, Hash p1) { invoke<Void>(0xAA6C49AE90A32299, ped, p1); } // 0xAA6C49AE90A32299 b1207
	NATIVE_DECL Ped _GET_CARRIER_AS_PED(Entity entity) { return invoke<Ped>(0x09B83E68DE004CD4, entity); } // 0x09B83E68DE004CD4 b1207
	NATIVE_DECL Ped _GET_CARRIER_AS_MOUNT(Entity entity) { return invoke<Ped>(0xA033D7E4BBF9844D, entity); } // 0xA033D7E4BBF9844D b1207
	NATIVE_DECL Ped _GET_CARRIER_AS_HUMAN(Entity entity) { return invoke<Ped>(0x79443D56C8DF45EE, entity); } // 0x79443D56C8DF45EE b1207
	NATIVE_DECL Any GET_CARRIED_ATTACHED_INFO_FOR_SLOT(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x608BC6A6AACD5036, p0, p1, p2, p3); } // 0x608BC6A6AACD5036 b1207
	NATIVE_DECL void DETACH_CARRIABLE_ENTITY(Entity entity, BOOL p1, BOOL p2) { invoke<Void>(0xED00D72F81CF7278, entity, p1, p2); } // 0xED00D72F81CF7278 b1207
	NATIVE_DECL void FIND_ALL_ATTACHED_CARRIABLE_ENTITIES(Ped ped, ItemSet itemset) { invoke<Void>(0xB5ACE8B23A438EC0, ped, itemset); } // 0xB5ACE8B23A438EC0 b1207
	NATIVE_DECL BOOL IS_PED_CARRYING_SOMETHING(Ped ped) { return invoke<BOOL>(0xA911EE21EDF69DAF, ped); } // 0xA911EE21EDF69DAF b1207
	NATIVE_DECL BOOL _0xB65927F861E7AE39(Ped ped, int p1) { return invoke<BOOL>(0xB65927F861E7AE39, ped, p1); } // 0xB65927F861E7AE39 b1207
	NATIVE_DECL BOOL _0xA1FBAC56D38563E2(Volume volume) { return invoke<BOOL>(0xA1FBAC56D38563E2, volume); } // 0xA1FBAC56D38563E2 b1207
	NATIVE_DECL Any _0x6F43C351A5D51E2F(Ped ped, Any* p1) { return invoke<Any>(0x6F43C351A5D51E2F, ped, p1); } // 0x6F43C351A5D51E2F b1207
	NATIVE_DECL BOOL IS_PED_LASSOED(Ped ped) { return invoke<BOOL>(0x9682F850056C9ADE, ped); } // 0x9682F850056C9ADE b1207
	// _IS_PED_S* - _IS_PED_U*
	NATIVE_DECL Entity _GET_LASSOER_OF_PED(Ped ped) { return invoke<Entity>(0x833F0053340EF413, ped); } // 0x833F0053340EF413 b1207
	NATIVE_DECL Entity _GET_LASSO_TARGET(Ped ped) { return invoke<Entity>(0xB65A4DAB460A19BD, ped); } // 0xB65A4DAB460A19BD b1207
	NATIVE_DECL Ped _GET_LASSOED_LASSOER(Ped ped) { return invoke<Ped>(0x0C31C51168E80365, ped); } // 0x0C31C51168E80365 b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/LOOTING_FLAGS
	// 
	// lootFlag:
	// enum eLootFlag
	// {
	// 	LOOT_FLAG_IS_CRITICAL_LOOT_TARGET = 7,
	// 	LOOT_FLAG_IGNORE_WATER_CHECKS = 8,
	// 	LOOT_FLAG_ANIMAL_FLAGGED_FOR_TAGGING = 23,
	// };
	NATIVE_DECL void SET_LOOTING_FLAG(Ped ped, int lootFlag, BOOL enabled) { invoke<Void>(0x6569F31A01B4C097, ped, lootFlag, enabled); } // 0x6569F31A01B4C097 b1207
	// lootFlag: see SET_LOOTING_FLAG
	NATIVE_DECL BOOL _GET_LOOTING_FLAG(Ped ped, int lootFlag) { return invoke<BOOL>(0xE4C11F104620DDCE, ped, lootFlag); } // 0xE4C11F104620DDCE b1207
	// Returns loot state
	NATIVE_DECL int _0x5463C962BC7777C3(Ped ped, int p1, Any p2, int p3, int p4) { return invoke<int>(0x5463C962BC7777C3, ped, p1, p2, p3, p4); } // 0x5463C962BC7777C3 b1207
	// enum ePedLootStatus
	// {
	// 	PLS_NONE,
	// 	PLS_PRE_LOOT,
	// 	PLS_SAMPLING,
	// 	PLS_SKINNING
	// };
	NATIVE_DECL int GET_PED_LOOT_STATUS_MP(Ped ped) { return invoke<int>(0xC737697C41628340, ped); } // 0xC737697C41628340 b1311
	NATIVE_DECL Ped _0x4B19F171450E0D4F(Ped ped) { return invoke<Ped>(0x4B19F171450E0D4F, ped); } // 0x4B19F171450E0D4F b1207
	NATIVE_DECL BOOL _0x758F081DB204DDDE(Ped ped) { return invoke<BOOL>(0x758F081DB204DDDE, ped); } // 0x758F081DB204DDDE b1207
	NATIVE_DECL Entity GET_LOOTING_PICKUP_TARGET_ENTITY(Ped ped) { return invoke<Entity>(0x14169FA823679E41, ped); } // 0x14169FA823679E41 b1207
	NATIVE_DECL Any _0x7B5C293238EE4F20(Any p0) { return invoke<Any>(0x7B5C293238EE4F20, p0); } // 0x7B5C293238EE4F20 b1207
	NATIVE_DECL void _0xAE6B68A83ABBE7C0(Any p0) { invoke<Void>(0xAE6B68A83ABBE7C0, p0); } // 0xAE6B68A83ABBE7C0 b1207
	NATIVE_DECL BOOL _0xA4B6432E3880F2F9(Ped ped) { return invoke<BOOL>(0xA4B6432E3880F2F9, ped); } // 0xA4B6432E3880F2F9 b1311
	NATIVE_DECL BOOL _ADD_PED_SUBSCRIBE_TO_LEGENDARY_BLIPS(Ped ped) { return invoke<BOOL>(0xE37287EE358939C3, ped); } // 0xE37287EE358939C3 b1311
	NATIVE_DECL BOOL _REMOVE_PED_SUBSCRIBE_TO_LEGENDARY_BLIPS(Ped ped) { return invoke<BOOL>(0x011A42FD923D41CA, ped); } // 0x011A42FD923D41CA b1311
	NATIVE_DECL BOOL IS_PED_INCAPACITATED(Ped ped) { return invoke<BOOL>(0xB655DB7582AEC805, ped); } // 0xB655DB7582AEC805 b1207
	NATIVE_DECL void _SET_PED_INCAPACITATION_MODIFIERS(Ped ped, BOOL canBeIncapacitated, int threshold, int bleedoutTime, int p4) { invoke<Void>(0x39ED303390DDEAC7, ped, canBeIncapacitated, threshold, bleedoutTime, p4); } // 0x39ED303390DDEAC7 b1207
	NATIVE_DECL BOOL _GET_PED_CAN_BE_INCAPACITATED_THIS_FRAME(Ped ped) { return invoke<BOOL>(0x7A4E00364B5D727B, ped); } // 0x7A4E00364B5D727B b1207
	// When set on a player ped, its just like when you die in RDO
	NATIVE_DECL void SET_PED_CAN_BE_INCAPACITATED(Ped ped, BOOL toggle) { invoke<Void>(0x5240864E847C691C, ped, toggle); } // 0x5240864E847C691C b1207
	NATIVE_DECL int _GET_PED_INCAPACITATION_HEALTH(Ped ped) { return invoke<int>(0x89BFDF6D53145545, ped); } // 0x89BFDF6D53145545 b1207
	NATIVE_DECL void _SET_PED_INCAPACITATION_TOTAL_BLEED_OUT_DURATION(Ped ped, float duration) { invoke<Void>(0x2890418B39BC8FFF, ped, duration); } // 0x2890418B39BC8FFF b1207
	NATIVE_DECL void _RESET_PED_INCAPACITATION_BLEED_OUT_DURATION(Ped ped) { invoke<Void>(0x4B9668DB91DC39B8, ped); } // 0x4B9668DB91DC39B8 b1207
	NATIVE_DECL void _SET_PED_INCAPACITATION_FLAGS(Ped ped, int flags) { invoke<Void>(0xD67B6F3BCF81BA47, ped, flags); } // 0xD67B6F3BCF81BA47 b1207
	NATIVE_DECL void _0x92A1B55A59720395(Any p0, Any p1) { invoke<Void>(0x92A1B55A59720395, p0, p1); } // 0x92A1B55A59720395 b1207
	NATIVE_DECL void _INCAPACITATED_REVIVE(Ped ped, Ped ped2) { invoke<Void>(0xF6262491C7704A63, ped, ped2); } // 0xF6262491C7704A63 b1207
	NATIVE_DECL int _GET_INCAPACITATION_TIME_REMAINING(Ped ped) { return invoke<int>(0x88D9D76D78065487, ped); } // 0x88D9D76D78065487 b1207
	NATIVE_DECL void _SET_PED_KNOCKED_BY_ONE_HIT(Ped ped, float p1) { invoke<Void>(0x5BCF0B79D4F5DBA3, ped, p1); } // 0x5BCF0B79D4F5DBA3 b1207
	NATIVE_DECL void _0x2E5B5D1F1453E08E(Ped ped, int p1) { invoke<Void>(0x2E5B5D1F1453E08E, ped, p1); } // 0x2E5B5D1F1453E08E b1207
	// _SET_PED_K* or _SET_PED_L*
	NATIVE_DECL void _0x29924EB8EE9DB926(Ped ped, float p1) { invoke<Void>(0x29924EB8EE9DB926, ped, p1); } // 0x29924EB8EE9DB926 b1207
	NATIVE_DECL void _0xB285AD0EC870B2DF(Any p0, Any p1) { invoke<Void>(0xB285AD0EC870B2DF, p0, p1); } // 0xB285AD0EC870B2DF b1207
	NATIVE_DECL Any _0xCB86D3E3E3708901(Any p0, Any p1, Any p2, Any p3, Any p4) { return invoke<Any>(0xCB86D3E3E3708901, p0, p1, p2, p3, p4); } // 0xCB86D3E3E3708901 b1207
	NATIVE_DECL void _0x633F83B301C87994(Any p0, Any p1) { invoke<Void>(0x633F83B301C87994, p0, p1); } // 0x633F83B301C87994 b1207
	NATIVE_DECL BOOL _0x5203038FF8BAE577(Ped ped, int p1, int p2) { return invoke<BOOL>(0x5203038FF8BAE577, ped, p1, p2); } // 0x5203038FF8BAE577 b1207
	NATIVE_DECL BOOL _0x7F090958AE95B61B(Ped ped, int p1) { return invoke<BOOL>(0x7F090958AE95B61B, ped, p1); } // 0x7F090958AE95B61B b1207
	// [WARDROBE] Player took off their disguise: p1 = 13
	// [WARDROBE] Player put on a disguise: p1 = 0
	NATIVE_DECL void _0xC494C76A34266E82(Ped ped, int p1) { invoke<Void>(0xC494C76A34266E82, ped, p1); } // 0xC494C76A34266E82 b1207
	// _GET_PED_G* - _GET_PED_I*
	NATIVE_DECL BOOL _0xC3995D396F1D97B6(Ped ped, int p1, int p2) { return invoke<BOOL>(0xC3995D396F1D97B6, ped, p1, p2); } // 0xC3995D396F1D97B6 b1207
	NATIVE_DECL void _0x15F4732C357B1D6D(Any p0, Any p1, Any p2) { invoke<Void>(0x15F4732C357B1D6D, p0, p1, p2); } // 0x15F4732C357B1D6D b1207
	// flags: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/PED___0x947E43F544B6AB34/README.md 
	// _GET_PED_G* - _GET_PED_I(NTERACTION?)*
	NATIVE_DECL BOOL _0x947E43F544B6AB34(Ped ped, Player player, int flag, int ms) { return invoke<BOOL>(0x947E43F544B6AB34, ped, player, flag, ms); } // 0x947E43F544B6AB34 b1207
	NATIVE_DECL Any _0x32417CB860A3BDC4(Any p0, Any p1) { return invoke<Any>(0x32417CB860A3BDC4, p0, p1); } // 0x32417CB860A3BDC4 b1207
	// Only used in R* Script nb_animal_attack: p2 = 120000
	// _SET_PED_SH* - _SET_PED_SP*
	NATIVE_DECL void _0xE737D5F14304A2EC(Ped ped, Player player, int p2) { invoke<Void>(0xE737D5F14304A2EC, ped, player, p2); } // 0xE737D5F14304A2EC b1207
	NATIVE_DECL void _0xEBD49472BCCF7642(Any p0, Any p1) { invoke<Void>(0xEBD49472BCCF7642, p0, p1); } // 0xEBD49472BCCF7642 b1207
	NATIVE_DECL void _0x19173C3F15367B54(Any p0, Any p1, Any p2) { invoke<Void>(0x19173C3F15367B54, p0, p1, p2); } // 0x19173C3F15367B54 b1207
	NATIVE_DECL void _0x5708EDD71B50C008(Any p0, Any p1, Any p2) { invoke<Void>(0x5708EDD71B50C008, p0, p1, p2); } // 0x5708EDD71B50C008 b1207
	NATIVE_DECL void _0xB9BDFAE609DFB7C5(Any p0, Any p1, Any p2) { invoke<Void>(0xB9BDFAE609DFB7C5, p0, p1, p2); } // 0xB9BDFAE609DFB7C5 b1207
	NATIVE_DECL Any _0xF7327ACC7A89AEF1(Any p0, Any p1, Any p2) { return invoke<Any>(0xF7327ACC7A89AEF1, p0, p1, p2); } // 0xF7327ACC7A89AEF1 b1207
	// AI_ATTITUDE_NEUTRAL = 0,
	// AI_ATTITUDE_FRIENDLY,
	// AI_ATTITUDE_WARY,
	// AI_ATTITUDE_COMBATIVE,
	// AI_ATTITUDE_NEVER_MET
	NATIVE_DECL int _GET_PED_ATTITUDE(Ped ped, Player player) { return invoke<int>(0x7CC2186C32D3540A, ped, player); } // 0x7CC2186C32D3540A b1207
	NATIVE_DECL BOOL _0x1E017404784AA6A3(Ped ped, Hash p1) { return invoke<BOOL>(0x1E017404784AA6A3, ped, p1); } // 0x1E017404784AA6A3 b1207
	NATIVE_DECL void _0x2B4CE170DE09F346(Any p0, Any p1) { invoke<Void>(0x2B4CE170DE09F346, p0, p1); } // 0x2B4CE170DE09F346 b1207
	NATIVE_DECL Any _0x7C8AA850617651D9(Any p0, Any p1) { return invoke<Any>(0x7C8AA850617651D9, p0, p1); } // 0x7C8AA850617651D9 b1207
	// If targetPed is set to 0 the ped motivationState affects everyone
	NATIVE_DECL float _GET_PED_MOTIVATION(Ped ped, int motivationState, Ped targetPed) { return invoke<float>(0x42688E94E96FD9B4, ped, motivationState, targetPed); } // 0x42688E94E96FD9B4 b1207
	// enum eMotivationState
	// {
	// 	TOILET_STATE,
	// 	FEAR_STATE,
	// 	ANGRY_STATE,
	// 	AGITATION_STATE,
	// 	HUNGRY_STATE,
	// 	TIRED_STATE,
	// 	SAD_STATE,
	// 	BRAVE_STATE,
	// 	OFFER_ITEM_STATE,
	// 	SUSPICION,
	// 	DRUNK_STATE
	// };
	// 
	// If targetPed is set to 0 the ped motivationState affects everyone
	NATIVE_DECL void _SET_PED_MOTIVATION(Ped ped, int motivationState, float threshold, Ped targetPed) { invoke<Void>(0x06D26A96CA1BCA75, ped, motivationState, threshold, targetPed); } // 0x06D26A96CA1BCA75 b1207
	NATIVE_DECL void _0x23BDE06596A22CEC(Ped ped, int p1, float p2, Any p3) { invoke<Void>(0x23BDE06596A22CEC, ped, p1, p2, p3); } // 0x23BDE06596A22CEC b1207
	NATIVE_DECL void _0xCDFB8C04D4C95D9B(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xCDFB8C04D4C95D9B, p0, p1, p2, p3); } // 0xCDFB8C04D4C95D9B b1207
	// motivationState: see _SET_PED_MOTIVATION
	NATIVE_DECL BOOL _GET_IS_PED_MOTIVATION_STATE_ENABLED(Ped ped, int motivationState) { return invoke<BOOL>(0x33FA048675821DA7, ped, motivationState); } // 0x33FA048675821DA7 b1207
	// motivationState: see _SET_PED_MOTIVATION
	NATIVE_DECL void _SET_PED_MOTIVATION_STATE_OVERRIDE(Ped ped, int motivationState, BOOL enabled) { invoke<Void>(0x2EB75FB86C41F026, ped, motivationState, enabled); } // 0x2EB75FB86C41F026 b1207
	// The higher the modifier, the slower the motivationState value will decrease
	NATIVE_DECL void _SET_PED_MOTIVATION_MODIFIER(Ped ped, int motivationState, float modifier) { invoke<Void>(0xA1EB5D029E0191D3, ped, motivationState, modifier); } // 0xA1EB5D029E0191D3 b1207
	NATIVE_DECL void _0xFD8E853F0BC2E942(Any p0, Any p1) { invoke<Void>(0xFD8E853F0BC2E942, p0, p1); } // 0xFD8E853F0BC2E942 b1207
	// 0.0 - 1.0
	// Modifies the "scent line" on the ped's body when using Eagle Eye.
	NATIVE_DECL void _SET_PED_SCENT(Ped ped, float scent) { invoke<Void>(0x01B21B81865E2A1F, ped, scent); } // 0x01B21B81865E2A1F b1207
	NATIVE_DECL void _SET_PED_LADDER_MOVEMENT_SPEED_MODIFIER(Ped ped, float p1) { invoke<Void>(0x05CE6AF4DF071D23, ped, p1); } // 0x05CE6AF4DF071D23 b1207
	NATIVE_DECL void _RESET_PED_LADDER_MOVEMENT_SPEED_MODIFIER(Ped ped) { invoke<Void>(0x801917E7D7BCE418, ped); } // 0x801917E7D7BCE418 b1207
	NATIVE_DECL void _0xC6C4E15CF7D52FEA(Any p0, Any p1) { invoke<Void>(0xC6C4E15CF7D52FEA, p0, p1); } // 0xC6C4E15CF7D52FEA b1207
	// _SET_PED_S* - _SET_PED_T*
	NATIVE_DECL void _SET_PED_VOICE_VOLUME(Ped ped, float volume) { invoke<Void>(0xD05AD61F242C626B, ped, volume); } // 0xD05AD61F242C626B b1207
	NATIVE_DECL void _0x0F967019CC853BCC(Any p0, Any p1) { invoke<Void>(0x0F967019CC853BCC, p0, p1); } // 0x0F967019CC853BCC b1207
	NATIVE_DECL BOOL _IS_PED_DRAGGING(Ped ped) { return invoke<BOOL>(0x226CF9B159E38F42, ped); } // 0x226CF9B159E38F42 b1207
	NATIVE_DECL BOOL IS_PED_BEING_DRAGGED(Ped ped) { return invoke<BOOL>(0xEF3A8772F085B4AA, ped); } // 0xEF3A8772F085B4AA b1207
	NATIVE_DECL void _0x070A3841406C43D5(Any p0, Any p1) { invoke<Void>(0x070A3841406C43D5, p0, p1); } // 0x070A3841406C43D5 b1207
	NATIVE_DECL BOOL _ADD_PED_STAY_OUT_VOLUME(Ped ped, Volume volume) { return invoke<BOOL>(0xE9B168527B337BF0, ped, volume); } // 0xE9B168527B337BF0 b1207
	NATIVE_DECL BOOL _REMOVE_PED_STAY_OUT_VOLUME(Ped ped, Volume volume) { return invoke<BOOL>(0x0CAB404CD2DB41F5, ped, volume); } // 0x0CAB404CD2DB41F5 b1207
	NATIVE_DECL void _0x9E66708B2B41F14A(Any p0, Any p1) { invoke<Void>(0x9E66708B2B41F14A, p0, p1); } // 0x9E66708B2B41F14A b1207
	NATIVE_DECL void _0xF634E2892220EF34(Ped ped, Any p1) { invoke<Void>(0xF634E2892220EF34, ped, p1); } // 0xF634E2892220EF34 b1207
	NATIVE_DECL void _0xAAC0EE3B4999ABB5(Ped ped, Ped targetPed) { invoke<Void>(0xAAC0EE3B4999ABB5, ped, targetPed); } // 0xAAC0EE3B4999ABB5 b1207
	NATIVE_DECL Entity GET_PED_MOTION_FOCUS_ENTITY(Ped ped) { return invoke<Entity>(0x243E1B4607040057, ped); } // 0x243E1B4607040057 b1207
	// Note: You have to update the ped's variation (using 0xCC8CA3E88256E58F) after calling this native
	// 
	// index = Ped expression ID's / face features
	// List of face features: https://pastebin.com/9jb88FXW
	// value: -1.0 to 1.0
	// 
	// This native also allows you to change a horse's gender.
	NATIVE_DECL void _SET_PED_FACE_FEATURE(Ped ped, int index, float value) { invoke<Void>(0x5653AB26C82938CF, ped, index, value); } // 0x5653AB26C82938CF b1207
	NATIVE_DECL float _GET_PED_FACE_FEATURE(Ped ped, int index) { return invoke<float>(0xFD1BA1EEF7985BB8, ped, index); } // 0xFD1BA1EEF7985BB8 b1207
	NATIVE_DECL void _0x5BB04BC74A474B47(Any p0, Any p1) { invoke<Void>(0x5BB04BC74A474B47, p0, p1); } // 0x5BB04BC74A474B47 b1207
	NATIVE_DECL void _0x9078FB0557364099(Any p0) { invoke<Void>(0x9078FB0557364099, p0); } // 0x9078FB0557364099 b1207
	NATIVE_DECL BOOL IS_PED_FALLING_OVER(Ped ped) { return invoke<BOOL>(0x3E592D0486DEC0F6, ped); } // 0x3E592D0486DEC0F6 b1207
	NATIVE_DECL BOOL _HAS_PED_BEEN_SHOVED_RECENTLY(Ped ped, int ms) { return invoke<BOOL>(0x29FCE825613FEFCA, ped, ms); } // 0x29FCE825613FEFCA b1207
	NATIVE_DECL Ped _GET_PED_TRANQUILIZER(Ped ped) { return invoke<Ped>(0x65C75FDCCAC86464, ped); } // 0x65C75FDCCAC86464 b1355
	NATIVE_DECL void _0x0D497AA69059FE40(Any p0, Any p1) { invoke<Void>(0x0D497AA69059FE40, p0, p1); } // 0x0D497AA69059FE40 b1207
	NATIVE_DECL void _0xD7D2F45C56A4F4DF(Any p0, Any p1, Any p2) { invoke<Void>(0xD7D2F45C56A4F4DF, p0, p1, p2); } // 0xD7D2F45C56A4F4DF b1207
	// The higher the multiplier the less the engine renders culls (https://docs.unity3d.com/Manual/OcclusionCulling.html)
	NATIVE_DECL void _SET_PED_CULL_RANGE(Ped ped, float p1, float p2) { invoke<Void>(0x8AC1D721B2097B6E, ped, p1, p2); } // 0x8AC1D721B2097B6E b1207
	NATIVE_DECL void _0x1D23D3F70606D788(Any p0, Any p1) { invoke<Void>(0x1D23D3F70606D788, p0, p1); } // 0x1D23D3F70606D788 b1207
	// enum eMetaPedType
	// {
	// 	MPT_MALE,
	// 	MPT_FEMALE,
	// 	MPT_TEEN,
	// 	MPT_ANIMAL,
	// 	MPT_NONE
	// };
	NATIVE_DECL int _GET_META_PED_TYPE(Ped ped) { return invoke<int>(0xEC9A1261BF0CE510, ped); } // 0xEC9A1261BF0CE510 b1207
	NATIVE_DECL BOOL _IS_METAPED_USING_COMPONENT(Ped ped, Hash component) { return invoke<BOOL>(0xFB4891BD7578CDC1, ped, component); } // 0xFB4891BD7578CDC1 b1207
	// _IS_PED_M* - _IS_PED_O*
	NATIVE_DECL BOOL _0xBD0E4F52F6D95242(Ped ped) { return invoke<BOOL>(0xBD0E4F52F6D95242, ped); } // 0xBD0E4F52F6D95242 b1207
	NATIVE_DECL BOOL _IS_PED_CHILD(Ped ped) { return invoke<BOOL>(0x137772000DAF42C5, ped); } // 0x137772000DAF42C5 b1207
	NATIVE_DECL void _0xFFA1594703ED27CA(Ped ped, int p1) { invoke<Void>(0xFFA1594703ED27CA, ped, p1); } // 0xFFA1594703ED27CA b1207
	// Use to apply metaped player components
	// Replaces asset, alternatively you can remove assets using REMOVE_TAG_FROM_META_PED
	NATIVE_DECL void _SET_META_PED_TAG(Ped ped, Hash drawable, Hash albedo, Hash normal, Hash material, Hash palette, int tint0, int tint1, int tint2) { invoke<Void>(0xBC6DF00D7A4A6819, ped, drawable, albedo, normal, material, palette, tint0, tint1, tint2); } // 0xBC6DF00D7A4A6819 b1207
	NATIVE_DECL void REMOVE_TAG_FROM_META_PED(Ped ped, Hash component, int p2) { invoke<Void>(0xD710A5007C2AC539, ped, component, p2); } // 0xD710A5007C2AC539 b1207
	NATIVE_DECL void _0xA2B8E47442C76CEC(Any p0, Any p1) { invoke<Void>(0xA2B8E47442C76CEC, p0, p1); } // 0xA2B8E47442C76CEC b1207
	// Works similar to 0x90403E8107B60E81 (_GET_NUM_COMPONENTS_IN_PED) but is used to get category hashes instead
	NATIVE_DECL int _GET_NUM_COMPONENT_CATEGORIES_IN_PED(Ped ped) { return invoke<int>(0xA622E66EEE92A08D, ped); } // 0xA622E66EEE92A08D b1207
	// Returns category hash that each ped component has. Hash examples: MASKS, HATS, HEADS, HORSE_MANES
	NATIVE_DECL Hash _GET_PED_COMPONENT_CATEGORY_BY_INDEX(Ped ped, int index) { return invoke<Hash>(0xCCB97B51893C662F, ped, index); } // 0xCCB97B51893C662F b1207
	NATIVE_DECL int _GET_NUM_COMPONENTS_IN_PED(Ped ped) { return invoke<int>(0x90403E8107B60E81, ped); } // 0x90403E8107B60E81 b1207
	NATIVE_DECL Any _0x9B90842304C938A7(Any p0, Any p1, Any p2) { return invoke<Any>(0x9B90842304C938A7, p0, p1, p2); } // 0x9B90842304C938A7 b1207
	// Update variation on ped, needed after first creation, or when component or texture/overlay is changed
	NATIVE_DECL void _UPDATE_PED_VARIATION(Ped ped, BOOL p1, BOOL p2, BOOL p3, BOOL p4, BOOL p5) { invoke<Void>(0xCC8CA3E88256E58F, ped, p1, p2, p3, p4, p5); } // 0xCC8CA3E88256E58F b1207
	NATIVE_DECL void _0xCB1A3864C524F784(Any p0, Any p1) { invoke<Void>(0xCB1A3864C524F784, p0, p1); } // 0xCB1A3864C524F784 b1207
	NATIVE_DECL void _0xFA0D206B489A6846(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xFA0D206B489A6846, p0, p1, p2, p3, p4); } // 0xFA0D206B489A6846 b1207
	NATIVE_DECL Any _0xA4AC05B1A364EBC5(Any p0, Any p1, Any p2) { return invoke<Any>(0xA4AC05B1A364EBC5, p0, p1, p2); } // 0xA4AC05B1A364EBC5 b1207
	NATIVE_DECL void _0x1298B3D8E4C2409F(Any p0) { invoke<Void>(0x1298B3D8E4C2409F, p0); } // 0x1298B3D8E4C2409F b1207
	NATIVE_DECL Any _0xA274F51EF7E34B95(Any p0, Any p1) { return invoke<Any>(0xA274F51EF7E34B95, p0, p1); } // 0xA274F51EF7E34B95 b1207
	NATIVE_DECL Any _0xC2EF407645BEECDC(Any p0) { return invoke<Any>(0xC2EF407645BEECDC, p0); } // 0xC2EF407645BEECDC b1207
	// Note: you have to update your ped's variation after calling (using 0xCC8CA3E88256E58F)
	// 
	// Body Types:
	// MPCREATOR_NEUTRAL
	// MPCREATOR_SKINNY
	// MPCREATOR_SKINNY_MUSCULAR
	// MPCREATOR_HEAVY
	// MPCREATOR_HEAVY_MUSCULAR
	// 
	// eBodyWeightOutfit (pedattributes.ymt):
	// -2045421226 (smallest)
	// -1745814259
	// -325933489
	// -1065791927
	// -844699484
	// -1273449080
	// 927185840
	// 149872391
	// 399015098
	// -644349862
	// 1745919061 (default)
	// 1004225511
	// 1278600348
	// 502499352
	// -2093198664
	// -1837436619
	// 1736416063
	// 2040610690
	// -1173634986
	// -867801909
	// 1960266524 (biggest)
	// 
	// https://github.com/femga/rdr3_discoveries/blob/master/peds_customization/ped_outfits.lua
	NATIVE_DECL void _EQUIP_PED_BODY_COMPONENT(Ped ped, Hash hash) { invoke<Void>(0x1902C4CFCC5BE57C, ped, hash); } // 0x1902C4CFCC5BE57C b1207
	NATIVE_DECL void _0xFA742B82D093D848(Any p0, Any p1, Any p2) { invoke<Void>(0xFA742B82D093D848, p0, p1, p2); } // 0xFA742B82D093D848 b1207
	NATIVE_DECL Hash _GET_PED_META_OUTFIT_HASH(Ped ped) { return invoke<Hash>(0x30569F348D126A5A, ped); } // 0x30569F348D126A5A b1207
	NATIVE_DECL void _0xA2F8B3B5FEDFC100(Any p0, Any p1) { invoke<Void>(0xA2F8B3B5FEDFC100, p0, p1); } // 0xA2F8B3B5FEDFC100 b1207
	NATIVE_DECL void _EQUIP_PED_SUBOUTFIT(Any p0, Any p1, Any p2) { invoke<Void>(0x66FF395445A88A6E, p0, p1, p2); } // 0x66FF395445A88A6E b1207
	NATIVE_DECL BOOL _DOES_METAPED_OUTFIT_EXIST_FOR_PED_MODEL(Hash outfit, Hash model) { return invoke<BOOL>(0xC0E880B7A441164D, outfit, model); } // 0xC0E880B7A441164D b1207
	NATIVE_DECL BOOL _DOES_METAPED_SUBOUTFIT_EXIST_FOR_PED_MODEL(Hash outfit, Hash suboutfit, Hash model) { return invoke<BOOL>(0x4FF3C2B4E6A196C1, outfit, suboutfit, model); } // 0x4FF3C2B4E6A196C1 b1207
	// Returns p1 value for 0x8E84119A23C16623
	NATIVE_DECL Any _0x62FDF4E678E40CC6(Entity entity, Any p1) { return invoke<Any>(0x62FDF4E678E40CC6, entity, p1); } // 0x62FDF4E678E40CC6 b1207
	NATIVE_DECL void _RESET_PED_COMPONENTS(Ped ped) { invoke<Void>(0x0BFA1BD465CDFEFD, ped); } // 0x0BFA1BD465CDFEFD b1207
	// _RESET_PED_*
	NATIVE_DECL void _0x370A973252741AC4(Ped ped, BOOL p1) { invoke<Void>(0x370A973252741AC4, ped, p1); } // 0x370A973252741AC4 b1207
	NATIVE_DECL void _SET_RANDOM_OUTFIT_VARIATION(Ped ped, BOOL p1) { invoke<Void>(0x283978A15512B2FE, ped, p1); } // 0x283978A15512B2FE b1207
	NATIVE_DECL int GET_NUM_META_PED_OUTFITS(Ped ped) { return invoke<int>(0x10C70A515BC03707, ped); } // 0x10C70A515BC03707 b1207
	// Sets the outfit preset for the ped. The presetId is an index which determines its preset outfit. p2 is always false.
	NATIVE_DECL void _EQUIP_PED_OUTFIT_PRESET(Ped ped, int presetId, BOOL p2) { invoke<Void>(0x77FF8D35EEC6BBC4, ped, presetId, p2); } // 0x77FF8D35EEC6BBC4 b1207
	// Changes Multiplayer ped face and body type components, they can be stacked
	// Params: p3 = 1
	// Body shape for mp_male from 124 - 128, 110 - 115 for mp_female
	// Face shape for mp_male from 110 - 123, 96 - 109 for mp_female
	// Cloth type for mp_male from 0 - 109, 0 - 95 for mp_female
	NATIVE_DECL void _EQUIP_PED_OUTFIT_EXTRA(Ped ped, int component, Any p2, Any p3) { invoke<Void>(0xA5BAE410B03E7371, ped, component, p2, p3); } // 0xA5BAE410B03E7371 b1207
	// Used in script function HORSE_IS_META_PED_OUTFIT_SADDLE_EQUIPPED
	NATIVE_DECL BOOL _IS_META_PED_OUTFIT_EQUIPPED(Ped ped, Hash outfit) { return invoke<BOOL>(0x98082246107A6ACF, ped, outfit); } // 0x98082246107A6ACF b1207
	NATIVE_DECL void _0x851966E1E35AF491(Any p0, Any p1) { invoke<Void>(0x851966E1E35AF491, p0, p1); } // 0x851966E1E35AF491 b1207
	// Used in script function METAPED_CLOTHING__XML__APPLY_OUTFIT_TINTS_TO_PED
	NATIVE_DECL void _0x4EFC1F8FF1AD94DE(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x4EFC1F8FF1AD94DE, p0, p1, p2, p3, p4, p5); } // 0x4EFC1F8FF1AD94DE b1207
	// Returns requestId
	// Params: p1 = 1 in R* Scripts (Used in SP only)
	NATIVE_DECL int _REQUEST_METAPED_PED(Hash model, int p1) { return invoke<int>(0xF97C34C33487D569, model, p1); } // 0xF97C34C33487D569 b1207
	NATIVE_DECL BOOL _HAS_METAPED_PED_REQUEST_LOADED(int requestId) { return invoke<BOOL>(0xC0940AC858C1E126, requestId); } // 0xC0940AC858C1E126 b1207
	NATIVE_DECL BOOL _IS_METAPED_PED_REQUEST_VALID(int requestId) { return invoke<BOOL>(0x43E4DA469541A9C9, requestId); } // 0x43E4DA469541A9C9 b1207
	// Only used in SP scripts, for example odriscolls1: BOOLS: true, true, true, false, false
	NATIVE_DECL Ped _CREATE_METAPED_PED(int requestId, float x, float y, float z, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8, BOOL p9) { return invoke<Ped>(0x0BCD4091C8EABA42, requestId, x, y, z, heading, p5, p6, p7, p8, p9); } // 0x0BCD4091C8EABA42 b1207
	NATIVE_DECL Ped _CREATE_METAPED_PED(int requestId, Vector3 vec, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8, BOOL p9) { return invoke<Ped>(0x0BCD4091C8EABA42, requestId, vec.x, vec.y, vec.z, heading, p5, p6, p7, p8, p9); } // 0x0BCD4091C8EABA42 b1207
	NATIVE_DECL void _RELEASE_METAPED_PED_REQUEST(int requestId) { invoke<Void>(0x3972F78A78B5D9DF, requestId); } // 0x3972F78A78B5D9DF b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/clothes/metaped_outfits.lua
	// Returns requestId, to be used with 0x74F512E29CB717E2
	NATIVE_DECL int _REQUEST_METAPED_OUTFIT(Hash model, Hash outfit) { return invoke<int>(0x13154A76CE0CF9AB, model, outfit); } // 0x13154A76CE0CF9AB b1207
	NATIVE_DECL Any _0x27E8A84C12B0B7D1(Any p0, Any p1, Any p2) { return invoke<Any>(0x27E8A84C12B0B7D1, p0, p1, p2); } // 0x27E8A84C12B0B7D1 b1207
	NATIVE_DECL Any _0x273915CE30780986(Any p0, Any p1) { return invoke<Any>(0x273915CE30780986, p0, p1); } // 0x273915CE30780986 b1207
	NATIVE_DECL void _RELEASE_METAPED_OUTFIT_REQUEST(int requestId) { invoke<Void>(0x4592B8B9B0EF5F48, requestId); } // 0x4592B8B9B0EF5F48 b1207
	// Used for script function PROCESS_PLAYER_HAT_EVENT
	// Returns requestId to be used with 0x13E7320C762F0477
	NATIVE_DECL int _0x3FCBB5FCFD968698(Hash drawable, Hash albedo, Hash normal, Hash material, Any p4) { return invoke<int>(0x3FCBB5FCFD968698, drawable, albedo, normal, material, p4); } // 0x3FCBB5FCFD968698 b1207
	// Returns requestId
	// Params: p1 = 1 in R* Scripts
	NATIVE_DECL int _REQUEST_METAPED_ASSET_BUNDLE(Hash asset, int p1) { return invoke<int>(0x91FE941F9FCFB702, asset, p1); } // 0x91FE941F9FCFB702 b1207
	NATIVE_DECL Any _REQUEST_METAPED_COMPONENT(int metaPedType, Any p1, int p2, int p3, int p4) { return invoke<Any>(0xF6D9E1F3560CBF8E, metaPedType, p1, p2, p3, p4); } // 0xF6D9E1F3560CBF8E b1207
	NATIVE_DECL void _RELEASE_METAPED_ASSET_REQUEST(int requestId) { invoke<Void>(0x13E7320C762F0477, requestId); } // 0x13E7320C762F0477 b1207
	NATIVE_DECL BOOL _HAS_METAPED_ASSET_LOADED(int requestId) { return invoke<BOOL>(0xB0B2C6D170B0E8E5, requestId); } // 0xB0B2C6D170B0E8E5 b1207
	NATIVE_DECL BOOL _IS_METAPED_ASSET_VALID(int requestId) { return invoke<BOOL>(0x93FFD92F05EC32FD, requestId); } // 0x93FFD92F05EC32FD b1207
	// Creates prop from metaped asset bundle
	// https://github.com/femga/rdr3_discoveries/blob/master/objects/metaped_asset_bundles_list.lua
	// Creates a pickup-able metaped component. asset doesn't seems to be related to component hashes. Hash example : 0xD20354AB (https ://i.imgur.com/dzHkcDb.png)
	NATIVE_DECL Entity _CREATE_METAPED_ASSET(Hash asset, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, BOOL p7, BOOL p8, BOOL p9) { return invoke<Entity>(0x9641A9A20310F6B8, asset, posX, posY, posZ, rotX, rotY, rotZ, p7, p8, p9); } // 0x9641A9A20310F6B8 b1207
	NATIVE_DECL Entity _CREATE_METAPED_ASSET(Hash asset, Vector3 pos, Vector3 rot, BOOL p7, BOOL p8, BOOL p9) { return invoke<Entity>(0x9641A9A20310F6B8, asset, pos.x, pos.y, pos.z, rot.x, rot.y, rot.z, p7, p8, p9); } // 0x9641A9A20310F6B8 b1207
	NATIVE_DECL BOOL _HAS_METAPED_OUTFIT_LOADED(int requestId) { return invoke<BOOL>(0x610438375E5D1801, requestId); } // 0x610438375E5D1801 b1207
	NATIVE_DECL BOOL _IS_METAPED_OUTFIT_REQUEST_VALID(int requestId) { return invoke<BOOL>(0xB25E57FC8E37114D, requestId); } // 0xB25E57FC8E37114D b1207
	// Creates metaped from ped outfit requestId. See _REQUEST_METAPED_OUTFIT
	NATIVE_DECL Ped _CREATE_METAPED_OUTFIT_PED(int requestId, float x, float y, float z, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8) { return invoke<Ped>(0xEAF682A14F8E5F53, requestId, x, y, z, heading, p5, p6, p7, p8); } // 0xEAF682A14F8E5F53 b1207
	NATIVE_DECL Ped _CREATE_METAPED_OUTFIT_PED(int requestId, Vector3 vec, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8) { return invoke<Ped>(0xEAF682A14F8E5F53, requestId, vec.x, vec.y, vec.z, heading, p5, p6, p7, p8); } // 0xEAF682A14F8E5F53 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/clothes/metaped_outfits.lua
	NATIVE_DECL BOOL _APPLY_PED_METAPED_OUTFIT(int requestId, Ped ped, BOOL p2, BOOL p3) { return invoke<BOOL>(0x74F512E29CB717E2, requestId, ped, p2, p3); } // 0x74F512E29CB717E2 b1207
	// Sets ped eye redness, weariness: 0.f to 1.f
	NATIVE_DECL void _SET_METAPED_WEARINESS(Ped ped, float weariness) { invoke<Void>(0x314C5465195F3B30, ped, weariness); } // 0x314C5465195F3B30 b1207
	NATIVE_DECL void _0xF47D54B986F0A346(Ped ped, int danceIntensity) { invoke<Void>(0xF47D54B986F0A346, ped, danceIntensity); } // 0xF47D54B986F0A346 b1232
	NATIVE_DECL void _0x3EFED081B4834BA1(Any p0) { invoke<Void>(0x3EFED081B4834BA1, p0); } // 0x3EFED081B4834BA1 b1232
	NATIVE_DECL void _0x0FB1BA7FF73B41E1(Any p0, Any p1, Any p2) { invoke<Void>(0x0FB1BA7FF73B41E1, p0, p1, p2); } // 0x0FB1BA7FF73B41E1 b1207
	NATIVE_DECL Any _0xB292203008EBBAAC(Any p0) { return invoke<Any>(0xB292203008EBBAAC, p0); } // 0xB292203008EBBAAC b1207
	NATIVE_DECL Any _0xD4D403EA031F351C(Any p0) { return invoke<Any>(0xD4D403EA031F351C, p0); } // 0xD4D403EA031F351C b1207
	// Returns peltId
	NATIVE_DECL int _GET_PELT_FROM_HORSE(Ped horse, int index) { return invoke<int>(0x0CEEB6F4780B1F2F, horse, index); } // 0x0CEEB6F4780B1F2F b1207
	NATIVE_DECL void _SET_PELT_FOR_HORSE(Ped horse, int peltId) { invoke<Void>(0xA73F50E8796150D5, horse, peltId); } // 0xA73F50E8796150D5 b1207
	NATIVE_DECL void _0xC412AA1C73111FE0(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xC412AA1C73111FE0, p0, p1, p2, p3, p4); } // 0xC412AA1C73111FE0 b1207
	NATIVE_DECL void _CLEAR_PELT_FROM_HORSE(Ped horse, int peltId) { invoke<Void>(0x627F7F3A0C4C51FF, horse, peltId); } // 0x627F7F3A0C4C51FF b1207
	NATIVE_DECL void _SET_PED_LIGHTS(Ped ped, BOOL toggle) { invoke<Void>(0x13A210949FCBD92B, ped, toggle); } // 0x13A210949FCBD92B b1207
	NATIVE_DECL void _0xD049FDAF089FDDB0(Any p0, Any p1, Any p2) { invoke<Void>(0xD049FDAF089FDDB0, p0, p1, p2); } // 0xD049FDAF089FDDB0 b1207
	NATIVE_DECL void _0xDD9540E7B1C9714F(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xDD9540E7B1C9714F, p0, p1, p2, p3, p4); } // 0xDD9540E7B1C9714F b1207
	NATIVE_DECL void _0x55546004A244302A(Any p0, Any p1) { invoke<Void>(0x55546004A244302A, p0, p1); } // 0x55546004A244302A b1207
	NATIVE_DECL void _SET_HEALTH_RECHARGE_MULTIPLIER(Ped ped, int multiplier) { invoke<Void>(0xDE1B1907A83A1550, ped, multiplier); } // 0xDE1B1907A83A1550 b1207
	NATIVE_DECL float _GET_HEALTH_RECHARGE_MULTIPLIER(Ped ped) { return invoke<float>(0x95B8E397B8F4360F, ped); } // 0x95B8E397B8F4360F b1207
	NATIVE_DECL void _SET_STAMINA_DEPLETION_MULTIPLIER(Ped ped, int multiplier) { invoke<Void>(0xEF5A3D2285D8924B, ped, multiplier); } // 0xEF5A3D2285D8924B b1207
	NATIVE_DECL float _GET_STAMINA_DEPLETION_MULTIPLIER(Ped ped) { return invoke<float>(0x825F6DD559A0895B, ped); } // 0x825F6DD559A0895B b1207
	NATIVE_DECL void _SET_STAMINA_RECHARGE_MULTIPLIER(Ped ped, int multiplier) { invoke<Void>(0x345C9F993A8AB4A4, ped, multiplier); } // 0x345C9F993A8AB4A4 b1207
	NATIVE_DECL float _GET_STAMINA_RECHARGE_MULTIPLIER(Ped ped) { return invoke<float>(0xE7687EB2F634ABF0, ped); } // 0xE7687EB2F634ABF0 b1207
	// Alters entity's stamina by 'amount'. Can be negative (to drain stamina). float amount: -1000.0 - 1000.0
	NATIVE_DECL BOOL _CHANGE_PED_STAMINA(Ped ped, float amount) { return invoke<BOOL>(0xC3D4B754C0E86B9E, ped, amount); } // 0xC3D4B754C0E86B9E b1207
	NATIVE_DECL float _GET_PED_STAMINA(Ped ped) { return invoke<float>(0x775A1CA7893AA8B5, ped); } // 0x775A1CA7893AA8B5 b1207
	// Returns stamina normalizedValue / normalizedUnlockedMax
	NATIVE_DECL float _GET_PED_STAMINA_NORMALIZED(Ped ped) { return invoke<float>(0x22F2A386D43048A9, ped); } // 0x22F2A386D43048A9 b1207
	NATIVE_DECL float _GET_PED_MAX_STAMINA(Ped ped) { return invoke<float>(0xCB42AFE2B613EE55, ped); } // 0xCB42AFE2B613EE55 b1207
	// _RESET_PED_*
	NATIVE_DECL void _0x36513AFFC703C60D(Any p0) { invoke<Void>(0x36513AFFC703C60D, p0); } // 0x36513AFFC703C60D b1207
	// 0.0 <= stamina <= 100.0
	NATIVE_DECL void _RESTORE_PED_STAMINA(Ped ped, float stamina) { invoke<Void>(0x675680D089BFA21F, ped, stamina); } // 0x675680D089BFA21F b1207
	NATIVE_DECL Any _0xFC3B580C4380B5B7(Any p0) { return invoke<Any>(0xFC3B580C4380B5B7, p0); } // 0xFC3B580C4380B5B7 b1207
	NATIVE_DECL void _0xEA8763E505AFD49A(Any p0, Any p1, Any p2) { invoke<Void>(0xEA8763E505AFD49A, p0, p1, p2); } // 0xEA8763E505AFD49A b1207
	NATIVE_DECL void _0xE4EF4382E22C780C(Any p0) { invoke<Void>(0xE4EF4382E22C780C, p0); } // 0xE4EF4382E22C780C b1207
	NATIVE_DECL void _0xD61FCF9FCFD515B7(Any p0, Any p1, Any p2) { invoke<Void>(0xD61FCF9FCFD515B7, p0, p1, p2); } // 0xD61FCF9FCFD515B7 b1207
	NATIVE_DECL void _0x8D9DB115FBA8E23D(Any p0) { invoke<Void>(0x8D9DB115FBA8E23D, p0); } // 0x8D9DB115FBA8E23D b1207
	NATIVE_DECL Any _GET_NUM_RESERVED_HEALTH(Ped ped) { return invoke<Any>(0x16F2C8C084AB2092, ped); } // 0x16F2C8C084AB2092 b1207
	NATIVE_DECL Any _0xD97BC27AC039F681(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xD97BC27AC039F681, p0, p1, p2, p3); } // 0xD97BC27AC039F681 b1311
	NATIVE_DECL Any _0xF6A8C4B4A11AE89C(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<Any>(0xF6A8C4B4A11AE89C, p0, p1, p2, p3, p4, p5); } // 0xF6A8C4B4A11AE89C b1207
	NATIVE_DECL void _0xE4C95E0AE31C6512(Ped ped, Any p1) { invoke<Void>(0xE4C95E0AE31C6512, ped, p1); } // 0xE4C95E0AE31C6512 b1207
	NATIVE_DECL Object _GET_PED_LAST_DROPPED_HAT(Ped ped) { return invoke<Object>(0x1F714E7A9DADFC42, ped); } // 0x1F714E7A9DADFC42 b1207
	// Related to ped hat
	// _SET_PED_LA* - _SET_PED_LE*
	NATIVE_DECL void _0x5D4CD22A8C82A81A(Ped ped, BOOL p1) { invoke<Void>(0x5D4CD22A8C82A81A, ped, p1); } // 0x5D4CD22A8C82A81A b1207
	NATIVE_DECL void _0xBF567DF2BEF211A6(Any p0, Any p1) { invoke<Void>(0xBF567DF2BEF211A6, p0, p1); } // 0xBF567DF2BEF211A6 b1207
	NATIVE_DECL Any _0x4F5EBE70081E5A20(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8) { return invoke<Any>(0x4F5EBE70081E5A20, p0, p1, p2, p3, p4, p5, p6, p7, p8); } // 0x4F5EBE70081E5A20 b1207
	NATIVE_DECL void _0x87247BC60B60BED8(Any p0) { invoke<Void>(0x87247BC60B60BED8, p0); } // 0x87247BC60B60BED8 b1207
	NATIVE_DECL BOOL _IS_PED_INTIMIDATED(Ped ped) { return invoke<BOOL>(0x57779B55B83E2BEA, ped); } // 0x57779B55B83E2BEA b1207
	// _IS_PED_H* - _IS_PED_I*
	NATIVE_DECL BOOL _0x7EE3A8660F38797E(Ped ped) { return invoke<BOOL>(0x7EE3A8660F38797E, ped); } // 0x7EE3A8660F38797E b1207
	NATIVE_DECL Any _0xA180FBD502A03125(Any p0, Any p1, Any p2) { return invoke<Any>(0xA180FBD502A03125, p0, p1, p2); } // 0xA180FBD502A03125 b1207
	// Creates a texture override data for ped and returns it's index.
	// So you can replace any texture of any ped's component.
	// Also, you can add overlays on it, such as aging, lipstick and more.
	// Textures can be reused by multiple peds at once.
	// You can keep only 32 textures at once(including other peds).
	// 
	// https://github.com/femga/rdr3_discoveries/blob/master/clothes/change_overlays_script.lua
	// materialHash: https://github.com/femga/rdr3_discoveries/blob/master/clothes/cloth_drawable_albedo_normal_material_TEMPORARY.lua
	NATIVE_DECL int _REQUEST_TEXTURE(Hash albedoHash, Hash normalHash, Hash materialHash) { return invoke<int>(0xC5E7204F322E49EB, albedoHash, normalHash, materialHash); } // 0xC5E7204F322E49EB b1207
	NATIVE_DECL void _APPLY_TEXTURE_ON_PED(Ped ped, Hash componentHash, int textureId) { invoke<Void>(0x0B46E25761519058, ped, componentHash, textureId); } // 0x0B46E25761519058 b1207
	// Removes a texture created by 0xC5E7204F322E49EB.
	NATIVE_DECL void _RELEASE_TEXTURE(int textureId) { invoke<Void>(0x6BEFAA907B076859, textureId); } // 0x6BEFAA907B076859 b1207
	// Should be called at least once for any new texture override.
	// Otherwise component textures will be just black.
	// Also needs to be called for updating any ped overlays to apply the changes.
	NATIVE_DECL void _UPDATE_PED_TEXTURE(int textureId) { invoke<Void>(0x92DAABA2C1C10B0E, textureId); } // 0x92DAABA2C1C10B0E b1207
	// Removes every texture layer but the base layer
	// Clearing texture's data: setting params to default values, but keep overlays.
	NATIVE_DECL void _RESET_PED_TEXTURE(int textureId) { invoke<Void>(0x8472A1789478F82F, textureId); } // 0x8472A1789478F82F b1207
	NATIVE_DECL BOOL _IS_TEXTURE_VALID(int textureId) { return invoke<BOOL>(0x31DC8D3F216D8509, textureId); } // 0x31DC8D3F216D8509 b1207
	// Creates ped overlay in texture override data and returns it's index.
	// This index are used for further overlay editing.
	// 
	// albedoHash: a hash of overlay's albedo texture
	// colorType: a color type(from 0 to 2). 0 is used for overlays with RGB colors usually.
	NATIVE_DECL int _ADD_TEXTURE_LAYER(int textureId, Hash albedoHash, Hash normalHash, Hash materialHash, int blendType, float texAlpha, int sheetGridIndex) { return invoke<int>(0x86BB5FF45F193A02, textureId, albedoHash, normalHash, materialHash, blendType, texAlpha, sheetGridIndex); } // 0x86BB5FF45F193A02 b1207
	NATIVE_DECL void _REMOVE_PED_OVERLAY(int textureId, int overlayId) { invoke<Void>(0x96C349DE04C49011, textureId, overlayId); } // 0x96C349DE04C49011 b1207
	NATIVE_DECL void _SET_TEXTURE_LAYER_SHEET_GRID_INDEX(int textureId, int layerId, int sheetGridIndex) { invoke<Void>(0x3329AAE2882FC8E4, textureId, layerId, sheetGridIndex); } // 0x3329AAE2882FC8E4 b1207
	NATIVE_DECL void _SET_TEXTURE_LAYER_ALPHA(int textureId, int layerId, float texAlpha) { invoke<Void>(0x6C76BC24F8BB709A, textureId, layerId, texAlpha); } // 0x6C76BC24F8BB709A b1207
	NATIVE_DECL void _SET_TEXTURE_LAYER_ROUGHNESS(int textureId, int layerId, float texRough) { invoke<Void>(0x057C4F092E2298BE, textureId, layerId, texRough); } // 0x057C4F092E2298BE b1207
	// paletteHash: https://raw.githubusercontent.com/femga/rdr3_discoveries/master/clothes/cloth_color_palletes.lua
	NATIVE_DECL void _SET_TEXTURE_LAYER_PALLETE(int textureId, int layerId, Hash paletteHash) { invoke<Void>(0x1ED8588524AC9BE1, textureId, layerId, paletteHash); } // 0x1ED8588524AC9BE1 b1207
	// Seem color is not RGB or HSV
	NATIVE_DECL void _SET_TEXTURE_LAYER_TINT(int textureId, int layerId, int tint0, int tint1, int tint2) { invoke<Void>(0x2DF59FFE6FFD6044, textureId, layerId, tint0, tint1, tint2); } // 0x2DF59FFE6FFD6044 b1207
	NATIVE_DECL void _SET_TEXTURE_LAYER_MOD(int textureId, int layerId, Hash modTextureHash, float modAlpha, int modChannel) { invoke<Void>(0xF2EA041F1146D75B, textureId, layerId, modTextureHash, modAlpha, modChannel); } // 0xF2EA041F1146D75B b1207
	NATIVE_DECL void _SET_TEXTURE_LAYER_TEXTURE_MAP(int textureId, int layerId, Hash albedoHash, Hash normalHash, Hash materialHash) { invoke<Void>(0x253A63B5BADBC398, textureId, layerId, albedoHash, normalHash, materialHash); } // 0x253A63B5BADBC398 b1207
	// Removes every texture layer
	// Old Name: _RESET_PED_TEXTURE_2
	NATIVE_DECL void _CLEAR_PED_TEXTURE(int textureId) { invoke<Void>(0xB63B9178D0F58D82, textureId); } // 0xB63B9178D0F58D82 b1207
	// Not implemented.
	NATIVE_DECL void _0xC991EF46FE323867(Ped ped, Any p1) { invoke<Void>(0xC991EF46FE323867, ped, p1); } // 0xC991EF46FE323867 b1207
	NATIVE_DECL void _0x1F8215D0E446F593(Any p0, Any p1, Any p2) { invoke<Void>(0x1F8215D0E446F593, p0, p1, p2); } // 0x1F8215D0E446F593 b1207
	NATIVE_DECL BOOL IS_LOCATION_SPAWN_SAFE(Ped ped, float p1) { return invoke<BOOL>(0xFB1E7998B8595825, ped, p1); } // 0xFB1E7998B8595825 b1207
	NATIVE_DECL void _0x53BA7D96B9A421D9(Any p0, Any p1) { invoke<Void>(0x53BA7D96B9A421D9, p0, p1); } // 0x53BA7D96B9A421D9 b1207
	NATIVE_DECL void _0x96C7B659854DE629(Any p0, Any p1) { invoke<Void>(0x96C7B659854DE629, p0, p1); } // 0x96C7B659854DE629 b1207
	// -1 - HORSE_ASSIST__NO_CHANGE
	//  0 - HORSE_ASSIST__MANUAL
	//  1 - HORSE_ASSIST__SEMIASSIST
	//  2 - HORSE_ASSIST__FULLASSIST
	NATIVE_DECL void SET_HORSE_AVOIDANCE_LEVEL(Ped horse, int avoidanceLevel) { invoke<Void>(0xDDCF6FEA5D7ACC17, horse, avoidanceLevel); } // 0xDDCF6FEA5D7ACC17 b1207
	NATIVE_DECL void RESET_HORSE_AVOIDANCE_LEVEL_TO_DEFAULT(Ped horse) { invoke<Void>(0x2A5AFD2B8381A6E1, horse); } // 0x2A5AFD2B8381A6E1 b1207
	// Doesn't actually return anything.
	NATIVE_DECL Any _SET_PED_USE_HORSE_MAP_COLLISION(Ped ped, BOOL toggle) { return invoke<Any>(0xEB72453B6F5B45B0, ped, toggle); } // 0xEB72453B6F5B45B0 b1232
	NATIVE_DECL void _0x5B73975B4F12F7F3(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x5B73975B4F12F7F3, p0, p1, p2, p3, p4); } // 0x5B73975B4F12F7F3 b1207
	NATIVE_DECL BOOL GET_META_PED_ASSET_GUIDS(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<BOOL>(0xA9C28516A6DC9D56, p0, p1, p2, p3, p4, p5); } // 0xA9C28516A6DC9D56 b1207
	NATIVE_DECL BOOL GET_META_PED_ASSET_TINT(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { return invoke<BOOL>(0xE7998FEC53A33BBE, p0, p1, p2, p3, p4, p5); } // 0xE7998FEC53A33BBE b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/BLACKBOARDS
	// Blackboard natives allow you to apply and check certain data to/for peds.
	// Blackboard bools, floats and strings are subdivided into 6 sections: "all", "animation", "any", "code", "global" and "script"
	// Most changes are only visible for "script" blackboards, some "script" blackboards change ped motions
	// "removeTimer" is self-removal timer, can be "-1" so your data will not be removed by the game (forever); 100 = 1 second
	NATIVE_DECL void _SET_PED_BLACKBOARD_INT(Ped ped, const char* variableName, int value, int removeTimer) { invoke<Void>(0x5F53010C4C3F6BAF, ped, variableName, value, removeTimer); } // 0x5F53010C4C3F6BAF b1207
	NATIVE_DECL void _SET_PED_BLACKBOARD_BOOL(Ped ped, const char* variableName, BOOL value, int removeTimer) { invoke<Void>(0xCB9401F918CB0F75, ped, variableName, value, removeTimer); } // 0xCB9401F918CB0F75 b1207
	NATIVE_DECL void _SET_PED_BLACKBOARD_FLOAT(Ped ped, const char* variableName, float value, int removeTimer) { invoke<Void>(0x437C08DB4FEBE2BD, ped, variableName, value, removeTimer); } // 0x437C08DB4FEBE2BD b1207
	// p1:
	// BodyPartChained
	// OverloadMostInjuredBodyPart
	// 
	// p2:
	// LeftLeg
	// Legs
	// RightArm
	NATIVE_DECL void _SET_PED_BLACKBOARD_HASH(Ped ped, const char* variableName, const char* value, int removeTimer) { invoke<Void>(0xA762C9D6CF165E0D, ped, variableName, value, removeTimer); } // 0xA762C9D6CF165E0D b1207
	NATIVE_DECL void _REMOVE_PED_BLACKBOARD_INT(Ped ped, const char* variableName) { invoke<Void>(0x81B75428A7813E67, ped, variableName); } // 0x81B75428A7813E67 b1207
	NATIVE_DECL void _REMOVE_PED_BLACKBOARD_BOOL(Ped ped, const char* variableName) { invoke<Void>(0xA6F67BEC53379A32, ped, variableName); } // 0xA6F67BEC53379A32 b1207
	NATIVE_DECL void _REMOVE_PED_BLACKBOARD_FLOAT(Ped ped, const char* variableName) { invoke<Void>(0x411189E51B8020BA, ped, variableName); } // 0x411189E51B8020BA b1207
	NATIVE_DECL void _REMOVE_PED_BLACKBOARD_HASH(Ped ped, const char* variableName) { invoke<Void>(0x0E17378642156790, ped, variableName); } // 0x0E17378642156790 b1207
	// Can be used to get a peds foliage active status: variableName = FoliageActive
	NATIVE_DECL BOOL _GET_PED_BLACKBOARD_BOOL(Ped ped, const char* variableName) { return invoke<BOOL>(0x498F2E77982D6945, ped, variableName); } // 0x498F2E77982D6945 b1207
	// Can be used to get a peds foliage raw height: variableName = FoliageHeight
	NATIVE_DECL float _GET_PED_BLACKBOARD_FLOAT(Ped ped, const char* variableName) { return invoke<float>(0x56E58D4D118FB45E, ped, variableName); } // 0x56E58D4D118FB45E b1207
	NATIVE_DECL Hash _GET_PED_BLACKBOARD_HASH(Ped ped, const char* variableName) { return invoke<Hash>(0xBF5E791BBBF90A3C, ped, variableName); } // 0xBF5E791BBBF90A3C b1207
	NATIVE_DECL int GET_PED_BLACKBOARD_SCRIPT_INT(Ped ped, const char* variableName) { return invoke<int>(0xB71B91B398F8F067, ped, variableName); } // 0xB71B91B398F8F067 b1207
	NATIVE_DECL BOOL GET_PED_BLACKBOARD_SCRIPT_BOOL(Ped ped, const char* variableName) { return invoke<BOOL>(0x4912DFE492DB98CD, ped, variableName); } // 0x4912DFE492DB98CD b1207
	NATIVE_DECL float GET_PED_BLACKBOARD_SCRIPT_FLOAT(Ped ped, const char* variableName) { return invoke<float>(0xA29FD00D45311EB7, ped, variableName); } // 0xA29FD00D45311EB7 b1207
	// Size will be permanent
	NATIVE_DECL void _SET_TANK_ATTRIBUTE_SIZE(Ped ped, int attributeIndex, float size) { invoke<Void>(0x7FF72DE061DF55E2, ped, attributeIndex, size); } // 0x7FF72DE061DF55E2 b1207
	NATIVE_DECL Any _0xA31D350D66FA1855(Any p0) { return invoke<Any>(0xA31D350D66FA1855, p0); } // 0xA31D350D66FA1855 b1207
	// _IS_TRACKED_* - IS_V*
	NATIVE_DECL BOOL _IS_USING_SLIPSTREAM(Ped ped) { return invoke<BOOL>(0xAF61B3CD8C3B82C3, ped); } // 0xAF61B3CD8C3B82C3 b1207
	NATIVE_DECL void _0xEEDC9B29314B2733(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { invoke<Void>(0xEEDC9B29314B2733, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0xEEDC9B29314B2733 b1207
	NATIVE_DECL void _0x5C90E20C25E6D83C(Any p0) { invoke<Void>(0x5C90E20C25E6D83C, p0); } // 0x5C90E20C25E6D83C b1207
	// NB_CUSTOM_CLIENT_ON_CREATE_COMPLETE - set legendary to not avoid prey
	NATIVE_DECL void _0x10F96086123B939F(Ped legendaryPed, Ped preyPed, float p2) { invoke<Void>(0x10F96086123B939F, legendaryPed, preyPed, p2); } // 0x10F96086123B939F b1207
	NATIVE_DECL void _0x3FDBB99EFD8CE4AF(Any p0, Any p1, Any p2) { invoke<Void>(0x3FDBB99EFD8CE4AF, p0, p1, p2); } // 0x3FDBB99EFD8CE4AF b1207
	NATIVE_DECL void _0x7E8F9949B7AABBF0(Any p0, Any p1, Any p2) { invoke<Void>(0x7E8F9949B7AABBF0, p0, p1, p2); } // 0x7E8F9949B7AABBF0 b1207
	NATIVE_DECL Any _0x5DA36CCCB63C0895(Any p0, Any p1, Any p2) { return invoke<Any>(0x5DA36CCCB63C0895, p0, p1, p2); } // 0x5DA36CCCB63C0895 b1207
	NATIVE_DECL void _0x56076667E7C2DCD6(Any p0, Any p1) { invoke<Void>(0x56076667E7C2DCD6, p0, p1); } // 0x56076667E7C2DCD6 b1311
	NATIVE_DECL void _APPLY_SHOP_ITEM_TO_PED(Ped ped, Hash componentHash, BOOL immediately, BOOL isMp, BOOL p4) { invoke<Void>(0xD3A7B003ED343FD9, ped, componentHash, immediately, isMp, p4); } // 0xD3A7B003ED343FD9 b1207
	// Directly removes a shop item component from a ped
	// Params: p2 and p3 are always 0
	NATIVE_DECL void _REMOVE_SHOP_ITEM_FROM_PED(Ped ped, Hash componentHash, int p2, BOOL p3) { invoke<Void>(0x0D7FFA1B2F69ED82, ped, componentHash, p2, p3); } // 0x0D7FFA1B2F69ED82 b1355
	// Params: p2, p3 usually 0 in R* Scripts
	NATIVE_DECL void REMOVE_SHOP_ITEM_FROM_PED_BY_CATEGORY(Ped ped, Hash componentCategory, int p2, BOOL p3) { invoke<Void>(0xDF631E4BCE1B1FC4, ped, componentCategory, p2, p3); } // 0xDF631E4BCE1B1FC4 b1207
	NATIVE_DECL void _UPDATE_SHOP_ITEM_WEARABLE_STATE(Ped ped, Hash componentHash, Hash wearableState, int p3, BOOL p4, int p5) { invoke<Void>(0x66B957AAC2EAAEAB, ped, componentHash, wearableState, p3, p4, p5); } // 0x66B957AAC2EAAEAB b1207
	NATIVE_DECL Hash _GET_SHOP_PED_COMPONENT_AT_INDEX(Ped ped, int index, BOOL p2, Any* argStruct, Any* argStruct2) { return invoke<Hash>(0x77BA37622E22023B, ped, index, p2, argStruct, argStruct2); } // 0x77BA37622E22023B b1207
	NATIVE_DECL Any _0xFFCC2DB2D9953401(Any p0, Any p1, Any p2) { return invoke<Any>(0xFFCC2DB2D9953401, p0, p1, p2); } // 0xFFCC2DB2D9953401 b1207
	NATIVE_DECL Any _0x6243635AF2F1B826(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x6243635AF2F1B826, p0, p1, p2, p3); } // 0x6243635AF2F1B826 b1207
	NATIVE_DECL Hash _GET_SHOP_PED_COMPONENT_CATEGORY(Hash componentHash, int metapedType, BOOL isMP) { return invoke<Hash>(0x5FF9A878C3D115B8, componentHash, metapedType, isMP); } // 0x5FF9A878C3D115B8 b1207
	NATIVE_DECL Any _0x31B2E7F2E3C58B89(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0x31B2E7F2E3C58B89, p0, p1, p2, p3); } // 0x31B2E7F2E3C58B89 b1207
	NATIVE_DECL BOOL _GET_SHOP_PED_BASE_LAYERS(Hash shopItem, Any p1, Ped ped, int metapedType, BOOL p4, Hash* drawable, Hash* albedo, Hash* normal, Hash* material, Hash* p9, Hash* p10, Hash* p11, Hash* p12) { return invoke<BOOL>(0x63342C50EC115CE8, shopItem, p1, ped, metapedType, p4, drawable, albedo, normal, material, p9, p10, p11, p12); } // 0x63342C50EC115CE8 b1207
	// Related to _0x704C908E9C405136 for component loading
	// _S*
	NATIVE_DECL Any _0xAAB86462966168CE(Ped ped, BOOL p1) { return invoke<Any>(0xAAB86462966168CE, ped, p1); } // 0xAAB86462966168CE b1207
	NATIVE_DECL Any _GET_SHOP_PED_HAT_COMPONENT(Ped ped, int metapedType, BOOL p2) { return invoke<Any>(0x7E02E4218D916B94, ped, metapedType, p2); } // 0x7E02E4218D916B94 b1207
	NATIVE_DECL void _0x59BD177A1A48600A(Any p0, Any p1) { invoke<Void>(0x59BD177A1A48600A, p0, p1); } // 0x59BD177A1A48600A b1207
	NATIVE_DECL void _0xD103F6DBB5442BE8(Any p0, Any p1) { invoke<Void>(0xD103F6DBB5442BE8, p0, p1); } // 0xD103F6DBB5442BE8 b1207
	NATIVE_DECL void _SET_PED_PROMPT_NAME_FROM_GXT_ENTRY(Ped ped, Hash gxtEntryHash) { invoke<Void>(0xFCA8FB9E15FA80D3, ped, gxtEntryHash); } // 0xFCA8FB9E15FA80D3 b1207
	NATIVE_DECL void _SET_PED_PROMPT_NAME(Ped ped, const char* name) { invoke<Void>(0x4A48B6E03BABB4AC, ped, name); } // 0x4A48B6E03BABB4AC b1207
	NATIVE_DECL void _0xC2745D9261664901(Any p0, Any p1) { invoke<Void>(0xC2745D9261664901, p0, p1); } // 0xC2745D9261664901 b1207
	NATIVE_DECL void _0x19B14E04B009E28B(Any p0, Any p1) { invoke<Void>(0x19B14E04B009E28B, p0, p1); } // 0x19B14E04B009E28B b1207
	NATIVE_DECL void _0xF917F92BF22ECBAB(Any p0) { invoke<Void>(0xF917F92BF22ECBAB, p0); } // 0xF917F92BF22ECBAB b1207
	NATIVE_DECL void _0x49DADFC4CD808B0A(Any p0, Any p1, Any p2) { invoke<Void>(0x49DADFC4CD808B0A, p0, p1, p2); } // 0x49DADFC4CD808B0A b1207
	// limb: 3 = Left Hand, 4 = Left Arm, 6 = Right Hand, 7 = Right Arm, 9 = Left Foot, 10 = Left Leg, 12 = Right Foot, 13 = Right Leg, 37 = Head
	NATIVE_DECL BOOL _HAS_PED_TAKEN_GORE_DAMAGE(Ped ped, int limb) { return invoke<BOOL>(0xBA208A8D6399A3AC, ped, limb); } // 0xBA208A8D6399A3AC b1207
	// _CLEAR*
	NATIVE_DECL void _0x704C908E9C405136(Ped ped) { invoke<Void>(0x704C908E9C405136, ped); } // 0x704C908E9C405136 b1207
	NATIVE_DECL void _0x7406C71F4AC2FFCC(Any p0) { invoke<Void>(0x7406C71F4AC2FFCC, p0); } // 0x7406C71F4AC2FFCC b1207
	NATIVE_DECL void _0x28508173C6A7CC18(Any p0) { invoke<Void>(0x28508173C6A7CC18, p0); } // 0x28508173C6A7CC18 b1311
	NATIVE_DECL Any _0x52250B92EA70BE3D(Any p0) { return invoke<Any>(0x52250B92EA70BE3D, p0); } // 0x52250B92EA70BE3D b1207
	// quality: see _GET_PED_QUALITY
	NATIVE_DECL void _SET_PED_QUALITY(Ped ped, int quality) { invoke<Void>(0xCE6B874286D640BB, ped, quality); } // 0xCE6B874286D640BB b1207
	// enum ePedQuality
	// {
	// 	PQ_INVALID = -1,
	// 	PQ_LOW,
	// 	PQ_MEDIUM,
	// 	PQ_HIGH,
	// 	PQ_MAX
	// };
	NATIVE_DECL int _GET_PED_QUALITY(Ped ped) { return invoke<int>(0x7BCC6087D130312A, ped); } // 0x7BCC6087D130312A b1207
	NATIVE_DECL void _0xCE7A6C1D5CDE1F9D(Ped ped, Object object, const char* propName, const char* animName) { invoke<Void>(0xCE7A6C1D5CDE1F9D, ped, object, propName, animName); } // 0xCE7A6C1D5CDE1F9D b1207
	NATIVE_DECL void _0x604E1010E3162E86(Any p0, Any p1, Any p2) { invoke<Void>(0x604E1010E3162E86, p0, p1, p2); } // 0x604E1010E3162E86 b1207
	NATIVE_DECL void _0xE8ABE3B73FC7FE17(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xE8ABE3B73FC7FE17, p0, p1, p2, p3); } // 0xE8ABE3B73FC7FE17 b1207
	NATIVE_DECL void _REMOVE_PED_PROP(Ped ped, const char* propName) { invoke<Void>(0x3A50753042B6891B, ped, propName); } // 0x3A50753042B6891B b1207
	// _SET_W(EAPON?)*
	NATIVE_DECL void _SET_TOTAL_PED_DAMAGE_FALLOFF_BONUS(Ped ped, float bonus) { invoke<Void>(0x932786CE3C76477C, ped, bonus); } // 0x932786CE3C76477C b1207
	NATIVE_DECL Any _0x095C2277FED731DB(Any p0) { return invoke<Any>(0x095C2277FED731DB, p0); } // 0x095C2277FED731DB b1207
	NATIVE_DECL void _0x09171A6F8FDE5DC1(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x09171A6F8FDE5DC1, p0, p1, p2, p3, p4); } // 0x09171A6F8FDE5DC1 b1207
	NATIVE_DECL void _0x09E378C52B1433B5(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x09E378C52B1433B5, p0, p1, p2, p3, p4); } // 0x09E378C52B1433B5 b1207
	// _IS_N* - _IS_P*
	NATIVE_DECL BOOL _0x6507AC3BD7C99009(float x, float y, float z, float p3) { return invoke<BOOL>(0x6507AC3BD7C99009, x, y, z, p3); } // 0x6507AC3BD7C99009 b1207
	NATIVE_DECL BOOL _0x6507AC3BD7C99009(Vector3 vec, float p3) { return invoke<BOOL>(0x6507AC3BD7C99009, vec.x, vec.y, vec.z, p3); } // 0x6507AC3BD7C99009 b1207
	// Returns how deep the water is below the ped (if in water)
	// -1.0f = Not in water
	// 10.0f = Max water depth
	NATIVE_DECL float _GET_PLAYER_PED_WATER_DEPTH(Ped ped) { return invoke<float>(0x2942457417A5FD24, ped); } // 0x2942457417A5FD24 b1207
	// duration in seconds
	NATIVE_DECL void _SET_PED_TRAIL_EFFECT(Ped ped, BOOL p1, float duration) { invoke<Void>(0xA5950E16B8F31052, ped, p1, duration); } // 0xA5950E16B8F31052 b1207
	// If returned true: PROCESS_RESIZING_TRACKING_BOUNDS_VOLUME - Scaling UP the bounds due to tracking
	// If returned false: PROCESS_RESIZING_TRACKING_BOUNDS_VOLUME - Scaling DOWN the bounds due to tracking
	// _IS_PED_T* - _IS_PED_U*
	NATIVE_DECL BOOL _0xEBAAC9A750E7563B(Ped ped) { return invoke<BOOL>(0xEBAAC9A750E7563B, ped); } // 0xEBAAC9A750E7563B b1207
	NATIVE_DECL void _0x992187D975635DF5(Any p0, Any p1) { invoke<Void>(0x992187D975635DF5, p0, p1); } // 0x992187D975635DF5 b1311
	NATIVE_DECL void _0x0B787A37EEDD226F(Any p0, Any p1) { invoke<Void>(0x0B787A37EEDD226F, p0, p1); } // 0x0B787A37EEDD226F b1311
}

namespace PERSCHAR
{
	NATIVE_DECL void _0x63AA2B8EB087886A(Any p0, Any p1) { invoke<Void>(0x63AA2B8EB087886A, p0, p1); } // 0x63AA2B8EB087886A b1207
	NATIVE_DECL Hash _GET_PERSCHAR_MODEL_NAME(Hash persCharHash) { return invoke<Hash>(0xA00DF706C60173D1, persCharHash); } // 0xA00DF706C60173D1 b1207
	NATIVE_DECL void _0x8BC555034A5A5E8C(Any p0, Any p1) { invoke<Void>(0x8BC555034A5A5E8C, p0, p1); } // 0x8BC555034A5A5E8C b1207
	NATIVE_DECL void _0x70605812ABC9FF0F(Any p0, Any p1) { invoke<Void>(0x70605812ABC9FF0F, p0, p1); } // 0x70605812ABC9FF0F b1207
	NATIVE_DECL Any _0xDC9655D47DEC0353(Any p0) { return invoke<Any>(0xDC9655D47DEC0353, p0); } // 0xDC9655D47DEC0353 b1207
	NATIVE_DECL void _0x2DF89CD2ED1D0BDE(Any p0, Any p1) { invoke<Void>(0x2DF89CD2ED1D0BDE, p0, p1); } // 0x2DF89CD2ED1D0BDE b1207
	NATIVE_DECL void _0x535A66AAD2BF68F9(Any p0, Any p1) { invoke<Void>(0x535A66AAD2BF68F9, p0, p1); } // 0x535A66AAD2BF68F9 b1207
	NATIVE_DECL Any _0xCEB40B678E403759(Any p0) { return invoke<Any>(0xCEB40B678E403759, p0); } // 0xCEB40B678E403759 b1207
	NATIVE_DECL void _SET_PERSCHAR_SCHEDULE(Hash persCharHash, const char* schedule) { invoke<Void>(0x187D65F3AEC5D679, persCharHash, schedule); } // 0x187D65F3AEC5D679 b1207
	NATIVE_DECL void _0x8B44273A92CD406C(Any p0) { invoke<Void>(0x8B44273A92CD406C, p0); } // 0x8B44273A92CD406C b1207
	NATIVE_DECL void _0xE0E65E0D261F7507(Any p0) { invoke<Void>(0xE0E65E0D261F7507, p0); } // 0xE0E65E0D261F7507 b1207
	NATIVE_DECL Any _0x112DDF56300BC6E5(Any p0) { return invoke<Any>(0x112DDF56300BC6E5, p0); } // 0x112DDF56300BC6E5 b1207
	NATIVE_DECL PersChar _CREATE_PERSISTENT_CHARACTER(Hash hash) { return invoke<PersChar>(0x4F76E3676583D951, hash); } // 0x4F76E3676583D951 b1207
	NATIVE_DECL BOOL _IS_PERSISTENT_CHARACTER_VALID(PersChar persChar) { return invoke<BOOL>(0x800DF3FC913355F3, persChar); } // 0x800DF3FC913355F3 b1207
	NATIVE_DECL void _DELETE_PERSCHAR(PersChar persChar) { invoke<Void>(0xFC77C5B44D5FF7C0, persChar); } // 0xFC77C5B44D5FF7C0 b1207
	NATIVE_DECL Vector3 _0x5EE6FCCC9C832CA2(Any p0) { return invoke<Vector3>(0x5EE6FCCC9C832CA2, p0); } // 0x5EE6FCCC9C832CA2 b1207
	NATIVE_DECL void _0x59C7AD6FEA2AC449(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x59C7AD6FEA2AC449, p0, p1, p2, p3); } // 0x59C7AD6FEA2AC449 b1207
	NATIVE_DECL void _0xBB68908CD11AEBDC(Any p0) { invoke<Void>(0xBB68908CD11AEBDC, p0); } // 0xBB68908CD11AEBDC b1207
	NATIVE_DECL Vector3 _0x94995829ED15A598(Any p0) { return invoke<Vector3>(0x94995829ED15A598, p0); } // 0x94995829ED15A598 b1207
	NATIVE_DECL Ped _GET_PERSCHAR_PED_INDEX(PersChar persChar) { return invoke<Ped>(0x31C70A716CAE1FEE, persChar); } // 0x31C70A716CAE1FEE b1207
	NATIVE_DECL PersChar _GET_PERSCHAR_INDEX_FROM_PED_INDEX(Ped ped) { return invoke<PersChar>(0x32A1E3B83D501096, ped); } // 0x32A1E3B83D501096 b1207
	NATIVE_DECL Any _0xF8DE7154F7D1458F(Any p0) { return invoke<Any>(0xF8DE7154F7D1458F, p0); } // 0xF8DE7154F7D1458F b1207
	NATIVE_DECL void _0x669C25840C6F7AE2(Any p0, Any p1) { invoke<Void>(0x669C25840C6F7AE2, p0, p1); } // 0x669C25840C6F7AE2 b1207
	NATIVE_DECL void _RETASK_PERSISTANT_CHARACTER(PersChar persChar) { invoke<Void>(0x631CD2D77FDC0316, persChar); } // 0x631CD2D77FDC0316 b1207
	NATIVE_DECL void _0x0B3A99AB6713AA52(Any p0) { invoke<Void>(0x0B3A99AB6713AA52, p0); } // 0x0B3A99AB6713AA52 b1207
	NATIVE_DECL BOOL _IS_PERSISTENT_CHARACTER_DEAD(PersChar persChar) { return invoke<BOOL>(0xEB98B38CA60742D7, persChar); } // 0xEB98B38CA60742D7 b1207
	NATIVE_DECL BOOL _REVIVE_PERSCHAR(PersChar persChar) { return invoke<BOOL>(0x49A8C2CD97815215, persChar); } // 0x49A8C2CD97815215 b1207
	NATIVE_DECL void _0xD4B614179BCD0654(Any p0) { invoke<Void>(0xD4B614179BCD0654, p0); } // 0xD4B614179BCD0654 b1207
	NATIVE_DECL void _0x406808610220405B(Any p0) { invoke<Void>(0x406808610220405B, p0); } // 0x406808610220405B b1207
	NATIVE_DECL void _0xA2B18FF8D39F6D87(Any p0) { invoke<Void>(0xA2B18FF8D39F6D87, p0); } // 0xA2B18FF8D39F6D87 b1207
	NATIVE_DECL Any _0xE4C51A8A3BD1664C(Any p0) { return invoke<Any>(0xE4C51A8A3BD1664C, p0); } // 0xE4C51A8A3BD1664C b1207
	NATIVE_DECL void _0x8AE4EFA464DAE42D(Any p0, Any p1) { invoke<Void>(0x8AE4EFA464DAE42D, p0, p1); } // 0x8AE4EFA464DAE42D b1207
	NATIVE_DECL void _0xA4DCB3F0DD7488BD(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xA4DCB3F0DD7488BD, p0, p1, p2, p3, p4); } // 0xA4DCB3F0DD7488BD b1207
	NATIVE_DECL void _0xD95D777F828B2BBB(Any p0) { invoke<Void>(0xD95D777F828B2BBB, p0); } // 0xD95D777F828B2BBB b1207
	NATIVE_DECL void _0x92690B0822493CE0() { invoke<Void>(0x92690B0822493CE0); } // 0x92690B0822493CE0 b1207
	NATIVE_DECL void _0xEFC5C6670E0B99BA() { invoke<Void>(0xEFC5C6670E0B99BA); } // 0xEFC5C6670E0B99BA b1207
	NATIVE_DECL void _0x2E957AA81F2C61C9() { invoke<Void>(0x2E957AA81F2C61C9); } // 0x2E957AA81F2C61C9 b1207
	NATIVE_DECL void _0xB173599D61FAEB31() { invoke<Void>(0xB173599D61FAEB31); } // 0xB173599D61FAEB31 b1207
	NATIVE_DECL Entity _0x08FC896D2CB31FCC(Any p0, BOOL p1) { return invoke<Entity>(0x08FC896D2CB31FCC, p0, p1); } // 0x08FC896D2CB31FCC b1207
	NATIVE_DECL Entity _FORCE_SPAWN_PERSCHAR(PersChar persChar, BOOL p1) { return invoke<Entity>(0x0CADC3A977997472, persChar, p1); } // 0x0CADC3A977997472 b1207
	NATIVE_DECL void _FORCE_DESPAWN_PERSCHAR(PersChar persChar) { invoke<Void>(0x7B204F88F6C3D287, persChar); } // 0x7B204F88F6C3D287 b1207
	NATIVE_DECL void _0xFCC6DB8DBE709BC8(Any p0) { invoke<Void>(0xFCC6DB8DBE709BC8, p0); } // 0xFCC6DB8DBE709BC8 b1207
	NATIVE_DECL void _0xA8C406C2A56EDC16(Any p0) { invoke<Void>(0xA8C406C2A56EDC16, p0); } // 0xA8C406C2A56EDC16 b1207
	NATIVE_DECL void _0x4F81EAD1DE8FA19B(Any p0) { invoke<Void>(0x4F81EAD1DE8FA19B, p0); } // 0x4F81EAD1DE8FA19B b1207
	NATIVE_DECL void _0x6759BEE6762E140B(Any p0) { invoke<Void>(0x6759BEE6762E140B, p0); } // 0x6759BEE6762E140B b1207
	NATIVE_DECL void _0xB65E7F733956CF25(Any p0) { invoke<Void>(0xB65E7F733956CF25, p0); } // 0xB65E7F733956CF25 b1207
	NATIVE_DECL Any _0x4AFC7288C77238B3(Any p0) { return invoke<Any>(0x4AFC7288C77238B3, p0); } // 0x4AFC7288C77238B3 b1207
	NATIVE_DECL Any _0xA8120EBEAF290C7A(Any p0) { return invoke<Any>(0xA8120EBEAF290C7A, p0); } // 0xA8120EBEAF290C7A b1207
	NATIVE_DECL Any _0x69786495C92A3044(Any p0) { return invoke<Any>(0x69786495C92A3044, p0); } // 0x69786495C92A3044 b1207
	NATIVE_DECL Any _0xEC254C2C9B0F08F1(Any p0, Any p1) { return invoke<Any>(0xEC254C2C9B0F08F1, p0, p1); } // 0xEC254C2C9B0F08F1 b1207
	NATIVE_DECL Any _0x9C7F95946E304778(Any p0, Any p1) { return invoke<Any>(0x9C7F95946E304778, p0, p1); } // 0x9C7F95946E304778 b1207
}

namespace PERSISTENCE
{
	NATIVE_DECL void _0x7A1BD123E5CDB6E5() { invoke<Void>(0x7A1BD123E5CDB6E5); } // 0x7A1BD123E5CDB6E5 b1207
	NATIVE_DECL void PERSISTENCE_REMOVE_ALL_ENTITIES_IN_AREA(float x, float y, float z, float radius) { invoke<Void>(0x9D16896F0DBE78A2, x, y, z, radius); } // 0x9D16896F0DBE78A2 b1207
	NATIVE_DECL void PERSISTENCE_REMOVE_ALL_ENTITIES_IN_AREA(Vector3 vec, float radius) { invoke<Void>(0x9D16896F0DBE78A2, vec.x, vec.y, vec.z, radius); } // 0x9D16896F0DBE78A2 b1207
	NATIVE_DECL void _0x065887B694359799(Any p0) { invoke<Void>(0x065887B694359799, p0); } // 0x065887B694359799 b1207
	NATIVE_DECL void _0xFC9806DA9A460093(float x1, float y1, float z1, float x2, float y2, float z2) { invoke<Void>(0xFC9806DA9A460093, x1, y1, z1, x2, y2, z2); } // 0xFC9806DA9A460093 b1207
	NATIVE_DECL void _0xFC9806DA9A460093(Vector3 vec1, Vector3 vec2) { invoke<Void>(0xFC9806DA9A460093, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z); } // 0xFC9806DA9A460093 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0xB03140014ACA6C40(Any p0, Any p1) { invoke<Void>(0xB03140014ACA6C40, p0, p1); } // 0xB03140014ACA6C40 b1207
	NATIVE_DECL void _0xE225CEF1901F6108(Any p0, Any p1) { invoke<Void>(0xE225CEF1901F6108, p0, p1); } // 0xE225CEF1901F6108 b1207
	NATIVE_DECL void _0x8DE104BEC243A73B(Any p0) { invoke<Void>(0x8DE104BEC243A73B, p0); } // 0x8DE104BEC243A73B b1207
	// Only used in R* script long_update.ysc in script function REFRESH_CLOSEST_TOWN
	NATIVE_DECL void _PERSISTENCE_REFRESH_TOWN_VOLUME(Volume volume) { invoke<Void>(0xEFB5F34CC0953B27, volume); } // 0xEFB5F34CC0953B27 b1207
	NATIVE_DECL Any _0xBA2C49EA6A8D24FF(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { return invoke<Any>(0xBA2C49EA6A8D24FF, p0, p1, p2, p3, p4, p5, p6); } // 0xBA2C49EA6A8D24FF b1207
	NATIVE_DECL Any _0x2E545965DF98D476(Any p0) { return invoke<Any>(0x2E545965DF98D476, p0); } // 0x2E545965DF98D476 b1207
	NATIVE_DECL void _0xF5622FA6ACFCA7DB(Any p0, Any p1) { invoke<Void>(0xF5622FA6ACFCA7DB, p0, p1); } // 0xF5622FA6ACFCA7DB b1207
	NATIVE_DECL void _0x3CA5E58C9731A16B(Any p0, Any p1) { invoke<Void>(0x3CA5E58C9731A16B, p0, p1); } // 0x3CA5E58C9731A16B b1207
	NATIVE_DECL void _0xDC0A1F0ECEC9F0C0(Any p0, Any p1) { invoke<Void>(0xDC0A1F0ECEC9F0C0, p0, p1); } // 0xDC0A1F0ECEC9F0C0 b1207
	NATIVE_DECL Any _0x5A79220F6D38D7C3(Any p0) { return invoke<Any>(0x5A79220F6D38D7C3, p0); } // 0x5A79220F6D38D7C3 b1207
	NATIVE_DECL Any _0xCFDA2518F322D836(Any p0) { return invoke<Any>(0xCFDA2518F322D836, p0); } // 0xCFDA2518F322D836 b1207
	NATIVE_DECL Any _0x1F56FB3FDB4EAF65(Any p0) { return invoke<Any>(0x1F56FB3FDB4EAF65, p0); } // 0x1F56FB3FDB4EAF65 b1207
	NATIVE_DECL void _0x291CC21D1FB6790E(Any p0) { invoke<Void>(0x291CC21D1FB6790E, p0); } // 0x291CC21D1FB6790E b1207
	NATIVE_DECL void PERSISTENCE_ADD_SCENARIO_LOOTED(int scenario) { invoke<Void>(0x8245C1F3262F4AC2, scenario); } // 0x8245C1F3262F4AC2 b1207
	NATIVE_DECL BOOL _PERSISTENCE_IS_SCENARIO_MARKED_AS_LOOTED(int scenario) { return invoke<BOOL>(0xFB7CF1DE938A3E22, scenario); } // 0xFB7CF1DE938A3E22 b1207
	NATIVE_DECL BOOL _PERSISTENCE_IS_SCENARIO_MARKED_AS_LOOTED_AT_COORDS(float x, float y, float z) { return invoke<BOOL>(0xB6E1A185C2B9319A, x, y, z); } // 0xB6E1A185C2B9319A b1207
	NATIVE_DECL BOOL _PERSISTENCE_IS_SCENARIO_MARKED_AS_LOOTED_AT_COORDS(Vector3 vec) { return invoke<BOOL>(0xB6E1A185C2B9319A, vec.x, vec.y, vec.z); } // 0xB6E1A185C2B9319A b1207
	NATIVE_DECL BOOL _PERSISTENCE_IS_SCENARIO_MARKED_AS_LOOTED_AT_COORDS_WITH_MODEL(float x, float y, float z, Hash model) { return invoke<BOOL>(0x188313616D184213, x, y, z, model); } // 0x188313616D184213 b1207
	NATIVE_DECL BOOL _PERSISTENCE_IS_SCENARIO_MARKED_AS_LOOTED_AT_COORDS_WITH_MODEL(Vector3 vec, Hash model) { return invoke<BOOL>(0x188313616D184213, vec.x, vec.y, vec.z, model); } // 0x188313616D184213 b1207
	NATIVE_DECL void _0x66DAA3A9274E8E82() { invoke<Void>(0x66DAA3A9274E8E82); } // 0x66DAA3A9274E8E82 b1232
}

namespace PHYSICS
{
	// There are 19 types of rope, from type = 0 to type = 18
	// Rope definitions are stored in ropedata.xml
	// Rope types 0, 15 and 18 have proper physics for hanging objects (taut, do not sag, small to medium diameter, good aspect for a rope)
	NATIVE_DECL int ADD_ROPE(float x, float y, float z, float rotX, float rotY, float rotZ, float length, int ropeType, float maxLength, float minLength, float p10, BOOL p11, BOOL p12, BOOL rigid, float p14, BOOL breakWhenShot, Any* unkPtr, BOOL p17) { return invoke<int>(0xE832D760399EB220, x, y, z, rotX, rotY, rotZ, length, ropeType, maxLength, minLength, p10, p11, p12, rigid, p14, breakWhenShot, unkPtr, p17); } // 0xE832D760399EB220 0xA592EC74 b1207
	NATIVE_DECL int ADD_ROPE(Vector3 vec, Vector3 rot, float length, int ropeType, float maxLength, float minLength, float p10, BOOL p11, BOOL p12, BOOL rigid, float p14, BOOL breakWhenShot, Any* unkPtr, BOOL p17) { return invoke<int>(0xE832D760399EB220, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, length, ropeType, maxLength, minLength, p10, p11, p12, rigid, p14, breakWhenShot, unkPtr, p17); } // 0xE832D760399EB220 0xA592EC74 b1207
	NATIVE_DECL int _ADD_ROPE_2(float x, float y, float z, float rotX, float rotY, float rotZ, float length, int ropeType, BOOL isNetworked, int p9, float p10) { return invoke<int>(0xE9C59F6809373A99, x, y, z, rotX, rotY, rotZ, length, ropeType, isNetworked, p9, p10); } // 0xE9C59F6809373A99 b1207
	NATIVE_DECL int _ADD_ROPE_2(Vector3 vec, Vector3 rot, float length, int ropeType, BOOL isNetworked, int p9, float p10) { return invoke<int>(0xE9C59F6809373A99, vec.x, vec.y, vec.z, rot.x, rot.y, rot.z, length, ropeType, isNetworked, p9, p10); } // 0xE9C59F6809373A99 b1207
	NATIVE_DECL void DELETE_ROPE(int* ropeId) { invoke<Void>(0x52B4829281364649, ropeId); } // 0x52B4829281364649 0x748D72AF b1207
	NATIVE_DECL void _0x6076213101A47B3B(int ropeId) { invoke<Void>(0x6076213101A47B3B, ropeId); } // 0x6076213101A47B3B b1207
	NATIVE_DECL void DELETE_CHILD_ROPE(int ropeId) { invoke<Void>(0xAA5D6B1888E4DB20, ropeId); } // 0xAA5D6B1888E4DB20 0xB19B4706 b1207
	// ropeTop returns top half of rope, ropeBottom returns bottom half of rope
	NATIVE_DECL void _BREAK_ROPE(int* ropeId, int* ropeTop, int* ropeBottom, float offsetX, float offsetY, float offsetZ, int p6) { invoke<Void>(0x4CFA2B7FAE115ECB, ropeId, ropeTop, ropeBottom, offsetX, offsetY, offsetZ, p6); } // 0x4CFA2B7FAE115ECB b1207
	NATIVE_DECL void _BREAK_ROPE(int* ropeId, int* ropeTop, int* ropeBottom, Vector3 offset, int p6) { invoke<Void>(0x4CFA2B7FAE115ECB, ropeId, ropeTop, ropeBottom, offset.x, offset.y, offset.z, p6); } // 0x4CFA2B7FAE115ECB b1207
	NATIVE_DECL BOOL DOES_ROPE_EXIST(int ropeId) { return invoke<BOOL>(0xFD5448BE3111ED96, ropeId); } // 0xFD5448BE3111ED96 0x66E4A3AC b1207
	NATIVE_DECL BOOL _IS_ROPE_BROKEN(int ropeId) { return invoke<BOOL>(0x79C2BEC82CFD7F7F, ropeId); } // 0x79C2BEC82CFD7F7F b1207
	NATIVE_DECL void _0x7A54D82227A139DB(int* ropeId, Any p1) { invoke<Void>(0x7A54D82227A139DB, ropeId, p1); } // 0x7A54D82227A139DB b1207
	NATIVE_DECL void ROPE_DRAW_SHADOW_ENABLED(int* ropeId, BOOL toggle) { invoke<Void>(0xF159A63806BB5BA8, ropeId, toggle); } // 0xF159A63806BB5BA8 0x51523B8C b1207
	NATIVE_DECL int GET_ROPE_VERTEX_COUNT(int ropeId) { return invoke<int>(0x3655F544CD30F0B5, ropeId); } // 0x3655F544CD30F0B5 0x5131CD2C b1207
	NATIVE_DECL void _0xE54BF2CE6C7D23A9(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xE54BF2CE6C7D23A9, p0, p1, p2, p3, p4); } // 0xE54BF2CE6C7D23A9 b1207
	NATIVE_DECL void _0x9C24846D0A4A2776(Any p0) { invoke<Void>(0x9C24846D0A4A2776, p0); } // 0x9C24846D0A4A2776 b1207
	NATIVE_DECL void _0x0CB16D05E03FB525(Any p0) { invoke<Void>(0x0CB16D05E03FB525, p0); } // 0x0CB16D05E03FB525 b1207
	NATIVE_DECL void _0xF27F1A8DE4F50A1B(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { invoke<Void>(0xF27F1A8DE4F50A1B, p0, p1, p2, p3, p4, p5, p6); } // 0xF27F1A8DE4F50A1B b1207
	NATIVE_DECL void _0x21D0890D88DFB0B0(int ropeId, BOOL p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float p9, int p10) { invoke<Void>(0x21D0890D88DFB0B0, ropeId, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x21D0890D88DFB0B0 b1207
	// Attaches entity 1 to entity 2.
	// If you use a boneName (p12/p13) make sure boneId (p15/p16) is set to -1.
	NATIVE_DECL void ATTACH_ENTITIES_TO_ROPE(int ropeId, Entity entity1, Entity entity2, float ent1X, float ent1Y, float ent1Z, float ent2X, float ent2Y, float ent2Z, float length, int alwaysZero1, int alwaysZero2, const char* boneName1, const char* boneName2, BOOL p14, int boneId1, int boneId2, int alwaysZero3, int alwaysZero4, BOOL p19, BOOL p20) { invoke<Void>(0x3D95EC8B6D940AC3, ropeId, entity1, entity2, ent1X, ent1Y, ent1Z, ent2X, ent2Y, ent2Z, length, alwaysZero1, alwaysZero2, boneName1, boneName2, p14, boneId1, boneId2, alwaysZero3, alwaysZero4, p19, p20); } // 0x3D95EC8B6D940AC3 0x7508668F b1207
	NATIVE_DECL void ATTACH_ENTITIES_TO_ROPE(int ropeId, Entity entity1, Entity entity2, Vector3 ent1, Vector3 ent2, float length, int alwaysZero1, int alwaysZero2, const char* boneName1, const char* boneName2, BOOL p14, int boneId1, int boneId2, int alwaysZero3, int alwaysZero4, BOOL p19, BOOL p20) { invoke<Void>(0x3D95EC8B6D940AC3, ropeId, entity1, entity2, ent1.x, ent1.y, ent1.z, ent2.x, ent2.y, ent2.z, length, alwaysZero1, alwaysZero2, boneName1, boneName2, p14, boneId1, boneId2, alwaysZero3, alwaysZero4, p19, p20); } // 0x3D95EC8B6D940AC3 0x7508668F b1207
	// Attaches a rope to two entities: binds two bones from two entities; one entity can be an object, i.e. a suspension point, the other an NPC bone
	NATIVE_DECL void _ATTACH_ENTITIES_TO_ROPE_2(int ropeId, Entity entity1, Entity entity2, float ent1X, float ent1Y, float ent1Z, float ent2X, float ent2Y, float ent2Z, const char* boneName1, const char* boneName2) { invoke<Void>(0x462FF2A432733A44, ropeId, entity1, entity2, ent1X, ent1Y, ent1Z, ent2X, ent2Y, ent2Z, boneName1, boneName2); } // 0x462FF2A432733A44 b1207
	NATIVE_DECL void _ATTACH_ENTITIES_TO_ROPE_2(int ropeId, Entity entity1, Entity entity2, Vector3 ent1, Vector3 ent2, const char* boneName1, const char* boneName2) { invoke<Void>(0x462FF2A432733A44, ropeId, entity1, entity2, ent1.x, ent1.y, ent1.z, ent2.x, ent2.y, ent2.z, boneName1, boneName2); } // 0x462FF2A432733A44 b1207
	NATIVE_DECL void _ATTACH_ENTITES_TO_ROPE_3(int ropeId, Entity entity1, Entity entity2, float p3, float p4, float p5, float p6, float p7, float p8, Any p9, Any p10) { invoke<Void>(0xE9CD9A67834985A7, ropeId, entity1, entity2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0xE9CD9A67834985A7 b1207
	NATIVE_DECL void _0x69C810B72291D831(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6) { invoke<Void>(0x69C810B72291D831, p0, p1, p2, p3, p4, p5, p6); } // 0x69C810B72291D831 b1207
	NATIVE_DECL void _0xB7469CB9AC3C0FD4(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xB7469CB9AC3C0FD4, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xB7469CB9AC3C0FD4 b1207
	NATIVE_DECL void _0xC64E7A62632AD2FE(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xC64E7A62632AD2FE, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xC64E7A62632AD2FE b1207
	NATIVE_DECL BOOL _IS_ROPE_ATTACHED_TO_ENTITY(int ropeId, Entity entity) { return invoke<BOOL>(0x9B4F7E3E4F9C77B3, ropeId, entity); } // 0x9B4F7E3E4F9C77B3 b1207
	NATIVE_DECL void DETACH_ROPE_FROM_ENTITY(int ropeId, Entity entity) { invoke<Void>(0xBCF3026912A8647D, ropeId, entity); } // 0xBCF3026912A8647D 0x3E720BEE b1207
	NATIVE_DECL void _HITCH_HORSE(Ped horse, float x, float y, float z) { invoke<Void>(0x06AADE17334F7A40, horse, x, y, z); } // 0x06AADE17334F7A40 b1207
	NATIVE_DECL void _HITCH_HORSE(Ped horse, Vector3 vec) { invoke<Void>(0x06AADE17334F7A40, horse, vec.x, vec.y, vec.z); } // 0x06AADE17334F7A40 b1207
	NATIVE_DECL void _UNHITCH_HORSE(Ped horse) { invoke<Void>(0x0348469DAA17576C, horse); } // 0x0348469DAA17576C b1207
	NATIVE_DECL void _0x6EA0E93CFFA472CC(Any p0) { invoke<Void>(0x6EA0E93CFFA472CC, p0); } // 0x6EA0E93CFFA472CC b1207
	NATIVE_DECL void _0xBDDA142759307528(Any p0) { invoke<Void>(0xBDDA142759307528, p0); } // 0xBDDA142759307528 b1207
	NATIVE_DECL void _0x32F4DBFDFCCCC735(Any p0, Any p1, Any p2) { invoke<Void>(0x32F4DBFDFCCCC735, p0, p1, p2); } // 0x32F4DBFDFCCCC735 b1207
	NATIVE_DECL void _0xF8CA39D5C0D1D9A1(Any p0, Any p1) { invoke<Void>(0xF8CA39D5C0D1D9A1, p0, p1); } // 0xF8CA39D5C0D1D9A1 b1207
	NATIVE_DECL void _0xEAF529446488EB18(Any p0) { invoke<Void>(0xEAF529446488EB18, p0); } // 0xEAF529446488EB18 b1207
	NATIVE_DECL void _0x31160EC47E7C9549(Any p0, Any p1) { invoke<Void>(0x31160EC47E7C9549, p0, p1); } // 0x31160EC47E7C9549 b1207
	NATIVE_DECL void _0x5E981C764DF33117(Any p0, Any p1) { invoke<Void>(0x5E981C764DF33117, p0, p1); } // 0x5E981C764DF33117 b1207
	NATIVE_DECL void ROPE_SET_UPDATE_ORDER(int ropeId, Any p1) { invoke<Void>(0xDC57A637A20006ED, ropeId, p1); } // 0xDC57A637A20006ED 0x80DB77A7 b1207
	NATIVE_DECL void _0xFB9153A54AC713E8(int ropeId, BOOL p1) { invoke<Void>(0xFB9153A54AC713E8, ropeId, p1); } // 0xFB9153A54AC713E8 b1207
	NATIVE_DECL void _0xD699E688B49C0FD2(int ropeId, float p1, float p2, float p3, BOOL p4) { invoke<Void>(0xD699E688B49C0FD2, ropeId, p1, p2, p3, p4); } // 0xD699E688B49C0FD2 b1207
	NATIVE_DECL void _0xBB3E9B073E66C3C9(int ropeId, BOOL p1, BOOL p2, BOOL p3, BOOL p4) { invoke<Void>(0xBB3E9B073E66C3C9, ropeId, p1, p2, p3, p4); } // 0xBB3E9B073E66C3C9 b1207
	NATIVE_DECL void _0x522FA3F490E2F7AC(int ropeId, Any p1, Any p2) { invoke<Void>(0x522FA3F490E2F7AC, ropeId, p1, p2); } // 0x522FA3F490E2F7AC b1207
	NATIVE_DECL void _0x3900491C0D61ED4B(Any p0, Any p1) { invoke<Void>(0x3900491C0D61ED4B, p0, p1); } // 0x3900491C0D61ED4B b1207
	NATIVE_DECL void _0xC89E7410A93AC19A(int ropeId, float p1) { invoke<Void>(0xC89E7410A93AC19A, ropeId, p1); } // 0xC89E7410A93AC19A b1207
	NATIVE_DECL void _0x1D97DA8ACB5D2582(int ropeId, int p1) { invoke<Void>(0x1D97DA8ACB5D2582, ropeId, p1); } // 0x1D97DA8ACB5D2582 b1207
	// Combining this with ADD_ROPE enables winding
	NATIVE_DECL void _0x3C6490D940FF5D0B(int ropeId, Any p1, const char* ropeModelType, float length, BOOL p4) { invoke<Void>(0x3C6490D940FF5D0B, ropeId, p1, ropeModelType, length, p4); } // 0x3C6490D940FF5D0B b1207
	NATIVE_DECL Vector3 GET_ROPE_LAST_VERTEX_COORD(int ropeId) { return invoke<Vector3>(0x21BB0FBD3E217C2D, ropeId); } // 0x21BB0FBD3E217C2D 0x91F6848B b1207
	NATIVE_DECL Vector3 GET_ROPE_VERTEX_COORD(int ropeId, int vertex) { return invoke<Vector3>(0xEA61CA8E80F09E4D, ropeId, vertex); } // 0xEA61CA8E80F09E4D 0x84374452 b1207
	NATIVE_DECL void START_ROPE_WINDING(int ropeId) { invoke<Void>(0x1461C72C889E343E, ropeId); } // 0x1461C72C889E343E 0x5187BED3 b1207
	NATIVE_DECL void STOP_ROPE_WINDING(int ropeId) { invoke<Void>(0xCB2D4AB84A19AA7C, ropeId); } // 0xCB2D4AB84A19AA7C 0x46826B53 b1207
	NATIVE_DECL void START_ROPE_UNWINDING_FRONT(int ropeId) { invoke<Void>(0x538D1179EC1AA9A9, ropeId); } // 0x538D1179EC1AA9A9 0xFC0DB4C3 b1207
	NATIVE_DECL void STOP_ROPE_UNWINDING_FRONT(int ropeId) { invoke<Void>(0xFFF3A50779EFBBB3, ropeId); } // 0xFFF3A50779EFBBB3 0x2EEDB18F b1207
	NATIVE_DECL void _0x00F611A794A3C36E(Any p0) { invoke<Void>(0x00F611A794A3C36E, p0); } // 0x00F611A794A3C36E b1207
	NATIVE_DECL void _0x10DAA76CB8A201A1(Any p0) { invoke<Void>(0x10DAA76CB8A201A1, p0); } // 0x10DAA76CB8A201A1 b1207
	NATIVE_DECL void _0x461FCBDEB4D06717(int ropeId, BOOL p1) { invoke<Void>(0x461FCBDEB4D06717, ropeId, p1); } // 0x461FCBDEB4D06717 b1207
	NATIVE_DECL void _0x423C6B1F3786D28B(Any p0, Any p1) { invoke<Void>(0x423C6B1F3786D28B, p0, p1); } // 0x423C6B1F3786D28B b1207
	NATIVE_DECL void _0x76BAD9D538BCA1AA(int ropeId, float p1) { invoke<Void>(0x76BAD9D538BCA1AA, ropeId, p1); } // 0x76BAD9D538BCA1AA b1207
	NATIVE_DECL void _0xB40EA9E0D2E2F7F3(int ropeId, float p1) { invoke<Void>(0xB40EA9E0D2E2F7F3, ropeId, p1); } // 0xB40EA9E0D2E2F7F3 b1207
	NATIVE_DECL Any _0x3D69537039F8D824(Any p0) { return invoke<Any>(0x3D69537039F8D824, p0); } // 0x3D69537039F8D824 b1207
	NATIVE_DECL void _0x751DF00EEFF122E3(Any p0) { invoke<Void>(0x751DF00EEFF122E3, p0); } // 0x751DF00EEFF122E3 b1207
	// Forces a rope to a certain length.
	NATIVE_DECL void ROPE_FORCE_LENGTH(int ropeId, float length) { invoke<Void>(0xD009F759A723DB1B, ropeId, length); } // 0xD009F759A723DB1B 0xABF3130F b1207
	// _ROPE_SET_*
	NATIVE_DECL void _0x8D59079C37C21D78(int ropeId, float p1) { invoke<Void>(0x8D59079C37C21D78, ropeId, p1); } // 0x8D59079C37C21D78 b1207
	NATIVE_DECL void _0x814D453FCFDF119F(Any p0, Any p1, Any p2) { invoke<Void>(0x814D453FCFDF119F, p0, p1, p2); } // 0x814D453FCFDF119F b1207
	NATIVE_DECL void _0x1FC92BDBA1106BD2(Any p0, Any p1) { invoke<Void>(0x1FC92BDBA1106BD2, p0, p1); } // 0x1FC92BDBA1106BD2 b1207
	NATIVE_DECL void _0xDEDE679ED29DD4E7(int ropeId, BOOL p1) { invoke<Void>(0xDEDE679ED29DD4E7, ropeId, p1); } // 0xDEDE679ED29DD4E7 b1207
	NATIVE_DECL void _0xF1EA2A881EB7F2CD(int ropeId, BOOL p1) { invoke<Void>(0xF1EA2A881EB7F2CD, ropeId, p1); } // 0xF1EA2A881EB7F2CD b1207
	NATIVE_DECL void _0x5A989B7EE3672A56(Any p0, Any p1) { invoke<Void>(0x5A989B7EE3672A56, p0, p1); } // 0x5A989B7EE3672A56 b1207
	NATIVE_DECL void _0x483D4E917B0D35A9(Any p0, Any p1) { invoke<Void>(0x483D4E917B0D35A9, p0, p1); } // 0x483D4E917B0D35A9 b1207
	NATIVE_DECL Player _0xEE360CFC80C8B2BC(int ropeId) { return invoke<Player>(0xEE360CFC80C8B2BC, ropeId); } // 0xEE360CFC80C8B2BC b1311
	NATIVE_DECL void SET_DAMPING(Entity entity, int vertex, float value) { invoke<Void>(0xEEA3B200A6FEB65B, entity, vertex, value); } // 0xEEA3B200A6FEB65B 0xCFB37773 b1207
	NATIVE_DECL void ACTIVATE_PHYSICS(Entity entity) { invoke<Void>(0x710311ADF0E20730, entity); } // 0x710311ADF0E20730 0x031711B8 b1207
	NATIVE_DECL void BREAK_ENTITY_GLASS(Entity entity, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, Any p9, BOOL p10) { invoke<Void>(0x2E648D16F6E308F3, entity, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0x2E648D16F6E308F3 0xD0E0402F b1207
	NATIVE_DECL void _0x8EEDFD8921389928(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { invoke<Void>(0x8EEDFD8921389928, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0x8EEDFD8921389928 b1207
	NATIVE_DECL void SET_DISABLE_BREAKING(Object object, BOOL toggle) { invoke<Void>(0x5CEC1A84620E7D5B, object, toggle); } // 0x5CEC1A84620E7D5B 0xEE77C326 b1207
	NATIVE_DECL void SET_DISABLE_FRAG_DAMAGE(Object object, BOOL toggle) { invoke<Void>(0x01BA3AED21C16CFB, object, toggle); } // 0x01BA3AED21C16CFB 0x97269DC8 b1207
	NATIVE_DECL void _0x5BD7457221CC5FF4(Any p0, Any p1) { invoke<Void>(0x5BD7457221CC5FF4, p0, p1); } // 0x5BD7457221CC5FF4 b1207
}

namespace PLAYER
{
	NATIVE_DECL Ped GET_PLAYER_PED(Player player) { return invoke<Ped>(0x275F255ED201B937, player); } // 0x275F255ED201B937 0x6E31E993 b1207
	NATIVE_DECL Ped _GET_PLAYER_PED_2(Player player) { return invoke<Ped>(0x5EBE38A20BC51C27, player); } // 0x5EBE38A20BC51C27 b1207
	// Only used in script function UPDATE_PLAYER_JUST_DIED_STATE
	NATIVE_DECL void _0x325434C68358D282(BOOL toggle) { invoke<Void>(0x325434C68358D282, toggle); } // 0x325434C68358D282 b1207
	// Does the same like PLAYER::GET_PLAYER_PED
	NATIVE_DECL Ped GET_PLAYER_PED_SCRIPT_INDEX(Player player) { return invoke<Ped>(0x5C880F9056D784C8, player); } // 0x5C880F9056D784C8 0x6AC64990 b1207
	// Make sure to request the model first and wait until it has loaded.
	NATIVE_DECL void SET_PLAYER_MODEL(Player player, Hash modelHash, BOOL p2) { invoke<Void>(0xED40380076A31506, player, modelHash, p2); } // 0xED40380076A31506 0x774A4C54 b1207
	// Returns true if the given player has a valid ped.
	NATIVE_DECL BOOL _NETWORK_HAS_PLAYER_VALID_PED(Player player) { return invoke<BOOL>(0x0760D6F70EBCC05C, player); } // 0x0760D6F70EBCC05C b1207
	// Gets the player's team.
	// Returns -1 in singleplayer.
	NATIVE_DECL int GET_PLAYER_TEAM(Player player) { return invoke<int>(0xB464EB6A40C7975B, player); } // 0xB464EB6A40C7975B 0x9873E404 b1207
	// Sets the player's team.
	NATIVE_DECL void SET_PLAYER_TEAM(Player player, int team, BOOL bRestrictToThisScript) { invoke<Void>(0xE8DD8536F01DE600, player, team, bRestrictToThisScript); } // 0xE8DD8536F01DE600 0x725ADCF2 b1207
	NATIVE_DECL const char* GET_PLAYER_NAME(Player player) { return invoke<const char*>(0x7124FD9AC0E01BA0, player); } // 0x7124FD9AC0E01BA0 0x406B4B20 b1207
	NATIVE_DECL const char* _FORMAT_PLAYER_NAME_STRING(const char* string) { return invoke<const char*>(0x5B6193813E03E4E9, string); } // 0x5B6193813E03E4E9 b1207
	NATIVE_DECL float GET_WANTED_LEVEL_RADIUS(int p0) { return invoke<float>(0x80B00EB26D9521C7, p0); } // 0x80B00EB26D9521C7 0x1CF7D7DA b1207
	NATIVE_DECL int GET_WANTED_LEVEL_THRESHOLD(int wantedLevel) { return invoke<int>(0x1B1A3B358F7D8F07, wantedLevel); } // 0x1B1A3B358F7D8F07 0xD9783F6B b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void SET_PLAYER_WANTED_LEVEL(Player player, int wantedLevel, BOOL disableNoMission) { invoke<Void>(0x384D4765395E006C, player, wantedLevel, disableNoMission); } // 0x384D4765395E006C 0xB7A0914B b1207
	NATIVE_DECL BOOL IS_PLAYER_WANTED_LEVEL_GREATER(Player player, int wantedLevel) { return invoke<BOOL>(0xE1C0AD4C24324C36, player, wantedLevel); } // 0xE1C0AD4C24324C36 0x589A2661 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void CLEAR_PLAYER_WANTED_LEVEL(Player player) { invoke<Void>(0x4E4B996C928C7AA6, player); } // 0x4E4B996C928C7AA6 0x54EA5BCC b1207
	NATIVE_DECL BOOL IS_PLAYER_DEAD(Player player) { return invoke<BOOL>(0x2E9C3FCB6798F397, player); } // 0x2E9C3FCB6798F397 0x140CA5A8 b1207
	// flags: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/SET_PLAYER_CONTROL/README.md
	NATIVE_DECL void SET_PLAYER_CONTROL(Player player, BOOL toggle, int flags, BOOL bPreventHeadingChange) { invoke<Void>(0x4D51E59243281D80, player, toggle, flags, bPreventHeadingChange); } // 0x4D51E59243281D80 0xD17AFCD8 b1207
	NATIVE_DECL int GET_PLAYER_WANTED_LEVEL(Player player) { return invoke<int>(0xABC532F9098BFD9D, player); } // 0xABC532F9098BFD9D 0xBDCDD163 b1207
	NATIVE_DECL void SET_MAX_WANTED_LEVEL(int maxWantedLevel) { invoke<Void>(0x28A4BD2CEE236E19, maxWantedLevel); } // 0x28A4BD2CEE236E19 0x665A06F5 b1207
	NATIVE_DECL void _SET_MAX_WANTED_LEVEL_2(int maxWantedLevel) { invoke<Void>(0xEA6DE0CD15AECBE2, maxWantedLevel); } // 0xEA6DE0CD15AECBE2 b1207
	// If toggle is set to false:
	//  The police won't be shown on the (mini)map
	// 
	// If toggle is set to true:
	//  The police will be shown on the (mini)map
	NATIVE_DECL void SET_POLICE_RADAR_BLIPS(BOOL toggle) { invoke<Void>(0x6FD7DD6B63F2820E, toggle); } // 0x6FD7DD6B63F2820E 0x8E114B10 b1207
	// Checks whether the specified player has a Ped, the Ped is not dead, is not injured and is not arrested.
	NATIVE_DECL BOOL IS_PLAYER_PLAYING(Player player) { return invoke<BOOL>(0xBFFB35986CAAE58C, player); } // 0xBFFB35986CAAE58C 0xE15D777F b1207
	NATIVE_DECL void SET_EVERYONE_IGNORE_PLAYER(Player player, BOOL toggle) { invoke<Void>(0x34630A768925B852, player, toggle); } // 0x34630A768925B852 0xC915285E b1207
	NATIVE_DECL BOOL GET_IS_PLAYER_UI_PROMPT_ACTIVE(Player player, int p1) { return invoke<BOOL>(0x51BEA356B1C60225, player, p1); } // 0x51BEA356B1C60225 b1207
	// Params: https://github.com/Halen84/RDR3-Native-Flags-And-Enums/blob/main/_MODIFY_PLAYER_UI_PROMPT/README.md
	// promptType is mostly 34 (PP_TRACK_ANIMAL), promptMode = 0 (PP_MODE_BLOCK) in R* Scripts
	NATIVE_DECL void _MODIFY_PLAYER_UI_PROMPT(Player player, int promptType, int promptMode, BOOL disabled) { invoke<Void>(0x0751D461F06E41CE, player, promptType, promptMode, disabled); } // 0x0751D461F06E41CE b1207
	// Returns false if PromptType is enabled
	// Params: See 0x0751D461F06E41CE
	NATIVE_DECL BOOL _GET_PLAYER_UI_PROMPT_IS_DISABLED(Player player, int promptType, int promptMode) { return invoke<BOOL>(0x6614F9039BD31931, player, promptType, promptMode); } // 0x6614F9039BD31931 b1207
	// Params: See 0x0751D461F06E41CE
	NATIVE_DECL void _MODIFY_PLAYER_UI_PROMPT_FOR_PED(Player player, Ped ped, int promptType, int promptMode, BOOL enabled) { invoke<Void>(0xA3DB37EDF9A74635, player, ped, promptType, promptMode, enabled); } // 0xA3DB37EDF9A74635 b1207
	// Returns true if PromptType is enabled for ped (mount)
	// Params: See 0x0751D461F06E41CE
	NATIVE_DECL BOOL _GET_PLAYER_UI_PROMPT_FOR_PED_IS_ENABLED(Player player, Ped ped, int promptType, int promptMode) { return invoke<BOOL>(0xEA8F168A76A0B9BC, player, ped, promptType, promptMode); } // 0xEA8F168A76A0B9BC b1207
	NATIVE_DECL void _0x93624B36E8851B42(Player player) { invoke<Void>(0x93624B36E8851B42, player); } // 0x93624B36E8851B42 b1207
	NATIVE_DECL void _0x9073EC5456651A90(Any p0, Any p1) { invoke<Void>(0x9073EC5456651A90, p0, p1); } // 0x9073EC5456651A90 b1207
	NATIVE_DECL void _0x2E67707BEC52CA4B(Any p0) { invoke<Void>(0x2E67707BEC52CA4B, p0); } // 0x2E67707BEC52CA4B b1207
	NATIVE_DECL void SET_ALL_RANDOM_PEDS_FLEE(Player player, BOOL toggle) { invoke<Void>(0xE705309B8C6445A4, player, toggle); } // 0xE705309B8C6445A4 0x49EAE968 b1207
	NATIVE_DECL void SET_ALL_RANDOM_PEDS_FLEE_THIS_FRAME(Player player) { invoke<Void>(0xD5C198A62F1DEB0A, player); } // 0xD5C198A62F1DEB0A 0xBF974891 b1207
	NATIVE_DECL void _0x16752DAA7E6D3F72(Player player) { invoke<Void>(0x16752DAA7E6D3F72, player); } // 0x16752DAA7E6D3F72 0x02DF7AF4 b1207
	NATIVE_DECL void _0x1D256EED194F5B58(Any p0) { invoke<Void>(0x1D256EED194F5B58, p0); } // 0x1D256EED194F5B58 b1207
	NATIVE_DECL Any _0x5B7B97E99F84138B(Any p0) { return invoke<Any>(0x5B7B97E99F84138B, p0); } // 0x5B7B97E99F84138B b1207
	NATIVE_DECL void _0x8674D138391FFB1B(Any p0, Any p1) { invoke<Void>(0x8674D138391FFB1B, p0, p1); } // 0x8674D138391FFB1B b1207
	NATIVE_DECL Any _0xA82964B9D8D6A983() { return invoke<Any>(0xA82964B9D8D6A983); } // 0xA82964B9D8D6A983 b1207
	NATIVE_DECL void SET_WANTED_LEVEL_MULTIPLIER(float multiplier) { invoke<Void>(0xD7FA719CB54866C2, multiplier); } // 0xD7FA719CB54866C2 0x1359292F b1207
	NATIVE_DECL void RESET_WANTED_LEVEL_DIFFICULTY(Player player) { invoke<Void>(0x062D14F18E8B0CAE, player); } // 0x062D14F18E8B0CAE 0xA64C378D b1207
	NATIVE_DECL void _0xD0B0B044112BF424(Player player) { invoke<Void>(0xD0B0B044112BF424, player); } // 0xD0B0B044112BF424 0x6B34A160 b1207
	NATIVE_DECL void _0x96722257E5381E00(Player player) { invoke<Void>(0x96722257E5381E00, player); } // 0x96722257E5381E00 0x3A7E5FB6 b1207
	NATIVE_DECL void REPORT_POLICE_SPOTTED_PLAYER(Player player) { invoke<Void>(0xCBCCF73FFA69CC6B, player); } // 0xCBCCF73FFA69CC6B 0xD15C4B1C b1207
	NATIVE_DECL void _0xD2DFC9CCA5596A11(float p0) { invoke<Void>(0xD2DFC9CCA5596A11, p0); } // 0xD2DFC9CCA5596A11 0xBF6993C7 b1207
	NATIVE_DECL void _0x5CE5CACC01D0F985() { invoke<Void>(0x5CE5CACC01D0F985); } // 0x5CE5CACC01D0F985 0x47CAB814 b1207
	NATIVE_DECL BOOL CAN_PLAYER_START_MISSION(Player player) { return invoke<BOOL>(0x2DF170B1185AF777, player); } // 0x2DF170B1185AF777 0x39E3CB3F b1207
	NATIVE_DECL BOOL IS_PLAYER_READY_FOR_CUTSCENE(Player player) { return invoke<BOOL>(0xAA67BCB0097F2FA3, player); } // 0xAA67BCB0097F2FA3 0xBB77E9CD b1207
	NATIVE_DECL BOOL IS_PLAYER_TARGETTING_ENTITY(Player player, Entity entity, BOOL p2) { return invoke<BOOL>(0x27F89FDC16688A7A, player, entity, p2); } // 0x27F89FDC16688A7A 0xF3240B77 b1207
	NATIVE_DECL BOOL GET_PLAYER_TARGET_ENTITY(Player player, Entity* entity) { return invoke<BOOL>(0xAE663DDD99C8A670, player, entity); } // 0xAE663DDD99C8A670 0xF6AAA2D7 b1207
	// _GET_A* - _GET_C*
	NATIVE_DECL BOOL _0x927861B2C08DBEA5(Player player) { return invoke<BOOL>(0x927861B2C08DBEA5, player); } // 0x927861B2C08DBEA5 b1207
	// Checks if player is focused on any entity
	NATIVE_DECL BOOL _IS_PLAYER_FREE_FOCUSING(Player player) { return invoke<BOOL>(0x1A51BFE60708E482, player); } // 0x1A51BFE60708E482 b1207
	NATIVE_DECL BOOL GET_PLAYER_INTERACTION_TARGET_ENTITY(Player player, Entity* outEntity, BOOL p2, BOOL p3) { return invoke<BOOL>(0x3EE1F7A8C32F24E1, player, outEntity, p2, p3); } // 0x3EE1F7A8C32F24E1 b1207
	// _GET_PLAYER_I*
	NATIVE_DECL Any _0xBEA3A6E5F5F79A6F(Any p0, Any p1) { return invoke<Any>(0xBEA3A6E5F5F79A6F, p0, p1); } // 0xBEA3A6E5F5F79A6F b1207
	NATIVE_DECL BOOL _IS_PLAYER_IN_SCOPE(Player player) { return invoke<BOOL>(0x04D7F33640662FA2, player); } // 0x04D7F33640662FA2 b1207
	// Gets a value indicating whether the specified player is currently aiming freely.
	NATIVE_DECL BOOL IS_PLAYER_FREE_AIMING(Player player) { return invoke<BOOL>(0x936F967D4BE1CE9D, player); } // 0x936F967D4BE1CE9D 0x1DEC67B7 b1207
	// Gets a value indicating whether the specified player is currently aiming freely at the specified entity.
	NATIVE_DECL BOOL IS_PLAYER_FREE_AIMING_AT_ENTITY(Player player, Entity entity) { return invoke<BOOL>(0x8C67C11C68713D25, player, entity); } // 0x8C67C11C68713D25 0x7D80EEAA b1207
	NATIVE_DECL BOOL GET_ENTITY_PLAYER_IS_FREE_AIMING_AT(Player player, Entity* entity) { return invoke<BOOL>(0xA6817C110B830EAD, player, entity); } // 0xA6817C110B830EAD 0x8866D9D0 b1207
	NATIVE_DECL void _0x3DAABE78A23694BC(Any p0, Any p1) { invoke<Void>(0x3DAABE78A23694BC, p0, p1); } // 0x3DAABE78A23694BC b1207
	// Only used in script function PROCESS_PED_INTERRUPT_DIALOGUE
	// _GET_PLAYER_*
	NATIVE_DECL BOOL _0x7AE93C45EC14A166(Player player, Ped* ped) { return invoke<BOOL>(0x7AE93C45EC14A166, player, ped); } // 0x7AE93C45EC14A166 b1207
	// Affects the range of auto aim target.
	NATIVE_DECL void SET_PLAYER_LOCKON_RANGE_OVERRIDE(Player player, float range) { invoke<Void>(0x3A3CD06597388322, player, range); } // 0x3A3CD06597388322 0x74D42C03 b1207
	// Sets whether this player can be hassled by gangs.
	NATIVE_DECL void SET_PLAYER_CAN_BE_HASSLED_BY_GANGS(Player player, BOOL toggle) { invoke<Void>(0xC7FE774412046825, player, toggle); } // 0xC7FE774412046825 0x71B305BB b1207
	// Sets whether this player can take cover.
	NATIVE_DECL void SET_PLAYER_CAN_USE_COVER(Player player, BOOL toggle) { invoke<Void>(0x5EDA520F7A3BAF4E, player, toggle); } // 0x5EDA520F7A3BAF4E 0x13CAFAFA b1207
	NATIVE_DECL void _0xD1A70C1E8D1031FE(Any p0, Any p1) { invoke<Void>(0xD1A70C1E8D1031FE, p0, p1); } // 0xD1A70C1E8D1031FE b1207
	NATIVE_DECL void _0xACA45DDCEF6071C4(Player player, BOOL p1) { invoke<Void>(0xACA45DDCEF6071C4, player, p1); } // 0xACA45DDCEF6071C4 b1207
	// Params: p1 is mostly 15, sometimes 1 in R* Scripts (Function: PLAYER_TOGGLE_PICK_UP_HATS)
	NATIVE_DECL void _0xA0C683284DF027C7(Player player, int p1, BOOL enable) { invoke<Void>(0xA0C683284DF027C7, player, p1, enable); } // 0xA0C683284DF027C7 b1207
	NATIVE_DECL void _SET_PLAYER_CAN_MERCY_KILL(Player player, BOOL toggle) { invoke<Void>(0x39363DFD04E91496, player, toggle); } // 0x39363DFD04E91496 b1311
	NATIVE_DECL void _0x4EC8BE63B8A5D4EF(Player player, int p1) { invoke<Void>(0x4EC8BE63B8A5D4EF, player, p1); } // 0x4EC8BE63B8A5D4EF b1207
	// Gets the maximum wanted level the player can get.
	// Ranges from 0 to 5.
	NATIVE_DECL int GET_MAX_WANTED_LEVEL() { return invoke<int>(0xD04CFAD1E2B7984A); } // 0xD04CFAD1E2B7984A 0x457F1E44 b1207
	NATIVE_DECL BOOL IS_PLAYER_TARGETTING_ANYTHING(Player player) { return invoke<BOOL>(0x4605C66E0F935F83, player); } // 0x4605C66E0F935F83 0x456DB50D b1207
	NATIVE_DECL void RESTORE_PLAYER_STAMINA(Player player, float p1) { invoke<Void>(0xC41F4B6E23FE6A4A, player, p1); } // 0xC41F4B6E23FE6A4A 0x62A93608 b1207
	// SET_PLAYER_S/T*
	NATIVE_DECL void _0x8591EE69CC3ED257(Player player, BOOL toggle) { invoke<Void>(0x8591EE69CC3ED257, player, toggle); } // 0x8591EE69CC3ED257 b1207
	// Returns the group ID the player is member of.
	NATIVE_DECL int GET_PLAYER_GROUP(Player player) { return invoke<int>(0x9BAB31815159ABCF, player); } // 0x9BAB31815159ABCF 0xA5EDCDE8 b1207
	NATIVE_DECL void _0x3D9DA5C9EFD20D88(Any p0, Any p1) { invoke<Void>(0x3D9DA5C9EFD20D88, p0, p1); } // 0x3D9DA5C9EFD20D88 b1207
	NATIVE_DECL void _0x2BEED53B912537D0(Any p0, Any p1, Any p2) { invoke<Void>(0x2BEED53B912537D0, p0, p1, p2); } // 0x2BEED53B912537D0 b1207
	NATIVE_DECL void _0x908D4B72854C8F62(Any p0) { invoke<Void>(0x908D4B72854C8F62, p0); } // 0x908D4B72854C8F62 b1207
	NATIVE_DECL Any _0xD1F6B912785BFD35(Any p0) { return invoke<Any>(0xD1F6B912785BFD35, p0); } // 0xD1F6B912785BFD35 b1207
	NATIVE_DECL void _0xC4873B053054C04B(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0xC4873B053054C04B, p0, p1, p2, p3, p4, p5, p6, p7); } // 0xC4873B053054C04B b1207
	NATIVE_DECL void _0xCA59808E51FD67C4(Any p0, Any p1) { invoke<Void>(0xCA59808E51FD67C4, p0, p1); } // 0xCA59808E51FD67C4 b1207
	NATIVE_DECL void _0xBA5CA1FEB5DE0DF6(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0xBA5CA1FEB5DE0DF6, p0, p1, p2, p3, p4, p5); } // 0xBA5CA1FEB5DE0DF6 b1207
	NATIVE_DECL void _0x0869D499A7848309(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0x0869D499A7848309, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x0869D499A7848309 b1207
	// _IS_PLAYER_I* - _IS_PLAYER_P*
	NATIVE_DECL BOOL _0xB331D8A73F9D2BDF(Player player, Any* p1) { return invoke<BOOL>(0xB331D8A73F9D2BDF, player, p1); } // 0xB331D8A73F9D2BDF b1207
	// Used in script function: NET_AUTO_FOLLOW_UPDATE_LEADER_VALUES
	NATIVE_DECL void _0xAC22AA6DF4D1C1DE(Player player, Ped ped, float p2, float p3, Any followMode, Any followPriority, Any p6) { invoke<Void>(0xAC22AA6DF4D1C1DE, player, ped, p2, p3, followMode, followPriority, p6); } // 0xAC22AA6DF4D1C1DE b1207
	NATIVE_DECL void _REMOVE_PLAYER_AS_FOLLOW_TARGET(Player player, Ped ped) { invoke<Void>(0x0C6B89876262A99D, player, ped); } // 0x0C6B89876262A99D b1207
	NATIVE_DECL void _0x12E09E278C6C29B7(Any p0) { invoke<Void>(0x12E09E278C6C29B7, p0); } // 0x12E09E278C6C29B7 b1207
	NATIVE_DECL void _0xDD33A82352C4652F(Player player, Ped ped, Any p2) { invoke<Void>(0xDD33A82352C4652F, player, ped, p2); } // 0xDD33A82352C4652F b1207
	NATIVE_DECL void _0x1FDA57E8908F2609(Player player, Ped ped, BOOL useSteerassist) { invoke<Void>(0x1FDA57E8908F2609, player, ped, useSteerassist); } // 0x1FDA57E8908F2609 b1207
	NATIVE_DECL void _0x84481018E668E1B8(Player player, Ped ped, Any p2) { invoke<Void>(0x84481018E668E1B8, player, ped, p2); } // 0x84481018E668E1B8 b1207
	// _IS_PLAYER_F*
	NATIVE_DECL BOOL _0x2009F8AB7A5E9D6D(Player player) { return invoke<BOOL>(0x2009F8AB7A5E9D6D, player); } // 0x2009F8AB7A5E9D6D b1207
	NATIVE_DECL BOOL _IS_PLAYER_FOLLOWING_TARGET(Player player, Ped ped) { return invoke<BOOL>(0xE24C64D9ADED2EF5, player, ped); } // 0xE24C64D9ADED2EF5 b1207
	// _IS_PLAYER_A* - _IS_PLAYER_BE*
	NATIVE_DECL BOOL _0xE7F8707269544B29(Player player, Ped ped) { return invoke<BOOL>(0xE7F8707269544B29, player, ped); } // 0xE7F8707269544B29 b1207
	NATIVE_DECL Any _0xE631EAF35828FA67(Any p0) { return invoke<Any>(0xE631EAF35828FA67, p0); } // 0xE631EAF35828FA67 b1207
	NATIVE_DECL void _0x086549F3B0381CB1(Any p0, Any p1) { invoke<Void>(0x086549F3B0381CB1, p0, p1); } // 0x086549F3B0381CB1 b1207
	// Returns whether the player can control himself.
	NATIVE_DECL BOOL IS_PLAYER_CONTROL_ON(Player player) { return invoke<BOOL>(0x7964097FCE4C244B, player); } // 0x7964097FCE4C244B 0x618857F2 b1207
	NATIVE_DECL BOOL IS_PLAYER_SCRIPT_CONTROL_ON(Player player) { return invoke<BOOL>(0xB78350754157C00F, player); } // 0xB78350754157C00F 0x61B00A84 b1207
	// Returns TRUE if the player ('s ped) is climbing at the moment.
	NATIVE_DECL BOOL IS_PLAYER_CLIMBING(Player player) { return invoke<BOOL>(0xB8A70C22FD48197A, player); } // 0xB8A70C22FD48197A 0x4A9E9AE0 b1207
	NATIVE_DECL void _0xEBB6E27AC2FF32DA(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xEBB6E27AC2FF32DA, p0, p1, p2, p3, p4); } // 0xEBB6E27AC2FF32DA b1207
	NATIVE_DECL Any _0xB15CD2F9932C9AB5(Any p0) { return invoke<Any>(0xB15CD2F9932C9AB5, p0); } // 0xB15CD2F9932C9AB5 b1207
	// _IS_PLAYER_S* - _IS_PLAYER_T*
	NATIVE_DECL BOOL _0x621D1B289CAF5978(Player player) { return invoke<BOOL>(0x621D1B289CAF5978, player); } // 0x621D1B289CAF5978 b1207
	// Return true while player is being arrested / busted.
	// 
	// If atArresting is set to 1, this function will return 1 when player is being arrested (while player is putting his hand up, but still have control)
	// 
	// If atArresting is set to 0, this function will return 1 only when the busted screen is shown.
	NATIVE_DECL BOOL IS_PLAYER_BEING_ARRESTED(Player player, BOOL atArresting) { return invoke<BOOL>(0xC8183AE963C58374, player, atArresting); } // 0xC8183AE963C58374 0x7F6A60D3 b1207
	NATIVE_DECL void RESET_PLAYER_ARREST_STATE(Player player) { invoke<Void>(0x12917931C31F1750, player); } // 0x12917931C31F1750 0x453C7CAB b1207
	NATIVE_DECL void _0xCBB54CC7FFFFAB86(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xCBB54CC7FFFFAB86, p0, p1, p2, p3); } // 0xCBB54CC7FFFFAB86 b1207
	NATIVE_DECL void _0xBED386157F65942C(Any p0, Any p1) { invoke<Void>(0xBED386157F65942C, p0, p1); } // 0xBED386157F65942C b1207
	NATIVE_DECL Any _0xDAB6A2FC56B7DE65(Any p0) { return invoke<Any>(0xDAB6A2FC56B7DE65, p0); } // 0xDAB6A2FC56B7DE65 b1207
	NATIVE_DECL Any _0x0F4EAF69DA41AF43(Any p0) { return invoke<Any>(0x0F4EAF69DA41AF43, p0); } // 0x0F4EAF69DA41AF43 b1207
	NATIVE_DECL void _SET_BOUNTY_TARGET(Player player, Player target) { invoke<Void>(0x6ADF821FBF21920E, player, target); } // 0x6ADF821FBF21920E b1207
	NATIVE_DECL void _CLEAR_BOUNTY_TARGET(Player player) { invoke<Void>(0x8F2A81C09DA9124A, player); } // 0x8F2A81C09DA9124A b1207
	NATIVE_DECL Vehicle GET_PLAYERS_LAST_VEHICLE() { return invoke<Vehicle>(0x2F96E7720B0B19EA); } // 0x2F96E7720B0B19EA 0xE2757AC1 b1207
	// Returns the same as PLAYER_ID and NETWORK_PLAYER_ID_TO_INT
	NATIVE_DECL Player GET_PLAYER_INDEX() { return invoke<Player>(0x47E385B0D957C8D4); } // 0x47E385B0D957C8D4 0x309BBDC1 b1207
	// Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
	NATIVE_DECL Player INT_TO_PLAYERINDEX(int value) { return invoke<Player>(0x748B3A65C2604C33, value); } // 0x748B3A65C2604C33 0x98DD98F1 b1207
	// Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
	NATIVE_DECL int INT_TO_PARTICIPANTINDEX(int value) { return invoke<int>(0x58FF971FC8F2702C, value); } // 0x58FF971FC8F2702C 0x98F3B274 b1207
	// This returns YOUR 'identity' as a Player type.
	// 
	// Always returns 0 in story mode.
	NATIVE_DECL Player PLAYER_ID() { return invoke<Player>(0x217E9DC48139933D); } // 0x217E9DC48139933D 0x8AEA886C b1207
	// Returns current player ped
	NATIVE_DECL Ped PLAYER_PED_ID() { return invoke<Ped>(0x096275889B8E0EE0); } // 0x096275889B8E0EE0 0xFA92E226 b1207
	// Does exactly the same thing as PLAYER_ID()
	NATIVE_DECL int NETWORK_PLAYER_ID_TO_INT() { return invoke<int>(0x8A9386F0749A17FA); } // 0x8A9386F0749A17FA 0x8DD5B838 b1207
	NATIVE_DECL BOOL HAS_FORCE_CLEANUP_OCCURRED(int cleanupFlags) { return invoke<BOOL>(0xC11469DCA6FC3BB5, cleanupFlags); } // 0xC11469DCA6FC3BB5 0x4B37333C b1207
	NATIVE_DECL void FORCE_CLEANUP(int cleanupFlags) { invoke<Void>(0x768C017FB878E4F4, cleanupFlags); } // 0x768C017FB878E4F4 0xFDAAEA2B b1207
	NATIVE_DECL void FORCE_CLEANUP_FOR_ALL_THREADS_WITH_THIS_NAME(const char* name, int cleanupFlags) { invoke<Void>(0xDAACAF8B687F2353, name, cleanupFlags); } // 0xDAACAF8B687F2353 0x04256C73 b1207
	NATIVE_DECL void FORCE_CLEANUP_FOR_THREAD_WITH_THIS_ID(int id, int cleanupFlags) { invoke<Void>(0xF4C9512A2F0A3031, id, cleanupFlags); } // 0xF4C9512A2F0A3031 0x882D3EB3 b1207
	NATIVE_DECL int GET_CAUSE_OF_MOST_RECENT_FORCE_CLEANUP() { return invoke<int>(0x84E8E29EBD4A46D2); } // 0x84E8E29EBD4A46D2 0x39AA9FC8 b1207
	NATIVE_DECL void _0x39BED552DB46FFA9(Any p0, Any p1) { invoke<Void>(0x39BED552DB46FFA9, p0, p1); } // 0x39BED552DB46FFA9 b1207
	NATIVE_DECL int _0x054473164C012699(Player player) { return invoke<int>(0x054473164C012699, player); } // 0x054473164C012699 b1207
	NATIVE_DECL void SET_PLAYER_MAY_ONLY_ENTER_THIS_VEHICLE(Player player, Vehicle vehicle) { invoke<Void>(0xDA35A134038557EC, player, vehicle); } // 0xDA35A134038557EC 0xA454DD29 b1207
	NATIVE_DECL void _0xC71D07C96946E263(Any p0, Any p1) { invoke<Void>(0xC71D07C96946E263, p0, p1); } // 0xC71D07C96946E263 b1207
	NATIVE_DECL void SET_PLAYER_MAY_NOT_ENTER_ANY_VEHICLE(Player player) { invoke<Void>(0xBEC463B3A11C909E, player); } // 0xBEC463B3A11C909E 0xAF7AFCC4 b1207
	NATIVE_DECL BOOL IS_SYSTEM_UI_BEING_DISPLAYED() { return invoke<BOOL>(0x908258B6209E71F7); } // 0x908258B6209E71F7 0xE495B6DA b1207
	NATIVE_DECL void _0xD48227263E3D06AE(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9) { invoke<Void>(0xD48227263E3D06AE, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9); } // 0xD48227263E3D06AE b1232
	NATIVE_DECL void _0x3946FC742AC305CD(Player player, Ped ped, const char* p2, float x, float y, float z, Entity targetEntity, const char* p7) { invoke<Void>(0x3946FC742AC305CD, player, ped, p2, x, y, z, targetEntity, p7); } // 0x3946FC742AC305CD b1207
	NATIVE_DECL void _0x3946FC742AC305CD(Player player, Ped ped, const char* p2, Vector3 vec, Entity targetEntity, const char* p7) { invoke<Void>(0x3946FC742AC305CD, player, ped, p2, vec.x, vec.y, vec.z, targetEntity, p7); } // 0x3946FC742AC305CD b1207
	NATIVE_DECL void _0xA28056CD1B04B250(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7, Any p8, Any p9, Any p10) { invoke<Void>(0xA28056CD1B04B250, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } // 0xA28056CD1B04B250 b1232
	// _DISABLE_*(PLAYER_FORCED_INTERACTION_LOCKON?)
	NATIVE_DECL void _0xC67A4910425F11F1(Player player, const char* name) { invoke<Void>(0xC67A4910425F11F1, player, name); } // 0xC67A4910425F11F1 b1207
	// Simply sets you as invincible (Health will not deplete).
	NATIVE_DECL void SET_PLAYER_INVINCIBLE(Player player, BOOL toggle) { invoke<Void>(0xFEBEEBC9CBDF4B12, player, toggle); } // 0xFEBEEBC9CBDF4B12 0xDFB9A2A2 b1207
	// Returns the player's invincibility status.
	NATIVE_DECL BOOL GET_PLAYER_INVINCIBLE(Player player) { return invoke<BOOL>(0x0CBBCB2CCFA7DC4E, player); } // 0x0CBBCB2CCFA7DC4E 0x680C90EE b1207
	NATIVE_DECL void SET_PLAYER_LOCKON(Player player, BOOL toggle) { invoke<Void>(0x462AA1973CBBA75E, player, toggle); } // 0x462AA1973CBBA75E 0x0B270E0F b1207
	NATIVE_DECL void _SET_LOCKON_TO_FRIENDLY_PLAYERS(Player player, BOOL toggle) { invoke<Void>(0x4A056257802DD3E5, player, toggle); } // 0x4A056257802DD3E5 b1207
	// Sets your targeting mode for when you're on foot.
	// enum eTargetingMode
	// {
	// 	TARGETING_MODE_INVALID = -1,
	// 	TARGETING_MODE_CAUSAL, (Wide)
	// 	TARGETING_MODE_NORMAL,
	// 	TARGETING_MODE_HARD, (Narrow)
	// 	TARGETING_MODE_EXPERT (Free Aim)
	// };
	NATIVE_DECL void SET_PLAYER_TARGETING_MODE(int targetMode) { invoke<Void>(0xD66A941F401E7302, targetMode); } // 0xD66A941F401E7302 0x61CAE253 b1207
	// Sets your targeting mode for when you're in a vehicle (perhaps a mount/horse).
	// see SET_PLAYER_TARGETING_MODE for eTargetingMode
	NATIVE_DECL void _SET_PLAYER_IN_VEHICLE_TARGETING_MODE(int targetMode) { invoke<Void>(0x19B4F71703902238, targetMode); } // 0x19B4F71703902238 b1207
	NATIVE_DECL Any _0x747257807B8721CE(Any p0, Any p1) { return invoke<Any>(0x747257807B8721CE, p0, p1); } // 0x747257807B8721CE b1207
	NATIVE_DECL Any _0x8702D9150D9FBB3D(Any p0, Any p1) { return invoke<Any>(0x8702D9150D9FBB3D, p0, p1); } // 0x8702D9150D9FBB3D b1207
	NATIVE_DECL void _0xCB0B9506BC91E441(Any p0, Any p1) { invoke<Void>(0xCB0B9506BC91E441, p0, p1); } // 0xCB0B9506BC91E441 b1207
	NATIVE_DECL void CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_PED(Player player) { invoke<Void>(0x270B63A641BE32F2, player); } // 0x270B63A641BE32F2 0x1D31CBBD b1207
	NATIVE_DECL BOOL HAS_PLAYER_DAMAGED_AT_LEAST_ONE_PED(Player player) { return invoke<BOOL>(0xDA4A4B9B96E20092, player); } // 0xDA4A4B9B96E20092 0x14F52453 b1207
	NATIVE_DECL void CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED(Player player) { invoke<Void>(0x0361096D6CE4372C, player); } // 0x0361096D6CE4372C 0x7E3BFBC5 b1207
	NATIVE_DECL BOOL HAS_PLAYER_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED(Player player) { return invoke<BOOL>(0x16C8D205DD5A2E90, player); } // 0x16C8D205DD5A2E90 0xA3707DFC b1207
	NATIVE_DECL void _0xEACEBAAE0A33FB3F(Any p0) { invoke<Void>(0xEACEBAAE0A33FB3F, p0); } // 0xEACEBAAE0A33FB3F b1207
	// _HAS_PLAYER_D*
	NATIVE_DECL BOOL _0x72AD59F7B7FB6E24(Player player, int p1) { return invoke<BOOL>(0x72AD59F7B7FB6E24, player, p1); } // 0x72AD59F7B7FB6E24 b1207
	NATIVE_DECL BOOL _0x1A6E84F13C952094(Player player, int p1, Any* p2) { return invoke<BOOL>(0x1A6E84F13C952094, player, p1, p2); } // 0x1A6E84F13C952094 b1207
	// damageInfo: STANDARD_PED_DAMAGE, STANDARD_FEMALE_PED_DAMAGE, STANDARD_PLAYER_PED_DAMAGE_MP, STANDARD_FEMALE_PLAYER_PED_DAMAGE_MP
	NATIVE_DECL void _SET_PLAYER_DAMAGE_INFO_OVERRIDE(Player player, const char* damageInfo) { invoke<Void>(0x78B3D19AF6391A55, player, damageInfo); } // 0x78B3D19AF6391A55 b1207
	NATIVE_DECL void _0x1F488807BC8E0630(Any p0) { invoke<Void>(0x1F488807BC8E0630, p0); } // 0x1F488807BC8E0630 b1207
	// This can be between 1.0f - 50.0f
	NATIVE_DECL void SET_AIR_DRAG_MULTIPLIER_FOR_PLAYERS_VEHICLE(Player player, float multiplier) { invoke<Void>(0x5DA6500FE849DA16, player, multiplier); } // 0x5DA6500FE849DA16 0xF20F72E5 b1207
	// Swim speed multiplier.
	// Multiplier goes up to 1.49f
	NATIVE_DECL void SET_SWIM_MULTIPLIER_FOR_PLAYER(Player player, float multiplier) { invoke<Void>(0xBFCEABDE34DA5085, player, multiplier); } // 0xBFCEABDE34DA5085 0xB986FF47 b1207
	NATIVE_DECL BOOL _0x73EB2EF2E92D23BF() { return invoke<BOOL>(0x73EB2EF2E92D23BF); } // 0x73EB2EF2E92D23BF b1207
	NATIVE_DECL void SET_PLAYER_FORCED_AIM(Player player, BOOL toggle, Ped ped, int p3, BOOL p4) { invoke<Void>(0xD5FCC166AEB2FD0F, player, toggle, ped, p3, p4); } // 0xD5FCC166AEB2FD0F 0x94E42E2E b1207
	NATIVE_DECL void _0x310CE349E0C0EC4B(Player player, Ped ped, int p2) { invoke<Void>(0x310CE349E0C0EC4B, player, ped, p2); } // 0x310CE349E0C0EC4B b1207
	// Inhibits the player from using any method of combat including melee and firearms.
	// 
	// NOTE: Only disables the firing for one frame
	NATIVE_DECL void DISABLE_PLAYER_FIRING(Player player, BOOL toggle) { invoke<Void>(0x2970929FD5F9FC89, player, toggle); } // 0x2970929FD5F9FC89 0x30CB28CB b1207
	NATIVE_DECL void _0xEBFF94328FF7A18A(Any p0, Any p1) { invoke<Void>(0xEBFF94328FF7A18A, p0, p1); } // 0xEBFF94328FF7A18A b1207
	NATIVE_DECL void _0xF993373285053D77(Any p0, Any p1, Any p2) { invoke<Void>(0xF993373285053D77, p0, p1, p2); } // 0xF993373285053D77 b1207
	NATIVE_DECL Any _0xE956C2340A76272E(Any p0) { return invoke<Any>(0xE956C2340A76272E, p0); } // 0xE956C2340A76272E b1207
	NATIVE_DECL void _ENABLE_CUSTOM_DEADEYE_ABILITY(Player player, BOOL enable) { invoke<Void>(0x95EE1DEE1DCD9070, player, enable); } // 0x95EE1DEE1DCD9070 b1207
	NATIVE_DECL Any _0xDE6C85975F9D4894(Any p0) { return invoke<Any>(0xDE6C85975F9D4894, p0); } // 0xDE6C85975F9D4894 b1207
	// Used in script function INIT_DEADEYE_SLOWDOWN
	// _SPECIAL_ABILITY*
	NATIVE_DECL void _0xBBA140062B15A8AC(Player player) { invoke<Void>(0xBBA140062B15A8AC, player); } // 0xBBA140062B15A8AC b1207
	NATIVE_DECL void _SPECIAL_ABILITY_SET_DISABLED(Player player, BOOL disabled) { invoke<Void>(0xAE637BB8EF017875, player, disabled); } // 0xAE637BB8EF017875 b1207
	NATIVE_DECL BOOL _IS_SPECIAL_ABILITY_ACTIVE(Player player) { return invoke<BOOL>(0xB16223CB7DA965F0, player); } // 0xB16223CB7DA965F0 b1207
	// Toggle handles wether Deadeye and Eagleeye are infinite or not.
	NATIVE_DECL void _MODIFY_INFINITE_TRAIL_VISION(Ped ped, BOOL toggle) { invoke<Void>(0x28A13BF6B05C3D83, ped, toggle); } // 0x28A13BF6B05C3D83 b1207
	NATIVE_DECL void _SPECIAL_ABILITY_SET_EAGLE_EYE_DISABLED(Ped ped) { invoke<Void>(0xC0B21F235C02139C, ped); } // 0xC0B21F235C02139C b1207
	// Restores Deadeye by given amount.
	// Params: p2, p3, p4 = 0, 0, 1 in R* Scripts
	NATIVE_DECL void _SPECIAL_ABILITY_RESTORE_BY_AMOUNT(Player player, float amount, int p2, int p3, int p4) { invoke<Void>(0x51345AE20F22C261, player, amount, p2, p3, p4); } // 0x51345AE20F22C261 b1207
	// Params: p1, p2, p3, p4 = 1.f, 0, 0, 0 in R* Scripts
	// _SPECIAL_ABILITY*
	NATIVE_DECL void _0xFA437FA0738C370C(Player player, float p1, int p2, int p3, int p4) { invoke<Void>(0xFA437FA0738C370C, player, p1, p2, p3, p4); } // 0xFA437FA0738C370C b1207
	// Only used in R* SP Script short_update
	// Restores Deadeye Outer Ring
	NATIVE_DECL void _SPECIAL_ABILITY_RESTORE_OUTER_RING(Player player, float amount) { invoke<Void>(0x2498035289B5688F, player, amount); } // 0x2498035289B5688F b1207
	// If player has less Dead Eye than required, Dead Eye cant be triggered.
	NATIVE_DECL float _GET_PLAYER_REQUIRED_DEAD_EYE_AMOUNT(Player player) { return invoke<float>(0x811A748B1BE231BA, player); } // 0x811A748B1BE231BA b1207
	// Returns Deadeye value from player
	NATIVE_DECL float _SPECIAL_ABILITY_GET_AMOUNT_CACHED(Player player) { return invoke<float>(0x029884FB65821B07, player); } // 0x029884FB65821B07 b1207
	// Drains Deadeye by given amount.
	NATIVE_DECL void _SPECIAL_ABILITY_DRAIN_BY_AMOUNT(Player player, float amount, Any p2) { invoke<Void>(0x200114E99552462B, player, amount, p2); } // 0x200114E99552462B b1207
	// Params: p1 = -1 in R* Scripts
	NATIVE_DECL void _SPECIAL_ABILITY_START_RESTORE(Player player, int p1, BOOL p2) { invoke<Void>(0x1D77B47AFA584E90, player, p1, p2); } // 0x1D77B47AFA584E90 b1207
	NATIVE_DECL void _SET_SPECIAL_ABILITY_MULTIPLIER(Player player, float multiplier) { invoke<Void>(0x5A498FCA232F71E1, player, multiplier); } // 0x5A498FCA232F71E1 b1207
	NATIVE_DECL float _GET_PLAYER_SPECIAL_ABILITY_MULTIPLIER(Player player) { return invoke<float>(0xAB3773E7AA1E9DCC, player); } // 0xAB3773E7AA1E9DCC b1207
	NATIVE_DECL void _0x00BA333DA05ADC23(Any p0, Any p1) { invoke<Void>(0x00BA333DA05ADC23, p0, p1); } // 0x00BA333DA05ADC23 b1207
	NATIVE_DECL void _0x22B3CABEDDB538B2(Player player, float p1) { invoke<Void>(0x22B3CABEDDB538B2, player, p1); } // 0x22B3CABEDDB538B2 b1207
	// durationCost: per second
	NATIVE_DECL void _SET_SPECIAL_ABILITY_DURATION_COST(Player player, float durationCost) { invoke<Void>(0xB783F75940B23014, player, durationCost); } // 0xB783F75940B23014 b1207
	// Only used in R* SP Script short_update
	NATIVE_DECL void _SET_SPECIAL_ABILITY_DISABLE_TIMER(Player player, float timer) { invoke<Void>(0xC0B1C05B313693D1, player, timer); } // 0xC0B1C05B313693D1 b1207
	NATIVE_DECL Any _0x57D9991DC1334151(Any p0) { return invoke<Any>(0x57D9991DC1334151, p0); } // 0x57D9991DC1334151 b1207
	NATIVE_DECL Any _0x21091B4BEB6376EE(Any p0) { return invoke<Any>(0x21091B4BEB6376EE, p0); } // 0x21091B4BEB6376EE b1207
	NATIVE_DECL void _SET_SPECIAL_ABILITY_ACTIVATION_COST(Player player, float activationCost, int p2) { invoke<Void>(0xAE4BCC79C587EBBF, player, activationCost, p2); } // 0xAE4BCC79C587EBBF b1207
	// _SET_SPECIAL_ABILITY_*
	NATIVE_DECL void _0x4D1699543B1C023C(Player player, float p1) { invoke<Void>(0x4D1699543B1C023C, player, p1); } // 0x4D1699543B1C023C b1207
	NATIVE_DECL float _GET_PLAYER_DEAD_EYE_METER_LEVEL(Player player, BOOL p1) { return invoke<float>(0x3A6AE4EEE30370FE, player, p1); } // 0x3A6AE4EEE30370FE b1207
	NATIVE_DECL float _GET_PLAYER_DEAD_EYE(Player player) { return invoke<float>(0xA81D24AE0AF99A5E, player); } // 0xA81D24AE0AF99A5E b1207
	NATIVE_DECL float _GET_PLAYER_CACHED_DEAD_EYE_AMOUNT(Player player) { return invoke<float>(0xDF66A37936D5F3D9, player); } // 0xDF66A37936D5F3D9 b1207
	NATIVE_DECL float _GET_PLAYER_MAX_DEAD_EYE(Player player, Any p1) { return invoke<float>(0x592F58BC4D2A2CF3, player, p1); } // 0x592F58BC4D2A2CF3 b1207
	NATIVE_DECL float _GET_PLAYER_HEALTH(Player player) { return invoke<float>(0x0317C947D062854E, player); } // 0x0317C947D062854E b1207
	NATIVE_DECL float _GET_PLAYER_STAMINA(Player player) { return invoke<float>(0x0FF421E467373FCF, player); } // 0x0FF421E467373FCF b1207
	// _N*, _O* or _PE*
	NATIVE_DECL void _SET_PLAYER_STAT_FLAG_HASH(Player player, Hash p1) { invoke<Void>(0x768E81AE285A4B67, player, p1); } // 0x768E81AE285A4B67 b1207
	NATIVE_DECL void _0x0E1DB1F8F5B561DC(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x0E1DB1F8F5B561DC, p0, p1, p2, p3, p4, p5); } // 0x0E1DB1F8F5B561DC b1207
	NATIVE_DECL void _0x08E22898A6AF4905(Any p0, Any p1) { invoke<Void>(0x08E22898A6AF4905, p0, p1); } // 0x08E22898A6AF4905 b1207
	NATIVE_DECL Any _0xBEFED69CE8317F91(Any p0) { return invoke<Any>(0xBEFED69CE8317F91, p0); } // 0xBEFED69CE8317F91 b1207
	// (Un)lock Eagle Eye functionality
	NATIVE_DECL void _ENABLE_EAGLEEYE(Player player, BOOL enable) { invoke<Void>(0xA63FCAD3A6FEC6D2, player, enable); } // 0xA63FCAD3A6FEC6D2 b1207
	NATIVE_DECL Any _0xE022CC1B545F1D9F(Any p0) { return invoke<Any>(0xE022CC1B545F1D9F, p0); } // 0xE022CC1B545F1D9F b1207
	// Activates EagleEye, called together with 0x28A13BF6B05C3D83
	NATIVE_DECL void _SECONDARY_SPECIAL_ABILITY_SET_ACTIVE(Player player) { invoke<Void>(0x1710BC33CFB83634, player); } // 0x1710BC33CFB83634 b1207
	// Deactivates EagleEye, called together with 0xC0B21F235C02139C
	NATIVE_DECL void _SECONDARY_SPECIAL_ABILITY_SET_DISABLED(Player player, BOOL disabled) { invoke<Void>(0x64FF4BF9AF59E139, player, disabled); } // 0x64FF4BF9AF59E139 b1207
	NATIVE_DECL BOOL _IS_SECONDARY_SPECIAL_ABILITY_ACTIVE(Player player) { return invoke<BOOL>(0x45AB66D02B601FA7, player); } // 0x45AB66D02B601FA7 b1207
	NATIVE_DECL void _0x107F2A66E1C4C83A(Any p0) { invoke<Void>(0x107F2A66E1C4C83A, p0); } // 0x107F2A66E1C4C83A b1207
	NATIVE_DECL void START_PLAYER_TELEPORT(Player player, float x, float y, float z, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8) { invoke<Void>(0xDF8822C55EDDA65B, player, x, y, z, heading, p5, p6, p7, p8); } // 0xDF8822C55EDDA65B 0xC552E06C b1207
	NATIVE_DECL void START_PLAYER_TELEPORT(Player player, Vector3 vec, float heading, BOOL p5, BOOL p6, BOOL p7, BOOL p8) { invoke<Void>(0xDF8822C55EDDA65B, player, vec.x, vec.y, vec.z, heading, p5, p6, p7, p8); } // 0xDF8822C55EDDA65B 0xC552E06C b1207
	NATIVE_DECL void _0x2C2D287748E8E9B7(BOOL p0) { invoke<Void>(0x2C2D287748E8E9B7, p0); } // 0x2C2D287748E8E9B7 b1207
	NATIVE_DECL BOOL UPDATE_PLAYER_TELEPORT(Player player) { return invoke<BOOL>(0xC39DCE4672CBFBC1, player); } // 0xC39DCE4672CBFBC1 b1207
	// Disables the player's teleportation
	NATIVE_DECL void STOP_PLAYER_TELEPORT() { invoke<Void>(0x0858B86146601BE8); } // 0x0858B86146601BE8 0x86AB8DBB b1207
	NATIVE_DECL BOOL IS_PLAYER_TELEPORT_ACTIVE() { return invoke<BOOL>(0x085EEAEB8783FEB5); } // 0x085EEAEB8783FEB5 0x3A11D118 b1207
	NATIVE_DECL float GET_PLAYER_CURRENT_STEALTH_NOISE(Player player) { return invoke<float>(0xD7ECC25E176ECBA5, player); } // 0xD7ECC25E176ECBA5 0xC3B02362 b1207
	NATIVE_DECL void SET_PLAYER_HEALTH_RECHARGE_MULTIPLIER(Player player, float regenRate) { invoke<Void>(0x8899C244EBCF70DE, player, regenRate); } // 0x8899C244EBCF70DE 0x45514731 b1207
	NATIVE_DECL float _GET_PLAYER_HEALTH_RECHARGE_MULTIPLIER(Player player) { return invoke<float>(0x22CD23BB0C45E0CD, player); } // 0x22CD23BB0C45E0CD b1207
	// Setting player's Health recharge time to zero forces immediate health regen
	NATIVE_DECL void _SET_PLAYER_HEALTH_RECHARGE_TIME_MODIFIER(Player player, float modifier) { invoke<Void>(0x535ED4605F89AB6E, player, modifier); } // 0x535ED4605F89AB6E b1207
	NATIVE_DECL void SET_PLAYER_STAMINA_RECHARGE_MULTIPLIER(Player player, float multiplier) { invoke<Void>(0xFECA17CF3343694B, player, multiplier); } // 0xFECA17CF3343694B b1207
	NATIVE_DECL float _GET_PLAYER_STAMINA_RECHARGE_MULTIPLIER(Player player) { return invoke<float>(0x617D3494AD58200F, player); } // 0x617D3494AD58200F b1207
	NATIVE_DECL void _SET_PLAYER_STAMINA_SPRINT_DEPLETION_MULTIPLIER(Player player, float multiplier) { invoke<Void>(0xBBADFB5E5E5766FB, player, multiplier); } // 0xBBADFB5E5E5766FB b1207
	NATIVE_DECL float _GET_PLAYER_STAMINA_DEPLETION_MULTIPLIER(Player player) { return invoke<float>(0x68A0389E0718AC8F, player); } // 0x68A0389E0718AC8F b1207
	// Seems to work similar to 0xD2CB0FB0FDCB473D
	NATIVE_DECL void _SET_PED_ACTIVE_PLAYER_HORSE(Player player, Ped horse) { invoke<Void>(0x8FBF9EDB378CCB8C, player, horse); } // 0x8FBF9EDB378CCB8C b1207
	NATIVE_DECL Ped _GET_ACTIVE_HORSE_FOR_PLAYER(Player player) { return invoke<Ped>(0x46FA0AE18F4C7FA9, player); } // 0x46FA0AE18F4C7FA9 b1207
	NATIVE_DECL void _SET_PED_AS_SADDLE_HORSE_FOR_PLAYER(Player player, Ped mount) { invoke<Void>(0xD2CB0FB0FDCB473D, player, mount); } // 0xD2CB0FB0FDCB473D b1207
	NATIVE_DECL Ped _GET_SADDLE_HORSE_FOR_PLAYER(Player player) { return invoke<Ped>(0xB48050D326E9A2F3, player); } // 0xB48050D326E9A2F3 b1207
	NATIVE_DECL BOOL SET_PED_AS_TEMP_PLAYER_HORSE(Player player, Ped horse) { return invoke<BOOL>(0x227B06324234FB09, player, horse); } // 0x227B06324234FB09 b1207
	NATIVE_DECL Ped _GET_TEMP_PLAYER_HORSE(Player player) { return invoke<Ped>(0xD3F7445CEA2E5035, player); } // 0xD3F7445CEA2E5035 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x77B0B6D17A3AC9AA(Any p0, Any p1) { invoke<Void>(0x77B0B6D17A3AC9AA, p0, p1); } // 0x77B0B6D17A3AC9AA b1207
	NATIVE_DECL void _0xDF93973251FB2CA5(Any p0, Any p1) { invoke<Void>(0xDF93973251FB2CA5, p0, p1); } // 0xDF93973251FB2CA5 b1207
	NATIVE_DECL void _0x694FFA4308060CD1(Any p0, Any p1) { invoke<Void>(0x694FFA4308060CD1, p0, p1); } // 0x694FFA4308060CD1 b1207
	NATIVE_DECL void BOOST_PLAYER_HORSE_SPEED_FOR_TIME(Player player, float speedBoost, int duration) { invoke<Void>(0x09C28F828EE674FA, player, speedBoost, duration); } // 0x09C28F828EE674FA b1207
	// This modifies the damage value of your weapon. Whether it is a multiplier or base damage is unknown.
	NATIVE_DECL void SET_PLAYER_WEAPON_DAMAGE_MODIFIER(Player player, float modifier) { invoke<Void>(0x94D529F7B73D7A85, player, modifier); } // 0x94D529F7B73D7A85 0xB02C2F39 b1207
	NATIVE_DECL void SET_PLAYER_WEAPON_DEFENSE_MODIFIER(Player player, float modifier) { invoke<Void>(0xD15CC2D493160BE3, player, modifier); } // 0xD15CC2D493160BE3 0xAE446344 b1207
	NATIVE_DECL void _0x818241B3EDA84191(Any p0, Any p1) { invoke<Void>(0x818241B3EDA84191, p0, p1); } // 0x818241B3EDA84191 b1207
	NATIVE_DECL void SET_PLAYER_MELEE_WEAPON_DAMAGE_MODIFIER(Player player, float modifier) { invoke<Void>(0xE4CB5A3F18170381, player, modifier); } // 0xE4CB5A3F18170381 0x362E69AD b1207
	NATIVE_DECL void _SET_PLAYER_EXPLOSIVE_WEAPON_DAMAGE_MODIFIER(Player player, float modifier) { invoke<Void>(0x2D3ACE3DE0A2B622, player, modifier); } // 0x2D3ACE3DE0A2B622 b1207
	NATIVE_DECL void _0x83C989D5B5B5B466(Any p0, Any p1) { invoke<Void>(0x83C989D5B5B5B466, p0, p1); } // 0x83C989D5B5B5B466 b1207
	NATIVE_DECL Any _0x03B4B759A8990505(Any p0) { return invoke<Any>(0x03B4B759A8990505, p0); } // 0x03B4B759A8990505 b1207
	NATIVE_DECL void _0x67659A8F248E0141(Any p0, Any p1) { invoke<Void>(0x67659A8F248E0141, p0, p1); } // 0x67659A8F248E0141 b1207
	// Decreases the damage the player receives while on horseback
	NATIVE_DECL void _SET_RECEIVED_HORSEBACK_DAMAGE_DECREASE(Player player, float damageDecrease) { invoke<Void>(0xB427911EA6DFFEF3, player, damageDecrease); } // 0xB427911EA6DFFEF3 b1207
	// Sets Player's Defense against AI modifier
	NATIVE_DECL void _SET_AI_PLAYER_DEFENSE_MODIFIER_AGAINST_AI(Player player, float modifier) { invoke<Void>(0x914071FF93AF2692, player, modifier); } // 0x914071FF93AF2692 b1207
	NATIVE_DECL float _GET_AI_PLAYER_DEFENSE_MODIFIER_AGAINST_AI(Player player) { return invoke<float>(0x2E78D822208E740A, player); } // 0x2E78D822208E740A b1207
	NATIVE_DECL Any _0x19B2C7A6C34FAD54(Any p0, Any p1) { return invoke<Any>(0x19B2C7A6C34FAD54, p0, p1); } // 0x19B2C7A6C34FAD54 b1207
	NATIVE_DECL Any _0x9422743A5BA50E10(Any p0) { return invoke<Any>(0x9422743A5BA50E10, p0); } // 0x9422743A5BA50E10 b1207
	// Sets stamina core drains peed using ranged damage scale and melee damage scale
	NATIVE_DECL void _SET_PLAYER_DEFENSE_MODIFIER(Player player, float weaponDefenseMod, float meleeDefenseMod) { invoke<Void>(0x497A6539BB0E8787, player, weaponDefenseMod, meleeDefenseMod); } // 0x497A6539BB0E8787 b1207
	// bullet damage modifier: type = 4
	// explosive damage Defense mod: type = 7
	// fire damage Defense mod: type = 8, 15
	NATIVE_DECL void _SET_PLAYER_DEFENSE_TYPE_MODIFIER(Player player, int type, float defenseModifier) { invoke<Void>(0x93F499CAE53FCD05, player, type, defenseModifier); } // 0x93F499CAE53FCD05 b1207
	NATIVE_DECL void SET_PLAYER_WEAPON_TYPE_DAMAGE_MODIFIER(Player player, Hash weaponHash, float damageModifier) { invoke<Void>(0xD04AD186CE8BB129, player, weaponHash, damageModifier); } // 0xD04AD186CE8BB129 b1207
	NATIVE_DECL float _GET_PLAYER_WEAPON_DAMAGE(Player player, Hash weaponHash) { return invoke<float>(0xFE0304050261442C, player, weaponHash); } // 0xFE0304050261442C b1207
	NATIVE_DECL void _0x5C2E5E3CAEEB1F58(Any p0, Any p1, Any p2) { invoke<Void>(0x5C2E5E3CAEEB1F58, p0, p1, p2); } // 0x5C2E5E3CAEEB1F58 b1207
	NATIVE_DECL void _SET_PLAYER_WEAPON_GROUP_DAMAGE_MODIFIER(Player player, Hash weaponGroup, float modifier) { invoke<Void>(0xFC79DCC94D0A5897, player, weaponGroup, modifier); } // 0xFC79DCC94D0A5897 b1207
	NATIVE_DECL void _SET_PLAYER_WEAPON_GROUP_AS_INSTANT_KILL(Player player, Hash weaponGroup, BOOL toggle) { invoke<Void>(0x59F0AFF3E0A1B019, player, weaponGroup, toggle); } // 0x59F0AFF3E0A1B019 b1207
	NATIVE_DECL void _SET_PLAYER_TRAMPLE_DAMAGE_MODIFIER(Player player, float modifier) { invoke<Void>(0xAF341032E97FB061, player, modifier); } // 0xAF341032E97FB061 b1207
	// _SET_PLAYER_A* - _SET_PLAYER_C*
	NATIVE_DECL void _SET_PLAYER_LASSO_DAMAGE_PER_SECOND(Player player, float damage) { invoke<Void>(0x43F50A7CD2482156, player, damage); } // 0x43F50A7CD2482156 b1207
	NATIVE_DECL void _SET_PLAYER_TOTAL_ACCURACY_MODIFIER(Player player, float accuracy) { invoke<Void>(0x967FF5BC0CFE6D26, player, accuracy); } // 0x967FF5BC0CFE6D26 b1207
	NATIVE_DECL void _SET_PLAYER_LOCAL_ACCURACY_FLOOR_MODIFIER(Player player, float accuracy) { invoke<Void>(0x4EA69188FBCE6A7D, player, accuracy); } // 0x4EA69188FBCE6A7D b1207
	NATIVE_DECL void _SET_PLAYER_REMOTE_ACCURACY_FLOOR_MODIFIER(Player player, float accuracy) { invoke<Void>(0xDEE80FEDFDD43C9B, player, accuracy); } // 0xDEE80FEDFDD43C9B b1207
	NATIVE_DECL void _0x3AD212429E095EFB(Any p0, Any p1) { invoke<Void>(0x3AD212429E095EFB, p0, p1); } // 0x3AD212429E095EFB b1207
	NATIVE_DECL void SET_PLAYER_NOISE_MULTIPLIER(Player player, float multiplier) { invoke<Void>(0xB5EC6BDAEBCA454C, player, multiplier); } // 0xB5EC6BDAEBCA454C 0x15786DD1 b1207
	NATIVE_DECL void _0x113EF458AB6CDA67(Any p0, Any p1) { invoke<Void>(0x113EF458AB6CDA67, p0, p1); } // 0x113EF458AB6CDA67 b1207
	NATIVE_DECL void SET_PLAYER_SNEAKING_NOISE_MULTIPLIER(Player player, float multiplier) { invoke<Void>(0x4DE44FA389DCA565, player, multiplier); } // 0x4DE44FA389DCA565 0x8D2D89C4 b1207
	NATIVE_DECL void SIMULATE_PLAYER_INPUT_GAIT(Player player, float amount, int gaitType, float speed, BOOL p4, BOOL p5) { invoke<Void>(0xFA0C063C422C4355, player, amount, gaitType, speed, p4, p5); } // 0xFA0C063C422C4355 0x0D77CC34 b1207
	NATIVE_DECL void RESET_PLAYER_INPUT_GAIT(Player player) { invoke<Void>(0x61A2EECAB274829B, player); } // 0x61A2EECAB274829B 0x4A701EE1 b1207
	NATIVE_DECL void SET_PLAYER_SIMULATE_AIMING(Player player, BOOL toggle) { invoke<Void>(0xE0447DEF81CCDFD2, player, toggle); } // 0xE0447DEF81CCDFD2 0xF1E0CAFC b1207
	NATIVE_DECL void SET_PLAYER_CLOTH_PIN_FRAMES(Ped ped, int p1) { invoke<Void>(0xD0D9317DFEEF9A66, ped, p1); } // 0xD0D9317DFEEF9A66 0xF7A0F00F b1207
	NATIVE_DECL BOOL HAS_PLAYER_BEEN_SPOTTED_IN_STOLEN_VEHICLE(Player player) { return invoke<BOOL>(0xC932F57F31EA9152, player); } // 0xC932F57F31EA9152 0x4A01B76A b1207
	// GET_PLAYER_*
	NATIVE_DECL BOOL _0xFB6EB8785F808551(Player player, int p1, BOOL p2) { return invoke<BOOL>(0xFB6EB8785F808551, player, p1, p2); } // 0xFB6EB8785F808551 0x9DF75B2A b1207
	NATIVE_DECL void _SET_MOUNT_PROMPT_DISABLED(BOOL disabled) { invoke<Void>(0x5B9813ECF7633FE8, disabled); } // 0x5B9813ECF7633FE8 b1207
	// Returns true if the player is riding a train.
	NATIVE_DECL BOOL IS_PLAYER_RIDING_TRAIN(Player player) { return invoke<BOOL>(0x2FB0ACADA6A238DD, player); } // 0x2FB0ACADA6A238DD 0x9765E71D b1207
	NATIVE_DECL void _0x9AFCF9FE1884BF62(Any p0, Any p1) { invoke<Void>(0x9AFCF9FE1884BF62, p0, p1); } // 0x9AFCF9FE1884BF62 b1207
	NATIVE_DECL Any _0x1E8099F449ABB0BA(Any p0) { return invoke<Any>(0x1E8099F449ABB0BA, p0); } // 0x1E8099F449ABB0BA b1207
	NATIVE_DECL int _GET_DEADEYE_ABILITY_LEVEL(Player player) { return invoke<int>(0xCCE7C695C164C35F, player); } // 0xCCE7C695C164C35F b1207
	// Max level is 5.
	NATIVE_DECL void _SET_DEADEYE_ABILITY_LEVEL(Player player, int level) { invoke<Void>(0xF0FE8E790BFEB5BB, player, level); } // 0xF0FE8E790BFEB5BB b1207
	NATIVE_DECL BOOL _IS_DEADEYE_ABILITY_LOCKED(Player player, int abilityType) { return invoke<BOOL>(0x8A0643B0B4CA276B, player, abilityType); } // 0x8A0643B0B4CA276B b1207
	NATIVE_DECL void _SET_DEADEYE_ABILITY_LOCKED(Player player, int abilityType, BOOL toggle) { invoke<Void>(0x2797B8D66DD0EBB8, player, abilityType, toggle); } // 0x2797B8D66DD0EBB8 b1207
	NATIVE_DECL void _SET_DEADEYE_TAGGING_ENABLED(Player player, BOOL toggle) { invoke<Void>(0x6B5DDFB967E5073D, player, toggle); } // 0x6B5DDFB967E5073D b1207
	NATIVE_DECL BOOL _GET_IS_DEADEYE_TAGGING_ENABLED(Player player) { return invoke<BOOL>(0x32348719DCED2969, player); } // 0x32348719DCED2969 b1207
	NATIVE_DECL void _0x3C4AE8506638C7E2(Any p0, Any p1) { invoke<Void>(0x3C4AE8506638C7E2, p0, p1); } // 0x3C4AE8506638C7E2 b1207
	NATIVE_DECL Any _0x51139D8C17B16FBC(Any p0) { return invoke<Any>(0x51139D8C17B16FBC, p0); } // 0x51139D8C17B16FBC b1207
	NATIVE_DECL void _0x8F44EBB3BA8F6D44(Any p0, Any p1) { invoke<Void>(0x8F44EBB3BA8F6D44, p0, p1); } // 0x8F44EBB3BA8F6D44 b1207
	NATIVE_DECL void _SET_DEADEYE_TAGGING_CONFIG(Player player, int filter) { invoke<Void>(0x83FCD6921FC8FD05, player, filter); } // 0x83FCD6921FC8FD05 b1207
	NATIVE_DECL Any _0xE92261BD28C0878F(Any p0) { return invoke<Any>(0xE92261BD28C0878F, p0); } // 0xE92261BD28C0878F b1207
	// Only used in R* SP Script short_update
	NATIVE_DECL void _SET_DEADEYE_ABILITY_DEPLETION_DELAY(Player player, float delay) { invoke<Void>(0x870634493CB4372C, player, delay); } // 0x870634493CB4372C b1207
	NATIVE_DECL Any _0xA54000D4BFD90BDE(Any p0) { return invoke<Any>(0xA54000D4BFD90BDE, p0); } // 0xA54000D4BFD90BDE b1207
	NATIVE_DECL void _0x6EDB5D08CB03E763(Any p0, Any p1) { invoke<Void>(0x6EDB5D08CB03E763, p0, p1); } // 0x6EDB5D08CB03E763 b1207
	NATIVE_DECL Any _0x27AD7162D3FED01E(Any p0, Any p1) { return invoke<Any>(0x27AD7162D3FED01E, p0, p1); } // 0x27AD7162D3FED01E b1207
	NATIVE_DECL int _GET_NUM_MARKED_DEADEYE_TARGETS(Player player) { return invoke<int>(0xCCD9B77F70D31C9D, player); } // 0xCCD9B77F70D31C9D b1207
	NATIVE_DECL Any _0xC93A9A45430D484E(Any p0) { return invoke<Any>(0xC93A9A45430D484E, p0); } // 0xC93A9A45430D484E b1207
	// Used in script function INIT_DEADEYE_SLOWDOWN
	NATIVE_DECL void _0x570A13A4CA2799BB(Player player, BOOL p1) { invoke<Void>(0x570A13A4CA2799BB, player, p1); } // 0x570A13A4CA2799BB b1207
	// Used in script function INIT_DEADEYE_SLOWDOWN
	NATIVE_DECL void _0x3ACAC8832E77BC93(Player player, BOOL p1) { invoke<Void>(0x3ACAC8832E77BC93, player, p1); } // 0x3ACAC8832E77BC93 b1207
	NATIVE_DECL void _0x2B12B6FC8B8772AB(Player player, int p1) { invoke<Void>(0x2B12B6FC8B8772AB, player, p1); } // 0x2B12B6FC8B8772AB b1207
	NATIVE_DECL void _0xE910932F4B30BE23(Player player) { invoke<Void>(0xE910932F4B30BE23, player); } // 0xE910932F4B30BE23 b1207
	NATIVE_DECL void _0x131E294EF60160DF(Player player, float p1, float p2, float p3, float p4, Any p5) { invoke<Void>(0x131E294EF60160DF, player, p1, p2, p3, p4, p5); } // 0x131E294EF60160DF b1207
	NATIVE_DECL void _0x0E9057A9DA78D0F8(Player player, int bitflag) { invoke<Void>(0x0E9057A9DA78D0F8, player, bitflag); } // 0x0E9057A9DA78D0F8 b1207
	NATIVE_DECL void _0x263D69767F76059C(Player player, int p1) { invoke<Void>(0x263D69767F76059C, player, p1); } // 0x263D69767F76059C b1207
	// Used for setting up eagle eye for entity
	// Params: p2 = re-register or not?
	NATIVE_DECL void _REGISTER_EAGLE_EYE_FOR_ENTITY(Player player, Entity entity, BOOL p2) { invoke<Void>(0x543DFE14BE720027, player, entity, p2); } // 0x543DFE14BE720027 b1207
	NATIVE_DECL void _REGISTER_EAGLE_EYE_TRAILS_FOR_ENTITY(Player player, Entity entity, Any p2) { invoke<Void>(0xAC67098A1E54ABB0, player, entity, p2); } // 0xAC67098A1E54ABB0 b1207
	NATIVE_DECL void _UNREGISTER_EAGLE_EYE_FOR_ENTITY(Player player, Entity entity) { invoke<Void>(0x9DAE1380CC5C6451, player, entity); } // 0x9DAE1380CC5C6451 b1207
	NATIVE_DECL void _UNREGISTER_EAGLE_EYE_TRAILS_FOR_ENTITY(Player player, Entity entity, Any p2) { invoke<Void>(0x9A957912CE2EABD1, player, entity, p2); } // 0x9A957912CE2EABD1 b1207
	NATIVE_DECL void _0xE5D3EB37ABC1EB03(Any p0) { invoke<Void>(0xE5D3EB37ABC1EB03, p0); } // 0xE5D3EB37ABC1EB03 b1207
	NATIVE_DECL BOOL _IS_EAGLE_EYE_REGISTERED_FOR_ENTITY(Player player, Entity entity) { return invoke<BOOL>(0x0E6846476906C9DD, player, entity); } // 0x0E6846476906C9DD b1207
	NATIVE_DECL Any _0x6852288340B43239(Any p0, Any p1) { return invoke<Any>(0x6852288340B43239, p0, p1); } // 0x6852288340B43239 b1207
	NATIVE_DECL Any _0xE50A67C33514A390(Any p0, Any p1) { return invoke<Any>(0xE50A67C33514A390, p0, p1); } // 0xE50A67C33514A390 b1207
	NATIVE_DECL void _0xD288E02E364972D2(Any p0, Any p1, Any p2) { invoke<Void>(0xD288E02E364972D2, p0, p1, p2); } // 0xD288E02E364972D2 b1311
	NATIVE_DECL void _EAGLE_EYE_DISABLE_TRACKING_TRAIL(Entity entity, const char* trail, Any p2, Any p3) { invoke<Void>(0x40AB73092C95B5F5, entity, trail, p2, p3); } // 0x40AB73092C95B5F5 b1207
	NATIVE_DECL void _0x6ECFC621A168424C(Entity entity1, Entity entity2, Any p2, float p3) { invoke<Void>(0x6ECFC621A168424C, entity1, entity2, p2, p3); } // 0x6ECFC621A168424C b1207
	NATIVE_DECL void _0xDC5E09D012D759C4(Entity entity1, Entity entity2, Any p2) { invoke<Void>(0xDC5E09D012D759C4, entity1, entity2, p2); } // 0xDC5E09D012D759C4 b1207
	NATIVE_DECL void _0x00B156AFEBCC5AE0(Any p0) { invoke<Void>(0x00B156AFEBCC5AE0, p0); } // 0x00B156AFEBCC5AE0 b1207
	NATIVE_DECL void _0xC58CE6824E604DEC(Any p0) { invoke<Void>(0xC58CE6824E604DEC, p0); } // 0xC58CE6824E604DEC b1207
	NATIVE_DECL void _0x330CA55A3647FA1C(Any p0, Any p1) { invoke<Void>(0x330CA55A3647FA1C, p0, p1); } // 0x330CA55A3647FA1C b1207
	NATIVE_DECL Any _0xA62BBAAE67A05BB0(Any p0) { return invoke<Any>(0xA62BBAAE67A05BB0, p0); } // 0xA62BBAAE67A05BB0 b1207
	// false: default eagleeye color
	// true: green eagleeye color
	NATIVE_DECL void _EAGLE_EYE_SET_COLOR(Player player, BOOL p1, Any* p2) { invoke<Void>(0x2C41D93F550D5E37, player, p1, p2); } // 0x2C41D93F550D5E37 b1207
	NATIVE_DECL void _0x22C8B10802301381(Any p0, Any p1) { invoke<Void>(0x22C8B10802301381, p0, p1); } // 0x22C8B10802301381 b1207
	NATIVE_DECL void _EAGLE_EYE_SET_DRAIN_RATE_MODIFIER(Player player, float modifier) { invoke<Void>(0xE0D6C2A146A5C993, player, modifier); } // 0xE0D6C2A146A5C993 b1207
	NATIVE_DECL void _0x06E1FB78B1E59CA5(Ped ped, BOOL p1) { invoke<Void>(0x06E1FB78B1E59CA5, ped, p1); } // 0x06E1FB78B1E59CA5 b1207
	NATIVE_DECL void _EAGLE_EYE_SET_PLUS_FLAG_DISABLED(Ped ped, BOOL disabled) { invoke<Void>(0xCE285A4413B00B7F, ped, disabled); } // 0xCE285A4413B00B7F b1207
	NATIVE_DECL Any _0x3813E11A378958A5(Any p0) { return invoke<Any>(0x3813E11A378958A5, p0); } // 0x3813E11A378958A5 b1207
	NATIVE_DECL void _EAGLE_EYE_SET_FOCUS_ON_ASSOCIATED_CLUE_TRAIL(Player player, Entity linkedWaypointPed) { invoke<Void>(0x2AF423D6ECB2C485, player, linkedWaypointPed); } // 0x2AF423D6ECB2C485 b1207
	NATIVE_DECL void _0x0F9CF06986300875(Any p0) { invoke<Void>(0x0F9CF06986300875, p0); } // 0x0F9CF06986300875 b1207
	NATIVE_DECL void _EAGLE_EYE_SET_TRACKING_UPGRADE(Player player, float p1) { invoke<Void>(0xDFC85C5199045026, player, p1); } // 0xDFC85C5199045026 b1207
	NATIVE_DECL void _EAGLE_EYE_SET_TRACKING_UPGRADE_2(Player player, float p1) { invoke<Void>(0x6FA957D1B55941C1, player, p1); } // 0x6FA957D1B55941C1 b1311
	NATIVE_DECL Any _0x1DA5C5B0923E1B85(Any p0) { return invoke<Any>(0x1DA5C5B0923E1B85, p0); } // 0x1DA5C5B0923E1B85 b1207
	NATIVE_DECL Any _0xAAED694CE814817F(Any p0) { return invoke<Any>(0xAAED694CE814817F, p0); } // 0xAAED694CE814817F b1207
	NATIVE_DECL void EAGLE_EYE_SET_CUSTOM_ENTITY_TINT(Entity entity, int red, int green, int blue) { invoke<Void>(0x62ED71E133B6C9F1, entity, red, green, blue); } // 0x62ED71E133B6C9F1 b1207
	NATIVE_DECL void _0xBC02B3D151D3859F(Entity entity, Any p1) { invoke<Void>(0xBC02B3D151D3859F, entity, p1); } // 0xBC02B3D151D3859F b1207
	NATIVE_DECL void _EAGLE_EYE_SET_CUSTOM_DISTANCE(Entity entity, float distance) { invoke<Void>(0x907B16B3834C69E2, entity, distance); } // 0x907B16B3834C69E2 b1207
	NATIVE_DECL void _0xF21C7A3F3FFBA629(Any p0) { invoke<Void>(0xF21C7A3F3FFBA629, p0); } // 0xF21C7A3F3FFBA629 b1207
	NATIVE_DECL void _SET_PLAYER_MANAGE_BUFF_SUPER_JUMP(Player player, float p1) { invoke<Void>(0x292F0B6EDC82E3A4, player, p1); } // 0x292F0B6EDC82E3A4 b1207
	// see personaabilities.meta
	// enum ePersonaAbilityFlag
	// {
	// 	PERSONA_CAN_AUTOESCAPE_FROM_LASSO,
	// 	PERSONA_HAT_BLOCKS_FIRST_HEADSHOT,
	// 	PERSONA_FULL_AUTO_FOR_ALL_WEAPONS,
	// 	PERSONA_MIGHT_LIVE_AFTER_DEADLY_DAMAGE,
	// 	PERSONA_IGNORE_AIM_BEFORE_FIRING_RESTRICTIONS,
	// 	PERSONA_DEADEYE_INSTANT_RELOAD,
	// 	PERSONA_USE_PHOSPHOROUS_ROUNDS,
	// 	PERSONA_CONT_DEADEYE_ON_TAKING_COVER,
	// 	PERSONA_CONT_DEADEYE_ON_RELOAD,
	// 	PERSONA_CONT_DEADEYE_ON_SHOOTING,
	// 	PERSONA_CONT_DEADEYE_ON_EXITING_AIM,
	// 	PERSONA_DISABLE_PLAYER_CANCELLING_DEADEYE,
	// 	PERSONA_CONT_DEADEYE_ON_RAGDOLL,
	// 	PERSONA_USE_EXPLOSIVE_ROUNDS,
	// 	PERSONA_EXIT_DEADEYE_ON_TAKING_DAMAGE,
	// 	PERSONA_CARRY_TWO_MONEYBAGS,
	// 	PERSONA_ABILITY_LONG_PICK_HERBS,
	// 	PERSONA_ABILITY_UNBREAKABLE_LASSO,
	// 	PERSONA_CONT_DEADEYE_ON_SPRINTING,
	// 	PERSONA_CANT_DEAL_HEADSHOTS,
	// 	PERSONA_HANGMAN,
	// 	PERSONA_ALLOW_DEADEYE_WITH_MELEE_WEAPONS,
	// 	PERSONA_ALLOW_DEADEYE_WHILE_UNARMED,
	// 	PERSONA_DISABLE_DEADEYE_PERFECT_ACCURACY,
	// 	PERSONA_CANT_DEAL_HEADSHOTS_TO_PLAYERS,
	// 	PERSONA_CANT_DEAL_CRITICAL_DAMAGE,
	// 	PERSONA_CANT_DEAL_CRITICAL_DAMAGE_TO_PLAYERS,
	// 	PERSONA_ALLOW_EAGLEEYE_IN_COMBAT,
	// 	PERSONA_CONT_EAGLEEYE_ON_SPRINT,
	// 	PERSONA_SUPPRESS_LENGENDARY_EAGLEEYE_TRAIL_COLOR
	// };
	NATIVE_DECL void _SET_LOCAL_PLAYER_PERSONA_ABILITY_FLAG(int flagId, BOOL toggle) { invoke<Void>(0x7146CF430965927C, flagId, toggle); } // 0x7146CF430965927C b1207
	NATIVE_DECL void _SET_PLAYER_MAX_AMMO_OVERRIDE_FOR_AMMO_TYPE(Player player, Hash ammoType, int amount) { invoke<Void>(0xE133C1EC5300F740, player, ammoType, amount); } // 0xE133C1EC5300F740 b1207
	NATIVE_DECL void _0xC900A465364A85D6(Player player) { invoke<Void>(0xC900A465364A85D6, player); } // 0xC900A465364A85D6 b1207
	NATIVE_DECL void _0xCFB2EED4FCB7BD77(Any p0, Any p1, Any p2) { invoke<Void>(0xCFB2EED4FCB7BD77, p0, p1, p2); } // 0xCFB2EED4FCB7BD77 b1207
	NATIVE_DECL void _0x2BB8D58E88777499(Any p0) { invoke<Void>(0x2BB8D58E88777499, p0); } // 0x2BB8D58E88777499 b1207
	NATIVE_DECL void _0x00EB5A760638DB55(Any p0, Any p1, Any p2) { invoke<Void>(0x00EB5A760638DB55, p0, p1, p2); } // 0x00EB5A760638DB55 b1207
	NATIVE_DECL void _0x65887EAC535A0B0C(Any p0) { invoke<Void>(0x65887EAC535A0B0C, p0); } // 0x65887EAC535A0B0C b1207
	NATIVE_DECL void _SET_WEAPON_DEGRADATION_MODIFIER(Player player, float modifier) { invoke<Void>(0x11A7FF918EF6BC66, player, modifier); } // 0x11A7FF918EF6BC66 b1207
	NATIVE_DECL void _SET_BOW_DRAW_REDUCTION_TIME_IN_DEADEYE(Player player, float drawReductionTime) { invoke<Void>(0xBE0C524970892D41, player, drawReductionTime); } // 0xBE0C524970892D41 b1207
	// Decreases Stamina bar drain speed by % when drawing a bow.
	NATIVE_DECL void _SET_BOW_STAMINA_DRAIN_SPEED(Player player, float staminaDrain) { invoke<Void>(0xFE7C9CF376D23342, player, staminaDrain); } // 0xFE7C9CF376D23342 b1207
	NATIVE_DECL void _SET_DAMAGE_CLOSE_DISTANCE_BONUS(Player player, float closeRangeLowerBound, float closeRangeUpperBound) { invoke<Void>(0x7761A30432C91297, player, closeRangeLowerBound, closeRangeUpperBound); } // 0x7761A30432C91297 b1207
	NATIVE_DECL void _SET_DAMAGE_CLOSE_DISTANCE_BONUS_TOTAL(Player player, float closeDamageBonus) { invoke<Void>(0x5006C36652D6EC56, player, closeDamageBonus); } // 0x5006C36652D6EC56 b1207
	NATIVE_DECL void _SET_DAMAGE_FAR_DISTANCE_BONUS(Player player, float farRangeLowerBound, float farRangeUpperBound) { invoke<Void>(0xED591CB17C8BA216, player, farRangeLowerBound, farRangeUpperBound); } // 0xED591CB17C8BA216 b1207
	NATIVE_DECL void _SET_DAMAGE_FAR_DISTANCE_BONUS_TOTAL(Player player, float farDamageBonus) { invoke<Void>(0x1F0E3A4434565F8F, player, farDamageBonus); } // 0x1F0E3A4434565F8F b1207
	NATIVE_DECL Any _0x6C54E69516CC56BD(Any p0) { return invoke<Any>(0x6C54E69516CC56BD, p0); } // 0x6C54E69516CC56BD b1207
	NATIVE_DECL void _0x3A8611BD7BDE84F7(Any p0, Any p1) { invoke<Void>(0x3A8611BD7BDE84F7, p0, p1); } // 0x3A8611BD7BDE84F7 b1207
	NATIVE_DECL void _0xC177C827CEFC0AA4(Any p0, Any p1) { invoke<Void>(0xC177C827CEFC0AA4, p0, p1); } // 0xC177C827CEFC0AA4 b1207
	NATIVE_DECL void _0xBD96185264DDAAEA(Any p0, Any p1) { invoke<Void>(0xBD96185264DDAAEA, p0, p1); } // 0xBD96185264DDAAEA b1207
	NATIVE_DECL void _0x628E742FE1F79C4A(Any p0, Any p1) { invoke<Void>(0x628E742FE1F79C4A, p0, p1); } // 0x628E742FE1F79C4A b1207
	NATIVE_DECL void _0xC6366A585659D15C(Any p0, Any p1) { invoke<Void>(0xC6366A585659D15C, p0, p1); } // 0xC6366A585659D15C b1207
	NATIVE_DECL void _0x98CD760DE43B612E(Any p0, Any p1) { invoke<Void>(0x98CD760DE43B612E, p0, p1); } // 0x98CD760DE43B612E b1207
	NATIVE_DECL void _0x216BC0D3D2E413D2(Player player, Any p1) { invoke<Void>(0x216BC0D3D2E413D2, player, p1); } // 0x216BC0D3D2E413D2 b1207
	NATIVE_DECL void _0x45EF176B532CA851(Any p0, Any p1) { invoke<Void>(0x45EF176B532CA851, p0, p1); } // 0x45EF176B532CA851 b1207
	NATIVE_DECL void _0xA342495F93B7B838(Any p0, Any p1) { invoke<Void>(0xA342495F93B7B838, p0, p1); } // 0xA342495F93B7B838 b1207
	NATIVE_DECL void _0x3BB84F812E052C90(Any p0) { invoke<Void>(0x3BB84F812E052C90, p0); } // 0x3BB84F812E052C90 b1207
	NATIVE_DECL void _0x9FC5A003FB76EDBD(Any p0, Any p1) { invoke<Void>(0x9FC5A003FB76EDBD, p0, p1); } // 0x9FC5A003FB76EDBD b1207
	NATIVE_DECL void _0x0FAF95D71ED67ADE(Any p0, Any p1) { invoke<Void>(0x0FAF95D71ED67ADE, p0, p1); } // 0x0FAF95D71ED67ADE b1207
	NATIVE_DECL void _0x988C9045531B9FCE(Any p0, Any p1) { invoke<Void>(0x988C9045531B9FCE, p0, p1); } // 0x988C9045531B9FCE b1232
	NATIVE_DECL void _0x06C3DB00B69D5435(Any p0, Any p1) { invoke<Void>(0x06C3DB00B69D5435, p0, p1); } // 0x06C3DB00B69D5435 b1232
	NATIVE_DECL void _0xBB6EA5D59E926095(Any p0, Any p1) { invoke<Void>(0xBB6EA5D59E926095, p0, p1); } // 0xBB6EA5D59E926095 b1207
	NATIVE_DECL Any _0xE1D356F5A66D0FFA(Any p0) { return invoke<Any>(0xE1D356F5A66D0FFA, p0); } // 0xE1D356F5A66D0FFA b1232
	NATIVE_DECL void _0x929DDD5538F3DF1F(Any p0, Any p1) { invoke<Void>(0x929DDD5538F3DF1F, p0, p1); } // 0x929DDD5538F3DF1F b1232
	NATIVE_DECL void _0xFA7DAAE3959E6C7B(Any p0, Any p1) { invoke<Void>(0xFA7DAAE3959E6C7B, p0, p1); } // 0xFA7DAAE3959E6C7B b1207
	NATIVE_DECL void _0x9461A8FAB0378E5B(Any p0, Any p1) { invoke<Void>(0x9461A8FAB0378E5B, p0, p1); } // 0x9461A8FAB0378E5B b1207
	NATIVE_DECL void _0xCB61A63AA53D7D22(Any p0, Any p1) { invoke<Void>(0xCB61A63AA53D7D22, p0, p1); } // 0xCB61A63AA53D7D22 b1207
	NATIVE_DECL void _0xCFFC3ECCD7A5CCEB(Player player, Hash weapon, BOOL p2) { invoke<Void>(0xCFFC3ECCD7A5CCEB, player, weapon, p2); } // 0xCFFC3ECCD7A5CCEB b1207
	NATIVE_DECL void _0x76F7E1BCD623A429(Any p0) { invoke<Void>(0x76F7E1BCD623A429, p0); } // 0x76F7E1BCD623A429 b1207
	NATIVE_DECL void _0x585CE159DB46FADB(Any p0, Any p1) { invoke<Void>(0x585CE159DB46FADB, p0, p1); } // 0x585CE159DB46FADB b1207
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/PLAYER_RESET_FLAGS
	NATIVE_DECL void _SET_PLAYER_RESET_FLAG(Player player, int playerResetFlag, BOOL p2) { invoke<Void>(0x9F9A829C6751F3C7, player, playerResetFlag, p2); } // 0x9F9A829C6751F3C7 b1207
	NATIVE_DECL Any _0xFE691E89C08937B6(Any p0, Any p1) { return invoke<Any>(0xFE691E89C08937B6, p0, p1); } // 0xFE691E89C08937B6 b1207
	NATIVE_DECL Ped GET_MOUNT_OWNED_BY_PLAYER(Player player) { return invoke<Ped>(0xF49F14462F0AE27C, player); } // 0xF49F14462F0AE27C b1207
	NATIVE_DECL Player _GET_PLAYER_OWNER_OF_MOUNT(Ped mount) { return invoke<Player>(0xAD03B03737CE6810, mount); } // 0xAD03B03737CE6810 b1207
	// Seems to enable active horse equipment prompt when being near it and enables the control that opens the inventory as well
	NATIVE_DECL void _SET_PLAYER_OWNS_MOUNT(Player player, Ped mount) { invoke<Void>(0xE6D4E435B56D5BD0, player, mount); } // 0xE6D4E435B56D5BD0 b1207
	NATIVE_DECL Vehicle _GET_VEHICLE_OWNED_BY_PLAYER(Player player) { return invoke<Vehicle>(0xB9050A97594C8832, player); } // 0xB9050A97594C8832 b1207
	NATIVE_DECL Player _GET_PLAYER_OWNER_OF_VEHICLE(Vehicle vehicle) { return invoke<Player>(0x7C803BDC8343228D, vehicle); } // 0x7C803BDC8343228D b1207
	NATIVE_DECL void _SET_PLAYER_OWNS_VEHICLE(Player player, Vehicle vehicle) { invoke<Void>(0xD0E02AA618020D17, player, vehicle); } // 0xD0E02AA618020D17 b1207
	NATIVE_DECL Vehicle _GET_PLAYER_HUNTING_WAGON(Player player) { return invoke<Vehicle>(0x5CA6BBD4A7D8145E, player); } // 0x5CA6BBD4A7D8145E b1207
	// Only applies to HUNTERCART01
	NATIVE_DECL void _SET_PLAYER_HUNTING_WAGON(Player player, Vehicle wagon) { invoke<Void>(0x6A4404BDFA62CE2C, player, wagon); } // 0x6A4404BDFA62CE2C b1207
	NATIVE_DECL void _0x9044835BE9D9DBFE(Any p0, Any p1) { invoke<Void>(0x9044835BE9D9DBFE, p0, p1); } // 0x9044835BE9D9DBFE b1207
	NATIVE_DECL Any GET_DISCOVERABLE_NAME_HASH_AND_TYPE_FOR_ENTITY(Any p0, Any p1) { return invoke<Any>(0x0139637A3BFF8B6D, p0, p1); } // 0x0139637A3BFF8B6D b1207
	// p0: mostly Ped Hashes
	NATIVE_DECL Hash _GET_CONSTRUCTED_DISCOVERED_CHARACTER_NAME(Hash p0, BOOL model, BOOL outfit) { return invoke<Hash>(0x8E84119A23C16623, p0, model, outfit); } // 0x8E84119A23C16623 b1207
	NATIVE_DECL Hash GET_TARGET_CHARACTER_NAME_SCRIPT_OVERRIDE_HASH(Ped ped) { return invoke<Hash>(0x0335106F3ACABBED, ped); } // 0x0335106F3ACABBED b1207
	NATIVE_DECL const char* GET_TARGET_CHARACTER_NAME_SCRIPT_OVERRIDE_RAW_STRING(Ped ped) { return invoke<const char*>(0x755E08680F21EF30, ped); } // 0x755E08680F21EF30 b1207
	NATIVE_DECL Hash GET_TARGET_CHARACTER_NAME_FOR_LOCAL_PLAYER(Ped ped) { return invoke<Hash>(0x36E3D8B5A6552FE8, ped); } // 0x36E3D8B5A6552FE8 b1207
	NATIVE_DECL Any _0xDA9D7BE231FE865F(Any p0, Any p1, Any p2) { return invoke<Any>(0xDA9D7BE231FE865F, p0, p1, p2); } // 0xDA9D7BE231FE865F b1207
	NATIVE_DECL void _0x946D46CD6DFB9742(Any p0, Any p1, Any p2) { invoke<Void>(0x946D46CD6DFB9742, p0, p1, p2); } // 0x946D46CD6DFB9742 b1207
	NATIVE_DECL Any _0x0772F87D7B07719A(Any p0, Any p1, Any p2) { return invoke<Any>(0x0772F87D7B07719A, p0, p1, p2); } // 0x0772F87D7B07719A b1207
	NATIVE_DECL void _0xCDDD4B74660E2335(Any p0, Any p1, Any p2) { invoke<Void>(0xCDDD4B74660E2335, p0, p1, p2); } // 0xCDDD4B74660E2335 b1207
	NATIVE_DECL void _0x77E83C315A3B31CA(Any p0) { invoke<Void>(0x77E83C315A3B31CA, p0); } // 0x77E83C315A3B31CA b1207
	NATIVE_DECL void _SET_PLAYER_HAS_DISCOVERED_CHARACTER_NAME_MP(Hash discoveryHash) { invoke<Void>(0x7C32191D9FB2BDEA, discoveryHash); } // 0x7C32191D9FB2BDEA b1207
	NATIVE_DECL BOOL GET_HAS_PLAYER_DISCOVERED_CHARACTER_NAME_MP(Hash discoveryHash) { return invoke<BOOL>(0x354F689C4FFAAB37, discoveryHash); } // 0x354F689C4FFAAB37 b1207
	NATIVE_DECL void _MODIFY_PLAYER_DISCOVERED_CHARACTER_NAME_MP_SET_UNDISCOVERED(Hash discoveryHash) { invoke<Void>(0xFB0E622B401884D3, discoveryHash); } // 0xFB0E622B401884D3 b1207
	NATIVE_DECL void _0xDC68829BB3F37023(Player player, BOOL showingInfoCard) { invoke<Void>(0xDC68829BB3F37023, player, showingInfoCard); } // 0xDC68829BB3F37023 b1207
	NATIVE_DECL void _0x4DBC4873707E8FD6(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x4DBC4873707E8FD6, p0, p1, p2, p3); } // 0x4DBC4873707E8FD6 b1207
	NATIVE_DECL void _0xCEDC16930526F728(Any p0) { invoke<Void>(0xCEDC16930526F728, p0); } // 0xCEDC16930526F728 b1207
	NATIVE_DECL void _0x14E57F88BA0A07FC(Hash location) { invoke<Void>(0x14E57F88BA0A07FC, location); } // 0x14E57F88BA0A07FC b1207
	NATIVE_DECL Any _0x2E1ABE627C95ED9B() { return invoke<Any>(0x2E1ABE627C95ED9B); } // 0x2E1ABE627C95ED9B b1207
	NATIVE_DECL void _0x497A18F8F88AA9D8() { invoke<Void>(0x497A18F8F88AA9D8); } // 0x497A18F8F88AA9D8 b1207
	NATIVE_DECL void _0x4F0D2256AAE94EDA(int p0) { invoke<Void>(0x4F0D2256AAE94EDA, p0); } // 0x4F0D2256AAE94EDA b1207
	// Focus Fire VFX start for player: p1 = focusfire
	NATIVE_DECL void _SET_LOCKON_FOCUS_FIRE_VFX(Player player, const char* p1) { invoke<Void>(0x5F8E0303C229C84B, player, p1); } // 0x5F8E0303C229C84B b1207
	// Hardcoded to return zero/false.
	NATIVE_DECL Any _0x0B7803F6F7BB43E0() { return invoke<Any>(0x0B7803F6F7BB43E0); } // 0x0B7803F6F7BB43E0 b1207
	// Hardcoded to return zero/false.
	NATIVE_DECL Any _0xC74EB3F2EC169F6B(Any p0) { return invoke<Any>(0xC74EB3F2EC169F6B, p0); } // 0xC74EB3F2EC169F6B b1232
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x3B296934DB026873(Any p0, Any p1) { invoke<Void>(0x3B296934DB026873, p0, p1); } // 0x3B296934DB026873 b1207
	NATIVE_DECL void SET_MIN_TIME_BEFORE_HORSE_BUCKING(Ped mount, int iMinBuckTime) { invoke<Void>(0x506CE71FB6E8CF5E, mount, iMinBuckTime); } // 0x506CE71FB6E8CF5E b1207
	NATIVE_DECL Any _0xF4CB347D7B5EB0FD() { return invoke<Any>(0xF4CB347D7B5EB0FD); } // 0xF4CB347D7B5EB0FD b1207
	NATIVE_DECL void _0xCD7CA3013FD12749(Any p0, Any p1) { invoke<Void>(0xCD7CA3013FD12749, p0, p1); } // 0xCD7CA3013FD12749 b1232
	NATIVE_DECL void _FORCE_REST_SCENARIO(BOOL toggle) { invoke<Void>(0xE5A3DD2FF84E1A4B, toggle); } // 0xE5A3DD2FF84E1A4B b1232
	// _IS_PLAYER_D* - _IS_PLAYER_F*
	NATIVE_DECL BOOL _0x57028FD99886F6F9() { return invoke<BOOL>(0x57028FD99886F6F9); } // 0x57028FD99886F6F9 b1232
	NATIVE_DECL void _0x35A33783EC3C3448(Any p0) { invoke<Void>(0x35A33783EC3C3448, p0); } // 0x35A33783EC3C3448 b1311
	NATIVE_DECL void _0x39D8D7082BC34B72(Any p0) { invoke<Void>(0x39D8D7082BC34B72, p0); } // 0x39D8D7082BC34B72 b1311
	NATIVE_DECL void _0x1AD8AD999C27F44A(Any p0) { invoke<Void>(0x1AD8AD999C27F44A, p0); } // 0x1AD8AD999C27F44A b1311
}

namespace POPULATION
{
	NATIVE_DECL int GET_NUM_MODELS_IN_POPULATION_SET(Hash popSetHash) { return invoke<int>(0xA1E3171ED0E47564, popSetHash); } // 0xA1E3171ED0E47564 b1207
	NATIVE_DECL Hash GET_PED_MODEL_NAME_IN_POPULATION_SET(Hash popSetHash, int index) { return invoke<Hash>(0x3EAFA1C533B7139E, popSetHash, index); } // 0x3EAFA1C533B7139E b1207
	NATIVE_DECL Hash GET_RANDOM_MODEL_FROM_POPULATION_SET(Hash popSetHash, int flags, Hash p2, BOOL p3, BOOL p4, float x, float y, float z) { return invoke<Hash>(0x6B12ED8C77E8567B, popSetHash, flags, p2, p3, p4, x, y, z); } // 0x6B12ED8C77E8567B b1207
	NATIVE_DECL Hash GET_RANDOM_MODEL_FROM_POPULATION_SET(Hash popSetHash, int flags, Hash p2, BOOL p3, BOOL p4, Vector3 vec) { return invoke<Hash>(0x6B12ED8C77E8567B, popSetHash, flags, p2, p3, p4, vec.x, vec.y, vec.z); } // 0x6B12ED8C77E8567B b1207
	NATIVE_DECL PopZone _CREATE_POPZONE_FROM_VOLUME(Volume volume) { return invoke<PopZone>(0x9AC1C64FE46B6D09, volume); } // 0x9AC1C64FE46B6D09 b1207
	NATIVE_DECL void _DELETE_SCRIPT_POPZONE(PopZone popZone) { invoke<Void>(0xA6E6A66FC4CA4224, popZone); } // 0xA6E6A66FC4CA4224 b1207
	NATIVE_DECL BOOL _IS_POPZONE_VALID(PopZone popZone) { return invoke<BOOL>(0xA5BD585005EFCAD4, popZone); } // 0xA5BD585005EFCAD4 b1207
	NATIVE_DECL void SET_POPZONE_POPULATION_SET(PopZone popZone, Hash populationSetHash) { invoke<Void>(0x3E6A49D9B519E85C, popZone, populationSetHash); } // 0x3E6A49D9B519E85C b1207
	NATIVE_DECL void _0x7E6BC0B94F5928F0(PopZone popZone, int p1, int p2) { invoke<Void>(0x7E6BC0B94F5928F0, popZone, p1, p2); } // 0x7E6BC0B94F5928F0 b1207
	NATIVE_DECL void _0x578E2FA64E847C60(PopZone popZone, int p1) { invoke<Void>(0x578E2FA64E847C60, popZone, p1); } // 0x578E2FA64E847C60 b1207
	NATIVE_DECL void _0x08892122769770D5(PopZone popZone, BOOL p1) { invoke<Void>(0x08892122769770D5, popZone, p1); } // 0x08892122769770D5 b1207
	NATIVE_DECL void _0x0F1861101C9A9944(PopZone popZone, BOOL p1) { invoke<Void>(0x0F1861101C9A9944, popZone, p1); } // 0x0F1861101C9A9944 b1207
	NATIVE_DECL void SET_SPAWNER_INFO_PRIORITY(Hash p0, Hash p1, int priority) { invoke<Void>(0x60CDE717A6D47769, p0, p1, priority); } // 0x60CDE717A6D47769 b1207
	NATIVE_DECL void CLEAR_SPAWNER_INFO_PRIORITY(Hash p0, Hash p1) { invoke<Void>(0x217A54DE2D200305, p0, p1); } // 0x217A54DE2D200305 b1207
	NATIVE_DECL void _0x638FCFC6042A9473(Any p0, Any p1) { invoke<Void>(0x638FCFC6042A9473, p0, p1); } // 0x638FCFC6042A9473 b1207
	NATIVE_DECL void _0xB56D41A694E42E86(Volume volume, int flags, int p2, Hash p3, Hash p4, Hash p5, int p6) { invoke<Void>(0xB56D41A694E42E86, volume, flags, p2, p3, p4, p5, p6); } // 0xB56D41A694E42E86 b1207
	NATIVE_DECL void _REMOVE_AMBIENT_SPAWN_RESTRICTION(Volume volume) { invoke<Void>(0x74C2B3DC0B294102, volume); } // 0x74C2B3DC0B294102 b1207
	NATIVE_DECL void _0x18262CAFEBB5FBE1(Volume volume, int flags, int p2, Hash p3, Hash p4, Hash p5, int p6) { invoke<Void>(0x18262CAFEBB5FBE1, volume, flags, p2, p3, p4, p5, p6); } // 0x18262CAFEBB5FBE1 b1207
	NATIVE_DECL void _REMOVE_AMBIENT_MOVE_RESTRICTION(Volume volume) { invoke<Void>(0xA1CFB35069D23C23, volume); } // 0xA1CFB35069D23C23 b1207
	NATIVE_DECL void _0x2161278C6322F740(int bitFlag, Any p1, Any p2, Hash p3, int p4, Volume volume) { invoke<Void>(0x2161278C6322F740, bitFlag, p1, p2, p3, p4, volume); } // 0x2161278C6322F740 b1207
	NATIVE_DECL void _0xF45E46DEECF7DF6E(int bitFlag, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0xF45E46DEECF7DF6E, bitFlag, p1, p2, p3, p4); } // 0xF45E46DEECF7DF6E b1207
	NATIVE_DECL void _0x8EC7CD701F872F87(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0x8EC7CD701F872F87, p0, p1, p2, p3, p4, p5); } // 0x8EC7CD701F872F87 b1207
	NATIVE_DECL void _0xC4533E3E87125C9E(Any p0) { invoke<Void>(0xC4533E3E87125C9E, p0); } // 0xC4533E3E87125C9E b1207
	// Params: p1 = 1 & 2 in R* Scripts
	NATIVE_DECL void _SET_PED_SHOULD_IGNORE_AVOIDANCE_VOLUMES(Ped ped, int p1) { invoke<Void>(0xF74E134F40192884, ped, p1); } // 0xF74E134F40192884 b1207
	NATIVE_DECL void _0xDBBF12EA7C1029B2(Any p0, Any p1) { invoke<Void>(0xDBBF12EA7C1029B2, p0, p1); } // 0xDBBF12EA7C1029B2 b1207
	NATIVE_DECL void _0x247F86595D396344(Any p0) { invoke<Void>(0x247F86595D396344, p0); } // 0x247F86595D396344 b1207
	NATIVE_DECL void _0x324AB2A68AD8AEE5() { invoke<Void>(0x324AB2A68AD8AEE5); } // 0x324AB2A68AD8AEE5 b1207
	NATIVE_DECL void DISABLE_AMBIENT_ROAD_POPULATION(BOOL unk) { invoke<Void>(0xC6DCC2A3A8825C85, unk); } // 0xC6DCC2A3A8825C85 b1207
	NATIVE_DECL void ENABLE_AMBIENT_ROAD_POPULATION() { invoke<Void>(0xBC90BDF4E5228EA1); } // 0xBC90BDF4E5228EA1 b1207
	NATIVE_DECL void _0x2660E7720EDC4BD0(Any p0, Any p1, Any p2) { invoke<Void>(0x2660E7720EDC4BD0, p0, p1, p2); } // 0x2660E7720EDC4BD0 b1311
	// Returns model hash of the closest fish
	NATIVE_DECL Hash _GET_RANDOM_FISH_TYPE_FOR_LOCATION() { return invoke<Hash>(0x595478B3BBC3076D); } // 0x595478B3BBC3076D b1207
	// Only used for Special Event (XMAS).
	// _SET_P*
	NATIVE_DECL void _0xEC116EDB683AD479(BOOL p0) { invoke<Void>(0xEC116EDB683AD479, p0); } // 0xEC116EDB683AD479 b1207
}

namespace POSSE
{
	NATIVE_DECL Any _0xC086FF658B2E51DB() { return invoke<Any>(0xC086FF658B2E51DB); } // 0xC086FF658B2E51DB b1207
	NATIVE_DECL Any _0xC086FF658B2E51DA(Any p0) { return invoke<Any>(0xC086FF658B2E51DA, p0); } // 0xC086FF658B2E51DA b1207
	NATIVE_DECL Any _0xC087FF658B2E51DA(Any p0, Any p1) { return invoke<Any>(0xC087FF658B2E51DA, p0, p1); } // 0xC087FF658B2E51DA b1207
	NATIVE_DECL int POSSE_GET_POSSE_MEMBERSHIP_COUNT() { return invoke<int>(0xC088FF658B2E51DA); } // 0xC088FF658B2E51DA b1207
	NATIVE_DECL Any _0xC089FF658B2E51DA(Any p0, Any p1) { return invoke<Any>(0xC089FF658B2E51DA, p0, p1); } // 0xC089FF658B2E51DA b1207
	NATIVE_DECL void _0xC08AFF658B2E51DA(Any p0) { invoke<Void>(0xC08AFF658B2E51DA, p0); } // 0xC08AFF658B2E51DA b1207
	NATIVE_DECL Any _0xC08BFF658B2E51DA(Any p0) { return invoke<Any>(0xC08BFF658B2E51DA, p0); } // 0xC08BFF658B2E51DA b1207
	NATIVE_DECL void _0xC08AFF658B2E51DB(Any p0) { invoke<Void>(0xC08AFF658B2E51DB, p0); } // 0xC08AFF658B2E51DB b1207
	NATIVE_DECL Any _0xC08CFF658B2E51DA(Any p0, Any p1) { return invoke<Any>(0xC08CFF658B2E51DA, p0, p1); } // 0xC08CFF658B2E51DA b1207
	NATIVE_DECL Any _0xC09CFF658B2E51DA(Any p0, Any p1, Any p2) { return invoke<Any>(0xC09CFF658B2E51DA, p0, p1, p2); } // 0xC09CFF658B2E51DA b1207
	NATIVE_DECL Any _0xC08DEF658B2E51DA(Any p0) { return invoke<Any>(0xC08DEF658B2E51DA, p0); } // 0xC08DEF658B2E51DA b1207
	NATIVE_DECL Any _0xC08DFF658B2E51DA() { return invoke<Any>(0xC08DFF658B2E51DA); } // 0xC08DFF658B2E51DA b1207
	NATIVE_DECL Any _0xC08DFF658B2E51DB(Any p0) { return invoke<Any>(0xC08DFF658B2E51DB, p0); } // 0xC08DFF658B2E51DB b1207
	NATIVE_DECL Any _0xC08EFF658B2E51DB(Any p0, Any p1) { return invoke<Any>(0xC08EFF658B2E51DB, p0, p1); } // 0xC08EFF658B2E51DB b1207
	NATIVE_DECL Any _0xC08FFF658B2E51DA() { return invoke<Any>(0xC08FFF658B2E51DA); } // 0xC08FFF658B2E51DA b1207
	NATIVE_DECL Any _0xC08FFF658B2E51DB(Any p0) { return invoke<Any>(0xC08FFF658B2E51DB, p0); } // 0xC08FFF658B2E51DB b1207
	NATIVE_DECL Any _0xC084FF658B2E61DA(Any p0) { return invoke<Any>(0xC084FF658B2E61DA, p0); } // 0xC084FF658B2E61DA b1207
	NATIVE_DECL Any _0xC084FF658B2E71DA(Any p0, Any p1, Any p2) { return invoke<Any>(0xC084FF658B2E71DA, p0, p1, p2); } // 0xC084FF658B2E71DA b1207
	NATIVE_DECL Any _0xC084FF658B2E81DA(Any p0, Any p1, Any p2) { return invoke<Any>(0xC084FF658B2E81DA, p0, p1, p2); } // 0xC084FF658B2E81DA b1207
	NATIVE_DECL Any _0xC084FF658B2E52DA(Any p0) { return invoke<Any>(0xC084FF658B2E52DA, p0); } // 0xC084FF658B2E52DA b1207
	NATIVE_DECL Any _0xC084FF658B2E53DA() { return invoke<Any>(0xC084FF658B2E53DA); } // 0xC084FF658B2E53DA b1207
	NATIVE_DECL Any _0xC084FF658B2E54DA(Any p0) { return invoke<Any>(0xC084FF658B2E54DA, p0); } // 0xC084FF658B2E54DA b1207
	NATIVE_DECL Any _0xC084FF658B2E55DA(Any p0, Any p1) { return invoke<Any>(0xC084FF658B2E55DA, p0, p1); } // 0xC084FF658B2E55DA b1207
	NATIVE_DECL void _0xC484FF658B2E55DA(Any p0) { invoke<Void>(0xC484FF658B2E55DA, p0); } // 0xC484FF658B2E55DA b1207
	NATIVE_DECL void _0xC584FF658B2E55DA(Any p0) { invoke<Void>(0xC584FF658B2E55DA, p0); } // 0xC584FF658B2E55DA b1207
	NATIVE_DECL void _0xC684FF658B2E55DA(Any p0) { invoke<Void>(0xC684FF658B2E55DA, p0); } // 0xC684FF658B2E55DA b1207
	NATIVE_DECL Any _0xC184FF658B2E55DA(Any p0, Any p1) { return invoke<Any>(0xC184FF658B2E55DA, p0, p1); } // 0xC184FF658B2E55DA b1207
	NATIVE_DECL Any _0xC284FF658B2E55DA(Any p0, Any p1, Any p2) { return invoke<Any>(0xC284FF658B2E55DA, p0, p1, p2); } // 0xC284FF658B2E55DA b1207
	NATIVE_DECL Any _0xC394FF658B2E55DA(Any p0, Any p1, Any p2, Any p3) { return invoke<Any>(0xC394FF658B2E55DA, p0, p1, p2, p3); } // 0xC394FF658B2E55DA b1207
	NATIVE_DECL Any _0xC07CFF658B2E51DA(Any p0, Any p1) { return invoke<Any>(0xC07CFF658B2E51DA, p0, p1); } // 0xC07CFF658B2E51DA b1207
	NATIVE_DECL Any _0xC06CFF658B2E51DA(Any p0, Any p1, Any p2) { return invoke<Any>(0xC06CFF658B2E51DA, p0, p1, p2); } // 0xC06CFF658B2E51DA b1207
}

namespace PROPSET
{
	NATIVE_DECL BOOL _REQUEST_PROP_SET(Hash hash) { return invoke<BOOL>(0xF3DE57A46D5585E9, hash); } // 0xF3DE57A46D5585E9 b1207
	// Same as _REQUEST_PROP_SET
	NATIVE_DECL BOOL _REQUEST_PROP_SET_2(Hash hash) { return invoke<BOOL>(0xE72F591958F3ACAB, hash); } // 0xE72F591958F3ACAB b1207
	NATIVE_DECL BOOL _HAS_PROP_SET_LOADED(Hash hash) { return invoke<BOOL>(0x48A88FC684C55FDC, hash); } // 0x48A88FC684C55FDC b1207
	// Same as _HAS_PROP_SET_LOADED
	NATIVE_DECL BOOL _HAS_PROP_SET_LOADED_2(Hash hash) { return invoke<BOOL>(0xD090ABEF4D6A7D96, hash); } // 0xD090ABEF4D6A7D96 b1207
	NATIVE_DECL void _SET_PROP_SET_AS_NO_LONGER_NEEDED(PropSet propSet) { invoke<Void>(0x909E3C7FAE539FB1, propSet); } // 0x909E3C7FAE539FB1 b1207
	NATIVE_DECL void _DELETE_PROP_SET(PropSet propSet, BOOL p1, BOOL p2) { invoke<Void>(0x58AC173A55D9D7B4, propSet, p1, p2); } // 0x58AC173A55D9D7B4 b1207
	NATIVE_DECL BOOL _RELEASE_PROP_SET(Hash hash) { return invoke<BOOL>(0xB1964A83B345B4AB, hash); } // 0xB1964A83B345B4AB b1207
	NATIVE_DECL PropSet _CREATE_PROP_SET(Hash hash, float x, float y, float z, int p4, float heading, float p6, BOOL p7, BOOL p8) { return invoke<PropSet>(0xE65C5CBA95F0E510, hash, x, y, z, p4, heading, p6, p7, p8); } // 0xE65C5CBA95F0E510 b1207
	NATIVE_DECL PropSet _CREATE_PROP_SET(Hash hash, Vector3 vec, int p4, float heading, float p6, BOOL p7, BOOL p8) { return invoke<PropSet>(0xE65C5CBA95F0E510, hash, vec.x, vec.y, vec.z, p4, heading, p6, p7, p8); } // 0xE65C5CBA95F0E510 b1207
	// Same as _CREATE_PROP_SET
	// https://github.com/femga/rdr3_discoveries/blob/master/objects/propsets_list.lua
	NATIVE_DECL PropSet _CREATE_PROP_SET_2(Hash hash, float x, float y, float z, int p4, float p5, float p6, BOOL p7, BOOL p8) { return invoke<PropSet>(0x899C97A1CCE7D483, hash, x, y, z, p4, p5, p6, p7, p8); } // 0x899C97A1CCE7D483 b1207
	NATIVE_DECL PropSet _CREATE_PROP_SET_2(Hash hash, Vector3 vec, int p4, float p5, float p6, BOOL p7, BOOL p8) { return invoke<PropSet>(0x899C97A1CCE7D483, hash, vec.x, vec.y, vec.z, p4, p5, p6, p7, p8); } // 0x899C97A1CCE7D483 b1207
	NATIVE_DECL PropSet CREATE_PROP_SET_INSTANCE_ATTACHED_TO_ENTITY(Hash hash, float x, float y, float z, Entity entity, float p5, BOOL p6, int p7, BOOL p8) { return invoke<PropSet>(0x9609DBDDE18FAD8C, hash, x, y, z, entity, p5, p6, p7, p8); } // 0x9609DBDDE18FAD8C b1207
	NATIVE_DECL PropSet CREATE_PROP_SET_INSTANCE_ATTACHED_TO_ENTITY(Hash hash, Vector3 vec, Entity entity, float p5, BOOL p6, int p7, BOOL p8) { return invoke<PropSet>(0x9609DBDDE18FAD8C, hash, vec.x, vec.y, vec.z, entity, p5, p6, p7, p8); } // 0x9609DBDDE18FAD8C b1207
	// Same as CREATE_PROP_SET_INSTANCE_ATTACHED_TO_ENTITY
	NATIVE_DECL PropSet _CREATE_PROP_SET_4(Hash hash, float x, float y, float z, Entity entity, float p5, BOOL p6, int p7, BOOL p8) { return invoke<PropSet>(0xACA7FB30269096D4, hash, x, y, z, entity, p5, p6, p7, p8); } // 0xACA7FB30269096D4 b1207
	NATIVE_DECL PropSet _CREATE_PROP_SET_4(Hash hash, Vector3 vec, Entity entity, float p5, BOOL p6, int p7, BOOL p8) { return invoke<PropSet>(0xACA7FB30269096D4, hash, vec.x, vec.y, vec.z, entity, p5, p6, p7, p8); } // 0xACA7FB30269096D4 b1207
	NATIVE_DECL BOOL DOES_PROP_SET_EXIST(PropSet propSet) { return invoke<BOOL>(0x7DDDCF815E650FF5, propSet); } // 0x7DDDCF815E650FF5 b1207
	NATIVE_DECL BOOL _DOES_PROP_SET_OF_TYPE_EXIST_NEAR_COORDS(Hash propsetHash, float x, float y, float z) { return invoke<BOOL>(0x72068021F498E6E3, propsetHash, x, y, z); } // 0x72068021F498E6E3 b1207
	NATIVE_DECL BOOL _DOES_PROP_SET_OF_TYPE_EXIST_NEAR_COORDS(Hash propsetHash, Vector3 vec) { return invoke<BOOL>(0x72068021F498E6E3, propsetHash, vec.x, vec.y, vec.z); } // 0x72068021F498E6E3 b1207
	NATIVE_DECL BOOL IS_PROP_SET_FULLY_LOADED(PropSet propSet) { return invoke<BOOL>(0xF42DB680A8B2A4D9, propSet); } // 0xF42DB680A8B2A4D9 b1207
	NATIVE_DECL void _SET_PROP_SET_VISIBLE(PropSet propSet, BOOL toggle) { invoke<Void>(0x9D096A5BD02F953E, propSet, toggle); } // 0x9D096A5BD02F953E b1207
	NATIVE_DECL BOOL _IS_PROP_SET_VISIBLE(PropSet propSet) { return invoke<BOOL>(0x0CE8AAFE9E433A23, propSet); } // 0x0CE8AAFE9E433A23 b1207
	NATIVE_DECL Hash _GET_PROP_SET_MODEL(PropSet propSet) { return invoke<Hash>(0xA6A9712955F53D9C, propSet); } // 0xA6A9712955F53D9C b1207
	NATIVE_DECL Hash _GET_VEHICLE_PROP_SET_HASH(Vehicle vehicle) { return invoke<Hash>(0x36F69E7A22655653, vehicle); } // 0x36F69E7A22655653 b1207
	NATIVE_DECL int _GET_ENTITIES_FROM_PROP_SET(PropSet propSet, ItemSet itemSet, Hash model, BOOL p3, BOOL p4) { return invoke<int>(0x738271B660FE0695, propSet, itemSet, model, p3, p4); } // 0x738271B660FE0695 b1207
	NATIVE_DECL void _0xC4B67EF3FD65622D(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5) { invoke<Void>(0xC4B67EF3FD65622D, p0, p1, p2, p3, p4, p5); } // 0xC4B67EF3FD65622D b1207
	NATIVE_DECL void _0x58E0B01D45CA7357(Any p0) { invoke<Void>(0x58E0B01D45CA7357, p0); } // 0x58E0B01D45CA7357 b1207
	NATIVE_DECL void _0xC1AB7EEFD3E6EE49(Any p0, Any p1) { invoke<Void>(0xC1AB7EEFD3E6EE49, p0, p1); } // 0xC1AB7EEFD3E6EE49 b1207
	NATIVE_DECL PropSet _GET_VEHICLE_PROP_SET(Vehicle vehicle) { return invoke<PropSet>(0xCE2ACD6F602803E5, vehicle); } // 0xCE2ACD6F602803E5 b1207
	NATIVE_DECL BOOL _DOES_VEHICLE_HAVE_ANY_PROP_SET(Vehicle vehicle) { return invoke<BOOL>(0x53784CEA0159439B, vehicle); } // 0x53784CEA0159439B b1207
	// List of vehicle propsets (wagons & trains): https://pastebin.com/1CsnvGLu / https://pastebin.com/v7TtqTgE
	NATIVE_DECL void _ADD_PROP_SET_FOR_VEHICLE(Vehicle vehicle, Hash propset) { invoke<Void>(0xD80FAF919A2E56EA, vehicle, propset); } // 0xD80FAF919A2E56EA b1207
	NATIVE_DECL void _REMOVE_VEHICLE_PROP_SETS(Vehicle vehicle) { invoke<Void>(0x3BCF32FF37EA9F1D, vehicle); } // 0x3BCF32FF37EA9F1D b1207
	NATIVE_DECL BOOL _IS_VEHICLE_PROP_SET_LOADED(Vehicle vehicle) { return invoke<BOOL>(0x155B2FBE72D7D1D0, vehicle); } // 0x155B2FBE72D7D1D0 b1207
	// https://github.com/femga/rdr3_discoveries/blob/master/vehicles/vehicle_modding/vehicle_propsets.lua
	NATIVE_DECL void _ADD_ADDITIONAL_PROP_SET_FOR_VEHICLE(Vehicle vehicle, Hash propset) { invoke<Void>(0x75F90E4051CC084C, vehicle, propset); } // 0x75F90E4051CC084C b1207
	NATIVE_DECL BOOL _IS_VEHICLE_PROP_SET_LOADED_ADDITIONAL(Vehicle vehicle) { return invoke<BOOL>(0x7264F9CA87A9830B, vehicle); } // 0x7264F9CA87A9830B b1207
	// Returns PropSet handle to be used with _GET_PROP_SET_MODEL
	NATIVE_DECL PropSet _GET_VEHICLE_LIGHT_PROP_SET(Vehicle vehicle) { return invoke<PropSet>(0xA079300AF757FB1A, vehicle); } // 0xA079300AF757FB1A b1207
	NATIVE_DECL BOOL _DOES_VEHICLE_HAVE_ANY_LIGHT_PROP_SET(Vehicle vehicle) { return invoke<BOOL>(0xC9B4B3A36F81FD75, vehicle); } // 0xC9B4B3A36F81FD75 b1207
	// To remove propsets either parse a zero as hash or call 0xE31C0CB1C3186D40
	// 0xA6A9712955F53D9C returns lightPropset Hashes
	// https://github.com/femga/rdr3_discoveries/blob/master/vehicles/vehicle_modding/vehicle_lantern_propsets.lua
	NATIVE_DECL void _ADD_LIGHT_PROP_SET_TO_VEHICLE(Vehicle vehicle, Hash lightPropset) { invoke<Void>(0xC0F0417A90402742, vehicle, lightPropset); } // 0xC0F0417A90402742 b1207
	NATIVE_DECL void _REMOVE_VEHICLE_LIGHT_PROP_SETS(Vehicle vehicle) { invoke<Void>(0xE31C0CB1C3186D40, vehicle); } // 0xE31C0CB1C3186D40 b1207
	NATIVE_DECL BOOL _IS_VEHICLE_LIGHT_PROP_SET_LOADED(Vehicle vehicle) { return invoke<BOOL>(0x0790473EEE1977D3, vehicle); } // 0x0790473EEE1977D3 b1207
	// Example before/after deleting a train carriage's propset: https://imgur.com/a/qRNrIrK
	NATIVE_DECL PropSet _GET_TRAIN_CARRIAGE_PROP_SET(Entity trainCarriage) { return invoke<PropSet>(0xCFC0BD09BB1B73FF, trainCarriage); } // 0xCFC0BD09BB1B73FF b1207
	NATIVE_DECL Any _0x8F3333F0A6900B3C(Any p0, Any p1) { return invoke<Any>(0x8F3333F0A6900B3C, p0, p1); } // 0x8F3333F0A6900B3C b1207
	NATIVE_DECL PropSet _GET_PROP_SET_AT_COORDS(Hash propsetHash, float x, float y, float z) { return invoke<PropSet>(0xC061E50F8D299F95, propsetHash, x, y, z); } // 0xC061E50F8D299F95 b1207
	NATIVE_DECL PropSet _GET_PROP_SET_AT_COORDS(Hash propsetHash, Vector3 vec) { return invoke<PropSet>(0xC061E50F8D299F95, propsetHash, vec.x, vec.y, vec.z); } // 0xC061E50F8D299F95 b1207
}

namespace QUEUE
{
	NATIVE_DECL BOOL _EVENT_QUEUE_IS_EMPTY(Hash hash) { return invoke<BOOL>(0x402B5D7D269FF796, hash); } // 0x402B5D7D269FF796 b1207
	NATIVE_DECL void _EVENT_QUEUE_POP(Hash hash) { invoke<Void>(0xD87DF294B049211D, hash); } // 0xD87DF294B049211D b1207
}

namespace RECORDING
{
	// nullsub, doesn't do anything
	NATIVE_DECL void _STOP_RECORDING_THIS_FRAME() { invoke<Void>(0xA8C44C13419634F2); } // 0xA8C44C13419634F2 b1207
}

namespace REPLAY
{
	// Hardcoded to return false.
	NATIVE_DECL BOOL _IS_INTERIOR_RENDERING_DISABLED() { return invoke<BOOL>(0x0F838D47DE58EDB2); } // 0x0F838D47DE58EDB2 b1207
	// nullsub, doesn't do anything
	NATIVE_DECL void _0x57C6525034E76EB0() { invoke<Void>(0x57C6525034E76EB0); } // 0x57C6525034E76EB0 b1207
	// Hardcoded to return true.
	NATIVE_DECL BOOL OPEN_VIDEO_EDITOR() { return invoke<BOOL>(0xB3F2829907403C13); } // 0xB3F2829907403C13 b1207
	// Hardcoded to return true.
	NATIVE_DECL BOOL CLOSE_VIDEO_EDITOR(Any p0) { return invoke<BOOL>(0xCEEC64BD27A59312, p0); } // 0xCEEC64BD27A59312 b1207
	// Hardcoded to return false.
	NATIVE_DECL BOOL IS_VIDEO_EDITOR_RUNNING() { return invoke<BOOL>(0x9EEB007317FA3B9C); } // 0x9EEB007317FA3B9C b1207
}

namespace SCRIPTS
{
	NATIVE_DECL void _SET_PLAYER_BIT_AT_INDEX(Any* value, int bitIndex) { invoke<Void>(0x31010318BA9897AC, value, bitIndex); } // 0x31010318BA9897AC b1207
	NATIVE_DECL void _CLEAR_PLAYER_BIT_AT_INDEX(Any* value, int bitIndex) { invoke<Void>(0xD426E2E3288469D6, value, bitIndex); } // 0xD426E2E3288469D6 b1207
	NATIVE_DECL void _0xE4ABE20DCE7C7CFE(Any p0, Any p1, Any p2) { invoke<Void>(0xE4ABE20DCE7C7CFE, p0, p1, p2); } // 0xE4ABE20DCE7C7CFE b1207
	NATIVE_DECL void _0xFFDDF802279BE128(Any p0, Any p1, Any p2) { invoke<Void>(0xFFDDF802279BE128, p0, p1, p2); } // 0xFFDDF802279BE128 b1207
	NATIVE_DECL void _0x64F765D9A1F8F02C(Any p0, Any p1, Any p2) { invoke<Void>(0x64F765D9A1F8F02C, p0, p1, p2); } // 0x64F765D9A1F8F02C b1207
	NATIVE_DECL void _SET_ALL_PLAYER_BITS(Any* value) { invoke<Void>(0x20F4CB76689ACDBC, value); } // 0x20F4CB76689ACDBC b1207
	NATIVE_DECL void _CLEAR_ALL_PLAYER_BITS(Any* value) { invoke<Void>(0xDE544B7EC0C187CC, value); } // 0xDE544B7EC0C187CC b1207
	NATIVE_DECL Any _0x72B2E00C9BAC6789(Any p0, Any p1) { return invoke<Any>(0x72B2E00C9BAC6789, p0, p1); } // 0x72B2E00C9BAC6789 b1207
	NATIVE_DECL BOOL _IS_ANY_PLAYER_BIT_SET(int* playerBits) { return invoke<BOOL>(0x179A6F0EE2E79026, playerBits); } // 0x179A6F0EE2E79026 b1207
	NATIVE_DECL int GET_BLOCK_OF_PLAYER_BITS(Any* value, int p1) { return invoke<int>(0xFA3B530A5CC693D5, value, p1); } // 0xFA3B530A5CC693D5 b1207
	NATIVE_DECL void SET_BLOCK_OF_PLAYER_BITS(Any* value, int p1, int p2) { invoke<Void>(0xC6DFB8C04C86D5A5, value, p1, p2); } // 0xC6DFB8C04C86D5A5 b1207
	NATIVE_DECL int COUNT_PLAYER_BITS(Any* value) { return invoke<int>(0x462C687BEA254BD9, value); } // 0x462C687BEA254BD9 b1207
	NATIVE_DECL void _0x1BDB5A07307F6929(Any p0, Any p1) { invoke<Void>(0x1BDB5A07307F6929, p0, p1); } // 0x1BDB5A07307F6929 b1207
	NATIVE_DECL void _0x1C5EB3C27F7508CB(Any p0, Any p1) { invoke<Void>(0x1C5EB3C27F7508CB, p0, p1); } // 0x1C5EB3C27F7508CB b1207
	NATIVE_DECL void _0x42A429CDFED6D99D(Any p0, Any p1, Any p2) { invoke<Void>(0x42A429CDFED6D99D, p0, p1, p2); } // 0x42A429CDFED6D99D b1207
	NATIVE_DECL void _0x5827BE85A87B073D(Any p0) { invoke<Void>(0x5827BE85A87B073D, p0); } // 0x5827BE85A87B073D b1207
	NATIVE_DECL Any _0x0A79C81C418F5D38(Any p0, Any p1) { return invoke<Any>(0x0A79C81C418F5D38, p0, p1); } // 0x0A79C81C418F5D38 b1207
	NATIVE_DECL Any _0xA88E1D7FA1E20080(Any p0) { return invoke<Any>(0xA88E1D7FA1E20080, p0); } // 0xA88E1D7FA1E20080 b1207
	NATIVE_DECL int COUNT_PARTICIPANT_BITS(Any* value) { return invoke<int>(0x2F050A3FF8738245, value); } // 0x2F050A3FF8738245 b1207
	NATIVE_DECL void REQUEST_SCRIPT(const char* scriptName) { invoke<Void>(0x46ED607DDD40D7FE, scriptName); } // 0x46ED607DDD40D7FE 0xE26B2666 b1207
	NATIVE_DECL void SET_SCRIPT_AS_NO_LONGER_NEEDED(const char* scriptName) { invoke<Void>(0x0086D3067E1CFD1C, scriptName); } // 0x0086D3067E1CFD1C 0x6FCB7795 b1207
	// Returns if a script has been loaded into the game. Used to see if a script was loaded after requesting.
	NATIVE_DECL BOOL HAS_SCRIPT_LOADED(const char* scriptName) { return invoke<BOOL>(0xE97BD36574F8B0A6, scriptName); } // 0xE97BD36574F8B0A6 0x5D67F751 b1207
	NATIVE_DECL BOOL DOES_SCRIPT_EXIST(const char* scriptName) { return invoke<BOOL>(0x552B171E3F69E5AE, scriptName); } // 0x552B171E3F69E5AE 0xDEAB87AB b1207
	NATIVE_DECL void REQUEST_SCRIPT_WITH_NAME_HASH(Hash scriptHash) { invoke<Void>(0xF6B9CE3F8D5B9B74, scriptHash); } // 0xF6B9CE3F8D5B9B74 0x1C68D9DC b1207
	NATIVE_DECL void SET_SCRIPT_WITH_NAME_HASH_AS_NO_LONGER_NEEDED(Hash scriptHash) { invoke<Void>(0x50723A1567C8361E, scriptHash); } // 0x50723A1567C8361E 0x96C26F66 b1207
	NATIVE_DECL BOOL HAS_SCRIPT_WITH_NAME_HASH_LOADED(Hash scriptHash) { return invoke<BOOL>(0xA5D8E0C2F3C7EEBC, scriptHash); } // 0xA5D8E0C2F3C7EEBC 0x06674818 b1207
	NATIVE_DECL BOOL DOES_SCRIPT_WITH_NAME_HASH_EXIST(Hash scriptHash) { return invoke<BOOL>(0xA34E89749F628284, scriptHash); } // 0xA34E89749F628284 0x19EAE282 b1207
	NATIVE_DECL void TERMINATE_THREAD(int threadId) { invoke<Void>(0x87ED52AE40EA1A52, threadId); } // 0x87ED52AE40EA1A52 0x253FD520 b1207
	NATIVE_DECL BOOL IS_THREAD_ACTIVE(int threadId, BOOL ignoreKilledState) { return invoke<BOOL>(0x46E9AE36D8FA6417, threadId, ignoreKilledState); } // 0x46E9AE36D8FA6417 0x78D7A5A0 b1207
	NATIVE_DECL BOOL DOES_THREAD_EXIST(int threadId) { return invoke<BOOL>(0xFF975BC4435A0FA3, threadId); } // 0xFF975BC4435A0FA3 b1207
	NATIVE_DECL void GET_THREAD_EXISTENCE_DETAILS(int threadId, BOOL* threadExists, BOOL* hasScriptHandler) { invoke<Void>(0xD92FA81B64920E85, threadId, threadExists, hasScriptHandler); } // 0xD92FA81B64920E85 b1207
	NATIVE_DECL Hash _GET_HASH_OF_THREAD(int threadId) { return invoke<Hash>(0x724CB89D35B283D0, threadId); } // 0x724CB89D35B283D0 b1207
	// Starts a new iteration of the current threads.
	// Call this first, then SCRIPT_THREAD_ITERATOR_GET_NEXT_THREAD_ID (0x30B4FA1C82DD4B9F)
	NATIVE_DECL void SCRIPT_THREAD_ITERATOR_RESET() { invoke<Void>(0x39382EB8DCD8684D); } // 0x39382EB8DCD8684D 0xBB4E2F66 b1207
	// If the function returns 0, the end of the iteration has been reached.
	NATIVE_DECL int SCRIPT_THREAD_ITERATOR_GET_NEXT_THREAD_ID() { return invoke<int>(0x3CE3FB167E837D7C); } // 0x3CE3FB167E837D7C 0x1E28B28F b1207
	NATIVE_DECL BOOL _IS_BACKGROUND_SCRIPT(int threadId) { return invoke<BOOL>(0x20B7F69B40C6B755, threadId); } // 0x20B7F69B40C6B755 b1207
	NATIVE_DECL int GET_ID_OF_THIS_THREAD() { return invoke<int>(0x55525C346BEF6960); } // 0x55525C346BEF6960 0xDE524830 b1207
	NATIVE_DECL void TERMINATE_THIS_THREAD() { invoke<Void>(0x5E8B6D17FF91CD59); } // 0x5E8B6D17FF91CD59 0x3CD9CBB7 b1207
	// Gets the number of instances of the specified script is currently running.
	// 
	// Actually returns numRefs - 1.
	// if (program)
	// 	v3 = rage::scrProgram::GetNumRefs(program) - 1;
	// return v3;
	NATIVE_DECL int _GET_NUMBER_OF_REFERENCES_OF_SCRIPT_WITH_NAME_HASH(Hash scriptHash) { return invoke<int>(0x8E34C953364A76DD, scriptHash); } // 0x8E34C953364A76DD 0x029D3841 b1207
	NATIVE_DECL void _REQUEST_THREAD_EXIT(int threadId) { invoke<Void>(0x7DE4643157AD646C, threadId); } // 0x7DE4643157AD646C b1207
	NATIVE_DECL void _REQUEST_THREAD_EXIT_FOR_ALL_THREADS_WITH_THIS_NAME(Hash nameHash) { invoke<Void>(0x7423F7835770F619, nameHash); } // 0x7423F7835770F619 b1207
	NATIVE_DECL BOOL IS_THREAD_EXIT_REQUESTED() { return invoke<BOOL>(0x9E4EF615E307FBBE); } // 0x9E4EF615E307FBBE b1207
	NATIVE_DECL BOOL _IS_THREAD_EXIT_REQUESTED_FOR_THREAD_WITH_THIS_ID(int threadId) { return invoke<BOOL>(0x30BED53646C86D11, threadId); } // 0x30BED53646C86D11 b1207
	// enum eThreadExitReason
	// {
	// 	THREAD_EXIT_REASON_NONE,
	// 	THREAD_EXIT_REASON_BACKGROUND_THREAD_STOPPED,
	// 	THREAD_EXIT_REASON_SESSION_MERGE,
	// 	THREAD_EXIT_REASON_SCENARIO_OUT_OF_SCOPE,
	// 	THREAD_EXIT_REASON_REQUESTED_BY_SCRIPT
	// };
	NATIVE_DECL int _GET_THREAD_EXIT_REASON() { return invoke<int>(0x54AE4FDEEFEAB77E); } // 0x54AE4FDEEFEAB77E b1207
	NATIVE_DECL Hash GET_HASH_OF_THIS_SCRIPT_NAME() { return invoke<Hash>(0xBC2C927F5C264960); } // 0xBC2C927F5C264960 0x2BEE1F45 b1207
	// eventGroup: 0 = SCRIPT_EVENT_QUEUE_AI (CEventGroupScriptAI), 1 = SCRIPT_EVENT_QUEUE_NETWORK (CEventGroupScriptNetwork), 2 = unk, 3 = unk, 4 = SCRIPT_EVENT_QUEUE_ERRORS (CEventGroupScriptErrors)
	NATIVE_DECL int GET_NUMBER_OF_EVENTS(int eventGroup) { return invoke<int>(0x5CE8DE5909565748, eventGroup); } // 0x5CE8DE5909565748 0xA3525D60 b1207
	// eventGroup: 0 = SCRIPT_EVENT_QUEUE_AI (CEventGroupScriptAI), 1 = SCRIPT_EVENT_QUEUE_NETWORK (CEventGroupScriptNetwork), 2 = unk, 3 = unk, 4 = SCRIPT_EVENT_QUEUE_SCRIPT_ERRORS (CEventGroupScriptErrors)
	NATIVE_DECL BOOL GET_EVENT_EXISTS(int eventGroup, int eventIndex) { return invoke<BOOL>(0xC9F59C0A710ECD34, eventGroup, eventIndex); } // 0xC9F59C0A710ECD34 0xA1B447B5 b1207
	// eventGroup: 0 = SCRIPT_EVENT_QUEUE_AI (CEventGroupScriptAI), 1 = SCRIPT_EVENT_QUEUE_NETWORK (CEventGroupScriptNetwork), 2 = unk, 3 = unk, 4 = SCRIPT_EVENT_QUEUE_SCRIPT_ERRORS (CEventGroupScriptErrors)
	// 
	// Returns event name hash: https://alloc8or.re/rdr3/doc/enums/eEventType.txt
	NATIVE_DECL Hash GET_EVENT_AT_INDEX(int eventGroup, int eventIndex) { return invoke<Hash>(0xA85E614430EFF816, eventGroup, eventIndex); } // 0xA85E614430EFF816 0xB49C1442 b1207
	// eventGroup: 0 = SCRIPT_EVENT_QUEUE_AI (CEventGroupScriptAI), 1 = SCRIPT_EVENT_QUEUE_NETWORK (CEventGroupScriptNetwork), 2 = unk, 3 = unk, 4 = SCRIPT_EVENT_QUEUE_SCRIPT_ERRORS (CEventGroupScriptErrors)
	// 
	// Note: eventDataSize is NOT the size in bytes, it is the size determined by the SIZE_OF operator (RAGE Script operator, not C/C++ sizeof). That is, the size in bytes divided by 8 (script variables are always 8-byte aligned!).
	// 
	// https://github.com/femga/rdr3_discoveries/tree/master/AI/EVENTS
	NATIVE_DECL BOOL GET_EVENT_DATA(int eventGroup, int eventIndex, Any* eventData, int eventDataSize) { return invoke<BOOL>(0x57EC5FA4D4D6AFCA, eventGroup, eventIndex, eventData, eventDataSize); } // 0x57EC5FA4D4D6AFCA 0x4280F92F b1207
	NATIVE_DECL void SET_EVENT_FLAG_FOR_DELETION(int eventGroup, int eventIndex, BOOL p2) { invoke<Void>(0x4768D5252EAEB76F, eventGroup, eventIndex, p2); } // 0x4768D5252EAEB76F b1207
	// eventGroup: 0 = SCRIPT_EVENT_QUEUE_AI (CEventGroupScriptAI), 1 = SCRIPT_EVENT_QUEUE_NETWORK (CEventGroupScriptNetwork), 2 = unk, 3 = unk, 4 = SCRIPT_EVENT_QUEUE_SCRIPT_ERRORS (CEventGroupScriptErrors)
	// 
	// Note: eventDataSize is NOT the size in bytes, it is the size determined by the SIZE_OF operator (RAGE Script operator, not C/C++ sizeof). That is, the size in bytes divided by 8 (script variables are always 8-byte aligned!).
	// 
	// playerBits (also known as playersToBroadcastTo) is a bitset that indicates which players this event should be sent to. In order to send the event to specific players only, use (1 << playerIndex). Set all bits if it should be broadcast to all players.
	NATIVE_DECL void TRIGGER_SCRIPT_EVENT(int eventGroup, Any* eventData, int eventDataSize, int scriptMetadataIndex, int* playerBits) { invoke<Void>(0x5AE99C571D5BBE5D, eventGroup, eventData, eventDataSize, scriptMetadataIndex, playerBits); } // 0x5AE99C571D5BBE5D 0x54763B35 b1207
	NATIVE_DECL void _TRIGGER_SCRIPT_EVENT_2(Any* eventData, int eventDataSize, int scriptMetadataIndex, int threadId) { invoke<Void>(0x8B61C950A148FFA2, eventData, eventDataSize, scriptMetadataIndex, threadId); } // 0x8B61C950A148FFA2 b1207
	NATIVE_DECL Any _0xE7282390542F570D(Any p0) { return invoke<Any>(0xE7282390542F570D, p0); } // 0xE7282390542F570D b1207
	// Used in Script Function DISABLE_REGISTERED_WORLD_BRAINS
	NATIVE_DECL void _0x11B0A0B282FA9B10(BOOL p0) { invoke<Void>(0x11B0A0B282FA9B10, p0); } // 0x11B0A0B282FA9B10 b1207
	NATIVE_DECL void _0x6F700A4BF7C3331B(BOOL p0) { invoke<Void>(0x6F700A4BF7C3331B, p0); } // 0x6F700A4BF7C3331B b1207
	NATIVE_DECL void _0xF9E951A1E5517C06() { invoke<Void>(0xF9E951A1E5517C06); } // 0xF9E951A1E5517C06 b1207
	NATIVE_DECL void _0x76CBCD9EADC00955() { invoke<Void>(0x76CBCD9EADC00955); } // 0x76CBCD9EADC00955 b1207
	NATIVE_DECL void SHUTDOWN_LOADING_SCREEN() { invoke<Void>(0xFC179D7E8886DADF); } // 0xFC179D7E8886DADF 0xA2826D17 b1207
	NATIVE_DECL void SET_NO_LOADING_SCREEN(BOOL toggle) { invoke<Void>(0x5CB83156AA038F95, toggle); } // 0x5CB83156AA038F95 0xC8055034 b1207
	NATIVE_DECL BOOL GET_NO_LOADING_SCREEN() { return invoke<BOOL>(0x323DAF00687E0F28); } // 0x323DAF00687E0F28 0x27512BA0 b1207
	NATIVE_DECL void _DISPLAY_LOADING_SCREENS(Hash p0, Hash p1, Hash p2, const char* gamemodeName, const char* title, const char* subtitle) { invoke<Void>(0x1E5B70E53DB661E5, p0, p1, p2, gamemodeName, title, subtitle); } // 0x1E5B70E53DB661E5 b1207
	NATIVE_DECL void _0x29FB4CE89472C3CB(Any p0, Any p1, Any p2, Any p3, Any p4, Any p5, Any p6, Any p7) { invoke<Void>(0x29FB4CE89472C3CB, p0, p1, p2, p3, p4, p5, p6, p7); } // 0x29FB4CE89472C3CB b1207
	NATIVE_DECL void STOP_DISPLAYING_MP_TRANSITION_LOADING_SCREENS(Any p0) { invoke<Void>(0x778D4733E0F2F265, p0); } // 0x778D4733E0F2F265 b1207
	// Same as GET_IS_LOADING_SCREEN_ACTIVE
	NATIVE_DECL BOOL IS_LOADING_SCREEN_VISIBLE() { return invoke<BOOL>(0xB54ADBE65D528FCB); } // 0xB54ADBE65D528FCB b1207
	NATIVE_DECL void BAIL_TO_LANDING_PAGE(int bailCode) { invoke<Void>(0xBC2C927F5C264243, bailCode); } // 0xBC2C927F5C264243 b1207
	NATIVE_DECL void BAIL_WITH_PASS_THROUGH_PARAMS(const char* params) { invoke<Void>(0xE98204D3C25AE14C, params); } // 0xE98204D3C25AE14C b1207
	// Returns true if GtaThread+0x77C is equal to 1.
	NATIVE_DECL BOOL _BG_EXITED_BECAUSE_BACKGROUND_THREAD_STOPPED() { return invoke<BOOL>(0x2238EC3EC631AB1F); } // 0x2238EC3EC631AB1F 0x22B9F132 b1207
	// Sets bit 0 in GtaThread+0x784
	NATIVE_DECL void _0x4858148E3B8A75D0() { invoke<Void>(0x4858148E3B8A75D0); } // 0x4858148E3B8A75D0 0x5C95B670 b1207
	// Hashed version of BG_START_CONTEXT
	NATIVE_DECL void BG_START_CONTEXT_HASH(Hash contextHash) { invoke<Void>(0x2EB67D564DCC09D5, contextHash); } // 0x2EB67D564DCC09D5 0x67B23E17 b1207
	// Hashed version of BG_END_CONTEXT
	NATIVE_DECL void BG_END_CONTEXT_HASH(Hash contextHash) { invoke<Void>(0x6D1431744182CDE8, contextHash); } // 0x6D1431744182CDE8 0x3D981EBF b1207
	// Inserts the given context into the background scripts context map.
	NATIVE_DECL void BG_START_CONTEXT(const char* contextName) { invoke<Void>(0x49BA5678BA040CA7, contextName); } // 0x49BA5678BA040CA7 0xF3F1D953 b1207
	// Deletes the given context from the background scripts context map.
	NATIVE_DECL void BG_END_CONTEXT(const char* contextName) { invoke<Void>(0x3ABF7BA1C3E2C8CF, contextName); } // 0x3ABF7BA1C3E2C8CF 0x11F38FB3 b1207
	// BG_*
	NATIVE_DECL BOOL _0x4AE1DFF337A86FDE(int scriptIndex, const char* p1) { return invoke<BOOL>(0x4AE1DFF337A86FDE, scriptIndex, p1); } // 0x4AE1DFF337A86FDE 0xF8E5F73A b1207
	// BG_*
	NATIVE_DECL int _0x55C40B7592BAD213(int scriptIndex, const char* p1) { return invoke<int>(0x55C40B7592BAD213, scriptIndex, p1); } // 0x55C40B7592BAD213 0x682CB7E1 b1207
	// BG_*
	NATIVE_DECL int _0x829CD22E043A2577(Hash p0) { return invoke<int>(0x829CD22E043A2577, p0); } // 0x829CD22E043A2577 0xC515E735 b1207
	NATIVE_DECL void _BG_RELOAD_ALL_BACKGROUND_SCRIPTS() { invoke<Void>(0xBE7D814CFA181B56); } // 0xBE7D814CFA181B56 b1207
	// goalContext: see <availableContexts> in common/data/stats_and_challenges/goals_*.meta
	NATIVE_DECL void _ACTIVATE_GOAL_CONTEXT(Hash goalContext) { invoke<Void>(0x7D654266025E921B, goalContext); } // 0x7D654266025E921B b1207
	// goalContext: see _ACTIVATE_GOAL_CONTEXT
	NATIVE_DECL void _DEACTIVATE_GOAL_CONTEXT(Hash goalContext) { invoke<Void>(0x50B72A754EE64A71, goalContext); } // 0x50B72A754EE64A71 b1207
	// goalContext: see _ACTIVATE_GOAL_CONTEXT
	NATIVE_DECL BOOL _IS_GOAL_CONTEXT_ACTIVE(Hash goalContext) { return invoke<BOOL>(0x7409669C5ED50144, goalContext); } // 0x7409669C5ED50144 b1207
	// Returns "INVALID_NET_RPC_GUID" if netRpcGuid is invalid.
	NATIVE_DECL const char* _NET_RPC_GUID_TO_STRING(Any* netRpcGuid) { return invoke<const char*>(0xAC9FF854BD4BA9B5, netRpcGuid); } // 0xAC9FF854BD4BA9B5 b1311
	NATIVE_DECL BOOL AWARDS_GET_RESULT_ITEM(Any* rpcGuid, Hash awardHash, int itemIndex, Any* outResultItem) { return invoke<BOOL>(0xAC8FAB22A914AE34, rpcGuid, awardHash, itemIndex, outResultItem); } // 0xAC8FAB22A914AE34 b1207
	NATIVE_DECL BOOL _AWARDS_GET_UNLOCK_CLAIM_DATA(Any* rpcGuid, Hash awardHash, int dataIndex, Any* outUnlockData) { return invoke<BOOL>(0xB9467E41DAB1CF2C, rpcGuid, awardHash, dataIndex, outUnlockData); } // 0xB9467E41DAB1CF2C b1207
	NATIVE_DECL BOOL _LOOT_GET_RESULT_ITEM(Any* rpcGuid, int itemIndex, Any* outResultItem) { return invoke<BOOL>(0x4293B44A855F82CC, rpcGuid, itemIndex, outResultItem); } // 0x4293B44A855F82CC b1207
	NATIVE_DECL BOOL _LOOT_GET_LOOT_CLAIM_DATA(Any* rpcGuid, int dataIndex, Any* outLootData) { return invoke<BOOL>(0xF1E9045F5AA9E428, rpcGuid, dataIndex, outLootData); } // 0xF1E9045F5AA9E428 b1311
	NATIVE_DECL BOOL _STORE_GLOBAL_BLOCK(int index) { return invoke<BOOL>(0xB952A3AC41D58F2F, index); } // 0xB952A3AC41D58F2F b1207
	NATIVE_DECL BOOL _RESTORE_GLOBAL_BLOCK(int index) { return invoke<BOOL>(0xDC3914A99B4A5FDF, index); } // 0xDC3914A99B4A5FDF b1207
	NATIVE_DECL BOOL _DOES_COMPRESSED_GLOBAL_BLOCK_BUFFER_EXIST(int index) { return invoke<BOOL>(0x66EE5B93C308F734, index); } // 0x66EE5B93C308F734 b1207
	NATIVE_DECL void _SET_GLOBAL_BLOCK_CAN_BE_ACCESSED(int index, BOOL toggle) { invoke<Void>(0xE66F392BFCE734AF, index, toggle); } // 0xE66F392BFCE734AF b1207
	NATIVE_DECL BOOL _GET_GLOBAL_BLOCK_CAN_BE_ACCESSED(int index) { return invoke<BOOL>(0x42A7EB5C814C2DE0, index); } // 0x42A7EB5C814C2DE0 b1207
	NATIVE_DECL void _SET_ALL_GLOBAL_BLOCKS_HAVE_BEEN_LOADED(BOOL toggle) { invoke<Void>(0x11986B05885564D2, toggle); } // 0x11986B05885564D2 b1207
	// Waiting for child scripts to terminate / waiting for collapse of child scripts
	NATIVE_DECL BOOL HAVE_ALL_CHILD_SCRIPTS_TERMINATED(int p0) { return invoke<BOOL>(0x380FFA15B72408FB, p0); } // 0x380FFA15B72408FB b1207
	NATIVE_DECL int START_NEW_SCRIPT(const char* scriptName, int stackSize) { return invoke<int>(0xE81651AD79516E48, scriptName, stackSize); } // 0xE81651AD79516E48 0x3F166D0E b1207
	// return : script thread id, 0 if failed
	// Pass pointer to struct of args in p1, size of struct goes into p2
	NATIVE_DECL int START_NEW_SCRIPT_WITH_ARGS(const char* scriptName, Any* args, int argCount, int stackSize) { return invoke<int>(0xB8BA7F44DF1575E1, scriptName, args, argCount, stackSize); } // 0xB8BA7F44DF1575E1 0x4A2100E4 b1207
	NATIVE_DECL int START_NEW_SCRIPT_WITH_NAME_HASH(Hash scriptHash, int stackSize) { return invoke<int>(0xEB1C67C3A5333A92, scriptHash, stackSize); } // 0xEB1C67C3A5333A92 0x8D15BE5D b1207
	NATIVE_DECL int START_NEW_SCRIPT_WITH_NAME_HASH_AND_ARGS(Hash scriptHash, Any* args, int argCount, int stackSize) { return invoke<int>(0xC4BB298BD441BE78, scriptHash, args, argCount, stackSize); } // 0xC4BB298BD441BE78 0xE38A3AD4 b1207
}

namespace SAVE
{
	NATIVE_DECL void _0x4FB5869E2B37FC00() { invoke<Void>(0x4FB5869E2B37FC00); } // 0x4FB5869E2B37FC00 b1207
	// enum eSavegameType : Hash
	// {
	// 	SAVEGAMETYPE_AMBIENT = 0x3CA4E1F8,
	// 	SAVEGAMETYPE_DEFAULT = 0xCB6ED080,
	// 	SAVEGAMETYPE_DELETE_CHAR = 0xCD35F947,
	// 	SAVEGAMETYPE_END_CREATE_NEWCHAR = 0x4C50A3CE,
	// 	SAVEGAMETYPE_END_MATCH = 0xE470ED50,
	// 	SAVEGAMETYPE_END_MISSION = 0x9A444E54,
	// 	SAVEGAMETYPE_END_SESSION = 0x6D23956C,
	// 	SAVEGAMETYPE_END_SHOPPING = 0xA311A6C4,
	// 	SAVEGAMETYPE_RANKUP = 0xE25F8017,
	// 	SAVEGAMETYPE_SCRIPT_MP_GLOBALS = 0xAFF30AD4,
	// 	SAVEGAMETYPE_SP_AUTOSAVE = 0xF4AE69EC,
	// 	SAVEGAMETYPE_SP_DEBUG = 0x6A8122FD,
	// 	SAVEGAMETYPE_SP_PROPERTY = 0xAE0AB38E
	// };
	NATIVE_DECL BOOL SAVEGAME_SAVE_SP(Hash savegameType) { return invoke<BOOL>(0x62C9EB51656D68CE, savegameType); } // 0x62C9EB51656D68CE b1207
	// See SAVEGAME_SAVE_SP
	NATIVE_DECL BOOL SAVEGAME_SAVE_MP(Hash savegameType) { return invoke<BOOL>(0x1840F3B30ED0105F, savegameType); } // 0x1840F3B30ED0105F b1207
	NATIVE_DECL BOOL SAVEGAME_IS_SAVE_PENDING() { return invoke<BOOL>(0x3CF46F55C6585590); } // 0x3CF46F55C6585590 b1207
	NATIVE_DECL Any _0x1431540BCA1A1BD2() { return invoke<Any>(0x1431540BCA1A1BD2); } // 0x1431540BCA1A1BD2 b1207
	NATIVE_DECL Any _0xA7ECEBAFBAF997A5(Hash savegameType) { return invoke<Any>(0xA7ECEBAFBAF997A5, savegameType); } // 0xA7ECEBAFBAF997A5 b1436
	NATIVE_DECL void _0xED4B0C1057892B2E(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xED4B0C1057892B2E, p0, p1, p2, p3); } // 0xED4B0C1057892B2E b1207
	NATIVE_DECL void _0x9BB83C4DD7BE0802(Any p0, Any p1, Any p2, Any p3, Any p4) { invoke<Void>(0x9BB83C4DD7BE0802, p0, p1, p2, p3, p4); } // 0x9BB83C4DD7BE0802 b1207
	NATIVE_DECL void _0xE8346E62FD7FB962() { invoke<Void>(0xE8346E62FD7FB962); } // 0xE8346E62FD7FB962 b1207
	NATIVE_DECL void _0xC0ABF784590798A9(Any p0) { invoke<Void>(0xC0ABF784590798A9, p0); } // 0xC0ABF784590798A9 b1207
	NATIVE_DECL Any _0xB00CE33465B5406D(Any p0, Any p1) { return invoke<Any>(0xB00CE33465B5406D, p0, p1); } // 0xB00CE33465B5406D b1207
	NATIVE_DECL void _0x529B9CCD0972AF4D(Any p0, Any p1) { invoke<Void>(0x529B9CCD0972AF4D, p0, p1); } // 0x529B9CCD0972AF4D b1207
	NATIVE_DECL void _0x529B9CCD0972AF4E(Any p0, Any p1) { invoke<Void>(0x529B9CCD0972AF4E, p0, p1); } // 0x529B9CCD0972AF4E b1207
	NATIVE_DECL void _0xB25B5A375BE5BE26(Any p0, Any p1) { invoke<Void>(0xB25B5A375BE5BE26, p0, p1); } // 0xB25B5A375BE5BE26 b1207
	NATIVE_DECL void _0x35DEFECAE36D4FAE(Any p0, Any p1) { invoke<Void>(0x35DEFECAE36D4FAE, p0, p1); } // 0x35DEFECAE36D4FAE b1207
	NATIVE_DECL void _0xBB7F4273C186BC4B(Any p0, Any p1) { invoke<Void>(0xBB7F4273C186BC4B, p0, p1); } // 0xBB7F4273C186BC4B b1207
	NATIVE_DECL void _0x5A10D6506B2F2C63(Any p0, Any p1) { invoke<Void>(0x5A10D6506B2F2C63, p0, p1); } // 0x5A10D6506B2F2C63 b1207
	NATIVE_DECL void _0x4845E7E7643A908C(Any p0, Any p1) { invoke<Void>(0x4845E7E7643A908C, p0, p1); } // 0x4845E7E7643A908C b1207
	NATIVE_DECL void _0x186608A2AC6F9E88(Any p0, Any p1) { invoke<Void>(0x186608A2AC6F9E88, p0, p1); } // 0x186608A2AC6F9E88 b1207
	NATIVE_DECL void _0x443174C20B8B9E7F(Any p0, Any p1, Any p2) { invoke<Void>(0x443174C20B8B9E7F, p0, p1, p2); } // 0x443174C20B8B9E7F b1207
	NATIVE_DECL void _0x8E8FFB9E4AD051D2(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x8E8FFB9E4AD051D2, p0, p1, p2, p3); } // 0x8E8FFB9E4AD051D2 b1207
	NATIVE_DECL void _0xE0B45E983BFC0768() { invoke<Void>(0xE0B45E983BFC0768); } // 0xE0B45E983BFC0768 b1207
	NATIVE_DECL void _0x81F4E92BE3958364(Any p0, Any p1, Any p2) { invoke<Void>(0x81F4E92BE3958364, p0, p1, p2); } // 0x81F4E92BE3958364 b1207
	NATIVE_DECL void _0xA844FEB5C22C2C74() { invoke<Void>(0xA844FEB5C22C2C74); } // 0xA844FEB5C22C2C74 b1207
}

namespace SHAPETEST
{
	// Asynchronously starts a line-of-sight (raycast) world probe shape test.
	// 
	// Use the handle with 0x3D87450E15D98694 or 0x65287525D951F6BE until it returns 0 or 2.
	// 
	// p8 is a bit mask with bits 1, 2 and/or 4, relating to collider types; 4 should usually be used.
	NATIVE_DECL ScrHandle START_SHAPE_TEST_LOS_PROBE(float x1, float y1, float z1, float x2, float y2, float z2, int flags, Entity entity, int p8) { return invoke<ScrHandle>(0x7EE9F5D83DD4F90E, x1, y1, z1, x2, y2, z2, flags, entity, p8); } // 0x7EE9F5D83DD4F90E 0xEFAF4BA6 b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_LOS_PROBE(Vector3 vec1, Vector3 vec2, int flags, Entity entity, int p8) { return invoke<ScrHandle>(0x7EE9F5D83DD4F90E, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, flags, entity, p8); } // 0x7EE9F5D83DD4F90E 0xEFAF4BA6 b1207
	NATIVE_DECL Any _0x04AA59CA40571C2E(Any p0, Any p1) { return invoke<Any>(0x04AA59CA40571C2E, p0, p1); } // 0x04AA59CA40571C2E b1207
	// Does the same as 0x7EE9F5D83DD4F90E, except blocking until the shape test completes.
	NATIVE_DECL ScrHandle START_EXPENSIVE_SYNCHRONOUS_SHAPE_TEST_LOS_PROBE(float x1, float y1, float z1, float x2, float y2, float z2, int flags, Entity entityToIgnore, int p8) { return invoke<ScrHandle>(0x377906D8A31E5586, x1, y1, z1, x2, y2, z2, flags, entityToIgnore, p8); } // 0x377906D8A31E5586 0x8251485D b1207
	NATIVE_DECL ScrHandle START_EXPENSIVE_SYNCHRONOUS_SHAPE_TEST_LOS_PROBE(Vector3 vec1, Vector3 vec2, int flags, Entity entityToIgnore, int p8) { return invoke<ScrHandle>(0x377906D8A31E5586, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, flags, entityToIgnore, p8); } // 0x377906D8A31E5586 0x8251485D b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_BOX(float x, float y, float z, float x1, float y2, float z2, float rotX, float rotY, float rotZ, Any p9, Any p10, Any entity, Any p12) { return invoke<ScrHandle>(0xFE466162C4401D18, x, y, z, x1, y2, z2, rotX, rotY, rotZ, p9, p10, entity, p12); } // 0xFE466162C4401D18 0x249BC876 b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_BOX(Vector3 vec, float x1, float y2, float z2, Vector3 rot, Any p9, Any p10, Any entity, Any p12) { return invoke<ScrHandle>(0xFE466162C4401D18, vec.x, vec.y, vec.z, x1, y2, z2, rot.x, rot.y, rot.z, p9, p10, entity, p12); } // 0xFE466162C4401D18 0x249BC876 b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_CAPSULE(float x1, float y1, float z1, float x2, float y2, float z2, float radius, int flags, Entity entityToIgnore, int p9) { return invoke<ScrHandle>(0x28579D1B8F8AAC80, x1, y1, z1, x2, y2, z2, radius, flags, entityToIgnore, p9); } // 0x28579D1B8F8AAC80 0x591EA833 b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_CAPSULE(Vector3 vec1, Vector3 vec2, float radius, int flags, Entity entityToIgnore, int p9) { return invoke<ScrHandle>(0x28579D1B8F8AAC80, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, radius, flags, entityToIgnore, p9); } // 0x28579D1B8F8AAC80 0x591EA833 b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_SWEPT_SPHERE(float x1, float y1, float z1, float x2, float y2, float z2, float radius, int flags, Entity entity, Any p9) { return invoke<ScrHandle>(0xAA5B7C8309F73230, x1, y1, z1, x2, y2, z2, radius, flags, entity, p9); } // 0xAA5B7C8309F73230 0x4559460A b1207
	NATIVE_DECL ScrHandle START_SHAPE_TEST_SWEPT_SPHERE(Vector3 vec1, Vector3 vec2, float radius, int flags, Entity entity, Any p9) { return invoke<ScrHandle>(0xAA5B7C8309F73230, vec1.x, vec1.y, vec1.z, vec2.x, vec2.y, vec2.z, radius, flags, entity, p9); } // 0xAA5B7C8309F73230 0x4559460A b1207
	NATIVE_DECL ScrHandle _START_SHAPE_TEST_SURROUNDING_COORDS(Vector3* pVec1, Vector3* pVec2, int flag, Entity entity, int flag2) { return invoke<ScrHandle>(0x9839013D8B6014F1, pVec1, pVec2, flag, entity, flag2); } // 0x9839013D8B6014F1 b1207
	// Returns the result of a shape test: 0 if the handle is invalid, 1 if the shape test is still pending, or 2 if the shape test has completed, and the handle should be invalidated.
	// 
	// When used with an asynchronous shape test, this native should be looped until returning 0 or 2, after which the handle is invalidated.
	// 
	// enum eShapeTestStatus
	// {
	// 	SHAPETEST_STATUS_NONEXISTENT,
	// 	SHAPETEST_STATUS_RESULTS_NOTREADY,
	// 	SHAPETEST_STATUS_RESULTS_READY
	// };
	NATIVE_DECL int GET_SHAPE_TEST_RESULT(ScrHandle shapeTestHandle, BOOL* hit, Vector3* endCoords, Vector3* surfaceNormal, Entity* entityHit) { return invoke<int>(0xEDE8AC7C5108FB1D, shapeTestHandle, hit, endCoords, surfaceNormal, entityHit); } // 0xEDE8AC7C5108FB1D 0xF3C2875A b1207
}

namespace SOCIALCLUB
{
	NATIVE_DECL int SC_INBOX_GET_TOTAL_NUM_MESSAGES() { return invoke<int>(0x8EF0F633280C0663); } // 0x8EF0F633280C0663 0x6BE5DF29 b1207
	NATIVE_DECL Hash SC_INBOX_GET_MESSAGE_TYPE_AT_INDEX(int msgIndex) { return invoke<Hash>(0xFF92537C4DDC1241, msgIndex); } // 0xFF92537C4DDC1241 0x5ECF955D b1207
	NATIVE_DECL BOOL SC_INBOX_GET_MESSAGE_IS_READ_AT_INDEX(int msgIndex) { return invoke<BOOL>(0x74CF39E030A382C4, msgIndex); } // 0x74CF39E030A382C4 0xD1ED1D48 b1207
	NATIVE_DECL BOOL SC_INBOX_SET_MESSAGE_AS_READ_AT_INDEX(int msgIndex) { return invoke<BOOL>(0x63CAC501FFF66DC4, msgIndex); } // 0x63CAC501FFF66DC4 0x19EE0CCB b1207
	NATIVE_DECL BOOL SC_INBOX_MESSAGE_GET_DATA_INT(int p0, const char* context, int* out) { return invoke<BOOL>(0x95BB39C4DA99F348, p0, context, out); } // 0x95BB39C4DA99F348 0x88068C7C b1207
	NATIVE_DECL BOOL SC_INBOX_MESSAGE_GET_DATA_STRING(int p0, const char* context, char* out) { return invoke<BOOL>(0x66F77FD58506FF6B, p0, context, out); } // 0x66F77FD58506FF6B 0x15607620 b1207
	NATIVE_DECL const char* SC_INBOX_MESSAGE_GET_RAW_TYPE_AT_INDEX(int p0) { return invoke<const char*>(0x176D077685CD83E4, p0); } // 0x176D077685CD83E4 0x2C959AF9 b1207
	NATIVE_DECL BOOL SC_PRESENCE_ATTR_SET_FLOAT(Hash attrHash, float value) { return invoke<BOOL>(0xA31DAFCDC33775E9, attrHash, value); } // 0xA31DAFCDC33775E9 0x94BF0D35 b1207
	NATIVE_DECL BOOL SC_PRESENCE_ATTR_SET_INT_EX(const char* attrName, int value, BOOL p2) { return invoke<BOOL>(0x0000000085488C49, attrName, value, p2); } // 0x0000000085488C49 b1207
	NATIVE_DECL BOOL SC_PRESENCE_ATTR_SET_FLOAT_EX(const char* attrName, float value, BOOL p2) { return invoke<BOOL>(0x00000000467F4CAA, attrName, value, p2); } // 0x00000000467F4CAA b1207
	NATIVE_DECL BOOL SC_PRESENCE_ATTR_SET_STRING_EX(const char* attrName, const char* value, BOOL p2) { return invoke<BOOL>(0x00000000EB2D93B3, attrName, value, p2); } // 0x00000000EB2D93B3 b1207
	// Starts a task to check an entered string for profanity on the ROS/Social Club services.
	NATIVE_DECL BOOL SC_PROFANITY_CHECK_STRING(const char* string, int* token) { return invoke<BOOL>(0x9C74AC9D87B3FFF4, string, token); } // 0x9C74AC9D87B3FFF4 0xDF084A6B b1207
	NATIVE_DECL BOOL SC_PROFANITY_GET_CHECK_IS_VALID(int token) { return invoke<BOOL>(0x08C8052AF40C4247, token); } // 0x08C8052AF40C4247 0xFFED3676 b1207
	NATIVE_DECL BOOL SC_PROFANITY_GET_CHECK_IS_PENDING(int token) { return invoke<BOOL>(0x3A10BCD0C8AA0B82, token); } // 0x3A10BCD0C8AA0B82 0xA796D7A7 b1207
	NATIVE_DECL BOOL SC_PROFANITY_GET_STRING_PASSED(int token) { return invoke<BOOL>(0xF302973BB8BE70E6, token); } // 0xF302973BB8BE70E6 0x09497F31 b1207
	NATIVE_DECL int SC_PROFANITY_GET_STRING_STATUS(int token) { return invoke<int>(0x0CF3BFB99EBBE5B1, token); } // 0x0CF3BFB99EBBE5B1 0x4D8A6521 b1207
	NATIVE_DECL BOOL _0xCBF743C984695CF3() { return invoke<BOOL>(0xCBF743C984695CF3); } // 0xCBF743C984695CF3 0xC96456BA b1207
	NATIVE_DECL int _0xD635DF6BAA5A6017() { return invoke<int>(0xD635DF6BAA5A6017); } // 0xD635DF6BAA5A6017 0xC5E08B66 b1207
	NATIVE_DECL BOOL _0xB4411D4D6B81438E(const char* p0, int* p1) { return invoke<BOOL>(0xB4411D4D6B81438E, p0, p1); } // 0xB4411D4D6B81438E 0x04EE74A3 b1207
	NATIVE_DECL BOOL _0x060BBAD634C2B44B(const char* p0, float* p1) { return invoke<BOOL>(0x060BBAD634C2B44B, p0, p1); } // 0x060BBAD634C2B44B 0x8DA93C3D b1207
	NATIVE_DECL BOOL _0x9F6DCD0C939C71E9(const char* p0, char* p1) { return invoke<BOOL>(0x9F6DCD0C939C71E9, p0, p1); } // 0x9F6DCD0C939C71E9 0x37DD48B5 b1207
	NATIVE_DECL BOOL _0x89D9BDE7334B110F(char* p0) { return invoke<BOOL>(0x89D9BDE7334B110F, p0); } // 0x89D9BDE7334B110F 0xF929F61D b1207
	NATIVE_DECL BOOL _0x09937EB0CEBC2F9F(const char* p0) { return invoke<BOOL>(0x09937EB0CEBC2F9F, p0); } // 0x09937EB0CEBC2F9F 0x0572EB5E b1207
	NATIVE_DECL int _0x03C03ABBABBEF752(const char* p0) { return invoke<int>(0x03C03ABBABBEF752, p0); } // 0x03C03ABBABBEF752 0x8E7AEEB7 b1207
	NATIVE_DECL BOOL _0x3519CC3525319A96(const char* p0, int* p1, const char* p2) { return invoke<BOOL>(0x3519CC3525319A96, p0, p1, p2); } // 0x3519CC3525319A96 0x28C57FA0 b1207
	NATIVE_DECL BOOL _0x1BDB56DB258F052D(const char* p0, float* p1, const char* p2) { return invoke<BOOL>(0x1BDB56DB258F052D, p0, p1, p2); } // 0x1BDB56DB258F052D 0x59394583 b1207
	NATIVE_DECL BOOL _0xC8FC3B2432E8229D(const char* p0, char* p1, const char* p2) { return invoke<BOOL>(0xC8FC3B2432E8229D, p0, p1, p2); } // 0xC8FC3B2432E8229D 0x92452C0E b1207
	NATIVE_DECL BOOL _0x85EA0BEC7B1F7622(char* p0, const char* p1) { return invoke<BOOL>(0x85EA0BEC7B1F7622, p0, p1); } // 0x85EA0BEC7B1F7622 0xBBA8D34D b1207
	NATIVE_DECL BOOL _0x62B384FEFDE06817(int p0) { return invoke<BOOL>(0x62B384FEFDE06817, p0); } // 0x62B384FEFDE06817 0xB21288FA b1207
	NATIVE_DECL BOOL _0x7C981DE05A7403A0(int p0, const char* p1, int* p2) { return invoke<BOOL>(0x7C981DE05A7403A0, p0, p1, p2); } // 0x7C981DE05A7403A0 0xE778B2A7 b1207
	NATIVE_DECL BOOL _0x91C9E2A0F9DD6DD4(int p0, const char* p1, float* p2) { return invoke<BOOL>(0x91C9E2A0F9DD6DD4, p0, p1, p2); } // 0x91C9E2A0F9DD6DD4 0x7E24BD6E b1207
	NATIVE_DECL BOOL _0x049D2196D9D11184(int p0, const char* p1, char* p2) { return invoke<BOOL>(0x049D2196D9D11184, p0, p1, p2); } // 0x049D2196D9D11184 0xCE7D50A8 b1207
	NATIVE_DECL BOOL _0x11EA52CAD1B55910(int p0, char* p1) { return invoke<BOOL>(0x11EA52CAD1B55910, p0, p1); } // 0x11EA52CAD1B55910 0xD26CCA46 b1207
}

namespace SOCIALCLUBFEED
{
	NATIVE_DECL int _SC_FEED_SUBMIT_PRESET_MESSAGE(int type, int subType) { return invoke<int>(0xEFB64240F6B17817, type, subType); } // 0xEFB64240F6B17817 b1207
	NATIVE_DECL BOOL SC_FEED_HUB_HAS_NEW_DATA() { return invoke<BOOL>(0x068332D20CB6F897); } // 0x068332D20CB6F897 b1232
}

namespace SPACTIONPROXY
{
	NATIVE_DECL BOOL _SPACTIONPROXY_START_MANAGER() { return invoke<BOOL>(0x1F471B79ACC91BEE); } // 0x1F471B79ACC91BEE b1207
	NATIVE_DECL BOOL _SPACTIONPROXY_MANAGER_IS_READY() { return invoke<BOOL>(0x1F471B79ACC91BED); } // 0x1F471B79ACC91BED b1207
	NATIVE_DECL BOOL _SPACTIONPROXY_MANAGER_IS_FAILED() { return invoke<BOOL>(0x1F471B79ACC91BEC); } // 0x1F471B79ACC91BEC b1207
	NATIVE_DECL BOOL _SPACTIONPROXY_GET_NEXT_PENDING_CRAFTING_ACTION(Any* data) { return invoke<BOOL>(0x1F471B79ACC97BEF, data); } // 0x1F471B79ACC97BEF b1207
	NATIVE_DECL BOOL _SPACTIONPROXY_GET_NEXT_PENDING_BUY_ACTION(Any* data) { return invoke<BOOL>(0x1F471B79ACC98BEF, data); } // 0x1F471B79ACC98BEF b1207
	NATIVE_DECL BOOL _SPACTIONPROXY_PROCESS_ACTION(Any p0, BOOL p1) { return invoke<BOOL>(0x1F471B79ACC94BEF, p0, p1); } // 0x1F471B79ACC94BEF b1207
}

namespace STATS
{
	// struct StatId
	// {
	// 	alignas(8) Hash BaseId;
	// 	alignas(8) Hash PermutationId;
	// }
	NATIVE_DECL BOOL STAT_ID_IS_VALID(Any* statId) { return invoke<BOOL>(0xC48FE1971C9743FF, statId); } // 0xC48FE1971C9743FF b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_SET_INT(Any* statId, int value, BOOL p2) { return invoke<BOOL>(0xA4DDF5DF95E65EEE, statId, value, p2); } // 0xA4DDF5DF95E65EEE b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_SET_FLOAT(Any* statId, float value, BOOL p2) { return invoke<BOOL>(0x481BDF6A10C5EF68, statId, value, p2); } // 0x481BDF6A10C5EF68 b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_SET_BOOL(Any* statId, BOOL value, BOOL p2) { return invoke<BOOL>(0x3B5107353267D7A1, statId, value, p2); } // 0x3B5107353267D7A1 b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_SET_GXT_LABEL(Any* statId, const char* label, BOOL p2) { return invoke<BOOL>(0x05060A54834F2382, statId, label, p2); } // 0x05060A54834F2382 b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_SET_DATE(Any* statId, Any* date, BOOL p2) { return invoke<BOOL>(0x1FAE9B2FAA2DFE06, statId, date, p2); } // 0x1FAE9B2FAA2DFE06 b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_GET_INT(Any* statId, int* p1) { return invoke<BOOL>(0x767FBC2AC802EF3E, statId, p1); } // 0x767FBC2AC802EF3E b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_GET_FLOAT(Any* statId, float* value) { return invoke<BOOL>(0xD7AE6C9C9C6AC54D, statId, value); } // 0xD7AE6C9C9C6AC54D b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_GET_BOOL(Any* statId, BOOL* value) { return invoke<BOOL>(0x11B5E6D2AE73F48F, statId, value); } // 0x11B5E6D2AE73F48F b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL BOOL STAT_ID_GET_DATE(Any* statId, Any* date) { return invoke<BOOL>(0x8B0FACEFC36C824C, statId, date); } // 0x8B0FACEFC36C824C b1207
	NATIVE_DECL void _0x0FEE2561120F3333(Any* statId) { invoke<Void>(0x0FEE2561120F3333, statId); } // 0x0FEE2561120F3333 b1207
	NATIVE_DECL void _STAT_ID_INCREMENT_INT(Any* statId, int value) { invoke<Void>(0x6A0184E904CDF25E, statId, value); } // 0x6A0184E904CDF25E b1207
	NATIVE_DECL void _STAT_ID_INCREMENT_FLOAT(Any* statId, float value) { invoke<Void>(0x4A47E38EA3D60939, statId, value); } // 0x4A47E38EA3D60939 b1207
	NATIVE_DECL void _0xBD861AE8A5181ED7(Any* statId, Any p1) { invoke<Void>(0xBD861AE8A5181ED7, statId, p1); } // 0xBD861AE8A5181ED7 b1207
	NATIVE_DECL void _0x91A4F58E01ED5E4C(Any* p0, Any p1) { invoke<Void>(0x91A4F58E01ED5E4C, p0, p1); } // 0x91A4F58E01ED5E4C b1207
	NATIVE_DECL void _0xE141F6B40B1E3683(Any p0, Any p1) { invoke<Void>(0xE141F6B40B1E3683, p0, p1); } // 0xE141F6B40B1E3683 b1207
	// statId: see 0xC48FE1971C9743FF
	NATIVE_DECL void STAT_ID_SET_TO_POSSE_ID(Any* statId) { invoke<Void>(0x34B22DE38477EDB4, statId); } // 0x34B22DE38477EDB4 b1207
	NATIVE_DECL Any _0x1E7384AB5D4F4581(Any p0) { return invoke<Any>(0x1E7384AB5D4F4581, p0); } // 0x1E7384AB5D4F4581 b1207
	NATIVE_DECL Any _0x5420D398A42917FC(Any* p0, Any p1) { return invoke<Any>(0x5420D398A42917FC, p0, p1); } // 0x5420D398A42917FC b1311
	NATIVE_DECL void _STAT_ITEM_FISH_CAUGHT(Ped fish, float weight, Hash category, Hash subcategory) { invoke<Void>(0xDA26263C87CCE9C1, fish, weight, category, subcategory); } // 0xDA26263C87CCE9C1 b1207
	NATIVE_DECL void _0x831BF01C56149A8A(Any p0) { invoke<Void>(0x831BF01C56149A8A, p0); } // 0x831BF01C56149A8A b1207
	NATIVE_DECL void _0x7C2ABF6E556B21FC(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0x7C2ABF6E556B21FC, p0, p1, p2, p3); } // 0x7C2ABF6E556B21FC b1207
	NATIVE_DECL void _0x8312F09C56149A8A(Any p0) { invoke<Void>(0x8312F09C56149A8A, p0); } // 0x8312F09C56149A8A b1207
	NATIVE_DECL void _0x378D3B1B11D9385B(Any p0) { invoke<Void>(0x378D3B1B11D9385B, p0); } // 0x378D3B1B11D9385B b1207
	NATIVE_DECL void _0xDA26263C07CCE9C2(Any p0) { invoke<Void>(0xDA26263C07CCE9C2, p0); } // 0xDA26263C07CCE9C2 b1207
	NATIVE_DECL void _0xD64DBC8B0424135F(Any p0, Any p1) { invoke<Void>(0xD64DBC8B0424135F, p0, p1); } // 0xD64DBC8B0424135F b1207
	NATIVE_DECL void _0xA59590050F80FF2E(Any p0, Any p1, Any p2, Any p3) { invoke<Void>(0xA59590050F80FF2E, p0, p1, p2, p3); } // 0xA59590050F80FF2E b1207
	NATIVE_DECL void _0x90E9A5DADBABC918(Any p0) { invoke<Void>(0x90E9A5DADBABC918, p0); } // 0x90E9A5DADBABC91