# RED DEAD REDEMPTION 2 NOTES

*And detailed maps.*

# OVERVIEW

This is a collection of noted events and encounters, along with some observed numerical data and notes associated with said data. All information is based upon PC vanilla runs without mods (aside from RampageTrainer). Be aware, here's a few spoilers here and there, but nothing major.

**For map-related information, skip to [Maps](#maps).**

[OVERVIEW](#overview)
<br>[GENERAL TIPS AND TRICKS](#general-tips-and-tricks)
<br>&emsp;[Weather and Attire](#weather-and-attire)
<br>&emsp;[Animal Attacks](#animal-attacks)
<br>&emsp;[Bed, Bath, and Beyond](#bed-bath-and-beyond)
<br>&emsp;[Food, Beverages, Tonics, and Weight](#food-beverages-tonics-and-weight)
<br>&emsp;[Honor](#honor)
<br>&emsp;[Transportation](#transportation)
<br>&emsp;[Weapons](#weapons)
<br>&emsp;[Map Icons](#map-icons)
<br>&emsp;[Camp Item Requests](#camp-item-requests)
<br>[HUNTING TIPS](#hunting-tips)
<br>&emsp;[Debunking the save/reload deal.](#debunking-the-savereload-deal)
<br>&emsp;[Use a headset if possible.](#use-a-headset-if-possible)
<br>&emsp;[Stealth is usually better.](#stealth-is-usually-better)
<br>&emsp;[Cover scent lotion.](#cover-scent-lotion)
<br>&emsp;[Give the game time to spawn everything.](#give-the-game-time-to-spawn-everything)
<br>&emsp;[Studying evasive/aggressive animals effectively.](#studying-evasiveaggressive-animals-effectively)
<br>&emsp;[Collecting animals which land in deep water.](#collecting-animals-which-land-in-deep-water)
<br>&emsp;[Farming gritty fish meat for potent predator bait.](#farming-gritty-fish-meat-for-potent-predator-bait)
<br>&emsp;[Farming wild animals.](#farming-wild-animals)
<br>&emsp;[List of materials for Satchel, Camp, and Trapper.](#list-of-materials-for-satchel-camp-and-trapper)
<br>&emsp;[What is the best weapon?](#what-is-the-best-weapon)
<br>&emsp;[How to get perfect skins?](#how-to-get-perfect-skins-pelts-hides-etc)
<br>[FISHING TIPS](#fishing-tips)
<br>&emsp;[Weather, bait, and bite sequences.](#weather-baits-and-bite-sequences)
<br>[PLANT/HERB LOCATIONS](#plantherb-locations)
<br>[ITEM LOCATIONS](#item-locations)
<br>&emsp;[Ginseng Elixir](#ginseng-elixir)
<br>&emsp;[Aged Pirate Rum](#aged-pirate-rum)
<br>&emsp;[Valerian Root](#valerian-root)
<br>&emsp;[Moonshine](#moonshine)
<br>&emsp;[Pamphlets](#pamphlets)
<br>[BOUNTY MISSIONS AND TARGETS](#bounty-missions-and-targets)
<br>[RANDOM EVENTS](#random-events)
<br>&emsp;[Horse Races](#horse-races)
<br>&emsp;[Moonshiners](#moonshiners)
<br>&emsp;[Competitive Shooter](#competitive-shooter)
<br>&emsp;[Herbalist](#herbalist)
<br>&emsp;[William](#william)
<br>&emsp;[Soothsayer](#soothsayer)
<br>&emsp;[Blind Man Cassidy](#blind-man-cassidy)
<br>&emsp;[Cave Hermit](#cave-hermit)
<br>&emsp;[Hermit Woman](#hermit-woman)
<br>&emsp;[Hermit Man](#hermit-man)
<br>&emsp;[Ghost In Swamp](#ghost-in-swamp)
<br>&emsp;[Sun Worshipper](#sun-worshipper)
<br>&emsp;[KKK](#kkk)
<br>&emsp;[Ex Soldier](#ex-soldier)
<br>&emsp;[Feral Man](#feral-man)
<br>&emsp;[Cave Voice](#cave-voice)
<br>[MISSABLE CONTENT](#missable-content)
<br>&emsp;[Chapter I](#chapter-i)
<br>&emsp;[Chapter II](#chapter-ii)
<br>&emsp;[Chapter III](#chapter-iii)
<br>&emsp;[Chapter IV](#chapter-iv)
<br>&emsp;[Chapter V](#chapter-v)
<br>&emsp;[Chapter VI](#chapter-vi)
<br>&emsp;[Epilogue I](#epilogue-i)
<br>&emsp;[Epilogue II](#epilogue-ii)
<br>&emsp;[Temporary Items](#temporary-items)
<br>[ITEM SELL PRICES](#item-sell-prices)
<br>&emsp;[Animal Skins](#animal-skins)
<br>&emsp;[Orchids](#orchids)
<br>[BUGS](#bugs)
<br>&emsp;[Facial hair bug](#facial-hair-bug)
<br>&emsp;[Cattleman Hero Grip wrong texture](#cattleman-hero-grip-wrong-texture)
<br>&emsp;[Unable to obtain Wild Man's Journal](#unable-to-obtain-wild-mans-journal)
<br>&emsp;[Bugged Soldier During The King's Son](#bugged-soldier-during-the-kings-son)
<br>&emsp;[Unable to send orchids by mail.](#unable-to-send-orchids-by-mail)
<br>&emsp;[Severe flickering or outright blackout in Bluewater Marsh and/or Bayou Nwa.](#severe-flickering-or-outright-blackout-in-bluewater-marsh-andor-bayou-nwa)
<br>&emsp;[Javier not getting off his horse during Chez Porter Homestead Robbery.](#javier-not-getting-off-his-horse-during-chez-porter-homestead-robbery)
<br>&emsp;[Locations not being noted on the map.](#locations-not-being-noted-on-the-map)
<br>&emsp;[Discount at Saint Denis shops as reward for killing Jean Marc as ordered by Mayor Henri Lemieux.](#discount-at-saint-denis-shops-as-reward-for-killing-jean-marc-as-ordered-by-mayor-henri-lemieux)
<br>&emsp;[Unable to save custom outfits.](#unable-to-save-custom-outfits)
<br>&emsp;[Legend of the East outfit not unlocking after 90th challenge.](#legend-of-the-east-outfit-not-unlocking-after-90th-challenge)
<br>&emsp;[Micro-stuttering, FPS drops, ERR_GFX_STATE popup/crash, and other graphics issues.](#micro-stuttering-fps-drops-err_gfx_state-popupcrash-and-other-graphics-issues)
<br>[GLITCHES](#glitches)
<br>&emsp;[Keep Arthur's unique suit from The Gilded Cage](#keep-arthurs-unique-suit-from-the-gilded-cage)
<br>&emsp;[Keep Arthur's closed Winter Shogun Coat](#keep-arthurs-closed-winter-shogun-coat)
<br>&emsp;[Looting saddle bags and not getting the shit kicked out of you](#looting-saddle-bags-and-not-getting-the-shit-kicked-out-of-you)
<br>&emsp;[Break down large fish](#break-down-large-fish)
<br>&emsp;[Keep temporary documents](#keep-temporary-documents)
<br>&emsp;[Launch from horse with carcass stowed on side](#launch-from-horse-with-carcass-stowed-on-side)
<br>&emsp;[Getting caught when quickly dismounting your horse](#getting-caught-when-quickly-dismounting-your-horse)
<br>&emsp;[Steal any horse from any stable](#steal-any-horse-from-any-stable)
<br>&emsp;[Remove scope from Carcano and/or Rolling Block Rifles](#remove-scope-from-carcano-andor-rolling-block-rifles)
<br>&emsp;[Universal saddle blankets](#universal-saddle-blankets)
<br>&emsp;[Saving Arthur's money for John](#saving-arthurs-money-for-john)
<br>&emsp;[Getting gang horses](#getting-gang-horses)
<br>&emsp;[Getting out of bounds](#getting-out-of-bounds)
<br>&emsp;[Glitching through locked interiors](#glitching-through-locked-interiors)
<br>&emsp;[Speed crafting](#speed-crafting)
<br>&emsp;[Duplicate journal sketches](#duplicate-journal-sketches)
<br>&emsp;[Huge Bass with Kieran](#huge-bass-with-kieran)
<br>&emsp;[Double skins](#double-skins)
<br>[EASTER EGGS](#easter-eggs)
<br>&emsp;[Witch in Graveyard](#witch-in-graveyard)
<br>&emsp;[Skinner Brothers Yelps](#skinner-brothers-yelps)
<br>&emsp;[Voices at Old Camps](#voices-at-old-camps)
<br>&emsp;[Roanoke Forest Whispers](#roanoke-forest-whispers)
<br>&emsp;[Woman in the Window](#woman-in-the-window)
<br>&emsp;[Trelawny's House](#trelawnys-house)
<br>&emsp;[Writing on a Tree](#writing-on-a-tree)
<br>&emsp;[Bottle Tree](#bottle-tree)
<br>&emsp;[Zombie Well](#zombie-well)
<br>&emsp;[Bolger Glade Whispers](#bolger-glade-whispers)
<br>&emsp;[Lemoyne Ghost Train](#lemoyne-ghost-train)
<br>&emsp;[UFO](#ufo)
<br>&emsp;[Witches Cauldron](#witches-cauldron)
<br>&emsp;[Dragic's Creation](#dragics-creation)
<br>&emsp;[Panoramic Map](#panoramic-map)
<br>&emsp;[Giant Snake](#giant-snake)
<br>&emsp;[Tally Marks in Well](#tally-marks-in-well)
<br>&emsp;[Gorilla](#gorilla)
<br>&emsp;[Graves](#graves)
<br>&emsp;[Undead Nightmare](#undead-nightmare)
<br>&emsp;[Strange Man](#strange-man)
<br>&emsp;[Crazy Guy in Treehouse](#crazy-guy-in-treehouse)
<br>&emsp;[Chelonians](#chelonians)
<br>&emsp;[Albert Mason Photos](#albert-mason-photos)
<br>&emsp;[Dead Man in Outhouse](#dead-man-in-outhouse)
<br>&emsp;[Frozen Explorer](#frozen-explorer)
<br>&emsp;[Dormin Crest](#dormin-crest)
<br>&emsp;[Frozen Cattle](#frozen-cattle)
<br>&emsp;[Black Sheep](#black-sheep)
<br>&emsp;[Burned Wagon](#burned-wagon)
<br>&emsp;[Antler Knife](#antler-knife)
<br>&emsp;[Banjo Mutant](#banjo-mutant)
<br>&emsp;[Pentagram](#pentagram)
<br>&emsp;[Blackwater Athletics Team](#blackwater-athletics-team)
<br>&emsp;[Hung Corpse](#hung-corpse)
<br>[MAPS](#maps)
<br>&emsp;[Map Key/Legend](#map-keylegend)
<br>&emsp;[Some Notes](#some-notes)
<br>&emsp;[Time Frames](#time-frames)
<br>&emsp;[Animal Scenarios](#animal-scenarios)
<br>&emsp;[Rival Gangs](#rival-gangs)
<br>&emsp;[Wild Animal Locations](#wild-animal-locations)
<br>&emsp;&emsp;[Western Bull Moose](#western-bull-moose)
<br>&emsp;&emsp;[Panther](#panther)
<br>&emsp;&emsp;[Horned Owl](#horned-owl)
<br>&emsp;&emsp;[Timber Wolf](#timber-wolf)
<br>&emsp;&emsp;[Cougar](#cougar)
<br>&emsp;&emsp;[Grizzly Bear](#grizzly-bear)
<br>&emsp;&emsp;[Hawk and Eagle](#hawk-and-eagle)
<br>&emsp;&emsp;[Vulture](#vulture)
<br>&emsp;&emsp;[Gray Wolf](#gray-wolf)
<br>&emsp;[Small Birds and Animals](#small-birds)
<br>&emsp;&emsp;[Scoreless Spawns](#scoreless-spawns)
<br>&emsp;&emsp;[Pileated Woodpecker](#pileated-woodpecker)
<br>&emsp;&emsp;[Red Bellied Woodpecker](#red-bellied-woodpecker)
<br>&emsp;&emsp;[American Robin](#american-robin)
<br>&emsp;&emsp;[Pigeon](#pigeon)
<br>&emsp;&emsp;[Little Brown Bat](#little-brown-bat)
<br>&emsp;&emsp;[Rat](#rat)
<br>&emsp;[Domestic Animal Locations](#domestic-animal-locations)
<br>&emsp;&emsp;[Bull](#bull)
<br>&emsp;&emsp;[Ox](#ox)
<br>&emsp;&emsp;[Rooster](#rooster)
<br>&emsp;&emsp;[Chicken](#chicken)
<br>&emsp;&emsp;[Pig](#pig)
<br>&emsp;&emsp;[Alpine Goat](#alpine-goat)
<br>&emsp;[Horse Stats and Locations](#horse-stats-and-locations)
<br>&emsp;[Activities](#activities)
<br>&emsp;&emsp;[Coffee](#coffee)
<br>&emsp;&emsp;[Alcohol Cases](#alcohol-cases)
<br>&emsp;&emsp;[Stew Bowl](#stew-bowl)
<br>&emsp;&emsp;[Chop Firewood](#chop-firewood)
<br>[MISCELLANEOUS](#miscellaneous)
<br>&emsp;[Cool Things](#cool-things)
<br>&emsp;[Tools](#tools)
<br>&emsp;[Mods](#mods)
<br>&emsp;[Programs Used](#programs-used)
<br>&emsp;[References](#references)
<br>&emsp;[Testing Procedures](#testing-procedures)
<br>&emsp;[Release Format](#release-format)
<br>&emsp;[Quotes](#quotes)

# GENERAL TIPS AND TRICKS

*Some notes on general topics.*

### Weather and Attire

Dress for what's coming. Clothing "warmth" is only dependent upon temperature, but weather will affect temperature as well as visuals.

Weather | Effects/Details
:--- | ---
Clear (Sunny) | Mostly clear with a few clouds here and there.
Overcast | Solid layer of cloud cover.
Rain | Visible rain.
Thunder | Just lightning/thunder, no rain. More common in **Great Plains, WE** and **Heartlands, NH**.
Thunderstorm | Heavy rain with lightning and thunder.
Hurricane | Strong wind and heavy rain. Entire state of **Lemoyne** and **Heartlands, NH**.
Sleet | Freezing rain. Occasional gusts. Common in **Big Valley, WE**, **Heartlands, NH**, **Roanoke Ridge, NH**
Blizzard (Whiteout) | High winds. Heavy snow. Super low visibility. Northwestern portion of **Grizzlies West, AM** (high mountains).
Windy | Leaves and other animated particles flying around. Audible wind. Usually indicative of a storm ahead.
Fog | Cloud cover moves close to ground level. Very low visibility. **Heartlands, NH**, **Roanoke Ridge, NH**, **State of Lemoyne**.
Mist | Low visibility. More common in early mornings. **Heartlands, NH**, **Roanoke Ridge, NH**, **State of Lemoyne**.
Dust Storm | Strong wind. Super low visibility. All regions of **New Austin** except **Hennigan's Stead, NA**.

Temperature | Suitable<br>Warmth Points
:--- | ---
Hot<br>(>70F) | 0-2
Average<br>(50-70F) | 3
Cold<br>(<50F) | 4+

Each clothing item has its own "warmth points".

Description | Warmth Points
:--- | ---
Slightly Warm | 1
Reasonably Warm | 2
Warm | 3
Very Warm | 4

### Animal Attacks

Some animals will charge and kill you, some will randomly charge and headbutt you, some will randomly charge and bite.

Animal(s) | Attack Type
:--- | ---
Grizzly Bear<br>Wolf | Warning, charge, kill.
Cougar<br>Panther | Charge, kill.
Alligator | Warning, charge, kill.
Bighorn Ram<br>Whitetail Buck<br>Bull Elk<br>Wild Boar<br>Collared Peccary<br>Ox<br>Bull<br>Alpine Goat<br>(Domestic) Pig | Charge, headbutt.
Raccoon<br>Muskrat<br>Beaver<br>Badger<br>Skunk | Charge, bite.
All land snakes. | Flee, warning, bite.

- All land **Snakes** will bite and envenomate you. You can cure both poison (from ingesting **Oleander Sage**) and venom (from snake bites) with a **Potent** or **Special Health Cure**. Alternatively, you can eat any **Ginseng** plant.

### Bed, Bath, and Beyond

Some businesses offer lodging, baths, table games, and/or dining. If a shop as two meals available, the less costly one will fully restore all cores while the more costly one will yield a gold health core. Completing the batch "minigame" (chore) will yield a gold stamina core. All businesses where clothing can be bought offer a wardrobe somewhere inside or outside the shop.

Business | Amenities
:--- | ---
**Flatneck Station**<br>Heartlands, NH | Poker
**Keane's Saloon**<br>Valentine, Heartlands NH | Oatmeal
**Smithfield's Saloon**<br>Valentine, Heartlands, NH | Poker<br>Beef Stew<br>Lamb's Fry with green peas and boiled potatoes.
**Saints Hotel**<br>Valentine, Heartlands, NH | Room<br>Bath
**Old Light Saloon**<br>Van Horn, Roanoke Ridge, NH | Blackjack<br>Fish Stew<br>Lamb's Heart with boiled cabbage.
**Van Horn Post Station**<br>Van Horn, Roanoke Ridge, NH | Room<br>Bath
**Rhodes Parlour House**<br>Rhodes, Scarlett Meadows, LE | Blackjack<br>Cracked Wheat and Milk<br>Fried Catfish with greens and boiled beans.
**Bastille Saloon**<br>Saint Denis, Bayou Nwa, LE | Poker<br>Lobster Bisque<br>Prime Rib with potatoes dauphinoise and spring salad.
**Blackwater Saloon**<br>Blackwater, Great Plains, WE | Poker<br>Blackjack<br>Room<br>Bath<br>Peach Cobbler with cream.<br>Roast Prarie Chicken with green beans and mashed potato and gravy.
**Tumbleweed Saloon**<br>Tumbleweed, Gaptooth Ridge, NA | Poker<br>Chili<br>Roast Beef with corn and glazed carrots.
**Tumbleweed Gunsmith**<br>Tumbleweed, Gaptooth Ridge, NA | Room

### Food, Beverages, Tonics, Hair Length, and Body Weight

You can get bonuses depending on your weight. Heavier gives less damage taken, lighter gives stamina drain buff. Max is 6% gain and loss, with 0.75% increments between the two as you go between **Overweight** and **Underweight**.

Both weight and hair length is updated each time the camera fades out/in. This includes setting up camp, tearing down camp, selecting "Wait Until Morning" when at closed shops, etc.

[Source.](https://youtu.be/CmkjekIdiJo) The fastest way to gain weight is:

1. Travel to any town which serves meals.
2. Rent a room in town.
3. Go to the Saloon.
4. Eat `2` of the $5.00 meals.
5. Sleep until midnight.
6. Eat `2` more $5.00 meals at the Saloon.
7. Go to any closed shop and "Wait Until Morning".
8. Repeat.

The fastest way to grow hair is also to do the above, but drinking a hair tonic every time you spawn back in.

There is an alternative method using just free alcohol crates: just keep drinking until you black out, over and over again. [Source.](https://youtu.be/zXprkDSzKBI)

**Alcohol**

Below is a list of alcohol values per item. Coped from [this Reddit post](https://redd.it/9s6qnk/). Values amount to "proof", and are the base values before any modifiers. Higher proof means drunk quicker. A value of `1.00` is "blackout drunk". The **Wolf's Heart Trinket** halves the effects of all alcohol.

State | Range
:--- | ---
Sober | 0.00 to 0.49
Tipsy | 0.50 to 0.74
Drunk | 0.75 to 0.99
Blackout | 1.00+

Name | Value
:--- | ---
Saloon Beer | 0.1
Saloon Whiskey | 0.1
Opened Guarma Rum | 0.1
Opened Fine Brandy | 0.1
Opened Gin | 0.1
Opened Kentucky Bourbon | 0.13
Guarma Rum | 0.17
Fine Brandy | 0.17
Gin | 0.17
Kentucky Bourbon | 0.25
Moonshine | 0.3
Whiskey Bottle | 0.4
Aged Pirate Rum | 0.5

**Cores/Tonics**

In testing **Potent Tonics** against their **Special** variants, a piece of **Cooked Big Game Meat** was consumed and time was clocked when the bar was fully used up and the gold core fully depleted.

**Stamina**
1. Oregano Big Game + Special Bitters
- 01:54:04
2. Oregano Big Game + Potent Bitters
- 01:42:87

**Dead Eye**
1. Thyme Big Game + Special Snake Oil
- 0:44:21
2. Thyme Big Game + Potent Snake Oil
- 0:41:68

As you can see, **Special Bitters** makes a bit of a difference, where as **Special Snake Oil** does fairly little in terms of better fortification. Overall, if you're short on materials, bought/crafted Potent tonics will do just fine in most situations.

### Honor

Honor is measured by ranks -8 to +8 on a scale according to the total honor as an integer from -320 to +320. It affects some aspects of the game. Interaction dialog change levels are unverified, but the effect does occur.

**NOTE:** In Chapter 6, actions that affect honor have a multiplier of 1.5x. Use this to your advantage if you run low honor as Arthur but want the "high honor" ending.

Honor | Effect
:--- | ---
280 | 50% discount in all shops
240 | New outfits available in shops.
200 | 25% discount in all shops
120 | New outfits available in shops.
80 | 10% discount in all shops. Interaction dialog changes to "positive".
40 | When looting bodies, drop rates of potent tonics, restorative items, jewelry, and food is increased.
0 | When looting bodies, primarily obtain standard tonics, cheap jewelry, basic horse consumables, and used/opened alcohol and tobacco.
-40 | When looting bodies, drop rates of dead eye tonics, thrown weapons, alcohol, and tobacco are increased. Also receive more money and jewelry when looting lawmen.
-80 | Interaction dialog changes to "negative".
-280 | Ambient sounds within dead eye change.

### Transportation

*Horses are faster, so I can disappear.*

**Stagecoach/Train**

Taking a train is generally slower, depending on load time. Stagecoach is, by far, the fastest way to get somewhere. It can be costly and stage stops are few and far between, but it is by far the fastest way to get around.

Travel Method | Available Stops
:--- | ---
Stagecoach | Annesburg<br>Armadillo<br>Emerald Ranch<br>MacFarlane's Ranch<br>Rhodes<br>Saint Denis<br>Strawberry<br>Tumbleweed<br>Valentine<br>Van Horn
Campfire | Annesburg<br>Armadillo<br>Beecher's Hope<br>Benedict Point<br>Blackwater<br>Braithwaite Manor<br>Butcher Creek<br>Caliga Hall<br>Colter<br>Cornwall Kerosene & Tar<br>Emerald Ranch<br>Lagras<br>MacFarlane's Ranch<br>Manzanita Trading Post<br>Pronghorn Ranch<br>Rhodes<br>Saint Denis<br>Strawberry<br>Thieves Landing<br>Tumbleweed<br>Valentine<br>Van Horn Trading Post<br>Wapiti Indian Reservation
Train | Annesburg<br>Emerald Ranch<br>Riggs Station<br>Rhodes<br>Saint Denis<br>Valentine<br>Wallace Station

**Asking for a ride?**

You can **Callout** NPCs on wagons to ask for a ride. If accepted, you'll be taken to the nearest town.

**How many horses can I own?**

Up to four horses can be stabled, with a fifth as a "temporary" horse anywhere outside of the Stable. Temporary horses will have a horse head icon (with no bit) on the main map and minimap. Your main (saddle) horse will have the same icon but with a bit and harness. When you reach bonding level 1 with a new horse, your temporary horse will despawn automatically if it's far enough away.

**How to tame a wild horse?**

1. Hold LT when approaching to keep it from spooking immediately. While you're walking up to it, do not let its "calmness" bar deplete as that will cause it to flee. It's usually best to immediately hop on the horse when you get close enough, rather than petting it.
2. After hopping on, hold the LS in the opposite direction of where the horse is turning. If it's turning left, hold LS to the right. It's turning right, hold LS to the left. The backwards and forwards movements aren't needed, just left to right.

*Alternative methods:*

- Hit it in a non-vital spot with any gun, then revive it. This carries more risk, but immediately grants bonding rank 1.
- Lasso it. This is the quick and dirty method, but it works. Stay on your own horse, ride up to the wild one, lasso it, and move forwards to hop on.

**How to max bond horses fast?**

- Food items have their own unique bonding point yields. Peppermints give the most points (6), while Sugar Cubes give (5).
- Completing two horse races with at least one of the [associated Horse Racer NPCs](#horse-races) will both allow you to bond with your horse while spurring and (after winning the second race) gives a third bar of speed for your saddled horse. Traveling in cinematic mode gives bonding points after completing the second race; a great legitimate way to bond AFK.
- Leading your horse yields more bonding points per minute than anything else. Yes, even more than constantly shoving Peppermints down your new horse's throat. The old rubber band trick works for this. CheatEngine64's speedhack also works wonders if you're rushing or just short on time.

1. Begin leading your horse.
2. Travel to the open fields of **The Heartlands**. Alternatively you can go to the plains west of Blackwater, but there are more snakes out that way. (Getting close to any aggressive animal will end the lead.)
3. Wrap a rubber band around your thumbstick and the end of either palm grip (depending on the length of the rubber band).
4. Do other things for a while. (About 20 minutes.)
5. Come back to your fully bonded horse.

- *BY DOING THIS, YOU'RE BASICALLY STILL IN-GAME, SO THE POSSIBILITY OF HOSTILITY FROM BOUNTY HUNTERS, BUSHWHACKERS, ROBBERS, AGGRESSIVE ANIMALS, ETC IS STILL PRESENT. MIGHT WANT TO PEEK AT THE SCREEN EVERY NOW AND THEN AND/OR KEEP AN EAR OUT.*
- *If on the PC version without a controller, you can use [AutoHotKey](https://www.autohotkey.com/) to simulate holding down the movement key(s).*

**What is the best horse?**

A purely subjective question. But, statistically speaking and taking into account my own experience in practice, the **Turkoman** and **Missouri Fox Trotter** are the best all-around breeds. Sure they don't have as fantastic of stats as Arabians, but those Arabians dart off at the first clink of a pen drop. The Turkoman and MFT are both well-rounded breeds, however they can only be obtained from Stables and some are locked until a certain story progression point.

For the "best" horse that can be found in the wild, I've found the **Thoroughbred** and **American Standardbred** breeds are the best balanced and closest to Turkoman and MFT.

Again, all purely subjective. Some players may go for looks. Others may go for stats. Like a certain coat on a certain horse, but don't care for its stats? If you're on PC, you're in luck:

[Multiclass Horses](https://www.nexusmods.com/reddeadredemption2/mods/1226)
[Work Horses](https://www.nexusmods.com/reddeadredemption2/mods/1340)
[War Horses](https://www.nexusmods.com/reddeadredemption2/mods/1327)
[Race Horses](https://www.nexusmods.com/reddeadredemption2/mods/1303)
[Draft Horses](https://www.nexusmods.com/reddeadredemption2/mods/1271)
[Riding Horses](https://www.nexusmods.com/reddeadredemption2/mods/1239)

**What's the best saddle?**

Technically, the **Beaver Roping Saddle** is the "best" saddle solely in terms of game logic because it provides the highest **Stamina Regen** (same as **Panther** and **Rattlesnake** saddles) and **Health Core Drain** bonuses. My reasoning behind this is: horse health core drain intensifies when they're dirty. I don't brush my horse often, so a lot of times it's just dirty. That being the case, the occasional health core penalty is lowered that much more with the Beaver Saddle. If you often push your horse hard and brush it once in a while, the **Panther Trail Saddle** is more fit for you. All that said, even though the aforementioned are the "best" stat-wise, I occasionally use the **Alligator Ranch Cutter** or **Cougar McClelland** saddles on my **Sooty Buckskin Dutch Warmblood** just because they look better on it. The stats don't differ a ton between higher-end **Trapper** saddles, so I generally just match the saddle to the horse I'm using. **Panther Trail** looks damn good to me on an **Amber Champagne MFT**.

Name | HEALTH CORE<br>DRAIN | STAMINA CORE<br>DRAIN | STAMINA<br>DRAIN | STAMINA<br>REGEN
:--- | --- | --- | --- | ---
Beaver Roping | -26% | -20% | -50% | +24%
Panther Trail | -20% | -26% | -50% | +24%
Rattlesnake Vaquero | -22% | -24% | -50% | +24%
Alligator Ranch Cutter | -24% | -20% | -50% | +22%
Bear Dakota | -20% | -24% | -50% | +22%
Cougar McClelland | -20% | -22% | -50% | +20%
Boar Mother Hubbard | -22% | -20% | -50% | +20%
Nuevo Paraiso | -12% | -12% | -25% | +12%

**Auto Travel**

Aside from fast travel (unlocked by purchasing the map from the camp ledger), you can autopilot to a destination: set a destination (must be in a road/path) on the map, hop on your horse and begin sprinting towards the waypoint. While sprinting, hold down the SELECT button (XB1) or X button (on PS4) to enter cinematic view. Black bars will appear and you will travel to the waypoint.

**NOTE:** I've observed that sometimes, regardless of distance, when I arrive at the waypoint my horse will have a full stamina core and bar. I've seen this only when doing so with a level 4 bonded horse (and feeding it a **Horse Meal** and injecting a **Potent Horse Stimulant** before going into Cinematic Camera). Every time I've done this with a non-max-level bonded horse, it always ends up with an empty stamina core and bar regardless of what I feed/inject it with.

**NOTE:** events still occur, it's just a different camera view. You can still get attacked by a predator or enemies.

**Where are the rare wild horses?**

Breed | Coat | Location
:--- | --- | ---
Arabian | White | Lake Isabella, Grizzlies West, AM
Arabian | Red Chestnut | Owanjila, Big Valley, WE (in woods west of lake)
Arabian | Warped Brindle | Tempest Rim, Grizzlies West, AM (north of Wapiti)
Andalusian | Perino | East bank of **Kamassa River** on cliffside at **Brandywine Drop**
Appaloosa | Few Spotted | Heartlands, NH (west of Oil Derrick)
Mustang | Tiger Striped Bay | Rio del Lobo Rock, Rio Bravo, NA (south of Legendary Pronghorn spawn)
American Standardbred | Black | Little Creek River, Big Valley, WE (along north bank; southeast of Watson's Cabin)
Thoroughbred | Blood Bay | Larned Sod, Heartlands, NH (southwest of house)

### Weapons

**Weapon Familiarity**

Yes, it's a thing and if you'd never seen it on the Compendium for each weapon you'd never know of it. Familiarity affects all stats, and the more familiar you are with a weapon, the better shot you become with it.

- Use dead eye to get headshots.
- If avoiding law and bounties, enemy hideouts refresh every few in-game days. The numerous Del Lobo hideouts in New Austin become accessible after Chapter 6.

**What is the best weapon?**

In practice, the **Bow** is the best hunting weapon for three reasons:

1. Yes, its range is limited and does not yield perfect varmint pelts, but the longest range at which you can make Bow kills is outrageous. Even if you're a ways away you can close in towards the target and make the kill via deadeye still quite some distance away. Granted, though it may be slim, there is still a chance to miss even with deadeye lock-on when the target is near the outside edge of the bow's maximum range.
2. It can make clean kills on everything except most animals which require the **Varmint Rifle** (which would have been nice to have some Varmint Arrows or just make either Regular or Small Game arrows cleanly kill the varmints). Most varmint kills with regular arrows will almost always yield a one-less-star pelt, i.e. you kill a three star and it will almost always drop to two stars. Be that as it may, there are exceptions to this: a headshot with a poison arrow to beavers and iguanas almost always yields a perfect pelt for me when skinning the two-star carcass. But every other varmint (skunks, possums, etc) rarely gives a perfect pelt with any arrow kill.
3. You get to craft and use **Poison/Fire/Dynamite Arrows**.

- Scoped rifles are more powerful than medium rifles and have near-hitscan bullet velocity, but two caveats: they must be scoped in when aiming (unless the de-scope glitch is used) and do not allow dead eye lock-on (even if de-scoped via glitch). The **Carcano** surpasses the **Rolling Block** on every point. It does everything the **Rolling Block** does, but with a six-round clip. Both of them will one-shot-headshot-kill a bear at any reasonable distance. Overall in practice, an unscoped **Carcano** is the best heavy rifle. It must be noted as well that a **Carcano** with **Express Ammo** deals more damage per shot than a **Rolling Block** with **Express Ammo**.
- The medium rifles, the **Bolt Action** sacrifices just a bit of damage for better accuracy, fire rate, and reload. All in all, unless you're constantly taking very long shots, the **Bolt Action** is better in practice and works for most everyone. The **Springfield's** slightly higher damage is not a proportional tradeoff to the loss of accuracy and single-round capacity.
- For revolvers, the **LeMat** comes out on top in terms of damage. The  **Double Action** has the best DPS (damage per second), but the **LeMat** also offers a secondary shotgun barrel. Slow to reload both the cap and ball ammo as well as the center grapeshot barrel, but you get everything in one package. The shotgun barrel itself appears to have quite less effective range than a **Sawed Off Shotgun**, but it's still mad effective at close range as a shotgun is meant to be.
- For pistols, **Mauser** is the best all-around. Yes, the **M1899** has better damage and accuracy. Yes, the **Semi Auto** slightly higher fire rate allows it to make stupid fast deadeye kills. The **Mauser** reigns because it gets the extra two rounds per clip (10 total; where as the **Semi Auto** and **M1899**) and nearly matches the **Semi Auto Pistol** rate of fire. It's essentially the middle ground, best of both worlds.

Below is a damage chart organized by weapon and bullet type (ordered corresponding to what's in-game). Weapon rows are grouped by class, with the highest damage of its class being at the top and all others in descending order. Incendiary and explosive ammo was not tested because... well, you know. Shotguns weren't tested either because... you get the gist. Testing was done with five shots of each bullet type for all weapons to eliminate one-off cases. All shots were to a grizzly's rear upper thigh (outside any critical/fatal areas). Damage was measured via RampageTrainer's in-game NPC debug feature.

Split point rounds deal slightly more damage at close range than high velocity rounds. I've yet to test them at longer ranges, though I imagine it'll be no different from a distance. Weapon familiarity does not affect damage. I've not tested shotguns yet. All unique weapons are identical to their regular counterparts (in terms of damage) except for those listed below.

Weapon | Class | Unlocked After | REG | HIV | SPL | EXP
:--- | --- | --- | --- | --- | --- | ---
Carcano | Rifle | `Goodbye, Dear Friend` | 57 | 70 | 78 | 85
Rolling Block | Rifle | `Pouring Forth Oil` | 69 | 74 | 76 | 83
Rare Rolling Block | Rifle | `Magicians for Sport`<br>**Held by Bounty Hunter in barn near end of mission.** | 68 | 73 | 75 | 79
Springfield | Rifle | `Eastward Bound` | 60 | 62 | 64 | 66
Bolt Action | Rifle | `Preaching Forgiveness as He Went` | 53 | 56 | 59 | 63
Litchfield | Repeater | `Goodbye, Dear Friend` | 48 | 51 | 55 | 58
Carbine | Repeater | `Old Friends` | 43 | 45 | 48 | 51
Volcanic | Pistol | `Eastward Bound` | 40 | 43 | 46 | 50
Lancaster | Repeater | `An American Pastoral Scene` | 36 | 38 | 41 | 43
LeMat | Revolver | `The Gilded Cage`<br>**Saint Denis Gunsmith only.** | 33 | 35 | 37 | 40
Evans | Repeater | `An Honest Mistake`<br>or `Advertising, The New American Art` | 34 | 35 | 38 | 39
Schofield | Revolver | `Blessed are the Meek?` | 29 | 32 | 33 | 36
Cattleman | Revolver | `Outlaws from the West` | 22 | 24 | 25 | 28
M1899 | Pistol | `The Battle of Shady Belle`<br>**Saint Denis Gunsmith only.** | 22 | 24 | 26 | 28
Double Action | Revolver | `A Strange Kindness` | 21 | 22 | 24 | 27
Algernon's<br>High Roller | Revolver | `Dutchesses and Other Animals VI` | 20 | 23 | 24 | 27
Micah's | Revolver | `American Venom`<br>**On Micah's corpse.** | 20 | 22 | 25 | 26
Mauser | Pistol | `That's Murfree Country`<br>**Saint Denis and Valentine Gunsmiths only.** | 21 | 22 | 25 | 26
Semi Auto | Pistol | `The Joys of Civilization`<br>**Saint Denis and Valentine Gunsmiths only.** | 19 | 21 | 23 | 25
Varmint | Rifle | `Eastward Bound`<br>Free for Special/Ultimate edition players. | 19 | - | - | -
Bow | N/A | `The Aftermath of Genesis` | 55<br>(REG) | 166<br>(IMP) | 15<br>(SGM) | 55+<br>(PSN)<br>**[*]**

**[*]** Poison Arrows deal the same initial damage as Regular Arrows, but continue to deal damage at a certain rate. I couldn't find any immediate information on what that rate is, but have observed it myself with RampageTrainer's debug menu.

And below here are early unlock methods for some weapons:

Weapon | Location
:--- | ---
Schofield Revolver | during `Shop Robbery` of back room at **Valentine Doctor's Office**
Double Action Revolver | gun case under bunk bed at **Lonnie's Shack, Scarlett Meadows, LE**; accessible before its associated `Homestead Robbery` with Sean in Chapter 3
Otis Miller's Revolver | In a chest within a cave at **Rattlesnake Hollow, Cholla Springs, NA**
M1899 Pistol | from moonshiner event northwest of **Valley View, Big Valley, WE**
Mauser Pistol | **Midnight's Pistol** from Billy Midnight in **Rhodes** during `The Noblest of Men, and a Woman`
Double Barrel Shotgun | **Catfish Jackson's, Scarlett Meadows, LE**
Semi Auto Shotgun | gun case in the basement of **Watson's Cabin, Big Valley, WE**
Pump Action Shotgun | gun case on platform above west bedroom in main house at **Chez Porter, Grizzlies West, AM**
Lancaster Repeater | gun case in basement Gunsmith in **Rhodes, Scarlett Meadows, LE**; only accessible during its associated `Shop Robbery`
Bolt Action Rifle | during `The First Shall Be Last`, after knifing the first two enemies with Javier, kill the one on the left of the next set of enemies **FIRST** and pick up his rifle
Machete | used by **Murfree Brood** and **Night Folk**
Broken Pirate Sword | in a broken boat south of **Caliga Hall** and **Saint Denis**, northeast of **Shady Belle, Scarlett Meadows, LE**
Antler Knife | in the neck of a dead *Grizzly Bear* northeast of **Stilt Shack, Big Valley, WE**
Civil War Knife | in the basement of **Fort Brennand, Roanoke Ridge, NH**
Wide Blade Knife | in the back of a dead miner inside the cave at **Beryl's Dream, Big Valley, WE**
Ornate Dagger | dropped by the Saint Denis **Vampire**
Hewing Hatchet | in a tree stump next to **Flattened Cabin, Grizzlies East, AM**
Stone Hatchet | in the center of **Native Burial, Big Valley, WE**
Viking Hatchet | in a skeleton at the center of **Old Tomb, Roanoke Ridge, NH**
Hunter Hatchet | in a tree stump outside **Dodd's Bluff, Grizzlies West, AM**
Rusted Hunter Hatchet | in a tree stump outside **Martha's Swain, Grizzlies East, AM**
Double Bit Hatchet | in a tree stump next to the rubble and remaining fence of an old cabin northwest of **Wallace Station, Big Valley, WE**
Rusted Double Bit Hatchet | in a tree stump between two large houses in northern **Annesburg, Roanoke Ridge, NH**

**NOTE:** You can also unlock dual wielding at the start of Chapter 2 by completing the **Master Hunter 1** challenge.

### Map Icons

- I used [this map](https://gtaforums.com/topic/968364-complete-map-with-all-discoverable-icons/) as a reference.
- Icons are rough areas of static spawns. There usually isn't a spawn of the marked animal directly at the icon's location, just in the general area.
- Animal drawings are added to the map when an animal is focused on, studied, picked up, or skinned in a specific area. The best thing to do is study and track everything you come across. Binoculars are by far the best way to add icons.
- Plant drawings are added when a plant is picked at least once in the immediate area of the icon. Best to pick everything you come across because spawning a plant with a trainer and picking it does not add the icon for some reason (unlike skinning/tracking animals).
- Point of interest and collectibel locations are added when they are "investigated".
- All map icons do not change based on what character discovered them. The journal sketches do, though.

### Camp Item Requests

*Info on camp item requests. Details are below the table.*

Camp Member | Chapter(s) | Request | Reward | Location
:--- | --- | --- | --- | ---
Abigail | II<br>(sitting with Jack at their tent) | $5.00 | - | -
Bill | II-IV<br>(sitting at his tent) | Hair Pomade | - | Store/Loot
Pearson | II-IV<br>(drinking beer and whistling) | Rabbit Carcass | Scout Jacket | Everywhere
Pearson | II-III<br>(while playing Poker) | Naval Compass | - | 
Charles | II<br>(making arrows by the campfire) | Oleander Sage | Poison Arrow
Charles | Epilogue | Eagle Feather | - | From wild Eagles.
Dutch | II-IV<br>(smoking cigar outside his tent) | Pipe | Vaquero Rider Spurs | Vetter's Echo, Big Valley, WE
Hosea | II-IV<br>(using mortar and pestle at table) | 2x Ginseng | - | -
Hosea | II-IV<br>(pick up the book at his tent) | Crime Novel | - | Hagen Orchards, Bayou Nwa, LE
Jack | II-IV<br>(during `A Fisher of Men`) | Penny Dreadful Book | Chocolate Bar | Osman Grove, Roanoke Ridge, NH<br>Clawson’s Rest, Grizzlies West, AM<br>Pleasance, Scarlett Meadows, LE<br>Downes Ranch, Heartlands, NH<br>Lake Don Julio House, Rio Bravo, NA
Jack | II<br>(walks up to you after `A Fisher of Men`) | Thimble | Jack's Drawing | Looted from enemy peds.
Javier | II-IV<br>(making knives at table) | Oleander | Poison Throwing Knife | Bayou Nwa, LE (near water)
Kieran | III<br>(tending to horses near Arthur's tent) | 2x Burdock Root | Horse Meal Pamphlet | near water
Lenny | II-IV | Pocket Watch | - | Store/Loot
Mary Beth | II<br>(writing in journal by her tent) | Fountain Pen | - | Osman Grove, Roanoke Ridge, NH
Molly | III-IV<br>(walks up and tells of "bad luck") | Pocket Mirror | - | Martha's Swain, Grizzlies East, AM
Sadie | III<br>(during `Further Questions of Female Suffrage`) | Harmonica | - | Granger's Hoggery, Heartlands, NH
Sean | II-III | Kentucky Bourbon | - | Store/Loot
Susan | II | 2x Oregano/Mint/Thyme | - | In the wild.
Tilly | II<br>(while playing Dominoes) | Necklace | - | Loot female peds.
Uncle | Epilogue I-II<br>("PSSST! JOHN!"; 08:00-20:00) | Kentucky Bourbon<br>Milkweed<br>Peppermint<br>Hair Pomade<br>Skunk Carcass | Frontier Vest<br>Tornado Boots<br>Drifter Hat<br>Classic Frock Coat | -

**Pearson's Rabbit**

Available from Chapter II to Chapter VI. Pearson will be drinking beer at his wagon's table. When you walk near him, it will only give a **Greet** prompt when the request is available for activation (like every other request). There are two cheese methods to get it to pop; rinse and repeat as needed:

- Low or zero health core. Sleep until morning, then drink a bunch of **Whiskey/Moonshine** or eat **Oleander Sage**. Head out of camp until around 10:00, then head back in.
- Wait until just after 10:00, then suicide jump off the cliff to the west right out of camp. After respawning, head back into camp.

**Dutch's Pipe**

I've gotten it to pop right after starting both Chapters II and III. In those, Dutch will be standing on the front right side of his tent. In Chapter IV, he'll be standing outside the south door of **Shady Belle**.

# HUNTING TIPS

### Debunking the save/reload deal.

**YOU DO NOT HAVE TO FULLY EXIT AND RESTART THE WHOLE GAME FOR THE "REFRESH" TO WORK. THIS GOES FOR ALL SCENARIOS IN WHICH SAVING AND RELOADING IS ADVISED, INCLUDING RANDOM ENCOUNTERS WITH NPCs.**

Been looking for some rare animal for hours? If you're hunting anything and it doesn't show up soon after you get to its known location:

1. If you know its exact spawn location, travel to it.
2. Set up camp on the spot.
3. Sleep until the best time frame for the animal, if known.
4. Tear down the camp.
5. Save and reload.
6. Once reloaded in, if it doesn't spawn around immediately, just travel a few hundred paces away and head back.

By sleeping, you're advancing time a bit to refresh any time-sensitive spawns. Usually it's best to sleep for a full 72 hours, but since I cannot find any direct evidence that any time-sensitive spawn mechanic is present I just sleep until the desired time frame. Might just be superstition on my part, but I seem to have better luck all the time after sleeping.

By saving and reloading, you're refreshing all entity spawns in the area you saved in. This is how I manage to spot all the super rare moose spawns (like **Painted Sky** and along the **Upper Montana River**).

### Use a headset if possible.

- Use a headset/headphones/earbuds when hunting. Tracking down owls by nothing but their hoots is essentially impossible with my shitty TV speakers. Hell, I even tried my old pair of Skullcandy Ink'd earbuds from 2012 and even with those I can hear everything. You don't have to use a high dollar headset... just something to isolate the game sound.

### Stealth is usually better.

If you're roaming around looking for uncommon/rare animals, do not hunt on your horse. Go on foot, crouched, and walk slowly. Crouch running (that's what I call it) creates more noise than regular crouch walking, but not nearly as much as sprinting. This difference is especially noticable when cover-scented and very close to animals. You can get within a few feet of most animals by slowly creeping up to them. Being able to get closer also opens up your options for clean kills. If stealth hunting, use the **Bow** for everything unless you're hunting down the middle ground animals which need the **Varmint Rifle** for a perfect carcass. Not to mention, while using the **Bow**, you won't scare off everything within a five mile radius. A number of other players claim the **Bow** is trash, but from my experience its quiet kills serve much better than its great but limited range (especially while hunting rare animals that spook easily, *ahem* Moose *cough cough*). The only time I recommend fast-paced hunting is when you know where the animal is or if you've an insane reaction time (primarily relating to hunting cougars/panthers).

### Cover Scent Lotion

It helps immensely if you're doing some stealth hunting. The crafting recipie is unlocked upon starting **Chapter 2**. You cook down the **Scent Glands** from **Skunks**, **Beavers**, and **Muskrats**. You to get way closer to animals without drawing their attention. Yes, you can stay downwind from the animal you're targeting. However, if you're out for anything and everything... you might spook a deer to your left, it runs towards a rabbit, which then runs towards what you're hunting for, spooks it, and they all leave you in the dust.

### Give the game time to spawn everything.

Stick around the area you're hunting in for a while. As in, at least a couple days. Sleeping and/or blacking out add to this, what I'm going to call, "time spent in area" mechanic. I think it's just you giving the game time to load in all the time-sensitive and random spawns. A good example: after a whole year of playing this game I've not once seen a moose at Barrow Lagoon... until I traveled to Barrow, set the game to timelapse 72 hours (via trainer), turned around, and there was the ever-so-illusive moose at Barrow, the first and only time I've ever seen it. Same goes for all animals everywhere else. That's how I killed three grizzlies west of Wallace Station within five minutes. That's also how I killed three bull meese in Tall Trees within 10 minutes. Just sleep as long as you can or blackout a couple times. Either that, or save and reload.

Looking away from a known spawn of any animal will usually let it spawn in. Here's a great example of this with the [bull moose up at Colter](https://youtu.be/JAZfloo_5GA). And another example of the [bull moose at Lake Isabella](https://youtu.be/L4Ve1vLbIWU).

### Studying evasive/aggressive animals effectively.

Having trouble studying aggressive and/or skittish animals? Hit them in a non-critical area with a **Poison Arrow** or **Poison Throwing Knife**. This changes their aggro and makes them flee, allowing you to study and track them as they run. Alternatively you can try to land a critical hit, but I've yet to find any gun which can land crits consistently.

### Collecting animals which land in deep water.

Hunting loons, seagulls, or water snakes? Use a boat. Any boat will do. One edge of the boat needs to be quite close to the carcass you're meaning to collect, so it can take some getting used to. Most boats in the game, even the short wooden pirogues are high enough that the pickup animation will clip.

### Farming gritty fish meat for potent predator bait.

Method 1:

1. Set up camp just west of **Prinz & Co**.
2. Fish on the banks for **Longnose Gar**.
3. After catching one, walk to your already-set-up camp nearby and select the "Cook" option.
4. Your screen will go black and you'll reappear at the fire cooking the first piece of fish.
5. Store or eat the first cooked piece
6. Back out of the cooking menu
7. Leave the campfire.
8. Rinse and repeat.

Method 2:

1. Go to **Lagras**.
2. Fish off of the docks around the settlement.
3. You'll be feeling for **Bullhead Catfish**, **Bluegill**, **Channel Catfish**, and **Longnose Gar**. Neither **Rock Bass** nor **Perch** spawn around **Lagras**, so you've not to worry about snagging one of those bastards. On the flip side, you may get **Smallmouth/Largemouth Bass**, **Chain Pickerel**, and/or **Lake Sturgeon**, but all their bite sequences are different from what you want. See [Weather, Baits, and Bite Sequences](#weather-baits-and-bite-sequences) for details.

### Farming wild animals.

Most animals will decompose within 24 hours, aside from massive class animals which decompose to bones, then fully decompose. All animal carcasses from those classified as "massive" (elk, moose, bison, bears, etc) will go to bones 36 hours after being killed, then fully decompose in 72 in-game hours.

If you're looking to farm animals for pelts, it's best to get rid of the carcass completely to skip the decomposition process. I've found three ways of going about this:

1. Sell the carcass whole to the **Trapper** or a **Butcher**.
2. Shimmy the carcass into to a body of water deep enough for the carcass to float. This works when you don't want to lug around a carcass you don't want to haul and sell.
3. Burn the carcass. I've had super spotty success with this, which is why I advise more to use the first two methods. Sometimes burning the carcass still leaves bones, where as donating/selling the carcass completely gets rid of it for sure and leaving it floating in even semi-deep water does the job more consistently.

You can attract scavenger birds and mammals by leaving a freshly killed carcass out in the open, then watching it from afar. Most areas will spawn rats, vultures, hawks, eagles, etc, over the carcass.

### List of Materials for Satchel, Camp, and Trapper

**Satchel**

Item | Quantity
:--- | ---
Deer Pelt | 7
Buck | 1
Elk | 2
Badger | 1
Squirrel | 1
Panther | 1
Bison | 1
Raccoon | 1
Boar | 1
Iguana | 1
Beaver | 1
Rabbit | 1
Cougar | 1
Wolf | 1

**Camp Upgrades**

Item | Quantity
:--- | ---
NA | NA

### How to get perfect skins, pelts, hides, etc.

**NOTE:** If you're on PC, there are tons of [Mods](#mods) available which alter pelt cleanliness, gun damage, etc.

According to my own testing, all "varmints" can be skinned for a perfect pelt when headshot with a regular arrow except for the **Skunk** and **Gila Monster**. You're still chancing it not being perfect, though. Same goes for killing small birds (robins, woodpeckers, etc) and animals (rats, frogs, etc) with the **Varmint Rifle**. The **Varmint Rifle** itself is interesting, though. You get a huge range buff for trading off pelt damage. From my experience it seems like every fourth or fifth kill ends up perfect, so about a 20-25% chance of keeping the "perfect" quality of a small bird/animal. After completing story mode and free roaming in Epilogue, I highly recommend switching to the **Varmint Rifle** when hunting birds. Small animals like frogs and even flightless birds like Quail are quite easy to hit with a **Small Game Arrow**. But going after some Pigeons or Woodpeckers in-flight with a Bow and Small Game Arrows has always driven me mad because the arrows can only hit below a certain aim angle and are also limited by range. The Varmint Rifle's low chance of perfect carcasses is worth the range tradeoff if you know what you're looking for and where to find a lot of them.

Below is a chart showing the ideal weapon for all animals when shooting for perfect pelts. [Source.](https://redd.it/a3afo9)

Class | Weapon(s) | Animal(s)
:--- | --- | ---
Small Game | Bow (Small Game Arrow) | Bullfrog<br>Toad<br>Snake<br>Blue Jay<br>Songbird<br>Macaw (Parrot)<br>Cardinal<br>Sparrow<br>Pheasant<br>Waxwing<br>Woodpecker<br>Quail<br>Crow<br>Carolina Parakeet<br>Raven<br>Oriole<br>Chicken<br>Rooster<br>Booby<br>Pigeon<br>Duck<br>Robin<br>Loon<br>Gull<br>Bat<br>Squirrel<br>Rat<br>Chipmunk
Moderate Game | Varmint Rifle | Beaver<br>Eagle<br>Owl<br>Crane<br>Pelican<br>Cormorant<br>Spoonbill<br>Egret<br>Heron<br>Turkey<br>Hawk<br>Vulture<br>Condor<br>Goose<br>Iguana<br>Gila Monster<br>Rabbit<br>Armadillo<br>Badger<br>Muskrat<br>Opossum<br>Raccoon<br>Skunk
Medium Game | Normal Arrow<br>Poison Arrow<br>Throwing Knife<br>Poison Throwing Knife<br>Repeater<br>Rifle<br>Sniper Rifle | Coyote<br>Fox<br>(Domestic) Pig
Large Game | Normal Arrow<br>Poison Arrow<br>Poison Throwing Knife<br>Rifle<br>Sniper Rifle | Boar<br>Pronghorn<br>Goat<br>Buck<br>Deer<br>Cougar<br>Sheep<br>Panther<br>Collared Peccary<br>Bighorn Ram<br>Wolf<br>Alligator (Small)<br>Turtle
Massive Game | Improved Arrow<br>Poison Arrow<br>Poison Throwing Knife<br>Rifle<br>Sniper Rifle<br>Shotgun Slug | Alligator<br>Grizzly/Black Bear<br>American Bison<br>Rocky Mountain Cow/Bull Elk<br>Western Cow/Bull Moose<br>Angus/Devon/Hereford Bull<br>Angus/Devon Ox<br>Florida Cracker Cow

# FISHING TIPS

- Contrary to compendium entries, weather doesn't seem to make a damn difference in spawn/bite rates.
- Certain fish are more attracted to certain lures/baits, but quick-pressing RT will attract all fish to your lure/bait. Be that as mit may, some may not necessarily nibble/bite it. Flicking RT more than once while fish are near the bait/lure will scare them off.
- The regular **Swamp/River/Lake Lures** are consumable.
- The **Special Swamp/River/Lake Lures** are a permanent inventory item and cannot be lost by any means, including line snaps.
- **Cheese/Bread/Corn/Worm/Cricket/Crayfish** baits can be lost in two ways: either line snaps or an extensive number of bites.
- If you dislike clutter and don't plan on using other types of baits/lures (worms, crayfish, crickets, regular lures), do not buy a whole lot of them as you have to manually lose them. There is no "Discard" option in the satchel for these. The fastest way to get rid of unwanted baits is to cause a line snap. To do this: hook any medium or large fish, then as soon as it's hooked pull and keep LS down while reeling in. Attach another unwanted bait/lure and repeat. Irritating, innit?
- Small fish will not even nibble on lures of any type except for the **Special Spinner**. They will only hit on consumable baits.
- The **Special Spinner** attracts all species of fish and all species will bite it. Everything from bluegill to northern pike. Once acquired, it is a permanent inventory item and cannot be lost due to cutting or snapping the line.
- **Special Lures** count as their regular counterparts in the **Compendium** Fish entries. As in, you can catch a **Channel Catfish** with either a **Regular** or **Special Swamp Lure** as both count towards 100% for that species.
- Push LS down to lower your rod. Keep it down while reeling when awaiting a bite. When you get a bite, pull LS back. This both sets the hook and pulls the fish in at the same time, giving you a head start right off the bat.
- Continue using LS up and down to pull the fish in faster, unless you're a glutton for punishment. Reeling in fish like the **Legendary Muskie** are a bitch if you don't know about using LS to make faster progress. I learned the hard way, you needn't.
- All fish have a specific pattern of nibbling/biting. Once you can recall what fish do what, you won't even need to use Eagle Eye to see what's down there.
- There is no direct way to break down large fish like Pike or Gar. See [Break Down Large Fish](#break-down-large-fish) for the hacky method.

### Weather, baits, and bite sequences.

Name | Active Weather | Favorite Bait | Area(s) | Bite Sequence<br>`N` = Nibble<br>`B` = Bite | Meat Type and Quantity
:--- | --- | --- | --- | --- | ---
Bluegill | Rain | Cheese | Pretty much everywhere. | NB | 1 Gritty
Bullhead Catfish | Rain | Corn | Lagras, Bayou Nwa, LE<br>Kamassa River, Bayou Nwa, LE (from west of **Lagras** to **Crawdad Willies**)<br>Lannaheechee River, Bayou Nwa, LE (east of **Lagras**) | NNNBB | 1 Gritty
Perch | Sunny | Bread | Everywhere north of the **Upper Montana River** | NB | 1 Flaky
Rock Bass | Sunny | Cheese | Pretty much everywhere. | NBB | 1 Flaky
Chain Pickerel | Sunny | Corn | Pretty much everywhere. | BNNB | 1 Flaky
Redfin Pickerel | Sunny | Bread | Dakota River, Heartlands, NH (from **Little Creek River** mouth to **Bard's Crossing**)<br>Upper Montana River, Big Valley, WE (from southeast of **Owanjila** to **Flat Iron Lake**)<br>Ringneck Creek, Scarlett Meadows, LE<br>Kamassa River, Bayou Nwa, LE (west-northwest of **Bayall Edge**)<br>Kamassa River, Bluewater Marsh, LE (**Trapper's Cabin** to northeast of **Maclean's House**)<br>Lannaheechee River, Bayou Nwa, LE (east of **Lakay**)<br>Lannaheechee River, Scarlett Meadows, LE (south of **Shady Belle** to south of **Catfish Jacksons**)<br>Aurora Basin, Tall Trees, WE<br>Lower Montana River, Tall Trees, WE (the entire river)<br>Stillwater Creek, Hennigan's Stead, NA<br>San Luis River, Hennigan's Stead, NA (all the way to **Sea of Coronado**)<br>Lake Don Julio, Rio Bravo, NA | NBB | 1 Flaky
Smallmouth Bass | Rain | Cricket | Lannahechee River, Bluewater Marsh, LE (from **Copperhead Landing** to **Van Horn Mansion**)<br>Lagras, Bayou Nwa, LE<br>Kamassa River, Bayou Nwa, LE (from **Macomb's End** to east of **Hill Haven Ranch**)<br>Ringneck Creek, Scarlett Meadows, LE<br>Kamassa River, Bayou Nwa, LE (east of **Prinz & Co.**)<br>Lannahechee River, Scarlett Meadows, LE (southwest of **Shady Belle**)<br>Flat Iron Lake, Scarlett Meadows, LE (around shipwreck islands)<br>Dakota River, Heartlands, NH (northeast of **Painted Sky**)<br>Upper Montana River, Big Valley, WE<br>Lake Don Julio, Rio Bravo, NA | NNBB | 2 Flaky
Largemouth Bass | Rain | Crayfish | Kamassa River, Bluewater Marsh, LE (from **Houseboat** to **Fishing Spot**)<br>Canebreak Manor, Bluewater Marsh, LE (north of **Canebreak Manor**)<br>Kamassa River, Scarlett Meadows, LE (from west of **Bayall Edge** to north of **Caliga Hall**)<br>Lannahechee River, Bayou Nwa, LE (from **Crawdad Willies** to south of **Shady Belle**)<br>Flat Iron Lake, Scarlett Meadows, LE (around southern islands west of **Braithwaite Manor**)<br>Gill's Landing, Heartlands, NH (southwest of **Gill's Landing**)<br>Bard's Crossing, Heartlands, NH (from **Bard's Crossing** to southeast of **Lone Mule Stead**)<br>Upper Montana River, Big Valley, WE (south of **Fort Riggs**)<br>Aurora Basin, Tall Trees, WE<br>Stillwater Creek, Hennigan's Stead, NA | BBBNB | 2 Flaky
Steelhead Trout | Rain | Worm | Kamassa River, Roanoke Ridge, NH (from northwest of **Maclean's House** to east of **Maclean's House**)<br>Lannahechee River, Scarlett Meadows, LE (southwest and southeast of **Catfish Jacksons**)<br>Flat Iron Lake, Scarlett Meadows, LE (from **Clemens Point** to southeast of **Gill's Landing**)<br>Dakota River, Heartlands, NH (from **Limpany** to **Bard's Crossing**)<br>Quaker's Cove, Great Plains, WE<br>Lower Montana River, Tall Trees, WE (northwest of **Stillwater Creek**)<br>San Luis River, Hennigan's Stead, NA (from **Brittlebrush Trawl** to the base of **Manteca Falls**)<br>San Luis River, Gaptooth Ridge, NA (southeast of **Scratching Post**) | NBBB | 2 Succulent
Sockeye Salmon | Overcast | River Lure | Kamassa River, Roanoke Ridge, NH (from southwest of **Huron Glen** to south of **Fort Brennand**)<br>O'Creagh's Run, Grizzlies East, AM<br>Dakota River, Cumberland Forest, NH (from **Bacchus Bridge** to north of **Chadwick Farm**)<br>Whinyard Strait, Grizzlies West, AM<br>Dakota River, Big Valley, WE (from **Cumberland Falls** to northwest of **Painted Sky**)<br>Little Creek River, Big Valley, WE (all west of **Watson's Cabin**)<br>Owanjila, Big Valley, WE (both the northwest side of **Owanjila** and creek feeding into it) | BNB | 2 Succulent
Lake Sturgeon | Overcast | Lake Lure | Lannahechee River, Bluewater Marsh, LE (southwest of **Copperhead Landing**)<br>Lagras, Bayou Nwa, LE<br>Kamassa River, Bayou Nwa, LE (from **Siltwater Strand** to northeast of **Prinz & Co.**)<br>Flat Iron Lake, Heartlands, NH (all around **Gill's Landing**)<br>Flat Iron Lake, Great Plains, WE (south of 'H' in "WEST ELIZABET**H**") | NNNNBBBB | 8 Flaky
Muskie | Overcast | Lake Lure | Lannahechee River, Roanoke Ridge, NH (from **Van Horn Trading Post** to **Van Horn Mansion**)<br>Lannahechee River, Roanoke Ridge, NH (southeast of **Annesburg**<br>Kamassa River, Roanoke Ridge, NH (from **Willard's Rest** to **Feral Man's Cave**)<br>O'Creagh's Run, Grizzlies East, AM<br>Calumet Ravine, Grizzlies East, AM (to **Donner Falls**)<br>Lake Isabella, Grizzlies West, AM<br>Owanjila, Big Valley, WE | BNBNBBB | 8 Flaky
Channel Catfish | Overcast | Swamp Lure | Lannahechee River, Bayou Nwa, LE (east of **Lakay**)<br>Lagras, Bayou Nwa, LE<br>Kamassa River, Bayou Nwa, LE (from **Maclean;s House** to **Prinz & Co.**) | NNNB | 4 Gritty
Longnose Gar | Overcast | Swamp Lure | Lagras, Bayou Nwa, LE<br>Bayall Edge, Bayou Nwa, LE<br>Kamassa River, Bayou Nwa, LE (southeast of **Caliga Hall** to **Crawdad Willies**) | NNNNNNNB | 6 Gritty
Northern Pike | Overcast | River Lure | Lannahechee River, Roanoke Ridge, NH (north of **Van Horn Trading Post**)<br>Kamassa River, Roanoke Ridge, NH (from **Brandywine Drop** to southwest of **Beaver Hollow**)<br>Dakota River, Cumberland Forest, NH (from northwest of **Fort Wallace** to west of **Valentine**)<br>Cattail Pond, Grizzlies West, AM<br>Lake Isabella, Grizzlies West, AM | BBBBBB | 8 Flaky

# PLANT/HERB LOCATIONS

Plant | Location(s)
:--- | ---
Vanilla Flower | **Bayou Nwa, LE** (highest concentration is around **Bayall Edge**)
English Mace | East of **O'Creagh's Run**; northwest of **Martha's Swain**. Only 5 plants.<br>East of **Mysterious Hill Home**; "You don't see this every day..."<br>North and northeast of **MacFarlane's Ranch** in **Hennigan's Stead, NA**<br>Along the southern edges of **Hennigan's Stead, NA**, **Rio Bravo, NA**, and southeastern **Gaptooth Ridge, NA**. All along the **San Luis River** from the 'H' in "WEST ELIZABETH" to a bit west of **Scratching Post, Gaptooth Ridge, NA**. Does not grow near the water's edge like Milkweed/Bulrush. It grows a bit inland from the river.
Wild Feverfew | Sporadically across **Hennigan's Stead, NA** and **Cholla Springs, NA**.
Red Sage | Only in **Rio Bravo, NA**, primarily around **Fort Mercer**.
Sparrow's Egg Orchid | NE of second 'O' in "RIO RRAV**O**".

# ITEM LOCATIONS

- Some information taken from [Chest & Lockbox Locatons](https://redd.it/9th89h/).
- Items in containers (lockboxes, chests, cabinets, wardrobes, etc) will respawn regardless of rarity. Rare items (i.e. Aged Pirate Rum) do not respawn unless they're in a container. Respawnable items are bolded in these lists for simplicity sake.
- New years day 2022, all non-respawning items respawned. Unsure if the game has something coded into it for refreshing every year.

### Ginseng Elixir

*Adds health experience.*

Location | Details
:--- | ---
**Cairn Lodge, Grizzlies West, AM** | in lockbox under bed inside the lodge
Dakota River, Grizzlies West, AM | by a tree on the island; west of **Lucky's Cabin**
**Six Point Cabin, Cumberland Forest, NH** | in a lockbox inside the cabin; inaccessible in Epilogue
**Cumberland Forest, NH** | lockbox in abandoned mail coach; first junction northeast of **Six Point Cabin**
**Carmody Dell, Heartlands, NH** | wardrobe upstairs
**Twin Stack Pass, Heartlands, NH** | in a chest under a wagon at the double-junctions; south of Cornwall Kerosene and Tar)**
Bottle Tree, Heartlands, NH | in the fork of the bottle tree, south of **Oil Derrick**
Oil Derrick, Heartlands, NH | on a crate near the derrick
Bard's Crossing, Heartlands, NH | base of large tree near cliff edge; west of **Flatneck Station**
Fire Lookout Tower, Roanoke Ridge, NH | top of tower; northeast of **Emerald Station**
Pleasance, Scarlett Meadows, LE | southernmost building on south side of road
Saint Denis, Bayou Nwa, LE | top deck of **Maria Isabella** in the southwest docks
Watson's Cabin, Big Valley, WE | northwest of **Wallace Station**
The Loft, Grizzlies East, AM | top of lookout tower
Millesani Claim, Grizzlies West, AM | easternmost shack; southeast of **Mount Hagen**
Hermit Woman's Shack, Big Valley, WE | high shelf
Black Bone Forest, Big Valley, WE | next to a bag, cans, and a compass between four large rocks; northeast of **Big Valley Trapper**
Owanjila Dam, Big Valley, WE | between tree and rock on shoreline; just west of the dam itself
Fort Riggs, Big Valley, WE | on a shelf inside the dilapidated schoolhouse
Manzanita Post, Tall Trees, WE | atop table next to stew pot over campfire
Aurora Basin, Tall Trees, WE | in a lockbox at the random Skinner campsite on the east shore
**Cholla Springs, NA** | lockbox on abandoned white wagon; northwest of **Mercer Station**

### Aged Pirate Rum

*Adds stamina experience.*

Location | Details
:--- | ---
Hani's Bethel, Heartlands, NH | inside chimney; northeast of **Heartland Overflow**
**Twin Stack Pass, Heartlands, NH** | lockbox atop northern cliff's edge; southwest of **Cornwall Kerosene and Tar**
Gill Landing, Heartlands, NH | inside the cabin atop some barrels under a taxidermied *Muskie* to the right of the fireplace
Clemens Point, Scarlett Meadows, LE | in a wrecked teal colored boat on southern shoreline
Clemens Point, Scarlett Meadows, LE | during Lemoyne Raider `Captive` random event just south of **Horse Fence**; can happen in other places around **Scarlett Meadows**; in a large chest next to a Lemoyne Raider campsite
**Flat Iron Lake, NH** | lockbox inside a wrecked pirate ship on largest island directly west of **Clemens Point**
Braithwaite Manor, Scarlett Meadows, LE | atop a barrel beside a fishing shack and dock on far west shore; slightly northwest of **Braithwaite's Secret**
Bolger Glade, Scarlett Meadows, LE | second floor of **Abandoned Church** next to some ammo 
Bolger Glade, Scarlett Meadows, LE | atop a crate under the *Boat in Tree* along shoreline; south of **Bolger Glade**
**Catfish Jackson's, Scarlett Meadows, LE** | lockbox on west side of house
**Shady Belle, Bayou Nwa, LE** | lockbox under barn southeast of main house
Saint Denis, Bayou Nwa, LE | atop a piano on the second floor above the **Saint Denis Gunsmith**; only accessible during the associated `Shop Robbery` mission
Fort Brennand, Roanoke Ridge, NH | atop a cabinet in the basement cellar
Van Horn Trading Post, Roanoke Ridge, NH | with a compass underneath large rock off next to the stone path leading to lighthouse
**Brandywine Drop, Roanoke Ridge, NH** | lockbox on cliff inside waterfall
Cotorra Springs, Grizzlies West, AM | in the southernmost freight car of a crashed train; east of **Granite Pass/Whinyard Strait**; jump in from cliff overhead to the east
Cumberland Forest, NH | reward for completing `Moonshiner` random event; at the 'E' in "CUMBERLAND" only during the first encounter; can occur at other places 
**Grizzlies East, AM** | lockbox on cliffside south of train tracks; northwest of **O'Creagh's Run**; climb down ledges from above first 'I' in "GR**I**ZZLIES EAST"
**Mount Hagen, Grizzlies West, AM** | in lockbox on top floor of watch tower; southeast side of Mount Hagen; east of **Micah's Hideout**
Mount Shann, Big Valley, WE | base of a trailside boulder near a compass, bedroll, and some ammo; northeast of **Beryl's Dream**
Blackwater, Great Plains, WE | atop a yellow windmill south of a beige house; southwest of **Blackwater**
Stillwater Cabin, Hennigan's Stead, NA | atop a table across from the bed inside the cabin
**McFarlane's Ranch, Hennigan's Stead, NA** | lockbox under bed inside blacksmith barn
Mercer Station, Cholla Springs, NA | in the window of a dilapidated cabin next to railroad tracks
Solomon's Folly, Gaptooth Ridge, NA | on a shelf in the basement cellar

### Valerian Root

*Adds dead eye experience.*

Location | Details
:--- | ---
Heartlands, NH | lockbox under small table at O'Driscoll campsite; southwest of **Downes Ranch**
Limpany, Heartlands, NH | saloon second floor window facing northeast
Caliban's Seat, Heartlands, NH | atop a cliff at a small campsite
Larned Sod, Heartlands, NH | over fireplace in cabin
Emerald Ranch, Heartlands, NH | atop the windmill
Old Trail Rise, Scarlett Meadows, LE | inside cellar wardrobe; north of **Scarlett Meadows Stable**
Old Greenback Mill, Scarlett Meadows, LE | north side of roof in square vent hole
Lannahechee River, LE | second floor window of dilapidated building; climb hanging boards on northwest side; building is northwest of **Crawdad Willies**
Shady Belle, Bayou Nwa, LE | on some crates; northwest of main house
Dakota River, Heartlands, NH | under a rock along the north shore next to a fishing pole; west of **Painted Sky**
Grizzlies East, AM | west side of **Ambarino Bridge**; enter through boards on west side; southeast of **The Loft**)
Cotorra Springs, Grizzlies West, AM | in the southernmost freight car of a crashed train; east of **Granite Pass/Whinyard Strait**; jump in from cliff overhead to the east
**Beaver Hollow, Roanoke Ridge, NH** | chest in very back of Murphy Brood cave
Annesburg, Roanoke Ridge, NH | atop the mineshaft tower; guards will attack you
Hanging Dog Ranch, Big Valley, WE | top floor of barn
Pagan Ritual Site, Big Valley, WE | south of **Big Valley Trapper**; northwest of **Owanjila**
Owanjila, Big Valley, WE | next to a boulder with a fishing rod near the southwest water line
Strawberry, Big Valley, WE | general store basement; accessible when robbing the shop
Big Valley, WE | on a crate next to an old cabin northeast of **Fort Riggs**
Beecher's Hope, Great Plains, WE | by a lone tree southeast of **Beecher's Hope**
**Armadillo, Cholla Springs, NA** | lockbox in abandoned campsite east of **Armadillo**
**Tumbleweed, Gaptooth Ridge, NA** | lockbox at foot of one of four wagons; southwest of **Tumbleweed**

### Pamphlets

*All pamphlets can be purchased from a Fence. Some pamphlets can be obtained in the open world.*

Pamphlet | Location
:--- | ---
Special Miracle Tonic | Lockbox under bloodstained green tent on plateau southeast of **Vetter's Echo, Big Valley, WE**
Special Health Cure | Chest at the scaffolding of **Face in Cliff, Grizzlies East, AM**<br>reward for recovering Dr. Alphonse Renaud's medical wagon during `No Good Deed`
Special Bitters | Lockbox next to open luggage near destroyed wagon and crates scattered on the ground just south of **Owanjila Dam, Big Valley, WE**
Special Snake Oil | Under floorboard in a small dilapidated shack along the railroad tracks east of **Eris Field, Scarlett Meadows, LE**
Special Horse Stimulant | Chest under desk in the Sheriff building of **Limpany, Heartlands, NH**<br><br>reward from **William**
Special Horse Medicine | Chest underneath stairs in southeast corner of **Fort Brennand, Roanoke Ridge, NH**
Special Horse Reviver | Lockbox in tree stump southwest of **Hill Haven Ranch, Scarlett Meadows, LE**
Dynamite Arrow | Lockbox under bridge south of **Wapiti Indian Reservation**.
Explosive Slug | Chest outside an Alchemist’s burned down house nearby the train tracks between **Gaptooth Ridge** and **Cholla Springs**.
Incendiary Buckshot | Lockbox under the floorboards of the dilapidated cabin at **Copperhead Landing**.
Volatile Dynamite | Lockbox underneath wagon at **Hani's Bethel**.
Volatile Fire Bottle | Lockbox at **Brush Fire**.
Homing Tomahawk | Lockbox inside **Flattened Cabin**.
Horse Meal | Reward for completing Kieran's request for Burdock Root (during Chapter 3).
Poison Arrow | Lockbox beside the **Mysterious Hill Home**.
Poison Throwing Knife | Under floorboard of long dilapidated shack north of **Saint Denis** west of the train tracks.<br>Lockbox at poachers' camp during `Hunting - Charles`

### Documents

(!) Missable<br>
(?) Obtainable with Photo Mode Glitch

**CHAPTER II**

Document | Location
:--- | ---
Oil Company Letter to Cornwall (!)<br>Mining Company Letter to Cornwall (!) | in private train car during `Who the Hell is Leviticus Cornwall`.
Letter to Curtis from M | Looted from Sheriff Malloy.
Letter from Cornwall Kerosene and Tar (!) | Looted from corpse at Oil Derrick in **Heartlands, NH**.
Letter to Brother Rodolfo (!) | Looted from body of Jesuit Missionary in southwest **Gaptooth Ridge, NA**.
Watson's Scrapbook Page (!) | Final encounter at **Watson's Cabin, Big Valley, WE**.
Lemoyne Raiders Letter | Looted from Lemoyne Raiders during random events.
Letter from Martha to Garfield | On the table at **Martha's Swain, Grizzlies East, AM**.
Letter from Garfield to Martha | On Garfield himself, bayonetted to a tree, at **Bolger Glade, Scarlett Meadows, LE**.
Lost Letter to Bonnie (!) | Looted from body next to boat southeast of **Flatneck Station, Heartlands, NH**.
Letter to Uncle Lewis from Elijah (!) | Looted from body near water's edge southwest of **Shady Belle**.
Family Photo<br>Newspaper Scrap | Under floorboard next to shackle holds and on the table near bed (respectively) at **Old Harry Fen, Scarlett Meadows, LE**.
Letter to the Editor (!)<br>Letter to Edmund from Mother (!) | On the countertop during `American Dreams`.
Mysterious Writing (5 Sketches) | Collected during the entire event sequence in **Saint Denis, Bayou Nwa, LE**.
Letter to Henrietta Douglas<br>Letter to William Errington<br>Letter to the Saint Denis Times Tribune<br>Letter to Judge Finley<br>Letter to Miriam Wegner | Lockbox in an abandoned mail coach southwest of **Fort Wallace, Cumberland Forest, NH**.
Letter from St. Luke's Academy (!) | Loot worker killed by wolf at **Appleseed Timber Company** during the third encounter. MISSABLE.
Letter to the doctor from Donal | Looted from **Valentine Doctor**.
Letter to Mayor Timmins from Belinda (!) | Looted from Mayor Nicholas Timmins in **Strawberry, Big Valley, WE** before attending all encounters with him. MISSABLE.
Note to Ma | Looted from self-appointed law thugs in **Van Horn, Roanoke Ridge, NH**.
Dear Annabella Poem<br>A Day's Walk Poem | In the top left drawer of the desk at **Vetter's Echo, Big Valley, WE**.
Wedding Certificate | Lockbox next to crashed wagon at cliff base of **Monto's Rest, Big Valley, WE**.
Note from Jim<br>Letter to Jim from Mildred | Doorstep of **Leonora View, Big Valley, WE**. The letter can be obtained 24 hours after obtaining the Note from Jim.
Bride Photograph (!) | Looted from the corpse of Jim during random encounter associated with crashed wagon at **Monto's Rest, Big Valley, WE**.
Note from Robert Elliot Patchen | Found underneath the Nevada Hat behind the waterfall at **Granite Pass, Grizzlies East, AM**.
Letter from Annette to Claude (!) | Looted from corpse outside **Robard Farm, Scarlett Meadows, LE**.
Mysterious Sermon | On the desk at **Hani's Bethel, Heartlands, NH**.
Letter to Glen and Eddie from Momma<br>Otis Miller and the Arabian Prince | In/on the nightstand at **Clawson's Rest, Grizzlies West, AM**.
Letter to Pa | Looted from any bank clerk. Recommend looting clerk at **Lemoyne National Bank** in **Saint Denis, Bayou Nwa, LE**.
Faded Letter | In lockbox next to tree on northern side of islands west of **Sisika Penitentiary, Bluewater Marsh, LE**.
Letter to Bubba from Jillian | Looted from residents of **Strawberry, Big Valley, WE** or **Valentine, Heartlands, NH**.
Letter to Mother from Miles | Looted from older female NPCs in **Blackwater, Great Plains, WE**.
Letter to Jacob from Father | Looted from older male NPCs in **Blackwater, Great Plains, WE**.
Letter to Mandy | Looted from male NPCs in **Blackwater, Great Plains, WE**.
Letter to Alfred from Annabel<br>Letter to Alfred from Matilda | Looted from rich male NPCs in **Blackwater, Great Plains, WE**.
Letter from Ms. Hobbs (!) | Arrives at post office after Arthur has completed the fourth `Hunting Request` before the Epilogue.
Letter to Nigel from Tom (!) | Looted from Nigel (Gavin's friend) before all encounters completed.
Letter to Martin from Father | Looted from U.S. Army soldiers. (At Fort Wallace.)
Letter to Margaret from Arnold | Looted from rich female NPCs in Rhodes.
Letter from Scruffers & Co. Publishers | Looted from rich female NPCs in **Rhodes, Scarlett Meadows, LE**.
Letter from Scruffers & Co. Publishers | Looted from rich male NPCs in **Rhodes, Scarlett Meadows, LE**.
Letter from Scruffers & Co. Publishers | Looted from rich male NPCs near **Bastille Saloon** in **Saint Denis, Bayou Nwa, LE**.
Note to Mother | Looted from older, rich female NPCs in **Saint Denis, Bayou Nwa, LE**.
Letter from Miss Marjorie (!) | Received from Ticket Taker after watching Miss Marjorie and her team's performance at **Theatre Raleur** in **Saint Denis, Bayou Nwa, LE.
Molly's Poem (?) | Found at Dutch's tent.
Bill's Dishonorable Discharge (?) | Found at Hosea's tent.
Letter from Lenny's Father (?) | Found at Hosea's tent.
Letter to Zhou Yi from Zhou Wei (!) | Looted from corpse of Zhou Yi in a campsite northeast of **Armadillo, Cholla Springs, NA**.
Letter to Herbert from Herberta | Looted from **Herbert Moon**, owner of the **General Store** in **Armadillo, Cholla Springs, NA**.
Letter to Momma (!) | Looted from a corpse dumped by two men on the west edge of **Armadillo, Cholla Springs, NA**.
Unfinished Letter (!) | Looted from a corpse during random encounter with the undertaker in **Armadillo, Cholla Springs, NA**.
Letter to Mavis from Larry | Looted from the owner of the **General Store** in **Tumbleweed, Gaptooth Ridge, NA**.
Nite Folk Victim's Note (!)<br>Nite Folk Wagerer's Note (!) | Looted from hanged corpse either northeast of **Lakay, Bayou Nwa, LE** or southeast of **Trapper's Cabin, Bluewater Marsh, LE**.
Murfree Brood Prisoner's Note (!)<br>Murfree Brood Random Note (!) | Looted from a hanged corpse either southwest of **Manito Glade, Roanoke Ridge, NH** or northwest of **Beaver Hollow, Roanoke Ridge, NH**.
Saint Denis Trolley Rider's Digest | On a small table on the north side of the **Post Office** in **Saint Denis, Bayou Nwa, LE**.
List of Debtors | Obtained during `Money Lending and Other Sins I`.
Civil War Report | In a chest in the basement at **Fort Brennand** in **Roanoke Ridge, NH**.
Letter to Pa<br>Meeting Notes | Looted from any rally member during any `Rally` random encounter. (The KKK.)
Missing Person Poster | Outside front wall of **Old Light Saloon** in **Van Horn, Roanoke Ridge, NH**.
Experiment Notes 1<br>Experiment Notes 2<br>Experiment Notes 3<br>Experiment Notes 4 | In the second floor room of the yellow house directly west of **Van Horn, Roanoke Ridge, NH**.
Note from the Sculptor (!) | Looted from hanged corpse at **Face in Cliff** in **Grizzlies East, AM**. North of **Moonstone Pond**.
Dutch's Speech Notes (!) | On a table next to a broken wagon right outside of camp to the east.
English Spelling Practice | On a desk inside a dilapidated school house at **Fort Riggs, Big Valley, WE**.
Property Deed (!) | Obtained during the second encounter with Percy Whitsickle at **Central Union Railroad** in **Roanoke Ridge, NH**. Taking the note after returning it to Percy will prevent the event from progressing. Keeping a copy of the document with RampageTrainer's "Unlimited Items" function does not affect the event progression.
Norwegian Journal Page<br>Norwegian Photo<br>Norwegian Newspaper Scrap | Chimney, under floorboard, and looted from NPCs (respectively) in small house south of main cabin at **Manzanita Post, Tall Trees, WE**.
True Tales of Frank Heck No. 102 | Inside **Lake Don Julio House** in **Rio Bravo, NA**. Also found in **Shady Belle** during Chapter IV.
Hopes for the Future | Obtained from Dr. Macintosh in **Annesburg, Roanoke Ridge, NH**.
Get Rich Quick | Obtained from Timothy A. Donahue northeast of the *Bastille Saloon** entrance in **Saint Denis, Bayou Nwa, LE**.
The Case of the Deceitful German (?) | At Hosea's tent.
The Case of the Shrew in the Fog | On a coffee table inside the farm house at **Hagen Orchards, Bayou Nwa, LE**.
Otis Miller and the Black-Hearted Lady | On a nightstand at **Osman Grove, Roanoke Ridge, NH**.
Otis Miller and the Boy from New York | On a table in the abandoned schoolhouse at **Pleasance, Scarlett Meadows, LE**.
Wild West Heroes No. 132 | On a nightstand at **Downes Ranch, Heartlands, NH**.
Wild Man's Journal (!) | In the Feral Man's cave. Follow him there during the third encounter.
Rambles through Woods and Plains (!)<br>Zoological Compendium (!) | Arthur's tent.
The American Inferno (?)<br>Existence and Oblivion (?) | Dutch's tent.
The Castle Above the Glen (?)<br>The Castle Above the Moor (?) | Karen's tent.
Mary-Beth's Notebook (?) | Karen's tent.
Jail Ledger (?) | On the desk at **Sheriff Office** in **Valentine, Heartlands, NH**.
River Lure Handbill<br>Lake Lure Handbill<br>Swamp Lure Handbill<br>Special River Lure Handbill<br>Special Lake Lure Handbill<br>Special Swamp Lure Handbill | Obtained after purchasing one of the matching lure from the **Bait Shop** in **Lagras, Bayou Nwa, LE**. Must have completed `A Fisher of Fish` before buying.
Eugenics Handbill | Obtained from Norris Forsythe near the Newspaper Boy in **Saint Denis, Bayou Nwa, LE**.
Chelonian Handbill (!) | Obtained only by Arthur from Anders Helgerson at the park/courtyard in **Saint Denis, Bayou Nwa, LE**.
Charity Handbill (!) | Taken from Thomas Downes' table across from the **Stable** in **Valentine, Heartlands, NH**.
Jack's Drawing (!) | Reward for completing Jack's item (thimble) request (given after completing `A Fisher of Men`).
Son's Drawing | Looted from Gunsmith in **Rhodes, Scarlett Meadows, LE**.
Phineas' Business Card | Obtained during `Smoking and Other Hobbies`.
Jeremy's Business Card | Obtained during `A Fisher of Fish`.`
Francis' Business Card | Obtained during `Geology for Beginners`.
Grave Newspaper Clipping | On a table at **Planter's Baun, Grizzlies West, AM**.
Micah Newspaper Scrap<br>Dutch's Wanted Poster<br>Blackwater Ledger Scrap | At Micah's camp on Monto's Rest after `An American Pastoral Scene`.
Bennett Brothers Newspaper Scrap | Looted from Prospector near **Butcher Creek, Roanoke Ridge, NH**, Percy Whitsickle (of the Central Union Railroad events), or from NPCs in **Annesburg, Roanoke Ridge, NH**.
First Bank Robbery Newspaper Scrap (?) | Arthur's tent.
New England Examiner Scrap (?) | Hosea's room in Chapter IV at **Shady Belle, Bayou Nwa, LE**.
Norwegian Newspaper Scrap | Looted from NPCs at **Manzanita Post, Tall Trees, WE**.
Wolves Photograph (!) | Obtained during `Arcadia for Amateurs III`.
Billy Midnight Photograph<br>Black Belle Photograph<br>Emmet Granger Photograph<br>Flaco Hernandez Photograph | Obtained during `The Noblest of Men, and a Woman I`.
Slim Grant Photograph | Obtained during last segment of `The Noblest of Men, and a Woman`.
Erotic Photograph 1<br>Erotic Photograph 2<br>Erotic Photograph 3<br>Erotic Photograph 4<br>Erotic Photograph 5 | Inside a chest at **Rattlesnake Hollow, Cholla Springs, NA**.
Gideon Bennett Bounty Poster | Outside south wall of **Post Office** in **Annesburg, Roanoke Ridge, NH**.
Pieced Together Map | Result of collecting Killer Clue Piece 1, 2, and 3.
Panoramic Map | Held by frozen couple northeast of **Lake Isabella, Grizzlies West, AM**.
Sketched Map | Chimney of **Reed Cottage, Roanoke Ridge, NH**.
Torn Treasure Map 1<br>Torn Treasure Map 2<br>Mended Map | **Manito Glade, Roanoke Ridge, NH**<br>**Hermit Woman's Shack<br>Big Valley, WE<br>Resulting item after collecting both pieces.
High Stakes Treasure Map 1 | Looted from man during random encounter between **Diablo Ridge** and **Riggs Station** in **Big Valley, WE**. Also can be purchased from a **Fence**.
Jack Hall Gang Map | Bought, haggled, stolen, or looted from Maximo during `All That Glitters`.
The Poisonous Trail Map 1 | Lockbox inside **Cairn Lodge, Grizzlies West, AM**.
The Elemental Trail Map 1 | Looted from a hanged corpse dangling from a cliff near the **Sea of Coronado, Gaptooth Ridge, NA**.
Landmarks of Riches Map 1 | Obtained by removing the plaque on the **Obelisk** northwest of **Owanjila, Big Valley, WE**.

**CHAPTER III**

Document | Location
:--- | ---
Letter to Mr. Compson from Col. Nixon<br>Letter of Termination<br>Note to Jeremiah from Bill<br>Note from Rance<br>Diary<br>Ledger | Collected during `The Inquities of History`.
Letter from Charles Chatenay | Arrives at any post office after completing Charles' last mission.
Mine Share (!) | In Trelawny's caravan during `Magicians For Sport`.
Letter to Angelo Bronte (!) | In the living room during `Blood Feuds, Ancient and Modern`.
Beau's Letter | Obtained during `The Course of True Love I`.
Penelope's Letter | Obtained during `The Course of True Love II`.
Letter from Mr. Pearson<br>Shopping List | Obtained during `Further Questions of Female Suffrage`.

**CHAPTER IV**

Document | Location
:--- | ---
Gray Family History Letter (!) | Looted from Tavish Gray on the back porch of the main house at **Caliga Hall, Scarlett Meadows, LE**.
Rare Orchids Order (!) | Posted at all **Post Offices** after completing `Duchesses and other Animals`. Recommend **Valentine, Heartlands, NH** or **Rhodes, Scarlett Meadows, LE**. WARNING: Do not save and reload before collecting the note. It will disappear permanently.
Letter from Micah to Amos (?) | Found on a crate next to the dock house behind **Shady Belle, Bayou Nwa, LE**.
Electric Chair Blueprint (!) | Looted from Professor Andrew Bell III after the product demonstration at the gallows of **Saint Denis**.
Inventor's Note (!) | On a desk in **Doverhill, Roanoke Ridge, NH** during the third mission (encounter) of `A Bright Bouncing Boy`.
Inventor's Plan (!) | On a desk in **Doverhill, Roanoke Ridge, NH** during the third mission (encounter) of `A Bright Bouncing Boy`.
List of Accounts (!)<br>Telegram to Police Chief Lambert (!) | On the desk in Bronte's office during `Revenge is a Dish Best Eaten`.
Farm, Field, and Falconry | Obtained in `Idealism and Pragmatism for Beginners II`.
The Castle in the Field of Lavender (?) | On a bench near the front entrance of **Shady Belle, Bayou Nwa, LE**.
Charles Chatenay's Sketch | Obtained during `The Artist's Way`.
Theater Ticket (!)<br>Algernon's Business Card (!) | Obtained during `The Gilded Cage`. If Arthur saves Algernon Wasp from choking on a peanut, he'll be offered his business card. If Arthur speaks with the smoking NPCs near the mayor about a cabaret show, he'll be offered the ticket.

**CHAPTER V**

Document | Location
:--- | ---
Letter from 'Caroline' (!) | On the kitchen table at **Shady Belle, Bayou Nwa, LE** after returning from **Guarma**.

**CHAPTER VI**

Document | Location
:--- | ---
Liability Agreement (!) | On a table during the last segment of `The Wisdom of the Elders`.
Letter from Charlotte | During the second encounter with Charlotte Balfour at **Willard's Rest**.
Letter to Tom from Colm (!) | Looted from the final O'Driscoll during `Mrs. Sadie Adler, Widow II`.
A letter from Penelope | At Arthur's tent.

**EPILOGUE I/II**

Document | Location
:--- | ---
Cholera Handbill (!) | Obtained from Town Crier in **Armadillo, Cholla Springs, NA**.
America | Obtained during the final segment of `The American Inferno, Burnt Out`.
Letter to Anthony from Dad | Looted from male tourist (wearing black, buttoned up coat) in or around the **Strawberry Welcome Center**.
Telegram from Sadie | Obtained during `Motherhood`.
Bank Credit Letter | Obtained during `Home of the Gentry`.
The Lady of the Manor | Obtained from Mary-Beth during her encounter at the **Post Office** in **Valentine, Heartlands, NH**.
Letter from Tilly (!) | On the dining table at **Beecher's Hope, Great Plains, WE** after encounter with Tilly in **Saint Denis, Bayou Nwa, LE**. She'll be on a bench across the trolley tracks from **Bastille Saloon**. Encounter only appears after completing `A Quick Favor for an Old Friend`.<br><br>WARNING: Do not save and reload before reading the note. Doing so will cause the letter to disappear permanently.

# BOUNTY MISSIONS AND TARGETS

*Monetary rewards for returning the target.*

Name | Gang | Condition | Reward | Poster Location
:--- | --- | --- | --- | ---
Benedict Allbright | None | Alive | $50 | Valentine
Ellie Anne Swan | None | Alive | $25 | Valentine
Joshua Brown | None | Alive | $40 | Strawberry
Bart Cavanaugh | Laramie | Dead or Alive | $60 | Strawberry
Mark Johnson | None | Alive | $25 | Rhodes
Robbie LaidLaw | None | Alive | $35 | Rhodes
Camille de Millemont | Lemoyne Raiders | Dead or Alive | $55 | Rhodes
Anthony Foreman** † | Foreman Brothers | Alive | $85 | Saint Denis
Lindsey Wofford | Lemoyne Raiders | Dead or Alive | $100 | Saint Denis
Elias Green † | Skinner Brothers | Dead or Alive | $90 | Blackwater
Otis Skinner † | Skinner Brothers | Dead or Alive | $75 | Blackwater
Herman Zizendorf † | None | Alive | $30 | Blackwater
Esteban Cortez † | Del Lobo | Dead or Alive | $65 | Tumbleweed
Joaquín Arroyo † | Del Lobo | Alive | $60 | Tumbleweed

- `†` Posted only in 1907.
- `**` Available only if spared in his associated story mission.

# RANDOM EVENTS

### Horse Races

There are three NPCs which will challenge you to a horse race, each with two of their own unique destinations. Winning the first race will allow you to bond with your horse while spurring it. Winning a second will add another mark of speed to whatever horse you have saddled (your main horse).

I have raced the man in Big Valley with a level 2 bonded horse before, so your horse doesn't need to be fully bonded to level 4.

These locations were taken from [this YouTube video](https://youtu.be/QU1fd4OPDuo) and verified manually. Below is a quoted comment on the same video from [this user](https://www.youtube.com/channel/UCdPexLQVoanuYMfe3V6p_jw).

> For The People Who Can’t Get These Races To Spawn<br><br>I have done my research on this by looking into the source code with the stranger and how often the races will spawn so basically as I was looking through the source I found that as Arthur the stats and spawn percentage depending on your chapter is different and this will be a full in depth guide at what I found<br><br>Chapter 1-No Horse Races Spawn For Arthur (because of colter and the game doesn’t expect you down there)<br>Chapter 2- Arthur Has 7 chances of declining during this chapter and the horse spawn rates are (90%)<br>Chapter 3-Arthur has 5 chances of declining and the spawn rates are (79%)<br>Chapter 4-Arthur has 5 chances of declining and spawn rates are (60%)<br>Chapter 5-No Horse Races Spawn For Arthur (because of Guarma)<br>Chapter 6- Arthur has 4 chances of declining and spawn rates are (45%)<br>Epilogue 1-John has 3 chances at declining and spawn rates are (25%)<br>Epilogue 2-John has 3 chances at declining and spawn rates are (10%)<br><br>Now oddly when you beat the game the spawn rate drops to a 2% spawn rate and John for some reason only gets 2 chances to race but it seems with each chapter the world becomes more rainier and spawn rates drop and the world feels more boring and they actually cut a lot of the base chapter encounters from the epilogue so in my opinion if your in the epilogue don’t try this because I got curious the other day and started wandering around in the epilogue and realized the racers weren’t spawning so I got curious and wanted to check for ya’ll and this is probably not worth the attempt if you beat the game and are playing as John

Racer | Area | Location
:--- | --- | ---
White<br>Nokota | Cumberland Falls, Big Valley, WE | Crossroads southeast of **Wallace Overlook**. West side of **Dakota River**. Approach from south.
White<br>Nokota | Fort Riggs, Big Valley, WE | Triple junction northwest of **Fort Riggs**. Approach from **Strawberry Stable**.
Brindle<br>Thoroughbred | Caliga Hall, Bayou Nwa, LE | Road on south side of **Caliga Hall** running parallel to the train tracks. West of the old, dilapidated train station.
Brindle<br>Thoroughbred | Caliga Hall, Bayou Nwa, LE | Road directly in front of (west of) the main house of **Caliga Hall**.
Brindle<br>Thoroughbred | Southfield Flats, Scarlett Meadows, LE | Off the road a bit, next to the train tracks across the path dead east of the **Horse Fence**.
Black<br>American Standardbred | Mossy Flats, Roanoke Ridge, NH | Northwest of **Mossy Flats**. West side of **Kamassa River**. Westernmost path of the junction northbound. Southwest of the beaver dam.
Black<br>American Standardbred | Three Sisters, Grizzlies East, AM | Junction directly north of **Hani's Bethel**. Southeast of **Moonstone Pond**.
Black<br>American Standardbred | Bacchus Station, Cumberland Forest, NH | First junction southeast of **Bacchus Station**. Dead east of **Fort Wallace**.

### Shop/Home Robbery Tips

Location | Type | Tip Target
:--- | --- | ---
Painted Sky, Big Valley, WE | Prisoner<br>In Transit | **Watson's Cabin, Big Valley, WE**

### Moonshiners

Location | Details | Ingredients<br>Needed
:--- | --- | ---
Castor's Ridge, Heartlands, NH | atop the cliff inside the dashed paths southwest of **Castor's Ridge** | 2x Ginseng
Cumberland Forest, NH | southeast of the first 'E' in "CUMB**E**RLAND FOREST" | 2x Indian Tobacco
Bluewater Marsh, LE | southwest of the first 'E' in "BLU**E**WATER MARSH" | 2x Milkweed
Bluewater Marsh, LE | north of first 'E' in "BLU**E**WATER MARSH" | 2x Milkweed
Bluewater Marsh, LE | north of junction north of second 'E' in "BLUEWAT**E**R MARSH" | 2x Oleander Sage
Southfield Flats, Scarlett Meadows, LE | west side of train tracks, southwest of a water tower | 2x Indian Tobacco
Old Harry Fen, Scarlett Meadows, LE | dead south of **Old Harry Fen** | 2x Indian Tobacco
Vetter's Echo, Big Valley, WE | east of **Vetter's Echo** | 2x Ginseng

### Competitive Shooter

Two avid shooters looking for a challenge.

Shooter | Location | Details
:--- | --- | ---
Mexican | Flatneck Station, Heartlands, NH | dead north of **Granger's Hoggery**, inside the train track junctions, just north of the southernmost tracks
Mexican | Heartland Overflow, Heartlands, NH | south of the second 'e' in "Heartland Ov**e**rflow"
Mexican | Twin Stack Pass, Heartlands, NH | southwest of **Twin Stack Pass**, southeast of the first 'E' in "N**E**W HANOVER"
Mexican | Dakota River, Heartlands, NH | west of 't' in "Dako**t**a River", southwest of **Downes Ranch**
Mexican | Big Valley, WE | east side of path dead northbound from **Lenora View**
Gringo | Southfield Flats, Scarlett Meadows, LE | west side of train tracks, southwest of a water tower
Gringo | Ringneck Creek, Scarlett Meadows, LE | in the curve of the creek, southwest of the 'E' in "**E**RIS FIELD"
Gringo | Caliga Hall, Scarlett Meadows, LE | south side of the short railroad bridge northwest of **Shady Belle**
Gringo | Siltwater Strand, Scarlett Meadows, LE | on the dock north of railroad bridge

### Herbalist

Unnamed NPC who tells of the benefits of certain plants.

Location | Details
:--- | ---
Horseshoe Overlook, Heartlands, NH | north of **Limpany**
Cumberland Forest, NH | east side of the path northbound from **Carmody Dell, Heartlands, NH**
Valley View, Big Valley, WE | north side of path northwest of **Valley View**
Strawberry, Big Valley, WE | south shore of **Hawk's Eye Creek**, dead east of **Strawberry Stable**

### William

William, an herbalist pioneer looking to concoct genuine medicines from natural sources, is camped in certain places all around the map. When approached, he will ask you to collect some herbs from the area.

Location | Details
:--- | ---
Lonnie's Shack, Roanoke Ridge, NH | NW across the path
Face Rock, Scarlett Meadows, LE | west of 'A' in "SC**A**RLETT MEADOWS"
Heartland Overflow, Heartlands, NH | N of first 'a' in "He**a**rtland Overflow"
Big Valley, WE | west side of **Dakota River**, dead west of 'k' in "Da**k**ota River"
Mossy Flats, Roanoke Ridge, NH | first 's' in "Mo**s**sy Flats"
Moonstone Pond, Grizzlies East, AM | dead end of path W of pond
Mysterious Hill Home, Grizzlies East, AM | NW of the home

### Soothsayer

A fortuneteller woman of African American heritage. Otherwise more commonly known as "the black lady fortuneteller in the swamp". In foggy weather at 18:00-02:00, she can be found at two different locations: south of **Canebreak Manor**, and northeast of **Bayall Edge**. She can be encountered again three in-game days after the previous encounter.

### Blind Man Cassidy

Gives short, mystifying words of wisdom. He can be found on roadsides all around the map:

Location | Details
:--- | ---
Cornwall Kerosene & Tar, Heartlands, NH | south of the facility
Fort Wallace, Cumberland Forest, NH | southwest of the fort
Annesburg, Roanoke Ridge, NH | southeast of 'E' in "ROANOK**E** RIDGE"
Tumbleweed, Gaptooth Ridge, NA | path eastbound leading out of the town
Blackwater, Great Plains, WE | north of the 'C' in "BLA**C**KWATER"

### Cave Hermit

Found inside a cave southwest of **Stilt Shack, Big Valley, WE**.

### Hermit Man

Found at **Manito Glade, Roanoke Ridge, NH**. A sketch is automatically added to the journal after completing the event.

### Hermit Woman

Found in a shack west of **Stilt Shack, Big Valley, WE**. The site can be inspected and sketched after completing the event.

### Sun Worshipper

[Reference.](https://youtu.be/97ruEliFXt0)

Bob Brownlee is a Sun worshipper who can be found at 12 different locations around New Austin. He spawns only when it is sunny weather after 12:00. He can be encountered again three in-game days after the previous encounter.

See `RDR2-SunWorshipper.jpg` for locations.

### Ghost in Swamp

A physical manifestation of the ghost of a woman, Agnes Dowd, can be seen near a tree west of the **Trapper's Cabin** from 21:00 to 03:00, usually in foggy weather. [Here's a compilation of all possible encounters.](https://youtu.be/P3Tra3O6Rko)

### KKK

*18:00-06:00*

- just south of junctions along **Little Creek River**, dead east of **Valley View** (across path to the east)
- southeast of 'L' in "WEST E**L**IZABETH"

### Ex Soldier

*The guy that has the Native American Ring.*

This is random camp encounter which happens only at night. Appears to be active from 00:00 to 04:00. An ex soldier will invite you to his camp, ask for whiskey, reveal his past, and pass out. Loot him and you get the ring. Its effect(s) is unknown, and nothing immediately noticeable occurs aside from larger random wolf packs. The encounter with the ex soldier has several possible locations:

Location | Details
:--- | ---
Oil Derrick, Heartlands, NH | south of the first 'A' in "THE HE**A**RTLANDS"
Heartland Oil Fields, Heartlands, NH | north of 'H' in "NEW **H**ANOVER"
Face Rock, Scarlett Meadows, LE | east of the first 'E' in ""SCARL**E**TT MEADOWS"
Van Horn Mansion, Roanoke Ridge, NH | just off the water southwest of **Van Horn Mansion**
Doverhill, Roanoke Ridge, NH | east of **Doverhill**
Little Creek River, Big Valley, WE | just southeast of **r** in "Little Creek Rive**r**", dead south of **Watson's Cabin**

### Feral Man

This is a sequence of three random events. The journal item is missable and [it is possible to glitch it out](#unable-to-obtain-wild-mans-journal).

https://reddead.fandom.com/wiki/Feral_Man

### Cave Voice

Once you've studied 30 animals, a flock of Pheasants will spawn on the southwest shore of the lake at **Calumet Ravine, Grizzlies East, AM**. When approached, they'll take off. Follow them to a cave on the northern border of the map southeast of **Fairvale Shanty, Grizzlies East, AM** and interact with an unseen entity. This is widely presumed to be a nod to bigfoot in RDR1.

# MISSABLE CONTENT

*Missable content grouped by chapter.*

**NOTE:** Some stranger missions can be done with only Arthur. This includes certain missions in character strands.

**NOTE:** If you're only concerned with missable cosmetics, Pearson's Scout Jacket and Dutch's Spurs are the only missable cosmetic items.

### Chapter I

*Items:*

- **Mining Company Letter to Cornwall** - Last train car during `Who the Hell is Leviticus Cornwall`
- **Oil Company Letter to Cornwall** - Last train car during `Who the Hell is Leviticus Cornwall`

### Chapter II

*Missions:*

- Money Lending and Other Sins (I, II, III)
- Debt Owed by Mr. Wrobel (see `Antique Watch` in **Items** below)
- Debt Owed by Chick Matthews
- Debt Owed by Lilly Millet
- Good, Honest, Snake Oil (until Chapter 6)
- We Loved Once and True (I, II, III)
- Pouring Forth Oil (I + II)
- Home Robbery with Javier
- Hunting with Charles
- Playing five finger fillet with Lenny
- Event Area missions (3x, look for missable items below) [Video.](https://youtu.be/QUZl1tseOF8)

*Random Events:*

- Rescue Bill Williamson: Random Event outside the camp where you’re getting asked to help safe Bill from some Bounty hunters (Chapter II-IV)
- Fundraiser: (Possible Chapter II – IV)
- Braithwaite's Secret: point of interest, the crazy lady in the outhouse, Gertrude Braithwaite. She is no longer there after Chapter 6
- Horse Races: can be made unavailable if declined once; [Reddit post.](https://redd.it/9yq601)

*Items:*

- **Classic Raccoon Mountain Hat**: looted from **Jon** at **Smithfields Saloon** in **Valentine**; unavailable after Ch. 6
- **Charity Handbill**: on the table of **Thomas Downes’** charity in **Valentine**; he shows up once before `Americans At Rest`, and once again after that mission; his table is outside of the newly built house adjacent the **Valentine Stable**.
- **Dutch’s Speech Notes**: picked up in **Horseshoe Overlook** camp; can be missed if you don’t pick it up before you move to the next camp
- **Native American Ring**: see [Ex Soldier](#ex-soldier).
- **John’s Cattleman Revolver**: You can actually get these as **Arthur** in Ch. 2 missions `Paying a Social Call`, `The Sheep and the Goats`, `Pouring Forth Oil` [Reference.](https://reddead.fandom.com/wiki/John%27s_Cattleman_Revolver#Acquisition)
- **Rare Shotgun**: used by **Hermit Man** at **Manito Glade**
- **Jimmy's Pen**: during `Polite Society, Valentine Style` only if you spare him; makes some (not all) journal entries more neatly written and darker; does not affect sketches)
- **Jack's Drawing**: reward for Jack's item request (Thimble); request available only in Chapter 2; unlocks shortly after `A Fisher of Men`
- **Antique Watch**: during/after `Money Lending and Other Sins II` from the Polish guy named **Wrobel**; you have to open the drawer with the watch, take other things until debt is paid, then run away a bit to the point where **Wrobel** is despawned, then come back and get it
- **Old Brass Compass**: you have to go back into **Sinclair’s Cabin** (not shown on the in-game map) immediately after `Geology for Beginners II` and get it; door will be forever locked after leaving the area
- **Micah Newspaper Clipping** and **Dutch's Wanted Poster**: in **Micah's Camp** after `An American Pastoral Scene`
- **Bucket Hat**: worn by workers at **Appleseed Timber Co.** before it gets deserted; best done during Ch. 2
- **Liberty Hat**: worn by enemies during `An American Pastoral Scene` and stranger mission `A Fine Night For it` during the second wave, may take a few retries before an enemy spawns wearing it
- **Newsboy Flat Cap**: worn by Cornwall's men during `The Sheep and the Goats`
- **Ornate Dagger**: can be picked up after killing the **Vampire** in **Saint Denis** after investigating all **Mysterious Writings** around the city
- **Flaco's Revolver, Granger's Revolver, Midnight's Pistol, Calloway's Revolver**: picked up after killing the associated gunslingers during `The Noblest of Men, and a Woman` stranger missions
- **Scout Jacket**: reward for Pearson's Rabbit request; he will be standing at his wagon drinking beer and whistling. Greet him to enable the request.

*Item Requests:*
- Jack: Thimble (for **Jack's Drawing**; randomly speaks with you after `A Fisher of Men`)
- Pearson: Rabbit Carcass (for the unique **Scout Jacket**; interact while he's behind the wagon table with the cauldron on top drinking a beer 08:00-14:00)
- Abigail: 5$: just after `A Fisher of Men`
- Jack: Comic Book (automatically during `A Fisher of Men`)
- Javier: Oleander (interact while at the games table with his knives)
- Mary-Beth: Fountain Pen (when she is writing in her book behind Arthur's tent; pen found at **Osman Grove**)
- Pearson: Naval Compass (play poker with anyone and he will join you and give you the quest; compass found at boathouse west shore of **Braithwaite Manor** and post-story at **Ridgewood Farm**)
- Sean: Kentucky Bourbon (interact with him while he's making fire bottles sitting at his table behind the tent near the campfire from 00:00-18:00, when you see- that the table has spawned, stay near it)
- Bill: Hair Pomeade (interact while hes sitting on the chair next to his tent)
- Charles: Moonshine (interact while hes working on arrows at the campfire)
- Charles: Oleander (interact while hes working on arrows at the campfire)
- Dutch: Pipe (chapter 2 to 4; interact while he's smoking a cigar outside of his camp)
- Hosea: Book (interact with him while he's reading or read his book(s) at his tent)
- Lenny: Pocket Watch (listen to him talking about his past at the campfire 8am-3pm, he tells a story about his father)
- Susan: Seasoning Herbs (randomly asks; can be any of **Mint**, **Thyme**, or **Oregano**)

### Chapter III

*Missions:*
- `Money Lending and Other Sins IV` - Gwyn Hughes, Winton Holmes
- `The Course of True Love I, II, III`
- `Home Robbery w/ Sean`
- `Fishing w/ Kieran`
- `Fishing w/ Javier`
- `Coach robbery w/ Sean`
- `Coach robbery w/ Bill`
- `Home robbery w/ Sean`
- `Valentine Bank Robbery`: only if you have the DLC.

*Items:*
- Lion's Paw Trinket: stranger mission `He's British, of Course IV`, hold Y to "Take Trophy" after killing the lion, then craft the trinket at a **Fence**
- Mine Share: **Trelawny’s Caravan** in **Rhodes** explored during the mission `Magicians for Sport`
- Rare Rolling Block Rifle: during `Magicians for Sport`, the sniper shooting at from the barn has it
- Golden Shield: Braithwaite mission `Blood Fueds, Ancient and Modern` inside the manor on the fireplace
- Letter to Angelo Bronte: From **Catherine Braithwaite** that can be looted during `Blood Feuds, Ancient and Modern` in the same room of the **Gold Shield**
- Braithwaite Brooch: **Catherine Braithwaite's** corpse after `Blood Fueds, Ancient and Modern`
- Horse Meal Pamphlet: see Kieran's Item Request below
- Theatre Ticket: interact with smoking people at party during `The Gilded Cage`

*Item Requests:*
- Tilly: Necklace, play dominoes with her
- Hosea: American Ginseng
- Kieran: Burdock Root exchanged for **Horse Meal Pamphlet**; interact while he's tending to the horses at camp
- Molly: Pocket Mirror (found at **Martha's Swain**)
- Sadie: Harmonica (found at **Granger's Hoggery**)

### Chapter IV

*Missions:*
- `Money Lending and Other Sins V`
- `High and Low Finance`: Ultimate edition bank robbery in **Rhodes** with Charles
- `Help a Brother Out`
- `Brothers and Sisters, One and All`
- `Fatherhood and Other Dreams (I, II)`
- `Coach Robbery w/ Micah`
- `Coach Robbery w/ Lenny`
- `Hunting w/ Pearson`
- `Rustling w/ Uncle`
- `Arcadia For Amateurs III` will be missable if you don't do it before Epilogue I.

*Random Events:*
- Gray's Secret: available in Chapter 4 and beyond, though getting it in the Epilogue is dodgy. It's the corpse of Tavish Gray on the back porch of **Caliga Hall**.

*Items:*
- Antique Compass: You can get this one BEFORE the mission `A Fine Night for Debauchery`, [best explained here](https://youtu.be/pIqYzmGdqDc)
- Electric Chair Blueprint: Professor Bell's corpse after `The Mercies of Knowledge - VIII`; missed if you don't loot him, available from Chapter IV and onwards
- Letter to Bronte from the mayor: on the table during `The Gilded Cage`; take it at the beginning of the mission before you head out to the others
- List of Accounts: Letter on Bronte's table during `Revenge is a Dish Best Eaten`
- Telegram to Police Chief Lambert: Letter on Brontes table during `Revenge is a Dish Best Eaten`

### Chapter V

**WARNING:** After the mission `That's Murfree Country`, bounty hunting is locked until Epilogue I.

**NOTE:** The Guarma-exclusive animals can be accessed after leaving the island via glitches. OOB glitches still work as of 2021/11/13.

**NOTE:** All Boa snakes can be found at the southeast corner of 'E' in "ARROYO D**E** LA VIBORA".

*Missions:*
- `Savagery Unleashed`: can be missed if you start with Dutch’s mission right after arriving at the island)
- 2 `Random Encounters`: one where you see some guards chasing some prisoners, and one where arthur falls into a pit trap.

*Items:*
- Sun Hat: random enemies wearing it during Chapter 5; most easily collected during  `Savagery Unleashed` and `A Kind and Benevolent Despot`
- Letter from Caroline: found on the table in the mission `Dear Uncle Tacitus`. The mission can be completed without collecting the letter so make sure to collect it.

*Animals:*
- Scarlet Macaw
- Blue and Yellow Macaw
- Great Green Macaw
- Red-Footed Booby
- Red-Tailed Boa Snake
- Rainbow Boa Snake
- Sunglow Boa Snake
- Fer de Lance Snake: can be found on the main map at **Stillwater Creek**. On **Guarma**, you can find it in the sugar cane just below the "AG" in "**AG**UASDULCES".
- Green Turtle: in the water near the beach. You can’t save it in your Compendium but you will get a journal entry.
- Shark: There is a shark stranded at the beach at some point as well but you can’t interact with it.

### Chapter VI

*Missions:*
- `Of Men and Angels (I, II)`: only available if `Brothers and Sisters, One and All` is completed
- `Money Lending and Other Sins (VI, VII)`: J. John Weaters, Arthur Londonderry
- `Do Not Seek Absolution (I, II)`: high honor needed
- `The Course of True Love (IV, V)`
- `Archeology for Beginners`
- `Honor, Amongst Thieves`: agree to help Captain Monroe during `Archeology for Beginners`
- `Mrs. Sadie Adler, Widow (I, II)`
- `The Widow of Willard's Rest (I, II, III)`: 3 stages can be completed only as Arthur

*Items:*
- Owl Feather Trinket: infiltrate the army camp during `Archeology for Beginners` and get the Chanupa without killing anybody; easy to just pistol whip everyone
- Military Mountie Hat: during `Archeology for Beginners`, random soldiers at **Fort Wallace** as well
- Saint Denis Lawman Helmet: during `Goodbye Dear Friend`; WARNING: this one is glitched as you can only keep it on your horse and it has no name in the inventory (so collect on your own risk): you may get the flying raven claw talisman bug as well
- Saint Denis Police Outfit: you can actually keep the outfit; [Video.](https://youtu.be/IkBk2TZef4)
- Liability Agreement: on the table next to money stacks during `The Wisdom of the Elders V`
- Letter to Tom from Colm: looted from the final O'Driscoll (killed by Sadie Adler) on the second floor of the house during `Sadie Adler, Widow II`

### Epilogue I

- Worn Flat Cap: worn during `The Wheel`; get it knocked off and pick it back up
- John's Gambler Hat: worn after `Simple Pleasures`; get it knocked off and pick it back up

### Epilogue II

*Items:*

- Fisherman's Hat: dropped by **Jeremy Gill** during `A Fisher of Fish II`; may be obtained by blowing him up with dynamite at **Gill's Landing** before the Epilogue
- Tornado Boots, Classic Frock Coat, Drifter Hat: Uncle's item request for Peppermint, Hair Pomeade, Kentucky Bourbon, Milkweed, and Skunk Carcass
- Cholera Handbill: collected from the **Town Crier** in **Armadillo** after interacting
- Unfinished Letter: random encounter with undertaker in **Armadillo**; the body he puts in the wagon must be looted before it is thrown into the pit

### Temporary Items

Some items are temporary, but can be retained either via glitch or a trainer function. (RampageTrainer has an "Unlimited Items" code break with prevents the game from removing items from the inventory.)

- Property Deed (second mission for **Central Union Railroad Company**)

# ITEM SELL PRICES

### Animal Skins

*All prices are based on Saint Denis Trapper. Animals listed below each Trapper location are local to the area and will sell for the normal price. Selling animals not local to the area you sell them in gives a small bonus in sell price. The general rule of thumb is the farther away from the animal's habitat, the more it will sell for. Go figure. Cross-country hauling one moose pelt to the Tumbleweed Butcher just for an extra $2.00-3.00*

Local Area | Animal(s)
:--- | ---
Saint Denis | Alligator<br>American Bullfrog<br>Black Bear<br>Boar<br>Chipmunk<br>Cormorant<br>Crane<br>Egret<br>Heron<br>Oriole<br>Panther<br>Pelican<br>Seagull<br>Western Toad<br>
Roanoke Ridge | Beaver<br>Boar<br>Cougar<br>Eagle<br>Rocky Mountain Elk<br>Canada Goose<br>Loon<br>Moose<br>Sockeye Salmon<br>Steelhead Trout<br>Wolf<br>
Black Bone Forest | Beaver<br>Bighorn<br>Chipmunk<br>Cougar<br>Eagle<br>Elk<br>Goose<br>Grizzly Bear<br>Moose<br>Pronghorn<br>Wolf<br>
Riggs Station | Beaver<br>Bighorn<br>Chipmunk<br>Cougar<br>Elk<br>Goose<br>Grizzly Bear<br>Loon<br>Moose<br>Pronghorn<br>Salmon<br>Trout<br>Wolf<br>

### Orchids

- **Orchids** are flowering plants which can be found sporadically around the entire map aside from **Great Plains, WE** and all of **New Austin** (aside from a single **Sparrow's Egg Orchid** in **Rio Bravo, NA**).
- After completing `Dutchesses and Other Animals`, you can collect the `Rare Orchids Order` from the board at any **Post Office** (Rhodes or Valentine). This allows **Orchids** and **Heron/Egret/Spoonbill Plumes** to be mailed to **Algernon Wasp** for cash. The payment mailed back will only be for a single orchid, so sending a stack of 7 of the same orchid will not affect the mailed payment. That being the case, to maximize profit: send one orchid, allow 6 hours to pass (sleep, blackout drunk, or wait until morning at a shop), collect the payment, and repeat.
- A lone **Sparrow's Egg Orchid** can be found directly north of the **Legendary Pronghorn**.

**WARNING:** AFTER COMPLETING ALL STAGES OF `Dutchesses and Other Animals`, DO NOT SEND MORE THAN ONE ORCHID SPECIES AT A TIME. DOING SO WILL GLITCH OUT THE ORCHID MAILING ORDER. [More info here.](#unable-to-send-orchids-by-mail)

Price | Orchid(s)
:--- | ---
$15.00 | Dragon's Mouth
$14.00 | Night Scented<br>Moccasin Flower<br>Ghost<br>Clamshell
$11.00 | Sparrow's Egg<br>Lady of the Night<br>Cigar<br>Acuna's Star
$10.00 | Rat Tail<br>Queen's<br>Lady Slipper<br>

# BUGS

*These are bugs which don't appear to have exploitable benefits.*

### Facial hair glitch

Sometimes the player's facial hair will appear to grow beside the eyes, high on the sides of the jaw, and patches on the lower neck. The only way to fix this is to exit and restart the game.

### Cattleman Hero Grip wrong texture

There's a bug with the hero grip on Cattleman Revolvers where the grip will retain the gold details but revert to a wooden base. The only known way to prevent this from happening is to not purchase any other grip or varnish. The only known way to fix it is to reset to the default (or pearl) grip, then set it back to the hero grip.

### Unable to obtain Wild Man's Journal

If you're facing a wonky direction just right while picking up the **Wild Man's Journal**, it is possible to clip out of the animation and forever prevent you from obtaining it. Do yourselves a favor and make a save before pursuing him back to his cave just in case you stumble into some stupid clipping action like I did.

### Bugged soldier during The King's Son

I've had this happen numerous times. There's an enemy army soldier standing dead still on the south side of the incomplete house (just the frame of a house). You must kill him **AFTER** killing all other enemies registered before the next mission checkpoint. I found it always works if you leave him for last, then knife from behind. Doing so has allowed me to proceed onto the main Cornwall building without having the mission dialog show up as if I'm leaving the gang behind.

### Unable to send orchids by mail

After taking the **Rare Orchids Order**, you are forced to send all you have of one orchid at a time. This does not affect payout via mail. Beware, though, as sending more than one species of orchid at a time will glitch out the mailing order and you will no longer be able to send more orchids nor receive money for orchids sent. For example, sending both a **Dragon's Mouth Orchid** and **Acuna's Star Orchid** will glitch out the mailing order. Always send only one orchid species and receive its payment **one at a time** to avoid glitching it.

### Second horse disappears while camping

[Source.](https://gtaforums.com/topic/917511-things-you-didnt-know-about-rdr2-until-now/?do=findComment&comment=1071884440)

If you load your game while camped at your campsite, your secondary horse will disappear, saving and reloading your game while not at the campsite will bring it back.

### Severe flickering or outright blackout in Bluewater Marsh and/or Bayou Nwa

I've found this to occur only when I'm near a **Snowy Egret** or the ghost of **Agnes Dowd**. No clue why, as it has never happened anywhere else. Likely just specific to my system and/or graphics settings.

### Javier not getting off his horse during Chez Porter Homestead Robbery

Present on both Xbox One and PC. Basically, you start the robbery, travel to **Chez Porter** with Javier, but when the black bars retract and Javier advises to go on foot from there, he won't get off his horse. The quickest way to fix this is suicide, but you can also run off to abandon Javier (thus failing the mission). Either way, restarting from checkpoint afterwards he should spawn off his horse and you can continue the mission normally.

### Locations not being noted on the map

I know of several locations which have buggy overworld map names:

- Dormin Crest, Grizzlies West, AM
- Planter's Baun, Grizzlies West, AM
- Nekoti Rock, Tall Trees, WE
- Rattlesnake Hollow, Cholla Springs, NA

These can be obtained, they're just dodgy as shit. Save your game quite a ways away from each before entering them for the first time. Just keep rolling the dice until the name shows up, move onto the next, save again, enter the next, etc, etc. The only location I've never been able to obtain is Granger's Hoggery. I've no idea why. There are other cabins and such which don't appear to have overworld map names, but those are completely void as they don't have a name to begin with.

For **Dormin Crest**, you must enter the cabin while the random encounter is still active. (Where there's a trail coming out of the front door.) I noticed in `PC v1436` the front door jots aside just a tiny bit just before reaching to open it. This only happens when the event is active. Still, I had to keep reloading and retrying to get it to show up on the map.

For **Planter's Baun**, I did not explore Grizzlies West extensively as long as I could. Barrow Lagoon and the surrounding area remained with fog of war. In Chapter 3, even though I hadn't explored up there and the fog of war was still there, the name showed up on the map shortly after starting Chapter 3. Yes, on top of the fog of war. I've no idea why or how. The door of the cabin itself isn't have the same forward jot like **Dormin Crest**, so on every run I've done it's been hit or miss.

For **Nekoti Rock** and **Rattlesnake Hollow**, there appear to be very small, specific areas you have to visit to get the names to pop. Nothing glitchy to them. I've not narrowed down exactly where aside from inside the cave with the chest (at Rattlesnake) and atop the highest peaks just aside OOB (at Nekoti).

### Discount at Saint Denis shops as reward for killing Jean Marc as ordered by Mayor Henri Lemieux

This can be done with Arthur and the discount will transfer to John. However, I calculated my discount with max honor and post-story mode I'm getting only a 55% discount. According to my player menu I am getting the full 50% max honor discount. According to everyone online the discount is meant to be 10% regardless of honor. I'm unsure if I just have a glitch, if the total discount at shops is meant to have be capped at 55%, or if the discount is lowered to 5% if transferred to John rather than doing the Mayor's final mission as John and (possibly) getting the full 10%. Regardless, 5% is better than nothing.

### Unable to save custom outfits

Apparently this has been around for a long time and to this day goes unfixed. What happens is your saved custom outfits start glitching by starting at two, then to three, and eventually if the glitch continues you'll no longer be able to save any custom outfits. This can be bypassed by using a trainer on PC, but the only "easy" way around it is to unlock the **Legend of the East** outfit, equip and store it on your horse, then load outfits from your trainer. As far as consoles go, if there is a known workaround I haven't been made aware of it.

### Legend of the East outfit not unlocking after 90th challenge

This is a glitch that remains unfixed. Many players have completed Bandit 10 as their final challenge and not had the outfit unlock. I, myself, have had it not unlock doing Explorer 10 as my final challenge. Always make a save before completing your final (90th) challenge, and if nothing else avoid doing Bandit 10 or Explorer 10 as your final challenge as these are problem-causers. If there is no turning back (like the position I was in, saving after completing the last challenge):

1. Open the settings menu and press [Y] (on Xbox controller) to open the cheat menu.
2. Enter the cheat "Vanity. All is vanity"
3. Close the settings menu.
4. Open a Trainer; I use Rampage.
5. Enable the cheat bypass function.
6. Go back to the Settings menu, enable the cheat you entered (unlock all outfits)
7. Go back in game and equip the **Legend of the East** outfit at camp.
8. Save your game.

### Micro-Stuttering, FPS Drops, ERR_GFX_STATE Popup/Crash, and other graphics issues

For micro-stuttering (I had it about once every ten seconds):

- Restart your computer. Yes, I know, stereotypical. But it generally works even for me.
- Change your graphics API. If you're using Vulkan, change to DX12. If the contrary, do the opposite. See which works better. Some users Note Vulkan runs a bit faster but DX12 looks crisper/sharper.
- Update/reinstall your graphics driver. Yeah, again, cliche... but the shit worked for me. Be sure to do a **CLEAN INSTALL** when reinstalling/updating the driver. It fixed the micro-stuttering I was encountering (about once every ten seconds). System info: ASUS G14 (2021) AMD Ryzen 9 5900HS @ 3301 MHz, 16384MB, NVIDIA RTX 3060 Laptop GPU, RDR2 Build 1436, NVIDIA Driver v471.96
- Periodically delete everything in the Settings folder except for "system.xml" (to retain graphics settings). Some sources claim that deleting the `.bin` files isn't necessary, but I do it anyway and it works. Doing this can also fix crashing because of `ERR_GFX_STATE`. [[Reference.]](https://www.reddit.com/r/RDR2/comments/dxlreb/err_gfx_state/)

The last step can be semi-automated using [BleachBit](https://github.com/bleachbit/bleachbit). (I began using it when Avast decided to fuck up CCleaner.) All you have to do is `BleachBit > Preferences > Custom > Add Folder` and add your RDR2 `Settings` folder. Then, `BleachBit > Preferences > Whitelist` and add your `system.xml` file to prevent BleachBit from deleting it (retaining your GFX settings).

# GLITCHES

*These are bugs/glitches which can be exploited.*

### Going to New Austin as Arthur

[In-mission method](https://youtu.be/1FUCZLHJSGk) during `Who is Not Without Sin`.

### Keep Arthur's unique suit from The Gilded Cage

[Source.](https://youtu.be/nrecu-MKn-c)

1. Continue mission normally until you get to the part where Arthur, Dutch, Hosea, and Bill are walking towards the house's front door.
2. U-turn and fail mission by leaving the area.
3. Cancel the mission when the "Mission Fail" prompt comes up.
4. You should've respawned with the suit equipped. If not, it evidently may take a few tries.
5. Go to any Wardrobe.
6. Change one item on the outfit.
7. Save the outfit with the custom item equipped.

### Keep Arthur's closed Winter Shogun Coat

*The coat can be applied with any trainer, but here's how to keep it without one.*

1. Right after entering Chapter 2 at Horseshoe Overlook, go to your horse and equip the "Custom Outfit" stored on it.
2. Go to your wardrobe and save the outfit.

### Looting saddle bags and not getting the shit kicked out of you.

*This glitch allows you to search both saddle bags of any horse without getting kicked in the face.*

1. Hop on the horse you want to loot.
2. Ride/lead the horse right next to any solid, static object that will partially block you phsically digging through the saddle bag, be it a tree, rock/boulder, wagon, train, etc. Ensure after you hop off that the **Search Saddle Bag** prompt is still there. A good point of reference (for me) is the edge of the object must be just behind the saddle bag.
3. Search the saddle bag. When done right, the game will not allow the animation to complete because you'd clip too far into the horse. This works in much the same way as evading the full animal skinning animation.
4. Enjoy your saddle bag loot never having to get kicked in the face ever again.

### Break down large fish.

For whatever reason, there is no prompt to break down large fish from the satchel inventory menu. So, that being the case, here's how:

1. Stow the large fish on your main horse.
2. Set up camp.
3. Stand up, retrieve the fish from your horse, and carry it to your campfire.
4. Select the "Cook" option.
5. Store the first cooked piece of fish meat in your satchel. Do not cook more than one piece as that would be counterintuitive.
6. Exit the cooking menu. All large fish yield 4-6 pieces of their associated meat.
7. This method also adds the carcass itself to your horse's inventory, but it will not show up physically and doesn't take up the "large" stow spot on your horse. You can do as you wish with the stowed fish carcass. Sell it to butcher/trapper, donate to camp, discard, etc.

### Keep temporary documents.

[Video of using the glitch](https://youtu.be/jZXI3JYEqv8) by [Alcomahol](https://gtaforums.com/profile/1162284-alcomahol/).

You can obtain almost every temporary document using this glitch. "Almost" because some documents cannot be stored permanently even with this glitch.

1. Inspect/open the document.
2. Pause the game, enter photo mode, and quickly exit. This enables all document controls for a very, very brief period of time. Including the ability to store it. On PC, you can spam F6 and Enter.

### Launch from horse with carcass stowed on side.

This might not be very useful, but I found that with a Condor stored on the side of a horse, getting off on the same side launches me up about 10 feet before landing. I've been able to launch atop buildings you normally wouldn't be able to access doing this.

### Getting caught when quickly dismounting your horse.

While wearing chaps/spats, I found that occasionally I'll fumble off my horse when dismounting while the horse is still running.

### Steal any horse from any stable.

[Source.](https://youtu.be/F2J00n9a7-s)

*This works with all horses at every Stable. You must be able to buy the horse after it's unlocked. (Unlocking it puts the horse physically in the stable to be bought. For example, you can't steal an Amber Champagne MFT from Scarlett Meadows before Chapter 4.) Stealing horses in this manner doesn't reduce honor. Some Stables are easier to hit than others, though.*

1. Get any wagon or buggy. Larger ones are preferable.
2. Ride the wagon to the Stable which houses the horse you want to steal.
3. Put on a mask/bandana.
4. As you enter the Stable, pull out any gun, aim, and fire just as the horse enters the doors of the stable. Doing this prevents the Stable doors from closing.
5. Ensure you've at least one witness. It's necessary for this method.
6. Park the wagon between the Stable doors. (Again, to ensure they don't close.)
7. Hop off the wagon and go to the horse you want to steal.
8. You won't be able to mount the horse, so feed it using the **Horse Menu** until it registers as a **Temporary Horse**.
9. Hide until the witnesses/law stop searching. You can mount the horse just before the search ends to auto-enter the stable. If not, the black bars will appear and you'll enter horseless into the Stable.
10. Exit the stable, travel a ways away, and whistle for your temporary horse. Most of the time they will jump over the gates and run to you. If it doesn't come after a while, move around while continuing to call the horse.
11. Mount the horse and take it to any Stable, even the one you stole it from. Doesn't matter where.
12. Saddle up and enjoy your free horse!

### Remove scope from carcano and/or rolling block rifles.

[Source.](https://youtu.be/Mst4pshFcD0)

Want a scopeless sniper in place of a Bolt Action or Springfield? In story mode, you can permanently de-scope (un-scope?) both the Rolling Block and Carcano Rifles. This glitch isn't entirely permanent, but only because you can just go to a Gunsmith and re-equip any scope to negate it. The rifle(s) will remain scopeless as long as you don't re-scope them at the Gunsmith. They will not gain the auto-aim function even if it's turned on. They still operate as the regular rifle, you're just no longer forced to scope in.

1. Hop on your horse, equip either sniper, and place it in the saddle holster.
2. Enter any Gunsmith.
3. Change the scope on the rifle. (Doesn't matter which, it just has to be changed.)
4. While still viewing in the Gunsmith menu, equip the rifle to your shoulder.
5. Exit the Gunsmith and draw the rifle you holstered earlier (LB on XB1, unsure on PS4).
6. The scopeless rifle on your back will drop. Pick it up.

### Universal saddle blankets.

[Source.](https://youtu.be/vSIyry-KePE)

*Some Trapper saddles have unique blankets. This method does not work with two saddles which have thier own unique blankets. You can glitch the panther blanket with the Rattlesnake Vaquero Saddle but not with the Alligator Saddle.*

1. Enter a stable.
2. Equip the saddle which has the blanket you want to use.
3. Exit the stable.
4. Re-enter the stable.
5. Equip the saddle you want to use with the blanket.
6. Exit the stable.
7. Enjoy your Rattlesnake Saddle with a Panther blanket! (Or whichever combination you choose.)

### Saving Arthur's money for John.

[[Source.]](https://youtu.be/Gu5s3l6w7h0)

The **Aberdeen Pig Farm** is inhabited by an incestual brother and sister, whom together work as a team of serial killers. There is a sort of side mission with these two: as either John or Arthur you can eat dinner with them. During which they'll offer some drinks. After drinking a few times, you pass out and wake up in their body dump site with no money. A decent backing for sticking to the story, I think, is: Arthur gets robbed, John reads about it in his journal, John goes to the farm and takes the money as it's of no use to Arthur at that point. :)

Go there and get robbed as Arthur right before the mission **"Red Dead Redemption"** (the last mission in which the player controls Arthur) but do not go back and kill them, nor get your money. Wait until you take control of John, travel to the farm, and retreive the cash from the safe behind the picture of "Mama" directly behind the front door. Kill or spare them as you see fit.

### Getting gang horses

[[Source.]](https://youtu.be/yMr_xta-Q6s)

It's possible to obtain gang horses, even in the Epilogue. You can't bond with them, but this is a mod-less way to get them. All gang horses spawn at random with this method.

1. Be in at least Chapter 3.
2. Travel to **Horseshoe Overlook, Heartlands, NH**.
3. Replay the Chapter 2 mission `Americans At Rest` and complete it.
4. Travel back to **Horseshoe Overlook** and pick any gang horse.

### Getting out of bounds.

[OOB on San Luis River.](https://youtu.be/kYmREKUf09A)<br>
[OOB on San Luis River (alternate).](https://youtu.be/GfM9vxakKTA)<br>
[Bridge glitch.](https://youtu.be/VSRt7FPGItE)<br>
[OOB far northeast.](https://youtu.be/eppF2TnLt00)<br>
[OOB in Devil's Cave.](https://youtu.be/Kx0llq2e8qs)<br>
[OOB at Aurora Basin.](https://youtu.be/KKgIuLrLe8A) - using slide glitch.

You'll need enough alcohol to blackout to do this, and it works anywhere applicable. Most spots under cliffs work well. If you've got the **Wolf Heart Trinket**, you'll need a lot. Now, to get compendium entries and sketches as Arthur for animals specific to New Austin (and/or Guarma before/after of Chapter 5), or just to run around and explore, you can travel out of bounds via the far west end (at the edge of a drop-off) in the **Devil's Cave**. If you're running post-Epilogue and want to explore the southern side out-of-map or travel to Guarma much quicker, an infinitely faster method is to travel to a specific point on the southern shore of the **San Luis River**.) Do the following once at either location:

1. Drink until you black out.
2. Do nondescript things while blacked out. (How the character scales seemingly sheer surfaces whilst blackout drunk is unclear. Ah, the wonders of moonshine!)
3. Wake up out of map.

**GETTING TO GUARMA:** Guarma is located at the southeast (bottom right) corner of the map. Go in that general direction until you hit the low poly (jellytown) ground. Any low-poly area is considered the physical "end of the map" which you'll fall through. If you hit a 90-degree corner, turn on it (after turning you should be facing south). Follow the seam until you begin to float (walk up an invisible hill). Turn to face the low poly section, walk a few steps over the seam and Guarma's map will render in.

- A quick side note: I black out drunk on the east side of **Aurora Basin** and woke up on the west side out-of-bounds. I will try to replicate this soon, but the few times afterwards resulted in no joy.

### Glitching through locked interiors.

It's possible to glitch into locked interiors like **Taxodermist House**. This doesn't work on all surfaces, though.

1. In third person view, equip the lantern and a pistol/revolver.
2. Walk up to a wall or door and aim straight down dead center with whatever you're trying to glitch through. Angles are important for this, so it usually takes some finesse.
3. Go into first person view while still aiming. If you can see through the door/wall, you got the angle right.
4. Jump once. If you don't glitch through the wall, rinse and repeat.

### Speed crafting.

*This involves using third-party programs. Some recipies can be done seamlessly by holding A (on Xbox). For example, ammunition.*

Download [CheatEngine](https://www.cheatengine.org/downloads.php). I use the RAR archive version which you don't have to join Patreon for; it doesn't come bundled with "optional" adware/bloatware like the installer does, but feel free to use what you want. Be sure to launch the 64-bit version of CheatEngine when using it in RDR2. Open "RDR2.exe" via the Open Process dialog and check "Enable Speedhack". You can adjust the speed as you see fit. When finished, uncheck the box to disable the speedhack.

Sometimes, a glitch may occur where the crafting process of some items (seemingly random) will freeze halfway through. I use 500x speed and travel near Colter when doing this, which seems to lower the chance of this happening.

I have not found a concrete way to alter item counts with CheatEngine. Looking into editing save files.

### Duplicate journal sketches.

Some POIs can be sketched as both Arthur and John (meaning two journal sketches per game):

- Cave Hermit
- Tree King
- Hermit Man
- Blind Man Cassidy
- Swamp Ghost
- Strange Statues

### Huge Bass with Kieran

In Chapter 3, while fishing at the second spot during **Fishing - Kieran**, a huge bass (reminiscient of the legendary bass found in the **San Luis River**) has a chance of spawning during the mission. It is not a legendary fish and cannot be mailed to Jeremy Gill.

### Double skins

If an animal can be picked up, you can get two ticks added to its `Skinned` counter in the **Compendium** by selling the skinned carcass to the Trapper or by donating it to camp. This does not yield two skins per animal, it just counts as skinning it twice.

# EASTER EGGS

Much information here was sourced from the [Red Dead Fandom](https://reddead.fandom.com/wiki/Easter_Eggs_%26_Secrets_in_Redemption_2).

### Egg Notes

*Just some things I jot down before I find out what they are, if I ever do.*

- Random dead camper at dilapidated campsite just down the hill from **Hawks Eye Cabin, Big Valley, WE**. Only spawns at night.

### Witch in Graveyard

During `Angelo Bronte, A Man of Honor` (in Chapter 3), a woman dressed in all black with one cataracted eye can be seen running around several spots in the graveyard. She doesn't appear outside of this mission.

### Skinner Brothers Yelps

The sounds made by **Skinner Brothers** during ambushes and attacks are the same made by **Wapiti Tribe** members during **My Last Boy**. Likely just a borrowed scare tactic, but the **Skinner Brothers** might have some other motive in doing this. Perhaps some members are tied to the tribe and are protecting land in **Tall Trees**. Or maybe it's just the former. In either case, the jumpscare potential is unreal. Trotting along the paths, you hear screaming out of nowhere but you know what's coming.

### Voices at Old Camps

Voice lines from previous missions can be heard while traveling to previous camp locations. This also happens in Epilogue.

### Roanoke Forest Whispers

[Explanation on Reddit.](https://www.reddit.com/r/reddeadmysteries/comments/9z42z3/roanoke_whispers_explained/)

Evidently, it's the voices of Ethel Boshared and Eugene Hutton, a couple who got lost in the forest. Some Theatres will show **The Ghostly Serenade**, which apparently tells the story of the couple.

### Woman in the Window

Seen at night peering out the second floor window of the house dead east of the junction at **Emerald Ranch, Heartlands, NH**.

### Trelawny's House

[[Reference.]](https://youtu.be/p-eA73N5y_c)

You can hear unique dialogue from inside Trelawny's house in **Saint Denis, Bayou Nwa, LE**.

### Writing on a Tree

A declaration of love carved into a tree trunk on the cliff north of **Flatneck Station, Heartlands, NH**. Extra carvings are added in the Epilogue. Seems to be carved by the boy casting stones into the **Dakota River**, whining about "Lily May".

### Bottle Tree

Lone tree with a bunch of bottles tied to it by strings and plenty more all around. Beside the path northeast of **Trading Post, Heartlands, NH** (point of interest).

### Zombie Well

Climbing to the bottom of the well at **Bear Claw, Tall Trees, WE** will change the lighting effects and show you as a zombie. Effect is negated if the Lantern or Miner's Hat is equipped.

### Bolger Glade Whispers

[Explanation on Reddit.](https://www.reddit.com/r/reddeadredemption/comments/ew1dx0/bolger_glade_sounds/)

### Lemoyne Ghost Train

https://youtu.be/_fSlasTGGag

### UFO

00:00-04:00 a stereotypically alien "UFO" shows up over **Hani's Bethel, Heartlands, NH**.

Another spawns in **Big Valley, WE**, southeast of the last 'N' in "MOUNT SHAN**N**". A small monolith can be found atop a cliff west of the path junction nearby, northwest of the 'M' in "**M**OUNT SHANN". Some miscellaneous gear can be found under a rock alongside the path southeast of the 'V' in "BIG **V**ALLEY".

### Witches Cauldron

Take a sip of that gray sludge. Found northwest of the 'N' in "AMBARI**N**O".

### Dragic's Creation

After completing Marko Dragic's mission strand, is "son" (the robot) can be found atop a cliff dead west of **Colter, Grizzlies West, AM**.

### Panoramic Map

A frozen couple holds the map northwest of the 'A' in "**A**MBARINO".

### Giant Snake

South of **Pleasance, Scarlett Meadows, LE**.

### Tally Marks in Well

Bottom of the well at **Compson's Stead, Scarlett Meadows, LE**.

### Gorilla

In a crate east of the bridge dead north of **Lenora View, Big Valley, WE**.

### Graves

A lone grave is under the **Warped Tree** east of **Larned Sod, Heartlands, NH**.

An old lean-to with three skeletons can be found northeast of **The Lookout Tower, Roanoke Ridge, NH**.

A wooden headstone listing many "workers" can be found northwest of **Copperhead Landing, Bluewater Marsh, LE**. West of the path parallel train tracks on the northern border of **Bluewater Marsh, LE**. It's assumed these were railroad workers.

A small graveyard can be found at a clearing in the forest dead west of the 's' in "Kama**s**sa River", southeast of **Osman Grove, Roanoke Ridge, NH**.

A lone grave marked with a skull on a stick can be found atop a cliff overlooking the **Upper Montana River** southwest of **Fort Riggs, Big Valley, WE**.

A desheveled and blood-stained tent is atop a plateau southeast of **Vetter's Echo, Big Valley, WE**. There's no body or grave, but it's presumed to be the final stand of someone against the same bear that can be found inside **Vetter's Echo** itself.

Dutch's mother is buried in the graveyard on the northwest side of **Blackwater, Great Plains, WE**.

A lone grave is near the shore southeast of the 'H' in "WEST ELIZABET**H**".

There's a skull on a stake next to a bull skull on a stump northeast of **Swadbass Point, Tall Trees, WE**.

### Undead Nightmare

The green mask from RDR1 Undead Nightmare can be found in the top left sheft behind the **Fence** shopkeep's counter in **Saint Denis, Bayou Nwa, LE**. [Reference.](https://youtu.be/lJm0PzXcRkA)

In the Epilogue, some Aztec symbols around **Blackwater, Great Plains, WE** can be sketched. [Reference.](https://youtu.be/TwQq9BbPNco)

### Strange Man

Some nods to RDR1. Only available in the Epilogue. When visiting **Bayall Edge, Bayou Nwa, LE**, a painting of the Strange Man is in progress. Pictures and other paintings in the cabin correlate to the player's honor level. Vultures and coyotes for negative, bucks and eagles for positive. The poem carved into the nightstand next to the couch changes based on whether or not you killed Jimmy Brooks in Chapter II. Over the next four visits to the cabin, the painting of the Strange Man will become more and more complete. On the final visit when the painting is completed, the Strange Man can be seen standing behind you in the mirror.

A picture of the Strange Man can be found behind the counter of the General Store in **Armadillo, Cholla Springs, NA**. Herbert Moon, the shopkeep, has some unique dialog hinting to the Strange Man as well.

### Crazy Guy in Treehouse

Northwest of the last 'N' in "NEW AUSTI**N**".

### Chelonians

A Chelonian can be found in room 1B during `Polite Society, Valentine Style`.

After speaking with the Chelonian in **Saint Denis, Bayou Nwa, LE**, a Chelonian group can be found committing suicide off a cliff southwest of **Veteran's Homestead, Grizzlies East, AM**.

A trio of dead Chelonians can be found northeast of the 'O' in "CH**O**LLA SPRINGS".

### Albert Mason Photos

His photographs are displayed at the Art Gallery in **Saint Denis, Bayou Nwa, LE**.

### Dead Man in Outhouse

Can be found inside the outhouse dead south of the 'H' in "MOUNT **H**AGEN".

### Frozen Explorer

[Reference.](https://youtu.be/NgYR4sXorW8)

Can be found at the northwesternmost edge of **Deadboot Creek, Grizzlies West, AM**.

### Dormin Crest

Cabin in **Grizzlies West, AM**, dead west of the 't' in "Deadboo**t** Creek". Tracks and a trail can be followed from the front door to a frozen man holding a repeater. This is thought to be a reference to the film *Jeremiah Johnson*.

### Frozen Cattle

[Reference.](https://youtu.be/WHdjFlmMTK8)

The cattle can be found in **Grizzlies West, AM**, dead east of the 'S' in "**S**pider Gorge". A lone skeleton can be found under a rockface near the northwest shore of **Lake Isabella**.

The **New Hanover Gazette No. 35** newspaper mentions the events which transpired. A friendly NPC camped southeast of **Oil Derrick, Heartlands, NH** (point of interest) will tell you of his story, which appears to link those frozen cattle and the lone skeleton at the lake.

This is thought to be a reference to the **Donner Party**, a real life group which became stranded while traveling out west.

### Black Sheep

Can be found in the southernmost pen at **Guthrie Farm, Heartlands, NH**. The black sheep can also be found alive roaming west of **Heartland Overflow**. Apparently, the dude married the sheep.

### Burned Wagon

South of the 'R' in "**R**IO DEL LOBO ROCK" in **Rio Bravo, NA**. Two dead men and two dead cows. Ground is burned and trees are dead.

### Antler Knife

A dead man and Grizzly Bear can be found northeast of **Stilt Shack, Big Valley, WE**. The Antler Knife is lodged in the bear's neck.

### Banjo Mutant

Found at **Butcher Creek, Roanoke Ridge, NH**. Based on a real life person.

### Pentagram

04:00-05:00 Glowing red under the northeasternmost cabin at **Butcher Creek, Roanoke Ridge, NH**.

### Blackwater Athletics Team

Found piled in a shallow grave in **Tall Trees, WE**. A reference to the team having gone missing is noted in the newspaper **Blackwater Ledger No. 69**. Evidently based on a real life amateur soccer team called "Los Maniceros" that went missing in Columbia in 2009.

### Hung Corpse

A man in a suit is strung up from a wagon roof beside the road north of **Macfarlane's Ranch, Hennigan's Stead, NA**.

## Maps

For release format and download information, see [Release Format](#release-format).

### Map Key/Legend

*Markers/Blips:*

Color | Marker Type
:-- | ---
Solid Red | Gang Hideout
Hollow Red | Animal Static Spawn<br>Bird Static Perch Spawn<br>Gang Campsite
Hollow Blue | Animal Scenario Spawn<br>Bird Flying Spawn<br>Gang Random Event

Some exceptions to these map key rules are:

- In `RDR2-SitLocations.jpg`, the blue blips are temporary locations. The one at **Clemens Point, Scarlett Meadows, LE** is only available during Chapter 3. The one west of **Annesburg, Roanoke Ridge, NH** is available temporarily, but the trigger or time it's available is unknown.

*Location Breakdown:*

I list locations in the typical format of smallest to largest territory. For RDR2 this is **Place, Region, State**.

Abbreviation | State | Regions
:- | -- | --
AM | Ambarino | Grizzlies West<br>Grizzlies East
NH | New Hanover | Heartlands<br>Cumberland Forest<br>Roanoke Ridge
LE | Lemoyne | Scarlett Meadows<br>Bayou Nwa<br>Bluewater Marsh
WE | West Elizabeth | Big Valley<br>Great Plains<br>Tall Trees
NA | New Austin | Hennigan's Stead<br>Cholla Springs<br>Rio Bravo<br>Gaptooth Ridge

### Some Notes

- Text within quotes, for example `"Willard's Rest"`, signifies text on the overworld (pause menu) map. Actual, in-game locations are noted in bold and not in quotes or a code block, as such: **Willard's Rest**. When describing placement relative to individual letters, the associated text will be in quotes and the individual letter(s) mentioned will be bolded. For example: west edge of the 'a' in "Will**a**rd's Rest".
- All reference locations (nearby plants, landmarks, etc) used are those which are the closest to where the animal was spotted. I try not to be vague, like "large rock next to the mountain". Some spawnpoints were a ways away from notable locations, and in those cases I've noted only landmarks and/or plants nearest to the spawnpoint as well as the animal's location relative to them.
- Random encounters don't seem to be tied to a specific time span, but for me all have occurred more often just after 10:00.
- Random encounters seem to appear more frequently if you save and reload in a nearby location or spend a great amount of time in the general vicinity. This includes all random encounters, including random events involving rival gangs. Setting up camp and sleeping has yielded less consistent results for me.
- The chance of random encounters does not change at any point if story mode, contrary to what I suspected. In `Simple Pleasures`, **Abe** says something I feel leans towards this being an actual mechanic put into the game for post-story play. [[Citation.]](#quotes) But, after extensive testing, random encounters are just as random regardless of story progression.
- It is possible to (apparently) increase the likelihood of random encounter spawning: hitch your horse and rest (kneel) a ways away from the point where whatever you're looking for is meant to spawn. Face away from the spawn while resting. Go do something else as time passes. I give at least six in-game hours, horse hitched and me kneeling. (That goes quicker with a timelapse function in a trainer.) After that short while, head towards the location. This is how I get the dodgy animal encounters to spawn more frequently.

### Time Frames

Span | Effect
:--- | ---
06:00-16:00 | Daytime
16:00-06:00 | Night
05:00-21:00 | Miscellaneous birds flying overhead.

### Animal Scenarios

Animal(s) | Location(s) | Description
:--- | --- | ---
Cougar<br>Deer | - Little Creek River, Big Valley, WE (south of 'E' in "Little Creek Riv**e**r", 11:23, 20:56) | Cougar stalks and attacks Deer.
Cougar<br>NPC Corpse | - Northeast of first 'N' in "HE**N**NIGAN'S STEAD".<br>- Shore of **Kamassa River** south of **Old Tomb, Roanoke Ridge, NH**. | Cougar eating dead NPC.
Western Bull Moose | - Lake Isabella, Grizzlies West, AM<br>- Barrow Lagoon, Grizzlies West, AM<br>- Cairn Lake, Grizzlies West, AM (16:08) | Slipping on ice while attempting to stand upright.
Western Bull Moose<br>Gray Wolf | - Lake Isabella, Grizzlies West, AM (northwest side of lake, swims to western shore)<br>- Calumet Ravine, Grizzlies East, AM (just north of the bridge to **Wapiti**, swims to west shore)<br>- Owanjila, Big Valley, WE (towards north side of lake, swims to west shore, 18:55)<br>- Owanjila, Big Valley, WE (closer to bridge at **Owanjila Dam**, swims to east shore with a single **Burdock Root**, 08:28) | Moose swimming, sometimes being chased by a lone wolf.
Hawk/Eagle/Owl<br>Fish/Snake/Rabbit/Rat | - Old Greenbank Mill, Heartlands, NH (west side of path west of the mill)<br>- Emerald Ranch, Heartlands, NH (owl catches rat on NE side of ranch)<br>- Elysian Pool, Roanoke Ridge, NH<br>- Calumet Ravine, Grizzlies East, AM<br>- Little Creek River, Big Valley, WE (hawk catches squirrel, northeast of **Valley View**)<br>- Kamassa River, Roanoke Ridge, NH (southwest of Beaver Hollow)<br>- Blackwater, Great Plains, WE (owl catches rat, east side of easternmost path heading southbound out of **Blackwater**) | Bird dives and catches random fish/snake (over water) or random small mammal/snake (on land).
Whitetail Buck | - Heartlands, NH (SW of the 'H' in "THE **H**EARTLANDS")<br>- Strawberry, Big Valley, WE (SE of the **Strawberry Stable**) | Two Bucks, one dead and the other alive, with interlocked horns.
Whitetail Buck | - Heartlands, NH (SW of second 'H' in "THE **H**EARTLANDS")<br>- Cumberland Falls, Heartlands, NH (east side of river, east of path southbound from **Cumberland Falls**, 12:50)<br>- Roanoke Ridge, NH (northern edge of the train tracks just inside the county border, southwest of the **Trapper**) | Two Bucks pushing each other around.
Bighorn Ram | - Cumberland Forest, NH (north of 'D' in "CUMBERLAN**D** FOREST")<br>- Deadboot Creek, Grizzlies West, AM (southeast of 'k' in "Deadboot Cree**k**".<br>- Little Creek River, Big Valley, WE (northwest side of junction NW of 'R' in "Little Creek **R**iver"<br>- Black Bone Forest, Big Valley, WE (just SE of the **Trapper**)<br>- Black Bone Forest, Big Valley, WE (southeast corner of the path junction just southeast of the Geddes' house at **Pronghorn Ranch**)<br>- Pronghorn Ranch, Big Valley, WE (first junction on eastbound dashed path heading away from the ranch.<br>- Cholla Springs, NA (dead south between 'I' and 'N' in "CHOLLA SPR**IN**GS") | Two Rams headbutt each other.
American Bison | - Heartland Overflow, Heartlands, NH (SW of 'H' in "**H**eartland Overflow"<br>- Great Plains, WE (southeast of 'T' and west of 'P' in "GREA**T P**LAINS")<br>- Hennigan's Stead, NA (west of second 'N' in "NEW AUSTI**N**") | Bison headbutting each nother.
Grizzly Bear<br>Gray Wolf | - Barrow Lagoon, Grizzlies West, AM (on ice south side of lagoon)<br>- Cattail Pond, Grizzlies West, AM (east of the pond; 13:35)<br>- Little Creek River, Big Valley, WE (on 'R' in "Little Creek **R**iver") | Grizzly eating Deer carcass. Wolves attempt to overpower the Grizzly. 10:00
Grizzly Bear | - Cattail Pond, Grizzlies West, AM (cliffside overlooking **Dakota River**, south of the pond) | Just chilling.
Grizzly Bear | - Watson's Cabin, Big Valley, WE (east of the cabin)<br>- Fairvale Shanty, Grizzlies East, AM (a few feet south of the cabin)<br>- Bear Claw, Tall Trees, WE (south of the cabins) | Scratching itself on a tree trunk.
Grizzly Bear<br>Sockeye Salmon | - O'Creagh's Run, Grizzlies East, AM (northern shore)<br>- Little Creek River, Big Valley, WE (east stretch of creek before stream goes downhill; 14:14)<br>- Little Creek River, Big Valley, WE (south of **Watson's Cabin**, 17:34)<br>- Dakota River, Big Valley, WE (where **Little Creek River** feeds into **Dakota River**)<br>- Aurora Basin, Tall Trees, WE (southeast shore) | Grizzly catches and eats Salmon.
Fox | - Barrow Lagoon, Grizzlies West, AM (south of lagoon)<br>- Spider Gorge, Grizzlies West, AM (south of 'S' in "**S**pider Gorge") | Stalks and pounces on prey beneath snow. Only occurs in northwestern snowy regions.
Gray Wolf | - Elysian Pool, Roanoke Ridge, NH (southeast of)<br>- Lake Isabella, Grizzlies West, AM (northwest path)<br>- Cairn Lake, Grizzlies West, AM (south side of the path leading westbound away from the lake)<br>- Evelyn Miller Camp, Tall Trees, WE (southeast of) | Two Gray Wolves play fighting.
Gray Wolf | - Fairvale Shanty, Grizzlies East, AM (on the hilltop across the path south of)<br>- Lake Isabella, Grizzlies West, AM (atop the cliff overlooking the waterfall on the northwest side of lake) | Mourning over dead wolf.
American Fox Hound<br>Bluetick Coonhound | - Painted Sky, Big Valley, WE (east side of path next to junction directly west of woodpecker icon) | Two domestic dogs play-fighting.

## Rival Gangs

**NOTE:** The map `RDR2-RivalGangs.jpg` was discontinued some time ago now. It was getting a bit messy, but nearly every encounter, camp, and hideout location is marked.

- O'Driscolls and Laramies share some of the same random encounter locations.
- O'Driscolls are not meant to be present in the Epilogue. However two can be found stumbling out of Smithfields (Valentine, Heartlands, NH) at night. I also recall a video of a glitched train robbery random event southwest of Armadillo. The event is meant to involve Del Lobos, but due to some fluke it ended up being O'Driscolls. I have seen the former myself, but not the latter.
- The gang around Saint Denis are goons serving **Guido Martelli** (as per **Charles** during `Bare Knuckle Friendships`). [[Citation.]](#quotes) They don't have a known hideout, but are localized to parts of Saint Denis and appear in only random encounters.
- Lemoyne Raiders can be found in **Saint Denis** (Bayou Nwa, LE), but only during random encounters. They can be found at the same spots **Martelli's Men** stand at, but between the two is up to RNG. So far, I've run into Raiders standing around only twice. Also encountered them throwing Fire Bottles at a building in the southwest side of **Saint Denis**.

NAME | LOCAL AREA(S)
:--- | ---
O'Driscoll Boys | Big Valley, WE<br>Heartlands, NH<br>Cumberland Forest, NH
Lemoyne Raiders | Scarlett Meadows, LE<br>Saint Denis, Bayou Nwa, LE
Murfree Brood | Roanoke Ridge, NH
Laramie Boys | Big Valley, WE (Epilogue)
Skinner Brothers | Tall Trees, WE (Epilogue)
Del Lobos | Gaptooth Ridge, NA<br>Cholla Springs, NA<br>Rio Bravo, NA<br>Hennigan's Stead, NA
Night Folk | Lagras, Bayou Nwa, LE<br>Lakay, Bayou Nwa, LE
Martelli's Men | Saint Denis, Bayou Nwa, LE

## Wild Animal Locations

### Western Bull Moose

*Primarily diurnal. Three coats: rust brown (almost orange), dark brown (almost black), and a gray-brown. Some coats and gender combinations can only be found at three specific spots, see below for details.*

See `RDR2-WesternBullMoose.jpg` for more locations.

**NOTE:** The most reliable spawns from my experience: Witches Cauldron (out of bounds) and Tall Trees (second 'L'). They're 24-hour spawn points and are the only two spots I'm aware of which allow all coats and both genders to spawn. Every other static spawn gives either a gray cow or orange bull and may as well be considered a random encounter given how rarely I've come across them elsewhere.

**NOTE:** I've found moose all over the map during sleet, mist, and fog. However they don't seem to spawn during rain or thunderstorm.

Location | Details | Time(s)
:--- | --- | ---
Colter, Grizzlies West, AM | atop small cliff on southeast side of road running northeast out of **Colter** [[Reference.]](https://youtu.be/Cg4ycMgVkAA) | 06:27, 14:41
Cairn Lake, Grizzlies West, AM | laying on the center of the ice | 06:55, 16:32, 19:27
Lake Isabella, Grizzlies West, AM | atop small cliff northeast of 'A' in "**A**MBARINO", west side of path | 09:02
Lake Isabella, Grizzlies West, AM | west side of path on northeast side of the lake; [[Reference.]](https://youtu.be/ys0vj0g2iAc) [[Reference.]](https://youtu.be/B_ma0mppixo) [[Reference.]](https://youtu.be/9r1fI8o3KM4) | 12:25
Lake Isabella, Grizzlies West, AM | path on west side of **Lake Isabella**; unaffected by **White Arabian** presence; unaffected by playing wolves random encounter | 09:13, 15:32, 16:40, 18:33, 18:40
Lake Isabella, Grizzlies West, AM | laying on ice northwest side of **Lake Isabella**; southeast of destroyed cabin; just some paces away from the spawn described above [[Reference.]](https://youtu.be/pmWMlnCKJlQ?t=502) [[Reference.]](https://youtu.be/lFeQF6NeQFs) | 06:24
Lake Isabella, Grizzlies West, AM | chased by wolf across northwestern **Lake Isabella**; swims to northern shore just southeast of waterfall | 17:45
Barrow Lagoon, Grizzlies West, AM | laying on ice southeast side of lagoon | 08:20, 10:45
Window Rock, Grizzlies West, AM | west side of train tracks atop cliff overlooking trestle bridge southwest of **Window Rock**; southwest of the trestle bridge itself; dead west of "Dodd's Bluff"; dead south of "Chez Porter"; northeast of dreamcatcher | -
Cattail Pond, Grizzlies West, AM | northeast shore of **Cattail Pond** on path which **Beartooth Beck** flows over [[Reference.]](https://youtu.be/SjCSYm1xiuc) | 19:05
Calumet Ravine, Grizzlies East, AM | swims to west shore on the south side of the lake being chased by wolf; directly in line with junction east of **Wapiti** | 07:16, 14:45
Fort Wallace, Grizzlies East, AM | east of **Fort Wallace**; in trees on west side of road at first junction south of **Bacchus Station**, [[Reference.]](https://youtu.be/UkMZvcwiGZ4) | 10:17, 15:01
Witches Cauldron, Grizzlies East, AM | west of **Witches Cauldron**; between 'I' and 'N' in "AMBAR**IN**O"; northeast of junction by **Strange Statues**; OOB, but can be lured with bait or by rolling the dice spooking it; alternative coats spawn here [[Reference.]](https://youtu.be/6He4lvedONs) | 24-hour
Witches Cauldron, Grizzlies East, AM | same as above, but about 100m east-southeast; cow moose only so far | 24-hour
O'Creagh's Run, Grizzlies East, AM | east shoreline of lake; just south of **Veteran's Homestead**; 15 paces west of Alaskan Ginseng plant; to the east of "O'Creagh's" in "**O'Creagh's** Run" | 06:17, 13:32
O'Creagh's Run, Grizzlies East, AM | near north shoreline of lake; swims south in line with "Cr" in "O'**Cr**eagh's Run" to northeast edge of western peninsula | 14:09
Fairvale Shanty, Grizzlies East, AM | in grass on south side of road; southwest of **Fairvale Shanty**; sleep until morning at **The Loft** [[Reference.]](https://youtu.be/b2DvMtMiW7o) | 06:49, 12:32
Willard's Rest, Roanoke Ridge, NH | inside 3-way junction just southeast of "Rest" in "Willard's **Rest**"; north side of train tracks [[Reference.]](https://youtu.be/9P7lpPdG2V0) | 07:48, 10:37, 11:59, 13:15, 18:38
Willard's Rest, Roanoke Ridge, NH | a little farther north of the other spawn here, seems to be just cow moose [[Reference.]](https://youtu.be/hWw00gGpBno) | 10:47
Brandywine Drop, Roanoke Ridge, NH | east side of river; edge of first cliff up from river at waterfall; west of first 'R' in "**R**OANOKE RIDGE" [Reference.](https://youtu.be/XjKY2grbAa8) | 08:15, 10:35
Deer Cottage, Roanoke Ridge, NH | west of 'A' in "RO**A**NOKE RIDGE"; inside double junctions | 10:55
Viking Tomb, Roanoke Ridge, NH | northern shoreline of **Kamassa River**; southwest of **Viking Tomb**; just below moose map icon [[Reference.]](https://youtu.be/U1ExHRWOotc) | 07:01, 08:03
Cumberland Falls, Heartlands, NH | east shore between 'o' and 't' in "Dak**ot**a River"; across from where **Little Creek River** feeds in; southwest of **Downes Ranch** [[Reference.]](https://youtu.be/QKzZjW0LKRE) | 11:15
Cumberland Falls, Big Valley, WE | island southwest of 'R' in "Dakota **R**iver"; so far this has been exclusively cow moose | 08:15, 09:42; 12:50
Wallace Station, Big Valley, WE | east-southeast of the station; atop cliff hanging over the path closest to the west side of the **Dakota River** [[Reference.]](https://youtu.be/hWw00gGpBno) | 06:28, 09:12, 11:55, 12:46, 15:15
Painted Sky, Big Valley, WE | southern shore of **Dakota River** next to 4 Wild Mint plants; north of **Painted Sky**; below **Burdock Root** map icon | -
Owanjila, Big Valley, WE | chased by wolf, swims to west shore of **Owanjila**, approach **Owanjila Dam** from south [[Reference.]](https://youtu.be/rgKzDOm6w-o) [[Reference.]](https://youtu.be/GVywtz_SdZg) | 06:47, 07:25, 08:45, 11:45, 12:46, 17:20
Owanjila, Big Valley, WE | swims to east shore next to a single Burdock Root plant [[Reference.]](https://youtu.be/cpBf3hXDm0M) [[Reference.]](https://youtu.be/dZ1P0u3_J9w) [[Reference.]](https://youtu.be/5vf27qTAUl0) | 06:48
Fort Riggs, Big Valley, WE | southwest of junction coming from the **Strawberry Stable**; 10 or so paces southeast of boar map icon; seems to be just cow moose [[Reference.]](https://youtu.be/ncTQZNpx5k8) [[Reference.]](https://youtu.be/BRXpsBWv-A4) | 14:01
Upper Montana River, Tall Trees, WE | atop cliff west side of river west of 'U' in "**U**pper Montana River"
Nekoti Rock, Tall Trees, WE | west side of river; northwest of 'U' in "**U**pper Montana River"; south side of path that crosses the river north of the 'U'; on the edge of a **Loon** map icon | -
Nekoti Rock, Tall Trees, WE | on a cliff overlooking the **Upper Montana River**; just southeast of where the path from **Owanjila Dam** turns southwestbound into **Tall Trees** | 06:06, 13:20
Evelyn Miller Camp, Tall Trees, WE | directly east of second 'L' in "TAL**L** TREES"; next to a **Lady Slipper Orchid**; alternative coats spawn here; can be seen from the permanent campsite with the pine limb lean-to [[Reference.]](https://youtu.be/myi-AxL9Zws) | 24-hour
Aurora Basin, Tall Trees, WE | between two groups of Burdock Root on the northwest side of **Aurora Basin**; northeast of Skinner Brothers campsite which, if present, will disable moose spawn | -
Aurora Basin, Tall Trees, WE | out-of-bounds atop small cliff on the southwest end of **Aurora Basin**; west side of **Lower Montana River**; may sometimes fall backwards and remain out-of-bounds; draw it out with Herbivore Bait like with the OOB Ambarino moose | 06:00, 13:00
Bear Claw, Tall Trees, WE | second 'E' in "TALL TRE**E**S"; occasionally a random NPC campsite spawns 20m away which seems to disable the moose spawn, if otherwise I never see both of them at the same time | -

### Panther

*Primarily nocturnal. Three coats: two of the ordinary Panther and one of the Florida Panther. All are relatively similar. The Florida panther has a paler coat than the regular Panther, but there is a regular Panther coat which is very close to the Florida's albeit a tiny bit darker. All coats of both species spawn at all locations.*

See `RDR2-CougarPanther.jpg` for specific locations.

Location | Details | Time(s)
:--- | --- | ---
Old Harry Fen, Scarlett Meadows, LE | two spawns close together; southwest of junction northeast of **Catfish Jacksons**; southeast of **Old Harry Fen** | 24 HOURS
Lakay, Bayou Nwa, LE | two spawns close together; eastern bank of **Kamassa River**; sleeping at water's edge northeast of **Lakay** | 00:00-04:00
Macomb's End, Bayou Nwa, LE | many spawn points from the schoolhouse of **Pleasance** down to **Macomb's End** | 00:00-05:00

### Horned Owl

*Primarily nocturnal, but a few select spawns are active 24 hours. Three coats: Californian (rust brown), Coastal (tan gray), and Great (gray white). Owls seem to share many (if not all) perch locations with Hawks and Eagles. All perch spawns are also landing points, so all large birds can also spawn flying nearby, but land on the perch.*

Additional locations are marked in `RDR2-Owl.jpg`.

Location | Details
:--- | ---
Fairvale Shanty, Grizzlies East, AM | 24 HOURS; perched atop a rock directly south of the shanty; north side of road
Little Creek River, Big Valley, WE | 24 HOURS; perched on ground next to boulder creekside southwest of the path junction from **Watson's Cabin** [[Reference.]](https://youtu.be/r9mEj49iook)
Fort Riggs, Big Valley, WE | on cliff edge southeast of the fort. [This fella posted screens of his catch at Fort Riggs.](https://gtaforums.com/topic/917511-things-you-didnt-know-about-rdr2-until-now/page/64/#comment-1071852129)
Fort Riggs, Big Valley, WE | flying south over the river a ways northwest of the fort. Usually turns westbound into **Tall Trees**, but sometimes turns eastward towards the fort.
Lone Mule Stead, Big Valley, WE | flying northwest of Blackwater; if followed, sometimes flies over **Lone Mule Stead**
Blackwater, Big Valley, WE | flying north out of Blackwater; if followed, sometimes flies to **Riggs Station** and continues toward **Appleseed Timber Co.**
Evelyn Miller Camp, Tall Trees, WE | 24 HOURS; perched atop rockface
Tanner's Reach, Tall Trees, WE | 24 HOURS; perched atop chimney

### Timber Wolf

*Solely nocturnal. Usually in groups of 2 to 3. Most common in **Cumberland Forest, NH** and **Grizzlies East, AM**. Shares spawns with Gray Wolves in **Grizzlies West, AM**.

See `RDR2-TimberWolf.jpg` for locations.

### Cougar

*Primarily nocturnal, but some spawn during the day. Four coats: orange/tan, light brown/tan (almost like buck pelt), gray (very similar to white, especially in moonlight), and white (mission-specific). Aside from random encounters, hotspots are northeast **Roanoke Ridge, NH** (mainly east of the **Kamassa River**) and north of **Ridgewood Farm** (Cholla Springs, NA).*

**NOTE:** The rare white cougar can only be found during `Money Lending and Other Sins IV` while hunting it with **Winton Holmes**. The gray coat can be found in the wild at random, and looks very much like a white cougar especially in the moonlight.

Location | Details | Time(s)
:--- | --- | ---
Pronghorn Ranch, Big Valley, WE | north side of path north of last 'h' in "Pronghorn Ranc**h**" | -
Valley View, Big Valley, WE | attacking deer; south of last 'e' in "Little Creek Riv**e**r" | 23:05, 19:17
Black Bone Forest, Big Valley, WE | creek bank feeding into **Owanjila**; west of **Native Burial**; between path and creek | -
Black Bone Forest, Big Valley, WE | southeast side of path; northwest of **Native Burial** | 07:15
Doverhill, Roanoke Ridge, NH | spawns on path on west bank of **Kamassa River**; north of train tracks; creeps up to NPC campsite | -
Roanoke Valley, Roanoke Ridge, NH | there are a ton of spawns between **Black Balsan Rise** and **Doverhill**; fewer spawns west of the **Kamassa River** | -
Cochinay, Tall Trees, WE | northwest of first 'T' in "**T**ALL TREES" | 24-hour
Beecher's Hope, Great Plains, WE | east of 'G' in "**G**REAT PLAINS" | -
Quaker's Cove, Great Plains, WE | between 'N' and 'S' in "GREAT PLAI**NS**" | -
Ridgewood Farm, Cholla Springs, NA | north of **Ridgewood Farm**; from southeast of **Rathskeller Fork** to east of **Pleasance House**; there's a ton of spawns between 'C' and second 'L' in "**C**HOL**L**A SPRINGS" | -
Plainview, Rio Bravo, NA | southwest of **Plainview**; in land depression on north side of path beyond junctions located west of **Plainview**; north-northeast of last 'R' in "SAN LUIS RIVE**R**"; at the base of a rocky hill | -
Benedict Point, Rio Bravo, NA | dead west of **Solomon's Folly**; dead south of the 'i' in "Benedict Po**i**nt" | 15:15
Rathskeller Fork, Gaptooth Ridge, NA | south of **Rathskeller**; northeast corner of junctions north of 'G' in "GAPTOOTH RID**G**E"; west of rabbit map icon | -
Gaptooth Ridge, NA | atop hill on north side of path directly north of second 'G' in "GAPTOOTH RID**G**E" | 09:54

### Grizzly Bear

*Primarily diurnal, but some spawn at night.*

**NOTE:** Unique encounters at **Vetter's Echo, Big Valley, WE** and in the cave west of **Wallace Station, Big Valley, WE** happen only once per game save.

Location | Details | Time(s)
:--- | --- | ---
Barrow Lagoon, Grizzlies West, AM | north of 'a' in "L**a**goon"; eating deer carcass | 10:40, 13:25
Barrow Lagoon, Grizzlies West, AM | between 'o' and 'n' in "Lago**on**"; eating deer carcass | 09:38, 10:32, 16:15
Cattail Pond, Grizzlies West, AM | southeast of pond; south of train tracks near cliff edge and **Alaskan Ginseng** growing on dead brush patch | 13:45
Cotorra Springs, Grizzlies East, AM | south of hot springs | -
Fairvale Shanty, Grizzlies East, AM | in small bunch of trees 15 paces south of shanty | -
O'Creagh's Run, Grizzlies East, AM | west shore; eating deer carcass | -
O'Creagh's Run, Grizzlies East, AM | north shore; catching salmon | 10:25
Hanging Dog Ranch, Big Valley, WE | in trees on north side of paths coming from the ranch | -
Vetter's Echo, Big Valley, WE | unique encounter; inside the cabin upon first entry; does not respawn after killing it once | -
Sheperds Rise, Big Valley, WE | streamside northwest of cabin; catching salmon | -
Wallace Station, Big Valley, WE | island west-northwest of 'R' in "Little Creek **R**iver"; catching salmon | -
Wallace Station, Big Valley, WE | unique encounter; inside dinosaur bone cave | -
Wallace Station, Big Valley, WE | there's at least four spawn locations in close proximity between **Watson's Cabin** and **Wallace Station**; all of which are south of the dinosaur bone cave and reasonably close to the old chimney; I've killed three grizzlies in five minutes here | -
Wallace Station, Big Valley, WE | north of the second 'L' in "WAL**L**ACE" | -
Watson's Cabin, Big Valley, WE | south shore of the creek; north of 'R' in "Little Creek **R**iver" | -
Pronghorn Ranch, Big Valley, WE | south of 'W' in "**W**EST ELIZABETH" | -
Black Bone Forest, Big Valley, WE | south-southeast of **Trapper**; just northwest of path diverge from creek | 22:00
Nekoti Rock, Tall Trees, WE | standing in the **Upper Montana River** towards the west bank; east of **Nekoti Rock**; west of second 'n' in "Upper Monta**n**a River" | -
Bear Claw, Tall Trees, WE | northwest of **Bear Claw**; second 'E' in "TALL TRE**E**S"; snooping around NPC campsite | -
Bear Claw, Tall Trees, WE | west of **Bear Claw**; sitting near cliff edge facing **Lower Montana River** | -
Bear Claw, Tall Trees, WE | south of **Bear Claw** | -
Aurora Basin, Tall Trees, WE | eating deer carcass on northeastern peninsula | 15:15
Aurora Basin, Tall Trees, WE | catching salmon on east shore | 14:42

### Hawk and Eagle

*These can be found literally everywhere. Even up northwest in the barren mountains. Both Hawks and Eagles spawn flying over dead carcasses. This happens even at night. Yes, when they're meant to be roosted in their nests. I don't understand it, either.*

Location | Details
:--- | ---
Twin Stack Pass, Heartlands, NH | both perched atop and flying around the peaks
Grizzlies East, AM | tons of both flying and perched around the first 'I' in "GR**I**ZZLIES EAST"
Mount Hagen, Grizzlies West, AM | perched on top of mountain and flying overhead
Tanner's Reach, Tall Trees, WE | tons of eagles

### Vulture

*Primarily diurnal scavenger birds. Easy to attract with dead animals. Skinning a dead animal doesn't appear to affect the level of attractance. I don't know if that's a word.*

**NOTE:** These seem to be more common at run down and burned areas. Including Pleasance, Limpany, Armadillo, etc.

Location | Details
:--- | ---
Bard's Crossing, Heartlands, NH | sunning atop southern railing on east side of bridge; directly north of 'G' in "BARD'S CROSSIN**G**"
Twin Stack Pass, Heartlands, NH | flying overhead and perched atop cliffs
Dewberry Creek, Scarlett Meadows, LE | flying overhead
Bluewater Marsh, LE | flying overhead
Lenora View, Big Valley, WE | sunning atop a large rock on the west side of the road southeast of the cabin
Hawks Eye Creek, Big Valley, WE | scavenging a deer carcass at the eastern tip of the 'Z' in "WEST ELI**Z**ABETH"
Armadillo, Cholla Springs, NA | flying all around the outskirts of Armadillo

## Small Birds and Animals

Damn tiny things.

### Scoreless Spawns

*There are a ton of scoreless bird spawn points around the map. These are active 24 hours a day, but are not guaranteed spawns every time you visit them. All small birds (except for Pileated Woodpecker) can be found at all of these locations.*

Location | Details
:--- | ---
Dakota River, Heartlands, NH | atop rocks and trees in the river and on the shore from **Bard's Crossing** to **Whinyard Strait**
Kamassa River, Roanoke Ridge, NH | atop rocks in the river and on the shore from **Maclean's House** to **Brandywine Drop**
Fort Brennand, Roanoke Ridge, NH | atop the fort walls
Trail Trees, Roanoke Ridge, NH | atop the railing of a bridge northeast of **Trapper**
Cattail Pond, Grizzlies West, AM | atop the flat rockface directly west of the pond
Taxidermist House, Big Valley, WE | atop the house
Lone Mule Stead, Big Valley, WE | atop the house

### Pileated Woodpecker

**NOTE:** Both species of woodpecker when spawned flying have the same flight paths, and can sometimes be seen flying in a follow-the-leader style.

*Primarily diurnal. Flies solo. This is the only bird which never spawns perched atop anything, unlike the Red Bellied Woodpecker. However it does spawn on the ground.*

Location | Details
:--- | ---
Cumberland Forest, NH | flying overhead, primarily southeast of **Fort Wallace**
Clemens Point, Scarlett Meadows, LE | flying overhead around the old cabins near the **Horse Fence**
Little Creek River, Big Valley, WE | flying overhead, primarily on the western junctions (north of **Pronghorn Ranch**)
Aurora Basin, Tall Trees, WE | flying overhead, even at night
Manteca Falls, Hennigan's Stead, NA | flying over the prairies north of the waterfall

### Red Bellied Woodpecker

**NOTE:** Both species of woodpecker when spawned flying have the same flight paths, and can sometimes be seen flying in a follow-the-leader style.

*Primarily diurnal. Flies solo. Can also be found on the sides of tree trunks, as well as perched on bridges and atop large rocks (especially near bodies of water).*

*When perched on trees their pecking sounds are clearly distinctive, and it gets louder if you enter Eagle Eye. The pecking sound usually kicks in when you're about 15 paces from one. Since they blend into tree bark quite well, if you can hear loud pecking but cannot see anything highlighted in Eagle Eye it's probably on the opposite side of the tree trunk. Pecking sounds are not ambient audio, unlike mourning dove calls.*

Location | Details
:--- | ---
Downes Ranch, Heartlands, NH | on the southwest side of a tree trunk just southwest of the barn
Fort Brennand, Roanoke Ridge, NH | perched on fort walls
Viking Burial Site, Roanoke Ridge, NH | atop rocks all along the **Kamassa River**
Bacchus Station, Cumberland Forest, NH | very common, pecking tree trunks on both sides of the path running south from **Bacchus Station**
Painted Sky, Big Valley, WE | perched atop rocks in **Dakota River** northeast of the house
Vetter's Echo, Big Valley, WE | pecking post to the right of the front door
Black Bone Forest, Big Valley, WE | pecking tree trunk east of **Trapper** just below the hill which his camp is set upon
Appleseed Timber Co, Big Valley, WE | east side of tree trunk just west of fourth railroad dot northwest of the logging site's junction
Riggs Station, Big Valley, WE | pecking tree trunk just north of **Trapper**
Old Harry Fen, Scarlett Meadows, LE | pecking tree trunk northeast of **Old Harry Fen**, south of the junction near **Killer Clue**, west side of path running north/south
Old Harry Fen, Scarlett Meadows, LE | pecking tree trunk directly west of junction west of **Old Harry Fen**
Hennigan's Stead, NA | flying overhead
Pleasance House, Cholla Springs, NA | in the hills west of **Pleasance House**; sometimes flying, but more often perched on ground and can be stirred up even at night

### American Robin

*Primarily diurnal. Flies solo. Seems to be quite widespread, but flying spawns appear to be more common in **Great Plains, WE**.*

Location | Details
:--- | ---
Heartland Oil Fields, Heartlands, NH | flying overhead southeast of **Cornwall Kerosene & Tar**
Braithwaite Manor, Scarlett Meadows, LE | flying overhead east of the manor
Flat Iron Lake, Scarlett Meadows, LE | perched on the ground; southwestern side of the southernmost island
Caliga Hall, Bayou Nwa, LE | flying overhead
Roanoke Ridge, NH | on the railing of the bridge north of **Trapper**, near the **Trail Trees**
Kamassa River, Roanoke Ridge, NH | perched atop rocks along the river, north of **Elysian Pool** all the way to **Brandywine Drop**
Fort Brennand, Roanoke Ridge, NH | perched on fort walls and flying overhead
Fort Wallace, Cumberland Forest, NH | flying overhead east of **Fort Wallace**
Cattail Pond, Grizzlies West, AM | perched atop rocks west and southwest of the pond
Upper Montana River, Great Plains, WE | up to four standing on river bank along the south side of the **Upper Montana**; directly across from two canoe spawns south of **Fort Riggs**
Broken Tree, Great Plains, WE | flying overhead, atop large rocks, and small cliffs southwest of **Blackwater**
Aurora Basin, Tall Trees, WE | up to three perched on ground next to directional sign at junction south of **Swadbass Point**

### California Quail

*Primarily diurnal. Usually found in groups of three to four, but sometimes as few as just one or as many as six.*

See `RDR2-CaliforniaQuail.jpg` for locations.

Location | Details
:--- | ---
Carmody Dell, Heartlands, NH | east of the junction southeast of **Carmody Dell**
Diablo Ridge, Big Valley, WE | at the double junction southwest of **Diablo Ridge**
Lone Mule Stead, Big Valley, WE | next to northwest corner of house, **24 HOURS**

### Pigeon

*Primarily diurnal. Two species: Rock Pigeon and Band-Tailed Pigeon. Rock Pigeon swarms spawn in a few places shared with American Crow swarms.*

Location | Details
:--- | ---
Bard's Crossing, Heartlands, NH | perched atop railing of railroad bridge over **Flat Iron Lake**
Bard's Crossing, Heartlands, NH | perched atop rocks on islands below the railroad bridge, usually on the southwest side
Braithwaite Manor, Scarlett Meadows, LE | swarming over grass northeast of the main plantation house; sometimes perched on ground a ways north of 'E' in "BRAITHWAIT**E** MANOR"
Saint Denis, Bayou Nwa, LE | perched on the fence and in the mud around dilapidated train station along tracks northwest of **Crawdad Willies**
Saint Denis, Bayou Nwa, LE | flying over the pond northwest of **Stable**
Van Horn, Roanoke Ridge, NH | swarming over and perched on a decent sized boulder a few paces NW from the **Van Horn Post Office**
Van Horn, Roanoke Ridge, NH | perched on the shore north of **Van Horn**
Annesburg, Roanoke Ridge, NH | perched along the shoreline of the town, usually more numerous on the north shore, may spawn near the piers or atop the dead tree
Cumberland Falls, Big Valley, WE | perched on the ground in middle of paths' intersection on west side of falls.
Pleasance House, Cholla Springs, NA | swarming just south of the **Crashed Airship** (south of **Pleasance House**)

### Rat

*Primarily nocturnal. Two species: Black and Brown. Most spawns can yield either at random. Often found scavenging on dead animals, including humans. Especially dead NPCs found at campsites around **Armadillo, Cholla Springs, NA**.*

Location | Species | Details
:--- | --- | ---
Oil Derrick, Heartlands, NH | Black<br>Brown | close to the rig tower
Limpany, Heartlands, NH | Black<br>Brown | mainly in the two story building on the west end
Bolger Glade, Scarlett Meadows, LE | Black<br>Brown | in and around the **Abandoned Church**
Prinz & Co, Bayou Nwa, LE | Black<br>Brown | around the trash and carcass piles
Saint Denis, Bayou Nwa, LE | Brown | tons of scoreless inside **Doyle's Tavern** during the two infestation random encounters associated with it
Saint Denis, Bayou Nwa, LE | Brown | east end of main path through cemetary near 45 degree turn southeast
Lagras, Bayou Nwa, LE | Black | a few near the west shore across the road from the **Bait Shop**
Pleasance, Scarlett Meadows, LE | Black | around the burned down school house
Copperhead Landing, Bluewater Marsh, LE | Black<br>Brown | around the dilapidated cabin
Maclean's House, Roanoke Ridge, NH | Brown | next to the outhouse west of the farmhouse
Fort Brennand, Roanoke Ridge, NH | Black | inside the fort walls
Wild Man's Cave, Roanoke Ridge, NH | Black | inside the cave
Van Horn, Roanoke Ridge, NH | Black<br>Brown | behind the **Old Light Saloon**
Mysterious Hill Home, Grizzlies East, AM | Black | on the southwest side of the home
Hermit Woman's Shack, Big Valley, WE | Black | inside the shack
Appleseed Timber Co, Big Valley, WE | Black<br>Brown | inside the foreman's cabin after the area is abandoned
Lone Mule Stead, Big Valley, WE | Black | around the cabin
Fort Riggs, Big Valley, WE | Black<br>Brown | around the western fort
The Old Bacchus Place, Hennigan's Stead, NA | Brown | numerous scoreless brown rats inside the shack

### Little Brown Bat

*Solely nocturnal and common across Lemoyne, but can be found in only certain locations outside of Lemoyne.*

Location | Details
:--- | ---
Bolger Glade, Scarlett Meadows, LE | perched on **Abandoned Church**; also may be flying overhead
Braithewaite Manor, Scarlett Meadows, LE | flying around the boat house on the east shore of **Flat Iron Lake**
Bayall Edge, Bayou Nwa, LE | perched on the front of the cabin
Canebreak Manor, Bluewater Marsh, LE | flying over the marsh flats
Macomb's End, Bayou Nwa, LE | swarm in the easternmost house
Pleasance, Scarlett Meadows, LE | swarm in the schoolhouse damaged by a fallen tree; south of 'c' in "Pleasan**c**e"
Fort Brennand, Roanoke Ridge, NH | perched in southwest crows nest
Elysian Pool, Roanoke Ridge, NH | perched on ceiling of cave inside the waterfall
Wild Man's Cave, Roanoke Ridge, NH | perched on ceiling of cave entrance
Flattened Cabin, Grizzlies East, AM | inside the cabin at **Moonstone Pond**; tons of them if you approach shortly after; 18:00
Big Valley, WE | perched in the opening of the dinosaur bone cave northeast of **Watson's Cabin**
Mount Shann, Big Valley, WE | cave mouth just south of 'U' in "MO**U**NT SHANN"; same cave **Winton Holmes** and the player travel to during `Money Lending and Other Sins IV`
Swadbass Point, Tall Trees, WE | perched on north side of cabin at **Aurora Basin**
Two Crows, Cholla Springs, NA | perched in northern shed
Tumbleweed, Gaptooth Ridge, NA | atop the large two story house on the west edge of Tumbleweed

## Domestic Animal Locations

### Bull

Location | Details
:--- | ---
Carmody Dell, Heartlands, NH | in fenced off area on north side of ranch
Hill Haven Ranch, Scarlett Meadows, LE | in the southeasternmost pen
Bayou Nwa, LE | in ranch north of second 'A' in "BAYOU NW**A**"
Hanging Dog Ranch, Big Valley, WE | scoreless; Epilogue only

### Ox

Location | Details
:--- | ---
Downes Ranch, Heartlands, NH | inside fence directly southwest of barn
Downes Ranch, Heartlands, NH | grazing in grass northwest of the ranch
Emerald Ranch, Heartlands, NH | inside the pen behind Seamus' **Fence** barn
Emerald Ranch, Heartlands, NH | walking with rancher southeast of **Heartland Overflow**
Emerald Ranch, Heartlands, NH | walking with rancher southwest of Seamus' **Fence**, northeast of **Old Trail Rise**, just inside the border of **Scarlett Meadows, LE**
Guthrie Farm, Heartlands, NH | inside fence with hay barn on southeast side of farm, sometimes with a Mule
Robard Farm, Scarlett Meadows, LE | inside the wooden fence across from the small pond; southwest of second 'F' in "Southfield **F**lats"
Robard Farm, Scarlett Meadows, LE | northwest edge of the 's' in "Southfield Flat**s**"
Caliga Hall, Scarlett Meadows, LE | near the water northeast of all the houses
Caliga Hall, Scarlett Meadows, LE | west of 'C' in "**C**ALIGA HALL"
Bolger Glade, Scarlett Meadows, LE | walking with rancher across the path north of the 'R' in "BOLGE**R** GLADE"
Braithewaite Manor, Scarlett Meadows, LE | southeast of the main plantation house
Hill Haven Ranch, Scarlett Meadows, LE | walking with rancher across the road northwest of the ranch
Eris Field, Scarlett Meadows, LE | walking with rancher on east side of road directly west of north side of **Ringneck Creek**
Roanoke Ridge, NH | next to the first shack on the road heading southeast out of **Butcher Creek**; northwest of **Manmade Mutant**
Brandywine Drop, Roanoke Ridge, NH | grazing with rancher on west side of path; southeast of **Brandywine Drop**
Macfarlane's Ranch, Hennigan's Stead, NA | grazing with rancher alongside the path north of the train tracks junction on the southeast side of the ranch

### Rooster

Location | Details
:--- | ---
Granger's Hoggery, Heartlands, NH | roaming around the shack
Emerald Ranch, Heartlands, NH | southwest side of ranch
Braithwaite Manor, Scarlett Meadows, LE | in a wooden fence pen in the center of the houses along **Flat Iron Lake**
Bayou Nwa, LE | in ranch north of second 'A' in "BAYOU NW**A**"
Rhodes, Scarlett Meadows, LE | in a wooden fence pen next to a large house east of **Fence**
Butcher Creek, Roanoke Ridge, NH | east edge of the village
Roanoke Ridge, NH | in woodpen fence pen next to a shack dead east of **Huron Glen**
Macfarlane's Ranch, Hennigan's Stead, NA | up to four around chicken coops on south side of ranch

### Chicken

Location | Details
:--- | ---
Emerald Ranch, Heartlands, NH | in a pen on the southwest side of ranch
Armadillo, Cholla Springs, NA | in a pen on the north edge of town
Rathskeller Fork, Gaptooth Ridge, NA | roaming around the farm

### Pig

Location | Details
:--- | ---
Saint Denis, Bayou Nwa, LE | roaming around the slums in the northeast side of town
Saint Denis, Bayou Nwa, LE | roaming around the cabin east of **Algernon's Business**
Armadillo, Cholla Springs, NA | in a fenced off area on the west edge of town (across from the closed down stable)

### Alpine Goat

Location | Details
:--- | ---
Emerald Ranch, Heartlands, NH | in pen west of **Seamus' Fence**
Van Horn Stable, Roanoke Ridge, NH | in a fenced pen south of the stable
Little Creek River, Big Valley, WE | north of path running east/west, southeast of **Watson's Cabin**
Rathskeller Fork, Gaptooth Ridge, NA | roaming around the farm
Pleasance House, Cholla Springs, NA | roaming down the hill south of the house
Silent Stead, Gaptooth Ridge, NA | one lone goat in the pen behind the shack

### Merino Sheep

Location | Details
:--- | ---
Emerald Ranch, Heartlands, NH | penned up in fence on southwest side of ranch
Emerald Ranch, Heartlands, NH | herded by rancher heading northeast towards the ranch; 15:05
Caliban's Seat, Heartlands, NH | herded by rancher heading southwest across the large triple junction east of **Caliban's Seat**
Little Creek River, Big Valley, WE | in open field herded by rancher heading east, north of **Vetter's Echo**
Little Creek River, Big Valley, WE | coming from tree line herded by rancher heading southeast, a bit southeast of **Watson's Cabin**

## Horse Stats and Locations

[Source.](https://reddead.fandom.com/wiki/Horse#Red_Dead_Redemption_2)

**(!)** Unique

Breed | Coat | Type | Handling | Health | Stamina | Speed | Acceleration | Location(s)
:---- | ---- | ---- | -------- | ------ | ------- | ----- | ------------ | -----------
American Paint | Grey Overo | Work | Standard | 5 | 5 | 4 | 4 | **Tumbleweed, Gaptooth Ridge, NA** (stable)
American Paint | Overo | Work | Standard | 3 | 4 | 3 | 3 | -
American Paint | Splashed White | Work | Standard | 3 | 5 | 3 | 3 | -
American Paint | Tobiano | Work | Standard | 3 | 4 | 3 | 3 | -
American Standardbred | Black | Race | Race | 3 | 3 | 4 | 3 | -
American Standardbred | Buckskin | Race | Race | 3 | 3 | 4 | 3 | -
American Standardbred | Palomino Dapple | Race | Race | 3 | 3 | 5 | 4 | **Valentine, Heartlands, NH** (stable)
American Standardbred | Silver Tail Buckskin | Race | Race | 4 | 4 | 5 | 5 | **Tumbleweed, Gaptooth Ridge, NA** (stable)
Andalusian | Dark Bay | War | Standard | 5 | 4 | 3 | 3 | **Strawberry, Big Valley, WE** (stable)
Andalusian | Rose Grey | War | Standard | 7 | 5 | 3 | 3 | **Van Horn, Roanoke Ridge, NH** (stable)
Andalusian | Perlino | War | Standard | 7 | 5 | 3 | 3 | **Brandywine Drop, Roanoke Ridge, NH**
Appaloosa | Blanket | Work | Standard | 3 | 4 | 3 | 3 | -
Appaloosa | Brown Leopard | Work | Standard | 5 | 6 | 4 | 3 | **Tumbleweed, Gaptooth Ridge, NA** (stable)
Appaloosa | Leopard | Work | Standard | 5 | 6 | 4 | 3 | **Van Horn, Roanoke Ridge, NH** (stable)
Appaloosa | Leopard Blanket | Work | Standard | 3 | 4 | 3 | 3 | -
Appaloosa | Few Spotted | Work | Standard | 3 | 5 | 3 | 3 | -
Appaloosa | Scarred Blanket | Work | Standard | 3 | 3 | 2 | 2 | during random encounters with Murfree Brood
Arabian | Black | Superior | Elite | 6 | 6 | 6 | 6 | **Saint Denis, Bayou Nwa, LE** (stable)<br>random encounter `Pedestrian Robbery` in **Saint Denis, Bayou Nwa, LE**
Arabian | Rose Grey Bay | Superior | Elite | 7 | 7 | 6 | 6 | **Blackwater, Great Plains, WE** (stable)
Arabian | White | Superior | Elite | 5 | 5 | 6 | 6 | **Lake Isabella, Grizzlies West, AM**
Arabian | Red Chestnut | Superior | Elite | 4 | 5 | 5 | 4 | **Owanjila, Big Valley, WE** (west side)
Arabian | Warped Brindle | Superior | Elite | 3 | 5 | 6 | 4 | **Wapiti, Grizzlies East, AM** (northwest of)
Ardennes | Bay Roan | War | Standard | 5 | 4 | 3 | 3 | **Scarlett Meadows, Scarlett Meadows, LE** (stable)
Ardennes | Strawberry Roan | War | Standard | 7 | 5 | 3 | 3 | **Van Horn, Roanoke Ridge, NH** (stable)
Belgian Draft | Mealy Chestnut<br>Blonde Chestnut | Draft | Heavy | 3 | 3 | 3 | 3 | pulling random NPC wagons
Dutch Warmblood | Chocolate Roan | Work | Standard | 5 | 6 | 4 | 3 | **Valentine, Heartlands, NH** (stable)
Dutch Warmblood | Seal Brown | Work | Standard | 4 | 5 | 3 | 3 | **Strawberry, Big Valley, WE** (stable)<br>`Bounty Hunter` random encounters<br>ridden by one of Cornwall's men during `An Honest Mistake`
Dutch Warmblood | Sooty Buckskin | Work | Standard | 4 | 5 | 3 | 3 | **Scarlett Meadows, LE** (stable)<br>`Prospector` random encounters<br>`Bounty Hunter` random encounters
Dutch Warmblood **(!)** | Cremello Gold | Work | Standard | - | - | - | - | during `The Veteran - V`
Hungarian Halfbred | Dapple Dark Grey | War | Standard | 5 | 4 | 3 | 3 | **Valentine, Heartlands, NH** (stable)
Hungarian Halfbred | Flaxen Chestnut | War | Standard | 4 | 3 | 3 | 3 | Wild
Hungarian Halfbred | Piebald Tobiano | War | Standard | 4 | 3 | 3 | 3 | **Twin Stack Pass, Heartlands, NH** (bounty hunter camp west of)<br>during `An Honest Mistake`
Kentucky Saddler | Grey<br>Chestnut Pinto<br>Black<br>Silver Bay | Riding | Standard | 3 | 2 | 3 | 2 | Ambient/Wild
Missouri Fox Trotter | Amber Champagne | Race/Work | Standard | 5 | 6 | 7 | 5 | **Scarlett Meadows, LE** (stable)
Missouri Fox Trotter | Silver Dapple Pinto | Race/Work | Standard | 5 | 6 | 7 | 5 | **Blackwater, Great Plains, WE** (stable)<br>during `Arcadia for Amateurs - III`<br>during `Trapped Rider` random encounters
Morgan | Palomino<br>Bay<br>Bay Roan<br>Flaxen Chestnut | Riding | Standard | 2 | 3 | 3 | 2 | Ambient/Wild
Mustang | Grullo Dun<br>Wild Bay | War/Work | Standard | 4 | 4 | 3 | 2 | Wild
Mustang | Tiger Striped Bay | War/Work | Standard | 5 | 5 | 4 | 3 | **Rio Del Lobo Rock, Rio Bravo, NA**
Nokota | Reverse Dapple Roan | Race | Race | 3 | 3 | 7 | 5 | **Saint Denis, Bayou Nwa, LE** (stable)
Nokota | Blue Roan<br>White Roan | Race | Race | 3 | 3 | 4 | 3 | Wild
Nokota | Scarred Blue Roan | Race | Race | 3 | 3 | 4 | 3 | during random encounters with Murfree Brood
Shire | Dark Bay<br>Light Grey | Draft | Heavy | 4 | 3 | 3 | 2 | pulling NPC wagons
Shire **(!)** | Raven Black | Draft | Heavy | 4 | 4 | 3 | 2 | during `Exit Pursued by a Bruised Ego`
Suffolk Punch | Red Chestnut | Draft | Heavy | - | - | 3 | 2 | pulling NPC wagons
Tennessee Walker | Flaxen Roan | Riding | Standard | 3 | 3 | 2 | 2 | **Tumbleweed, Gaptooth Ridge, NA** (stable)
Tennessee Walker | Mahogany Bay | Riding | Standard | 3 | 3 | 2 | 2 | during `Outlaws from the West`
Tennessee Walker | Gold Palomino | Riding | Standard | 3 | 4 | 3 | 2 | Ambient/Wild
Tennessee Walker | Black Rabicano<br>Chestnut<br>Dapple Bay<br>Red Roan | Riding | Standard | 3 | 3 | 2 | 2 | Ambient/Wild
Thoroughbred | Brindle | Race | Race | 3 | 3 | 7 | 5 | **Strawberry, Big Valley, WE** (stable)
Thoroughbred | Blood Bay<br>Dapple Grey | Race | Race | 3 | 3 | 4 | 3 | Wild
Thoroughbred **(!)** | Seal Brown | Race | Race | 4 | 4 | 6 | 4 | after `The Wheel`
Turkoman | Dark Bay | Race/War | Standard | 7 | 5 | 6 | 5 | **Blackwater, Great Plains, WE** (stable)
Turkoman | Gold | Race/War | Standard | 7 | 5 | 6 | 5 | **Saint Denis, Bayou Nwa, LE** (stable)
Turkoman | Silver | Race/War | Standard | 7 | 5 | 6 | 5 | **Tumbleweed, Gaptooth Ridge, NA** (stable)
Mule | - | Work | Standard | - | - | - | - | **Emerald Ranch, Heartlands, NH** (south side of ranch in front of Seamus' **Fence**)

**Early Unlocks:**

Breed | Coat | Details
:--- | --- | ---
Turkoman | Dark Bay | In **Chapter 3** during `Horse Flesh for Dinner`. Before starting the mission, discard/sell all possible horse food options, then fill up on **Sugar Cubes** from a **Stable**. Start the mission and continue until right after you rope in the escaped (untethered) horse. When John and Javier are mounted still next to the brothers who run the **Horse Fence**, dismount your horse, walk up to the Turkoman, and hold the prompt to feed it until you reach bonding rank 1 (and it becomes a temporary horse, shown by an icon on the map). Getting close to the brothers will trigger the next cutscene, so stay away from them while you're feeding the Turkoman.
Missouri Fox Trotter | Silver Dapple Pinto | (METHOD 1) During the random encounter where the woman's horse "Biscuit" has died and she needs a ride to Emerald Ranch, a glitch can occur where the horse, a Silver Dapple Pinto, will be found alive and can be claimed. Similarly, a woman needing a ride to Lagras will also have Silver Dapple Pinto that will occasionally spawn alive. One way to ensure this is to go stand upon Face Rock where the event spawns by, aim with a sniper rifle at the road below after which the event should spawn so long as the encounter has not been completed by the player prior, and keep shooting the lady. This causes both her and her horse to respawn, and eventually, it should respawn alive, and can be claimed by the player. [[Source.]](https://youtu.be/E3bM1zs83GM) [[Source.]]()<br><br>(METHOD 2) Another alternative way to obtain the Silver Dapple Pinto coat as Arthur is after the third encounter with Albert Mason `Arcadia For Amateurs III`. While herding the horses, go into Eagle Eye, track the Silver Dapple Pinto and then exit Eagle Eye while staying focused on the horse's trail. Once Mason photographs the herd, go to him and skip the cutscene as soon as it starts. Then follow the horse's trail, carefully and patiently, as the trail can be lost and the tracking process can last approximately up to 10 minutes. Once you find the horse, jump on it from your horse's back and ride it to the nearest stable without dismounting it to saddle it up or store it. Save the game and load the save file you just made. Then the horse will be yours to keep. [[Source.]](https://youtu.be/uaFjw5BlOZo) [[Source.]](https://youtu.be/DJgv9dChjPs) [[Wagon method.]](https://youtu.be/GqN3ygmcfwI)
Dutch Warmblood | Cremello Gold | The special horse a.k.a. Buell, Hamish Sinclair's horse. You can get him as [both Arthur and John](https://youtu.be/B-NCMd6ftjA).

## Activites

### Coffee

*The rare four-sip brews.*

Location | Details
:--- | ---
Beecher's Hope, Great Plains, WE | at main campfire
Blackwater, Great Plains, WE | camp on southwest side of town
Blackwater, Great Plains, WE | at campfires in bank construction zone

### Alcohol Cases

*Homebrew and swamp whiskey.*

Location | Type | Details
:--- | --- | ---
Valentine, Heartlands, NH | beer | in camp west of town
Hill Haven Ranch, Scarlett Meadows, LE | whiskey | inside ranch house
Rhodes, Scarlett Meadows, LE | whiskey | next to campfire in **Trelawny's Caravan**
Rhodes, Scarlett Meadows, LE | beer | center of houses west of **Fence**
Saint Denis, Bayou Nwa, LE | whiskey | two cases in alley northwest of **Doyle's Tavern**
Saint Denis, Bayou Nwa, LE | random | south side of house directly north of cemetary
Van Horn, Roanoke Ridge, NH | beer | in run down house across from **Five Finger Fillet**
Van Horn, Roanoke Ridge, NH | beer | atop house boat on southeast side of town
Van Horn, Roanoke Ridge, NH | beer | directly west of **Five Finger Fillet**
Butcher Creek, Roanoke Ridge, NH | whiskey | atop a table next to a stew over a campfire
Butcher Creek, Roanoke Ridge, NH | whiskey | atop a table next to the house just north of the butcher's canopy
Downes Ranch, Heartlands, NH | beer | inside ranch house
Castor's Ridge, Heartlands, NH | beer | inside house
Lagras, Bayou Nwa, LE | beer<br>random<br>whiskey | two beer, two whiskey, one random, all among the houses
Wapiti, Grizzlies East, AM | beer | next to a cabin on the northwest side of the settlement; not present in Epilogue
Beecher's Hope, Great Plains, WE | beer | atop blacksmithing table
Blackwater, Great Plains, WE | beer | in camp southwest of town
Blackwater, Great Plains, WE | beer | on the porch of the first houses west of the **Blackwater Post Office** and **Blackwater Stable**
Ridgewood Farm, Cholla Springs, NA | whiskey | outside the southeast corner of the farmhouse

### Stew Bowl

*Guess... it's a surprise, then.*

Location | Details
:--- | ---
*all story camp locations* | Pearson makes stew every day
Valentine, Heartlands, NH | in camp west side of town
Beecher's Hope, Great Plains, WE | Abigail will serve stew every evening
Blackwater, Great Plains, WE | west side of bank construction
Blackwater, Great Plains, WE | southeast side of camp outside of town

### Chop Firewood

*Mr. Appleseed would be proud.*

Location | Details
:--- | ---
Hill Haven Ranch, Scarlett Meadows, LE | south side of ranch house
Rhodes, Scarlett Meadows, LE | south side of house directly west of **Rhodes Parlour House**
Beecher's Hope, Great Plains, WE | next to main campfire

# MISCELLANEOUS

### Cool Things

*All references to controls are in terms of Xbox One/Series controllers.*

[Reference](https://gtaforums.com/topic/917511-things-you-didnt-know-about-rdr2-until-now/)

- Double-tap RB to walk your horse backwards.
- Perform a flashy holster animation by double-tapping LB. Works with only primary sidearm. Does not work with Sawed Off Shotgun.
- You can buy goods from some of the shops at the **Saint Denis Market**.

### Tools

- [CodeWalker](https://github.com/dexyfex/CodeWalker)

### Mods

- [ScriptHookRDR2](https://www.dev-c.com/rdr2/scripthookrdr2/) - ScriptHookRDR2 base required for ASI plugin mods. SDK for development of C++ plugins available on the same page.
- [Lenny's Mod Loader (LML)](https://www.rdr2mods.com/downloads/rdr2/tools/76-lennys-mod-loader-rdr/) - Stream modded content directly into game. Required by all mods that stream files.
- [RampageTrainer](https://www.nexusmods.com/reddeadredemption2/mods/233) - SP trainer.
- [Stash That Lantern](https://www.nexusmods.com/reddeadredemption2/mods/333) - Store lantern on satchels, both your own and on your horse.
- [ImprovedLoot](https://www.nexusmods.com/reddeadredemption2/mods/1596) - Improves NPC, animal, and herb loot pool. Also improves clean kills on many weapons.
- [Realistic Weapon Rebalance](https://www.nexusmods.com/reddeadredemption2/mods/1156) - Rebalances all guns in story mode.
- [Non-Sticky Hats](https://www.nexusmods.com/reddeadredemption2/mods/263) - Changes physics to make hats more likely to fall off.
- [Main Menu and Legal Skip](https://www.nexusmods.com/reddeadredemption2/mods/1469) - Boot right into story mode.
- [SnappyUI](https://www.nexusmods.com/reddeadredemption2/mods/971) - Disable the "smooth transition" in the pause menu.
- [Better Horses](https://www.nexusmods.com/reddeadredemption2/mods/842) - Improves horse stats of those which basically only the player can own.
- [Multiclass Horses](https://www.nexusmods.com/reddeadredemption2/mods/1226) - Cross-species horse coats. Avaiable for all breeds.
- [Remove Horse Speed Limit](https://www.nexusmods.com/reddeadredemption2/mods/975) - Removes horse speed limit in towns and on train tracks.
- [Clothing and Accessory Textures](https://www.nexusmods.com/reddeadredemption2/mods/570) - Various modded textures for player clothing.
- [Proper Horse Sprint on Controller](https://www.nexusmods.com/reddeadredemption2/mods/1347) - Locks current horse speed while holding A.

### Programs Used

- [GNU Image Manipulation Program](https://www.gimp.org/) - *Editing maps.*
- [GreenShot](https://github.com/greenshot/greenshot) - Capturing in-game screenshots.
- [nomacs](https://github.com/nomacs/nomacs) - Scan through screenshots when marking new locations.
- [CheatEngine](https://www.cheatengine.org/download/CheatEngine7.2_MissingSetup.rar) - *portable version; used for speedhack to make time fly by.*
- [7-Zip](https://www.7-zip.org/) - *Archiving and compressing.*
- [VS Code](https://code.visualstudio.com/) - *Editing and previewing Markdown docs.*

### References

- [RDR Fandom Missable Content](https://reddead.fandom.com/wiki/Missable_Content_in_Redemption_2) [[Steam]](https://steamcommunity.com/sharedfiles/filedetails/?id=2002543938) [[GTAForums]](https://gtaforums.com/topic/924480-spoilers-everything-missable-in-rdr2/)
- [RDR2Mods](https://www.rdr2mods.com/) - focused around RDR2 modding. Wiki with databases, tutorials, and references (including hash IDs). [[Wiki]](https://www.rdr2mods.com/wiki/)
- [RDOMap](https://jeanropke.github.io/RDOMap/) and its associated [contributors](https://github.com/jeanropke/RDOMap/blob/master/CONTRIBUTORS.md) for nearly all sit locations.
- [Complete Map](https://gtaforums.com/topic/968364-complete-map-with-all-discoverable-icons/) - Story mode map with all discoverable animal icons and location names.
- [Original map, a fantastic 10MP hillshaded render](https://www.reddit.com/r/reddeadredemption/comments/gimo7v/10mp_rdr2_game_map_redux_enhanced_with_hillshaded/) by Reddit user [domriccobene](https://www.reddit.com/user/domriccobene/).
- [Sit map](https://www.reddit.com/r/RedDeadOnline/comments/bzv17m/for_those_of_you_who_like_to_stay_classy_even/) by Reddit user [Impossible_Phase](https://www.reddit.com/user/Impossible_Phase/).
- [ViktorFekete](https://gtaforums.com/profile/1197324-viktorfekete/) for narrowing the search area for cougars around **Benedict Point, Gaptooth Ridge, NA**.
- [Looser3241](https://gtaforums.com/profile/1225578-looser3241/) for the sit location at **Clemens Point, Scarlett Meadows, LE**. [Cutter de Blanc](https://gtaforums.com/profile/642145-cutter-de-blanc/) for testing the location.

For select animal population maps:

- [Red Dead Wiki](https://reddead.fandom.com/)
- [GosuNoob](https://www.gosunoob.com/red-dead-redemption-2/)
- [GTABase](https://gtabase.com/)
- [RDR2.org](https://rdr2.org/)
- [PowerPyx's Guides](https://www.powerpyx.com/red-dead-redemption-2-all-animal-locations-zoologist-skin-deep/)

### Testing Procedures

Here's some notes on what all I keep constant while playing:

- PC, latest version, locked at 60fps, V-Sync on, Triple Buffering on, mostly medium settings aside from low lighting qualities and ultra textures.
- All animals are tracked back to their original locations via **Eagle Eye**. All locations shown were verified at least twice before being marked.
- Dismount horse well away from spawn.
- Constant application of **Cover Scent Lotion**, as in once every 30 or so seconds.
- Slow approach, normal crouched walking.
- RampageTrainer (freeze/change time/weather; 2021/12/05 using Ignored By Wild Animals to pinpoint exact spawn locations)

### Release Format

You can download archives of maps in the `Releases` tab on the right side of this page. All releases are in 7z format with LZMA2 compression, so you'll need an archiving program capable of extracting LZMA2 7-zip archives. I use [7-zip itself](https://www.7-zip.org/), but you're free to use whatever you want.

In-game screenshots of the player sitting at a "sit" location are uploaded in their own, separate archives with the suffix `SitLocationsInGame` (i.e. `rdr2-maps-2021-11-07-SitLocationsInGame.7z`).

### Quotes

[Abe (Ep. I, Simple Pleasures)](https://game-scripts.fandom.com/wiki/Red_Dead_Redemption_2#Simple_Pleasures)

> It’s changed. Rich fellers are coming in and buying everything... the ranches... but... well, it ain’t as wild as it once were, at least. 

[Charles Smith (Ep. II, Bare Knuckle Friendships)](https://game-scripts.fandom.com/wiki/Red_Dead_Redemption_2#Bare_Knuckle_Friendships)

> Those are Guido Martelli's men.