# ImprovedLoot

[ImprovedLoot](https://www.nexusmods.com/reddeadredemption2/mods/1596) by [sajuuk6](https://www.nexusmods.com/reddeadredemption2/users/117678753).

*A modification for RDR2 which improves gang and animal loot, as well as rebalancing hunting with changes to kill cleanliness.*

This document is in Markdown format, and as such requires a Markdown parser to read properly. I recommend [VS Code](https://code.visualstudio.com/) (press `Ctrl+Shift+V` to preview Markdown), but [Notepad++](https://notepad-plus-plus.org/) also has a Markdown plugin which can be [installed manually](https://github.com/nea/MarkdownViewerPlusPlus) or via the Notepad++ [Plugins Admin](https://npp-user-manual.org/docs/plugins/).

# Table of Contents

[Top](#improvedloot)
<br>[Table of Contents](#table-of-contents)
<br>[Installation](#installation)
<br>[Using Modded Content Selectively](#using-modded-content-selectively)
<br>[Altering Values and Loot Pools](#altering-values-and-loot-pools)
<br>[CHANGELOG](#changelog)
<br>&emsp;[v2023.01.14](#v20230114)
<br>&emsp;[v2023.01.06](#v20230106)
<br>&emsp;[v2022.10.08](#v20221008)
<br>&emsp;[v2022.07.27](#v20220727)

# Installation

You'll need only [Lenny's Mod Loader (LML)](https://www.rdr2mods.com/downloads/rdr2/tools/76-lennys-mod-loader-rdr/). No, you don't need any trainer or DLL. Nor ScriptHookRDR2. Once you've installed LML, extract the `ImprovedLoot` folder in the archive to your `lml` folder and run the game. (Remember to run `RDR2.exe` as administrator to prevent LML file access issues.)

# Using Modded Content Selectively

Want to apply only parts of my mod? You can delete files which alter data you don't wish to be changed. Or, in the case you're using another mod which alters the same file(s) and prefer it to take priority over mine, you can change my mod to an earlier `LoadOrder` than the mod you wish to prioritize. For details on what each file does, here's a table:

File | Description
:--- | ---
damagecleanlinessdata.meta | Shot scoring (kill cleanliness).
loot_items_matrix.meta | Animal loot pools.
loot_table_herb.meta | Herb loot pools.
loot_table_itemgroups.meta | Item loot pools.
loot_table_passthrough.meta | Ped (NPC) loot pools. These are parent trees and break off to pools in `loot_table_ped.meta`.
loot_table_ped.meta | Ped (NPC) loot pools. Followed from `loot_table_passthrough.meta`.

# Altering Values and Loot Pools

The modded files are plaintext and in **XML** format, so if you've no experience in programming get ready. Simply edit the values as needed and re-launch the game. I've included as many comment notes as possible in each file pertaining to what exactly was changed and how it may affect other things.

And since it's all **XML**, I recommend copying the whole file's plaintext and running it through the [w3schools XML validator](https://www.w3schools.com/xml/xml_validator.asp). I've used similar parsers in the past, but this one is quick and easy. Not to mention it gives specific line and column numbers for errors. REMEMBER TO CLOSE ALL YOUR TAGS, LOL.

# Changelog

### v2023.01.14

- `PS_EXTRA_LARGE` (bears, bison, etc) can now be clean killed via any hit area using *ONLY* **Shotgun Slug**, **Poison/Improved Arrow**, **Poison Throwing Knife**, and all **Rifle** ammo. Limb is excluded and only maintains `Perfect` status if hit with a **Poison Throwing Knife** or **Poison Arrow**. Had some unusual inconsistency killing pristine griz with what I landed as a headshot with stock ammo, yet didn't get the perfect-perfect bonus.
- `PS_LARGE` (deer, cougars, etc) can now be clean killed with **Pistol** *ONLY IF IT'S A HEADSHOT*. **Revolver** still clean kills on all crits.
- `PS_MEDIUMLARGE` (foxes, goats, etc) can now be clean killed with **Revolver** on crits.
- Gang loot now includes a small monetary benefit of `$1.00` to `$3.00` per body.
- Removed `MALE_GROOMING_ITEMS` from gang loot.
- Removed potent baits from `HUNTING ITEMS`.
- Added `USED_MEDS` (opened tonics). All gang NPCs will now drop opened tonics regardless of honor. The drop rate of **Opened Miracle Tonic** is far greater than **Opened Health Cure**, **Opened Bitters**, and **Opened Snake Oil**.
- Ammo drops are now `4` to `6` bullets per body.
- Removed unopened **Cover Scent Lotion** from `HUNTING ITEMS`.
- Removed unopened **Gin**, **Guarma Rum**, and **Fine Brandy** from `ALCOHOL ITEMS`. Gang members are perpetually drunk.
- Added **Opened Kentucky Bourbon** to `ALCOHOL ITEMS`.
- Grouped `USED_MEDS` and `ALCOHOL_ITEMS` into their own pool: `GANG_LOOT_TONIC`. Gang loot now has four drop groups.

### v2023.01.06

- All animals now yield meat, feathers, and fat according to both pelt quality and kill cleanliness. Had to change a lot of stuff around because I fucked up the numbers last time around.
- Added bonus for clean kills on pristine animls. Meat bonus (increase yield by `1`) is for all animals, but those with loot specific to them (**Horns**, **Antlers**, **Fang**, **Claw**, etc) now give `2` of their associated loot if the animal has a pristine pelt (3 star) and is killed cleanly.
- All small birds still yield `1` **Gamey Bird Meat**, but feather yields have been changed to match `DamageQuality`. You will be punished for blowing those helpless little three star woodpeckers to bits with your Springfield.
- All large birds and varmints now yield `1` **Gamey Bird Meat** unless the `DamageQuality` is `Perfect` and the `SkinQuality` is either `Good` or `Perfect`. In which case, you get `2`. Basically if you clean kill one of these when it's either a two or three star, you'll get the extra meat. For some reason, I had it set to where you can get the meat bonus if you clean kill a poor quality varmint. That's been fixed.
- `A_C_BAT_01` now yields only `1` wing if either `DamageQuality` or `SkinQuality` is `Poor`. Still yields `2` **Bat Wing** otherwise.
- `A_C_ALLIGATOR_01` now yield `4` to `6` **Herptile Meat**. No more big game farming down in those swamps.
- `A_C_BEAR_01` now yield `4` to `6` **Big Game Meat** and **Animal Fat**.
- `A_C_BEARBLACK_01` now yield `2` to `4` **Big Game Meat** and **Animal Fat**.
- `A_C_BEAVER_01` now yields `1` to `2` **Game Meat**, `1` to `2` **Animal Fat**, and `1` to `2` **Scent Glands**.
- `A_C_BEAVER_01` *(LEGENDARY)* now yields `4` **Game Meat**, `4` **Animal Fat**, and `2` **Scent Glands** regardless of `DamageQuality`.
- `A_C_BIGHORNRAM_01` now yields `2` to `4` **Gristly Mutton** and `1` to `2` **Bighorn Horn**.
- `A_C_BIGHORNRAM_01` now yields `6` **Gristly Mutton** regardless of `DamageQuality`.
- `A_C_BOAR_01` now yields `1` to `3` **Tender Porkloin**, `1` to `3` **Animal Fat**, and `1` to `2` **Boar Tusk**.
- `A_C_BOAR_01` *(LEGENDARY)* now yields `6` **Tender Porkloin** and **Animal Fat** regardless of `DamageQuality`.
- `A_C_BUCK_01` now yields `2` to `4` **Mature Venison** and `1` to `2` **Buck Antler**.
- `A_C_BUCK_01` now yields `6` **Mature Venison** regardless of `DamageQuality`.
- `A_C_BUFFALO_01` now yields `4` to `6` **Prime Beef**, `4` to `6` **Animal Fat**, and `1` to `2` **Bison Horn**.
- `A_C_BUFFALO_01` *(LEGENDARY)* now yields `8` **Prime Beef** and `8` **Animal Fat** regardless of `DamageQuality`.
- `A_C_BUFFALO_TATANKA_01` *(LEGENDARY)* now yields `8` **Prime Beef** and `8` **Animal Fat** regardless of `DamageQuality`.
- `A_C_BULL_01`, `A_C_OX_01` now yield `4` to `6` **Prime Beef**, `4` to `6` **Animal Fat**, and `1` to `2` **Bull Horn**.
- `A_C_CALIFORNIACONDOR_01` no longer yields any meat. They're trash birds, like buzzards.
- `A_C_COUGAR_01` now yields `2` to `4` **Big Game Meat** and `1` to `2` **Cougar Fang**.
- `A_C_COW_01` now yields `4` to `6` **Prime Beef** and `4` to `6` **Animal Fat**.
- `A_C_DEER_01` now yields `2` to `4` **Mature Venison**.
- `A_C_EAGLE_01` now yields `1` to `2` **Eagle Talon**.
- `A_C_ELK_01` now yields `4` to `6` **Mature Venison** and `1` to `2` **Elk Antler**.
- `A_C_ELK_01` *(LEGENDARY)* now yields `4` to `6` **Mature Venison** and `1` to `2` **Elk Antler**.
- `A_C_FOX_01` *(LEGENDARY)* now yields `5` **Stringy Meat** regardless of `DamageQuality`.
- `A_C_FROGBULL_01` now yields `2` **Herptile Meat** matching the changes to varmints and larger birds. Frogs have two tasty back legs, after all.
- `A_C_GOOSECANADA_01` now yields `1` to `2` **Animal Fat**.
- `A_C_JAVELINA_01` now yields `1` to `3` **Tender Porkloin** and `1` to `2` **Animal Fat**.
- `A_C_MOOSE_01` now yields `4` to `6` **Mature Venison** and `1` to `2` **Moose Antler**.
- `A_C_MOOSE_01` *(LEGENDARY)* now yields `8` **Mature Venison** regardless of `DamageQuality`.
- `A_C_OX_01` now yields `4` to `6` **Prime Beef** and `1` to `2` **Ox Horn**, but no longer yields **Animal Fat**.
- `A_C_PANTHER_01` now yields `2` to `4` **Big Game Meat**.
- `A_C_PHEASANT_01` now yields `1` to `2` **Animal Fat**.
- `A_C_PIG_01` now yields `1` to `3` **Tender Porkloin** and `1` to `3` **Animal Fat**.
- `A_C_PRONHGORN_01` now yields `2` to `4` **Mature Venison**.
- `A_C_PRONHGORN_01` *(LEGENDARY)* now yields `6` **Mature Venison** regardless of `DamageQuality`.
- `A_C_QUAIL_01` now yields only `1` **Game Meat**.
- `A_C_SEAGULL_01` now yields only `1` to `2` **Gamey Bird Meat**.
- `A_C_SHEEP_01` now yields `1` to `3` **Gristly Mutton**.
- `A_C_TOAD_01` no longer yields meat. Toa
- `A_C_TOAD_01` no longer yields any meat. Virtually all toads IRL are poisonous even when cleaned and cooked properly.
- `A_C_TURTLESNAPPING_01` now yields `1` to `3` **Herptile Meat**.
- `A_C_VULTURE_01` no longer yields any meat. Who the hell eats vulture meat, even in famine?
- `A_C_WOLF_01`, `A_C_WOLF_MEDIUM`, and `A_C_WOLF_SMALL` now yield `2` to `4` **Stringy Meat**. Big game from random wolf ambushes was too easy to farm.
- Unopened drinks in `ALCOHOL_ITEMS` now drop considerably less often than opened versions.
- `GANG_LOOT_AMMO` now draws from three tables: `THROWABLE_AMMO` (just knives now), `LARGE_ARMS_AMMO` (**Rifle**, **Repeater**, **Shotgun Shell**, and **Shotgun Slug**), and `SMALL_ARMS_AMMO` (**Revolver** and **Pistol**).
- Removed **Dynamite** and **Fire Bottles** from `THROWABLE_AMMO`.
- Removed **Dynamite Arrows** and **Fire Arrows** from `ARROW_AMMO`.
- Reduced `XP_TONIC` rate to `0.05` in `GANG_LOOT_REWARD`. After testing, the chance of looting any XP tonic is extremely rare now.
- `GANG_LOOT_REWARD` now draws from numerous tables: `HUNTING ITEMS` (cover scent, gun oil, potent baits), `JEWELRY_ITEMS_MALE` (rings, watches, teeth, etc), `MALE_GROOMING_ITEMS` (hair tonic, hair pomeade), `ANIMAL_PELTS_SMALL_PERFECT` (random varmint pelts), and `XP_TONICS` (aged pirate rum, ginseng elixer, valerian root).
- `GANG_LOOT_FOOD` now draws from: `ALCOHOL_ITEMS` (opened and unopened **Fine Brandy**, **Guarma Rum**, and **Gin**, with small chance to loot **Moonshine**), `FOOD_ITEMS_CAN` (all canned goods), and `FOOD_ITEMS_SNACK` (jerky).
- `HUNTING_ITEMS` now has drastically reduced drop rates of potent baits.
- Moved all XP tonics to their own table `XP_TONICS`.
- Consolidated all gang loot into one primary group `GANG_LOOT_PED`. Three groups are rolled, and the chances have been lowered to prevent overcrowding of inventory.
- Added loot for **Laramie Boys**.
- Added loot for all **O'Driscolls**.
- Removed ammo loot from dropped weapons. Ammo boxes still give ammo when looted.
- Added chance to loot gold and silver teeth in `JEWELRY_ITEMS_MALE`. All enemy gang NPCs now have a chance to drop them.
- `PS_MEDIUM` (owls, hawks, beavers, etc) and `PS_LARGE` (deer, cougars, etc) can now be cleanly killed with **Repeaters**. Critical hits only. You still don't need to lug around a **Varmint Rifle** as **Pistols/Revolvers** still clean kill these regardless, but I wanted to open up the capability for hunting with **Repeaters**.
- Decreased yield of all herbs to `1`. **Ram Horn Trinket** still doubles herb loot, so all plants yield `2` if the trinket is crafted and owned. This was done after several days of playing and having to discard a lot of herbs I pick often. Getting `6` of quite a few herbs from just a single plant was getting to be a bit excessive, so I just cut the loot back to the normal `1` and made the **Ram Horn Trinket** double the yield of all plants to `2`. Given all **Special Tonics** require `2` of certain herbs, I reckon `2` with the trinket is good enough for balancing. Basically just halves the workload. In the case for **Special Miracle Tonic**, albeit not a whole lot better than other **Special Tonics**, collecting three of each plant (for a total of `6` with trinket) isn't hard to do if you know where to look.
- No changes were made to any **Orchids** nor the **Vanilla Flower**. They still only yield `1` with and without the **Ram Horn Trinket**.
- Added `CONSUMABLE_OFFAL` to `FOOD_ITEMS_CANNED` table. Changed all drop chances in table to `0.10`.

### v2022.10.08

- Increased loot yield for all plants. Took inspiration from [Herbalist mod](https://www.nexusmods.com/reddeadredemption2/mods/1457).
- Orchid loot, including **Vanilla Flower**, was left untouched.
- **Ram Horn Trinket** now doubles the yield of all plants. Numbers listed below are without trinket.
- **Alaskan Ginseng**, **American Ginseng**, **Burdock Root**, **Common Bulrush**, **Milkweed**, and **Wild Carrot** now yield `2`.
- All other herbs now yield `3`.
- Animals which yield `PROVISION_ANIMAL_SCENT_GLAND` and/or `PROVISION_ANIMAL_FAT` now yield at least one more of each/either when carcass quality and kill qualities are both perfect. This was done to make crafting your own **Cover Scent Lotion**, **Fire Bottles**, and **Fire Arrows** a lot less time consuming. And what kind of true hunter *buys* their scentblock?
- `A_C_BADGER_01` and `A_C_RACOON_01` now yield `PROVISION_ANIMAL_SCENT_GLAND`; same bonuses for each with perfect kills on pristine carcasses.
- Animals which yield special loot (**Buck Antler**, **Cougar Fang**, **Ram Horn**, **Moose Antler**, **Bear Claw**, etc) now yield `2` if the carcass is perfect (regardless of kill quality).
- `A_C_BADGER_01`, `A_C_BEAR_01`, `A_C_BEAVER_01`, `A_C_BEARBLACK_01`, `A_C_BOAR_01`, `A_C_BUFFALO_01`, `A_C_BULL_01`, `A_C_COW_01`, `A_C_DUCK_01`, `A_C_GOOSECANADA_01`, `A_C_JAVELINA_01`, `A_C_OX_01`, `A_C_PHEASANT_01`, `A_C_PIG_01`, and `A_C_RACCOON_01` all now yield `PROVISION_ANIMAL_FAT`.
- Less cluttered list of (above) animals now yielding **Animal Fat**: Badgers, Grizzly Bears, Beavers, Black Bears, Wild Boar, Bison, Bulls, Cows, Ducks, Canada Geese, Collared Peccary, Ox, Pheasants, Pigs, Raccoons.
- Changed project name from `ImprovedGangLoot` to `ImprovedLoot`.
- I did my best to add comments describing what was changed within the files, along with stuff I've learned along the way modding this game.
- Made edits to `damagecleanlinessdata.meta`, changing kill quality with certain weapons and animal groups. Inspired by [Realistic Hunting Rebalance](https://www.nexusmods.com/reddeadredemption2/mods/1559). Some changes carried over. All are listed below.
- Removed `PROVISION_GAMEY_BIRD_MEAT` from `A_C_CALIFORNIACONDOR_01` and `A_C_VULTURE_01`.
- Removed `PROVISION_HERPTILE_MEAT` from `A_C_TOAD_01`.
- Removed `PROVISION_STRINGY_MEAT` and `PROVISION_BIG_GAME_MEAT` from `A_C_WOLF_01`, `A_C_WOLF_MEDIUM`, and `A_C_WOLF_SMALL`. This makes wolves unfarmable for Big Game Meat. All other big game, including Alligators, still retain their pool and are thus still the best option.
- All classes except for `PS_SMALL` can now be clean killed by **Poison Arrows** and **Poison Throwing Knives**. This opens up the Bow's use against foxes and beavers, as opposed to the old way where you could only get perfect carcasses by using the **Varmint Rifle**. This is meant to put emphasis on using poison weapons.
- `PS_MEDIUMLARGE` (pigs, sheep, goats, foxes, etc) can now be killed cleanly with **Shotgun Slugs**, all **Repeater** ammo, and all **Rifle** ammo (now including **Rifle Express**) as long as it's not a limb/body shot. This was done to make shotguns a more viable choice for hunting more various animals, rather than just lugging around a rifle all the time.
- `PS_MEDIUMLARGE` can no longer be cleanly killed by **Revolvers, Pistols**, **Regular Arrows**, or **Regular/Improved Throwing Knives** regardless of shot placement. Emphasizes using **Rifles**, **Repeaters**, **Poison Arrows**, and **Poison Throwing Knives**.
- `PS_SMALL` (small game) and `PS_MEDIUM` (varmints) can now be clean killed with **Varmint Rifle**, **Revolvers**, and **Pistols** regardless of shot placement or ammo type. This eliminates the necessity of **Small Game Arrows** for `PS_SMALL`, but they can still be used for clean kills.
- `PS_MEDIUM` (varmints) can now be killed cleanly with **Poison Arrows** and **Poison Throwing Knives** regardless of shot placement.
- `PS_EXTRA_LARGE` (massive game) can now be clean killed with **Poison Arrows** and **Poison Throwing Knives** regardless of shot placement.
- `PS_EXTRA_LARGE` can no longer be clean killed by **Rifle** or **Slug** body/limb shots.
- `PS_EXTRA_LARGE` can now be clean killed with **Repeaters**, but only on criticals.
- Removed herb loot from gangs. Creating new pools in `loot_table_itemgroups.meta` bugs out the entire loot system. Trying to find a workaround using conditionals present in `loot_reward_conditions.meta`. I could add the herbs to an existing group, but all loot pools that include those groups would also be altered.
- All gangs now drop both `LARGE_ARMS_AMMO` and `SMALL_ARMS_AMMO`. Increased **Shotgun** ammo (both `AMMO_SHOTGUN` and `AMMO_SHOTGUN_SLUG`) count for drops.
- Added chance to loot `AMMO_SHOTGUN_SLUG` in `LARGE_ARMS_AMMO` pool.
- Greatly decreased chance to loot **Fire/Dynamite Arrows** from `ARROW_AMMO` pool.
- Greatly increased chance to loot regular **Throwing Knives** from **Skinners, Lobos, and Raiders**.
- Removed chance to loot regular **Throwing Knives** from **Murfrees and Night Folk**.
- Greatly decreased chance to loot valuables. (Watches, rings, buckles, etc.)
- Decreased chance to loot provisions, but all gangs now have a chance to drop canned foods, alcohol, and snacks.
- Greatly decreased chance to loot new (unopened) alcohols. These fellas were probably drinking it before you raided them anyway.
- Tiny chance (1% each) to loot **Aged Pirate Rum, Ginseng Elixir, or Valerian Root**. Added to `ALCOHOL_ITEMS`, so this applies to all gangs and NPCs that use this pool.
- Changed **Herbivore Bait** and **Predator Bait** to **Potent Herbivore Bait** and **Potent Predator Bait**. Both were replaced in `HUNTING_ITEMS`, so all NPCs which draw from this pool have a chance to yield potent baits.
- Removed **Biscuits** and **Crackers** from snack pool. (Only **Salted Venison** and **Salted Beef** can be looted now. Might add **Offal** to either snack or canned pool.)
- Varmint pelt drop rate greatly decreased. Much rarer, but the pelts will always be perfect when looted.
- All **Varmint** pelts consolidated into one group. This means that sometimes you can loot a **Gila Monster** skin from a **Raider**, but from my point of view we'll call that rare anyway. Maybe they took a trip down to New Austin before and kept the skin as a keepsake or something. Maybe a hand-me-down from a family member.
- All varmints originally in the `ANIMAL_PELTS_SMALL_PERFECT` pool retained their place. **Snake, opossum, skunk, badger, rabbit, etc.**

### v2022.07.27

- Initial release.
- Slightly lowered drop rate of valuables.
- Herb drops matching local area. (Raiders drop Milkweed/Bulrush, Del Lobos drop Mace/Feverfew/Poppy, Skinners drop Ginseng/Currant.)
- Pelt drops matching local area. (Raiders drop Skunk/Opossum/Muskrat, Del Lobos drop GilaMonster/Iguana/Armadillo/Snake, Skinners drop all varmints native to Tall Trees.)
- All consumables are set to drop as "opened". Want sealed/new products? Buy or craft them. :D
- Raiders drop Brandy, Del Lobos drop Rum, Skinners drop Gin.
- Throwable drops retained. Knives drop 1-3. Dynamite and molotovs drop 1-2. Drop rate lowered slightly.