#include "../minisonar.h"

#include <stdio.h>

int main(int argc, const char *argv[])
{
  const char *ValidPatterns[] = {
      "AABBCCDDEEFF00",
      "CaFeBabE",
      "BeeFCaFe",
      "dEad??eF",
      "AA BB CC DD",
      "AABB CC DD",
      "A ABB CCD D",
      "A? BB ?? B* **",
      "AA**??BBC?",
      " AA**??BBC?",
      "    AA**??BBC?",
      "abba abb3f 7fff 2?   ?",
      "AABBCC\nDDEEFF??",
      0};

  const char *InvalidPatterns[] = {
      "AABBCCDDEE F",          // incomplete byte sequence
      "?? *",                  // ditto
      "AABBCCDDEEFFGG",        // Non hex
      "0xff 0x44 0xFF",        // unsupported format
      "aABBccDD Hello World!", // Unsupported characters
      0};

  for ( int i = 0; ValidPatterns[i]; ++i )
  {
    printf(
        "Testing following pattern:\n"
        "%s\n",
        ValidPatterns[i]);

    if ( !sonar_isValidPattern(ValidPatterns[i]) )
    {
      puts("Test Failed!");
      return 1;
    }
    else
    {
      puts("\tOK");
    }
  }

  puts("---------------------------------------------\n"
       "Invalid Patterns\n"
       "---------------------------------------------");

  for ( int i = 0; InvalidPatterns[i]; ++i )
  {
    printf(
        "Testing following pattern:\n"
        "%s\n",
        InvalidPatterns[i]);

    if ( sonar_isValidPattern(InvalidPatterns[i]) )
    {
      puts("Test Failed!");
      return 1;
    }
    else
    {
      puts("\tOK");
    }
  }

  puts("Test Finished!");
  return 0;
}
