#include "../minisonar.h"

#include <stdio.h>

int main(int argc, const char *argv[])
{
  const char src[]                 = "\x00\x20\x33\x7F\x66\x06\x07\xFF\x7F";
  const char mask[]                = "33 7F 66 06";
  const char maskwithwildcard[]    = "?? 7F ?? 06";
  const char maskwithnibbleUpper[] = "33 ?F 66 ?6";
  const char maskwithnibbleLower[] = "33 7? 66 06";
  const char maskwithnibble[]      = "33 7? ?6 ??";

  const char invalidmask[]                = "00 20 33 6F";
  const char largerthanrange[]            = "00 20 33 7F 66 06 07 ff 7F 00";
  const char maskwithnibbleUpperInvalid[] = "33 ?D 66 06";
  const char maskwithnibbleLowerInvalid[] = "33 A? 66 06";

  int result = 0;

  /* Tests with valid masks */

  if ( !sonar_RangedScan(src, src + (sizeof(src)), mask) )
  {
    puts("[MASK] Test failed!");
    result++;
  }

  if ( !sonar_RangedScan(src, src + (sizeof(src)), maskwithnibble) )
  {
    puts("[MASK WITH NIBBLE] Test failed!");
    result++;
  }

  if ( !sonar_RangedScan(src, src + (sizeof(src)), maskwithnibbleUpper) )
  {
    puts("[MASK WITH NIBBLE UPPER] Test failed!");
    result++;
  }

  if ( !sonar_RangedScan(src, src + (sizeof(src)), maskwithnibbleLower) )
  {
    puts("[MASK WITH NIBBLE LOWER] Test failed!");
    result++;
  }

  if ( !sonar_RangedScan(src, src + (sizeof(src)), maskwithwildcard) )
  {
    puts("[MASK WITH WILDCARD] Test failed!");
    result++;
  }

  /* Task with invalid masks */

  if ( sonar_RangedScan(src, src + (sizeof(src)), invalidmask) )
  {
    puts("[INVALID MASK] Test failed!");
    result++;
  }

  if ( sonar_RangedScan(src, src + (sizeof(src)), largerthanrange) )
  {
    puts("[LARGER THAN RANGE] Test failed!");
    result++;
  }

  if ( sonar_RangedScan(src, src + (sizeof(src)), maskwithnibbleUpperInvalid) )
  {
    puts("[MASK WITH NIBBLE UPPER INVALID] Test failed!");
    result++;
  }

  if ( sonar_RangedScan(src, src + (sizeof(src)), maskwithnibbleLowerInvalid) )
  {
    puts("[MASK WITH NIBBLE LOWER INVALID] Test failed!");
    result++;
  }

  printf("Test Finished! (Failed Tests: %d)\n", result);
  return result;
}
