#ifndef SIGSCAN_H
#define SIGSCAN_H

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

#include <stddef.h>
#include <stdint.h> // uintptr_t

/**
 * @brief Perform a pattern scan.
 * @details Scan ranged pattern scan. The "Range" aka "Sliding window".
 *
 * @param start address Start
 * @param end address End
 * @param pattern pattern to search
 * @return const void* return address of pattern matches otherwise NULL
 *
 * @example To find more than one occurance, run this again with results address
 * + 1 as a new start address until it returns NULL.
 */
const void *
sonar_RangedScan(const void *start, const void *end, const char *pattern);

#ifdef __cplusplus
}
#endif //__cplusplus

#endif // SIGSCAN_H
