/**
 * @file pattern.c
 * @author Grant Kim (you@domain.com)
 * @brief Pattern signature utilities
 * @version 0.1
 * @date 2023-05-02
 *
 * @copyright Copyright (c) 2023
 *
 */

#include "pattern.h"

#include <stdint.h> // size_t
#include <string.h>

const size_t sonar_isValidPattern(const char *pattern)
{
  // Allowed: [a-z], [A-Z], [0-9], ?, *;
  // ? and * are basically the same atm
  char  *ptr        = (char *)pattern;
  size_t len        = 0;
  size_t whitespace = 0;

  if ( !pattern )
  {
    return 0;
  }

  // Phase 1
  while ( *ptr )
  {
    if ( !((*ptr >= '0' && *ptr <= '9') || (*ptr >= 'A' && *ptr <= 'F') ||
           (*ptr >= 'a' && *ptr <= 'f') || *ptr == '*' || *ptr == '?' ||
           *ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n') )
    {
      // Invalid character detected.
      return 0;
    }

    if ( *ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n' )
    {
      whitespace++;
    }

    len++;
    ptr++;
  }

  // Phase 2
  if ( (len - whitespace) % 2 )
  {
    return 0;
  }

  return len - whitespace;
}
