/**
 * @file StarfieldKit.cpp
 * @author your name (you@domain.com)
 * @brief
 * @version 0.1
 * @date 2023-09-13
 *
 * @copyright Copyright (c) 2023
 *
 */

// Platform
#include <windows.h>

// SFSE
#include "sfse/PluginAPI.h" // PluginInfo
#include "sfse_common/sfse_version.h"

// Minisonar
#include "minisonar.h"
#include "utils.h"

// Patch

// Platforms
#ifdef _MSC_VER
#  define SFSEAPI extern "C" __declspec(dllexport)
#elif __GNUC__
#  define SFSEAPI extern "C" __attribute__((visibility("default")))
#else
#  define SFSEAPI extern "C"
#endif // _MSC_VER

// Interfaces
SFSEAPI SFSEPluginVersionData SFSEPlugin_Version = {
    SFSEPluginVersionData::kVersion,
    SFSEPluginVersionData::kAddressIndependence_Signatures,
    "StarfieldKit - Enable disk cache",
    "Archost",
    0,
    0,
    // TODO: Change MAKE_EXE_VERSION to the official "RUNTIME_VERSION"
    {MAKE_EXE_VERSION(1, 7, 29), RUNTIME_VERSION_1_7_23, 0},
    0,
    0,
    0};

int enableDiskCache()
{
  // BA2 - Generic binary reader
  const char SIGBA[] = "48 895c24 30"       // Template for overlapped IO
                       "41 BE ????????"     // mov r14d,????????
                       "44 897424 28"       // dwFlagsAndAttributes
                       "C74424 20 03000000" // OPEN_EXISTING
                       "45 33C9"            // NULL
                       "BA 00000080"        // GENERIC_READ
                       "45 8D41 01"         // dwSharedMode
                       "48 8D4C24 40"       // lpFileName
                       "FF15 ????????";     // Call (6C04E600)

  // ESM/ESP reader. Will be memory mapped.
  const char SIGESP[] = "33DB"             // xor ebx, ebx
                        "41 833E 00"       // cmp
                        "BF 00000008"      // FILE_FLAG_SEQUENTIAL_SCAN
                        "7D 07"            // jge
                        "BF 00000068"      // 0x68000000
                        "EB 0B"            // jmp
                        "45 850E"          // TEST
                        "B8 ????????"      // mov eax, ????????
                        "0F45F8"           // cmovne (param)
                        "48 836424 30 00 " // hTemplateFile
                        "45 33C9"          // lpSecurityAttributes
                        "897C24 28 "       // dwFlagsAndAttributes
                        "44 8BC3"          // dwSharedMode
                        "8BD6"             // dwDesiredAccess
                        "44 895424 20"     // dwCreationDisposition
                        "49 8BCF"          // lpFileName
                        "FF15 ????????";   // Call (1F2FD500)

  // TODO: Use .text section size for the scanning range.
  uintptr_t start, end;
  start = getbaseaddr() + 0x600; // Skip PE header
  end   = start + 0x3ea7200;     // .text size

  uintptr_t addr = (uintptr_t)sonar_RangedScan(
      (const void *)start, (const void *)end, SIGBA);

  DWORD param = 0;

  if ( addr )
  {
    param = FILE_FLAG_OVERLAPPED | FILE_FLAG_RANDOM_ACCESS;
    printf("%llx found\n", addr);

    // Casting hell
    writeData(
        (void *)((uintptr_t)sonar_RangedScan(
                     (void *)addr, (void *)(addr + 0xF), "41 BE ????????") +
                 0x2),
        &param,
        sizeof(param));
  }
  else
  {
    (void)0;
    puts("Binary reader patch failed!");
  }

  addr = 0;

  // ESM/ESP/ESL record reader
  addr = (uintptr_t)sonar_RangedScan(
      (const void *)start, (const void *)end, SIGESP);

  if ( addr )
  {
    param = FILE_FLAG_RANDOM_ACCESS;
    addr  = (uintptr_t)sonar_RangedScan(
        (void *)addr, (void *)(addr + 0xF), "00 BF ???????? 7D 07");

    if ( addr )
    {
      // puts("0!");
    }

    addr = (uintptr_t)writeData(((void *)(addr + 0x2)), &param, sizeof(param));

    param = FILE_FLAG_OVERLAPPED | FILE_FLAG_RANDOM_ACCESS;
    addr  = (uintptr_t)sonar_RangedScan(
        (void *)addr, (void *)(addr + 0xF), "7D 07 BF ???????? EB 0B");

    if ( addr )
    {
      // puts("1!");
    }

    addr = (uintptr_t)writeData((void *)(addr + 0x3), &param, sizeof(param));

    addr += sizeof(param);

    param = FILE_FLAG_RANDOM_ACCESS;
    addr  = (uintptr_t)sonar_RangedScan(
        (void *)addr, (void *)(addr + 0xF), "EB 0B 45 850E");
    if ( addr )
    {
      // puts("2!");
    }

    addr = (uintptr_t)writeData((void *)(addr + 0x6), &param, sizeof(param));
  }
  else
  {
    (void)0;
    // puts("Record file reader patch failed");
  }

  return 0;
}

DWORD WINAPI enableDiskCache_fn(void *)
{
  return (DWORD)enableDiskCache();
}

SFSEAPI bool SFSEPlugin_Load(const SFSEInterface *sfse)
{
  bool result = false;

  return !enableDiskCache();
}

// Win32
BOOL WINAPI
DllMain(HINSTANCE hInstDLL, DWORD fdwReason, LPVOID toolazytoattachadebugger)
{
  if ( !getthisaddr() )
  {
    setThisAddr((uintptr_t)hInstDLL);
  }

  switch ( fdwReason )
  {
  case DLL_PROCESS_ATTACH:
    // FILE *stdof;
    // AllocConsole();
    // freopen_s(&stdof, "CONOUT$", "w", stdout);
    // puts("Hello!");
    // printf(
    //     "Base address: %p (%d)\n"
    //     "This address: %p (%llx)\n",
    //     (void *)getbaseaddr(),
    //     0,
    //     (void *)getthisaddr(),
    //     getthisaddr() - getbaseaddr());
    CreateThread(NULL, 0, enableDiskCache_fn, NULL, 0, NULL);
  }
  return TRUE;
}
