#include "DKUtil/Hook.hpp"
#include "main.h"

DLLEXPORT constinit auto SFSEPlugin_Version = []() noexcept {
	SFSE::PluginVersionData data{};

	data.PluginVersion(Plugin::Version);
	data.PluginName(Plugin::NAME);
	data.AuthorName(Plugin::AUTHOR);
	data.UsesSigScanning(true);
	//data.UsesAddressLibrary(true);
	data.HasNoStructUse(true);
	//data.IsLayoutDependent(true);
	data.CompatibleVersions({ SFSE::RUNTIME_LATEST });

	return data;
}();


uint32_t playerRefID = 0x14;
uint32_t playerBaseID = 0x7;
float g_uMaxDriftPercentage = 15.0f/50.0f;
float g_uFemalePercentage = 93.0f / 100.0f;

float (*CurveNormalizer)(unsigned int, unsigned int);
unsigned int (*NumberManipulatorFunction)(unsigned int);
template<class T>
struct TESQueriedPtr
{
	T* _ptr = {};
	bool         queried = false;
};
namespace HRandomPtrs
{
	static TESQueriedPtr<RE::BGSKeyword> ActorTypeHumanKeyword;
	bool (*HasKeyword)(RE::TESObjectREFR*, RE::BGSKeyword*) = NULL;
	RE::TESForm* (*LookupByEditorID)(const char*) = NULL;

	uintptr_t                            g_moduleBase;
}
class hk_HeightRandomizer
{
	static float HookHandler(RE::TESObjectREFR* a_refr, float a_scale)
	{
		// do something with it
		float returnScale = a_scale;
		auto objectBase = a_refr->GetBaseObject();
		if (objectBase->GetFormType() == RE::FormType::kNPC_) [[unlikely]]{ 
			float           refScale = float(a_refr->scale) / 100;
			float           baseScale = a_scale / refScale;
			auto actorBase = reinterpret_cast<RE::TESActorBase*>(objectBase);
			if (!(HRandomPtrs::ActorTypeHumanKeyword.queried)) [[unlikely]] {
				HRandomPtrs::ActorTypeHumanKeyword.queried = true;
				if (auto humanTypeKeywordForm = HRandomPtrs::LookupByEditorID("ActorTypeHuman")) {
					if (humanTypeKeywordForm->GetFormType() == RE::FormType::kKYWD) {
						HRandomPtrs::ActorTypeHumanKeyword._ptr = reinterpret_cast<RE::BGSKeyword*>(humanTypeKeywordForm);
					}
				}
			}

			RE::BGSKeyword* humanTypeKeyword = HRandomPtrs::ActorTypeHumanKeyword._ptr;
			if (humanTypeKeyword && HRandomPtrs::HasKeyword(a_refr, humanTypeKeyword)) {

				if (a_refr->formID != playerRefID && actorBase->formID != playerBaseID) [[likely]] {
					if ((fabs(returnScale - 1) < 0.009) && CurveNormalizer && NumberManipulatorFunction) {
						returnScale += (CurveNormalizer(NumberManipulatorFunction(a_refr->formID & 0xFFFFFF), 101) * (g_uMaxDriftPercentage));
					}
					if (actorBase->actorData.actorBaseFlags.underlying() & 1) {
						returnScale *= g_uFemalePercentage;

					}
					
				}
			}
		}
		return returnScale;
	}

	struct Prolog : Xbyak::CodeGenerator
	{
		Prolog()
		{
			mov(rcx, rbx);
			vmovaps(xmm0, xmm1);
			vmovaps(xmm1, xmm6);
			vmovaps(xmm6, xmm0);
		}
	};
	struct Epilog : Xbyak::CodeGenerator
	{
		Epilog()
		{
			vmovaps(xmm1, xmm6);
			vmovaps(xmm6, xmm0);
		}
	};

public:
	static void Install()
	{
		auto   funcAddr = REL::Offset{ 0x1A0826B };
		Prolog prolog = {};
		prolog.ready();
		Epilog epilog = {};
		epilog.ready();
		auto handle = DKUtil::Hook::AddCaveHook(
			funcAddr.address(),
			{ 0, 5 },
			FUNC_INFO(HookHandler),
			&prolog,
			&epilog, DKUtil::Hook::HookFlag::kRestoreAfterEpilog);

		handle->Enable();
	}
};
/**
// for preload plugins
void SFSEPlugin_Preload(SFSE::LoadInterface* a_sfse);
/**/
namespace
{
	void MessageCallback(SFSE::MessagingInterface::Message* a_msg) noexcept
	{
		switch (a_msg->type) {
		case SFSE::MessagingInterface::kPostLoad:
			{
				hk_HeightRandomizer::Install();
				break;
			}
		default:
			break;
		}
	}
}


namespace IniSettings
{
	bool ReadIniSettings() {
		char iniDir[MAX_PATH];
		GetModuleFileNameA(GetModuleHandle(NULL), iniDir, MAX_PATH);
		auto heightAlgo = unsigned int(GetPrivateProfileIntA("Main", "uHeightAlgorithm", 1, iniDir));
		if (heightAlgo == 0) {
			return false;
		}
		strcpy((char*)(strrchr(iniDir, '\\') + 1), "Data\\SFSE\\Plugins\\HeightRandomizer.ini");
		unsigned int intArgtmp;
		intArgtmp = GetPrivateProfileIntA("Main", "uMaxDriftPercentage", 15, iniDir);
		if (intArgtmp >= 99) {
			intArgtmp = 99;
		}
		g_uMaxDriftPercentage = float(intArgtmp) / 50;
		g_uFemalePercentage = ((float)GetPrivateProfileIntA("Main", "uFemalePercentage", 92, iniDir)) / 100;
		if (!GetPrivateProfileIntA("Main", "bUseTrueRandom", 0, iniDir)) {
			NumberManipulatorFunction = HeightRandomizer::FNV1aHasher;
		} else {
			NumberManipulatorFunction = HeightRandomizer::RandomizerDefault;
		}

		switch (unsigned int(GetPrivateProfileIntA("Main", "uHeightAlgorithm", 1, iniDir)) % 3) {
		case 1:
			CurveNormalizer = HeightRandomizer::CurveNormalizerRealistic;
			break;
		case 2:
			CurveNormalizer = HeightRandomizer::CurveNormalizerHighVariance;
			break;
		default:
			CurveNormalizer = HeightRandomizer::CurveNormalizerSemilinear;
		}

		if (g_uFemalePercentage <= 0.1) {
			g_uFemalePercentage = 0.1;
		}
		return true;

	}
}



DLLEXPORT bool SFSEAPI SFSEPlugin_Load(const SFSE::LoadInterface* a_sfse)
{
#ifndef NDEBUG
	while (!IsDebuggerPresent()) {
		Sleep(100);
	}
#endif
	if (!(IniSettings::ReadIniSettings()))
	{
		return true;
	}
	SFSE::Init(a_sfse, false);
	HRandomPtrs::ActorTypeHumanKeyword.queried = false;
	HRandomPtrs::ActorTypeHumanKeyword._ptr = nullptr;
	HRandomPtrs::g_moduleBase = reinterpret_cast<uintptr_t>(GetModuleHandleA(NULL));
	DKUtil::Logger::Init(Plugin::NAME, std::to_string(Plugin::Version));

	INFO("{} v{} loaded", Plugin::NAME, Plugin::Version);
	HRandomPtrs::HasKeyword = reinterpret_cast<bool (*)(RE::TESObjectREFR*, RE::BGSKeyword*)>(HRandomPtrs::g_moduleBase + 0x0139EDB8);
	HRandomPtrs::LookupByEditorID = reinterpret_cast<RE::TESForm* (*)(const char*)>(HRandomPtrs::g_moduleBase + 0x014D7F0C);

	
	// do stuff
	SFSE::AllocTrampoline(1 << 10);

	SFSE::GetMessagingInterface()->RegisterListener(MessageCallback);

	return true;
}
