@echo off
setlocal enabledelayedexpansion

TITLE Starfield Hotkeys Merge Utility
echo ---- Starfield Hotkeys Merge Utility ----
echo.

REM Find the Starfield installation directory.
echo Searching for Starfield installation directory...
echo.
for /f "usebackq tokens=*" %%a ^
in (`powershell.exe -NoProfile -Command "Get-ItemProperty 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\*' | Where-Object {$_.DisplayName -eq 'Starfield'} | Select -ExpandProperty InstallLocation"`) ^
do (set starfielddir=%%a)

echo Starfield installation directory: !starfielddir!
echo.

if not exist "!starfielddir!\Starfield.exe" (
    echo Failed to automatically locate Starfield installation directory.
    echo.
    set /p "starfielddir=Enter installation directory manually (you can drag and drop into this window): "

    if not exist "!starfielddir!\Starfield.exe" (
        echo ERROR - Could not find Starfield.exe.
        echo Check if the installation directory is correct.
        echo.
        goto FAIL
    )
)

set "hotkeysini=!starfielddir!\Hotkeys\Hotkeys.ini"
set "file=Hotkeys\Hotkeys.ini"

if not exist "%hotkeysini%" (
    echo Could not find Hotkeys.ini in Starfield directory.
    goto FAIL
)

if not exist "Hotkeys\Hotkeys.ini" (
    echo Could not find Hotkeys.ini in this folder.
    goto FAIL
)

echo Source file: %file%
echo Target file: %hotkeysini%
echo.
set c=Y
set /P c=Begin merge? [Enter/Y/N] 
echo.
if /I "%c%" NEQ "Y" (
    goto CANCEL
)

REM Remove the [Hotkeys] line from custom Hotkeys.ini to prepare search string file for findstr /G.
findstr /v /i "Hotkeys]" "%file%" >"%file%.tmp"

REM Remove any new entries that are *already* in the file.
findstr /v /i /G:"%file%.tmp" "%hotkeysini%" >"%hotkeysini%.tmp"

REM Append contents of custom Hotkeys.ini into master Hotkeys.ini.

REM Check if the last line in the master file is blank (or not) and add a newline if it's not.
findstr /n "^" "%hotkeysini%.tmp" >"%hotkeysini%.tmp2"

for /f "usebackq tokens=1* delims=:" %%a in ("%hotkeysini%.tmp2") do (
    set lastLine=%%b
)
if defined lastLine (
    >>"%hotkeysini%.tmp" echo/
    >>"%hotkeysini%.tmp" echo/
)
copy /B "%hotkeysini%.tmp" + "%file%.tmp" "%hotkeysini%" >nul

del "%hotkeysini%.tmp"
del "%hotkeysini%.tmp2"
del "%file%.tmp"

:SUCCESS
echo Merge successful.
echo.
set c=N
set /P c=Do you want to open Hotkeys.ini? [Y/N] 
echo.
if /I "%c%" EQU "Y" (
    start "" "%hotkeysini%"
)
pause
goto:EOF

:FAIL
echo Merge failed.
echo.
pause
goto:EOF

:CANCEL
echo Merge cancelled.
echo.
pause
goto:EOF