@echo off
setlocal enabledelayedexpansion

TITLE Starfield Hotkeys Uninstaller
echo ---- Starfield Hotkeys Uninstaller by reg2k ----
echo.

REM Find the user's My Documents directory. Directory name may be localized.
for /f "usebackq tokens=*" %%a ^
in (`powershell.exe -NoProfile -Command "[Environment]::GetFolderPath('MyDocuments')"`) ^
do (set mydocuments=%%a)

REM Find the Starfield installation directory.
echo Searching for Starfield installation directory...
echo.
for /f "usebackq tokens=*" %%a ^
in (`powershell.exe -NoProfile -Command "Get-ItemProperty 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\*' | Where-Object {$_.DisplayName -eq 'Starfield'} | Select -ExpandProperty InstallLocation"`) ^
do (set starfielddir=%%a)

echo Starfield installation directory: %starfielddir%
echo.

if not exist "%starfielddir%\Starfield.exe" (
    echo Failed to automatically locate Starfield installation directory.
    echo.
    set /p "starfielddir=Enter installation directory manually (you can drag and drop into this window): "

    if not exist "!starfielddir!\Starfield.exe" (
        echo ERROR - Could not find Starfield.exe.
        echo Check if the installation directory is correct.
        echo.
        goto CANCEL
    )
)

REM Set the ini.
set "file=%mydocuments%\My Games\Starfield\StarfieldCustom.ini"

echo Updating INI at %file%...
echo.

set c=Y
set /P c=Continue? [Enter/Y/N] 
echo.
if /I "%c%" NEQ "Y" (
    goto CANCEL
)

if exist "%file%" (
    findstr /v /i "bUseConsoleHotkeys= sConsoleINI=" "%file%" >"%file%.tmp"
    for /f "usebackq tokens=1 delims=:" %%a in (`findstr /n /i "Menu]" "%file%.tmp"`) do (
        set foundLine=%%a
    )
    REM set /a foundLine -= 1
    if defined foundLine (
        set for_parameters="usebackq skip=!foundLine! delims="
        call :CheckForSectionEntries
        
        set shouldRemoveHeader=F
        if "x!lineAfterSectionHeader:~0,1!"=="x[" (
            REM Next line is another section header.
            set shouldRemoveHeader=T
        )
        if not defined lineAfterSectionHeader (
            REM Next line is empty.
            set shouldRemoveHeader=T
        )
        
        if "!shouldRemoveHeader!"=="T" (
            findstr /v /i "Menu]" "%file%.tmp" >"%file%"
            del "%file%.tmp"
            echo Removing empty section...
            echo.
        ) else (
            move /y "%file%.tmp" "%file%" >nul
        )
    ) else (
        echo Nothing to change.
        del "%file%.tmp"
        echo.
    )
    
    if exist "%starfielddir%\Hotkeys" (
        echo Do you want to delete your hotkey settings file?
        REM Delete hotkeys
        rmdir "%starfielddir%\Hotkeys" /s
        REM Delete the junction (no prompt, ignore output)
        rmdir "%mydocuments%\My Games\Starfield\Hotkeys" 2> NUL
        echo.
    )
    
    echo Hotkeys disabled.
    echo.
    
) else (
    echo StarfieldCustom.ini couldn't be found.
    echo.
)
goto END

:CheckForSectionEntries
for /f %for_parameters% %%b in ("%file%.tmp") do (
    if not defined lineAfterSectionHeader set lineAfterSectionHeader=%%b
)
goto :eof

:CANCEL
echo Uninstallation cancelled.
echo.
pause
goto:EOF

:END
pause
goto :eof