@echo off
setlocal enabledelayedexpansion

TITLE Starfield Hotkeys Installer
echo ---- Starfield Hotkeys Installer by reg2k ----
echo.

REM Find the user's My Documents directory. Directory name may be localized.
for /f "usebackq tokens=*" %%a ^
in (`powershell.exe -NoProfile -Command "[Environment]::GetFolderPath('MyDocuments')"`) ^
do (set mydocuments=%%a)

REM Find the Starfield installation directory.
echo Searching for Starfield installation directory...
echo.
for /f "usebackq tokens=*" %%a ^
in (`powershell.exe -NoProfile -Command "Get-ItemProperty 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\*' | Where-Object {$_.DisplayName -eq 'Starfield'} | Select -ExpandProperty InstallLocation"`) ^
do (set starfielddir=%%a)

echo Starfield installation directory: %starfielddir%
echo.

if not exist "%starfielddir%\Starfield.exe" (
    echo Failed to automatically locate Starfield installation directory.
    echo.
    set /p "starfielddir=Enter installation directory manually (you can drag and drop into this window): "

    if not exist "!starfielddir!\Starfield.exe" (
        echo ERROR - Could not find Starfield.exe.
        echo Check if the installation directory is correct.
        echo.
        goto FAIL
    )
)

REM Set the ini.
set "file=%mydocuments%\My Games\Starfield\StarfieldCustom.ini"

echo Updating INI at %file%...
echo.

set c=Y
set /P c=Continue? [Enter/Y/N] 
echo.
if /I "%c%" NEQ "Y" (
    goto CANCEL
)

if not exist "%file%" (
    type NUL > "%file%"
)

if exist "%file%" (
    findstr /v /i "bUseConsoleHotkeys= sConsoleINI=" "%file%" >"%file%.tmp"

    set area=[Menu]
    set key=bUseConsoleHotkeys
    set currarea=
    for /f "usebackq delims=" %%a in ("%file%.tmp") do (
        set ln=%%a
        >>"%file%.tmp2" echo !ln!
        
        if "x!ln:~0,1!"=="x[" (
            set currarea=!ln!
            if "x!area!"=="x!currarea!" (
                >>"%file%.tmp2" echo/bUseConsoleHotkeys=1
                >>"%file%.tmp2" echo/sConsoleINI=Hotkeys\Hotkeys.ini
                set foundHeader=1
                echo Existing section header found. Adding to section...
                echo.
            )
        ) else (
            for /f "tokens=1,2 delims==" %%b in ("!ln!") do (
                set currkey=%%b
                set currval=%%c
            )
        )
    )
    
    if not defined foundHeader (
        >>"%file%.tmp2" echo/[Menu]
        >>"%file%.tmp2" echo/bUseConsoleHotkeys=1
        >>"%file%.tmp2" echo/sConsoleINI=Hotkeys\Hotkeys.ini
        echo New INI section created.
        echo.
    )
    
    move /y "%file%.tmp2" "%file%" >nul
    del "%file%.tmp"
    
    echo Copying files...
    xcopy "Hotkeys.ini" "%starfielddir%\Hotkeys\" /Q

    echo.
    echo Creating junction...
    mklink /J "%mydocuments%\My Games\Starfield\Hotkeys" "%starfielddir%\Hotkeys\" 2> NUL
    
    echo.
    echo Hotkeys successfully enabled.
    echo.
    
) else (
    echo StarfieldCustom.ini couldn't be found. Install failed.
    echo.
)

:SUCCESS
pause
goto:EOF

:CANCEL
echo Installation cancelled.
echo.
pause
goto:EOF

:FAIL
echo Installation failed.
echo.
pause