ScriptName JDB_ShipManager

; Had to reimplement it like this sice Game.IsPlayerSpaceshipOwner does not seem to work
bool Function _IsPlayerSpaceshipOwner(SpaceshipReference ship) global
  SpaceshipReference[] ownedShips = Game.GetPlayerOwnedShips()
  int i = 0
  while (i < ownedShips.length)
    if (ownedShips[i] == ship)
      return true
    endIf
    i += 1
  endWhile
  return false
EndFunction

SpaceshipReference Function _GetHomeShip () global
  SpaceshipReference theHomeShip = Game.GetPlayerHomeSpaceShip()
  if (theHomeShip == None)
    Debug.Notification("You do not have a home ship")
    return None
  endIf

  return theHomeShip
EndFunction

SpaceshipReference Function _GetCurrentShip () global
  Actor player = Game.GetPlayer()
  SpaceshipReference currentShip = player.GetCurrentShipRef()
  if (currentShip == None)
    Debug.Notification("You are not inside a ship")
    return None
  endIf
  return currentShip
EndFunction

SpaceshipReference Function _GetCurrentOwnedShip () global
  SpaceshipReference currentShip = _GetCurrentShip()
  if (currentShip == None)
    return None
  endIf

  bool isOwned = _IsPlayerSpaceshipOwner(currentShip)

  if (!isOwned)
    Debug.Notification("You do not own this ship")
    return None
  endIf

  return currentShip
EndFunction

SpaceshipReference Function _GetSittingShip () global
  SpaceshipReference currentShip = _GetCurrentShip()
  if (currentShip == None)
    return None
  endIf

  Actor player = Game.GetPlayer()

  Keyword SpaceshipCockpitPilotSeat = Game.GetForm(0x00005627) as Keyword

  ObjectReference playerFurniture = player.GetFurnitureUsing()
  if (playerFurniture == None || !playerFurniture.HasKeyword(SpaceshipCockpitPilotSeat))
    Debug.Notification("You must be in the pilot seat")
    return None
  endIf

  return currentShip
EndFunction

Function TakeOverShip () global
  SpaceshipReference currentShip = _GetSittingShip()
  if (currentShip != None)
    if (!_IsPlayerSpaceshipOwner(currentShip))
      Game.AddPlayerOwnedShip(currentShip)
      Debug.Notification("This ship has been added to your fleet")
    else
      Debug.Notification("You already own this ship")
    endIf
  endIf
EndFunction

Function OpenCurrentShipInventory () global
  Actor player = Game.GetPlayer()
  SpaceshipReference currentShip = _GetCurrentOwnedShip()
  if (currentShip != None)
    currentShip.OpenInventory()
  endIf
EndFunction

Function OpenHomeShipInventory () global
  SpaceshipReference theHomeShip = _GetHomeShip()
  if (theHomeShip != None)
    theHomeShip.OpenInventory()
  endIf
EndFunction

string Function _GetConsoleName (int systemIndex) global
  if (systemIndex == 0)
    return "1"
  elseIf (systemIndex == 1)
    return "2"
  elseIf (systemIndex == 2)
    return "3"
  elseIf (systemIndex == 3)
    return "eng"
  elseIf (systemIndex == 4)
    return "shi"
  elseIf (systemIndex == 5)
    return "grav"
  endIf
EndFunction

int Function _GetSystemIndex (string systemName) global
  if (systemName == "none" || systemName == None || systemName == "")
    return -1
  elseIf (systemName == "weapon1")
    return 0
  elseIf (systemName == "weapon2")
    return 1
  elseIf (systemName == "weapon3")
    return 2
  elseIf (systemName == "engine")
    return 3
  elseIf (systemName == "shield")
    return 4
  elseIf (systemName == "grav")
    return 5
  endIf
EndFunction

; Unfortunately we have to use (dynamic) console commands here because the
; SetPower / GetPower commands are implemented poorly.
; Here are some of the issues I have encountered:
; Issue 1: The weapons indices do not necessarily match the UI.
;          They probably go by the order you added the weapons to the ship.
; Issue 2: Unlike the console command, every single call updates the UI,
;           and it's quite slow, so it flickers quite a bit when you need to
;           change a bunch of values.
; Issue 3: GetPower sometimes returns the wrong value for non-existing
;          weapon slots.
; Unless SFSE fixes those this is currently the best option.
Function PowerShipSystems (string p0 = "none", string p1 = "none", string p2 = "none", string p3 = "none", string p4 = "none", string p5 = "none") global
  SpaceshipReference currentShip = _GetSittingShip()
  if (currentShip == None)
    return
  endIf

  string shipHEX = Utility.IntToHex(currentShip.GetFormID())

  int[] powerPriorities = new int[6]

  powerPriorities[0] = _GetSystemIndex(p0)
  powerPriorities[1] = _GetSystemIndex(p1)
  powerPriorities[2] = _GetSystemIndex(p2)
  powerPriorities[3] = _GetSystemIndex(p3)
  powerPriorities[4] = _GetSystemIndex(p4)
  powerPriorities[5] = _GetSystemIndex(p5)

  Debug.ExecuteConsole(p0 + " " + p1 + " " + p2 + " " + p3 + " " + p4 + " " + p5)

  int i = 0
  bool anyValue = false

  while (i <= 5)
    if (powerPriorities[i] > -1)
      anyValue = true
      i = 6 ;break
    else
      i += 1
    endIf
  endWhile

  string RemoveCommand = ""

  i = 0

  while (i <= 5)
    if (i > 0)
      RemoveCommand += "; "
    endIf
    RemoveCommand += shipHEX + ".RemovePower " + _GetConsoleName(i) + " " + "12"
    i += 1
  endWhile

  if (!anyValue)
    Debug.ExecuteConsole(RemoveCommand)
    return
  endIf

  string AddCommand = ""

  i = 0

  while (i <= 5)
    int powerPriority = powerPriorities[i]
    if (powerPriority > -1)
      if (i > 0)
        AddCommand += "; "
      endIf
      AddCommand += shipHEX + ".AddPower " + _GetConsoleName(powerPriorities[i]) + " " + "12"
    endIf
    i += 1
  endWhile

  Debug.ExecuteConsole(RemoveCommand + "; " + AddCommand)
EndFunction