ScriptName SummonShipServicesScriptA Hidden

Function CallShipServices(Int BuildShopVar) Global
	; define variables
	Actor Player = Game.GetForm(0x14) as Actor
	Location PlayerLoc = Player.GetCurrentLocation()
	ActorBase VendorBase = Game.GetForm(0x206704) as ActorBase
	; place vendor
	DebugTrace("Call PlaceActorAtMe >> " + Player as String + " / " + PlayerLoc as String + " / " + VendorBase as String)
	Actor Vendor = Player.PlaceActorAtMe(VendorBase, 0, PlayerLoc, False, False, False, None, True)
	; attach script b
	String VendorID = Utility.IntToHex(Vendor.GetFormID())
	String ConsoleCommand = VendorID + ".AttachPapyrusScript SummonShipServicesScriptB"
	DebugTrace("Call ExecuteConsole >> " + ConsoleCommand)
	Debug.ExecuteConsole(ConsoleCommand)
	; get and remember credits
	MiscObject Credits = Game.GetForm(0xF) as MiscObject
	ObjectReference VendorChest = Game.GetForm(0x12DF03) as ObjectReference
	Int OldCreditsCount = VendorChest.GetItemCount(Credits)
	DebugTrace("Info: Old credits amount >> " + OldCreditsCount as String + " / Vendor mode >> " + BuildShopVar as String)
	; set credits and mode
	VendorChest.RemoveItem(Credits, OldCreditsCount, True, None)
	VendorChest.AddItem(Credits, 1000000, True)
	While (Vendor as SummonShipServicesScriptB == None)
		Utility.Wait(0.1)
		DebugTrace("Info: Waiting for script B launch")
	EndWhile
	(Vendor as SummonShipServicesScriptB).BuildShop = BuildShopVar as Bool
	; wait and delete
	Utility.Wait(10.0)
	DebugTrace("Call Disable/Delete >> " + Vendor)
	Vendor.Disable(False)
	Vendor.Delete()
	; restore credits
	Int NewCreditsCount = VendorChest.GetItemCount(Credits)
	DebugTrace("Info: New credits amount >> " + NewCreditsCount as String)
	VendorChest.RemoveItem(Credits, NewCreditsCount, True, None)
	VendorChest.AddItem(Credits, OldCreditsCount, True)
EndFunction

Function DebugTrace(String sText) Global
	Debug.Trace("[SummonShipServicesScript] " + sText, 1)
EndFunction
