ScriptName RichAuthorityScript Extends Actor Hidden

; filled on game load
MiscObject Property Credits Auto
Int Property HalfCreditsAmount Auto Hidden
ObjectReference[] Property AuthorityChests Auto Hidden
Int[] Property AuthorityTraders Auto Hidden
; menu names
String Property DialogueMenuName = "DialogueMenu" Auto Hidden
String Property BarterMenuName = "BarterMenu" Auto Hidden
; temp data
Actor Property CurrentDialogueTarget = None Auto Hidden
Int Property CurrentDialogueTargetID = 0 Auto Hidden
Int Property CurrentDialogueIndex = -1 Auto Hidden

Function AttachToActor(Actor NewActor) Global
	; attach only once
	If (NewActor == Game.GetForm(20) as Actor) && (NewActor as RichAuthorityScript == None)
		DebugTrace("AttachToActor > Player has no script / ExecuteConsole")
		Debug.ExecuteConsole("Player.AttachPapyrusScript RichAuthorityScript")
	Else
		DebugTrace("AttachToActor > Player has script / Perform nothing")
	EndIf
EndFunction

Event OnInit()
	DebugTrace("OnInit > Maintenance")
	Maintenance()
EndEvent

Event OnPlayerLoadGame()
	DebugTrace("OnPlayerLoadGame > Maintenance")
	Maintenance()
EndEvent

Function Maintenance()
	; re-register menus
	Self.UnregisterForMenuOpenCloseEvent(DialogueMenuName)
	Self.UnregisterForMenuOpenCloseEvent(BarterMenuName)
	Self.RegisterForMenuOpenCloseEvent(DialogueMenuName)
	Self.RegisterForMenuOpenCloseEvent(BarterMenuName)
	; set credits
	Credits = Game.GetForm(15) as MiscObject
	HalfCreditsAmount = 500000
	; register chests
	AuthorityChests = New ObjectReference[6]
	AuthorityChests[0] = Game.GetForm(1172391) as ObjectReference ; The Den
	AuthorityChests[1] = Game.GetForm(2286907) as ObjectReference ; The Well
	AuthorityChests[2] = Game.GetForm(646049) as ObjectReference  ; Cydonia
	AuthorityChests[3] = Game.GetForm(1421575) as ObjectReference ; Neon
	AuthorityChests[4] = Game.GetForm(1767119) as ObjectReference ; Akila
	AuthorityChests[5] = Game.GetForm(1260538) as ObjectReference ; The Key
	; register traders
	AuthorityTraders = New Int[6]
	AuthorityTraders[0] = 1172397 ; The Den
	AuthorityTraders[1] = 79794   ; The Well
	AuthorityTraders[2] = 646050  ; Cydonia
	AuthorityTraders[3] = 1135682 ; Neon
	AuthorityTraders[4] = 2180740 ; Akila
	AuthorityTraders[5] = 86940   ; The Key
EndFunction

Event OnMenuOpenCloseEvent(String MenuName, Bool Opening)
	If (MenuName == DialogueMenuName)
		If (Opening)
			CurrentDialogueTarget = Self.GetDialogueTarget()
			CurrentDialogueTargetID = CurrentDialogueTarget.GetFormID()
			CurrentDialogueIndex = AuthorityTraders.Find(CurrentDialogueTargetID)
			If (CurrentDialogueIndex >= 0)
				ProcessTrader(CurrentDialogueTarget, True)
				ProcessChest(AuthorityChests[CurrentDialogueIndex], True, True)
			EndIf
		Else
			If (CurrentDialogueIndex >= 0)
				ProcessTrader(CurrentDialogueTarget, False)
			EndIf
			CurrentDialogueTarget = None
			CurrentDialogueTargetID = 0
			CurrentDialogueIndex = -1
		EndIf
	ElseIf (MenuName == BarterMenuName)
		If (CurrentDialogueIndex >= 0)
			ProcessChest(AuthorityChests[CurrentDialogueIndex], Opening, False)
		EndIf
	EndIf
EndEvent

Function ProcessTrader(Actor Trader, Bool Opening)
	If (Trader as Bool)
		DebugTrace("ProcessTrader > " + Trader.GetFormID() as String + " / " + Opening as String)
		If (Opening)
			; process trader > open
			Trader.RemoveItem(Credits, Trader.GetItemCount(Credits), True, None)
			Trader.AddItem(Credits, HalfCreditsAmount, True)
			DebugTrace("Milestone Trader A")
		Else
			; process trader > close
			Utility.Wait(1.0)
			Trader.RemoveItem(Credits, Trader.GetItemCount(Credits), True, None)
			DebugTrace("Milestone Trader B")
		EndIf
	EndIf
EndFunction

Function ProcessChest(ObjectReference Chest, Bool Opening, Bool FullReset)
	If (Chest as Bool)
		DebugTrace("ProcessChest > " + Chest.GetFormID() as String + " / " + Opening as String + " / " + FullReset as String)
		If (Opening)
			; process reset
			If (FullReset)
				Chest.RemoveAllItems(None, False, False)
				Chest.Reset(Chest)
			Else
				Chest.RemoveItem(Credits, Chest.GetItemCount(Credits), True, None)
				Chest.AddItem(Credits, HalfCreditsAmount, True)
			EndIf
			DebugTrace("Milestone Chest A")
		Else
			; process merged
			Chest.RemoveAllItems(None, False, False)
			Chest.Reset(Chest)
			Chest.RemoveItem(Credits, Chest.GetItemCount(Credits), True, None)
			Chest.AddItem(Credits, HalfCreditsAmount, True)
			DebugTrace("Milestone Chest B")
		EndIf
	EndIf
EndFunction

Function DebugTrace(String Text) Global
	Debug.Trace("[RichAuthorityScript] " + Text, 1)
EndFunction
