ScriptName RichAuthorityScriptA Hidden

Function CallRichAuthority() Global
	; define records
	Actor Player = Game.GetForm(0x14) as Actor
	Location PlayerLoc = Player.GetCurrentLocation()
	ActorBase VendorBase = Game.GetForm(0x11E3AE) as ActorBase
	; place vendor
	RichAuthorityScript.DebugTrace("Call PlaceActorAtMe >> " + Player as String + " / " + PlayerLoc as String + " / " + VendorBase as String)
	Actor Vendor = Player.PlaceActorAtMe(VendorBase, 0, PlayerLoc, False, False, False, None, True)
	; attach script b
	String VendorID = Utility.IntToHex(Vendor.GetFormID())
	String ConsoleCommand = VendorID + ".AttachPapyrusScript RichAuthorityScriptB"
	RichAuthorityScript.DebugTrace("Call ExecuteConsole >> " + ConsoleCommand)
	Debug.ExecuteConsole(ConsoleCommand)
	; set chest property
	While (Vendor as RichAuthorityScriptB == None)
		Utility.Wait(0.1)
		RichAuthorityScript.DebugTrace("Info: Waiting for script B launch")
	EndWhile
	ObjectReference VendorChest = Game.GetForm(0x11E3A7) as ObjectReference
	(Vendor as RichAuthorityScriptB).TraderChest = VendorChest
	; wait and delete
	Utility.Wait(10.0)
	RichAuthorityScript.DebugTrace("Call Disable/Delete >> " + Vendor)
	Vendor.Disable(False)
	Vendor.Delete()
EndFunction
