ScriptName RichAuthorityScriptB Extends Actor

ObjectReference Property TraderChest Auto

Event OnInit()
	RichAuthorityScript.DebugTrace("Info: Actor was summoned >> " + Self as String)
EndEvent

Event OnActivate(ObjectReference ActionRef)
	RichAuthorityScript.DebugTrace("Info: Activated by reference >> " + ActionRef as String)
	If (ActionRef == Game.GetForm(0x14) as ObjectReference)
		; refresh chest and trader
		RichAuthorityScript PlayerInstance = (ActionRef as Actor) as RichAuthorityScript
		PlayerInstance.ProcessChest(TraderChest, False, False)
		PlayerInstance.ProcessTrader(Self, True)
		; begin barter
		RichAuthorityScript.DebugTrace("Call ShowBarterMenu >> " + Self as String + " / " + TraderChest as String)
		Self.ShowBarterMenu()
	EndIf
EndEvent
