ScriptName CompleteEvidenceScript Hidden

Function Launch() Global
	CFSD01_QuestScript CFSD01 = (Game.GetForm(0x1E8E2A) as Quest) as CFSD01_QuestScript
	If (CFSD01.IsCompleted() || CFSD01.DebugWasDone)
		DebugTrace("CFSD01 is completed or debug was done")
	ElseIf CFSD01.IsRunning()
		DebugTrace("CFSD01 is running, perform next check")
		CF07_QuestScript CF07 = (Game.GetForm(0x1EF7F2) as Quest) as CF07_QuestScript
		If CF07.IsCompleted()
			DebugTrace("CF07 is completed, execute CFSD01.DebugAddAll")
			CFSD01.DebugAddAll()
		Else
			DebugTrace("CF07 is not completed, do nothing")
		EndIf
	Else
		DebugTrace("CFSD01 is not started, do nothing")
	EndIf
EndFunction

Function DebugTrace(String Text) Global
	Debug.Trace("[CompleteEvidenceScript] " + Text, 1)
EndFunction
