ScriptName MagicEffectStarbornScript Extends ActiveMagicEffect

;-- Properties --------------------------------------
Spell Property ffStarbornTeleport Auto Const mandatory
Spell Property ffStarbornDeath Auto Const mandatory
ActorValue Property QuantumEssence Auto Const mandatory
Message Property QuantumEssenceAddMSG Auto Const mandatory
Spell Property FortifyQuantumEssenceSpell Auto Const mandatory
EffectShader Property Starborn_DeathShader Auto Const mandatory
Keyword Property NoLoot Auto Const mandatory

; new vars
bool hasLoaded
int essDo
int powDo
int lootDo

; new vars (only change these)
int powChance = 50
int lootChance = 70 ; loot may include rare items
int essChance = 10
; if useAll == 0, above has to equal 100 when totalled
int useAll = 1

;-- Functions ---------------------------------------

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
	ffStarbornTeleport.Cast(akCaster as ObjectReference, akCaster as ObjectReference)
	Self.RegisterForRemoteEvent(akCaster as ScriptObject, "OnLoad")
	Self.RegisterForRemoteEvent(akCaster as ScriptObject, "OnDying")
	Self.RegisterForRemoteEvent(akCaster as ScriptObject, "OnDeath")

	; set loot chances
	if (useAll == 1)
		if (Utility.RandomInt(1, 100) <= essChance)
			essDo = 1
		endif
		if Utility.RandomInt(1, 100) <= powChance
			powDo = 1
		endif
		if Utility.RandomInt(1, 100) <= lootChance
			lootDo = 1
		endif
		if (essDo == 0) && (powDo == 0) && (lootDo == 0)
			if (lootChance > 0)
				lootDo = 1
			elseif (powChance > 0)
				powDo = 1
			elseif (essChance > 0)
				essDo = 1
			endif
		endif
	else
		int myRoll = Utility.RandomInt(1, 100)
		if (myRoll <= essChance)
			essDo = 1
		elseif (myRoll > essChance) && (myRoll <= (essChance + powChance))
			powDo = 1
		else
			lootDo = 1
		endif
	endif
EndEvent

Event Actor.OnDeath(Actor akSender, ObjectReference akKiller)
	Utility.Wait(6.0)	
	if (lootDo == 0)
		akSender.Disable(False)
	endif
EndEvent

Event Actor.OnDying(Actor akSender, ObjectReference akKiller)
	if (lootDo == 0)
		akSender.BlockActivation(True, True)
		Starborn_DeathShader.Play(akSender as ObjectReference, 5.0)
	else
		akSender.AddItem((Game.GetFormFromFile(0x00279269, "Starfield.esm") as LeveledItem), 1, True)
		akSender.AddItem((Game.GetFormFromFile(0x00070372, "Starfield.esm") as LeveledItem), 1, True)
		akSender.AddItem((Game.GetFormFromFile(0x0004BD2A, "Starfield.esm") as LeveledItem), 1, True)
		if (Utility.RandomInt(1, 10) < 7)
			akSender.AddItem((Game.GetFormFromFile(0x001C1D4A, "Starfield.esm") as LeveledItem), 1, True)
		endif
	endif
	If !akSender.HasKeyword(NoLoot)
		If (akKiller as Actor).IsPlayerTeammate()
			FortifyQuantumEssenceSpell.Cast(akSender as ObjectReference, Game.GetPlayer() as ObjectReference)
		Else
			FortifyQuantumEssenceSpell.Cast(akSender as ObjectReference, akKiller)
		EndIf
		if (essDo == 1)
			int bonusQ = Utility.RandomInt(2,4)
			Game.GetPlayer().ModValue(QuantumEssence, bonusQ)
			debug.notification("You have gained " + (bonusQ + 1) + " Quantum Essence.")
		else
			QuantumEssenceAddMSG.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		endif
	EndIf
	if (powDo == 1)
		GrantAbility()
	endif
EndEvent

Event ObjectReference.OnLoad(ObjectReference akSender)
	if !hasLoaded
		hasLoaded = True
		ffStarbornTeleport.Cast(akSender, akSender)
	endif
EndEvent

;-- State -------------------------------------------
; Auto State WaitingForLoad
	; Event ObjectReference.OnLoad(ObjectReference akSender)
		; Self.GotoState("HasLoaded")
		; ffStarbornTeleport.Cast(akSender, akSender)
	; EndEvent
; EndState

;-- State -------------------------------------------
; State HasLoaded
	; Event ObjectReference.OnLoad(ObjectReference akSender)
	; EndEvent
; EndState

Function GrantAbility()
	int[] myID = new Int[24]
	myID[0] = 0x0025E164
	myID[1] = 0x0025E163
	myID[2] = 0x0025E162
	myID[3] = 0x0025E161
	myID[4] = 0x0025E160
	myID[5] = 0x0025E15F
	myID[6] = 0x0025E15E
	myID[7] = 0x0025E15D
	myID[8] = 0x0025E15C
	myID[9] = 0x0025E15B
	myID[10] = 0x0025E15A
	myID[11] = 0x0025E159
	myID[12] = 0x0025E158
	myID[13] = 0x0025E157
	myID[14] = 0x0025E156
	myID[15] = 0x0025E155
	myID[16] = 0x0025E154
	myID[17] = 0x0025E153
	myID[18] = 0x0025E152
	myID[19] = 0x0025E151
	myID[20] = 0x0025E150
	myID[21] = 0x0025E14F
	myID[22] = 0x0025E14E
	myID[23] = 0x0025E14D

	int myPick = Utility.RandomInt(0, 23)
	spell mySpell = (Game.GetFormFromFile(myID[myPick], "Starfield.esm") as Spell)
	mySpell.Cast(Game.GetPlayer(), Game.GetPlayer())
EndFunction
