ScriptName EssToPower Extends ScriptObject

Function Start() Global
	int myCost = 10 ; change this to set the minimum cost

	ActorValue qEss = (Game.GetFormFromFile(0x001447B7, "Starfield.esm") as ActorValue)

	; mod value correction
	actor myPlayer = Game.GetPlayer()
	if myPlayer.GetBaseValue(qEss) != myPlayer.GetValue(qEss)
		float currEss = myPlayer.GetValue(qEss)
		float baseEss = myPlayer.GetBaseValue(qEss)
		myPlayer.ModValue(qEss, (baseEss - currEss))
		myPlayer.SetValue(qEss, baseEss)
	endif

	int myEss = (Game.GetPlayer().GetValue(qEss)) as int
	if myEss >= myCost
		Game.GetPlayer().SetValue(qEss, Game.GetPlayer().GetValue(qEss) - myCost)
		DoEssToPower()
		debug.notification("You have " + ((Game.GetPlayer().GetValue(qEss)) as int) + " Quantum Essence remaining.")
	else
		debug.notification("You need at least " + myCost + " Quantum Essence. You have " + myEss + ".")
	endif
EndFunction

Function DoEssToPower() Global
	; cast shader
	(Game.GetFormFromFile(0x0018B81F, "Starfield.esm") as Spell).Cast(Game.GetPlayer(), Game.GetPlayer())

	int[] myID = new Int[24]
	myID[0] = 0x0025E164
	myID[1] = 0x0025E163
	myID[2] = 0x0025E162
	myID[3] = 0x0025E161
	myID[4] = 0x0025E160
	myID[5] = 0x0025E15F
	myID[6] = 0x0025E15E
	myID[7] = 0x0025E15D
	myID[8] = 0x0025E15C
	myID[9] = 0x0025E15B
	myID[10] = 0x0025E15A
	myID[11] = 0x0025E159
	myID[12] = 0x0025E158
	myID[13] = 0x0025E157
	myID[14] = 0x0025E156
	myID[15] = 0x0025E155
	myID[16] = 0x0025E154
	myID[17] = 0x0025E153
	myID[18] = 0x0025E152
	myID[19] = 0x0025E151
	myID[20] = 0x0025E150
	myID[21] = 0x0025E14F
	myID[22] = 0x0025E14E
	myID[23] = 0x0025E14D

	int myPick = Utility.RandomInt(0, 23)
	spell mySpell = (Game.GetFormFromFile(myID[myPick], "Starfield.esm") as Spell)
	mySpell.Cast(Game.GetPlayer(), Game.GetPlayer())
EndFunction
