ScriptName MQ201BScript Extends Quest

;-- Variables ---------------------------------------
ObjectReference AndrejaHomeMarker
ObjectReference BarrettHomeMarker
ObjectReference CoraHomeMarker
ObjectReference SamHomeMarker
ObjectReference SarahHomeMarker

;-- Properties --------------------------------------
Faction Property AvailableCompanionFaction Auto Const mandatory
Keyword Property LinkHome Auto Const mandatory
ObjectReference Property EyeHomeMarker Auto Const mandatory
ReferenceAlias Property Andreja Auto Const mandatory
ReferenceAlias Property Barrett Auto Const mandatory
ReferenceAlias Property SamCoe Auto Const mandatory
ReferenceAlias Property CoraCoe Auto Const mandatory
ReferenceAlias Property SarahMorgan Auto Const mandatory
GlobalVariable Property COM_CompanionID_Andreja Auto Const mandatory
GlobalVariable Property COM_CompanionID_Barrett Auto Const mandatory
GlobalVariable Property COM_CompanionID_SamCoe Auto Const mandatory
GlobalVariable Property COM_CompanionID_SarahMorgan Auto Const mandatory
GlobalVariable Property MQ_CompanionAtEye Auto Const mandatory
GlobalVariable Property MQ_CompanionAtLodge Auto Const mandatory
ReferenceAlias Property MQ00_CompanionAtEye Auto Const mandatory
ReferenceAlias Property MQ00_CompanionAtLodge Auto Const mandatory
Quest Property SQ_Companions Auto Const mandatory
ActorValue Property COM_AffinityLevel Auto Const mandatory
ActorValue Property COM_Affinity Auto Const mandatory

;-- Functions ---------------------------------------

Function SetCompanionsAtRisk()
  companionActorScript[] CompanionActorArray = new companionActorScript[4] ; #DEBUG_LINE_NO:34
  CompanionActorArray[0] = SarahMorgan.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:35
  CompanionActorArray[1] = SamCoe.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:36
  CompanionActorArray[2] = Barrett.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:37
  Self.SetCompanionAtEye(Andreja.GetActorRef() as companionActorScript) ; #DEBUG_LINE_NO:38
  (SQ_Companions as sQ_CompanionsScript).SortCompanionArrayByAffinity(CompanionActorArray, True) ; #DEBUG_LINE_NO:39
  Self.SetCompanionAtLodge(CompanionActorArray[1]) ; #DEBUG_LINE_NO:40
EndFunction

Function SetCompanionAtEye(companionActorScript Companion)
  MQ00_CompanionAtEye.ForceRefTo(Companion as ObjectReference) ; #DEBUG_LINE_NO:44
  Companion.SetGlobalToCompanionID(MQ_CompanionAtEye) ; #DEBUG_LINE_NO:45
EndFunction

Function SetCompanionAtLodge(companionActorScript Companion)
  MQ00_CompanionAtLodge.ForceRefTo(Companion as ObjectReference) ; #DEBUG_LINE_NO:49
  Companion.SetGlobalToCompanionID(MQ_CompanionAtLodge) ; #DEBUG_LINE_NO:50
EndFunction

Function SetCompanionsHomeLink()
  Actor AndrejaREF = Andreja.GetActorRef() ; #DEBUG_LINE_NO:54
  Actor BarrettREF = Barrett.GetActorRef() ; #DEBUG_LINE_NO:55
  Actor SamCoeREF = SamCoe.GetActorRef() ; #DEBUG_LINE_NO:56
  Actor SarahMorganREF = SarahMorgan.GetActorRef() ; #DEBUG_LINE_NO:57
  Actor CoraCoeREF = CoraCoe.GetActorRef() ; #DEBUG_LINE_NO:58
  AndrejaHomeMarker = AndrejaREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:59
  BarrettHomeMarker = BarrettREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:60
  SamHomeMarker = SamCoeREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:61
  CoraHomeMarker = CoraCoeREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:62
  SarahHomeMarker = SarahMorganREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:63
  AndrejaREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:64
  BarrettREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:65
  SamCoeREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:66
  SarahMorganREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:67
  CoraCoeREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:68
EndFunction

Function ResetCompanionsHomeLink()
  Actor AndrejaREF = Andreja.GetActorRef() ; #DEBUG_LINE_NO:72
  Actor BarrettREF = Barrett.GetActorRef() ; #DEBUG_LINE_NO:73
  Actor SamCoeREF = SamCoe.GetActorRef() ; #DEBUG_LINE_NO:74
  Actor SarahMorganREF = SarahMorgan.GetActorRef() ; #DEBUG_LINE_NO:75
  Actor CoraCoeREF = CoraCoe.GetActorRef() ; #DEBUG_LINE_NO:76
  AndrejaREF.SetLinkedRef(AndrejaHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:77
  BarrettREF.SetLinkedRef(BarrettHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:78
  SamCoeREF.SetLinkedRef(SamHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:79
  SarahMorganREF.SetLinkedRef(SarahHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:80
  CoraCoeREF.SetLinkedRef(CoraHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:81
EndFunction
