ScriptName MQ201BScript Extends Quest

;-- Variables ---------------------------------------
ObjectReference AndrejaHomeMarker
ObjectReference BarrettHomeMarker
ObjectReference CoraHomeMarker
ObjectReference SamHomeMarker
ObjectReference SarahHomeMarker

;-- Properties --------------------------------------
Faction Property AvailableCompanionFaction Auto Const mandatory
Keyword Property LinkHome Auto Const mandatory
ObjectReference Property EyeHomeMarker Auto Const mandatory
ReferenceAlias Property Andreja Auto Const mandatory
ReferenceAlias Property Barrett Auto Const mandatory
ReferenceAlias Property SamCoe Auto Const mandatory
ReferenceAlias Property CoraCoe Auto Const mandatory
ReferenceAlias Property SarahMorgan Auto Const mandatory
GlobalVariable Property COM_CompanionID_Andreja Auto Const mandatory
GlobalVariable Property COM_CompanionID_Barrett Auto Const mandatory
GlobalVariable Property COM_CompanionID_SamCoe Auto Const mandatory
GlobalVariable Property COM_CompanionID_SarahMorgan Auto Const mandatory
GlobalVariable Property MQ_CompanionAtEye Auto Const mandatory
GlobalVariable Property MQ_CompanionAtLodge Auto Const mandatory
ReferenceAlias Property MQ00_CompanionAtEye Auto Const mandatory
ReferenceAlias Property MQ00_CompanionAtLodge Auto Const mandatory
Quest Property SQ_Companions Auto Const mandatory
ActorValue Property COM_AffinityLevel Auto Const mandatory
ActorValue Property COM_Affinity Auto Const mandatory

;-- Functions ---------------------------------------

Function SetCompanionsAtRisk()
  companionActorScript[] CompanionActorArray = new companionActorScript[4] ; #DEBUG_LINE_NO:34
  CompanionActorArray[0] = SarahMorgan.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:35
  CompanionActorArray[1] = SamCoe.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:36
  CompanionActorArray[2] = Andreja.GetActorRef() as companionActorScript ; #DEBUG_LINE_NO:38
  Self.SetCompanionAtEye(Barrett.GetActorRef() as companionActorScript) ; #DEBUG_LINE_NO:39
  (SQ_Companions as sQ_CompanionsScript).SortCompanionArrayByAffinity(CompanionActorArray, True) ; #DEBUG_LINE_NO:40
  Self.SetCompanionAtLodge(CompanionActorArray[1]) ; #DEBUG_LINE_NO:41
EndFunction

Function SetCompanionAtEye(companionActorScript Companion)
  MQ00_CompanionAtEye.ForceRefTo(Companion as ObjectReference) ; #DEBUG_LINE_NO:45
  Companion.SetGlobalToCompanionID(MQ_CompanionAtEye) ; #DEBUG_LINE_NO:46
EndFunction

Function SetCompanionAtLodge(companionActorScript Companion)
  MQ00_CompanionAtLodge.ForceRefTo(Companion as ObjectReference) ; #DEBUG_LINE_NO:50
  Companion.SetGlobalToCompanionID(MQ_CompanionAtLodge) ; #DEBUG_LINE_NO:51
EndFunction

Function SetCompanionsHomeLink()
  Actor AndrejaREF = Andreja.GetActorRef() ; #DEBUG_LINE_NO:55
  Actor BarrettREF = Barrett.GetActorRef() ; #DEBUG_LINE_NO:56
  Actor SamCoeREF = SamCoe.GetActorRef() ; #DEBUG_LINE_NO:57
  Actor SarahMorganREF = SarahMorgan.GetActorRef() ; #DEBUG_LINE_NO:58
  Actor CoraCoeREF = CoraCoe.GetActorRef() ; #DEBUG_LINE_NO:59
  AndrejaHomeMarker = AndrejaREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:60
  BarrettHomeMarker = BarrettREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:61
  SamHomeMarker = SamCoeREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:62
  CoraHomeMarker = CoraCoeREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:63
  SarahHomeMarker = SarahMorganREF.GetLinkedRef(LinkHome) ; #DEBUG_LINE_NO:64
  AndrejaREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:65
  BarrettREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:66
  SamCoeREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:67
  SarahMorganREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:68
  CoraCoeREF.SetLinkedRef(EyeHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:69
EndFunction

Function ResetCompanionsHomeLink()
  Actor AndrejaREF = Andreja.GetActorRef() ; #DEBUG_LINE_NO:73
  Actor BarrettREF = Barrett.GetActorRef() ; #DEBUG_LINE_NO:74
  Actor SamCoeREF = SamCoe.GetActorRef() ; #DEBUG_LINE_NO:75
  Actor SarahMorganREF = SarahMorgan.GetActorRef() ; #DEBUG_LINE_NO:76
  Actor CoraCoeREF = CoraCoe.GetActorRef() ; #DEBUG_LINE_NO:77
  AndrejaREF.SetLinkedRef(AndrejaHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:78
  BarrettREF.SetLinkedRef(BarrettHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:79
  SamCoeREF.SetLinkedRef(SamHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:80
  SarahMorganREF.SetLinkedRef(SarahHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:81
  CoraCoeREF.SetLinkedRef(CoraHomeMarker, LinkHome, True) ; #DEBUG_LINE_NO:82
EndFunction
