;;-----------------------------------------------------------------------------------
ScriptName LSSL:Interface Const hidden
{Looter Shooter, Shooter Looter
by 1000101
October 2023

Public API functions for console/hotkeys/etc.}




;;-----------------------------------------------------------------------------------
;; Internal API
LSSL:LootQuest Function __GetQuest() Global
    Return ( Game.GetFormFromFile( 0x00000825, "LooterShooter-ShooterLooter.esp" ) As Quest ) As LSSL:LootQuest
EndFunction


;;-----------------------------------------------------------------------------------
;; Public API

;; cgf "LSSL:Interface.SetFloatControl" "asControl" afValue
Function SetFloatControl( String asControl, Float afValue ) Global
    __GetQuest().SetFloatControl( asControl, afValue )
EndFunction


;; cgf "LSSL:Interface.ModFloatControl" "asControl" afValue
Function ModFloatControl( String asControl, Float afValue ) Global
    __GetQuest().ModFloatControl( asControl, afValue )
EndFunction


;; cgf "LSSL:Interface.SetBoolControl" "asControl" abValue
Function SetBoolControl( String asControl, Bool abValue ) Global
    __GetQuest().SetBoolControl( asControl, abValue )
EndFunction


;; cgf "LSSL:Interface.ToggleBoolControl" "asControl"
Function ToggleBoolControl( String asControl ) Global
    __GetQuest().ToggleBoolControl( asControl )
EndFunction


;; cgf "LSSL:Interface.ToggleFilter" "asFilterTag"
Function ToggleFilter( String asFilterTag ) Global
    __GetQuest().ToggleFilter( asFilterTag )
EndFunction




