ScriptName BEBlockPilotSeatScript Extends ReferenceAlias
{ Script placed on a ship's pilot seat. Blocks players from sitting in the seat and taking over the ship, optionally until all enemy crew are dead. }

;-- Variables ---------------------------------------
Bool activationUnblocked

;-- Properties --------------------------------------
Message Property PilotSeatNotAuthorizedMessage Auto Const mandatory
{ Message to display when the player tries to sit in the ship's pilot seat while the block is in place. }
Bool Property ShouldAllowTakeoverWhenAllCrewDead = False Auto Const
{ Default=False; BEScript Quests ONLY. Should we allow the player to sit in the pilot seat and take over the ship once all enemy crew are dead? }

;-- Functions ---------------------------------------

Event OnAliasInit()
  ; If ShouldAllowTakeoverWhenAllCrewDead
  ; always allow takeover - if the owning quest is a valid bescript quest, force all enemy crew to be killed first
  bescript owningBEQuest = Self.GetOwningQuest() as bescript
  If owningBEQuest != None
    ObjectReference myRef = Self.GetReference()
    myRef.BlockActivation(True, False)
    Self.RegisterForCustomEvent(owningBEQuest as ScriptObject, "bescript_BEAllCrewDead")
  Else
    activationUnblocked = True
  EndIf
  ; EndIf
EndEvent

Event OnActivate(ObjectReference akActivator)
  ; existing save compatibility - exit early in case there is still enemy crew alive
  If !activationUnblocked && (Self.GetOwningQuest() as bescript) != None
    return
  EndIf
  ObjectReference myRef = Self.GetReference()
  ; if the activation is blocked - allow it
  If myRef.IsActivationBlocked() && (akActivator == Game.GetPlayer() as ObjectReference)
    myRef.BlockActivation(False, False)
    myRef.Activate(akActivator, False)
  EndIf
EndEvent

Event BEScript.BEAllCrewDead(bescript source, Var[] akArgs)
  ObjectReference myRef = Self.GetReference()
  myRef.BlockActivation(False, False)
  activationUnblocked = True
EndEvent
