Scriptname RS_ConfigScript Extends ActiveMagicEffect

Actor Property PlayerRef Auto
Message Property RS_ConfigMsg Auto
Message Property RS_ConfigOrganMsg Auto
Message Property RS_ConfigMeatMsg Auto
Form Property RS_ConfigChem Auto
Perk Property TRAIT_Cannibal Auto
GlobalVariable Property NPCAlwaysDropOrgan Auto
GlobalVariable Property NPCAlwaysDropMeat Auto
GlobalVariable Property OrganDropFailureRateBase Auto
GlobalVariable Property MeatDropFailureRateBase Auto

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  If akTarget == PlayerRef
    PlayerRef.AddItem(RS_ConfigChem, 1, True)
    Menu()
  EndIf
EndEvent

Function Menu(Int aiMsg = 0, Int aiBtn = 0, Bool abMenu = True)
  While abMenu
    If aiBtn == -1

    ;============================================== Root
    ElseIf aiMsg == 0
      aiBtn = RS_ConfigMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

      If aiBtn == 0     ;Close this menu
        abMenu = False
      ElseIf aiBtn == 1 ;Change organ drop rate
        aiMsg = 1
      ElseIf aiBtn == 2 ;Change meat drop rate
        aiMsg = 2
      ElseIf aiBtn == 3 ;Grant me cannibal trait
        ;PlayerRef.AddPerk(TRAIT_Cannibal, True)
        Debug.ExecuteConsole("player.addperk " + Utility.IntToHex(TRAIT_Cannibal.GetFormID()))
      ElseIf aiBtn == 4 ;Revoke me cannibal trait
        ;PlayerRef.RemovePerk(TRAIT_Cannibal, True)
        Debug.ExecuteConsole("player.removeperk " + Utility.IntToHex(TRAIT_Cannibal.GetFormID()))
      EndIf

    ;============================================== Organ
    ElseIf aiMsg == 1
      aiBtn = RS_ConfigOrganMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0

      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;100% [Always]
        NPCAlwaysDropOrgan.SetValue(1.0)
      ElseIf aiBtn == 2 ;(Zoology * Medicine / 16) * 100%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(0.0)
      ElseIf aiBtn == 3 ;(Zoology * Medicine / 16) * 75%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(25.0)
      ElseIf aiBtn == 4 ;(Zoology * Medicine / 16) * 50%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(50.0)
      ElseIf aiBtn == 5 ;(Zoology * Medicine / 16) * 25%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(75.0)
      ElseIf aiBtn == 6 ;(Zoology * Medicine / 16) * 10%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(90.0)
      ElseIf aiBtn == 7 ;(Zoology * Medicine / 16) * 5%
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(95.0)
      ElseIf aiBtn == 8 ;0% [Disable]
        NPCAlwaysDropOrgan.SetValue(0.0)
        OrganDropFailureRateBase.SetValue(100.0)
      EndIf

    ;============================================== Meat
    ElseIf aiMsg == 2
      aiBtn = RS_ConfigMeatMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0

      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;100% [Always]
        NPCAlwaysDropMeat.SetValue(1.0)
      ElseIf aiBtn == 2 ;(Zoology * Gastonomy / 16) * 100%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(0.0)
      ElseIf aiBtn == 3 ;(Zoology * Gastonomy / 16) * 75%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(25.0)
      ElseIf aiBtn == 4 ;(Zoology * Gastonomy / 16) * 50%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(50.0)
      ElseIf aiBtn == 5 ;(Zoology * Gastonomy / 16) * 25%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(75.0)
      ElseIf aiBtn == 6 ;(Zoology * Gastonomy / 16) * 10%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(90.0)
      ElseIf aiBtn == 7 ;(Zoology * Gastonomy / 16) * 5%
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(95.0)
      ElseIf aiBtn == 8 ;0% [Disable]
        NPCAlwaysDropMeat.SetValue(0.0)
        MeatDropFailureRateBase.SetValue(100.0)
      EndIf
    EndIf
  EndWhile
EndFunction
