ScriptName avontech_spacenegative Extends ObjectReference

;-- Variables ---------------------------------------
Form[] Property ShipToSpawn auto mandatory
;-- Properties --------------------------------------

;-- Functions ---------------------------------------
Event OnContainerChanged(ObjectReference akNewContainer, ObjectReference akOldContainer)
    If akNewContainer == Game.GetPlayer() as ObjectReference ; #DEBUG_LINE_NO:47
        Self.StartTreasureQuest() ; #DEBUG_LINE_NO:48
    EndIf
EndEvent

Function StartTreasureQuest()
    Utility.Wait(3)
    spaceshipreference playerShipRef = Game.GetPlayer().GetCurrentShipRef()
    
    Float[] placePosition = new Float[3]
    placePosition[0] = Utility.RandomFloat(-500, 500)
    placePosition[1] = Utility.RandomFloat(400, 750)
    placePosition[2] = Utility.RandomFloat(-600, 600)
    spaceshipreference myNewShip = playerShipRef.PlaceShipAtMe(ShipToSpawn[Utility.RandomInt(0, ShipToSpawn.Length - 1)], 4, True, False, False, True, placePosition, None, None, True)

    ObjectReference player = Game.GetPlayer() as ObjectReference
    player.RemoveItem(Self as Form, 1, True, None)
EndFunction
