ScriptName FollowersAllTerminalMenuScript Extends TerminalMenu

SQ_FollowersScript Property SQ_Followers Auto
SQ_PlayerShipScript Property SQ_PlayerShip Auto
Actor Property PlayerRef Auto

Guard InstructionsGuard

Function WaitAll(ObjectReference akTerminalRef)
	RegisterForCustomEvent(self, "FollowersAllTerminalMenuScript_WaitAllRequested")
	SendCustomEvent("FollowersAllTerminalMenuScript_WaitAllRequested", None)
EndFunction

Event FollowersAllTerminalMenuScript.WaitAllRequested(FollowersAllTerminalMenuScript akSender, Var[] akArgs)
	Guard InstructionsGuard
		SQ_Followers.AllFollowersWait(None, True, False)
		Utility.Wait(0.01)
	EndGuard
EndEvent

Function FollowAll(ObjectReference akTerminalRef)
	RegisterForCustomEvent(self, "FollowersAllTerminalMenuScript_FollowAllRequested")
	SendCustomEvent("FollowersAllTerminalMenuScript_FollowAllRequested", None)
EndFunction

Event FollowersAllTerminalMenuScript.FollowAllRequested(FollowersAllTerminalMenuScript akSender, Var[] akArgs)
	Guard InstructionsGuard
		SQ_Followers.AllFollowersFollow(None)
		Utility.Wait(0.01)
	EndGuard
EndEvent

Function TeleportPlayerAll(ObjectReference akTerminalRef)
	RegisterForCustomEvent(self, "FollowersAllTerminalMenuScript_TeleportPlayerAllRequested")
	SendCustomEvent("FollowersAllTerminalMenuScript_TeleportPlayerAllRequested", None)
EndFunction

Event FollowersAllTerminalMenuScript.TeleportPlayerAllRequested(FollowersAllTerminalMenuScript akSender, Var[] akArgs)
	Guard InstructionsGuard
		SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, True, False, False)
		Utility.Wait(0.01)
	EndGuard
EndEvent

Function ReturnToShipAll(ObjectReference akTerminalRef)
	RegisterForCustomEvent(self, "FollowersAllTerminalMenuScript_ReturnToShipAllRequested")
	SendCustomEvent("FollowersAllTerminalMenuScript_ReturnToShipAllRequested", None)
EndFunction

Event FollowersAllTerminalMenuScript.ReturnToShipAllRequested(FollowersAllTerminalMenuScript akSender, Var[] akArgs)
	Guard InstructionsGuard
		SQ_Followers.AllFollowersWait(SQ_PlayerShip.HomeShipCrewMarker.GetRef(), False, False)
		Utility.Wait(0.01)
	EndGuard
EndEvent

Function InventoryAll(ObjectReference akTerminalRef)
	RegisterForCustomEvent(self, "FollowersAllTerminalMenuScript_InventoryAllRequested")
	SendCustomEvent("FollowersAllTerminalMenuScript_InventoryAllRequested", None)
EndFunction

Event FollowersAllTerminalMenuScript.InventoryAllRequested(FollowersAllTerminalMenuScript akSender, Var[] akArgs)
	Guard InstructionsGuard
		Actor[] activeFollowersArray = (SQ_Followers.Alias_Active as RefCollectionAlias).GetArray() as Actor[]
		Int i = activeFollowersArray.Length
		While i
			i -= 1
			Actor activeFollower = activeFollowersArray[i]
			If activeFollower
				Utility.Wait(0.1)
				activeFollower.OpenInventory(True, None, True)
			EndIf
		EndWhile
	EndGuard
EndEvent
