ScriptName SRCBookAliasScript Extends ReferenceAlias

ObjectReference Property SRCTerminalRef Auto
sq_playershipscript Property SQ_PlayerShip Auto
Keyword Property SpaceshipLinkedInterior Auto
Keyword Property SpaceshipEnabledLandingLink Auto
FormList Property SRCLandingMarkers Auto
Furniture Property SRCLandingMarker Auto
Quest Property SRCSLandingQuest Auto
ReferenceAlias Property SRCSLandingQuestAlias Auto
Static Property XMarker Auto
GlobalVariable Property SRCLandingPercentage Auto
GlobalVariable Property SRCLandingAllowed Auto
Message Property SRCLandingMessage Auto

Event OnEquipped(Actor akActor)
	If SQ_PlayerShip.PlayerShip.GetShipRef()
		SRCTerminalRef.Activate(akActor, False)
	EndIf
	akActor.UnequipItem(GetReference().GetBaseObject(), False, True)
EndEvent

Function SetGravity(Float gravity)
	RegisterForCustomEvent(self, "SRCBookAliasScript_GravityChangeRequested")
	Var[] akArgs = new Var[1]
	akArgs[0] = gravity
	SendCustomEvent("SRCBookAliasScript_GravityChangeRequested", akArgs)
EndFunction

Guard GravityGuard
Event SRCBookAliasScript.GravityChangeRequested(SRCBookAliasScript akSender, Var[] akArgs)
	Guard GravityGuard
		Utility.Wait(0.01)
		SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
		Cell shipInterior = akShip.GetLinkedCell(SpaceshipLinkedInterior)
		Float gravity = akArgs[0] As Float
		shipInterior.SetGravityScale(gravity)
	EndGuard
EndEvent

Function TakeOff()
	SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	akShip.TakeOff()
EndFunction

Function Land()
	RegisterForCustomEvent(self, "SRCBookAliasScript_LandingRequested")
	ObjectReference landingMarker = FindLandingMarker()
	If landingMarker
		SRCLandingAllowed.SetValueInt(1)
		Var[] akArgs = new Var[1]
		akArgs[0] = landingMarker
		SendCustomEvent("SRCBookAliasScript_LandingRequested", akArgs)
	Else
		SRCLandingAllowed.SetValueInt(0)
	EndIf
EndFunction

InputEnableLayer disableFastTravelLayer
Event SRCBookAliasScript.LandingRequested(SRCBookAliasScript akSender, Var[] akArgs)
	ObjectReference landingMarker = akArgs[0] As ObjectReference
	SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	SRCSLandingQuest.Stop()
	SRCSLandingQuest.Reset()
	disableFastTravelLayer = InputEnableLayer.Create()
	disableFastTravelLayer.EnableFastTravel(False)
	akShip.Disable(False)
	akShip.MoveTo(landingMarker, 0, 0, 0, True, False)
	akShip.SetLinkedRef(landingMarker, SpaceshipEnabledLandingLink, True)
	RegisterForRemoteEvent(Game.GetPlayer(), "OnLocationChange")
	SRCSLandingQuest.Start()
	SRCSLandingQuestAlias.ForceRefTo(landingMarker)
	SRCSLandingQuest.SetActive(True)
	SRCSLandingQuest.SetObjectiveDisplayed(100, True, False)
	akShip.Enable(False)
	akShip.EnableWithLanding()
	While SRCSLandingQuest.IsRunning() && !akShip.IsLanded()
		Utility.Wait(1)
	EndWhile
	ShutDownLandingQuest()
EndEvent

Event Actor.OnLocationChange(Actor akSource, Location akOldLoc, Location akNewLoc)
	WorldSpace ws1 = Game.GetPlayer().GetWorldSpace()
	WorldSpace ws2 = SRCSLandingQuestAlias.GetRef().GetWorldSpace()
	If !ws1 || ws1 != ws2
		ShutDownLandingQuest()
	EndIf
EndEvent

Function ShutDownLandingQuest()
	SRCSLandingQuest.CompleteAllObjectives()
	SRCSLandingQuest.CompleteQuest()
	SRCSLandingQuest.Stop()
	SRCSLandingQuest.Reset()
	If disableFastTravelLayer
		disableFastTravelLayer.EnableFastTravel(True)
    	disableFastTravelLayer.Delete()
	EndIf
EndFunction

ObjectReference Function FindLandingMarker()
	Actor playerRef = Game.GetPlayer()
	SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	ObjectReference landingMarker200 = Game.FindClosestReferenceOfAnyTypeInListFromRef(SRCLandingMarkers, playerRef, 200)
	If landingMarker200 && akShip.CanLandAtMarker(landingMarker200) && !landingMarker200.IsFurnitureInUse(False)
		Return landingMarker200
	EndIf
	SRCLandingMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	Float[] offsets = new Float[6]
    offsets[1] = 10.0
    offsets[5] = 180.0
	ObjectReference landingMarkerCustom = playerRef.PlaceAtMe(SRCLandingMarker, 1, False, False, True, offsets, None, True)
	If CheckLandingSpace(landingMarkerCustom) && akShip.CanLandAtMarker(landingMarkerCustom) && !landingMarker200.IsFurnitureInUse(False)
		Return landingMarkerCustom
	EndIf
	Return None
EndFunction

bool Function CheckLandingSpace(ObjectReference markerRef)
	Int i = -30
	Int j = -30
	While i < 30
		While j < 30
			Float[] offsets = new Float[6]
			offsets[0] = i
			offsets[1] = j
			offsets[2] = 0.0
			offsets[3] = 0.0
			offsets[4] = 0.0
			offsets[5] = 0.0
			ObjectReference test1 = markerRef.PlaceAtMe(XMarker, 1, False, False, True, offsets, None, False)
			ObjectReference test2 = markerRef.PlaceAtMe(XMarker, 1, False, False, True, offsets, None, True)
			Float distance = test1.GetDistance(test2)
			test1.Delete()
			test2.Delete()
			If distance > 2
				Return False
			EndIf
			j += 1
		EndWhile
		i += 1
	EndWhile
	Return True
EndFunction