Scriptname LJailScript_MiscItem_PrisonerTablet extends ReferenceAlias

GlobalVariable Property BasePrisonerCost Auto Const
GlobalVariable Property TotalPrisonerCost Auto
Quest Property JailManager Auto Const
Message Property Menu Auto Const
ReferenceAlias Property CargoHold Auto Const
Message Property FailMessage Auto Const
Keyword Property PrisonLocation Auto Const
FormList Property CityPrisonCellsList Auto Const
GlobalVariable Property MissionCostMult Auto Const


Event OnRead()

    If Game.GetPlayer().GetCurrentLocation().HasKeyword(PrisonLocation) || Game.GetPlayer().GetParentCell().HasKeyword(PrisonLocation) || CityPrisonCellsList.Find(Game.GetPlayer().GetParentCell()) >= 0
        calcPrisonerCost()
        int prisoners = GetManager().GetArrestedActors().Length
        If Menu.Show(prisoners, TotalPrisonerCost.GetValueInt(), 0, 0, 0, 0, 0, 0, 0) == 0
            SellPrisoners()
        EndIf
    Else
        FailMessage.Show(0, 0, 0, 0, 0, 0, 0, 0, 0)
    EndIf
EndEvent

Function calcPrisonerCost()

    int price = (BasePrisonerCost.GetValueInt() * MissionCostMult.GetValue()) as int

    TotalPrisonerCost.SetValueInt(GetManager().GetArrestedActors().Length * price)
    JailManager.UpdateCurrentInstanceGlobal(TotalPrisonerCost)
EndFunction

Function SellPrisoners()
    Actor[] actors = GetManager().GetArrestedActors()
    int index = 0

    While index < actors.Length
        
        GetManager().Release(actors[index])
        actors[index].KillSilent(None)
        actors[index].Disable(False)

        index +=1
    EndWhile

    Game.GetPlayer().AddItem(Game.GetCredits(), TotalPrisonerCost.GetValueInt(), false)
    
EndFunction

LJailScript_Quest Function GetManager()
    return JailManager as LJailScript_Quest
EndFunction