Scriptname LJailScript_Quest extends Quest

RefCollectionAlias Property PrisonMarker Auto
RefCollectionAlias Property Prioners Auto
Keyword Property CellLinkKeyword Auto Const
Faction Property BrigPrisonerFaction Auto Const
ActorValue Property AggroAV Auto Const
Book Property PrisonerTabletItem Auto Const
ReferenceAlias Property PrisonerItemAlias Auto Const
Perk Property SendToBrigPerk Auto Const
ObjectReference Property CargoHold Auto Const
Armor Property PrisonerClothes Auto Const
ObjectReference Property OverflowPrisonMarker Auto Const

Event OnQuestInit()
    If !Game.GetPlayer().HasPerk(SendToBrigPerk)
        Game.GetPlayer().AddPerk(SendToBrigPerk, False)
    EndIF
    FindAllBeds()
EndEvent

Function FindAllBeds()
    PrisonMarker.RefillAlias()
    ;Re-arrest all old prisoners
    CleanPrisoners()
    Actor[] inmates = GetArrestedActors()
    ObjectReference[] usedCells = new ObjectReference[0]
    int index = 0
    While index < inmates.Length

        ;If this Prisoner's old bed is not found, or it is being used by another prisoner, re-arrest
        ObjectReference oldCell = inmates[index].GetLinkedRef(CellLinkKeyword)
        If PrisonMarker.Find(oldCell) < 0 || usedCells.Find(oldCell) >= 0 || oldCell == OverflowPrisonMarker
            Arrest(inmates[index], True)
        Else
            usedCells.Add(oldCell)
        EndIf

        index += 1
    EndWhile
EndFunction


Function SetPrisonerEquipment(Actor p)
    p.RemoveAllItems(none, False, False)
    p.EquipItem(PrisonerClothes, true, true)
    
EndFunction

Bool Function Arrest(Actor act, Bool force)
    CleanPrisoners()

    ;If our brigs are at capacity, return false
    If GetArrestedActors().Length >= PrisonMarker.GetCount() && !force
        return false
    EndIf

    ObjectReference marker = getNextFreeCell()
    if marker == none
        marker = OverflowPrisonMarker
    EndIf

    act.moveTo(OverflowPrisonMarker, 0, 0, 0, False, false)

    act.SetCrimeFaction(BrigPrisonerFaction)
    act.Kill(none)
    ;Utility.Wait(1)

    act.RemoveAllItems(CargoHold, False, False)

    act.Resurrect()
    SetPrisonerEquipment(act)
    act.RemoveFromAllFactions()
    act.SetCrimeFaction(BrigPrisonerFaction)

    act.SetLinkedRef(marker, CellLinkKeyword, false)
    act.SetValue(AggroAV, 0)
    act.StopCombat()
    act.StopCombatAlarm()
    
    ;Utility.Wait(1)

    act.MoveToFurniture(marker)
    Prioners.addRef(act)
    
    act.EvaluatePackage(False)

    return true
EndFunction

Function Release(Actor act)
    act.SetLinkedRef(none, CellLinkKeyword, false)
    act.RemoveFromFaction(BrigPrisonerFaction)
    Prioners.RemoveRef(act)
EndFunction

;Returns the amount of actors in custody
Int Function CleanPrisoners()
    int index = 0
    int count = 0
    While index < Prioners.GetCount()
        
        ObjectReference ref = Prioners.GetAt(index)
        Actor act = ref as Actor
        ;If this is disabled, dead, or not an actor
        If act == none || act.IsDead()
            Release(act)
        Else
            count += 1
        EndIf

        index += 1
    EndWhile
    return count
EndFunction

Actor[] Function GetArrestedActors()
    Actor[] actors = new Actor[0]

    int index = 0;
    While index < Prioners.GetCount()
        Actor ref = Prioners.GetAt(index) as Actor
        If ref != none
            actors.add(ref)
        EndIf
        index += 1
    EndWhile

    return actors
EndFunction

ObjectReference Function getNextFreeCell()

    int index = 0
    While index < PrisonMarker.getCount()
        ObjectReference marker = PrisonMarker.GetAt(index)
        
        bool inUse = False;
        int prisonerIndex = 0
        While prisonerIndex < Prioners.GetCount()
            
            If Prioners.GetAt(prisonerIndex).GetLinkedRef(CellLinkKeyword) == marker
                inUse = True
            EndIf

            prisonerIndex += 1
        EndWhile

        if(!marker.IsFurnitureInUse(true) && !inUse)
            return marker
        EndIf

        index += 1
    EndWhile

    return none

EndFunction

Function ReleaseAll()
    int index = 0
    While index < Prioners.getCount()
        Release(Prioners.GetAt(index) as Actor)
        index += 1
    EndWhile
EndFunction