ScriptName SISA_Survival extends Quest

Quest Property MQ101 Auto Const

Perk Property SurvivalStart Auto Const
Perk Property SurvivalLogos Auto Const
Perk Property SurvivalLogosOff Auto Const
Perk Property SurvivalAdrenaline Auto Const
Perk Property SurvivalAdrenalineBuff Auto Const
Perk Property SurvivalAdrenalineAftermath Auto Const
Perk Property OversatiationDebuff Auto Const
Perk Property Nutrition Auto Const
Actor Property PlayerRef Auto Const
ActorValue Property Hunger Auto Const
ActorValue Property Sleep Auto Const
ActorValue Property Thirst Auto Const
ActorValue Property Oversatiation Auto Const
Armor Property AdrenalineToken Auto Const
Armor Property WellRestedToken Auto Const
Book Property StarvivalGuide Auto Const

Potion Property Blackout Auto Const
Potion Property SatiationChecker Auto Const

Potion Property AffPotionAnalgesicPoultice Auto Const
Potion Property AffPotionAntibioticInjector Auto Const
Potion Property AffPotionAntibioticPaste Auto Const
Potion Property AffPotionAntibioticPasteResearch Auto Const
Potion Property AffPotionAntibiotics Auto Const
Potion Property AffPotionAntibioticsCoctail Auto Const
Potion Property AffPotionBandages Auto Const
Potion Property AffPotionBandagesInfused Auto Const
Potion Property AffPotionBandagesZipper Auto Const
Potion Property AffPotionEmergencyKit Auto Const
Potion Property AffPotionHealGel Auto Const
Potion Property AffPotionHealPaste Auto Const
Potion Property AffPotionImmobilizer Auto Const
Potion Property AffPotionImmobilizerAnchored Auto Const
Potion Property AffPotionImmobilizerRepairing Auto Const
Potion Property AffPotionImmobilizerRepairingResearch Auto Const
Potion Property AffPotionInjector Auto Const
Potion Property AffPotionInjectorBoosted Auto Const
Potion Property AffPotionMedpack Auto Const
Potion Property AffPotionPanacea Auto Const
Potion Property AffPotionPanaceaResearch Auto Const
Potion Property AffPotionPenicillinX Auto Const
Potion Property AffPotionSnakeOil Auto Const
Potion Property AffPotionTraumaPack Auto Const
Potion Property AddPotionCureJunkFlush Auto Const

GlobalVariable Property HungerTime Auto Const
GlobalVariable Property HungerDMGPoints Auto Const
GlobalVariable Property HungerLowestPoints Auto Const
GlobalVariable Property HungerMaxPoints Auto Const
GlobalVariable Property HungerMaxPointsBonus Auto Const

GlobalVariable Property OversatiationMaxPoints Auto Const
GlobalVariable Property OversatiationMaxPointsBonus Auto Const

GlobalVariable Property SleepTime Auto Const
GlobalVariable Property SleepDMGPoints Auto Const
GlobalVariable Property SleepLowestPoints Auto Const
GlobalVariable Property SleepMaxPoints Auto Const
GlobalVariable Property SleepMaxPointsBonus Auto Const

GlobalVariable Property ThirstTime Auto Const
GlobalVariable Property ThirstDMGPoints Auto Const
GlobalVariable Property ThirstLowestPoints Auto Const
GlobalVariable Property ThirstMaxPoints Auto Const
GlobalVariable Property ThirstMaxPointsBonus Auto Const

GlobalVariable Property FoodPointsLow Auto Const
GlobalVariable Property FoodPointsMedium Auto Const
GlobalVariable Property FoodPointsHigh Auto Const
GlobalVariable Property FoodPointsLegendary Auto Const

GlobalVariable Property FoodPointsLowOversatiation Auto Const
GlobalVariable Property FoodPointsMediumOversatiation Auto Const
GlobalVariable Property FoodPointsHighOversatiation Auto Const
GlobalVariable Property FoodPointsLegendaryOversatiation Auto Const

GlobalVariable Property DrinkPointsLow Auto Const
GlobalVariable Property DrinkPointsMedium Auto Const
GlobalVariable Property DrinkPointsHigh Auto Const
GlobalVariable Property DrinkPointsSpecial Auto Const
GlobalVariable Property DrinkPointsSpecialEnergy Auto Const

GlobalVariable Property DrinkAlcPointsLow Auto Const
GlobalVariable Property DrinkAlcPointsHigh Auto Const
GlobalVariable Property DrinkAlcPointsSpecialThirst Auto Const
GlobalVariable Property DrinkAlcPointsSpecialFatigue Auto Const

GlobalVariable Property ChemsPointsLow Auto Const
GlobalVariable Property ChemsPointsMedium Auto Const
GlobalVariable Property ChemsPointsHigh Auto Const

GlobalVariable Property BlackoutDuration Auto Const

GlobalVariable Property SurvivalToggler Auto Const

GlobalVariable Property AdrenalineMax Auto Const
GlobalVariable Property AdrenalineTimer Auto Const

GlobalVariable Property AdrenalineCountNotifier Auto Const
GlobalVariable Property NeedsCheckerNotifier Auto Const
GlobalVariable Property NeedsCheckerAfterConsumptionNotifier Auto Const
GlobalVariable Property OversatiationCheckerNotifier Auto Const
GlobalVariable Property OversatiationStarter Auto Const

GlobalVariable Property OversatiationLowestPoints Auto Const

GlobalVariable Property AfflictionCureTimer Auto Const
GlobalVariable Property AfflictionCureTimerBandages Auto Const
GlobalVariable Property AddictionCureTimerJunkFlush Auto Const

GlobalVariable Property SleepStartTime Auto
GlobalVariable Property SleepStopTime Auto
GlobalVariable Property SleepTOTALTime Auto

MagicEffect Property FoodLowGrade Auto Const
MagicEffect Property FoodMediumGrade Auto Const
MagicEffect Property FoodHighGrade Auto Const
MagicEffect Property FoodLegendaryGrade Auto Const

MagicEffect Property DrinkLowGrade Auto Const
MagicEffect Property DrinkMediumGrade Auto Const
MagicEffect Property DrinkHighGrade Auto Const
MagicEffect Property DrinkEnergy Auto Const

MagicEffect Property DrinkAlcoholLowGrade Auto Const
MagicEffect Property DrinkAlcoholHighGrade Auto Const
MagicEffect Property DrinkAlcoholSpecial Auto Const

MagicEffect Property ChemsLowGrade Auto Const
MagicEffect Property ChemsMediumGrade Auto Const
MagicEffect Property ChemsHighGrade Auto Const

MagicEffect Property AddictionSuppressantCheck Auto Const
MagicEffect Property CaffeinophagiaCheck Auto Const

MagicEffect Property AffCureAnalgesicPoultice Auto Const
MagicEffect Property AffCureAntibioticInjector Auto Const
MagicEffect Property AffCureAntibioticPaste Auto Const
MagicEffect Property AffCureAntibioticPasteResearch Auto Const
MagicEffect Property AffCureAntibiotics Auto Const
MagicEffect Property AffCureAntibioticsCoctail Auto Const
MagicEffect Property AffCureBandages Auto Const
MagicEffect Property AffCureBandagesInfused Auto Const
MagicEffect Property AffCureBandagesZipper Auto Const
MagicEffect Property AffCureEmergencyKit Auto Const
MagicEffect Property AffCureHealGel Auto Const
MagicEffect Property AffCureHealPaste Auto Const
MagicEffect Property AffCureImmobilizer Auto Const
MagicEffect Property AffCureImmobilizerAnchored Auto Const
MagicEffect Property AffCureImmobilizerRepairing Auto Const
MagicEffect Property AffCureImmobilizerRepairingResearch Auto Const
MagicEffect Property AffCureInjector Auto Const
MagicEffect Property AffCureInjectorBoosted Auto Const
MagicEffect Property AffCureMedpack Auto Const
MagicEffect Property AffCurePanacea Auto Const
MagicEffect Property AffCurePanaceaResearch Auto Const
MagicEffect Property AffCurePenicillinX Auto Const
MagicEffect Property AffCureSnakeOil Auto Const
MagicEffect Property AffCureTraumaPack Auto Const
MagicEffect Property AddictionCureJunkFlush Auto Const

Message Property InitializeMSG Auto Const
Message Property StarvivalEnabled Auto Const
Message Property StarvivalRemoved Auto Const

Message Property NeedsAllChecker Auto Const
Message Property NeedsAllCheckerBox Auto Const

Message Property AdrenalineCount Auto Const

wwiseevent Property NeedsNotification Auto Const
wwiseevent Property NeedsNotification02 Auto Const

bool AddichroneOnPlayer = false
bool IntroductionEnabled = false


Event OnQuestInit()

      RegisterForPlayerSleep()
      RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

EndEvent

Function IntroductoryMessage()

         Utility.Wait(3.0)
		 int button = -1
		 button = InitializeMSG.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	     If (button == 0)
                
            StartSurvivalSystems()
            IntroductionEnabled = True

	 ElseIf (button == 1)
            PlayerRef.Additem(StarvivalGuide, 1, False)
            IntroductionEnabled = True
	  EndIf

EndFunction

Function StartSurvivalSystems()

                  SurvivalPoints()
                  SurvivalLetsGo()
                  PlayerRef.Additem(StarvivalGuide, 1, False)
                  PlayerRef.Additem(SatiationChecker, 1, False)
                  SurvivalToggler.SetValue(1) 
                  Utility.Wait(1.0)
                  MainPerksAdder()

                  RegisterForPlayerSleep()
                  RegisterForPlayerWait()
                  RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)
                  
EndFunction

Function StarvivalNeedsDisable()

                   SurvivalToggler.SetValue(0) 
                   PlayerRef.RemovePerk(SurvivalStart)
                   PlayerRef.Addperk(SurvivalLogosOff, False) 
                   PlayerRef.Removeitem(SatiationChecker, 1, True, None)
                   SurvivalPointsRestoreOnDeactivate()

                   UnregisterForPlayerSleep()
                   UnregisterForPlayerWait()
                   UnRegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
                   UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)

                   PlayerRef.Removeperk(SurvivalLogosOff) 

                   CancelTimer(0)
                   CancelTimer(2)
                   CancelTimer(3)
                   CancelTimer(4)

EndFunction

Function StarvivalNeedsEnable()

                  SurvivalToggler.SetValue(1)
                  SurvivalPoints()
                  SurvivalLetsGo()

                  Utility.Wait(1.0)
                  MainPerksAdder()
                  PlayerRef.Additem(SatiationChecker, 1, False)
                  RegisterForPlayerSleep()
                  RegisterForPlayerWait()
                  RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)

EndFunction

Function NeedsFullReset()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         PlayerRef.Removeitem(SatiationChecker, 999, True, None)
         PlayerRef.RemovePerk(SurvivalStart) 
         PlayerRef.Addperk(SurvivalLogosOff, False) 

	     Utility.Wait(1.0)
         SurvivalLetsStop()     

	     Utility.Wait(1.0)
         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         Utility.Wait(1.0)         
	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

         Utility.Wait(1.0)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)

	     Utility.Wait(1.0)
         PlayerRef.Additem(SatiationChecker, 1, False)
         PlayerRef.Addperk(SurvivalLogos, False)  

         Utility.Wait(1.0)
         PlayerRef.Removeperk(SurvivalLogos) 
         PlayerRef.Removeperk(SurvivalLogosOff) 
         PlayerRef.Addperk(SurvivalStart, False) 

	     Utility.Wait(1.0)
         SurvivalLetsGo()
         SatiationChecker()

EndFunction

Function MainPerksAdder()

          If SurvivalToggler.GetValue() == 1
             PlayerRef.Addperk(SurvivalLogos, False) 
             Utility.Wait(1.0)
             PlayerRef.Removeperk(SurvivalLogos) 
       EndIf

     PlayerRef.Addperk(SurvivalStart, False) 
     PlayerRef.Addperk(SurvivalAdrenaline, False) 

EndFunction

Event Actor.OnPlayerLoadGame(Actor akSender)

      RegisterForPlayerSleep()
      RegisterForPlayerWait()

EndEvent

Function SurvivalPoints()

         Float HungerPointsPool = HungerMaxPoints.GetValue()
		 Float SleepPointsPool = SleepMaxPoints.GetValue()
		 Float ThirstPointsPool = ThirstMaxPoints.GetValue()
		 Float OversatiationPointsPool = OversatiationMaxPoints.GetValue()

	     PlayerRef.SetValue(Hunger, HungerPointsPool)
	     PlayerRef.SetValue(Sleep, SleepPointsPool)
	     PlayerRef.SetValue(Thirst, ThirstPointsPool)
	     PlayerRef.SetValue(Oversatiation, OversatiationPointsPool)

         Utility.Wait(1.0)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)

         Utility.Wait(1.0)
         SatiationChecker()

EndFunction

Function SurvivalPointsRestoreOnDeactivate()

	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

EndFunction

Function SurvivalLetsGo()

         Float HungerStart = HungerTime.GetValue()
         Float SleepStart = SleepTime.GetValue()
         Float ThirstStart = ThirstTime.GetValue()

         StartTimer(HungerStart, 2)
         StartTimer(SleepStart, 3)
         StartTimer(ThirstStart, 4)

EndFunction

Function SurvivalLetsStop()

         CancelTimer(0)
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)

EndFunction

float Function GetCurrentHourOfDay() 
 
	float Time = Utility.GetCurrentRealTime()
	Return Time
 
EndFunction

Event OnPlayerWaitStart(float afWaitStartTime, float afDesiredWaitEndTime)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

EndEvent

Event OnPlayerWaitStop(bool abInterrupted)

	     Float EndingSleep = GetCurrentHourOfDay()
	     SleepStopTime.SetValue(EndingSleep)

      If SurvivalToggler.GetValue() == 1 
         NeedsAfterWait()
         NeedsThresholdsChecks()
   EndIf

EndEvent

Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

    If PlayerRef.HasMagicEffect(AddictionSuppressantCheck) == True
       AddichroneOnPlayer = True    
	EndIf

EndEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)


	          Float EndingSleep = GetCurrentHourOfDay()
	          SleepStopTime.SetValue(EndingSleep)
	
              Float RestoreOversatiationPoints = PlayerRef.Getvalue(Oversatiation)

                 If PlayerRef.HasPerk(SurvivalAdrenalineAftermath) == True
                    PlayerRef.RemovePerk(SurvivalAdrenalineAftermath)
              EndIf

              AddichroneOnPlayer = False 

        If SurvivalToggler.GetValue() == 1 
           NeedsAfterSleep()
           NeedsThresholdsChecks()

		         If OversatiationStarter.GetValue() == 1
                    PlayerRef.damagevalue(Oversatiation, RestoreOversatiationPoints)
              EndIf
     EndIf

        If IntroductionEnabled == False
		   IntroductoryMessage()
     EndIf

EndEvent

Function NeedsAfterSleep()

	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged01)

         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged02)

         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70

                PlayerRef.DamageValue(Hunger, HungerDamaged03)

         ElseIf FoodHungerCheck < 40

                PlayerRef.DamageValue(Hunger, HungerDamaged04)

          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)

         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)

         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70

                PlayerRef.DamageValue(Thirst, ThirstDamaged03)

         ElseIf DrinkThirstCheck < 40

                PlayerRef.DamageValue(Thirst, ThirstDamaged04)

          EndIf

     If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && AddichroneOnPlayer == False

        ;Empty

	 Else
		
		Int SleepRestored01 = (SleepTOTALTime.GetValue() as Int)*6
		Int SleepRestored02 = (SleepTOTALTime.GetValue() as Int)*8
		Int SleepRestored03 = (SleepTOTALTime.GetValue() as Int)*10
		Int SleepRestored04 = (SleepTOTALTime.GetValue() as Int)*14
 
             If SleepFatigueCheck >= 90

	            PlayerRef.RestoreValue(Sleep, SleepRestored01)

         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90

	            PlayerRef.RestoreValue(Sleep, SleepRestored02)

         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70

                PlayerRef.RestoreValue(Sleep, SleepRestored03)

         ElseIf SleepFatigueCheck < 40

                PlayerRef.RestoreValue(Sleep, SleepRestored04)

          EndIf
	 EndIf

        If HoursYouHaveSlept >= 7
           PlayerRef.Additem(WellRestedToken, 1, True)
     EndIf
	 
EndFunction

Function NeedsAfterWait()
       
	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged01)

         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged02)

         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70

                PlayerRef.DamageValue(Hunger, HungerDamaged03)

         ElseIf FoodHungerCheck < 40

                PlayerRef.DamageValue(Hunger, HungerDamaged04)

          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)

         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)

         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70

                PlayerRef.DamageValue(Thirst, ThirstDamaged03)

         ElseIf DrinkThirstCheck < 40

                PlayerRef.DamageValue(Thirst, ThirstDamaged04)

          EndIf
		
		Int SleepDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int SleepDamaged02 = (SleepTOTALTime.GetValue() as Int)*5
		Int SleepDamaged03 = (SleepTOTALTime.GetValue() as Int)*7
		Int SleepDamaged04 = (SleepTOTALTime.GetValue() as Int)*9
 
             If SleepFatigueCheck >= 90

	            PlayerRef.DamageValue(Sleep, SleepDamaged01)

         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90

	            PlayerRef.DamageValue(Sleep, SleepDamaged02)

         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70

                PlayerRef.DamageValue(Sleep, SleepDamaged03)

         ElseIf SleepFatigueCheck < 40

                PlayerRef.DamageValue(Sleep, SleepDamaged04)

          EndIf

EndFunction

Function NeedsThresholdsChecksTimered()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Function NeedsThresholdsAfterConsumption()

		 Float OversatiationPool = OversatiationMaxPointsBonus.GetValue()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 

		 Float HungerPointsPoolBonus = HungerMaxPointsBonus.GetValue()
		 Float ThirstPointsPoolBonus = ThirstMaxPointsBonus.GetValue()
		 Float SleepPointsPoolBonus = SleepMaxPointsBonus.GetValue()

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) > SleepPointsPoolBonus
            PlayerRef.SetValue(Sleep, SleepPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Thirst) > ThirstPointsPoolBonus
            PlayerRef.SetValue(Thirst, ThirstPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Hunger) > HungerPointsPoolBonus
            PlayerRef.SetValue(Hunger, HungerPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Oversatiation) >= OversatiationPool
            PlayerRef.SetValue(Oversatiation, OversatiationPool)
            PlayerRef.Addperk(OversatiationDebuff, False)
      EndIf

      NeedsAfterConsumptionStatusChecker()

EndFunction

Function NeedsThresholdsChecks()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep)
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         If PlayerRef.GetValue(Hunger) <= HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) <= ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) <= SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

		 If OversatiationStarter.GetValue() == 1
                     If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
                        PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
                  EndIf
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Event OnMagicEffectApply(ObjectReference akTarget, ObjectReference akCaster, MagicEffect akEffect)

		   Float FoodLow = FoodPointsLow.GetValue()
		   Float FoodLowWithPerk = FoodPointsLow.GetValue() * 2
		   Float FoodMedium = FoodPointsMedium.GetValue()
		   Float FoodMediumWithPerk = FoodPointsMedium.GetValue() * 2
		   Float FoodHigh = FoodPointsHigh.GetValue()
		   Float FoodHighWithPerk = FoodPointsHigh.GetValue() * 2
 		   Float FoodLegendary = FoodPointsLegendary.GetValue()
 		   Float FoodLegendaryWithPerk = FoodPointsLegendary.GetValue() * 2

		   Float OversatiationLow = FoodPointsLowOversatiation.GetValue()
		   Float OversatiationLowWithPerk = FoodPointsLowOversatiation.GetValue() / 2
		   Float OversatiationMedium = FoodPointsMediumOversatiation.GetValue()
		   Float OversatiationMediumWithPerk = FoodPointsMediumOversatiation.GetValue() / 2
		   Float OversatiationHigh = FoodPointsHighOversatiation.GetValue()
		   Float OversatiationHighWithPerk = FoodPointsHighOversatiation.GetValue() / 2
 		   Float OversatiationLegendary = FoodPointsLegendaryOversatiation.GetValue()
 		   Float OversatiationLegendaryWithPerk = FoodPointsLegendaryOversatiation.GetValue() / 2

		   Float DrinkLow = DrinkPointsLow.GetValue()
		   Float DrinkLowWithPerk = DrinkPointsLow.GetValue() * 2
		   Float DrinkMedium = DrinkPointsMedium.GetValue()
		   Float DrinkMediumWithPerk = DrinkPointsMedium.GetValue() * 2
		   Float DrinkHigh = DrinkPointsHigh.GetValue()
		   Float DrinkHighWithPerk = DrinkPointsHigh.GetValue() * 2
		   Float DrinkSpecial = DrinkPointsSpecial.GetValue()
		   Float DrinkSpecialWithPerk = DrinkPointsSpecial.GetValue() * 2
		   Float DrinkSpecialEnergy = DrinkPointsSpecialEnergy.GetValue()
		   Float DrinkSpecialEnergyWithPerk = DrinkPointsSpecialEnergy.GetValue() * 2

		   Float DrinkAlcLow = DrinkAlcPointsLow.GetValue()
		   Float DrinkAlcLowWithPerk = DrinkAlcPointsLow.GetValue() / 2
		   Float DrinkAlcHigh = DrinkAlcPointsHigh.GetValue()
		   Float DrinkAlcHighWithPerk = DrinkAlcPointsHigh.GetValue() / 2
		   Float DrinkAlcSpecialThirst = DrinkAlcPointsSpecialThirst.GetValue()
		   Float DrinkAlcSpecialThirstWithPerk = DrinkAlcPointsSpecialThirst.GetValue() / 2
		   Float DrinkAlcSpecialFatigue = DrinkAlcPointsSpecialFatigue.GetValue()
		   Float DrinkAlcSpecialFatigueWithPerk = DrinkAlcPointsSpecialFatigue.GetValue() * 2

		   Float ChemsLow = ChemsPointsLow.GetValue()
		   Float ChemsMedium = ChemsPointsMedium.GetValue()
		   Float ChemsHigh = ChemsPointsHigh.GetValue()

    If SurvivalToggler.GetValue() == 1 
		   If (akTarget == PlayerRef as ObjectReference && akEffect == FoodLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodLowGrade, True)
			 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Hunger, FoodLowWithPerk)
                    Else
					       PlayerRef.RestoreValue(Hunger, FoodLow)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLowWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLow)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodMediumGrade, True)
				 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Hunger, FoodMediumWithPerk)
                    Else
					       PlayerRef.RestoreValue(Hunger, FoodMedium)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationMediumWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationMedium)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodHighGrade, True)
				 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Hunger, FoodHighWithPerk)
                    Else
					       PlayerRef.RestoreValue(Hunger, FoodHigh)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodLegendaryGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodLegendaryGrade, True)
  					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Hunger, FoodLegendaryWithPerk)
                    Else
					       PlayerRef.RestoreValue(Hunger, FoodLegendary)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLegendaryWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLegendary)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkLowGrade, True)
				 			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkLowWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkLow)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLowWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLow)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkMediumGrade, True)
			 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkMediumWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkMedium)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationMediumWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationMedium)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkHighGrade, True)
					 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkHighWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkHigh)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkEnergy)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkEnergy, True)
				 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkSpecialWithPerk)	 
					       PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergyWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkSpecial)	 
					       PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergy)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholLowGrade, True)
			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, DrinkAlcLowWithPerk)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcLowWithPerk)
                    Else
					       PlayerRef.DamageValue(Thirst, DrinkAlcLow)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcLow)
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholHighGrade, True)
			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, DrinkAlcHighWithPerk)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcHighWithPerk)
                    Else
					       PlayerRef.DamageValue(Thirst, DrinkAlcHigh)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcHigh)
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholSpecial)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholSpecial, True)
 			
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigueWithPerk)
					       PlayerRef.DamageValue(Thirst, DrinkAlcSpecialThirstWithPerk)
                    Else
					       PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigue)
					       PlayerRef.DamageValue(Thirst, DrinkAlcSpecialThirst)
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsLowGrade, True)
			 
					 PlayerRef.DamageValue(Thirst, ChemsLow)			 
					 PlayerRef.DamageValue(Hunger, ChemsLow)
					 PlayerRef.DamageValue(Sleep, ChemsLow)

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsMediumGrade, True)
				 
					 PlayerRef.DamageValue(Thirst, ChemsMedium)			 
					 PlayerRef.DamageValue(Hunger, ChemsMedium) 
					 PlayerRef.DamageValue(Sleep, ChemsMedium)

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsHighGrade, True)
 					 
					 PlayerRef.DamageValue(Thirst, ChemsHigh)			 
					 PlayerRef.DamageValue(Hunger, ChemsHigh)		 
					 PlayerRef.DamageValue(Sleep, ChemsHigh)
        
	    EndIf

        NeedsThresholdsAfterConsumption()
EndIf
EndEvent

Function NeedsAfterConsumptionStatusChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()

        If NeedsCheckerAfterConsumptionNotifier.GetValue() == 1

             If DrinkThirstCheck > 75 || FoodHungerCheck > 75 || SleepFatigueCheck > 75
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

         ElseIf DrinkThirstCheck > 50 || FoodHungerCheck > 50 || SleepFatigueCheck > 50
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

         ElseIf DrinkThirstCheck > 35 || FoodHungerCheck > 35 || SleepFatigueCheck > 35
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)

         ElseIf DrinkThirstCheck > 20 || FoodHungerCheck > 20 || SleepFatigueCheck > 20
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)
          EndIf	
     EndIf

EndFunction

Function NeedsAfterEachCycleChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()

        If NeedsCheckerNotifier.GetValue() == 1

             If DrinkThirstCheck <= 75 || FoodHungerCheck <= 75 || SleepFatigueCheck <= 75
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

         ElseIf DrinkThirstCheck <= 50 || FoodHungerCheck <= 50 || SleepFatigueCheck <= 50
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

         ElseIf DrinkThirstCheck <= 35 || FoodHungerCheck <= 35 || SleepFatigueCheck <= 35
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)

         ElseIf DrinkThirstCheck <= 20 || FoodHungerCheck <= 20 || SleepFatigueCheck <= 20
                Utility.Wait(0.1)
                NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)
          EndIf
     EndIf

EndFunction

Function NeedsAfterEachCycleCheckerBox()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()

           NeedsAllCheckerBox.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

EndFunction

Event OnTimer(int aiTimerID)
	 
	  	     Float HungerDamage = HungerDMGPoints.GetValue()
 			 Float SleepDamage = SleepDMGPoints.GetValue()
 			 Float ThirstDamage = ThirstDMGPoints.GetValue()
	         Float HungerStart = HungerTime.GetValue()
             Float SleepStart = SleepTime.GetValue()
             Float ThirstStart = ThirstTime.GetValue()
	 
             Float BlackoutTimer = BlackoutDuration.GetValue()
             Float Timer = AdrenalineTimer.GetValue()
 
     	     If (aiTimerID == 0)       

                   If PlayerRef.GetValue(Sleep) > 35
                      CancelTimer(0)
                Else
				      PlayerRef.EquipItem(Blackout, 1, True)
                      StartTimer(BlackoutTimer, 0)
				EndIf

      	 ElseIf (aiTimerID == 1)       

                   If PlayerRef.GetItemCount(AdrenalineToken) >= 1 
                      PlayerRef.RemoveItem(AdrenalineToken, 1, True, None)
                      StartTimer(Timer, 1)
                      AdrenalineStatusChecker()
                EndIf

      	 ElseIf (aiTimerID == 2)       

                PlayerRef.DamageValue(Hunger, HungerDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(HungerStart, 2)

      	 ElseIf (aiTimerID == 3)       

                PlayerRef.DamageValue(Sleep, SleepDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(SleepStart, 3)

      	 ElseIf (aiTimerID == 4)       

                PlayerRef.DamageValue(Thirst, ThirstDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(ThirstStart, 4)

      	 ElseIf (aiTimerID == 10)       

                PlayerRef.EquipItem(AffPotionAnalgesicPoultice, 1, True)

      	 ElseIf (aiTimerID == 11)       

                PlayerRef.EquipItem(AffPotionAntibioticInjector, 1, True)

      	 ElseIf (aiTimerID == 12)       

                PlayerRef.EquipItem(AffPotionAntibioticPaste, 1, True)

      	 ElseIf (aiTimerID == 13)       

                PlayerRef.EquipItem(AffPotionAntibioticPasteResearch, 1, True)

      	 ElseIf (aiTimerID == 14)       

                PlayerRef.EquipItem(AffPotionAntibiotics, 1, True)

      	 ElseIf (aiTimerID == 15)       

                PlayerRef.EquipItem(AffPotionAntibioticsCoctail, 1, True)

      	 ElseIf (aiTimerID == 16)       

                PlayerRef.EquipItem(AffPotionBandages, 1, True)

      	 ElseIf (aiTimerID == 17)       

                PlayerRef.EquipItem(AffPotionBandagesInfused, 1, True)

      	 ElseIf (aiTimerID == 18)       

                PlayerRef.EquipItem(AffPotionBandagesZipper, 1, True)

      	 ElseIf (aiTimerID == 19)       

                PlayerRef.EquipItem(AffPotionEmergencyKit, 1, True)

      	 ElseIf (aiTimerID == 20)       

                PlayerRef.EquipItem(AffPotionHealGel, 1, True)

      	 ElseIf (aiTimerID == 21)       

                PlayerRef.EquipItem(AffPotionHealPaste, 1, True)

      	 ElseIf (aiTimerID == 22)       

                PlayerRef.EquipItem(AffPotionImmobilizer, 1, True)

      	 ElseIf (aiTimerID == 23)       

                PlayerRef.EquipItem(AffPotionImmobilizerAnchored, 1, True)

      	 ElseIf (aiTimerID == 24)       

                PlayerRef.EquipItem(AffPotionImmobilizerRepairing, 1, True)

      	 ElseIf (aiTimerID == 25)       

                PlayerRef.EquipItem(AffPotionImmobilizerRepairingResearch, 1, True)

      	 ElseIf (aiTimerID == 26)       

                PlayerRef.EquipItem(AffPotionInjector, 1, True)

      	 ElseIf (aiTimerID == 27)       

                PlayerRef.EquipItem(AffPotionInjectorBoosted, 1, True)

      	 ElseIf (aiTimerID == 28)       

                PlayerRef.EquipItem(AffPotionMedpack, 1, True)

      	 ElseIf (aiTimerID == 29)       

                PlayerRef.EquipItem(AffPotionPanacea, 1, True)

      	 ElseIf (aiTimerID == 30)       

                PlayerRef.EquipItem(AffPotionPanaceaResearch, 1, True)

      	 ElseIf (aiTimerID == 31)       

                PlayerRef.EquipItem(AffPotionPenicillinX, 1, True)

      	 ElseIf (aiTimerID == 32)       

                PlayerRef.EquipItem(AffPotionSnakeOil, 1, True)

      	 ElseIf (aiTimerID == 33)       

                PlayerRef.EquipItem(AffPotionTraumaPack, 1, True)

      	 ElseIf (aiTimerID == 34)       

                PlayerRef.EquipItem(AddPotionCureJunkFlush, 1, True)

          EndIf
	  
EndEvent

Function Adrenaline()

                Float Max = AdrenalineMax.GetValue()
                Float Timer = AdrenalineTimer.GetValue()

                PlayerRef.Additem(AdrenalineToken, 1, True)

                   If PlayerRef.GetItemCount(AdrenalineToken) >= Max
                      PlayerRef.AddPerk(SurvivalAdrenalineBuff, False)
                      PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
			    EndIf
                AdrenalineStatusChecker()
                StartTimer(Timer, 1)


EndFunction

Function AdrenalineStatusChecker()

           Float Max = AdrenalineMax.GetValue()
           Float Count = PlayerRef.GetItemCount(AdrenalineToken)

        If AdrenalineCountNotifier.GetValue() == 1

           Utility.Wait(0.1)
           AdrenalineCount.show(Count, Max, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

     EndIf

EndFunction

Function Blackout()

                StartTimer(0, 0)

EndFunction

Function SatiationChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()

           Utility.Wait(0.1)
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)

EndFunction

Function SatiationCheckerBox()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()

           Utility.Wait(0.1)
           NeedsAllCheckerBox.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, afArg9 = 0.0)	

           PlayerRef.Additem(SatiationChecker, 1, True)

EndFunction

Function AfflictionCure()

        Float CureTimer = AfflictionCureTimer.Getvalue()
        Float CureTimerBandages = AfflictionCureTimerBandages.Getvalue()
        Float CureTimerJunkFlush = AddictionCureTimerJunkFlush.Getvalue()

        If PlayerRef.HasMagicEffect(AffCureAnalgesicPoultice) == True         
	       StartTimer(CureTimer, 10)	 
	 EndIf	 

        If PlayerRef.HasMagicEffect(AffCureAntibioticInjector) == True         
	       StartTimer(CureTimer, 11)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticPaste) == True         
	       StartTimer(CureTimer, 12)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticPasteResearch) == True         
	       StartTimer(CureTimer, 13)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibiotics) == True         
	       StartTimer(CureTimer, 14)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticsCoctail) == True         
	       StartTimer(CureTimer, 15)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandages) == True         
	       StartTimer(CureTimerBandages, 16)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandagesInfused) == True         
	       StartTimer(CureTimerBandages, 17)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandagesZipper) == True         
	       StartTimer(CureTimerBandages, 18)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureEmergencyKit) == True         
	       StartTimer(CureTimer, 19)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureHealGel) == True         
	       StartTimer(CureTimer, 20)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureHealPaste) == True         
	       StartTimer(CureTimer, 21)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizer) == True         
	       StartTimer(CureTimer, 22)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerAnchored) == True         
	       StartTimer(CureTimer, 23)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerRepairing) == True         
	       StartTimer(CureTimer, 24)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerRepairingResearch) == True         
	       StartTimer(CureTimer, 25)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureInjector) == True         
	       StartTimer(CureTimer, 26)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureInjectorBoosted) == True         
	       StartTimer(CureTimer, 27)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureMedpack) == True         
	       StartTimer(CureTimer, 28)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePanacea) == True         
	       StartTimer(CureTimer, 29)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePanaceaResearch) == True         
	       StartTimer(CureTimer, 30)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePenicillinX) == True         
	       StartTimer(CureTimer, 31)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureSnakeOil) == True         
	       StartTimer(CureTimer, 32)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureTraumaPack) == True         
	       StartTimer(CureTimer, 33)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AddictionCureJunkFlush) == True         
	       StartTimer(CureTimerJunkFlush, 34)	 
	 EndIf	

EndFunction