ScriptName SML_SleepQuestScript Extends Quest

;-- Variables ---------------------------------------
; Int iOneHourTimerID = 1 Const
; Int iDroppingItemIntoWorld = 3 Const
; String EatSleepDrinkVer = "0.1.1" Const ; why is this an unresolved identifier? todo, this would be convenient. make it work
String EatSleepDrinkESM = "SML_EatSleepDrink.esm" Const
String StarfieldESM = "Starfield.esm" Const
Float UpkeepPeriod = 1.0 Const ; how many many real world hours there needs to be upkeep 

Int InjurySpell_FID = 0x00000829 Const ; the injury spell to apply if upkeep is not maintained
Int PrognosisAV_FID = 0x00000827 Const ; the current prognosis/status
Int LastUpkeepAV_FID = 0x00000828 Const ; upkeep actor value to track if the player is eating/sleeping/drinking, etc. keeping up with the timer
; For sleep there's nothing to equip/consume and sleeping doesn't have a keyword, it has its own event
; Int UpkeepItemKYWD_FID = 0x0014253C Const ; What item counts for the upkeep (from Starfield.esm), ie. InventoryCategoryAidFood KYWD: 00055ECC
; for drink: VendorDrink [KYWD:0014253C]
; for food: VendorFood [KYWD:00022CE6]
; both food and drink: InventoryCategoryAidFood KYWD: 00055ECC

;-- Properties --------------------------------------
; Int Property StageToSet Auto Const

;-- Functions ---------------------------------------

Event OnQuestInit()
  ; Debug.Trace("[SML_ThirstQuestScript] **** ON QUEST INIT ****", 0)
    ; Start the injurty check timer if the esm is installed
    If Game.IsPluginInstalled(EatSleepDrinkESM) == True
      ; this probably isn't the right place because it will only be once.
      ; OnPlayerLoadGame() is better but only because the quest was already started before the rest of the script was finished
      ; it probably would be ok here normally, but it may be worth just keeping StartInuryCheckTimer with the load game event
      ; Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnItemEquipped")
      Self.RegisterForPlayerSleep()
      Self.StartInuryCheckTimer()
      Debug.Trace("[SML_ThirstQuestScript] Version 0.4.0", 0)

      ; Spell spInjury = Game.GetFormFromFile(InjurySpell_FID, EatSleepDrinkESM) as Spell
      ; Actor PlayerRef = Game.GetPlayer()
      ; PlayerRef.AddSpell(spInjury, true)

      Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
    Else
      ; Debug.MessageBox("Missing " + EatSleepDrinkESM + " - Hunger Quest will not work.") ; it's optional, so don't tell the player about it
      Debug.Trace("[SML_ThirstQuestScript] missing file " + EatSleepDrinkESM, 1)
    EndIf
EndEvent

Function Version() Global
  ; Debug.MessageBox("Eat Sleep Drink Script Version: " + EatSleepDrinkVer)
  Debug.MessageBox("Eat Sleep Drink (Survivability) Script Version: 0.4.0")
  ; TODO: figure out how to get the full name from keyword
  ; Keyword kwSML_EatSleepDrink_Version = Game.GetFormFromFile(0x0200081E, EatSleepDrinkESM)
EndFunction

Function DebugSleepDeprivation() global
  Spell spInjury = Game.GetFormFromFile(0x00000829, "SML_EatSleepDrink.esm") as Spell
  Actor PlayerRef = Game.GetPlayer()
  PlayerRef.AddSpell(spInjury, true)
EndFunction

; When the game loads, start the injury check timer
Event Actor.OnPlayerLoadGame(Actor akSender)
  ; Debug.Trace("[SML_ThirstQuestScript] **** ON PLAYER LOAD GAME ****", 0)
  ; Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnItemEquipped")
  Self.RegisterForPlayerSleep()
  Self.StartInuryCheckTimer()
EndEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)
  if abInterrupted
    ; Debug.Trace("[SML_ThirstQuestScript] Player was woken by something!")
  else
    Debug.Trace("[SML_ThirstQuestScript] Player woke up naturally", 0)
    
    ; Remove the spell from the player ref
    Spell spInjury = Game.GetFormFromFile(InjurySpell_FID, EatSleepDrinkESM) as Spell
    Actor PlayerRef = Game.GetPlayer()
    PlayerRef.RemoveSpell(spInjury)
    
    ; Set the last time the player ate to the real world hours passed and set sleep deprivation prognosis to zero
    ActorValue avLastUpkeep = Game.GetFormFromFile(LastUpkeepAV_FID, EatSleepDrinkESM) as ActorValue
    ActorValue avPrognosis = Game.GetFormFromFile(PrognosisAV_FID, EatSleepDrinkESM) as ActorValue
    PlayerRef.SetValue(avLastUpkeep, Game.GetRealHoursPassed())
    PlayerRef.SetValue(avPrognosis, 0.0)
  endIf
EndEvent

; Starts the injury check timer, by default it checks to apply sleep deprivation every 30 minutes
; see UpkeepPeriod for how long a player can go without eat/sleep/drink (in real life hours) before an injury spell is applied ; how many 
Function StartInuryCheckTimer(Float hours = 0.5)
  ; Debug.Trace("[SML_ThirstQuestScript] *** START TIMER ***", 0)
  Self.StartTimerGameTime(hours, 3)
EndFunction

; Handle the timer event
Event OnTimerGameTime(Int aiTimerID)
  ; Debug.Trace("[SML_ThirstQuestScript] *** TIMER CHECK ***", 0)
    If aiTimerID == 3 ; should be the timer id given to StartTimerGameTime() above, I assume scoped to this script
      ; Self.SetStage(StageToSet) ; not sure if quest stages will be used here
      ; Debug.Trace("timer passed", 0)

      ; Get the Actor Value Information object from the esm
      ActorValue avPrognosis = Game.GetFormFromFile(PrognosisAV_FID, EatSleepDrinkESM) as ActorValue
      ActorValue avLastUpkeep = Game.GetFormFromFile(LastUpkeepAV_FID, EatSleepDrinkESM) as ActorValue
      ; Get the sleep deprivation Spell from the esm
      Spell spInjury = Game.GetFormFromFile(InjurySpell_FID, EatSleepDrinkESM) as Spell

      ; Get the player ref
      Actor PlayerRef = Game.GetPlayer()
      ; current sleep deprivation actor value TBD if this is a changing prognosis or just a binary kinda thing - you're either starving or you're not
      Float mySleepDeprivation = PlayerRef.GetValue(avPrognosis)
      ; Debug.Trace("[SML_ThirstQuestScript] sleep deprivation value: " + mySleepDeprivation, 0)
      
      ; Check the last time the player ate compared to the current time (this is all based on real hours passed)
      Float currentRealHoursPassed = Game.GetRealHoursPassed()
      Float lastAte = PlayerRef.GetValue(avLastUpkeep)
      ; Debug.Trace("[SML_ThirstQuestScript] currentRealHoursPassed: " + currentRealHoursPassed, 0)
      ; Debug.Trace("[SML_ThirstQuestScript] lastAte: " + lastAte, 2)

      ; If the hour time difference is greater than the sleep deprivation period, apply sleep deprivation
      If currentRealHoursPassed - lastAte >= UpkeepPeriod
        ; Debug.Trace("[SML_ThirstQuestScript] it has been an hour or more since the player last ate", 0) ; how many 

        ; Set the actor value on the player ref for sleep deprivation prognosis
        PlayerRef.SetValue(avPrognosis, 1.0)
        ; Debug.Trace("[SML_ThirstQuestScript] sleep deprivation value is now: " + PlayerRef.GetValue(avPrognosis), 0)

        ; Add the spell to the player ref, this is what applies the sleep deprivation Spell object from the esm
        ; this includes showing in game ui the message about sleep deprivation under player status, drains health via the Magic Effect, etc.
        PlayerRef.AddSpell(spInjury, true)
      EndIf

      ; This will kick off the timer again because it's a one time thing and so this loops it
      ; Debug.Trace("[SML_ThirstQuestScript] OnTimerGameTime() - start timer again...", 0)
      Self.StartInuryCheckTimer()
    EndIf
EndEvent
  
