Scriptname SN_ConfigScript Extends ActiveMagicEffect

;============================================================ Base

Actor Property PlayerRef Auto

Form Property ConfigChem Auto

Perk Property EatStatusPerk Auto
Perk Property DrinkStatusPerk Auto
Perk Property SleepStatusPerk Auto

Form Property SignalChem_ConfigEnd Auto

;============================================================ Messages

Message Property ConfigMsg Auto

Message Property ConfigEatMsg Auto
Message Property ConfigDrinkMsg Auto
Message Property ConfigSleepMsg Auto
Message Property ConfigFoodEfficiencyMsg Auto

Message Property ConfigEatBuffDurMsg Auto
Message Property ConfigEatDebuffDurMsg Auto
Message Property ConfigEatDeathMsg Auto
Message Property ConfigEatBuffMagMsg Auto
Message Property ConfigEatDebuffMagMsg Auto
Message Property ConfigEatAlertFilterMsg Auto

Message Property ConfigDrinkBuffDurMsg Auto
Message Property ConfigDrinkDebuffDurMsg Auto
Message Property ConfigDrinkDeathMsg Auto
Message Property ConfigDrinkBuffMagMsg Auto
Message Property ConfigDrinkDebuffMagMsg Auto
Message Property ConfigDrinkAlertFilterMsg Auto

Message Property ConfigSleepBuffDurMsg Auto
Message Property ConfigSleepDebuffDurMsg Auto
Message Property ConfigSleepDeathMsg Auto
Message Property ConfigSleepBuffMagMsg Auto
Message Property ConfigSleepDebuffMagMsg Auto
Message Property ConfigSleepAlertFilterMsg Auto

;============================================================ Buff Curves

GlobalVariable Property EatBuffHoursToZero_Halfed Auto
GlobalVariable Property EatBuffHoursToZero Auto
GlobalVariable Property EatDebuffHoursToMax_Halfed Auto
GlobalVariable Property EatDebuffHoursToMax Auto
GlobalVariable Property EatDebuffHoursToDeath Auto

GlobalVariable Property DrinkBuffHoursToZero_Halfed Auto
GlobalVariable Property DrinkBuffHoursToZero Auto
GlobalVariable Property DrinkDebuffHoursToMax_Halfed Auto
GlobalVariable Property DrinkDebuffHoursToMax Auto
GlobalVariable Property DrinkDebuffHoursToDeath Auto

GlobalVariable Property SleepBuffHoursToZero_Halfed Auto
GlobalVariable Property SleepBuffHoursToZero Auto
GlobalVariable Property SleepDebuffHoursToMax_Halfed Auto
GlobalVariable Property SleepDebuffHoursToMax Auto
GlobalVariable Property SleepDebuffHoursToDeath Auto

;============================================================ Buff Values

GlobalVariable Property EatBuffWeightMultMax Auto
GlobalVariable Property EatDebuffWeightMultMax Auto
ActorValue Property CurrentEatBuffMult Auto

GlobalVariable Property DrinkBuffO2MultMax Auto
GlobalVariable Property DrinkDebuffO2MultMax Auto
ActorValue Property CurrentDrinkBuffMult Auto

GlobalVariable Property SleepBuffXPMultMax Auto
GlobalVariable Property SleepDebuffXPMultMax Auto
ActorValue Property CurrentSleepBuffMult Auto

;============================================================ Efficiency

GlobalVariable Property FoodHoursBack_01_VerySmall Auto
GlobalVariable Property FoodHoursBack_02_Small Auto
GlobalVariable Property FoodHoursBack_03_Medium Auto
GlobalVariable Property FoodHoursBack_04_Large Auto
GlobalVariable Property FoodHoursBack_05_XLarge Auto
GlobalVariable Property FoodHoursBack_06_Huge Auto
GlobalVariable Property FoodHoursBack_07_XHuge Auto

;============================================================ Variables

GlobalVariable Property MainTimerInterval Auto

GlobalVariable Property EatSystemDisabled Auto
GlobalVariable Property DrinkSystemDisabled Auto
GlobalVariable Property SleepSystemDisabled Auto

GlobalVariable Property EatHUDAlertFilterLevel Auto
GlobalVariable Property DrinkHUDAlertFilterLevel Auto
GlobalVariable Property SleepHUDAlertFilterLevel Auto

GlobalVariable Property EnableRecoveryNotification Auto

GlobalVariable Property DisableEnvStress Auto

;============================================================ Launch

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  If akTarget == PlayerRef
    If afMagnitude == 0.0 && PlayerRef.GetItemCount(ConfigChem) == 0
      PlayerRef.AddItem(ConfigChem, 1, True)
    EndIf
    Self.Menu()
  EndIf
EndEvent


Function Menu(Int aiMsg = 0, Int aiBtn = 0, Bool abMenu = True)
  While abMenu
    If aiBtn == -1

    ;============================================== Root
    ElseIf aiMsg == 0
      aiBtn = ConfigMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

      If aiBtn == 0     ;Close this menu
        abMenu = False
      ElseIf aiBtn == 1 ;Eating settings
        aiMsg = 10
      ElseIf aiBtn == 2 ;Drinking settings
        aiMsg = 20
      ElseIf aiBtn == 3 ;Sleeping settings
        aiMsg = 30
      ElseIf aiBtn == 4 ;Food Efficiency
        aiMsg = 40
      ElseIf aiBtn == 5 ;Enable environmental stress
        DisableEnvStress.SetValue(0.0)
      ElseIf aiBtn == 6 ;Disable environmental stress
        DisableEnvStress.SetValue(1.0)
      ElseIf aiBtn == 7 ;Enable recovery notification
        EnableRecoveryNotification.SetValue(1.0)
      ElseIf aiBtn == 8 ;Disable recovery notification
        EnableRecoveryNotification.SetValue(0.0)
      EndIf

    ;============================================== Eating
    ElseIf aiMsg == 10
      aiBtn = ConfigEatMsg.Show(PlayerRef.GetValue(CurrentEatBuffMult), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;Buff duration
        aiMsg = 11
      ElseIf aiBtn == 2 ;Debuff maximization time
        aiMsg = 12
      ElseIf aiBtn == 3 ;Death time
        aiMsg = 13
      ElseIf aiBtn == 4 ;Buff magnification
        aiMsg = 14
      ElseIf aiBtn == 5 ;Debuff magnification
        aiMsg = 15
      ElseIf aiBtn == 6 ;Alert level
        aiMsg = 16
      ElseIf aiBtn == 7 ;Disable eating system
        aiMsg = 10
        EatSystemDisabled.SetValue(1.0)
        Debug.ExecuteConsole("player.removeperk " + Utility.IntToHex(EatStatusPerk.GetFormID()))
      ElseIf aiBtn == 8 ;Enable eating system
        aiMsg = 10
        EatSystemDisabled.SetValue(0.0)
        Debug.ExecuteConsole("player.addperk " + Utility.IntToHex(EatStatusPerk.GetFormID()))
      EndIf

    ;============================================== Drinking
    ElseIf aiMsg == 20
      aiBtn = ConfigDrinkMsg.Show(PlayerRef.GetValue(CurrentDrinkBuffMult), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;Buff duration
        aiMsg = 21
      ElseIf aiBtn == 2 ;Debuff maximization time
        aiMsg = 22
      ElseIf aiBtn == 3 ;Death time
        aiMsg = 23
      ElseIf aiBtn == 4 ;Buff magnification
        aiMsg = 24
      ElseIf aiBtn == 5 ;Debuff magnification
        aiMsg = 25
      ElseIf aiBtn == 6 ;Alert level
        aiMsg = 26
      ElseIf aiBtn == 7 ;Disable drinking system
        aiMsg = 20
        DrinkSystemDisabled.SetValue(1.0)
        Debug.ExecuteConsole("player.removeperk " + Utility.IntToHex(DrinkStatusPerk.GetFormID()))
      ElseIf aiBtn == 8 ;Enable drinking system
        aiMsg = 20
        DrinkSystemDisabled.SetValue(0.0)
        Debug.ExecuteConsole("player.addperk " + Utility.IntToHex(DrinkStatusPerk.GetFormID()))
      EndIf

    ;============================================== Sleeping
    ElseIf aiMsg == 30
      aiBtn = ConfigSleepMsg.Show(PlayerRef.GetValue(CurrentSleepBuffMult), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;Buff duration
        aiMsg = 31
      ElseIf aiBtn == 2 ;Debuff maximization time
        aiMsg = 32
      ElseIf aiBtn == 3 ;Death time
        aiMsg = 33
      ElseIf aiBtn == 4 ;Buff magnification
        aiMsg = 34
      ElseIf aiBtn == 5 ;Debuff magnification
        aiMsg = 35
      ElseIf aiBtn == 6 ;Alert level
        aiMsg = 36
      ElseIf aiBtn == 7 ;Disable sleeping system
        aiMsg = 30
        SleepSystemDisabled.SetValue(1.0)
        Debug.ExecuteConsole("player.removeperk " + Utility.IntToHex(SleepStatusPerk.GetFormID()))
      ElseIf aiBtn == 8 ;Enable sleeping system
        aiMsg = 30
        SleepSystemDisabled.SetValue(0.0)
        Debug.ExecuteConsole("player.addperk " + Utility.IntToHex(SleepStatusPerk.GetFormID()))
      EndIf

    ;============================================== Food Efficiency
    ElseIf aiMsg == 40
      aiBtn = ConfigFoodEfficiencyMsg.Show(FoodHoursBack_01_VerySmall.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 0
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;1.0x - Default
        FoodHoursBack_01_VerySmall.SetValue(1.0)
        FoodHoursBack_02_Small.SetValue(2.0)
        FoodHoursBack_03_Medium.SetValue(3.0)
        FoodHoursBack_04_Large.SetValue(5.0)
        FoodHoursBack_05_XLarge.SetValue(8.0)
        FoodHoursBack_06_Huge.SetValue(12.0)
        FoodHoursBack_07_XHuge.SetValue(18.0)
      ElseIf aiBtn == 2 ;1.5x
        FoodHoursBack_01_VerySmall.SetValue(1.5)
        FoodHoursBack_02_Small.SetValue(3.0)
        FoodHoursBack_03_Medium.SetValue(4.5)
        FoodHoursBack_04_Large.SetValue(7.5)
        FoodHoursBack_05_XLarge.SetValue(12.0)
        FoodHoursBack_06_Huge.SetValue(18.0)
        FoodHoursBack_07_XHuge.SetValue(27.0)
      ElseIf aiBtn == 3 ;2.0x
        FoodHoursBack_01_VerySmall.SetValue(2.0)
        FoodHoursBack_02_Small.SetValue(4.0)
        FoodHoursBack_03_Medium.SetValue(6.0)
        FoodHoursBack_04_Large.SetValue(10.0)
        FoodHoursBack_05_XLarge.SetValue(16.0)
        FoodHoursBack_06_Huge.SetValue(24.0)
        FoodHoursBack_07_XHuge.SetValue(36.0)
      ElseIf aiBtn == 4 ;3.0x - Author's choice
        FoodHoursBack_01_VerySmall.SetValue(3.0)
        FoodHoursBack_02_Small.SetValue(6.0)
        FoodHoursBack_03_Medium.SetValue(9.0)
        FoodHoursBack_04_Large.SetValue(10.0)
        FoodHoursBack_05_XLarge.SetValue(16.0)
        FoodHoursBack_06_Huge.SetValue(24.0)
        FoodHoursBack_07_XHuge.SetValue(36.0)
      ElseIf aiBtn == 5 ;5.0x
        FoodHoursBack_01_VerySmall.SetValue(5.0)
        FoodHoursBack_02_Small.SetValue(10.0)
        FoodHoursBack_03_Medium.SetValue(15.0)
        FoodHoursBack_04_Large.SetValue(25.0)
        FoodHoursBack_05_XLarge.SetValue(40.0)
        FoodHoursBack_06_Huge.SetValue(60.0)
        FoodHoursBack_07_XHuge.SetValue(90.0)
      ElseIf aiBtn == 6 ;10.0x
        FoodHoursBack_01_VerySmall.SetValue(10.0)
        FoodHoursBack_02_Small.SetValue(20.0)
        FoodHoursBack_03_Medium.SetValue(30.0)
        FoodHoursBack_04_Large.SetValue(50.0)
        FoodHoursBack_05_XLarge.SetValue(80.0)
        FoodHoursBack_06_Huge.SetValue(120.0)
        FoodHoursBack_07_XHuge.SetValue(180.0)
      EndIf

    ;============================================== Eating > Buff Dur.
    ElseIf aiMsg == 11
      aiBtn = ConfigEatBuffDurMsg.Show(EatBuffHoursToZero.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;2 hours
        EatBuffHoursToZero.SetValue(2.0)
      ElseIf aiBtn == 2 ;4 hours
        EatBuffHoursToZero.SetValue(4.0)
      ElseIf aiBtn == 3 ;6 hours
        EatBuffHoursToZero.SetValue(6.0)
      ElseIf aiBtn == 4 ;8 hours
        EatBuffHoursToZero.SetValue(8.0)
      ElseIf aiBtn == 5 ;10 hours
        EatBuffHoursToZero.SetValue(10.0)
      ElseIf aiBtn == 6 ;12 hours
        EatBuffHoursToZero.SetValue(12.0)
      EndIf

    ;============================================== Eating > Debuff Dur.
    ElseIf aiMsg == 12
      aiBtn = ConfigEatDebuffDurMsg.Show(EatDebuffHoursToMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;24 hours
        EatDebuffHoursToMax.SetValue(24.0)
      ElseIf aiBtn == 2 ;36 hours
        EatDebuffHoursToMax.SetValue(36.0)
      ElseIf aiBtn == 3 ;48 hours
        EatDebuffHoursToMax.SetValue(48.0)
      ElseIf aiBtn == 4 ;60 hours
        EatDebuffHoursToMax.SetValue(60.0)
      ElseIf aiBtn == 5 ;72 hours
        EatDebuffHoursToMax.SetValue(72.0)
      ElseIf aiBtn == 6 ;96 hours
        EatDebuffHoursToMax.SetValue(96.0)
      EndIf

    ;============================================== Eating > Death
    ElseIf aiMsg == 13
      aiBtn = ConfigEatDeathMsg.Show(EatDebuffHoursToDeath.GetValue() / 24, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;5 days
        EatDebuffHoursToDeath.SetValue(120.0)
      ElseIf aiBtn == 2 ;7 days
        EatDebuffHoursToDeath.SetValue(168.0)
      ElseIf aiBtn == 3 ;10 days
        EatDebuffHoursToDeath.SetValue(240.0)
      ElseIf aiBtn == 4 ;14 days
        EatDebuffHoursToDeath.SetValue(336.0)
      ElseIf aiBtn == 5 ;21 days
        EatDebuffHoursToDeath.SetValue(504.0)
      ElseIf aiBtn == 6 ;Never
        EatDebuffHoursToDeath.SetValue(0.0)
      EndIf

    ;============================================== Eating > Buff Mag.
    ElseIf aiMsg == 14
      aiBtn = ConfigEatBuffMagMsg.Show(EatBuffWeightMultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;2.0x
        EatBuffWeightMultMax.SetValue(2.0)
      ElseIf aiBtn == 2 ;1.75x
        EatBuffWeightMultMax.SetValue(1.75)
      ElseIf aiBtn == 3 ;1.5x
        EatBuffWeightMultMax.SetValue(1.5)
      ElseIf aiBtn == 4 ;1.25x
        EatBuffWeightMultMax.SetValue(1.25)
      ElseIf aiBtn == 5 ;1.1x
        EatBuffWeightMultMax.SetValue(1.1)
      ElseIf aiBtn == 6 ;1.0x
        EatBuffWeightMultMax.SetValue(1.0)
      EndIf

    ;============================================== Eating > Debuff Mag.
    ElseIf aiMsg == 15
      aiBtn = ConfigEatDebuffMagMsg.Show(EatDebuffWeightMultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;1.0x
        EatDebuffWeightMultMax.SetValue(1.0)
      ElseIf aiBtn == 2 ;0.8x
        EatDebuffWeightMultMax.SetValue(0.8)
      ElseIf aiBtn == 3 ;0.5x
        EatDebuffWeightMultMax.SetValue(0.5)
      ElseIf aiBtn == 4 ;0.3x
        EatDebuffWeightMultMax.SetValue(0.3)
      ElseIf aiBtn == 5 ;0.2x
        EatDebuffWeightMultMax.SetValue(0.2)
      ElseIf aiBtn == 6 ;0.1x
        EatDebuffWeightMultMax.SetValue(0.1)
      EndIf

    ;============================================== Eating > Alert
    ElseIf aiMsg == 16
      aiBtn = ConfigEatAlertFilterMsg.Show(EatHUDAlertFilterLevel.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 10
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;0 - Caution and warning
        EatHUDAlertFilterLevel.SetValue(0.0)
      ElseIf aiBtn == 2 ;1 - Only warning
        EatHUDAlertFilterLevel.SetValue(1.0)
      ElseIf aiBtn == 3 ;2 - Show nothing
        EatHUDAlertFilterLevel.SetValue(2.0)
      EndIf

    ;============================================== Drinking > Buff Dur.
    ElseIf aiMsg == 21
      aiBtn = ConfigDrinkBuffDurMsg.Show(DrinkBuffHoursToZero.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;1 hour
        DrinkBuffHoursToZero.SetValue(1.0)
      ElseIf aiBtn == 2 ;2 hours
        DrinkBuffHoursToZero.SetValue(2.0)
      ElseIf aiBtn == 3 ;3 hours
        DrinkBuffHoursToZero.SetValue(3.0)
      ElseIf aiBtn == 4 ;4 hours
        DrinkBuffHoursToZero.SetValue(4.0)
      ElseIf aiBtn == 5 ;5 hours
        DrinkBuffHoursToZero.SetValue(5.0)
      ElseIf aiBtn == 6 ;6 hours
        DrinkBuffHoursToZero.SetValue(6.0)
      EndIf

    ;============================================== Drinking > Debuff Dur.
    ElseIf aiMsg == 22
      aiBtn = ConfigDrinkDebuffDurMsg.Show(DrinkDebuffHoursToMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;8 hours
        DrinkDebuffHoursToMax.SetValue(8.0)
      ElseIf aiBtn == 2 ;10 hours
        DrinkDebuffHoursToMax.SetValue(10.0)
      ElseIf aiBtn == 3 ;12 hours
        DrinkDebuffHoursToMax.SetValue(12.0)
      ElseIf aiBtn == 4 ;16 hours
        DrinkDebuffHoursToMax.SetValue(16.0)
      ElseIf aiBtn == 5 ;20 hours
        DrinkDebuffHoursToMax.SetValue(20.0)
      ElseIf aiBtn == 6 ;24 hours
        DrinkDebuffHoursToMax.SetValue(24.0)
      EndIf

    ;============================================== Drinking > Death
    ElseIf aiMsg == 23
      aiBtn = ConfigDrinkDeathMsg.Show(DrinkDebuffHoursToDeath.GetValue() / 24, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;2 days
        DrinkDebuffHoursToDeath.SetValue(48.0)
      ElseIf aiBtn == 2 ;3 days
        DrinkDebuffHoursToDeath.SetValue(72.0)
      ElseIf aiBtn == 3 ;4 days
        DrinkDebuffHoursToDeath.SetValue(96.0)
      ElseIf aiBtn == 4 ;5 days
        DrinkDebuffHoursToDeath.SetValue(120.0)
      ElseIf aiBtn == 5 ;7 days
        DrinkDebuffHoursToDeath.SetValue(168.0)
      ElseIf aiBtn == 6 ;Never
        DrinkDebuffHoursToDeath.SetValue(0.0)
      EndIf

    ;============================================== Drinking > Buff Mag.
    ElseIf aiMsg == 24
      aiBtn = ConfigDrinkBuffMagMsg.Show(DrinkBuffO2MultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;0.1x
        DrinkBuffO2MultMax.SetValue(0.1)
      ElseIf aiBtn == 2 ;0.25x
        DrinkBuffO2MultMax.SetValue(0.25)
      ElseIf aiBtn == 3 ;0.5x
        DrinkBuffO2MultMax.SetValue(0.5)
      ElseIf aiBtn == 4 ;0.75x
        DrinkBuffO2MultMax.SetValue(0.75)
      ElseIf aiBtn == 5 ;0.9x
        DrinkBuffO2MultMax.SetValue(0.9)
      ElseIf aiBtn == 6 ;1.0x
        DrinkBuffO2MultMax.SetValue(1.0)
      EndIf

    ;============================================== Drinking > Debuff Mag.
    ElseIf aiMsg == 25
      aiBtn = ConfigDrinkDebuffMagMsg.Show(DrinkDebuffO2MultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;1.0x
        DrinkDebuffO2MultMax.SetValue(1.0)
      ElseIf aiBtn == 2 ;1.5x
        DrinkDebuffO2MultMax.SetValue(1.5)
      ElseIf aiBtn == 3 ;2.0x
        DrinkDebuffO2MultMax.SetValue(2.0)
      ElseIf aiBtn == 4 ;2.5x
        DrinkDebuffO2MultMax.SetValue(2.5)
      ElseIf aiBtn == 5 ;3.0x
        DrinkDebuffO2MultMax.SetValue(3.0)
      ElseIf aiBtn == 6 ;5.0x
        DrinkDebuffO2MultMax.SetValue(5.0)
      EndIf

    ;============================================== Drinking > Alert
    ElseIf aiMsg == 26
      aiBtn = ConfigDrinkAlertFilterMsg.Show(DrinkHUDAlertFilterLevel.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 20
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;0 - Caution and warning
        DrinkHUDAlertFilterLevel.SetValue(0.0)
      ElseIf aiBtn == 2 ;1 - Only warning
        DrinkHUDAlertFilterLevel.SetValue(1.0)
      ElseIf aiBtn == 3 ;2 - Show nothing
        DrinkHUDAlertFilterLevel.SetValue(2.0)
      EndIf

    ;============================================== Sleeping > Buff Dur.
    ElseIf aiMsg == 31
      aiBtn = ConfigSleepBuffDurMsg.Show(SleepBuffHoursToZero.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;8 hours
        SleepBuffHoursToZero.SetValue(8.0)
      ElseIf aiBtn == 2 ;10 hours
        SleepBuffHoursToZero.SetValue(10.0)
      ElseIf aiBtn == 3 ;12 hours
        SleepBuffHoursToZero.SetValue(12.0)
      ElseIf aiBtn == 4 ;14 hours
        SleepBuffHoursToZero.SetValue(14.0)
      ElseIf aiBtn == 5 ;16 hours
        SleepBuffHoursToZero.SetValue(16.0)
      ElseIf aiBtn == 6 ;18 hours
        SleepBuffHoursToZero.SetValue(18.0)
      EndIf

    ;============================================== Sleeping > Debuff Dur.
    ElseIf aiMsg == 32
      aiBtn = ConfigSleepDebuffDurMsg.Show(SleepDebuffHoursToMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;24 hours
        SleepDebuffHoursToMax.SetValue(24.0)
      ElseIf aiBtn == 2 ;36 hours
        SleepDebuffHoursToMax.SetValue(36.0)
      ElseIf aiBtn == 3 ;48 hours
        SleepDebuffHoursToMax.SetValue(48.0)
      ElseIf aiBtn == 4 ;60 hours
        SleepDebuffHoursToMax.SetValue(60.0)
      ElseIf aiBtn == 5 ;72 hours
        SleepDebuffHoursToMax.SetValue(72.0)
      ElseIf aiBtn == 6 ;96 hours
        SleepDebuffHoursToMax.SetValue(96.0)
      EndIf

    ;============================================== Sleeping > Death
    ElseIf aiMsg == 33
      aiBtn = ConfigSleepDeathMsg.Show(SleepDebuffHoursToDeath.GetValue() / 24, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;3 days
        SleepDebuffHoursToDeath.SetValue(72.0)
      ElseIf aiBtn == 2 ;5 days
        SleepDebuffHoursToDeath.SetValue(120.0)
      ElseIf aiBtn == 3 ;7 days
        SleepDebuffHoursToDeath.SetValue(168.0)
      ElseIf aiBtn == 4 ;10 days
        SleepDebuffHoursToDeath.SetValue(240.0)
      ElseIf aiBtn == 5 ;14 days
        SleepDebuffHoursToDeath.SetValue(336.0)
      ElseIf aiBtn == 6 ;Never
        SleepDebuffHoursToDeath.SetValue(0.0)
      EndIf

    ;============================================== Sleeping > Buff Mag.
    ElseIf aiMsg == 34
      aiBtn = ConfigSleepBuffMagMsg.Show(SleepBuffXPMultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;3.0x
        SleepBuffXPMultMax.SetValue(3.0)
      ElseIf aiBtn == 2 ;2.0x
        SleepBuffXPMultMax.SetValue(2.0)
      ElseIf aiBtn == 3 ;1.5x
        SleepBuffXPMultMax.SetValue(1.5)
      ElseIf aiBtn == 4 ;1.25x
        SleepBuffXPMultMax.SetValue(1.25)
      ElseIf aiBtn == 5 ;1.1x
        SleepBuffXPMultMax.SetValue(1.1)
      ElseIf aiBtn == 6 ;1.0x
        SleepBuffXPMultMax.SetValue(1.0)
      EndIf

    ;============================================== Sleeping > Debuff Mag.
    ElseIf aiMsg == 35
      aiBtn = ConfigSleepDebuffMagMsg.Show(SleepDebuffXPMultMax.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;1.0x
        SleepDebuffXPMultMax.SetValue(1.0)
      ElseIf aiBtn == 2 ;0.9x
        SleepDebuffXPMultMax.SetValue(0.9)
      ElseIf aiBtn == 3 ;0.75x
        SleepDebuffXPMultMax.SetValue(0.75)
      ElseIf aiBtn == 4 ;0.5x
        SleepDebuffXPMultMax.SetValue(0.5)
      ElseIf aiBtn == 5 ;0.25x
        SleepDebuffXPMultMax.SetValue(0.25)
      ElseIf aiBtn == 6 ;0.1x
        SleepDebuffXPMultMax.SetValue(0.1)
      EndIf

    ;============================================== Sleeping > Alert
    ElseIf aiMsg == 36
      aiBtn = ConfigSleepAlertFilterMsg.Show(SleepHUDAlertFilterLevel.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      aiMsg = 30
  
      If aiBtn == 0     ;Cancel and change nothing
      ElseIf aiBtn == 1 ;0 - Caution and warning
        SleepHUDAlertFilterLevel.SetValue(0.0)
      ElseIf aiBtn == 2 ;1 - Only warning
        SleepHUDAlertFilterLevel.SetValue(1.0)
      ElseIf aiBtn == 3 ;2 - Show nothing
        SleepHUDAlertFilterLevel.SetValue(2.0)
      EndIf

    EndIf
  EndWhile
  PlayerRef.EquipItem(SignalChem_ConfigEnd, False, True)
EndFunction