Scriptname SN_StatusScript Extends ActiveMagicEffect

Actor Property PlayerRef Auto
Form Property Chem Auto
Form Property SignalChem_ConfigEnd Auto
Message Property NotifyStatusEatMsg Auto
Message Property NotifyStatusDrinkMsg Auto
Message Property NotifyStatusSleepMsg Auto
Message Property NotifyStatusBoxMsg Auto
Message Property NotifyStatusBoxNoEnvMsg Auto
GlobalVariable Property NoEatHours Auto
GlobalVariable Property NoDrinkHours Auto
GlobalVariable Property NoSleepHours Auto
GlobalVariable Property DisableEnvStress Auto
ConditionForm Property ENV_CND_InSealedEnvironment Auto
Int Property MessageType Auto

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  If akTarget == PlayerRef
    If afMagnitude == 0.0 && PlayerRef.GetItemCount(Chem) == 0
      PlayerRef.AddItem(Chem, 1, True)
    EndIf
    If MessageType == 0
      Self.StatusNotification()
    ElseIf MessageType == 1
      Self.StatusBox()
    EndIf
  EndIf
EndEvent

Function StatusNotification()
  ;Debug.Trace("[SN_NotificationScript] StatusNotification()", 0)
  NotifyStatusEatMsg.Show(NoEatHours.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  NotifyStatusDrinkMsg.Show(NoDrinkHours.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  NotifyStatusSleepMsg.Show(NoSleepHours.GetValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  PlayerRef.EquipItem(SignalChem_ConfigEnd, False, True)
EndFunction

Function StatusBox()
  ;Debug.Trace("[SN_NotificationScript] StatusBox()", 0)
  If DisableEnvStress.GetValue() as Bool == False
    Planet myPlanet = PlayerRef.GetCurrentPlanet()
    Float fCurrentGravity = PlayerRef.GetGravityScale()
    Float fCurrentTemperature = myPlanet.GetTemperature()
    If fCurrentTemperature == "inf"
      fCurrentTemperature = 25.0
    EndIf
    If ENV_CND_InSealedEnvironment.IsTrue(PlayerRef as ObjectReference, None)
      Float fTemperatureDiff = fCurrentTemperature - 25
      If fTemperatureDiff >= 0
        fCurrentTemperature = Math.sqrt(fTemperatureDiff) + 25
      Else
        fCurrentTemperature = Math.sqrt(Math.abs(fTemperatureDiff)) * -1 + 25
      EndIf
    EndIf
    Float fGravityStress = Math.Min(Math.abs(fCurrentGravity), 2)
    Float fTemperatureStress = Math.Min(Math.abs(25.0 - fCurrentTemperature), 200) / 100
    Float fEnvStress = Math.Max(Math.sqrt(fGravityStress + fTemperatureStress) - 0.25, 0.5)
    NotifyStatusBoxMsg.Show(NoEatHours.GetValue(), NoDrinkHours.GetValue(), NoSleepHours.GetValue(), fEnvStress, 0.0, 0.0, 0.0, 0.0, 0.0)
  Else
    NotifyStatusBoxMsg.Show(NoEatHours.GetValue(), NoDrinkHours.GetValue(), NoSleepHours.GetValue(), 1.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
  PlayerRef.EquipItem(SignalChem_ConfigEnd, False, True)
EndFunction
