Scriptname SN_InitScript Extends Quest

;============================================================ Base

Actor Property PlayerRef Auto
Keyword Property VendorFood Auto
Keyword Property VendorDrink Auto
GlobalVariable Property GameDaysPassed Auto
GlobalVariable Property PlayerJailed Auto

Perk Property EatStatusPerk Auto
Perk Property DrinkStatusPerk Auto
Perk Property SleepStatusPerk Auto

Message Property UnknownDrinkMsg Auto
Message Property UnknownFoodMsg Auto

Message Property NotifyEatMsg Auto
Message Property NotifyDrinkMsg Auto
Message Property NotifySleepMsg Auto

Message Property NotifyStatusEatMsg Auto
Message Property NotifyStatusDrinkMsg Auto
Message Property NotifyStatusSleepMsg Auto
Message Property NotifyStatusBoxMsg Auto

Form Property SignalChem_ConfigEnd Auto

;============================================================ Buff Curves

GlobalVariable Property EatBuffHoursToZero_Halfed Auto
GlobalVariable Property EatBuffHoursToZero Auto
GlobalVariable Property EatDebuffHoursToMax_Halfed Auto
GlobalVariable Property EatDebuffHoursToDeath Auto
GlobalVariable Property EatDebuffHoursToMax Auto

GlobalVariable Property DrinkBuffHoursToZero_Halfed Auto
GlobalVariable Property DrinkBuffHoursToZero Auto
GlobalVariable Property DrinkDebuffHoursToMax_Halfed Auto
GlobalVariable Property DrinkDebuffHoursToMax Auto
GlobalVariable Property DrinkDebuffHoursToDeath Auto

GlobalVariable Property SleepBuffHoursToZero_Halfed Auto
GlobalVariable Property SleepBuffHoursToZero Auto
GlobalVariable Property SleepDebuffHoursToMax_Halfed Auto
GlobalVariable Property SleepDebuffHoursToMax Auto
GlobalVariable Property SleepDebuffHoursToDeath Auto

;============================================================ Buff Values

GlobalVariable Property EatBuffWeightMultMax Auto
GlobalVariable Property EatDebuffWeightMultMax Auto
ActorValue Property CurrentEatBuffMult Auto

GlobalVariable Property DrinkBuffO2MultMax Auto
GlobalVariable Property DrinkDebuffO2MultMax Auto
ActorValue Property CurrentDrinkBuffMult Auto

GlobalVariable Property SleepBuffXPMultMax Auto
GlobalVariable Property SleepDebuffXPMultMax Auto
ActorValue Property CurrentSleepBuffMult Auto

;============================================================ Recovery Values

GlobalVariable Property FoodHoursBack_01_VerySmall Auto
GlobalVariable Property FoodHoursBack_02_Small Auto
GlobalVariable Property FoodHoursBack_03_Medium Auto
GlobalVariable Property FoodHoursBack_04_Large Auto
GlobalVariable Property FoodHoursBack_05_XLarge Auto
GlobalVariable Property FoodHoursBack_06_Huge Auto
GlobalVariable Property FoodHoursBack_07_XHuge Auto

GlobalVariable Property SleepHoursBackPerHour Auto

;============================================================ Pseudo-Keywords

FormList Property EatList_01_VerySmall Auto
FormList Property EatList_02_Small Auto
FormList Property EatList_03_Medium Auto
FormList Property EatList_04_Large Auto
FormList Property EatList_05_XLarge Auto
FormList Property EatList_06_Huge Auto
FormList Property EatList_07_XHuge Auto

FormList Property DrinkList_Alcohol Auto
FormList Property DrinkList_Caffeine Auto
FormList Property DrinkList_Sedative Auto
FormList Property DrinkList_NonAlcohol Auto

FormList Property PauseLocationList Auto

;============================================================ Variables

GlobalVariable Property MainTimerInterval Auto
GlobalVariable Property LastDayLength Auto

GlobalVariable Property LastDrinkCheckTime Auto
GlobalVariable Property LastEatCheckTime Auto
GlobalVariable Property LastSleepCheckTime Auto
GlobalVariable Property SleepStartTime Auto
GlobalVariable Property WaitStartTime Auto

GlobalVariable Property NoEatHours Auto
GlobalVariable Property NoDrinkHours Auto
GlobalVariable Property NoSleepHours Auto

GlobalVariable Property EatSystemDisabled Auto
GlobalVariable Property DrinkSystemDisabled Auto
GlobalVariable Property SleepSystemDisabled Auto

GlobalVariable Property EnableRecoveryNotification Auto

GlobalVariable Property DisableEnvStress Auto
ConditionForm Property ENV_CND_InSealedEnvironment Auto

;============================================================ External MODs

String Property ESM_RecycleScum Auto
Int Property FormID_KYWD_CannibalFood Auto
Int Property FormID_PERK_TRAIT_Cannibal Auto

;============================================================ Const

Int iMainTimerID = 0 Const

;============================================================ Launch

Event OnQuestInit()
  ;Debug.Trace("[SN_InitScript] OnQuestInit()", 0)
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")
  ;Self.RegisterForPlayerTeleport()
  Self.RegisterForPlayerSleep()
  Self.RegisterForPlayerWait()
  Self.InitVariables()
  Self.InitStatusPerks()
  Self.StartMainTimer()
EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)
  ;Debug.Trace("[SN_InitScript] Actor.OnPlayerLoadGame()", 0)
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")
  ;Self.RegisterForPlayerTeleport()
  Self.RegisterForPlayerSleep()
  Self.RegisterForPlayerWait()
  Self.InitVariables()
  Self.InitStatusPerks()
  Self.StartMainTimer()
EndEvent

;Duct taped until I figure out how to catch Story Events correctly
Event Actor.OnPlayerJail(Actor akSender, ObjectReference akGuard, Form akFaction, Location akLocation, Int aeCrimeGold)
  ;Debug.Trace("[SN_InitScript] OnPlayerJail()", 0)
  PlayerJailed.SetValue(3.0)
EndEvent

;Please tell me how to handle these correctly.

;Event OnStoryJail(ObjectReference akGuard, Form akCrimeGroup, Location akLocation, Int aiCrimeGold)
;  ;Debug.Trace("[SN_InitScript] OnStoryJail()", 0)
;EndEvent
;Event OnStoryEscapeJail(Location akLocation, Form akCrimeGroup)
;  ;Debug.Trace("[SN_InitScript] OnStoryEscapeJail()", 0)
;EndEvent
;Event OnStoryServedTime(Location akLocation, Form akCrimeGroup, Int aiCrimeGold, Int aiDaysJail)
;  ;Debug.Trace("[SN_InitScript] OnStoryServedTime() "+ aiDaysJail +" Days", 0)
;EndEvent
;Event OnStoryScript(Keyword akKeyword, Location akLocation, ObjectReference akRef1, ObjectReference akRef2, Int aiValue1, Int aiValue2)
;  ;Debug.Trace("[SN_InitScript] OnStoryScript() "+ akKeyword, 0)
;EndEvent

Function InitVariables()
  ;Debug.Trace("[SN_InitScript] InitVariables()", 0)
  If LastEatCheckTime.GetValue() == 0.0
    LastEatCheckTime.SetValue(GameDaysPassed.GetValue())
  EndIf
  If LastDrinkCheckTime.GetValue() == 0.0
    LastDrinkCheckTime.SetValue(GameDaysPassed.GetValue())
  EndIf
  If LastSleepCheckTime.GetValue() == 0.0
    LastSleepCheckTime.SetValue(GameDaysPassed.GetValue())
  EndIf
EndFunction

Function InitStatusPerks()
  ;Debug.Trace("[SN_InitScript] InitStatusPerks()", 0)
  If SleepSystemDisabled.GetValue() as Bool == False
    PlayerRef.AddPerk(SleepStatusPerk, False)
  EndIf
  If DrinkSystemDisabled.GetValue() as Bool == False
    PlayerRef.AddPerk(DrinkStatusPerk, False)
  EndIf
  If EatSystemDisabled.GetValue() as Bool == False
    PlayerRef.AddPerk(EatStatusPerk, False)
  EndIf
EndFunction

Function StartMainTimer()
  ;Debug.Trace("[SN_InitScript] StartMainTimer()", 0)
  Self.StartTimer(MainTimerInterval.GetValue(), iMainTimerID)
EndFunction

Event OnTimer(int aiTimerID)
  ;Debug.Trace("[SN_InitScript] OnTimer()", 0)
  If aiTimerID == iMainTimerID
    Self.CheckStatus()
    Self.StartMainTimer()
  EndIf
EndEvent

;============================================================ Foods

Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
  ;Debug.Trace("[SN_InitScript] Actor.OnItemEquipped()", 0)
  If akBaseObject == SignalChem_ConfigEnd
    Self.CheckStatus()
    Return
  EndIf
  Bool bUnlistedFood = False
  Bool bUnlistedDrink = False

  If akBaseObject.HasKeyword(VendorFood) || akBaseObject.HasKeyword(VendorDrink)
    If Self.VerifyFood(akBaseObject)
      If EatList_07_XHuge.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_07_XHuge.GetValue())
      ElseIf EatList_06_Huge.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_06_Huge.GetValue())
      ElseIf EatList_05_XLarge.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_05_XLarge.GetValue())
      ElseIf EatList_04_Large.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_04_Large.GetValue())
      ElseIf EatList_03_Medium.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_03_Medium.GetValue())
      ElseIf EatList_02_Small.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_02_Small.GetValue())
      ElseIf EatList_01_VerySmall.Find(akBaseObject) != -1
        Self.RecoverEat(FoodHoursBack_01_VerySmall.GetValue())
      Else
        bUnlistedFood = True
      EndIf
    EndIf

    If Self.VerifyDrink(akBaseObject)
      If DrinkList_Alcohol.Find(akBaseObject) != -1
        Self.RecoverDrink(FoodHoursBack_01_VerySmall.GetValue())
        Self.RecoverSleep(-2.0)
      ElseIf DrinkList_Caffeine.Find(akBaseObject) != -1
        Self.RecoverDrink(FoodHoursBack_02_Small.GetValue())
        Self.RecoverSleep(1.0)
      ElseIf DrinkList_Sedative.Find(akBaseObject) != -1
        Self.RecoverDrink(FoodHoursBack_03_Medium.GetValue())
        Self.RecoverSleep(-1.0)
      ElseIf DrinkList_NonAlcohol.Find(akBaseObject) != -1
        Self.RecoverDrink(FoodHoursBack_03_Medium.GetValue())
      Else
        bUnlistedDrink = True
      EndIf
    EndIf

    If bUnlistedFood && akBaseObject.HasKeyword(VendorFood)
      Self.ShowUnknownFoodMsg(akBaseObject)
    EndIf
    If bUnlistedDrink && akBaseObject.HasKeyword(VendorDrink)
      Self.ShowUnknownDrinkMsg(akBaseObject)
    EndIf
  EndIf
EndEvent

Bool Function VerifyFood(Form akBaseObject)
  If EatSystemDisabled.GetValue() as Bool == True
    Return False
  EndIf
  If Game.IsPluginInstalled(ESM_RecycleScum)
    If PlayerRef.HasPerk(Game.GetFormFromFile(FormID_PERK_TRAIT_Cannibal, ESM_RecycleScum) as Perk)
      If akBaseObject.HasKeyword(Game.GetFormFromFile(FormID_KYWD_CannibalFood, ESM_RecycleScum) as Keyword) != 1
        Return False
      EndIf
    EndIf
  EndIf
  Return True
EndFunction

Bool Function VerifyDrink(Form akBaseObject)
  If DrinkSystemDisabled.GetValue() as Bool == True
    Return False
  EndIf
  Return True
EndFunction

;============================================================ Unknown Food

Function ShowUnknownFoodMsg(Form akBaseObject)
  ;Debug.Trace("[SN_InitScript] ShowUnknownFoodMsg()", 0)
  Int aiBtn = UnknownFoodMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  If aiBtn == 1
    EatList_01_VerySmall.AddForm(akBaseObject)
  ElseIf aiBtn == 2
    EatList_02_Small.AddForm(akBaseObject)
  ElseIf aiBtn == 3
    EatList_03_Medium.AddForm(akBaseObject)
  ElseIf aiBtn == 4
    EatList_04_Large.AddForm(akBaseObject)
  ElseIf aiBtn == 5
    EatList_05_XLarge.AddForm(akBaseObject)
  ElseIf aiBtn == 6
    EatList_06_Huge.AddForm(akBaseObject)
  ElseIf aiBtn == 7
    EatList_07_XHuge.AddForm(akBaseObject)
  EndIf
EndFunction

Function ShowUnknownDrinkMsg(Form akBaseObject)
  ;Debug.Trace("[SN_InitScript] ShowUnknownDrinkMsg()", 0)
  Int aiBtn = UnknownDrinkMsg.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  If aiBtn == 1
    DrinkList_Alcohol.AddForm(akBaseObject)
  ElseIf aiBtn == 2
    DrinkList_Caffeine.AddForm(akBaseObject)
  ElseIf aiBtn == 3
    DrinkList_Sedative.AddForm(akBaseObject)
  ElseIf aiBtn == 4
    DrinkList_NonAlcohol.AddForm(akBaseObject)
  EndIf
EndFunction

;============================================================ Timer

Function CheckStatus(Bool bWaitEnd = False)
  ;Debug.Trace("[SN_InitScript] CheckStatus()", 0)
  Planet myPlanet = PlayerRef.GetCurrentPlanet()
  Float fCurrentCheckTime = GameDaysPassed.GetValue()
  Float fCurrentDayLength = Math.abs(myPlanet.GetDayLength())
  Float fLastDayLength = Math.abs(LastDayLength.GetValue())
  ;Debug.Trace("[SN_InitScript] fCurrentCheckTime = "+ fCurrentCheckTime, 0)
  ;Debug.Trace("[SN_InitScript] fCurrentDayLength = "+ fCurrentDayLength, 0)
  ;Debug.Trace("[SN_InitScript] fLastDayLength = "+ fLastDayLength, 0)
  
  Float fWaitStartTime = WaitStartTime.GetValue()
  Float fSleepStartTime = SleepStartTime.GetValue()
  Float fPlayerJailed = PlayerJailed.GetValue()

  ;This is why GetDayLength() is unreliable.
  ;When this bastard returns inf, the bed asks for tens of UT hours.
  ;I feel like I'm going to lose my mind.
  If PlayerRef.IsInSpace() || fCurrentDayLength == "inf" || fCurrentDayLength == 0.0
    fCurrentDayLength = 24.0
    ;Debug.Trace("[SN_InitScript] fCurrentDayLength is changed to "+ fCurrentDayLength, 0)
  EndIf
  If fLastDayLength == "inf" || fLastDayLength == 0.0
    fLastDayLength = 24.0
    ;Debug.Trace("[SN_InitScript] fLastDayLength is changed to "+ fLastDayLength, 0)
  EndIf

  Float fEnvStress = 1.0
  If DisableEnvStress.GetValue() as Bool == False
    Float fCurrentGravity = PlayerRef.GetGravityScale()
    Float fCurrentTemperature = myPlanet.GetTemperature()
    ;Debug.Trace("[SN_InitScript] fCurrentGravity = "+ fCurrentGravity, 0)
    ;Debug.Trace("[SN_InitScript] fCurrentTemperature = "+ fCurrentTemperature, 0)
    
    If fCurrentTemperature == "inf"
      fCurrentTemperature = 25.0
      ;Debug.Trace("[SN_InitScript] fCurrentTemperature is changed to "+ fCurrentTemperature, 0)
    EndIf
    If ENV_CND_InSealedEnvironment.IsTrue(PlayerRef as ObjectReference, None)
      Float fTemperatureDiff = fCurrentTemperature - 25
      If fTemperatureDiff >= 0
        fCurrentTemperature = Math.sqrt(fTemperatureDiff) + 25
      Else
        fCurrentTemperature = Math.sqrt(Math.abs(fTemperatureDiff)) * -1 + 25
      EndIf
      ;Debug.Trace("[SN_InitScript] fCurrentTemperature is changed to "+ fCurrentTemperature, 0)
    EndIf
    Float fGravityStress = Math.Min(Math.abs(fCurrentGravity), 2)
    Float fTemperatureStress = Math.Min(Math.abs(25 - fCurrentTemperature), 200) / 100
    fEnvStress = Math.Max(Math.sqrt(fGravityStress + fTemperatureStress) - 0.25, 0.5)
    ;Debug.Trace("[SN_InitScript] fEnvStress = "+ fEnvStress, 0)
  EndIf
  
  If fWaitStartTime as Bool == False && fPlayerJailed as Bool == False && PauseLocationList.Find(PlayerRef.GetCurrentLocation()) == -1
    If EatSystemDisabled.GetValue() as Bool == False && fSleepStartTime as Bool == False
      ;Self.RecoverEat(-576.0 * (fCurrentCheckTime - LastEatCheckTime.GetValue()) / Math.Max(fCurrentDayLength, fLastDayLength) * fEnvStress)
      Self.RecoverEat(-24.0 * (fCurrentCheckTime - LastEatCheckTime.GetValue()) * fEnvStress)
    EndIf
    If DrinkSystemDisabled.GetValue() as Bool == False && fSleepStartTime as Bool == False
      Self.RecoverDrink(-24.0 * (fCurrentCheckTime - LastDrinkCheckTime.GetValue()) * fEnvStress)
    EndIf
    If SleepSystemDisabled.GetValue() as Bool == False
      If fSleepStartTime as Bool == False
        Self.RecoverSleep(-24.0 * (fCurrentCheckTime - LastSleepCheckTime.GetValue()) * fEnvStress)
      Else
        ;Self.RecoverSleep(576.0 * (fCurrentCheckTime - fSleepStartTime) / Math.Min(fCurrentDayLength, fLastDayLength) * SleepHoursBackPerHour.GetValue())
        Self.RecoverSleep(24.0 * (fCurrentCheckTime - LastSleepCheckTime.GetValue()))
        If bWaitEnd
          ;Debug.Trace("[SN_InitScript] Wake up!", 0)
          SleepStartTime.SetValue(0.0)
        EndIf
      EndIf
    EndIf
  EndIf

  If bWaitEnd && fWaitStartTime as Bool == True
    ;Debug.Trace("[SN_InitScript] Break is over!", 0)
    WaitStartTime.SetValue(0.0)
  EndIf

  ;Duct taped until I figure out how to catch Story Events correctly
  If fPlayerJailed > 1.0
    PlayerJailed.SetValue(fPlayerJailed - 1.0)
    ;Debug.Trace("[SN_InitScript] PlayerJailed = "+ PlayerJailed.GetValue(), 0)
  Else
    PlayerJailed.SetValue(0.0)
    ;Debug.Trace("[SN_InitScript] PlayerJailed = "+ PlayerJailed.GetValue(), 0)
  EndIf

  LastEatCheckTime.SetValue(fCurrentCheckTime)
  LastDrinkCheckTime.SetValue(fCurrentCheckTime)
  LastSleepCheckTime.SetValue(fCurrentCheckTime)
  LastDayLength.SetValue(fCurrentDayLength)
EndFunction

;============================================================ Recover

Function RecoverEat(Float afHours)
  ;Debug.Trace("[SN_InitScript] RecoverEat("+ afHours +")", 0)
  Float fNoSupplyHours = NoEatHours.GetValue()
  Float fBuffHoursToZero = EatBuffHoursToZero.GetValue()
  Float fDebuffHoursToMax = EatDebuffHoursToMax.GetValue()
  Float fDebuffHoursToDeath = EatDebuffHoursToDeath.GetValue()
  Float fBuffMult = EatBuffWeightMultMax.GetValue()
  Float fDebuffMult = EatDebuffWeightMultMax.GetValue()
  Float fMult = 1.0

  fNoSupplyHours = fNoSupplyHours - afHours
  If fNoSupplyHours < 0
    fNoSupplyHours = 0
  EndIf
  If EnableRecoveryNotification.GetValue() && afHours >= 1
    NotifyEatMsg.Show(fNoSupplyHours, afHours, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf

  If fNoSupplyHours <= fBuffHoursToZero
    fMult = (1 - fNoSupplyHours / fBuffHoursToZero) * (fBuffMult - 1) + 1
  ElseIf fNoSupplyHours <= fDebuffHoursToMax
    fMult = ((fNoSupplyHours - fBuffHoursToZero) / (fDebuffHoursToMax - fBuffHoursToZero)) * (fDebuffMult - 1) + 1
  ElseIf fNoSupplyHours >= fDebuffHoursToDeath
    If fDebuffHoursToDeath <= fDebuffHoursToMax
      fMult = fDebuffMult
    Else
      PlayerRef.Kill(None)
    EndIf
  Else
    fMult = fDebuffMult
  EndIf
  EatBuffHoursToZero_Halfed.SetValue(fBuffHoursToZero / 2)
  EatDebuffHoursToMax_Halfed.SetValue((fBuffHoursToZero + fDebuffHoursToMax) / 2)
  ;Debug.Trace("[SN_InitScript] Weight Mult = "+ fMult, 0)
  PlayerRef.SetValue(CurrentEatBuffMult, fMult)
  NoEatHours.SetValue(fNoSupplyHours)
EndFunction


Function RecoverDrink(Float afHours)
  ;Debug.Trace("[SN_InitScript] RecoverDrink("+ afHours +")", 0)
  Float fNoSupplyHours = NoDrinkHours.GetValue()
  Float fBuffHoursToZero = DrinkBuffHoursToZero.GetValue()
  Float fDebuffHoursToMax = DrinkDebuffHoursToMax.GetValue()
  Float fDebuffHoursToDeath = DrinkDebuffHoursToDeath.GetValue()
  Float fBuffMult = DrinkBuffO2MultMax.GetValue()
  Float fDebuffMult = DrinkDebuffO2MultMax.GetValue()
  Float fMult = 1.0

  fNoSupplyHours = fNoSupplyHours - afHours
  If fNoSupplyHours < 0
    fNoSupplyHours = 0
  EndIf
  If EnableRecoveryNotification.GetValue() && afHours >= 1
    NotifyDrinkMsg.Show(fNoSupplyHours, afHours, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf

  If fNoSupplyHours <= fBuffHoursToZero
    fMult = (1 - fNoSupplyHours / fBuffHoursToZero) * (fBuffMult - 1) + 1
  ElseIf fNoSupplyHours <= fDebuffHoursToMax
    fMult = ((fNoSupplyHours - fBuffHoursToZero) / (fDebuffHoursToMax - fBuffHoursToZero)) * (fDebuffMult - 1) + 1
  ElseIf fNoSupplyHours >= fDebuffHoursToDeath
    If fDebuffHoursToDeath <= fDebuffHoursToMax
      fMult = fDebuffMult
    Else
      PlayerRef.Kill(None)
    EndIf
  Else
    fMult = fDebuffMult
  EndIf
  DrinkBuffHoursToZero_Halfed.SetValue(fBuffHoursToZero / 2)
  DrinkDebuffHoursToMax_Halfed.SetValue((fBuffHoursToZero + fDebuffHoursToMax) / 2)
  ;Debug.Trace("[SN_InitScript] O2 Mult = "+ fMult, 0)
  PlayerRef.SetValue(CurrentDrinkBuffMult, fMult)
  NoDrinkHours.SetValue(fNoSupplyHours)
EndFunction


Function RecoverSleep(Float afHours)
  ;Debug.Trace("[SN_InitScript] RecoverSleep("+ afHours +")", 0)
  Float fNoSupplyHours = NoSleepHours.GetValue()
  Float fBuffHoursToZero = SleepBuffHoursToZero.GetValue()
  Float fDebuffHoursToMax = SleepDebuffHoursToMax.GetValue()
  Float fDebuffHoursToDeath = SleepDebuffHoursToDeath.GetValue()
  Float fBuffMult = SleepBuffXPMultMax.GetValue()
  Float fDebuffMult = SleepDebuffXPMultMax.GetValue()
  Float fMult = 1.0

  fNoSupplyHours = fNoSupplyHours - afHours
  If fNoSupplyHours < 0
    fNoSupplyHours = 0
  EndIf
  If EnableRecoveryNotification.GetValue() && afHours >= 1
    NotifySleepMsg.Show(fNoSupplyHours, afHours, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf

  If fNoSupplyHours <= fBuffHoursToZero
    fMult = (1 - fNoSupplyHours / fBuffHoursToZero) * (fBuffMult - 1) + 1
  ElseIf fNoSupplyHours <= fDebuffHoursToMax
    fMult = ((fNoSupplyHours - fBuffHoursToZero) / (fDebuffHoursToMax - fBuffHoursToZero)) * (fDebuffMult - 1) + 1
  ElseIf fNoSupplyHours >= fDebuffHoursToDeath
    If fDebuffHoursToDeath <= fDebuffHoursToMax
      fMult = fDebuffMult
    Else
      PlayerRef.Kill(None)
    EndIf
  Else
    fMult = fDebuffMult
  EndIf
  SleepBuffHoursToZero_Halfed.SetValue(fBuffHoursToZero / 2)
  SleepDebuffHoursToMax_Halfed.SetValue((fBuffHoursToZero + fDebuffHoursToMax) / 2)
  ;Debug.Trace("[SN_InitScript] XP Mult = "+ fMult, 0)
  PlayerRef.SetValue(CurrentSleepBuffMult, fMult)
  NoSleepHours.SetValue(fNoSupplyHours)
EndFunction

;============================================================ Sleep

Event OnPlayerSleepStart(Float afSleepStartTime, Float afDesiredSleepEndTime, ObjectReference akBed)
  ;Debug.Trace("[SN_InitScript] OnPlayerSleepStart()", 0)
  Self.CheckStatus()
  If SleepSystemDisabled.GetValue() as Bool == False
    SleepStartTime.SetValue(GameDaysPassed.GetValue())
  EndIf
EndEvent

Event OnPlayerSleepStop(Bool abInterrupted, ObjectReference akBed)
  ;Debug.Trace("[SN_InitScript] OnPlayerSleepStop()", 0)
  Self.CheckStatus(True)
EndEvent

;============================================================ Wait

Event OnPlayerWaitStart(Float afWaitStartTime, Float afDesiredWaitEndTime)
  ;Debug.Trace("[SN_InitScript] OnPlayerWaitStart()", 0)
  Self.CheckStatus()
  WaitStartTime.SetValue(GameDaysPassed.GetValue())
EndEvent

Event OnPlayerWaitStop(Bool abInterrupted)
  ;Debug.Trace("[SN_InitScript] OnPlayerWaitStop()", 0)
  Self.CheckStatus(True)
EndEvent
