Scriptname RS_InitScript Extends Quest

Actor Property PlayerRef Auto
Perk Property RS_BodyActivationPerk Auto

FormList Property RS_EatList_01_VerySmall Auto
FormList Property RS_EatList_02_Small Auto
FormList Property RS_EatList_03_Medium Auto
FormList Property RS_EatList_04_Large Auto
FormList Property RS_EatList_05_XLarge Auto
FormList Property RS_EatList_06_Huge Auto
FormList Property RS_EatList_07_XHuge Auto

FormList Property RS_DrinkList_Alcohol Auto
FormList Property RS_DrinkList_Caffeine Auto
FormList Property RS_DrinkList_Sedative Auto
FormList Property RS_DrinkList_NonAlcohol Auto

String Property ESM_SimpleNeeds Auto

Int Property FLST_SN_EatList_01_VerySmall Auto
Int Property FLST_SN_EatList_02_Small Auto
Int Property FLST_SN_EatList_03_Medium Auto
Int Property FLST_SN_EatList_04_Large Auto
Int Property FLST_SN_EatList_05_XLarge Auto
Int Property FLST_SN_EatList_06_Huge Auto
Int Property FLST_SN_EatList_07_XHuge Auto

Int Property FLST_SN_DrinkList_Alcohol Auto
Int Property FLST_SN_DrinkList_Caffeine Auto
Int Property FLST_SN_DrinkList_Sedative Auto
Int Property FLST_SN_DrinkList_NonAlcohol Auto

String Property Version Auto
String sSaveVersion

Bool bInit

Event OnQuestInit()
  ;Debug.Trace("[RS_InitScript] OnQuestInit()", 0)
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
  Utility.Wait(0.1)
  If bInit == True
    Return
  Else
    bInit = True
    Self.Load()
  EndIf
EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)
  ;Debug.Trace("[RS_InitScript] Actor.OnPlayerLoadGame()", 0)
  Self.Load()
EndEvent

Function Load()
  ;Debug.Trace("[RS_InitScript] Load()", 0)
  PlayerRef.AddPerk(RS_BodyActivationPerk, False)
  ;Debug.Trace("[RS_InitScript] Version = "+ Version, 0)
  ;Debug.Trace("[RS_InitScript] sSaveVersion = "+ sSaveVersion, 0)
  If Version != sSaveVersion
    Self.InitSimpleNeedsFLST()
    sSaveVersion = Version
  EndIF
EndFunction

Function InitSimpleNeedsFLST()
  ;Debug.Trace("[RS_InitScript] InitSimpleNeedsFLST()", 0)
  If Game.IsPluginInstalled(ESM_SimpleNeeds) == False
    Return
  EndIf
  FormList SN_EatList_01_VerySmall = Game.GetFormFromFile(FLST_SN_EatList_01_VerySmall, ESM_SimpleNeeds) as FormList
  FormList SN_EatList_02_Small     = Game.GetFormFromFile(FLST_SN_EatList_02_Small,     ESM_SimpleNeeds) as FormList
  FormList SN_EatList_03_Medium    = Game.GetFormFromFile(FLST_SN_EatList_03_Medium,    ESM_SimpleNeeds) as FormList
  FormList SN_EatList_04_Large     = Game.GetFormFromFile(FLST_SN_EatList_04_Large,     ESM_SimpleNeeds) as FormList
  FormList SN_EatList_05_XLarge    = Game.GetFormFromFile(FLST_SN_EatList_05_XLarge,    ESM_SimpleNeeds) as FormList
  FormList SN_EatList_06_Huge      = Game.GetFormFromFile(FLST_SN_EatList_06_Huge,      ESM_SimpleNeeds) as FormList
  FormList SN_EatList_07_XHuge     = Game.GetFormFromFile(FLST_SN_EatList_07_XHuge,     ESM_SimpleNeeds) as FormList
  FormList SN_DrinkList_Alcohol    = Game.GetFormFromFile(FLST_SN_DrinkList_Alcohol,    ESM_SimpleNeeds) as FormList
  FormList SN_DrinkList_Caffeine   = Game.GetFormFromFile(FLST_SN_DrinkList_Caffeine,   ESM_SimpleNeeds) as FormList
  FormList SN_DrinkList_Sedative   = Game.GetFormFromFile(FLST_SN_DrinkList_Sedative,   ESM_SimpleNeeds) as FormList
  FormList SN_DrinkList_NonAlcohol = Game.GetFormFromFile(FLST_SN_DrinkList_NonAlcohol, ESM_SimpleNeeds) as FormList
  int i = 0
  Form item = None
  While (i < RS_EatList_01_VerySmall.GetSize())
    item = RS_EatList_01_VerySmall.GetAt(i)
    If item && SN_EatList_01_VerySmall.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_01_VerySmall.AddForm("+ item +")", 0)
      SN_EatList_01_VerySmall.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_02_Small.GetSize())
    item = RS_EatList_02_Small.GetAt(i)
    If item && SN_EatList_02_Small.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_02_Small.AddForm("+ item +")", 0)
      SN_EatList_02_Small.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_03_Medium.GetSize())
    item = RS_EatList_03_Medium.GetAt(i)
    If item && SN_EatList_03_Medium.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_03_Medium.AddForm("+ item +")", 0)
      SN_EatList_03_Medium.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_04_Large.GetSize())
    item = RS_EatList_04_Large.GetAt(i)
    If item && SN_EatList_04_Large.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_04_Large.AddForm("+ item +")", 0)
      SN_EatList_04_Large.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_05_XLarge.GetSize())
    item = RS_EatList_05_XLarge.GetAt(i)
    If item && SN_EatList_05_XLarge.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_05_XLarge.AddForm("+ item +")", 0)
      SN_EatList_05_XLarge.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_06_Huge.GetSize())
    item = RS_EatList_06_Huge.GetAt(i)
    If item && SN_EatList_06_Huge.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_06_Huge.AddForm("+ item +")", 0)
      SN_EatList_06_Huge.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_EatList_07_XHuge.GetSize())
    item = RS_EatList_07_XHuge.GetAt(i)
    If item && SN_EatList_07_XHuge.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_EatList_07_XHuge.AddForm("+ item +")", 0)
      SN_EatList_07_XHuge.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_DrinkList_Alcohol.GetSize())
    item = RS_DrinkList_Alcohol.GetAt(i)
    If item && SN_DrinkList_Alcohol.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_DrinkList_Alcohol.AddForm("+ item +")", 0)
      SN_DrinkList_Alcohol.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_DrinkList_Caffeine.GetSize())
    item = RS_DrinkList_Caffeine.GetAt(i)
    If item && SN_DrinkList_Caffeine.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_DrinkList_Caffeine.AddForm("+ item +")", 0)
      SN_DrinkList_Caffeine.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_DrinkList_Sedative.GetSize())
    item = RS_DrinkList_Sedative.GetAt(i)
    If item && SN_DrinkList_Sedative.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_DrinkList_Sedative.AddForm("+ item +")", 0)
      SN_DrinkList_Sedative.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
  i = 0
  While (i < RS_DrinkList_NonAlcohol.GetSize())
    item = RS_DrinkList_NonAlcohol.GetAt(i)
    If item && SN_DrinkList_NonAlcohol.HasForm(item) == False
      ;Debug.Trace("[RS_InitScript] SN_DrinkList_NonAlcohol.AddForm("+ item +")", 0)
      SN_DrinkList_NonAlcohol.AddForm(item)
    EndIf
    i = i + 1
  EndWhile
EndFunction