ScriptName AUR:Fragments:Terminals:TerminalMenuCompanionInfo Extends TerminalMenu hidden

;-- Properties --------------------------------------

ObjectReference Property andrejaRef Auto Const Mandatory
ObjectReference Property BarrettREF Auto Const Mandatory
ObjectReference Property SamCoeREF Auto Const Mandatory
ObjectReference Property SarahMorganREF Auto Const Mandatory
ActorValue Property COM_Affinity Auto Const Mandatory
ActorValue Property COM_AffinityLevel Auto Const Mandatory
ActorValue Property COM_AngerLevel Auto Const Mandatory
ActorValue Property COM_IsCommitted Auto Const Mandatory
ActorValue Property COM_IsRomantic Auto Const Mandatory
GlobalVariable Property COM_AffinityLevel_0_Neutral Auto Const Mandatory
GlobalVariable Property COM_AffinityLevel_1_Friendship Auto Const Mandatory
GlobalVariable Property COM_AffinityLevel_2_Affection Auto Const Mandatory
GlobalVariable Property COM_AffinityLevel_3_Commitment Auto Const Mandatory
Message Property AffinityLevelNeutral Auto Const Mandatory
Message Property AffinityLevelFriend Auto Const Mandatory
Message Property AffinityLevelFriendAlly Auto Const Mandatory
Message Property AffinityLevelRomantic Auto Const Mandatory
Message Property AffinityLevelCommitted Auto Const Mandatory
Message Property AngerLevelNotAngry Auto Const Mandatory
Message Property AngerLevelAnnoyed Auto Const Mandatory
Message Property AngerLevelAngry Auto Const Mandatory
Message Property AngerLevelFurious Auto Const Mandatory

;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  ; Current Affinity
  akTerminalRef.AddTextReplacementValue("AndrejaAffinity", andrejaRef.GetValue(COM_Affinity))
  akTerminalRef.AddTextReplacementValue("BarrettAffinity", BarrettREF.GetValue(COM_Affinity))
  akTerminalRef.AddTextReplacementValue("SamAffinity", SamCoeREF.GetValue(COM_Affinity))
  akTerminalRef.AddTextReplacementValue("SarahAffinity", SarahMorganREF.GetValue(COM_Affinity))

  ; Current Relationship
  akTerminalRef.AddTextReplacementData("AndrejaAffinityLevel", GetCurrentAffinityLevel(andrejaRef))
  akTerminalRef.AddTextReplacementData("BarrettAffinityLevel", GetCurrentAffinityLevel(BarrettREF))
  akTerminalRef.AddTextReplacementData("SamAffinityLevel", GetCurrentAffinityLevel(SamCoeREF))
  akTerminalRef.AddTextReplacementData("SarahAffinityLevel", GetCurrentAffinityLevel(SarahMorganREF))

  ; Current Anger
  akTerminalRef.AddTextReplacementData("AndrejaAngerLevel", GetAngry(andrejaRef))
  akTerminalRef.AddTextReplacementData("BarrettAngerLevel", GetAngry(BarrettREF))
  akTerminalRef.AddTextReplacementData("SamAngerLevel", GetAngry(SamCoeREF))
  akTerminalRef.AddTextReplacementData("SarahAngerLevel", GetAngry(SarahMorganREF))
EndEvent

Message Function GetCurrentAffinityLevel(ObjectReference akCompanion)
  Message msgCompanionRelationship = AffinityLevelNeutral
  Int fAffinityLevel = akCompanion.GetValue(COM_AffinityLevel) as Int
  bool bIsCommitted = akCompanion.GetValue(COM_IsCommitted) as bool
  bool bIsRomantic = akCompanion.GetValue(COM_IsRomantic) as bool
  If bIsCommitted
    msgCompanionRelationship = AffinityLevelCommitted
  ElseIf bIsRomantic && !bIsCommitted
    msgCompanionRelationship = AffinityLevelRomantic
  ElseIf fAffinityLevel == COM_AffinityLevel_2_Affection.GetValueInt()
    msgCompanionRelationship = AffinityLevelFriendAlly
  ElseIf fAffinityLevel == COM_AffinityLevel_1_Friendship.GetValueInt()
    msgCompanionRelationship = AffinityLevelFriend
  ElseIf fAffinityLevel == COM_AffinityLevel_0_Neutral.GetValueInt()
    msgCompanionRelationship = AffinityLevelNeutral 
  EndIf
  return msgCompanionRelationship      
EndFunction

Message Function GetAngry(ObjectReference akCompanion)
  Message msgCompanionAnger = AngerLevelNotAngry
  Int fAngerLevel = akCompanion.GetValue(COM_AngerLevel) as Int
  If fAngerLevel == 0
    msgCompanionAnger = AngerLevelNotAngry
  ElseIf fAngerLevel == 1
    msgCompanionAnger = AngerLevelAnnoyed
  ElseIf fAngerLevel == 2
    msgCompanionAnger = AngerLevelAngry
  ElseIf fAngerLevel == 3
    msgCompanionAnger = AngerLevelFurious
  EndIf
  return msgCompanionAnger
EndFunction