ScriptName AUR:Fragments:Terminals:TerminalMenuAllFollowers Extends TerminalMenu hidden

;-- Properties --------------------------------------

SQ_FollowersScript Property SQ_Followers Auto Const Mandatory
SQ_CompanionsScript Property SQ_Companions Auto Const Mandatory
SQ_CrewScript Property SQ_Crew Auto Const Mandatory
SQ_PlayerShipScript Property SQ_PlayerShip Auto
ObjectReference Property PlayerRef Auto Const Mandatory

;-- Guards -----------------------------------------

Guard CommandGuard

;-- Events ------------------------------------------

Event TerminalMenuAllFollowers.WaitAllRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
    SQ_Followers.AllFollowersWait(None, True, False)
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.FollowAllRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
    SQ_Followers.AllFollowersFollow(None)
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.DismissAllRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
    Actor[] ActiveFollowersArray = SQ_Followers.GetFollowers(True, True)
    Int I = 0
    While I < ActiveFollowersArray.Length
      Actor currentFollower = ActiveFollowersArray[I]
      If currentFollower 
        If SQ_Companions.IsCompanionLockedIn(currentFollower as companionactorscript) == False && !SQ_Crew.IsEliteCrew(currentFollower)
          Utility.Wait(0.1)
          SQ_Companions.SetRoleInactive(currentFollower as companionactorscript, True, False, True)
        ElseIf SQ_Crew.IsEliteCrew(currentFollower)
          Utility.Wait(0.1)
          SQ_Crew.SetEliteCrewInactive(currentFollower, False)
        Else 
          Utility.Wait(0.1)
          SQ_Followers._CustomSetRoleInactive(currentFollower)
        EndIf
      EndIf
      I += 1
    EndWhile
    ; Just in case someone was missed - not using at the moment
    ; SQ_Followers.Alias_Active.Clear()
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.TeleportAndFollowRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
    SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, True, False, False)
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.TeleportAllAndWaitRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
   SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, False, True, True)
   Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.TeleportAllRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
   SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, True, False, False)
   Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuAllFollowers.TeleportToShipRequested(TerminalMenuAllFollowers akSender, Var[] akArgs)
  Guard CommandGuard
    SQ_Followers.AllFollowersWait(SQ_PlayerShip.HomeShipCrewMarker.GetRef(), False, False)
    Utility.Wait(0.01)
  EndGuard
EndEvent

;-- Functions ----------------------------------------

Function TerminalMenu_All_Wait(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_WaitAllRequested")
  SendCustomEvent("TerminalMenuAllFollowers_WaitAllRequested", None)
EndFunction

Function TerminalMenu_All_Follow(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_FollowAllRequested")
  SendCustomEvent("TerminalMenuAllFollowers_FollowAllRequested", None)
EndFunction

Function TerminalMenu_All_Dismiss(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_DismissAllRequested")
  SendCustomEvent("TerminalMenuAllFollowers_DismissAllRequested", None)
EndFunction

Function TerminalMenu_All_TeleportAndFollow(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_TeleportAndFollowRequested")
  SendCustomEvent("TerminalMenuAllFollowers_TeleportAndFollowRequested", None)
EndFunction

Function TerminalMenu_All_TeleportAndWait(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_TeleportAllAndWaitRequested")
  SendCustomEvent("TerminalMenuAllFollowers_TeleportAllAndWaitRequested", None)
EndFunction

Function TerminalMenu_All_TeleportToMe(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_TeleportAllRequested")
  SendCustomEvent("TerminalMenuAllFollowers_TeleportAllRequested", None)
EndFunction

Function TerminalMenu_All_TeleportAllToShip(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuAllFollowers_TeleportToShipRequested")
  SendCustomEvent("TerminalMenuAllFollowers_TeleportToShipRequested", None)
EndFunction