ScriptName AUR:Fragments:Terminals:TerminalMenuCompanions Extends TerminalMenu hidden

;-- Properties --------------------------------------

Perk Property CompanionCheckPerk Auto Const Mandatory
Quest Property CompanionQuest Auto Const Mandatory
ObjectReference Property CompanionRef Auto Const Mandatory
ObjectReference Property PlayerRef Auto Const Mandatory
Quest Property SQ_Companions Auto Const Mandatory

;-- Guards -----------------------------------------

Guard CommandGuard

;-- Events ------------------------------------------

Event TerminalMenuCompanions.SetAsMainRequested(TerminalMenuCompanions akSender, Var[] akArgs)
  Guard CommandGuard
    (SQ_Companions as SQ_CompanionsScript).SetMainCompanion(CompanionRef, CompanionQuest, CompanionCheckPerk)
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuCompanions.WaitRequested(TerminalMenuCompanions akSender, Var[] akArgs)
  Guard CommandGuard
    com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
    compQuest.WaitSceneEnded()
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuCompanions.FollowRequested(TerminalMenuCompanions akSender, Var[] akArgs)
  Guard CommandGuard
    com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
    compQuest.FollowSceneEnded()
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuCompanions.DismissRequested(TerminalMenuCompanions akSender, Var[] akArgs)
  Guard CommandGuard
    com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
    compQuest.DismissSceneEnded()
    Utility.Wait(0.01)
  EndGuard
EndEvent

Event TerminalMenuCompanions.TeleportRequested(TerminalMenuCompanions akSender, Var[] akArgs)
  Guard CommandGuard
    companionactorscript Companion = CompanionRef as companionactorscript
    bool isActive = (SQ_Companions as SQ_CompanionsScript).IsActiveCompanion(CompanionRef as Actor)
    ; Make sure companion is not empty
    If Companion
      ; If companion is not active, teleport to player and hire them
      If !isActive
        CompanionRef.MoveTo(PlayerRef, 0.0, 0.0, 0.0, True, True)
        com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
        compQuest.PickupSceneEnded()
        Utility.Wait(0.01)
      Else
        CompanionRef.MoveTo(PlayerRef, 0.0, 0.0, 0.0, True, True)
        Utility.Wait(0.01)
      EndIf
    EndIf
  EndGuard
EndEvent

;-- Functions ---------------------------------------

Function TerminalMenu_Companions_SetAsMain(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuCompanions_SetAsMainRequested")
  SendCustomEvent("TerminalMenuCompanions_SetAsMainRequested", None)
EndFunction

Function TerminalMenu_Companions_Wait(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuCompanions_WaitRequested")
  SendCustomEvent("TerminalMenuCompanions_WaitRequested", None)
EndFunction

Function TerminalMenu_Companions_Follow(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuCompanions_FollowRequested")
  SendCustomEvent("TerminalMenuCompanions_FollowRequested", None)
EndFunction

Function TerminalMenu_Companions_Dismiss(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuCompanions_DismissRequested")
  SendCustomEvent("TerminalMenuCompanions_DismissRequested", None)
EndFunction

Function TerminalMenu_Companions_Teleport(ObjectReference akTerminalRef)
  RegisterForCustomEvent(self, "TerminalMenuCompanions_TeleportRequested")
  SendCustomEvent("TerminalMenuCompanions_TeleportRequested", None)
EndFunction