Scriptname CS7_SpaceShipLandingScript extends Quest
{Quest script for SpaceShipLandingReloaded.esm}

sq_playershipscript Property SQ_PlayerShip Auto
sq_followersscript Property SQ_Followers Auto
Keyword Property SpaceshipEnabledLandingLink Auto
Keyword Property CurrentInteractionLinkedRefKeyword Auto
Keyword Property SpaceshipPreventRampOpenOnLanding Auto
LocationRefType Property Ship_PilotSeat_RefType Auto


spaceshipreference playerShipRef
Bool bPlayerInShipPilotSeat
Bool bFollowersArePaused
Int FailSafeTimer = 10


EVENT OnQuestInit()
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnSit") 
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnGetUp") 
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
ENDEVENT


EVENT Actor.OnPlayerLoadGame(Actor akSender)
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnSit") 
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnGetUp") 
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
	
	If (Game.IsPluginInstalled("SpaceShipLandingReloaded.esm") == False)
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnSit") 
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnGetUp")
		CancelTimer(FailSafeTimer)
		Self.Stop()
	EndIf
ENDEVENT


EVENT OnTimer(Int aiTimerID)
	If aiTimerID == FailSafeTimer
		if SQ_PlayerShip.PlayerShip.GetShipRef().IsLanded()
			Self.UnregisterAndResetMod()
		else
			StartTimer(1.0, FailSafeTimer)
		endif
	EndIf
ENDEVENT


EVENT Actor.OnSit(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = True
    EndIf
ENDEVENT


EVENT Actor.OnGetUp(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = False
    EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipFarTravel(ReferenceAlias akSender, Location aDepartureLocation, Location aArrivalLocation, Int aState)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	planet thePlanetOrbit = aDepartureLocation.GetCurrentPlanet()
	planet thePlanetSurface = aArrivalLocation.GetCurrentPlanet()
	If ((akSender != SQ_PlayerShip.PlayerShip) || (aState == 1) || (thePlanetOrbit != thePlanetSurface) || playerShipRef.IsLanded())
		RETURN
	Else
		CancelTimer(FailSafeTimer)
		Self.PauseCrewAndFollowers()
		playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
		Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
		Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		StartTimer(6.0, FailSafeTimer)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnLocationChange(ReferenceAlias akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
	If (akSender != SQ_PlayerShip.PlayerShip) || (akOldLoc == akNewLoc) || bPlayerInShipPilotSeat || Game.GetPlayer().GetParentCell().IsInterior() || (akNewLoc != Game.GetPlayer().GetCurrentLocation())
		playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
		Self.UnpauseCrewAndFollowers()
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	Else
		Game.FadeOutGame(False, True, 10.0, 0.00015, False)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	CancelTimer(FailSafeTimer)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If !bPlayerInShipPilotSeat
		ObjectReference LandingMarker = Self.GetShipLandingMarker(playerShipRef)
		if (LandingMarker as Bool)
			playerShipRef.MoveTo(LandingMarker, 0.0, 0.0, 155.0, True, False)
			Game.FadeOutGame(False, True, 5.0, 0.00015, False)
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			if playerShipRef.IsRampDown()
				Self.OpenOrCloseLandingRamps(playerShipRef, False)
			endif
			Self.MovePlayerIntoPilotSeat(SQ_PlayerShip.PlayerShipPilotSeat.GetRef())
			Game.FadeOutGame(False, True, 1.0, 0.5, False)
			playerShipRef.SetLinkedRef(LandingMarker, SpaceshipEnabledLandingLink, True)
			playerShipRef.EnableWithLanding()
			Utility.Wait(0.01)
			playerShipRef.SetAngle(LandingMarker.GetAngleX(), LandingMarker.GetAngleY(), LandingMarker.GetAngleZ())
		else
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			Game.FadeOutGame(False, True, 0.0, 0.1, False)
			if !playerShipRef.IsRampDown()
				Self.OpenOrCloseLandingRamps(playerShipRef, True)
			endif
		endif
		Self.UnpauseCrewAndFollowers()
	EndIf
	StartTimer(2.0, FailSafeTimer)
ENDEVENT


ObjectReference Function GetShipLandingMarker(spaceshipreference akShip)
	ObjectReference theLandingMarker
	ObjectReference MarkerRef = akShip.GetLinkedRef(SQ_PlayerShip.LandingMarkerKeyword)
	If MarkerRef && (MarkerRef.GetDistance(Game.GetPlayer()) < 200)
		theLandingMarker = MarkerRef
	Else
		MarkerRef = akShip.GetLinkedRef(CurrentInteractionLinkedRefKeyword)
		If MarkerRef && (MarkerRef.GetDistance(Game.GetPlayer()) < 150)
			theLandingMarker = MarkerRef
		EndIf
	EndIf
	Return theLandingMarker
EndFunction


Function MovePlayerIntoPilotSeat(ObjectReference akPilotSeat)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	inputenablelayer myEnableLayer = inputenablelayer.Create()
	myEnableLayer.DisablePlayerControls(True, True, True, False, False, True, True, False, True, True, False)
	Game.GetPlayer().MoveTo(playerShipRef as ObjectReference, 0.0, 0.0, 0.0, True, False)
	Game.PopPlayerTo(akPilotSeat, 0.0, 0.0, 0.0, True, False)
	Game.GetPlayer().SnapIntoInteraction(akPilotSeat)
	Utility.Wait(0.01)
	myEnableLayer.Delete()
EndFunction


Function OpenOrCloseLandingRamps(spaceshipreference akShip, Bool bOpen = True)
	ObjectReference[] landingRamps = playerShipRef.GetLandingRamps()
	If (landingRamps != None)
		Int i = 0
		While i < landingRamps.Length
			landingRamps[i].SetOpen(bOpen)
			i += 1
		EndWhile
	EndIf
EndFunction

Actor[] crewMembers
Actor[] currentFollowers
Function PauseCrewAndFollowers()
	bFollowersArePaused = True
	crewMembers = playerShipRef.GetAllCrewMembers()
	int i = 0
	While (i < crewMembers.Length)
		crewMembers[i].SetUnconscious(True)
		i += 1
	EndWhile
	currentFollowers = Game.GetPlayerFollowers()
	i = 0
	While (i < currentFollowers.Length)
		SQ_Followers.SetRoleInactive(currentFollowers[i], False, False, False)
		i += 1
	EndWhile
EndFunction


Function UnpauseCrewAndFollowers()
	bFollowersArePaused = False
	int i = 0
	While (i < crewMembers.Length)
		crewMembers[i].SetUnconscious(False)
		i += 1
	EndWhile
	i = 0
	While (i < currentFollowers.Length)
		SQ_Followers.SetRoleActive(currentFollowers[i], False, True, 0.0, 0.0)
		SQ_Followers.CommandFollow(currentFollowers[i])
		currentFollowers[i].EvaluatePackage(False)
		i += 1
	EndWhile
EndFunction


Function UnregisterAndResetMod()
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
	if !playerShipRef.IsRampDown()
		Self.OpenOrCloseLandingRamps(playerShipRef, True)
	endif
	if bFollowersArePaused
		Self.UnpauseCrewAndFollowers()
	endif
EndFunction
		