scriptname WT_Functions extends Quest

;;;;;;;;;;;;;;;;;PROPERTIES;;;;;;;;;;;;;;;;;;;;

WT_Manager_Script Property WT_Manager auto
Actor Property PlayerRef auto 

;;;;;;;;;;;;;;;Functions used to Store items to AVIFs;;;;;;;;;;;;;;;;;;;;;;;;

Function StoreBaseObject(int akItemSlot, ActorValue[] akAVIFtoStore, ActorValue[] akAmmoAVIF = none)
    If akItemSlot == 0                                                                                        ; 0 = Weapon. Get the ammo first and store it. Then unequip weapon to continue on PlayerAlias script
        form base_weapon = PlayerRef.GetEquippedWeapon(0) as form                                             ; Get the weapon type which determines the ammo used        
        StoreAmmoInAVIF(base_weapon, akAmmoAVIF)                                                              ; First deal with the ammo and remove it from inventory
        PlayerRef.unequipitem(base_weapon, false, true)                                                       ; Unequip the weapon
    Else
        PlayerRef.UnequipItemSlot(akItemSlot)                                                                 ; Unequip the armor slot
    EndIF
        utility.wait(0.1)                                                                                     ; Wait for Player to finish unequipping item
        StoreFormIDInAVIF(akAVIFtoStore[0], none, 0)                                                                
EndFunction

Function StoreAmmoInAVIF(form akWeaponform, ActorValue[] akAmmoAVIF)                                        ; Find out what ammo is equipped, and how much
    form base_ammo = PlayerRef.GetEquippedWeapon(0).GetAmmo() as form
    int AmmoAmount = PlayerRef.getitemcount(base_ammo)
    int Ammo_formid = base_ammo.getformid()
    PlayerRef.setvalue(akAmmoAVIF[0], Ammo_formid)                                                          ; 0: Ammo FormID
    PlayerRef.setvalue(akAmmoAVIF[1], AmmoAmount)                                                           ; 1: integer amount of ammo
    PlayerRef.unequipitem(base_ammo, false, true)                                                           ; Unequip ammo - may not be needed
    Utility.wait(0.1)
    PlayerRef.removeItem(base_ammo, -1, true, none)                                                         ; Remove from inventory now so it doesn't interfere with getting weapon info
EndFunction

Function StoreFormIDInAVIF(ActorValue akAVIF, ObjectMod akOmod = none, int akIndex)
    int formid = 0

    If akIndex == 0                                                                                             ; If dealing the base object
        If !WT_Manager.Item_Alias.getReference()                                                                ; Error capture, abort since no item
            return
        EndIf
        
        formid = WT_Manager.Item_Alias.getReference().getbaseobject().getformid()                               ; gets the base object formid
        PlayerRef.setvalue(akAVIF, formid)
        return
    EndIf
                                                                                                                ; If dealing with OMODs
    If !akOmod                                                                                                  ; Error capture, no OMOD so exit
        return
    EndIf

    formid = akOmod.getformid()
    PlayerRef.setvalue(akAVIF, formid)
EndFunction

Function FindAndStoreOMODs(int akItemSlot, ActorValue[] akAVIFtoStore, keyword akItemKeyword) 
    If akItemKeyword                                                                                            ; Keep looking for OMODs for helmets, suits, packs
        int AVIFindex = 1
        While AVIFindex < akAVIFtoStore.length
            GetMods(akItemSlot, akAVIFtoStore, akItemKeyword, AVIFindex)                                        
            AVIFindex += 1
        EndWhile
    EndIf
EndFunction 

Function GetMods(int akItemSlot, ActorValue[] akAVIFtoStore, keyword akItemKeyword = none, int akAVIFindex)
    ObjectMod OMODToStore = none
    ObjectMod[] TempWeaponQualityOMODs
    bool IsLegendary = false
    WT_Struct_Definitions:SlotStruct[] SlotArrayToCheck

    If akAVIFindex == 1                                                                                         ; Gets the Quality Slot
        If akItemKeyword == WT_Manager.WeaponKeyword                                                            ; Handling for the weapon, requires different functions
            TempWeaponQualityOMODs = GetWeaponQualityOMOD()
            StoreWeaponQualityFormIDsInAVIF(akAVIFtoStore, TempWeaponQualityOMODs)
            return            
        Else        
            OMODToStore = GetArmorQualityOmod(WT_Manager.GeneralArmorQualitySlot, akItemKeyword)
            StoreFormIDInAVIF(akAVIFtoStore[akAVIFindex], OMODToStore, akAVIFindex)                                    ; Store the Quality OMOD to an AVIF
            return                             
        EndIF
    EndIf
                                                                                                                ; Gets all other OMODs
    SlotArrayToCheck = GetSlotArrayToCheck(akAVIFindex, akItemKeyword)                                          ; Determine the Slot 
;    debug.trace("WT log: Just before isLegendary: " + akItemSlot + ":" + akAVIFtoStore + ":" + akItemKeyword + ":" + akAVIFindex, 0)
    IsLegendary = CheckIfLegendaryList(akAVIFindex)                                                             ; Flag if it is a Legendary Slot since a different Struct       
    OMODToStore = GetSlotOMOD(SlotArrayToCheck, akItemKeyword, IsLegendary)                                                       
    StoreFormIDInAVIF(akAVIFtoStore[akAVIFindex], OMODToStore, akAVIFindex)                                       
    return
EndFunction



;;;;;;;;;;;;;;;;;;Functions to find OMODs depending on the STRUCT type;;;;;;;;;;;;;;;;;;;
Function StoreWeaponQualityFormIDsInAVIF(ActorValue[] akAVIFtoStore, ObjectMod[] TempWeaponQualityOMODs)         ; There are 4 weapon quality OMODs per weapon. We store all 4 pre-unity so they can be removed and then applied in order to the required level
    int i = 0
    While i < TempWeaponQualityOMODs.length
        StoreFormIDInAVIF(akAVIFtoStore[i+1], TempWeaponQualityOMODs[i], i+1)                                    ; AVIF array   1: Quality 1 OMOD   3: Quality 3 OMOD 
        i += 1                                                                                                   ;              2: Quality 2 OMOD   4: Quality 4 OMOD
    EndWhile
EndFunction

ObjectMod Function GetArmorQualityOmod(WT_Struct_Definitions:QualityStruct[] akQualityListToCheck, keyword akArmorType)          ; If a quality keyword is found on the armor, return the OMOD                  
    int i = 0
    While i < akQualityListToCheck.length
        If  WT_Manager.Item_Alias.getReference().HasKeyword(akQualityListToCheck[i].QualityKYWD) && akQualityListToCheck[i].ArmorKYWD == akArmorType
            return akQualityListToCheck[i].OMOD
        EndIf
    i+=1
    EndWhile
EndFunction

ObjectMod[] Function GetWeaponQualityOMOD()                                                     ; Creates an array of all 4 quality OMODs associated with that weapon
    int index = -1
    ObjectMod[] WeaponQualityOMODs = new ObjectMod[5]
    Keyword WeaponType = DeterminePlayerWeaponType(WT_Manager.Item_Alias.getReference())
    int WeaponArrayToCheck = GetWeaponArrayToCheck()                                            ; Find which Quality Keyword is on the player's weapon
    index = WT_Manager.WeaponQuality4.FindStruct("NameKYWD", WeaponType, 0)                     ; Each QualityStructArray has the same order, doesn't matter which one we search
    int i = 4
    While i >=1
        If i == 4
            WeaponQualityOMODs[i-1] = WT_Manager.WeaponQuality4[index].OMOD
        ElseIf i == 3
            WeaponQualityOMODs[i-1] = WT_Manager.WeaponQuality3[index].OMOD
        ElseIf i ==2
            WeaponQualityOMODs[i-1] = WT_Manager.WeaponQuality2[index].OMOD
        Else
            WeaponQualityOMODs[i-1] = WT_Manager.WeaponQuality1[0].OMOD
        EndIf
        i -= 1
    EndWhile
    PlayerRef.setvalue(WT_Manager.WeaponAVIFArray[5], WeaponArrayToCheck)                       ; 5: Stores the Quality level of the current weapon as an integer
    If index < 0
        debug.trace("Error, Weapon Quality OMOD not found", 0)
    EndIf
    return WeaponQualityOMODs
EndFunction    
    
ObjectMod Function GetSlotOMOD(WT_Struct_Definitions:SlotStruct[] akArmorSlotToCheck, keyword akArmorType = none, bool IsLegendary)
    int i = 0                                                                                   ; Finds the OMOD on the current slot
    While i < akArmorSlotToCheck.length
        If IsLegendary                                                                          ; If Legendary, we don't need to check armor type
            If  WT_Manager.Item_Alias.getReference().HasKeyword(akArmorSlotToCheck[i].NameKYWD)
                return akArmorSlotToCheck[i].OMOD
            EndIf
        ElseIf  WT_Manager.Item_Alias.getReference().HasKeyword(akArmorSlotToCheck[i].NameKYWD) && akArmorSlotToCheck[i].ArmorKYWD == akArmorType
            return akArmorSlotToCheck[i].OMOD
        EndIf
        i+=1
    EndWhile
EndFunction

;;;;;;;;;;;;;;;;;;;;;;;;;;;Helper Functions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

keyword Function DeterminePlayerWeaponType(form akWeapon)
    int i = 0
    While i < WT_Manager.WeaponKeywordArray.length                                                              
        If akWeapon.HasKeyword(WT_Manager.WeaponKeywordArray[i])
            return WT_Manager.WeaponKeywordArray[i]
        EndIf
        i += 1
    EndWhile
EndFunction


int Function GetWeaponArrayToCheck()
    If  WT_Manager.Item_Alias.getReference().HasKeyword(WT_Manager.WeaponQuality4Keyword)
        ;debug.trace("WT log: QUALITY 4 DETECTED", 0)
        return 4
    ElseIf WT_Manager.Item_Alias.getReference().HasKeyword(WT_Manager.WeaponQuality3Keyword)
        ;debug.trace("WT log: QUALITY 3 DETECTED", 0)
        return 3
    ElseIf WT_Manager.Item_Alias.getReference().HasKeyword(WT_Manager.WeaponQuality2Keyword)
        ;debug.trace("WT log: QUALITY 2 DETECTED", 0)
        return 2
    Else
        return 1
    EndIf
    ;debug.trace("WT log: NO QUALITY LEVEL DETECTED", 0)
EndFunction


WT_Struct_Definitions:SlotStruct[] Function GetSlotArrayToCheck(int akAVIFindex, keyword akItemKeyword)                                   ; Ugly ugly ugly, look away 
    
    If akItemKeyword == WT_Manager.WeaponKeyword
        If akAVIFindex == 6
            return WT_Manager.WeaponLegendarySlot1
        ElseIf akAVIFindex == 7
            return WT_Manager.WeaponLegendarySlot2
        ElseIf akAVIFindex == 8
            return WT_Manager.WeaponLegendarySlot3
        EndIf 
        return
    ElseIf akAVIFindex == 2
        return WT_Manager.ArmorSlot1
    ElseIf akAVIFindex == 3
        return WT_Manager.ArmorSlot2
    ElseIf akAVIFindex == 4
        return WT_Manager.ArmorSlot3
    ElseIf akAVIFindex == 5 && akItemKeyword == WT_Manager.BackpackKeyword
        return WT_Manager.BoostSlot
    ElseIF akAVIFindex == 5
        return WT_Manager.ArmorSlot4
    ElseIf akAVIFindex == 6
        return WT_Manager.ArmorLegendarySlot1
    ElseIf akAVIFindex == 7
        return WT_Manager.ArmorLegendarySlot2
    ElseIf akAVIFindex == 8
        return WT_Manager.ArmorLegendarySlot3
    EndIf 
EndFunction


bool Function CheckIfLegendaryList(int akAVIFindex)
    If akAVIFindex == 6 || akAVIFindex == 7 || akAVIFindex == 8
        return true
    EndIf
    return false
EndFunction

;;;;;;;;;;;;;;;;;;;;;Functions used to create items during Starborn start;;;;;;;;;;;;;;;;;;;;; 

Form Function AVIFToForm(ActorValue[] akItemAVIFArray, int index)
    int ItemDecimalFormID = PlayerRef.getvalue(akItemAVIFArray[index]) as int                                   ; Get the formID from the AVIF, and return the form
    form ItemToAdd = game.getform(ItemDecimalFormID)
    return ItemToAdd
EndFunction

Function CreateBaseObject(form akTempForm, referencealias akUnityAlias)
    If PlayerRef.getitemcount(akTempForm) <= 0                                                          ; Place base object in player inventory so we can add OMODs to it
        PlayerRef.additem(akTempForm, 1, true)
    Else
        debug.trace("WT: CBO: Player already has item, exiting", 0)
        return
    EndIf

    If akUnityAlias == WT_Manager.UnityHat || akUnityAlias == WT_Manager.UnityClothes || akUnityAlias == WT_Manager.UnityNeuroamp
        ;debug.trace("WT: CBO: Hat, clothes, or Neuroamp so exit", 0)                                   ; These items don't have OMODs, so equip and exit early
        PlayerRef.equipitem(akTempForm, false, true)
        return
    EndIF
EndFunction

Function WriteToLog(ActorValue[] akAVIFArray)
    int i = 0
    debug.trace("WT log: AVIF Array: " + akAVIFArray, 0)
    While i < akAVIFArray.length
        ;debug.trace("WT log: just before AVIFtoform: " + akAVIFArray + ":" + i, 0)
        If akAVIFArray[i]
            form Item = AVIFToForm(akAVIFArray, i)
            debug.trace("WT log: index: " + i + " Value: " +  (PlayerRef.getvalue(akAVIFArray[i]) as int) + " Form: " + Item, 0)
        Else
            debug.trace("WT log: index: " + i + " Value: None Form: None", 0)
        EndIf
        i+= 1
    EndWhile
EndFunction