scriptname WT_Manager_Script extends Quest

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;STRUCT PROPERTIES;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

WT_Struct_Definitions:QualityStruct[] Property GeneralArmorQualitySlot auto
; WT_Struct_Definitions:QualityStruct[] Property CF_ChargerQualitySlot auto             ; The CF armors have different quality OMODs that are slightly nerfed. Enjoy the better regular quality OMOD after Unity, too much work to implement for little benefit.
; WT_Struct_Definitions:QualityStruct[] Property CF_OfficerQualitySlot auto

WT_Struct_Definitions:SlotStruct[] Property ArmorSlot1 auto
WT_Struct_Definitions:SlotStruct[] Property ArmorSlot2 auto
WT_Struct_Definitions:SlotStruct[] Property ArmorSlot3 auto
WT_Struct_Definitions:SlotStruct[] Property ArmorSlot4 auto
WT_Struct_Definitions:SlotStruct[] Property BoostSlot auto
WT_Struct_Definitions:SlotStruct[] Property ArmorLegendarySlot1 auto
WT_Struct_Definitions:SlotStruct[] Property ArmorLegendarySlot2 auto
WT_Struct_Definitions:SlotStruct[] Property ArmorLegendarySlot3 auto
WT_Struct_Definitions:SlotStruct[] Property WeaponLegendarySlot1 auto
WT_Struct_Definitions:SlotStruct[] Property WeaponLegendarySlot2 auto
WT_Struct_Definitions:SlotStruct[] Property WeaponLegendarySlot3 auto

WT_Struct_Definitions:WeaponStruct[] Property WeaponQuality1 auto
WT_Struct_Definitions:WeaponStruct[] Property WeaponQuality2 auto
WT_Struct_Definitions:WeaponStruct[] Property WeaponQuality3 auto
WT_Struct_Definitions:WeaponStruct[] Property WeaponQuality4 auto

;;;;;;;;;;;;;;;;;;;;;;;;;;;PROPERTIES;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Index Values for AVIF Arrays
; 0 - Base Object
; 1 - Quality OMOD
; 2 - Slot 1
; 3 - Slot 2
; 4 - Slot 3/Boostpack
; 5 - Slot 4
; 6 - Legendary 1
; 7 - Legendary 2
; 8 - Legendary 3
; 9 - ENV Hazard -- Not implemented, should be (I hope) handled by the base object. If it's not, then remember it's a different universe you are in now and things may be different.
; 10 - Skin -- Not implemented because Constellation.esl and OldMars.esl cannot be masters since they are .esl

ActorValue[] Property HelmetAVIFArray auto                                                  
ActorValue[] Property BackpackAVIFArray auto
ActorValue[] Property SpacesuitAVIFArray auto
ActorValue[] Property ClothingHatAVIFArray auto
ActorValue[] Property ClothingAVIFArray auto
ActorValue[] Property NeuroAmpAVIFArray auto
ActorValue[] Property WeaponAVIFArray auto
ActorValue[] Property AmmoAVIFArray auto

Actor Property PlayerRef auto

Keyword Property HelmetKeyword auto
Keyword Property SpacesuitKeyword auto
Keyword Property BackpackKeyword auto
KeyWord Property WeaponKeyword auto
Keyword Property WeaponQuality2Keyword auto
Keyword Property WeaponQuality3Keyword auto
Keyword Property WeaponQuality4Keyword auto

Location Property UnityLocation auto

Keyword[] Property WeaponKeywordArray auto                              ; Unique keywords identifying each weapon type

Quest Property MQ101 auto
Quest Property MQ305 auto

referencealias Property Item_Alias auto                                 ; Storage for the item unequipped by player alias script
referencealias Property UnityClothes auto                               ; Aliased object reference of items to take through Unity.
referencealias Property UnityHat auto                                   ; Has to be aliased otherwise OMODs detach when unequipped
referencealias Property UnityHelmet auto
referencealias Property UnityPack auto
referencealias Property UnitySuit auto
referencealias Property UnityNeuroamp auto
referencealias Property UnityWeapon auto

WT_Functions Property WT_Function auto

;;;;;;;;;;;;;;;;;REFERENCE NOTES;;;;;;;;;;;;;;;;;;;;;;
;Unequip item slot 0 - weapon -- not actually true, but 0 unused and need a way to identify weapon since it is handled by a different function
;Unequip item slot 3 - clothes -- need to check first because some clothes have hats attached
;Unequip item slot 4 - clothing hat
;Unequip item slot 32 - helmet
;Unequip item slot 35 - spacesuit
;Unequip item slot 37 - pack
;Unequip item slot 18 - neuroamp - need to test

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;VARIABLES;;;;;;;;;;;;;;;;;;;;;;

int Property UNITY_STAGE = 1000 auto const 
int Property STARBORN_STAGE = 2000 auto const 

;;;;;;;;;;;;;;;MANAGER SCRIPT;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Event OnQuestInit()                                                             ; Register for quest stage changes to trigger code
          
    RegisterForRemoteEvent(MQ101 as scriptobject, "OnStageSet")                 ; MQ101 - New game start. Stage 2000 = Starborn start in your ship                             
    RegisterForRemoteEvent(MQ305 as scriptobject, "OnStageSet")
;    RegisterForRemoteEvent(PlayerRef, "OnLocationChange")                      ; MQ305 - Go to Unity. Stage 2000 = walking into Unity                                                                                                                              

EndEvent

Function GoIntoUnity()                                                          ; Checks your equipped gear and stores information in AVIFs to bring into NG+
    StoreObjectInAVIF(3, ClothingAVIFArray)                                     ; 1st parameter = item slot to unequip
    StoreObjectInAVIF(4, ClothingHatAVIFArray)
    StoreObjectInAVIF(18, NeuroAmpAVIFArray)                            
    StoreObjectInAVIF(32, HelmetAVIFArray, HelmetKeyword)
    StoreObjectInAVIF(35, SpacesuitAVIFArray, SpacesuitKeyword)
    StoreObjectInAVIF(37, BackpackAVIFArray, BackpackKeyword)
    StoreObjectInAVIF(0, WeaponAVIFArray, WeaponKeyword, AmmoAVIFArray)  
    WT_Log()  
    (self as quest).setstage(20)
EndFunction

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)
    If akSender == MQ101 && auiStageID == STARBORN_STAGE                        ; If it is a Starborn start, create the seven items
        CreateItemFromAVIF(HelmetAVIFArray, UnityHelmet)
        CreateItemFromAVIF(SpacesuitAVIFArray, UnitySuit)
        CreateItemFromAVIF(ClothingAVIFArray, UnityClothes)
        CreateItemFromAVIF(ClothingHatAVIFArray, UnityHat)
        CreateItemFromAVIF(BackpackAVIFArray, UnityPack)
        CreateItemFromAVIF(NeuroAmpAVIFArray, UnityNeuroamp)
        CreateItemFromAVIF(WeaponAVIFArray, UnityWeapon)
        CreateAmmoFromAVIF(AmmoAVIFArray)
        WT_Log()
    EndIf

EndEvent

;;;;;;;;;;;;;;;;;;;;;;;;STORE ITEM INFORMATION WHEN ENTERING UNITY;;;;;;;;;;;;;;;;;;

Function StoreObjectInAVIF(int akItemSlot, ActorValue[] akAVIFtoStore, keyword akItemKeyword = none, ActorValue[] akAmmoAVIF = none)
    Item_Alias.clear()
    WT_Function.StoreBaseObject(akItemSlot, akAVIFtoStore, akAmmoAVIF)
    WT_Function.FindAndStoreOMODs(akItemSlot, akAVIFtoStore, akItemKeyword)
EndFunction


;;;;;;;;;;;;;;;;;;;;;RETRIVE ITEMS DURING STARBORN START;;;;;;;;;;;;;;;;;

Function RemoveWeaponOMODsFromItem(form akForm)                                          ; Weapon spawns at random quality based on player level, so if we want the same 
    keyword WeaponType = WT_Function.DeterminePlayerWeaponType(akForm)                   ; as pre-Unity, we need to remove existing quality OMODs and reapply them in order
    int index = WeaponQuality4.FindStruct("NameKYWD", WeaponType, 0)                     ; I'm not fully sure it's needed, but there are reports that you need to apply them in order.
    PlayerRef.RemoveModFromInventoryItem(akForm, WeaponQuality4[index].OMOD)
    PlayerRef.RemoveModFromInventoryItem(akForm, WeaponQuality3[index].OMOD)
    PlayerRef.RemoveModFromInventoryItem(akForm, WeaponQuality2[index].OMOD)
    PlayerRef.RemoveModFromInventoryItem(akForm, WeaponQuality1[0].OMOD)
EndFunction

Function CreateItemFromAVIF(ActorValue[] akItemAVIFArray, referencealias akUnityAlias)

    int index = 0
    form ItemBaseForm                                                                   ; Base Object that we add each object mod to in order
    form OMODForm                                                                       ; The OMOD form we are retrieving and then adding to the Base Object
    ;debug.trace("CIFA: " + akItemAVIFArray + akUnityAlias, 0)
    
    While index < akItemAVIFArray.length
        ;debug.trace("Index:" + index, 0)
        OMODForm = WT_Function.AVIFToForm(akItemAVIFArray, index)
        
        If index == 0
            WT_Function.CreateBaseObject(OMODForm, akUnityAlias)                        ; This function adds the base object to player inventory
            ItemBaseForm = OMODForm
            If akUnityAlias == UnityWeapon                                               ; Store the base item. We need to store it in an Alias as well as a temp variable                                                                                   
                PlayerRef.MakeAliasedRefFromInventory(OMODForm, Item_Alias)              ; Have to store item in an alias, or the OMODs will detach when unequipped >:(
                RemoveWeaponOMODsFromItem(Item_Alias.getReference().getbaseobject())     ; Remove any Quality OMODs it spawned with before adding back our own
            EndIf
        Else                                                                             ; OMOD handling
            If akUnityAlias == UnityWeapon
                If index <= (PlayerRef.getvalue(akItemAVIFArray[5]) as int) || index >= 6   ; Only add quality mods up to the level defined in [5]. Start adding legendaries at [6]
                    PlayerRef.attachModToInventoryItem(Item_Alias.getReference().getbaseobject(), OMODForm as ObjectMod)
                EndIf                                                                                                                
            Else
                PlayerRef.attachModToInventoryItem(ItemBaseForm, OMODForm as ObjectMod)                 ; Attach the Armor OMODs
            EndIf
        EndIF
        index += 1
    EndWhile

    If akUnityAlias == UnityWeapon
        UnityWeapon = Item_Alias
        PlayerRef.equipitem(ItemBaseForm, false, true)
    Else
        PlayerRef.MakeAliasedRefFromInventory(ItemBaseForm, akUnityAlias)                   ; Have to store item in an alias, or the OMODs will detach when unequipped >:(
        PlayerRef.equipitem(ItemBaseForm, false, true)                                      
    EndIf
EndFunction

Function CreateAmmoFromAVIF(ActorValue[] akItemAVIFArray)
    form tempform = WT_Function.AVIFToForm(akItemAVIFArray, 0)
    PlayerRef.additem(tempform, PlayerRef.getvalue(akItemAVIFArray[1]) as int, true)
EndFunction

Function WT_Log()
    WT_Function.WriteToLog(ClothingHatAVIFArray)
    WT_Function.WriteToLog(ClothingAVIFArray)
    WT_Function.WriteToLog(NeuroAmpAVIFArray)
    WT_Function.WriteToLog(SpacesuitAVIFArray)
    WT_Function.WriteToLog(HelmetAVIFArray)
    WT_Function.WriteToLog(BackpackAVIFArray)
    WT_Function.WriteToLog(WeaponAVIFArray)
    WT_Function.WriteToLog(AmmoAVIFArray)
EndFunction