
-- ************************************************************************************************************
-- If you only have that .lua file, download the RGOG folder at https://www.nexusmods.com/nomanssky/mods/2791
--  in order to update the mod with AMUMSS.
-- place the "RGOG" folder inside the AMUMSS's root directory ( 1 folder above "ModScript" directory)
-- & RedmasModBuilder.lua inside AMUMSS's "ModScript" folder.
-- ***********************************************************************************************************
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- ---------------    You can configure the overhaul from the following VARs-       --------------------------
--------------------------------------------------------------------------------------------------------------
-- --------------                 Never change the **BUILDER** section                   ------------------
--------------------------------------------------------------------------------------------------------------
--            If you are a confirmed modder and you are wanting to add or to update the features do a 
--                               			CTRL+F **FEATURES**
--                                              to edit them
----------------------------------------------------------------------------
-- THIS LUA SCRIPT REQUIRES RGOG FRAMEWORK THAT YOU CAN DOWNLOAD AT https://www.nexusmods.com/nomanssky/mods/2791
-- https://discord.gg/KtY5kguX6p
----------------------------------------------------------------------------
INIT_PRESET ={
["MODNAME"] = "UNTITLED_MOD_EXAMPLE",--> change the mod name here
----------------------------------------------------------------------------
-- Don't forget to build again your mod after each vanilla updates ( it's better to wait 2 days before doing it in order to have all features updated)
-- Check for new version of that script after a vanilla update at https://www.nexusmods.com/nomanssky/mods/2791
-- When you change the mod name, don't forget to remove the previously named one inside the No Man's Sky "MODS" folder ( [NMSGAMEFOLDER] / GAMEDATA / PCBANKS / MODS )
-- I ve put alternative values in comments inside ""
----------------------------------------------------------------------------
	["VISUAL_OVERHAUL_FEATURES"] =
    {
        ["VISUAL_OVERHAUL"] = "ON", -- > this var {"OFF"} will disable all features under that node 
        --
        ["REDMAS_WATER_REFLECTIONS"] = "ON", -- {"OFF"} / redmas water mod -- Creates foam , waves and reflections on water --> it makes it look more realistic       
        ["SPACE_BLUR_FEATURE"] = "ON", -- {"OFF"} This value will create a blur effect while in space -- /!\ with this var on you have to activate DepthOfField in photomode   -- Ctrl+F "SPACE_BLUR_FEATURE" to edit it   
        ["FILTERS_SWAP_FEATURE"] = "ON", -- {"OFF"} with this value on, default filter are replaced with brighter ones 
        -- BINOCULARS_TYPE SUN value will replace the binoclar filter with a vintage filter,
        -- BINOCULARS_TYPE Clear will remove the visual filter when using binoculars  -- Ctrl+F "FILTERS_SWAP_FEATURE" to edit it   
        ["BINOCULARS_TYPE"] = "CLEAR", -- {"SUN"} / {"CLEAR"}  
        ["SPEED_EFFECTS_REDUCER_FEATURE"] = "ON", -- {"OFF"} / This will reduce the speed lines while using the pulse warp in solar systems
        -- SPACESHIPS_TRAILS_TYPE REALISTIC : No visible trails for player and AI spaceships - Enemies and allies trails are visible during spaceships combat
        -- SPACESHIPS_TRAILS_TYPE E3 : restore the previous spaceship trails of NMS ( Pre-NEXT update)
        ["SPACESHIPS_TRAILS_TYPE"] = "E3",  -- ( {"REALISTIC"} / {"VANILLA"} / {"E3"} )
        -- REALISTIC SPACE_COLOURS_TYPE Make space much darker( but not always full black) - it can be combined with ULTRA_DIVERSE_SPACE_COLOURS option ON
        -- SPACE_COLOURS_TYPE ON is vanilla unless you use the ULTRA_DIVERSE_SPACE_COLOURS option ON 
        -- FANTASY SPACE_COLOURS_TYPE Make all space darker ( but still colorful) - it can be combined with ULTRA_DIVERSE_SPACE_COLOURS option ON
        ["SPACE_COLOURS_TYPE"] = "FANTASY", -- ({"REALISTIC"} / {"ON"} / {"FANTASY"} )
        -- REALISTIC ASTEROIDS_FIELDS_TYPE this meant to make astroid fields more natural ( this can be adjusted if you ctrl+F **ASTEROIDS_FIELDS_SPACING_PRESETS** to edit the spacing)
        -- FANTASY ASTEROIDS_FIELDS_TYPE this meant to make astroid easier to flight around ( very spaced and smaller) ( this can be adjusted if you ctrl+F **ASTEROIDS_FIELDS_SPACING_PRESETS** to edit the spacing)
        -- GLUED ASTEROIDS_FIELDS_TYPE this will make asteroids packed, like they are in vanilla, but with more spacing ( this can be adjusted if you ctrl+F **ASTEROIDS_FIELDS_SPACING_PRESETS** to edit the spacing)
        ["ASTEROIDS_FIELDS_TYPE"] = "FANTASY", -- ({"FANTASY"}  / {"REALISTIC"} / {"GLUED"})
        -- FIGHTERS_SPACESHIPS_REPAINT ON for Dirty looking metal spaceships ( allows to see fighters base colors) CTRL + F **SPACESHIPS_REPAINT** to edit it 
        -- FIGHTERS_SPACESHIPS_REPAINT FULL for full metal spaceships ( do not allows to see fighters base colors) CTRL + F **SPACESHIPS_REPAINT** to edit it 
        ["FIGHTERS_SPACESHIPS_REPAINT"] = "ON",  -- {"ON"} / {"FULL"} / {"OFF"} ( METALIC SPACESHIP MOD )
        ["DROPSHIPS_SPACESHIPS_REPAINT"] = "ON", -- {"ON"} / {"OFF"} -- ( METALIC SPACESHIP MOD ) CTRL + F **SPACESHIPS_REPAINT** to edit it 
        ["SHUTTLE_SPACESHIPS_REPAINT"] = "ON", -- {"ON"} / {"OFF"} ( METALIC SPACESHIP MOD ) CTRL + F **SPACESHIPS_REPAINT** to edit it 
        --
    },
    -----------------------------------------------------------------------------------------------------------

    ["MENU_OVERHAUL_FEATURES"] =
    { -- You can Edit the Pictures inside  RGOG/IMAGES/ to customise the screens
        -- Edit them with paintdotnet tool for example 
        -- You can download a background at https://wall.alphacoders.com/by_sub_category.php?id=226189&name=No+Man%27s+Sky+Wallpapers
        ---------------------------------------------------------------------------------------------------------------------------
        -- Trick for creating your own image:
        -- 1 open with paintdotnet _TEMPLATE.DDS in ../RGOG/IMAGES/
        -- 2 open with paintdotnet the image that you want to add ( + edit it if you want )
        -- 3 Edit > select all + Edit>copy on the image that you want to add
        -- 4 go to the template image .dds already open in paintdotnet ( you did it in step 1)
        -- 5 Edit > Paste in a new layer ( dont adjust the image area when asked to )
        -- 6 save as a new .DDS inside ../RGOG/IMAGES/
        ---------------------------------------------------------------------------------------------------------------------------
        -- Copy paste the dds images names from ../RGOG/IMAGES/ and paste them here
        ["HELLO_GAMES_SPASH_SCREEN"] = "SCIFIPAINT",  -- "","HG-E3-1"  or another img name from ../RGOG/IMAGES
        -- This is the first loading Screen
        ["ENGINE_SPASH_SCREEN"] = "E3-SHIPS", --  "" , "E-E3-1"   or another img name from ../RGOG/IMAGES
        -- This is the seconf loading Screen
        ["NMS_TITLE"] = "TITLE-ATLAS", --  "" , "TITLE-WAYPOINT"   or another img name from ../RGOG/IMAGES
        -- this will replace the title loading screen
        ["MENU_SPLASH_SCREEN"] = "PRE-RELEASE4", --  "" , "E3-RUINS"   or another img name from ../RGOG/IMAGES
        -- this will replace the Menus Screens
        ["TRANSPARENT_OPTIONS_MENU"] = "OFF", -- -- this var is not used anymore because it was impossibe to read the menus in some situations
    },
    ["CAMERA_FEATURES"] =
    {
	    ["CAMERA_OVERHAUL_FEATURE"] = "ON", -- "ON"/"OFF" this value enable the camera changes
        -- ( larger FOV , exocrafts cam improvements for mining from exocrafts, camera is more far during system warp)
        -- CTRL+F **CAMERA_OVERHAUL_FEATURES** to edit the changes
	    ["CAMERA_NO_SHAKE_FEATURE"] = "ON",
        -- this is different from the game menu no shake : this changes will remove shaking for everything exept getting hit, sandworms , and volcanos.
        -- it can be combine with the vanilla camera shakes adjustement
        -- I suggest to use it, in order to have a feeling of danger and to be in rare situations
	    ["CENTERED_CAMERA_FEATURE"] = "OFF", -- this var is not used anymore -- had a cam auto move bug / felt unconfortable to use
    },
    ["GAMEPLAY_FEATURES"] =
    {
        ["GAMEPLAY_OVERHAUL"] = "ON",   
        ["QOL_FEATURES"] =
        {
            -- Quality of Life features
            ["ADVANCED_BODY_SHAPES_FEATURE"] = "ON", -- "ON"/"OFF"  more character shape customisations -- vanilla have 5 body types, this mod will add 20 in between body shapes
            ["MINING_SPEED"] = "10", -- 2 to 10 (10 = REDMAS INSTANT MINING mod) -- adjust the mining speed. it works by reducing all props lifebar / health
            ["NEW_INTERACTIONS_FEATURE"] = "ON", -- "ON"/"OFF"  ( New Gameplay Mechanics ) -- add new interactions to decorations - add useful stuff in hangars - reworks freighters bridge
            ["ADVANCED_BUILDS_FEATURE"] = "ON", --  "ON"/"OFF"  ( more buildable objects on freighter planets and settlements )
            ["FREE_POWER_ON_EM_GENERATORS"] = "ON", -- "ON"/"OFF"   ( electro magnetic generator always give power with that value on )
        },
        ["ONFOOT_GAMEPLAY_FEATURES"] =
        {
            ["ONFOOT_CONTROLS_REVISON_FEATURE"] = "ON",    
            -- Character movements polishing -- since NMS 4.25 it also improve the capes movements
            ["LONGER_STEALTH_FEATURE"] = "OFF", -- "ON"/"OFF" 
            ["FASTER_WALK_WHILE_SHIELDING_FEATURE"] = "ON", -- "ON"/"OFF" 
            ["PLAYER_IS_WALKING_INSTEAD_OF_JOGGING_FEATURE"] = "OFF", -- "ON"/"OFF" 
            ["CONTROLLED_FALL_ANIMATION_REPLACEMENT"] = "ON", -- "ON"/"OFF" 
            ["ONFOOT_COMBAT_REVISON_BETA_FEATURE"] = "ON", -- "ON"/"OFF" 
        },
        ["SPACESHIPS_GAMEPLAY_FEATURES"] =
        {
          ["HOVER_MODE"] = "ON", -- "ON"/"OFF" HOVERMODE FOR ALL SPACESHIPS
          ["SANKUKAI_SPACESHIPS_COMBAT"] = "ON", -- -- "ON"/"OFF"  player and AI spaceships controls rework 
        },
        ["VEHICLES_FEATURES"] =
        {
            ["EXOCRAFTS_CONTROLS_REVISON_FEATURE"] = "ON", -- "ON"/"OFF"  player and AI spaceships controls rework CTRL+F **VEHICULE_HANDLINGS** for editing it
            ["ADDITIONAL_EXOCRAFT_DRAGONFLY"] = "ON", -- "ON"/"OFF" this will add dragonfly unused exocraft with a custom model that can be summoned & customised at trading posts
            ["CUSTOM_NOMAD_EXOCRAFT"] = "OFF", -- "ON"/"OFF" this value ON will enable the custom model that i did for the nomad ( ball exocraft ) i am planing to add more models ( the hoverbike for example)
            ["CUSTOM_PILGRIM_EXOCRAFT"] = "ON", -- "ON"/"OFF" this value ON will enable the custom model that i did for the pilgrim: REDMASPOD v3 ( a KANEDA BIKE INSPIRED SKIN )
            ["CUSTOM_COLOSSUS_EXOCRAFT"] = "ON", -- "ON"/"OFF" "MAKO-A" ( "Mass Effect" Inspired custom model" for the colossus
            ["CUSTOM_ROAMER_EXOCRAFT"] = "ON", -- "ON"/"OFF" this value ON will enable the custom model that i did for the roamer : a more aggressive / sport car looking version of the vanilla roamer
            ["ROAMER_BIGWHEELS_FEATURE"] = "ON", -- "ON"/"OFF" this value on will add LARGER BEHIND WHEELS on the custom model for the roamer
            ["ROAMER_ADDITIONAL_LAMPS_FEATURE"] = "ON", -- "ON"/"OFF" this value on will add additional lamps on the custom model for the roamer ( i had to disable their light they were too strong )
            ["GIANT_MECHS_BETA_FEATURE"] = "ON", -- "ON"/"OFF" this value on will rescale both mechs ( player and sentinel ( because they are the same one for the game ))
            ["MECHS_SIZE_MULTIPLIER"] = 2,  -- ( "2" to "10" -- adviced size : 2 ) notice that this param requires a integer, not a string
        },
    },
    ["CREATURES_FEATURES"] =
    {
        ["CREATURES_OVERHAUL"] = "ON",   
        --
        ["CREATURES_HIGH_DENSITY_FEATURE"] = "ON", -- "ON"/"OFF" This will increase the birds, fishs and butterflies, but will make everything else sparse for balancing the performance
        ["MAX_CREATURES_NUMBER"] = 20, -- "10" < - > "20"  max number of the birds, fishs and butterflies when CREATURES_HIGH_DENSITY_FEATURE is ON. notice that this param requires a integer, not a string
        ["CREATURES_BEHAVIOURS_IMPROVEMENTS_FEATURE"] = "ON",
        ["SANDWORM_OVERHAUL_FEATURE"] = "ON",
        ["PETS_BEHAVIOURS_AND_RIDING_IMPROVEMENTS_FEATURE"] ="ON",
        ["OVERHAUL_TIMER"] = 2, --( In Hours ) ( 24 H in vanilla ) ( timer used for creatures evolutions steps )
        ["FIENDS_SCARY_COMBAT_FEATURE"] = "OFF", -- this var is not used anymore 
        ["GIANTS_CREATURES_FEATURE"] = "ON",
        ["GIANTS_MAX_SIZE"] = "24", -- 8 <-> 94 (8 ( vanilla ) / 94 (very huge.)) -- recommanded 54
    },
    ["COLORS_GENERATION"]=
    {
        ["COLORS_AUTO_GENERATION_FEATURES"] =
        {
			-- The script will procedurally generate new colours possibilties // they will be diferent at each generation of the pak
            ["ULTRA_DIVERSE_SPACE_COLOURS"] = "ON", -- "ON"/"OFF" 
            ["HUGE_WATER_COLORS_DIVERSITY_FEATURE"] = "ON", -- "ON"/"OFF" 
            ["PLANETSKY_COLORS_DIVERSITY_FEATURE"] = "ON", -- "ON"/"OFF" 
        },
    },
    ["GENERATION_FEATURES"] =
    {
        ["GENERATION_OVERHAUL"] = "ON",   
        --

        ["PLANETS_GENERATION_FEATURES"] =
        {
            ["TERRAIN_SHAPES_FEATURES"] =
            {
                -- Mods for the voxel generation
                ["MODDED_TERRAIN_SHAPES_FEATURE"] = "OFF", -- "EPIC_FANTASY" , "SCI_FI_FANTASY" or "ON" or "OFF" 
                ["E3_STYLE_RESSOURCES_DEPOSITS"] = "OFF", -- inverts the ressources deposits ( making them out of the ground )
                ["TERRAIN_HEIGHT_MAX"] = "10", -- "-40" to "40"
            },
            ["BIOMES_FEATURES"] = -- world generation features
            {
                ["CONSTRUCTS_BY_MSSP_SPAWNER"] = "OFF", -- "ON"/"OFF" -- ( Requires "_MOD.MSSP.ConstructsVisions.Core.pak" from  https://www.nexusmods.com/nomanssky/mods/323)
                ["FANTASY_BIOMES_FEATURE"] = "ON", -- "ON"/"OFF"-- put "off" to have the utopia revamp world generation // "on" is euphoria world generation
                ["SKY_BIOMES_FEATURE"] = "OFF", -- "ON"/"OFF"-- floating things in the skies
                ["STORM_BIOMES_FEATURES"] = "OFF", -- this var is not used anymore 
                ["GIANTS_BIOMES_FEATURE"] = "OFF", -- "ON"/"OFF"-- Put "OFF" to have my old biomes generation ( before Euphoria  / post NMS FANTASY )
                ["LOWWATER_AND_BEACH_BIOMES_FEATURE"] = "ON",-- "ON"/"OFF" -- swamp biomes ( trees and constructs on water) & flora / rocks on beaches
                ["MONTAINS_BIOMES_FEATURE"] = "OFF",-- "ON"/"OFF" -- more diversity on montains
                ["CAVE_BIOMES_FEATURE"] = "OFF",-- "ON"/"OFF"-- more diversity on caves
            },
            ["ASSETS_REPLACEMENTS_FEATURES"] = -- world generation features, by models replacement
            { 

                ["E3_FANTASY_ASSETS_FEATURES"] = "ON",    -- "ON"/"OFF"
                --
                ["E3_FANTASY_WORSTONES_ASSETS_FEATURE"] = "ON", -- "ON"/"OFF"-- modded wordstones models
                ["E3_FANTASY_BEACONS_ASSETS_FEATURE"] = "ON", -- "ON"/"OFF"-- E3 building aside planets beacons
                ["E3_FANTASY_PORTALS_ASSETS_FEATURE"] = "ON",-- "ON"/"OFF" -- portals model replacements with e3 ones
                ["E3_FANTASY_DEPOTS_ASSETS_FEATURE"] = "ON", -- "ON"/"OFF"-- Rings buildings aside planet deposits
                ["E3_FANTASY_CRYSTALS_ASSETS_FEATURE"] = "OFF",-- "ON"/"OFF" -- E3 Crystals instead of vanilla crystals ( heridium / carbon, titan ones )
                ["E3_FANTASY_PLANETS_COLORS_FEATURE"] = "ON", -- "ON"/"OFF"-- Planets colours and tiles rework -- ( 90% "Pathfinder" colors )
                ["REDMAS_RUINS_FEATURES"] = "OFF", -- "ON"/"OFF"-- very Large ruins
                ["LARGE_BUILDINGS_TRADINGPOSTS_FEATURE"] = "ON", -- "ON"/"OFF"-- put archeologic buildings aside trading posts 
            },
        },
        ["SPACE_GENERATION_FEATURES"] =
        {
            ["REDMAS_SPACE_GENERATION"] = "ON",  
            --
            ["TRADING_ROUTES"] = "OFF", -- vanilla value is "on"
            ["MASSIVE_FLEET"] = "ON", -- ADD frigates aside freighters and redesign freighters - that change can be ressource heavy
            ["PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION"] = "ON", -- this will enable the custom models that i did for the derelic mission crash sites
        },
        ["SPACESHIPS_GENERATION_FEATURES"] =
        {
            -- Redmas Spaceships Generation Mod
            ["ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS"] = "ON", -- "ON"/"OFF" 
            ["ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS"] = "ON",  -- "ON"/"OFF" 
            ["ADDITIONAL_VARIATIONS_FOR_SCIENTICS_SPACESHIPS"] = "ON", -- "ON"/"OFF" 
            ["ADDITIONAL_VARIATIONS_FOR_SCLASS_SPACESHIPS"] = "ON", -- "ON"/"OFF" 
            ["ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS"] = "ON", -- "ON"/"OFF" 
        },
    },
    ["SKINS"] =
    {
        ["CHARACTERS_SKINS_FEATURE"] = "ON",       -- "ON"/"OFF" 
        --    
        ["DRONE_PET_SKIN_FEATURE"] = "ON",
		["DRONE_PET_SKIN"] = "E3-DAMAGED",-- ("E3-DAMAGED" or "E3") replacement with custom models for flare ( the friendly sentinel drone ) ( i will add more ones)
        ["CHAR_PRESETS_SKINS"] = "UTOPIA2"
        -- this will replace the default character customisations by more advanced looking skins ( which are characters from my youtube mini series NMS FANTASY )
        -- they are visible by vanilla players as soon as you rdit and save them in a character customisation slot
        -- "THE-WATCHER"  /or/   "SPACE-PIRATE" /or/     "GIRLY"       /or/
        -- "KORVAX"      /or/   "OUTLAWS"      /or/     "TRAVELLER"   /or/
        -- "VY-KEEN"    /or/   "ANOMALY"      /or/      "GEK"        /or/
        -- "UTOPIA"    /or/    "UTOPIA2"     /or/      "SCIFI"
    },
    ["NEWGAME_BONUS_FEATURES"] ={

        ["NEWGAME_BONUSES"] = "OFF",  
        --
        -- I recommend to always wait 1 or 2 week(s) after a vanilla base game update before activating that section
        -- ( the gamefiles it changes is always updated last )
        ["STARTING_SHIP"] = "ALPHA_VECTOR",
        -- "OUTLAW1" / "OUTLAW2" / "ALPHA_VECTOR" /
		-- "PLANETEXPLO2" / "PLANETEXPLO3" / "PLANETEXPLO4" / "PLANETEXPLO5" / "PLANETEXPLO6" / "PLANETEXPLO7" /
		-- "SPACEEXPLO1" / "SPACEEXPLO2" / "SPACEEXPLO3" / "SPACEEXPLO4" / "SPACEEXPLO5" / "SPACEEXPLO6" / "SPACEEXPLO7"
		-- "BOUNTYHUNTER1" / "BOUNTYHUNTER2" / "BOUNTYHUNTER3" / "BOUNTYHUNTER4" / "BOUNTYHUNTER5"
        ["STARTING_MULTITOOL"] = "OUTLAW1",
        -- "OUTLAW1" / "OUTLAW2" / "EXPLO1" / "SPACE" /
		-- "EXPLO2" / "EXPLO3" / "EXPLO4" / "EXPLO5" / "EXPLO6" / "EXPLO7" /
		-- "BOUNTYHUNTER1" / "BOUNTYHUNTER2" / "BOUNTYHUNTER3" / "BOUNTYHUNTER4" / "BOUNTYHUNTER5"
    },
    ["CHALLENGE_FEATURES"] =
    {
        ["CHALLENGE_MODE"] = "OFF",   
        --
		["STRONG_CREATURES_FEATURE"] = "OFF", -- note the base game already does it since NMS v 4.0
        ["HEALTH_MULTIPLIER"] = "4", -- 2 to 6 -- this param is related to STRONG_CREATURES_FEATURE = ON
        ["DARK_UNDERWATER"] = "OFF", -- This will make vision harder under water
        ["STRONG_PIRATES_FEATURE"] = "OFF", -- note the base game already does it since NMS v 4.0
    },
    ["EASY_MODE_FEATURES"] =
    {
        -- this section is for the cheats of the Game overhaul ( there are few as you can see )
        ["EASY_MODE"] = "ON", -- "ON"/"OFF"   
        --
        ["PULSE_ENGINE_SPEED_MULTIPLIER"] = 2 , -- ( "1" < - > "4" ( too much will be glitchy when entering planets' atmosphere)) -- notice that this param requires a integer, not a string
        ["LAUNCH_COST_REDUCTION"] = 5 , -- In % ( take off reduce ) note the base game already does it since NMS v 4.0 -- notice that this param requires a integer, not a string
        ["WARPCELL_USAGE_MULTIPLIER"] = 5, --> increase the number of usages of normal warpcells -- notice that this param requires a integer, not a string
        ["HYPERDRIVE_RANGE_MULTIPLIER"] = 1000, --> increase all hyperdrive ranges -- notice that this param requires a integer, not a string
    }
}
---------------------------------------------------------------------------------------------------------------------------
ASTEROIDS_REWORK = "ON" -- turn this value off if you don't want to aplie any changes to the asteroids file ( GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN )
--------------------------------------------------------------------------------------------------------------
HQ_SPACESTATIONS = "ON" -- "ON"/"OFF" enables the unreleased space stations models ( at the time i write )
--------------------------------------------------------------------------------------------------------------
PROCEDURALMAX = 1000  -- 10 to 1000 --This is the number of procedural generated new params for this script
-- change this var to increase the number of autogenerated colors, if they are enabled ( for skies, seas & space)
-- increasing that var will increase the rendering time
--------------------------------------------------------------------------------------------------------------
COLORS_GENERATION_REWORK = "FANTASY_COLOURS" -- "FANTASY_COLOURS" or "SCIFI_COLOURS"
-- color generation used for planets, creatures, materials, etc
-- FANTASY COLOURS Are 90% PathFinder colors ( its the classical Utopia revamp mod look and old NMS fantasy look )
-- SCIFI_COLOURS is new original colors
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
FIX_FOR_VANILLA_TREES = "ON" -- turn this value to "ON" to fix vanilla trees imposter - turn it "OFF" if it has no purpose for your mod
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
REDMAS_CAPE_FIX = "ON" -- turn this value to "ON" to improve capes movements - turn it "OFF" if it has no purpose for your mod (PLAYERCHARACTER.ENTITY.MBIN)
--------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------
BUSY_SPACE_TRAFFIC = "ON" -- turn that feature "OFF" if you want to do **share spaceships systems locations to others players**
-- Increases numbers of spaceships in systems
-- makes Sail spaceships roaming
-- makes sentinel spaceships roaming
-- increases chances of seeing Royal spaceships
-- turn this value "OFF" if want to keep compatibility with others mods using
-- GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN
-- AISPACESHIPMANAGER.MBIN
-------------------------------------------------------------------------------------------------------------------------------
ADD_RGO_CUSTOM_ASSETS = "ON" -- Turn this "OFF" to remove the custom models if your wanted-pak doesn't require them
-- this var doens't include custom exocrafts, custom spaceships parts, HQ spacestations, or Constructs mod
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

FREIGHTER_BRIDGE_REWORK = "ON" -- Turn this on to enable the tweaks inside freighter's bridges. ( less drapes - more convinient warp console position)
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- **ADVANCED PARAMS**
---------------------------
DAY_ONE_MODE = "OFF"--( put "ON" the day one of a big vanilla update while mbincompiler is being updated to disable some features
--PERFORMANCE_MODE = "ON" --( Putting ON will reduce CPU-DEMANDING FEATURES )
MULTIPLAYER_MODE = "OFF" --( Put On if you play heavily in Multiplayer )
----------------------------------------------------------------------------------
-- SPACESHIPS CONTROLS REWORK
SPACESHIPS_SPACE_THRUSTFORCE = 140
SPACESHIPS_SPACE_MAXPSEED = 4420
SPACESHIPS_SPACE_FALLOFF = 0.00007 -- deprecated change for RGOG
SPACESHIPS_SPACE_BOOST_FORCE = SPACESHIPS_SPACE_THRUSTFORCE*4
SPACESHIPS_SPACE_BOOST_MAX = 4420
--
SPACESHIPS_PLANET_THRUSTFORCE = 20
SPACESHIPS_PLANET_MAXPSEED = 160
SPACESHIPS_PLANET_FALLOFF = 0.00007 -- deprecated change for RGOG
SPACESHIPS_PLANET_BOOST_FORCE = 190
SPACESHIPS_PLANET_BOOST_MAX = 190
--
SPACESHIPS_SMALL_SPEED_MULTIPLIER = 1.111
SPACESHIPS_HEAVY_SPEED_MULTIPLIER = 1
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
-- SPACESHIPS CAMERAS
SMALL_SPACESHIPS_MIN_DIST = 1
SMALL_SPACESHIPS_MAX_DIST = 60
SMALL_SPACESHIPS_UP_MIN_DIST = 0
SMALL_SPACESHIPS_UP_MAX_DIST = 15
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
LONG_SPACESHIPS_MIN_DIST = 5
LONG_SPACESHIPS_MAX_DIST = 60
LONG_SPACESHIPS_UP_MIN_DIST = 1
LONG_SPACESHIPS_UP_MAX_DIST = 25
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
SMALL_SPACESHIPS_MIN_DIST = tostring(SMALL_SPACESHIPS_MIN_DIST)
SMALL_SPACESHIPS_MAX_DIST = tostring(SMALL_SPACESHIPS_MAX_DIST)
SMALL_SPACESHIPS_UP_MIN_DIST = tostring(SMALL_SPACESHIPS_UP_MIN_DIST)
SMALL_SPACESHIPS_UP_MAX_DIST = tostring(SMALL_SPACESHIPS_UP_MAX_DIST)
-----------------------------------------
LONG_SPACESHIPS_MIN_DIST = tostring(LONG_SPACESHIPS_MIN_DIST)
LONG_SPACESHIPS_MAX_DIST = tostring(LONG_SPACESHIPS_MAX_DIST)
LONG_SPACESHIPS_UP_MIN_DIST = tostring(LONG_SPACESHIPS_UP_MIN_DIST)
LONG_SPACESHIPS_UP_MAX_DIST = tostring(LONG_SPACESHIPS_UP_MAX_DIST)
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
---------------**ASTEROIDS_FIELDS_SPACING_PRESETS**----------------------------------------------------------

--
ASTEROIDS_GLUED_PRESET ={
	["RARE_ASTEROID_SPACING_MULTIPLIER"] = "1.5",
	["LARGE_ASTEROID_SPACING_MULTIPLIER"] = "1.5",
	["ASTEROID_SPACING_MULTIPLIER"] = "1.5",
	["RARE_ASTEROID_SCALE_MULTIPLIER"] = "1",
	["LARGE_ASTEROID_SCALE_MULTIPLIER"] = "1",
	["ASTEROID_SCALE_MULTIPLIER"] = "1"
}
--
ASTEROIDS_FANTASY_PRESET ={
	["RARE_ASTEROID_SPACING_MULTIPLIER"] = "6.5",
	["LARGE_ASTEROID_SPACING_MULTIPLIER"] = "6.5",
	["ASTEROID_SPACING_MULTIPLIER"] = "6.5",
	["RARE_ASTEROID_SCALE_MULTIPLIER"] = "1.1",
	["LARGE_ASTEROID_SCALE_MULTIPLIER"] = "1.1",
	["ASTEROID_SCALE_MULTIPLIER"] = "1.1"
}
ASTEROIDS_VANILLA_PRESET ={
	["RARE_ASTEROID_SPACING_MULTIPLIER"] = "1",
	["LARGE_ASTEROID_SPACING_MULTIPLIER"] = "1",
	["ASTEROID_SPACING_MULTIPLIER"] = "1",
	["RARE_ASTEROID_SCALE_MULTIPLIER"] = "1",
	["LARGE_ASTEROID_SCALE_MULTIPLIER"] = "1",
	["ASTEROID_SCALE_MULTIPLIER"] = "1"
}

ASTEROIDS_REALISTIC_PRESET ={
	["RARE_ASTEROID_SPACING_MULTIPLIER"] = "2.5",
	["LARGE_ASTEROID_SPACING_MULTIPLIER"] = "1.5",
	["ASTEROID_SPACING_MULTIPLIER"] = "4.5",
	["RARE_ASTEROID_SCALE_MULTIPLIER"] = "1.5",
	["LARGE_ASTEROID_SCALE_MULTIPLIER"] = "1.5",
	["ASTEROID_SCALE_MULTIPLIER"] = "1.5"
}


--
-- BUILDER  -----------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
-- DONT CHANGE THAT PART -------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
-- 
------------------------------------------------------------------------------
CREATUREDATATABLE = [[METADATA\SIMULATION\ECOSYSTEM\CREATUREDATATABLE.MBIN]]------------------------------------
CREATUREGLOBALS = [[GCCREATUREGLOBALS.MBIN]]--------------------------------------------------------------------
PATH_ECOSYSTEM = [[METADATA\SIMULATION\ECOSYSTEM\]]----------------------------------------------------------
CREATURESMODELS = [[MODELS\PLANETS\CREATURES\]]-------------------------------------------------------------
FREIGHTER_PATH = [[MODELS\COMMON\SPACECRAFT\COMMONPARTS\HANGARINTERIORPARTS\]]------------------------------
SETTLEMENT_PATH = [[METADATA\SIMULATION\SOLARSYSTEM\WFCBUILDINGS\CUBOID3\]]---------------------------------
BUILDINGS_PATH = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\]]------------------------------------------------
---------------------------------------------------------------------------------------------------------------
FEATURES_CHANGE_TABLE = {}-----------------------------------------------------------------------------------
CUSTOM_CONTENT = {}----------------------------------------------------------------------------------------------
CONTENT = {}

MODNAME=""
VISUAL_OVERHAUL = ""
CAMERA_OVERHAUL_FEATURE = ""
CAMERA_NO_SHAKE_FEATURE = ""
CENTERED_CAMERA_FEATURE = ""
GAMEPLAY_OVERHAUL = ""
CREATURES_OVERHAUL = ""
GENERATION_OVERHAUL = ""
CHARACTERS_SKINS_FEATURE = ""
NEWGAME_BONUSES = ""
EASY_MODE = ""
CHALLENGE_MODE = ""
-- MENUS PARAMS ----------------------------------------------------------------------------------------------
HELLO_GAMES_SPASH_SCREEN = ""
ENGINE_SPASH_SCREEN = ""
NMS_TITLE = ""
MENU_SPLASH_SCREEN = ""
TRANSPARENT_OPTIONS_MENU = ""
-- VISUAL OVERHAUL PARAMS ------------------------------------------------------------------------------------
REDMAS_WATER_REFLECTIONS = ""
SPACE_BLUR_FEATURE = ""
FILTERS_SWAP_FEATURE = ""
BINOCULARS_TYPE = ""
SPEED_EFFECTS_REDUCER_FEATURE = ""
SPACESHIPS_TRAILS_TYPE = ""
SPACE_COLOURS_TYPE = ""
ULTRA_DIVERSE_SPACE_COLOURS = ""
ASTEROIDS_FIELDS_TYPE = ""
FIGHTERS_SPACESHIPS_REPAINT = ""
DROPSHIPS_SPACESHIPS_REPAINT = ""
SHUTTLE_SPACESHIPS_REPAINT = ""
JETPACKMAXBONUS = ""
-- CAMERA OVERHAUL PARAMS ------------------------------------------------------------------------------------
SMALL_SPACESHIPS_MIN_DIST = 0 --- /!\ defiened later, this is var definition
SMALL_SPACESHIPS_MAX_DIST = 0 ---/!\ defiened later, this is var definition
LONG_SPACESHIPS_MIN_DIST = 0 ---/!\ defiened later, this is var definition
LONG_SPACESHIPS_MAX_DIST = 0 ---/!\ defiened later, this is var definition
-- GAMEPLAY OVERHAUL PARAMS ----------------------------------------------------------------------------------
ADVANCED_BODY_SHAPES_FEATURE = ""
MINING_SPEED = 0 ---/!\ defiened later, this is var definition
NEW_INTERACTIONS_FEATURE = ""
ADVANCED_BUILDS_FEATURE = ""
FREE_POWER_ON_EM_GENERATORS = ""
HOVER_MODE = ""
SANKUKAI_SPACESHIPS_COMBAT = ""
ONFOOT_CONTROLS_REVISON_FEATURE = ""
LONGER_STEALTH_FEATURE = ""
FASTER_WALK_WHILE_SHIELDING_FEATURE = ""
PLAYER_IS_WALKING_INSTEAD_OF_JOGGING_FEATURE = ""
CONTROLLED_FALL_ANIMATION_REPLACEMENT = ""
EXOCRAFTS_CONTROLS_REVISON_FEATURE = ""
ADDITIONAL_EXOCRAFT_DRAGONFLY = ""
CUSTOM_NOMAD_EXOCRAFT = ""
CUSTOM_ROAMER_EXOCRAFT = ""
ROAMER_BIGWHEELS_FEATURE = ""
ROAMER_ADDITIONAL_LAMPS_FEATURE = ""
CUSTOM_COLOSSUS_EXOCRAFT = ""
CUSTOM_PILGRIM_EXOCRAFT = ""
ONFOOT_COMBAT_REVISON_BETA_FEATURE = ""
GIANT_MECHS_BETA_FEATURE = ""
MECHS_SIZE_MULTIPLIER = 0 ---/!\ defiened later, this is var definition
-- CREATURES PARAMS ------------------------------------------------------------------------------------------
CREATURES_HIGH_DENSITY_FEATURE = ""
MAX_CREATURES_NUMBER = ""
CREATURES_BEHAVIOURS_IMPROVEMENTS_FEATURE =  ""
SANDWORM_OVERHAUL_FEATURE =  ""
PETS_BEHAVIOURS_AND_RIDING_IMPROVEMENTS_FEATURE =  ""
OVERHAUL_TIMER =  ""

GIANTS_CREATURES_FEATURE =  ""
GIANTS_MAX_SIZE =  ""
--  GENERATION PARAMS ---------------------------------------------------------------------------------------
-- SPACESHIPS GENERATION PARAMS ----------------------------------------------------------------------------
ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS =  ""
ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS =  ""
ADDITIONAL_VARIATIONS_FOR_SCIENTICS_SPACESHIPS =  ""
ADDITIONAL_VARIATIONS_FOR_SCLASS_SPACESHIPS =  ""
ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS =  ""
-- PLANETS GENERATION PARAMS ---------------------------------------------------------------------------------
--voxels params
MODDED_TERRAIN_SHAPES_FEATURE =  ""
E3_STYLE_RESSOURCES_DEPOSITS =  ""
TERRAIN_HEIGHT_MAX =  ""
-- end voxels params
-- ASSETS REWORK params
E3_FANTASY_ASSETS_FEATURES =  ""
E3_FANTASY_WORSTONES_ASSETS_FEATURE =   ""
E3_FANTASY_PORTALS_ASSETS_FEATURE =  ""
E3_FANTASY_BEACONS_ASSETS_FEATURE =  ""
E3_FANTASY_DEPOTS_ASSETS_FEATURE =  ""
E3_FANTASY_CRYSTALS_ASSETS_FEATURE =  ""
E3_FANTASY_PLANETS_COLORS_FEATURE =  ""
REDMAS_RUINS_FEATURES =  ""
-- End Assets Rework params
HUGE_WATER_COLORS_DIVERSITY_FEATURE =  ""
PLANETSKY_COLORS_DIVERSITY_FEATURE =  ""
LARGE_BUILDINGS_TRADINGPOSTS_FEATURE =  ""
-- Biomes param
CONSTRUCTS_BY_MSSP_SPAWNER =  ""
SKY_BIOMES_FEATURE =  ""
FANTASY_BIOMES_FEATURE =  ""
--STORM_BIOMES_FEATURES =  "" -- disabled
GIANTS_BIOMES_FEATURE =  ""
LOWWATER_AND_BEACH_BIOMES_FEATURE =  ""
-- MONTAINS_BIOMES_FEATURE =  "" -- disabled
 CAVE_BIOMES_FEATURE =  "" -- disabled
-- End Biomes param
-- SPACE PARAMS ----------------------------------------------------------------------------------------------
--REDMAS_SPACE_GENERATION =  ""
TRADING_ROUTES =  ""
MASSIVE_FLEET =  ""
PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION =  ""
-- SKINS PARAMS ---------------------------------------------------------------------------------
DRONE_PET_SKIN_FEATURE =  ""
DRONE_PET_SKIN =  ""
CHAR_PRESETS_SKINS =  ""
-- CHALLENGE MODE PARAMS -------------------------------------------------------------------------------------
 STRONG_CREATURES_FEATURE =  ""
 HEALTH_MULTIPLIER =  ""
 DARK_UNDERWATER =  ""
 STRONG_PIRATES_FEATURE =  ""
-- EASY MODE PARAMS ------------------------------------------------------------------------------------------
PULSE_ENGINE_SPEED_MULTIPLIER =  ""
 LAUNCH_COST_REDUCTION =  ""
 WARPCELL_USAGE_MULTIPLIER =  ""
 HYPERDRIVE_RANGE_MULTIPLIER =  ""
STARTING_SHIP = ""
STARTING_MULTITOOL =""
-----------------------------------------------------------------------------------
-- INIT
OFTEN_SPAWN_R2 =------------------------------------------------------------------------------------------------------------
[[
		<Property name="AutoCollision" value="False" />
						<Property name="CollideWithPlayer" value="True" />
						<Property name="CollideWithPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerShip" value="True" />
						<Property name="DestroyedByTerrainEdit" value="True" />
						<Property name="InvisibleToCamera" value="False" />
						<Property name="CreaturesCanEat" value="False" />
						<Property name="ShearWindStrength" value="0" />
						<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
						<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
						<Property name="ID" value="STANDARD" />
<Property name="Coverage" value="0.1" />
						<Property name="FlatDensity" value="0.0041" />
						<Property name="SlopeDensity" value="0" />
          <Property name="SlopeDensity" value="0" />
          <Property name="SlopeMultiplier" value="3" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="120" />
										<Property value="160" />
										<Property value="1150" />
										<Property value="1500" />
            </Property>
						</Property>
						<Property name="QualityVariants">

						</Property>
]]

OFTEN_SPAWN_R =------------------------------------------------------------------------------------------------------------
[[
		<Property name="AutoCollision" value="False" />
						<Property name="CollideWithPlayer" value="True" />
						<Property name="CollideWithPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerShip" value="True" />
						<Property name="DestroyedByTerrainEdit" value="True" />
						<Property name="InvisibleToCamera" value="False" />
						<Property name="CreaturesCanEat" value="False" />
						<Property name="ShearWindStrength" value="0" />
						<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
						<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
						<Property name="ID" value="STANDARD" />
<Property name="Coverage" value="0.6" />
						<Property name="FlatDensity" value="0.00041" />
						<Property name="SlopeDensity" value="0" />
          <Property name="SlopeDensity" value="0" />
          <Property name="SlopeMultiplier" value="3" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="120" />
										<Property value="160" />
										<Property value="1150" />
										<Property value="1500" />
            </Property>
						</Property>
						<Property name="QualityVariants">

						</Property>
]]
--------------------------------------------------------------------------------------------------------------
GIANT_OFTEN_SPAWN =------------------------------------------------------------------------------------------------------------
[[
		<Property name="AutoCollision" value="False" />
						<Property name="CollideWithPlayer" value="True" />
						<Property name="CollideWithPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerShip" value="True" />
						<Property name="DestroyedByTerrainEdit" value="True" />
						<Property name="InvisibleToCamera" value="False" />
						<Property name="CreaturesCanEat" value="False" />
						<Property name="ShearWindStrength" value="0" />
						<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
						<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
						<Property name="ID" value="STANDARD" />
						<Property name="Coverage" value="0.4" />
						<Property name="FlatDensity" value="0.00041" />
						<Property name="SlopeDensity" value="0" />
						<Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="0" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="1120" />
            <Property value="1610" />
            <Property value="2150" />
            <Property value="2500" />
						</Property>
						</Property>
						<Property name="QualityVariants">

						</Property>
]]
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
GIANT_SPARSE_SPAWN = ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
[[
	<Property name="AutoCollision" value="False" />
						<Property name="CollideWithPlayer" value="True" />
						<Property name="CollideWithPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerVehicle" value="True" />
						<Property name="DestroyedByPlayerShip" value="True" />
						<Property name="DestroyedByTerrainEdit" value="True" />
						<Property name="InvisibleToCamera" value="False" />
						<Property name="CreaturesCanEat" value="False" />
						<Property name="ShearWindStrength" value="0" />
						<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
						<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
						<Property name="ID" value="STANDARD" />
						<Property name="Coverage" value="0.3" />
						<Property name="FlatDensity" value="0.0001" />
						<Property name="SlopeDensity" value="0" />
						<Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="0" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="1120" />
            <Property value="1610" />
            <Property value="2150" />
            <Property value="2500" />
						</Property>
						</Property>
						<Property name="QualityVariants">

						</Property>
]]

-------------------------------------------------------------------------------------
MODNAME = INIT_PRESET.MODNAME
STARTING_SHIP = INIT_PRESET.NEWGAME_BONUS_FEATURES.STARTING_SHIP
STARTING_MULTITOOL = INIT_PRESET.NEWGAME_BONUS_FEATURES.STARTING_MULTITOOL
VISUAL_OVERHAUL = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.VISUAL_OVERHAUL
CAMERA_OVERHAUL_FEATURE = INIT_PRESET.CAMERA_FEATURES.CAMERA_OVERHAUL_FEATURE
CAMERA_NO_SHAKE_FEATURE = INIT_PRESET.CAMERA_FEATURES.CAMERA_NO_SHAKE_FEATURE
CENTERED_CAMERA_FEATURE = INIT_PRESET.CAMERA_FEATURES.CENTERED_CAMERA_FEATURE
GAMEPLAY_OVERHAUL = INIT_PRESET.GAMEPLAY_FEATURES.GAMEPLAY_OVERHAUL
CREATURES_OVERHAUL = INIT_PRESET.CREATURES_FEATURES.CREATURES_OVERHAUL
GENERATION_OVERHAUL = INIT_PRESET.GENERATION_FEATURES.GENERATION_OVERHAUL
CHARACTERS_SKINS_FEATURE = INIT_PRESET.SKINS.CHARACTERS_SKINS_FEATURE
NEWGAME_BONUSES = INIT_PRESET.NEWGAME_BONUS_FEATURES.NEWGAME_BONUSES
EASY_MODE = INIT_PRESET.EASY_MODE_FEATURES.EASY_MODE
CHALLENGE_MODE = INIT_PRESET.CHALLENGE_FEATURES.CHALLENGE_MODE
-- MENUS PARAMS ----------------------------------------------------------------------------------------------
HELLO_GAMES_SPASH_SCREEN = INIT_PRESET.MENU_OVERHAUL_FEATURES.HELLO_GAMES_SPASH_SCREEN
ENGINE_SPASH_SCREEN = INIT_PRESET.MENU_OVERHAUL_FEATURES.ENGINE_SPASH_SCREEN
NMS_TITLE = INIT_PRESET.MENU_OVERHAUL_FEATURES.NMS_TITLE
-- I will update this on Nexus with new updates theme / visuals
 -- You can Edit or Replace the Pictures inside  RGOG/IMAGES/ to customise the Title
MENU_SPLASH_SCREEN = INIT_PRESET.MENU_OVERHAUL_FEATURES.MENU_SPLASH_SCREEN
TRANSPARENT_OPTIONS_MENU = INIT_PRESET.MENU_OVERHAUL_FEATURES.TRANSPARENT_OPTIONS_MENU
-- VISUAL OVERHAUL PARAMS ------------------------------------------------------------------------------------
REDMAS_WATER_REFLECTIONS = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.REDMAS_WATER_REFLECTIONS
SPACE_BLUR_FEATURE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.SPACE_BLUR_FEATURE
FILTERS_SWAP_FEATURE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.FILTERS_SWAP_FEATURE
BINOCULARS_TYPE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.BINOCULARS_TYPE
SPEED_EFFECTS_REDUCER_FEATURE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.SPEED_EFFECTS_REDUCER_FEATURE
SPACESHIPS_TRAILS_TYPE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.SPACESHIPS_TRAILS_TYPE
SPACE_COLOURS_TYPE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.SPACE_COLOURS_TYPE
ULTRA_DIVERSE_SPACE_COLOURS = INIT_PRESET.COLORS_GENERATION .COLORS_AUTO_GENERATION_FEATURES.ULTRA_DIVERSE_SPACE_COLOURS
ASTEROIDS_FIELDS_TYPE = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.ASTEROIDS_FIELDS_TYPE
FIGHTERS_SPACESHIPS_REPAINT = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.FIGHTERS_SPACESHIPS_REPAINT
DROPSHIPS_SPACESHIPS_REPAINT = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.DROPSHIPS_SPACESHIPS_REPAINT
SHUTTLE_SPACESHIPS_REPAINT = INIT_PRESET.VISUAL_OVERHAUL_FEATURES.SHUTTLE_SPACESHIPS_REPAINT
-- CAMERA OVERHAUL PARAMS ------------------------------------------------------------------------------------
SMALL_SPACESHIPS_MIN_DIST = 5 -- (if CAMERA_OVERHAUL_FEATURE == "ON" )
SMALL_SPACESHIPS_MAX_DIST = 40 -- (if CAMERA_OVERHAUL_FEATURE == "ON" )
LONG_SPACESHIPS_MIN_DIST = 5 -- (if CAMERA_OVERHAUL_FEATURE == "ON" )
LONG_SPACESHIPS_MAX_DIST = 50 -- (if CAMERA_OVERHAUL_FEATURE == "ON" )
-- GAMEPLAY OVERHAUL PARAMS ----------------------------------------------------------------------------------
ADVANCED_BODY_SHAPES_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.QOL_FEATURES.ADVANCED_BODY_SHAPES_FEATURE
MINING_SPEED = INIT_PRESET.GAMEPLAY_FEATURES.QOL_FEATURES.MINING_SPEED
NEW_INTERACTIONS_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.QOL_FEATURES.NEW_INTERACTIONS_FEATURE
ADVANCED_BUILDS_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.QOL_FEATURES.ADVANCED_BUILDS_FEATURE
FREE_POWER_ON_EM_GENERATORS = INIT_PRESET.GAMEPLAY_FEATURES.QOL_FEATURES.FREE_POWER_ON_EM_GENERATORS
HOVER_MODE = INIT_PRESET.GAMEPLAY_FEATURES.SPACESHIPS_GAMEPLAY_FEATURES.HOVER_MODE
SANKUKAI_SPACESHIPS_COMBAT = INIT_PRESET.GAMEPLAY_FEATURES.SPACESHIPS_GAMEPLAY_FEATURES.SANKUKAI_SPACESHIPS_COMBAT
ONFOOT_CONTROLS_REVISON_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.ONFOOT_CONTROLS_REVISON_FEATURE
LONGER_STEALTH_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.LONGER_STEALTH_FEATURE
FASTER_WALK_WHILE_SHIELDING_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.FASTER_WALK_WHILE_SHIELDING_FEATURE
PLAYER_IS_WALKING_INSTEAD_OF_JOGGING_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.PLAYER_IS_WALKING_INSTEAD_OF_JOGGING_FEATURE
CONTROLLED_FALL_ANIMATION_REPLACEMENT = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.CONTROLLED_FALL_ANIMATION_REPLACEMENT
EXOCRAFTS_CONTROLS_REVISON_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.EXOCRAFTS_CONTROLS_REVISON_FEATURE
ADDITIONAL_EXOCRAFT_DRAGONFLY = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.ADDITIONAL_EXOCRAFT_DRAGONFLY
CUSTOM_NOMAD_EXOCRAFT = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.CUSTOM_NOMAD_EXOCRAFT
CUSTOM_ROAMER_EXOCRAFT = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.CUSTOM_ROAMER_EXOCRAFT
ROAMER_BIGWHEELS_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.ROAMER_BIGWHEELS_FEATURE
ROAMER_ADDITIONAL_LAMPS_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.ROAMER_ADDITIONAL_LAMPS_FEATURE
CUSTOM_COLOSSUS_EXOCRAFT = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.CUSTOM_COLOSSUS_EXOCRAFT
CUSTOM_PILGRIM_EXOCRAFT = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.CUSTOM_PILGRIM_EXOCRAFT
ONFOOT_COMBAT_REVISON_BETA_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.ONFOOT_GAMEPLAY_FEATURES.ONFOOT_COMBAT_REVISON_BETA_FEATURE
GIANT_MECHS_BETA_FEATURE = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.GIANT_MECHS_BETA_FEATURE
MECHS_SIZE_MULTIPLIER = INIT_PRESET.GAMEPLAY_FEATURES.VEHICLES_FEATURES.MECHS_SIZE_MULTIPLIER
-- CREATURES PARAMS ------------------------------------------------------------------------------------------
CREATURES_HIGH_DENSITY_FEATURE = INIT_PRESET.CREATURES_FEATURES.CREATURES_HIGH_DENSITY_FEATURE
MAX_CREATURES_NUMBER = INIT_PRESET.CREATURES_FEATURES.MAX_CREATURES_NUMBER
CREATURES_BEHAVIOURS_IMPROVEMENTS_FEATURE = INIT_PRESET.CREATURES_FEATURES.CREATURES_BEHAVIOURS_IMPROVEMENTS_FEATURE
SANDWORM_OVERHAUL_FEATURE = INIT_PRESET.CREATURES_FEATURES.SANDWORM_OVERHAUL_FEATURE
PETS_BEHAVIOURS_AND_RIDING_IMPROVEMENTS_FEATURE = INIT_PRESET.CREATURES_FEATURES.PETS_BEHAVIOURS_AND_RIDING_IMPROVEMENTS_FEATURE
OVERHAUL_TIMER = INIT_PRESET.CREATURES_FEATURES.OVERHAUL_TIMER

GIANTS_CREATURES_FEATURE = INIT_PRESET.CREATURES_FEATURES.GIANTS_CREATURES_FEATURE
GIANTS_MAX_SIZE = INIT_PRESET.CREATURES_FEATURES.GIANTS_MAX_SIZE
--  GENERATION PARAMS ---------------------------------------------------------------------------------------
-- SPACESHIPS GENERATION PARAMS ----------------------------------------------------------------------------
ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS = INIT_PRESET.GENERATION_FEATURES.SPACESHIPS_GENERATION_FEATURES.ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS
ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS = INIT_PRESET.GENERATION_FEATURES.SPACESHIPS_GENERATION_FEATURES.ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS
ADDITIONAL_VARIATIONS_FOR_SCIENTICS_SPACESHIPS = INIT_PRESET.GENERATION_FEATURES.SPACESHIPS_GENERATION_FEATURES.ADDITIONAL_VARIATIONS_FOR_SCIENTICS_SPACESHIPS
ADDITIONAL_VARIATIONS_FOR_SCLASS_SPACESHIPS = INIT_PRESET.GENERATION_FEATURES.SPACESHIPS_GENERATION_FEATURES.ADDITIONAL_VARIATIONS_FOR_SCLASS_SPACESHIPS
ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS = INIT_PRESET.GENERATION_FEATURES.SPACESHIPS_GENERATION_FEATURES.ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS
-- PLANETS GENERATION PARAMS ---------------------------------------------------------------------------------
--voxels params
MODDED_TERRAIN_SHAPES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.TERRAIN_SHAPES_FEATURES.MODDED_TERRAIN_SHAPES_FEATURE
E3_STYLE_RESSOURCES_DEPOSITS = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.TERRAIN_SHAPES_FEATURES.E3_STYLE_RESSOURCES_DEPOSITS
TERRAIN_HEIGHT_MAX = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.TERRAIN_SHAPES_FEATURES.TERRAIN_HEIGHT_MAX
-- end voxels params
-- ASSETS REWORK params
E3_FANTASY_ASSETS_FEATURES = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_ASSETS_FEATURES
E3_FANTASY_WORSTONES_ASSETS_FEATURE =  INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_WORSTONES_ASSETS_FEATURE
E3_FANTASY_PORTALS_ASSETS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_PORTALS_ASSETS_FEATURE
E3_FANTASY_BEACONS_ASSETS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_BEACONS_ASSETS_FEATURE
E3_FANTASY_DEPOTS_ASSETS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_DEPOTS_ASSETS_FEATURE
E3_FANTASY_CRYSTALS_ASSETS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_CRYSTALS_ASSETS_FEATURE
E3_FANTASY_PLANETS_COLORS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.E3_FANTASY_PLANETS_COLORS_FEATURE
REDMAS_RUINS_FEATURES = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.REDMAS_RUINS_FEATURES
-- End Assets Rework params
HUGE_WATER_COLORS_DIVERSITY_FEATURE = INIT_PRESET.COLORS_GENERATION.COLORS_AUTO_GENERATION_FEATURES.HUGE_WATER_COLORS_DIVERSITY_FEATURE
PLANETSKY_COLORS_DIVERSITY_FEATURE = INIT_PRESET.COLORS_GENERATION.COLORS_AUTO_GENERATION_FEATURES.PLANETSKY_COLORS_DIVERSITY_FEATURE
LARGE_BUILDINGS_TRADINGPOSTS_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.ASSETS_REPLACEMENTS_FEATURES.LARGE_BUILDINGS_TRADINGPOSTS_FEATURE
-- Biomes param
CONSTRUCTS_BY_MSSP_SPAWNER = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.CONSTRUCTS_BY_MSSP_SPAWNER
SKY_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.SKY_BIOMES_FEATURE
FANTASY_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.FANTASY_BIOMES_FEATURE
--STORM_BIOMES_FEATURES = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.STORM_BIOMES_FEATURES
GIANTS_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.GIANTS_BIOMES_FEATURE
LOWWATER_AND_BEACH_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.LOWWATER_AND_BEACH_BIOMES_FEATURE
--MONTAINS_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.MONTAINS_BIOMES_FEATURE
CAVE_BIOMES_FEATURE = INIT_PRESET.GENERATION_FEATURES.PLANETS_GENERATION_FEATURES.BIOMES_FEATURES.CAVE_BIOMES_FEATURE
-- End Biomes param
-- SPACE PARAMS ----------------------------------------------------------------------------------------------
--REDMAS_SPACE_GENERATION = INIT_PRESET.GENERATION_FEATURES.SPACE_GENERATION_FEATURES.REDMAS_SPACE_GENERATION
TRADING_ROUTES = INIT_PRESET.GENERATION_FEATURES.SPACE_GENERATION_FEATURES.TRADING_ROUTES
MASSIVE_FLEET = INIT_PRESET.GENERATION_FEATURES.SPACE_GENERATION_FEATURES.MASSIVE_FLEET
PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION = INIT_PRESET.GENERATION_FEATURES.SPACE_GENERATION_FEATURES.PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION
-- SKINS PARAMS ---------------------------------------------------------------------------------
DRONE_PET_SKIN_FEATURE = INIT_PRESET.SKINS.DRONE_PET_SKIN_FEATURE
DRONE_PET_SKIN = INIT_PRESET.SKINS.DRONE_PET_SKIN
CHAR_PRESETS_SKINS = INIT_PRESET.SKINS.CHAR_PRESETS_SKINS
-- CHALLENGE MODE PARAMS -------------------------------------------------------------------------------------
 STRONG_CREATURES_FEATURE = INIT_PRESET.CHALLENGE_FEATURES.STRONG_CREATURES_FEATURE
 HEALTH_MULTIPLIER = INIT_PRESET.CHALLENGE_FEATURES.HEALTH_MULTIPLIER
 DARK_UNDERWATER = INIT_PRESET.CHALLENGE_FEATURES.DARK_UNDERWATER
 STRONG_PIRATES_FEATURE = INIT_PRESET.CHALLENGE_FEATURES.STRONG_PIRATES_FEATURE
-- EASY MODE PARAMS ------------------------------------------------------------------------------------------
PULSE_ENGINE_SPEED_MULTIPLIER = INIT_PRESET.EASY_MODE_FEATURES.PULSE_ENGINE_SPEED_MULTIPLIER
 LAUNCH_COST_REDUCTION = INIT_PRESET.EASY_MODE_FEATURES.LAUNCH_COST_REDUCTION
 WARPCELL_USAGE_MULTIPLIER = INIT_PRESET.EASY_MODE_FEATURES.WARPCELL_USAGE_MULTIPLIER
 HYPERDRIVE_RANGE_MULTIPLIER = INIT_PRESET.EASY_MODE_FEATURES.HYPERDRIVE_RANGE_MULTIPLIER
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
-- **FUNCTIONS** ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
local interactButton = function(path)
	local BUTTON = [[
		<Property value="TkSceneNodeData.xml">
          <Property name="Name" value="REDMAS_BUTTON" />
          <Property name="NameHash" value="1402981485" />
          <Property name="Type" value="LOCATOR" />
          <Property name="Transform" value="TkTransformData.xml">
            <Property name="TransX" value="0" />
            <Property name="TransY" value="0" />
            <Property name="TransZ" value="0" />
            <Property name="RotX" value="0" />
            <Property name="RotY" value="0" />
            <Property name="RotZ" value="0" />
            <Property name="ScaleX" value="0.1" />
            <Property name="ScaleY" value="0.1" />
            <Property name="ScaleZ" value="0.1" />
          </Property>
          <Property name="Attributes">
            <Property value="TkSceneNodeAttributeData.xml">
              <Property name="Name" value="ATTACHMENT" />
              <Property name="AltID" value="" />
             <Property name="Value" value="]]..path..[[" />
            </Property>
          </Property>
          <Property name="Children" />
        </Property>		   
	]]
	return BUTTON
end
BTN_CARGO = interactButton([[MODELS\RGO\ENTITIES\CARGOGENERATOR.ENTITY.MBIN]])
BTN_SAVE = interactButton([[MODELS\RGO\ENTITIES\SAVEPOINT.ENTITY.MBIN]])
BTN_CUSTOMIZER = interactButton([[MODELS\RGO\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]])
BTN_CRATES = interactButton([[MODELS\RGO\ENTITIES\FERRITEDUSTGENERATOR.ENTITY.MBIN]])
BTN_HYDRO = interactButton([[MODELS\RGO\ENTITIES\DIHYDROGENGENERATOR.ENTITY.MBIN]])
BTN_SIGNAL = interactButton([[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\TECH\SIGNALSCANNER\ENTITIES\SIGNALSCANNER.ENTITY.MBIN]])
local addContent = function (CONTENT_TABLE)----------------------------------------------------------------------------
	local localCONTENT = --------------------------------------------------------------------------------------------------------------------------------------------------------
	{--------------------------------------------------------------------------------------------------------------------------------------------------------
		["MBIN_CHANGE_TABLE"] = CONTENT_TABLE----------------------------------------------------------------------------
	}--------------------------------------------------------------------------------------------------------------------------------------------------------
	table.insert(FEATURES_CHANGE_TABLE,localCONTENT)----------------------------------------------------------------------------
end--------------------------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------
local addFeature = function (FEATURE,CONTENTPARAM,DAYONE)----------------------------------------------------------------------------
	if FEATURE == "ALWAYS" then----------------------------------------------------------------------------
		FEATURE = "ON"----------------------------------------------------------------------------
	end--------------------------------------------------------------------------------------------------------------------------------------------------------
	if DAYONE == nil then----------------------------------------------------------------------------
		if FEATURE == "ON" then----------------------------------------------------------------------------
			addContent(CONTENTPARAM)----------------------------------------------------------------------------
		end--------------------------------------------------------------------------------------------------------------------------------------------------------
	else --------------------------------------------------------------------------------------------------------------------------------------------------------
		if FEATURE == "ON" and DAYONE ~="ON" then----------------------------------------------------------------------------
			addContent(CONTENTPARAM)----------------------------------------------------------------------------
		end--------------------------------------------------------------------------------------------------------------------------------------------------------
	end--------------------------------------------------------------------------------------------------------------------------------------------------------
end--------------------------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------
local readTemplate = function (name)----------------------------------------------------------------------------
	Template = io.open([[..\RGOG\XML\]]..name..[[.xml]],"r")----------------------------------------------------------------------------
	if Template ~=nil then--------------------------------------------------------------------------------------------------------------------------------------------------------
	CONTENT = Template:read("*all")--------------------------------------------------------------------------------------------------------------------------------------------------------
	Template:close()--------------------------------------------------------------------------------------------------------------------------------------------------------
	else print("------ REDMAS TEMPLATE not found : " .. name..".XML -----")----------------------------------------------------------------------------
	end--------------------------------------------------------------------------------------------------------------------------------------------------------
	return CONTENT--------------------------------------------------------------------------------------------------------------------------------------------------------
end--------------------------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------
local copyEXML = function (flag,source,destination)----------------------------------------------------------------------------
	if flag == "ON" then	--------------------------------------------------------------------------------------------------------------------------------------------------------
			CONTENT =--------------------------------------------------------------------------------------------------------------------------------------------------------
			{--------------------------------------------------------------------------------------------------------------------------------------------------------
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\]]..source,		----------------------------------------------------------------------------
				["FILE_DESTINATION"] 		= destination,			----------------------------------------------------------------------------
			}--------------------------------------------------------------------------------------------------------------------------------------------------------
		table.insert(CUSTOM_CONTENT, CONTENT) ----------------------------------------------------------------------------
	end--------------------------------------------------------------------------------------------------------------------------------------------------------
end	--------------------------------------------------------------------------------------------------------------------------------------------------------
--copyEXML("ON","_01.SCENE.EXML","MODELS\RGO\TEST.EXML")
local tablelength = function (T)------------------------------------------------------------------------------------------------------------
  local count = 0------------------------------------------------------------------------------------------------------------
  for _ in pairs(T) do count = count + 1
 end------------------------------------------------------------------------------------------------------------
  return count------------------------------------------------------------------------------------------------------------
end------------------------------------------------------------------------------------------------------------
function generateRareRessourcesBiome(BIOME_PATH,TYPE,PATH,MAXSIZE)
	-----------------------------------------------------------------------------------------------------------
	BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},		
					["ADD"] 	=
					[[
						<Property name="Objects"></Property>	
						<Property name="Landmarks">	  
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..PATH..[[" />
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="LEAF" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.4" />
											<Property name="G" value="0.53" />
											<Property name="B" value="0.289" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="2" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="FLORACLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="15" />
								<Property name="MatchGroundColour" value="True" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.91" />
								<Property name="MaxScale" value="]]..MAXSIZE..[[" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								]]..GIANT_SPARSE_SPAWN..[[						
							</Property>
						
						</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
function generateRessourcesBiome(BIOME_PATH,TYPE,PATH,MAXSIZE)
	BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\ROCK\DEAD.MBIN]],------------------------------------------------------------------------------------------------------------
					BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","DetailObjects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},------------------------------------------------------------------------------------------------------------		
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="DetailObjects">	 
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..PATH..[[" />
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="LEAF" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.4" />
											<Property name="G" value="0.53" />
											<Property name="B" value="0.289" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="2" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="5" />
								<Property name="MatchGroundColour" value="True" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.21" />
								<Property name="MaxScale" value="]]..MAXSIZE..[[" />
								<Property name="MinScaleY" value="0.91" />
								<Property name="MaxScaleY" value="1.15" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								]]..OFTEN_SPAWN_R2..[[						
							</Property>
						</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------

function generateRessourcesBiomeR(BIOME_PATH,TYPE,PATH,MAXSIZE)
	BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\ROCK\DEAD.MBIN]],------------------------------------------------------------------------------------------------------------
					BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","DetailObjects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},------------------------------------------------------------------------------------------------------------		
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="DetailObjects">	 
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..PATH..[[" />
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="LEAF" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.4" />
											<Property name="G" value="0.53" />
											<Property name="B" value="0.289" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="2" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="85" />
								<Property name="MatchGroundColour" value="True" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.2" />
								<Property name="MaxScale" value="]]..MAXSIZE..[[" />
								<Property name="MinScaleY" value="0.91" />
								<Property name="MaxScaleY" value="1.15" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								]]..OFTEN_SPAWN_R..[[						
							</Property>
						</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
function generateGiantBiomeFOREST
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_ROTATION,
		MAIN_TREE_SIZEMAX
	)

	------------------------------------------------------------------------------------------------------------
	GENERATED_GIANT_BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},		------------------------------------------------------------------------------------------------------------
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="Objects"></Property>	
						<Property name="Landmarks">		  
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="FLORACLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="High" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
								<Property name="OverlapStyle" value="SameSeed" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="10" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="1" />
								<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
								<Property name="MinScaleY" value="0.91" />
								<Property name="MaxScaleY" value="1.12" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
								]]..GIANT_OFTEN_SPAWN..[[
								</Property>
							
						</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_GIANT_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------
--generateORIGINSTREES------------------------------------------------------------------------------------------------------------
function generateORIGINSTREES
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_SIZEMAX,
		MAIN_TREE_ROTATION
		
	)

	------------------------------------------------------------------------------------------------------------
	GENERATED_BIOME = ------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="Landmarks"></Property>	
							<Property name="Objects">	

								<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="False" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.6" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="9999" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.6" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="9999" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

							</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------

--generateORIGINSTREESALT------------------------------------------------------------------------------------------------------------
function generateORIGINSTREESAlt
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_SIZEMAX,
		MAIN_TREE_ROTATION
		
	)

	------------------------------------------------------------------------------------------------------------
	GENERATED_BIOME = ------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="Landmarks"></Property>	
							<Property name="Objects">	  


								
								<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="False" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.002" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.002" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

																<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="False" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

							</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	

--generateORIGINSTREES------------------------------------------------------------------------------------------------------------
function generateORIGINSTREESFROZEN
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_SIZEMAX,
		MAIN_TREE_ROTATION
		
	)

	------------------------------------------------------------------------------------------------------------
	GENERATED_BIOME = ------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="Landmarks"></Property>	
							<Property name="Objects">	

								<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="True" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.6" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="9999" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.6" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="9999" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

							</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------


--generateORIGINSTREESALT------------------------------------------------------------------------------------------------------------
function generateORIGINSTREESAltFROZEN
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_SIZEMAX,
		MAIN_TREE_ROTATION
		
	)

	------------------------------------------------------------------------------------------------------------
	GENERATED_BIOME = ------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="Landmarks"></Property>	
							<Property name="Objects">	  


								
								<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="True" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.002" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.002" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

																<Property value="GcObjectSpawnData.xml">
									<Property name="DebugName" value="" />
										<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
										<Property name="Resource" value="GcResourceElement.xml">
										<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
									<Property name="ResHandle" value="GcResource.xml">
										<Property name="ResourceID" value="0" />
									</Property>
									<Property name="Seed" value="GcSeed.xml">
										<Property name="Seed" value="0" />
										<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="AltId" value="" />
									<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
										<Property name="Samplers">
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="OVERLAY" />
												<Property name="Group" value="BARKO" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Rock" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.673" />
												<Property name="G" value="0.641" />
												<Property name="B" value="0.567" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="GRASS" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARK" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Wood" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.93" />
												<Property name="G" value="0.891" />
												<Property name="B" value="0.838" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="3" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="2" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="LEAF" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Leaf" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="True" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.923" />
												<Property name="G" value="0.484" />
												<Property name="B" value="0.046" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										<Property value="TkProceduralTextureChosenOptionSampler.xml">
											<Property name="Options">
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="COLOUR" />
												<Property name="Group" value="BARKC" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Plant" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.164" />
												<Property name="G" value="0.509" />
												<Property name="B" value="0.63" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="" />
											</Property>
											<Property value="TkProceduralTextureChosenOption.xml">
												<Property name="Layer" value="BASE" />
												<Property name="Group" value="BARKB" />
												<Property name="Palette" value="TkPaletteTexture.xml">
												<Property name="Palette" value="Grass" />
												<Property name="ColourAlt" value="Primary" />
												</Property>
												<Property name="OverrideColour" value="False" />
												<Property name="Colour" value="Colour.xml">
												<Property name="R" value="0.542" />
												<Property name="G" value="0.67" />
												<Property name="B" value="0.333" />
												<Property name="A" value="1" />
												</Property>
												<Property name="OptionName" value="1" />
											</Property>
											</Property>
										</Property>
										</Property>
									</Property>
									</Property>
									<Property name="AltResources" />
									<Property name="ExtraTileTypes" />
									<Property name="Placement" value="FLORACLUMP" />
									<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
									</Property>
									<Property name="PlacementPriority" value="High" />
									<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
									<Property name="OverlapStyle" value="SameSeed" />
									<Property name="MinHeight" value="-1" />
									<Property name="MaxHeight" value="128" />
									<Property name="RelativeToSeaLevel" value="True" />
									<Property name="MinAngle" value="0" />
									<Property name="MaxAngle" value="60" />
									<Property name="MatchGroundColour" value="False" />
									<Property name="GroundColourIndex" value="Auto" />
									<Property name="SwapPrimaryForSecondaryColour" value="True" />
									<Property name="SwapPrimaryForRandomColour" value="False" />
									<Property name="AlignToNormal" value="False" />
									<Property name="MinScale" value="0.9" />
									<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
									<Property name="MinScaleY" value="0.81" />
									<Property name="MaxScaleY" value="1.02" />
									<Property name="SlopeScaling" value="1" />
									<Property name="PatchEdgeScaling" value="0" />
									<Property name="MaxXZRotation" value="]]..MAIN_TREE_ROTATION..[[" />
									<Property name="AutoCollision" value="False" />
									<Property name="CollideWithPlayer" value="True" />
									<Property name="CollideWithPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerVehicle" value="True" />
									<Property name="DestroyedByPlayerShip" value="True" />
									<Property name="DestroyedByTerrainEdit" value="True" />
									<Property name="InvisibleToCamera" value="True" />
									<Property name="CreaturesCanEat" value="False" />
									<Property name="ShearWindStrength" value="0" />
									<Property name="SupportsScanToReveal" value="False" />
									<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
									<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
									<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="60" />
										<Property value="150" />
										<Property value="500" />
									</Property>
									</Property>
									<Property name="QualityVariants">
									<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.5" />
									<Property name="FlatDensity" value="0.001" />
									<Property name="SlopeDensity" value="0" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="10" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="0" />
										<Property name="LodDistances">
										<Property value="0" />
										<Property value="20" />
										<Property value="30" />
										<Property value="40" />
										<Property value="500" />
										</Property>
									</Property>
									</Property>
								</Property>

							</Property>
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	


--generate BROKEN TREES
--[=[
function generateBrokenTreeS
	(
		GENERATED_BIOME_PATH,
		MAIN_TREE_TYPE,
		MAIN_TREE_PATH,		
		MAIN_TREE_ROTATION,
		MAIN_TREE_SIZEMAX
		
	)

	GENERATED_BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
							<Property name="Landmarks">
								<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..MAIN_TREE_TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..MAIN_TREE_PATH..[[" />
																					
																			
											
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="OVERLAY" />
											<Property name="Group" value="BARK" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Plant" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.474" />
											<Property name="G" value="0.56" />
											<Property name="B" value="0.231" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="LICHEN" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="BARK" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Wood" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.217" />
											<Property name="G" value="0.28" />
											<Property name="B" value="0.167" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="2" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="GRADIENT" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Plant" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.474" />
											<Property name="G" value="0.56" />
											<Property name="B" value="0.231" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.149" />
											<Property name="G" value="0.563" />
											<Property name="B" value="0.315" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="5" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.149" />
											<Property name="G" value="0.563" />
											<Property name="B" value="0.315" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="FLORACLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="30" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="1.7" />
								<Property name="MaxScale" value="]]..MAIN_TREE_SIZEMAX..[[" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="320" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.15" />
								<Property name="FlatDensity" value="0.0019" />
								<Property name="SlopeDensity" value="0.001" />
								<Property name="SlopeMultiplier" value="1" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
																				
																		
																		
																			
																				
																				
																					
																					
																						
																					
																					
																
															
															
															
															
															
											
											
								</Property>
							</Property>
							
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/TESTS/FREQTEST/RARE2.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers" />
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="RARE2X" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="High" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
								<Property name="OverlapStyle" value="SameSeed" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="180" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="1" />
								<Property name="MaxScale" value="1" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="1" />
									<Property name="FlatDensity" value="0.5" />
									<Property name="SlopeDensity" value="0.5" />
									<Property name="SlopeMultiplier" value="0" />
									<Property name="MaxRegionRadius" value="9999" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="9999" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							</Property>
							<Property name="Objects">
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Single" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/COMMON/RARERESOURCE/CRYSTALS/GEMCRYSTALS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers" />
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="RARE2" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
								<Property name="OverlapStyle" value="All" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="60" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.6" />
								<Property name="MaxScale" value="1.1" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="10" />
									<Property name="FlatDensity" value="0.035" />
									<Property name="SlopeDensity" value="0.035" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="3" />
									<Property name="MaxImposterRadius" value="0" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="9999" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							</Property>
 
							]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------
-- end generate BROKEN trees
--]=]

--generate ROCK SUBBIOMES
function generateRocksBiomes
	(
		GENERATED_BIOME_PATH,
		ROCK_TYPE,
		ROCK_PATH		
	)

	GENERATED_BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\ROCK\DEAD.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","DetailObjects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
					-----------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[
						<Property name="DetailObjects">
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..ROCK_TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..ROCK_PATH..[[" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="MOSS" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Plant" />
											<Property name="ColourAlt" value="MatchGround" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.509" />
											<Property name="G" value="0.685" />
											<Property name="B" value="0.7" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.509" />
											<Property name="G" value="0.685" />
											<Property name="B" value="0.7" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlace" />
								<Property name="OverlapStyle" value="All" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="150" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.03" />
								<Property name="MaxScale" value="0.1" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.1" />
								<Property name="FlatDensity" value="0.001" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="1" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/COMMON/GRASS/TALLGRASSBILLBOARD.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Grass" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.35" />
											<Property name="G" value="0.318" />
											<Property name="B" value="0.243" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="All" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.3" />
								<Property name="MaxScale" value="0.8" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.2" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.1" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="True" />
								<Property name="ShearWindStrength" value="0.3" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.25" />
									<Property name="FlatDensity" value="0.03" />
									<Property name="SlopeDensity" value="0.03" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.25" />
									<Property name="FlatDensity" value="0.03" />
									<Property name="SlopeDensity" value="0.03" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/TOXIC/SMALL/TOXICGRASS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Grass" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.35" />
											<Property name="G" value="0.318" />
											<Property name="B" value="0.243" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="All" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="145" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="1.2" />
								<Property name="MaxScale" value="1.8" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.1" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="True" />
								<Property name="ShearWindStrength" value="0.2" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="50" />
									<Property name="FadeOutEndDistance" value="60" />
									<Property name="FadeOutOffsetDistance" value="5" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
    
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/BARREN/PLANTS/SCRUBBUSH.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.643" />
											<Property name="G" value="0.195" />
											<Property name="B" value="0.136" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="0" />
								<Property name="MaxAngle" value="145" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="1" />
								<Property name="MaxScale" value="1.7" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.5" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="8" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.3" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.15" />
									<Property name="FlatDensity" value="0.08" />
									<Property name="SlopeDensity" value="0.08" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.15" />
									<Property name="FlatDensity" value="0.08" />
									<Property name="SlopeDensity" value="0.08" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/COMMON/ROCKS/SURFACEBLEND/GRAVELPATCHSANDBLEND.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.643" />
											<Property name="G" value="0.195" />
											<Property name="B" value="0.136" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="2.5" />
								<Property name="MaxScale" value="3.5" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.4" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.5" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.3" />
									<Property name="FlatDensity" value="0.04" />
									<Property name="SlopeDensity" value="0.02" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="60" />
									<Property name="FadeOutEndDistance" value="70" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="7" />
									<Property value="15" />
									<Property value="25" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.3" />
									<Property name="FlatDensity" value="0.04" />
									<Property name="SlopeDensity" value="0.02" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="7" />
									<Property value="15" />
									<Property value="25" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/COMMON/ROCKS/SURFACEBLEND/GRAVELPATCHSANDBLEND.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="SNOW" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Snow" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.509" />
											<Property name="G" value="0.685" />
											<Property name="B" value="0.7" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="MOSS" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Plant" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.278" />
											<Property name="G" value="0.581" />
											<Property name="B" value="0.653" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.334" />
											<Property name="G" value="0.33" />
											<Property name="B" value="0.327" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="SameSeed" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="3" />
								<Property name="MaxScale" value="4" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.4" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.5" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.4" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.04" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="60" />
									<Property name="FadeOutEndDistance" value="70" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="7" />
									<Property value="15" />
									<Property value="25" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.4" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.04" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="7" />
									<Property value="15" />
									<Property value="25" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/BARREN/PLANTS/SCRUBGRASS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.643" />
											<Property name="G" value="0.195" />
											<Property name="B" value="0.136" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="145" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="0.8" />
								<Property name="MaxScale" value="1.2" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="8" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.3" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="]]..ROCK_TYPE..[[" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="]]..ROCK_PATH..[[" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.923" />
											<Property name="G" value="0.484" />
											<Property name="B" value="0.046" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Normal" />
								<Property name="LargeObjectCoverage" value="DoNotPlace" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="0.03" />
								<Property name="MaxScale" value="0.7" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.1" />
								<Property name="MaxXZRotation" value="8" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.2" />
									<Property name="FlatDensity" value="0.008" />
									<Property name="SlopeDensity" value="0.005" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.2" />
									<Property name="FlatDensity" value="0.008" />
									<Property name="SlopeDensity" value="0.005" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/COMMON/GRASS/TALLGRASSBILLBOARD.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.643" />
											<Property name="G" value="0.195" />
											<Property name="B" value="0.136" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="145" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="0.3" />
								<Property name="MaxScale" value="0.8" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="8" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.3" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.035" />
									<Property name="SlopeDensity" value="0.035" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.035" />
									<Property name="SlopeDensity" value="0.035" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/TOXIC/SMALL/BLOBFRAGMENTS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="1" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Leaf" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.643" />
											<Property name="G" value="0.195" />
											<Property name="B" value="0.136" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="145" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="1" />
								<Property name="MaxScale" value="2" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="8" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.3" />
									<Property name="FlatDensity" value="0.02" />
									<Property name="SlopeDensity" value="0.02" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.3" />
									<Property name="FlatDensity" value="0.02" />
									<Property name="SlopeDensity" value="0.02" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="25" />
									<Property value="35" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/TOXIC/SMALL/TOXICGRASS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Grass" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="True" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.287" />
											<Property name="G" value="0.287" />
											<Property name="B" value="0.287" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="All" />
								<Property name="MinHeight" value="-10" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="150" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="1.2" />
								<Property name="MaxScale" value="1.8" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.05" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.2" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="50" />
									<Property name="FadeOutEndDistance" value="60" />
									<Property name="FadeOutOffsetDistance" value="5" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.24" />
									<Property name="FlatDensity" value="0.06" />
									<Property name="SlopeDensity" value="0.06" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/HQLUSH/SMALLPROPS/SMALLROCK.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers">
									<Property value="TkProceduralTextureChosenOptionSampler.xml">
										<Property name="Options">
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="OVERLAY" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Grass" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.245" />
											<Property name="G" value="0.591" />
											<Property name="B" value="0.7" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="TOPDOWNMOSS" />
										</Property>
										<Property value="TkProceduralTextureChosenOption.xml">
											<Property name="Layer" value="BASE" />
											<Property name="Group" value="" />
											<Property name="Palette" value="TkPaletteTexture.xml">
											<Property name="Palette" value="Rock" />
											<Property name="ColourAlt" value="Primary" />
											</Property>
											<Property name="OverrideColour" value="False" />
											<Property name="Colour" value="Colour.xml">
											<Property name="R" value="0.377" />
											<Property name="G" value="0.321" />
											<Property name="B" value="0.261" />
											<Property name="A" value="1" />
											</Property>
											<Property name="OptionName" value="" />
										</Property>
										</Property>
									</Property>
									</Property>
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="JAMESPATCH" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="None" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="150" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="0.2" />
								<Property name="MaxScale" value="0.8" />
								<Property name="MinScaleY" value="0.8" />
								<Property name="MaxScaleY" value="1.3" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0.5" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="False" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.2" />
									<Property name="FlatDensity" value="0.005" />
									<Property name="SlopeDensity" value="0.005" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="70" />
									<Property name="FadeOutEndDistance" value="80" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.2" />
									<Property name="FlatDensity" value="0.005" />
									<Property name="SlopeDensity" value="0.005" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="15" />
									<Property value="30" />
									<Property value="45" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/BARREN/PLANTS/SCRUBBUSH.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers" />
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="SMALLCLUMP" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="DoNotPlace" />
								<Property name="OverlapStyle" value="SameSeed" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="False" />
								<Property name="MinScale" value="0.8" />
								<Property name="MaxScale" value="1.5" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1.2" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.3" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.35" />
									<Property name="FlatDensity" value="0.03" />
									<Property name="SlopeDensity" value="0.03" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="9999" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.35" />
									<Property name="FlatDensity" value="0.03" />
									<Property name="SlopeDensity" value="0.03" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>
							<Property value="GcObjectSpawnData.xml">
								<Property name="DebugName" value="" />
								<Property name="Type" value="Instanced" />
								<Property name="Resource" value="GcResourceElement.xml">
								<Property name="Filename" value="MODELS/PLANETS/BIOMES/TOXIC/SMALL/TOXICGRASS.SCENE.MBIN" />
								<Property name="ResHandle" value="GcResource.xml">
									<Property name="ResourceID" value="0" />
								</Property>
								<Property name="Seed" value="GcSeed.xml">
									<Property name="Seed" value="0" />
									<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="AltId" value="" />
								<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
									<Property name="Samplers" />
								</Property>
								</Property>
								<Property name="AltResources" />
								<Property name="ExtraTileTypes" />
								<Property name="Placement" value="BARRENGRASSCLUM" />
								<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
								</Property>
								<Property name="PlacementPriority" value="Low" />
								<Property name="LargeObjectCoverage" value="AlwaysPlace" />
								<Property name="OverlapStyle" value="SameSeed" />
								<Property name="MinHeight" value="-1" />
								<Property name="MaxHeight" value="128" />
								<Property name="RelativeToSeaLevel" value="True" />
								<Property name="MinAngle" value="10" />
								<Property name="MaxAngle" value="140" />
								<Property name="MatchGroundColour" value="False" />
								<Property name="GroundColourIndex" value="Auto" />
								<Property name="SwapPrimaryForSecondaryColour" value="False" />
								<Property name="SwapPrimaryForRandomColour" value="False" />
								<Property name="AlignToNormal" value="True" />
								<Property name="MinScale" value="1" />
								<Property name="MaxScale" value="3" />
								<Property name="MinScaleY" value="1" />
								<Property name="MaxScaleY" value="1" />
								<Property name="SlopeScaling" value="1" />
								<Property name="PatchEdgeScaling" value="0" />
								<Property name="MaxXZRotation" value="0" />
								<Property name="AutoCollision" value="False" />
								<Property name="CollideWithPlayer" value="True" />
								<Property name="CollideWithPlayerVehicle" value="False" />
								<Property name="DestroyedByPlayerVehicle" value="True" />
								<Property name="DestroyedByPlayerShip" value="True" />
								<Property name="DestroyedByTerrainEdit" value="True" />
								<Property name="InvisibleToCamera" value="False" />
								<Property name="CreaturesCanEat" value="False" />
								<Property name="ShearWindStrength" value="0.2" />
								<Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
								<Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
								<Property name="ID" value="STANDARD" />
								<Property name="Coverage" value="0.2" />
								<Property name="FlatDensity" value="0.5" />
								<Property name="SlopeDensity" value="0" />
								<Property name="SlopeMultiplier" value="3" />
								<Property name="MaxRegionRadius" value="9999" />
								<Property name="MaxImposterRadius" value="10" />
								<Property name="FadeOutStartDistance" value="9999" />
								<Property name="FadeOutEndDistance" value="9999" />
								<Property name="FadeOutOffsetDistance" value="9999" />
								<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
									<Property value="0" />
								</Property>
								</Property>
								<Property name="QualityVariants">
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="STANDARD" />
									<Property name="Coverage" value="0.35" />
									<Property name="FlatDensity" value="0.04" />
									<Property name="SlopeDensity" value="0.04" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="2" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="9999" />
									<Property name="FadeOutEndDistance" value="9999" />
									<Property name="FadeOutOffsetDistance" value="9999" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									</Property>
								</Property>
								<Property value="GcObjectSpawnDataVariant.xml">
									<Property name="ID" value="ULTRA" />
									<Property name="Coverage" value="0.35" />
									<Property name="FlatDensity" value="0.04" />
									<Property name="SlopeDensity" value="0.04" />
									<Property name="SlopeMultiplier" value="1" />
									<Property name="MaxRegionRadius" value="7" />
									<Property name="MaxImposterRadius" value="10" />
									<Property name="FadeOutStartDistance" value="200" />
									<Property name="FadeOutEndDistance" value="210" />
									<Property name="FadeOutOffsetDistance" value="10" />
									<Property name="LodDistances">
									<Property value="0" />
									<Property value="20" />
									<Property value="60" />
									<Property value="150" />
									<Property value="500" />
									</Property>
								</Property>
								</Property>
							</Property>

							</Property>
  
 
							]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------------------------------------------------------------------
-- end generate ROCK SUBBIOMES
--[=[
function generateCaveBiomes
	(
		GENERATED_BIOME_PATH,
		PROPS_TYPE,
		PROPS_PATH
	)

	GENERATED_BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\ROCK\DEAD.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","DetailObjects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
					-----------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[						  
					    <Property name="DetailObjects">
			<Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="]]..PROPS_TYPE..[[" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="]]..PROPS_PATH..[[" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="FOREST" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Normal" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="60" />
        <Property name="MaxAngle" value="120" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="0.3" />
        <Property name="MaxScale" value="0.8" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="5" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
        <Property name="Coverage" value="0.2" />
        <Property name="FlatDensity" value="0.08" />
        <Property name="SlopeDensity" value="0.08" />
        <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />

      </Property>

	   <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="]]..PROPS_TYPE..[[" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="]]..PROPS_PATH..[[" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="CAVEGRASSCLUMP" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Normal" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="61" />
        <Property name="MaxAngle" value="222" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="0.01" />
        <Property name="MaxScale" value="0.03" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="5" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
        <Property name="Coverage" value="0.2" />
        <Property name="FlatDensity" value="0.08" />
        <Property name="SlopeDensity" value="0.08" />
        <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />

      </Property>

	
      <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="Single" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRATE\TREASURE_CHEST.SCENE.MBIN" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="RARECAVE" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="High" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="0" />
        <Property name="MaxAngle" value="5" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="1" />
        <Property name="MaxScale" value="1" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="0" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="False" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
          <Property name="Coverage" value="0.21" />
          <Property name="FlatDensity" value="0.0002" />
          <Property name="SlopeDensity" value="0.0002" />
          <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants">
          <Property value="GcObjectSpawnDataVariant.xml">
            <Property name="ID" value="STANDARD" />
            <Property name="Coverage" value="0.21" />
            <Property name="FlatDensity" value="0.0002" />
            <Property name="SlopeDensity" value="0.0002" />
            <Property name="SlopeMultiplier" value="1" />
            <Property name="MaxRegionRadius" value="10" />
            <Property name="MaxImposterRadius" value="10" />
            <Property name="FadeOutStartDistance" value="9999" />
            <Property name="FadeOutEndDistance" value="9999" />
            <Property name="FadeOutOffsetDistance" value="9999" />
            <Property name="LodDistances">
              <Property value="0" />
              <Property value="20" />
              <Property value="60" />
              <Property value="150" />
              <Property value="500" />
            </Property>
          </Property>
        </Property>
      </Property>

	   <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="Instanced" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="MODELS\PLANETS\BIOMES\COMMON\FLOWERS\YARROW.SCENE.MBIN" />
          <Property name="ResHandle" value="GcResource.xml">
            <Property name="ResourceID" value="0" />
          </Property>
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="1" />
            <Property name="UseSeedValue" value="True" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers">
              <Property value="TkProceduralTextureChosenOptionSampler.xml">
                <Property name="Options">
                  <Property value="TkProceduralTextureChosenOption.xml">
                    <Property name="Layer" value="BASE" />
                    <Property name="Group" value="" />
                    <Property name="Palette" value="TkPaletteTexture.xml">
                      <Property name="Palette" value="Plant" />
                      <Property name="ColourAlt" value="Primary" />
                    </Property>
                    <Property name="OverrideColour" value="True" />
                    <Property name="Colour" value="Colour.xml">
                      <Property name="R" value="0.42" />
                      <Property name="G" value="0.53" />
                      <Property name="B" value="0.239" />
                      <Property name="A" value="1" />
                    </Property>
                    <Property name="OptionName" value="6" />
                  </Property>
                </Property>
              </Property>
            </Property>
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="JAMESPATCH" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Low" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
        <Property name="OverlapStyle" value="All" />
        <Property name="MinHeight" value="-1" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="0" />
        <Property name="MaxAngle" value="255" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="1.6" />
        <Property name="MaxScale" value="1.9" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="0" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="False" />
        <Property name="CollideWithPlayerVehicle" value="False" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0.75" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
          <Property name="Coverage" value="0.3" />
          <Property name="FlatDensity" value="0.2" />
          <Property name="SlopeDensity" value="0.7" />
          <Property name="SlopeMultiplier" value="2.8" />
          <Property name="MaxRegionRadius" value="7" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="100" />
          <Property name="FadeOutEndDistance" value="110" />
          <Property name="FadeOutOffsetDistance" value="5" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="8" />
            <Property value="15" />
            <Property value="25" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />
      </Property>   
    </Property>
					     



  

 
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	------------------------------------------------

function generateMountainBiomes
	(
		GENERATED_BIOME_PATH,
		PROPS_TYPE,
		PROPS_PATH
	)

	GENERATED_BIOME =------------------------------------------------------------------------------------------------------------
	{	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] =------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\ROCK\DEAD.MBIN]],------------------------------------------------------------------------------------------------------------
					GENERATED_BIOME_PATH..".MBIN"------------------------------------------------------------------------------------------------------------
				}------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		},	------------------------------------------------------------------------------------------------------------
		{------------------------------------------------------------------------------------------------------------
			["MBIN_FILE_SOURCE"] = GENERATED_BIOME_PATH..".MBIN",------------------------------------------------------------------------------------------------------------
			["EXML_CHANGE_TABLE"] = ------------------------------------------------------------------------------------------------------------
			{------------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["PRECEDING_KEY_WORDS"] = {"Objects","DetailObjects"},------------------------------------------------------------------------------------------------------------
					["SECTION_ACTIVE"] = {1,2},------------------------------------------------------------------------------------------------------------
					["REMOVE"] 	= "SECTION"------------------------------------------------------------------------------------------------------------
				},------------------------------------------------------------------------------------------------------------
					-----------------------------------------------------------------------------------------------------------
				{------------------------------------------------------------------------------------------------------------
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},	------------------------------------------------------------------------------------------------------------	
					["ADD"] 	=------------------------------------------------------------------------------------------------------------
					[[						  
					    <Property name="DetailObjects">
			<Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="]]..PROPS_TYPE..[[" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="]]..PROPS_PATH..[[" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="FOREST" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Normal" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="60" />
        <Property name="MaxAngle" value="120" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="0.3" />
        <Property name="MaxScale" value="0.8" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="5" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
        <Property name="Coverage" value="0.2" />
        <Property name="FlatDensity" value="0.08" />
        <Property name="SlopeDensity" value="0.08" />
        <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />

      </Property>

	   <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="]]..PROPS_TYPE..[[" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="]]..PROPS_PATH..[[" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="CAVEGRASSCLUMP" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Normal" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="61" />
        <Property name="MaxAngle" value="222" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="0.01" />
        <Property name="MaxScale" value="0.06" />
        <Property name="MinScaleY" value="0.1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="5" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
        <Property name="Coverage" value="0.2" />
        <Property name="FlatDensity" value="0.08" />
        <Property name="SlopeDensity" value="0.08" />
        <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />

      </Property>

	
      <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="Single" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRATE\TREASURE_CHEST.SCENE.MBIN" />
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="0" />
            <Property name="UseSeedValue" value="False" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers" />
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="RARECAVE" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="High" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceClose" />
        <Property name="OverlapStyle" value="None" />
        <Property name="MinHeight" value="-128" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="0" />
        <Property name="MaxAngle" value="5" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="1" />
        <Property name="MaxScale" value="1" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="0" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="True" />
        <Property name="CollideWithPlayerVehicle" value="False" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
          <Property name="Coverage" value="0.21" />
          <Property name="FlatDensity" value="0.0002" />
          <Property name="SlopeDensity" value="0.0002" />
          <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="9999" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="9999" />
          <Property name="FadeOutEndDistance" value="9999" />
          <Property name="FadeOutOffsetDistance" value="9999" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="20" />
            <Property value="60" />
            <Property value="150" />
            <Property value="500" />
          </Property>
        </Property>
        <Property name="QualityVariants">
          <Property value="GcObjectSpawnDataVariant.xml">
            <Property name="ID" value="STANDARD" />
            <Property name="Coverage" value="0.21" />
            <Property name="FlatDensity" value="0.0002" />
            <Property name="SlopeDensity" value="0.0002" />
            <Property name="SlopeMultiplier" value="1" />
            <Property name="MaxRegionRadius" value="10" />
            <Property name="MaxImposterRadius" value="10" />
            <Property name="FadeOutStartDistance" value="9999" />
            <Property name="FadeOutEndDistance" value="9999" />
            <Property name="FadeOutOffsetDistance" value="9999" />
            <Property name="LodDistances">
              <Property value="0" />
              <Property value="20" />
              <Property value="60" />
              <Property value="150" />
              <Property value="500" />
            </Property>
          </Property>
        </Property>
      </Property>

	   <Property value="GcObjectSpawnData.xml">
        <Property name="DebugName" value="" />
        <Property name="Type" value="Instanced" />
        <Property name="Resource" value="GcResourceElement.xml">
          <Property name="Filename" value="MODELS\PLANETS\BIOMES\COMMON\FLOWERS\YARROW.SCENE.MBIN" />
          <Property name="ResHandle" value="GcResource.xml">
            <Property name="ResourceID" value="0" />
          </Property>
          <Property name="Seed" value="GcSeed.xml">
            <Property name="Seed" value="1" />
            <Property name="UseSeedValue" value="True" />
          </Property>
          <Property name="AltId" value="" />
          <Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
            <Property name="Samplers">
              <Property value="TkProceduralTextureChosenOptionSampler.xml">
                <Property name="Options">
                  <Property value="TkProceduralTextureChosenOption.xml">
                    <Property name="Layer" value="BASE" />
                    <Property name="Group" value="" />
                    <Property name="Palette" value="TkPaletteTexture.xml">
                      <Property name="Palette" value="Plant" />
                      <Property name="ColourAlt" value="Primary" />
                    </Property>
                    <Property name="OverrideColour" value="True" />
                    <Property name="Colour" value="Colour.xml">
                      <Property name="R" value="0.42" />
                      <Property name="G" value="0.53" />
                      <Property name="B" value="0.239" />
                      <Property name="A" value="1" />
                    </Property>
                    <Property name="OptionName" value="6" />
                  </Property>
                </Property>
              </Property>
            </Property>
          </Property>
        </Property>
        <Property name="AltResources" />
        <Property name="ExtraTileTypes" />
        <Property name="Placement" value="CAVEGRASSCLUMP" />
        <Property name="Seed" value="GcSeed.xml">
          <Property name="Seed" value="0" />
          <Property name="UseSeedValue" value="False" />
        </Property>
        <Property name="PlacementPriority" value="Low" />
        <Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
        <Property name="OverlapStyle" value="All" />
        <Property name="MinHeight" value="-1" />
        <Property name="MaxHeight" value="128" />
        <Property name="RelativeToSeaLevel" value="True" />
        <Property name="MinAngle" value="0" />
        <Property name="MaxAngle" value="255" />
        <Property name="MatchGroundColour" value="False" />
        <Property name="GroundColourIndex" value="Auto" />
        <Property name="SwapPrimaryForSecondaryColour" value="False" />
        <Property name="SwapPrimaryForRandomColour" value="False" />
        <Property name="AlignToNormal" value="True" />
        <Property name="MinScale" value="1.6" />
        <Property name="MaxScale" value="1.9" />
        <Property name="MinScaleY" value="1" />
        <Property name="MaxScaleY" value="1" />
        <Property name="SlopeScaling" value="1" />
        <Property name="PatchEdgeScaling" value="0" />
        <Property name="MaxXZRotation" value="0" />
        <Property name="AutoCollision" value="False" />
        <Property name="CollideWithPlayer" value="False" />
        <Property name="CollideWithPlayerVehicle" value="False" />
        <Property name="DestroyedByPlayerVehicle" value="True" />
        <Property name="DestroyedByPlayerShip" value="True" />
        <Property name="DestroyedByTerrainEdit" value="True" />
        <Property name="InvisibleToCamera" value="False" />
        <Property name="CreaturesCanEat" value="False" />
        <Property name="ShearWindStrength" value="0.75" />
        <Property name="DestroyedByVehicleEffect" value="VEHICLECRASH" />
        <Property name="QualityVariantData" value="GcObjectSpawnDataVariant.xml">
          <Property name="ID" value="STANDARD" />
          <Property name="Coverage" value="0.18" />
          <Property name="FlatDensity" value="0.2" />
          <Property name="SlopeDensity" value="0" />
          <Property name="SlopeMultiplier" value="1" />
          <Property name="MaxRegionRadius" value="7" />
          <Property name="MaxImposterRadius" value="10" />
          <Property name="FadeOutStartDistance" value="100" />
          <Property name="FadeOutEndDistance" value="110" />
          <Property name="FadeOutOffsetDistance" value="5" />
          <Property name="LodDistances">
            <Property value="0" />
            <Property value="8" />
            <Property value="15" />
            <Property value="25" />
            <Property value="1500" />
          </Property>
        </Property>
        <Property name="QualityVariants" />
      </Property>   
    </Property>
					     



  

 
					]]
				},------------------------------------------------------------------------------------------------------------
			}------------------------------------------------------------------------------------------------------------
		}------------------------------------------------------------------------------------------------------------
	}------------------------------------------------------------------------------------------------------------
	addContent(GENERATED_BIOME)------------------------------------------------------------------------------------------------------------
end	--]=]------------------------------------------------------------------------------------------------------------
-- end generate CAVE SUBBIOMES
--[=[
	local generateGiantBiomeMEGALITH = function
	(
		GENERATED_GIANT_BIOME_PATH,
		LARGEROCK_TYPE,
		LARGEROCK_PATH,
		LARGEROCK_ROTATION,
		LARGEROCK_SIZEMAX
	)


	GENERATED_GIANT_BIOME =
	{
		{
			["MBIN_FILE_SOURCE"] =
			{
				{
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],
					GENERATED_GIANT_BIOME_PATH..".MBIN"
				}
			}
		},
		{
			["MBIN_FILE_SOURCE"] = GENERATED_GIANT_BIOME_PATH..".MBIN",
			["EXML_CHANGE_TABLE"] =
			{
				{
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},
					["SECTION_ACTIVE"] = {1,2},
					["REMOVE"] 	= "SECTION"
				},
				{
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},
					["SECTION_ACTIVE"] = {1,2},
					["REMOVE"] 	= "SECTION"
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},
					["ADD"] 	=
					[[
						<Property name="Objects"></Property>
						<Property name="Objects">

						<Property value="GcObjectSpawnData.xml">
							<Property name="DebugName" value="" />
							<Property name="Type" value="]]..LARGEROCK_TYPE..[[" />
							<Property name="Resource" value="GcResourceElement.xml">
							<Property name="Filename" value="]]..LARGEROCK_PATH..[[" />
							<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
							</Property>
							<Property name="AltId" value="" />
							<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
								<Property name="Samplers">
								<Property value="TkProceduralTextureChosenOptionSampler.xml">
									<Property name="Options">
									<Property value="TkProceduralTextureChosenOption.xml">
										<Property name="Layer" value="BASE" />
										<Property name="Group" value="LEAF" />
										<Property name="Palette" value="TkPaletteTexture.xml">
										<Property name="Palette" value="Leaf" />
										<Property name="ColourAlt" value="Primary" />
										</Property>
										<Property name="OverrideColour" value="True" />
										<Property name="Colour" value="Colour.xml">
										<Property name="R" value="0.4" />
										<Property name="G" value="0.53" />
										<Property name="B" value="0.289" />
										<Property name="A" value="1" />
										</Property>
										<Property name="OptionName" value="2" />
									</Property>
									</Property>
								</Property>
								</Property>
							</Property>
							</Property>
							<Property name="AltResources" />
							<Property name="ExtraTileTypes" />
							<Property name="Placement" value="FLORACLUMP" />
							<Property name="Seed" value="GcSeed.xml">
							<Property name="Seed" value="0" />
							<Property name="UseSeedValue" value="False" />
							</Property>
							<Property name="PlacementPriority" value="Normal" />
							<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
							<Property name="OverlapStyle" value="None" />
							<Property name="MinHeight" value="-1" />
							<Property name="MaxHeight" value="1128" />
							<Property name="RelativeToSeaLevel" value="True" />
							<Property name="MinAngle" value="0" />
							<Property name="MaxAngle" value="15" />
							<Property name="MatchGroundColour" value="True" />
							<Property name="GroundColourIndex" value="Auto" />
							<Property name="SwapPrimaryForSecondaryColour" value="False" />
							<Property name="SwapPrimaryForRandomColour" value="False" />
							<Property name="AlignToNormal" value="True" />
							<Property name="MinScale" value="]]..LARGEROCK_SIZEMAX..[[" />
							<Property name="MaxScale" value="]]..LARGEROCK_SIZEMAX..[[" />
							<Property name="MinScaleY" value="1" />
							<Property name="MaxScaleY" value="1.3" />
							<Property name="SlopeScaling" value="1" />
							<Property name="PatchEdgeScaling" value="0" />
							<Property name="MaxXZRotation" value="]]..LARGEROCK_ROTATION..[[" />
							]]..GIANT_OFTEN_SPAWN..[[
						</Property>
					</Property>


					]]
				},
			}
		}

	}
	addContent(GENERATED_GIANT_BIOME)
end--]=]
--[=[
local generateGiantBiomeCITY = function
	(
		GENERATED_GIANT_BIOME_PATH,
		BIG_OBJECT_TYPE,
		BIG_OBJECT_PATH,
		BIG_OBJECT_ROTATION,
		BIG_OBJECT_SIZEMAX
	)


	GENERATED_GIANT_BIOME =
	{
		{
			["MBIN_FILE_SOURCE"] =
			{
				{
					[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\ALWAYSPRESENT.MBIN]],
					GENERATED_GIANT_BIOME_PATH..".MBIN"
				}
			}
		},
		{
			["MBIN_FILE_SOURCE"] = GENERATED_GIANT_BIOME_PATH..".MBIN",
			["EXML_CHANGE_TABLE"] =
			{
				{
					["PRECEDING_KEY_WORDS"] = {"Objects","Landmarks"},
					["SECTION_ACTIVE"] = {1,2},
					["REMOVE"] 	= "SECTION"
				},
				{
					["PRECEDING_KEY_WORDS"] = {"Objects","Objects"},
					["SECTION_ACTIVE"] = {1,2},
					["REMOVE"] 	= "SECTION"
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Objects","GcEnvironmentSpawnData.xml"},
					["ADD"] 	=
					[[
						<Property name="Objects"></Property>
						<Property name="Objects">

						<Property value="GcObjectSpawnData.xml">
							<Property name="DebugName" value="" />
							<Property name="Type" value="]]..BIG_OBJECT_TYPE..[[" />
							<Property name="Resource" value="GcResourceElement.xml">
							<Property name="Filename" value="]]..BIG_OBJECT_PATH..[[" />

							<Property name="Seed" value="GcSeed.xml">
								<Property name="Seed" value="0" />
								<Property name="UseSeedValue" value="False" />
							</Property>
							<Property name="AltId" value="" />
							<Property name="ProceduralTexture" value="TkProceduralTextureChosenOptionList.xml">
								<Property name="Samplers">
								<Property value="TkProceduralTextureChosenOptionSampler.xml">
									<Property name="Options">
									<Property value="TkProceduralTextureChosenOption.xml">
										<Property name="Layer" value="BASE" />
										<Property name="Group" value="LEAF" />
										<Property name="Palette" value="TkPaletteTexture.xml">
										<Property name="Palette" value="Leaf" />
										<Property name="ColourAlt" value="Primary" />
										</Property>
										<Property name="OverrideColour" value="True" />
										<Property name="Colour" value="Colour.xml">
										<Property name="R" value="0.4" />
										<Property name="G" value="0.53" />
										<Property name="B" value="0.289" />
										<Property name="A" value="1" />
										</Property>
										<Property name="OptionName" value="2" />
									</Property>
									</Property>
								</Property>
								</Property>
							</Property>
							</Property>
							<Property name="AltResources" />
							<Property name="ExtraTileTypes" />
							<Property name="Placement" value="FLORACLUMP" />
							<Property name="Seed" value="GcSeed.xml">
							<Property name="Seed" value="0" />
							<Property name="UseSeedValue" value="False" />
							</Property>
							<Property name="PlacementPriority" value="Normal" />
							<Property name="LargeObjectCoverage" value="DoNotPlaceIgnoreFootprint" />
							<Property name="OverlapStyle" value="None" />
							<Property name="MinHeight" value="-1" />
							<Property name="MaxHeight" value="1128" />
							<Property name="RelativeToSeaLevel" value="True" />
							<Property name="MinAngle" value="0" />
							<Property name="MaxAngle" value="15" />
							<Property name="MatchGroundColour" value="True" />
							<Property name="GroundColourIndex" value="Auto" />
							<Property name="SwapPrimaryForSecondaryColour" value="False" />
							<Property name="SwapPrimaryForRandomColour" value="False" />
							<Property name="AlignToNormal" value="True" />
							<Property name="MinScale" value="1" />
							<Property name="MaxScale" value="]]..BIG_OBJECT_SIZEMAX..[[" />
							<Property name="MinScaleY" value="1" />
							<Property name="MaxScaleY" value="1" />
							<Property name="SlopeScaling" value="1" />
							<Property name="PatchEdgeScaling" value="0" />
							<Property name="MaxXZRotation" value="]]..BIG_OBJECT_ROTATION..[[" />
							]]..GIANT_SPARSE_SPAWN..[[
						</Property>

					</Property>


					]]
				},
			}
		}

	}
	addContent(GENERATED_GIANT_BIOME)
end
--]=]
----------------------------------------------------------------------------------------------------------------------------------------------------------
	RARE_ASTEROID_SPACING_MULTIPLIER = ""----------------------------------------------------------------------------
	LARGE_ASTEROID_SPACING_MULTIPLIER = ""---------------------------------------------------------------------------
	ASTEROID_SPACING_MULTIPLIER = ""-----------------------------------------------------------------------------
	RARE_ASTEROID_SCALE_MULTIPLIER =  ""----------------------------------------------------------------------------
	LARGE_ASTEROID_SCALE_MULTIPLIER =  ""---------------------------------------------------------------------------
	ASTEROID_SCALE_MULTIPLIER =  ""----
local createAsteroidsFields = function  (ASTEROIDS_FILEDS_DATA)--------------------------------------------------------------------------------------------------------------------------------------------------------
	RARE_ASTEROID_SPACING_MULTIPLIER = ASTEROIDS_FILEDS_DATA.RARE_ASTEROID_SPACING_MULTIPLIER----------------------------------------------------------------------------
	LARGE_ASTEROID_SPACING_MULTIPLIER = ASTEROIDS_FILEDS_DATA.LARGE_ASTEROID_SPACING_MULTIPLIER----------------------------------------------------------------------------
	ASTEROID_SPACING_MULTIPLIER = ASTEROIDS_FILEDS_DATA.ASTEROID_SPACING_MULTIPLIER----------------------------------------------------------------------------
	RARE_ASTEROID_SCALE_MULTIPLIER = ASTEROIDS_FILEDS_DATA.RARE_ASTEROID_SCALE_MULTIPLIER----------------------------------------------------------------------------
	LARGE_ASTEROID_SCALE_MULTIPLIER = ASTEROIDS_FILEDS_DATA.LARGE_ASTEROID_SCALE_MULTIPLIER----------------------------------------------------------------------------
	ASTEROID_SCALE_MULTIPLIER = ASTEROIDS_FILEDS_DATA.ASTEROID_SCALE_MULTIPLIER----------------------------------------------------------------------------
end--------------------------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------
if DAY_ONE_MODE == "ON"---------------------------------------------------------------------------------
then---------------------------------------------------------------------------------------------------------------------------------------------------
	MODNAME = MODNAME..[[_DAY_ONE_VERSION]]---------------------------------------------------------------------------------
end---------------------------------------------------------------------------------------------------------------------------------------------------
if ASTEROIDS_FIELDS_TYPE == "FANTASY" then---------------------------------------------------------------------------------
	createAsteroidsFields(ASTEROIDS_FANTASY_PRESET)---------------------------------------------------------------------------------
end---------------------------------------------------------------------------------------------------------------------------------------------------
if ASTEROIDS_FIELDS_TYPE == "GLUED" then---------------------------------------------------------------------------------
	createAsteroidsFields(ASTEROIDS_GLUED_PRESET)---------------------------------------------------------------------------------
end
if ASTEROIDS_FIELDS_TYPE == "OFF" then---------------------------------------------------------------------------------
	createAsteroidsFields(ASTEROIDS_VANILLA_PRESET)---------------------------------------------------------------------------------
end---------------------------------------------------------------------------------------------------------------------------------------------------
if MULTIPLAYER_MODE == "ON" then
MODDED_TERRAIN_SHAPES_FEATURE = "OFF"
E3_STYLE_RESSOURCES_DEPOSITS = "OFF"
FANTASY_BIOMES_FEATURE = "OFF"
end
--[=[
if PERFORMANCE_MODE == "ON" then
CAVE_BIOMES_FEATURE = "OFF"
MONTAINS_BIOMES_FEATURE = "OFF"
end--]=]
if ASTEROIDS_FIELDS_TYPE == "REALISTIC" then---------------------------------------------------------------------------------
	createAsteroidsFields(ASTEROIDS_REALISTIC_PRESET)---------------------------------------------------------------------------------
end---------------------------------------------------------------------------------------------------------------------------------------------------
-- SPAWNDISTANCE = 4---------------------------------------------------------------------------------
-- SPAWNRATE = 500---------------------------------------------------------------------------------
TIMER_VALUE =""
if CREATURES_OVERHAUL=="ON" then
	TIMER_VALUE = tostring(OVERHAUL_TIMER * 3600)---------------------------------------------------------------------------------
end
SPACEBLURVALUE = "0.6"---------------------------------------------------------------------------------
R_VALUE_REF =0---------------------------------------------------------------------------------------------------------------------------------------------------
G_VALUE_REF =0---------------------------------------------------------------------------------------------------------------------------------------------------
B_VALUE_REF =0---------------------------------------------------------------------------------
--ALWAYS = "ALWAYS"---------------------------------------------------------------------------------
BINOC_SUN =""
BINOC_CLEAR =""
if BINOCULARS_TYPE == "SUN" then------------------------------------------------------------------
	BINOC_SUN = "ON"------------------------------------------------------------------------------------------------------------------------------------
else------------------------------------------------------------------------------------------------------------------------------------
	BINOC_SUN = "OFF"------------------------------------------------------------------------------------------------------------------------------------
end------------------------------------------------------------------------------------------------------------------------------------
if BINOCULARS_TYPE == "CLEAR" then------------------------------------------------------------------
	BINOC_CLEAR = "ON"------------------------------------------------------------------
else------------------------------------------------------------------------------------------------------------------------------------
	BINOC_CLEAR = "OFF"------------------------------------------------------------------
end------------------------------------------------------------------------------------------------------------------------------------
SPACESHIPS_SPACE_THRUSTFORCE_S = tostring(SPACESHIPS_SPACE_THRUSTFORCE * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_MAXPSEED_S = tostring(SPACESHIPS_SPACE_MAXPSEED * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_FORCE_S = tostring(SPACESHIPS_SPACE_BOOST_FORCE * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_MAX_S = tostring(SPACESHIPS_SPACE_BOOST_MAX * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
--SPACESHIPS_SPACE_FALLOFF_S = tostring(SPACESHIPS_SPACE_FALLOFF)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_THRUSTFORCE_S = tostring(SPACESHIPS_PLANET_THRUSTFORCE * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_MAXPSEED_S = tostring(SPACESHIPS_PLANET_MAXPSEED * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_FORCE_S = tostring(SPACESHIPS_PLANET_BOOST_FORCE * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_MAX_S = tostring(SPACESHIPS_PLANET_BOOST_FORCE * SPACESHIPS_SMALL_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
--SPACESHIPS_PLANET_FALLOFF_S = tostring(SPACESHIPS_PLANET_FALLOFF) ---------------------------------------------------------------------------------
SPACESHIPS_SPACE_THRUSTFORCE_H = tostring(SPACESHIPS_SPACE_THRUSTFORCE * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_MAXPSEED_H = tostring(SPACESHIPS_SPACE_MAXPSEED * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_FORCE_H = tostring(SPACESHIPS_SPACE_BOOST_FORCE * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_MAX_H = tostring(SPACESHIPS_SPACE_BOOST_MAX * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
--SPACESHIPS_SPACE_FALLOFF_H = tostring(SPACESHIPS_SPACE_FALLOFF) ---------------------------------------------------------------------------------
SPACESHIPS_PLANET_THRUSTFORCE_H = tostring(SPACESHIPS_PLANET_THRUSTFORCE * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_MAXPSEED_H = tostring(SPACESHIPS_PLANET_MAXPSEED * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
--SPACESHIPS_PLANET_FALLOFF_H = tostring(SPACESHIPS_PLANET_FALLOFF * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_FORCE_H = tostring(SPACESHIPS_PLANET_BOOST_FORCE * SPACESHIPS_HEAVY_SPEED_MULTIPLIER)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_MAX_H = tostring(SPACESHIPS_PLANET_BOOST_MAX)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_THRUSTFORCE = tostring(SPACESHIPS_SPACE_THRUSTFORCE)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_MAXPSEED = tostring(SPACESHIPS_SPACE_MAXPSEED)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_FALLOFF = tostring(SPACESHIPS_SPACE_FALLOFF)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_FORCE = tostring(SPACESHIPS_SPACE_BOOST_FORCE)---------------------------------------------------------------------------------
SPACESHIPS_SPACE_BOOST_MAX = tostring(SPACESHIPS_SPACE_BOOST_MAX)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_THRUSTFORCE = tostring(SPACESHIPS_PLANET_THRUSTFORCE)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_MAXPSEED = tostring(SPACESHIPS_PLANET_MAXPSEED)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_FALLOFF = tostring(SPACESHIPS_PLANET_FALLOFF)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_FORCE = tostring(SPACESHIPS_PLANET_BOOST_FORCE)---------------------------------------------------------------------------------
SPACESHIPS_PLANET_BOOST_MAX = tostring(SPACESHIPS_PLANET_BOOST_MAX)---------------------------------------------------------------------------------

DISABLE_TRADING_ROUTES = "False"	------------------------------------------------------------------------------------------------------------------------------------------------------------------
if TRADING_ROUTES == "OFF" then------------------------------------------------------------------------------------------------------------------------------------------------------------------
DISABLE_TRADING_ROUTES = "True"------------------------------------------------------------------------------------------------------------------------------------------------------------------
end------------------------------------------------------------------------------------------------------------------------------------------------------------------
BIGWHEELSSIZE = "1.15"------------------------------------------------------------------------------------------------------------------------------------------------------------------
if ROAMER_BIGWHEELS_FEATURE == "ON" then---------------------------------------------------------------------------------
	BIGWHEELSSIZE = "1.5"---------------------------------------------------------------------------------
end------------------------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------
-----XML    -----------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------
ALIENRING = readTemplate("ALIENRING")
FREIGHTER_DESCRIPTOR = readTemplate("FREIGHTER_DESCRIPTOR")---------------------------------------------------------------------------------
CONTENT_FREIGHTERS_SPAWNER = readTemplate("ADDITIONAL_FREIGHTERS")---------------------------------------------------------------------------------
LARGE_FREIGHTERS = readTemplate("LARGE_FREIGHTERS")---------------------------------------------------------------------------------
FREIGHTER_CONTENT = readTemplate("FREIGHTER_CONTENT")---------------------------------------------------------------------------------
TRADINGPOST_SCIENTIFIC_CONTENT = readTemplate("TRADINGPOST_SCIENTIFIC_CONTENT")---------------------------------------------------------------------------------
TRADINGPOST_WARRIOR_CONTENT = readTemplate("TRADINGPOST_WARRIOR_CONTENT")---------------------------------------------------------------------------------
TRADINGPOST_TRADER_CONTENT = readTemplate("TRADINGPOST_TRADER_CONTENT")---------------------------------------------------------------------------------
TRADINGPOST_COMMON_CONTENT = readTemplate("TRADINGPOST_COMMON_CONTENT")---------------------------------------------------------------------------------
KORVAX_TOWER = readTemplate("KORVAX_TOWER")---------------------------------------------------------------------------------
VYK_TOWER = readTemplate("VYK_TOWER")---------------------------------------------------------------------------------
POSITIONS = readTemplate("POSITIONS")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_BUTTERFLIES = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_BUTTERFLIES")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS_PRED = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS_PRED")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDFLOAT = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDFLOAT")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL")---------------------------------------------------------------------------------
REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL_PRED = readTemplate("REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL_PRED")---------------------------------------------------------------------------------
REDMAS_CREATURES_GRUNTS = readTemplate("REDMAS_CREATURES_GRUNTS")---------------------------------------------------------------------------------
REDMAS_CREATURES_DIPLOS = readTemplate("REDMAS_CREATURES_DIPLOS")---------------------------------------------------------------------------------
REDMAS_CREATURES_KRITTERS = readTemplate("REDMAS_CREATURES_KRITTERS")---------------------------------------------------------------------------------
SHUTTLE_PROC = readTemplate("SHUTTLE_PROC")---------------------------------------------------------------------------------
SHUTTLE_DESC = readTemplate("SHUTTLE_DESC")---------------------------------------------------------------------------------
FIGHTER_PROC = readTemplate("FIGHTER_PROC")---------------------------------------------------------------------------------
---------------------------------------------------------------------------------
--SAILCOCKPIT_PROC = readTemplate("SAILCOCKPIT_PROC")---------------------------------------------------------------------------------
--SAILCOCKPIT_DESC = readTemplate("SAILCOCKPIT_DESC")---------------------------------------------------------------------------------
_WINGS_F = readTemplate("_WINGS_F")---------------------------------------------------------------------------------
ACCAx2 = readTemplate("ACCAx2")---------------------------------------------------------------------------------
ACCASMALLx2 = readTemplate("ACCASMALLx2")
--TURBINEFIN = readTemplate("TURBINEFIN")---------------------------------------------------------------------------------
TURBINESAIL = readTemplate("TURBINESAIL")---------------------------------------------------------------------------------
ACCAWINDYx2 = readTemplate("ACCAWINDYx2")---------------------------------------------------------------------------------
TURBINEAAF = readTemplate("TURBINEAAF")---------------------------------------------------------------------------------
MOUSTACHE = readTemplate("MOUSTACHE")---------------------------------------------------------------------------------
CANOPYA = readTemplate("CANOPYA")---------------------------------------------------------------------------------
--ADDITIONAL_SUBWINGS = readTemplate("ADDITIONAL_SUBWINGS")---------------------------------------------------------------------------------
--ADDITIONAL_SUBWINGS_DESC = readTemplate("ADDITIONAL_SUBWINGS_DESC")---------------------------------------------------------------------------------
WINGSX = readTemplate("WINGSX")---------------------------------------------------------------------------------
WINGSFX = readTemplate("WINGSFX")--------------------------------------------------------------------------------------------------
--SANDWORM_NEW_ENTITY = readTemplate("SANDWORM_NEW_ENTITY")---------------------------------------------------------------------------------
E3TRAIL = readTemplate("E3TRAIL")---------------------------------------------------------------------------------
BALL = readTemplate("BALL")---------------------------------------------------------------------------------
BIKEPRES1 = readTemplate("BIKEPRES1")---------------------------------------------------------------------------------
BIKEPRES2 = readTemplate("BIKEPRES2")---------------------------------------------------------------------------------
--BIKE_DESC = readTemplate("BIKE_DESC")---------------------------------------------------------------------------------
BUGGY_LAMPS = readTemplate("BUGGY_LAMPS")---------------------------------------------------------------------------------
KANEDA = readTemplate("KANEDA")---------------------------------------------------------------------------------
DRAGONFLYGARAGE = readTemplate("DRAGONFLYGARAGE")---------------------------------------------------------------------------------
DRAGONFLYCOCKPIT = readTemplate("DRAGONFLYCOCKPIT")---------------------------------------------------------------------------------
DRAGONFLY_WHEELS = readTemplate("DRAGONFLY_WHEELS")---------------------------------------------------------------------------------
DRAGONFLYEXO = readTemplate("DRAGONFLYEXO")---------------------------------------------------------------------------------
_HOVERCRAFT = readTemplate("_HOVERCRAFT")---------------------------------------------------------------------------------
COCKPIT_A_DATA = readTemplate("COCKPIT_A_DATA")-------------------------------------------------------------------------------
COCKPIT_B_DATA = readTemplate("COCKPIT_B_DATA")-------------------------------------------------------------------------------
COCKPIT_D_DATA = readTemplate("COCKPIT_D_DATA")-------------------------------------------------------------------------------
COCKPIT_E_DATA = readTemplate("COCKPIT_E_DATA")-------------------------------------------------------------------------------
COCKPIT_F_DATA = readTemplate("COCKPIT_F_DATA")-------------------------------------------------------------------------------
--DROPSHIPS_PROC = readTemplate("DROPSHIPS_PROC")-------------------------------------------------------------------------------
--SCIENTIFIC_PROC = readTemplate("SCIENTIFIC_PROC")-------------------------------------------------------------------------------
--SCIENTIFIC_DESC = readTemplate("SCIENTIFIC_DESC")-------------------------------------------------------------------------------
SENT_CIVIL = readTemplate("SENT_CIVIL")
FREIGHTER_GROUP = readTemplate('FREIGHTER_GROUP')
FREIGHTER_EXO = readTemplate('FREIGHTER_EXO')
KNOWNPROD = readTemplate("KNOWNPROD")
if GIANT_MECHS_BETA_FEATURE ~= "ON" then
	MECHS_SIZE_MULTIPLIER = 1
end
RESIZABLEMECH =
[[
		<Property value="TkSceneNodeData.xml">
		<Property name="Name" value="pCube1" />
		<Property name="NameHash" value="2488506156" />
		<Property name="Type" value="REFERENCE" />
		<Property name="Transform" value="TkTransformData.xml">
			<Property name="TransX" value="0" />
			<Property name="TransY" value="0" />
			<Property name="TransZ" value="0" />
			<Property name="RotX" value="0" />
			<Property name="RotY" value="0" />
			<Property name="RotZ" value="0" />
			<Property name="ScaleX" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
			<Property name="ScaleY" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
			<Property name="ScaleZ" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
		</Property>
		<Property name="Attributes">
			<Property value="TkSceneNodeAttributeData.xml">
			<Property name="Name" value="SCENEGRAPH" />
			<Property name="AltID" value="" />
			<Property name="Value" value="MODELS\RGO\MECH_SUIT_PRES.SCENE.MBIN" />
			</Property>
		</Property>
		<Property name="Children" />
		</Property>
]]
RESIZABLESENTINELMECH = [[
 
	      <Property value="TkSceneNodeData.xml">
      <Property name="Name" value="RESIZEDSENTINELMECH" />
      <Property name="NameHash" value="1952019589" />
      <Property name="Type" value="REFERENCE" />
      <Property name="Transform" value="TkTransformData.xml">
        <Property name="TransX" value="0" />
        <Property name="TransY" value="0" />
        <Property name="TransZ" value="0" />
        <Property name="RotX" value="0" />
        <Property name="RotY" value="0" />
        <Property name="RotZ" value="0" />
        <Property name="ScaleX" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
        <Property name="ScaleY" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
        <Property name="ScaleZ" value="]]..MECHS_SIZE_MULTIPLIER..[[" />
      </Property>

    <Property name="Attributes">
			<Property value="TkSceneNodeAttributeData.xml">
			<Property name="Name" value="SCENEGRAPH" />
			<Property name="AltID" value="" />
			<Property name="Value" value="MODELS\RGO\SENTMECH_SUIT_PRES.SCENE.MBIN" />
			</Property>
		</Property>
		<Property name="Children" />
		</Property>
]]

local replaceIMG = function (IMGNAME,DESTINATION)
	local IMG_CONTENT_TABLE =
	{

		["FILE_DESTINATION"] 		= DESTINATION,
		["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\]]..IMGNAME..[[.DDS]]

	}
table.insert(CUSTOM_CONTENT, IMG_CONTENT_TABLE)
end

local tileRework = function ()
	-- tiles rework
		if GENERATION_OVERHAUL == "ON" then





			NEW_TILES_TABLE =
			{
				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\COLOURS\BASETILETYPES.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\BASETILETYPES.EXML]]
			}
			table.insert(CUSTOM_CONTENT, NEW_TILES_TABLE)



			NEW_TILES_TABLE =
			{
				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\COLOURS\BASETILETYPES_LAVA.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\BASETILETYPES_LAVA.EXML]]
			}
			table.insert(CUSTOM_CONTENT, NEW_TILES_TABLE)

			NEW_TILES_TABLE =
			{
				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\LUSH\LUSHTILETYPES.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\LUSHTILETYPES.EXML]]
			}
			table.insert(CUSTOM_CONTENT, NEW_TILES_TABLE)

			NEW_TILES_TABLE =
			{
				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\FROZEN\FROZENTILETYPES.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\FROZENTILETYPES.EXML]]
			}
			table.insert(CUSTOM_CONTENT, NEW_TILES_TABLE)
		end

end	

if MENU_SPLASH_SCREEN ~= "OFF" and MENU_SPLASH_SCREEN ~= "" then
	replaceIMG (MENU_SPLASH_SCREEN,[[TEXTURES\UI\FRONTEND\BACKGROUNDS\STARTBG.DDS]])
end
if HELLO_GAMES_SPASH_SCREEN ~= "OFF" and HELLO_GAMES_SPASH_SCREEN ~= "" then
	replaceIMG (HELLO_GAMES_SPASH_SCREEN,[[TEXTURES\UI\LOADING\HGLOGOBLACKBGSMALL.DDS]])
end
if ENGINE_SPASH_SCREEN ~= "OFF" and ENGINE_SPASH_SCREEN ~= "" then
	replaceIMG(ENGINE_SPASH_SCREEN,[[TEXTURES\UI\LOADING\MIDDLEWAREPAIR.DDS]])
end
if NMS_TITLE ~= "OFF" and NMS_TITLE ~= "" then
	replaceIMG(NMS_TITLE,[[TEXTURES\UI\LOADING\NMSTITLE.DDS]])
end

if TRANSPARENT_OPTIONS_MENU == "ON" then
	--[=[TRANSPARENT_OPTIONS_CONTENT =
	{

		["FILE_DESTINATION"] 		= [[TEXTURES\UI\FRONTEND\BACKGROUNDS\OPTIONSBG.DDS]],
		["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\OPTIONSBGT.DDS]]		
	}
table.insert(CUSTOM_CONTENT, TRANSPARENT_OPTIONS_CONTENT)--]=]
end

CONSTRUCTS_WARNING = [[<!--This is a copy of the vanilla file in order to prevent the deprecated constructs spawner use -->]]
-- END BUILDER  -----------------------------------------------------------------------------




--
---------------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- ---------------------------------------------------------------- **FEATURES** -------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------
	if MASSIVE_FLEET == "ON" then
		addFeature
		(
			MASSIVE_FLEET,
			{
				{
					["MBIN_FILE_SOURCE"]  = {
						{
						"MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTERTINY_PROC.SCENE.MBIN",
						"MODELS\RGO\_FREIGHTERTINY_PROC.SCENE.MBIN"
						}
					}
				},
				{

					["MBIN_FILE_SOURCE"]  = "MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTSHIP01.SCENE.MBIN",
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2027018462"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTERSMALL_PROC\ENTITIES\SMALLFREIGHTER.ENTITY.MBIN]]},
							}
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
						"MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTERTINY_PROC.SCENE.MBIN",
						"MODELS\RGO\_FREIGHTERTINY_PROC.SCENE.MBIN"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = "MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTERTINY_PROC.SCENE.MBIN",
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = CONTENT_FREIGHTERS_SPAWNER
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"]  = "MODELS\COMMON\SPACECRAFT\INDUSTRIAL\FREIGHTERTINY_PROC.DESCRIPTOR.MBIN",
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "List",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = FREIGHTER_DESCRIPTOR
						},
					}

				},
				{
					["MBIN_FILE_SOURCE"]  = "MODELS\SPACE\POI\ATLASBEACON.SCENE.MBIN",
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = LARGE_FREIGHTERS
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"]  = "MODELS\SPACE\POI\ATLASBEACON.DESCRIPTOR.MBIN",
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "List",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = FREIGHTER_DESCRIPTOR
						},
					}

				},
			}
			
		)
		copyEXML
		(
			MASSIVE_FLEET,
			[[FREIGHTER_A.SCENE.EXML]],
			[[MODELS\RGO\FREIGHTER_A.SCENE.EXML]]
		)	
		copyEXML
		(
			MASSIVE_FLEET,
			[[FREIGHTSHIP01.SCENE.EXML]],
			[[MODELS\RGO\FREIGHTSHIP01.SCENE.EXML]]
		)
	end
	--
	if ULTRA_DIVERSE_SPACE_COLOURS == "ON" then
		ULTRA_DIVERSE_SPACE_COLOURS_EXML_ROW = ""
		ULTRA_DIVERSE_SPACE_COLOURS_EXML = ""

		for loop = 0 , 2000 do
			print("------ ADDED NEW SPACE COLOUR " .. loop)
			R_VALUE_REF = math.random(0,6)*0.1+math.random(0,9)*0.01+math.random(0,9)*0.001
			B_VALUE_REF = math.random(0,6)*0.1+math.random(0,9)*0.01+math.random(0,9)*0.001
			G_VALUE_REF = math.random(0,6)*0.1+math.random(0,9)*0.01+math.random(0,9)*0.001
			G_MID = G_VALUE_REF+math.random(1,3)*0.01
			R_MID = R_VALUE_REF+math.random(1,3)*0.01
			B_MID = B_VALUE_REF+math.random(1,3)*0.01
			G_BOT = G_MID+math.random(1,3)*0.11
			R_BOT = R_MID+math.random(1,3)*0.11
			B_BOT = B_MID+math.random(1,3)*0.11
			G_NEB1 = G_BOT+math.random(1,3)*0.021
			R_NEB1 = R_BOT+math.random(1,3)*0.021
			B_NEB1 = B_BOT+math.random(1,3)*0.021
			G_NEB2 = R_NEB1+math.random(1,3)*0.031
			R_NEB2 = B_NEB1+math.random(1,3)*0.031
			B_NEB2 = G_NEB2+math.random(1,3)*0.031
			G_NEB3 = R_NEB1-math.random(1,3)*0.041
			R_NEB3 = B_NEB1-math.random(1,3)*0.041
			B_NEB3 = G_NEB2-math.random(1,3)*0.041
			ULTRA_DIVERSE_SPACE_COLOURS_EXML_ROW =
			[[
				<Property value="GcSolarSystemSkyColourData.xml">
				<Property name="TopColour" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="MidColour" value="Colour.xml">
				  <Property name="R" value="]]..G_MID..[[" />
				  <Property name="G" value="]]..R_MID..[[" />
				  <Property name="B" value="]]..B_MID..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="BottomColour" value="Colour.xml">
				  <Property name="R" value="]]..G_BOT..[[" />
				  <Property name="G" value="]]..G_BOT..[[" />
				  <Property name="B" value="]]..G_BOT..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="TopColourPlanet" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="MidColourPlanet" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="BottomColourPlanet" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="CloudColour" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="LightColour" value="Colour.xml">
				  <Property name="R" value="]]..R_NEB1..[[" />
				  <Property name="G" value="]]..G_NEB1..[[" />
				  <Property name="B" value="]]..B_NEB1..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="NebulaColour1" value="Colour.xml">
				  <Property name="R" value="]]..R_NEB1..[[" />
				  <Property name="G" value="]]..G_NEB1..[[" />
				  <Property name="B" value="]]..B_NEB1..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="NebulaColour2" value="Colour.xml">
				  <Property name="R" value="]]..R_NEB2..[[" />
				  <Property name="G" value="]]..G_NEB2..[[" />
				  <Property name="B" value="]]..B_NEB2..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="NebulaColour3" value="Colour.xml">
				  <Property name="R" value="]]..R_NEB3..[[" />
				  <Property name="G" value="]]..G_NEB3..[[" />
				  <Property name="B" value="]]..B_NEB3..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="FogColour" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
				<Property name="FogColour2" value="Colour.xml">
				  <Property name="R" value="]]..R_VALUE_REF..[[" />
				  <Property name="G" value="]]..G_VALUE_REF..[[" />
				  <Property name="B" value="]]..B_VALUE_REF..[[" />
				  <Property name="A" value="1" />
				</Property>
			  </Property>

			]]
			ULTRA_DIVERSE_SPACE_COLOURS_EXML = ULTRA_DIVERSE_SPACE_COLOURS_EXML .. ULTRA_DIVERSE_SPACE_COLOURS_EXML_ROW
		end

		ULTRA_DIVERSE_SPACE_COLOURS_CHANGE_TABLE =
		{
			{
				["MBIN_FILE_SOURCE"]  = {
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACERARESKYCOLOURS.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACESKYCOLOURS.MBIN]]
				},
				["EXML_CHANGE_TABLE"] 	={
					{
						["PRECEDING_KEY_WORDS"] = {"Settings"},
						["ADD"] 	= ULTRA_DIVERSE_SPACE_COLOURS_EXML
					}
				}
			}
		}
		addContent(ULTRA_DIVERSE_SPACE_COLOURS_CHANGE_TABLE)

	end



	--------------------------------------------------------------------------
	-- BUSY SPACE TRAFFIC
	--------------------------------------------------------------------------
	addFeature
	(
		BUSY_SPACE_TRAFFIC,
		{

				{
					["MBIN_FILE_SOURCE"]  = [[GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["MATH_OPERATION"] = "+",
							["REPLACE_TYPE"] = "ALL",
							["VALUE_CHANGE_TABLE"] =
							{
								{"Freighter","100"},
								{"Royal","100"},
								{"Alien","100"},
								{"Sail","100"},
							}
						}
					}
				},
				
				{
					["MBIN_FILE_SOURCE"]  = [[METADATA\SIMULATION\SPACE\AISPACESHIPMANAGER.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Spaceships",
							["SECTION_ACTIVE"] = {1,2,3},
							["ADD"] = SENT_CIVIL
						}

					}
				},
				
								
				


		},
		DAY_ONE_MODE
	)



	-- PROCEDURAL CRASH SITES MISSIONS
	if PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION == "ON" then
		
	
	DERELIC_CRASHSITE = readTemplate("DERELIC_CRASHSITE")
	addFeature
	(
		PROCEDURAL_SPACE_CRASHSITE_FOR_SCAVENGING_MISSION,
		{
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\SPACE\POI\DUNGEON.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1},
						["ADD"] = DERELIC_CRASHSITE
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  =
				{
					{
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRASHEDFREIGHTER\CRASHEDFREIGHTER.DESCRIPTOR.MBIN]],
						[[MODELS\SPACE\POI\DUNGEON.DESCRIPTOR.MBIN]]
					}
				},
			}
		}
	)
	end
	--------------------------------------------------------------------
	-- REDMAS SPACESHIPS GENERATION


	-- fighters new PARTS
	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS,
		{
			--[=====[
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\DRONE\DRONESHIP.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"]=
					{
						{
							["SECTION_ACTIVE"] = {1},
							["SPECIAL_KEY_WORDS"] = {"Name","Ship","Name","MATERIAL"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"Value",[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\HULL\HULLB\DROPSHIP_MAT.MATERIAL.MBIN]]}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Ship","Name","ATTACHMENT"},
							["REMOVE"] = "SECTION"
						},

					}
				},

				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\DRONE\DRONESHIP.SCENE.MBIN]],
							[[MODELS\RGO\WINGSE3.SCENE.MBIN]],
							"REMOVE"
						}
					}
				},
				--]=====]
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_C\ENGINEC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","SpinEngine1"},
							["VALUE_CHANGE_TABLE"] = {
								--{"TransX","0"},
								--{"TransY","1.642135"},
								--{"TransZ","-2.26289"},
								--{"RotX","0"},
								--{"RotY","0"},
								--{"RotZ","0"},
								--{"ScaleX","1"},
								--{"ScaleY","1"},
								{"ScaleZ","1.5"},
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","EngineParts"},
							["INTEGER_TO_FLOAT"] = "FORCE",
							["VALUE_CHANGE_TABLE"] = {
								--{"TransX","0"},
								--{"TransY","0"},
								--{"TransZ","0"},
								--{"RotX","0"},
								--{"RotY","0"},
								--{"RotZ","0"},
								--{"ScaleX","1"},
								--{"ScaleY","1"},
								{"ScaleZ","1.5"},
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","Stage2"},
							["VALUE_CHANGE_TABLE"] = {
								--{"TransX","0"},
								--{"TransY","1.641415"},
								--{"TransZ","-2.419677"},
								--{"RotX","0"},
								--{"RotY","180"},
								--{"RotZ","0"},
								{"ScaleX","1.82"},
								{"ScaleY","1.82"},
								{"ScaleZ","2"},
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","Stage2","Name","C1"},
							["VALUE_CHANGE_TABLE"] = {
								{"ScaleX","1.314815"},
								{"ScaleY","1.314815"},
								{"ScaleZ","1.314815"},
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_C\ENGINEC.SCENE.MBIN]],
							[[MODELS\RGO\ENGINEC.SCENE.MBIN]],
						}
					}
				},
								{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEA\COCKPITANOSEA.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\COCKPITANOSEAW.DESCRIPTOR.MBIN]],
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEA\COCKPITANOSEA.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITANOSEAW.SCENE.MBIN]],
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\COCKPITANOSEAW.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] = MOUSTACHE,
						}
					}
				},

				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\TURBINEAA.SCENE.MBIN]],
							[[MODELS\RGO\_TURBINEAA.SCENE.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\TURBINEAA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = TURBINEAAF,
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\TURBINEAA.SCENE.MBIN]],
							[[MODELS\RGO\TURBINEAAFR.SCENE.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\TURBINEAA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					 {
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_Acc_None"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"RotZ","90"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_Acc_ABIG"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"RotZ","90"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_Acc_ASMALL"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"RotZ","90"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_Acc_ASMALL2"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"RotZ","90"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_Acc_AWINDY"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"RotZ","90"}
							}
						}


					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\TURBINEAA.SCENE.MBIN]],
							[[MODELS\RGO\TURBINEAAFL.SCENE.MBIN]],
							"REMOVE"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
							[[MODELS\RGO\_ACCA.SCENE.MBIN]]
						}
					}
				},
				-- SMALL
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Contrail1"},
							["REMOVE"] = "SECTION"
						},
						{

							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.2"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.2"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.2"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD3"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.2"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},

					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCASMALL.SCENE.MBIN]]
						}
					}
				},
				-- BIG
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.51"},
								{"TransZ", "-0.5"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "1.5"},
								{"ScaleZ", "1"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.51"},
								{"TransZ", "-0.5"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "1.5"},
								{"ScaleZ", "1"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.51"},
								{"TransZ", "-0.5"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "1.5"},
								{"ScaleZ", "1"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD3"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.51"},
								{"TransZ", "-0.5"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "1.5"},
								{"ScaleZ", "1"}
							}
						},
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCABIG.SCENE.MBIN]]
						}
					}
				},
				-- WINDY
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {


						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.5"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.5"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.5"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD3"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "0"},
								{"TransY", "-0.5"},
								{"TransZ", "-0.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "0"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ACCESSORIES\ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCAWINDY.SCENE.MBIN]],
							"REMOVE"
						}
					}
				},
				--  2x
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\RGO\_ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCAx2.SCENE.MBIN]],
						}
					},
					["EXML_CHANGE_TABLE"] = {
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
								["SECTION_ACTIVE"] = {1},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.2"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
								["SECTION_ACTIVE"] = {1},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.2"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
								["SECTION_ACTIVE"] = {1},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.2"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD3"},
								["SECTION_ACTIVE"] = {1},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.2"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = ACCAx2,
						}
					}
				},
				-- small 2x
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\RGO\_ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCASMALLx2.SCENE.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\RGO\ACCASMALLx2.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] = {
												{
							["INTEGER_TO_FLOAT"] = "FORCE",
								["SECTION_ACTIVE"] = {1},
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.5"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
								["SECTION_ACTIVE"] = {1},
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.5"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
								["SECTION_ACTIVE"] = {1},
							["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.5"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
								["SECTION_ACTIVE"] = {1},
							["VALUE_CHANGE_TABLE"] =
							{
								{"TransX", "-0.51"},
								{"TransY", "-0.5"},
								{"TransZ", "-1.51"},
								{"RotX", "0"},
								{"RotY", "0"},
								{"RotZ", "50"},
								{"ScaleX", "1"},
								{"ScaleY", "0.5"},
								{"ScaleZ", "2"}
							}
						},

						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = ACCASMALLx2,
						}


					}
				},
				-- windy 2x
				 {
					["MBIN_FILE_SOURCE"]  = {
						{
							[[MODELS\RGO\_ACCA.SCENE.MBIN]],
							[[MODELS\RGO\ACCAWINDYx2.SCENE.MBIN]],

						},
						["EXML_CHANGE_TABLE"] =
						{
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
									["SECTION_ACTIVE"] = {1},
								["SPECIAL_KEY_WORDS"] = {"Name","AccALOD0"},
								["VALUE_CHANGE_TABLE"] =
								{
									{"TransX", "-0.51"},
									{"TransY", "-0.5"},
									{"TransZ", "-0.81"},
									{"RotX", "0"},
									{"RotY", "0"},
									{"RotZ", "50"},
									{"ScaleX", "1"},
									{"ScaleY", "0.5"},
									{"ScaleZ", "2"}
								}
							},
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
									["SECTION_ACTIVE"] = {1},
								["SPECIAL_KEY_WORDS"] = {"Name","AccALOD1"},
								["VALUE_CHANGE_TABLE"] =
								{
									{"TransX", "-0.51"},
									{"TransY", "-0.5"},
									{"TransZ", "-0.81"},
									{"RotX", "0"},
									{"RotY", "0"},
									{"RotZ", "50"},
									{"ScaleX", "1"},
									{"ScaleY", "0.5"},
									{"ScaleZ", "2"}
								}
							},
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
								["SPECIAL_KEY_WORDS"] = {"Name","AccALOD2"},
									["SECTION_ACTIVE"] = {1},
								["VALUE_CHANGE_TABLE"] =
								{
									{"TransX", "-0.51"},
									{"TransY", "-0.5"},
									{"TransZ", "-0.81"},
									{"RotX", "0"},
									{"RotY", "0"},
									{"RotZ", "50"},
									{"ScaleX", "1"},
									{"ScaleY", "0.5"},
									{"ScaleZ", "2"}
								}
							},
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
								["SPECIAL_KEY_WORDS"] = {"Name","AccALOD3"},
								["SECTION_ACTIVE"] = {1},
								["VALUE_CHANGE_TABLE"] =
								{
									{"TransX", "-0.51"},
									{"TransY", "-0.5"},
									{"TransZ", "-0.81"},
									{"RotX", "0"},
									{"RotY", "0"},
									{"RotZ", "50"},
									{"ScaleX", "1"},
									{"ScaleY", "0.5"},
									{"ScaleZ", "2"}
								}
							},

							{
								["PRECEDING_KEY_WORDS"] = "Children",
								["SECTION_ACTIVE"] = {1},
								["ADD"] = ACCAWINDYx2,
							}

						}
					}
				},
				-- SAILSHIPS
				
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\SAILSHIP\SAILSHIP_PROC.SCENE.MBIN]],
							[[MODELS\RGO\SAIL_COCKPIT.SCENE.MBIN]],

						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\SAILSHIP\SAILSHIP_PROC.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\SAIL_COCKPIT.DESCRIPTOR.MBIN]],

						 }
					}
				},

				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\SAIL_COCKPIT.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","WingsShared"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_A"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_B"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_C"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_D"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_E"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Wings_F"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Tips_A"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Tips_B"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Tips_C"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Tips_D"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Tips_E"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Sails_A"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Sails_B"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","_Sails_C"},
							["REMOVE"] = "SECTION"

						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {1},
							["ADD"] = TURBINESAIL,
						}
					}
				},

				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\SAIL_COCKPIT.DESCRIPTOR.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"TypeId","_TIPS_"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"TypeId","_WINGS_"},
							["REMOVE"] = "SECTION"

						},
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"TypeId","_SAILS_"},
							["REMOVE"] = "SECTION"

						}
					}
				},


				{
					["MBIN_FILE_SOURCE"] 	=
					{
						{
							[[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\CANOPY\CANOPYA\CANOPYA.SCENE.MBIN]],
							[[MODELS\RGO\_CANOPYA.SCENE.MBIN]],

						 }
					}
				},

				{
					["MBIN_FILE_SOURCE"] 	=
					{
						{
							[[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\CANOPY\CANOPYA\CANOPYA.SCENE.MBIN]],
							[[MODELS\RGO\BALL_COCKPIT.SCENE.MBIN]],

						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\_CANOPYA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","CanopyA","Name","CockpitPos"},
							["VALUE_CHANGE_TABLE"] = {{"TransY","0.5"}}
						}
					}
				},

				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\BALL_COCKPIT.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","CanopyA"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = CANOPYA
						}
					}
				},

				{
					["MBIN_FILE_SOURCE"] 	=
					{
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F\WINGS_F.SCENE.MBIN]],
							[[MODELS\RGO\_WINGS_F.SCENE.MBIN]],
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	=
					{
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F\WINGS_F.SCENE.MBIN]],
							[[MODELS\RGO\WINGS_FX.SCENE.MBIN]],
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	=
					{
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F\WINGS_F.SCENE.MBIN]],
							[[MODELS\RGO\WINGS_X.SCENE.MBIN]],
						}
					}
				},

				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\_WINGS_F.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_C","Name","SubWings_C"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"ScaleZ", "2"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_C","Name","SubWingsCRight"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"ScaleZ", "2"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_D","Name","SubWings_D"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"ScaleZ", "2"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_D","Name","SubWingsDRight"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"ScaleZ", "2"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_E","Name","SubWings_E","Name","SCENEGRAPH"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"Value", "MODELS\RGO\TURBINEAAFR.SCENE.MBIN"}
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_E","Name","Turbine","Name","SCENEGRAPH"},
							["VALUE_CHANGE_TABLE"] =
							{
								{"Value", "MODELS\RGO\TURBINEAAFL.SCENE.MBIN"}
							}
						},
					}
				},
				--[=====[
				--]=====]
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\WINGS_FX.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Type",[[COLLISION]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD0]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD3]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD0]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD3]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[_SubWings_E]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Stage1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Stage2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Gun1Ref]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Gun1Ref1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_C"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_D"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = WINGSFX
						}

					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\WINGS_X.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Type",[[COLLISION]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD0]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsFLOD3]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD0]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[WingsF2LOD3]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[_SubWings_E]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Stage1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Stage2]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Gun1Ref]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name",[[Gun1Ref1]]},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_C"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","_SubWings_D"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = WINGSX
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPITA.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITA.SCENE.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\COCKPITA.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Data"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Inventory"},
							["REMOVE"] = "SECTION"
						},
												{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = COCKPIT_A_DATA
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPITA.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\COCKPITA.DESCRIPTOR.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPITB.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITB.SCENE.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\COCKPITB.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Data"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = COCKPIT_B_DATA
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPITB.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\COCKPITB.DESCRIPTOR.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_D\COCKPITD.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITD.SCENE.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\COCKPITD.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Data"},
							["REMOVE"] = "SECTION"
						},
												{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = COCKPIT_D_DATA
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_D\COCKPITD.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\COCKPITD.DESCRIPTOR.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_E\COCKPIT_E.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITE.SCENE.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\COCKPITE.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Data"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = COCKPIT_E_DATA
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_E\COCKPIT_E.DESCRIPTOR.MBIN]],
							[[MODELS\RGO\COCKPITE.DESCRIPTOR.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_F\COCKPTF.SCENE.MBIN]],
							[[MODELS\RGO\COCKPITF.SCENE.MBIN]],
						 }
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\COCKPITF.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","Data"},
							["REMOVE"] = "SECTION"
						},
												{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = COCKPIT_F_DATA
						}
					}

				},

--[=[
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\SAILSHIP\SAILSHIP_PROC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = SAILCOCKPIT_PROC
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\SAILSHIP\SAILSHIP_PROC.DESCRIPTOR.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"TypeId","_BODY_"},
							["REMOVE"] = "SECTION"

						},
						{
							["PRECEDING_KEY_WORDS"] = "List",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = SAILCOCKPIT_DESC
						}
					}
				},

--]=]
		},
		MULTIPLAYER_MODE
	)




	-- fighters & sailships proc gen
	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS,
		{

						{
							["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\FIGHTERS\FIGHTER_PROC.SCENE.MBIN]],
							["EXML_CHANGE_TABLE"] =
							{
								{
									["REPLACE_TYPE"] = "ALL",
									["SPECIAL_KEY_WORDS"] = {"Name","ProcRoot_StarShip"},
									["REMOVE"] = "SECTION"

								},
								{
									["PRECEDING_KEY_WORDS"] = "Children",
									["SECTION_ACTIVE"] = {0,1},
									["ADD"] = FIGHTER_PROC
								}
							}
						},
					
						
		},
		MULTIPLAYER_MODE
	)
	
		copyEXML
		(
			ADDITIONAL_VARIATIONS_FOR_FIGHTERS_SPACESHIPS,
			[[FIGHTER_PROC.DESCRIPTOR.EXML]],
			[[MODELS\COMMON\SPACECRAFT\FIGHTERS\FIGHTER_PROC.DESCRIPTOR.EXML]]
		)
	-- new shuttle design
	addFeature
	(
		-- design tweaks
		ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS,
		{
			{
				["MBIN_FILE_SOURCE"]  =
				{
					[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITADOUBLE.SCENE.MBIN]],
					[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITASINGLE.SCENE.MBIN]]
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","CanopyA"},
						["VALUE_CHANGE_TABLE"] = {
							{"ScaleX","0.7"},
							{"ScaleY","0.7"},
							{"ScaleZ","0.7"},
							{"TransZ","-0.7"}
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = {
					[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLEBOX.SCENE.MBIN]],
					[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER.SCENE.MBIN]],
					[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLEBOX.SCENE.MBIN]]
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","Canopy"},
						["VALUE_CHANGE_TABLE"] = {
							{"ScaleX","0.7"},
							{"ScaleY","0.7"},
							{"ScaleZ","0.7"},
							{"TransZ","-0.7"}
						}
					}

				}
			},
			{
				["MBIN_FILE_SOURCE"]  = {
					"MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLE.SCENE.MBIN",
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","polySurface2"},
						["VALUE_CHANGE_TABLE"] = {
							{"ScaleX","0.87"},
							{"ScaleY","0.87"},
							{"ScaleZ","0.87"},
							{"TransZ","-0.87"}
						}
					}

				}
			},
			{
				["MBIN_FILE_SOURCE"]  = {
					"MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER.SCENE.MBIN",
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","CanopyB"},
						["VALUE_CHANGE_TABLE"] = {
							{"ScaleX","0.7"},
							{"ScaleY","0.7"},
							{"ScaleZ","0.7"},
							{"TransZ","-0.7"}
						}
					}

				}
			}
		},
		MULTIPLAYER_MODE
	)
	-- new shuttle generation
	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_SHUTTLE_SPACESHIPS,
		{

				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\SHUTTLE\SHUTTLE_PROC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"Name","ProcRoot_StarShip"},
							["REMOVE"] = "SECTION"

						},
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = SHUTTLE_PROC
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\SHUTTLE\SHUTTLE_PROC.DESCRIPTOR.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["SPECIAL_KEY_WORDS"] = {"TypeId","_SHUTTLE_",},
							["REMOVE"] = "SECTION"

						},
						{
							["PRECEDING_KEY_WORDS"] = "List",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = SHUTTLE_DESC
						}
					}
				}

		},
		MULTIPLAYER_MODE
	)
	-- New design for scientifics ships
	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_SCIENTICS_SPACESHIPS,
		{
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSB\WINGSBRIGHT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingBRight"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleZ","2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSB\WINGSBLEFT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingBLeft"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleZ","2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSE\WINGERIGHT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingERight"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"RotX","-90"},
							{"ScaleX","2"},
							{"ScaleY","2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSE\WINGELEFT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingsELeft"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"RotX","-90"},
							{"ScaleX","2"},
							{"ScaleY","2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSD\WINGDRIGHT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingDRight"},
						["INTEGER_TO_FLOAT"] = "Force",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY","1.5"},
							{"ScaleZ","1.5"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\WINGS\WINGSD\WINGDLEFT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"]={"Name","WingDLeft"},
						["INTEGER_TO_FLOAT"] = "Force",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY","1.5"},
							{"ScaleZ","1.5"},
						}
					},
				}
			}
		},
		MULTIPLAYER_MODE
	)

	if ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS == "ON" then
		
-- New parts for Freighters
	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\GANTRYBCAPBRIDGEA.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\GANTRYBCAPBRIDGEA.SCENE.EXML]]
	)	
--[=[	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\GANTRYBCAPBRIDGEC.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\GANTRYBCAPBRIDGEC.SCENE.EXML]]
	)
	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\GANTRYBCAPBRIDGED.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\GANTRYBCAPBRIDGED.SCENE.EXML]]
	)
	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\GANTRYBCAPSPHERE.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\GANTRYBCAPSPHERE.SCENE.EXML]]
	)
	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\GANTRYBJOINTRING.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\GANTRYBJOINTRING.SCENE.EXML]]
	)
	copyEXML
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		[[INDUSTRIAL\LARGEGANTRYCAPB.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\GANTRY\LARGEGANTRYCAPB.SCENE.EXML]]
	)--]=]

	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_FREIGHTERS_SPACESHIPS,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\ACCESSORIES\ANTENAHUGE_A.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "AntenaHuge_A"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "0.51"},
							{"ScaleZ", "2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\ACCESSORIES\SAIL1.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "SailLOD0"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "SailLOD1"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "SailLOD2"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "SailLOD3"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\ACCESSORIES\VERTICALFIN.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "VerticalFinLOD0"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
							{"ScaleZ", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "VerticalFinLOD1"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
							{"ScaleZ", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "VerticalFinLOD2"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
							{"ScaleZ", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name", "VerticalFinLOD3"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleY", "2"},
							{"ScaleZ", "2"},
						}
					},
				}
			}
		},
		MULTIPLAYER_MODE
	)
	end
	-- additional parts & generation for royal sclass
	SCLASS_PROC = readTemplate("SCLASS_PROC")
	SCLASS_DESC = readTemplate("SCLASS_DESC")
	addFeature
	(
		ADDITIONAL_VARIATIONS_FOR_SCLASS_SPACESHIPS,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\S-CLASS\S-CLASS_PROC.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","ProcRoot_StarShip"},
						["REMOVE"] = "SECTION"

					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {0,1},
						["ADD"] = SCLASS_PROC
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\SPACECRAFT\S-CLASS\S-CLASS_PROC.DESCRIPTOR.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"TypeId","_SCLASSSHIP_"},
						["REMOVE"] = "SECTION"

					},
					{
						["PRECEDING_KEY_WORDS"] = "List",
						["SECTION_ACTIVE"] = {0,1},
						["ADD"] = SCLASS_DESC
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A\ENTITIES\WINGS_A.ENTITY.MBIN]],
						[[MODELS\RGO\ENTITIES\WINGS_A2.ENTITY.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A\ENTITIES\WINGS_A.ENTITY.MBIN]],
						[[MODELS\RGO\ENTITIES\WINGS_A3.ENTITY.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A\ENTITIES\WINGS_A.ENTITY.MBIN]],
						[[MODELS\RGO\ENTITIES\WINGS_A4.ENTITY.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= "MODELS\RGO\ENTITIES\WINGS_A2.ENTITY.MBIN",
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","TAKEOFF",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameEnd",	"145"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","LANDING",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameStart",	"36"},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= "MODELS\RGO\ENTITIES\WINGS_A3.ENTITY.MBIN",
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","TAKEOFF",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameEnd",	"161"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","LANDING",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameStart",	"20"},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= "MODELS\RGO\ENTITIES\WINGS_A4.ENTITY.MBIN",
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","TAKEOFF",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameEnd",	"131"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Anim","LANDING",},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"FrameStart",	"50"},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A.SCENE.MBIN]],
						[[MODELS\RGO\WINGS_A2.SCENE.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\WINGS_A2.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","ATTACHMENT",},
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Value",	[[MODELS\RGO\ENTITIES\WINGS_A2.ENTITY.MBIN]]},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A.SCENE.MBIN]],
						[[MODELS\RGO\WINGS_A3.SCENE.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\WINGS_A3.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","ATTACHMENT",},
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Value",	[[MODELS\RGO\ENTITIES\WINGS_A3.ENTITY.MBIN]]},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\S-CLASS\ROYALPARTS\WINGS\WINGS_A.SCENE.MBIN]],
						[[MODELS\RGO\WINGS_A4.SCENE.MBIN]],

					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\WINGS_A4.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","ATTACHMENT",},
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Value",	[[MODELS\RGO\ENTITIES\WINGS_A4.ENTITY.MBIN]]},
						}
					}
				}
			},
		},
		MULTIPLAYER_MODE
	)
	----------------------------------------------------------------------------------------------



if E3_FANTASY_PLANETS_COLORS_FEATURE == "ON" then

		-- planets fantasy colors
		FANTASY_COLOURS = readTemplate(COLORS_GENERATION_REWORK) -- "FANTASY_COLOURS" or "SCIFI_COLOURS" -- ( temporary way to change the colors style )
		FANTASY_FROZEN_COLOURS = readTemplate("FANTASY_FROZEN_COLOURS")
		
		tileRework()

		addFeature
		(
			E3_FANTASY_PLANETS_COLORS_FEATURE,
			{
				{
					["MBIN_FILE_SOURCE"] = {
						[[METADATA\SIMULATION\SOLARSYSTEM\COLOURS\BASECOLOURPALETTES.MBIN]],
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\LUSH\LUSHCOLOURPALETTES.MBIN]],
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\LUSH\LUSHHQCOLOURPALETTE.MBIN]],
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\LUSH\LUSHROOMACOLOURPALETTE.MBIN]],
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\LUSH\LUSHROOMBCOLOURPALETTE.MBIN]]
					},
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Grass","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Plant","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Leaf","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Wood","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Rock","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Stone","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Crystal","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Sand","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Dirt","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Metal","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Paint","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Plastic","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Fur","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Scale","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Feather","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Water","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Cloud","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Sky","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Space","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Underbelly","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Undercoat","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Snow","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"SkyHorizon","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
												{
							["PRECEDING_KEY_WORDS"] = "Palettes",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] = FANTASY_COLOURS
						},
					}
				},
				{
					["MBIN_FILE_SOURCE"] = {
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\FROZEN\FROZENCOLOURPALETTES.MBIN]],
						[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\FROZEN\FROZENHQCOLOURPALETTES.MBIN]]
					},
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Grass","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Plant","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Leaf","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Wood","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Rock","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Stone","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Crystal","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Sand","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Dirt","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Metal","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Paint","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Plastic","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Fur","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Scale","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Feather","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Water","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Cloud","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Sky","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Space","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Underbelly","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Undercoat","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Snow","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"SkyHorizon","GcPaletteData.xml"},
							["REMOVE"] = "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = "Palettes",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] = FANTASY_FROZEN_COLOURS
						},
					}
				}
			}
		)
end

		-- E3 CRYSTALS Assets
		if E3_FANTASY_CRYSTALS_ASSETS_FEATURE == "ON" then

			

			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_CAVE.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_CAVE.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_CAVE.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_CAVE.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_MOUNTAIN.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_MOUNTAIN.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_MOUNTAIN.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_MOUNTAIN.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			--[=[-
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_UNDERWATER.DESCRIPTOR]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_UNDERWATER.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_UNDERWATER.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_UNDERWATER.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			-]=]
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_CAVE.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_CAVE.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_CAVE.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_CAVE.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_MOUNTAIN.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_MOUNTAIN.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_MOUNTAIN.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_MOUNTAIN.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_UNDERWATER.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_UNDERWATER.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_UNDERWATER.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_UNDERWATER.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_FRAGMENT.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_MEDIUM.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_MEDIUM.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_CAVE.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_CAVE.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_CAVE.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_CAVE.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_MOUNTAIN.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_MOUNTAIN.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_MOUNTAIN.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_MOUNTAIN.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_UNDERWATER.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_UNDERWATER.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_UNDERWATER.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\CRYSTALS\SMALL\CRYSTAL_SMALL_UNDERWATER.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\BARREN.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\BARREN.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\SCORCHED.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\SCORCHED.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\RADIOACTIVE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\RADIOACTIVE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\LUSH.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\LUSH.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\FULL.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\FULL.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\FROZEN.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\FROZEN.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\DEAD.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\DEAD.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\CAVEFULL.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\CAVEFULL.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\CRYSTALS\TOXIC.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\SPAWNERS\CRYSTALS\TOXIC.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)

		end


		-- E3 DEPOSITS ASSETS
		if E3_FANTASY_DEPOTS_ASSETS_FEATURE == "ON" then

			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\CONSTRUCT01.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\CONSTRUCT01.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--[=[
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\ALIENRING.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\ALIENRING.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--]=]
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\BAT.DESCRIPTOR.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\BAT.DESCRIPTOR.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\BAT.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\BAT.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\CONSTRUCT01.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\CONSTRUCT01.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			--
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\MONOLITH.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\MONOLITH.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
		addFeature
		(
			E3_FANTASY_DEPOTS_ASSETS_FEATURE,
			{


				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\DEPOTSCIENTIFIC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Children",
							["ADD"] 	= ALIENRING
						},			

					}
				},
					{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\DEPOTWARRIOR.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Children",
							["ADD"] 	= ALIENRING
						},			

					}
				},
					{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\DEPOT\DEPOTTRADER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Children",
							["ADD"] 	= ALIENRING
						},			

					}
				}
			}

		)

		end

		-- E3 BUILDINGS BEACONS
		if E3_FANTASY_BEACONS_ASSETS_FEATURE == "ON" then
		
		NEW_CONTENT =
		{

			["FILE_DESTINATION"] 		= [[MODELS\RGO\CONSTRUCT02.SCENE.EXML]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\DEPOTS\CONSTRUCT01.SCENE.EXML]]

		}
		table.insert(CUSTOM_CONTENT, NEW_CONTENT)

		BEACON = [[
      <Property value="TkSceneNodeData.xml">
      <Property name="Name" value="RefPortal" />
      <Property name="NameHash" value="1182013967" />
      <Property name="Type" value="REFERENCE" />
      <Property name="Transform" value="TkTransformData.xml">
        <Property name="TransX" value="60" />
        <Property name="TransY" value="-5" />
        <Property name="TransZ" value="20" />
        <Property name="RotX" value="0" />
        <Property name="RotY" value="0" />
        <Property name="RotZ" value="0" />
        <Property name="ScaleX" value="1.62" />
        <Property name="ScaleY" value="1.62" />
        <Property name="ScaleZ" value="1.62" />
      </Property>
      <Property name="Attributes">
        <Property value="TkSceneNodeAttributeData.xml">
          <Property name="Name" value="SCENEGRAPH" />
          <Property name="AltID" value="" />
          <Property name="Value" value="MODELS\RGO\CONSTRUCT02.SCENE.MBIN" />
        </Property>
      </Property>
      <Property name="Children" />
    </Property>
		]]

		addFeature
		(
			E3_FANTASY_BEACONS_ASSETS_FEATURE,
			{


				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BEACONS\BEACON.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Children",
							["ADD"] 	= BEACON
						},			

					}
				}
			}

		)


		end

		-- E3 RUINS
		if REDMAS_RUINS_FEATURES == "ON" then
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\RUINS\__FAKEPROCRUINS.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\RUINS\__FAKEPROCRUINS.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\RUINS\_PROCRUINS.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\RUINS\_PROCRUINS.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
			NEW_CONTENT =
			{

				["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\RUINS\PROCRUINS.SCENE.EXML]],
				["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\RUINS\PROCRUINS.SCENE.EXML]]

			}
			table.insert(CUSTOM_CONTENT, NEW_CONTENT)
			--
			--
		end




	if E3_FANTASY_PORTALS_ASSETS_FEATURE == "ON" then
		-- portals assets
	PORTAL = readTemplate("PORTAL")
	COLLISION_STARGATE = readTemplate("COLLISION_STARGATE")
	addFeature
	(
		E3_FANTASY_PORTALS_ASSETS_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] =
				{
					{
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PORTAL\PORTAL.SCENE.MBIN]],
						[[MODELS\RGO\_PORTAL.SCENE.MBIN]],
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] =
				{
					{
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\MONUMENTS\STARGATEMAIN.SCENE.MBIN]],
						[[MODELS\RGO\_STARGATEMAIN.SCENE.MBIN]],"REMOVE"
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] =
				{
					{
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\MONUMENTS\STARGATETEMPLE.SCENE.MBIN]],
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PORTAL\PORTAL.SCENE.MBIN]],"REMOVE"
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PORTAL\PORTAL.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","pPlane1"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NameHash","3621565930"},
						["PRECEDING_KEY_WORDS"] = {"SCENEGRAPH"},
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Value",	[[MODELS\RGO\_STARGATEMAIN.SCENE.MBIN]]},
						}
					},

				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\_STARGATEMAIN.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["PRECEDING_KEY_WORDS"] = "Children",
						["ADD"] 	= PORTAL
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["PRECEDING_KEY_WORDS"] = "Children",
						["ADD"] 	= COLLISION_STARGATE
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","gate46"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"TransX","5.8"},
							{"TransY","5"},
							{"RotY","180"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","gate264"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"TransX","-5.8"},
							{"TransY","5"},
							{"RotY","0"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MainMono"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"TransY","-5"},
						}
					},

				}
			}
		}
	)
	end
	
	if E3_FANTASY_WORSTONES_ASSETS_FEATURE == "ON" then
		-- wordstones
		WORDSTONES_SPAWNER =
		{
	   	 	["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\LEVELONEOBJECTS\FULL.EXML]],
      		["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\LEVELONEOBJECTS\FULL.EXML]]
  		}
		table.insert(CUSTOM_CONTENT, WORDSTONES_SPAWNER)
		WORDSTONES_SPAWNER =
		{
	   		 ["FILE_DESTINATION"] 		= [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\LEVELONEOBJECTS\FULLSAFE.EXML]],
       		 ["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\LEVELONEOBJECTS\FULLSAFE.EXML]]
  		}
		table.insert(CUSTOM_CONTENT, WORDSTONES_SPAWNER)
		addFeature
		(
			E3_FANTASY_WORSTONES_ASSETS_FEATURE,
			{
				{
					["MBIN_FILE_SOURCE"] =
					{
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\STANDINGSTONE\STANDINGSTONEWARRIOR_RARE.SCENE.MBIN]],
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\WORDSTONE.SCENE.MBIN]],"REMOVE"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\WORDSTONE.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1959231336"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\WORDSTONE\ENTITIES\WORDSTONE.ENTITY.MBIN]]},
							}
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\WORDSTONE\ENTITIES\WORDSTONE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"UseInteractCamera",	"False"},
								{"RepeatInteraction",	"True"},
							}
						},
					}
				},
				-- plaques
				{
					["MBIN_FILE_SOURCE"] =
					{
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\MONOLITH\MONOLITH.SCENE.MBIN]],
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\PLAQUE.SCENE.MBIN]]
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\PLAQUE.SCENE.MBIN]],
					["REPLACE_TYPE"] = "ALL",
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2969419012"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\PLAQUE\ENTITIES\PLAQUE.ENTITY.MBIN]]},
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","362111922"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\RUINPARTS\PLAQUE\ENTITIES\PLAQUE.ENTITY.MBIN]]},
							}
						}
					}
					
				},
			}
		)

	end





-- LARGE BUILDINGS TRADING POSTS
	addFeature
	(
		LARGE_BUILDINGS_TRADINGPOSTS_FEATURE,
		{


				{
					-- SCIENTIFIC
					["MBIN_FILE_SOURCE"]  = {
						{
							BUILDINGS_PATH..[[LARGEBUILDINGS\LARGEBUILDING_PROC.DESCRIPTOR.MBIN]],
							BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTSCIENTIFIC.DESCRIPTOR.MBIN]]
						}
					},
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_BUILDING_KOR"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_LAYOUT_KOR"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTSCIENTIFIC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"Children"},
							["SECTION_ACTIVE"] = 1,
							["ADD"] 	= VYK_TOWER
						}
					}
				},
				-- TRADER
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							BUILDINGS_PATH..[[LARGEBUILDINGS\LARGEBUILDING_PROC.DESCRIPTOR.MBIN]],
							BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTTRADER.DESCRIPTOR.MBIN]]
						}
					},
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_BUILDING_VYK"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_LAYOUT_VYK"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTTRADER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"Children"},
							["SECTION_ACTIVE"] = 1,
							["ADD"] 	= KORVAX_TOWER
						}
					}
				},
				-- WARRIOR
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							BUILDINGS_PATH..[[LARGEBUILDINGS\LARGEBUILDING_PROC.DESCRIPTOR.MBIN]],
							BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTWARRIOR.DESCRIPTOR.MBIN]],
							"REMOVE"
						}
					},
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_BUILDING_VYK"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Id","_LAYOUT_VYK"},
							["REPLACE_TYPE"] = "ALL",
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = BUILDINGS_PATH..[[TRADINGPOST\TRADINGPOSTWARRIOR.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"Children"},
							["SECTION_ACTIVE"] = 1,
							["ADD"] 	= KORVAX_TOWER
						}
					}
				},

		}
	)
	
-- freighter bridge rework

if FREIGHTER_BRIDGE_REWORK == "ON" then
	copyEXML
	(
		'ON',
		[[BRIDGE.SCENE.EXML]],
		[[MODELS\COMMON\SPACECRAFT\COMMONPARTS\HANGARINTERIORPARTS\BRIDGE.SCENE.EXML]]
	)
end

--vanilla Debug 
if REDMAS_CAPE_FIX == "ON"
then
addFeature
(
	ONFOOT_CONTROLS_REVISON_FEATURE,
	{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\PLAYER\PLAYERCHARACTER\PLAYERCHARACTER\ENTITIES\PLAYERCHARACTER.ENTITY.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						['REPLACE_TYPE'] = "ALL",
						["SECTION_ACTIVE"] = {0,1,2,3,4},
						["VALUE_CHANGE_TABLE"] =
						{
							{"StandardGravityScale", "0"},
							{"ApplyGameWind", "0"},
							{"AirSpeedFromMovementSpeedScale", "0"},
						}
					}
				}
			}

	}
)
end

if HQ_SPACESTATIONS == "ON"
then
	copyEXML(
		HQ_SPACESTATIONS,
		[[SPACESTATIONTYPEB.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATION.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[SPACESTATIONTYPEB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATION.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\ORANGEGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\ORANGEGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\\ARMA\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\\ARMA\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\LIGHTCARD1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\LIGHTCARD1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\\ARMA\STATIONLARGETILE1_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\STATIONLARGETILE1_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\COLLISION_MAT4.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\COLLISION_MAT4.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\LIGHTCARD1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\LIGHTCARD1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\COLLISIONMAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\COLLISIONMAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\SPACESTATIONTYPEB.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATIONTYPEB.GEOMETRY.MBIN.PC]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\SPACESTATIONTYPEB.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATIONTYPEB.GEOMETRY.DATA.MBIN.PC]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\COLLISIONMAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\COLLISIONMAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\GLOW_MAT4.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\GLOW_MAT4.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\REDBLINKSCROLL_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\REDBLINKSCROLL_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\GLOW_MAT4.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\GLOW_MAT4.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\REDBLINKSCROLL_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\REDBLINKSCROLL_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE\SPACESTATION_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE\SPACESTATION_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\ORANGEGLOWFADE_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\ORANGEGLOWFADE_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOW_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOW_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\LIGHTCARD1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\LIGHTCARD1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\MESHDECAL_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\MESHDECAL_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\TRIMLIGHTS_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT\TRIMLIGHTS_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\COLLISIONMAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\COLLISIONMAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\GLOW_MAT2.MATERIAL.EXML]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\COLLISIONMAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\COLLISIONMAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\COLLISIONMAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\COLLISIONMAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\MESHDECAL_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\MESHDECAL_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\ORANGEGLOWFADE_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\ORANGEGLOWFADE_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\ORANGEGLOWFADE_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\ORANGEGLOWFADE_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\GLOW_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\GLOW_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SHARED\ENTITIES\PARTLODDATA.ENTITY.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SHARED\ENTITIES\PARTLODDATA.ENTITY.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SHARED\ENTITIES\PARTLODONLY.ENTITY.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SHARED\ENTITIES\PARTLODONLY.ENTITY.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\GLOW_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\GLOW_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\GLOW_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\GLOW_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\LIGHTCARD1_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\LIGHTCARD1_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\REDGLOW_MAT1.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\REDGLOW_MAT1.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\LIGHTCARD1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\LIGHTCARD1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\MESHDECAL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\MESHDECAL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\REDBLINKSCROLL_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\REDBLINKSCROLL_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\STATIONLARGETILE1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\STATIONLARGETILE1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\LIGHTCARD1_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\LIGHTCARD1_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)

	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\GLOW_MAT2.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\GLOW_MAT2.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\GLOWPRIMARY_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\GLOWPRIMARY_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\MISTLIGHTFADE_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\MISTLIGHTFADE_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\REDGLOW_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\REDGLOW_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\STATIONLARGETILE1ALT_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\TRIMLIGHTS_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING\TRIMLIGHTS_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.SCENE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.DESCRIPTOR.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.SCENE.EXML]]
	)

	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.SCENE.EXML]]
	)

	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.DESCRIPTOR.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.DESCRIPTOR.EXML]]
	)

	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.SCENE.EXML]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.SCENE.EXML]]
	)

	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.GEOMETRY.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.GEOMETRY.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.GEOMETRY.MBIN.PC]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSA.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\AERIALSB.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMA.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ARMB.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASP.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\CLASPTRI.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISK.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISK.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\DISKPARTIAL.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\ENTRANCE.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXHAUST.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCORE.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\EXTCOREOCT.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOT.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\FOOTSTUB.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONA.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONB.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSFRONT.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSHALF.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRING.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PANELSECTIONSRINGQUAD.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\PRISM.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\SPHERE.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\STORAGE.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TOWER.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TRIANGLEBASE.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.GEOMETRY.DATA.MBIN.PC]],
		[[MODELS\SPACE\SPACESTATION\MODULARPARTSTYPEB\EXTERIOR\TUNNELOPENING.GEOMETRY.DATA.MBIN.PC]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\SPACESTATIONTYPEB\COLLISION_MAT3.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATIONTYPEB\COLLISION_MAT3.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\SPACESTATIONTYPEB\POMSHEET_MAT.MATERIAL.EXML]],
		[[MODELS\SPACE\SPACESTATION\SPACESTATIONTYPEB\POMSHEET_MAT.MATERIAL.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.ACCENTPANELS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.ACCENTPANELS.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.ALTPANELS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.ALTPANELS.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.BASE.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.BASE.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.BASE.MASKS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.BASE.MASKS.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.BASE.NORMAL.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.BASE.NORMAL.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.BASE.PARALLAX.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.BASE.PARALLAX.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.PAINTED.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.PAINTED.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.STRIP.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.STRIP.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1.TEXTURE.EXML]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1.TEXTURE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.BASE.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.BASE.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.BASE.MASKS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.BASE.MASKS.DDS]]
	)
		copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.BASE.NORMAL.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.BASE.NORMAL.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.BASE.PARALLAX.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.BASE.PARALLAX.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.COLPANELS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.COLPANELS.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.PAINTED.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.PAINTED.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.STRIP.1.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.STRIP.1.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.STRIP.2.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.STRIP.2.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.STRIP.3.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.STRIP.3.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.STRIP.4.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.STRIP.4.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.STRIP.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.STRIP.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\LARGETILING1ALT.TEXTURE.EXML]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\LARGETILING1ALT.TEXTURE.EXML]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\TRIM1.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\TRIM1.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\TRIM1.MASKS.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\TRIM1.MASKS.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\TRIM1.NORMAL.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\TRIM1.NORMAL.DDS]]
	)
	copyEXML(
		HQ_SPACESTATIONS,
		[[STATION\TEXTURES\TYPEB\TRIM1.PARALLAX.DDS]],
		[[TEXTURES\SPACE\SPACESTATION\TYPEB\TRIM1.PARALLAX.DDS]]
	)
end




-- CAMERA OVERHAUL
if CENTERED_CAMERA_FEATURE == "ON"
then
addFeature
(
	CENTERED_CAMERA_FEATURE,
	{
		{
			["MBIN_FILE_SOURCE"]  = "GCCAMERAGLOBALS.GLOBAL.MBIN",
			["EXML_CHANGE_TABLE"] =
			{
				{
					["REPLACE_TYPE"] = "ALL",
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetX", "0"},
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","CHARCOMBAT",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetX", "0.51"},
					}
				},
			}
		}
	}
)
end


-- **CAMERA_OVERHAUL_FEATURES**
if CAMERA_OVERHAUL_FEATURE == "ON"
then
addFeature
(
	CAMERA_OVERHAUL_FEATURE,
	{
		{
			["MBIN_FILE_SOURCE"]  = "GCCAMERAGLOBALS.GLOBAL.MBIN",
			["EXML_CHANGE_TABLE"] =
			{
				
				{
					["SPECIAL_KEY_WORDS"] = {"Name","BUGGY",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"BackMinDistance", "3"},
						{"BackMaxDistance", "15"},
						{"UpMinDistance", "1"},
						{"UpMaxDistance", "1"}
					}
				},
--[=[
								{
					["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
					--	{"BackMinDistance", "2.5"},
					--	{"BackMaxDistance", "5"},
					--	{"UpMinDistance", "2.5"},
					--	{"UpMaxDistance", "5"},
					--	{"OffsetX", "2.5"},
					--	{"OffsetY", "2.5"},
					--	{"OffsetYAlt", "2.5"},
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","MECHJETPACK",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
					--	{"BackMinDistance", "2.5"},
					--	{"BackMaxDistance", "5"},
					--	{"UpMinDistance", "2.5"},
					--	{"UpMaxDistance", "5"},
					--	{"OffsetX", "2.5"},
					--	{"OffsetY", "2.5"},
					--	{"OffsetYAlt","2.5"},
					}
				},
				--]=]
				{
					["SPECIAL_KEY_WORDS"] = {"Name","HOVERCRAFT",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"BackMinDistance", "3"},
						{"BackMaxDistance", "15"},
						{"OffsetY", "3.8"},
						{"OffsetYAlt", "5"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SUBMARINE",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetY", "3.8"},
						{"OffsetZFlat", "-2.5"},
						{"BackMinDistance", "8"},
						{"BackMaxDistance", "18.7"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"BikeFollowCam","GcCameraFollowSettings.xml",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetY", "0.5"},
						{"OffsetYAlt", "0.5"},
						{"BackMinDistance", "3"},
						{"BackMaxDistance", "15"},
						{"UpMinDistance", "0"},
						{"UpMaxDistance", "0"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"WheeledBikeFollowCam","GcCameraFollowSettings.xml",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetY", "0.9"},
						{"OffsetYAlt", "2"},
						{"BackMinDistance", "5"},
						{"BackMaxDistance", "13"},
						--{"UpMinDistance", "0"}, -- to activate when/if vanilla is different
						--{"UpMaxDistance", "0"} -- to activate when/if vanilla is different
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"TruckFollowCam","GcCameraFollowSettings.xml",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["VALUE_CHANGE_TABLE"] =
					{
						{"OffsetY", "3.8"},
						--{"OffsetYAlt", "5"},-- to activate when/if vanilla is different
						{"BackMinDistance", "3"},
						{"BackMaxDistance", "15"},
						{"UpMinDistance", "0"}, -- to activate when/if vanilla is different
						{"UpMaxDistance", "0"} -- to activate when/if vanilla is different
					}
				},
				--- Spaceships
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SPACESHIP",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", LONG_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", LONG_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", LONG_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", LONG_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","DROPSHIP",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", LONG_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", LONG_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", LONG_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", LONG_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SHUTTLE",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", LONG_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", LONG_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", LONG_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", LONG_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","ROYAL",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", SMALL_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", SMALL_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", SMALL_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", SMALL_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SAILSHIP",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", LONG_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", LONG_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", LONG_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", LONG_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SCIENCE",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", SMALL_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", SMALL_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", SMALL_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", SMALL_SPACESHIPS_UP_MAX_DIST}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","ALIENSHIP",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", SMALL_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", SMALL_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", SMALL_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", SMALL_SPACESHIPS_UP_MAX_DIST}
					}
				},
								{
					["SPECIAL_KEY_WORDS"] = {"Name","ROBOTSHIP",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"LookStickLimitAngle", "115"},
						{"MinSpeed", "1"},
						{"SpeedRange", "100"},
						{"BackMinDistance", SMALL_SPACESHIPS_MIN_DIST},
						{"BackMaxDistance", SMALL_SPACESHIPS_MAX_DIST},
						{"UpMinDistance", SMALL_SPACESHIPS_UP_MIN_DIST},
						{"UpMaxDistance", SMALL_SPACESHIPS_UP_MAX_DIST}
					}
				},
				--- Warp
				{
					["SPECIAL_KEY_WORDS"] = {"WarpSettings","GcCameraWarpSettings.xml",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["VALUE_CHANGE_TABLE"] =
					{
						{"FocusPointDist", "99999999"},
						{"OffsetZStartBias", "100"}
					}
				},
				-- FOV
				{
					["VALUE_CHANGE_TABLE"] =
					{
						{"FirstPersonFoV", "85"},
						{"ThirdPersonFoV", "100"},
						{"ShipFoVMiniJump", "125"}
					}
				}
			}
		}
	}
)
end
-- CAMERA NO SHAKE
if	CAMERA_NO_SHAKE_FEATURE == "ON"
then
addFeature
(
	CAMERA_NO_SHAKE_FEATURE,
	{
		{
			["MBIN_FILE_SOURCE"]  = "GCCAMERAGLOBALS.GLOBAL.MBIN",
			["EXML_CHANGE_TABLE"] =
			{
				--- NO SHAKE
				{
					["PRECEDING_KEY_WORDS"] = "CameraShakeTable",
					["REPLACE_TYPE"] = "ALL",
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"TotalTime", "0.001"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","BIGPAINSHAKE",},
					["VALUE_CHANGE_TABLE"] =
					{
						{"TotalTime", "1"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","MEDIUMRUMBLE",},
					["VALUE_CHANGE_TABLE"] =
					{
						{"TotalTime", "5"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","SANDWORMEMERGE",},
					["VALUE_CHANGE_TABLE"] =
					{
						{"TotalTime", "0.5"}
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","WORMGRNDEMERGE",},
					["VALUE_CHANGE_TABLE"] =
					{
						{"TotalTime", "2.5"}
					}
				},
				{
					["VALUE_CHANGE_TABLE"] =
					{
						{"BobAmount", "0.006"}
					}
				}

			}
		}
	}
)
end
-- END CAMERA OVERHAUL
-- VISUAL OVERHAUL


if GENERATION_OVERHAUL == "ON" then
		----------------------------------------------------------------------

end

if VISUAL_OVERHAUL == "ON"
then
	if ASTEROIDS_REWORK == "ON"
	then
	addFeature
	(
		ASTEROIDS_REWORK,
		{
			{
				-- asteroids rework
					["MBIN_FILE_SOURCE"]  = "GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN",
					["EXML_CHANGE_TABLE"] =
					{
						-- Small ones
						{
							["PRECEDING_KEY_WORDS"] = "CommonAsteroidData",
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"Spacing", ASTEROID_SPACING_MULTIPLIER},
								{"Scale", ASTEROID_SCALE_MULTIPLIER},
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = {"CommonAsteroidData","ScaleVariance"},
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"x", ASTEROID_SCALE_MULTIPLIER},
								{"y", ASTEROID_SCALE_MULTIPLIER},
							}
						},
						-- BIG  ones
						{
							["PRECEDING_KEY_WORDS"] = "LargeAsteroidData",
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"Spacing", LARGE_ASTEROID_SPACING_MULTIPLIER},
								{"Scale", LARGE_ASTEROID_SCALE_MULTIPLIER},
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = {"LargeAsteroidData","ScaleVariance"},
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"x", LARGE_ASTEROID_SCALE_MULTIPLIER},
								{"y", LARGE_ASTEROID_SCALE_MULTIPLIER},
							}
						},
						-- rare ones
						{
							["PRECEDING_KEY_WORDS"] = "LargeAsteroidData",
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"Spacing", RARE_ASTEROID_SPACING_MULTIPLIER},
								{"Scale", RARE_ASTEROID_SCALE_MULTIPLIER},
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = {"LargeAsteroidData","ScaleVariance"},
							["INTEGER_TO_FLOAT"] = "FORCE",
							["MATH_OPERATION"] = "*",
							["VALUE_CHANGE_TABLE"] =
							{
								{"x", RARE_ASTEROID_SCALE_MULTIPLIER},
								{"y", RARE_ASTEROID_SCALE_MULTIPLIER},
							}
						},

					}
				}

		},
		DAY_ONE_MODE
	)
	end
	
	----------------------------------------------------------------------
	if SPACE_BLUR_FEATURE == "ON" then
	SPACEBLURVALUE = "0.5"
	else
		SPACEBLURVALUE ="0"
	end

	----------------------------------------------------------------------
	if SPACE_COLOURS_TYPE == "REALISTIC" then
		SPACE_COLOURS_CHANGE_TABLE =
		{
			{
				["MBIN_FILE_SOURCE"]  = {
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACERARESKYCOLOURS.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACESKYCOLOURS.MBIN]]
				},
				["EXML_CHANGE_TABLE"] = {
					{
						["SPECIAL_KEY_WORDS"] = {"TopColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"MidColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"BottomColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour1","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour2","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour3","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},----------------------------------------------------------------
{
						["SPECIAL_KEY_WORDS"] = {"TopColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "*",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.1"},
							{"B", "0.2"},
							{"G", "0.1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"MidColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "*",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.09"},
							{"B", "0.18"},
							{"G", "0.09"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"BottomColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "*",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.08"},
							{"B", "0.16"},
							{"G", "0.08"},
						}
					},
												{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour1","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.82"}
								}
							},
							{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour2","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.85"}
								}
							},
							{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour3","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.89"}
								}
							}
				}


			}
		}
		addContent(SPACE_COLOURS_CHANGE_TABLE)
	end
	if SPACE_COLOURS_TYPE == "FANTASY" then
	SPACE_COLOURS_CHANGE_TABLE =
	{
			{
				["MBIN_FILE_SOURCE"]  = {
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACERARESKYCOLOURS.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\SPACESKYCOLOURS.MBIN]]
				},
				["EXML_CHANGE_TABLE"] = {
					{
						["SPECIAL_KEY_WORDS"] = {"TopColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"MidColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"BottomColour","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour1","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour2","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"NebulaColour3","Colour.xml"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["MATH_OPERATION"] 	= "+",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"R", "0.0001"},
							{"B", "0.0001"},
							{"G", "0.0001"},
						}
					},----------------------------------------------------------------

												{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour1","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.02"}
								}
							},
							{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour2","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.5"}
								}
							},
							{
								["SPECIAL_KEY_WORDS"] = {"NebulaColour3","Colour.xml"},
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["MATH_OPERATION"] 	= "*",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"A", "0.9"}
								}
							}

											
				
				}


			}
		}
		addContent(SPACE_COLOURS_CHANGE_TABLE)
	end

	----------------------------------------------------------------------
	-- WATER REWORK
	if REDMAS_WATER_REFLECTIONS == "ON"
	then
	addFeature
	(
		REDMAS_WATER_REFLECTIONS,
		{
			{
				["MBIN_FILE_SOURCE"]  = "GCWATERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"WaveHeight", "0.5"},
							{"WaveFrequency", "0.21"},
							{"FresnelAlpha", "5E-05"},
							{"FoamFadeHeight", "0"},
							{"Foam1Scale", "8E-09"},
							{"Foam1Speed", "2E-05"},
							{"Foam2Scale", "5E-09"},
							{"Foam2Speed", "0.0004"},
							{"WaterStrength", "0.004"},
							{"A", "0"},
						}
					}
				}
			}
		}
	)
	end
	----------------------------------------------------------------------
	-- BLUR IN THE DISTANCE AND OTHER SKY EFFECTS
	if SPACE_BLUR_FEATURE == "ON"
	then
	addFeature
	(
		SPACE_BLUR_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[GCSKYGLOBALS.GLOBALS.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"RainbowDistance", "130"},
							{"SpaceAtmosphereThickness", "0.64"},
							{"NoAtmosphereFogStrength", "0.1"},
						}
					},
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"AtmosphereThickness", "0.63"},
							{"DepthOfField", SPACEBLURVALUE},
							{"FogMax", "0.73"},
							{"FogStrength", "0.06"},
							{"FogColourStrength", "20"},
							{"FogColourMax", "0.41"},
							{"FogHeight", "128"},
							--{"CloudRatio","0.005"}--> removes all clouds
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"PlanetFlightFog","GcFogProperties.xml"},
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"DepthOfField", SPACEBLURVALUE},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  =
				{
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\BLUEWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\BUBBLEWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\CLEARCOLD.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\DUSTWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\FIRESTORMWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\GRAVITYSTORMWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\GREENWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\HUMIDWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\LAVAWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\RADIOACTIVE.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\RAINWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\REDWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SCORCHED.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SNOWWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SWAMPWEATHER.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\TOXIC.MBIN]],
					[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\WEIRDWEATHER.MBIN]]
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"AtmosphereThickness", "0.63"},
							{"DepthOfField", "0.5"},
							{"FogMax", "0.73"},
							{"FogStrength", "0.06"},
							{"FogColourStrength", "20"},
							{"FogColourMax", "0.41"},
							{"FogHeight", "128"},
							--{"CloudRatio","0.005"}
						}
					}

				}
			}
		}
	)
	end

	-----------------------------------------------------------------------
	-- CONTRAILS REMOVER
	addFeature
	(
		SPEED_EFFECTS_REDUCER_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\EFFECTS\TRAILS\SPACECRAFT\CONTRAIL\CONTRAILTRAIL.TRAIL.MBIN]],
				["EXML_CHANGE_TABLE"] ={
					{
						["VALUE_CHANGE_TABLE"] 	= {
							{"Width", "0"},
						}
					}
				}
			}
		}
	)
	----------------------------------------------------------------------
	-- SPEEDLINES REDUCER
	addFeature
	(
		SPEED_EFFECTS_REDUCER_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  ={
					[[MODELS\EFFECTS\SPEEDLINES\MINIJUMPSPEEDLINES.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\MINIJUMPSPEEDLINES2.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\SPACE.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\SPACE2.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\SPACEBIG.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\MINIJUMPSPEEDLINES3.SPEEDLINE.MBIN]],
					[[MODELS\EFFECTS\SPEEDLINES\MINIJUMPSPEEDLINES4.SPEEDLINE.MBIN]],
				},
				["EXML_CHANGE_TABLE"] ={
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] 	= {
							{"Width", "0.21"},
						}
					}
				}
			}
		}
	)
	----------------------------------------------------------------------
	-- Metal Spaceships

	-- you can edit the textures that i ve chosen for the repaint here , in that block
	--FRESH_PAINT = [[MODELS\COMMON\SPACECRAFT\INDUSTRIAL\HULL\HULL_A\FREIGHTERPROC_MAT.MATERIAL.MBIN]]
	METAL_PAINT = [[MODELS\SPACE\NEXUS\NEXUSEXTERIOR\METALSHINY_MAT.MATERIAL.MBIN]]
	GOLD_PAINT = [[MODELS\SPACE\NEXUS\NEXUSEXTERIOR\GOLDMETAL_MAT.MATERIAL.MBIN]]
	--OLD_PAINT = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRASHEDFREIGHTER\CRASHEDFREIGHTER\CRASHEDFREIGHTER_MAT.MATERIAL.MBIN]]
	PLASTIC_PAINT = [[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\CANOPY\CANOPYB\CANOPYB\SCIENTIFIC_MAT.MATERIAL.MBIN]]
	--
	--
	-----------------------------------------------------------------------------------------------------------
	------------------------------------------------------------------------------------------------------------
	--------------- **SPACESHIPS_REPAINT**-------------------------------------------------------------------
	-- Change those values for fighters spaceships

	--dirty metal
	FIGHTERS_PAINT1 = METAL_PAINT -- "FRESH_PAINT"/ "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT2 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT3 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT4 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options

	if FIGHTERS_SPACESHIPS_REPAINT == "FULL" then
	-- Full Metal
	FIGHTERS_PAINT1 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT2 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT3 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	FIGHTERS_PAINT4 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	end
	-- Change those values for DROPSHIP ("Hauler") spaceships
	DROPSHIP_PAINT1 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	DROPSHIP_PAINT2 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	DROPSHIP_PAINT3 = GOLD_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	DROPSHIP_PAINT4 = METAL_PAINT -- "FRESH_PAINT" / "GOLD_PAINT" / "METAL_PAINT" / "OLD_PAINT" options
	-- Change those values for Shuttle spaceships
	SHUTTLE_PAINT = PLASTIC_PAINT
	-----------------------------------------------------------------------------------------------------------------------------------
	------------------------------------------------------------------------------------------------------------------------------------
	

	addFeature
	(
		"FIGHTERS_SPACESHIPS_REPAINT",
		{

				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPITA\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPITA\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPITB\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPITB\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPITB\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_D\COCKPITD\PRIMARY5.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_D\COCKPITD\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_D\COCKPITD\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_E\COCKPITE\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_E\COCKPITE\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_E\COCKPITE\PRIMARY6.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_F\COCKPITF\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_F\COCKPITF\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_F\COCKPITF\PRIMARY7.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_F\COCKPITF\PRIMARY6.MATERIAL.MBIN]],

						}
					}
				},
				---
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEA\COCKPITANOSEA\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEA\COCKPITANOSEA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEA\COCKPITANOSEA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEB\COCKPITANOSEB\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEB\COCKPITANOSEB\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEC\COCKPITANOSEC\TERTIARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEC\COCKPITANOSEC\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEC\COCKPITANOSEC\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEC\COCKPITANOSEC\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSED\COCKPITANOSED\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSED\COCKPITANOSED\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSED\COCKPITANOSED\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEE\COCKPITANOSEE\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEE\COCKPITANOSEE\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEE\COCKPITANOSEE\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITB_NOSEA\COCKPITBNOSEA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITB_NOSEA\COCKPITBNOSEA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				---
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_A\SUBWINGSA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_A\SUBWINGSA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_A\SUBWINGSA\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_B\SUBWINGSB\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_B\SUBWINGSB\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_B\SUBWINGSC\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_C\SUBWINGSC\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_C\SUBWINGSC\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_C\SUBWINGSC\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDLEFT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDLEFT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDLEFT\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDRIGHT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDRIGHT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_D\SUBWINGSDRIGHT\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				---
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A\WINGS_A\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A\WINGS_A\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_B\WINGSB\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_B\WINGSB\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_B\WINGSB\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_D\WINGSD\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E\WINGSE\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E\WINGSE\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E\WINGSE\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F\WINGS_F\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F\WINGS_F\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G\WINGSG\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G\WINGSG\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I\WINGSI\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I\WINGSI\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I\WINGSI\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_J\WINGSJ\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_K\WINGSK\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_K\WINGSK\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_B\ENGINEB\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_B\ENGINEB\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_B\ENGINEB\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_C\ENGINEC\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_C\ENGINEC\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_C\ENGINEC\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_D\ENGINED\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							FIGHTERS_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\FIGHTERS\ENGINE\ENGINE_D\ENGINED\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},


		}
	)
	
	addFeature
	(
		DROPSHIPS_SPACESHIPS_REPAINT,
		{

				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITA\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITB\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITB\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\COCKPIT\COCKPITB\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\CONTAINERS\BALLCONTAINER\BALLCONTAINER_L\TERTIARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\CONTAINERS\BALLCONTAINER\BALLCONTAINER_L\PRIMARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\CONTAINERS\BALLCONTAINER\BALLCONTAINER_L\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\CONTAINERS\BOXCONTAINER\BOXCONTAINER_L\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\CONTAINERS\BOXCONTAINER\BOXCONTAINER_L\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\HULL\HULLA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT1,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\HULL\HULLA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_LEFT\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_LEFT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_LEFT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_RIGHT\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_RIGHT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSA\SUBWINGSA_RIGHT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSB\SUBWINGSB_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSC\SUBWINGSC_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\SECONDARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\SECONDARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\PRIMARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_RIGHT\PRIMARY3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSD\SUBWINGSD_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSE\SUBWINGSE_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSF\SUBWINGSF_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_LEFT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSG\SUBWINGSG_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_LEFT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSH\SUBWINGSH_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_LEFT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_LEFT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_RIGHT\PRIMARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_RIGHT\SECONDARY2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT2,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\SUBWINGS\SUBWINGSI\SUBWINGSI_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_LEFT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSA\THRUSTERSA_RIGHT\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSB\THRUSTERSB_LEFT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSB\THRUSTERSB_LEFT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSB\THRUSTERSB_RIGHT\SECONDARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSB\THRUSTERSB_RIGHT\PRIMARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSC\THRUSTERSC_LEFT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSC\THRUSTERSC_LEFT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSC\THRUSTERSC_RIGHT\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSC\THRUSTERSC_RIGHT\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_L\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_L\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_L\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_L\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_R\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERS_R\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_L\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_L\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_L\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_L\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_R\TERTIARY1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_R\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT4,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_R\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_R\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSA\WINGSA\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSA\WINGSA\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSA\WINGSA\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSB\WINGSB\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSB\WINGSB\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSC\WINGSC\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSC\WINGSC\SECONDARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSD\WINGSD\PRIMARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSD\WINGSD\TERTIARY.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							DROPSHIP_PAINT3,
							[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\WINGS\WINGSD\WINGSD\TERTIARY3.MATERIAL.MBIN]],

						}
					}
				},

		}
	)

	addFeature
	(
		SHUTTLE_SPACESHIPS_REPAINT,
		{

				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYA\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYB\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYB\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYC\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYD\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYE\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYF\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYG\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYG\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYH\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYI\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYJ\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYK\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\ACCESSORIES\ACCESSORYK\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\CANOPY\CANOPYA\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\CANOPY\CANOPYB\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_A\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_B\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_C\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_D\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_E\SHUTTLE_MAT5.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_E\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_E\SHUTTLE_MAT10.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_E\SHUTTLE_MAT11.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITACCESSORIES\COCKPITACC_F\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITADOUBLE\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITASINGLE\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLEBOX\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER\SHUTTLE_MAT18.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER\SHUTTLE_MAT19.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBDOUBLECYLINDER\SHUTTLE_MAT20.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLE\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLEBOX\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER\SHUTTLE_MAT13.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER\SHUTTLE_MAT11.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER\SHUTTLE_MAT10.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\COCKPIT\COCKPITBSINGLECYLINDER\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\BOXDOUBLE\BOXHULL\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\BOXDOUBLE\BOXHULLEND\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\BOXHULL\BOXHULL\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\BOXHULL\BOXHULLEND\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULL\BOX\BOXPOD\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULL\CYLINDER\CYLINDERHULL\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULL\CYLINDER\CYLINDERHULLEND\SHUTTLEMAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULL\CYLINDER\CYLINDERHULLSTART\SHUTTLEMAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULLDOUBLE\LCYLINDERHULLDOUBLE\SHUTTLEMAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\HULL\PODSHULLDOUBLE\RCYLINDERHULLDOUBLE\SHUTTLEMAT.MATERIAL.MBIN]],

						}
					}
				},
				--
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\SUBWINGS\SUBWING_A\SUBWINGA_LEFT\SUBWINGA_LEFT_SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\SUBWINGS\SUBWING_A\SUBWINGA_RIGHT\SUBWINGA_LEFT_SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\SUBWINGS\SUBWING_B\SUBWINGB_L\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\SUBWINGS\SUBWING_B\SUBWINGB_R\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\SUBWINGS\SUBWING_C\SUBWINGC_L\WINGSL_L_SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\LTHRUSTERA\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\LTHRUSTERA\SHUTTLE_MAT2.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\LTHRUSTERA\SHUTTLE_MAT3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\LTHRUSTERA\SHUTTLE_MAT10.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\RTHRUSTERA\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\THRUSTER\THRUSTERA\THRUSTERA\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSA\WINGSA_LEFT\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSA\WINGSA_RIGHT\SHUTTLE_MAT9.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSB\WINGSBSTART_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSB\WINGSBSTART_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDCYLIND_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDCYLIND_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDEND_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDEND_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDFLAT_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDFLAT_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDSTART_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDSTART_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDSTARTROUND_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDSTARTROUND_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDVENT_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDVENT_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSD\WINGSDVENT_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSF\WINGSF_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSF\WINGSF_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSG\WINGSG_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSG\WINGSG_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSH\WINGSH_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSH\WINGSH_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSI\WINGSI_LEFT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSI\WINGSI_RIGHT\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSJ\WINGSJ_LEFT\SHUTTLE_MAT3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSJ\WINGSJ_LEFT\SHUTTLE_MAT4.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSJ\WINGSJ_LEFT\SHUTTLE_MAT5.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSJ\WINGSJ_LEFT\WINGSA_LEFT_SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSJ\WINGSJ_RIGHT\SHUTTLE_MAT3.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSK\WINGSK_L\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSK\WINGSK_R\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSL\WINGSL_L\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSL\WINGSL_R\SHUTTLE_MAT.MATERIAL.MBIN]],

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = {
						{
							SHUTTLE_PAINT,
							[[MODELS\COMMON\SPACECRAFT\SHUTTLE\WINGS\WINGSL\WINGSL_R\SHUTTLE_MAT1.MATERIAL.MBIN]],

						}
					}
				},

		}
	)
	----------------------------------------------------------
	addFeature
	(
		GAMEPLAY_OVERHAUL, -- not visual_overhaul, this is solving a confict in utopia paks in 3 splits version
		{
			{
				["MBIN_FILE_SOURCE"]  = "GCSPACESHIPGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"CameraPostWarpFov", "120"},
							{"MiniWarpLinesNum", "0"},
							{"ShakePowerScaler", "0.07"},
						}
					}
				}
			}
		},
		DAY_ONE_MODE
	)
	-- TRAILS
	if      SPACESHIPS_TRAILS_TYPE == "REALISTIC" then
	SPACESHIPS_TRAILS_CHANGE_TABLE =
	{

		{
			["MBIN_FILE_SOURCE"]  = [[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTTRAIL.TRAIL.MBIN]],
			["EXML_CHANGE_TABLE"] = {
				{
					["INTEGER_TO_FLOAT"] = "FORCE",
					["VALUE_CHANGE_TABLE"] 	= {
						{"Width", "1"},
					}
				}
			}
		},
		{
			["MBIN_FILE_SOURCE"]  = [[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTTRAIL.SCENE.MBIN]],
			["EXML_CHANGE_TABLE"] 	=
			{
				{
					["SPECIAL_KEY_WORDS"] = {"Name","COLOUR"},
					["REMOVE"] 	= "SECTION"
				}
			}

		},
		{
			["MBIN_FILE_SOURCE"]  = [[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTCYANTRAIL.SCENE.MBIN]],
			["EXML_CHANGE_TABLE"] 	={
				{
					["SPECIAL_KEY_WORDS"] = {"Name","COLOUR"},
					["REMOVE"] 	= "SECTION"
				}
			}

		},

	}
	addContent(SPACESHIPS_TRAILS_CHANGE_TABLE)
	end
	if  SPACESHIPS_TRAILS_TYPE == "E3" then
		SPACESHIPS_TRAILS_CHANGE_TABLE = {
			["MBIN_CHANGE_TABLE"] = {
				{
					["MBIN_FILE_SOURCE"]  =
					{
						[[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTTRAIL.SCENE.MBIN]],
						[[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTCYANTRAIL.SCENE.MBIN]]
					} ,
					["EXML_CHANGE_TABLE"] 	={
						{
							["SPECIAL_KEY_WORDS"] = {"Name","COLOUR"},
							["REMOVE"] 	= "SECTION"
						}
					}

				},
				{
					["MBIN_FILE_SOURCE"]  =
					{
						[[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTTRAIL.SCENE.MBIN]],
						[[MODELS\EFFECTS\TRAILS\SPACECRAFT\HOT\HOTCYANTRAIL.SCENE.MBIN]]
					} ,
					["EXML_CHANGE_TABLE"] 	={
						{
							["PRECEDING_KEY_WORDS"] = {"Children"},
							["ADD"] 	= E3TRAIL
						}
					}
				}
			}
		}
		table.insert(FEATURES_CHANGE_TABLE, SPACESHIPS_TRAILS_CHANGE_TABLE)
	end
	-- fix for weird vanilla artefacts
	--
	if FIX_FOR_VANILLA_TREES == "ON" then
	NEW_CONTENT =
		{

			["FILE_DESTINATION"] 		= [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.EXML]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\EXML\R2\DRACAENA.SCENE.EXML]]

		}
		table.insert(CUSTOM_CONTENT, NEW_CONTENT)
	--
	end
	-- FILTERS REWORK
	if FILTERS_SWAP_FEATURE == "ON" then
		FILTERS_CONTENT1 = {}
		FILTERS_CONTENT1 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\DEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT1)



		FILTERS_CONTENT2 = {}
		FILTERS_CONTENT2 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\AFDEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT2)
		FILTERS_CONTENT3 = {}
		FILTERS_CONTENT3 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\DEFAULTSTORM.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT3)
		FILTERS_CONTENT4 = {}
		FILTERS_CONTENT4 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\FROZENDEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT4)
		FILTERS_CONTENT5 = {}
		FILTERS_CONTENT5 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\RADIODEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT5)
		FILTERS_CONTENT6 = {}
		FILTERS_CONTENT6 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\SCORCHDEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT6)
		FILTERS_CONTENT7 = {}
		FILTERS_CONTENT7 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\SCORCHSTORM.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT7)
		FILTERS_CONTENT8 = {}
		FILTERS_CONTENT8 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\TOXICDEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\BRIGHT.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT8)
		FILTERS_CONTENT9 = {}
		FILTERS_CONTENT9 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\BARRENSTORM.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\E3.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT9)
		FILTERS_CONTENT10 = {}
		FILTERS_CONTENT10 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\BARRENDEFAULT.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\E3.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT10)
		FILTERS_CONTENT11 = {}
		FILTERS_CONTENT11 =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\NEXUS.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\CYBER.DDS]]

		}
		table.insert(CUSTOM_CONTENT, FILTERS_CONTENT11)
	end
	-- BINOC REWORK
	if BINOC_CLEAR == "ON" then
		BINOC_CONTENT = {}
		BINOC_CONTENT =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\BINOCULARS.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\CLEAN.DDS]]

		}
		table.insert(CUSTOM_CONTENT, BINOC_CONTENT)
	end
	if BINOC_SUN == "ON" then
		BINOC_CONTENT = {}
		BINOC_CONTENT =
		{

			["FILE_DESTINATION"] 		= [[TEXTURES\LUT\FILTERS\BINOCULARS.DDS]],
			["EXTERNAL_FILE_SOURCE"] 	= [[..\RGOG\IMAGES\FILTERS\SUNGLASS.DDS]]

		}
		table.insert(CUSTOM_CONTENT, BINOC_CONTENT)
	end
	--
end
-- END VISUAL OVERHAUL
-- GAMEPLAY OVERHAUL
if GAMEPLAY_OVERHAUL == "ON" then



	-- PLAYER
	addFeature
	(
		PLAYER_IS_WALKING_INSTEAD_OF_JOGGING_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] = "GCPLAYERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"GroundWalkSpeed", "2.5"},
							--{"GroundWalkSpeedTeleportHmd", "2.4"}, -- NEED to be tested in VR
						}
					},
				}
			},
		},
		DAY_ONE_MODE
	)
	addFeature
	(
		FASTER_WALK_WHILE_SHIELDING_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] = "GCPLAYERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"FrontShieldSpeedSlowdown", "1.5"},
						}
					},
				}
			},
		},
		DAY_ONE_MODE
	)
	addFeature
	(
		LONGER_STEALTH_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] = "GCPLAYERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"StealthDrainRate", "1.5"},
							{"StealthRechargeRate", "6"},
						}
					},
				}
			},
		},
		DAY_ONE_MODE
	)

	addFeature
	(
		ONFOOT_CONTROLS_REVISON_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] = "GCPLAYERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"JetpackUnderwaterFillRate", "10"},
							{"UnderwaterMaxSpeed", "6"},
							{"UnderwaterMaxJetpackSpeed", "12"},
							{"UnderwaterJetpackForce", "250"},
							{"BinocularRangePlanet", "10000"},
							{"MinBinocActiveTime", "0.06"},
							{"RocketBootsBoostForce", "128"},
							{"RocketBootsDriftForce", "60"},
							{"RocketBootsDriftForce", "60"},
							{"RocketBootsMaxDesiredHeight", "36"},
							{"RocketBootsBoostTankDrainSpeed", "0.006"},
							{"RocketBootsMaxSpeed", "40"},
							{"JetpackMinLevel", "-10.5"}, -- put 0 if you dont want the 'EMMERGENCY TANK' feature ( meant to give you time to see that you dont have fuel )
							{"JetpackMaxSpeed", "9"},
							{"JetpackMaxUpSpeed", "7"},
							{"JetpackFillRate", "15"},
							--{"JetpackFillRateHardMode", "5"},
							{"AnimWalkSpeed", "4.5"},
							{"AnimRunSpeed", "1"},
							{"AnimWalkToRunSpeed", "0.5"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = "GCCHARACTERGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"CharacterTurnSpeed", "8.5"},
							{"CharacterJetpackTurnSpeed", "18"},
							{"TimeAfterDeathRagdollIsEnabledForward", "0.0001"},
							{"TimeAfterDeathRagdollIsEnabledBackward", "0.00013"},
							{"TimeAfterDeathRagdollIsEnabledWhenBlocked", "0.02"},
							{"MinStickForIntoJogAnim", "2.25"},
							{"SmoothVelocitySpeed", "0.3"},
						}
					},
				}
			}
		},
		DAY_ONE_MODE
	)

	addFeature
	(
		CONTROLLED_FALL_ANIMATION_REPLACEMENT,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\PLAYER\PLAYERCHARACTER\PLAYERCHARACTER\ENTITIES\PLAYERCHARACTER.ENTITY.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Anim","0H_FALL_PANIC"},
						["SECTION_ACTIVE"] = {2},
						["VALUE_CHANGE_TABLE"] =
						{
							{"Filename", [[MODELS/COMMON/PLAYER/PLAYERCHARACTER/ANIMS/JETPACK/0H_JPACK_DOWN.ANIM.MBIN]]},
							{"FrameEnd", "0"}
						}
					}
				}
			}
		},
		DAY_ONE_MODE
	)

	-- VEHICLES
	addFeature
	(
		ADDITIONAL_EXOCRAFT_DRAGONFLY,
		{
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\TECH\VEHICLEGARAGEHOVER.SCENE.MBIN]],
						[[MODELS\RGO\VEHICLEGARAGEHOVER.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\VEHICLEGARAGEHOVER.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","TERRAINEDITBOX"},
						["REMOVE"] = "SECTION"
					}
				}

			},
			{
				["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\TRADINGPOST\PARTS\TRADINGPOST_COMMON.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] = DRAGONFLYGARAGE
					}

				}

			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\SAILSHIP\SAILSHIP_PROC.SCENE.MBIN]],
						[[MODELS\RGO\EXO_SAILSHIP_COCKPIT.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\EXO_SAILSHIP_COCKPIT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_RootJNT_"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Data"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","BodyShared"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_A"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_B"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_C"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_D"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_E"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Body_F"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WingsShared"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_A"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_B"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_C"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_D"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_E"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Wings_F"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Tips_A"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Tips_B"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Tips_C"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Tips_D"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Tips_E"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Sails_A"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Sails_B"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_Sails_C"},
						["REMOVE"] = "SECTION"

					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] =  DRAGONFLYCOCKPIT
					}

				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\HOVER\HOVERCRAFT.SCENE.MBIN]],
						[[MODELS\RGO\_HOVERCRAFT.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\HOVER\HOVERCRAFT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","COCKPITPOS"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage1"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage2"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"

					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] =  DRAGONFLYEXO
					}

				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\_HOVERCRAFT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","COCKPITPOS"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage1"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage2"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"

					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"

					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] =  _HOVERCRAFT
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\BIKE\BIKEPRES.SCENE.MBIN]],
						[[MODELS\RGO\DRAGONFLY_WHEELS.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	= [[MODELS\RGO\DRAGONFLY_WHEELS.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Lights"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage1"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage2"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"
					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] =  DRAGONFLY_WHEELS
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_R.SCENE.MBIN]],
						[[MODELS\RGO\EXO_THRUSTERSD_R.SCENE.MBIN]],
					},
				},
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\DROPSHIPS\THRUSTERS\THRUSTERSD\THRUSTERSD_L.SCENE.MBIN]],
						[[MODELS\RGO\EXO_THRUSTERSD_L.SCENE.MBIN]],
					},
				}
			},
		}
	)
	-- **VEHICULE_HANDLINGS**
	addFeature
	(
		EXOCRAFTS_CONTROLS_REVISON_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  = "GCVEHICLEGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"UnderwaterScannerIconRangeBoost", "0"},
							{"MechAltJumpMode",                 "True"},
							{"MechContrailAlpha",               "0.006"},
							{"MechLandBrake",                   "0.9"},
							{"MechJetpackStrafeStrength",       "1.5"},
							{"MechJetpackLandTime",             "1E-05"},
							{"MechJetpackBrake",                "1.2"},
							{"MechJetpackMaxSpeed",             "40"},
							{"MechJetpackUpForce",              "80"},
							{"MechJetpackFallForce",            "40"},
							{"MechJetpackDrainRate",            "0.05"},
							{"MechTitanFallCameraShakeDist",    "180"},
						}
					},
					--[=[DEPRECATED NMS 4.30.3.
						
					{
						["SPECIAL_KEY_WORDS"] = {"VehicleLocalScan","GcScanData.xml",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"PulseRange", "200"},
							{"ChargeTime", "20"},
						}
					},--]=]
					{
						["SPECIAL_KEY_WORDS"] = {"Name","BIKE",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionForce",         "20"},
								{"TopSpeedForward",              "35"},
								{"VehicleBoostMaxSpeed",         "40"},
								{"TopSpeedReverse",              "40"},
								{"WheelMaxAccelForceForward",    "350"},
								{"WheelMaxAccelForceReverse",    "350.5"},
								{"WheelMaxDecelForceNonBraking", "-1.1"},
								{"WheelMaxDecelForceBraking",    "550.05"},
								{"WheelDragginess",              "1"},
								{"TurningWheelForce",            "-4"},
								{"TurningWheelFrictionBraking",  "20"},
								{"VehicleGravity",               "40.5"},
								{"VehicleGravityWater",          "10.5"},
								{"VehicleJumpForce",             "1875"},
								{"VehicleJumpAirControlForce",   "220"},
								{"VehicleBoostForce",            "800"},
								
								{"VehicleBoostExtraMaxSpeedAir", "5"},
								{"VehicleBoostSpeedFalloff",     "0.05"},
								{"VehicleBoostTime",             "10.5"},
								{"VehicleBoostRechargeTime",     "0.02"},
								{"VehicleJumpAirRotateXAmount",  "0"},
								{"VehicleJumpAirRotateZAmount",  "0"},
								{"WheelSpinParticleMaxRate",     "11"},


								{"HeadlightIntensity",           "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MED_BUGGY",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionlength",        "0.7"},
								{"TopSpeedForward",              "34"},
								{"VehicleBoostMaxSpeed",         "45"},
								{"WheelMaxAccelForceForward",    "300.5"},
								{"WheelMaxAccelForceReverse",    "900.1"},
								{"WheelMaxDecelForceNonBraking", "0.02"},
								{"WheelMaxDecelForceBraking",    "188"},
								{"VehicleGravity",               "40"},
								{"VehicleGravityWater",          "38"},
								{"VehicleJumpForce",             "920"},
								{"VehicleBoostForce",            "480"},
								
								{"VehicleBoostSpeedFalloff",     "0.001"},
								{"VehicleBoostTime",             "1"},
								{"VehicleBoostRechargeTime",     "0.03"},
								{"HeadlightIntensity",           "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","TRUCK",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionForce",         "40"},
								{"TopSpeedForward",              "32"},
								{"VehicleBoostMaxSpeed",         "20"},
								{"WheelMaxDecelForceNonBraking", "0.002"},
								{"VehicleJumpForce",             "40"},
								{"VehicleBoostForce",            "520"},
								{"VehicleBoostMaxSpeed",         "40"},
								{"VehicleBoostSpeedFalloff",     "0.005"},
								{"VehicleBoostTime",             "100.25"},
								{"AudioImpacts",                 "Buggy_Impacts"},
								{"AudioSuspension",              "Buggy_Suspension"},
								{"AudioJump",                    "Buggy_Jump"},
								{"HeadlightIntensity",           "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WHEELEDBIKE",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionForce",           "12"},
								{"TopSpeedForward",                "19"},
								{"VehicleBoostMaxSpeed",           "25"},
								{"WheelMaxAccelForceForward",      "1060.5"},
								{"WheelMaxAccelForceReverse",      "655.5"},
								{"WheelMaxDecelForceNonBraking",   "0.002"},
								{"WheelMaxDecelForceBraking",      "5528"},
								{"WheelSpinniness",                "12"},
								{"WheelDragginess",                "55.01"},
								{"TurningWheelForce",              "-6"},
								--{"TurningWheelForceVR",            "0.8"},
								{"TurningWheelFrictionNonBraking", "28"},
								{"TurningWheelFrictionBraking",    "52"},
								{"VehicleGravity",                 "35"},
								{"VehicleGravityWater",            "58"},
								{"VehicleJumpForce",               "1050"},
								{"VehicleJumpAirControlForce",     "0"},
								{"VehicleBoostForce",              "560"},
								{"VehicleBoostMaxSpeed",           "45"},
								{"VehicleBoostSpeedFalloff",       "0.001"},
								{"VehicleBoostTime",               "10.2"},
								{"VehicleBoostRechargeTime",       "0.4"},
								{"VehicleJumpAirRotateXAmount",    "100"},
								{"VehicleJumpAirRotateZAmount",    "400"},
								{"VehicleJumpAirRotateTimeMin",    "30"},
								{"VehicleJumpAirRotateTimeMax",    "100"},
								{"HeadlightIntensity",             "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","HOVERCRAFT",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionForce",           "20"},
								{"WheelSuspensionDamping",         "0"},
								{"TopSpeedForward",                "45"},
								{"VehicleBoostMaxSpeed",           "60"},
								{"TopSpeedReverse",                "10"},
								{"WheelMaxAccelForceForward",    "350"},
								{"WheelMaxAccelForceReverse",    "350.5"},
								{"WheelMaxDecelForceNonBraking",   "-1.1"},
								{"WheelMaxDecelForceBraking",      "550.05"},
								{"WheelFrontFrictionDynamic",      "4"},
								{"WheelFrontFrictionStatic",       "8"},
								{"WheelSideFrictionDynamic",       "3"},
								{"WheelSideFrictionStatic",        "8"},
								{"TurningWheelFrictionNonBraking", "6"},
								{"TurningWheelFrictionBraking",    "20"},
								{"VehicleGravity",                 "40.5"},
								{"VehicleGravityWater",            "10.5"},
								{"VehicleJumpForce",               "875"},
								{"VehicleJumpAirControlForce",     "220"},
								{"VehicleBoostForce",              "800"},
								
								{"VehicleBoostExtraMaxSpeedAir",   "5"},
								{"VehicleBoostSpeedFalloff",       "0.05"},
								{"VehicleBoostTime",               "10.5"},
								{"VehicleBoostRechargeTime",       "0.02"},
								{"VehicleJumpAirRotateXAmount",    "0"},
								{"VehicleJumpAirRotateZAmount",    "0"},
								{"VehicleJumpAirRotateTimeMax",    "0.5"},
								{"DriveOnTopOfWater",              "True"},
								{"HeadlightIntensity",             "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","SUBMARINE",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"UnderwaterEnginePower",                  "32.2"},
								{"UnderwaterEngineMaxSpeed",               "65"},
								{"UnderwaterEngineFalloff",                "0.07"},
								{"UnderwaterEngineDirectionBrakeVertical", "0.002"},
								{"WheelSuspensionForce",                   "85"},
								{"TopSpeedForward",                        "25"},
								{"WheelMaxDecelForceNonBraking",           "1E-05"},
								{"WheelMaxDecelForceBraking",              "500.05"},
								{"VehicleGravity",                         "10"},
								{"VehicleJumpAirControlForce",             "980"},
								{"VehicleBoostMaxSpeed",                   "45"},
								{"VehicleBoostExtraMaxSpeedAir",           "60"},
								{"VehicleBoostTime",                       "12.5"},
								{"HeadlightIntensity",                     "30"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
								{"WheelSuspensionForce",        "0"},
								{"WheelSuspensionDamping",      "0"},
								{"TopSpeedForward",             "3"},
								{"TopSpeedReverse",             "3"},
								{"WheelMaxAccelForceReverse",   "9.5"},
								{"TurningWheelForce",           "-40"},
								{"TurningWheelFrictionBraking", "-12"},
								{"VehicleGravity",              "55"},
								{"VehicleGravityWater",         "90.5"},
								{"VehicleJumpAirControlForce",  "18000"},
								{"VehicleBoostMaxSpeed",        "9"},
								{"VehicleBoostSpeedFalloff",    "0.5"},
								{"VehicleBoostRechargeTime",    "0.05"},
								{"HeadlightIntensity",          "30"},
						}
					},
				}
			}
		},
		DAY_ONE_MODE
	)
	-- CUSTOM EXOCRAFTS

	addFeature
	(
		CUSTOM_ROAMER_EXOCRAFT,
		{
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\BUGGY\BUGGYPRES.SCENE.MBIN]],
						[[MODELS\RGO\_BUGGYPRES.SCENE.MBIN]],
					},
				}
			},

		}
	)
	addFeature
	(
		CUSTOM_NOMAD_EXOCRAFT ,
		{
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\BUGGY\BUGGYPRES.SCENE.MBIN]],
						[[MODELS\RGO\_BUGGYPRES.SCENE.MBIN]],
					},
				},
			}
		}
	)

	addFeature
	(
		CUSTOM_ROAMER_EXOCRAFT,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\BUGGY\BUGGYPRES.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Body2"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.4"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Glass"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.3"},
							{"TransZ", "-0.3"},
							{"ScaleX", "1.44"},
							{"ScaleY", "1.2"},
							{"ScaleZ", "1.44"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FL_SwingArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FR_SwingArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RL_SwingArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RR_SwingArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FL_SwingArmJNT","Name","FL_WheelAttach","Name","FL_SuspensionMountJNT","Name","FL_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.1"},
							{"ScaleY", "1.1"},
							{"ScaleZ", "1.1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FR_SwingArmJNT","Name","FR_WheelAttach","Name","FR_SuspensionMountJNT","Name","FR_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.1"},
							{"ScaleY", "1.1"},
							{"ScaleZ", "1.1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RL_SwingArmJNT","Name","RL_WheelAttach","Name","RL_SuspensionMountJNT","Name","RL_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", BIGWHEELSSIZE},
							{"ScaleY", BIGWHEELSSIZE},
							{"ScaleZ", BIGWHEELSSIZE},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RR_SwingArmJNT","Name","RR_WheelAttach","Name","RR_SuspensionMountJNT","Name","RR_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", BIGWHEELSSIZE},
							{"ScaleY", BIGWHEELSSIZE},
							{"ScaleZ", BIGWHEELSSIZE},
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Lights"},
						["REMOVE"] = "SECTION"
					},
					{
						["SECTION_ACTIVE"] = {0},
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							-- {"TransX", "0"},-- Enable if vanilla changes
							{"TransY", "0.4"},
							{"TransZ", "2.7"},
							{"ScaleX", "0.4"},
							{"ScaleY", "0.4"},
							{"ScaleZ", "0.4"},
						}
					},
					{
						["SECTION_ACTIVE"] = {0},
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransZ", "-0.4"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust","Name","RL"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1"},
							{"ScaleY", "1"},
							{"ScaleZ", "1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust","Name","RR"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1"},
							{"ScaleY", "1"},
							{"ScaleZ", "1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust","Name","FR"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1"},
							{"ScaleY", "1"},
							{"ScaleZ", "1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust","Name","FL"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1"},
							{"ScaleY", "1"},
							{"ScaleZ", "1"},
						}
					},
				}

			},
		}
	)
	if CUSTOM_ROAMER_EXOCRAFT == "ON" then
		addFeature
		(
			ROAMER_ADDITIONAL_LAMPS_FEATURE,
			{
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\BUGGY\BUGGYPRES.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] = BUGGY_LAMPS
						},
					}

				},
				{
					["MBIN_FILE_SOURCE"]  =
					{
						{
							[[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\ACCESSORIES\LAMP.SCENE.MBIN]],
							[[MODELS\RGO\EXO_LAMP.SCENE.MBIN]]
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\EXO_LAMP.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3665260437"},
							["PRECEDING_KEY_WORDS"] = {"MATERIAL"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\SPACE\NEXUS\NEXUSEXTERIOR\METALSHINY_MAT.MATERIAL.MBIN]]},
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\EXO_LAMP.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","HeadLamp","Name","StandingLight2"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","HeadLamp","Name","LightFlare"},
							["REMOVE"] = "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","HeadLamp","Name","spotLight1"},
							["REMOVE"] = "SECTION"
						},
					}
				},
			}
		)
	end
	addFeature
	(
		CUSTOM_COLOSSUS_EXOCRAFT,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\ROVER\ROVERPRES.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{

					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","BoostEffect"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.2"},
							{"TransZ", "-0.9"},
							{"ScaleX", "1.2"},
							{"ScaleY", "0.8"},
							{"ScaleZ", "0.8"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L1_SuspArmJNT","Name","L1_SuspJNT","Name","L1_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L2_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L3_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L4_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "3"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L3_SuspArmJNT","Name","L3_SuspJNT","Name","L3_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L4_SuspArmJNT","Name","L4_SuspJNT","Name","L4_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R1_SuspArmJNT","Name","R1_SuspJNT","Name","R1_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R2_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R3_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R4_SuspArmJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "3"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R4_SuspArmJNT","Name","R4_SuspJNT","Name","R4_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransZ", "-0.45"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R3_SuspArmJNT","Name","R3_SuspJNT","Name","R3_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransZ", "-1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L4_SuspArmJNT","Name","L4_SuspJNT","Name","L4_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransZ", "-0.45"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","L3_SuspArmJNT","Name","L3_SuspJNT","Name","L3_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransZ", "-1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R3_SuspArmJNT","Name","R3_SuspJNT","Name","R3_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","R4_SuspArmJNT","Name","R4_SuspJNT","Name","R4_WheelJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX", "1.5"},
							{"ScaleY", "1.5"},
							{"ScaleZ", "1.5"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","ThrusterJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","LVent1JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","LVent2JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","ThrustTopJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","ThrustBotJNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RVent2JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RVent1JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","TopVent3JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","TopVent2JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","TopVent1JNT"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Rover1"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.2"},
							{"ScaleX", "1.2"},
							{"ScaleY", "0.8"},
							{"ScaleZ", "0.8"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MeshParts"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.2"},
							{"ScaleX", "1.2"},
							{"ScaleY", "0.88"},
							{"ScaleZ", "0.8"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","FinishPipe5"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","AntennaSection2"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","SolarPanels"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight4"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight5"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","RearLight"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.8"},
							{"TransZ", "0.85"},
							{"ScaleZ", "0.8"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","RearLights"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.1"},
							{"TransZ", "1"},
							{"ScaleX", "1.2"},
							{"ScaleY", "0.8"},
							--{"ScaleZ", "1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","RearLightGlass"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "-0.8"},
							{"TransZ", "0.95"},
							{"ScaleX", "1.2"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","AntennaSection"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","COCKPITPOS"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "4.48"},
							{"TransZ", "3.84"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransY", "1.15"},
							{"TransZ", "0.1"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TransX", "-2.2"},
							{"TransY", "1.2"},
							{"TransZ", "0.8"},
						}
					},
				}
			}
		}
	)
	addFeature
	(
		CUSTOM_PILGRIM_EXOCRAFT,
		{
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\WHEELEDBIKE\WHEELEDBIKE.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Type","REFERENCE"},
						["REMOVE"] = "SECTION"
					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1},
						["ADD"] = KANEDA
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\BIKE\BIKEPRES.SCENE.MBIN]],
						[[MODELS\RGO\KANEDA_COCKPIT.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\VEHICLES\WHEELEDBIKE\WHEELEDBIKEPRES.SCENE.MBIN]],
						[[MODELS\RGO\KANEDA_WHEELS.SCENE.MBIN]],
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\KANEDA_COCKPIT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FR_SwingArmJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","FL_SwingArmJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RL_SwingArmJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RR_SwingArmJNT"},
						["REMOVE"] = "SECTION"
					},
				}
			},
			--
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\KANEDA_COCKPIT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SPECIAL_KEY_WORDS"] = {"NameHash","4012473969"},
						["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Value",	[[MODELS\COMMON\VEHICLES\WHEELEDBIKE\WHEELEDBIKE\ENTITIES\WHEELEDBIKE.ENTITY.MBIN]]},
						}
					}
				},
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\KANEDA_WHEELS.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","AntennaJNT1"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","TopRSuspJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RFinJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","LFinJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","LVentJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT","Name","RootJNT","Name","RVentJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Spin"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Spin1"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Body"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","WheeledBike"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight2"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight3"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight5"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","spotLight6"},
						["REMOVE"] = "SECTION"
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Thruster1REF"},
						["REMOVE"] = "SECTION"
					},
				}
			},
		}
	)
	addFeature
	(
		CUSTOM_NOMAD_EXOCRAFT,
		{
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					{
						[[MODELS\COMMON\SPACECRAFT\SCIENTIFIC\CANOPY\CANOPYA\CANOPYA.SCENE.MBIN]],
						[[MODELS\RGO\BALL_COCKPIT_EXO.SCENE.MBIN]],

					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\BALL_COCKPIT_EXO.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","ATTACHMENT"},
						["REMOVE"] = "SECTION"
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\BIKE\BIKE.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Type","REFERENCE"},
						["REMOVE"] = "SECTION"
					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1},
						["ADD"] = BALL
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = "GCVEHICLEGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","BIKE",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"DriveOnTopOfWater",           "False"},
						}
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\BIKE\BIKEPRES.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Lights"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage1"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Stage2"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"
					},
				},
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\BIKE\BIKEPRES.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1},
						["ADD"] = BIKEPRES1
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  =
				{
					{
						[[MODELS\COMMON\VEHICLES\BIKE\BIKEPRES.SCENE.MBIN]],
						[[MODELS\RGO\BIKEPRES1.SCENE.MBIN]],
						
					}
				},
			},

			{
				["MBIN_FILE_SOURCE"]  =
				{
					{
						[[MODELS\RGO\_BUGGYPRES.SCENE.MBIN]],
						[[MODELS\RGO\BIKEPRES2.SCENE.MBIN]],
					}
				},
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\BIKEPRES2.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","CTRLJNT"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Lights"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Glass"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Accs1"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Boost"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","BackCover"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Body2"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","LEngineSpin"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","REngineSpin"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Buggy"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Gun"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","Scanner"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelDust"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","WheelSkidDust"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosA_Front"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosB_Left"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosC_Right"},
						["REMOVE"] = "SECTION"
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Name","_DecalPosD_Back"},
						["REMOVE"] = "SECTION"
					},

				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\RGO\BIKEPRES2.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1},
						["ADD"] = BIKEPRES2
					},

				}
			},
		}
	)
	-- MECHs RESIZER
	if MECHS_SIZE_MULTIPLIER > 10 then
		MECHS_SIZE_MULTIPLIER = 10
	end
	if MECHS_SIZE_MULTIPLIER <= 1 then
		MECHS_SIZE_MULTIPLIER = 2
	end
	MECH_FACTOR = (MECHS_SIZE_MULTIPLIER-1) /20
	MECH_ANIM_SPEED = tostring((math.abs(1-MECH_FACTOR))) -- from {size "2" : anim "0.9"} to {size "10" : anim 0.1}
	MECH_SPEED_MULTIPLIER = tostring(MECHS_SIZE_MULTIPLIER/2)
	--MECHS_SIZE_MULTIPLIERx15 = tostring(MECHS_SIZE_MULTIPLIER*15)
	--MECHS_SIZE_MULTIPLIERx10 = tostring(MECHS_SIZE_MULTIPLIER*10)
	MECHS_SIZE_MULTIPLIER = tostring(MECHS_SIZE_MULTIPLIER)


	addFeature
	(
		GIANT_MECHS_BETA_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\TECH\VEHICLEGARAGEMECH.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{

					{
						["MATH_OPERATION"] = "*" ,
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","Hologram","Name","MechHoloLOD2"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX",MECHS_SIZE_MULTIPLIER},
							{"ScaleY",MECHS_SIZE_MULTIPLIER},
							{"ScaleZ",MECHS_SIZE_MULTIPLIER}
						}
					},
					{
						["MATH_OPERATION"] = "*" ,
						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Name","Hologram","Name","MechHoloLOD3"},
						["VALUE_CHANGE_TABLE"] =
						{
							{"ScaleX",MECHS_SIZE_MULTIPLIER},
							{"ScaleY",MECHS_SIZE_MULTIPLIER},
							{"ScaleZ",MECHS_SIZE_MULTIPLIER}
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\TECH\VEHICLEGARAGEMECH\ENTITIES\CUSTOMISER.ENTITY.MBIN]],
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["SECTION_ACTIVE"] = {0,1,2,3},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Distance",	"50"},
						}
					}
				},
			},
			{
				["MBIN_FILE_SOURCE"] =
				{
					{
						[[MODELS\COMMON\VEHICLES\MECH_SUIT\MECH_SUIT.SCENE.MBIN]],[[MODELS\RGO\MECH_SUIT_PRES.SCENE.MBIN]]
					},
					{
						[[MODELS\COMMON\ROBOTS\SENTINELMECH.SCENE.MBIN]],[[MODELS\RGO\SENTMECH_SUIT_PRES.SCENE.MBIN]]
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\VEHICLES\MECH_SUIT\MECH_SUIT.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","TrajectorySHJnt"},
						["REMOVE"] = "SECTION",
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","RootLocator"},
						["REMOVE"] = "SECTION",
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","mech_mesh"},
						["REMOVE"] = "SECTION",
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","Mech"},
						["REMOVE"] = "SECTION",
					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] = RESIZABLEMECH
					}

				}
			},
			{
				["MBIN_FILE_SOURCE"] =
				{
					{
						[[MODELS\COMMON\ROBOTS\SENTINELMECH.SCENE.MBIN]],[[MODELS\RGO\SENTINEL_MECH.SCENE.MBIN]]
					}
				}
			},
			{
				["MBIN_FILE_SOURCE"] = [[MODELS\COMMON\ROBOTS\SENTINELMECH.SCENE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"Name","TrajectorySHJnt"},
						["REMOVE"] = "SECTION",
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","mech_mesh"},
						["REMOVE"] = "SECTION",
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","mech"},
						["REMOVE"] = "SECTION",
					},
					{
						["PRECEDING_KEY_WORDS"] = "Children",
						["SECTION_ACTIVE"] = {1,2},
						["ADD"] = RESIZABLESENTINELMECH
					}
				}
			},

			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\VEHICLES\MECH_SUIT\MECH_SUIT\ENTITIES\MECH.ENTITY.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"Speed",MECH_ANIM_SPEED},
							
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = [[MODELS\COMMON\ROBOTS\MECH\ENTITIES\SENTINELMECH.ENTITY.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"Speed",MECH_ANIM_SPEED},
							{"Health","10"}
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = "GCVEHICLEGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MechLandBrake",                   "1"},
							{"MechAIResummonTriggerDistance",             "2000"},
							{"MechAIResummonMinSpawnDistance",             "1000"},
							{"MechTitanFallCameraShakeDist",    "1800"},
						}
					},
					{
						["MATH_OPERATION"] = "*" ,
						["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"TopSpeedForward",             MECH_SPEED_MULTIPLIER},
							{"TopSpeedReverse",             MECH_SPEED_MULTIPLIER},
							{"WheelMaxAccelForceForward",   MECH_SPEED_MULTIPLIER},
							{"WheelMaxAccelForceReverse",   MECH_SPEED_MULTIPLIER},
							{"VehicleBoostMaxSpeed",        MECH_SPEED_MULTIPLIER},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"VehicleGravity",               "40.5"},
						}
					},
				}
			},
			{
				["MBIN_FILE_SOURCE"]  = "GCCAMERAGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
--[=[

								{
					["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"BackMinDistance", "2.5"},
						{"BackMaxDistance", "2.5"},
						{"UpMinDistance", "2.5"},
						{"UpMaxDistance", "2.5"},
						{"OffsetX", "2.5"},
						{"OffsetY", "2.5"},
						{"OffsetYAlt", "2.5"},
					}
				},
				{
					["SPECIAL_KEY_WORDS"] = {"Name","MECHJETPACK",},
					["INTEGER_TO_FLOAT"] = "FORCE",
					["SECTION_ACTIVE"] = {1,2},
					["VALUE_CHANGE_TABLE"] =
					{
						{"BackMinDistance", "2.5"},
						{"BackMaxDistance", "2.5"},
						{"UpMinDistance", "2.5"},
						{"UpMaxDistance", "2.5"},
						--{"OffsetX", "0.5"},
						{"OffsetY", "2.5"},
						{"OffsetYAlt","2.5"},
				},

				--]=]
					{
						["REPLACE_TYPE"] = "ALL",

						["SPECIAL_KEY_WORDS"] = {"Name","MECH",},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["MATH_OPERATION"] 	= "*",
						["VALUE_CHANGE_TABLE"] =
						{
							{"BackMinDistance", MECHS_SIZE_MULTIPLIER},
							{"BackMaxDistance", MECHS_SIZE_MULTIPLIER},
							{"OffsetX", MECHS_SIZE_MULTIPLIER},
							{"OffsetY", MECHS_SIZE_MULTIPLIER},
							{"OffsetYAlt", MECHS_SIZE_MULTIPLIER},
							{"UpMinDistance", MECHS_SIZE_MULTIPLIER},
							{"UpMaxDistance", MECHS_SIZE_MULTIPLIER},
						}
					},
					
					{
						["SPECIAL_KEY_WORDS"] = {"Name","MECHJETPACK",},
						["INTEGER_TO_FLOAT"] = "FORCE",

						["SECTION_ACTIVE"] = {1,2},
						["MATH_OPERATION"] 	= "*",
						["VALUE_CHANGE_TABLE"] =
						{
							--{"OffsetX", MECHS_SIZE_MULTIPLIER},
							{"OffsetY", MECHS_SIZE_MULTIPLIER},
							{"OffsetYAlt", MECHS_SIZE_MULTIPLIER},
							{"UpMinDistance", MECHS_SIZE_MULTIPLIER},
							{"UpMaxDistance", MECHS_SIZE_MULTIPLIER},
							{"BackMinDistance", MECHS_SIZE_MULTIPLIER},
							{"BackMaxDistance", MECHS_SIZE_MULTIPLIER},
						}
					},
				},
			},
		},
		DAY_ONE_MODE
	)

	-- HOVER MODE
	addFeature
	(
		HOVER_MODE,
		{
			{
				["MBIN_FILE_SOURCE"]  = "GCSPACESHIPGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
										{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"HoverTakeoffHeight", "590"},
							{"HoverMinSpeed", "0.1"},
							{"MiniWarpLinesNum", "0"},
							{"LandGroundTakeOffTime", "0.92"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MinSpeed", "0.1"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MinSpeed", "0.1"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlLight", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MinSpeed", "0.1"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MinSpeed", "0.1"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MinSpeed", "0.1"},
						}
					}
				}
			}
		},
		DAY_ONE_MODE
	)
	-- SANKUKAI SPACE COMBAT ( REDMAS DOGFIGHTS )
	
	addFeature
	(
		SANKUKAI_SPACESHIPS_COMBAT,
		{
			
			{
				["MBIN_FILE_SOURCE"]  = "GCSPACESHIPGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
										{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"HoverTakeoffHeight", "590"},
							{"HoverMinSpeed", "0.1"},
							{"MiniWarpLinesNum", "0"},
							{"LandGroundTakeOffTime", "0.92"},
						}
					},
					-- NORMAL SPACESHIPS
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "SpaceEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX},
							{"BoostFalloff", "0" },
							{"OverspeedBrake" , "0"},
							{"RollForce", "2"},
							{"RollAmount", "2"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "CombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "Control", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					-- SMALL SPACESHIPS
					{
						["PRECEDING_KEY_WORDS"] = { "ControlLight", "SpaceEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlLight", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlLight", "CombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"} 
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlLight", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
						--	{"OverspeedBrake" , "0"}
						}
					},
					-- HEAVY SPACESHIPS
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "SpaceEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE_H},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_H},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_H},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_H},
							{"BoostFalloff", "0"},
														{"RollForce", "2"},
							{"RollAmount", "2"},
							{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_H},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_H},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_H},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_H},
							{"BoostFalloff", "0" },
														{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "CombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE_H},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_H},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_H},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_H},
							{"BoostFalloff", "0"},
														{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHeavy", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_H},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_H},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_H},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_H},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
										-- Sentinels SPACESHIPS
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHover", "SpaceEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHover", "PlanetEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHover", "CombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_S},
							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_SPACE_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "ControlHover", "AtmosCombatEngine" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"ThrustForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"Falloff", "0"},
							{"BoostThrustForce", SPACESHIPS_PLANET_BOOST_FORCE_S},
							{"BoostMaxSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"BoostFalloff", "0" },
							{"RollForce", "2"},
							{"RollAmount", "2"},
							--{"OverspeedBrake" , "0"}
						}
					},
				}
			},
			-- aim issue fix
			{
				["MBIN_FILE_SOURCE"]  = "METADATA\PROJECTILES\PROJECTILETABLE.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["MATH_OPERATION"] = "*" ,
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"DefaultSpeed", "1.9"},
							{"Scale", "1.012"},
						}
					}
				}
			},
			-- Balancing
			--[=[ Decompiling issue on NMS 4.44
			{
				["MBIN_FILE_SOURCE"]  = "METADATA\SIMULATION\SPACE\AISPACESHIPATTACKDATATABLE.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["MATH_OPERATION"] = "*" ,
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"LevelledExtraHealth", "0.01"},
							{"Health", "0.51"},
							{"RechargeDelayTime", "10"},
						}
					}
				}
			},
			
			-- A.I.
			{
				["MBIN_FILE_SOURCE"]  = "METADATA\SIMULATION\SPACE\AISPACESHIPATTACKDATATABLE.MBIN",
				["EXML_CHANGE_TABLE"] =
				{

					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","SPACE_EASY"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"BoostSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"Force", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MinSpeedForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"DirectionBrake", "0.05"},
							{"MaxSpeedBrake", "0.09"},
							{"MaxSpeedBrake", "0.001"},
							{"Falloff", SPACESHIPS_SPACE_FALLOFF_S},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","SPACE_HARD"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"BoostSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"Force", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MinSpeedForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"DirectionBrake", "0.05"},
							{"MaxSpeedBrake", "0.09"},
							{"MaxSpeedBrake", "0.001"},
							{"Falloff", SPACESHIPS_SPACE_FALLOFF},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","PLANET_EASY"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MinSpeedForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							--{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"DirectionBrake", "0.05"},
							--{"MaxSpeedBrake", "0.09"},
							--{"MaxSpeedBrake", "0.001"},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","PLANET_HARD"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_S},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX_S},
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"MinSpeedForce", SPACESHIPS_PLANET_THRUSTFORCE_S},
							{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"DirectionBrake", "0.05"},
							--{"MaxSpeedBrake", "0.09"},
							--{"MaxSpeedBrake", "0.001"},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","RAID_BUILDING"},
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MinSpeedForce", SPACESHIPS_PLANET_THRUSTFORCE},
							{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"DirectionBrake", "0.05"},
							--{"MaxSpeedBrake", "0.09"},
							--{"MaxSpeedBrake", "0.001"},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							--{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","SQUADRON_SLOW"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MinSpeedForce", SPACESHIPS_PLANET_THRUSTFORCE},
							{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"DirectionBrake", "0.05"},
							--{"MaxSpeedBrake", "0.09"},
							--{"MaxSpeedBrake", "0.001"},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{

						["INTEGER_TO_FLOAT"] = "FORCE",
						["SPECIAL_KEY_WORDS"] = {"Id","SQUADRON_FAST"},
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS

							{"MaxSpeed", SPACESHIPS_SPACE_MAXPSEED_S},
							{"BoostSpeed", SPACESHIPS_SPACE_BOOST_MAX_S},
							{"Force", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"MinSpeedForce", SPACESHIPS_SPACE_THRUSTFORCE_S},
							{"Falloff", SPACESHIPS_SPACE_FALLOFF},
							{"DirectionBrake", "0.05"},
							--{"MaxSpeedBrake", "0.09"},
							--{"MaxSpeedBrake", "0.001"},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					-- COMBAT REWORK
					{
						["REPLACE_TYPE"] = "ALL",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							--{"GunDispersionAngle", "5"},
							{"GunFireRate", "0.055"},
							{"AttackWeaponRange", "1000"},
							{"AttackAngle", "61"},
							{"AttackShootTimeMin", "4.5"},
							{"AttackShootTimeMax", "135"},
							{"NumHitsBeforeReposition", "5"}
						}
					}

				}
			},
			--]=]
			{
				["MBIN_FILE_SOURCE"]  = "GCAISPACESHIPGLOBALS.GLOBAL.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] =
						{
							--{"BulletLength", "50"},
							--{"BulletGlowWidthTime", "10.2"},
							--{"BulletScaler", "3"},
							{"FinalDeathExplosionScale", "10"},
							{"FinalDeathExplosionTime", "200.8"},
							{"DisableTradeRoutes",DISABLE_TRADING_ROUTES}
						}
					},
					{
						["VALUE_CHANGE_TABLE"] =
						{
							{"FlybyPlanetLandingProbability", 0.30 },
						}
					},

					{
						["INTEGER_TO_FLOAT"]= "FORCE",
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] =
						{
							{"AttackShipsFollowLeader", "True"},
							{"WitnessSightRange", "300000"},
							{"FreighterAttackDisengageDistance", "30000000"},
							-- {"WingmanLockDistance", WingmanLockDistance},
							{"MaxNumTurretMissiles", "10"},
							{"MissileLaunchSpeed", "1200"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "FallbackTravelData" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
						--	{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "SlowCombatEffectAttackTravel" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
						--	{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "AsteroidMiningPositioningTravelData" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED},
						--	{"Falloff", SPACESHIPS_PLANET_FALLOFF},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					},
					{
						["PRECEDING_KEY_WORDS"] = { "AsteroidMiningTravelData" },
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							-- SPACESHIP SKILLS
							{"Force", SPACESHIPS_PLANET_THRUSTFORCE_H},
							{"MaxSpeed", SPACESHIPS_PLANET_MAXPSEED_H},
						--	{"Falloff", SPACESHIPS_PLANET_FALLOFF_H},
							{"BoostSpeed", SPACESHIPS_PLANET_BOOST_MAX_H},
							-- FIX FOR WEIRD LOOPING
							{"Roll", "0" },
							{"AvoidTime", "0"},
						}
					}
				}
			}
		},
		DAY_ONE_MODE
	)
	-- ONFOOT COMBAT
	addFeature
	(
		ONFOOT_COMBAT_REVISON_BETA_FEATURE,
		{
			
			{
				["MBIN_FILE_SOURCE"] = [[GCROBOTGLOBALS.MBIN]],
				["INTEGER_TO_FLOAT"] = "PRESERVE",
				["EXML_CHANGE_TABLE"] =
				{
				--[=[{
						
						["VALUE_CHANGE_TABLE"] =
						{
							--{"WalkerAttackRange","160"},
							--{"WalkerGuardAlertRange","120"},
							--{"WalkerAttackRate","5"},
							--{"WalkerLaserOvershootStart","5"},
							--{"WalkerLaserOvershootStart","-2"},
							--{"WalkerGunShootTime","40"},
							--{"WalkerGunRate","0.01"},
							--{"QuadAlertRange","16"},
							--{"QuadAttackRange","200"},
							--{"QuadAttackMinRange","1"},
							--{"QuadAttackAngle","380"},
							--{"QuadJumpBackRange","100"},
							--{"QuadJumpBackCheckRange","120"},
							--{"QuadJumpBackHeightRange","20"},
							--{"QuadJumpBackJumpDistance","150"},
							--{"QuadJumpBackJumpMinLength","35"},
							--{"QuadPounceRange","180"},
							--{"QuadFireTime","0.2"},
							--{"QuadChargeTargetLockPercent","0.8"},
							--{"QuadAttackRate","1"},
							--{"QuadMoveSpeed","80"},
							--{"QuadLaserIntensity","5"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = "WalkerLaser",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
						--	{"LaserSpringTime","3"},
							--{"LaserMiningDamage","30000000"},
						--	{"LaserChargeTime","2.8"},
						--	{"LaserTime","0.2"},
						--	{"LaserLightChargeSize","20"},
						--	{"LaserLightAttackSize","40"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = "QuadLaser",
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
						--	{"LaserMiningDamage","300"},
						--	{"LaserChargeTime","2.8"},
						--	{"LaserTime","0.08"},
						--	{"LaserLightChargeSize","5"},
						}
					},--]=]
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Patrol"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","40"},
							{"MinHeight","0.7"},
							--{"MaxHeight","14"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Attack"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","40"},
							{"MinHeight","3.8"},
							--{"MaxHeight","14"},
							--{"MaxPitch","360"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Search"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","50"},
							{"MinHeight","0.5"},
							--{"MaxHeight","15"},
						}
					},
					
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Summon"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","50"},
							--{"Strength","1000"},
							{"MinHeight","8"},
							--{"MaxHeight","8"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","ToCover"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","50"},
							--{"Strength","2"},
							{"MinHeight","0.5"},
							--{"MaxHeight","1"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Stun"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","5"},
							--{"Strength","2"},
							{"MinHeight","1"},
							{"MaxHeight","2"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","Friendly"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","3"},
							{"MinHeight","0.5"},
							{"MaxHeight","1"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl","FriendlyFast"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"MaxSpeed","15"},
							{"MinHeight","2.5"},
							{"MaxHeight","4"},
						}
					},
					{
						["SECTION_ACTIVE"] = {1,2,3},
						["PRECEDING_KEY_WORDS"] = {"DroneControl"},
						["INTEGER_TO_FLOAT"] = "FORCE",
						["VALUE_CHANGE_TABLE"] =
						{
							{"AttackMinSpeed","60"},
							--{"AttackBobAmount","0.51"},
							--{"AttackMoveAngle","360"},
						}
					},


				}
			},
			
		},
		DAY_ONE_MODE
	)


	-- INERACTIVE OBJECTS
	--copyEXML(NEW_INTERACTIONS_FEATURE,[[SAVETABLE.SCENE.EXML]],[[MODELS\RGO\SAVETABLE.SCENE.EXML]])
	copyEXML(NEW_INTERACTIONS_FEATURE,[[SAVEPOINT.ENTITY.EXML]],[[MODELS\RGO\ENTITIES\SAVEPOINT.ENTITY.EXML]])


 	--copyEXML(NEW_INTERACTIONS_FEATURE,[[SAVETABLE.SCENE.EXML]],[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\LIGHTTABLE.SCENE.EXML]])
	
	addFeature
	(
		NEW_INTERACTIONS_FEATURE,
		{
			-- NEW NPCS INTERACTIONS
			{
				["MBIN_FILE_SOURCE"] 	= [[METADATA\SIMULATION\NPCS\NPCSPAWNTABLE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					{
						["SPECIAL_KEY_WORDS"] = {"PlacementRuleId","WFC_SECONDARY"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"InteractionType","MissionGiver"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"PlacementRuleId","FREIGHT_GENERIC"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"InteractionType","NPC_Secondary"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"PlacementRuleId","FREIGHT_HANGAR"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"InteractionType","NPC_Secondary"}
						}
					},
				}
			},
				---------------------------------------------------------------------------------------
				-- FREIGHTER HANGAR
				{
					["MBIN_FILE_SOURCE"] 	= FREIGHTER_PATH..[[HANGARINTERIOR.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] 	= FREIGHTER_CONTENT
						}
					}
				},
				 ----FREIGHTER HANGAR CUSTOM MODELS generation
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\MONITORDESK.SCENE.MBIN]],
					

					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3601946984"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\MISSIONS.ENTITY.MBIN]]},
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\MONITORDESK.SCENE.MBIN]],
							[[MODELS\RGO\MISSION-MONITORDESK.SCENE.MBIN]]
					 	}
					},
				},
				{
					["MBIN_FILE_SOURCE"] 	=  [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\MONITORDESK.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3601946984"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\MP-MISSIONS.ENTITY.MBIN]]},
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\MONITORDESK.SCENE.MBIN]],
							[[MODELS\RGO\MP-MISSION-MONITORDESK.SCENE.MBIN]]
					 	}
					},
				},
				-- New Entities creation
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\SPACE\NEXUS\NEXUS\ENTITIES\MPTERMINAL.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"UseInteractCamera",	"False"},
								{"RepeatInteraction",	"True"},
							}
						}
					}
				},
				{

					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\SPACE\NEXUS\NEXUS\ENTITIES\MPTERMINAL.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\MP-MISSIONS.ENTITY.MBIN]]
					 	},
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\SPACE\NEXUS\NEXUS\ENTITIES\MPTERMINAL.ENTITY.MBIN]],
											{
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT",},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"InteractionType",	[[MissionGiver]]},
							}
						}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\SPACE\NEXUS\NEXUS\ENTITIES\MPTERMINAL.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\MISSIONS.ENTITY.MBIN]],
							"REMOVE"
					 	},
					}
				},
				-- END FREIGHTER HANGAR






				-- TRADINGPOST
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\TRADINGPOST\LAYOUTS\LAYOUT_SCIENTIFIC.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] 	= TRADINGPOST_SCIENTIFIC_CONTENT
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\TRADINGPOST\LAYOUTS\LAYOUT_TRADER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] 	= TRADINGPOST_TRADER_CONTENT
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\TRADINGPOST\LAYOUTS\LAYOUT_WARRIOR.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] 	= TRADINGPOST_WARRIOR_CONTENT
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\TRADINGPOST\PARTS\TRADINGPOST_COMMON.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair2"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair3"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair4"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair6"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair7"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair8"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair9"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair10"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair13"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair17"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair18"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair19"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair20"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair21"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair22"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair23"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair24"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair25"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair26"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair27"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair28"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair29"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair30"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair31"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair32"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair33"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair34"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair35"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair36"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair37"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair38"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair39"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair40"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair41"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair42"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair43"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair44"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair45"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair46"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair47"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair48"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair49"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair50"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair51"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair52"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair53"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair54"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair55"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair56"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair57"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair58"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair59"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair60"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair61"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair62"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair63"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair64"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair65"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair86"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair90"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair94"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair98"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair102"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair106"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Name","WaitingRoomChair110"},
							["REMOVE"] 	= "SECTION"
						},

						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0,1},
							["ADD"] 	= TRADINGPOST_COMMON_CONTENT
						}
					}
				},
				-- TRADING POST CUSTOM MODELS generation
				
				
				
				

				---- INTERACTIVE DECORATION ENTITIES generation
				------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"FREIGHTERLOOT"},
							}

						},
						{
							["PRECEDING_KEY_WORDS"] = {"GcScannableComponentData.xml"},
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\CARGOGENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_RARE_COPPER"},
							}

						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\COBALTGENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_GEM_B_LARGE"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\DIHYDROGENGENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_GEODE_LAND"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\FERRITEDUSTGENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"PLANT_FUEL"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\OXYGENFAN.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"PLANTER_CARBON"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\PLANTERWALLSHELVES.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"SHIELDLARGE"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\SHIELDPLANT.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_CAVE_SECOND"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\SILVCOPPLATCOBGENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_WATER_LARGE"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\WATER2GENERATOR.ENTITY.MBIN]],

					 	}
					}
				},
				--------------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = {"GcSimpleInteractionComponentData.xml"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Id",	"DE_WATERPLANT_A"},
							}

						}
					}

				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\BARREL\BARREL_MEDIUM_RARE\ENTITIES\BARREL_MEDIUM_RARE.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\SALTGENERATOR.ENTITY.MBIN]],
							"REMOVE"
					 	}
					}
				},
				--------------------
				------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\COMMONPARTS\CRYOCHAMBERPOD\ENTITIES\CRYOCHAMBERPOD.ENTITY.MBIN]],
	
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"UseInteractCamera",	"False"},
								{"RepeatInteraction",	"True"},
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = {"TkAnimationComponentData.xml"},
							["REMOVE"] 	= "SECTION"
						},
						{
							["PRECEDING_KEY_WORDS"] = {"GcTriggerActionComponentData.xml"},
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\COMMONPARTS\CRYOCHAMBERPOD\ENTITIES\CRYOCHAMBERPOD.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\SUITUPGRADE.ENTITY.MBIN]],
							"REMOVE"
					 	}
					}
				},
				------------
				------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CHARCUSTOMISER\CHARCUSTOMISER\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"UseInteractCamera",	"False"},
								{"RepeatInteraction",	"True"},
							}
						},
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CHARCUSTOMISER\CHARCUSTOMISER\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]],
							"REMOVE"
							}
					}
				},
				------------
				------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRATE\CRATE_WEAPON\ENTITIES\CRATE_WEAPON.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"UseInteractCamera",	"False"},
								{"RepeatInteraction",	"True"},
							}
						},
						{
							["PRECEDING_KEY_WORDS"] = {"TkAnimationComponentData.xml"},
							["REMOVE"] 	= "SECTION"
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= {
						{
							[[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\CRATE\CRATE_WEAPON\ENTITIES\CRATE_WEAPON.ENTITY.MBIN]],
							[[MODELS\RGO\ENTITIES\CRATE_WEAPON.ENTITY.MBIN]],
							"REMOVE"
						}
					}
				},

				------------
				-- INTERACTIVE DECORATION MODELS generation
				-------------
				
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\BED.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","501765465"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\SAVEPOINT.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\CANISTERRACK.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_HYDRO							
						},
					}				
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\CRATE.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_CRATES							
						},
					}					
				},
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\LOCKER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_CUSTOMIZER							
						},
					}					
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\DRAWS.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_CUSTOMIZER							
						},
					}					
				},
				------------- 
				-------------
				--[=[
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\LIGHTTABLE.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_SAVE					
						},
					}					
				},--]=]
				-------------
								{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\BED.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_SAVE					
						},
					}					
				},
				
				-------------
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\DRAWS.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1616260697"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\FANVENT.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1339394650"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\OXYGENFAN.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\LARGEDESK.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_SIGNAL							
						},

					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\TECH\SIGNALSCANNER\ENTITIES\SIGNALSCANNER.ENTITY.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SECTION_ACTIVE"] = {0,1,2,3},
							["PRECEDING_KEY_WORDS"] = {"TkAudioComponentData.xml"},
							["REMOVE"] 	= "SECTION"
						}

					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\LOCKER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2810148397"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\PLANTPOT_1.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","247822816"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\PLANTERWALLSHELVES.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\PLANTPOT_2.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2663608103"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\SHIELDPLANT.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\PLANTPOT_3.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3639339141"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\PLANTERWALLSHELVES.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\PLANTPOTWALL.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1932763104"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\PLANTERWALLSHELVES.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\ROBOTICARM.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2234383842"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\SUITUPGRADE.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\ROOFMONITOR.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","2810148397"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\SUITUPGRADE.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\SHELVES.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1790091986"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\CHARCUSTOMISER.ENTITY.MBIN]]},
							}
						}
					}

				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WALLMONITOR_A.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1932763104"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\MISSIONS.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WALLMONITOR_B.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3704986639"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\MISSIONS.ENTITY.MBIN]]},
							}
						}
					}

				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WALLMONITOR_B2.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3704986639"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\MP-MISSIONS.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WATERCORALTREEDECORATION.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","1043640970"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\WATER2GENERATOR.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WATERGLOWPLANTDECORATION.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","3904623923"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\SALTGENERATOR.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PARTS\BUILDABLEPARTS\DECORATION\WEAPONRACK.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] 	=
					{
						{
							["SPECIAL_KEY_WORDS"] = {"NameHash","245433769"},
							["PRECEDING_KEY_WORDS"] = {"ATTACHMENT"},
							["SECTION_ACTIVE"] = {0,1,2,3},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"Value",	[[MODELS\RGO\ENTITIES\CRATE_WEAPON.ENTITY.MBIN]]},
							}
						}
					}
				},
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PROPS\LARGECRATE.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Children",
							["SECTION_ACTIVE"] = {0},
							["ADD"] 	= BTN_CARGO							
						},

					}
				},
				
				-------------
				-------------
				{
					["MBIN_FILE_SOURCE"] 	= [[MODELS\PLANETS\BIOMES\COMMON\BUILDINGS\PROPS\CONTAINER.SCENE.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Attributes",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] 	=
							{
								[[
									<Property value="TkSceneNodeAttributeData.xml">
									<Property name="Name" value="ATTACHMENT" />
									<Property name="AltID" value="" />
									<Property name="Value" value="MODELS\RGO\ENTITIES\CARGOGENERATOR.ENTITY.MBIN" />
									</Property>
								]]
							}
						},

					}
				}

		}
	)
	-- Advanced Builds






	addFeature
	(
		ADVANCED_BUILDS_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] 	= {
					SETTLEMENT_PATH..[[BASECOMPUTER.WFC.MBIN]],
					SETTLEMENT_PATH..[[BIOROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[CUBEROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[MAINROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[NPCBASE.WFC.MBIN]],
					SETTLEMENT_PATH..[[WATER\BIOROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[WATER\CUBEROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[WATER\MAINROOM.WFC.MBIN]],
					SETTLEMENT_PATH..[[WATER\NPCBASE.WFC.MBIN]]
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"DontSpawnNearPlayerBases","False"},
						}
					},
				}
			},
			---
			{
				["MBIN_FILE_SOURCE"] 	= [[METADATA\REALITY\TABLES\BASEBUILDINGOBJECTSTABLE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{

					{
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CheckPlaceholderCollision","False"},
							{"BuildableUnderwater","True"},
							{"CanScale","True"},
							{"BuildableAboveWater","True"},
							{"PlanetLimit","0"},
							{"RegionLimit","0"},
						--	{"PlanetBaseLimit","0"},
						--	{"FreighterBaseLimit","0"},
						--	{"BuildableOnSpaceBase","True"},
							{"BuildableOnFreighter","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["PRECEDING_KEY_WORDS"] = {"Objects","Groups"},
						["ADD"] 	= FREIGHTER_GROUP,

					},
					{
							["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_MECH"},
							["SECTION_ACTIVE"] = {1,2},
							["REMOVE"] = "SECTION"
						},
											{
							["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_L"},
							["SECTION_ACTIVE"] = {1,2},
							["REMOVE"] = "SECTION"
						},
											{
							["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_M"},
							["SECTION_ACTIVE"] = {1,2},
							["REMOVE"] = "SECTION"
						},
											{
							["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_S"},
							["SECTION_ACTIVE"] = {1,2},
							["REMOVE"] = "SECTION"
						},
											{
							["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_B"},
							["SECTION_ACTIVE"] = {1,2},
							["REMOVE"] = "SECTION"
						},
					{
						["PRECEDING_KEY_WORDS"] = {"Objects"},						
						["ADD"] 	= FREIGHTER_EXO,

					},
					-- PICKABLE OBJECTS LIST
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","PLANETEXOCRAFT"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanPickUp","True"},
							{"PlanetBaseLimit","0"},
							{"FreighterBaseLimit","0"},
							--{"BuildableOnSpaceBase","True"},

						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","PLANET_TECH"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanPickUp","True"},


						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","FURNITURE"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanPickUp","True"},

						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","TECHTECH"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanPickUp","True"},

						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","FRE_TECH_OTHER"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanPickUp","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_S"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanScale","False"},

						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_M"},
						["VALUE_CHANGE_TABLE"] 	=
						{
														{"CanScale","False"},

						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_L"},
						["VALUE_CHANGE_TABLE"] 	=
						{
														{"CanScale","False"},

						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_M"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CanScale","False"},

						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_MECH"},
						["VALUE_CHANGE_TABLE"] 	=
						{
														{"CanScale","False"},

						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","GARAGE_SUB"},
						["VALUE_CHANGE_TABLE"] 	=
						{
														{"CanScale","False"},
						}
					},
					-- Autopowered objects list
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","DECOLIGHTS"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"NetworkSubGroup","0"},
							{"NetworkMask","0"},
							{"Rate","0"}
						}
					},

					-- more objects for planet bases
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","FURNITURE"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALL"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALLDOOR"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALLTALL"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALLCURVED"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","ROOMFLOOR"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALL"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALL"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"ID","WALL"},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanetBase","True"},
							{"CanScale","True"}
						}
					},



					------------------------------------------------
						-- Buildable on planets objects list ( related to the customisable settlements feature, and for new gameplay mechanics )
						-- /!\ never put walls, doors, roofs, and other things related to the build mission in the story progression - That would break it /!\
						{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","TECHTECH"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","DECORATION"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","FURNITURE"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","BASE_TECH"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","EXOTICS"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","FRE_TECH_OTHER"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","WALL_ART"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"SubGroupName","PLANETPORTABLE"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					},
					{
						["REPLACE_TYPE"] = "ALL",
						["SPECIAL_KEY_WORDS"] = {"Group","PLANET_TECH"},
						["SECTION_UP"] = 2,
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"BuildableOnPlanet","True"}
						}
					}
				}

			}
		}
	)
	-- FREE POWER
	addFeature
	(
		FREE_POWER_ON_EM_GENERATORS,
		{
			{
				["MBIN_FILE_SOURCE"] 	= [[METADATA\REALITY\TABLES\BASEBUILDINGOBJECTSTABLE.MBIN]],
				["EXML_CHANGE_TABLE"] =
				{
					-- Free POWER
					{
						["SPECIAL_KEY_WORDS"] = {"ID","U_GENERATOR_S"},
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"DependsOnHotspots","None"},
                             {"Storage","36000"},
                            {"Rate","1000"}
						}
					}
				}
			}
		}
	)
	-- Mining speed
	MINING_SPEED_FEATURE = "OFF"
	if MINING_SPEED ~= "1" then
		MINING_SPEED_FEATURE = "ON"
	end
	addFeature
	(
		MINING_SPEED_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"] 	=
				{
					[[MODELS\PLANETS\BIOMES\BARREN\PLANTS\LARGECACTUS\ENTITIES\LARGECACTUS.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\BARREN\PLANTS\MEDIUMCACTUS\ENTITIES\MEDIUMCACTUS.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\BARREN\PLANTS\SMALLCACTUS\ENTITIES\SMALLCACTUS.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\BARREN\PLANTS\THINBUSHTREE\ENTITIES\_CAC_1.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\BARREN\ROCKS\LARGEROCK\ENTITIES\LARGEBARRENROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK\ENTITIES\MEDIUMROCKBARREN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\CAVE\SMALLPROP\SMALLGLOWPLANT\ENTITIES\_MEDPLANT_B.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\PLANTS\LARGEPLANT\ENTITIES\LARGEPLANT.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\PLANTS\MEDIUMBUSH\ENTITIES\_MEDIUMBUSH.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\PLANTS\MEDIUMPLANT\ENTITIES\MEDIUMPLANT.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\PLANTS\SMALLFLOWERS\ENTITIES\SMALLFLOWER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\PLANTS\SMALLPLANT\ENTITIES\SMALLPLANT.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\LARGE\LARGEROCK\ENTITIES\LARGEROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\LARGE\LARGEROCK\ENTITIES\LARGEROCKWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\LARGE\PROCSHAPE1\ENTITIES\_BASE_1.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\LARGE\RESOURCEROCKLARGE\ENTITIES\RESOURCEROCKLARGE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\LARGE\RESOURCEROCKSHARD\ENTITIES\RESOURCEROCKSHARD.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\MEDIUMROCK\ENTITIES\MEDIUMROCKCAVE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\MEDIUMROCK\ENTITIES\MEDIUMROCKSCAN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\MEDIUMROCK\ENTITIES\MEDIUMROCKWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\MEDIUMROCK\ENTITIES\ROCKMEDIUM1.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\RESOURCEROCK\ENTITIES\RESOURCEROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\SMALL\RESOURCESMALL\ENTITIES\RESOURCEROCKSMALL.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\ROCKS\SMALL\SMALLROCK\ENTITIES\SMALLROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1\ENTITIES\MEDIUMTREE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGEROCKS\ENTITIES\_LARGEROCK_A.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGETREE\ENTITIES\_TRUNK_A2.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGETREE\ENTITIES\_TRUNK_C.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGETREE\ENTITIES\_TRUNK_C2.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\MEDIUMPROPS\MEDIUMPLANT\ENTITIES\_MEDPLANT_D.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\FROZEN\SMALLPROPS\SMALLPLANT\ENTITIES\_SMALLPLANT_A.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGEROCK\ENTITIES\LARGESCORCHROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE\ENTITIES\LARGESPIRE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK\ENTITIES\MEDIUMSCORCHROCK.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMSPIRE\ENTITIES\MEDIUMSPIRE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\VOLCANICPLANT\ENTITIES\SCORCHEDPLANT.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\SCORCHED\SMALL\SMALLSPIRE\ENTITIES\SMALLSPIRE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\TOXIC\LARGE\FUNGALTREE\ENTITIES\FUNGALTREE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGEBLOB\ENTITIES\LARGEBLOB.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE\ENTITIES\SPONGE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL\ENTITIES\_TENDRIL_1.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL\ENTITIES\TENDRIL.ENTITY.MBIN]] ,
										[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\LARGE\CRYSTAL_LARGE\ENTITIES\CRYSTAL_LARGE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\LARGE\CRYSTAL_LARGE_CAVE\ENTITIES\CRYSTAL_LARGE_CAVE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\LARGE\CRYSTAL_LARGE_MOUNTAIN\ENTITIES\CRYSTAL_LARGE_MOUNTAIN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\LARGE\CRYSTAL_LARGE_UNDERWATER\ENTITIES\CRYSTAL_LARGE_UNDERWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\LARGE\CRYSTALCUBE_LARGE\ENTITIES\CRYSTALCUBE_LARGE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM\ENTITIES\CRYSTAL_MEDIUM.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_CAVE\ENTITIES\CRYSTAL_MEDIUM_CAVE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_MOUNTAIN\ENTITIES\CRYSTAL_MEDIUM_MOUNTAIN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTAL_MEDIUM_UNDERWATER\ENTITIES\CRYSTAL_MEDIUM_UNDERWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM\ENTITIES\CRYSTAL_MEDIUM.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\MEDIUM\CRYSTALCUBE_MEDIUM\ENTITIES\CRYSTALCUBE_MEDIUM.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT\ENTITIES\SHARDS.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_CAVE\ENTITIES\SHARDS_CAVE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_MOUNTAIN\ENTITIES\SHARDS_MOUNTAIN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_FRAGMENT_UNDERWATER\ENTITIES\SHARDS_UNDERWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL\ENTITIES\CYSTAL_SMALL.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_CAVE\ENTITIES\CYSTAL_SMALL_CAVE.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_MOUNTAIN\ENTITIES\CYSTAL_SMALL_MOUNTAIN.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTAL_SMALL_UNDERWATER\ENTITIES\CYSTAL_SMALL_UNDERWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\COMMON\CRYSTALS\SMALL\CRYSTALCUBE_SMALL\ENTITIES\CYSTALCUBE_SMALL.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\UNDERWATER\LARGEPLANTS\ENTITIES\LARGEPLANTWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\UNDERWATER\MEDIUMPLANTS\ENTITIES\MEDIUMPLANTWATER.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\UNDERWATER\MEDIUMPLANTS\MEDIUIMGLOWPLANT\ENTITIES\_BASE_1.ENTITY.MBIN]] ,
					[[MODELS\PLANETS\BIOMES\UNDERWATER\SMALLPLANTS\ENTITIES\SMALLPLANTWATER.ENTITY.MBIN]]
				},
				["EXML_CHANGE_TABLE"] 	=
				{
					{
						["PRECEDING_KEY_WORDS"] = "",
						["MATH_OPERATION"] 		= "/",
						["REPLACE_TYPE"] 		= "ALL",
						["VALUE_MATCH"] 		= "",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{ "Health",	MINING_SPEED }
						}
					}
				}
			}
		}
	)
	-- Advanced Body Shapes
	addFeature
	(
		ADVANCED_BODY_SHAPES_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  = "METADATA/UI/CHARACTERCUSTOMISATIONUIDATA.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["INTEGER_TO_FLOAT"] = "FORCE",
						["PRECEDING_KEY_WORDS"] = {"Positions"},
						["REPLACE_TYPE"] = "ALL",
						["ADD"] 	= POSITIONS
					}
				}
			}
		}
	)
end
-- END GAMEPLAY OVERHAUL
-- CREATURES GENERATION
if CREATURES_OVERHAUL == "ON" then
--[=[
	-- CREATURES DENSITY FEATURE ------------------------------------------------
	if PERFORMANCE_MODE == "ON"
	then
		SPAWNDISTANCE = 2
		SPAWNRATE = 5000
	end
--]=]	-------------------------------------------------------------------------------
	-- HIGH DENSITY FEATURE

	addFeature
	(
		
				CREATURES_HIGH_DENSITY_FEATURE,
		{
			{
				["MBIN_FILE_SOURCE"]  =
				{
					PATH_ECOSYSTEM..[[AIR\AIRTABLEBIGBIRD.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLEBUSY.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLECOMMON.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLECOMMONLIZARD.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLECOMMONSNAKE.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLEFLYINGLIZARDONLY.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLEFLYINGSNAKESONLY.MBIN]],
					PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEBUTTERFLY.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\UNDERWATERTABLECOMMON.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLEFLOCK.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLEFLOCK2.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLEFLOCK3.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLEFLOCKSHARK.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLEJELLYFISH.MBIN]],
					PATH_ECOSYSTEM..[[UNDERWATER\TEST\UNDERWATERTABLESHARKEATSNAKE.MBIN]],
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							--{"IncreasedSpawnDistance", "3"},
							{"CreatureActiveTime", "AnyTime"},
							--{"MaxGroupSize", MAX_CREATURES_NUMBER},
						}
					},

				}
			},
			--test
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[CREATUREROLEDESCRIPTIONTABLE.MBIN]],
				["EXML_CHANGE_TABLE"] = 
				{
					{
						["MATH_OPERATION"] = "+",
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Dead", "1"},
							{"Low", "2"},
							{"Mid", "3"},
							{"Full", "5"},
						}
					},
				}
			},
			
			--fin test
			
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM.."CREATUREGENERATIONARCHETYPES.MBIN",
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Sparse"},
						}
					},
					--[=[
					{
						["SPECIAL_KEY_WORDS"] = {"Id","ROBOT"}	,
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","ROBOT"}	,
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
				
					{
						["SPECIAL_KEY_WORDS"] = {"Id","FLYINGLIZARD"}	,
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_PLOUGH"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_PLOUGH"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_PROTOFLYER"},
						["REPLACE_TYPE"] = "ALL",
						["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","PARADISE"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","DEFAULT"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},--]=]
					{
						["SPECIAL_KEY_WORDS"] = {"Id","BUTTERFLY"}	,
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_SMALLBIRD"}	,
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","BIGBIRDS"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},

					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_JELLYFISH"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_FLOCKSHARK"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_FLOCK3"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_FLOCK2"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_FLOCK"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","T_SHARKSNAKE"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","CRABS"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},
					{
						["SPECIAL_KEY_WORDS"] = {"Id","CRABS"},
						["REPLACE_TYPE"] = "ALL",
						--["SECTION_ACTIVE"] = {1,2},
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"Density", "Dense"},
						}
					},

				},
			},
		}
	)
	-----------------------------------------------------------------
	
	
	--------------------------------------------------------------
	-- REDMAS GAME OVERHAUL ADDITIONAL CREATURES
	addFeature
	(
		CREATURES_OVERHAUL,
		{

			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDBUTTERFLY.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_BUTTERFLIES,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDCRYSTAL.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDCRYSTALPREDATOR.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_CRYSTALS_PRED,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDFLOAT.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDFLOAT,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDROLL.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\WEIRD\GROUNDTABLEWEIRDROLLPREDATOR.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{

					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_BONES_n_ROBOTs_WEIRDROLL_PRED,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEHERBIVOREMED.MBIN]],
				["EXML_CHANGE_TABLE"]  =
				{
					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_GRUNTS,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  = {
					PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEHERBIVORELARGE.MBIN]],
					PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEHERBIVOREGIANT.MBIN]],
				},
				["EXML_CHANGE_TABLE"]  =
				{
					{
						["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
						["ADD"] 				= REDMAS_CREATURES_DIPLOS,
					},
				}

			},
			{
				["MBIN_FILE_SOURCE"]  =
					{
						PATH_ECOSYSTEM..[[CAVE\CAVETABLECOMMON.MBIN]],
						PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPREDATORMED.MBIN]],
						PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPREDATORLARGE.MBIN]],
						PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPLAYERPREDATORMED.MBIN]],
						PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPLAYERPREDATORLARGE.MBIN]],

					},
				["EXML_CHANGE_TABLE"]  =
				{
					{
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"CreatureRole", "PlayerPredator"},
						},
						{
							["PRECEDING_KEY_WORDS"] = {"RoleDescription"},
							["ADD"] 				= REDMAS_CREATURES_KRITTERS,
						}
					}
				}
			}
		}
	)
	---------------------------------------------------------------------------
	-- FIENDS COMBAT REWORK
	addFeature
	(
		CREATURES_OVERHAUL,
		{
			{
				["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
				["VALUE_CHANGE_TABLE"] 	=
				{
					{"FiendHealth", "6"},
					{"FiendDespawnDistance", "1500"},
					{"FiendMaxEngaged", "16"},
					{"FiendMaxAttackers", "12"},
					{"MaxFiendsToSpawn", "16"},
				},
			}
		},
		DAY_ONE_MODE
	)
	-----------------------------------------------------------------------------------
	-- SANDWORM OVERHAUL FEATURE ------------------------------------------------
	addFeature
	(
		SANDWORM_OVERHAUL_FEATURE,
		{

				{
					["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
					["EXML_CHANGE_TABLE"]  =
					{
						{
							["INTEGER_TO_FLOAT"] = "FORCE",
							["VALUE_CHANGE_TABLE"] =
							{
								{"SandWormChangeDirectionTime", "0.001"},
								{"SandWormSteerAdjustTime", "0.2"},
								{"SandWormMaxSteer", "10"},
								{"SandWormMaxHeightAdjust", "380"},
								{"SandWormJumpHeight", "3"},
								{"SandWormJumpTime", "0.0001"},
								{"SandWormSubmergeDepth", "1"},
								{"SandWormSubmergeTime", "1"},
								{"SandWormSurfaceTime", "3"},
								{"SandWormMaxJumps", "1500"},
								{"SandWormSpawnTimer", "130"},
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"]  = CREATUREDATATABLE,
					["EXML_CHANGE_TABLE"]  =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Id","SANDWORM"},
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"MoveRange", "10000"},
								{"SwarmMovementRadius", "1000"},
								{"SwarmMovementType", "Circle"},
								{"MaxSpeed", "70"},
								{"CircleAttractor", "Player"},
							}
						},
					}
				}

		},
		DAY_ONE_MODE
	)
	-- CREATURES BEHAVIOURS IMPROVEMENTS FEATURE ------------------------------------------------
	addFeature
	(
		CREATURES_BEHAVIOURS_IMPROVEMENTS_FEATURE,
				{
					{
				["MBIN_FILE_SOURCE"]  =
				{
					PATH_ECOSYSTEM..[[AIR\AIRTABLEFLYINGLIZARDONLY.MBIN]],
					PATH_ECOSYSTEM..[[AIR\AIRTABLEFLYINGSNAKESONLY.MBIN]],
				},
				["EXML_CHANGE_TABLE"] =
				{
					{
						["REPLACE_TYPE"] = "ALL",
						["VALUE_CHANGE_TABLE"] 	=
						{
							{"IncreasedSpawnDistance", "3"},
						}
					},

				}
			},

					{
						["MBIN_FILE_SOURCE"]  = CREATUREDATATABLE,
						["EXML_CHANGE_TABLE"] =
							{
								{

									["SPECIAL_KEY_WORDS"] = {"Id","FISH"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"}
									}
								},
																{

									["SPECIAL_KEY_WORDS"] = {"Id","SANDWORM"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinScale", "1"},
										{"MaxScale", "11"},
									}
								},
								{

									["SPECIAL_KEY_WORDS"] = {"Id","FISHFLOCK"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"}
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","SWIMCOW"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"}
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","SWIMRODENT"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "50"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","JELLYFISH"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMin", "5"},
										{"HeightMax", "50"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","CRAB"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"}
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","SEASNAKE"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","SHARK"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMax", "56"},
										{"MoveRange", "1500"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","BIRD"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										--{"HeightMin", "5"},
										{"HeightMax", "10"},
										{"MoveRange", "150"},
									}
								},
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","FLYINGSNAKE"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMin", "5"},
										{"HeightMax", "40"},
										{"SwarmMovementSpeed", "0.1"},
										{"SwarmMovementType", "FollowPlayer"},
										{"CircleAttractor", "Portal"},
										{"MaxSpeed", "10"},
									}
								},
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","FLYINGLIZARD"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"HeightMin", "5.1"},
										{"HeightMax", "50"},
										{"SwarmMovementSpeed", "56"},
										{"SwarmMovementType", "FollowPlayer"},
										{"FlapSpeedMin", "0.5"},
										{"FlapSpeed", "49"},
										{"FlapAccel", "49"},
										{"FlapSpeedMinScale", "0.1"},
										{"CircleAttractor", "Player"},
										{"MaxSpeed", "10"},

									}
								},
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","BUTTERFLY"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MoveSpeedScale", "0.1"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","LARGEBUTTERFLY"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MaxSpeed", "15"},
										{"GroundAlign", "True"},
										{"GroundAvoid", "False"},
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","FLYINGBEETLE"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinScale", "0.14"},
										{"MoveRange", "1000"},
										{"MoveSpeedScale", "1"},
										{"MaxSpeed", "15"},
										{"ApplyScaleToSpeed", "False"},
									}
								},

								{
									["SPECIAL_KEY_WORDS"] = {"Id","PLOUGH"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"SwarmMovementType", "FollowPlayer"},
									}
								},
								{
									["SPECIAL_KEY_WORDS"] = {"Id","PROTOFLYER"},
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"SwarmMovementType", "FollowPlayer"},
									}
								},

							}
					},
					{
						["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
						["EXML_CHANGE_TABLE"] =
							{
								{
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"IsHurtingCreaturesACrime", "True"},
										{"EnableFlyingSnakeTails", "True"},
									}
								}
							}
					},



			},
			DAY_ONE_MODE
	)
	-- GIANTS CREATURES FEATURE ------------------------------------------------
	addFeature
	(
		GIANTS_CREATURES_FEATURE,
		{

					{
						["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
						["EXML_CHANGE_TABLE"] =
							{
								{
									["VALUE_CHANGE_TABLE"] =
									{
										{"MaxCreatureSize", GIANTS_MAX_SIZE },
										{"CreatureSmallHealth", "1400" },
										{"CreatureMedHealth", "4000" },
										{"CreatureLargeHealth", "10000" },
										{"CreatureHugeHealth", "30000" },
										{"PredatorSmallHealth", "1400" },
										{"PredatorMedHealth", "3000" },
										{"PredatorLargeHealth", "10000" },
										{"PredatorHugeHealth", "30000" },
									}
								},
							}
					},

					-- LOD improvements for large creatures
					{
						["MBIN_FILE_SOURCE"]  = {
							PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEROBOT.MBIN]],
							PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPREDATORLARGE.MBIN]],
							PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEPREDATORLARGE.MBIN]],
							PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEHERBIVORELARGE.MBIN]],
							PATH_ECOSYSTEM..[[GROUND\GROUNDTABLEBONE.MBIN]],
							PATH_ECOSYSTEM..[[GROUND\TEST\GROUNDTABLELARGEBUTTERFLY.MBIN]]
						},
						["EXML_CHANGE_TABLE"] =
						{
							{
								["REPLACE_TYPE"] = "ALL",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"IncreasedSpawnDistance", "2"},
								}
							},

						}
					},

					-- Creatures types max size spawning
					{
						["MBIN_FILE_SOURCE"]  = PATH_ECOSYSTEM.."AIR\AIRTABLECOMMONSNAKE.MBIN",
						["EXML_CHANGE_TABLE"] =
						{
							{
								["VALUE_MATCH"] 		    = "Medium",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"CreatureSizeClass", "Huge"},
								}
							},


						}
					},
					
					{
						["MBIN_FILE_SOURCE"]  = CREATUREDATATABLE,
						["EXML_CHANGE_TABLE"] =
							{
	
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","SHARK"},
									
									["VALUE_CHANGE_TABLE"] 	=
									{
																				{"MinCount", "1"},
									  	{"MaxCount", "1"},
										{"MinScale", "1"},
										{"MaxScale", "13"},
									}
								},

								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","ROBOTANTELOPE"},
									
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinCount", "1"},
									  	{"MaxCount", "1"},
										{"MinScale", "0.2"},
										{"MaxScale", "142"},
									}
								},

																{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","BONECAT"},
									
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinCount", "1"},
									  	{"MaxCount", "1"},
										{"MinScale", "0.2"},
										{"MaxScale", "14"},
									}
								},

							
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","STRIDER"},
									
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinCount", "1"},
									  	{"MaxCount", "1"},
										{"MinScale", "1"},
										{"MaxScale", "52"},
									}
								},
								{
									["INTEGER_TO_FLOAT"] = "FORCE",
									["SPECIAL_KEY_WORDS"] = {"Id","TREX"},
									
									["VALUE_CHANGE_TABLE"] 	=
									{
										{"MinCount", "1"},
									  	{"MaxCount", "1"},
										{"MinScale", "1"},
										{"MaxScale", "15"},
									}
								},
						
							}
					},
					{
						-- slowest animations to make the Giant creatures more credible
						["MBIN_FILE_SOURCE"]  = {
							CREATURESMODELS..[[ANTELOPERIG\ANTELOPEROBOT\ENTITIES\ANTELOPEROBOT.ENTITY.MBIN]],
							CREATURESMODELS..[[CATRIG\BONECAT\ENTITIES\BONECATBODY.ENTITY.MBIN]],
						--	CREATURESMODELS..[[FLYINGLIZARDRIG\FLYINGLIZARD\ENTITIES\BODY_LIZARD.ENTITY.MBIN]],
							CREATURESMODELS..[[SHARKRIG\SHARK\ENTITIES\SHARK1.ENTITY.MBIN]],
							CREATURESMODELS..[[STRIDERRIG\STRIDER\ENTITIES\STRIDERMESH.ENTITY.MBIN]],
							CREATURESMODELS..[[TREXRIG\TREX\ENTITIES\_BODY_TREX.ENTITY.MBIN]],
						--	CREATURESMODELS..[[FISH\FISHFLOCK\ENTITIES\FISHFLOCK.ENTITY.MBIN]],
						--	CREATURESMODELS..[[FISH\SMALLFISH\ENTITIES\SMALLFISH.ENTITY.MBIN]],
							CREATURESMODELS..[[FISH\SMALLFISH\ENTITIES\BIGFISH.ENTITY.MBIN]],
						--	CREATURESMODELS..[[TRICERATOPSRIG\TRICERATOPS\ENTITIES\_BODY_TRI.ENTITY.MBIN]]
						},
						["EXML_CHANGE_TABLE"] =
						{
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
								["REPLACE_TYPE"] = "ALL",
								["VALUE_CHANGE_TABLE"] 	=
								{
									{"Speed", "0.7"},
								}
							}
						}
					}

			},
		DAY_ONE_MODE
	)

	-- BETTER SPAWNS
	addFeature
	(
		CREATURES_OVERHAUL,
			{
				{
					["MBIN_FILE_SOURCE"]  = CREATUREDATATABLE,
					["EXML_CHANGE_TABLE"] =
					{
						{
							["SPECIAL_KEY_WORDS"] = {"Id","BIRD"},
							
							["VALUE_CHANGE_TABLE"] 	=
							{
								--{"MinCount", "1"},
								{"MaxCount", MAX_CREATURES_NUMBER},
							}
						},
						{
							["SPECIAL_KEY_WORDS"] = {"Id","FISH"},
							
							["VALUE_CHANGE_TABLE"] 	=
							{
								--{"MinCount", "1"},
								{"MaxCount", MAX_CREATURES_NUMBER},
							}
						}
					}
				},--[=[ very laggy
				{
					["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
					["EXML_CHANGE_TABLE"] =
					{
						{
							["VALUE_CHANGE_TABLE"] 	=
							{
								{"MaxEcosystemCreaturesNormal", "400"},
								{"MaxEcosystemCreaturesLow", "200"},
								{"PauseBetweenCreatureSpawnRequests", SPAWNRATE},
							}
						}
					}
				}--]=]
			},

		DAY_ONE_MODE
	)
	--------------------------------------------------------------------
	-- PETS AND RIDING FEATURES
	addFeature
	(
		PETS_BEHAVIOURS_AND_RIDING_IMPROVEMENTS_FEATURE,
		{

					{
						["MBIN_FILE_SOURCE"]  = CREATUREGLOBALS,
						["EXML_CHANGE_TABLE"] =
						{
							{
								["INTEGER_TO_FLOAT"] = "FORCE",
								["VALUE_CHANGE_TABLE"] =
								{
									{"RideSpeedFast", "3" },
									{"RideSpeedChangeTime", "11.2" },
									{"RiderLeanTime", "1.3" },
									{"MaxSpeed", "10" },
									{"CreatureMedMinSize", "5" },
									{"CreatureLargeMinSize", "12" },
									{"CreatureHugeMinSize", "20" },
									{"PetWalkAtHeelChanceDevoted", "0.0001" },
									{"PetWalkAtHeelChanceIndependent", "0.9" },
									{"PetWalkAtHeelDistMin", "0.5" },
									{"PetWalkAtHeelDistMax", "1.8" },
									{"PetRunAtHeelDistMin", "1" },
									{"PetRunAtHeelDistMax", "10" },
									{"PetFollowRunPlayerDistance", "1000" },
									{"PetIncubationTime", TIMER_VALUE },
									{"PetTrustChangeInterval", TIMER_VALUE },
									{"PetEggFirstEggDelay", TIMER_VALUE }
								}
							}
						}
					}


			},
			DAY_ONE_MODE
	)
end
-- END CREATURES GENERATION

	-- voxels
	if E3_STYLE_RESSOURCES_DEPOSITS == "ON" then
		addFeature
		(
			E3_STYLE_RESSOURCES_DEPOSITS,
			{
				{
					["MBIN_FILE_SOURCE"] = [[METADATA\SIMULATION\SOLARSYSTEM\VOXELGENERATORSETTINGS.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["VALUE_CHANGE_TABLE"] =
							{
								{"SwapZY","True"},
							}
						},
					}
				}
			}
		)
	end

	if MODDED_TERRAIN_SHAPES_FEATURE == "SCI_FI_FANTASY" then
		copyEXML("ON",[[TERRAINSHAPE\SCI_FI_FANTASY.EXML]],[[METADATA\SIMULATION\SOLARSYSTEM\VOXELGENERATORSETTINGS.EXML]])
	end

	-- water colors

	if HUGE_WATER_COLORS_DIVERSITY_FEATURE == "ON" then

		GENERATED_WATER_COLORS = ""
		for loop=0 , PROCEDURALMAX do
			print("------ ADDED NEW WATER COLOURS " .. loop)
			_R_ = math.random(0,9)/10
			_G_ = math.random(0,9)/10
			_B_ = 0.9

		GENERATED_WATER_COLORS = GENERATED_WATER_COLORS..
		[[
			<Property value="GcPlanetWaterColourData.xml">
				<Property name="WaterFogColourNear" value="Colour.xml">
					<Property name="R" value="]].._R_..[[" />
					<Property name="G" value="]].._G_..[[" />
					<Property name="B" value="0.5" />
					<Property name="A" value="1" />
				</Property>
				<Property name="WaterFogColourFar" value="Colour.xml">
					<Property name="R" value="]].._R_..[[" />
					<Property name="G" value="]].._G_..[[" />
					<Property name="B" value="0.5" />
					<Property name="A" value="1" />
				</Property>
				<Property name="WaterColourBase" value="Colour.xml">
					<Property name="R" value="]].._R_..[[" />
					<Property name="G" value="]].._G_..[[" />
					<Property name="B" value="0.5" />
					<Property name="A" value="1" />
				</Property>
				<Property name="WaterColourAdd" value="Colour.xml">
					<Property name="R" value="0.015" />
					<Property name="G" value="0.015" />
					<Property name="B" value="0.015" />
					<Property name="A" value="1" />
				</Property>
				<Property name="FoamColour" value="Colour.xml">
					<Property name="R" value="0.412" />
					<Property name="G" value="0.308" />
					<Property name="B" value="0.065" />
					<Property name="A" value="0.2" />
				</Property>
			</Property>
		]]
		end
		addFeature
		(
			HUGE_WATER_COLORS_DIVERSITY_FEATURE,
			{
				{
					["MBIN_FILE_SOURCE"] = [[METADATA\SIMULATION\SOLARSYSTEM\COLOURS\WATERCOLOURS.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Settings",
							["ADD"] = GENERATED_WATER_COLORS
						},

					}
				}
			}
		)

	end
	--- end water colors

	-- SKY colors

	if PLANETSKY_COLORS_DIVERSITY_FEATURE == "ON" then

		GENERATED_FIRESKIES_COLORS = ""
		for loop=0 , PROCEDURALMAX do
			print("------ ADDED NEW FIRE SKIES COLOURS " .. loop)
			_R_ = math.random(0,5)/10
			_G_ = math.random(5,9)/10
			_B_ = math.random(5,9)/10

			_R3_ = math.random(0,5)/10
			_G3_ = math.random(0,9)/10
			_B3_ = math.random(5,9)/10

			_R2_ = 0.4
			_G2_ = 0.8
			_B2_ = 0.7

			_R4_ = math.random(0,5)/10
			_G4_ = math.random(0,9)/10
			_B4_ = math.random(5,9)/10
		GENERATED_FIRESKIES_COLORS = GENERATED_FIRESKIES_COLORS..
		[[
		      <Property value="GcPlanetWeatherColourData.xml">
				<Property name="SkyColour" value="Colour.xml">
				<Property name="R" value="]].._R_..[[" />
				<Property name="G" value="]].._G_..[[" />
				<Property name="B" value="]].._B_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkyUpperColour" value="Colour.xml">
				<Property name="R" value="]].._R_..[[" />
				<Property name="G" value="]].._G_..[[" />
				<Property name="B" value="]].._B_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkySolarColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="0.904" />
				<Property name="A" value="1" />
				</Property>
				<Property name="HorizonColour" value="Colour.xml">
				<Property name="R" value="]].._R3_..[[" />
				<Property name="G" value="]].._G3_..[[" />
				<Property name="B" value="]].._B3_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SunColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="]].._B4_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="FogColour" value="Colour.xml">
				<Property name="R" value="]].._R4_..[[" />
				<Property name="G" value="]].._G4_..[[" />
				<Property name="B" value="]].._B4_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="HeightFogColour" value="Colour.xml">
				<Property name="R" value="]].._R2_..[[" />
				<Property name="G" value="]].._G2_..[[" />
				<Property name="B" value="]].._B2_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkyGradientSpeed" value="Vector3f.xml">
				<Property name="x" value="1" />
				<Property name="y" value="1" />
				<Property name="z" value="1" />
				</Property>
				<Property name="LightColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="0.904" />
				<Property name="A" value="1" />
				</Property>
				<Property name="CloudColour1" value="Colour.xml">
				<Property name="R" value="0.9" />
				<Property name="G" value="0.945" />
				<Property name="B" value="0.965" />
				<Property name="A" value="1" />
				</Property>
				<Property name="CloudColour2" value="Colour.xml">
				<Property name="R" value="0.101" />
				<Property name="G" value="0.312" />
				<Property name="B" value="0.53" />
				<Property name="A" value="1" />
				</Property>
			</Property>

		]]
		end
		GENERATED_NORMALSKIES_COLORS = ""
		for loop=0 , PROCEDURALMAX do
			print("------ ADDED NEW NORMAL SKIES COLOURS " .. loop)
			_R_ = math.random(0,5)/10
			_G_ = math.random(5,9)/10
			_B_ = math.random(5,9)/10

			_R3_ = math.random(0,5)/10
			_G3_ = math.random(0,9)/10
			_B3_ = math.random(5,9)/10

			_R2_ = 0.4
			_G2_ = 0.8
			_B2_ = 0.7

			_R4_ = math.random(0,5)/10
			_G4_ = math.random(0,9)/10
			_B4_ = math.random(5,9)/10

		GENERATED_NORMALSKIES_COLORS = GENERATED_NORMALSKIES_COLORS..
		[[
			<Property value="GcPlanetWeatherColourData.xml">
				<Property name="SkyColour" value="Colour.xml">
				<Property name="R" value="]].._R_..[[" />
				<Property name="G" value="]].._G_..[[" />
				<Property name="B" value="]].._B_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkyUpperColour" value="Colour.xml">
				<Property name="R" value="]].._R_..[[" />
				<Property name="G" value="]].._G_..[[" />
				<Property name="B" value="]].._B_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkySolarColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="0.904" />
				<Property name="A" value="1" />
				</Property>
				<Property name="HorizonColour" value="Colour.xml">
				<Property name="R" value="]].._R3_..[[" />
				<Property name="G" value="]].._G3_..[[" />
				<Property name="B" value="]].._B3_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SunColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="]].._B4_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="FogColour" value="Colour.xml">
				<Property name="R" value="]].._R4_..[[" />
				<Property name="G" value="]].._G4_..[[" />
				<Property name="B" value="]].._B4_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="HeightFogColour" value="Colour.xml">
				<Property name="R" value="]].._R2_..[[" />
				<Property name="G" value="]].._G2_..[[" />
				<Property name="B" value="]].._B2_..[[" />
				<Property name="A" value="1" />
				</Property>
				<Property name="SkyGradientSpeed" value="Vector3f.xml">
				<Property name="x" value="1" />
				<Property name="y" value="1" />
				<Property name="z" value="1" />
				</Property>
				<Property name="LightColour" value="Colour.xml">
				<Property name="R" value="1" />
				<Property name="G" value="1" />
				<Property name="B" value="0.904" />
				<Property name="A" value="1" />
				</Property>
				<Property name="CloudColour1" value="Colour.xml">
				<Property name="R" value="0.9" />
				<Property name="G" value="0.945" />
				<Property name="B" value="0.965" />
				<Property name="A" value="1" />
				</Property>
				<Property name="CloudColour2" value="Colour.xml">
				<Property name="R" value="0.101" />
				<Property name="G" value="0.312" />
				<Property name="B" value="0.53" />
				<Property name="A" value="1" />
				</Property>
			</Property>

		]]
		end
		addFeature
		(
			HUGE_WATER_COLORS_DIVERSITY_FEATURE,
			{
				{
					["MBIN_FILE_SOURCE"] = 	[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\DAYSKYCOLOURS_FIRESTORM.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Settings",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] = GENERATED_FIRESKIES_COLORS
						},

					}
				},
				{
					["MBIN_FILE_SOURCE"] = 	[[METADATA\SIMULATION\SOLARSYSTEM\WEATHER\SKYSETTINGS\DAYSKYCOLOURS.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["PRECEDING_KEY_WORDS"] = "Settings",
							["SECTION_ACTIVE"] = {1,2},
							["ADD"] = GENERATED_FIRESKIES_COLORS
						},

					}
				},
			}
		)

	end
	--- end sky colors

	val_TERRAIN_HEIGHT_MIN = tonumber(TERRAIN_HEIGHT_MAX) - 50
	TERRAIN_HEIGHT_MIN = tostring (val_TERRAIN_HEIGHT_MIN)
	if MODDED_TERRAIN_SHAPES_FEATURE == "EPIC_FANTASY" then
		addFeature
		(
			"ON",
			{
				{
					["MBIN_FILE_SOURCE"] = [[METADATA\SIMULATION\SOLARSYSTEM\VOXELGENERATORSETTINGS.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["VALUE_CHANGE_TABLE"] =
							{
								{"Active","True"},
							}
						},


					}
				}
			}
		)
	end

	if MODDED_TERRAIN_SHAPES_FEATURE == "ON" then
		addFeature
		(
			"ON",
			{
				{
					["MBIN_FILE_SOURCE"] = [[METADATA\SIMULATION\SOLARSYSTEM\VOXELGENERATORSETTINGS.MBIN]],
					["EXML_CHANGE_TABLE"] =
					{
						{
							["REPLACE_TYPE"] = "ALL",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight",TERRAIN_HEIGHT_MIN},
								{"MaxHeight",TERRAIN_HEIGHT_MAX},
								--{"Active","True"},
							}
						},

						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Large",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","130"},
								{"MaxHeight","250"},
								{"NoiseGridType","SuperFormula_08"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Small",
							["VALUE_CHANGE_TABLE"] =
							{
								--{"SwapZY","True"},
								{"MinHeight","50"},
								{"MaxHeight","150"},
								{"NoiseGridType","Sphere"},
							}
						},
																		{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Aluminium",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","SuperPrimitiveRandom"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Gold",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","Torus"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Emeril",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Nickel",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","SuperPrimitiveRandom"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Iridium",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","SuperPrimitiveRandom"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Heridium",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","SuperFormula_03"},
							}
						},
						{
							["REPLACE_TYPE"] = "ALL",
							["PRECEDING_KEY_WORDS"] = "Resources_Copper",
							["VALUE_CHANGE_TABLE"] =
							{
								{"MinHeight","10"},
								{"MaxHeight","50"},
								{"NoiseGridType","SuperFormula_08"},
							}
						},

					}
				}
			}
		)
	end


-- GENERATION OVERHAUL
if GENERATION_OVERHAUL == "ON"
then
 --copyEXML(FANTASY_BIOMES_FEATURE,[[SENT\Fantasy_EXTREMESENTINELPROPS.EXML]],[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\EXTREMESENTINELPROPS.EXML]])
   copyEXML(FANTASY_BIOMES_FEATURE,[[SENT\Vanilla_EXTREMESENTINELPROPS.EXML]],[[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\RARE\EXTREMESENTINELPROPS.EXML]])
		TABLE_FERRITE_DUST_RESSOURCES =
		{

						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/BARREN/HQ/MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
									{
				["PATH"] = [[MODELS/PLANETS/BIOMES/BARREN/HQ/MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
									{
				["PATH"] = [[MODELS/PLANETS/BIOMES/BARREN/HQ/MEDIUMBOULDER02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
									{
				["PATH"] = [[MODELS/PLANETS/BIOMES/BARREN/HQ/MEDIUMBOULDER02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
				

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLBOULDER05.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "3"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/RADIOACTIVE/MEDIUM/CURVEDMEDIUM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMPROP01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\ROCKS\MEDIUM\RESOURCEROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\MEDIUM\MEDIUMGLOWROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\MEDIUM\MEDIUMGLOWROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLBLOCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},


			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS\RGO\LARGEROCK_1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTCUBE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.14"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMPILLAR.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMPROP01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SMALLPILLARSTUMP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SMALLTENDRIL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMSHARP01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\RESOURCEROCK.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMSHARP02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMSLATE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SQUATPILLAR1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

		}
		TABLE_CARBONE_RESSOURCES =
		{
					
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\VOLCANICPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/LUSHROOM/MEDIUMSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\TOXICEGGCLUSTER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\MEDIUMPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\MEDIUMTOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\SPORESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\SPORETUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},--
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			
				{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\FUNGALTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGEBLOB.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},	


		


						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.030"
			},

			
						{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.44"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.044"
			},
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGEFULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},

			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
				{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},

						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.03"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},

			{
				["PATH"] = [[MODELS/RGO/UNDERWATERTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "10",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS/RGO/UNDERWATERTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "10",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS/RGO/UNDERWATERTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "10",
				["MAXSIZE"] = "0.20"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREESMALL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.05"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS/RGO/VINETREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.44"
			},
			
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\LARGETREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
					["PATH"] = [[MODELS\RGO\MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE5.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
					["PATH"] = [[MODELS\RGO\MEDIUMTREE6.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
						["PATH"] = [[MODELS\RGO\MEDIUMTREE7.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE8.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE9.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE10.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
		
		

		}
		FROZENPROPS =
		{
			{
				["PATH"] = [[MODELS/RGO/DEADTREE02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},		
			--[=[
			{
				["PATH"] = [[MODELS/RGO/DEADTREE02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},	
			{
				["PATH"] = [[MODELS/RGO/DEADTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},	
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/MEDIUM/TOXICEGGCLUSTER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},	
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE5.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "60",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "30",
				["MAXSIZE"] = "1"
			},

			-- old
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},


			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\LARGEPROPS\ICEDECAL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\FOLIAGE\LARGETREEBARE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\FOLIAGE\STALKBRANCH.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\LARGEPROPS\ICEDECAL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\SKINNEDTREES.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\LARGEPROPS\LARGEICEROCK_1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\LARGEPROPS\LARGEROCKSTACK_1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\LARGEPROPS\LARGEROCK_1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\MEDIUMPROPS\MEDIUMROCKS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\TREES\HEROPINE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\TREES\SKINNYPINE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQFROZEN\TREES\TALLPINE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGEROCKS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGETREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\MSTRUCTURES\MSTRUCTURE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\LARGETREEBARE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "360",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\FROZEN\LARGEPROPS\SNOWCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2"
			},--]=]

		}
		NORMALLUSHTREES =
		{	
			{
				["PATH"] = [[MODELS/RGO/DEADTREE02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			
			
				-- update v7.2
			{
				["PATH"] = [[MODELS/RGO/DEADTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},	
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/MEDIUM/TOXICEGGCLUSTER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE5.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "5",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "50",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "20",
				["MAXSIZE"] = "2"
			},
			
			-- Old version

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},

			{
				["PATH"] = [[MODELS\RGO\MEDIUMBUSH01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMBUSH02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

		}
		max_giant_props2 = "14"
		max_giant_props = "20"
		max_rare_props = "55"
		GIANTLUSHTREES =
		{	
			{
				["PATH"] = [[MODELS/RGO/DEADTREE02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "44"
			},
			
			{
				["PATH"] = [[MODELS/RGO/DEADTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "44"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/MEDIUM/TOXICEGGCLUSTER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "44"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "34"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/TOXIC/LARGE/LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "40"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE5.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},

			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},		
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "42"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "6",
				["MAXSIZE"] = "12"
			},
					
			{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_giant_props2
			},
			
			{
				["PATH"] = [[MODELS/RGO/DEADTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_giant_props
			},
			{
				["PATH"] = [[MODELS/RGO/DEADTREE02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_giant_props
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_giant_props
			},
			
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_giant_props
			},
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
				{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},

			

			{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.01"
			},

			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "12"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREEMEDIUM.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREESMALL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},		
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\COLOURFANSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},

			{
				["PATH"] = [[MODELS\RGO\MEDIUMBUSH01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMBUSH02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\MEDIUM\VOLCANICPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/LUSHROOM/MEDIUMSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\TOXICEGGCLUSTER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\MEDIUMPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\MEDIUMTOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\SPORESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\SPORETUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
				{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\FUNGALTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGEBLOB.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.013"
			},	
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.04"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.030"
			},
									{
				["PATH"] = [[MODELS/RGO/RACESTATUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.014"
			},
			
						{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.44"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.044"
			},
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGEFULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},


			{
				["PATH"] = [[MODELS/RGO/UNDERWATERTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "10",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/BENDYTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/MEDIUMTREE4.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREEMEDIUM.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREESMALL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS/RGO/VINETREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.44"
			},
			
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\LARGETREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE5.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE6.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.20"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.44"
			},

			{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.01"
			},

			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "12"
			},

						{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.01"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\FUNGALTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGEBLOB.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\LARGETOXICEGGSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},

		
			{
				["PATH"] = [[MODELS\RGO\HOLOEXPLORER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "63"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTCUBE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\PROCRUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},

						{
				["PATH"] = [[MODELS\RGO\PROCRUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},


			{
				["PATH"] = [[MODELS\RGO\STEAMVENT.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
									{
				["PATH"] = [[MODELS/RGO/RACESTATUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			
						{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
		
			{
				["PATH"] = [[MODELS/RGO/MANGROVELARGEFULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
				{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "6"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

			{
				["PATH"] = [[MODELS/RGO/UNDERWATERTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "10",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/BENDYTREE01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREEMEDIUM.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRAIGHTTREESMALL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "5"
			},
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS/RGO/VINETREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			
			
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\COLOURFANSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGERING\HUGERINGTREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"-- always 1 thats a big model ( can cause a crash if more than value 1 )
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGESCORCHED\HUGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
				{
				["PATH"] = [[MODELS\RGO\LARGEROCK_1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTGLOWINGSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
									{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
									{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\PILLAR1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\RGO\SQUATPILLAR1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
		
			{
				["PATH"] = [[MODELS\RGO\LARGEPILLAR.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\RGO\LARGEPYRAMID.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			
			{
				["PATH"] = [[MODELS\RGO\LARGEROCKS2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\RGO\LARGESTRANDS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\RGO\MONOLITH.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2.94"
			},
						{
				["PATH"] = [[MODELS\RGO\SMALLTENDRIL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2.24"
			},
						{
				["PATH"] = [[MODELS\RGO\SQUATPILLAR1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2.4"
			},
			{
				["PATH"] = [[MODELS\RGO\UNDERWATERBOULDER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "2.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\GROUNDREVEALROCK01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "1",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\GROUNDREVEALROCK02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\LARGEHIVE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\LARGEHIVESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\LARGEMOUNTAINROCKCLOSED.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\LARGEPLAINSBOULDER02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER01.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMBOULDER02.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLBOULDER05.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\SMALLROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\LARGEROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\ROCKS\MEDIUMROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\CORAL\LARGEPROP\LARGELUMP1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\CORAL\LARGEPROP\SCALLOPSHELL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\CORAL\LARGEPROP\SHELLSPIKES.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\CORAL\LARGEPROP\SPIKEYSHELL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQLUSH\LARGEPROPS\MOSSCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQLUSH\LARGEPROPS\MOUNTAINROCK_1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQLUSHULTRA\HQLARGEROCKS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HQLUSHULTRA\HQROCKS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGETOXIC\HUGEFUNGUS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGETOXIC\HUGEFUNGUS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGETOXIC\HUGETENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGETOXIC\HUGETENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGEUW\HUGESWIRLPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGEUW\HUGESTRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGEUW\HUGESTRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LAVA\MEDIUMPROPS\LAVACRYSTALS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\LARGE\CURVEDROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\LARGE\LARGEGLOWPLANT.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\LARGE\LARGEGLOWPLANTSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\RADIOACTIVE\LARGE\RADIOACTIVETREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGEROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGEROCKSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\HOUDINIPROPS\LARGETENTACLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\HOUDINIPROPS\MEDIUMTENTACLEBLOB.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPORETREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "2",
				["MAXSIZE"] = "4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\SPONGE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\FUNGALTREE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing -- on purpose, not a mistake ( model replacement done)
				["ROT"] = "2",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\RGO\HUGEROCKRING.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\HUGEPROPS\HUGEROCK\HUGESPIKEROCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "2",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLBLOCK.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\IRRISHELLS\SHELLSHARD.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\BEAMSTONE\SMALLSTONE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTCUBE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTMETALSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},--]=]
				
		}
		TABLERAREOBJECTS = 
		{
			{
				["PATH"] = [[MODELS\RGO\GEK_HEAD02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "40"
			},			

			{
				["PATH"] = [[MODELS\RGO\GEK_HEAD02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "40"
			},
			{
				["PATH"] = [[MODELS\RGO\_SKULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "40"
			},
			{
				["PATH"] = [[MODELS\RGO\STATUE_WALK_S.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
				{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.5"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.3"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\COLOURFANSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
									{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "8"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},

			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},

			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
						{
				["PATH"] = [[MODELS/RGO/MANGROVEFULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
						{
				["PATH"] = [[MODELS/RGO/MANGROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "77"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "77"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "77"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "76"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "76"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "76"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "75"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "75"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "75"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.4"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.12"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.14"
			},
				{
				["PATH"] = [[MODELS/RGO/LARGEFIR01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "112"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.12"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.1"
			},
		
			{
				["PATH"] = [[MODELS/RGO/STRANDS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "111"
			},
		
		
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.26"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "26"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\COLOURFANSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.26"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.26"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.26"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20.6"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.2"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.51"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.56"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.55"
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
						{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
			{
				["PATH"] = [[MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.52"
			},

		
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\MEDIUM\SPORETUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "22"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\WEIRD\WIRECELLS\WIRECELLFLOATCUBE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = max_rare_props
			},
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\TOXIC\LARGE\TENDRIL.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "21"
			},	
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "30"
			},
		
									{
				["PATH"] = [[MODELS/RGO/RACESTATUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.3"
			},
			
						{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK01.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEARRANGEDROCK02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			
		
			{
				["PATH"] = [[MODELS/RGO/VINETREELARGE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			
			
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\LARGETREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS\RGO\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS/RGO/SMALLTREE1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "20"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\TREES\DRACAENA.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "4"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\COLOURFANSHROOM.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEBLUESHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\LUSHROOM\LARGEFANSHROOMSINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESHIELDTREESINGLE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\SCORCHED\LARGE\LARGESPIRE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "0.24"
			},
						{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			{
				["PATH"] = [[MODELS/RGO/REDMAS_GROVE3.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
						{
				["PATH"] = [[MODELS\RGO\FLOATER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},

			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "7"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "27"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "17"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK3.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "16"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK4.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "26"
			},
						{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "16"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "15"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "15"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "15"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK2.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS/RGO/LARGEOAK1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\COMMON\TREES\MEDIUMTREE1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "12"
			},
		


			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},			
			{
				["PATH"] = [[MODELS\RGO\STATUE_WARRIOR1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
						{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
												{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},{
				["PATH"] = [[MODELS\RGO\STATUE_WARRIOR1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
						{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
												{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},{
				["PATH"] = [[MODELS\RGO\STATUE_WARRIOR1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
						{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
												{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},{
				["PATH"] = [[MODELS\RGO\STATUE_WARRIOR1.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			
								{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},			{
				["PATH"] = [[MODELS\RGO\STATUE_WARRIOR1.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},									{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
		
						{
				["PATH"] = [[MODELS\RGO\ANOMALYEXPLORER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
			{
				["PATH"] = [[MODELS\RGO\EXPLORERSTAND.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
						{
				["PATH"] = [[MODELS\RGO\SMALLRUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\STEAMVENT.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\DRONESHIP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\DRONESHIP2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\ANOMALYEXPLORER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
									{
				["PATH"] = [[MODELS\RGO\HOLOSCEPTIC.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
						
						{
				["PATH"] = [[MODELS\RGO\HOLOEXPLORER.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\FOURTHRACE.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "11"
			},
						{
				["PATH"] = [[MODELS\RGO\GEK_HEAD02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\RGO\HUGEROCKRING.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "13"
			},
			{
				["PATH"] = [[MODELS\RGO\LARGEPYRAMID.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\NEXUSTOWER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\RGO\PLAQUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},


			{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\META.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\TURRETA.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\STATUE_WALK_S.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "14"
			},
			
							{
				["PATH"] = [[MODELS\RGO\POLICESHIP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\POLICESHIP02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTCUBE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTMETALSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},


						{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\HQ\MEDIUMHIVE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},



			{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},


			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\LARGEFLAG.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\PLANETS\BIOMES\BARREN\LARGEPROPS\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
						{
				["PATH"] = [[MODELS\RGO\PROCRUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\RGO\PROCRUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},

						{
				["PATH"] = [[MODELS\RGO\PROCRUINS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},


			{
				["PATH"] = [[MODELS\RGO\SMALLRUINS.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\STEAMVENT.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\DRONESHIP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\DRONESHIP2.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\GEK_HEAD02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
						{
				["PATH"] = [[MODELS\RGO\GEK_HEAD02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "2"
			},
			{
				["PATH"] = [[MODELS\RGO\HUGEROCKRING.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\LARGEPYRAMID.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\NEXUSTOWER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\PLAQUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\POLICESHIP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\POLICESHIP02.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\RUINS.SCENE.MBIN]],
				["TYPE"] = "Instanced", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
						{
				["PATH"] = [[MODELS\RGO\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SKULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\RGO\TURRETA.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\STATUE_WALK_S.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\HUGEROCKRING.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\LARGEPYRAMID.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\NEXUSTOWER.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\PLAQUE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\SKULL.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTMETALSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
						{
				["PATH"] = [[MODELS\RGO\SANDCOVEREDWEIRDPROP.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},
			{
				["PATH"] = [[MODELS\RGO\GIANTMETALSPIKE.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "10"
			},
			{
				["PATH"] = [[MODELS\RGO\TURRETA.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

						{
				["PATH"] = [[MODELS\RGO\STATUE_WALK_S.SCENE.MBIN]],
				["TYPE"] = "Single", -- please dont change that value if you are not sure of what you are doing
				["ROT"] = "0",
				["MAXSIZE"] = "1"
			},

		}
		SUBBIOMES_GR = ""
		--
		for count=1, tablelength(TABLE_FERRITE_DUST_RESSOURCES) do
			GENERATED_BIOME_PATH = [[METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GR]]..count
			generateRocksBiomes
			(
				GENERATED_BIOME_PATH,
				TABLE_FERRITE_DUST_RESSOURCES[count].TYPE,TABLE_FERRITE_DUST_RESSOURCES[count].PATH)
			SUBBIOMES_GR = SUBBIOMES_GR..
			[[
				<Property value="NMSString0x80.xml">
					<Property name="Value" value="]]..GENERATED_BIOME_PATH..[[.MBIN" />
					</Property>
			]]
		end
		--


		LUSHGRASSLIST =
				[[
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
				]]
			--
			--
				RNGPLANETGRASSLIST =
				[[
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\ROCKS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\ROCKS2.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\ROCKS2.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\ROCKS4.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\ROCKS5.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\CAVEBIOMESPARSETOXIC.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\CAVEBIOMEMID.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\CAVEBIOMEGRASSBUSHES.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\CAVEBIOMEFULL.MBIN" />
					</Property>
					]]..SUBBIOMES_GR..[[
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHINFESTED.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMA.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHROOMB.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\NORMAL.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\RADIOACTIVEALIEN.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\WEIRDHEXA.MBIN" />
						</Property>
						<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\GRASS1.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LAVA.MBIN" />
					</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LONG.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHBIGPROPS.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQ.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATION\SOLARSYSTEM\BIOMES\OBJECTS\GRASS\LUSHHQTENTACLE.MBIN" />
						</Property>
					<Property value="NMSString0x80.xml">
						<Property name="Value" value="METADATA\SIMULATIO